/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.veccy;

import de.malban.Global;
import de.malban.vide.veccy.BackGroundScene;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

public class BackGroundScenePool {
    public static final String DEFAULT_XML_NAME = new String("BackGroundScene.xml");
    private String mFileName = DEFAULT_XML_NAME;
    private HashMap<String, BackGroundScene> mBackGroundScene = new HashMap();
    private HashMap<String, String> mKlassenMap = new HashMap();

    public BackGroundScenePool(String name) {
        this.mFileName = name;
        this.init();
    }

    public BackGroundScenePool() {
        this.init();
    }

    public void setFilename(String n) {
        this.mFileName = n;
    }

    private boolean init() {
        try {
            return this.load();
        }
        catch (Throwable e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Load Error BackGroundScene...", 1);
            return false;
        }
    }

    public boolean load() {
        File f = new File(Global.mBaseDir + this.mFileName);
        if (!f.exists()) {
            return false;
        }
        this.mBackGroundScene = BackGroundScene.getHashMapFromXML(this.mFileName);
        return true;
    }

    public void save() {
        BackGroundScene.saveCollectionAsXML(this.mFileName, this.mBackGroundScene.values());
        this.buildKlassenMap();
    }

    public void remove(BackGroundScene st) {
        this.mBackGroundScene.remove(st.mName);
    }

    public void put(BackGroundScene st) {
        this.mBackGroundScene.remove(st.mName);
        this.mBackGroundScene.put(st.mName, st);
    }

    public void putAsNew(BackGroundScene st) {
        this.mBackGroundScene.put(st.mName, st);
    }

    public BackGroundScene get(String key) {
        return this.mBackGroundScene.get(key);
    }

    public HashMap<String, BackGroundScene> getHashMap() {
        return this.mBackGroundScene;
    }

    private void buildKlassenMap() {
        this.mKlassenMap = new HashMap();
        Set<Map.Entry<String, BackGroundScene>> entries = this.mBackGroundScene.entrySet();
        for (Map.Entry<String, BackGroundScene> entry : entries) {
            BackGroundScene value = entry.getValue();
            this.mKlassenMap.put(value.mClass, value.mClass);
        }
    }

    public HashMap<String, String> getKlassenHashMap() {
        this.buildKlassenMap();
        return this.mKlassenMap;
    }

    public HashMap<String, BackGroundScene> getMapForKlasse(String klasse) {
        HashMap<String, BackGroundScene> ret = new HashMap<String, BackGroundScene>();
        Set<Map.Entry<String, BackGroundScene>> entries = this.mBackGroundScene.entrySet();
        for (Map.Entry<String, BackGroundScene> entry : entries) {
            BackGroundScene value = entry.getValue();
            if (!value.mClass.equalsIgnoreCase(klasse)) continue;
            ret.put(value.mName, value);
        }
        return ret;
    }
}

