/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.veccy;

import de.malban.Global;
import de.malban.vide.veccy.GameData;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

public class GameDataPool {
    public static final String DEFAULT_XML_NAME = new String("GameData.xml");
    private String mFileName = DEFAULT_XML_NAME;
    private HashMap<String, GameData> mGameData = new HashMap();
    private HashMap<String, String> mKlassenMap = new HashMap();

    public GameDataPool(String name) {
        this.mFileName = name;
        this.init();
    }

    public GameDataPool() {
        this.init();
    }

    public void setFilename(String n) {
        this.mFileName = n;
    }

    private boolean init() {
        try {
            return this.load();
        }
        catch (Throwable e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Load Error GameData...", 1);
            return false;
        }
    }

    public boolean load() {
        File f = new File(Global.mBaseDir + this.mFileName);
        if (!f.exists()) {
            return false;
        }
        this.mGameData = GameData.getHashMapFromXML(this.mFileName);
        return true;
    }

    public void save() {
        GameData.saveCollectionAsXML(this.mFileName, this.mGameData.values());
        this.buildKlassenMap();
    }

    public void remove(GameData st) {
        this.mGameData.remove(st.mName);
    }

    public void put(GameData st) {
        this.mGameData.remove(st.mName);
        this.mGameData.put(st.mName, st);
    }

    public void putAsNew(GameData st) {
        this.mGameData.put(st.mName, st);
    }

    public GameData get(String key) {
        return this.mGameData.get(key);
    }

    public HashMap<String, GameData> getHashMap() {
        return this.mGameData;
    }

    private void buildKlassenMap() {
        this.mKlassenMap = new HashMap();
        Set<Map.Entry<String, GameData>> entries = this.mGameData.entrySet();
        for (Map.Entry<String, GameData> entry : entries) {
            GameData value = entry.getValue();
            this.mKlassenMap.put(value.mClass, value.mClass);
        }
    }

    public HashMap<String, String> getKlassenHashMap() {
        this.buildKlassenMap();
        return this.mKlassenMap;
    }

    public HashMap<String, GameData> getMapForKlasse(String klasse) {
        HashMap<String, GameData> ret = new HashMap<String, GameData>();
        Set<Map.Entry<String, GameData>> entries = this.mGameData.entrySet();
        for (Map.Entry<String, GameData> entry : entries) {
            GameData value = entry.getValue();
            if (!value.mClass.equalsIgnoreCase(klasse)) continue;
            ret.put(value.mName, value);
        }
        return ret;
    }
}

