/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.veccy;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.graphics.GFXVectorAnimation;
import de.malban.graphics.GFXVectorList;
import de.malban.gui.dialogs.ShowWarningDialog;
import de.malban.gui.panels.LogPanel;
import de.malban.util.UtilityFiles;
import de.malban.util.UtilityString;
import de.malban.vide.veccy.ActionNewData;
import de.malban.vide.veccy.ActionNewDataPool;
import de.malban.vide.veccy.ActionPanel;
import de.malban.vide.veccy.ActionResultData;
import de.malban.vide.veccy.ActionResultDataPool;
import de.malban.vide.veccy.ActionTriggerData;
import de.malban.vide.veccy.ActionTriggerDataPool;
import de.malban.vide.veccy.BackGroundScene;
import de.malban.vide.veccy.BackGroundScenePool;
import de.malban.vide.veccy.GameData;
import de.malban.vide.veccy.GameDataPool;
import de.malban.vide.veccy.GenerationParameters;
import de.malban.vide.veccy.LevelData;
import de.malban.vide.veccy.LevelDataPool;
import de.malban.vide.veccy.LevelObjectData;
import de.malban.vide.veccy.LevelObjectDataPool;
import de.malban.vide.veccy.SpriteData;
import de.malban.vide.veccy.SpriteDataPool;
import de.malban.vide.veccy.VeccyPanel;
import de.malban.vide.vedi.VediPanel;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JOptionPane;

public class GameGenerator {
    LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    VeccyPanel veccy = null;
    String name = "";
    private GameDataPool mGameDataPool;
    private LevelDataPool mLevelDataPool;
    private ActionNewDataPool mActionDataPool;
    private SpriteDataPool mSpriteDataPool;
    private BackGroundScenePool mBackGroundScenePool;
    private LevelObjectDataPool mLevelObjectDataPool;
    private ActionTriggerDataPool mTriggerPool;
    private ActionResultDataPool mResultPool;
    private GameData mGameData;
    private LevelData mLevelData;
    private ActionNewData mActionData;
    private SpriteData mSpriteData;
    private BackGroundScene mSceneData;
    private LevelObjectData mLevelObjectData;
    private HashMap<String, String> mSceneDone = new HashMap();
    private HashMap<String, String> mSpritesDone = new HashMap();
    private HashMap<String, String> mVectorlistDone = new HashMap();
    private HashMap<String, String> mAFXDone = new HashMap();
    private HashMap<String, String> mtextDone = new HashMap();
    private HashMap<String, String> mSmartlistFunctions = new HashMap();
    private HashMap<String, String> mTriggerForActionDone = new HashMap();
    private HashMap<String, String> mSpriteVersusSpriteDone = new HashMap();
    private boolean smartlistUsed = false;
    private boolean hasAFX = true;
    private boolean has5Font = true;
    private boolean hasStandardFont = true;
    StringBuilder SB_sceneList = new StringBuilder();
    StringBuilder SB_vectorLists = new StringBuilder();
    StringBuilder SB_actionCode = new StringBuilder();
    StringBuilder SB_spriteInitCode = new StringBuilder();
    StringBuilder SB_levelInclude = new StringBuilder();
    StringBuilder SB_additionalFunctions = new StringBuilder();
    StringBuilder SB_AFXSounds = new StringBuilder();
    ArrayList levelList = new ArrayList();
    boolean doGenerateBaseData = true;
    boolean font5TextRoutineDone = false;
    boolean fontStandardTextRoutineDone = false;
    boolean font5MultiTextRoutineDone = false;
    boolean fontStandardMultiTextRoutineDone = false;
    int initUID = 0;
    int printAndMoveUID = 0;
    int randomUID = 0;
    private HashMap<String, String> mTriggerResults = new HashMap();
    int triggerFoundUID = 0;
    int generalDetectionUID = 0;
    int spriteColDetectionUID = 0;
    int continuousNumber = 0;
    int removeUID = 0;
    int removeAllUID_ = 0;
    private HashMap<String, String> knownFunctions = new HashMap();
    int spawnPosUID = 0;
    public static int MAX_NUM_GEN = 16;
    private HashMap<String, String> mSmartListDone = new HashMap();
    int alternateSmartlist = 2;

    public GameGenerator(VeccyPanel vp, String n) {
        this.veccy = vp;
        this.name = n;
        this.mActionDataPool = new ActionNewDataPool();
        this.mSpriteDataPool = new SpriteDataPool();
        this.mBackGroundScenePool = new BackGroundScenePool();
        this.mGameDataPool = new GameDataPool();
        this.mLevelObjectDataPool = new LevelObjectDataPool();
        this.mLevelDataPool = new LevelDataPool();
        this.mTriggerPool = new ActionTriggerDataPool();
        this.mResultPool = new ActionResultDataPool();
    }

    public void generateGame() {
        File file;
        boolean b;
        String gameName = UtilityString.onlyUpperASCIINo(UtilityString.replaceWhiteSpaces(File.separator + this.name, "_"));
        String gamePathString = Global.mainPathPrefix + "projects" + File.separator + gameName;
        String upperTemplatePathString = Global.mainPathPrefix + "template";
        String templatePathString = Global.mainPathPrefix + "template" + File.separator + "game";
        this.SB_levelInclude = new StringBuilder();
        Path gamePath = Paths.get(gamePathString, new String[0]);
        if (!gamePath.toFile().exists() && !(b = (file = gamePath.toAbsolutePath().toFile()).mkdir())) {
            JOptionPane.showMessageDialog(Configuration.getConfiguration().getMainFrame(), "Failed to create directory!\n" + gamePath.toAbsolutePath(), "Directory creation failed", 0);
            return;
        }
        Path templatePath = Paths.get(templatePathString, "GameTemplateProjectProperty.xml");
        Vector<String> searchFor = new Vector<String>();
        Vector<String> replaceWith = new Vector<String>();
        searchFor.add("<Name>GameTemplate</Name>");
        replaceWith.add("<Name>" + gameName + "</Name>");
        UtilityString.replaceToNewFile(new File(templatePath.toString()), new File(gamePathString + File.separator + gameName + "ProjectProperty.xml"), searchFor, replaceWith);
        searchFor.clear();
        replaceWith.clear();
        templatePath = Paths.get(templatePathString, "gameConfig.i");
        UtilityFiles.copyOneFile(templatePath.toString(), gamePathString + File.separator + "gameConfig.i");
        templatePath = Paths.get(templatePathString, "object.asm");
        UtilityFiles.copyOneFile(templatePath.toString(), gamePathString + File.separator + "object.asm");
        templatePath = Paths.get(templatePathString, "ram.i");
        UtilityFiles.copyOneFile(templatePath.toString(), gamePathString + File.separator + "ram.i");
        if (this.hasAFX) {
            templatePath = Paths.get(templatePathString, "ayfxPlayer_channel1.i");
            UtilityFiles.copyOneFile(templatePath.toString(), gamePathString + File.separator + "ayfxPlayer_channel1.i");
            templatePath = Paths.get(templatePathString, "ayfxPlayer_channel2.i");
            UtilityFiles.copyOneFile(templatePath.toString(), gamePathString + File.separator + "ayfxPlayer_channel2.i");
            templatePath = Paths.get(templatePathString, "ayfxPlayer_channel3.i");
            UtilityFiles.copyOneFile(templatePath.toString(), gamePathString + File.separator + "ayfxPlayer_channel3.i");
        }
        if (this.has5Font) {
            templatePath = Paths.get(templatePathString, "font_5.asm");
            UtilityFiles.copyOneFile(templatePath.toString(), gamePathString + File.separator + "font_5.asm");
        }
        if (this.hasStandardFont) {
            templatePath = Paths.get(templatePathString, "font_standard.asm");
            UtilityFiles.copyOneFile(templatePath.toString(), gamePathString + File.separator + "font_standard.asm");
        }
        templatePath = Paths.get(templatePathString, "vectrex.i");
        UtilityFiles.copyOneFile(templatePath.toString(), gamePathString + File.separator + "vectrex.i");
        templatePath = Paths.get(templatePathString, "macro.i");
        UtilityFiles.copyOneFile(templatePath.toString(), gamePathString + File.separator + "macro.i");
        this.generateLevels(gamePathString);
        UtilityFiles.createTextFile(gamePathString + File.separator + "vectorlists.i", this.SB_vectorLists.toString());
        String smText = this.buildSmartlistFunctions(this.mSmartlistFunctions);
        UtilityFiles.createTextFile(gamePathString + File.separator + "genSmartlist.i", smText);
        templatePath = Paths.get(templatePathString, "main.asm");
        searchFor.add("\"GAME_NAME\",");
        replaceWith.add("\"" + gameName + "\",");
        if (this.smartlistUsed) {
            searchFor.add(";                   include  \"vectorlists.i\"");
            replaceWith.add("                    include  \"vectorlists.i\"");
            searchFor.add(";                   include  \"smartlist.asm\"");
            replaceWith.add("                    include  \"genSmartlist.i\"");
        }
        this.SB_levelInclude.append("; ------------------\n");
        this.SB_levelInclude.append("allLevelList:\n");
        for (int i = 0; i < this.levelList.size(); ++i) {
            this.SB_levelInclude.append("\tDW " + this.levelList.get(i).toString() + "\n");
        }
        this.SB_levelInclude.append("\tDW 0\n");
        this.SB_levelInclude.append("; ------------------\n");
        searchFor.add(";LEVEL_INCLUDE_FILES");
        replaceWith.add(this.SB_levelInclude.toString());
        UtilityString.replaceToNewFile(new File(templatePath.toString()), new File(gamePathString + File.separator + "main.asm"), searchFor, replaceWith);
        searchFor.clear();
        replaceWith.clear();
        if (this.veccy != null) {
            this.veccy.startASM(gamePathString + File.separator + "main.asm");
        }
    }

    private void generateLevels(String destPath) {
        Collection<String> collectionKlasse = this.mLevelDataPool.getKlassenHashMap().values();
        Iterator<String> iterKlasse = collectionKlasse.iterator();
        boolean i = false;
        String klasse = this.name + "_Levels";
        Collection<LevelData> colC = this.mLevelDataPool.getMapForKlasse(klasse).values();
        ArrayList<LevelData> list2 = new ArrayList<LevelData>(colC);
        Collections.sort(list2, new Comparator<LevelData>(){

            @Override
            public int compare(LevelData o1, LevelData o2) {
                return o1.mLevelOrder - o2.mLevelOrder;
            }
        });
        Iterator iterC = list2.iterator();
        int no = 1;
        while (iterC.hasNext()) {
            this.mLevelData = (LevelData)iterC.next();
            this.generateOneLevel(destPath, no++);
        }
    }

    public void generateOneLevel(String destPath, int no) {
        String klasse = this.mLevelData.mName;
        Collection<LevelObjectData> colC = this.mLevelObjectDataPool.getMapForKlasse(klasse).values();
        Iterator<LevelObjectData> iterC = colC.iterator();
        int maxSpriteObjects = 0;
        this.SB_sceneList = new StringBuilder();
        this.SB_spriteInitCode = new StringBuilder();
        this.SB_actionCode = new StringBuilder();
        this.SB_additionalFunctions = new StringBuilder();
        this.SB_sceneList.append("SceneList" + no + ":\n");
        ArrayList lateCommer = new ArrayList();
        while (iterC.hasNext()) {
            this.mLevelObjectData = iterC.next();
            this.doGenerateBaseData = true;
            if (this.mLevelObjectData.mType.equals("Sprite")) {
                maxSpriteObjects += this.mLevelObjectData.mMaxLiveObjects;
            }
            this.generateOneLevelObject();
        }
        maxSpriteObjects = 40;
        this.SB_sceneList.append("\tDW       0; 0 terminated list of all scenes");
        if (maxSpriteObjects == 0) {
            maxSpriteObjects = 1;
        }
        int maxObjects = colC.size();
        StringBuilder ram = new StringBuilder();
        ram.append("MAX_OBJECT_L" + no + " = " + maxSpriteObjects + "\n");
        ram.append("\n");
        ram.append("; ---------------------------------- \n");
        ram.append("\n");
        ram.append("\tbss\n");
        ram.append("\n");
        ram.append("\torg LEVEL_RAM\n");
        ram.append("object_list_L" + no + "\tds\tObjectStruct*(" + maxSpriteObjects + ")\n");
        ram.append("object_list_end_L" + no + "\tds\t0\n");
        ram.append("\n");
        ram.append("; ---------------------------------- \n");
        ram.append("\n");
        ram.append("; ---------------------------------- \n");
        ram.append("; --------- FOR DEBUGGING ---------- \n");
        ram.append("; ---------------------------------- \n");
        for (int i = 0; i < maxSpriteObjects; ++i) {
            ram.append("L" + no + "OBJECT_" + i + "_YPOS = " + i + "*ObjectStruct+object_list_L" + no + "+(Y_POS)\n");
            ram.append("L" + no + "OBJECT_" + i + "_XPOS = " + i + "*ObjectStruct+object_list_L" + no + "+(X_POS)\n");
            ram.append("L" + no + "OBJECT_" + i + "_BEHAVIOUR = " + i + "*ObjectStruct+object_list_L" + no + "+(BEHAVIOUR)\n");
            ram.append("L" + no + "OBJECT_" + i + "_NEXT_OBJECT = " + i + "*ObjectStruct+object_list_L" + no + "+(NEXT_OBJECT)\n");
            ram.append("L" + no + "OBJECT_" + i + "_DATA_W = " + i + "*ObjectStruct+object_list_L" + no + "+(C_DATA_W)\n");
            ram.append("L" + no + "OBJECT_" + i + "_COUNTER = " + i + "*ObjectStruct+object_list_L" + no + "+(C_COUNTER)\n");
            ram.append("L" + no + "OBJECT_" + i + "_DATA_B1 = " + i + "*ObjectStruct+object_list_L" + no + "+(C_DATA_B1)\n");
            ram.append("L" + no + "OBJECT_" + i + "_DATA_POS = " + i + "*ObjectStruct+object_list_L" + no + "+(C_DATA_POS)\n");
            ram.append("L" + no + "OBJECT_" + i + "_DATA_B2 = " + i + "*ObjectStruct+object_list_L" + no + "+(C_DATA_B2)\n");
            ram.append("L" + no + "OBJECT_" + i + "_INTENSITY = " + i + "*ObjectStruct+object_list_L" + no + "+(C_INTENSITY)\n");
            ram.append("L" + no + "OBJECT_" + i + "_TIMER = " + i + "*ObjectStruct+object_list_L" + no + "+(C_TIMER)\n");
            ram.append("L" + no + "OBJECT_" + i + "_ANIM_PLACE = " + i + "*ObjectStruct+object_list_L" + no + "+(C_ANIM_PLACE)\n");
            ram.append("L" + no + "OBJECT_" + i + "_FLAG = " + i + "*ObjectStruct+object_list_L" + no + "+(C_FLAG)\n");
            ram.append("L" + no + "OBJECT_" + i + "_Y_DELTA = " + i + "*ObjectStruct+object_list_L" + no + "+(C_Y_DELTA)\n");
            ram.append("L" + no + "OBJECT_" + i + "_X_DELTA = " + i + "*ObjectStruct+object_list_L" + no + "+(C_X_DELTA)\n");
            ram.append("L" + no + "OBJECT_" + i + "_HEIGHT = " + i + "*ObjectStruct+object_list_L" + no + "+(C_HEIGHT)\n");
            ram.append("L" + no + "OBJECT_" + i + "_WIDTH = " + i + "*ObjectStruct+object_list_L" + no + "+(C_WIDTH)\n");
            ram.append("L" + no + "OBJECT_" + i + "_COLLISION_ID = " + i + "*ObjectStruct+object_list_L" + no + "+(C_COLLISION_ID)\n");
        }
        ram.append("; ---------------------------------- \n");
        ram.append("; --------- FOR DEBUGGING END ------ \n");
        ram.append("; ---------------------------------- \n");
        this.levelList.add("initLevel_" + no);
        StringBuilder code2 = new StringBuilder();
        code2.append("\tcode\n");
        code2.append("\n");
        code2.append("; ---------------------------------- \n");
        code2.append("\n");
        code2.append("initLevel_" + no + ":\n");
        code2.append("; first initialize the object list, so it builds a continous list\n");
        code2.append("\tlda      #MAX_OBJECT_L" + no + "\n");
        code2.append("\tldu      #object_list_L" + no + "\n");
        code2.append("\tjsr      initObjects_ua\n");
        code2.append("\tldd      #SceneList" + no + "\n");
        code2.append("\tstd      sceneListForLevel\n");
        if (this.levelHasAnalog()) {
            code2.append("\tlda      #LEVEL_USES_ANALOG_INPUT\n");
        } else {
            code2.append("\tlda      #0\n");
        }
        code2.append("\tsta      currentLevelFlags\n");
        code2.append("\n");
        code2.append((CharSequence)this.SB_spriteInitCode);
        code2.append("\trts\n");
        code2.append("\n");
        code2.append("; ---------------------------------- \n");
        code2.append("\n");
        code2.append((CharSequence)this.SB_actionCode);
        code2.append("\n");
        code2.append("; ---------------------------------- \n");
        code2.append("\n");
        code2.append("; ----------------------------------\n");
        code2.append("; ----- ADDITIONAL FUNCTIONS -------\n");
        code2.append("; -------- SPRITE INIT -------------\n");
        code2.append("; ----------------------------------\n");
        code2.append((CharSequence)this.SB_additionalFunctions);
        code2.append("; ----------------------------------\n");
        code2.append("; ----- ADDITIONAL FUNCTIONS -------\n");
        code2.append("; ------- SPRITE INIT END ----------\n");
        code2.append("; ----------------------------------\n");
        code2.append("\n");
        code2.append("; ---------------------------------- \n");
        code2.append((CharSequence)this.SB_sceneList);
        code2.append("; ---------------------------------- \n");
        code2.append("\n");
        code2.append("; ---------------------------------- \n");
        code2.append((CharSequence)this.SB_AFXSounds);
        code2.append("; ---------------------------------- \n");
        code2.append("\n");
        String pptext = VediPanel.prettyPrint(ram.toString() + code2.toString());
        UtilityFiles.createTextFile(destPath + File.separator + "levelRoutines_" + no + ".i", pptext);
        this.SB_levelInclude.append("\t include \"levelRoutines_" + no + ".i\" \n");
    }

    public void generateOneLevelObject() {
        if (this.mLevelObjectData.mType.equals("Sprite")) {
            this.generateSprite();
        }
        if (this.mLevelObjectData.mType.equals("Background Scene")) {
            this.generateScene();
        }
    }

    SpriteData getSpriteByID(String spriteID) {
        SpriteData spriteData = this.mSpriteDataPool.getMapForKlasse("AllSprites").get(spriteID);
        return spriteData;
    }

    ActionNewData getPlayer1() {
        Collection<LevelObjectData> colCo = this.mLevelObjectDataPool.getMapForKlasse(this.mLevelData.mName).values();
        for (LevelObjectData levelObjectData : colCo) {
            SpriteData spriteData;
            if (!levelObjectData.mType.equals("Sprite") || (spriteData = this.mSpriteDataPool.getMapForKlasse("AllSprites").get(levelObjectData.mSpriteID)) == null) continue;
            Collection<ActionNewData> colCa = this.mActionDataPool.getMapForKlasse(spriteData.mName + "_Actions").values();
            Iterator<ActionNewData> iterCa = colCa.iterator();
            ActionNewData actionData = this.getDefaultAction(spriteData);
            if (actionData == null || !actionData.mbehaviour.equals("player 1 controlled")) continue;
            return actionData;
        }
        return null;
    }

    SpriteData getPlayer1Sprite() {
        Collection<LevelObjectData> colCo = this.mLevelObjectDataPool.getMapForKlasse(this.mLevelData.mName).values();
        for (LevelObjectData levelObjectData : colCo) {
            SpriteData spriteData;
            if (!levelObjectData.mType.equals("Sprite") || (spriteData = this.mSpriteDataPool.getMapForKlasse("AllSprites").get(levelObjectData.mSpriteID)) == null) continue;
            Collection<ActionNewData> colCa = this.mActionDataPool.getMapForKlasse(spriteData.mName + "_Actions").values();
            Iterator<ActionNewData> iterCa = colCa.iterator();
            ActionNewData actionData = this.getDefaultAction(spriteData);
            if (actionData == null || !actionData.mbehaviour.equals("player 1 controlled")) continue;
            return spriteData;
        }
        return null;
    }

    ActionNewData getPlayer2() {
        Collection<LevelObjectData> colCo = this.mLevelObjectDataPool.getMapForKlasse(this.mLevelData.mName).values();
        for (LevelObjectData levelObjectData : colCo) {
            SpriteData spriteData;
            if (!levelObjectData.mType.equals("Sprite") || (spriteData = this.mSpriteDataPool.getMapForKlasse("AllSprites").get(levelObjectData.mSpriteID)) == null) continue;
            Collection<ActionNewData> colCa = this.mActionDataPool.getMapForKlasse(spriteData.mName + "_Actions").values();
            Iterator<ActionNewData> iterCa = colCa.iterator();
            ActionNewData actionData = this.getDefaultAction(spriteData);
            if (actionData == null || !actionData.mbehaviour.equals("player 2 controlled")) continue;
            return actionData;
        }
        return null;
    }

    SpriteData getPlayer2Sprite() {
        Collection<LevelObjectData> colCo = this.mLevelObjectDataPool.getMapForKlasse(this.mLevelData.mName).values();
        for (LevelObjectData levelObjectData : colCo) {
            SpriteData spriteData;
            if (!levelObjectData.mType.equals("Sprite") || (spriteData = this.mSpriteDataPool.getMapForKlasse("AllSprites").get(levelObjectData.mSpriteID)) == null) continue;
            Collection<ActionNewData> colCa = this.mActionDataPool.getMapForKlasse(spriteData.mName + "_Actions").values();
            Iterator<ActionNewData> iterCa = colCa.iterator();
            ActionNewData actionData = this.getDefaultAction(spriteData);
            if (actionData == null || !actionData.mbehaviour.equals("player 2 controlled")) continue;
            return spriteData;
        }
        return null;
    }

    public void generateScene() {
        this.doGenerateBaseData = !this.mSceneDone.containsKey(this.mLevelObjectData.mScene);
        String klasse = "AllScenes";
        this.mSceneData = this.mBackGroundScenePool.getMapForKlasse(klasse).get(this.mLevelObjectData.mScene);
        if (this.doGenerateBaseData) {
            this.generateSceneVectorlist();
        }
        this.SB_sceneList.append("\tDW        " + this.mSceneData.mName + "\n");
        if (this.doGenerateBaseData) {
            this.mSceneDone.put(this.mLevelObjectData.mScene, this.mLevelObjectData.mScene);
        }
    }

    void generateSceneVectorlist() {
        if (this.mVectorlistDone.containsKey(this.mSceneData.msceneFile)) {
            return;
        }
        GFXVectorAnimation animation = new GFXVectorAnimation();
        boolean ok = animation.loadFromXML(this.mSceneData.msceneFile);
        if (!ok) {
            this.log.addLog("Error loading scene: " + this.mSceneData.msceneFile, LogPanel.ERROR);
            return;
        }
        this.smartlistUsed = true;
        GenerationParameters p = new GenerationParameters();
        p.compileForVB = true;
        p.rts2 = false;
        p.paraName = this.mSceneData.mName;
        p.doNoPositionMove = false;
        this.veccy.setParameters(p);
        this.SB_vectorLists.append(";\n");
        this.SB_vectorLists.append(";Vectorlists for scene: " + this.mSceneData.mName + "\n");
        this.SB_vectorLists.append(";\n");
        this.SB_vectorLists.append(p.paraName + ":\n");
        this.SB_vectorLists.append(this.veccy.buildSmartScenarioListG(false, animation, this.mSmartlistFunctions));
        this.mVectorlistDone.put(this.mSceneData.msceneFile, p.paraName);
    }

    public void generateSprite() {
        String klasse = "AllSprites";
        this.mSpriteData = this.mSpriteDataPool.getMapForKlasse(klasse).get(this.mLevelObjectData.mSpriteID);
        if (this.mSpriteData == null) {
            return;
        }
        this.doGenerateBaseData = !this.mSpritesDone.containsKey(this.mSpriteData.mName);
        boolean i = false;
        klasse = this.mSpriteData.mName + "_Actions";
        Collection<ActionNewData> colC = this.mActionDataPool.getMapForKlasse(klasse).values();
        for (ActionNewData this.mActionData : colC) {
            this.generateAction();
        }
        if (this.doGenerateBaseData) {
            this.mSpritesDone.put(this.mSpriteData.mName, this.mSpriteData.mName);
        }
    }

    public void generateAction() {
        if (this.doGenerateBaseData) {
            this.generateActionVectorlist();
        }
        this.mTriggerForActionDone = new HashMap();
        this.generateActionCode();
    }

    void generateActionCode() {
        String afxName;
        String v;
        GFXVectorList boundingList;
        ++this.initUID;
        String spriteName = this.mSpriteData.mName;
        String actionName = this.mSpriteData.mName + this.mActionData.mName + "Behaviour";
        String defaultName = this.mSpriteData.mName + "DefaultBehaviour";
        String defaultActionName = this.mSpriteData.mDefaultActionID;
        String vectorAnimName = this.mSpriteData.mName + "_" + this.mActionData.mName;
        boolean isTextSprite = this.isText(this.mSpriteData);
        boolean isTriggerOnly = this.mActionData.mbehaviour.equals("trigger only");
        int animationCount = 0;
        GFXVectorAnimation animation = new GFXVectorAnimation();
        if (animation.loadFromXML(this.mActionData.manimationFile)) {
            animationCount = animation.size();
        }
        if (this.doGenerateBaseData) {
            this.SB_actionCode.append("; ********************************** \n");
            this.SB_actionCode.append("; ************ Code for ************\n");
            this.SB_actionCode.append("; *** Sprite: " + this.mSpriteData.mName + " \n");
            this.SB_actionCode.append("; *** Action: " + this.mActionData.mName + " \n");
            this.SB_actionCode.append("; ********************************** \n");
        }
        if (defaultActionName.equals(this.mActionData.mName) && this.mLevelObjectData.mLiveOnInit) {
            this.SB_spriteInitCode.append("; --- init sprite: " + this.mSpriteData.mName + "\n");
            if (this.mLevelObjectData.myPos.contains(",")) {
                String[] xParts;
                String[] yParts = UtilityString.cleanCSV(this.mLevelObjectData.myPos);
                if (yParts.length != (xParts = UtilityString.cleanCSV(this.mLevelObjectData.mxPos)).length) {
                    ShowWarningDialog.showWarningDialog("Coordinate size mismatch!", "Number of Y and X coordinates do not match! (" + this.mSpriteData.mName + ")");
                }
                this.SB_spriteInitCode.append("\tbra      " + this.mLevelObjectData.mSpriteID + "InlinePosDataDone" + this.initUID + "\n");
                this.SB_spriteInitCode.append(this.mLevelObjectData.mSpriteID + "InlinePosData" + this.initUID + ":\n");
                for (int i = 0; i < yParts.length; ++i) {
                    int y = UtilityString.Int0(yParts[i]);
                    int x = 0;
                    if (xParts.length > i) {
                        x = UtilityString.Int0(xParts[i]);
                    }
                    this.SB_spriteInitCode.append("\tDB      " + String.format("$%02X", y & 0xFF) + ", " + String.format("$%02X", x & 0xFF) + "\n");
                }
                this.SB_spriteInitCode.append(this.mLevelObjectData.mSpriteID + "InlinePosDataDone" + this.initUID + ":\n");
                this.SB_spriteInitCode.append("\tlda      #" + (yParts.length - 1) + " ; \n");
                this.SB_spriteInitCode.append("\tsta      temp8bit ; \n");
                this.SB_spriteInitCode.append(this.mLevelObjectData.mSpriteID + "Init" + this.initUID + ":\n");
                this.SB_spriteInitCode.append("\tbmi      " + this.mLevelObjectData.mSpriteID + "Init" + this.initUID + "Done\n");
                this.SB_spriteInitCode.append("\tjsr      newObject\t; return pointer to U \n");
                this.SB_spriteInitCode.append(" ; no overflow testing is done during init \n");
                this.SB_spriteInitCode.append("\tldx      #" + this.mLevelObjectData.mSpriteID + "InlinePosData" + this.initUID + "\n");
                this.SB_spriteInitCode.append("\tlda      temp8bit\n");
                this.SB_spriteInitCode.append("\tasla\n");
                this.SB_spriteInitCode.append("\tldd      a,x\n");
                this.SB_spriteInitCode.append("\tstd      Y_POS,u\n");
                this.SB_spriteInitCode.append("\tldx      #" + this.mLevelObjectData.mSpriteID + "DefaultBehaviour ; sprites always start with their default behaviour\n");
                String functionName = this.functionalizeNewAction(this.mSpriteData, this.mActionData, "u", false);
                this.SB_spriteInitCode.append("\tjsr      " + functionName + "\n");
                this.SB_spriteInitCode.append("\tdec      temp8bit\n");
                this.SB_spriteInitCode.append("\tbra      " + this.mLevelObjectData.mSpriteID + "Init" + this.initUID + "\n");
                this.SB_spriteInitCode.append(this.mLevelObjectData.mSpriteID + "Init" + this.initUID + "Done:\n");
            } else {
                String pos = String.format("$%04X", (UtilityString.Int0(this.mLevelObjectData.myPos) * 256 & 0xFF00) + (UtilityString.Int0(this.mLevelObjectData.mxPos) & 0xFF));
                this.SB_spriteInitCode.append("\tjsr      newObject\t; return pointer to U \n");
                this.SB_spriteInitCode.append(" ; no overflow testing is done during init \n");
                if (this.mActionData.mbehaviour.equals("player 1 controlled")) {
                    this.SB_spriteInitCode.append("\tstu      main1Pointer ; store player one pointer for future use\n");
                }
                if (this.mActionData.mbehaviour.equals("player 2 controlled")) {
                    this.SB_spriteInitCode.append("\tstu      main2Pointer ; store player two pointer for future use\n");
                }
                this.SB_spriteInitCode.append("\tldx      #" + this.mLevelObjectData.mSpriteID + "DefaultBehaviour ; sprites always start with their default behaviour\n");
                this.SB_spriteInitCode.append("\tldd      #" + pos + " ; setup with position \n");
                this.SB_spriteInitCode.append("\tstd      Y_POS,u\n");
                String functionName = this.functionalizeNewAction(this.mSpriteData, this.mActionData, "u", false);
                this.SB_spriteInitCode.append("\tjsr      " + functionName + "\n");
                for (int eventCount = 0; eventCount < this.mActionData.meventUID.size(); ++eventCount) {
                    ActionTriggerData trigger = this.getTriggerByUID(this.mActionData, this.mActionData.meventUID.elementAt(eventCount));
                    ActionResultData result = this.getResultByUID(this.mActionData, this.mActionData.meventUID.elementAt(eventCount));
                    if (!trigger.mtriggerByCause.elementAt(0).equals("on creation")) continue;
                    this.SB_spriteInitCode.append("\ttfr      u,y ; save u = created new sprite register usage in 'child'\n");
                    this.SB_spriteInitCode.append("; ---- init child (follower) start ----\n");
                    this.SB_spriteInitCode.append("\tjsr      newObject\t; return pointer to U \n");
                    this.SB_spriteInitCode.append(" ; no overflow testing is done during init \n");
                    ActionNewData saveAction = this.mActionData;
                    SpriteData saveSprite = this.mSpriteData;
                    this.mSpriteData = this.getSpriteByID(result.mresultSpriteID.elementAt(0));
                    this.mActionData = this.getActionByID(this.mSpriteData, this.mSpriteData.mDefaultActionID);
                    this.SB_spriteInitCode.append("\tldx      #" + this.mSpriteData.mName + "DefaultBehaviour ; sprites always start with their default behaviour\n");
                    String functionName2 = this.functionalizeNewAction(this.mSpriteData, this.mActionData, "u", false);
                    this.SB_spriteInitCode.append("\tjsr      " + functionName2 + "\n");
                    if (this.mActionData.mbehaviour.equals("follow sprite")) {
                        this.SB_spriteInitCode.append("\tsty      C_DATA_W,u\n");
                    }
                    this.mActionData = saveAction;
                    this.mSpriteData = saveSprite;
                    this.SB_spriteInitCode.append("; ---- init child (follower) end ----\n");
                }
            }
        }
        if (!this.doGenerateBaseData) {
            return;
        }
        this.SB_actionCode.append("; ----------------------------------\n");
        this.SB_actionCode.append("; ------ BEHAVIOUR CODE START ------\n");
        this.SB_actionCode.append("; ----------------------------------\n");
        if (isTextSprite) {
            this.SB_actionCode.append("; unique ID of the sprite this behaviour belongs to\n");
            this.SB_actionCode.append("; all objects need this, so remove all does not produce bad results!\n");
            this.SB_actionCode.append("\tDB      0 \n");
            this.SB_actionCode.append(defaultName + ":\n");
        } else {
            this.SB_actionCode.append("; unique ID of the sprite this behaviour belongs to\n");
            this.SB_actionCode.append("; we need this for reference to know what collided with what\n");
            this.SB_actionCode.append("; and I don't want to waste a byte or two in the precious RAM list of objects\n");
            this.SB_actionCode.append("; ... so each behaviour has the ID of the sprite it belongs to\n");
            this.SB_actionCode.append("\tDB      " + this.mSpriteData.mspriteUID + " \n");
            if (this.mSpriteData.mDefaultActionID.equals(this.mActionData.mName)) {
                this.SB_actionCode.append(defaultName + ":\n");
            }
            this.SB_actionCode.append(actionName + ":\n");
        }
        if (!isTextSprite && !isTriggerOnly) {
            this.addAnimationCode(animationCount);
        }
        boolean isPlayer1 = this.mActionData.mbehaviour.equals("player 1 controlled");
        boolean isPlayer2 = this.mActionData.mbehaviour.equals("player 2 controlled");
        if (this.mActionData.mbehaviour.equals("patrol")) {
            this.addEnemyPatrolCode();
        }
        this.addMovementCode();
        if (this.isPlayer1(this.mSpriteData)) {
            this.addPlayerVersusPlayerCollision();
        }
        if (!(this.isPlayer(this.mSpriteData) || isTriggerOnly || isTextSprite)) {
            this.addPlayerCollisionDetection();
            this.addNonPlayerCollisionDetection();
        }
        if (this.isPlayer(this.mSpriteData)) {
            this.addPlayerActionCode(true);
        } else if (this.mActionData.mbehaviour.equals("trigger only")) {
            this.addPlayerActionCode(false);
        }
        if (!(isTextSprite || isTriggerOnly || this.isPlayer(this.mSpriteData))) {
            this.addSpriteActionCode();
        }
        this.addSpriteTriggerTimerCode();
        this.addSpriteTriggerLongTimerCode();
        this.addSpriteTriggerPostionCode();
        this.SB_actionCode.append(this.mSpriteData.mName + this.mActionData.mName + "BehaviourTriggerDone:\n");
        if (isTextSprite) {
            this.printAndMoveText();
        } else if (isTriggerOnly) {
            this.SB_actionCode.append("\tlds      S_NEXT_OBJECT,s ; load stack with the next object data\n");
            this.SB_actionCode.append("\tpuls     d,pc ; and jump to the next object in the object list\n");
        } else {
            if (this.mActionData.mintensity.length() != 0) {
                int intensity = UtilityString.IntX(this.mActionData.mintensity, 300);
                if (intensity != 300) {
                    this.SB_actionCode.append("\tlda      currentLevelFlags ; level flags\n");
                    this.SB_actionCode.append("\tora      #INTENSITY_IS_DEFAULT ; mark intensity as non standard\n");
                    this.SB_actionCode.append("\tsta      currentLevelFlags ; level flags\n");
                    this.SB_actionCode.append("\tldb      INTENSITY,s ; load the current Intensity\n");
                } else if (this.mActionData.mintensity.startsWith("=")) {
                    this.SB_actionCode.append("\tlda      currentLevelFlags ; level flags\n");
                    this.SB_actionCode.append("\tora      #INTENSITY_IS_DEFAULT ; mark intensity as non standard\n");
                    this.SB_actionCode.append("\tsta      currentLevelFlags ; level flags\n");
                    this.SB_actionCode.append("\tldb      " + this.mActionData.mintensity.substring(1) + " ; load the current Intensity from variable\n");
                } else {
                    ShowWarningDialog.showWarningDialog("Strange intensity settings", "I don't know how to handle the intensity. (Sprite: " + this.mSpriteData.mName + " action: " + this.mActionData.mName + ")");
                }
                this.SB_actionCode.append("\tlds      S_NEXT_OBJECT,s ; load stack with the next object data\n");
            } else {
                this.SB_actionCode.append("\tlds      S_NEXT_OBJECT,s ; load stack with the next object data\n");
                if (this.levelUsesIntensityInSprites()) {
                    this.SB_actionCode.append("\tldb      #$ff ; flag default to no intensity change\n");
                    this.SB_actionCode.append("\tlda      currentLevelFlags ; level flags\n");
                    this.SB_actionCode.append("\tanda      #INTENSITY_IS_DEFAULT ; is mark intensity non standard?\n");
                    this.SB_actionCode.append("\tbeq      noIntensityChange" + this.initUID + "\n");
                    this.SB_actionCode.append("\tlda      currentLevelFlags ; mark level as standard intensity\n");
                    this.SB_actionCode.append("\tanda     #(255-INTENSITY_IS_DEFAULT) ; set flag to default intensity\n");
                    this.SB_actionCode.append("\tsta      currentLevelFlags ; store level flags\n");
                    this.SB_actionCode.append("\tldb      #$5f ; load default intensity\n");
                    this.SB_actionCode.append("noIntensityChange" + this.initUID + ":\n");
                }
            }
            this.SB_actionCode.append("\tldu      vListTemp ; load the current to be displayed smartlist\n");
            this.SB_actionCode.append("\tMY_MOVE_TO_A_END ; if there is time left for moving... iddle away\n");
            if (this.mActionData.mintensity.length() != 0) {
                this.SB_actionCode.append("\t_INTENSITY_B ; \n");
            } else if (this.levelUsesIntensityInSprites()) {
                this.SB_actionCode.append("\ttstb      ; if b negative we have default intensity\n");
                this.SB_actionCode.append("\tbmi      noIntensityChange2" + this.initUID + "\n");
                this.SB_actionCode.append("\t_INTENSITY_B ; \n");
                this.SB_actionCode.append("noIntensityChange2" + this.initUID + ":\n");
            }
            this.SB_actionCode.append("\tldx      #(%11111110*256)+$98 ; \n");
            this.SB_actionCode.append("\tldy      #(%00001111*256)+$98 ; \n");
            this.SB_actionCode.append(" ; and jump to the smartlist drawing \n");
            this.SB_actionCode.append("\tpulu     d,pc ; -> which in turn jumps to the next object in the list when finished\n");
        }
        this.SB_actionCode.append("; ----------------------------------\n");
        this.SB_actionCode.append("; ------ BEHAVIOUR CODE END --------\n");
        this.SB_actionCode.append("; ----------------------------------\n");
        if ((this.mActionData.mbehaviour.equals("player 1 controlled") || this.mActionData.mbehaviour.equals("player 2 controlled")) && (boundingList = ActionPanel.computeBoundingBoxStatic(this.mActionData)) != null) {
            int dyi = ((int)boundingList.get((int)0).start.y() / ActionPanel.BLOW - (int)boundingList.get((int)2).start.y() / ActionPanel.BLOW) / 2;
            int dxi = ((int)boundingList.get((int)0).start.x() / ActionPanel.BLOW - (int)boundingList.get((int)2).start.x() / ActionPanel.BLOW) / 2;
            byte dx = (byte)(dxi & 0xFF);
            byte dy = (byte)(dyi & 0xFF);
            String xd = String.format("$%02X", dx);
            String yd = String.format("$%02X", dy);
            this.SB_actionCode.append(this.mSpriteData.mName + this.mActionData.mName + "DeltaData:\n");
            this.SB_actionCode.append("; bounding box delta data for current vectorlist (action)\n");
            this.SB_actionCode.append("; the bounding box data is calculated using the first\n");
            this.SB_actionCode.append("; animation phase of the vectorlist animation data\n");
            this.SB_actionCode.append("; \n");
            this.SB_actionCode.append("; delta data of enemies (for player<->sprite collision)\n");
            this.SB_actionCode.append("; is not kept in DB statements, \n");
            this.SB_actionCode.append("; but are handled in code immediately, since the values\n");
            this.SB_actionCode.append("; are unique to the sprite->action\n");
            this.SB_actionCode.append("\tDB      " + yd + ", " + xd + "\t; yDelta, xDelta - assuming sprite is midway\n");
            this.SB_actionCode.append("; ---------------------------------- \n");
        }
        if (this.mActionData.mtext != null && this.mActionData.mtext.length() != 0 && (v = this.mtextDone.get(this.mActionData.mtext)) == null) {
            String[] t = UtilityString.cleanSplitNL(this.mActionData.mtext);
            if (t.length <= 1) {
                this.SB_actionCode.append(this.mSpriteData.mName + this.mActionData.mName + "Text:\n");
                this.SB_actionCode.append("\tDB      \"" + this.mActionData.mtext + "\", 0x80\n");
                this.SB_actionCode.append("; ---------------------------------- \n");
                this.mtextDone.put(this.mActionData.mtext, this.mSpriteData.mName + this.mActionData.mName + "Text");
            } else {
                int i;
                this.SB_actionCode.append(this.mSpriteData.mName + this.mActionData.mName + "MultiText:\n");
                for (i = 0; i < t.length; ++i) {
                    this.SB_actionCode.append("\t DW " + this.mSpriteData.mName + this.mActionData.mName + "MultiText" + i + "\n");
                }
                this.SB_actionCode.append("\t DW 0\n");
                for (i = 0; i < t.length; ++i) {
                    this.SB_actionCode.append(this.mSpriteData.mName + this.mActionData.mName + "MultiText" + i + ":\n");
                    this.SB_actionCode.append("\tDB      \"" + t[i] + "\", 0x80\n");
                }
                this.SB_actionCode.append("; ---------------------------------- \n");
            }
        }
        if ((afxName = this.mActionData.msoundFile) == null) {
            return;
        }
        if (afxName.length() == 0) {
            return;
        }
        if (this.mAFXDone.get(afxName) != null) {
            return;
        }
        this.SB_AFXSounds.append(this.genAYFX(afxName));
        this.mAFXDone.put(afxName, afxName);
    }

    void addMovementCode() {
        String actionName = this.mSpriteData.mName + this.mActionData.mName + "Behaviour";
        if (!this.mActionData.mbehaviour.equals("fixed position")) {
            this.SB_actionCode.append("; ----------------------------------\n");
            this.SB_actionCode.append("; ------ MOVEMENT CODE START -------\n");
            this.SB_actionCode.append("; ----------------------------------\n");
            if (this.mActionData.mbehaviour.equals("follow sprite")) {
                this.SB_actionCode.append("\tldx      DATA_W,s ; position pointer  \n");
                this.SB_actionCode.append("\tldd      ,x ; load position from parenet  \n");
                this.SB_actionCode.append("\tadda     Y_DELTA,s ; apply our offset Y \n");
                this.SB_actionCode.append("\taddb     X_DELTA,s ; apply our offset X \n");
                this.SB_actionCode.append("\tstD      S_Y_POS,s ; and store the new position\n");
            } else {
                int restriction;
                String restrictionS;
                boolean _isPlayer1 = this.mActionData.mbehaviour.equals("player 1 controlled");
                boolean _isPlayer2 = this.mActionData.mbehaviour.equals("player 2 controlled");
                if (this.mActionData.mchangeWhileActiveY.startsWith("ay")) {
                    if (_isPlayer1) {
                        this.SB_actionCode.append("\tlda      Vec_Joy_1_Y ; load current Y \n");
                    } else if (_isPlayer2) {
                        this.SB_actionCode.append("\tlda      Vec_Joy_2_Y ; load current Y \n");
                    }
                    restrictionS = UtilityString.replace(this.mActionData.mchangeWhileActiveY, "ay", "");
                    restriction = UtilityString.Int0(restrictionS);
                    if (restriction > 0) {
                        this.SB_actionCode.append("\tcmpa    #" + restriction + "; ensure that analog value is within specs\n");
                        this.SB_actionCode.append("\tblt     " + actionName + "AnalogYSmallerMax ; ensure that analog value is within specs\n");
                        this.SB_actionCode.append("\tlda     #" + restriction + "; load with max\n");
                        this.SB_actionCode.append("\tbra     " + actionName + "AnalogYCheckDone ; ensure that analog value is within specs\n");
                        this.SB_actionCode.append(actionName + "AnalogYSmallerMax:\n");
                        this.SB_actionCode.append("\tcmpa    #-" + restriction + "; ensure that analog value is within specs\n");
                        this.SB_actionCode.append("\tbgt     " + actionName + "AnalogYCheckDone ; ensure that analog value is within specs\n");
                        this.SB_actionCode.append("\tlda     #-" + restriction + "; load with min\n");
                        this.SB_actionCode.append(actionName + "AnalogYCheckDone:\n");
                    }
                } else {
                    this.SB_actionCode.append("\tlda      Y_DELTA,s ; load current Y speed\n");
                    this.SB_actionCode.append("\tadda     S_Y_POS,s ; add position \n");
                }
                this.SB_actionCode.append("\tsta      S_Y_POS,s ; store to the Y position\n");
                if (this.mActionData.mchangeWhileActiveX.startsWith("ax")) {
                    if (_isPlayer1) {
                        this.SB_actionCode.append("\tlda      Vec_Joy_1_X ; load current X \n");
                    } else if (_isPlayer2) {
                        this.SB_actionCode.append("\tlda      Vec_Joy_2_X ; load current X \n");
                    }
                    restrictionS = UtilityString.replace(this.mActionData.mchangeWhileActiveX, "ax", "");
                    restriction = UtilityString.Int0(restrictionS);
                    if (restriction > 0) {
                        this.SB_actionCode.append("\tcmpa    #" + restriction + "; ensure that analog value is within specs\n");
                        this.SB_actionCode.append("\tblt     " + actionName + "AnalogXSmallerMax ; ensure that analog value is within specs\n");
                        this.SB_actionCode.append("\tlda     #" + restriction + "; load with max\n");
                        this.SB_actionCode.append("\tbra     " + actionName + "AnalogXCheckDone ; ensure that analog value is within specs\n");
                        this.SB_actionCode.append(actionName + "AnalogXSmallerMax:\n");
                        this.SB_actionCode.append("\tcmpa    #-" + restriction + "; ensure that analog value is within specs\n");
                        this.SB_actionCode.append("\tbgt     " + actionName + "AnalogXCheckDone ; ensure that analog value is within specs\n");
                        this.SB_actionCode.append("\tlda     #-" + restriction + "; load with min\n");
                        this.SB_actionCode.append(actionName + "AnalogXCheckDone:\n");
                    }
                } else {
                    this.SB_actionCode.append("\tlda      X_DELTA,s ; load current X speed\n");
                    this.SB_actionCode.append("\tadda     S_X_POS,s ; add position \n");
                }
                this.SB_actionCode.append("\tsta      S_X_POS,s ; store to the X position\n");
            }
            this.SB_actionCode.append("; ----------------------------------\n");
            this.SB_actionCode.append("; ------ MOVEMENT CODE END ---------\n");
            this.SB_actionCode.append("; ----------------------------------\n");
        }
    }

    void addAnimationCode(int animationCount) {
        String actionName = this.mSpriteData.mName + this.mActionData.mName + "Behaviour";
        this.SB_actionCode.append("; in S pointer to object structure ()\n");
        this.SB_actionCode.append("\tMY_MOVE_TO_D_START\n");
        this.SB_actionCode.append("\tldb      #OBJECT_SCALE\n");
        this.SB_actionCode.append("\tstb      VIA_t1_cnt_lo\n");
        if (animationCount > 1) {
            this.SB_actionCode.append("; ----------------------------------\n");
            this.SB_actionCode.append("; ------ ANIMATION CODE START ------\n");
            this.SB_actionCode.append("; ----------------------------------\n");
            this.SB_actionCode.append("\tlda      animCountdown ; load global countdown\n");
            this.SB_actionCode.append("\tbne      " + actionName + "NoAnimChange ; only change animation when 0\n");
            this.SB_actionCode.append("\tlda      ANIM_PLACE,s ; increase current animation phase\n");
            this.SB_actionCode.append("\tinca\n");
            this.SB_actionCode.append("\tsta      ANIM_PLACE,s\n");
            this.SB_actionCode.append("\tcmpa     #" + animationCount + " ; but if to high -> reset to 0\n");
            this.SB_actionCode.append("\tbne      " + actionName + "NoAnimChange_A_Loaded\n");
            this.SB_actionCode.append("\tclr      ANIM_PLACE,s\n");
        }
        this.SB_actionCode.append(actionName + "NoAnimChange:\n");
        if (this.mVectorlistDone.get(this.mActionData.manimationFile) == null) {
            ShowWarningDialog.showWarningDialog("Vectorlist null!", "Did you not supply a vector animation list? (" + this.mSpriteData.mName + ", action: " + this.mActionData.mName + ")");
        }
        if (animationCount > 1) {
            this.SB_actionCode.append("\tlda       ANIM_PLACE,s ; load current animation phase \n");
            this.SB_actionCode.append(actionName + "NoAnimChange_A_Loaded:\n");
            this.SB_actionCode.append("\tldx       #" + this.mVectorlistDone.get(this.mActionData.manimationFile) + " ; load vectoranimation base address\n");
            this.SB_actionCode.append("\tlsla ; phase count double -> because it is a word pointer (2 bytes)\n");
            this.SB_actionCode.append("\tldu       a,x ; and load the actual vectorlist address to be displayed\n");
            this.SB_actionCode.append("; ----------------------------------\n");
            this.SB_actionCode.append("; ------ ANIMATION CODE END --------\n");
            this.SB_actionCode.append("; ----------------------------------\n");
        } else {
            this.SB_actionCode.append(actionName + "NoAnimChange_A_Loaded:\n");
            this.SB_actionCode.append("\tldx       #" + this.mVectorlistDone.get(this.mActionData.manimationFile) + " ; load pointer to vectorlist\n");
            this.SB_actionCode.append("\tldu       ,x ; and load the actual vectorlist address to be displayed\n");
        }
        this.SB_actionCode.append("\tstu       vListTemp ; save the for later usage\n");
    }

    /*
     * Enabled aggressive block sorting
     */
    void printAndMoveText() {
        String[] t = UtilityString.cleanSplitNL(this.mActionData.mtext);
        if (t.length <= 1) {
            if (this.mActionData.mtextType.equals("5 font")) {
                if (this.font5TextRoutineDone) {
                    this.SB_actionCode.append("\tjmp     Font5TextBehaviour\n");
                    return;
                }
                this.SB_actionCode.append("Font5TextBehaviour:\n");
            }
            if (this.mActionData.mtextType.equals("standard font")) {
                if (this.fontStandardTextRoutineDone) {
                    this.SB_actionCode.append("\tjmp     FontStandardTextBehaviour\n");
                    return;
                }
                this.SB_actionCode.append("FontStandardTextBehaviour:\n");
            }
        } else {
            if (this.mActionData.mtextType.equals("5 font")) {
                if (this.font5MultiTextRoutineDone) {
                    this.SB_actionCode.append("\tjmp     Font5MultiTextBehaviour\n");
                    return;
                }
                this.SB_actionCode.append("Font5MultiTextBehaviour:\n");
            }
            if (this.mActionData.mtextType.equals("standard font")) {
                if (this.fontStandardMultiTextRoutineDone) {
                    this.SB_actionCode.append("\tjmp     FontStandardMultiTextBehaviour\n");
                    return;
                }
                this.SB_actionCode.append("FontStandardMultiTextBehaviour:\n");
            }
        }
        ++this.printAndMoveUID;
        boolean buildNow = false;
        String stringRoutine = "";
        if (this.mActionData.mtextType.equals("standard font")) {
            if (t.length <= 1) {
                if (!this.fontStandardTextRoutineDone) {
                    stringRoutine = "\tjsr      sync_Std_Print_Str_d ; print the string at D \n";
                    this.fontStandardTextRoutineDone = true;
                    buildNow = true;
                }
            } else if (!this.fontStandardMultiTextRoutineDone) {
                stringRoutine = "\tjsr      sync_Std_Print_Str_d ; print the string at D \n";
                this.fontStandardMultiTextRoutineDone = true;
                buildNow = true;
            }
        }
        if (this.mActionData.mtextType.equals("5 font")) {
            if (t.length <= 1) {
                if (!this.font5TextRoutineDone) {
                    stringRoutine = "\tjsr      sync_Print_Str_d ; print the string at D \n";
                    this.font5TextRoutineDone = true;
                    buildNow = true;
                }
            } else if (!this.font5MultiTextRoutineDone) {
                stringRoutine = "\tjsr      sync_Print_Str_d ; print the string at D \n";
                this.font5MultiTextRoutineDone = true;
                buildNow = true;
            }
        }
        if (buildNow) {
            this.SB_actionCode.append("\tldb      INTENSITY,s ; load the current Intensity\n");
            this.SB_actionCode.append("\tbmi      noIntensityChange_PaM_1" + this.printAndMoveUID + "\n");
            this.SB_actionCode.append("\t_INTENSITY_B ; \n");
            this.SB_actionCode.append("\tbra      noIntensityChange_PaM_2" + this.printAndMoveUID + "\n");
            this.SB_actionCode.append("noIntensityChange_PaM_1" + this.printAndMoveUID + ":\n");
            if (this.levelUsesIntensityInSprites()) {
                this.SB_actionCode.append("\tlda      currentLevelFlags ; level flags\n");
                this.SB_actionCode.append("\tanda      #INTENSITY_IS_DEFAULT ; is mark intensity non standard?\n");
                this.SB_actionCode.append("\tbeq       noIntensityChange_PaM_2" + this.printAndMoveUID + ":\n");
                this.SB_actionCode.append("\tlda      currentLevelFlags ; mark level as standard intensity\n");
                this.SB_actionCode.append("\tanda     #(255-INTENSITY_IS_DEFAULT) ; set flag to default intensity\n");
                this.SB_actionCode.append("\tsta      currentLevelFlags ; store level flags\n");
                this.SB_actionCode.append("\tldb      #$5f ; load default intensity\n");
                this.SB_actionCode.append("\t_INTENSITY_B ; \n");
            }
            this.SB_actionCode.append("noIntensityChange_PaM_2" + this.printAndMoveUID + ":\n");
            this.SB_actionCode.append("\tsts      temp16bit ; remember stack (current position in object list) \n");
            this.SB_actionCode.append("\tldd      S_Y_POS,s ; (re)load position (might be destroyed by trigger code) \n");
            this.SB_actionCode.append("\tldx      HEIGHT,s ; load string sizes \n");
            this.SB_actionCode.append("\tstx      Vec_Text_HW ; and store them to default \n");
            if (t.length <= 1) {
                this.SB_actionCode.append("\tldu      TEXT,s ; load text address to u \n");
                this.SB_actionCode.append("\tlds      #Vec_Default_Stk ; and enable stack usage (so we can use sub routines) \n");
                this.SB_actionCode.append(stringRoutine);
            } else {
                this.SB_actionCode.append("\tldy      TEXT,s ; load text address to y \n");
                this.SB_actionCode.append("\tlds      #Vec_Default_Stk ; and enable stack usage (so we can use sub routines) \n");
                this.SB_actionCode.append("nextMultiLine_PaM" + this.printAndMoveUID + ":\n");
                this.SB_actionCode.append("\tldu      ,y++ ; load text address to u \n");
                this.SB_actionCode.append("\tbeq      multiLineDone_PaM" + this.printAndMoveUID + "\n");
                this.SB_actionCode.append(stringRoutine);
                this.SB_actionCode.append("; in D are the old coordinates, adjusted to lines that were drawn");
                this.SB_actionCode.append("; move a little more down to draw the next line");
                this.SB_actionCode.append("\tsuba Vec_Text_Height \n");
                this.SB_actionCode.append("\tsuba Vec_Text_Height \n");
                this.SB_actionCode.append("\tsuba Vec_Text_Height \n");
                this.SB_actionCode.append("\tsuba Vec_Text_Height \n");
                this.SB_actionCode.append("\tbra      nextMultiLine_PaM" + this.printAndMoveUID + "\n");
                this.SB_actionCode.append("multiLineDone_PaM" + this.printAndMoveUID + ":\n");
            }
            this.SB_actionCode.append("\tlds      temp16bit ; restore stack to current object in object list\n");
            this.SB_actionCode.append("\tlda      gameScale ; load ...\n");
            this.SB_actionCode.append("\tsta      <VIA_t1_cnt_lo ; and set the default movement scale\n");
            this.SB_actionCode.append("\tldb      #$cc ; reset the beam to zero\n");
            this.SB_actionCode.append("\tSTb      >VIA_cntl\n");
            this.SB_actionCode.append("\tldd      #0 ; reset our VIA registers\n");
            this.SB_actionCode.append("\tstd      >VIA_port_b\n");
            this.SB_actionCode.append("\tldb      INTENSITY,s ; load the current Intensity\n");
            this.SB_actionCode.append("\tbmi      noIntensityChange_2PaM" + this.printAndMoveUID + "\n");
            this.SB_actionCode.append("\tldb      #$5f ; reset to default intensity\n");
            this.SB_actionCode.append("\t_INTENSITY_B ; \n");
            this.SB_actionCode.append("noIntensityChange_2PaM" + this.printAndMoveUID + ":\n");
            this.SB_actionCode.append("; ----------------------------------\n");
            this.SB_actionCode.append("; ------ MOVEMENT CODE START -------\n");
            this.SB_actionCode.append("; ----------------------------------\n");
            this.SB_actionCode.append("\tlda      Y_DELTA,s ; load current Y speed\n");
            this.SB_actionCode.append("\tadda     S_Y_POS,s ; add position \n");
            this.SB_actionCode.append("\tsta      S_Y_POS,s ; store to the Y position\n");
            this.SB_actionCode.append("\tlda      X_DELTA,s ; load current X speed\n");
            this.SB_actionCode.append("\tadda     S_X_POS,s ; add position \n");
            this.SB_actionCode.append("\tsta      S_X_POS,s ; store to the X position\n");
            this.SB_actionCode.append("; ----------------------------------\n");
            this.SB_actionCode.append("; ------ MOVEMENT CODE END ---------\n");
            this.SB_actionCode.append("; ----------------------------------\n");
            this.SB_actionCode.append("\tlds      S_NEXT_OBJECT,s ; load stack with the next object data\n");
            this.SB_actionCode.append("\tpuls     d,pc ; and jump to the next object in the object list\n");
        }
    }

    String genAYFX(String inFilename) {
        byte[] data2;
        Path path = Paths.get(inFilename, new String[0]);
        String nameOnly = path.getFileName().toString();
        String barenameOnly = nameOnly.substring(0, nameOnly.length() - 4);
        try {
            data2 = Files.readAllBytes(path);
        }
        catch (Throwable e) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        int count = 0;
        buf.append("; AYFX - Data of file: \"" + inFilename + "\"\n");
        buf.append("" + barenameOnly + "_data:\n");
        for (int i = 0; i < data2.length; ++i) {
            if (count == 0) {
                buf.append(" DB ");
            } else {
                buf.append(", ");
            }
            buf.append(String.format("$%02X", data2[i]));
            if (++count != 10) continue;
            count = 0;
            buf.append("\n");
        }
        return buf.toString();
    }

    void generateActionVectorlist() {
        if (this.mVectorlistDone.containsKey(this.mActionData.manimationFile)) {
            return;
        }
        GFXVectorAnimation animation = new GFXVectorAnimation();
        boolean ok = animation.loadFromXML(this.mActionData.manimationFile);
        if (!ok) {
            this.log.addLog("Error loading animation: " + this.mActionData.manimationFile, LogPanel.ERROR);
            return;
        }
        this.smartlistUsed = true;
        GenerationParameters p = new GenerationParameters();
        p.compileForVB = true;
        p.rts2 = true;
        p.paraName = this.mSpriteData.mName + "_" + this.mActionData.mName;
        p.doNoPositionMove = false;
        this.veccy.setParameters(p);
        this.SB_vectorLists.append(";\n");
        this.SB_vectorLists.append(";Vectorlists for action: " + this.mActionData.mName + ", sprite: " + this.mSpriteData.mName + "\n");
        this.SB_vectorLists.append(";\n");
        this.SB_vectorLists.append(p.paraName + ":\n");
        this.SB_vectorLists.append(this.veccy.buildSmartAnimlistG(false, animation, this.mSmartlistFunctions));
        this.mVectorlistDone.put(this.mActionData.manimationFile, p.paraName);
    }

    void addPlayerActionCode(boolean isPlayer) {
        boolean XLoaded = false;
        boolean YLoaded = false;
        this.SB_actionCode.append("; ----------------------------------\n");
        if (isPlayer) {
            this.SB_actionCode.append("; ---- PLAYER ACTION CODE START ----\n");
        } else {
            this.SB_actionCode.append("; ---- TRIGGER CODE ONLY START -----\n");
        }
        this.SB_actionCode.append("; ----------------------------------\n");
        this.SB_actionCode.append("; DEBUG: addPlayerActionCode enter\n");
        boolean buttonLoaded = false;
        boolean isPlayer1 = this.mActionData.mbehaviour.equals("player 1 controlled");
        boolean isPlayer2 = this.mActionData.mbehaviour.equals("player 2 controlled");
        for (int outer = 0; outer < 3; ++outer) {
            this.SB_actionCode.append("; DEBUG: addPlayerActionCode outer: " + outer + "\n");
            int eventtriggerCount = 0;
            for (int eventCount = 0; eventCount < this.mActionData.meventUID.size(); ++eventCount) {
                this.SB_actionCode.append("; DEBUG: addPlayerActionCode eventCount: " + eventCount + "\n");
                ActionTriggerData triggers = this.getTriggerByUID(this.mActionData, this.mActionData.meventUID.elementAt(eventCount));
                ActionResultData results = this.getResultByUID(this.mActionData, this.mActionData.meventUID.elementAt(eventCount));
                for (int triggerCount = 0; triggerCount < triggers.mtriggerByCause.size(); ++triggerCount) {
                    this.SB_actionCode.append("; DEBUG: addPlayerActionCode triggerCount: " + triggerCount + "\n");
                    ++eventtriggerCount;
                    if (this.mTriggerForActionDone.containsKey(this.buildTriggerKey(triggerCount, eventCount))) continue;
                    boolean triggerFound = false;
                    String cause = triggers.mtriggerByCause.elementAt(triggerCount);
                    String targetAction = results.mresultActionID.elementAt(0);
                    String triggerIDString = this.mSpriteData.mName + this.mActionData.mName + eventCount + "" + triggerCount + "" + outer;
                    String actionIDStringIter = this.mSpriteData.mName + targetAction;
                    String branchString = "";
                    if (outer == 2) {
                        if (cause.contains("button down")) {
                            if (!buttonLoaded) {
                                this.SB_actionCode.append("\tlda       Vec_Btn_State ; load current button state\n");
                                buttonLoaded = true;
                            }
                        } else if (cause.contains("button pressed")) {
                            if (!buttonLoaded) {
                                this.SB_actionCode.append("\tlda       Vec_Buttons ; load current toggle button state\n");
                                buttonLoaded = true;
                            }
                        } else {
                            buttonLoaded = false;
                        }
                        if (!cause.startsWith("joystick")) {
                            YLoaded = false;
                            XLoaded = false;
                        }
                        if (cause.equals("button down 1") || cause.equals("button pressed 1")) {
                            this.SB_actionCode.append("; trigger: " + cause + "\n");
                            triggerFound = true;
                            if (isPlayer1) {
                                this.SB_actionCode.append("\tbita      #$01 ; button 1\n");
                            }
                            if (isPlayer2) {
                                this.SB_actionCode.append("\tbita      #$10 ; button 1\n");
                            }
                            branchString = "\tbeq       endTest" + triggerIDString + "\n";
                        }
                        if (cause.equals("button down 2") || cause.equals("button pressed 2")) {
                            this.SB_actionCode.append("; trigger: " + cause + "\n");
                            triggerFound = true;
                            if (isPlayer1) {
                                this.SB_actionCode.append("\tbita      #$02 ; button 2\n");
                            }
                            if (isPlayer2) {
                                this.SB_actionCode.append("\tbita      #$20 ; button 2\n");
                            }
                            branchString = "\tbeq       endTest" + triggerIDString + "\n";
                        }
                        if (cause.equals("button down 3") || cause.equals("button pressed 3")) {
                            this.SB_actionCode.append("; trigger: " + cause + "\n");
                            triggerFound = true;
                            if (isPlayer1) {
                                this.SB_actionCode.append("\tbita      #$04 ; button 3\n");
                            }
                            if (isPlayer2) {
                                this.SB_actionCode.append("\tbita      #$40 ; button 3\n");
                            }
                            branchString = "\tbeq       endTest" + triggerIDString + "\n";
                        }
                        if (cause.equals("button down 4") || cause.equals("button pressed 4")) {
                            this.SB_actionCode.append("; trigger: " + cause + "\n");
                            triggerFound = true;
                            if (isPlayer1) {
                                this.SB_actionCode.append("\tbita      #$08 ; button 4\n");
                            }
                            if (isPlayer2) {
                                this.SB_actionCode.append("\tbita      #$80 ; button 4\n");
                            }
                            branchString = "\tbeq       endTest" + triggerIDString + "\n";
                        }
                        if (cause.equals("joystick center")) {
                            this.SB_actionCode.append("; trigger: " + cause + "\n");
                            triggerFound = true;
                            if (isPlayer1) {
                                this.SB_actionCode.append("\tldd       Vec_Joy_1_X; testing X and Y -> 16 bit\n");
                            }
                            if (isPlayer2) {
                                this.SB_actionCode.append("\tldd       Vec_Joy_2_X; testing X and Y -> 16 bit\n");
                            }
                            branchString = "\tbne       endTest" + triggerIDString + "\n";
                        }
                        if (cause.equals("joystick up")) {
                            this.SB_actionCode.append("; trigger: " + cause + "\n");
                            triggerFound = true;
                            if (isPlayer1) {
                                this.SB_actionCode.append("\tlda       Vec_Joy_1_Y\n");
                            }
                            if (isPlayer2) {
                                this.SB_actionCode.append("\tlda       Vec_Joy_2_Y\n");
                            }
                            YLoaded = true;
                            XLoaded = false;
                            branchString = "\tble       endTest" + triggerIDString + "\n";
                        }
                        if (cause.equals("joystick down")) {
                            this.SB_actionCode.append("; trigger: " + cause + "\n");
                            triggerFound = true;
                            if (!YLoaded) {
                                if (isPlayer1) {
                                    this.SB_actionCode.append("\tlda       Vec_Joy_1_Y\n");
                                }
                                if (isPlayer2) {
                                    this.SB_actionCode.append("\tlda       Vec_Joy_2_Y\n");
                                }
                            }
                            YLoaded = true;
                            XLoaded = false;
                            branchString = "\tbpl       endTest" + triggerIDString + "\n";
                        }
                        if (cause.equals("joystick right")) {
                            this.SB_actionCode.append("; trigger: " + cause + "\n");
                            triggerFound = true;
                            if (isPlayer1) {
                                this.SB_actionCode.append("\tldb       Vec_Joy_1_X\n");
                            }
                            if (isPlayer2) {
                                this.SB_actionCode.append("\tldb       Vec_Joy_2_X\n");
                            }
                            XLoaded = true;
                            YLoaded = false;
                            branchString = "\tble       endTest" + triggerIDString + "\n";
                        }
                        if (cause.equals("joystick left")) {
                            this.SB_actionCode.append("; trigger: " + cause + "\n");
                            triggerFound = true;
                            if (!XLoaded) {
                                if (isPlayer1) {
                                    this.SB_actionCode.append("\tldb       Vec_Joy_1_X\n");
                                }
                                if (isPlayer2) {
                                    this.SB_actionCode.append("\tldb       Vec_Joy_2_X\n");
                                }
                            }
                            YLoaded = false;
                            XLoaded = true;
                            branchString = "\tbpl       endTest" + triggerIDString + "\n";
                        }
                    }
                    if (outer == 0 && cause.equals("sprite no collision") && isPlayer) {
                        triggerFound = true;
                        branchString = this.addNoCollisionCheck(eventCount, triggerCount, triggerIDString, "endTest");
                    }
                    if (outer == 1 && (cause.equals("sprite collision") || cause.equals("sprite receive collision")) && isPlayer) {
                        triggerFound = true;
                        this.SB_actionCode.append("; DEBUG: addCollisionCheck start\n");
                        branchString = this.addCollisionCheck(eventCount, triggerCount, triggerIDString, "endTest");
                        this.SB_actionCode.append("; DEBUG: addCollisionCheck end\n");
                    }
                    if (!triggerFound) continue;
                    this.SB_actionCode.append("; DEBUG: addTriggerFoundCode start\n");
                    this.addTriggerFoundCode(eventCount, triggerCount, branchString);
                    this.SB_actionCode.append("; DEBUG: addTriggerFoundCode end\n");
                    this.SB_actionCode.append("endTest" + triggerIDString + ":\n");
                }
            }
        }
        this.SB_actionCode.append("; DEBUG: addPlayerActionCode exit\n");
        this.SB_actionCode.append("; ----------------------------------\n");
        if (isPlayer) {
            this.SB_actionCode.append("; ---- PLAYER ACTION CODE END ------\n");
        } else {
            this.SB_actionCode.append("; ---- TRIGGER ONLY CODE END -------\n");
        }
        this.SB_actionCode.append("; ----------------------------------\n");
    }

    String addCollisionCheck(int eventCount, int triggerCount, String triggerIDString, String endTest) {
        ActionTriggerData triggers = this.getTriggerByUID(this.mActionData, this.mActionData.meventUID.elementAt(eventCount));
        ActionResultData results = this.getResultByUID(this.mActionData, this.mActionData.meventUID.elementAt(eventCount));
        String cause = triggers.mtriggerByCause.elementAt(triggerCount);
        String targetAction = results.mresultActionID.elementAt(0);
        String actionIDStringIter = this.mSpriteData.mName + targetAction;
        String branchString = "";
        this.SB_actionCode.append("; trigger: " + cause + "\n");
        this.SB_actionCode.append(" ; collision testing is done on the\n");
        this.SB_actionCode.append(" ; enemy objects, if one collided with THIS sprite\n");
        this.SB_actionCode.append(" ; a flag is set and can be reacted upon here (in the next round)\n");
        this.SB_actionCode.append("\tldb      FLAG,s       ; \n");
        this.SB_actionCode.append("\tbitb     #(SPRITE_SPRITE_COLLISION_BIT)       ; check if collision with a sprite occured\n");
        this.SB_actionCode.append("\tbeq       " + endTest + triggerIDString + "\n");
        String otherID = triggers.mtriggerBySpriteID.elementAt(triggerCount);
        if (otherID != null && otherID.length() != 0) {
            SpriteData sprite = this.getSpriteByID(otherID);
            this.SB_actionCode.append("\tlda     COLLISION_ID,s ; load id of the sprite with which the collision happened\n");
            this.SB_actionCode.append("\tcmpa    #" + sprite.mspriteUID + " ; check if collision with the CORRECT sprite happened\n");
            this.SB_actionCode.append("\tbne       " + endTest + triggerIDString + "\n");
            this.SB_actionCode.append("\tandb      #(255-SPRITE_SPRITE_COLLISION_BIT)       ; remove flag\n");
            this.SB_actionCode.append("\tstb      FLAG,s       ; \n");
            branchString = "\tbrn       " + endTest + triggerIDString + "\n";
        } else {
            ShowWarningDialog.showWarningDialog("Unkown player<->sprite collision!", "An unkown collision detection can occur, otherID = null. (Player action: " + this.mActionData.mName + ", trigger count: " + triggerCount + ")");
            this.SB_actionCode.append("\tandb      #(255-SPRITE_SPRITE_COLLISION_BIT)       ; remove flag\n");
            this.SB_actionCode.append("\tstb      FLAG,s       ; \n");
            branchString = "\tbrn       " + endTest + triggerIDString + "\n";
        }
        return branchString;
    }

    String addNoCollisionCheck(int eventCount, int triggerCount, String triggerIDString, String endTest) {
        ActionTriggerData triggers = this.getTriggerByUID(this.mActionData, this.mActionData.meventUID.elementAt(eventCount));
        ActionResultData results = this.getResultByUID(this.mActionData, this.mActionData.meventUID.elementAt(eventCount));
        String cause = triggers.mtriggerByCause.elementAt(triggerCount);
        String targetAction = results.mresultActionID.elementAt(triggerCount);
        String actionIDStringIter = this.mSpriteData.mName + targetAction;
        String branchString = "";
        this.SB_actionCode.append("; trigger: " + cause + "\n");
        this.SB_actionCode.append("\tldb      FLAG,s       ; \n");
        this.SB_actionCode.append("\tbitb     #(SPRITE_SPRITE_COLLISION_BIT)       ; check if collision with a sprite occured\n");
        this.SB_actionCode.append("\tbeq       noCollisionDetected" + triggerIDString + "\n");
        String otherID = triggers.mtriggerBySpriteID.elementAt(triggerCount);
        if (otherID != null && otherID.length() != 0) {
            SpriteData sprite = this.getSpriteByID(otherID);
            this.SB_actionCode.append("\tlda     COLLISION_ID,s ; load id of the sprite with which the collision happened\n");
            this.SB_actionCode.append("\tcmpa    #" + sprite.mspriteUID + " ; check if collision with the CORRECT sprite happened\n");
            this.SB_actionCode.append("\tbeq       " + endTest + triggerIDString + "\n");
            branchString = "\tbrn       " + endTest + triggerIDString + "\n";
        } else {
            ShowWarningDialog.showWarningDialog("Unkown player<->sprite no collision!", "An unkown no collision detection can occur, otherID = null. (Player action: " + this.mActionData.mName + ", trigger count: " + triggerCount + ")");
            this.SB_actionCode.append("\tbra       " + endTest + triggerIDString + "\n");
        }
        this.SB_actionCode.append("noCollisionDetected" + triggerIDString + ": \n");
        return branchString;
    }

    void addSpriteActionCode() {
        String endOFActionHandle = this.mSpriteData.mName + this.mActionData.mName + "BehaviourNoAnimChange";
        this.SB_actionCode.append("; ----------------------------------\n");
        this.SB_actionCode.append("; ----- SPRITE ACTION CODE START ---\n");
        this.SB_actionCode.append("; ----------------------------------\n");
        boolean buttonLoaded = false;
        for (int outer = 0; outer < 2; ++outer) {
            for (int eventCount = 0; eventCount < this.mActionData.meventUID.size(); ++eventCount) {
                ActionTriggerData triggers = this.getTriggerByUID(this.mActionData, this.mActionData.meventUID.elementAt(eventCount));
                ActionResultData results = this.getResultByUID(this.mActionData, this.mActionData.meventUID.elementAt(eventCount));
                for (int triggerCount = 0; triggerCount < triggers.mtriggerByCause.size(); ++triggerCount) {
                    if (this.mTriggerForActionDone.containsKey(this.buildTriggerKey(triggerCount, eventCount))) continue;
                    boolean triggerFound = false;
                    String cause = triggers.mtriggerByCause.elementAt(triggerCount);
                    String targetAction = results.mresultActionID.elementAt(triggerCount);
                    String triggerIDString = this.mSpriteData.mName + this.mActionData.mName + eventCount + "" + triggerCount + "" + outer;
                    String actionIDStringIter = this.mSpriteData.mName + targetAction;
                    String branchString = "";
                    StringBuilder postTriggerAdd = new StringBuilder();
                    if (outer == 0 && cause.equals("sprite no collision")) {
                        triggerFound = true;
                        branchString = this.addNoCollisionCheck(eventCount, triggerCount, triggerIDString, "endTestSprSpr");
                    }
                    if (outer == 1 && (cause.equals("sprite collision") || cause.equals("sprite receive collision"))) {
                        triggerFound = true;
                        branchString = this.addCollisionCheck(eventCount, triggerCount, triggerIDString, "endTestSprSpr");
                    }
                    if (triggerFound) {
                        this.addTriggerFoundCode(eventCount, triggerCount, branchString);
                    }
                    this.SB_actionCode.append("endTestSprSpr" + triggerIDString + ":\n");
                }
            }
        }
        this.SB_actionCode.append("; ----------------------------------\n");
        this.SB_actionCode.append("; ----- SPRITE ACTION CODE END -----\n");
        this.SB_actionCode.append("; ----------------------------------\n");
    }

    void addSpriteTriggerPostionCode() {
        String actionIDString = this.mSpriteData.mName + this.mActionData.mName;
        if (this.hasPositionTrigger(this.mActionData)) {
            this.SB_actionCode.append("; ----------------------------------\n");
            this.SB_actionCode.append("; ------ POSITION CODE START -------\n");
            this.SB_actionCode.append("; ----------------------------------\n");
        }
        for (int eventCount = 0; eventCount < this.mActionData.meventUID.size(); ++eventCount) {
            ActionTriggerData triggers = this.getTriggerByUID(this.mActionData, this.mActionData.meventUID.elementAt(eventCount));
            ActionResultData results = this.getResultByUID(this.mActionData, this.mActionData.meventUID.elementAt(eventCount));
            for (int triggerCount = 0; triggerCount < triggers.mtriggerByCause.size(); ++triggerCount) {
                String pos;
                String triggerID = "e" + eventCount + "_t" + triggerCount;
                if (this.mTriggerForActionDone.containsKey(this.buildTriggerKey(triggerCount, eventCount))) continue;
                boolean wasPositionTrigger = false;
                String branchString = "";
                String target = results.mresultType.elementAt(0);
                if (triggers.mtriggerByCause.elementAt(triggerCount).equals("position equals")) {
                    this.SB_actionCode.append("; trigger: position equals\n");
                    wasPositionTrigger = true;
                    pos = String.format("$%04X", (triggers.mtriggerByY.elementAt(triggerCount) * 256 & 0xFF00) + (triggers.mtriggerByX.elementAt(triggerCount) & 0xFF));
                    this.SB_actionCode.append("\tldd      S_Y_POS,s\n");
                    this.SB_actionCode.append("\tcmpd     #" + pos + "\n");
                    branchString = "\tbne      " + this.mSpriteData.mName + this.mActionData.mName + triggerID + "PosCompareDone\n";
                }
                if (triggers.mtriggerByCause.elementAt(triggerCount).equals("position > Y")) {
                    this.SB_actionCode.append("; trigger: position > Y\n");
                    wasPositionTrigger = true;
                    pos = String.format("$%02X", triggers.mtriggerByY.elementAt(triggerCount) & 0xFF);
                    this.SB_actionCode.append("\tlda      S_Y_POS,s\n");
                    this.SB_actionCode.append("\tcmpa     #" + pos + "\n");
                    branchString = "\tble      " + this.mSpriteData.mName + this.mActionData.mName + triggerID + "PosCompareDone\n";
                }
                if (triggers.mtriggerByCause.elementAt(triggerCount).equals("position < Y")) {
                    this.SB_actionCode.append("; trigger: position < Y\n");
                    wasPositionTrigger = true;
                    pos = String.format("$%02X", triggers.mtriggerByY.elementAt(triggerCount) & 0xFF);
                    this.SB_actionCode.append("\tlda      S_Y_POS,s\n");
                    this.SB_actionCode.append("\tcmpa     #" + pos + "\n");
                    branchString = "\tbge      " + this.mSpriteData.mName + this.mActionData.mName + triggerID + "PosCompareDone\n";
                }
                if (triggers.mtriggerByCause.elementAt(triggerCount).equals("position > X")) {
                    this.SB_actionCode.append("; trigger: position > X\n");
                    wasPositionTrigger = true;
                    pos = String.format("$%02X", triggers.mtriggerByX.elementAt(triggerCount) & 0xFF);
                    this.SB_actionCode.append("\tlda      S_X_POS,s\n");
                    this.SB_actionCode.append("\tcmpa     #" + pos + "\n");
                    branchString = "\tble      " + this.mSpriteData.mName + this.mActionData.mName + triggerID + "PosCompareDone\n";
                }
                if (triggers.mtriggerByCause.elementAt(triggerCount).equals("position < X")) {
                    this.SB_actionCode.append("; trigger: position < X\n");
                    wasPositionTrigger = true;
                    pos = String.format("$%02X", triggers.mtriggerByX.elementAt(triggerCount) & 0xFF);
                    this.SB_actionCode.append("\tlda      S_X_POS,s\n");
                    this.SB_actionCode.append("\tcmpa     #" + pos + "\n");
                    branchString = "\tbge      " + this.mSpriteData.mName + this.mActionData.mName + triggerID + "PosCompareDone\n";
                }
                if (!wasPositionTrigger) continue;
                this.addTriggerFoundCode(eventCount, triggerCount, branchString);
                this.SB_actionCode.append(this.mSpriteData.mName + this.mActionData.mName + triggerID + "PosCompareDone:\n");
            }
        }
        if (this.hasPositionTrigger(this.mActionData)) {
            this.SB_actionCode.append("; ----------------------------------\n");
            this.SB_actionCode.append("; ------ POSITION CODE END ---------\n");
            this.SB_actionCode.append("; ----------------------------------\n");
        }
    }

    String buildTriggerKey(int trigger, int event) {
        ActionTriggerData triggers = this.getTriggerByUID(this.mActionData, this.mActionData.meventUID.elementAt(event));
        ActionResultData results = this.getResultByUID(this.mActionData, this.mActionData.meventUID.elementAt(event));
        String t = this.mSpriteData.mName + this.mActionData.mName + "_" + event + "_" + triggers.mtriggerByCause.elementAt(trigger) + triggers.mtriggerByTicks.elementAt(trigger) + triggers.mtriggerByX.elementAt(trigger) + triggers.mtriggerByY.elementAt(trigger);
        if (triggers.mtriggerByCause.elementAt(trigger).contains("collision")) {
            t = t + triggers.mtriggerBySpriteID.elementAt(trigger);
        }
        return t;
    }

    void addSpriteTriggerTimerCode() {
        if (this.getTimerEventIndex(this.mActionData) == -1) {
            return;
        }
        int eventIndex = this.getTimerEventIndex(this.mActionData);
        ActionTriggerData triggers = this.getTriggerByUID(this.mActionData, this.mActionData.meventUID.elementAt(eventIndex));
        ActionResultData results = this.getResultByUID(this.mActionData, this.mActionData.meventUID.elementAt(eventIndex));
        if (this.mTriggerForActionDone.containsKey(this.buildTriggerKey(0, eventIndex))) {
            return;
        }
        this.SB_actionCode.append("; ----------------------------------\n");
        this.SB_actionCode.append("; -------- TIMER CODE START --------\n");
        this.SB_actionCode.append("; ----------------------------------\n");
        String actionIDString = this.mSpriteData.mName + this.mActionData.mName;
        String target = results.mresultType.elementAt(0);
        this.SB_actionCode.append("; trigger: timer expired\n");
        this.SB_actionCode.append("\tdec       TIMER,s\n");
        this.SB_actionCode.append("\tlbne      " + actionIDString + "TimerNotExpired\n");
        String reload = triggers.mtriggerByTicks.elementAt(0);
        if (reload.startsWith("=")) {
            reload = reload.substring(1);
            this.SB_actionCode.append("\tlda      " + reload + " ; reload timer\n");
        } else {
            this.SB_actionCode.append("\tlda      #" + reload + " ; reload timer\n");
        }
        this.SB_actionCode.append("\tsta      TIMER,s\n");
        this.addTriggerFoundCode(eventIndex, 0, "");
        this.SB_actionCode.append(actionIDString + "TimerNotExpired:\n");
        this.SB_actionCode.append("; ----------------------------------\n");
        this.SB_actionCode.append("; -------- TIMER CODE END ----------\n");
        this.SB_actionCode.append("; ----------------------------------\n");
    }

    void addSpriteTriggerLongTimerCode() {
        if (this.getLongTimerEventIndex(this.mActionData) == -1) {
            return;
        }
        int eventIndex = this.getLongTimerEventIndex(this.mActionData);
        ActionTriggerData triggers = this.getTriggerByUID(this.mActionData, this.mActionData.meventUID.elementAt(eventIndex));
        ActionResultData results = this.getResultByUID(this.mActionData, this.mActionData.meventUID.elementAt(eventIndex));
        if (this.mTriggerForActionDone.containsKey(this.buildTriggerKey(0, eventIndex))) {
            return;
        }
        this.SB_actionCode.append("; ----------------------------------\n");
        this.SB_actionCode.append("; ---- LONG TIMER CODE START -------\n");
        this.SB_actionCode.append("; ----------------------------------\n");
        String actionIDString = this.mSpriteData.mName + this.mActionData.mName;
        String target = results.mresultType.elementAt(0);
        this.SB_actionCode.append("; trigger: long timer expired\n");
        this.SB_actionCode.append("\tldx       DATA_W,s\n");
        this.SB_actionCode.append("\tleax      -1,x\n");
        this.SB_actionCode.append("\tstx       DATA_W,s\n");
        this.SB_actionCode.append("\tlbpl      " + actionIDString + "LongTimerNotExpired\n");
        String reload = triggers.mtriggerByTicks.elementAt(0);
        if (reload.startsWith("=")) {
            reload = reload.substring(1);
            this.SB_actionCode.append("\tldd      " + reload + " ; reload timer (16bit)\n");
        } else {
            this.SB_actionCode.append("\tldd      #" + reload + " ; reload timer\n");
        }
        this.SB_actionCode.append("\tstd      DATA_W,s\n");
        this.addTriggerFoundCode(eventIndex, 0, "");
        this.SB_actionCode.append(actionIDString + "LongTimerNotExpired:\n");
        this.SB_actionCode.append("; ----------------------------------\n");
        this.SB_actionCode.append("; ------ LONG TIMER CODE END -------\n");
        this.SB_actionCode.append("; ----------------------------------\n");
    }

    String get8bitKeyClean(String n) {
        String s = this.get8bitKey(n);
        s = UtilityString.replace(s, "-", "n");
        s = UtilityString.replace(s, "+", "p");
        s = UtilityString.replace(s, "(", "");
        s = UtilityString.replace(s, ")", "");
        s = UtilityString.replace(s, "!", "");
        return s;
    }

    String get8bitKey(String n) {
        int v = UtilityString.IntX(n, 300);
        if (v < 300) {
            String ret = "" + v;
            return ret;
        }
        if (n.toLowerCase().equals("x")) {
            return "x";
        }
        if (n.toLowerCase().startsWith("rand")) {
            return n.toLowerCase();
        }
        if (n.toLowerCase().equals("neg")) {
            return "neg";
        }
        if (n.toLowerCase().equals("++")) {
            return "pp";
        }
        if (n.toLowerCase().equals("--")) {
            return "nn";
        }
        if (n.toLowerCase().equals("+=0")) {
            return "p0";
        }
        if (n.toLowerCase().equals("+=1")) {
            return "p1";
        }
        if (n.toLowerCase().equals("+=2")) {
            return "p2";
        }
        if (n.toLowerCase().equals("+=3")) {
            return "p3";
        }
        if (n.toLowerCase().equals("+=4")) {
            return "p4";
        }
        if (n.toLowerCase().equals("+=5")) {
            return "p5";
        }
        if (n.toLowerCase().equals("+=6")) {
            return "p6";
        }
        if (n.toLowerCase().equals("+=7")) {
            return "p7";
        }
        if (n.toLowerCase().equals("+=8")) {
            return "p8";
        }
        if (n.toLowerCase().equals("+=9")) {
            return "p9";
        }
        if (n.toLowerCase().equals("-=0")) {
            return "n0";
        }
        if (n.toLowerCase().equals("-=1")) {
            return "n1";
        }
        if (n.toLowerCase().equals("-=2")) {
            return "n2";
        }
        if (n.toLowerCase().equals("-=3")) {
            return "n3";
        }
        if (n.toLowerCase().equals("-=4")) {
            return "n4";
        }
        if (n.toLowerCase().equals("-=5")) {
            return "n5";
        }
        if (n.toLowerCase().equals("-=6")) {
            return "n6";
        }
        if (n.toLowerCase().equals("-=7")) {
            return "n7";
        }
        if (n.toLowerCase().equals("-=8")) {
            return "n8";
        }
        if (n.toLowerCase().equals("-=9")) {
            return "n9";
        }
        if (n.toLowerCase().startsWith("=")) {
            return "var" + n.substring(1);
        }
        return "UNKNOWN";
    }

    String genDCodeForKey(String key, String reg, String org2, int result) {
        StringBuilder ret = new StringBuilder();
        String varName = "";
        String lda = "\tld" + reg + "      ";
        String adda = "\tadd" + reg + "     ";
        String nega = "\tneg" + reg + "     ";
        if (key.startsWith("rand")) {
            ++this.randomUID;
            boolean pn = false;
            boolean n = false;
            boolean p = false;
            if ((key = UtilityString.replace(key, "rand", "")).contains("+-")) {
                pn = true;
            }
            if ((key = UtilityString.replace(key, "+-", "")).contains("-")) {
                n = true;
            }
            if ((key = UtilityString.replace(key, "-", "")).contains("+")) {
                p = true;
            }
            key = UtilityString.replace(key, "+", "");
            if (!(pn || n || p)) {
                p = true;
            }
            key = UtilityString.replace(key, "(", "");
            int val = UtilityString.Int0(key = UtilityString.replace(key, ")", ""));
            if (val == 0) {
                ShowWarningDialog.showWarningDialog("Random", "Can't discern random base. (" + this.mSpriteData.mName + ", action: " + this.mActionData.mName + ")");
                ret.append(lda + org2 + "\n");
                return ret.toString();
            }
            int min = 0;
            int max = 0;
            if (p) {
                min = 0;
                max = val;
            }
            if (n) {
                min = -val;
                max = 0;
            }
            if (pn) {
                min = -val;
                max = val;
            }
            ret.append("\tsts      temp16bit ; remember stack (current position in object list) \n");
            ret.append("\tlds      #Vec_Default_Stk ; and enable stack usage (so we can use sub routines) \n");
            ret.append("\tpshs d\n");
            ret.append("repeatRandom" + this.randomUID + ":\n");
            ret.append("\tjsr      Random ; todo replace with good random \n");
            if (p) {
                ret.append("\tanda     #%00001111; max 15 \n");
            }
            if (n) {
                ret.append("\tanda     #%00001111; max 15 \n");
                ret.append("\tnega     #%10000000; max 15 \n");
            }
            if (pn) {
                ret.append("\tbpl      repeatPos" + this.randomUID + "\n");
                ret.append("\tora     #%11110000; max -15 \n");
                ret.append("\tbra      repeatNegDone" + this.randomUID + "\n");
                ret.append("repeatPos" + this.randomUID + ":\n");
                ret.append("\tanda     #%00001111; max 15 \n");
                ret.append("repeatNegDone" + this.randomUID + ":\n");
            }
            ret.append("\tcmpa     #" + max + "; max  \n");
            ret.append("\tbgt       repeatRandom" + this.randomUID + ";  \n");
            ret.append("\tcmpa     #" + min + "; min  \n");
            ret.append("\tblt       repeatRandom" + this.randomUID + ";  \n");
            ret.append("\tsta temp8bit\n");
            ret.append("\tpuls d\n");
            ret.append("\tlds      temp16bit ; reload stack \n");
            ret.append("\tld" + reg + " temp8bit\n");
            return ret.toString();
        }
        int adder = 10;
        if (key.equals("pp")) {
            adder = 1;
        } else if (key.equals("x")) {
            adder = 0;
        } else if (key.startsWith("p")) {
            adder = UtilityString.IntX(key.substring(1), 300);
        } else if (key.equals("nn")) {
            adder = -1;
        } else if (key.startsWith("n")) {
            adder = -UtilityString.IntX(key.substring(1), 300);
        }
        if (key.startsWith("var")) {
            varName = key.substring(3);
            ret.append(lda + varName + "\n");
        } else if (key.startsWith("neg")) {
            ret.append(lda + org2 + "\n");
            ret.append(nega + "\n");
        } else if (adder < 10) {
            ret.append(lda + org2 + "\n");
            if (adder != 0) {
                ret.append(adda + "#" + adder + "\n");
            }
        } else if (result < 300) {
            ret.append(lda + "#" + result + "\n");
        } else {
            ShowWarningDialog.showWarningDialog("change error", "Change can not be built! (" + this.mSpriteData.mName + ", action: " + this.mActionData.mName + ")");
            ret.append(lda + org2 + "\n");
        }
        return ret.toString();
    }

    void loadDWithPosChange(StringBuilder s, String yC, String xC) {
        int resultY = UtilityString.IntX(yC, 300);
        int resultX = UtilityString.IntX(xC, 300);
        if (resultY < 300 && resultX < 300) {
            String pos = String.format("$%04X", (resultY * 256 & 0xFF00) + (resultX & 0xFF));
            s.append("\tldd      #" + pos + "\n");
            return;
        }
        String code1 = this.genDCodeForKey(this.get8bitKey(yC), "a", "S_Y_POS,s", resultY);
        String code2 = this.genDCodeForKey(this.get8bitKey(xC), "b", "S_X_POS,s", resultX);
        s.append(code1);
        s.append(code2);
    }

    void loadDWithSpeedChange(StringBuilder s, String yC, String xC) {
        int resultY = UtilityString.IntX(yC, 300);
        int resultX = UtilityString.IntX(xC, 300);
        if (resultY < 300 && resultX < 300) {
            String pos = String.format("$%04X", (resultY * 256 & 0xFF00) + (resultX & 0xFF));
            s.append("\tldd      #" + pos + "\n");
            return;
        }
        String code1 = this.genDCodeForKey(this.get8bitKey(yC), "a", "Y_DELTA,s", resultY);
        String code2 = this.genDCodeForKey(this.get8bitKey(xC), "b", "X_DELTA,s", resultX);
        s.append(code1);
        s.append(code2);
    }

    void loadAWithVarChange(StringBuilder s, String yC, String xC) {
        int resultY = UtilityString.IntX(yC, 300);
        int resultX = UtilityString.IntX(xC, 300);
        if (resultY < 300) {
            ShowWarningDialog.showWarningDialog("No Variable found", "No Variable found! (" + this.mSpriteData.mName + ", action: " + this.mActionData.mName + ")");
            return;
        }
        String key = this.get8bitKey(yC);
        String varNameTarget = "";
        if (key.startsWith("var")) {
            varNameTarget = key.substring(3);
        } else {
            ShowWarningDialog.showWarningDialog("No Variable found", "No Variable found (2)! (" + this.mSpriteData.mName + ", action: " + this.mActionData.mName + ")");
        }
        key = this.get8bitKey(xC);
        String code1 = this.genDCodeForKey(key, "a", varNameTarget, resultX);
        s.append(code1);
    }

    void loadAWithContents(StringBuilder s, String yC) {
        int resultY = UtilityString.IntX(yC, 300);
        String code1 = this.genDCodeForKey(this.get8bitKey(yC), "a", "#0", resultY);
        s.append(code1);
    }

    int[] getTriggerCounts(String triggerKey) {
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (int eventCount = 0; eventCount < this.mActionData.meventUID.size(); ++eventCount) {
            ActionTriggerData triggers = this.getTriggerByUID(this.mActionData, this.mActionData.meventUID.elementAt(eventCount));
            ActionResultData results = this.getResultByUID(this.mActionData, this.mActionData.meventUID.elementAt(eventCount));
            for (int triggerCount = 0; triggerCount < triggers.mtriggerByCause.size(); ++triggerCount) {
                String localKey = this.buildTriggerKey(triggerCount, eventCount);
                if (!localKey.equals(triggerKey)) continue;
                l.add(triggerCount);
            }
        }
        int[] ret = new int[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            ret[i] = (Integer)l.get(i);
        }
        return ret;
    }

    void addTriggerFoundCode(int eventCount, int tCount, String branchString) {
        ActionTriggerData triggers = this.getTriggerByUID(this.mActionData, this.mActionData.meventUID.elementAt(eventCount));
        ActionResultData results = this.getResultByUID(this.mActionData, this.mActionData.meventUID.elementAt(eventCount));
        for (int rcount = 0; rcount < results.mresultType.size(); ++rcount) {
            String tKey = this.buildTriggerKey(tCount, eventCount);
            this.mTriggerForActionDone.put(tKey, tKey);
            int[] triggerCountsForCause = this.getTriggerCounts(tKey);
            if (triggerCountsForCause.length == 0) {
                ShowWarningDialog.showWarningDialog("Trigger count mismatch!", "A trigger identified could not be found! (Sprite: " + this.mSpriteData.mName + ", Action: " + this.mActionData.mName + ")");
            }
            for (int rem = 0; rem < 4; ++rem) {
                boolean isFirst = true;
                for (int ii = 0; ii < triggerCountsForCause.length; ++ii) {
                    int triggerCount = triggerCountsForCause[ii];
                    String endOFActionHandle = this.mSpriteData.mName + this.mActionData.mName + "BehaviourTriggerDone";
                    String cause = triggers.mtriggerByCause.elementAt(triggerCount);
                    String targetAction = results.mresultActionID.elementAt(rcount);
                    String triggerIDString = this.mSpriteData.mName + this.mActionData.mName + "" + eventCount + "_" + triggerCount + "_" + rcount;
                    String actionIDStringIter = this.mSpriteData.mName + targetAction;
                    String key = actionIDStringIter + "Triggered";
                    int resultY = UtilityString.IntX(results.mresultY.elementAt(rcount), 300);
                    int resultX = UtilityString.IntX(results.mresultX.elementAt(rcount), 300);
                    if (rem == 0) {
                        String pos;
                        String spawnID;
                        if (results.mresultType.elementAt(rcount).equals("action change")) {
                            key = key + "ActionChange" + targetAction;
                        }
                        if (results.mresultType.elementAt(rcount).equals("random spawn sprite")) {
                            spawnID = results.mresultSpriteID.elementAt(rcount);
                            key = key + "RandomSpriteSpawn" + spawnID;
                        }
                        if (results.mresultType.elementAt(rcount).equals("spawn sprite")) {
                            spawnID = results.mresultSpriteID.elementAt(rcount);
                            key = key + "SpriteSpawn" + spawnID;
                        }
                        if (results.mresultType.elementAt(rcount).equals("set position")) {
                            pos = String.format("0x%04X", (resultY * 256 & 0xFF00) + (resultX & 0xFF));
                            key = key + "SetPosition" + this.get8bitKeyClean(results.mresultY.elementAt(rcount)) + "_" + this.get8bitKeyClean(results.mresultX.elementAt(rcount));
                        }
                        if (results.mresultType.elementAt(rcount).equals("block movement")) {
                            key = key + "BlockMovement";
                        }
                        if (results.mresultType.elementAt(rcount).equals("speed change")) {
                            pos = String.format("0x%04X", (resultY * 256 & 0xFF00) + (resultX & 0xFF));
                            key = key + "SetSpeed" + this.get8bitKeyClean(results.mresultY.elementAt(rcount)) + "_" + this.get8bitKeyClean(results.mresultX.elementAt(rcount));
                        }
                        if (results.mresultType.elementAt(rcount).equals("variable change")) {
                            key = key + "varChange";
                        }
                        if (results.mresultType.elementAt(rcount).equals("intensity change")) {
                            key = key + "intensityChange";
                        }
                        if (results.mresultType.elementAt(rcount).equals("play sfx")) {
                            key = key + "playsfx";
                        }
                    }
                    if (rem == 1 && results.mresultType.elementAt(rcount).equals("remove all")) {
                        key = key + "RemoveAll";
                    }
                    if (rem == 2 && results.mresultType.elementAt(rcount).equals("remove")) {
                        key = key + "Remove";
                    }
                    if (rem == 3) {
                        if (results.mresultType.elementAt(rcount).equals("next level")) {
                            key = key + "nextLevel";
                        }
                        if (results.mresultType.elementAt(rcount).equals("set level")) {
                            key = key + "setLevel";
                        }
                    }
                    if (isFirst) {
                        if (branchString.length() > 0) {
                            if (!branchString.substring(1).startsWith("brn")) {
                                this.SB_actionCode.append(branchString);
                            }
                        } else {
                            this.SB_actionCode.append(branchString);
                        }
                    }
                    isFirst = false;
                    ++this.triggerFoundUID;
                    if (rem == 0) {
                        if (results.mresultType.elementAt(rcount).equals("variable change")) {
                            String toChange = results.mresultY.elementAt(rcount);
                            String changer = results.mresultX.elementAt(rcount);
                            this.loadAWithVarChange(this.SB_actionCode, toChange, changer);
                            String varNameTarget = this.get8bitKey(toChange);
                            if (varNameTarget.startsWith("var")) {
                                varNameTarget = varNameTarget.substring(3);
                                this.SB_actionCode.append("\tsta      " + varNameTarget + "\n");
                            } else {
                                ShowWarningDialog.showWarningDialog("No Variable found", "No Variable found (3)! (" + this.mSpriteData.mName + ", action: " + this.mActionData.mName + ")");
                            }
                        }
                        if (results.mresultType.elementAt(rcount).equals("intensity change")) {
                            String deltaString = results.mresultY.elementAt(rcount);
                            String code1 = this.genDCodeForKey(this.get8bitKey(deltaString), "a", "INTENSITY,s", resultY);
                            this.SB_actionCode.append(code1);
                            this.SB_actionCode.append("\tsta      INTENSITY,s ;\n");
                        }
                        if (results.mresultType.elementAt(rcount).equals("set position")) {
                            this.SB_actionCode.append("; trigger result -> set position\n");
                            this.loadDWithPosChange(this.SB_actionCode, results.mresultY.elementAt(rcount), results.mresultX.elementAt(rcount));
                            this.SB_actionCode.append("\tstd      S_Y_POS,s\n");
                        }
                        if (results.mresultType.elementAt(rcount).equals("block movement")) {
                            this.SB_actionCode.append("\tldb      FLAG,s ; load collision direction flags\n");
                            this.SB_actionCode.append("\tlda      Y_DELTA,s ; load current Y speed\n");
                            this.SB_actionCode.append("\tbeq      " + triggerIDString + "TriggerBlockCheckVerticalEscape ; 0 -> don't care\n");
                            this.SB_actionCode.append("\tbpl      " + triggerIDString + "TriggerBlockCheckNorth ; postive -> tries to go north\n");
                            this.SB_actionCode.append("\tbitb     #COLLISION_SOUTH ; negative -> here check south block\n");
                            this.SB_actionCode.append("\tbeq      " + triggerIDString + "TriggerBlockCheckVerticalDone ; not blocked branch\n");
                            this.SB_actionCode.append("\tnega       ; invert last delta\n");
                            this.SB_actionCode.append("\tbra      " + triggerIDString + "TriggerBlockCheckVerticalDone ; \n");
                            this.SB_actionCode.append(triggerIDString + "TriggerBlockCheckVerticalEscape ; 0 -> don't care\n");
                            this.SB_actionCode.append("\tbitb     #COLLISION_SOUTH ; \n");
                            this.SB_actionCode.append("\tbeq      " + triggerIDString + "TriggerBlockCheckNoEscapeNotSouth ; not blocked branch\n");
                            this.SB_actionCode.append("\tinca       ; one step to the north\n");
                            this.SB_actionCode.append("\tbra      " + triggerIDString + "TriggerBlockCheckVerticalDone ; \n");
                            this.SB_actionCode.append(triggerIDString + "TriggerBlockCheckNoEscapeNotSouth:\n");
                            this.SB_actionCode.append("\tbitb     #COLLISION_NORTH ; \n");
                            this.SB_actionCode.append("\tbeq      " + triggerIDString + "TriggerBlockCheckVerticalDone ; \n");
                            this.SB_actionCode.append("\tdeca       ; one step to the south\n");
                            this.SB_actionCode.append("\tbra      " + triggerIDString + "TriggerBlockCheckVerticalDone ; \n");
                            this.SB_actionCode.append(triggerIDString + "TriggerBlockCheckNorth: ; trying to go north\n");
                            this.SB_actionCode.append("\tbitb     #COLLISION_NORTH ; is it blocked?\n");
                            this.SB_actionCode.append("\tbeq      " + triggerIDString + "TriggerBlockCheckVerticalDone ; no... than branch\n");
                            this.SB_actionCode.append("\tnega       ; negate trying to go north\n");
                            this.SB_actionCode.append(triggerIDString + "TriggerBlockCheckVerticalDone: ; \n");
                            this.SB_actionCode.append("\tadda     S_Y_POS,s ; set position \n");
                            this.SB_actionCode.append("\tsta      S_Y_POS,s ; set position \n");
                            this.SB_actionCode.append("\tlda      X_DELTA,s ; load current X speed\n");
                            this.SB_actionCode.append("\tbeq      " + triggerIDString + "TriggerBlockCheckHorizontalEscape ; 0 -> don't care\n");
                            this.SB_actionCode.append("\tbpl      " + triggerIDString + "TriggerBlockCheckEast ; postive -> tries to go east\n");
                            this.SB_actionCode.append("\tbitb     #COLLISION_WEST ; negative -> here check west block\n");
                            this.SB_actionCode.append("\tbeq      " + triggerIDString + "TriggerBlockCheckHorizontalDone ; not blocked branch\n");
                            this.SB_actionCode.append("\tnega       ; invert last delta\n");
                            this.SB_actionCode.append("\tbra      " + triggerIDString + "TriggerBlockCheckHorizontalDone ; \n");
                            this.SB_actionCode.append(triggerIDString + "TriggerBlockCheckHorizontalEscape: ; 0 -> don't care\n");
                            this.SB_actionCode.append("\tbitb     #COLLISION_WEST ; \n");
                            this.SB_actionCode.append("\tbeq      " + triggerIDString + "TriggerBlockCheckNoEscapeNotWest ; not blocked branch\n");
                            this.SB_actionCode.append("\tinca       ; one step to the east\n");
                            this.SB_actionCode.append("\tbra      " + triggerIDString + "TriggerBlockCheckHorizontalDone ; \n");
                            this.SB_actionCode.append(triggerIDString + "TriggerBlockCheckNoEscapeNotWest:\n");
                            this.SB_actionCode.append("\tbitb     #COLLISION_EAST ; \n");
                            this.SB_actionCode.append("\tbeq      " + triggerIDString + "TriggerBlockCheckHorizontalDone ; \n");
                            this.SB_actionCode.append("\tdeca       ; one step to the west\n");
                            this.SB_actionCode.append("\tbra      " + triggerIDString + "TriggerBlockCheckHorizontalDone ; \n");
                            this.SB_actionCode.append(triggerIDString + "TriggerBlockCheckEast: ; trying to go east\n");
                            this.SB_actionCode.append("\tbitb     #COLLISION_EAST ; is it blocked?\n");
                            this.SB_actionCode.append("\tbeq      " + triggerIDString + "TriggerBlockCheckHorizontalDone ; no... than branch\n");
                            this.SB_actionCode.append("\tnega       ; negate trying to go east\n");
                            this.SB_actionCode.append(triggerIDString + "TriggerBlockCheckHorizontalDone: ; \n");
                            this.SB_actionCode.append("\tadda     S_X_POS,s ; set position \n");
                            this.SB_actionCode.append("\tsta      S_X_POS,s ; set position \n");
                        }
                        if (results.mresultType.elementAt(rcount).equals("speed change")) {
                            this.SB_actionCode.append("; trigger result -> speed change\n");
                            this.loadDWithSpeedChange(this.SB_actionCode, results.mresultY.elementAt(0), results.mresultX.elementAt(0));
                            this.SB_actionCode.append("\tstd      Y_DELTA,s\n");
                        }
                        if (results.mresultType.elementAt(rcount).equals("action change")) {
                            this.SB_actionCode.append("; trigger result -> action change\n");
                            this.SB_actionCode.append("\tldx       #" + actionIDStringIter + "Behaviour ; load new behaviour (action)\n");
                            ActionNewData action = this.getActionByID(this.mSpriteData, targetAction);
                            this.setupNewAction(this.SB_actionCode, this.mSpriteData, action, "s", true);
                            if (action.mbehaviour.equals("parent direction")) {
                                // empty if block
                            }
                        }
                        if (results.mresultType.elementAt(rcount).equals("play sfx")) {
                            String actionID = results.mresultActionID.elementAt(rcount);
                            ActionNewData action = this.getActionByID(this.mSpriteData, actionID);
                            if (action.msoundFile.length() != 0) {
                                this.SB_actionCode.append("; trigger result -> play sfx\n");
                                this.SB_actionCode.append("\tsts      temp16bit ; remember stack (current position in object list) \n");
                                this.SB_actionCode.append("\tlds      #Vec_Default_Stk ; and enable stack usage (so we can use sub routines) \n");
                                Path path = Paths.get(action.msoundFile, new String[0]);
                                String nameOnly = path.getFileName().toString();
                                String barenameOnly = nameOnly.substring(0, nameOnly.length() - 4);
                                this.SB_actionCode.append("\tldd      #" + barenameOnly + "_data ; \n");
                                this.SB_actionCode.append("\tjsr      playSound ; \n");
                                this.SB_actionCode.append("\tlds      temp16bit ; restore stack to current object in object list\n");
                            }
                        }
                        boolean doRandomSpawn = false;
                        if (results.mresultType.elementAt(rcount).equals("random spawn sprite")) {
                            this.SB_actionCode.append("; trigger result -> random spawn sprite\n");
                            this.SB_actionCode.append("\tsts      temp16bit ; remember stack (current position in object list) \n");
                            this.SB_actionCode.append("\tlds      #Vec_Default_Stk ; and enable stack usage (so we can use sub routines) \n");
                            this.SB_actionCode.append("\tjsr      Random ; todo replace with good random \n");
                            this.SB_actionCode.append("\tlds      temp16bit ; restore stack to current object in object list\n");
                            this.SB_actionCode.append("\tcmpa     #" + triggers.mtriggerByY.elementAt(triggerCount) + " ; compare with 'Y'\n");
                            this.SB_actionCode.append("\tbhi      #" + triggerIDString + "TriggerSpawnFailed ; not in range -> don't spawn\n");
                            doRandomSpawn = true;
                        }
                        if (results.mresultType.elementAt(rcount).equals("spawn sprite") || doRandomSpawn) {
                            ActionTriggerData trigger;
                            String spawnID = results.mresultSpriteID.elementAt(rcount);
                            SpriteData sprite = this.getSpriteByID(spawnID);
                            if (sprite == null) {
                                ShowWarningDialog.showWarningDialog("Sprite is Null!", "Sprite is null, did you forget to give a spawn sprite? (" + this.mSpriteData.mName + ", action: " + this.mActionData.mName + ")");
                            }
                            ActionNewData action = this.getDefaultAction(sprite);
                            if (!doRandomSpawn) {
                                this.SB_actionCode.append("; trigger result -> sprite spawn\n");
                            }
                            int maxSprite = this.getMaxAllowedSprite(spawnID);
                            this.getSpawnPositionToX(eventCount, triggerCount, this.mActionData, this.SB_actionCode, action);
                            this.SB_actionCode.append("\tsts      temp16bit ; remember stack (current position in object list) \n");
                            this.SB_actionCode.append("\tlds      #Vec_Default_Stk ; and enable stack usage (so we can use sub routines) \n");
                            if (maxSprite > 0) {
                                this.SB_actionCode.append("\tlda      #" + maxSprite + " ; check if not to many sprites of this kind \n");
                                this.SB_actionCode.append("\tldb      #" + sprite.mspriteUID + " ; uid of this kind of sprites \n");
                                this.SB_actionCode.append("\tjsr      checkObjectCount ; Z flag is set, when not allowed \n");
                                this.SB_actionCode.append("\tbeq      " + triggerIDString + "TriggerSpawnFailed ; \n");
                            }
                            this.SB_actionCode.append("\tjsr      newObject ; return pointer to U \n");
                            this.SB_actionCode.append("\tcmpu     #OBJECT_LIST_COMPARE_ADDRESS ; check if object creation was successfull \n");
                            this.SB_actionCode.append("\tbls      " + triggerIDString + "TriggerSpawnFailed ; branch if not successfull\n");
                            if (action.mbehaviour.equals("follow sprite")) {
                                this.SB_actionCode.append("\tstx      C_DATA_W,u\n");
                            } else {
                                this.SB_actionCode.append("\tstx      Y_POS,u\t; spawn at current location\n");
                            }
                            if (action.msoundFile.length() != 0) {
                                Path path = Paths.get(action.msoundFile, new String[0]);
                                String nameOnly = path.getFileName().toString();
                                String barenameOnly = nameOnly.substring(0, nameOnly.length() - 4);
                                this.SB_actionCode.append("\tldd      #" + barenameOnly + "_data ; \n");
                                this.SB_actionCode.append("\tjsr      playSound ; \n");
                            }
                            this.SB_actionCode.append("\tldx      #" + spawnID + "DefaultBehaviour\n");
                            String functionName = this.functionalizeNewAction(sprite, action, "u", false);
                            this.SB_actionCode.append("\tjsr      " + functionName + "\n");
                            this.SB_actionCode.append(triggerIDString + "TriggerSpawnFailed:\n");
                            if (!this.hasTrigger(action, "on creation")) {
                                this.SB_actionCode.append("\tlds      temp16bit ; restore stack to current object in object list\n");
                            }
                            if (action.mbehaviour.equals("parent direction")) {
                                this.SB_actionCode.append("\tldx      temp16bit ; this is the pointer to our stack drawn parent\n");
                                this.SB_actionCode.append("; --- adjust for behaviour: parent direction\n");
                                this.SB_actionCode.append("\tldb      #" + action.mchangeWhileActiveX + " ; load shot speed (assumed an absolut + value )\n");
                                this.SB_actionCode.append("\tlda      Y_DELTA,x ; parent speed y vertically\n");
                                this.SB_actionCode.append("\tsta      C_Y_DELTA,u ; set to action\n");
                                this.SB_actionCode.append("\tbeq      " + sprite.mName + action.mName + "yDeltaDone" + this.triggerFoundUID + " \n");
                                this.SB_actionCode.append("\tbpl      " + sprite.mName + action.mName + "yDeltaPositiv" + this.triggerFoundUID + " \n");
                                this.SB_actionCode.append("\tnegb      \n");
                                this.SB_actionCode.append("\tstb       C_Y_DELTA,u ; set to action\n");
                                this.SB_actionCode.append("\tnegb      \n");
                                this.SB_actionCode.append("\tbra      " + sprite.mName + action.mName + "yDeltaDone" + this.triggerFoundUID + " \n");
                                this.SB_actionCode.append(sprite.mName + action.mName + "yDeltaPositiv" + this.triggerFoundUID + ": \n");
                                this.SB_actionCode.append("\tstb      C_Y_DELTA,u ; set to action\n");
                                this.SB_actionCode.append(sprite.mName + action.mName + "yDeltaDone" + this.triggerFoundUID + ": \n");
                                this.SB_actionCode.append("\tlda      X_DELTA,x ; parent speed x vertically\n");
                                this.SB_actionCode.append("\tsta      C_X_DELTA,u ; set to action\n");
                                this.SB_actionCode.append("\tbeq      " + sprite.mName + action.mName + "xDeltaDone" + this.triggerFoundUID + " \n");
                                this.SB_actionCode.append("\tbpl      " + sprite.mName + action.mName + "xDeltaPositiv" + this.triggerFoundUID + " \n");
                                this.SB_actionCode.append("\tnegb      \n");
                                this.SB_actionCode.append("\tstb      C_X_DELTA,u ; set to action\n");
                                this.SB_actionCode.append("\tnegb      \n");
                                this.SB_actionCode.append("\tbra      " + sprite.mName + action.mName + "xDeltaDone" + this.triggerFoundUID + " \n");
                                this.SB_actionCode.append(sprite.mName + action.mName + "xDeltaPositiv" + this.triggerFoundUID + ": \n");
                                this.SB_actionCode.append("\tstb      C_X_DELTA,u ; set to action\n");
                                this.SB_actionCode.append(sprite.mName + action.mName + "xDeltaDone" + this.triggerFoundUID + ": \n");
                            }
                            if ((trigger = this.getTrigger(action, "on creation")) != null) {
                                this.SB_actionCode.append("\ttfr      u,y ; save u = created new sprite register usage in 'child'\n");
                                for (int eventCount2 = 0; eventCount2 < action.meventUID.size(); ++eventCount2) {
                                    trigger = this.getTriggerByUID(action, action.meventUID.elementAt(eventCount2));
                                    ActionResultData result = this.getResultByUID(action, action.meventUID.elementAt(eventCount2));
                                    if (!trigger.mtriggerByCause.elementAt(rcount).equals("on creation")) continue;
                                    this.SB_actionCode.append("; ---- init child (follower) start ----\n");
                                    this.SB_actionCode.append("\tjsr      newObject\t; return pointer to U \n");
                                    this.SB_actionCode.append("\tcmpu     #OBJECT_LIST_COMPARE_ADDRESS ; check if object creation was successfull \n");
                                    this.SB_actionCode.append("\tbls      " + triggerIDString + "TriggerSpawnFailedOnCreation ; branch if not successfull\n");
                                    ActionNewData saveAction = this.mActionData;
                                    SpriteData saveSprite = this.mSpriteData;
                                    this.mSpriteData = this.getSpriteByID(result.mresultSpriteID.elementAt(rcount));
                                    this.mActionData = this.getActionByID(this.mSpriteData, this.mSpriteData.mDefaultActionID);
                                    this.SB_actionCode.append("\tldx      #" + this.mSpriteData.mName + "DefaultBehaviour ; sprites always start with their default behaviour\n");
                                    String functionName2 = this.functionalizeNewAction(this.mSpriteData, this.mActionData, "u", false);
                                    this.SB_actionCode.append("\tjsr      " + functionName2 + "\n");
                                    this.SB_actionCode.append("\tsty      C_DATA_W,u\n");
                                    this.mActionData = saveAction;
                                    this.mSpriteData = saveSprite;
                                    this.SB_actionCode.append("; ---- init child (follower) end ----\n");
                                }
                                this.SB_actionCode.append(triggerIDString + "TriggerSpawnFailedOnCreation:\n");
                                this.SB_actionCode.append("\tlds      temp16bit ; restore stack to current object in object list\n");
                            }
                        }
                    }
                    if (rem == 1 && results.mresultType.elementAt(rcount).equals("remove all")) {
                        this.SB_actionCode.append("; trigger result -> remove all\n");
                        this.addRemoveAllCode(this.SB_actionCode, results.mresultSpriteID.elementAt(0));
                    }
                    if (rem == 2 && results.mresultType.elementAt(rcount).equals("remove")) {
                        this.SB_actionCode.append("; trigger result -> remove\n");
                        this.addRemoveCode(this.SB_actionCode);
                    }
                    if (rem != 3) continue;
                    if (results.mresultType.elementAt(rcount).equals("next level")) {
                        this.SB_actionCode.append("\tMY_MOVE_TO_A_END ; if there is time left for moving... iddle away\n");
                        this.SB_actionCode.append("\tlds       #Vec_Default_Stk             ; correct the stack to default address\n");
                        this.SB_actionCode.append("\tinc       currentLevel\n");
                        this.SB_actionCode.append("\tjmp       initCurrentLevel ; if there is time left for moving... iddle away\n");
                    }
                    if (!results.mresultType.elementAt(rcount).equals("set level")) continue;
                    this.loadAWithContents(this.SB_actionCode, results.mresultY.elementAt(rcount));
                    this.SB_actionCode.append("\tcmpa      currentLevel\n");
                    this.SB_actionCode.append("\tbeq      " + triggerIDString + "SetLevelEqual ; \n");
                    this.SB_actionCode.append("\tsta       currentLevel\n");
                    this.SB_actionCode.append("\tMY_MOVE_TO_A_END ; if there is time left for moving... iddle away\n");
                    this.SB_actionCode.append("\tlds       #Vec_Default_Stk             ; correct the stack to default address\n");
                    this.SB_actionCode.append("\tjmp       initCurrentLevel ; if there is time left for moving... iddle away\n");
                    this.SB_actionCode.append(triggerIDString + "SetLevelEqual: ; \n");
                }
            }
        }
    }

    void addEnemyPatrolCode() {
        String actionIDString = this.mSpriteData.mName + this.mActionData.mName;
        this.SB_actionCode.append("; ----------------------------------\n");
        this.SB_actionCode.append("; -------- PATROL CODE START -------\n");
        this.SB_actionCode.append("; ----------------------------------\n");
        int dataPos = 0;
        int posCount = 0;
        int maxStations = this.mActionData.mpositioning.size() / 3;
        if (maxStations == 0) {
            return;
        }
        if (maxStations > 1) {
            this.SB_actionCode.append("; patrol positions are handled DIRECTLY\n");
            this.SB_actionCode.append("; there is no list to go thru, but each\n");
            this.SB_actionCode.append("; position is programmed directly/immediately\n");
            this.SB_actionCode.append("; thus the following checks are in reality a jumptable\n");
            this.SB_actionCode.append("\tlda       DATA_POS,s\t; what patrol position stage are we in?\n");
        }
        boolean counter = false;
        while (posCount != maxStations - 1) {
            this.SB_actionCode.append("\tbeq       " + actionIDString + "Patrol_" + posCount + "\n");
            if (++posCount < maxStations - 1) {
                this.SB_actionCode.append("\tdeca       \n");
                continue;
            }
            this.SB_actionCode.append("\tbra       " + actionIDString + "Patrol_" + posCount + "\n");
        }
        dataPos = 0;
        posCount = 0;
        while (posCount != maxStations) {
            int count = this.mActionData.mpositioning.elementAt(dataPos + 0);
            int sy = this.mActionData.mpositioning.elementAt(dataPos + 1);
            int sx = this.mActionData.mpositioning.elementAt(dataPos + 2);
            int nextCount = posCount == maxStations - 1 ? this.mActionData.mpositioning.elementAt(0).intValue() : this.mActionData.mpositioning.elementAt(dataPos + 0 + 3).intValue();
            this.SB_actionCode.append(actionIDString + "Patrol_" + posCount + ":\n");
            if (sy != 0) {
                if (sy == 1) {
                    this.SB_actionCode.append("\tinc      S_Y_POS,s ; increase y by 1\n");
                } else if (sy == -1) {
                    this.SB_actionCode.append("\tdec      S_Y_POS,s  ; decrease y by 1\n");
                } else {
                    this.SB_actionCode.append("\tlda       S_Y_POS,s\n");
                    this.SB_actionCode.append("\tadda      #" + sy + "\n");
                    this.SB_actionCode.append("\tsta       S_Y_POS,s ; add and store the speed to the Y position\n");
                }
            }
            if (sx != 0) {
                if (sx == 1) {
                    this.SB_actionCode.append("\tinc      S_X_POS,s ; increase x by 1\n");
                } else if (sx == -1) {
                    this.SB_actionCode.append("\tdec      S_X_POS,s ; decrease x by 1\n");
                } else {
                    this.SB_actionCode.append("\tldb       S_X_POS,s\n");
                    this.SB_actionCode.append("\taddb      #" + sx + "\n");
                    this.SB_actionCode.append("\tstb       S_X_POS,s ; add and store the speed to the X position\n");
                }
            }
            this.SB_actionCode.append("\tdec        COUNTER,s ; decrease counter for this pattrol phase\n");
            this.SB_actionCode.append("\tbne        " + actionIDString + "PatrolDone ; if not zero branch\n");
            if (posCount != maxStations - 1) {
                this.SB_actionCode.append("\tinc       DATA_POS,s ; go to the next patrol phase\n");
            } else {
                this.SB_actionCode.append("\tclr       DATA_POS,s ; reset phase to the first \n");
            }
            this.SB_actionCode.append("\tlda       #" + nextCount + " ; and initialize the count for the next phase\n");
            this.SB_actionCode.append("\tsta        COUNTER,s\n");
            if (posCount + 1 != maxStations) {
                this.SB_actionCode.append("\tbra        " + actionIDString + "PatrolDone\n");
            }
            ++posCount;
            dataPos += 3;
        }
        this.SB_actionCode.append(actionIDString + "PatrolDone:\n");
        this.SB_actionCode.append("; ----------------------------------\n");
        this.SB_actionCode.append("; -------- PATROL CODE END ---------\n");
        this.SB_actionCode.append("; ----------------------------------\n");
    }

    boolean isText(SpriteData sprite) {
        boolean isText;
        ActionNewData action = this.getDefaultAction(sprite);
        if (action == null) {
            return true;
        }
        boolean bl = isText = action.mtext != null && action.mtext.length() != 0;
        if (action.mbehaviour.equals("text")) {
            isText = true;
        }
        return isText;
    }

    boolean isTriggerOnly(SpriteData sprite) {
        ActionNewData action = this.getDefaultAction(sprite);
        if (action == null) {
            return true;
        }
        return action.mbehaviour.equals("trigger only");
    }

    boolean isPlayer(SpriteData sprite) {
        ActionNewData action = this.getDefaultAction(sprite);
        if (action == null) {
            return false;
        }
        return action.mbehaviour.equals("player 1 controlled") || action.mbehaviour.equals("player 2 controlled");
    }

    boolean isPlayer1(SpriteData sprite) {
        ActionNewData action = this.getDefaultAction(sprite);
        if (action == null) {
            return false;
        }
        return action.mbehaviour.equals("player 1 controlled");
    }

    boolean isPlayer2(SpriteData sprite) {
        ActionNewData action = this.getDefaultAction(sprite);
        if (action == null) {
            return false;
        }
        return action.mbehaviour.equals("player 2 controlled");
    }

    ActionResultData getResults(String uid) {
        Collection<String> collectionKlasse = this.mResultPool.getKlassenHashMap().values();
        String klasse = uid;
        Collection<ActionResultData> colC = this.mResultPool.getMapForKlasse(klasse).values();
        for (ActionResultData item : colC) {
            if (!item.mName.equals(uid)) continue;
            return item;
        }
        ActionResultData results = new ActionResultData();
        results.mresultType = new Vector();
        results.mresultActionID = new Vector();
        results.mresultSpriteID = new Vector();
        results.mresultY = new Vector();
        results.mresultX = new Vector();
        return results;
    }

    ActionTriggerData getTriggers(String uid) {
        Collection<String> collectionKlasse = this.mTriggerPool.getKlassenHashMap().values();
        String klasse = uid;
        Collection<ActionTriggerData> colC = this.mTriggerPool.getMapForKlasse(klasse).values();
        for (ActionTriggerData item : colC) {
            if (!item.mName.equals(uid)) continue;
            return item;
        }
        ActionTriggerData triggers = new ActionTriggerData();
        triggers.mtriggerByCause = new Vector();
        triggers.mtriggerBySpriteID = new Vector();
        triggers.mtriggerByY = new Vector();
        triggers.mtriggerByX = new Vector();
        triggers.mtriggerByTicks = new Vector();
        return triggers;
    }

    ActionTriggerData getTriggerTypeStart(ActionNewData action, String cause) {
        for (int i = 0; i < action.meventUID.size(); ++i) {
            ActionTriggerData triggers = this.getTriggers(action.meventUID.elementAt(i));
            for (int ii = 0; ii < triggers.mtriggerByCause.size(); ++ii) {
                if (!triggers.mtriggerByCause.elementAt(ii).startsWith(cause)) continue;
                return triggers;
            }
        }
        return null;
    }

    ActionTriggerData getTrigger(ActionNewData action, String testTrigger) {
        for (int i = 0; i < action.meventUID.size(); ++i) {
            ActionTriggerData triggers = this.getTriggers(action.meventUID.elementAt(i));
            for (int ii = 0; ii < triggers.mtriggerByCause.size(); ++ii) {
                if (!triggers.mtriggerByCause.elementAt(ii).equals(testTrigger)) continue;
                return triggers;
            }
        }
        return null;
    }

    ActionResultData getResult(ActionNewData action, String testTrigger) {
        for (int i = 0; i < action.meventUID.size(); ++i) {
            ActionTriggerData triggers = this.getTriggers(action.meventUID.elementAt(i));
            for (int ii = 0; ii < triggers.mtriggerByCause.size(); ++ii) {
                if (!triggers.mtriggerByCause.elementAt(ii).equals(testTrigger)) continue;
                return this.getResults(action.meventUID.elementAt(i));
            }
        }
        return null;
    }

    ActionTriggerData getTriggerByUID(ActionNewData action, String uid) {
        return this.getTriggers(uid);
    }

    ActionResultData getResultByUID(ActionNewData action, String uid) {
        return this.getResults(uid);
    }

    boolean hasTriggerTypeStart(ActionNewData action, String cause) {
        return this.getTriggerTypeStart(action, cause) != null;
    }

    boolean hasTrigger(ActionNewData action, String cause) {
        return this.getTrigger(action, cause) != null;
    }

    boolean hasPositionTrigger(ActionNewData action) {
        return this.hasTriggerTypeStart(action, "position");
    }

    boolean hasButtonAction(ActionNewData action) {
        return this.hasTriggerTypeStart(action, "button");
    }

    boolean hasButton1Action(ActionNewData action) {
        return this.hasTrigger(action, "button 1");
    }

    boolean hasButton2Action(ActionNewData action) {
        return this.hasTrigger(action, "button 2");
    }

    boolean hasButton3Action(ActionNewData action) {
        return this.hasTrigger(action, "button 3");
    }

    boolean hasButton4Action(ActionNewData action) {
        return this.hasTrigger(action, "button 4");
    }

    boolean hasSpriteCollisionWithSprite(SpriteData thisSprite, SpriteData thatSprite) {
        int triggerCount;
        ActionTriggerData triggers;
        int eventCount;
        if (thisSprite == null) {
            return false;
        }
        if (thatSprite == null) {
            return false;
        }
        boolean ret = false;
        Collection<ActionNewData> colCa = this.mActionDataPool.getMapForKlasse(thisSprite.mName + "_Actions").values();
        for (ActionNewData actionData : colCa) {
            for (eventCount = 0; eventCount < actionData.meventUID.size(); ++eventCount) {
                triggers = this.getTriggerByUID(actionData, actionData.meventUID.elementAt(eventCount));
                for (triggerCount = 0; triggerCount < triggers.mtriggerByCause.size(); ++triggerCount) {
                    if (!triggers.mtriggerByCause.elementAt(triggerCount).equals("sprite collision") || !triggers.mtriggerBySpriteID.elementAt(triggerCount).equals(thatSprite.mName)) continue;
                    return true;
                }
            }
        }
        colCa = this.mActionDataPool.getMapForKlasse(thatSprite.mName + "_Actions").values();
        for (ActionNewData actionData : colCa) {
            for (eventCount = 0; eventCount < actionData.meventUID.size(); ++eventCount) {
                triggers = this.getTriggerByUID(actionData, actionData.meventUID.elementAt(eventCount));
                for (triggerCount = 0; triggerCount < triggers.mtriggerByCause.size(); ++triggerCount) {
                    if (!triggers.mtriggerByCause.elementAt(triggerCount).equals("sprite collision") || !triggers.mtriggerBySpriteID.elementAt(triggerCount).equals(thisSprite.mName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    boolean hasPlayer1CollisionWith(SpriteData sprite) {
        return this.hasSpriteCollisionWithSprite(this.getPlayer1Sprite(), sprite);
    }

    boolean hasPlayer2CollisionWith(SpriteData sprite) {
        return this.hasSpriteCollisionWithSprite(this.getPlayer2Sprite(), sprite);
    }

    void addPlayerVersusPlayerCollision() {
        if (!this.isPlayer1(this.mSpriteData)) {
            return;
        }
        if (!this.hasSpriteCollisionWithSprite(this.getPlayer1Sprite(), this.getPlayer2Sprite())) {
            return;
        }
        String actionIDString = this.mSpriteData.mName + this.mActionData.mName;
        ActionNewData player1Data = this.getPlayer1();
        this.SB_actionCode.append("; ----------------------------------\n");
        this.SB_actionCode.append("; ---- COLLISION CODE START PvP ----\n");
        this.SB_actionCode.append("; ----------------------------------\n");
        this.SB_actionCode.append("\tldx      main2Pointer  ; player pointer \n");
        this.generalCollisionDetection(this.SB_actionCode, "actionDelta1", "actionDelta2", "actionDelta1+1", "actionDelta2+1", "P1vP2", null, 100, 100, 100, 100);
        this.SB_actionCode.append("; ----------------------------------\n");
        this.SB_actionCode.append("; ----- COLLISION CODE END PvP -----\n");
        this.SB_actionCode.append("; ----------------------------------\n");
    }

    byte abs(byte i) {
        if (i < 0) {
            return -i;
        }
        return i;
    }

    void generalCollisionDetection(StringBuilder s, String delta1Y, String delta2Y, String delta1X, String delta2X, String kindOfCheck, String endBranch, int idelta1Y, int idelta12Y, int idelta1X, int idelta2X) {
        ++this.generalDetectionUID;
        String actionIDString = this.mSpriteData.mName + this.mActionData.mName + this.generalDetectionUID + "_" + kindOfCheck;
        if (endBranch == null) {
            endBranch = "\tbhs      " + actionIDString + "NoColDetect ; if lower -> we overlap, possible collision, lets check X\n";
        }
        s.append("\tclrb      ; used as 8 bit buffer for hit directions, lower 4 bits opponent, upper 4 bits ourself\n");
        boolean forceTest = false;
        if (this.abs((byte)(idelta1X - idelta1Y)) < 5) {
            forceTest = true;
        }
        s.append("; check Y position \n");
        s.append("\tlda      " + delta1Y + "  ; y delta of ourself action\n");
        s.append("\tadda     " + delta2Y + "  ; y delta of opponent action\n");
        s.append("\tsta      temp8bit    ; the complete HEIGHT of possible overlap \n");
        s.append("\tlda      Y_POS,x       ; load opponent Y position \n");
        s.append("\tsuba     S_Y_POS,s     ; subtract the ourself Y position \n");
        s.append("\tbpl      " + actionIDString + "YDeltaIsPositiv\n");
        s.append("\tnega     ; we are interested in ABSOLUT values for overlapping\n");
        s.append("\torb      #LoN_HiS ; Opponent is hit from north\n");
        s.append("\tbra      " + actionIDString + "YDeltaNegativeDone\n");
        s.append(actionIDString + "YDeltaIsPositiv:\n");
        s.append("\torb      #LoS_HiN ;Opponent is hit from south\n");
        s.append(actionIDString + "YDeltaNegativeDone:\n");
        s.append("\tcmpa     temp8bit ; compare the resulting position difference, with our max delta\n");
        s.append(endBranch);
        if (idelta1X >= 2 || forceTest) {
            s.append("\tsta     temp16bit ; remember the absolut difference (8bit used)\n");
        } else {
            s.append("\tclr     temp16bit ; possibly vertical wall - interfere with resulting ONE result\n");
        }
        s.append("; check X position \n");
        s.append("\tlda      " + delta1X + " ; x delta of ourself action\n");
        s.append("\tadda     " + delta2X + " ; x delta of opponent action\n");
        s.append("\tsta      temp8bit ; the complete WIDTH of possible overlap \n");
        s.append("\tlda      X_POS,x       ; load player opponent X position\n");
        s.append("\tsuba     S_X_POS,s     ; subtract ourself X postion\n");
        s.append("\tbpl      " + actionIDString + "XDeltaIsPositiv\n");
        s.append("\tnega     ; we are interested in ABSOLUT values for overlapping\n");
        s.append("\torb      #LoE_HiW ; Opponent is hit from east\n");
        s.append("\tbra      " + actionIDString + "XDeltaNegativeDone\n");
        s.append(actionIDString + "XDeltaIsPositiv:\n");
        s.append("\torb      #LoW_HiE ; P2 is hit from west\n");
        s.append(actionIDString + "XDeltaNegativeDone:\n");
        s.append("\tcmpa     temp8bit ; compare the resulting position difference, with our max delta\n");
        s.append(endBranch);
        if (idelta1Y < 2 && !forceTest) {
            s.append("\tclra ; possibly horizontal wall - interfere with resulting ONE result\n");
        }
        s.append(";--- collision between sprites! \n");
        s.append(" ; in reg A and temp16bit the vertical and horizontal overlappings are stored\n");
        s.append(" ; the larger of both is probably our most\n");
        s.append(" ; recent overlapping\n");
        s.append(" ; so this defines the ONE direction the collision happened\n");
        s.append(" ; if reg A smaller temp16, than vertical is 'main'\n");
        s.append("\tcmpa     temp16bit ; compare the horizontal and vertical distances\n");
        s.append("\tblo     " + actionIDString + "VerticalIsMain ; \n");
        s.append("\tandb    #NO_VERTICAL_AND ; horizontal is main\n");
        s.append("\tbra     " + actionIDString + "MainCheckDone ; \n");
        s.append(actionIDString + "VerticalIsMain:\n");
        s.append("\tandb    #NO_HORZONTAL_AND ; \n");
        s.append(actionIDString + "MainCheckDone:\n");
        s.append(" ; store out findings to the sprite flag\n");
        s.append("\ttfr      b,a       ; store a  copy of the flags in reg A\n");
        s.append("\tanda     #%00001111 ; flag of only opponent \n");
        s.append("\tora      #SPRITE_SPRITE_COLLISION_BIT ; and add a sprite collision! \n");
        s.append("\tsta      C_FLAG,x       ; store it\n");
        s.append("\tlsrb    ; scroll in our own flags \n");
        s.append("\tlsrb     \n");
        s.append("\tlsrb     \n");
        s.append("\tlsrb     \n");
        s.append("\torb      #SPRITE_SPRITE_COLLISION_BIT ; and add a sprite collision! \n");
        s.append("\tstb      FLAG,s       ; store it\n");
        s.append("\tldu      S_BEHAVIOUR,s       ; Behaviour of ourself\n");
        s.append("\tlda      -1,u       ; sprite ID of this sprite \n");
        s.append("\tsta      C_COLLISION_ID,x       ; store to opponent our ID as collision id \n");
        s.append("\tldu      BEHAVIOUR,x       ; Behaviour of opponent\n");
        s.append("\tlda      -1,u              ; sprite ID of opponent \n");
        s.append("\tsta      COLLISION_ID,s    ; store to ourself the collision ID of the opponent\n");
        s.append(actionIDString + "NoColDetect:\n");
    }

    void addPlayerCollisionDetection() {
        String yd;
        String xd;
        byte dy;
        byte dx;
        int dxi;
        int dyi;
        GFXVectorList boundingList;
        String actionIDString;
        boolean isPlayer = this.isPlayer(this.mSpriteData);
        if (isPlayer) {
            return;
        }
        if (this.hasPlayer1CollisionWith(this.mSpriteData)) {
            actionIDString = this.mSpriteData.mName + this.mActionData.mName;
            ActionNewData player1Data = this.getPlayer1();
            boundingList = ActionPanel.computeBoundingBoxStatic(this.mActionData);
            if (boundingList == null) {
                return;
            }
            dyi = ((int)boundingList.get((int)0).start.y() / ActionPanel.BLOW - (int)boundingList.get((int)2).start.y() / ActionPanel.BLOW) / 2;
            dxi = ((int)boundingList.get((int)0).start.x() / ActionPanel.BLOW - (int)boundingList.get((int)2).start.x() / ActionPanel.BLOW) / 2;
            dx = (byte)(dxi & 0xFF);
            dy = (byte)(dyi & 0xFF);
            xd = String.format("$%02X", dx);
            yd = String.format("$%02X", dy);
            this.SB_actionCode.append("; ----------------------------------\n");
            this.SB_actionCode.append("; ------ COLLISION CODE START P1 ---\n");
            this.SB_actionCode.append("; ----------------------------------\n");
            this.SB_actionCode.append("\tldx      main1Pointer  ; player pointer \n");
            this.generalCollisionDetection(this.SB_actionCode, "#" + yd, "actionDelta1", "#" + xd, "actionDelta1+1", "SvP1", null, this.abs(dy), 100, this.abs(dx), 100);
            this.SB_actionCode.append("; ----------------------------------\n");
            this.SB_actionCode.append("; ------ COLLISION CODE END P1 -----\n");
            this.SB_actionCode.append("; ----------------------------------\n");
        }
        if (this.hasPlayer2CollisionWith(this.mSpriteData)) {
            actionIDString = this.mSpriteData.mName + this.mActionData.mName;
            ActionNewData player2Data = this.getPlayer2();
            boundingList = ActionPanel.computeBoundingBoxStatic(this.mActionData);
            if (boundingList == null) {
                return;
            }
            dyi = ((int)boundingList.get((int)0).start.y() / ActionPanel.BLOW - (int)boundingList.get((int)2).start.y() / ActionPanel.BLOW) / 2;
            dxi = ((int)boundingList.get((int)0).start.x() / ActionPanel.BLOW - (int)boundingList.get((int)2).start.x() / ActionPanel.BLOW) / 2;
            dx = (byte)(dxi & 0xFF);
            dy = (byte)(dyi & 0xFF);
            xd = String.format("$%02X", dx);
            yd = String.format("$%02X", dy);
            this.SB_actionCode.append("; ----------------------------------\n");
            this.SB_actionCode.append("; ------ COLLISION CODE START P2 ---\n");
            this.SB_actionCode.append("; ----------------------------------\n");
            this.SB_actionCode.append("\tldx      main2Pointer  ; player pointer \n");
            this.generalCollisionDetection(this.SB_actionCode, "#" + yd, "actionDelta2", "#" + xd, "actionDelta2+1", "SvP2", null, this.abs(dy), 100, this.abs(dx), 100);
            this.SB_actionCode.append("; ----------------------------------\n");
            this.SB_actionCode.append("; ------ COLLISION CODE END P2 -----\n");
            this.SB_actionCode.append("; ----------------------------------\n");
        }
    }

    void addNonPlayerCollisionDetection() {
        if (this.isPlayer(this.mSpriteData)) {
            return;
        }
        if (this.isText(this.mSpriteData)) {
            return;
        }
        if (this.isTriggerOnly(this.mSpriteData)) {
            return;
        }
        GFXVectorList boundingList = ActionPanel.computeBoundingBoxStatic(this.mActionData);
        if (boundingList == null) {
            return;
        }
        int dyi = ((int)boundingList.get((int)0).start.y() / ActionPanel.BLOW - (int)boundingList.get((int)2).start.y() / ActionPanel.BLOW) / 2;
        int dxi = ((int)boundingList.get((int)0).start.x() / ActionPanel.BLOW - (int)boundingList.get((int)2).start.x() / ActionPanel.BLOW) / 2;
        byte dx = (byte)(dxi & 0xFF);
        byte dy = (byte)(dyi & 0xFF);
        String xd = String.format("$%02X", dx);
        String yd = String.format("$%02X", dy);
        int[] colDetectSpriteIDs = this.getColDetectSpriteIDs();
        if (colDetectSpriteIDs.length == 0) {
            return;
        }
        ++this.spriteColDetectionUID;
        this.SB_actionCode.append("; ----------------------------------\n");
        this.SB_actionCode.append("; ------ COLLISION CODE START ------\n");
        this.SB_actionCode.append("; ------- SPRITE <-> SPRITE --------\n");
        this.SB_actionCode.append("; ----------------------------------\n");
        String actionIDString = this.mSpriteData.mName + this.mActionData.mName;
        String uid = actionIDString + "spvsp" + this.spriteColDetectionUID;
        this.SB_actionCode.append("; go thru all possible sprites!\n");
        this.SB_actionCode.append("\tldx      objectlist_used_head ; load head of the object list\n");
        this.SB_actionCode.append(uid + "compareNextObject:\n");
        this.SB_actionCode.append("\tldu      BEHAVIOUR,x ; load behaviour address\n");
        this.SB_actionCode.append("\tlda      -1,u ; load sprite ID of the other sprite, check if we are interested\n");
        boolean selfCheckFound = false;
        for (int i = 0; i < colDetectSpriteIDs.length; ++i) {
            SpriteData otherSprite = this.getSpriteByUID(colDetectSpriteIDs[i]);
            if (otherSprite == null) {
                ShowWarningDialog.showWarningDialog("Collision with unkown sprite", "Did you add all sprites to the level, that you defined in your actions? (Sprite: " + this.mSpriteData.mName + ", action: " + this.mActionData.mName + ", unkown sprite ID: " + colDetectSpriteIDs[i] + ")");
                continue;
            }
            if (this.isPlayer(otherSprite) || this.isText(otherSprite) || this.isTriggerOnly(otherSprite)) continue;
            String key1 = otherSprite.mName + "Versus" + this.mSpriteData.mName;
            String key2 = this.mSpriteData.mName + "Versus" + otherSprite.mName;
            if (this.mSpriteVersusSpriteDone.get(key1) != null) continue;
            this.mSpriteVersusSpriteDone.put(key1, key1);
            this.mSpriteVersusSpriteDone.put(key2, key2);
            if (this.mSpriteData.mspriteUID == colDetectSpriteIDs[i]) {
                selfCheckFound = true;
                continue;
            }
            this.SB_actionCode.append("\tcmpa     #" + colDetectSpriteIDs[i] + " ; interested in this one?\n");
            this.SB_actionCode.append("\tbeq      " + uid + "checkForColDetect; if yes, branch to the check\n");
        }
        if (selfCheckFound) {
            this.SB_actionCode.append(" ; this is a collision with our own kind - special check needed!\n");
            this.SB_actionCode.append("\tcmpa     #" + this.mSpriteData.mspriteUID + " ; interested in this one?\n");
            this.SB_actionCode.append("\tbne      " + uid + "checkNextObject ; if no, branch to next\n");
            this.SB_actionCode.append(" ; ensure we are not testing for coliision with ourself\n");
            this.SB_actionCode.append("\tleay     STACK_PULL_OFFSET,x ; in y the start in ram of the current handled object\n");
            this.SB_actionCode.append("\tsty     temp16bit ; save to be able to compare\n");
            this.SB_actionCode.append("\tcmpx     temp16bit ; compare\n");
            this.SB_actionCode.append("\tbne      " + uid + "checkForColDetect; if not the same, branch to the check\n");
        }
        this.SB_actionCode.append(uid + "checkNextObject:\n");
        this.SB_actionCode.append("\tldx      NEXT_OBJECT,x ; initiate the next possible object to test \n");
        this.SB_actionCode.append("\tcmpx     #OBJECT_LIST_COMPARE_ADDRESS; is it the end of the list?\n");
        this.SB_actionCode.append("\tbhi      " + uid + "compareNextObject; no, than branch to next check\n");
        this.SB_actionCode.append("\tbra      " + uid + "objectsDoneNoCollision; yes -> than get out of here\n");
        this.SB_actionCode.append(uid + "checkForColDetect:\n");
        this.SB_actionCode.append("; in X pointer to other sprite to be checked\n");
        this.generalCollisionDetection(this.SB_actionCode, "#" + yd, "C_HEIGHT,x", "#" + xd, "C_WIDTH,x", "SvS", "\tbhi      " + uid + "checkNextObject ; if lower -> we overlap, continue\n", this.abs(dy), 100, this.abs(dx), 100);
        this.SB_actionCode.append(uid + "objectsDoneNoCollision:\n");
        this.SB_actionCode.append("; ----------------------------------\n");
        this.SB_actionCode.append("; ------- COLLISION CODE END -------\n");
        this.SB_actionCode.append("; ------- SPRITE <-> SPRITE --------\n");
        this.SB_actionCode.append("; ----------------------------------\n");
    }

    void setupNewAction(StringBuilder s, SpriteData sprite, ActionNewData action, String indexRegister, boolean stackAlreadyPulled) {
        int tindex;
        int ltindex;
        ++this.continuousNumber;
        HashMap<String, String> stackWasPulled = new HashMap<String, String>();
        HashMap<String, String> stackNotPulled = new HashMap<String, String>();
        stackWasPulled.put("BEHAVIOUR", "S_BEHAVIOUR");
        stackWasPulled.put("DATA_POS", "DATA_POS");
        stackWasPulled.put("COUNTER", "COUNTER");
        stackWasPulled.put("DATA_W", "DATA_W");
        stackWasPulled.put("X_DELTA", "X_DELTA");
        stackWasPulled.put("Y_DELTA", "Y_DELTA");
        stackWasPulled.put("TEXT", "TEXT");
        stackWasPulled.put("FLAG", "FLAG");
        stackWasPulled.put("ANIM_PLACE", "ANIM_PLACE");
        stackWasPulled.put("TIMER", "TIMER");
        stackWasPulled.put("Y_POS", "S_Y_POS");
        stackWasPulled.put("X_POS", "S_X_POS");
        stackWasPulled.put("INTENSITY", "INTENSITY");
        stackWasPulled.put("HEIGHT", "HEIGHT");
        stackWasPulled.put("WIDTH", "WIDTH");
        stackWasPulled.put("COLLISION_ID", "COLLISION_ID");
        stackNotPulled.put("BEHAVIOUR", "BEHAVIOUR");
        stackNotPulled.put("DATA_POS", "C_DATA_POS");
        stackNotPulled.put("COUNTER", "C_COUNTER");
        stackNotPulled.put("TEXT", "C_TEXT");
        stackNotPulled.put("DATA_W", "C_DATA_W");
        stackNotPulled.put("X_DELTA", "C_X_DELTA");
        stackNotPulled.put("Y_DELTA", "C_Y_DELTA");
        stackNotPulled.put("FLAG", "C_FLAG");
        stackNotPulled.put("ANIM_PLACE", "C_ANIM_PLACE");
        stackNotPulled.put("TIMER", "C_TIMER");
        stackNotPulled.put("INTENSITY", "C_INTENSITY");
        stackNotPulled.put("Y_POS", "Y_POS");
        stackNotPulled.put("X_POS", "X_POS");
        stackNotPulled.put("HEIGHT", "C_HEIGHT");
        stackNotPulled.put("WIDTH", "C_WIDTH");
        stackNotPulled.put("COLLISION_ID", "C_COLLISION_ID");
        HashMap<String, String> m = stackAlreadyPulled ? stackWasPulled : stackNotPulled;
        if (action == null) {
            ShowWarningDialog.showWarningDialog("Action is Null!", "Action is null, did you perhaps rename an action/sprite? (" + sprite.mName + ", action: " + action.mName + ")");
            return;
        }
        boolean isPlayer1 = action.mbehaviour.equals("player 1 controlled");
        boolean isPlayer2 = action.mbehaviour.equals("player 2 controlled");
        boolean isTriggerOnly = action.mbehaviour.equals("trigger only");
        GFXVectorList boundingList = null;
        boolean isTextAction = this.isText(sprite);
        if (isTextAction) {
            String[] t = UtilityString.cleanSplitNL(action.mtext);
            String v = this.mtextDone.get(action.mtext);
            if (v == null) {
                if (t.length <= 1) {
                    s.append("\tldd      #" + sprite.mName + action.mName + "Text ; load text for this action \n");
                } else {
                    s.append("\tldd      #" + sprite.mName + action.mName + "MultiText ; load text for this action \n");
                }
            } else {
                s.append("\tldd      #" + v + " ; load text for this action \n");
            }
            s.append("\tstd      " + (String)m.get("TEXT") + "," + indexRegister + " ; set to action\n");
            s.append("\tlda       #" + action.mtextHeight + " ; height\n");
            s.append("\tsta       " + (String)m.get("HEIGHT") + "," + indexRegister + " ; set to action\n");
            s.append("\tlda       #" + action.mtextWidth + " ; width\n");
            s.append("\tsta       " + (String)m.get("WIDTH") + "," + indexRegister + " ; set to action\n");
            if (this.mActionData.mintensity.length() != 0) {
                int intensity = UtilityString.IntX(this.mActionData.mintensity, 300);
                if (intensity != 300) {
                    s.append("\tlda      #" + intensity + " ; load the intensity value\n");
                    s.append("\tsta      " + (String)m.get("INTENSITY") + "," + indexRegister + " ; and set it to the object structure\n");
                } else {
                    ShowWarningDialog.showWarningDialog("Text & Intensity", "Text sprites are not allowed to have a variable in intensity! (Sprite: " + sprite.mName + ", Action: " + action.mName + ")");
                    s.append("\tlda      #$ff ; don't use intensity\n");
                    s.append("\tsta      " + (String)m.get("INTENSITY") + "," + indexRegister + " ; and set it to the object structure\n");
                }
            } else {
                s.append("\tlda      #$ff ; don't use intensity\n");
                s.append("\tsta      " + (String)m.get("INTENSITY") + "," + indexRegister + " ; and set it to the object structure\n");
            }
        } else {
            int intensity;
            if (this.mActionData.mintensity.length() != 0 && (intensity = UtilityString.IntX(this.mActionData.mintensity, 300)) != 300) {
                s.append("\tlda      #" + intensity + " ; load the intensity value\n");
                s.append("\tsta      " + (String)m.get("INTENSITY") + "," + indexRegister + " ; and set it to the object structure\n");
            }
            if (!isTriggerOnly) {
                boundingList = ActionPanel.computeBoundingBoxStatic(action);
            }
        }
        if (boundingList != null) {
            int dyi = ((int)boundingList.get((int)0).start.y() / ActionPanel.BLOW - (int)boundingList.get((int)2).start.y() / ActionPanel.BLOW) / 2;
            int dxi = ((int)boundingList.get((int)0).start.x() / ActionPanel.BLOW - (int)boundingList.get((int)2).start.x() / ActionPanel.BLOW) / 2;
            byte dx = (byte)(dxi & 0xFF);
            byte dy = (byte)(dyi & 0xFF);
            String xd = String.format("$%02X", dx);
            String yd = String.format("$%02X", dy);
            s.append("\tlda       #" + yd + " ; height\n");
            s.append("\tsta       " + (String)m.get("HEIGHT") + "," + indexRegister + " ; set to action\n");
            s.append("\tlda       #" + xd + " ; width\n");
            s.append("\tsta       " + (String)m.get("WIDTH") + "," + indexRegister + " ; set to action\n");
        }
        s.append("\tstx       " + (String)m.get("BEHAVIOUR") + "," + indexRegister + " ; set the behaviour\n");
        if (!isTriggerOnly || isTextAction) {
            if (!action.mchangeWhileActiveY.contains("a")) {
                if (action.mchangeWhileActiveY.length() == 0) {
                    ShowWarningDialog.showWarningDialog("Text Zero length!", "Delta Y is not set! (Sprite: " + sprite.mName + ", Action: " + action.mName + ")");
                }
                s.append("\tlda       #" + action.mchangeWhileActiveY + " ; get speed value y\n");
                s.append("\tsta       " + (String)m.get("Y_DELTA") + "," + indexRegister + " ; set to action\n");
            }
            if (!action.mchangeWhileActiveX.contains("a")) {
                if (action.mchangeWhileActiveX.length() == 0) {
                    ShowWarningDialog.showWarningDialog("Text Zero length!", "Delta X is not set! (Sprite: " + sprite.mName + ", Action: " + action.mName + ")");
                }
                s.append("\tlda       #" + action.mchangeWhileActiveX + " ; get speed value x\n");
                s.append("\tsta       " + (String)m.get("X_DELTA") + "," + indexRegister + " ; set to action\n");
            }
        }
        boolean isLongTimer = (ltindex = this.getLongTimerEventIndex(action)) != -1;
        boolean isFollow = action.mbehaviour.equals("follow sprite");
        if (isTextAction && action.mbehaviour.equals("patrol")) {
            ShowWarningDialog.showWarningDialog("Text on Patrol!", "An action can not be both - a text action and have the patrol flag!");
        }
        if (isLongTimer && action.mbehaviour.equals("patrol")) {
            ShowWarningDialog.showWarningDialog("Long timer on Patrol!", "An action can not be both - a long timer and have the patrol flag!");
        }
        if (isLongTimer && isTextAction) {
            ShowWarningDialog.showWarningDialog("Long timer on Text!", "An action can not be both - a long timer and have text!");
        }
        if (isFollow && action.mbehaviour.equals("patrol")) {
            ShowWarningDialog.showWarningDialog("Follow on Patrol!", "An action can not be both - a Follow and have the patrol flag!");
        }
        if (isFollow && isLongTimer) {
            ShowWarningDialog.showWarningDialog("Follow on Long timer!", "An action can not be both - a long timer and Follow!");
        }
        if (isFollow && isTextAction) {
            ShowWarningDialog.showWarningDialog("Follow on Text!", "An action can not be both - a Follow and have text!");
        }
        if (action.mbehaviour.equals("patrol")) {
            s.append(" ; init patroling\n");
            s.append("\tclr       " + (String)m.get("DATA_POS") + "," + indexRegister + " ; start with patrol position 0\n");
            int count = 1;
            if (action.mpositioning != null && action.mpositioning.size() != 0) {
                count = action.mpositioning.elementAt(0);
            }
            s.append("\tlda       #" + count + "\n");
            s.append("\tsta       " + (String)m.get("COUNTER") + "," + indexRegister + " ; and remember the times the patrol data should be applied\n");
        } else if (!isTextAction) {
            if (isLongTimer) {
                ActionTriggerData triggers = this.getTriggerByUID(action, action.meventUID.elementAt(ltindex));
                String load = triggers.mtriggerByTicks.elementAt(0);
                if (load.startsWith("=")) {
                    load = load.substring(1);
                    s.append("\tldd      " + load + " ; load timer (16bit)\n");
                } else {
                    s.append("\tldd      #" + load + " ; load timer\n");
                }
            } else if (!isFollow) {
                s.append("\tldd       #0 ; init unused object fields to 0\n");
            }
            if (!isFollow) {
                s.append("\tstd       " + (String)m.get("DATA_W") + "," + indexRegister + "\n");
            }
        }
        s.append("\tclra      \n");
        s.append("\tsta       " + (String)m.get("FLAG") + "," + indexRegister + " ; clear flags (collision detection) \n");
        if (!isTriggerOnly) {
            s.append("\tclr       " + (String)m.get("ANIM_PLACE") + "," + indexRegister + " ; clear animation position\n");
            s.append("\tclr       " + (String)m.get("COLLISION_ID") + "," + indexRegister + " ; clear colision ID\n");
        }
        if (isPlayer1 && !isTextAction) {
            s.append(" ; player 1 remember delta data\n");
            s.append("\tldd      " + sprite.mName + action.mName + "DeltaData  ; that is the bounding box data as delta\n");
            s.append("\tstd      actionDelta1\n");
        }
        if (isPlayer2 && !isTextAction) {
            s.append(" ; player 2 remember delta data\n");
            s.append("\tldd      " + sprite.mName + action.mName + "DeltaData  ; that is the bounding box data as delta\n");
            s.append("\tstd      actionDelta2\n");
        }
        if ((tindex = this.getTimerEventIndex(action)) != -1) {
            ActionTriggerData triggers = this.getTriggerByUID(action, action.meventUID.elementAt(tindex));
            String reload = triggers.mtriggerByTicks.elementAt(0);
            if (reload.startsWith("=")) {
                reload = reload.substring(1);
                s.append("\tlda      " + reload + " ; load timer\n");
            } else {
                s.append("\tlda      #" + reload + " ; load timer\n");
            }
        } else {
            s.append("\tclra ; clear timer tick count (not used with this action)\n");
        }
        s.append("\tsta      " + (String)m.get("TIMER") + "," + indexRegister + "\n");
        if (action.mbehaviour.equals("fixed movement")) {
            // empty if block
        }
        if (action.mbehaviour.equals("parent direction")) {
            // empty if block
        }
        if (action.mbehaviour.equals("target player 1")) {
            int shotSpeed = UtilityString.IntX(action.mchangeWhileActiveY, 1);
            s.append("; --- adjust for behaviour: target player 1\n");
            s.append("; --- vertical\n");
            s.append("\tldx      main1Pointer  ; player pointer \n");
            s.append("\tlda      Y_POS,x ; current player Y position\n");
            s.append("\tsuba     " + (String)m.get("Y_POS") + "," + indexRegister + " ; delta to our position \n");
            s.append("\tbpl      " + sprite.mName + action.mName + "TargetPlayer1YDeltaNoNeg" + this.continuousNumber + " \n");
            s.append("\tnega      \n");
            s.append(sprite.mName + action.mName + "TargetPlayer1YDeltaNoNeg" + this.continuousNumber + ":\n");
            s.append("\tcmpa     #10 ; compare to shot position \n");
            s.append("\tbhs      " + sprite.mName + action.mName + "TargetPlayer1YNotTiny" + this.continuousNumber + " \n");
            s.append("\tclrb     \n");
            s.append("\tbra      " + sprite.mName + action.mName + "TargetPlayer1YDone" + this.continuousNumber + "\n");
            s.append(sprite.mName + action.mName + "TargetPlayer1YNotTiny" + this.continuousNumber + ":\n");
            s.append("\tlda      Y_POS,x ; current player Y position\n");
            s.append("\tcmpa     " + (String)m.get("Y_POS") + "," + indexRegister + " ; compare to shot position \n");
            s.append("\tbgt      " + sprite.mName + action.mName + "TargetPlayer1YGreater" + this.continuousNumber + "\n");
            s.append("\tldb      #-" + shotSpeed + " ; if lower, than negative speed\n");
            s.append("\tbra      " + sprite.mName + action.mName + "TargetPlayer1YDone" + this.continuousNumber + "\n");
            s.append(sprite.mName + action.mName + "TargetPlayer1YGreater" + this.continuousNumber + ":\n");
            s.append("\tldb      #" + shotSpeed + " ; if higher, than positive speed\n");
            s.append(sprite.mName + action.mName + "TargetPlayer1YDone" + this.continuousNumber + ":\n");
            s.append("\tstb      " + (String)m.get("Y_DELTA") + "," + indexRegister + " ; store the speed to Y_DELTA\n");
            s.append("\tsuba     " + (String)m.get("Y_POS") + "," + indexRegister + " ; calculate the the delta of the two positions\n");
            s.append("\tbpl      " + sprite.mName + action.mName + "TargetPlayer1YGreaterNoNeg" + this.continuousNumber + "\n");
            s.append("\tnega     ; only the ABSOLUT value\n");
            s.append(sprite.mName + action.mName + "TargetPlayer1YGreaterNoNeg" + this.continuousNumber + ": \n");
            s.append("\tsta      temp8bit ; and store it in tmp\n");
            s.append("; --- horizontal\n");
            s.append("\tlda      X_POS,x ; current player X position\n");
            s.append("\tsuba     " + (String)m.get("X_POS") + "," + indexRegister + " ; delta to our position \n");
            s.append("\tbpl      " + sprite.mName + action.mName + "TargetPlayer1XDeltaNoNeg" + this.continuousNumber + "\n");
            s.append("\tnega      \n");
            s.append(sprite.mName + action.mName + "TargetPlayer1XDeltaNoNeg" + this.continuousNumber + ":\n");
            s.append("\tcmpa     #10 ; compare to shot position \n");
            s.append("\tbhs      " + sprite.mName + action.mName + "TargetPlayer1XNotTiny" + this.continuousNumber + "\n");
            s.append("\tclrb     \n");
            s.append("\ttst      " + (String)m.get("Y_DELTA") + "," + indexRegister + " ; check if both directions are 0 - if so load X speed with default value\n");
            s.append("\tbne      " + sprite.mName + action.mName + "TargetPlayer1XDone" + this.continuousNumber + "\n");
            s.append("\tldb      #" + shotSpeed + "\n");
            s.append("\tbra      " + sprite.mName + action.mName + "TargetPlayer1XDone" + this.continuousNumber + "\n");
            s.append(sprite.mName + action.mName + "TargetPlayer1XNotTiny" + this.continuousNumber + ":\n");
            s.append("\tldx      main1Pointer  ; player pointer \n");
            s.append("\tlda      X_POS,x ; current player X position\n");
            s.append("\tcmpa     " + (String)m.get("X_POS") + "," + indexRegister + " ; compare to shot position \n");
            s.append("\tbgt      " + sprite.mName + action.mName + "TargetPlayer1XGreater" + this.continuousNumber + "\n");
            s.append("\tldb      #-" + shotSpeed + " ; if lower, than negative speed\n");
            s.append("\tbra      " + sprite.mName + action.mName + "TargetPlayer1XDone" + this.continuousNumber + "\n");
            s.append(sprite.mName + action.mName + "TargetPlayer1XGreater" + this.continuousNumber + ":\n");
            s.append("\tldb      #" + shotSpeed + " ; if higher, than positive speed\n");
            s.append(sprite.mName + action.mName + "TargetPlayer1XDone" + this.continuousNumber + ":\n");
            s.append("\tstb      " + (String)m.get("X_DELTA") + "," + indexRegister + " ; store the speed to X_DELTA\n");
            s.append("\tsuba     " + (String)m.get("X_POS") + "," + indexRegister + " ; calculate the the delta of the two positions\n");
            s.append("\tbpl      " + sprite.mName + action.mName + "TargetPlayer1XGreaterNoNeg" + this.continuousNumber + "\n");
            s.append("\tnega     ; only the ABSOLUT value\n");
            s.append(sprite.mName + action.mName + "TargetPlayer1XGreaterNoNeg" + this.continuousNumber + ": \n");
            s.append(sprite.mName + action.mName + "TargetPlayer1XGreaterNoNeg" + this.continuousNumber + ": \n");
            s.append("\ttfr      a,b ; in a x delta, save it in reg b\n");
            s.append("\tasla     ; double x delta\n");
            s.append("\tcmpa     temp8bit ; compare to y delta\n");
            s.append("\tble      " + sprite.mName + action.mName + "TargetPlayer1YWayBigger" + this.continuousNumber + " ; if double X still smaller than y delta, than y delta is BiG\n");
            s.append("\tlda      temp8bit ; load y delta\n");
            s.append("\tstb      temp8bit ; store x delta\n");
            s.append("\tasla     ; double the y delta\n");
            s.append("\tcmpa     temp8bit ; compare to x delta\n");
            s.append("\tbhs      " + sprite.mName + action.mName + "TargetPlayer1Done" + this.continuousNumber + "\n");
            s.append("\tasl      " + (String)m.get("X_DELTA") + "," + indexRegister + " ; than double the X speed\n");
            s.append("\tbra      " + sprite.mName + action.mName + "TargetPlayer1Done" + this.continuousNumber + "\n");
            s.append(sprite.mName + action.mName + "TargetPlayer1YWayBigger" + this.continuousNumber + ":\n");
            s.append("\tasl      " + (String)m.get("Y_DELTA") + "," + indexRegister + " ; than double the Y speed\n");
            s.append(sprite.mName + action.mName + "TargetPlayer1Done" + this.continuousNumber + ":\n");
        }
        if (action.mbehaviour.equals("target player 2")) {
            int shotSpeed = UtilityString.IntX(action.mchangeWhileActiveY, 1);
            s.append("; --- adjust for behaviour: target player 2\n");
            s.append("; --- vertical\n");
            s.append("\tldx      main2Pointer  ; player pointer \n");
            s.append("\tlda      Y_POS,x ; current player Y position\n");
            s.append("\tsuba     " + (String)m.get("Y_POS") + "," + indexRegister + " ; delta to our position \n");
            s.append("\tbpl      " + sprite.mName + action.mName + "TargetPlayer2YDeltaNoNeg" + this.continuousNumber + " \n");
            s.append("\tnega      \n");
            s.append(sprite.mName + action.mName + "TargetPlayer2YDeltaNoNeg" + this.continuousNumber + ":\n");
            s.append("\tcmpa     #10 ; compare to shot position \n");
            s.append("\tbhs      " + sprite.mName + action.mName + "TargetPlayer2YNotTiny" + this.continuousNumber + " \n");
            s.append("\tclrb     \n");
            s.append("\tbra      " + sprite.mName + action.mName + "TargetPlayer2YDone" + this.continuousNumber + "\n");
            s.append(sprite.mName + action.mName + "TargetPlayer2YNotTiny" + this.continuousNumber + ":\n");
            s.append("\tlda      Y_POS,x ; current player Y position\n");
            s.append("\tcmpa     " + (String)m.get("Y_POS") + "," + indexRegister + " ; compare to shot position \n");
            s.append("\tbgt      " + sprite.mName + action.mName + "TargetPlayer2YGreater" + this.continuousNumber + "\n");
            s.append("\tldb      #-" + shotSpeed + " ; if lower, than negative speed\n");
            s.append("\tbra      " + sprite.mName + action.mName + "TargetPlayer2YDone" + this.continuousNumber + "\n");
            s.append(sprite.mName + action.mName + "TargetPlayer2YGreater" + this.continuousNumber + ":\n");
            s.append("\tldb      #" + shotSpeed + " ; if higher, than positive speed\n");
            s.append(sprite.mName + action.mName + "TargetPlayer2YDone" + this.continuousNumber + ":\n");
            s.append("\tstb      " + (String)m.get("Y_DELTA") + "," + indexRegister + " ; store the speed to Y_DELTA\n");
            s.append("\tsuba     " + (String)m.get("Y_POS") + "," + indexRegister + " ; calculate the the delta of the two positions\n");
            s.append("\tbpl      " + sprite.mName + action.mName + "TargetPlayer2YGreaterNoNeg" + this.continuousNumber + "\n");
            s.append("\tnega     ; only the ABSOLUT value\n");
            s.append(sprite.mName + action.mName + "TargetPlayer2YGreaterNoNeg" + this.continuousNumber + ": \n");
            s.append("\tsta      temp8bit ; and store it in tmp\n");
            s.append("; --- horizontal\n");
            s.append("\tlda      X_POS,x ; current player X position\n");
            s.append("\tsuba     " + (String)m.get("X_POS") + "," + indexRegister + " ; delta to our position \n");
            s.append("\tbpl      " + sprite.mName + action.mName + "TargetPlayer2XDeltaNoNeg" + this.continuousNumber + "\n");
            s.append("\tnega      \n");
            s.append(sprite.mName + action.mName + "TargetPlayer2XDeltaNoNeg" + this.continuousNumber + ":\n");
            s.append("\tcmpa     #10 ; compare to shot position \n");
            s.append("\tbhs      " + sprite.mName + action.mName + "TargetPlayer2XNotTiny" + this.continuousNumber + "\n");
            s.append("\tclrb     \n");
            s.append("\ttst      " + (String)m.get("Y_DELTA") + "," + indexRegister + " ; check if both directions are 0 - if so load X speed with default value\n");
            s.append("\tbne      " + sprite.mName + action.mName + "TargetPlayer2XDone" + this.continuousNumber + "\n");
            s.append("\tldb      #" + shotSpeed + "\n");
            s.append("\tbra      " + sprite.mName + action.mName + "TargetPlayer2XDone" + this.continuousNumber + "\n");
            s.append(sprite.mName + action.mName + "TargetPlayer2XNotTiny" + this.continuousNumber + ":\n");
            s.append("\tldx      main2Pointer  ; player pointer \n");
            s.append("\tlda      X_POS,x ; current player X position\n");
            s.append("\tcmpa     " + (String)m.get("X_POS") + "," + indexRegister + " ; compare to shot position \n");
            s.append("\tbgt      " + sprite.mName + action.mName + "TargetPlayer2XGreater" + this.continuousNumber + "\n");
            s.append("\tldb      #-" + shotSpeed + " ; if lower, than negative speed\n");
            s.append("\tbra      " + sprite.mName + action.mName + "TargetPlayer2XDone" + this.continuousNumber + "\n");
            s.append(sprite.mName + action.mName + "TargetPlayer2XGreater" + this.continuousNumber + ":\n");
            s.append("\tldb      #" + shotSpeed + " ; if higher, than positive speed\n");
            s.append(sprite.mName + action.mName + "TargetPlayer2XDone" + this.continuousNumber + ":\n");
            s.append("\tstb      " + (String)m.get("X_DELTA") + "," + indexRegister + " ; store the speed to X_DELTA\n");
            s.append("\tsuba     " + (String)m.get("X_POS") + "," + indexRegister + " ; calculate the the delta of the two positions\n");
            s.append("\tbpl      " + sprite.mName + action.mName + "TargetPlayer2XGreaterNoNeg" + this.continuousNumber + "\n");
            s.append("\tnega     ; only the ABSOLUT value\n");
            s.append(sprite.mName + action.mName + "TargetPlayer2XGreaterNoNeg" + this.continuousNumber + ": \n");
            s.append(sprite.mName + action.mName + "TargetPlayer2XGreaterNoNeg" + this.continuousNumber + ": \n");
            s.append("\ttfr      a,b ; in a x delta, save it in reg b\n");
            s.append("\tasla     ; double x delta\n");
            s.append("\tcmpa     temp8bit ; compare to y delta\n");
            s.append("\tble      " + sprite.mName + action.mName + "TargetPlayer2YWayBigger" + this.continuousNumber + " ; if double X still smaller than y delta, than y delta is BiG\n");
            s.append("\tlda      temp8bit ; load y delta\n");
            s.append("\tstb      temp8bit ; store x delta\n");
            s.append("\tasla     ; double the y delta\n");
            s.append("\tcmpa     temp8bit ; compare to x delta\n");
            s.append("\tbhs      " + sprite.mName + action.mName + "TargetPlayer2Done" + this.continuousNumber + "\n");
            s.append("\tasl      " + (String)m.get("X_DELTA") + "," + indexRegister + " ; than double the X speed\n");
            s.append("\tbra      " + sprite.mName + action.mName + "TargetPlayer2Done" + this.continuousNumber + "\n");
            s.append(sprite.mName + action.mName + "TargetPlayer2YWayBigger" + this.continuousNumber + ":\n");
            s.append("\tasl      " + (String)m.get("Y_DELTA") + "," + indexRegister + " ; than double the Y speed\n");
            s.append(sprite.mName + action.mName + "TargetPlayer2Done" + this.continuousNumber + ":\n");
        }
    }

    int getTimerEventIndex(ActionNewData action) {
        for (int eventCount = 0; eventCount < action.meventUID.size(); ++eventCount) {
            ActionTriggerData triggers = this.getTriggerByUID(action, action.meventUID.elementAt(eventCount));
            ActionResultData results = this.getResultByUID(action, action.meventUID.elementAt(eventCount));
            for (int triggerCount = 0; triggerCount < triggers.mtriggerByCause.size(); ++triggerCount) {
                if (!triggers.mtriggerByCause.elementAt(triggerCount).equals("timer expired")) continue;
                return eventCount;
            }
        }
        return -1;
    }

    int getLongTimerEventIndex(ActionNewData action) {
        for (int eventCount = 0; eventCount < action.meventUID.size(); ++eventCount) {
            ActionTriggerData triggers = this.getTriggerByUID(action, action.meventUID.elementAt(eventCount));
            ActionResultData results = this.getResultByUID(action, action.meventUID.elementAt(eventCount));
            for (int i = 0; i < triggers.mtriggerByCause.size(); ++i) {
                if (!triggers.mtriggerByCause.elementAt(i).equals("long timer expired")) continue;
                return eventCount;
            }
        }
        return -1;
    }

    ActionNewData getActionByID(SpriteData sprite, String actionID) {
        Collection<ActionNewData> colCa = this.mActionDataPool.getMapForKlasse(sprite.mName + "_Actions").values();
        for (ActionNewData actionData : colCa) {
            if (!actionData.mName.equals(actionID)) continue;
            return actionData;
        }
        return null;
    }

    ActionNewData getDefaultAction(SpriteData sprite) {
        ActionNewData action = this.getActionByID(sprite, sprite.mDefaultActionID);
        if (action == null) {
            ShowWarningDialog.showWarningDialog("Action is Null!", "Default sprite action is null, did you save the sprite correctly?<BR>Did you delete an action/sprite without removing it from the level?<BR> (" + sprite.mName + ")");
        }
        return action;
    }

    void addRemoveCode(StringBuilder b) {
        ++this.removeUID;
        b.append("\tleax     -(NEXT_OBJECT),s\t; in x pointer to THIS original object structure start\n");
        b.append("\tleay      ,x ; remember this in y, so we can check for followers later\n");
        b.append("\tlds      S_NEXT_OBJECT,s ; load stack with the next object to process in the list\n");
        b.append("\tsts      temp16bit ; save that temporarily\n");
        b.append("\tlds      #Vec_Default_Stk ; and enable stack usage (so we can use sub routines) \n");
        b.append("\tjsr      removeObject\t; object in X, destroys D and U\n");
        b.append("; do some work, that usually is done at the end \n");
        b.append("; of the smartlist...\n");
        b.append("\tlda      gameScale ; load ...\n");
        b.append("\tsta      <VIA_t1_cnt_lo ; and set the default movement scale\n");
        b.append("\tldb      #$cc ; reset the beam to zero\n");
        b.append("\tMY_MOVE_TO_A_END ; end the actual moving to the position of the now deleted object\n");
        b.append("\tSTb      >VIA_cntl\n");
        b.append("\tldd      #0 ; reset our VIA registers\n");
        b.append("\tstd      >VIA_port_b\n");
        b.append("; go thru all possible sprites!\n");
        b.append("RemoveStartAgain" + this.removeUID + ":\n");
        b.append("\tldx      objectlist_used_head ; load head of the object list\n");
        b.append("RemoveCompareNextObject" + this.removeUID + ":\n");
        b.append("\tcmpy        C_DATA_W,x ; does this look like a follower?\n");
        b.append("\tbne         RemoveNoFollower" + this.removeUID + "\n");
        b.append("\tjsr      removeObject\t; object in X, destroys D and U\n");
        b.append("\tbne         RemoveStartAgain" + this.removeUID + "\n");
        b.append("RemoveNoFollower" + this.removeUID + ":\n");
        b.append("\tldx      NEXT_OBJECT,x ; initiate the next possible object to test \n");
        b.append("\tcmpx     #OBJECT_LIST_COMPARE_ADDRESS; is it the end of the list?\n");
        b.append("\tbhi      RemoveCompareNextObject" + this.removeUID + " ; no - so test the next\n");
        b.append("\tlds      temp16bit ; and reload the stack value we need\n");
        b.append("\tpuls     d,pc ; and jump to the next object in the object list\n");
    }

    void addOneCompleteRemoveX(StringBuilder b, boolean stackAlreadySaved) {
        String removeAllUID = "rAllInner" + this.removeAllUID_;
        if (!stackAlreadySaved) {
            b.append("\tsts      temp16bit ; save that temporarily\n");
            b.append("\tlds      #Vec_Default_Stk ; and enable stack usage (so we can use sub routines) \n");
        }
        b.append("\tjsr      removeObject; object in X, destroys D and U\n");
        b.append(";--------------- remove followers!\n");
        b.append("; go thru all possible sprites!\n");
        b.append("RemoveStartAgain" + removeAllUID + ":\n");
        b.append("\tldx      objectlist_used_head ; load head of the object list\n");
        b.append("RemoveCompareNextObject" + removeAllUID + ":\n");
        b.append("\tcmpy        C_DATA_W,x ; does this look like a follower?\n");
        b.append("\tbne         RemoveNoFollower" + removeAllUID + "\n");
        b.append("\tjsr      removeObject\t; object in X, destroys D and U\n");
        b.append("\tbne         RemoveStartAgain" + removeAllUID + "\n");
        b.append("RemoveNoFollower" + removeAllUID + ":\n");
        b.append("\tldx      NEXT_OBJECT,x ; initiate the next possible object to test \n");
        b.append("\tcmpx     #OBJECT_LIST_COMPARE_ADDRESS; is it the end of the list?\n");
        b.append("\tbhi      RemoveCompareNextObject" + removeAllUID + " ; no - so test the next\n");
        if (!stackAlreadySaved) {
            b.append("\tlds      temp16bit ; and reload the stack value we need\n");
        }
    }

    void addRemoveAllCode(StringBuilder b, String spriteID) {
        ++this.removeAllUID_;
        String removeAllUID = "rAll" + this.removeAllUID_;
        SpriteData sprite = this.getSpriteByID(spriteID);
        int spriteUID = sprite.mspriteUID;
        b.append("\tsts      temp16bit ; save that temporarily\n");
        b.append("\tlds      #Vec_Default_Stk ; and enable stack usage (so we can use sub routines) \n");
        b.append("\tpshs y \n");
        b.append("; go thru all possible sprites!\n");
        b.append("RemoveStartAgain" + removeAllUID + ":\n");
        b.append("\tldx      objectlist_used_head ; load head of the object list\n");
        b.append("RemoveCompareNextObject" + removeAllUID + ":\n");
        b.append("\tldy      BEHAVIOUR,x ; behaviour address of the sprite\n");
        b.append("\tleay     -1,y ; spriteID is behaviour -1\n");
        b.append("\tlda      ,y ; get the spriteID\n");
        b.append("\tcmpa     #" + spriteUID + " ; is this the id we are looking for?\n");
        b.append("\tbeq      doOneRemove" + removeAllUID + " ; \n");
        b.append("\tldx      NEXT_OBJECT,x ; initiate the next possible object to test \n");
        b.append("\tcmpx     #OBJECT_LIST_COMPARE_ADDRESS; is it the end of the list?\n");
        b.append("\tbhi      RemoveCompareNextObject" + removeAllUID + " ; no - so test the next\n");
        b.append("\tjmp      RemoveAllDone" + removeAllUID + "\n");
        b.append("doOneRemove" + removeAllUID + ": ; \n");
        this.addOneCompleteRemoveX(b, true);
        b.append("\tbra      RemoveStartAgain" + removeAllUID + "\n");
        b.append("RemoveAllDone" + removeAllUID + ":\n");
        if (this.mSpriteData.mName.equals(spriteID)) {
            b.append("; I just removed myself - I don't know for sure if my following sprite is still\n");
            b.append("; valid - so I will hickup the game - and return to main!\n");
            b.append("; do some work, that usually is done at the end \n");
            b.append("; of the smartlist...\n");
            b.append("\tlda      gameScale ; load ...\n");
            b.append("\tsta      <VIA_t1_cnt_lo ; and set the default movement scale\n");
            b.append("\tldb      #$cc ; reset the beam to zero\n");
            b.append("\tMY_MOVE_TO_A_END ; end the actual moving to the position of the now deleted object\n");
            b.append("\tSTb      >VIA_cntl\n");
            b.append("\tldd      #0 ; reset our VIA registers\n");
            b.append("\tstd      >VIA_port_b\n");
            b.append("\tjmp      jmpBack1FromObjectHandling ;\n");
        } else {
            b.append("\tpuls y \n");
            b.append("\tlds      temp16bit ; get our stack back and continue\n");
        }
    }

    String functionalizeNewAction(SpriteData sprite, ActionNewData action, String indexRegister, boolean stackAlreadyPulled) {
        StringBuilder result = new StringBuilder();
        String name = "newAction_" + sprite.mName + action.mName + indexRegister + stackAlreadyPulled;
        if (this.knownFunctions.get(name) != null) {
            return name;
        }
        this.SB_additionalFunctions.append("; ----------------------------------\n");
        this.SB_additionalFunctions.append(name + ":\n");
        this.setupNewAction(this.SB_additionalFunctions, sprite, action, indexRegister, stackAlreadyPulled);
        this.SB_additionalFunctions.append("\trts\n");
        this.SB_additionalFunctions.append("; ----------------------------------\n");
        this.knownFunctions.put(name, name);
        return name;
    }

    SpriteData getSpriteByUID(int uid) {
        boolean found = false;
        SpriteData spriteFound = null;
        String klasse = this.mLevelData.mName;
        Collection<LevelObjectData> colC = this.mLevelObjectDataPool.getMapForKlasse(klasse).values();
        Iterator<LevelObjectData> iterC = colC.iterator();
        String oldName = "";
        while (iterC.hasNext()) {
            LevelObjectData levelObject = iterC.next();
            if (!levelObject.mType.equals("Sprite")) continue;
            SpriteData sprite = this.getSpriteByID(levelObject.mSpriteID);
            if (sprite.mspriteUID != uid) continue;
            if (found && !oldName.equals(sprite.mName)) {
                ShowWarningDialog.showWarningDialog("Sprite ID not UNIQUE", "Non unique sprite id in collision detection found (" + sprite.mName + "<->" + spriteFound.mName + "(" + uid + "))");
            }
            oldName = sprite.mName;
            spriteFound = sprite;
            found = true;
        }
        return spriteFound;
    }

    int[] getColDetectSpriteIDs() {
        HashMap<Integer, Integer> intA = new HashMap<Integer, Integer>();
        for (int eventCount = 0; eventCount < this.mActionData.meventUID.size(); ++eventCount) {
            ActionTriggerData triggers = this.getTriggerByUID(this.mActionData, this.mActionData.meventUID.elementAt(eventCount));
            ActionResultData results = this.getResultByUID(this.mActionData, this.mActionData.meventUID.elementAt(eventCount));
            for (int triggerCount = 0; triggerCount < triggers.mtriggerByCause.size(); ++triggerCount) {
                if (!triggers.mtriggerByCause.elementAt(triggerCount).equals("sprite collision")) continue;
                int spid = 0;
                try {
                    if (this.isPlayer(this.getSpriteByID(triggers.mtriggerBySpriteID.elementAt(triggerCount))) || this.isTriggerOnly(this.getSpriteByID(triggers.mtriggerBySpriteID.elementAt(triggerCount))) || this.isText(this.getSpriteByID(triggers.mtriggerBySpriteID.elementAt(triggerCount)))) continue;
                    spid = this.getSpriteByID((String)triggers.mtriggerBySpriteID.elementAt((int)triggerCount)).mspriteUID;
                }
                catch (Throwable e) {
                    ShowWarningDialog.showWarningDialog("Col detect sprite not found!", "Did you forget to supply a sprite ID? (sprite: " + this.mSpriteData.mName + ", action: " + this.mActionData.mName + ")");
                }
                intA.put(spid, spid);
            }
        }
        int[] ret = new int[intA.size()];
        Set entries = intA.entrySet();
        Iterator it = entries.iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Integer value = (Integer)entry.getValue();
            ret[i++] = value;
        }
        return ret;
    }

    int getMaxAllowedSprite(String spriteID) {
        String klasse = this.mLevelData.mName;
        Collection<LevelObjectData> colC = this.mLevelObjectDataPool.getMapForKlasse(klasse).values();
        Iterator<LevelObjectData> iterC = colC.iterator();
        int maxSprites = 0;
        while (iterC.hasNext()) {
            LevelObjectData o = iterC.next();
            if (!o.mType.equals("Sprite") || !o.mSpriteID.equals(spriteID)) continue;
            maxSprites += o.mMaxLiveObjects;
        }
        return maxSprites;
    }

    boolean levelHasAnalog() {
        ActionNewData player1 = this.getPlayer1();
        ActionNewData player2 = this.getPlayer2();
        if (player1 != null) {
            if (player1.mchangeWhileActiveY.contains("a")) {
                return true;
            }
            if (player1.mchangeWhileActiveX.contains("a")) {
                return true;
            }
        }
        if (player2 != null) {
            if (player2.mchangeWhileActiveY.contains("a")) {
                return true;
            }
            if (player2.mchangeWhileActiveX.contains("a")) {
                return true;
            }
        }
        return false;
    }

    void getSpawnPositionToX(int eventCount, int triggerCount, ActionNewData action, StringBuilder s, ActionNewData childAction) {
        int max;
        int min;
        int val;
        boolean p;
        boolean n;
        ActionTriggerData triggers = this.getTriggerByUID(this.mActionData, this.mActionData.meventUID.elementAt(eventCount));
        ActionResultData results = this.getResultByUID(this.mActionData, this.mActionData.meventUID.elementAt(eventCount));
        ++this.spawnPosUID;
        if (childAction.mbehaviour.equals("follow sprite")) {
            s.append("\tleax      STACK_PULL_OFFSET,s ; remember current sprites position pointer for follower\n");
            return;
        }
        String sY = results.mresultY.elementAt(0);
        String sX = results.mresultX.elementAt(0);
        int ydelta = UtilityString.IntX(sY, 300);
        int xdelta = UtilityString.IntX(sX, 300);
        if (ydelta < 300 && xdelta < 300) {
            String pos = String.format("$%04X", (ydelta * 256 & 0xFF00) + (xdelta & 0xFF));
            s.append("\tldx      #" + pos + " ; remember current position\n");
            return;
        }
        if (sY.startsWith("d") && sX.startsWith("d")) {
            sY = sY.substring(1);
            sX = sX.substring(1);
            ydelta = UtilityString.IntX(sY, 300);
            xdelta = UtilityString.IntX(sX, 300);
            if (ydelta == 0 && xdelta == 0) {
                s.append("\tldx      S_Y_POS,s ; remember current position\n");
                return;
            }
            s.append("\tldd      S_Y_POS,s ; remember current position\n");
            s.append("\tadda      #" + ydelta + " ; add y offset of spawn position \n");
            s.append("\taddb      #" + xdelta + " ; add x offset of spawn position \n");
            s.append("\ttfr      d,x ; remember current position\n");
            return;
        }
        s.append("\tldd      S_Y_POS,s ; remember current position\n");
        if (ydelta < 300) {
            String pos = String.format("$%02X", ydelta & 0xFF);
            s.append("\tlda      #" + pos + " ; remember current position\n");
        } else if (sY.startsWith("d")) {
            sY = sY.substring(1);
            ydelta = UtilityString.IntX(sY, 300);
            s.append("\tadda      #" + ydelta + " ; add y offset of spawn position \n");
        } else if (sY.startsWith("=")) {
            sY = sY.substring(1);
            s.append("\tlda      " + sY + " ; variable contents \n");
        } else if (sY.startsWith("rand")) {
            boolean pn = false;
            n = false;
            p = false;
            if ((sY = UtilityString.replace(sY, "rand", "")).contains("+-")) {
                pn = true;
            }
            if ((sY = UtilityString.replace(sY, "+-", "")).contains("-")) {
                n = true;
            }
            if ((sY = UtilityString.replace(sY, "-", "")).contains("+")) {
                p = true;
            }
            sY = UtilityString.replace(sY, "+", "");
            if (!(pn || n || p)) {
                p = true;
            }
            sY = UtilityString.replace(sY, "(", "");
            val = UtilityString.Int0(sY = UtilityString.replace(sY, ")", ""));
            if (val == 0) {
                ShowWarningDialog.showWarningDialog("Spawn Random", "Can't discern random base (Y). (" + this.mSpriteData.mName + ", action: " + this.mActionData.mName + ")");
                s.append("\tldx      #pos ; ERROR fallback return!\n");
                return;
            }
            min = 0;
            max = 0;
            if (p) {
                min = 0;
                max = val;
            }
            if (n) {
                min = -val;
                max = 0;
            }
            if (pn) {
                min = -val;
                max = val;
            }
            s.append("\tsts      temp16bit ; remember stack (current position in object list) \n");
            s.append("\tlds      #Vec_Default_Stk ; and enable stack usage (so we can use sub routines) \n");
            s.append("\tpshs d\n");
            s.append("repeatSpawnRandomY" + this.spawnPosUID + ":\n");
            s.append("\tjsr      Random ; todo replace with good random \n");
            if (p) {
                s.append("\tanda     #%01111111; max 127 \n");
            }
            if (n) {
                s.append("\tora     #%10000000; max 0 \n");
            }
            s.append("\tcmpa     #" + max + "; max  \n");
            s.append("\tbgt       repeatSpawnRandomY" + this.spawnPosUID + ";  \n");
            s.append("\tcmpa     #" + min + "; min  \n");
            s.append("\tblt       repeatSpawnRandomY" + this.spawnPosUID + ";  \n");
            s.append("\tsta temp8bit\n");
            s.append("\tpuls d\n");
            s.append("\tlds      temp16bit ; reload stack \n");
            s.append("\tlda      temp8bit\n");
        }
        if (xdelta < 300) {
            String pos = String.format("$%02X", xdelta & 0xFF);
            s.append("\tldb      #" + pos + " ; remember current position\n");
        } else if (sX.startsWith("d")) {
            sX = sX.substring(1);
            xdelta = UtilityString.IntX(sX, 300);
            s.append("\taddb      #" + xdelta + " ; add x offset of spawn position \n");
        } else if (sX.startsWith("=")) {
            sX = sX.substring(1);
            s.append("\tldb      " + sX + " ; variable contents \n");
        } else if (sX.startsWith("rand")) {
            boolean pn = false;
            n = false;
            p = false;
            if ((sX = UtilityString.replace(sX, "rand", "")).contains("+-")) {
                pn = true;
            }
            if ((sX = UtilityString.replace(sX, "+-", "")).contains("-")) {
                n = true;
            }
            if ((sX = UtilityString.replace(sX, "-", "")).contains("+")) {
                p = true;
            }
            sX = UtilityString.replace(sX, "+", "");
            if (!(pn || n || p)) {
                p = true;
            }
            sX = UtilityString.replace(sX, "(", "");
            val = UtilityString.Int0(sX = UtilityString.replace(sX, ")", ""));
            if (val == 0) {
                ShowWarningDialog.showWarningDialog("Spawn Random", "Can't discern random base (X). (" + this.mSpriteData.mName + ", action: " + this.mActionData.mName + ")");
                s.append("\tldx      #pos ; ERROR fallback return!\n");
                return;
            }
            min = 0;
            max = 0;
            if (p) {
                min = 0;
                max = val;
            }
            if (n) {
                min = -val;
                max = 0;
            }
            if (pn) {
                min = -val;
                max = val;
            }
            s.append("\tsts      temp16bit ; remember stack (current position in object list) \n");
            s.append("\tlds      #Vec_Default_Stk ; and enable stack usage (so we can use sub routines) \n");
            s.append("\tpshs d\n");
            s.append("repeatSpawnRandomX" + this.spawnPosUID + ":\n");
            s.append("\tjsr      Random ; todo replace with good random \n");
            if (p) {
                s.append("\tanda     #%01111111; max 127 \n");
            }
            if (n) {
                s.append("\tora     #%10000000; max 0 \n");
            }
            s.append("\tcmpa     #" + max + "; max  \n");
            s.append("\tbgt       repeatSpawnRandomX" + this.spawnPosUID + ";  \n");
            s.append("\tcmpa     #" + min + "; min  \n");
            s.append("\tblt       repeatSpawnRandomX" + this.spawnPosUID + ";  \n");
            s.append("\tsta temp8bit\n");
            s.append("\tpuls d\n");
            s.append("\tlds      temp16bit ; reload stack \n");
            s.append("\tldb      temp8bit\n");
        }
        s.append("\ttfr      d,x ; remember current position\n");
    }

    boolean levelUsesIntensityInSprites() {
        Collection<LevelObjectData> colCo = this.mLevelObjectDataPool.getMapForKlasse(this.mLevelData.mName).values();
        for (LevelObjectData levelObjectData : colCo) {
            SpriteData spriteData;
            if (!levelObjectData.mType.equals("Sprite") || (spriteData = this.mSpriteDataPool.getMapForKlasse("AllSprites").get(levelObjectData.mSpriteID)) == null) continue;
            Collection<ActionNewData> colCa = this.mActionDataPool.getMapForKlasse(spriteData.mName + "_Actions").values();
            for (ActionNewData actionData : colCa) {
                if (actionData.mbehaviour.equals("text") || actionData.mintensity.length() == 0) continue;
                return true;
            }
        }
        return false;
    }

    String buildSmartlistFunctionsAlternate1(HashMap<String, String> smartlistCollector) {
        StringBuilder smB = new StringBuilder();
        String START_T1_AGAIN_MOVE = "START_T1_AGAIN_MOVE             macro\n\tnop 2\n\tsta      <VIA_t1_cnt_hi               ;[4] Clear T1H\n\tendm\n";
        String START_T1_AGAIN_DRAW = "START_T1_AGAIN_DRAW             macro\n\tnop 2\n\tsta      <VIA_t1_cnt_hi               ;[4] Clear T1H\n\tendm\n";
        String START_T1 = "START_T1             macro\n\tsta      <VIA_t1_cnt_hi               ;[4] Clear T1H\n\tendm\n";
        String START_T1_B = "START_T1_B             macro\n\tstb      <VIA_t1_cnt_hi               ;[4] Clear T1H\n\tendm\n";
        String PULL_NEXT_LINE = "PULL_NEXT_LINE             macro\n\tpulu     d,pc                         ;[9] \n\tendm\n";
        String LAST_DRAW_RTS2 = "SM_lastDraw_rts2                                        ;#isfunction  \n\tSET_SHIFT_END  \n\tlda      gameScale \n\tsta      <VIA_t1_cnt_lo \n\tldb      #$cc \n\tSTb      <VIA_cntl                    ;/BLANK low and /ZERO low \n\tLDB     #$01\n\tSTB     <VIA_port_b     ;disable mux\n\tpuls     d,pc                         ; (D = y,x, pc = next object) \n";
        String LAST_DRAW_RTS = "SM_lastDraw_rts                                        ;#isfunction  \n\tSET_SHIFT_END  \n\tlda      gameScale \n\tsta      <VIA_t1_cnt_lo \n\tldb      #$cc \n\tSTb      <VIA_cntl                    ;/BLANK low and /ZERO low \n\tLDB     #$01\n\tSTB     <VIA_port_b     ;disable mux\n\trts \n";
        String TH_MOVE_START_Y_X = "TH_MOVE_START_Y_X             macro\n\tSTA      <VIA_port_a                  ;[4] Send Y to A/D\n\tclra                                  ;[2]\n\tsta      <VIA_port_b                  ;[4] Enable mux\n\tinca; [2]\tnop ;[2] - delay\texg a,a; [6]\tstd <VIA_port_b [5]\tnop ;[2] - delay\tnop ;[2] - delay\tbrn 0; [3]\tdeca; [2]\tsta      <VIA_t1_cnt_hi               ;[4] Clear T1H\n\tendm\n";
        String TH_DRAW_START_Y_X = "TH_DRAW_START_Y_X             macro\n\tSTA      <VIA_port_a                  ;[4] Send Y to A/D\n\tclra                                  ;[2]\n\tsta      <VIA_port_b                  ;[4] Enable mux\n\tinca; [2]\tnop ;[2] - delay\tnop ;[2] - delay\tsta <VIA_shift_reg [4]\tstd <VIA_port_b [5]\tdeca; [2]\tsta      <VIA_t1_cnt_hi               ;[4] Clear T1H\n\tendm\n";
        String TH_WAIT_CONT = "TH_WAIT_CONT              macro\n\texg a,a; [6]\texg a,a; [6]\texg a,a; [6]\tendm\n";
        String TH_DRAW_CONT = "TH_DRAW_CONT             macro\n\tSTA      <VIA_port_a                  ;[4] Send Y to A/D\n\tclra                                  ;[2]\n\tsta      <VIA_port_b                  ;[4] Enable mux\n\tinca; [2]\n ldx #10*256+0; [3]\tnop ;[2] - delay\tstd <VIA_port_b [5]\tstx      <VIA_t1_cnt_lo               ;[5] Clear T1H\n\tendm\n";
        String TH_DRAW_END = "TH_DRAW_END             macro\n\texg a,a; [6]\texg a,a; [6]\texg a,a; [6]\tnop; [2]\tLDA      #$f0                  ;[2]\n\tnop; [2]\tbrn 0; [3]\tsta <VIA_shift_reg [4]\tendm\n";
        smB.append("\tnoopt\n");
        smB.append(TH_MOVE_START_Y_X);
        smB.append(TH_DRAW_START_Y_X);
        smB.append(TH_WAIT_CONT);
        smB.append(TH_DRAW_CONT);
        smB.append(TH_DRAW_END);
        smB.append(START_T1);
        smB.append(START_T1_AGAIN_MOVE);
        smB.append(START_T1_AGAIN_DRAW);
        smB.append(START_T1_B);
        smB.append(PULL_NEXT_LINE);
        GenerationParameters p = new GenerationParameters();
        p.compileForVB = true;
        p.rts2 = false;
        p.paraName = "Example";
        p.doNoPositionMove = false;
        this.veccy.setParameters(p);
        String prefix = this.veccy.functionPrefix;
        String[] types = new String[]{"startMove", "startDraw", "continue_draw", "continue_move"};
        for (int ii = 0; ii < 4; ++ii) {
            Set<Map.Entry<String, String>> entries = smartlistCollector.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                int i;
                String fName = entry.getValue();
                String n = UtilityString.replace(fName, prefix, "");
                String drawType = "";
                String delayInfo = "";
                int sequenceCount = 0;
                String optimization = "";
                String countAdd = "";
                if (n.startsWith("startMove")) {
                    drawType = "startMove";
                }
                if (n.startsWith("startDraw")) {
                    drawType = "startDraw";
                }
                if (n.startsWith("continue_draw")) {
                    drawType = "continue_draw";
                }
                if (n.startsWith("continue_move")) {
                    drawType = "continue_move";
                }
                if ((n = UtilityString.replace(n, drawType, "")).startsWith("_yd4")) {
                    delayInfo = "_yd4";
                }
                if ((n = UtilityString.replace(n, delayInfo, "")).length() > 0) {
                    sequenceCount = UtilityString.Int0(n.substring(0, 1));
                }
                if (sequenceCount > 0) {
                    n = n.substring(1);
                }
                if (n.startsWith("_newY_eq_oldX")) {
                    optimization = "_newY_eq_oldX";
                }
                if (n.startsWith("_yEqx")) {
                    optimization = "_yEqx";
                }
                if (n.startsWith("_x0")) {
                    optimization = "_x0";
                }
                if (n.startsWith("_y0")) {
                    optimization = "_y0";
                }
                if (n.startsWith("_xyStays")) {
                    optimization = "_xyStays";
                }
                if (n.startsWith("_yStays")) {
                    optimization = "_yStays";
                }
                n = UtilityString.replace(n, optimization, "");
                int sameCount = 0;
                if (n.startsWith("_multi")) {
                    if (n.length() >= 8) {
                        sameCount = UtilityString.Int0(n.substring(6, 8));
                        if (sameCount <= 0) {
                            sameCount = UtilityString.Int0(n.substring(6, 7));
                        }
                    } else if (n.length() >= 1) {
                        sameCount = UtilityString.Int0(n.substring(6, 7));
                    }
                    countAdd = "_multi" + sameCount;
                    n = UtilityString.replace(n, countAdd, "");
                }
                boolean decode = false;
                if (fName.startsWith(prefix + "setIntensity")) {
                    decode = true;
                    System.out.println("FN: " + fName + " decoded to: '" + prefix + "' + 'setIntensity'");
                } else if (fName.startsWith(prefix + "lastDraw_rts2")) {
                    decode = true;
                    System.out.println("FN: " + fName + " decoded to: '" + prefix + "' + 'lastDraw_rts2'");
                } else if (fName.startsWith(prefix + "lastDraw_rts")) {
                    decode = true;
                    System.out.println("FN: " + fName + " decoded to: '" + prefix + "' + 'lastDraw_rts'");
                } else if (fName.startsWith(prefix + "LightOff_Intensity")) {
                    decode = true;
                    System.out.println("FN: " + fName + " decoded to: '" + prefix + "' + 'LightOff_Intensity'");
                }
                if (decode) continue;
                if (n.length() != 0) {
                    ShowWarningDialog.showWarningDialog("Function name unresolved!", "Smartlist function name could not be decoded (" + fName + ")");
                    continue;
                }
                System.out.println("FN: " + fName + " decoded to: '" + prefix + "' + '" + drawType + "' + '" + delayInfo + "' + '" + sequenceCount + "' + '" + optimization + "' + '" + countAdd + "'");
                fName = UtilityString.replace(fName, "_yd4", "");
                String bName = prefix + drawType + "_yd4" + optimization + countAdd;
                String oName = prefix + drawType + optimization + countAdd;
                if (this.mSmartListDone.containsKey(fName)) continue;
                if (drawType.equals("startMove") && types[ii].equals("startMove")) {
                    smB.append(bName + ":\n");
                    smB.append(oName + ":\n");
                    smB.append("\tSET_SHIFT_END\n");
                    this.addOpto(smB, optimization, false);
                    if (sameCount > 1) {
                        smB.append("\tjmp      again_sm" + (sameCount - 1) + "\n");
                    } else {
                        smB.append("\tPULL_NEXT_LINE\n");
                    }
                    if (!this.mSmartListDone.containsKey("startMove_multi" + MAX_NUM_GEN)) {
                        smB.append(drawType + "_multi" + MAX_NUM_GEN + ":\n");
                        smB.append("\tSET_SHIFT_END\n");
                        this.addOpto(smB, "", false);
                        smB.append("\tjmp again_sm" + (MAX_NUM_GEN - 1) + "\n");
                        for (i = MAX_NUM_GEN - 1; i >= 1; --i) {
                            smB.append("again_sm" + i + ":\n");
                            smB.append("\tnop\n");
                            if (i != 1) {
                                smB.append("\tSTART_T1_AGAIN_MOVE\n");
                                smB.append("\tjmp again_sm" + (i - 1) + "\n");
                                continue;
                            }
                            smB.append("\tSTART_T1_AGAIN_MOVE_LAST\n");
                        }
                        smB.append("\tPULL_NEXT_LINE\n");
                        this.mSmartListDone.put("startMove_multi" + MAX_NUM_GEN, "startMove_multi" + MAX_NUM_GEN);
                    }
                    this.mSmartListDone.put(fName, fName);
                    continue;
                }
                if (drawType.equals("startDraw") && types[ii].equals("startDraw")) {
                    smB.append(bName + ":\n");
                    smB.append(oName + ":\n");
                    this.addOpto(smB, optimization, true);
                    if (sameCount > 1) {
                        smB.append("\tjmp      again_sd" + (sameCount - 1) + "\n");
                    } else {
                        smB.append("\tPULL_NEXT_LINE\n");
                    }
                    if (!this.mSmartListDone.containsKey("startDraw_multi" + MAX_NUM_GEN)) {
                        smB.append(drawType + "_multi" + MAX_NUM_GEN + ":\n");
                        this.addOpto(smB, "", false);
                        smB.append("\tjmp again_sd" + (MAX_NUM_GEN - 1) + "\n");
                        for (i = MAX_NUM_GEN - 1; i >= 1; --i) {
                            smB.append("again_sd" + i + ":\n");
                            smB.append("\tnop\n");
                            if (i != 1) {
                                smB.append("\tSTART_T1_AGAIN_DRAW\n");
                                smB.append("\tjmp again_sd" + (i - 1) + "\n");
                                continue;
                            }
                            smB.append("\tSTART_T1_AGAIN_DRAW_LAST\n");
                        }
                        smB.append("\tPULL_NEXT_LINE\n");
                        this.mSmartListDone.put("startDraw_multi" + MAX_NUM_GEN, "startDraw_multi" + MAX_NUM_GEN);
                    }
                    this.mSmartListDone.put(fName, fName);
                    continue;
                }
                if (drawType.equals("continue_draw") && types[ii].equals("continue_draw")) {
                    smB.append(bName + ":\n");
                    smB.append(oName + ":\n");
                    if (!optimization.equals("_xyStays")) {
                        smB.append("\tSET_SHIFT_END\n");
                        this.addOpto(smB, optimization, true);
                    } else {
                        this.addOpto(smB, optimization, false);
                    }
                    if (sameCount > 1) {
                        smB.append("\tjmp      again_cd" + (sameCount - 1) + "\n");
                    } else {
                        smB.append("\tPULL_NEXT_LINE\n");
                    }
                    if (!this.mSmartListDone.containsKey("continue_draw_multi" + MAX_NUM_GEN)) {
                        smB.append(drawType + "_multi" + MAX_NUM_GEN + ":\n");
                        if (!optimization.equals("_xyStays")) {
                            smB.append("\tSET_SHIFT_END\n");
                            this.addOpto(smB, "", false);
                        } else {
                            this.addOpto(smB, optimization, false);
                        }
                        smB.append("\tjmp again_cd" + (MAX_NUM_GEN - 1) + "\n");
                        for (i = MAX_NUM_GEN - 1; i >= 1; --i) {
                            smB.append("again_cd" + i + ":\n");
                            smB.append("\tnop\n");
                            if (i != 1) {
                                smB.append("\tSTART_T1_AGAIN_DRAW\n");
                                smB.append("\tjmp again_cd" + (i - 1) + "\n");
                                continue;
                            }
                            smB.append("\tSTART_T1_AGAIN_DRAW_LAST\n");
                        }
                        smB.append("\tPULL_NEXT_LINE\n");
                        this.mSmartListDone.put("continue_draw_multi" + MAX_NUM_GEN, "continue_draw_multi" + MAX_NUM_GEN);
                    }
                    this.mSmartListDone.put(fName, fName);
                    continue;
                }
                if (!drawType.equals("continue_move") || !types[ii].equals("continue_move")) continue;
                smB.append(bName + ":\n");
                smB.append(oName + ":\n");
                this.addOpto(smB, optimization, false);
                if (sameCount > 1) {
                    smB.append("\tjmp      again_cm" + (sameCount - 1) + "\n");
                } else {
                    smB.append("\tPULL_NEXT_LINE\n");
                }
                if (!this.mSmartListDone.containsKey("continue_move_multi" + MAX_NUM_GEN)) {
                    smB.append(drawType + "_multi" + MAX_NUM_GEN + ":\n");
                    this.addOpto(smB, "", false);
                    smB.append("\tjmp again_cm" + (MAX_NUM_GEN - 1) + "\n");
                    for (i = MAX_NUM_GEN - 1; i >= 1; --i) {
                        smB.append("again_cm" + i + ":\n");
                        smB.append("\tnop\n");
                        if (i != 1) {
                            smB.append("\tSTART_T1_AGAIN_MOVE\n");
                            smB.append("\tjmp again_cm" + (i - 1) + "\n");
                            continue;
                        }
                        smB.append("\tSTART_T1_AGAIN_MOVE_LAST\n");
                    }
                    smB.append("\tPULL_NEXT_LINE\n");
                    this.mSmartListDone.put("continue_move_multi" + MAX_NUM_GEN, "continue_movemulti" + MAX_NUM_GEN);
                }
                this.mSmartListDone.put(fName, fName);
            }
        }
        smB.append("\topt\n");
        smB.append(LAST_DRAW_RTS2);
        smB.append(LAST_DRAW_RTS);
        return smB.toString();
    }

    String buildSmartlistFunctionsAlternate2(HashMap<String, String> smartlistCollector) {
        smartlistCollector.put("SM_continue_move_multi6", "SM_continue_move_multi6");
        smartlistCollector.put("SM_continue_draw", "SM_continue_draw");
        smartlistCollector.put("SM_continue_draw_multi2", "SM_continue_draw_multi2");
        smartlistCollector.put("SM_continue_draw_multi3", "SM_continue_draw_multi3");
        smartlistCollector.put("SM_continue_draw_multi4", "SM_continue_draw_multi4");
        smartlistCollector.put("SM_continue_draw_multi12", "SM_continue_draw_multi12");
        smartlistCollector.put("SM_continue_draw_yd4", "SM_continue_draw_yd4");
        smartlistCollector.put("SM_continue_draw_yd4_multi2", "SM_continue_draw_yd4_multi2");
        smartlistCollector.put("SM_continue_draw_yd4_multi4", "SM_continue_draw_yd4_multi4");
        smartlistCollector.put("SM_continue_draw_yd4_newY_eq_oldX", "SM_continue_draw_yd4_newY_eq_oldX");
        smartlistCollector.put("SM_continue_draw_yd4_yEqx", "SM_continue_draw_yd4_yEqx");
        smartlistCollector.put("SM_startDraw", "SM_startDraw");
        smartlistCollector.put("SM_startDraw_multi2", "SM_startDraw_multi2");
        smartlistCollector.put("SM_startDraw_yd4_multi3", "SM_startDraw_yd4_multi3");
        smartlistCollector.put("SM_startMove", "SM_startMove");
        smartlistCollector.put("SM_startMove_multi2", "SM_startMove_multi2");
        smartlistCollector.put("SM_startMove_multi6", "SM_startMove_multi6");
        smartlistCollector.put("SM_continue_move_multi3", "SM_continue_move_multi3");
        smartlistCollector.put("SM_startDraw_multi8", "SM_startDraw_multi8");
        smartlistCollector.put("SM_startDraw_yd4_multi8", "SM_startDraw_yd4_multi8");
        smartlistCollector.put("SM_startDraw_yd4_multi16", "SM_startDraw_yd4_multi16");
        smartlistCollector.put("SM_startMove_multi16", "SM_startMove_multi16");
        smartlistCollector.put("SM_startMove_yd4_multi16", "SM_startMove_yd4_multi16");
        smartlistCollector.put("SM_continue_draw_multi6", "SM_continue_draw_multi6");
        smartlistCollector.put("SM_continue_draw_multi8", "SM_continue_draw_multi8");
        smartlistCollector.put("SM_continue_move_multi12", "SM_continue_move_multi12");
        smartlistCollector.put("SM_continue_move_multi16", "SM_continue_move_multi16");
        smartlistCollector.put("SM_startDraw_multi6", "SM_startDraw_multi6");
        smartlistCollector.put("SM_continue_draw_multi16", "SM_continue_draw_multi16");
        smartlistCollector.put("SM_startDraw_multi12", "SM_startDraw_multi12");
        StringBuilder smB = new StringBuilder();
        String SET_Y_X = "SET_Y_X             macro\n\tSTA      <VIA_port_a                  ;[4] Send Y to A/D\n\tclra                                  ;[2]\n\tsta      <VIA_port_b                  ;[4] Enable mux\n\tINC      <VIA_port_b                  ;[6] Disable mux\n\tSTB      <VIA_port_a                  ;[4] Send X to A/D\n\tendm\n";
        String SET_YSTAYS_X = "SET_YSTAYS_X             macro\n\t                                      ;[] A is generated to 0\n\tnop 4                                 ;[8]\n\tSTB      <VIA_port_a                  ;[4] Send X to A/D\n\tendm\n";
        String SET_Y_EQUOLD_X = "SET_Y_EQUOLD_X             macro\n\t                                      ;[] A is generated to 0\n\tsta      <VIA_port_b                  ;[4] Enable mux\n\tINC      <VIA_port_b                  ;[6] Disable mux\n\tSTB      <VIA_port_a                  ;[4] Send X to A/D\n\tendm\n";
        String SET_Y_EQU_X = "SET_Y_EQU_X             macro\n\t                                      ;[ ] A is generated to 0\n\tSTB      <VIA_port_a                  ;[4] Send Y to A/D\n\tsta      <VIA_port_b                  ;[4] Enable mux\n\tINC      <VIA_port_b                  ;[6] Disable mux\n\tendm\n";
        String SET_Y_X0 = "SET_Y_X0             macro\n\tSTA      <VIA_port_a                  ;[4] Send Y to A/D\n\tstb      <VIA_port_b                  ;[4] Enable mux\n\tINC      <VIA_port_b                  ;[6] Disable mux\n\tSTB      <VIA_port_a                  ;[4] Send X to A/D\n\tendm\n";
        String SET_Y0_X = "SET_Y0_X             macro\n\tSTA      <VIA_port_a                  ;[4] Send Y to A/D\n\tsta      <VIA_port_b                  ;[4] Enable mux\n\tINC      <VIA_port_b                  ;[6] Disable mux\n\tSTB      <VIA_port_a                  ;[4] Send X to A/D\n\tendm\n";
        String SET_SHIFT_START = "SET_SHIFT_START             macro\n\tsty      <VIA_shift_reg               ;[4] Store pattern in shift register \n\tendm\n";
        String SET_SHIFT_END = "SET_SHIFT_END             macro\n\tstx      <VIA_shift_reg               ;[5, but shift after 4!] \n\tendm\n";
        String START_T1_AGAIN_MOVE = "START_T1_AGAIN_MOVE             macro\n\tnop 2\n\tsta      <VIA_t1_cnt_hi               ;[4] Clear T1H\n\tendm\n";
        String START_T1_AGAIN_DRAW = "START_T1_AGAIN_DRAW             macro\n\tnop 2\n\tsta      <VIA_t1_cnt_hi               ;[4] Clear T1H\n\tendm\n";
        String START_T1_AGAIN_MOVE_LAST = "START_T1_AGAIN_MOVE_LAST             macro\n\tnop 2\n\tsta      <VIA_t1_cnt_hi               ;[4] Clear T1H\n\tendm\n";
        String START_T1_AGAIN_DRAW_LAST = "START_T1_AGAIN_DRAW_LAST             macro\n\tnop 2\n\tsta      <VIA_t1_cnt_hi               ;[4] Clear T1H\n\tendm\n";
        String START_T1 = "START_T1             macro\n\tsta      <VIA_t1_cnt_hi               ;[4] Clear T1H\n\tendm\n";
        String START_T1_B = "START_T1_B             macro\n\tstb      <VIA_t1_cnt_hi               ;[4] Clear T1H\n\tendm\n";
        String PULL_NEXT_LINE = "PULL_NEXT_LINE             macro\n\tpulu     d,pc                         ;[9] \n\tendm\n";
        String LAST_DRAW_RTS2 = "SM_lastDraw_rts2                                        ;#isfunction  \n\tSET_SHIFT_END  \n\tlda      gameScale \n\tsta      <VIA_t1_cnt_lo \n\tldb      #$cc \n\tSTb      <VIA_cntl                    ;/BLANK low and /ZERO low \n\tLDB     #$01\n\tSTB     <VIA_port_b     ;disable mux\n\tpuls     d,pc                         ; (D = y,x, pc = next object) \n";
        String LAST_DRAW_RTS = "SM_lastDraw_rts                                        ;#isfunction  \n\tSET_SHIFT_END  \n\tlda      gameScale \n\tsta      <VIA_t1_cnt_lo \n\tldb      #$cc \n\tSTb      <VIA_cntl                    ;/BLANK low and /ZERO low \n\tLDB     #$01\n\tSTB     <VIA_port_b     ;disable mux\n\trts \n";
        smB.append("\tnoopt\n");
        smB.append(SET_Y_X);
        smB.append(SET_YSTAYS_X);
        smB.append(SET_Y_EQUOLD_X);
        smB.append(SET_Y_EQU_X);
        smB.append(SET_Y_X0);
        smB.append(SET_Y0_X);
        smB.append(SET_SHIFT_START);
        smB.append(SET_SHIFT_END);
        smB.append(START_T1);
        smB.append(START_T1_AGAIN_MOVE);
        smB.append(START_T1_AGAIN_DRAW);
        smB.append(START_T1_AGAIN_MOVE_LAST);
        smB.append(START_T1_AGAIN_DRAW_LAST);
        smB.append(START_T1_B);
        smB.append(PULL_NEXT_LINE);
        GenerationParameters p = new GenerationParameters();
        p.compileForVB = true;
        p.rts2 = false;
        p.paraName = "Example";
        p.doNoPositionMove = false;
        this.veccy.setParameters(p);
        String prefix = this.veccy.functionPrefix;
        String[] types = new String[]{"startMove", "startDraw", "continue_draw", "continue_move"};
        for (int ii = 0; ii < 4; ++ii) {
            Set<Map.Entry<String, String>> entries = smartlistCollector.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                int i;
                String fName = entry.getValue();
                String n = UtilityString.replace(fName, prefix, "");
                String drawType = "";
                String delayInfo = "";
                int sequenceCount = 0;
                String optimization = "";
                String countAdd = "";
                if (n.startsWith("startMove")) {
                    drawType = "startMove";
                }
                if (n.startsWith("startDraw")) {
                    drawType = "startDraw";
                }
                if (n.startsWith("continue_draw")) {
                    drawType = "continue_draw";
                }
                if (n.startsWith("continue_move")) {
                    drawType = "continue_move";
                }
                if ((n = UtilityString.replace(n, drawType, "")).startsWith("_yd4")) {
                    delayInfo = "_yd4";
                }
                if ((n = UtilityString.replace(n, delayInfo, "")).length() > 0) {
                    sequenceCount = UtilityString.Int0(n.substring(0, 1));
                }
                if (sequenceCount > 0) {
                    n = n.substring(1);
                }
                if (n.startsWith("_newY_eq_oldX")) {
                    optimization = "_newY_eq_oldX";
                }
                if (n.startsWith("_yEqx")) {
                    optimization = "_yEqx";
                }
                if (n.startsWith("_x0")) {
                    optimization = "_x0";
                }
                if (n.startsWith("_y0")) {
                    optimization = "_y0";
                }
                if (n.startsWith("_xyStays")) {
                    optimization = "_xyStays";
                }
                if (n.startsWith("_yStays")) {
                    optimization = "_yStays";
                }
                n = UtilityString.replace(n, optimization, "");
                int sameCount = 0;
                if (n.startsWith("_multi")) {
                    if (n.length() >= 8) {
                        sameCount = UtilityString.Int0(n.substring(6, 8));
                        if (sameCount <= 0) {
                            sameCount = UtilityString.Int0(n.substring(6, 7));
                        }
                    } else if (n.length() >= 1) {
                        sameCount = UtilityString.Int0(n.substring(6, 7));
                    }
                    countAdd = "_multi" + sameCount;
                    n = UtilityString.replace(n, countAdd, "");
                }
                boolean decode = false;
                if (fName.startsWith(prefix + "setIntensity")) {
                    decode = true;
                    System.out.println("FN: " + fName + " decoded to: '" + prefix + "' + 'setIntensity'");
                } else if (fName.startsWith(prefix + "lastDraw_rts2")) {
                    decode = true;
                    System.out.println("FN: " + fName + " decoded to: '" + prefix + "' + 'lastDraw_rts2'");
                } else if (fName.startsWith(prefix + "lastDraw_rts")) {
                    decode = true;
                    System.out.println("FN: " + fName + " decoded to: '" + prefix + "' + 'lastDraw_rts'");
                } else if (fName.startsWith(prefix + "LightOff_Intensity")) {
                    decode = true;
                    System.out.println("FN: " + fName + " decoded to: '" + prefix + "' + 'LightOff_Intensity'");
                }
                if (decode) continue;
                if (n.length() != 0) {
                    ShowWarningDialog.showWarningDialog("Function name unresolved!", "Smartlist function name could not be decoded (" + fName + ")");
                    continue;
                }
                System.out.println("FN: " + fName + " decoded to: '" + prefix + "' + '" + drawType + "' + '" + delayInfo + "' + '" + sequenceCount + "' + '" + optimization + "' + '" + countAdd + "'");
                fName = UtilityString.replace(fName, "_yd4", "");
                String bName = prefix + drawType + "_yd4" + optimization + countAdd;
                String oName = prefix + drawType + optimization + countAdd;
                if (this.mSmartListDone.containsKey(fName)) continue;
                if (drawType.equals("startMove") && types[ii].equals("startMove")) {
                    smB.append(bName + ":\n");
                    smB.append(oName + ":\n");
                    smB.append("\tSET_SHIFT_END\n");
                    this.addOpto(smB, optimization, false);
                    if (sameCount > 1) {
                        smB.append("\tjmp      again_sm" + (sameCount - 1) + "\n");
                    } else {
                        smB.append("\tPULL_NEXT_LINE\n");
                    }
                    if (!this.mSmartListDone.containsKey("startMove_multi" + MAX_NUM_GEN)) {
                        smB.append(drawType + "_multi" + MAX_NUM_GEN + ":\n");
                        smB.append("\tSET_SHIFT_END\n");
                        this.addOpto(smB, "", false);
                        smB.append("\tjmp again_sm" + (MAX_NUM_GEN - 1) + "\n");
                        for (i = MAX_NUM_GEN - 1; i >= 1; --i) {
                            smB.append("again_sm" + i + ":\n");
                            smB.append("\tnop\n");
                            if (i != 1) {
                                smB.append("\tSTART_T1_AGAIN_MOVE\n");
                                smB.append("\tjmp again_sm" + (i - 1) + "\n");
                                continue;
                            }
                            smB.append("\tSTART_T1_AGAIN_MOVE_LAST\n");
                        }
                        smB.append("\tPULL_NEXT_LINE\n");
                        this.mSmartListDone.put("startMove_multi" + MAX_NUM_GEN, "startMove_multi" + MAX_NUM_GEN);
                    }
                    this.mSmartListDone.put(fName, fName);
                    continue;
                }
                if (drawType.equals("startDraw") && types[ii].equals("startDraw")) {
                    smB.append(bName + ":\n");
                    smB.append(oName + ":\n");
                    this.addOpto(smB, optimization, true);
                    if (sameCount > 1) {
                        smB.append("\tjmp      again_sd" + (sameCount - 1) + "\n");
                    } else {
                        smB.append("\tPULL_NEXT_LINE\n");
                    }
                    if (!this.mSmartListDone.containsKey("startDraw_multi" + MAX_NUM_GEN)) {
                        smB.append(drawType + "_multi" + MAX_NUM_GEN + ":\n");
                        this.addOpto(smB, "", false);
                        smB.append("\tjmp again_sd" + (MAX_NUM_GEN - 1) + "\n");
                        for (i = MAX_NUM_GEN - 1; i >= 1; --i) {
                            smB.append("again_sd" + i + ":\n");
                            smB.append("\tnop\n");
                            if (i != 1) {
                                smB.append("\tSTART_T1_AGAIN_DRAW\n");
                                smB.append("\tjmp again_sd" + (i - 1) + "\n");
                                continue;
                            }
                            smB.append("\tSTART_T1_AGAIN_DRAW_LAST\n");
                        }
                        smB.append("\tPULL_NEXT_LINE\n");
                        this.mSmartListDone.put("startDraw_multi" + MAX_NUM_GEN, "startDraw_multi" + MAX_NUM_GEN);
                    }
                    this.mSmartListDone.put(fName, fName);
                    continue;
                }
                if (drawType.equals("continue_draw") && types[ii].equals("continue_draw")) {
                    smB.append(bName + ":\n");
                    smB.append(oName + ":\n");
                    if (!optimization.equals("_xyStays")) {
                        smB.append("\tSET_SHIFT_END\n");
                        this.addOpto(smB, optimization, true);
                    } else {
                        this.addOpto(smB, optimization, false);
                    }
                    if (sameCount > 1) {
                        smB.append("\tjmp      again_cd" + (sameCount - 1) + "\n");
                    } else {
                        smB.append("\tPULL_NEXT_LINE\n");
                    }
                    if (!this.mSmartListDone.containsKey("continue_draw_multi" + MAX_NUM_GEN)) {
                        smB.append(drawType + "_multi" + MAX_NUM_GEN + ":\n");
                        if (!optimization.equals("_xyStays")) {
                            smB.append("\tSET_SHIFT_END\n");
                            this.addOpto(smB, "", false);
                        } else {
                            this.addOpto(smB, optimization, false);
                        }
                        smB.append("\tjmp again_cd" + (MAX_NUM_GEN - 1) + "\n");
                        for (i = MAX_NUM_GEN - 1; i >= 1; --i) {
                            smB.append("again_cd" + i + ":\n");
                            smB.append("\tnop\n");
                            if (i != 1) {
                                smB.append("\tSTART_T1_AGAIN_DRAW\n");
                                smB.append("\tjmp again_cd" + (i - 1) + "\n");
                                continue;
                            }
                            smB.append("\tSTART_T1_AGAIN_DRAW_LAST\n");
                        }
                        smB.append("\tPULL_NEXT_LINE\n");
                        this.mSmartListDone.put("continue_draw_multi" + MAX_NUM_GEN, "continue_draw_multi" + MAX_NUM_GEN);
                    }
                    this.mSmartListDone.put(fName, fName);
                    continue;
                }
                if (!drawType.equals("continue_move") || !types[ii].equals("continue_move")) continue;
                smB.append(bName + ":\n");
                smB.append(oName + ":\n");
                this.addOpto(smB, optimization, false);
                if (sameCount > 1) {
                    smB.append("\tjmp      again_cm" + (sameCount - 1) + "\n");
                } else {
                    smB.append("\tPULL_NEXT_LINE\n");
                }
                if (!this.mSmartListDone.containsKey("continue_move_multi" + MAX_NUM_GEN)) {
                    smB.append(drawType + "_multi" + MAX_NUM_GEN + ":\n");
                    this.addOpto(smB, "", false);
                    smB.append("\tjmp again_cm" + (MAX_NUM_GEN - 1) + "\n");
                    for (i = MAX_NUM_GEN - 1; i >= 1; --i) {
                        smB.append("again_cm" + i + ":\n");
                        smB.append("\tnop\n");
                        if (i != 1) {
                            smB.append("\tSTART_T1_AGAIN_MOVE\n");
                            smB.append("\tjmp again_cm" + (i - 1) + "\n");
                            continue;
                        }
                        smB.append("\tSTART_T1_AGAIN_MOVE_LAST\n");
                    }
                    smB.append("\tPULL_NEXT_LINE\n");
                    this.mSmartListDone.put("continue_move_multi" + MAX_NUM_GEN, "continue_movemulti" + MAX_NUM_GEN);
                }
                this.mSmartListDone.put(fName, fName);
            }
        }
        smB.append("\topt\n");
        smB.append(LAST_DRAW_RTS2);
        smB.append(LAST_DRAW_RTS);
        return smB.toString();
    }

    String buildSmartlistFunctions(HashMap<String, String> smartlistCollector) {
        if (this.alternateSmartlist == 1) {
            return this.buildSmartlistFunctionsAlternate1(smartlistCollector);
        }
        if (this.alternateSmartlist == 2) {
            return this.buildSmartlistFunctionsAlternate2(smartlistCollector);
        }
        smartlistCollector.put("SM_continue_move_multi6", "SM_continue_move_multi6");
        smartlistCollector.put("SM_continue_draw", "SM_continue_draw");
        smartlistCollector.put("SM_continue_draw_multi2", "SM_continue_draw_multi2");
        smartlistCollector.put("SM_continue_draw_multi3", "SM_continue_draw_multi3");
        smartlistCollector.put("SM_continue_draw_multi4", "SM_continue_draw_multi4");
        smartlistCollector.put("SM_continue_draw_multi12", "SM_continue_draw_multi12");
        smartlistCollector.put("SM_continue_draw_yd4", "SM_continue_draw_yd4");
        smartlistCollector.put("SM_continue_draw_yd4_multi2", "SM_continue_draw_yd4_multi2");
        smartlistCollector.put("SM_continue_draw_yd4_multi4", "SM_continue_draw_yd4_multi4");
        smartlistCollector.put("SM_continue_draw_yd4_newY_eq_oldX", "SM_continue_draw_yd4_newY_eq_oldX");
        smartlistCollector.put("SM_continue_draw_yd4_yEqx", "SM_continue_draw_yd4_yEqx");
        smartlistCollector.put("SM_startDraw", "SM_startDraw");
        smartlistCollector.put("SM_startDraw_multi2", "SM_startDraw_multi2");
        smartlistCollector.put("SM_startDraw_yd4_multi3", "SM_startDraw_yd4_multi3");
        smartlistCollector.put("SM_startMove", "SM_startMove");
        smartlistCollector.put("SM_startMove_multi2", "SM_startMove_multi2");
        smartlistCollector.put("SM_startMove_multi6", "SM_startMove_multi6");
        smartlistCollector.put("SM_continue_move_multi3", "SM_continue_move_multi3");
        smartlistCollector.put("SM_startDraw_multi8", "SM_startDraw_multi8");
        smartlistCollector.put("SM_startDraw_yd4_multi8", "SM_startDraw_yd4_multi8");
        smartlistCollector.put("SM_startDraw_yd4_multi16", "SM_startDraw_yd4_multi16");
        smartlistCollector.put("SM_startMove_multi16", "SM_startMove_multi16");
        smartlistCollector.put("SM_startMove_yd4_multi16", "SM_startMove_yd4_multi16");
        smartlistCollector.put("SM_continue_draw_multi6", "SM_continue_draw_multi6");
        smartlistCollector.put("SM_continue_draw_multi8", "SM_continue_draw_multi8");
        smartlistCollector.put("SM_continue_move_multi12", "SM_continue_move_multi12");
        smartlistCollector.put("SM_continue_move_multi16", "SM_continue_move_multi16");
        smartlistCollector.put("SM_startDraw_multi6", "SM_startDraw_multi6");
        smartlistCollector.put("SM_continue_draw_multi16", "SM_continue_draw_multi16");
        smartlistCollector.put("SM_startDraw_multi12", "SM_startDraw_multi12");
        StringBuilder smB = new StringBuilder();
        String SET_Y_X = "SET_Y_X             macro\n\tSTA      <VIA_port_a                  ;[4] Send Y to A/D\n\tclra                                  ;[2]\n\tsta      <VIA_port_b                  ;[4] Enable mux\n\tINC      <VIA_port_b                  ;[6] Disable mux\n\tSTB      <VIA_port_a                  ;[4] Send X to A/D\n\tendm\n";
        String SET_YSTAYS_X = "SET_YSTAYS_X             macro\n\t                                      ;[] A is generated to 0\n\tnop 4                                 ;[8]\n\tSTB      <VIA_port_a                  ;[4] Send X to A/D\n\tendm\n";
        String SET_Y_EQUOLD_X = "SET_Y_EQUOLD_X             macro\n\t                                      ;[] A is generated to 0\n\tsta      <VIA_port_b                  ;[4] Enable mux\n\tINC      <VIA_port_b                  ;[6] Disable mux\n\tSTB      <VIA_port_a                  ;[4] Send X to A/D\n\tendm\n";
        String SET_Y_EQU_X = "SET_Y_EQU_X             macro\n\t                                      ;[ ] A is generated to 0\n\tSTB      <VIA_port_a                  ;[4] Send Y to A/D\n\tsta      <VIA_port_b                  ;[4] Enable mux\n\tINC      <VIA_port_b                  ;[6] Disable mux\n\tendm\n";
        String SET_Y_X0 = "SET_Y_X0             macro\n\tSTA      <VIA_port_a                  ;[4] Send Y to A/D\n\tstb      <VIA_port_b                  ;[4] Enable mux\n\tINC      <VIA_port_b                  ;[6] Disable mux\n\tSTB      <VIA_port_a                  ;[4] Send X to A/D\n\tendm\n";
        String SET_Y0_X = "SET_Y0_X             macro\n\tSTA      <VIA_port_a                  ;[4] Send Y to A/D\n\tsta      <VIA_port_b                  ;[4] Enable mux\n\tINC      <VIA_port_b                  ;[6] Disable mux\n\tSTB      <VIA_port_a                  ;[4] Send X to A/D\n\tendm\n";
        String SET_SHIFT_START = "SET_SHIFT_START             macro\n\tsty      <VIA_shift_reg               ;[4] Store pattern in shift register \n\tendm\n";
        String SET_SHIFT_END = "SET_SHIFT_END             macro\n\tstx      <VIA_shift_reg               ;[5, but shift after 4!] \n\tendm\n";
        String START_T1_AGAIN_MOVE = "START_T1_AGAIN_MOVE             macro\n\tnop 2\n\tsta      <VIA_t1_cnt_hi               ;[4] Clear T1H\n\tendm\n";
        String START_T1_AGAIN_DRAW = "START_T1_AGAIN_DRAW             macro\n\tnop 2\n\tsta      <VIA_t1_cnt_hi               ;[4] Clear T1H\n\tendm\n";
        String START_T1_AGAIN_MOVE_LAST = "START_T1_AGAIN_MOVE_LAST             macro\n\tnop 2\n\tsta      <VIA_t1_cnt_hi               ;[4] Clear T1H\n\tendm\n";
        String START_T1_AGAIN_DRAW_LAST = "START_T1_AGAIN_DRAW_LAST             macro\n\tnop 2\n\tsta      <VIA_t1_cnt_hi               ;[4] Clear T1H\n\tendm\n";
        String START_T1 = "START_T1             macro\n\tsta      <VIA_t1_cnt_hi               ;[4] Clear T1H\n\tendm\n";
        String START_T1_B = "START_T1_B             macro\n\tstb      <VIA_t1_cnt_hi               ;[4] Clear T1H\n\tendm\n";
        String PULL_NEXT_LINE = "PULL_NEXT_LINE             macro\n\tpulu     d,pc                         ;[9] \n\tendm\n";
        String LAST_DRAW_RTS2 = "SM_lastDraw_rts2                                        ;#isfunction  \n\tSET_SHIFT_END  \n\tlda      gameScale \n\tsta      <VIA_t1_cnt_lo \n\tldb      #$cc \n\tSTb      <VIA_cntl                    ;/BLANK low and /ZERO low \n\tLDB     #$01\n\tSTB     <VIA_port_b     ;disable mux\n\tpuls     d,pc                         ; (D = y,x, pc = next object) \n";
        String LAST_DRAW_RTS = "SM_lastDraw_rts                                        ;#isfunction  \n\tSET_SHIFT_END  \n\tlda      gameScale \n\tsta      <VIA_t1_cnt_lo \n\tldb      #$cc \n\tSTb      <VIA_cntl                    ;/BLANK low and /ZERO low \n\tLDB     #$01\n\tSTB     <VIA_port_b     ;disable mux\n\trts \n";
        smB.append("\tnoopt\n");
        smB.append(SET_Y_X);
        smB.append(SET_YSTAYS_X);
        smB.append(SET_Y_EQUOLD_X);
        smB.append(SET_Y_EQU_X);
        smB.append(SET_Y_X0);
        smB.append(SET_Y0_X);
        smB.append(SET_SHIFT_START);
        smB.append(SET_SHIFT_END);
        smB.append(START_T1);
        smB.append(START_T1_AGAIN_MOVE);
        smB.append(START_T1_AGAIN_DRAW);
        smB.append(START_T1_AGAIN_MOVE_LAST);
        smB.append(START_T1_AGAIN_DRAW_LAST);
        smB.append(START_T1_B);
        smB.append(PULL_NEXT_LINE);
        GenerationParameters p = new GenerationParameters();
        p.compileForVB = true;
        p.rts2 = false;
        p.paraName = "Example";
        p.doNoPositionMove = false;
        this.veccy.setParameters(p);
        String prefix = this.veccy.functionPrefix;
        String[] types = new String[]{"startMove", "startDraw", "continue_draw", "continue_move"};
        for (int ii = 0; ii < 4; ++ii) {
            Set<Map.Entry<String, String>> entries = smartlistCollector.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                int i;
                String fName = entry.getValue();
                String n = UtilityString.replace(fName, prefix, "");
                String drawType = "";
                String delayInfo = "";
                int sequenceCount = 0;
                String optimization = "";
                String countAdd = "";
                if (n.startsWith("startMove")) {
                    drawType = "startMove";
                }
                if (n.startsWith("startDraw")) {
                    drawType = "startDraw";
                }
                if (n.startsWith("continue_draw")) {
                    drawType = "continue_draw";
                }
                if (n.startsWith("continue_move")) {
                    drawType = "continue_move";
                }
                if ((n = UtilityString.replace(n, drawType, "")).startsWith("_yd4")) {
                    delayInfo = "_yd4";
                }
                if ((n = UtilityString.replace(n, delayInfo, "")).length() > 0) {
                    sequenceCount = UtilityString.Int0(n.substring(0, 1));
                }
                if (sequenceCount > 0) {
                    n = n.substring(1);
                }
                if (n.startsWith("_newY_eq_oldX")) {
                    optimization = "_newY_eq_oldX";
                }
                if (n.startsWith("_yEqx")) {
                    optimization = "_yEqx";
                }
                if (n.startsWith("_x0")) {
                    optimization = "_x0";
                }
                if (n.startsWith("_y0")) {
                    optimization = "_y0";
                }
                if (n.startsWith("_xyStays")) {
                    optimization = "_xyStays";
                }
                if (n.startsWith("_yStays")) {
                    optimization = "_yStays";
                }
                n = UtilityString.replace(n, optimization, "");
                int sameCount = 0;
                if (n.startsWith("_multi")) {
                    if (n.length() >= 8) {
                        sameCount = UtilityString.Int0(n.substring(6, 8));
                        if (sameCount <= 0) {
                            sameCount = UtilityString.Int0(n.substring(6, 7));
                        }
                    } else if (n.length() >= 1) {
                        sameCount = UtilityString.Int0(n.substring(6, 7));
                    }
                    countAdd = "_multi" + sameCount;
                    n = UtilityString.replace(n, countAdd, "");
                }
                boolean decode = false;
                if (fName.startsWith(prefix + "setIntensity")) {
                    decode = true;
                    System.out.println("FN: " + fName + " decoded to: '" + prefix + "' + 'setIntensity'");
                } else if (fName.startsWith(prefix + "lastDraw_rts2")) {
                    decode = true;
                    System.out.println("FN: " + fName + " decoded to: '" + prefix + "' + 'lastDraw_rts2'");
                } else if (fName.startsWith(prefix + "lastDraw_rts")) {
                    decode = true;
                    System.out.println("FN: " + fName + " decoded to: '" + prefix + "' + 'lastDraw_rts'");
                } else if (fName.startsWith(prefix + "LightOff_Intensity")) {
                    decode = true;
                    System.out.println("FN: " + fName + " decoded to: '" + prefix + "' + 'LightOff_Intensity'");
                }
                if (decode) continue;
                if (n.length() != 0) {
                    ShowWarningDialog.showWarningDialog("Function name unresolved!", "Smartlist function name could not be decoded (" + fName + ")");
                    continue;
                }
                System.out.println("FN: " + fName + " decoded to: '" + prefix + "' + '" + drawType + "' + '" + delayInfo + "' + '" + sequenceCount + "' + '" + optimization + "' + '" + countAdd + "'");
                fName = UtilityString.replace(fName, "_yd4", "");
                String bName = prefix + drawType + "_yd4" + optimization + countAdd;
                String oName = prefix + drawType + optimization + countAdd;
                if (this.mSmartListDone.containsKey(fName)) continue;
                if (drawType.equals("startMove") && types[ii].equals("startMove")) {
                    smB.append(bName + ":\n");
                    smB.append(oName + ":\n");
                    smB.append("\tSET_SHIFT_END\n");
                    this.addOpto(smB, optimization, false);
                    if (sameCount > 1) {
                        smB.append("\tjmp      again_sm" + (sameCount - 1) + "\n");
                    } else {
                        smB.append("\tPULL_NEXT_LINE\n");
                    }
                    if (!this.mSmartListDone.containsKey("startMove_multi" + MAX_NUM_GEN)) {
                        smB.append(drawType + "_multi" + MAX_NUM_GEN + ":\n");
                        smB.append("\tSET_SHIFT_END\n");
                        this.addOpto(smB, "", false);
                        smB.append("\tjmp again_sm" + (MAX_NUM_GEN - 1) + "\n");
                        for (i = MAX_NUM_GEN - 1; i >= 1; --i) {
                            smB.append("again_sm" + i + ":\n");
                            smB.append("\tnop\n");
                            if (i != 1) {
                                smB.append("\tSTART_T1_AGAIN_MOVE\n");
                                smB.append("\tjmp again_sm" + (i - 1) + "\n");
                                continue;
                            }
                            smB.append("\tSTART_T1_AGAIN_MOVE_LAST\n");
                        }
                        smB.append("\tPULL_NEXT_LINE\n");
                        this.mSmartListDone.put("startMove_multi" + MAX_NUM_GEN, "startMove_multi" + MAX_NUM_GEN);
                    }
                    this.mSmartListDone.put(fName, fName);
                    continue;
                }
                if (drawType.equals("startDraw") && types[ii].equals("startDraw")) {
                    smB.append(bName + ":\n");
                    smB.append(oName + ":\n");
                    this.addOpto(smB, optimization, true);
                    if (sameCount > 1) {
                        smB.append("\tjmp      again_sd" + (sameCount - 1) + "\n");
                    } else {
                        smB.append("\tPULL_NEXT_LINE\n");
                    }
                    if (!this.mSmartListDone.containsKey("startDraw_multi" + MAX_NUM_GEN)) {
                        smB.append(drawType + "_multi" + MAX_NUM_GEN + ":\n");
                        this.addOpto(smB, "", false);
                        smB.append("\tjmp again_sd" + (MAX_NUM_GEN - 1) + "\n");
                        for (i = MAX_NUM_GEN - 1; i >= 1; --i) {
                            smB.append("again_sd" + i + ":\n");
                            smB.append("\tnop\n");
                            if (i != 1) {
                                smB.append("\tSTART_T1_AGAIN_DRAW\n");
                                smB.append("\tjmp again_sd" + (i - 1) + "\n");
                                continue;
                            }
                            smB.append("\tSTART_T1_AGAIN_DRAW_LAST\n");
                        }
                        smB.append("\tPULL_NEXT_LINE\n");
                        this.mSmartListDone.put("startDraw_multi" + MAX_NUM_GEN, "startDraw_multi" + MAX_NUM_GEN);
                    }
                    this.mSmartListDone.put(fName, fName);
                    continue;
                }
                if (drawType.equals("continue_draw") && types[ii].equals("continue_draw")) {
                    smB.append(bName + ":\n");
                    smB.append(oName + ":\n");
                    if (!optimization.equals("_xyStays")) {
                        smB.append("\tSET_SHIFT_END\n");
                        this.addOpto(smB, optimization, true);
                    } else {
                        this.addOpto(smB, optimization, false);
                    }
                    if (sameCount > 1) {
                        smB.append("\tjmp      again_cd" + (sameCount - 1) + "\n");
                    } else {
                        smB.append("\tPULL_NEXT_LINE\n");
                    }
                    if (!this.mSmartListDone.containsKey("continue_draw_multi" + MAX_NUM_GEN)) {
                        smB.append(drawType + "_multi" + MAX_NUM_GEN + ":\n");
                        if (!optimization.equals("_xyStays")) {
                            smB.append("\tSET_SHIFT_END\n");
                            this.addOpto(smB, "", false);
                        } else {
                            this.addOpto(smB, optimization, false);
                        }
                        smB.append("\tjmp again_cd" + (MAX_NUM_GEN - 1) + "\n");
                        for (i = MAX_NUM_GEN - 1; i >= 1; --i) {
                            smB.append("again_cd" + i + ":\n");
                            smB.append("\tnop\n");
                            if (i != 1) {
                                smB.append("\tSTART_T1_AGAIN_DRAW\n");
                                smB.append("\tjmp again_cd" + (i - 1) + "\n");
                                continue;
                            }
                            smB.append("\tSTART_T1_AGAIN_DRAW_LAST\n");
                        }
                        smB.append("\tPULL_NEXT_LINE\n");
                        this.mSmartListDone.put("continue_draw_multi" + MAX_NUM_GEN, "continue_draw_multi" + MAX_NUM_GEN);
                    }
                    this.mSmartListDone.put(fName, fName);
                    continue;
                }
                if (!drawType.equals("continue_move") || !types[ii].equals("continue_move")) continue;
                smB.append(bName + ":\n");
                smB.append(oName + ":\n");
                this.addOpto(smB, optimization, false);
                if (sameCount > 1) {
                    smB.append("\tjmp      again_cm" + (sameCount - 1) + "\n");
                } else {
                    smB.append("\tPULL_NEXT_LINE\n");
                }
                if (!this.mSmartListDone.containsKey("continue_move_multi" + MAX_NUM_GEN)) {
                    smB.append(drawType + "_multi" + MAX_NUM_GEN + ":\n");
                    this.addOpto(smB, "", false);
                    smB.append("\tjmp again_cm" + (MAX_NUM_GEN - 1) + "\n");
                    for (i = MAX_NUM_GEN - 1; i >= 1; --i) {
                        smB.append("again_cm" + i + ":\n");
                        smB.append("\tnop\n");
                        if (i != 1) {
                            smB.append("\tSTART_T1_AGAIN_MOVE\n");
                            smB.append("\tjmp again_cm" + (i - 1) + "\n");
                            continue;
                        }
                        smB.append("\tSTART_T1_AGAIN_MOVE_LAST\n");
                    }
                    smB.append("\tPULL_NEXT_LINE\n");
                    this.mSmartListDone.put("continue_move_multi" + MAX_NUM_GEN, "continue_movemulti" + MAX_NUM_GEN);
                }
                this.mSmartListDone.put(fName, fName);
            }
        }
        smB.append("\topt\n");
        smB.append(LAST_DRAW_RTS2);
        smB.append(LAST_DRAW_RTS);
        return smB.toString();
    }

    void addOpto(StringBuilder smB, String optimization, boolean isDraw) {
        if (optimization.length() == 0) {
            smB.append("\tSET_Y_X\n");
            if (isDraw) {
                smB.append("\tSET_SHIFT_START\n");
            }
            smB.append("\tSTART_T1\n");
        } else if (optimization.equals("_yStays")) {
            smB.append("\tSET_YSTAYS_X\n");
            if (isDraw) {
                smB.append("\tSET_SHIFT_START\n");
            }
            smB.append("\tSTART_T1\n");
        } else if (optimization.equals("_xyStays")) {
            if (isDraw) {
                smB.append("\tSET_SHIFT_START\n");
            }
            smB.append("\tSTART_T1\n");
        } else if (optimization.equals("_y0")) {
            smB.append("\tSET_Y0_X\n");
            if (isDraw) {
                smB.append("\tSET_SHIFT_START\n");
            }
            smB.append("\tSTART_T1\n");
        } else if (optimization.equals("_x0")) {
            smB.append("\tSSET_Y_X0\n");
            if (isDraw) {
                smB.append("\tSET_SHIFT_START\n");
            }
            smB.append("\tSTART_T1_B\n");
        } else if (optimization.equals("_yEqx")) {
            smB.append("\tSET_Y_EQU_X\n");
            if (isDraw) {
                smB.append("\tSET_SHIFT_START\n");
            }
            smB.append("\tSTART_T1\n");
        } else if (optimization.equals("_newY_eq_oldX")) {
            smB.append("\tSET_Y_EQUOLD_X\n");
            if (isDraw) {
                smB.append("\tSET_SHIFT_START\n");
            }
            smB.append("\tSTART_T1\n");
        }
    }
}

