/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.veccy;

import de.malban.config.Configuration;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.Windowable;
import de.malban.gui.components.CSAView;
import de.malban.gui.dialogs.InputDialog;
import de.malban.gui.panels.LogPanel;
import de.malban.util.UtilityString;
import de.malban.vide.veccy.ActionData;
import de.malban.vide.veccy.ActionDataPool;
import de.malban.vide.veccy.ActionNewData;
import de.malban.vide.veccy.ActionNewDataPool;
import de.malban.vide.veccy.ActionPanel;
import de.malban.vide.veccy.ActionResultData;
import de.malban.vide.veccy.ActionResultDataPool;
import de.malban.vide.veccy.ActionTriggerData;
import de.malban.vide.veccy.ActionTriggerDataPool;
import de.malban.vide.veccy.BackGroundScenePanel;
import de.malban.vide.veccy.GameData;
import de.malban.vide.veccy.GameDataPool;
import de.malban.vide.veccy.GameGenerator;
import de.malban.vide.veccy.LevelData;
import de.malban.vide.veccy.LevelDataPool;
import de.malban.vide.veccy.LevelObjectData;
import de.malban.vide.veccy.LevelObjectDataPanel;
import de.malban.vide.veccy.LevelObjectDataPool;
import de.malban.vide.veccy.SpriteData;
import de.malban.vide.veccy.SpriteDataPool;
import de.malban.vide.veccy.VeccyPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.UUID;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class GamePanel
extends JPanel
implements Windowable {
    LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    VeccyPanel veccy = null;
    private int mClassSetting = 0;
    private CSAView mParent = null;
    private JMenuItem mParentMenuItem = null;
    private GameData mGameData = new GameData();
    private GameDataPool mGameDataPool;
    private LevelData mLevelData = new LevelData();
    private LevelDataPool mLevelDataPool;
    private ActionNewData mActionData = new ActionNewData();
    private ActionNewDataPool mActionDataPool;
    private SpriteData mSpriteData = new SpriteData();
    private SpriteDataPool mSpriteDataPool;
    private LevelObjectDataPool mLevelObjectDataPool;
    private ActionPanel actionPanel1;
    private ActionPanel actionPanel2;
    private BackGroundScenePanel backGroundScenePanel1;
    private JButton jButton1;
    private JButton jButtonCreateNewLevelObject;
    private JButton jButtonDeleteAction;
    private JButton jButtonDeleteGame;
    private JButton jButtonDeleteLevel;
    private JButton jButtonDeleteSprite;
    private JButton jButtonNewAction;
    private JButton jButtonNewGame;
    private JButton jButtonNewLevel;
    private JButton jButtonNewSprite;
    private JButton jButtonSaveAction;
    private JButton jButtonSaveAsNewAction;
    private JButton jButtonSaveAsNewGame;
    private JButton jButtonSaveAsNewLevel;
    private JButton jButtonSaveAsNewSprite;
    private JButton jButtonSaveGame;
    private JButton jButtonSaveLevel;
    private JButton jButtonSaveSprite;
    private JComboBox jComboBoxActionName;
    private JComboBox<String> jComboBoxDefaultAction;
    private JComboBox jComboBoxNameGame;
    private JComboBox jComboBoxNameLevel;
    private JComboBox jComboBoxSpriteName;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanelLevel;
    private JPanel jPanelLevelObjectPanel;
    private JPanel jPanelSprite;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTabbedPane jTabbedPane1;
    private JTextArea jTextArea1;
    private JTextField jTextFieldLevelNumber;
    private JTextField jTextFieldNameGame;
    private JTextField jTextFieldNameLevel;
    private JTextField jTextFieldSpriteID;
    private JTextField jTextFieldSpriteUID;

    @Override
    public void closing() {
        if (this.veccy != null) {
            this.veccy.removeSBPanel();
        }
    }

    @Override
    public boolean isIcon() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return false;
        }
        return frame.getInternalFrame(this).isIcon();
    }

    @Override
    public void setIcon(boolean b) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return;
        }
        try {
            frame.getInternalFrame(this).setIcon(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void deIconified() {
    }

    @Override
    public void setParentWindow(CSAView jpv) {
        this.mParent = jpv;
    }

    @Override
    public void setMenuItem(JMenuItem item) {
        this.mParentMenuItem = item;
        this.mParentMenuItem.setText("Vector: Game");
    }

    @Override
    public JMenuItem getMenuItem() {
        return this.mParentMenuItem;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    public GamePanel() {
        this.initComponents();
        this.mActionDataPool = new ActionNewDataPool();
        this.resetConfigPoolActions(false);
        this.mSpriteDataPool = new SpriteDataPool();
        this.resetConfigPoolSprites(false);
        this.mGameDataPool = new GameDataPool();
        this.resetConfigPoolGame(false);
        this.mLevelObjectDataPool = new LevelObjectDataPool();
        this.mLevelDataPool = new LevelDataPool();
        this.resetConfigPoolLevel(false);
        this.resetDefaultPoolActions();
        this.spriteNameEditEnabled();
        this.levelNameEditEnabled();
        this.jButtonCreateNewLevelObject.setEnabled(this.mLevelObjectDataPool != null);
    }

    private void resetConfigPoolGame(boolean select) {
        ++this.mClassSetting;
        Collection<String> collectionKlasse = this.mGameDataPool.getKlassenHashMap().values();
        Iterator<String> iterKlasse = collectionKlasse.iterator();
        int i = 0;
        String klasse = "AllGames";
        Collection<GameData> colC = this.mGameDataPool.getMapForKlasse(klasse).values();
        Iterator<GameData> iterC = colC.iterator();
        this.jComboBoxNameGame.removeAllItems();
        i = 0;
        while (iterC.hasNext()) {
            GameData item = iterC.next();
            this.jComboBoxNameGame.addItem(item.mName);
            if (i == 0 && select) {
                this.jComboBoxNameGame.setSelectedIndex(0);
                this.mGameData = this.mGameDataPool.get(item.mName);
                this.setAllFromCurrentGame();
            }
            ++i;
        }
        if (!select) {
            this.jComboBoxNameGame.setSelectedIndex(-1);
        }
        --this.mClassSetting;
    }

    private void clearAllGame() {
        ++this.mClassSetting;
        this.mGameData = new GameData();
        this.mLevelObjectDataPool = null;
        this.setAllFromCurrentGame();
        this.mLevelData = new LevelData();
        this.setAllFromCurrentLevel();
        --this.mClassSetting;
    }

    private void setAllFromCurrentGame() {
        ++this.mClassSetting;
        this.jComboBoxNameGame.setSelectedItem(this.mGameData.mName);
        this.jTextFieldNameGame.setText(this.mGameData.mName);
        this.mLevelDataPool = new LevelDataPool();
        this.resetConfigPoolLevel(false);
        this.levelNameEditEnabled();
        --this.mClassSetting;
    }

    private void readAllToCurrentGame() {
        this.mGameData.mName = this.jTextFieldNameGame.getText();
        this.mGameData.mClass = "AllGames";
    }

    private void resetConfigPoolLevel(boolean select) {
        ++this.mClassSetting;
        Collection<String> collectionKlasse = this.mLevelDataPool.getKlassenHashMap().values();
        Iterator<String> iterKlasse = collectionKlasse.iterator();
        int i = 0;
        String klasse = this.getGameName() + "_Levels";
        Collection<LevelData> colC = this.mLevelDataPool.getMapForKlasse(klasse).values();
        Iterator<LevelData> iterC = colC.iterator();
        String currentName = this.mLevelData.mName;
        this.jComboBoxNameLevel.removeAllItems();
        i = 0;
        while (iterC.hasNext()) {
            LevelData item = iterC.next();
            this.jComboBoxNameLevel.addItem(item.mName);
            if (item.mName.equals(currentName) && select) {
                this.jComboBoxNameLevel.setSelectedIndex(0);
                this.mLevelData = this.mLevelDataPool.get(item.mName);
                this.setAllFromCurrentLevel();
            }
            ++i;
        }
        if (!select) {
            this.jComboBoxNameLevel.setSelectedIndex(-1);
        }
        --this.mClassSetting;
    }

    private void clearAllLevel() {
        ++this.mClassSetting;
        this.mLevelData = new LevelData();
        this.setAllFromCurrentLevel();
        --this.mClassSetting;
    }

    private void setAllFromCurrentLevel() {
        ++this.mClassSetting;
        this.jComboBoxNameLevel.setSelectedItem(this.mLevelData.mName);
        this.jTextFieldNameLevel.setText(this.mLevelData.mName);
        this.jTextFieldLevelNumber.setText("" + this.mLevelData.mLevelOrder);
        this.setAllLevelObjects();
        --this.mClassSetting;
    }

    private void readAllToCurrentLevel() {
        this.mLevelData.mName = this.jTextFieldNameLevel.getText();
        this.mLevelData.mClass = this.getGameName() + "_Levels";
        this.mLevelData.mLevelOrder = UtilityString.IntX(this.jTextFieldLevelNumber.getText(), 1);
    }

    private void resetConfigPoolSprites(boolean select) {
        ++this.mClassSetting;
        Collection<String> collectionKlasse = this.mSpriteDataPool.getKlassenHashMap().values();
        Iterator<String> iterKlasse = collectionKlasse.iterator();
        int i = 0;
        String klasse = "AllSprites";
        Collection<SpriteData> colC = this.mSpriteDataPool.getMapForKlasse(klasse).values();
        ArrayList<SpriteData> list2 = new ArrayList<SpriteData>(colC);
        Collections.sort(list2, new Comparator<SpriteData>(){

            @Override
            public int compare(SpriteData o1, SpriteData o2) {
                return o1.mName.compareToIgnoreCase(o2.mName);
            }
        });
        Iterator iterC = list2.iterator();
        this.jComboBoxSpriteName.removeAllItems();
        i = 0;
        while (iterC.hasNext()) {
            SpriteData item = (SpriteData)iterC.next();
            this.jComboBoxSpriteName.addItem(item.mName);
            if (i == 0 && select) {
                this.jComboBoxSpriteName.setSelectedIndex(0);
                this.mSpriteData = this.mSpriteDataPool.get(item.mName);
                this.setAllFromCurrentSprites();
            }
            ++i;
        }
        if (!select) {
            this.jComboBoxSpriteName.setSelectedIndex(-1);
        }
        --this.mClassSetting;
    }

    private void resetConfigPoolActions(boolean select) {
        ++this.mClassSetting;
        Collection<String> collectionKlasse = this.mActionDataPool.getKlassenHashMap().values();
        Iterator<String> iterKlasse = collectionKlasse.iterator();
        int i = 0;
        String klasse = this.getSpriteName() + "_Actions";
        Collection<ActionNewData> colC = this.mActionDataPool.getMapForKlasse(klasse).values();
        Iterator<ActionNewData> iterC = colC.iterator();
        if (colC.size() == 0) {
            this.convertOldActionToNewAction();
            this.mActionDataPool = new ActionNewDataPool();
            collectionKlasse = this.mActionDataPool.getKlassenHashMap().values();
            iterKlasse = collectionKlasse.iterator();
            i = 0;
            klasse = this.getSpriteName() + "_Actions";
            colC = this.mActionDataPool.getMapForKlasse(klasse).values();
            iterC = colC.iterator();
        }
        this.jComboBoxActionName.removeAllItems();
        i = 0;
        boolean somethingDone = false;
        while (iterC.hasNext()) {
            ActionNewData item = iterC.next();
            this.jComboBoxActionName.addItem(item.mName);
            if (i == 0 && select) {
                this.jComboBoxActionName.setSelectedIndex(0);
                this.mActionData = this.mActionDataPool.get(item.mName);
                this.setAllFromCurrentActions();
            }
            ++i;
        }
        if (!select) {
            this.jComboBoxActionName.setSelectedIndex(-1);
        }
        --this.mClassSetting;
    }

    private void resetDefaultPoolActions() {
        ++this.mClassSetting;
        Collection<String> collectionKlasse = this.mActionDataPool.getKlassenHashMap().values();
        Iterator<String> iterKlasse = collectionKlasse.iterator();
        int i = 0;
        String klasse = this.getSpriteName() + "_Actions";
        Collection<ActionNewData> colC = this.mActionDataPool.getMapForKlasse(klasse).values();
        Iterator<ActionNewData> iterC = colC.iterator();
        String selectedDefaultAction = this.mSpriteData.mDefaultActionID;
        this.jComboBoxDefaultAction.removeAllItems();
        this.jComboBoxDefaultAction.addItem("");
        i = 1;
        while (iterC.hasNext()) {
            ActionNewData item = iterC.next();
            this.jComboBoxDefaultAction.addItem(item.mName);
            if (selectedDefaultAction.equals(item.mName)) {
                this.jComboBoxDefaultAction.setSelectedIndex(i);
            }
            ++i;
        }
        --this.mClassSetting;
    }

    private void clearAllActions() {
        ++this.mClassSetting;
        this.mActionData = new ActionNewData();
        this.setAllFromCurrentActions();
        this.spriteNameEditEnabled();
        --this.mClassSetting;
    }

    private void setAllFromCurrentActions() {
        ++this.mClassSetting;
        this.jComboBoxActionName.setSelectedItem(this.mActionData.mName);
        this.actionPanel2.setActionData(this.mActionData, this.mSpriteData);
        --this.mClassSetting;
    }

    private void readAllToCurrentActions() {
        if (this.actionPanel2 != null) {
            this.actionPanel2.stopEditing();
        }
        this.mActionData = this.actionPanel2.getActionData();
        this.mActionData.mClass = this.getSpriteName() + "_Actions";
    }

    private void initComponents() {
        this.actionPanel1 = new ActionPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelLevel = new JPanel();
        this.jLabel5 = new JLabel();
        this.jTextFieldNameLevel = new JTextField();
        this.jComboBoxNameLevel = new JComboBox();
        this.jButtonSaveLevel = new JButton();
        this.jButtonSaveAsNewLevel = new JButton();
        this.jButtonDeleteLevel = new JButton();
        this.jButtonNewLevel = new JButton();
        this.jButtonCreateNewLevelObject = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jPanelLevelObjectPanel = new JPanel();
        this.jLabel6 = new JLabel();
        this.jTextFieldLevelNumber = new JTextField();
        this.jPanelSprite = new JPanel();
        this.jComboBoxDefaultAction = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextFieldSpriteID = new JTextField();
        this.jButtonSaveAsNewSprite = new JButton();
        this.jButtonSaveSprite = new JButton();
        this.jComboBoxSpriteName = new JComboBox();
        this.jButtonDeleteSprite = new JButton();
        this.jButtonNewSprite = new JButton();
        this.jPanel1 = new JPanel();
        this.actionPanel2 = new ActionPanel();
        this.jButtonDeleteAction = new JButton();
        this.jButtonSaveAsNewAction = new JButton();
        this.jButtonSaveAction = new JButton();
        this.jButtonNewAction = new JButton();
        this.jComboBoxActionName = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jTextFieldSpriteUID = new JTextField();
        this.jPanel2 = new JPanel();
        this.backGroundScenePanel1 = new BackGroundScenePanel();
        this.jButton1 = new JButton();
        this.jLabel4 = new JLabel();
        this.jTextFieldNameGame = new JTextField();
        this.jComboBoxNameGame = new JComboBox();
        this.jButtonNewGame = new JButton();
        this.jButtonSaveGame = new JButton();
        this.jButtonSaveAsNewGame = new JButton();
        this.jButtonDeleteGame = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jLabel5.setText("Name");
        this.jComboBoxNameLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GamePanel.this.jComboBoxNameLevelActionPerformed(evt);
            }
        });
        this.jButtonSaveLevel.setText("Save");
        this.jButtonSaveLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GamePanel.this.jButtonSaveLevelActionPerformed(evt);
            }
        });
        this.jButtonSaveAsNewLevel.setText("Save as new");
        this.jButtonSaveAsNewLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GamePanel.this.jButtonSaveAsNewLevelActionPerformed(evt);
            }
        });
        this.jButtonDeleteLevel.setText("Delete");
        this.jButtonDeleteLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GamePanel.this.jButtonDeleteLevelActionPerformed(evt);
            }
        });
        this.jButtonNewLevel.setText("New");
        this.jButtonNewLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GamePanel.this.jButtonNewLevelActionPerformed(evt);
            }
        });
        this.jButtonCreateNewLevelObject.setText("add object");
        this.jButtonCreateNewLevelObject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GamePanel.this.jButtonCreateNewLevelObjectActionPerformed(evt);
            }
        });
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        this.jPanelLevelObjectPanel.setLayout(new BoxLayout(this.jPanelLevelObjectPanel, 1));
        this.jScrollPane2.setViewportView(this.jPanelLevelObjectPanel);
        this.jLabel6.setText("Level number");
        this.jTextFieldLevelNumber.setHorizontalAlignment(11);
        this.jTextFieldLevelNumber.setText("1");
        this.jTextFieldLevelNumber.setToolTipText("Start with one and go steady up!");
        GroupLayout jPanelLevelLayout = new GroupLayout(this.jPanelLevel);
        this.jPanelLevel.setLayout(jPanelLevelLayout);
        jPanelLevelLayout.setHorizontalGroup(jPanelLevelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLevelLayout.createSequentialGroup().addContainerGap().addGroup(jPanelLevelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLevelLayout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldNameLevel, -2, 125, -2)).addComponent(this.jButtonCreateNewLevelObject)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelLevelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel6, -2, 131, -2).addComponent(this.jComboBoxNameLevel, -2, 134, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelLevelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonNewLevel, -1, -1, Short.MAX_VALUE).addComponent(this.jTextFieldLevelNumber, -2, 53, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSaveLevel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSaveAsNewLevel).addGap(41, 41, 41).addComponent(this.jButtonDeleteLevel).addContainerGap(602, Short.MAX_VALUE)).addComponent(this.jScrollPane2));
        jPanelLevelLayout.setVerticalGroup(jPanelLevelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLevelLayout.createSequentialGroup().addContainerGap().addGroup(jPanelLevelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonNewLevel).addComponent(this.jLabel5).addComponent(this.jTextFieldNameLevel, -2, -1, -2).addComponent(this.jComboBoxNameLevel, -2, -1, -2).addComponent(this.jButtonDeleteLevel).addComponent(this.jButtonSaveLevel).addComponent(this.jButtonSaveAsNewLevel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelLevelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCreateNewLevelObject).addComponent(this.jLabel6).addComponent(this.jTextFieldLevelNumber, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 686, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Levels", this.jPanelLevel);
        this.jComboBoxDefaultAction.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxDefaultAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GamePanel.this.jComboBoxDefaultActionActionPerformed(evt);
            }
        });
        this.jLabel1.setText("default action");
        this.jLabel3.setText("Sprite ID");
        this.jButtonSaveAsNewSprite.setText("Save as new");
        this.jButtonSaveAsNewSprite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GamePanel.this.jButtonSaveAsNewSpriteActionPerformed(evt);
            }
        });
        this.jButtonSaveSprite.setText("Save");
        this.jButtonSaveSprite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GamePanel.this.jButtonSaveSpriteActionPerformed(evt);
            }
        });
        this.jComboBoxSpriteName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GamePanel.this.jComboBoxSpriteNameActionPerformed(evt);
            }
        });
        this.jButtonDeleteSprite.setText("Delete");
        this.jButtonDeleteSprite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GamePanel.this.jButtonDeleteSpriteActionPerformed(evt);
            }
        });
        this.jButtonNewSprite.setText("New");
        this.jButtonNewSprite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GamePanel.this.jButtonNewSpriteActionPerformed(evt);
            }
        });
        this.jButtonDeleteAction.setText("Delete");
        this.jButtonDeleteAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GamePanel.this.jButtonDeleteActionActionPerformed(evt);
            }
        });
        this.jButtonSaveAsNewAction.setText("Save as new");
        this.jButtonSaveAsNewAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GamePanel.this.jButtonSaveAsNewActionActionPerformed(evt);
            }
        });
        this.jButtonSaveAction.setText("Save");
        this.jButtonSaveAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GamePanel.this.jButtonSaveActionActionPerformed(evt);
            }
        });
        this.jButtonNewAction.setText("New");
        this.jButtonNewAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GamePanel.this.jButtonNewActionActionPerformed(evt);
            }
        });
        this.jComboBoxActionName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GamePanel.this.jComboBoxActionNameActionPerformed(evt);
            }
        });
        this.jLabel2.setText("edit action");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.actionPanel2, -1, 1217, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2).addGap(48, 48, 48).addComponent(this.jComboBoxActionName, -2, 173, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonNewAction).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSaveAction).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSaveAsNewAction).addGap(34, 34, 34).addComponent(this.jButtonDeleteAction))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jComboBoxActionName, -2, -1, -2).addComponent(this.jButtonNewAction).addComponent(this.jButtonSaveAction).addComponent(this.jButtonSaveAsNewAction).addComponent(this.jButtonDeleteAction)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.actionPanel2, -1, 659, Short.MAX_VALUE)));
        this.jLabel7.setText("UID");
        this.jTextFieldSpriteUID.setText("0");
        this.jTextFieldSpriteUID.setToolTipText("Each sprite needs a distinct UID, these is used to identify sprites during colision detection!");
        GroupLayout jPanelSpriteLayout = new GroupLayout(this.jPanelSprite);
        this.jPanelSprite.setLayout(jPanelSpriteLayout);
        jPanelSpriteLayout.setHorizontalGroup(jPanelSpriteLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(jPanelSpriteLayout.createSequentialGroup().addContainerGap().addGroup(jPanelSpriteLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel1)).addGap(31, 31, 31).addGroup(jPanelSpriteLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jComboBoxDefaultAction, 0, 172, Short.MAX_VALUE).addComponent(this.jTextFieldSpriteID)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelSpriteLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanelSpriteLayout.createSequentialGroup().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jTextFieldSpriteUID, -2, 92, -2)).addComponent(this.jComboBoxSpriteName, -2, 147, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonNewSprite).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSaveSprite).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSaveAsNewSprite).addGap(34, 34, 34).addComponent(this.jButtonDeleteSprite).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelSpriteLayout.setVerticalGroup(jPanelSpriteLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSpriteLayout.createSequentialGroup().addGap(5, 5, 5).addGroup(jPanelSpriteLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonDeleteSprite, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonSaveAsNewSprite, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonSaveSprite, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonNewSprite, -1, -1, Short.MAX_VALUE).addComponent(this.jComboBoxSpriteName).addGroup(jPanelSpriteLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldSpriteID).addComponent(this.jLabel3))).addGap(10, 10, 10).addGroup(jPanelSpriteLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBoxDefaultAction, -2, -1, -2).addComponent(this.jLabel7).addComponent(this.jTextFieldSpriteUID, -2, -1, -2)).addGap(4, 4, 4).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Sprites", this.jPanelSprite);
        this.jPanel2.setName("");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.backGroundScenePanel1, -2, -1, -2).addGap(0, 502, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.backGroundScenePanel1, -2, -1, -2).addGap(0, 276, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Background Scene", this.jPanel2);
        this.jButton1.setText("Generate game");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GamePanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Name");
        this.jComboBoxNameGame.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GamePanel.this.jComboBoxNameGameActionPerformed(evt);
            }
        });
        this.jButtonNewGame.setText("New");
        this.jButtonNewGame.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GamePanel.this.jButtonNewGameActionPerformed(evt);
            }
        });
        this.jButtonSaveGame.setText("Save");
        this.jButtonSaveGame.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GamePanel.this.jButtonSaveGameActionPerformed(evt);
            }
        });
        this.jButtonSaveAsNewGame.setText("Save as new");
        this.jButtonSaveAsNewGame.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GamePanel.this.jButtonSaveAsNewGameActionPerformed(evt);
            }
        });
        this.jButtonDeleteGame.setText("Delete");
        this.jButtonDeleteGame.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GamePanel.this.jButtonDeleteGameActionPerformed(evt);
            }
        });
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setText("All sprites are drawn with a scale of $8!\nAll positioning is done with a scale of $80!");
        this.jScrollPane1.setViewportView(this.jTextArea1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1).addGroup(layout.createSequentialGroup().addComponent(this.jTextFieldNameGame, -2, 133, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxNameGame, -2, 131, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonNewGame).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSaveGame).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSaveAsNewGame).addGap(42, 42, 42).addComponent(this.jButtonDeleteGame))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, -2, 333, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jTextFieldNameGame, -2, -1, -2).addComponent(this.jComboBoxNameGame, -2, -1, -2).addComponent(this.jButtonNewGame).addComponent(this.jButtonSaveGame).addComponent(this.jButtonSaveAsNewGame).addComponent(this.jButtonDeleteGame)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1)).addComponent(this.jScrollPane1, -2, 48, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTabbedPane1)));
        this.jTabbedPane1.getAccessibleContext().setAccessibleName("game");
    }

    private void jComboBoxActionNameActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        String key = this.jComboBoxActionName.getSelectedItem().toString();
        this.mActionData = this.mActionDataPool.get(key);
        this.setAllFromCurrentActions();
    }

    private void jButtonSaveActionActionPerformed(ActionEvent evt) {
        this.readAllToCurrentActions();
        this.actionPanel2.saveTriggersAndResults();
        this.mActionDataPool.put(this.mActionData);
        this.mActionDataPool.save();
        ++this.mClassSetting;
        String nameToSet = this.mActionData.mName;
        this.resetConfigPoolActions(true);
        --this.mClassSetting;
        this.jComboBoxActionName.setSelectedItem(nameToSet);
        this.resetDefaultPoolActions();
        this.spriteNameEditEnabled();
    }

    private void jButtonSaveAsNewActionActionPerformed(ActionEvent evt) {
        this.mActionData = new ActionNewData();
        this.readAllToCurrentActions();
        this.actionPanel2.saveTriggersAndResults();
        this.mActionDataPool.putAsNew(this.mActionData);
        this.mActionDataPool.save();
        ++this.mClassSetting;
        this.resetConfigPoolActions(true);
        this.jComboBoxActionName.setSelectedItem(this.mActionData.mName);
        this.spriteNameEditEnabled();
        --this.mClassSetting;
    }

    private void jButtonDeleteActionActionPerformed(ActionEvent evt) {
        this.readAllToCurrentActions();
        this.mActionDataPool.remove(this.mActionData);
        this.mActionDataPool.save();
        ++this.mClassSetting;
        this.resetConfigPoolActions(true);
        if (this.jComboBoxActionName.getSelectedIndex() == -1) {
            this.clearAllActions();
        }
        if (this.jComboBoxActionName.getSelectedItem() == null) {
            this.mActionData = new ActionNewData();
            this.setAllFromCurrentActions();
            this.spriteNameEditEnabled();
            --this.mClassSetting;
            return;
        }
        String key = this.jComboBoxActionName.getSelectedItem().toString();
        this.mActionData = this.mActionDataPool.get(key);
        this.setAllFromCurrentActions();
        this.spriteNameEditEnabled();
        --this.mClassSetting;
    }

    private void jButtonNewActionActionPerformed(ActionEvent evt) {
        ++this.mClassSetting;
        this.mActionData = new ActionNewData();
        this.mActionData.mtextHeight = 2;
        this.mActionData.mtextWidth = 50;
        this.clearAllActions();
        this.resetConfigPoolActions(false);
        --this.mClassSetting;
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.actionPanel2 != null) {
            this.actionPanel2.stopEditing();
        }
        GameGenerator gg = new GameGenerator(this.veccy, this.jTextFieldNameGame.getText());
        gg.generateGame();
    }

    private void jButtonSaveAsNewSpriteActionPerformed(ActionEvent evt) {
        String oldName = this.mSpriteData.mName;
        this.mSpriteData = new SpriteData();
        this.readAllToCurrentSprites();
        String newName = this.mSpriteData.mName = InputDialog.showInputDialog("Enter new sprite name:");
        this.mSpriteDataPool.putAsNew(this.mSpriteData);
        String selectedSprite = this.mSpriteData.mName;
        this.mSpriteDataPool.save();
        this.copyActionFromSpriteToSprite(oldName, newName);
        ++this.mClassSetting;
        this.resetConfigPoolSprites(true);
        this.jComboBoxSpriteName.setSelectedItem(selectedSprite);
        this.updateSpriteRefs();
        --this.mClassSetting;
    }

    private void jButtonSaveSpriteActionPerformed(ActionEvent evt) {
        this.readAllToCurrentSprites();
        this.mSpriteDataPool.put(this.mSpriteData);
        String selectedSprite = this.mSpriteData.mName;
        String selectedAction = this.mActionData.mName;
        this.mSpriteDataPool.save();
        ++this.mClassSetting;
        this.resetConfigPoolSprites(true);
        this.resetConfigPoolActions(true);
        --this.mClassSetting;
        this.jComboBoxSpriteName.setSelectedItem(selectedSprite);
        this.jComboBoxActionName.setSelectedItem(selectedAction);
        ++this.mClassSetting;
        this.updateSpriteRefs();
        --this.mClassSetting;
    }

    private void jComboBoxSpriteNameActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        String key = this.jComboBoxSpriteName.getSelectedItem().toString();
        this.mSpriteData = this.mSpriteDataPool.get(key);
        this.setAllFromCurrentSprites();
        this.spriteNameEditEnabled();
    }

    private void jButtonDeleteSpriteActionPerformed(ActionEvent evt) {
        this.readAllToCurrentSprites();
        this.mSpriteDataPool.remove(this.mSpriteData);
        this.mSpriteDataPool.save();
        ++this.mClassSetting;
        this.resetConfigPoolSprites(true);
        if (this.jComboBoxActionName.getSelectedIndex() == -1) {
            this.clearAllSprites();
        }
        String key = this.jComboBoxActionName.getSelectedItem().toString();
        this.mSpriteData = this.mSpriteDataPool.get(key);
        this.setAllFromCurrentSprites();
        this.updateSpriteRefs();
        --this.mClassSetting;
    }

    private void jButtonNewSpriteActionPerformed(ActionEvent evt) {
        ++this.mClassSetting;
        this.mSpriteData = new SpriteData();
        this.clearAllSprites();
        this.resetConfigPoolSprites(false);
        this.spriteNameEditEnabled();
        --this.mClassSetting;
    }

    private void jComboBoxNameLevelActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        String key = this.jComboBoxNameLevel.getSelectedItem().toString();
        this.mLevelData = this.mLevelDataPool.get(key);
        this.verifyLevelData(this.mLevelData);
        this.setAllFromCurrentLevel();
    }

    private void jButtonSaveLevelActionPerformed(ActionEvent evt) {
        this.readAllToCurrentLevel();
        this.mLevelDataPool.put(this.mLevelData);
        this.mLevelDataPool.save();
        ++this.mClassSetting;
        this.resetConfigPoolLevel(true);
        --this.mClassSetting;
    }

    private void jButtonSaveAsNewLevelActionPerformed(ActionEvent evt) {
        this.mLevelData = new LevelData();
        this.readAllToCurrentLevel();
        this.mLevelDataPool.putAsNew(this.mLevelData);
        this.mLevelDataPool.save();
        ++this.mClassSetting;
        this.resetConfigPoolLevel(true);
        this.jComboBoxNameLevel.setSelectedItem(this.mLevelData.mName);
        --this.mClassSetting;
    }

    private void jButtonDeleteLevelActionPerformed(ActionEvent evt) {
        this.readAllToCurrentLevel();
        this.mLevelDataPool.remove(this.mLevelData);
        this.mLevelDataPool.save();
        ++this.mClassSetting;
        this.resetConfigPoolLevel(true);
        if (this.jComboBoxNameLevel.getSelectedIndex() == -1) {
            this.clearAllLevel();
        }
        String key = this.jComboBoxNameLevel.getSelectedItem().toString();
        this.mLevelData = this.mLevelDataPool.get(key);
        this.setAllFromCurrentLevel();
        --this.mClassSetting;
    }

    private void jButtonNewLevelActionPerformed(ActionEvent evt) {
        ++this.mClassSetting;
        this.mLevelData = new LevelData();
        this.clearAllLevel();
        this.resetConfigPoolLevel(false);
        --this.mClassSetting;
    }

    private void jButtonSaveAsNewGameActionPerformed(ActionEvent evt) {
        this.mGameData = new GameData();
        this.readAllToCurrentGame();
        this.mGameDataPool.putAsNew(this.mGameData);
        this.mGameDataPool.save();
        ++this.mClassSetting;
        this.resetConfigPoolGame(true);
        this.jComboBoxNameGame.setSelectedItem(this.mGameData.mName);
        --this.mClassSetting;
    }

    private void jButtonDeleteGameActionPerformed(ActionEvent evt) {
        this.readAllToCurrentGame();
        this.mGameDataPool.remove(this.mGameData);
        this.mGameDataPool.save();
        ++this.mClassSetting;
        this.resetConfigPoolGame(true);
        if (this.jComboBoxNameGame.getSelectedIndex() == -1) {
            this.clearAllGame();
        }
        String key = this.jComboBoxNameGame.getSelectedItem().toString();
        this.mGameData = this.mGameDataPool.get(key);
        this.setAllFromCurrentGame();
        this.jButtonCreateNewLevelObject.setEnabled(this.mLevelObjectDataPool != null);
        --this.mClassSetting;
    }

    private void jButtonNewGameActionPerformed(ActionEvent evt) {
        ++this.mClassSetting;
        this.mGameData = new GameData();
        this.clearAllGame();
        this.resetConfigPoolGame(false);
        this.jButtonCreateNewLevelObject.setEnabled(this.mLevelObjectDataPool != null);
        --this.mClassSetting;
    }

    private void jButtonSaveGameActionPerformed(ActionEvent evt) {
        this.readAllToCurrentGame();
        this.mGameDataPool.put(this.mGameData);
        this.mGameDataPool.save();
        ++this.mClassSetting;
        this.resetConfigPoolGame(true);
        this.jComboBoxNameGame.setSelectedItem(this.mGameData.mName);
        --this.mClassSetting;
    }

    private void jComboBoxNameGameActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        String key = this.jComboBoxNameGame.getSelectedItem().toString();
        this.mGameData = this.mGameDataPool.get(key);
        this.setAllFromCurrentGame();
        this.mLevelData = new LevelData();
        this.setAllFromCurrentLevel();
        this.resetConfigPoolGame(false);
        this.setAllFromCurrentGame();
    }

    private void jButtonCreateNewLevelObjectActionPerformed(ActionEvent evt) {
        ++this.mClassSetting;
        LevelObjectData mLevelObjectData = new LevelObjectData();
        this.addLevelObjectPanel(mLevelObjectData);
        --this.mClassSetting;
    }

    private void jComboBoxDefaultActionActionPerformed(ActionEvent evt) {
    }

    private void clearAllSprites() {
        ++this.mClassSetting;
        this.mSpriteData = new SpriteData();
        this.setAllFromCurrentSprites();
        this.clearAllActions();
        --this.mClassSetting;
    }

    private void setAllFromCurrentSprites() {
        ++this.mClassSetting;
        this.jComboBoxActionName.setSelectedItem(this.mSpriteData.mName);
        this.jTextFieldSpriteID.setText(this.mSpriteData.mName);
        this.resetConfigPoolActions(true);
        this.resetDefaultPoolActions();
        this.jComboBoxDefaultAction.setSelectedItem(this.mSpriteData.mDefaultActionID);
        this.jTextFieldSpriteUID.setText("" + this.mSpriteData.mspriteUID);
        --this.mClassSetting;
    }

    void levelNameEditEnabled() {
        boolean enabled = false;
        this.readAllToCurrentLevel();
        String klasse = this.getGameName() + "_Levels";
        Collection<ActionNewData> colC = this.mActionDataPool.getMapForKlasse(klasse).values();
        enabled = this.mLevelData.mName == null ? true : (this.mLevelData.mName.length() == 0 ? true : colC.isEmpty());
        this.jTextFieldNameGame.setEditable(enabled);
    }

    void spriteNameEditEnabled() {
        boolean enabled = false;
        this.readAllToCurrentSprites();
        String klasse = this.getSpriteName() + "_Actions";
        Collection<ActionNewData> colC = this.mActionDataPool.getMapForKlasse(klasse).values();
        enabled = this.mSpriteData.mName == null ? true : (this.mSpriteData.mName.length() == 0 ? true : colC.isEmpty());
        this.jTextFieldSpriteID.setEditable(enabled);
    }

    String getSpriteName() {
        this.mSpriteData.mName = this.jTextFieldSpriteID.getText();
        return this.mSpriteData.mName;
    }

    String getGameName() {
        this.readAllToCurrentGame();
        return this.mGameData.mName;
    }

    private void readAllToCurrentSprites() {
        this.mSpriteData.mClass = "AllSprites";
        this.mSpriteData.mName = this.jTextFieldSpriteID.getText();
        if (this.jComboBoxDefaultAction.getSelectedItem() != null) {
            this.mSpriteData.mDefaultActionID = this.jComboBoxDefaultAction.getSelectedItem().toString();
        } else if (this.mSpriteData.mDefaultActionID == null) {
            this.mSpriteData.mDefaultActionID = "";
        }
        this.mSpriteData.mspriteUID = UtilityString.Int0(this.jTextFieldSpriteUID.getText());
    }

    public static void showModPanelNoModal(VeccyPanel v) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        GamePanel panel = new GamePanel();
        if (v != null) {
            v.setGamePanel(panel);
            panel.veccy = v;
        }
        Configuration.getConfiguration().getMainFrame().addAsWindow(panel, 1080, 800, "Vector: GamePanel");
    }

    private void resetConfigPoolLevelObjects() {
        ++this.mClassSetting;
        Collection<String> collectionKlasse = this.mLevelObjectDataPool.getKlassenHashMap().values();
        Iterator<String> iterKlasse = collectionKlasse.iterator();
        boolean i = false;
        String klasse = this.mLevelData.mName;
        Collection<LevelObjectData> colC = this.mLevelObjectDataPool.getMapForKlasse(klasse).values();
        Iterator<LevelObjectData> iterC = colC.iterator();
        this.jPanelLevelObjectPanel.removeAll();
        while (iterC.hasNext()) {
            LevelObjectData item = iterC.next();
            this.addLevelObjectPanel(item);
        }
        this.jPanelLevelObjectPanel.invalidate();
        this.jPanelLevelObjectPanel.revalidate();
        this.jPanelLevelObjectPanel.repaint();
        --this.mClassSetting;
    }

    private void addLevelObjectPanel(LevelObjectData item) {
        ++this.mClassSetting;
        LevelObjectDataPanel panel = new LevelObjectDataPanel(this, item);
        this.jPanelLevelObjectPanel.add(panel);
        panel.updateObjectComboBox(item.mType);
        this.jPanelLevelObjectPanel.invalidate();
        this.jPanelLevelObjectPanel.revalidate();
        this.jPanelLevelObjectPanel.repaint();
        --this.mClassSetting;
    }

    public void saveLevelObject(LevelObjectData lodata) {
        lodata.mClass = this.mLevelData.mName;
        this.mLevelObjectDataPool.put(lodata);
        this.mLevelObjectDataPool.save();
        ++this.mClassSetting;
        --this.mClassSetting;
    }

    public void removeLevelObject(LevelObjectData lodata) {
        this.mLevelObjectDataPool.remove(lodata);
        this.mLevelObjectDataPool.save();
        ++this.mClassSetting;
        this.resetConfigPoolLevelObjects();
        --this.mClassSetting;
    }

    public void setAllLevelObjects() {
        if (this.mLevelObjectDataPool == null) {
            this.mLevelObjectDataPool = new LevelObjectDataPool();
        }
        this.resetConfigPoolLevelObjects();
    }

    void updateSpriteRefs() {
        this.resetConfigPoolLevelObjects();
    }

    void verifyLevelData(LevelData level) {
        String klasse = level.mName;
        Collection<LevelObjectData> colC = this.mLevelObjectDataPool.getMapForKlasse(klasse).values();
        Iterator<LevelObjectData> iterC = colC.iterator();
        SpriteDataPool localSpriteDataPool = new SpriteDataPool();
        while (iterC.hasNext()) {
            LevelObjectData o = iterC.next();
            if (!o.mType.equals("Sprite")) continue;
            SpriteData sprite = localSpriteDataPool.getMapForKlasse("AllSprites").get(o.mSpriteID);
            if (sprite == null) {
                System.out.println("SpriteID not found: " + o.mSpriteID);
                this.mLevelObjectDataPool.remove(o);
                continue;
            }
            ActionData action = this.getActionByID(sprite, sprite.mDefaultActionID);
            if (action != null) continue;
            System.out.println("Sprite has no default action: " + o.mSpriteID);
            this.mLevelObjectDataPool.remove(o);
        }
    }

    ActionData getActionByID(SpriteData sprite, String actionID) {
        ActionDataPool localActionDataPool = new ActionDataPool();
        Collection<ActionData> colCa = localActionDataPool.getMapForKlasse(sprite.mName + "_Actions").values();
        for (ActionData actionData : colCa) {
            if (!actionData.mName.equals(actionID)) continue;
            return actionData;
        }
        return null;
    }

    void copyActionFromSpriteToSprite(String fromName, String toName) {
    }

    void convertOldActionToNewAction() {
        ActionDataPool oldPool = new ActionDataPool();
        Collection<String> collectionKlasse = oldPool.getKlassenHashMap().values();
        for (String klasse : collectionKlasse) {
            Collection<ActionData> colC = oldPool.getMapForKlasse(klasse).values();
            for (ActionData oldAction : colC) {
                ActionNewDataPool newPool = this.mActionDataPool;
                String key = oldAction.mName;
                ActionNewData newAction = newPool.get(key);
                if (newAction != null) {
                    return;
                }
                newAction = new ActionNewData();
                this.mActionData.mtextHeight = 2;
                this.mActionData.mtextWidth = 50;
                newAction.mClass = oldAction.mClass;
                newAction.mName = oldAction.mName;
                newAction.manimationFile = oldAction.manimationFile;
                newAction.mchangeWhileActiveX = oldAction.mchangeWhileActiveX;
                newAction.mchangeWhileActiveY = oldAction.mchangeWhileActiveY;
                newAction.msoundLoop = oldAction.msoundLoop;
                newAction.msoundFile = oldAction.msoundFile;
                newAction.mbehaviour = oldAction.mbehaviour;
                newAction.mboundingBoxOffsetX = oldAction.mboundingBoxOffsetX;
                newAction.mtext = oldAction.mtext;
                newAction.mtextType = oldAction.mtextType;
                newAction.mtextHeight = oldAction.mtextHeight;
                newAction.mtextWidth = oldAction.mtextWidth;
                newAction.misEnemy = oldAction.misEnemy;
                newAction.mboundingBoxOffsetY = oldAction.mboundingBoxOffsetY;
                newAction.misPlayerShot = oldAction.misPlayerShot;
                newAction.misEnemyShot = oldAction.misEnemyShot;
                newAction.mintensity = oldAction.mintensity;
                newAction.mpositioning = oldAction.mpositioning;
                ActionTriggerDataPool mTriggerPool = new ActionTriggerDataPool();
                ActionResultDataPool mResultPool = new ActionResultDataPool();
                for (int i = 0; i < oldAction.mtriggerByCause.size(); ++i) {
                    String uid = UUID.randomUUID().toString();
                    newAction.meventUID.addElement(uid);
                    newAction.meventName.addElement("" + i);
                    ActionTriggerData triggers = new ActionTriggerData();
                    triggers.mtriggerByCause = new Vector();
                    triggers.mtriggerBySpriteID = new Vector();
                    triggers.mtriggerByY = new Vector();
                    triggers.mtriggerByX = new Vector();
                    triggers.mtriggerByTicks = new Vector();
                    triggers.mtriggerByCause.addElement(oldAction.mtriggerByCause.elementAt(i));
                    triggers.mtriggerBySpriteID.addElement(oldAction.mtriggerBySpriteID.elementAt(i));
                    triggers.mtriggerByY.addElement(oldAction.mtriggerByY.elementAt(i));
                    triggers.mtriggerByX.addElement(oldAction.mtriggerByX.elementAt(i));
                    triggers.mtriggerByTicks.addElement(oldAction.mtriggerByTicks.elementAt(i));
                    triggers.mClass = uid;
                    triggers.mName = uid;
                    String triggerName = "";
                    if (triggers.mtriggerByCause.size() > 0) {
                        triggerName = triggerName + triggers.mtriggerByCause.elementAt(0);
                    }
                    if (triggers.mtriggerBySpriteID.size() > 0 && triggers.mtriggerBySpriteID.elementAt(0).trim().length() > 0) {
                        triggerName = triggerName + " " + triggers.mtriggerBySpriteID.elementAt(0);
                    }
                    if (triggers.mtriggerByY.size() > 0 && triggers.mtriggerByY.elementAt(0) != 0) {
                        triggerName = triggerName + " Y:" + triggers.mtriggerByY.elementAt(0);
                    }
                    if (triggers.mtriggerByX.size() > 0 && triggers.mtriggerByX.elementAt(0) != 0) {
                        triggerName = triggerName + " X:" + triggers.mtriggerByX.elementAt(0);
                    }
                    if (triggers.mtriggerByTicks.size() > 0 && triggers.mtriggerByTicks.elementAt(0).trim().length() > 0 && !triggers.mtriggerByTicks.elementAt(0).trim().startsWith("0")) {
                        triggerName = triggerName + " Ticks:" + triggers.mtriggerByTicks.elementAt(0);
                    }
                    newAction.mtriggerName.addElement("" + i + "." + triggerName);
                    ActionResultData results = new ActionResultData();
                    results.mresultType = new Vector();
                    results.mresultActionID = new Vector();
                    results.mresultSpriteID = new Vector();
                    results.mresultY = new Vector();
                    results.mresultX = new Vector();
                    results.mresultType.addElement(oldAction.mtriggerByTarget.elementAt(i));
                    results.mresultActionID.addElement(oldAction.mtriggerByActionID.elementAt(i));
                    results.mresultSpriteID.addElement(oldAction.mtriggerBySpriteID.elementAt(i));
                    results.mresultY.addElement(oldAction.mtriggerResultY.elementAt(i));
                    results.mresultX.addElement(oldAction.mtriggerResultX.elementAt(i));
                    results.mClass = uid;
                    results.mName = uid;
                    String resultName = "";
                    if (results.mresultType.size() > 0) {
                        resultName = resultName + results.mresultType.elementAt(0);
                    }
                    if (results.mresultActionID.size() > 0 && results.mresultActionID.elementAt(0).trim().length() > 0) {
                        resultName = resultName + " " + results.mresultActionID.elementAt(0);
                    }
                    if (results.mresultSpriteID.size() > 0 && results.mresultSpriteID.elementAt(0).trim().length() > 0) {
                        resultName = resultName + " Sprite:" + results.mresultSpriteID.elementAt(0);
                    }
                    if (results.mresultY.size() > 0 && results.mresultY.elementAt(0).trim().length() > 0 && !results.mresultY.elementAt(0).trim().startsWith("0")) {
                        resultName = resultName + " Y:" + results.mresultY.elementAt(0);
                    }
                    if (results.mresultX.size() > 0 && results.mresultX.elementAt(0).trim().length() > 0 && !results.mresultX.elementAt(0).trim().startsWith("0")) {
                        resultName = resultName + " X:" + results.mresultX.elementAt(0);
                    }
                    newAction.mresultName.addElement("" + i + "." + resultName);
                    mTriggerPool.put(triggers);
                    mResultPool.put(results);
                }
                mTriggerPool.save();
                mResultPool.save();
                this.mActionDataPool.put(newAction);
                this.mActionDataPool.save();
            }
        }
    }
}

