/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.veccy;

import de.malban.Global;
import de.malban.vide.veccy.LevelData;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

public class LevelDataPool {
    public static final String DEFAULT_XML_NAME = new String("LevelData.xml");
    private String mFileName = DEFAULT_XML_NAME;
    private HashMap<String, LevelData> mLevelData = new HashMap();
    private HashMap<String, String> mKlassenMap = new HashMap();

    public LevelDataPool(String name) {
        this.mFileName = name;
        this.init();
    }

    public LevelDataPool() {
        this.init();
    }

    public void setFilename(String n) {
        this.mFileName = n;
    }

    private boolean init() {
        try {
            return this.load();
        }
        catch (Throwable e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Load Error LevelData...", 1);
            return false;
        }
    }

    public boolean load() {
        File f = new File(Global.mBaseDir + this.mFileName);
        if (!f.exists()) {
            return false;
        }
        this.mLevelData = LevelData.getHashMapFromXML(this.mFileName);
        return true;
    }

    public void save() {
        LevelData.saveCollectionAsXML(this.mFileName, this.mLevelData.values());
        this.buildKlassenMap();
    }

    public void remove(LevelData st) {
        this.mLevelData.remove(st.mName);
    }

    public void put(LevelData st) {
        this.mLevelData.remove(st.mName);
        this.mLevelData.put(st.mName, st);
    }

    public void putAsNew(LevelData st) {
        this.mLevelData.put(st.mName, st);
    }

    public LevelData get(String key) {
        return this.mLevelData.get(key);
    }

    public HashMap<String, LevelData> getHashMap() {
        return this.mLevelData;
    }

    private void buildKlassenMap() {
        this.mKlassenMap = new HashMap();
        Set<Map.Entry<String, LevelData>> entries = this.mLevelData.entrySet();
        for (Map.Entry<String, LevelData> entry : entries) {
            LevelData value = entry.getValue();
            this.mKlassenMap.put(value.mClass, value.mClass);
        }
    }

    public HashMap<String, String> getKlassenHashMap() {
        this.buildKlassenMap();
        return this.mKlassenMap;
    }

    public HashMap<String, LevelData> getMapForKlasse(String klasse) {
        HashMap<String, LevelData> ret = new HashMap<String, LevelData>();
        Set<Map.Entry<String, LevelData>> entries = this.mLevelData.entrySet();
        for (Map.Entry<String, LevelData> entry : entries) {
            LevelData value = entry.getValue();
            if (!value.mClass.equalsIgnoreCase(klasse)) continue;
            ret.put(value.mName, value);
        }
        return ret;
    }
}

