/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.veccy;

import de.malban.Global;
import de.malban.util.UtilityString;
import de.malban.vide.veccy.LevelObjectDataXMLHandler;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class LevelObjectData {
    protected String mClass = "";
    public String mName = "";
    protected String mType = "";
    protected String mSpriteID = "";
    protected String mxPos = "";
    protected String myPos = "";
    protected String mScene = "";
    protected int mMaxLiveObjects = 0;
    protected boolean mLiveOnInit = false;
    private static LevelObjectDataXMLHandler XMLHANDLER = new LevelObjectDataXMLHandler();

    public String getName() {
        return this.mName;
    }

    public void setName(String n) {
        this.mName = n;
    }

    public String getCClass() {
        return this.mClass;
    }

    public void setCClass(String c) {
        this.mClass = c;
    }

    public String getType() {
        return this.mType;
    }

    public void setType(String Type2) {
        this.mType = Type2;
    }

    public String getSpriteID() {
        return this.mSpriteID;
    }

    public void setSpriteID(String SpriteID2) {
        this.mSpriteID = SpriteID2;
    }

    public String getxPos() {
        return this.mxPos;
    }

    public void setxPos(String xPos) {
        this.mxPos = xPos;
    }

    public String getyPos() {
        return this.myPos;
    }

    public void setyPos(String yPos) {
        this.myPos = yPos;
    }

    public String getScene() {
        return this.mScene;
    }

    public void setScene(String Scene) {
        this.mScene = Scene;
    }

    public int getMaxLiveObjects() {
        return this.mMaxLiveObjects;
    }

    public void setMaxLiveObjects(int MaxLiveObjects) {
        this.mMaxLiveObjects = MaxLiveObjects;
    }

    public boolean getLiveOnInit() {
        return this.mLiveOnInit;
    }

    public void setLiveOnInit(boolean LiveOnInit) {
        this.mLiveOnInit = LiveOnInit;
    }

    private String exportXML() {
        StringBuffer s = new StringBuffer();
        s.append("\t<LevelObjectData>\n");
        s.append("\t\t<Class>" + UtilityString.toXML(this.mClass) + "</Class>\n");
        s.append("\t\t<Name>" + UtilityString.toXML(this.mName) + "</Name>\n");
        s.append("\t\t<Type>" + UtilityString.toXML(this.mType) + "</Type>\n");
        s.append("\t\t<SpriteID>" + UtilityString.toXML(this.mSpriteID) + "</SpriteID>\n");
        s.append("\t\t<xPos>" + UtilityString.toXML(this.mxPos) + "</xPos>\n");
        s.append("\t\t<yPos>" + UtilityString.toXML(this.myPos) + "</yPos>\n");
        s.append("\t\t<Scene>" + UtilityString.toXML(this.mScene) + "</Scene>\n");
        s.append("\t\t<MaxLiveObjects>" + this.mMaxLiveObjects + "</MaxLiveObjects>\n");
        s.append("\t\t<LiveOnInit>" + this.mLiveOnInit + "</LiveOnInit>\n");
        s.append("\t</LevelObjectData>\n");
        return s.toString();
    }

    public String toString() {
        return this.mName;
    }

    public static LevelObjectDataXMLHandler getXMLParseHandler() {
        return XMLHANDLER;
    }

    public static boolean saveCollectionAsXML(String filename, Collection<LevelObjectData> col) {
        return LevelObjectData.saveCollectionAsXML(Global.mBaseDir, filename, col);
    }

    public static boolean saveCollectionAsXML(String pathName, String filename, Collection<LevelObjectData> col) {
        try {
            PrintWriter pw = new PrintWriter(pathName + filename, "UTF-8");
            pw.print("<?xml version=\"1.0\"?>\n");
            pw.print("<AllLevelObjectData>\n");
            for (LevelObjectData item : col) {
                pw.print(item.exportXML());
            }
            pw.print("</AllLevelObjectData>\n");
            pw.close();
        }
        catch (IOException e) {
            System.err.println(e.toString());
            return false;
        }
        return true;
    }

    public static HashMap<String, LevelObjectData> getHashMapFromXML(String filename) {
        HashMap<String, LevelObjectData> filters = new HashMap<String, LevelObjectData>();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            LevelObjectDataXMLHandler h = LevelObjectData.getXMLParseHandler();
            saxParser.parse(Global.mBaseDir + filename, (DefaultHandler)h);
            filters = h.getLastHashMap();
        }
        catch (Throwable e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.toString(), "LevelObjectData Load Error...", 1);
        }
        return filters;
    }
}

