/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.veccy;

import de.malban.util.UtilityString;
import de.malban.vide.veccy.BackGroundScene;
import de.malban.vide.veccy.BackGroundScenePool;
import de.malban.vide.veccy.GamePanel;
import de.malban.vide.veccy.LevelObjectData;
import de.malban.vide.veccy.SpriteData;
import de.malban.vide.veccy.SpriteDataPool;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class LevelObjectDataPanel
extends JPanel {
    private LevelObjectData mLevelObjectData = new LevelObjectData();
    private int mClassSetting = 0;
    private GamePanel parent;
    private JButton jButtonDelete;
    private JButton jButtonLoad2;
    private JButton jButtonSave;
    private JCheckBox jCheckBoxLiveOnStart;
    private JComboBox jComboBoxLevelObject;
    private JComboBox<String> jComboBoxObjectType;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JTextField jTextFieldMaxLifeInstances;
    private JTextField jTextFieldName;
    private JTextField jTextFieldVectorlistFile;
    private JTextField jTextFieldposX;
    private JTextField jTextFieldposY;

    public LevelObjectData getLevelObject() {
        return this.mLevelObjectData;
    }

    public LevelObjectDataPanel(GamePanel p, LevelObjectData o) {
        this.parent = p;
        this.mLevelObjectData = o;
        this.initComponents();
        this.setAllFromCurrent();
    }

    private void setAllFromCurrent() {
        ++this.mClassSetting;
        this.jTextFieldName.setText(this.mLevelObjectData.mName);
        if (this.mLevelObjectData.mType != null && this.mLevelObjectData.mType.length() > 0) {
            this.jComboBoxObjectType.setSelectedItem(this.mLevelObjectData.mType);
        }
        this.updateObjectComboBox(this.mLevelObjectData.mType);
        this.jTextFieldposX.setText("" + this.mLevelObjectData.mxPos);
        this.jTextFieldposY.setText("" + this.mLevelObjectData.myPos);
        if (this.mLevelObjectData.mType.equals(128)) {
            this.jComboBoxLevelObject.setSelectedItem(this.mLevelObjectData.mSpriteID);
        }
        this.jTextFieldMaxLifeInstances.setText("" + this.mLevelObjectData.mMaxLiveObjects);
        this.jCheckBoxLiveOnStart.setSelected(this.mLevelObjectData.mLiveOnInit);
        boolean enabled = true;
        if (this.mLevelObjectData.mType.equals("Background Scene")) {
            enabled = false;
        }
        this.jTextFieldposY.setEnabled(enabled);
        this.jTextFieldposX.setEnabled(enabled);
        this.jTextFieldMaxLifeInstances.setEnabled(enabled);
        this.jCheckBoxLiveOnStart.setEnabled(enabled);
        this.jLabel7.setEnabled(enabled);
        this.jLabel1.setEnabled(enabled);
        --this.mClassSetting;
    }

    private void readAllToCurrent() {
        this.mLevelObjectData.mName = this.jTextFieldName.getText();
        this.mLevelObjectData.mType = "Sprite";
        if (this.jComboBoxObjectType.getSelectedItem() != null) {
            this.mLevelObjectData.mType = this.jComboBoxObjectType.getSelectedItem().toString();
        }
        this.mLevelObjectData.mxPos = this.jTextFieldposX.getText();
        this.mLevelObjectData.myPos = this.jTextFieldposY.getText();
        this.mLevelObjectData.mMaxLiveObjects = UtilityString.IntX(this.jTextFieldMaxLifeInstances.getText(), 1);
        this.mLevelObjectData.mLiveOnInit = this.jCheckBoxLiveOnStart.isSelected();
        this.mLevelObjectData.mSpriteID = "";
        if (this.jComboBoxLevelObject.getSelectedItem() != null) {
            this.mLevelObjectData.mSpriteID = this.jComboBoxLevelObject.getSelectedItem().toString();
            this.mLevelObjectData.mScene = this.jComboBoxLevelObject.getSelectedItem().toString();
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jButtonSave = new JButton();
        this.jButtonDelete = new JButton();
        this.jPanel3 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jComboBoxObjectType = new JComboBox();
        this.jLabel7 = new JLabel();
        this.jTextFieldposY = new JTextField();
        this.jTextFieldposX = new JTextField();
        this.jLabel8 = new JLabel();
        this.jButtonLoad2 = new JButton();
        this.jTextFieldVectorlistFile = new JTextField();
        this.jComboBoxLevelObject = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jTextFieldMaxLifeInstances = new JTextField();
        this.jCheckBoxLiveOnStart = new JCheckBox();
        this.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel3.setText("Name");
        this.jButtonSave.setText("Save");
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LevelObjectDataPanel.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LevelObjectDataPanel.this.jButtonDeleteActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addGap(19, 19, 19).addComponent(this.jTextFieldName, -2, 109, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonSave).addGap(31, 31, 31).addComponent(this.jButtonDelete).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldName, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.jButtonSave).addComponent(this.jButtonDelete)));
        this.jLabel6.setText("type");
        this.jComboBoxObjectType.setModel(new DefaultComboBoxModel<String>(new String[]{"Sprite", "Background Scene", "YM File (not done)", "Arkos Tracker 1 (bin) (not done)", "Arkos Tracker 2 (aky asm) (not done)", "Foreground VList (not done)", "Global variable (not done)"}));
        this.jComboBoxObjectType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LevelObjectDataPanel.this.jComboBoxObjectTypeActionPerformed(evt);
            }
        });
        this.jLabel7.setText("y, x");
        this.jTextFieldposY.setHorizontalAlignment(11);
        this.jTextFieldposY.setText("0");
        this.jTextFieldposY.setToolTipText("csv start positions y");
        this.jTextFieldposY.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LevelObjectDataPanel.this.jTextFieldposYFocusLost(evt);
            }
        });
        this.jTextFieldposY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LevelObjectDataPanel.this.jTextFieldposYActionPerformed(evt);
            }
        });
        this.jTextFieldposX.setHorizontalAlignment(11);
        this.jTextFieldposX.setText("0");
        this.jTextFieldposX.setToolTipText("csv start positions x");
        this.jTextFieldposX.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LevelObjectDataPanel.this.jTextFieldposXFocusLost(evt);
            }
        });
        this.jTextFieldposX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LevelObjectDataPanel.this.jTextFieldposXActionPerformed(evt);
            }
        });
        this.jLabel8.setText("ID/Name/File");
        this.jButtonLoad2.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_go.png")));
        this.jButtonLoad2.setToolTipText("load animation");
        this.jButtonLoad2.setEnabled(false);
        this.jButtonLoad2.setMargin(new Insets(0, 1, 0, -1));
        this.jTextFieldVectorlistFile.setEnabled(false);
        this.jComboBoxLevelObject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LevelObjectDataPanel.this.jComboBoxLevelObjectActionPerformed(evt);
            }
        });
        this.jLabel1.setText("max life instances");
        this.jTextFieldMaxLifeInstances.setText("-1");
        this.jTextFieldMaxLifeInstances.setToolTipText("This is only check if >0!");
        this.jCheckBoxLiveOnStart.setText("live on start");
        this.jCheckBoxLiveOnStart.setToolTipText("");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.jLabel7)).addGap(20, 20, 20).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jComboBoxObjectType, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel8)).addComponent(this.jTextFieldposY, -2, 297, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jComboBoxLevelObject, -2, 146, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldVectorlistFile, -2, 153, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonLoad2)).addComponent(this.jTextFieldposX))).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldMaxLifeInstances, -2, 43, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxLiveOnStart))).addContainerGap(95, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jComboBoxObjectType, -2, -1, -2).addComponent(this.jLabel8).addComponent(this.jComboBoxLevelObject, -2, -1, -2).addComponent(this.jTextFieldVectorlistFile, -2, -1, -2)).addComponent(this.jButtonLoad2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addComponent(this.jTextFieldposX, -2, -1, -2).addComponent(this.jTextFieldposY, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 6, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldMaxLifeInstances, -2, -1, -2).addComponent(this.jCheckBoxLiveOnStart))));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -1, -1, -2)));
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        this.readAllToCurrent();
        ++this.mClassSetting;
        this.parent.saveLevelObject(this.mLevelObjectData);
        --this.mClassSetting;
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.readAllToCurrent();
        ++this.mClassSetting;
        this.parent.removeLevelObject(this.mLevelObjectData);
        this.mLevelObjectData = null;
        this.parent = null;
        --this.mClassSetting;
    }

    private void jComboBoxObjectTypeActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        ++this.mClassSetting;
        if (this.jComboBoxObjectType.getSelectedItem() != null) {
            if (this.jComboBoxObjectType.getSelectedItem().toString().equals("Sprite")) {
                this.updateObjectComboBox(this.jComboBoxObjectType.getSelectedItem().toString());
                this.jTextFieldposY.setEnabled(true);
                this.jTextFieldposX.setEnabled(true);
                this.jTextFieldMaxLifeInstances.setEnabled(true);
                this.jCheckBoxLiveOnStart.setEnabled(true);
                this.jLabel7.setEnabled(true);
                this.jLabel1.setEnabled(true);
            } else if (this.jComboBoxObjectType.getSelectedItem().toString().equals("Background Scene")) {
                this.updateObjectComboBox(this.jComboBoxObjectType.getSelectedItem().toString());
                this.jTextFieldposY.setEnabled(false);
                this.jTextFieldposX.setEnabled(false);
                this.jTextFieldMaxLifeInstances.setEnabled(false);
                this.jCheckBoxLiveOnStart.setEnabled(false);
                this.jLabel7.setEnabled(false);
                this.jLabel1.setEnabled(false);
            }
        }
        --this.mClassSetting;
    }

    private void jTextFieldposYFocusLost(FocusEvent evt) {
    }

    private void jTextFieldposYActionPerformed(ActionEvent evt) {
    }

    private void jTextFieldposXFocusLost(FocusEvent evt) {
    }

    private void jTextFieldposXActionPerformed(ActionEvent evt) {
    }

    private void jComboBoxLevelObjectActionPerformed(ActionEvent evt) {
    }

    public void updateObjectComboBox(String type) {
        if (this.mLevelObjectData.mType == null) {
            return;
        }
        ++this.mClassSetting;
        if (type.equals("Background Scene")) {
            BackGroundScenePool sceneDataPool = new BackGroundScenePool();
            Collection<String> collectionKlasse = sceneDataPool.getKlassenHashMap().values();
            Iterator<String> iterKlasse = collectionKlasse.iterator();
            boolean i = false;
            String klasse = "AllScenes";
            Collection<BackGroundScene> colC = sceneDataPool.getMapForKlasse(klasse).values();
            Iterator<BackGroundScene> iterC = colC.iterator();
            String oldValue = "";
            if (this.jComboBoxLevelObject.getSelectedItem() != null) {
                oldValue = this.jComboBoxLevelObject.getSelectedItem().toString();
            }
            if (oldValue.length() == 0) {
                oldValue = this.mLevelObjectData.mScene;
            }
            this.jComboBoxLevelObject.removeAllItems();
            ArrayList<String> items = new ArrayList<String>();
            boolean found = false;
            while (iterC.hasNext()) {
                BackGroundScene item = iterC.next();
                items.add(item.mName);
            }
            Collections.sort(items, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareToIgnoreCase(o2);
                }
            });
            for (int ii = 0; ii < items.size(); ++ii) {
                String item = (String)items.get(ii);
                this.jComboBoxLevelObject.addItem(item);
                if (!item.equals(oldValue)) continue;
                found = true;
            }
            if (oldValue.length() > 0 && found) {
                this.jComboBoxLevelObject.setSelectedItem(oldValue);
            }
        } else {
            SpriteDataPool spriteDataPool = new SpriteDataPool();
            Collection<String> collectionKlasse = spriteDataPool.getKlassenHashMap().values();
            Iterator<String> iterKlasse = collectionKlasse.iterator();
            boolean i = false;
            String klasse = "AllSprites";
            Collection<SpriteData> colC = spriteDataPool.getMapForKlasse(klasse).values();
            Iterator<SpriteData> iterC = colC.iterator();
            String oldValue = "";
            if (this.jComboBoxLevelObject.getSelectedItem() != null) {
                oldValue = this.jComboBoxLevelObject.getSelectedItem().toString();
            }
            if (oldValue.length() == 0) {
                oldValue = this.mLevelObjectData.mSpriteID;
            }
            this.jComboBoxLevelObject.removeAllItems();
            ArrayList<String> items = new ArrayList<String>();
            boolean found = false;
            while (iterC.hasNext()) {
                SpriteData item = iterC.next();
                items.add(item.mName);
            }
            Collections.sort(items, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareToIgnoreCase(o2);
                }
            });
            for (int ii = 0; ii < items.size(); ++ii) {
                String item = (String)items.get(ii);
                this.jComboBoxLevelObject.addItem(item);
                if (!item.equals(oldValue)) continue;
                found = true;
            }
            if (oldValue.length() > 0 && found) {
                this.jComboBoxLevelObject.setSelectedItem(oldValue);
            }
        }
        --this.mClassSetting;
    }
}

