/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.veccy;

import de.malban.Global;
import de.malban.util.UtilityString;
import de.malban.vide.veccy.SpriteDataXMLHandler;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class SpriteData {
    protected String mClass = "";
    public String mName = "";
    protected Vector<String> mActionID = new Vector();
    protected String mDefaultActionID = "";
    protected int mspriteUID = 0;
    private static SpriteDataXMLHandler XMLHANDLER = new SpriteDataXMLHandler();

    public String getName() {
        return this.mName;
    }

    public void setName(String n) {
        this.mName = n;
    }

    public String getCClass() {
        return this.mClass;
    }

    public void setCClass(String c) {
        this.mClass = c;
    }

    public Vector<String> getActionID() {
        return this.mActionID;
    }

    public void setActionID(Vector<String> ActionID2) {
        this.mActionID = ActionID2;
    }

    public String getDefaultActionID() {
        return this.mDefaultActionID;
    }

    public void setDefaultActionID(String DefaultActionID) {
        this.mDefaultActionID = DefaultActionID;
    }

    public int getspriteUID() {
        return this.mspriteUID;
    }

    public void setspriteUID(int spriteUID) {
        this.mspriteUID = spriteUID;
    }

    private String exportXML() {
        StringBuffer s = new StringBuffer();
        s.append("\t<SpriteData>\n");
        s.append("\t\t<Class>" + UtilityString.toXML(this.mClass) + "</Class>\n");
        s.append("\t\t<Name>" + UtilityString.toXML(this.mName) + "</Name>\n");
        s.append("\t\t<ActionIDs>\n");
        for (int i = 0; i < this.mActionID.size(); ++i) {
            s.append("\t\t\t<ActionID>" + UtilityString.toXML(this.mActionID.elementAt(i)) + "</ActionID>\n");
        }
        s.append("\t\t</ActionIDs>\n");
        s.append("\t\t<DefaultActionID>" + UtilityString.toXML(this.mDefaultActionID) + "</DefaultActionID>\n");
        s.append("\t\t<spriteUID>" + this.mspriteUID + "</spriteUID>\n");
        s.append("\t</SpriteData>\n");
        return s.toString();
    }

    public String toString() {
        return this.mName;
    }

    public static SpriteDataXMLHandler getXMLParseHandler() {
        return XMLHANDLER;
    }

    public static boolean saveCollectionAsXML(String filename, Collection<SpriteData> col) {
        return SpriteData.saveCollectionAsXML(Global.mBaseDir, filename, col);
    }

    public static boolean saveCollectionAsXML(String pathName, String filename, Collection<SpriteData> col) {
        try {
            PrintWriter pw = new PrintWriter(pathName + filename, "UTF-8");
            pw.print("<?xml version=\"1.0\"?>\n");
            pw.print("<AllSpriteData>\n");
            for (SpriteData item : col) {
                pw.print(item.exportXML());
            }
            pw.print("</AllSpriteData>\n");
            pw.close();
        }
        catch (IOException e) {
            System.err.println(e.toString());
            return false;
        }
        return true;
    }

    public static HashMap<String, SpriteData> getHashMapFromXML(String filename) {
        HashMap<String, SpriteData> filters = new HashMap<String, SpriteData>();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            SpriteDataXMLHandler h = SpriteData.getXMLParseHandler();
            saxParser.parse(Global.mBaseDir + filename, (DefaultHandler)h);
            filters = h.getLastHashMap();
        }
        catch (Throwable e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.toString(), "SpriteData Load Error...", 1);
        }
        return filters;
    }
}

