/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.veccy;

import de.malban.Global;
import de.malban.vide.veccy.SpriteData;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

public class SpriteDataPool {
    public static final String DEFAULT_XML_NAME = new String("SpriteData.xml");
    private String mFileName = DEFAULT_XML_NAME;
    private HashMap<String, SpriteData> mSpriteData = new HashMap();
    private HashMap<String, String> mKlassenMap = new HashMap();

    public SpriteDataPool(String name) {
        this.mFileName = name;
        this.init();
    }

    public SpriteDataPool() {
        this.init();
    }

    public void setFilename(String n) {
        this.mFileName = n;
    }

    private boolean init() {
        try {
            return this.load();
        }
        catch (Throwable e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Load Error SpriteData...", 1);
            return false;
        }
    }

    public boolean load() {
        File f = new File(Global.mBaseDir + this.mFileName);
        if (!f.exists()) {
            return false;
        }
        this.mSpriteData = SpriteData.getHashMapFromXML(this.mFileName);
        return true;
    }

    public void save() {
        SpriteData.saveCollectionAsXML(this.mFileName, this.mSpriteData.values());
        this.buildKlassenMap();
    }

    public void remove(SpriteData st) {
        this.mSpriteData.remove(st.mName);
    }

    public void put(SpriteData st) {
        this.mSpriteData.remove(st.mName);
        this.mSpriteData.put(st.mName, st);
    }

    public void putAsNew(SpriteData st) {
        this.mSpriteData.put(st.mName, st);
    }

    public SpriteData get(String key) {
        return this.mSpriteData.get(key);
    }

    public HashMap<String, SpriteData> getHashMap() {
        return this.mSpriteData;
    }

    private void buildKlassenMap() {
        this.mKlassenMap = new HashMap();
        Set<Map.Entry<String, SpriteData>> entries = this.mSpriteData.entrySet();
        for (Map.Entry<String, SpriteData> entry : entries) {
            SpriteData value = entry.getValue();
            this.mKlassenMap.put(value.mClass, value.mClass);
        }
    }

    public HashMap<String, String> getKlassenHashMap() {
        this.buildKlassenMap();
        return this.mKlassenMap;
    }

    public HashMap<String, SpriteData> getMapForKlasse(String klasse) {
        HashMap<String, SpriteData> ret = new HashMap<String, SpriteData>();
        Set<Map.Entry<String, SpriteData>> entries = this.mSpriteData.entrySet();
        for (Map.Entry<String, SpriteData> entry : entries) {
            SpriteData value = entry.getValue();
            if (!value.mClass.equalsIgnoreCase(klasse)) continue;
            ret.put(value.mName, value);
        }
        return ret;
    }
}

