/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.veccy;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.graphics.GFXVectorAnimation;
import de.malban.graphics.Single3dDisplayPanel;
import de.malban.gui.panels.LogPanel;
import de.malban.util.UtilityString;
import de.malban.util.XMLSupport;
import de.malban.vide.veccy.StoryboardElement;
import de.malban.vide.veccy.StoryboardPanelInterface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public class StoryboardLanePanel
extends JPanel {
    LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    private static int uidcount = 0;
    private int uid = uidcount++;
    ArrayList<StoryboardElement> elements = new ArrayList();
    StoryboardPanelInterface sb = null;
    private JButton jButton4;
    private JButton jButtonOneBack;
    private JButton jButtonOneForward;
    private Single3dDisplayPanel storyelement;

    public StoryboardLanePanel() {
        this.initComponents();
    }

    public boolean isVersion1() {
        for (StoryboardElement element : this.elements) {
            if (element.version != 1) continue;
            return true;
        }
        return false;
    }

    public StoryboardLanePanel(StoryboardPanelInterface s) {
        this.initComponents();
        this.remove(this.storyelement);
        this.sb = s;
    }

    private void initComponents() {
        this.jButton4 = new JButton();
        this.storyelement = new Single3dDisplayPanel();
        this.jButtonOneForward = new JButton();
        this.jButtonOneBack = new JButton();
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                StoryboardLanePanel.this.formMousePressed(evt);
            }
        });
        this.setLayout(null);
        this.jButton4.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/add.png")));
        this.jButton4.setPreferredSize(new Dimension(20, 20));
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardLanePanel.this.jButton4ActionPerformed(evt);
            }
        });
        this.add(this.jButton4);
        this.jButton4.setBounds(1, 1, 20, 20);
        this.storyelement.setMaximumSize(new Dimension(150, 150));
        this.storyelement.setMinimumSize(new Dimension(150, 150));
        GroupLayout storyelementLayout = new GroupLayout(this.storyelement);
        this.storyelement.setLayout(storyelementLayout);
        storyelementLayout.setHorizontalGroup(storyelementLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        storyelementLayout.setVerticalGroup(storyelementLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.add(this.storyelement);
        this.storyelement.setBounds(26, 1, 120, 77);
        this.jButtonOneForward.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/arrow_right.png")));
        this.jButtonOneForward.setToolTipText("moves one to the right.");
        this.jButtonOneForward.setPreferredSize(new Dimension(20, 20));
        this.jButtonOneForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardLanePanel.this.jButtonOneForwardActionPerformed(evt);
            }
        });
        this.add(this.jButtonOneForward);
        this.jButtonOneForward.setBounds(1, 22, 20, 20);
        this.jButtonOneBack.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/arrow_left.png")));
        this.jButtonOneBack.setToolTipText("moves one to the left.");
        this.jButtonOneBack.setPreferredSize(new Dimension(20, 20));
        this.jButtonOneBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardLanePanel.this.jButtonOneBackActionPerformed(evt);
            }
        });
        this.add(this.jButtonOneBack);
        this.jButtonOneBack.setBounds(1, 43, 20, 20);
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.addStoryelement(true);
    }

    private void formMousePressed(MouseEvent evt) {
        this.sb.setElement(null, this);
    }

    private void jButtonOneForwardActionPerformed(ActionEvent evt) {
        StoryboardLanePanel lane = this.sb.getCurrentLane();
        if (lane != this) {
            return;
        }
        StoryboardElement element = this.sb.getCurrentElement();
        if (element == null) {
            return;
        }
        int index = this.elements.indexOf(element);
        if (index == -1) {
            return;
        }
        if (index == this.elements.size() - 1) {
            return;
        }
        Component[] cs = this.getComponents();
        int cindex = -1;
        for (int i = 0; i < cs.length; ++i) {
            if (cs[i] != element) continue;
            cindex = i;
            break;
        }
        if (cindex == -1) {
            return;
        }
        if (cindex == cs.length - 1) {
            return;
        }
        this.elements.remove(index);
        this.elements.add(index + 1, element);
        this.remove(cindex);
        this.add((Component)element, cindex + 1);
        this.reorder();
        this.sb.updateBounds();
        this.sb.setElement(element, this);
        this.repaint();
    }

    private void jButtonOneBackActionPerformed(ActionEvent evt) {
        StoryboardLanePanel lane = this.sb.getCurrentLane();
        if (lane != this) {
            return;
        }
        StoryboardElement element = this.sb.getCurrentElement();
        if (element == null) {
            return;
        }
        int index = this.elements.indexOf(element);
        if (index == -1) {
            return;
        }
        if (index == 0) {
            return;
        }
        Component[] cs = this.getComponents();
        int cindex = -1;
        for (int i = 0; i < cs.length; ++i) {
            if (cs[i] != element) continue;
            cindex = i;
            break;
        }
        if (cindex == -1) {
            return;
        }
        if (cindex == 0) {
            return;
        }
        this.elements.remove(index);
        this.elements.add(index - 1, element);
        this.remove(cindex);
        this.add((Component)element, cindex - 1);
        this.reorder();
        this.sb.updateBounds();
        this.sb.setElement(element, this);
        this.repaint();
    }

    private void storyelementMousePressed(MouseEvent evt) {
        if (evt.getSource() instanceof StoryboardElement) {
            this.sb.setElement((StoryboardElement)evt.getSource(), this);
        }
    }

    StoryboardElement addStoryelement(boolean setIt) {
        StoryboardElement se = new StoryboardElement();
        se.setAxisAngleX(0);
        se.setAxisAngleY(0);
        se.setAxisAngleZ(0);
        se.version = this.sb.getVersion();
        se.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                StoryboardLanePanel.this.storyelementMousePressed(evt);
            }
        });
        this.add(se);
        se.setBounds(26 + this.elements.size() * 130, 1, 120, 77);
        this.elements.add(se);
        Rectangle bounds = this.getBounds();
        bounds.width += 130;
        this.setBounds(bounds);
        this.sb.updateBounds();
        if (setIt) {
            this.sb.setElement(se, this);
        }
        return se;
    }

    void reorder() {
        int width = 26;
        int count = 0;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component c = this.getComponent(i);
            if (!(c instanceof StoryboardElement)) continue;
            StoryboardElement e = (StoryboardElement)c;
            e.setBounds(26 + count * 130, 1, 120, 77);
            ++count;
            width += 130;
        }
        Rectangle bounds = this.getBounds();
        bounds.width = width;
        this.setBounds(bounds);
        this.sb.updateBounds();
        this.repaint();
    }

    public boolean toXML(StringBuilder s, String tag) {
        s.append("<").append(tag).append(">\n");
        boolean ok = true;
        for (StoryboardElement l : this.elements) {
            ok &= l.toXML(s, "SBElement");
        }
        s.append("</").append(tag).append(">\n");
        return ok;
    }

    public boolean fromXML(StringBuilder xml, XMLSupport xmlSupport) {
        this.elements = new ArrayList();
        int errorCode = 0;
        StringBuilder xmlBuffer = new StringBuilder(xml);
        StringBuilder oneElement = null;
        while ((oneElement = xmlSupport.removeTag("SBElement", xmlBuffer)) != null) {
            errorCode |= xmlSupport.errorCode;
            StoryboardElement se = this.addStoryelement(false);
            se.fromXML(oneElement, xmlSupport);
            errorCode |= xmlSupport.errorCode;
            if (!se.pause) {
                GFXVectorAnimation currentAnimation = new GFXVectorAnimation();
                boolean ok = currentAnimation.loadFromXML(Global.mainPathPrefix + se.listName);
                if (ok) {
                    se.setAnimation(currentAnimation);
                    se.setDelay(se.delay);
                    this.sb.setElement(se, this);
                    continue;
                }
                this.log.addLog("Storyboard animation could not be loaded: " + se.listName, LogPanel.WARN);
                continue;
            }
            this.sb.setElement(se, this);
        }
        return errorCode == 0;
    }

    public void setLaneSelected(boolean s) {
        if (s) {
            this.setBorder(BorderFactory.createLineBorder(Color.GREEN));
        } else {
            this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        }
    }

    void removeElement(StoryboardElement element) {
        this.remove(element);
        this.elements.remove(element);
        this.reorder();
    }

    void getAnimData(ArrayList<String> animData, HashMap<String, String> noDoubleAnimMap) {
        StringBuilder t0 = new StringBuilder();
        for (StoryboardElement element : this.elements) {
            String text;
            int resync;
            String name;
            StringBuilder t1 = new StringBuilder();
            if (element.disabled || element.getAnimation() == null || noDoubleAnimMap.get(element.listName) != null) continue;
            if (element.drawType.equals("synced extended")) {
                name = "AnimList_" + uidcount++ + "#_UNIQUE_ID#";
                noDoubleAnimMap.put(element.listName, name);
                resync = element.resyncMax;
                if (resync == 0) {
                    resync = 20;
                }
                element.getAnimation().createASMDraw_syncList(t1, name, true, resync, true, 127, this.sb.isNoAdditionalSyncOptimization(), "BLOW_UP_" + uidcount + "#_UNIQUE_ID#");
                text = "";
                if (element.factor == 0) {
                    element.factor = 1;
                }
                text = "BLOW_UP_" + uidcount + "#_UNIQUE_ID# EQU " + element.factor + "\n\n" + t1.toString();
                animData.add(text);
                continue;
            }
            if (element.drawType.equals("synced")) {
                name = "AnimList_" + uidcount++ + "#_UNIQUE_ID#";
                noDoubleAnimMap.put(element.listName, name);
                resync = element.resyncMax;
                if (resync == 0) {
                    resync = 20;
                }
                text = "";
                element.getAnimation().createASMDraw_syncList(t1, name, true, resync, false, 127, this.sb.isNoAdditionalSyncOptimization(), "BLOW_UP_" + uidcount + "#_UNIQUE_ID#");
                if (element.factor == 0) {
                    element.factor = 1;
                }
                text = "BLOW_UP_" + uidcount + "#_UNIQUE_ID# EQU " + element.factor + "\n\n" + t1.toString();
                animData.add(text);
                continue;
            }
            if (!element.drawType.equals("Mov_Draw_VLc_a") && !element.drawType.equals("Draw_VLc") && !element.drawType.equals("Draw_VLp") && !element.drawType.equals("Draw_VL_mode") && !element.drawType.equals("AnimCodeGen")) continue;
        }
    }

    void getDrawRoutines(ArrayList<String> routineData, HashMap<String, String> noDoubleRoutineMap) {
        for (StoryboardElement element : this.elements) {
            String text;
            Path template;
            if (element.disabled || element.getAnimation() == null || noDoubleRoutineMap.get(element.drawType) != null) continue;
            if (element.drawType.equals("synced extended")) {
                noDoubleRoutineMap.put(element.drawType, element.drawType);
                template = Paths.get(Global.mainPathPrefix, "template", "animationDraw_esync.template");
                text = UtilityString.readTextFileToOneString(new File(template.toString()));
                text = UtilityString.deleteLinesBefore(text, ";SUB_START");
                text = UtilityString.deleteLinesAfter(text, ";SUB_END");
                routineData.add(text);
                continue;
            }
            if (element.drawType.equals("synced")) {
                noDoubleRoutineMap.put(element.drawType, element.drawType);
                template = Paths.get(Global.mainPathPrefix, "template", "animationDraw_sync.template");
                text = UtilityString.readTextFileToOneString(new File(template.toString()));
                text = UtilityString.deleteLinesBefore(text, ";SUB_START");
                text = UtilityString.deleteLinesAfter(text, ";SUB_END");
                routineData.add(text);
                continue;
            }
            if (!element.drawType.equals("Mov_Draw_VLc_a") && !element.drawType.equals("Draw_VLc") && !element.drawType.equals("Draw_VLp") && !element.drawType.equals("Draw_VL_mode") && !element.drawType.equals("AnimCodeGen")) continue;
        }
    }

    void getLaneInit(ArrayList<String> initCode) {
        String t = "\n";
        t = t + " leau laneData,u \n";
        t = t + " ldx #lane" + this.uid + "Data#_UNIQUE_ID# \n";
        t = t + " jsr initLane\n";
        initCode.add(t);
    }

    void getLaneData(ArrayList<String> laneCode, HashMap<String, String> noDoubleAnimMap) {
        StringBuilder t = new StringBuilder();
        t.append("\n");
        t.append("lane" + this.uid + "Data#_UNIQUE_ID#: \n");
        int count = 1;
        for (StoryboardElement element : this.elements) {
            if (element.disabled || element.getAnimation() == null) continue;
            t.append(" dw element_" + this.uid + "" + count++ + "#_UNIQUE_ID#\n");
        }
        t.append(" dw 0\n");
        count = 1;
        for (StoryboardElement element : this.elements) {
            if (element.disabled || element.getAnimation() == null) continue;
            if (element.version == 1) {
                this.getElementDataV1(t, element, count, noDoubleAnimMap);
            } else if (element.version == 2) {
                this.getElementDataV2(t, element, count, noDoubleAnimMap);
            }
            ++count;
        }
        laneCode.add(t.toString());
    }

    void getElementDataV1(StringBuilder t, StoryboardElement element, int count, HashMap<String, String> noDoubleAnimMap) {
        t.append("\n");
        t.append("element_" + this.uid + "" + count + "#_UNIQUE_ID#:\n");
        if (element.pause) {
            t.append(" dw 0\n");
        } else {
            t.append(" dw " + noDoubleAnimMap.get(element.listName) + "\n");
        }
        t.append(" db " + element.vectrexdelay + "; delay\n");
        t.append(" db " + element.listScaleStart + "; scale start\n");
        t.append(" db " + element.listScaleDelay + "; scale delay\n");
        t.append(" db " + element.listScaleIncrease + "; scale increase\n");
        t.append(" db " + element.intensityStart + "; intensityStart\n");
        t.append(" db " + element.intensityDelay + "; intensityDelay\n");
        t.append(" db " + element.intensityIncrease + "; intensityIncrease\n");
        t.append(" db " + element.positionYStart + ", " + element.positionXStart + "; position start (y,x)\n");
        t.append(" db " + element.positionYDelay + ", " + element.positionXDelay + "; position delay (y,x)\n");
        t.append(" db " + element.positionYIncrease + ", " + element.positionXIncrease + "; position increase (y,x)\n");
        t.append(" db " + element.moveScale + "; move scale\n");
        if (element.pause) {
            t.append(" dw draw_pause; draw pause\n");
        } else if (element.drawType.equals("synced extended")) {
            t.append(" dw draw_esynced_list; draw jsr\n");
        } else if (element.drawType.equals("synced")) {
            t.append(" dw draw_synced_list; draw jsr\n");
        } else if (element.drawType.equals("Mov_Draw_VLc_a")) {
            t.append(" dw Mov_Draw_VLc_a; draw jsr\n");
        } else if (element.drawType.equals("Draw_VLc")) {
            t.append(" dw Draw_VLc; draw jsr\n");
        } else if (element.drawType.equals("Draw_VLp")) {
            t.append(" dw Draw_VLp; draw jsr\n");
        } else if (element.drawType.equals("Draw_VL_mode")) {
            t.append(" dw Draw_VL_mode; draw jsr\n");
        } else if (element.drawType.equals("AnimCodeGen")) {
            t.append(" dw AnimCodeGen; draw jsr\n");
        } else {
            t.append(" dw 0; draw UNKOWN\n");
        }
        String behaviour = "BEHAVIOUR_NONE";
        if (element.loop) {
            behaviour = behaviour + "+BEHAVIOUR_LOOP";
        }
        if (element.pause) {
            behaviour = behaviour + "+BEHAVIOUR_PAUSE";
        }
        if (element._goto) {
            behaviour = behaviour + "+BEHAVIOUR_GOTO";
        }
        t.append(" db " + behaviour + " ; BEHAVIOUR_LOOP or BEHAVIOUR_GOTO or BEHAVIOUR_LOOP\n");
        t.append(" db " + element.loopCount + "; loop count\n");
        t.append(" db " + element.goto_value + "; goto value\n");
        t.append(" dw " + element.roundCount + "; element end count\n");
        t.append(" db ELEMENT_ANIM ; type of element \n");
    }

    void getElementDataV2(StringBuilder t, StoryboardElement element, int count, HashMap<String, String> noDoubleAnimMap) {
        element.calculateV2();
        t.append("\n");
        t.append("element_" + this.uid + "" + count + "#_UNIQUE_ID#:\n");
        if (element.pause) {
            t.append(" dw 0\n");
        } else {
            t.append(" dw " + noDoubleAnimMap.get(element.listName) + "\n");
        }
        t.append(" db " + element.vectrexdelay + "; delay\n");
        t.append(" db " + element.listScaleFrom + "; scale from\n");
        t.append(" db " + element.listScaleTo + "; scale to\n");
        t.append(" db " + element.listScaleDelay + "; scale delay\n");
        t.append(" db " + element.listScaleIncrease + "; scale increase\n");
        t.append(" db " + element.intensityFrom + "; intensityFrom\n");
        t.append(" db " + element.intensityTo + "; intensityTo\n");
        t.append(" db " + element.intensityDelay + "; intensityDelay\n");
        t.append(" db " + element.intensityIncrease + "; intensityIncrease\n");
        t.append(" db " + element.positionYFrom + ", " + element.positionXFrom + "; position from (y,x)\n");
        t.append(" db " + element.positionYTo + ", " + element.positionXTo + "; position to (y,x)\n");
        t.append(" db " + element.positionYDelay + ", " + element.positionXDelay + "; position delay (y,x)\n");
        t.append(" db " + element.positionYIncrease + ", " + element.positionXIncrease + "; position increase (y,x)\n");
        t.append(" db " + element.moveScale + "; move scale\n");
        if (element.pause) {
            t.append(" dw draw_pause; draw pause\n");
        } else if (element.drawType.equals("synced extended")) {
            t.append(" dw draw_esynced_list; draw jsr\n");
        } else if (element.drawType.equals("synced")) {
            t.append(" dw draw_synced_list; draw jsr\n");
        } else if (element.drawType.equals("Mov_Draw_VLc_a")) {
            t.append(" dw Mov_Draw_VLc_a; draw jsr\n");
        } else if (element.drawType.equals("Draw_VLc")) {
            t.append(" dw Draw_VLc; draw jsr\n");
        } else if (element.drawType.equals("Draw_VLp")) {
            t.append(" dw Draw_VLp; draw jsr\n");
        } else if (element.drawType.equals("Draw_VL_mode")) {
            t.append(" dw Draw_VL_mode; draw jsr\n");
        } else if (element.drawType.equals("AnimCodeGen")) {
            t.append(" dw AnimCodeGen; draw jsr\n");
        } else {
            t.append(" dw 0; draw UNKOWN\n");
        }
        String behaviour = "BEHAVIOUR_NONE";
        if (element.pause) {
            behaviour = behaviour + "+BEHAVIOUR_PAUSE";
        }
        if (element.animationLoop) {
            behaviour = behaviour + "+BEHAVIOUR_ANIMATION_LOOP";
        }
        t.append(" db " + behaviour + " ; BEHAVIOUR_PAUSE / BEHAVIOUR_ANIMATION_LOOP\n");
        t.append(" dw " + element.roundCount + "; element end count\n");
        t.append(" db ELEMENT_ANIM ; type of element \n");
    }

    public int getLengthInRound() {
        int ret = 0;
        for (StoryboardElement element : this.elements) {
            if (element.disabled) continue;
            ret += element.roundCount;
        }
        return ret;
    }
}

