/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.veccy;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.graphics.GFXVectorAnimation;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.HotKey;
import de.malban.gui.Windowable;
import de.malban.gui.components.CSAView;
import de.malban.gui.dialogs.InternalFrameFileChoser;
import de.malban.gui.panels.LogPanel;
import de.malban.util.Utility;
import de.malban.util.UtilityFiles;
import de.malban.util.UtilityString;
import de.malban.util.XMLSupport;
import de.malban.vide.assy.Asmj;
import de.malban.vide.veccy.StoryboardElement;
import de.malban.vide.veccy.StoryboardLanePanel;
import de.malban.vide.veccy.StoryboardPanelInterface;
import de.malban.vide.veccy.VeccyPanel;
import de.malban.vide.vecx.VecXPanel;
import de.malban.vide.vedi.VediPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;

public class StoryboardPanelNew
extends JPanel
implements Windowable,
StoryboardPanelInterface {
    LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    String pathOnly = "";
    private int mClassSetting = 0;
    private CSAView mParent = null;
    private JMenuItem mParentMenuItem = null;
    Thread two = null;
    String orgName = "";
    BufferedImage baseImage;
    VeccyPanel veccy = null;
    private ArrayList<StoryboardLanePanel> lanes = new ArrayList();
    private StoryboardLanePanel currentLane = null;
    private StoryboardElement currentElement = null;
    private GFXVectorAnimation currentAnimation = new GFXVectorAnimation();
    Thread one = null;
    public boolean asmStarted = false;
    public boolean stop = false;
    public boolean running = false;
    public boolean pausing = false;
    private ButtonGroup buttonGroup1;
    private JButton jButton3;
    private JButton jButtonAssemble;
    private JButton jButtonEditInVedi;
    private JButton jButtonLoad1;
    private JButton jButtonLoad2;
    private JButton jButtonSave3;
    private JButton jButtonaddLane;
    private JButton jButtonaddLane1;
    private JCheckBox jCheckBoxAnimationLoop;
    private JCheckBox jCheckBoxDisable;
    private JCheckBox jCheckBoxNoAdditionalSynOptimization;
    private JCheckBox jCheckBoxPause;
    private JComboBox jComboBoxDrawType;
    private JLabel jLabel1;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane5;
    private JTextArea jTextAreaResult;
    private JTextField jTextFieldAnimationName;
    private JTextField jTextFieldDelayVectrex;
    private JTextField jTextFieldFactor;
    private JTextField jTextFieldFrameCount;
    private JTextField jTextFieldFrameCount2;
    private JTextField jTextFieldListIntensityFrom;
    private JTextField jTextFieldListIntensityTo;
    private JTextField jTextFieldListScaleFrom;
    private JTextField jTextFieldListScaleTo;
    private JTextField jTextFieldMoveScale;
    private JTextField jTextFieldPosXFrom;
    private JTextField jTextFieldPosXTo;
    private JTextField jTextFieldPosYFrom;
    private JTextField jTextFieldPosYTo;
    private JTextField jTextFieldResync;
    private JTextField jTextFieldRoundCount;
    private JTextField jTextFieldUniqueID;
    private JPanel lanePanel;
    private StoryboardLanePanel storyboardLanePanel1;

    @Override
    public void closing() {
        if (this.veccy != null) {
            this.veccy.removeSBPanel();
        }
    }

    @Override
    public boolean isIcon() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return false;
        }
        return frame.getInternalFrame(this).isIcon();
    }

    @Override
    public void setIcon(boolean b) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return;
        }
        try {
            frame.getInternalFrame(this).setIcon(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void setParentWindow(CSAView jpv) {
        this.mParent = jpv;
    }

    @Override
    public void setMenuItem(JMenuItem item) {
        this.mParentMenuItem = item;
        this.mParentMenuItem.setText("Vector: Storyboard (new)");
    }

    @Override
    public JMenuItem getMenuItem() {
        return this.mParentMenuItem;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public ArrayList<StoryboardLanePanel> getLanes() {
        return this.lanes;
    }

    @Override
    public void setLanes(ArrayList<StoryboardLanePanel> lanes) {
        this.lanes = lanes;
    }

    @Override
    public StoryboardLanePanel getCurrentLane() {
        return this.currentLane;
    }

    @Override
    public void setCurrentLane(StoryboardLanePanel currentLane) {
        this.currentLane = currentLane;
    }

    @Override
    public StoryboardElement getCurrentElement() {
        return this.currentElement;
    }

    @Override
    public void setCurrentElement(StoryboardElement currentElement) {
        this.currentElement = currentElement;
    }

    @Override
    public GFXVectorAnimation getCurrentAnimation() {
        return this.currentAnimation;
    }

    @Override
    public void setCurrentAnimation(GFXVectorAnimation currentAnimation) {
        this.currentAnimation = currentAnimation;
    }

    public StoryboardPanelNew() {
        this.initComponents();
        this.lanePanel.remove(this.storyboardLanePanel1);
        if (Global.getOSName().toUpperCase().contains("MAC")) {
            HotKey.addMacDefaults(this.jTextFieldAnimationName);
            HotKey.addMacDefaults(this.jTextFieldFrameCount);
            HotKey.addMacDefaults(this.jTextFieldDelayVectrex);
            HotKey.addMacDefaults(this.jTextFieldListIntensityFrom);
            HotKey.addMacDefaults(this.jTextFieldMoveScale);
            HotKey.addMacDefaults(this.jTextFieldResync);
            HotKey.addMacDefaults(this.jTextFieldFactor);
            HotKey.addMacDefaults(this.jTextFieldListScaleTo);
            HotKey.addMacDefaults(this.jTextFieldListScaleFrom);
            HotKey.addMacDefaults(this.jTextFieldListIntensityTo);
            HotKey.addMacDefaults(this.jTextFieldPosXFrom);
            HotKey.addMacDefaults(this.jTextFieldPosXTo);
            HotKey.addMacDefaults(this.jTextFieldPosYFrom);
            HotKey.addMacDefaults(this.jTextFieldPosYTo);
            HotKey.addMacDefaults(this.jTextFieldMoveScale);
            HotKey.addMacDefaults(this.jTextFieldRoundCount);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.lanePanel = new JPanel();
        this.storyboardLanePanel1 = new StoryboardLanePanel();
        this.jButtonaddLane = new JButton();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextFieldFrameCount = new JTextField();
        this.jLabel2 = new JLabel();
        this.jButton3 = new JButton();
        this.jLabel3 = new JLabel();
        this.jTextFieldListScaleFrom = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTextFieldMoveScale = new JTextField();
        this.jLabel5 = new JLabel();
        this.jTextFieldPosXFrom = new JTextField();
        this.jTextFieldPosYFrom = new JTextField();
        this.jLabel7 = new JLabel();
        this.jTextFieldPosXTo = new JTextField();
        this.jTextFieldPosYTo = new JTextField();
        this.jLabel8 = new JLabel();
        this.jComboBoxDrawType = new JComboBox();
        this.jTextFieldListScaleTo = new JTextField();
        this.jButtonLoad2 = new JButton();
        this.jLabel6 = new JLabel();
        this.jTextFieldAnimationName = new JTextField();
        this.jTextFieldDelayVectrex = new JTextField();
        this.jTextFieldResync = new JTextField();
        this.jTextFieldFactor = new JTextField();
        this.jLabel14 = new JLabel();
        this.jTextFieldRoundCount = new JTextField();
        this.jLabel9 = new JLabel();
        this.jTextFieldListIntensityFrom = new JTextField();
        this.jTextFieldListIntensityTo = new JTextField();
        this.jCheckBoxDisable = new JCheckBox();
        this.jCheckBoxPause = new JCheckBox();
        this.jCheckBoxNoAdditionalSynOptimization = new JCheckBox();
        this.jCheckBoxAnimationLoop = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.jScrollPane5 = new JScrollPane();
        this.jTextAreaResult = new JTextArea();
        this.jPanel5 = new JPanel();
        this.jButtonLoad1 = new JButton();
        this.jButtonSave3 = new JButton();
        this.jButtonAssemble = new JButton();
        this.jButtonEditInVedi = new JButton();
        this.jButtonaddLane1 = new JButton();
        this.jLabel15 = new JLabel();
        this.jTextFieldFrameCount2 = new JTextField();
        this.jTextFieldUniqueID = new JTextField();
        this.jLabel16 = new JLabel();
        this.jScrollPane1.setHorizontalScrollBarPolicy(32);
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.lanePanel.setPreferredSize(new Dimension(600, 428));
        this.lanePanel.setLayout(null);
        this.lanePanel.add(this.storyboardLanePanel1);
        this.storyboardLanePanel1.setBounds(0, 65, 1028, 0);
        this.jScrollPane1.setViewportView(this.lanePanel);
        this.jButtonaddLane.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/add.png")));
        this.jButtonaddLane.setText("add lane");
        this.jButtonaddLane.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonaddLane.setPreferredSize(new Dimension(93, 21));
        this.jButtonaddLane.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanelNew.this.jButtonaddLaneActionPerformed(evt);
            }
        });
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("sequence detail"));
        this.jLabel1.setText("frames");
        this.jTextFieldFrameCount.setEditable(false);
        this.jTextFieldFrameCount.setText("10");
        this.jLabel2.setText("animation");
        this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/delete.png")));
        this.jButton3.setToolTipText("delete current element");
        this.jButton3.setEnabled(false);
        this.jButton3.setPreferredSize(new Dimension(20, 20));
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanelNew.this.jButton3ActionPerformed(evt);
            }
        });
        this.jLabel3.setText("scale from <-> to");
        this.jTextFieldListScaleFrom.setText("10");
        this.jTextFieldListScaleFrom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanelNew.this.jTextFieldListScaleFromActionPerformed(evt);
            }
        });
        this.jTextFieldListScaleFrom.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StoryboardPanelNew.this.jTextFieldListScaleFromKeyReleased(evt);
            }
        });
        this.jLabel4.setText("move - scale");
        this.jTextFieldMoveScale.setText("10");
        this.jTextFieldMoveScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanelNew.this.jTextFieldMoveScaleActionPerformed(evt);
            }
        });
        this.jTextFieldMoveScale.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StoryboardPanelNew.this.jTextFieldPosStartXKeyReleased(evt);
            }
        });
        this.jLabel5.setText("X from <-> to");
        this.jTextFieldPosXFrom.setText("10");
        this.jTextFieldPosXFrom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanelNew.this.jTextFieldPosXFromActionPerformed(evt);
            }
        });
        this.jTextFieldPosXFrom.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StoryboardPanelNew.this.textfieldKeyReleased(evt);
            }
        });
        this.jTextFieldPosYFrom.setText("10");
        this.jTextFieldPosYFrom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanelNew.this.jTextFieldPosYFromActionPerformed(evt);
            }
        });
        this.jTextFieldPosYFrom.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StoryboardPanelNew.this.jTextFieldPosStartXKeyReleased(evt);
            }
        });
        this.jLabel7.setText("Y from <-> to");
        this.jTextFieldPosXTo.setText("10");
        this.jTextFieldPosXTo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanelNew.this.jTextFieldPosXToActionPerformed(evt);
            }
        });
        this.jTextFieldPosXTo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StoryboardPanelNew.this.jTextFieldPosStartXKeyReleased(evt);
            }
        });
        this.jTextFieldPosYTo.setText("10");
        this.jTextFieldPosYTo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanelNew.this.jTextFieldPosYToActionPerformed(evt);
            }
        });
        this.jTextFieldPosYTo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StoryboardPanelNew.this.jTextFieldPosStartXKeyReleased(evt);
            }
        });
        this.jLabel8.setText("draw type");
        this.jComboBoxDrawType.setModel(new DefaultComboBoxModel<String>(new String[]{"synced extended"}));
        this.jComboBoxDrawType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanelNew.this.jComboBoxDrawTypeActionPerformed(evt);
            }
        });
        this.jTextFieldListScaleTo.setText("10");
        this.jTextFieldListScaleTo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanelNew.this.textFieldReturn(evt);
            }
        });
        this.jTextFieldListScaleTo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StoryboardPanelNew.this.jTextFieldListScaleToKeyReleased(evt);
            }
        });
        this.jButtonLoad2.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_go.png")));
        this.jButtonLoad2.setToolTipText("load animation");
        this.jButtonLoad2.setEnabled(false);
        this.jButtonLoad2.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonLoad2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanelNew.this.jButtonLoad2ActionPerformed(evt);
            }
        });
        this.jLabel6.setText("animation delay");
        this.jTextFieldAnimationName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanelNew.this.jTextFieldAnimationNameActionPerformed(evt);
            }
        });
        this.jTextFieldDelayVectrex.setText("10");
        this.jTextFieldDelayVectrex.setToolTipText("display delay for vectrex, in \"rounds\"/ticks");
        this.jTextFieldDelayVectrex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanelNew.this.jTextFieldDelayVectrexActionPerformed(evt);
            }
        });
        this.jTextFieldDelayVectrex.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StoryboardPanelNew.this.jTextFieldDelayVectrexKeyReleased(evt);
            }
        });
        this.jTextFieldResync.setText("10");
        this.jTextFieldResync.setToolTipText("resync max");
        this.jTextFieldResync.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanelNew.this.jTextFieldResyncActionPerformed(evt);
            }
        });
        this.jTextFieldResync.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StoryboardPanelNew.this.jTextFieldResyncjTextFieldPosStartXKeyReleased(evt);
            }
        });
        this.jTextFieldFactor.setText("10");
        this.jTextFieldFactor.setToolTipText("factor for list values");
        this.jTextFieldFactor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanelNew.this.jTextFieldFactorActionPerformed(evt);
            }
        });
        this.jTextFieldFactor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StoryboardPanelNew.this.jTextFieldFactorjTextFieldPosStartXKeyReleased(evt);
            }
        });
        this.jLabel14.setText("length");
        this.jTextFieldRoundCount.setText("200");
        this.jTextFieldRoundCount.setToolTipText("<html>\nLength in vectrex rounds.<BR>\nAn efficient vectrex program will run at 50Hz, thus one length \"tick\" is 1/50 of a second, <BR>\nor 0,02 seconds.<BR>\nVectrex will at least use 1/50 of a second per round, if your animations consists of more vectors than\n<BR>Vectrex can draw in 1/50 second, the \"tick\" will last longer.<BR>\n</html>");
        this.jTextFieldRoundCount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanelNew.this.jTextFieldRoundCountActionPerformed(evt);
            }
        });
        this.jTextFieldRoundCount.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StoryboardPanelNew.this.jTextFieldRoundCountKeyReleased(evt);
            }
        });
        this.jLabel9.setText("intensity from <-> to");
        this.jLabel9.setEnabled(false);
        this.jTextFieldListIntensityFrom.setText("10");
        this.jTextFieldListIntensityFrom.setToolTipText("-1 = no intensity setting");
        this.jTextFieldListIntensityFrom.setEnabled(false);
        this.jTextFieldListIntensityFrom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanelNew.this.jTextFieldListIntensityFromActionPerformed(evt);
            }
        });
        this.jTextFieldListIntensityFrom.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StoryboardPanelNew.this.jTextFieldListIntensityFromKeyReleased(evt);
            }
        });
        this.jTextFieldListIntensityTo.setText("10");
        this.jTextFieldListIntensityTo.setEnabled(false);
        this.jTextFieldListIntensityTo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanelNew.this.jTextFieldListIntensityTotextFieldReturn(evt);
            }
        });
        this.jTextFieldListIntensityTo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StoryboardPanelNew.this.jTextFieldListIntensityToKeyReleased(evt);
            }
        });
        this.jCheckBoxDisable.setText("disable");
        this.jCheckBoxDisable.setToolTipText("treat sequence as if it was not avaible (for testing purposes - not SAVED)");
        this.jCheckBoxDisable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanelNew.this.jCheckBoxDisableActionPerformed(evt);
            }
        });
        this.jCheckBoxPause.setText("is pause");
        this.jCheckBoxPause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanelNew.this.jCheckBoxPauseActionPerformed(evt);
            }
        });
        this.jCheckBoxNoAdditionalSynOptimization.setSelected(true);
        this.jCheckBoxNoAdditionalSynOptimization.setText("no opt");
        this.jCheckBoxNoAdditionalSynOptimization.setToolTipText("<html>\nWhile generating the storyboard, do not try to optimize the vectorlist(s).<BR>\nOptimizing takes time - and if the list is already optimized - there will be no better results.\n</html>");
        this.jCheckBoxAnimationLoop.setSelected(true);
        this.jCheckBoxAnimationLoop.setText("loop");
        this.jCheckBoxAnimationLoop.setToolTipText("does the animation loop");
        this.jCheckBoxAnimationLoop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanelNew.this.jCheckBoxAnimationLoopActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel14).addComponent(this.jLabel5).addComponent(this.jLabel7).addComponent(this.jLabel4).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel8).addComponent(this.jLabel9).addComponent(this.jLabel6).addComponent(this.jCheckBoxDisable)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addComponent(this.jComboBoxDrawType, -2, 147, -2).addGap(3, 3, 3).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jTextFieldResync, -2, 45, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldFactor, -2, 45, -2)).addComponent(this.jCheckBoxNoAdditionalSynOptimization))).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxPause, -2, 89, -2).addComponent(this.jTextFieldMoveScale, -2, 45, -2).addComponent(this.jTextFieldRoundCount, -2, 45, -2)).addContainerGap())).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jTextFieldAnimationName, -2, 147, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonLoad2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxAnimationLoop)).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldPosYFrom, -2, 45, -2).addComponent(this.jTextFieldPosXFrom, -2, 45, -2).addComponent(this.jTextFieldListIntensityFrom, -2, 45, -2).addComponent(this.jTextFieldListScaleFrom, -2, 45, -2).addComponent(this.jTextFieldDelayVectrex, -2, 45, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldPosXTo, -2, 45, -2).addComponent(this.jTextFieldPosYTo, -2, 45, -2).addComponent(this.jTextFieldListIntensityTo, -2, 45, -2).addComponent(this.jTextFieldListScaleTo, -2, 45, -2).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.jTextFieldFrameCount, -2, 45, -2)))))));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(1, 1, 1).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton3, -2, -1, -2).addComponent(this.jButtonLoad2).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldAnimationName, -2, -1, -2)))).addComponent(this.jCheckBoxAnimationLoop)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel6).addComponent(this.jTextFieldDelayVectrex, -2, -1, -2).addComponent(this.jTextFieldFrameCount, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldListScaleFrom, -2, -1, -2).addComponent(this.jTextFieldListScaleTo, -2, -1, -2)).addGap(4, 4, 4).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.jTextFieldListIntensityFrom, -2, -1, -2).addComponent(this.jTextFieldListIntensityTo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldPosXFrom, -2, -1, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jTextFieldPosYFrom, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldMoveScale, -2, -1, -2).addComponent(this.jLabel4)).addGap(6, 6, 6).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel8, -1, -1, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldResync, -2, -1, -2).addComponent(this.jTextFieldFactor, -2, -1, -2)).addComponent(this.jComboBoxDrawType, -2, 19, -2))).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jTextFieldPosXTo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldPosYTo, -2, -1, -2))).addGap(6, 6, 6).addComponent(this.jCheckBoxNoAdditionalSynOptimization).addGap(6, 6, 6).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel14).addComponent(this.jTextFieldRoundCount, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 9, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxPause).addComponent(this.jCheckBoxDisable))));
        this.jTextAreaResult.setColumns(20);
        this.jTextAreaResult.setFont(new Font("Courier New", 1, 12));
        this.jTextAreaResult.setRows(5);
        this.jScrollPane5.setViewportView(this.jTextAreaResult);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane5, -1, 377, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane5));
        this.jButtonLoad1.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_go.png")));
        this.jButtonLoad1.setToolTipText("load storyboard");
        this.jButtonLoad1.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonLoad1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanelNew.this.jButtonLoad1ActionPerformed(evt);
            }
        });
        this.jButtonSave3.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_save.png")));
        this.jButtonSave3.setToolTipText("save storyboard");
        this.jButtonSave3.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonSave3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanelNew.this.jButtonSave3ActionPerformed(evt);
            }
        });
        this.jButtonAssemble.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/control_play_blue.png")));
        this.jButtonAssemble.setToolTipText("Assemble current file, if if project is loaded, build project");
        this.jButtonAssemble.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonAssemble.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanelNew.this.jButtonAssembleActionPerformed(evt);
            }
        });
        this.jButtonEditInVedi.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_edit.png")));
        this.jButtonEditInVedi.setToolTipText("edit output in vedi");
        this.jButtonEditInVedi.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonEditInVedi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanelNew.this.jButtonEditInVediActionPerformed(evt);
            }
        });
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jButtonLoad1).addGap(6, 6, 6).addComponent(this.jButtonSave3).addGap(18, 18, 18).addComponent(this.jButtonAssemble).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonEditInVedi).addGap(0, 0, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonLoad1).addComponent(this.jButtonSave3).addComponent(this.jButtonAssemble).addComponent(this.jButtonEditInVedi));
        this.jButtonaddLane1.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/delete.png")));
        this.jButtonaddLane1.setText("delete lane");
        this.jButtonaddLane1.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonaddLane1.setPreferredSize(new Dimension(93, 21));
        this.jButtonaddLane1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanelNew.this.jButtonaddLane1ActionPerformed(evt);
            }
        });
        this.jLabel15.setText("length in rounds");
        this.jTextFieldFrameCount2.setEditable(false);
        this.jTextFieldFrameCount2.setText("0");
        this.jTextFieldUniqueID.setToolTipText("Adds the id to all generated functions");
        this.jTextFieldUniqueID.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StoryboardPanelNew.this.jTextFieldUniqueIDActionPerformed(evt);
            }
        });
        this.jLabel16.setText("unique ID");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jButtonaddLane, -2, 127, -2).addGap(35, 35, 35).addComponent(this.jButtonaddLane1, -2, 127, -2)).addComponent(this.jPanel3, -2, -1, -2).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel15).addGap(34, 34, 34).addComponent(this.jTextFieldFrameCount2, -2, 45, -2).addGap(18, 18, 18).addComponent(this.jLabel16, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldUniqueID, -2, 105, -2).addGap(8, 8, 8))).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE)).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel15).addComponent(this.jTextFieldFrameCount2, -2, -1, -2).addComponent(this.jTextFieldUniqueID, -2, -1, -2).addComponent(this.jLabel16)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonaddLane, -2, -1, -2).addComponent(this.jButtonaddLane1, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 275, -2).addGap(0, 0, 0).addComponent(this.jPanel5, -2, -1, -2)));
    }

    private void jButtonLoad1ActionPerformed(ActionEvent evt) {
        this.loadStoryboard();
    }

    private void jButtonSave3ActionPerformed(ActionEvent evt) {
        this.saveStoryboard();
    }

    private void jButtonEditInVediActionPerformed(ActionEvent evt) {
        this.generateSource();
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        VediPanel p = new VediPanel(false);
        p.setTreeVisible(false);
        frame.addAsWindow(p, 1024, 768, VediPanel.SID);
        String tmpFile = Global.mainPathPrefix + "tmp" + File.separator + "veccyAsm.asm";
        UtilityFiles.createTextFile(tmpFile, this.jTextAreaResult.getText());
        p.addTempEditFile(tmpFile);
    }

    private void jButtonAssembleActionPerformed(ActionEvent evt) {
        String filename = Global.mainPathPrefix + "tmp" + File.separator + "storyboard.tmp";
        File f = new File(filename);
        String saveName = f.getAbsolutePath();
        if (saveName != null) {
            if (!saveName.toUpperCase().endsWith(".XML")) {
                saveName = saveName + ".xml";
            }
            this.saveAsXML(saveName);
        }
        this.generateSource();
        filename = Global.mainPathPrefix + "tmp" + File.separator + "veccytmp.asm";
        UtilityFiles.createTextFile(filename, this.jTextAreaResult.getText());
        this.startASM(filename);
    }

    private void jButtonaddLaneActionPerformed(ActionEvent evt) {
        StoryboardLanePanel sb = new StoryboardLanePanel(this);
        this.lanePanel.add(sb);
        sb.setBounds(0, 80 * this.lanes.size(), 28, 79);
        this.lanes.add(sb);
        this.lanePanel.repaint();
        this.updateBounds();
    }

    private void jButtonLoad2ActionPerformed(ActionEvent evt) {
        this.loadAnimation();
        this.setListType("dummy");
        this.jTextFieldFrameCount.setText("" + this.currentAnimation.size());
        if (this.currentElement != null) {
            this.updateToElement(false);
        }
        this.guessBlowUpFactor();
    }

    private void jTextFieldListScaleFromKeyReleased(KeyEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldListScaleToKeyReleased(KeyEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldPosStartXKeyReleased(KeyEvent evt) {
        this.updateToElement(false);
    }

    private void textFieldReturn(ActionEvent evt) {
        this.updateToElement(false);
    }

    private void textfieldKeyReleased(KeyEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldDelayVectrexActionPerformed(ActionEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldDelayVectrexKeyReleased(KeyEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldMoveScaleActionPerformed(ActionEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldPosXToActionPerformed(ActionEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldPosYToActionPerformed(ActionEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldPosYFromActionPerformed(ActionEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldPosXFromActionPerformed(ActionEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldListScaleFromActionPerformed(ActionEvent evt) {
        this.updateToElement(false);
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.deleteCurrentElement();
    }

    private void jButtonaddLane1ActionPerformed(ActionEvent evt) {
        this.deleteLane();
    }

    private void jTextFieldResyncActionPerformed(ActionEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldResyncjTextFieldPosStartXKeyReleased(KeyEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldFactorActionPerformed(ActionEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldFactorjTextFieldPosStartXKeyReleased(KeyEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldListIntensityFromActionPerformed(ActionEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldListIntensityFromKeyReleased(KeyEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldListIntensityTotextFieldReturn(ActionEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldListIntensityToKeyReleased(KeyEvent evt) {
        this.updateToElement(false);
    }

    private void jTextFieldRoundCountActionPerformed(ActionEvent evt) {
        this.updateToElement(false);
    }

    private void jCheckBoxPauseActionPerformed(ActionEvent evt) {
        this.updateToElement(false);
    }

    private void jComboBoxDrawTypeActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        this.updateToElement(false);
    }

    private void jTextFieldAnimationNameActionPerformed(ActionEvent evt) {
        this.updateToElement(false);
    }

    private void jCheckBoxDisableActionPerformed(ActionEvent evt) {
        this.updateToElement(false);
    }

    private void jCheckBoxAnimationLoopActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        this.updateToElement(false);
    }

    private void jTextFieldRoundCountKeyReleased(KeyEvent evt) {
        this.currentElement.roundCount = UtilityString.IntX(this.jTextFieldRoundCount.getText(), 20);
    }

    private void jTextFieldUniqueIDActionPerformed(ActionEvent evt) {
    }

    @Override
    public void updateBounds() {
        int minW = this.jScrollPane1.getViewport().getBounds().width;
        int minH = this.jScrollPane1.getViewport().getBounds().height;
        int laneH = 0;
        for (StoryboardLanePanel l : this.lanes) {
            if (l.getBounds().width > minW) {
                minW = l.getBounds().width;
            }
            laneH += 80;
        }
        if (laneH > minH) {
            minH = laneH;
        }
        Rectangle bounds = this.lanePanel.getBounds();
        bounds.width = minW;
        bounds.height = minH;
        Dimension dim = new Dimension(minW, minH);
        this.lanePanel.setBounds(bounds);
        this.lanePanel.setPreferredSize(dim);
        this.lanePanel.setSize(dim);
        this.lanePanel.setMinimumSize(dim);
        this.repaint();
    }

    public void startASM(final String filenameASM) {
        if (this.asmStarted) {
            return;
        }
        this.asmStarted = true;
        this.jButtonAssemble.setEnabled(false);
        if (this.one != null) {
            return;
        }
        this.one = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(10L);
                    try {
                        Asmj asm = new Asmj(filenameASM, null, null, null, null, "", null);
                        String info = asm.getInfo();
                        final boolean asmOk = info.indexOf("0 errors detected.") >= 0;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                StoryboardPanelNew.this.asmResult(asmOk);
                            }
                        });
                    }
                    catch (Throwable e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                StoryboardPanelNew.this.log.addLog(e, LogPanel.WARN);
                                StoryboardPanelNew.this.asmResult(false);
                            }
                        });
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                StoryboardPanelNew.this.one = null;
                StoryboardPanelNew.this.jButtonAssemble.setEnabled(true);
                StoryboardPanelNew.this.asmStarted = false;
            }
        };
        this.one.setName("Run ASMJ with: " + filenameASM);
        this.one.start();
    }

    protected void asmResult(boolean asmOk) {
        if (asmOk) {
            VecXPanel vec = ((CSAMainFrame)this.mParent).getVecxy();
            ((CSAMainFrame)this.mParent).getInternalFrame(vec).toFront();
            String fname = Global.mainPathPrefix + "tmp" + File.separator + "veccytmp.bin";
            vec.startUp(fname);
            if (this.veccy != null) {
                boolean bl;
                if (this.veccy.jCheckBoxPiTrex.isSelected()) {
                    bl = this.veccy.checkVec4EverFile(fname);
                }
                if (this.veccy.jCheckBoxVecFever.isSelected()) {
                    bl = this.veccy.checkVec4EverFile(fname);
                }
            }
            this.log.addLog("Vecci-Assembly successful...", LogPanel.INFO);
        } else {
            this.log.addLog("Vecci-Assembly not successful, see ASM output...", LogPanel.WARN);
        }
        this.jButtonAssemble.setEnabled(true);
    }

    @Override
    public void setVeccy(VeccyPanel vp) {
        this.veccy = vp;
    }

    public static void showModPanelNoModal(VeccyPanel v) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        StoryboardPanelNew panel = new StoryboardPanelNew();
        if (v != null) {
            v.setSBPanel(panel);
            panel.veccy = v;
        }
        Configuration.getConfiguration().getMainFrame().addAsWindow(panel, 1080, 800, "Vector: Storyboard (new)");
    }

    void updateToElement(boolean onlyAnimation) {
        if (this.mClassSetting > 0) {
            return;
        }
        this.jButtonLoad2.setEnabled(this.currentElement != null);
        this.jButton3.setEnabled(this.currentElement != null);
        if (this.currentElement == null) {
            return;
        }
        ++this.mClassSetting;
        if (!onlyAnimation) {
            this.currentElement.animationLoop = this.jCheckBoxAnimationLoop.isSelected();
            this.currentElement.listScaleFrom = UtilityString.Int0(this.jTextFieldListScaleFrom.getText());
            this.currentElement.listScaleTo = UtilityString.Int0(this.jTextFieldListScaleTo.getText());
            this.currentElement.intensityFrom = UtilityString.Int0(this.jTextFieldListIntensityFrom.getText());
            this.currentElement.intensityTo = UtilityString.Int0(this.jTextFieldListIntensityTo.getText());
            this.currentElement.positionXFrom = UtilityString.Int0(this.jTextFieldPosXFrom.getText());
            this.currentElement.positionYFrom = UtilityString.Int0(this.jTextFieldPosYFrom.getText());
            this.currentElement.positionXTo = UtilityString.Int0(this.jTextFieldPosXTo.getText());
            this.currentElement.positionYTo = UtilityString.Int0(this.jTextFieldPosYTo.getText());
            this.currentElement.moveScale = UtilityString.Int0(this.jTextFieldMoveScale.getText());
            this.currentElement.vectrexdelay = UtilityString.Int0(this.jTextFieldDelayVectrex.getText());
            this.currentElement.delay = this.currentElement.vectrexdelay * 20;
            this.currentElement.resyncMax = UtilityString.IntX(this.jTextFieldResync.getText(), 20);
            this.currentElement.factor = UtilityString.IntX(this.jTextFieldFactor.getText(), 1);
            this.currentElement.disabled = this.jCheckBoxDisable.isSelected();
            this.currentElement.pause = this.jCheckBoxPause.isSelected();
            if (this.currentElement.vectrexdelay == 0) {
                this.currentElement.vectrexdelay = 1;
            }
            if (this.currentAnimation != null) {
                this.jTextFieldFrameCount.setText("" + this.currentAnimation.size());
            }
            this.currentElement.roundCount = UtilityString.IntX(this.jTextFieldRoundCount.getText(), 20);
            this.currentElement.drawType = this.getListType();
            if (this.currentElement.drawType == null || this.currentElement.drawType.trim().length() == 0) {
                this.currentElement.drawType = "synced";
                this.setListType("synced");
            }
            this.jLabel9.setEnabled(this.currentElement.drawType != "synced extended");
            this.jTextFieldListIntensityFrom.setEnabled(this.currentElement.drawType != "synced extended");
            this.jTextFieldListIntensityTo.setEnabled(this.currentElement.drawType != "synced extended");
            if (this.currentElement.drawType == "synced extended") {
                this.currentElement.intensityTo = 127;
                this.currentElement.intensityFrom = 127;
                this.jTextFieldListIntensityFrom.setText("" + this.currentElement.intensityFrom);
                this.jTextFieldListIntensityTo.setText("" + this.currentElement.intensityTo);
            }
        }
        this.currentElement.listName = this.jTextFieldAnimationName.getText();
        if (this.currentAnimation != null && this.jTextFieldAnimationName.getText().trim().length() != 0 && !this.currentElement.pause) {
            this.currentElement.setAnimation(this.currentAnimation);
        }
        this.currentElement.setDelay(this.currentElement.delay);
        this.upladeLaneData();
        --this.mClassSetting;
    }

    void clearElement(boolean isPause) {
        this.jTextFieldListScaleFrom.setText("80");
        this.jTextFieldListScaleTo.setText("0");
        this.jTextFieldListIntensityFrom.setText("127");
        this.jTextFieldListIntensityTo.setText("0");
        this.jTextFieldPosXFrom.setText("0");
        this.jTextFieldPosYFrom.setText("0");
        this.jTextFieldPosXTo.setText("0");
        this.jTextFieldPosYTo.setText("0");
        this.jTextFieldMoveScale.setText("80");
        this.jTextFieldDelayVectrex.setText("3");
        this.jCheckBoxDisable.setSelected(false);
        this.jTextFieldFactor.setText("1");
        this.jTextFieldResync.setText("20");
        this.jTextFieldFrameCount.setText("0");
        this.jTextFieldAnimationName.setText("");
        this.jTextFieldRoundCount.setText("200");
        ++this.mClassSetting;
        this.jCheckBoxAnimationLoop.setSelected(true);
        this.jComboBoxDrawType.setModel(new DefaultComboBoxModel<String>(new String[]{""}));
        this.jComboBoxDrawType.setSelectedIndex(-1);
        --this.mClassSetting;
        this.upladeLaneData();
    }

    @Override
    public void setElement(StoryboardElement element, StoryboardLanePanel lane) {
        if (this.currentLane != null) {
            this.currentLane.setLaneSelected(false);
        }
        this.currentLane = lane;
        if (this.currentLane == null) {
            this.clearElement(false);
            return;
        }
        this.currentLane.setLaneSelected(true);
        if (this.currentElement != null) {
            this.currentElement.setElementSelected(false);
        }
        this.currentElement = element;
        this.jButtonLoad2.setEnabled(this.currentElement != null);
        this.jButton3.setEnabled(this.currentElement != null);
        if (this.currentElement == null) {
            this.clearElement(false);
            return;
        }
        this.currentElement.setElementSelected(true);
        this.jCheckBoxPause.setSelected(this.currentElement.pause);
        this.jTextFieldRoundCount.setText("" + element.roundCount);
        if (!this.currentElement.pause && !this.setAnimationFromElement(this.currentElement)) {
            this.clearElement(this.currentElement.pause);
            return;
        }
        this.jTextFieldAnimationName.setText(element.listName);
        this.jTextFieldFrameCount.setText("" + this.currentAnimation.size());
        this.jTextFieldListScaleFrom.setText("" + element.listScaleFrom);
        this.jTextFieldListScaleTo.setText("" + element.listScaleTo);
        this.jTextFieldListIntensityFrom.setText("" + element.intensityFrom);
        this.jTextFieldListIntensityTo.setText("" + element.intensityTo);
        this.jTextFieldPosXFrom.setText("" + element.positionXFrom);
        this.jTextFieldPosYFrom.setText("" + element.positionYFrom);
        this.jCheckBoxDisable.setSelected(element.disabled);
        this.jTextFieldPosXTo.setText("" + element.positionXTo);
        this.jTextFieldPosYTo.setText("" + element.positionYTo);
        this.jTextFieldMoveScale.setText("" + element.moveScale);
        if (element.vectrexdelay == 0) {
            element.vectrexdelay = 1;
        }
        this.jTextFieldDelayVectrex.setText("" + element.vectrexdelay);
        this.currentElement.delay = this.currentElement.vectrexdelay * 20;
        this.jTextFieldResync.setText("" + element.resyncMax);
        this.jTextFieldFactor.setText("" + element.factor);
        this.jTextFieldRoundCount.setText("" + element.roundCount);
        ++this.mClassSetting;
        this.jCheckBoxAnimationLoop.setSelected(element.animationLoop);
        --this.mClassSetting;
        this.setListType(element.drawType);
        this.upladeLaneData();
    }

    boolean loadAnimationFromElement(String loadName) {
        if (this.currentElement == null) {
            return false;
        }
        boolean ok = false;
        if (loadName == null) {
            this.clearElement(false);
            return false;
        }
        if (loadName.trim().length() == 0) {
            this.clearElement(false);
            return false;
        }
        if (loadName != null) {
            if (!loadName.toUpperCase().endsWith(".XML")) {
                loadName = loadName + ".xml";
            }
            this.currentAnimation = new GFXVectorAnimation();
            ok = this.currentAnimation.loadFromXML(loadName);
            if (ok) {
                if (this.currentAnimation.size() > 0) {
                    this.updateToElement(true);
                } else {
                    this.clearElement(false);
                    return false;
                }
            }
        }
        loadName = Utility.makeVideRelative(loadName);
        this.jTextFieldAnimationName.setText(loadName);
        this.currentElement.listName = loadName;
        this.upladeLaneData();
        return ok;
    }

    boolean setAnimationFromElement(StoryboardElement element) {
        if (element == null) {
            return false;
        }
        boolean ok = false;
        if (!element.pause) {
            String loadName = element.listName;
            this.currentAnimation = element.getAnimation();
            if (this.currentAnimation == null) {
                this.clearElement(false);
                return false;
            }
            if (this.currentAnimation.size() <= 0) {
                this.clearElement(false);
                return false;
            }
            this.updateToElement(true);
            this.currentElement.listName = loadName;
        }
        this.upladeLaneData();
        return true;
    }

    boolean loadAnimation() {
        boolean ok = false;
        String filename = Global.mainPathPrefix + "xml" + File.separator + "vectoranimation";
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        fc.setCurrentDirectory(new File(filename));
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return false;
        }
        String name = fc.getSelectedFile().getAbsolutePath();
        return this.loadAnimationFromElement(name);
    }

    private void setListType(String type) {
        ++this.mClassSetting;
        if (this.currentElement == null || this.currentAnimation == null) {
            this.jComboBoxDrawType.setModel(new DefaultComboBoxModel<String>(new String[]{""}));
            this.jComboBoxDrawType.setSelectedIndex(-1);
            --this.mClassSetting;
            return;
        }
        ArrayList<String> types = new ArrayList<String>();
        boolean Mov_Draw_VLc_a = true;
        boolean Draw_VLc = this.currentAnimation.isAnimation;
        boolean Draw_VLp = this.currentAnimation.isAnimation;
        boolean Draw_VL_mode = true;
        boolean AnimCodeGen = true;
        boolean allSamePattern = this.currentAnimation.isAllSamePattern();
        boolean allContinuous = this.currentAnimation.isCompleteRelative();
        boolean allHighPattern0 = this.getCurrentAnimation().isAllPatternHigh(true);
        if (!allSamePattern) {
            Draw_VLc = false;
        }
        if (!allHighPattern0) {
            Draw_VLp = false;
        }
        if (!allContinuous) {
            Mov_Draw_VLc_a = false;
            Draw_VLc = false;
            Draw_VLp = false;
            Draw_VL_mode = false;
            AnimCodeGen = false;
        }
        types.add("synced");
        types.add("synced extended");
        int index = -1;
        int count = 0;
        for (String s : types) {
            if (s.equals(type)) {
                index = count;
                break;
            }
            ++count;
        }
        this.jComboBoxDrawType.setModel(new DefaultComboBoxModel<String>(types.toArray(new String[0])));
        this.jComboBoxDrawType.setSelectedIndex(index);
        --this.mClassSetting;
    }

    private String getListType() {
        if (this.jComboBoxDrawType.getSelectedIndex() == -1) {
            return "";
        }
        if (this.jComboBoxDrawType.getSelectedItem() == null) {
            return "";
        }
        return this.jComboBoxDrawType.getSelectedItem().toString();
    }

    boolean loadStoryboard() {
        String filename = Global.mainPathPrefix + "xml" + File.separator + "storyboard";
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        fc.setCurrentDirectory(new File(filename));
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return false;
        }
        String loadName = fc.getSelectedFile().getAbsolutePath();
        boolean ok = false;
        if (loadName != null) {
            this.clearLanes();
            if (!loadName.toUpperCase().endsWith(".XML")) {
                loadName = loadName + ".xml";
            }
            ok = this.loadFromXML(loadName);
            this.jLabel9.setEnabled(this.currentElement.drawType != "synced extended");
            this.jTextFieldListIntensityFrom.setEnabled(this.currentElement.drawType != "synced extended");
            this.jTextFieldListIntensityTo.setEnabled(this.currentElement.drawType != "synced extended");
            if (this.currentElement.drawType == "synced extended") {
                this.currentElement.intensityTo = 127;
                this.currentElement.intensityFrom = 127;
                this.jTextFieldListIntensityFrom.setText("" + this.currentElement.intensityFrom);
                this.jTextFieldListIntensityTo.setText("" + this.currentElement.intensityTo);
            }
        }
        return ok;
    }

    boolean saveStoryboard() {
        String filename = Global.mainPathPrefix + "xml" + File.separator + "storyboard";
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        fc.setCurrentDirectory(new File(filename));
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return false;
        }
        if (fc.getSelectedFile() == null) {
            return false;
        }
        String saveName = fc.getSelectedFile().getAbsolutePath();
        if (saveName != null) {
            if (!saveName.toUpperCase().endsWith(".XML")) {
                saveName = saveName + ".xml";
            }
            return this.saveAsXML(saveName);
        }
        return false;
    }

    public boolean loadFromXML(String filename) {
        String xml = UtilityString.readTextFileToOneString(new File(filename));
        boolean ok = this.fromXML(xml, new XMLSupport());
        if (!ok) {
            this.log.addLog("Storyboard load from xml '" + filename + "' return false", LogPanel.WARN);
            return false;
        }
        return true;
    }

    public boolean saveAsXML(String filename) {
        StringBuilder xml = new StringBuilder();
        boolean ok = this.toXML(xml, "Storyboard");
        if (!ok) {
            this.log.addLog("Storyboard save 'toXML' return false", LogPanel.WARN);
            return false;
        }
        ok = UtilityFiles.createTextFile(filename, xml.toString());
        if (!ok) {
            this.log.addLog("Storyboard create file '" + filename + "' return false", LogPanel.WARN);
            return false;
        }
        return true;
    }

    public boolean toXML(StringBuilder s, String tag) {
        s.append("<").append(tag).append(">\n");
        boolean ok = true;
        ok &= XMLSupport.addElement(s, "noAdditionalStoryboardOptimization", this.jCheckBoxNoAdditionalSynOptimization.isSelected());
        for (StoryboardLanePanel l : this.lanes) {
            ok &= l.toXML(s, "SBLane");
        }
        s.append("</").append(tag).append(">\n");
        return ok;
    }

    public boolean fromXML(String xml, XMLSupport xmlSupport) {
        this.lanes = new ArrayList();
        int errorCode = 0;
        StringBuilder xmlBuffer = new StringBuilder(xml);
        StringBuilder oneElement = null;
        this.jCheckBoxNoAdditionalSynOptimization.setSelected(xmlSupport.getBooleanElement("noAdditionalStoryboardOptimization", xmlBuffer));
        errorCode |= xmlSupport.errorCode;
        while ((oneElement = xmlSupport.removeTag("SBLane", xmlBuffer)) != null) {
            errorCode |= xmlSupport.errorCode;
            StoryboardLanePanel sb = new StoryboardLanePanel(this);
            sb.fromXML(oneElement, xmlSupport);
            if (sb.isVersion1()) {
                this.log.addLog("Wrong storyboard version - not loaded", LogPanel.WARN);
                this.lanes = new ArrayList();
                this.upladeLaneData();
                this.updateBounds();
                return false;
            }
            errorCode |= xmlSupport.errorCode;
            this.lanePanel.add(sb);
            sb.setBounds(0, 0 + 80 * this.lanes.size(), sb.getBounds().width, 79);
            this.lanes.add(sb);
            this.lanePanel.repaint();
        }
        this.upladeLaneData();
        this.updateBounds();
        return errorCode == 0;
    }

    void clearLanes() {
        for (int i = this.lanePanel.getComponentCount() - 1; i >= 0; --i) {
            Component c = this.lanePanel.getComponent(i);
            if (!(c instanceof StoryboardLanePanel)) continue;
            this.lanePanel.remove(c);
        }
        this.currentElement = null;
        this.currentLane = null;
        this.upladeLaneData();
        this.repaint();
    }

    void deleteCurrentElement() {
        if (this.currentElement == null) {
            return;
        }
        if (this.currentLane == null) {
            return;
        }
        this.currentLane.removeElement(this.currentElement);
        this.upladeLaneData();
    }

    void deleteLane() {
        if (this.currentLane == null) {
            return;
        }
        this.lanePanel.remove(this.currentLane);
        this.lanes.remove(this.currentLane);
        this.currentLane = null;
        this.currentElement = null;
        this.reorder();
        this.upladeLaneData();
        this.lanePanel.repaint();
    }

    void reorder() {
        int count = 0;
        for (int i = 0; i < this.lanePanel.getComponentCount(); ++i) {
            Component c = this.lanePanel.getComponent(i);
            if (!(c instanceof StoryboardLanePanel)) continue;
            StoryboardLanePanel sb = (StoryboardLanePanel)c;
            sb.setBounds(0, 0 + 80 * count, sb.getBounds().width, 79);
            ++count;
        }
        this.updateBounds();
        this.repaint();
    }

    void guessBlowUpFactor() {
        int factor;
        if (this.currentAnimation == null) {
            return;
        }
        if (this.currentElement == null) {
            return;
        }
        int maxLen = (int)this.currentAnimation.getMaxAbsLenValue();
        if (maxLen == 0) {
            this.currentElement.factor = 1;
            this.jTextFieldFactor.setText("" + this.currentElement.factor);
            return;
        }
        this.currentElement.factor = factor = 127 / maxLen;
        this.jTextFieldFactor.setText("" + this.currentElement.factor);
    }

    private void generateSource() {
        String with = this.jTextFieldUniqueID.getText();
        if (with.length() != 0) {
            with = "_" + with;
        }
        StringBuilder text = new StringBuilder();
        HashMap<String, String> noDoubleAnimMap = new HashMap<String, String>();
        ArrayList<String> animData = new ArrayList<String>();
        HashMap<String, String> noDoubleRoutineMap = new HashMap<String, String>();
        ArrayList<String> routineData = new ArrayList<String>();
        ArrayList<String> laneInit = new ArrayList<String>();
        ArrayList<String> laneData = new ArrayList<String>();
        for (StoryboardLanePanel storyboardLanePanel : this.lanes) {
            storyboardLanePanel.getAnimData(animData, noDoubleAnimMap);
            storyboardLanePanel.getDrawRoutines(routineData, noDoubleRoutineMap);
            storyboardLanePanel.getLaneData(laneData, noDoubleAnimMap);
            storyboardLanePanel.getLaneInit(laneInit);
        }
        StringBuilder laneInitString = new StringBuilder();
        for (String li : laneInit) {
            laneInitString.append(li);
        }
        Path path = Paths.get(Global.mainPathPrefix, "template", "storyboardDefines.template");
        String defines = UtilityString.readTextFileToOneString(new File(path.toString()));
        Path path2 = Paths.get(Global.mainPathPrefix, "template", "storyboardMain.template");
        String main = UtilityString.readTextFileToOneString(new File(path2.toString()));
        main = UtilityString.replace(main, ";INSERT LANE INIT CODE", laneInitString.toString());
        Path path3 = Paths.get(Global.mainPathPrefix, "template", "storyboardRoutinesV2.template");
        String lane_subroutines = UtilityString.readTextFileToOneString(new File(path3.toString()));
        Path path4 = Paths.get(Global.mainPathPrefix, "template", "storyboardRAMV2.template");
        String ram = UtilityString.readTextFileToOneString(new File(path4.toString()));
        ram = UtilityString.replace(ram, "#LANE_COUNT#", "" + this.lanes.size());
        text.append(ram);
        text.append(defines);
        text.append(main);
        text.append(lane_subroutines);
        for (String routine : routineData) {
            text.append(routine);
        }
        for (String lc : laneData) {
            text.append(lc);
        }
        for (String anim : animData) {
            text.append(anim);
        }
        this.jTextAreaResult.setText(UtilityString.replace(text.toString(), "#_UNIQUE_ID#", with));
    }

    void upladeLaneData() {
        if (this.currentLane != null) {
            this.jTextFieldFrameCount2.setText("" + this.currentLane.getLengthInRound());
        } else {
            this.jTextFieldFrameCount2.setText("0");
        }
    }

    @Override
    public boolean isNoAdditionalSyncOptimization() {
        return this.jCheckBoxNoAdditionalSynOptimization.isSelected();
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    public void deIconified() {
    }
}

