/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.veccy;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.graphics.GFXVectorAnimation;
import de.malban.graphics.GFXVectorList;
import de.malban.graphics.Single3dDisplayPanel;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.HotKey;
import de.malban.gui.components.ModalInternalFrame;
import de.muntjak.tinylookandfeel.Theme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class VectorListFileChoserJPanel
extends JPanel {
    String filePath = "";
    boolean isAnimation = false;
    ArrayList<String> files = new ArrayList();
    String returnText = "";
    ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/malban/vide/images/vector.png"));
    private JButton jButtonCancel;
    private JButton jButtonCodeGen;
    private JButton jButtonDraw_VL_mode;
    private JButton jButtonDraw_VLc;
    private JButton jButtonDraw_VLp;
    private JButton jButtonMov_Draw_VLc_a;
    private JButton jButtonOk;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JTextField jTextFieldFileName;
    private Single3dDisplayPanel singleVectorPanel;
    ModalInternalFrame modelDialog;

    public String getStringRepresentation() {
        return this.returnText;
    }

    public VectorListFileChoserJPanel(String filepath, boolean ia) {
        this.initComponents();
        if (Global.getOSName().toUpperCase().contains("MAC")) {
            HotKey.addMacDefaults(this.jTextFieldFileName);
        }
        this.isAnimation = ia;
        this.filePath = filepath;
        this.initTable();
        this.singleVectorPanel.setGrid(false, 1);
        if (this.isAnimation) {
            this.singleVectorPanel.setDelay(80);
            this.jLabel3.setText("All animations are stored in the directory:");
            this.jLabel4.setText("%VIDE%/xml/vectoranimation");
        }
        this.jLabel5.setVisible(this.isAnimation);
        this.singleVectorPanel.setByteFrame(false);
        this.singleVectorPanel.setAxisAngleX(0);
        this.singleVectorPanel.setAxisAngleY(0);
        this.singleVectorPanel.setAxisAngleZ(0);
        ListSelectionModel cellSelectionModel = this.jTable1.getSelectionModel();
        cellSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                VectorListFileChoserJPanel.this.tableSelectionChanged();
            }
        });
        this.updateMyUI();
    }

    void updateMyUI() {
        int fontSize = Theme.textFieldFont.getFont().getSize();
        int rowHeight = fontSize + 2;
        this.jTable1.setRowHeight(rowHeight);
    }

    void setExportTypesVisible(boolean showExportTypes) {
        this.jButtonOk.setVisible(!showExportTypes);
        this.jPanel2.setVisible(showExportTypes);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jButtonOk = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabel1 = new JLabel();
        this.jTextFieldFileName = new JTextField();
        this.jLabel2 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jPanel3 = new JPanel();
        this.singleVectorPanel = new Single3dDisplayPanel();
        this.jLabel5 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jButtonMov_Draw_VLc_a = new JButton();
        this.jButtonDraw_VLc = new JButton();
        this.jButtonDraw_VLp = new JButton();
        this.jButtonDraw_VL_mode = new JButton();
        this.jButtonCodeGen = new JButton();
        this.jScrollPane1.setBackground(new Color(255, 255, 255));
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable1.setSelectionMode(0);
        this.jTable1.setShowHorizontalLines(false);
        this.jTable1.setShowVerticalLines(false);
        this.jTable1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                VectorListFileChoserJPanel.this.jTable1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jButtonOk.setText("Ok");
        this.jButtonOk.setName("create");
        this.jButtonOk.setPreferredSize(new Dimension(0, 21));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setPreferredSize(new Dimension(0, 21));
        this.jLabel1.setText("Filename:");
        this.jTextFieldFileName.setPreferredSize(new Dimension(0, 21));
        this.jLabel2.setText("Filename:");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"XML"}));
        this.jComboBox1.setEnabled(false);
        this.jComboBox1.setPreferredSize(new Dimension(0, 21));
        this.jLabel3.setText("All vectorlists are stored in the directory:");
        this.jLabel4.setFont(new Font("Courier New", 0, 14));
        this.jLabel4.setText("%VIDE%/xml/vectorlist");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel4)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addGap(5, 5, 5)));
        this.singleVectorPanel.setPreferredSize(new Dimension(200, 200));
        GroupLayout singleVectorPanelLayout = new GroupLayout(this.singleVectorPanel);
        this.singleVectorPanel.setLayout(singleVectorPanelLayout);
        singleVectorPanelLayout.setHorizontalGroup(singleVectorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 200, Short.MAX_VALUE));
        singleVectorPanelLayout.setVerticalGroup(singleVectorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 200, Short.MAX_VALUE));
        this.jLabel5.setText("animation");
        this.jButtonMov_Draw_VLc_a.setText("Mov_Draw_VLc_a");
        this.jButtonMov_Draw_VLc_a.setToolTipText("<html>\n<B>Mov_Draw_VLc_a</B>        <BR>                                  \n                                                <BR>                            \nThis routine moves to the first location specified in vector list,    <BR>     \nand then draws lines between the rest of coordinates in the list.    <BR>      \nThe number of vectors to draw is specified as the first byte in the   <BR>     \nvector list.  The current scale factor is used.  The vector list has  <BR>     \nthe following format:                                                 <BR>     \n                                       <BR>                                  \n<PRE>\n   count, rel y, rel x, rel y, rel x, ... \n</PRE>\n<BR>     \n</html>");
        this.jButtonMov_Draw_VLc_a.setEnabled(false);
        this.jButtonMov_Draw_VLc_a.setHorizontalAlignment(2);
        this.jButtonMov_Draw_VLc_a.setName("create");
        this.jButtonMov_Draw_VLc_a.setPreferredSize(new Dimension(160, 21));
        this.jButtonMov_Draw_VLc_a.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VectorListFileChoserJPanel.this.jButtonMov_Draw_VLc_aActionPerformed(evt);
            }
        });
        this.jButtonDraw_VLc.setText("Draw_VLc");
        this.jButtonDraw_VLc.setToolTipText("<html>\n<B>Draw_VLc</B>        <BR>                                  \n                                                <BR>                            \nThis routine draws vectors between the set of (y,x) points pointed    <BR>     \nto by the X register.  The number of vectors to draw is specified     <BR>     \nas the first byte in the vector list.  The current scale factor is    <BR>     \nused.  The vector list has the following format:                      <BR>  \n<BR>\n<PRE>\n   count, rel y, rel x, rel y, rel x, ... \n</PRE>\n<BR>     \n</html>\n\n\n   \n");
        this.jButtonDraw_VLc.setEnabled(false);
        this.jButtonDraw_VLc.setHorizontalAlignment(2);
        this.jButtonDraw_VLc.setName("create");
        this.jButtonDraw_VLc.setPreferredSize(new Dimension(160, 21));
        this.jButtonDraw_VLc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VectorListFileChoserJPanel.this.jButtonDraw_VLcActionPerformed(evt);
            }
        });
        this.jButtonDraw_VLp.setText("Draw_VLp");
        this.jButtonDraw_VLp.setToolTipText("<html>\n<B>Draw_VLp</B>        <BR>                                  \n                                                <BR>                            \nThis routine draws patterned lines using the vector list pointed to   <BR>\nby the X-register.  The current scale factor is used.  The vector   <BR>\nlist has the following format: <BR>\n<BR>\n<PRE>\n      pattern, rel y, rel x                                           \n      pattern, rel y, rel x                                           \n         .      .      .                                              \n         .      .      .                                              \n      pattern, rel y, rel x                                           \n      0x01 \n</PRE>\n<BR>     \n</html>\n");
        this.jButtonDraw_VLp.setEnabled(false);
        this.jButtonDraw_VLp.setHorizontalAlignment(2);
        this.jButtonDraw_VLp.setName("create");
        this.jButtonDraw_VLp.setPreferredSize(new Dimension(160, 21));
        this.jButtonDraw_VLp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VectorListFileChoserJPanel.this.jButtonDraw_VLpActionPerformed(evt);
            }
        });
        this.jButtonDraw_VL_mode.setText("Draw_VL_mode");
        this.jButtonDraw_VL_mode.setToolTipText("<html>\n<B>Draw_VL_mode</B>        <BR>                                  \n                                                <BR>                            \nThis routine processes the vector list pointed to by the X register.  <BR> \nThe current scale factor is used.  The vector list has the following  <BR> \nformat: <BR> \n<BR>\n<PRE>\n     mode, rel y, rel x,                                             \n     mode, rel y, rel x,                                             \n     .      .      .                                                \n     .      .      .                                                \n     mode, rel y, rel x,                                             \n     0x01  \n</PRE>\n<BR>\nwhere mode has the following meaning:         <BR>                        \n                                              <BR>                    \n< 0  use the pattern in $C829        <BR>                           \n= 0  move to specified endpoint      <BR>                           \n= 1  end of list, so return         <BR>                            \n> 1  draw to specified endpoint <BR>\n<BR>     \n</html>\n");
        this.jButtonDraw_VL_mode.setEnabled(false);
        this.jButtonDraw_VL_mode.setHorizontalAlignment(2);
        this.jButtonDraw_VL_mode.setName("create");
        this.jButtonDraw_VL_mode.setPreferredSize(new Dimension(160, 21));
        this.jButtonDraw_VL_mode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VectorListFileChoserJPanel.this.jButtonDraw_VL_modeActionPerformed(evt);
            }
        });
        this.jButtonCodeGen.setText("Code generation");
        this.jButtonCodeGen.setToolTipText("");
        this.jButtonCodeGen.setEnabled(false);
        this.jButtonCodeGen.setHorizontalAlignment(2);
        this.jButtonCodeGen.setName("create");
        this.jButtonCodeGen.setPreferredSize(new Dimension(160, 21));
        this.jButtonCodeGen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VectorListFileChoserJPanel.this.jButtonCodeGenActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonMov_Draw_VLc_a, -2, 181, -2).addComponent(this.jButtonDraw_VLc, -2, 181, -2).addComponent(this.jButtonDraw_VLp, -2, 181, -2).addComponent(this.jButtonDraw_VL_mode, -2, 181, -2).addComponent(this.jButtonCodeGen, -2, 181, -2));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jButtonMov_Draw_VLc_a, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDraw_VLc, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDraw_VLp, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDraw_VL_mode, -2, -1, -2).addGap(5, 5, 5).addComponent(this.jButtonCodeGen, -2, -1, -2)));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel5, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addComponent(this.singleVectorPanel, -2, -1, -2)).addGap(5, 5, 5)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.singleVectorPanel, -1, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addGap(2, 2, 2).addComponent(this.jPanel2, -1, -1, -2)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(12, 12, 12).addComponent(this.jTextFieldFileName, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonOk, -2, 86, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel, -2, 86, -2)).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jComboBox1, 0, -1, Short.MAX_VALUE))))).addGap(270, 270, 270)).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addGap(5, 5, 5).addComponent(this.jPanel3, -2, -1, -2).addGap(5, 5, 5)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldFileName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addGroup(layout.createSequentialGroup().addComponent(this.jComboBox1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOk, -2, -1, -2).addComponent(this.jButtonCancel, -2, -1, -2)))).addContainerGap()));
    }

    private void jTable1MouseClicked(MouseEvent evt) {
        JTable table = (JTable)evt.getSource();
        Point p = evt.getPoint();
        int row = table.rowAtPoint(p);
        int col = table.columnAtPoint(p);
        if (evt.getClickCount() == 2) {
            Container c = this.getParent();
            if (c == null) {
                return;
            }
            Container c2 = c.getParent();
            if (c2 == null) {
                return;
            }
            Container c3 = c2.getParent();
            if (c3 == null) {
                return;
            }
            Container c4 = c3.getParent();
            if (c4 == null) {
                return;
            }
            if (!(c4 instanceof ModalInternalFrame)) {
                return;
            }
            ModalInternalFrame modal = (ModalInternalFrame)c4;
            modal.modalExit(true);
        }
    }

    private void jButtonMov_Draw_VLc_aActionPerformed(ActionEvent evt) {
        String name = this.getChosenFilename();
        if (name.trim().length() == 0) {
            return;
        }
        File f = new File(name);
        if (!f.exists()) {
            return;
        }
        if (!f.isFile()) {
            return;
        }
        if (!name.toUpperCase().endsWith(".XML")) {
            return;
        }
        name = f.getName();
        name = name.substring(0, name.length() - 4);
        if (this.isAnimation) {
            GFXVectorAnimation animation = new GFXVectorAnimation(this.getChosenFilename());
            this.returnText = animation.createASMMov_Draw_VLc_a(name, false);
            return;
        }
        GFXVectorList vl = this.singleVectorPanel.getForegroundVectorList();
        this.returnText = vl.createASMMov_Draw_VLc_a(true, name, false);
    }

    private void jButtonDraw_VLcActionPerformed(ActionEvent evt) {
        String name = this.getChosenFilename();
        if (name.trim().length() == 0) {
            return;
        }
        File f = new File(name);
        if (!f.exists()) {
            return;
        }
        if (!f.isFile()) {
            return;
        }
        if (!name.toUpperCase().endsWith(".XML")) {
            return;
        }
        name = f.getName();
        name = name.substring(0, name.length() - 4);
        if (this.isAnimation) {
            GFXVectorAnimation animation = new GFXVectorAnimation(this.getChosenFilename());
            this.returnText = animation.createASMMov_Draw_VLc_a(name, false);
            return;
        }
        GFXVectorList vl = this.singleVectorPanel.getForegroundVectorList();
        this.returnText = vl.createASMMov_Draw_VLc_a(false, name, false);
    }

    private void jButtonDraw_VLpActionPerformed(ActionEvent evt) {
        String name = this.getChosenFilename();
        if (name.trim().length() == 0) {
            return;
        }
        File f = new File(name);
        if (!f.exists()) {
            return;
        }
        if (!f.isFile()) {
            return;
        }
        if (!name.toUpperCase().endsWith(".XML")) {
            return;
        }
        name = f.getName();
        name = name.substring(0, name.length() - 4);
        if (this.isAnimation) {
            GFXVectorAnimation animation = new GFXVectorAnimation(this.getChosenFilename());
            this.returnText = animation.createASMDraw_VLp(name, false);
            return;
        }
        GFXVectorList vl = this.singleVectorPanel.getForegroundVectorList();
        this.returnText = vl.createASMDraw_VLp(name, false, false);
    }

    private void jButtonDraw_VL_modeActionPerformed(ActionEvent evt) {
        String name = this.getChosenFilename();
        if (name.trim().length() == 0) {
            return;
        }
        File f = new File(name);
        if (!f.exists()) {
            return;
        }
        if (!f.isFile()) {
            return;
        }
        if (!name.toUpperCase().endsWith(".XML")) {
            return;
        }
        name = f.getName();
        name = name.substring(0, name.length() - 4);
        if (this.isAnimation) {
            GFXVectorAnimation animation = new GFXVectorAnimation(this.getChosenFilename());
            this.returnText = animation.createASMDraw_VL_mode(name, true, false);
            return;
        }
        GFXVectorList vl = this.singleVectorPanel.getForegroundVectorList();
        this.returnText = vl.createASMDraw_VL_mode(name, false, false);
    }

    private void jButtonCodeGenActionPerformed(ActionEvent evt) {
        String name = this.getChosenFilename();
        if (name.trim().length() == 0) {
            return;
        }
        File f = new File(name);
        if (!f.exists()) {
            return;
        }
        if (!f.isFile()) {
            return;
        }
        if (!name.toUpperCase().endsWith(".XML")) {
            return;
        }
        name = f.getName();
        name = name.substring(0, name.length() - 4);
        if (this.isAnimation) {
            GFXVectorAnimation animation = new GFXVectorAnimation(this.getChosenFilename());
            this.returnText = animation.createASMCodeGen(name);
            return;
        }
        GFXVectorList vl = this.singleVectorPanel.getForegroundVectorList();
        this.returnText = vl.createASMCodeGen(name);
    }

    void tableSelectionChanged() {
        this.singleVectorPanel.clearVectors();
        int row = this.jTable1.getSelectedRow();
        if (row == -1) {
            int[] selectedRow = this.jTable1.getSelectedRows();
            if (selectedRow.length == 0) {
                return;
            }
            row = selectedRow[0];
        }
        if (row >= 0 && row < this.files.size()) {
            this.jTextFieldFileName.setText(this.files.get(row));
            if (this.isAnimation) {
                GFXVectorAnimation animation = new GFXVectorAnimation(this.getChosenFilename());
                if (animation.isAnimation) {
                    this.singleVectorPanel.setAnimation(new GFXVectorAnimation());
                    this.singleVectorPanel.setDelay(-1);
                    this.singleVectorPanel.setDelay(80);
                    this.singleVectorPanel.setAnimation(animation);
                    this.jLabel5.setText("animation");
                } else {
                    this.singleVectorPanel.setAnimation(new GFXVectorAnimation());
                    this.singleVectorPanel.setDelay(-1);
                    this.jLabel5.setText("scenario");
                    GFXVectorList vl = new GFXVectorList();
                    for (int i = 0; i < animation.size(); ++i) {
                        vl.add(animation.get(i));
                    }
                    if (vl.size() < 200) {
                        vl.connectWherePossible(false);
                        this.singleVectorPanel.setForegroundVectorList(vl);
                    }
                }
                this.jButtonMov_Draw_VLc_a.setEnabled(true);
                this.jButtonDraw_VLc.setEnabled(animation.isAnimation);
                this.jButtonDraw_VLp.setEnabled(animation.isAnimation);
                this.jButtonDraw_VL_mode.setEnabled(true);
                this.jButtonCodeGen.setEnabled(true);
                boolean allSamePattern = animation.isAllSamePattern();
                boolean allContinuous = animation.isCompleteRelative();
                boolean allHighPattern = animation.isAllPatternHigh(true);
                if (!allSamePattern) {
                    this.jButtonMov_Draw_VLc_a.setEnabled(false);
                    this.jButtonDraw_VLc.setEnabled(false);
                }
                if (!allContinuous) {
                    this.jButtonMov_Draw_VLc_a.setEnabled(false);
                    this.jButtonDraw_VLc.setEnabled(false);
                    this.jButtonDraw_VLp.setEnabled(false);
                    this.jButtonDraw_VL_mode.setEnabled(false);
                    this.jButtonCodeGen.setEnabled(false);
                }
                if (!allHighPattern) {
                    this.jButtonDraw_VLp.setEnabled(false);
                }
            } else {
                this.singleVectorPanel.addForegroundVectorList(new GFXVectorList(this.getChosenFilename()));
                Rectangle b = this.singleVectorPanel.getBounds();
                b.height = 200;
                b.width = 200;
                this.singleVectorPanel.setBounds(b);
                GFXVectorList vl = this.singleVectorPanel.getForegroundVectorList();
                this.jButtonMov_Draw_VLc_a.setEnabled(true);
                this.jButtonDraw_VLc.setEnabled(true);
                this.jButtonDraw_VLp.setEnabled(true);
                this.jButtonDraw_VL_mode.setEnabled(true);
                this.jButtonCodeGen.setEnabled(true);
                if (!vl.isAllSamePattern()) {
                    this.jButtonMov_Draw_VLc_a.setEnabled(false);
                    this.jButtonDraw_VLc.setEnabled(false);
                }
                if (!vl.isCompleteRelative()) {
                    this.jButtonMov_Draw_VLc_a.setEnabled(false);
                    this.jButtonDraw_VLc.setEnabled(false);
                    this.jButtonDraw_VLp.setEnabled(false);
                    this.jButtonDraw_VL_mode.setEnabled(false);
                    this.jButtonCodeGen.setEnabled(false);
                }
                if (!vl.isAllPatternHigh(true)) {
                    this.jButtonDraw_VLp.setEnabled(false);
                }
                if (vl.getXMaxLength() > 127 || vl.getYMaxLength() > 127 || vl.getZMaxLength() > 127) {
                    this.jButtonMov_Draw_VLc_a.setEnabled(false);
                    this.jButtonDraw_VLc.setEnabled(false);
                    this.jButtonDraw_VLp.setEnabled(false);
                    this.jButtonDraw_VL_mode.setEnabled(false);
                    this.jButtonCodeGen.setEnabled(false);
                }
            }
            this.singleVectorPanel.scaleToFit();
        }
    }

    public static String showSavePanel(String fileName, String title2, boolean ia) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        VectorListFileChoserJPanel panel = new VectorListFileChoserJPanel(fileName, ia);
        ArrayList<JButton> eb = new ArrayList<JButton>();
        eb.add(panel.jButtonOk);
        eb.add(panel.jButtonCancel);
        ModalInternalFrame modal = new ModalInternalFrame(title2, frame.getRootPane(), frame, panel, null, null, eb);
        modal.setResizable(true);
        panel.modelDialog = modal;
        modal.setVisible(true);
        panel.singleVectorPanel.setDelay(-1);
        String result = modal.getNamedExit();
        if (result.equals("create") || modal.isManualOkExit()) {
            modal = null;
            String saveName = panel.getChosenFilename();
            panel = null;
            if (saveName != null && saveName.length() != 0) {
                return saveName;
            }
        }
        panel = null;
        modal = null;
        return null;
    }

    public static String showLoadPanel(String fileName, String title2, boolean ia) {
        return VectorListFileChoserJPanel.showLoadPanel(fileName, title2, ia, false);
    }

    public static String showLoadPanel(String fileName, String title2, boolean ia, boolean showExportTypes) {
        String loadName;
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        VectorListFileChoserJPanel panel = new VectorListFileChoserJPanel(fileName, ia);
        panel.setExportTypesVisible(showExportTypes);
        ArrayList<JButton> eb = new ArrayList<JButton>();
        eb.add(panel.jButtonOk);
        eb.add(panel.jButtonCancel);
        eb.add(panel.jButtonMov_Draw_VLc_a);
        eb.add(panel.jButtonDraw_VLc);
        eb.add(panel.jButtonDraw_VLp);
        eb.add(panel.jButtonDraw_VL_mode);
        eb.add(panel.jButtonCodeGen);
        ModalInternalFrame modal = new ModalInternalFrame(title2, frame.getRootPane(), frame, panel, null, null, eb);
        modal.setResizable(true);
        panel.modelDialog = modal;
        panel.jTextFieldFileName.setEnabled(false);
        modal.setVisible(true);
        String result = modal.getNamedExit();
        if ((result.equals("create") || modal.isManualOkExit()) && (loadName = panel.getChosenFilename()) != null && loadName.length() != 0) {
            if (showExportTypes) {
                return panel.returnText;
            }
            return loadName;
        }
        return null;
    }

    boolean initTable() {
        File directory = new File(this.filePath);
        if (!directory.isDirectory()) {
            if (directory.getParent() != null) {
                directory = new File(directory.getParent());
            }
            if (!directory.isDirectory()) {
                return false;
            }
        }
        this.filePath = directory.toString();
        File[] fList = directory.listFiles();
        Arrays.sort(fList, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                if (f1 == null) {
                    return 1;
                }
                if (f2 == null) {
                    return -1;
                }
                if (f1.isDirectory() && !f2.isDirectory()) {
                    return -1;
                }
                if (f2.isDirectory() && !f1.isDirectory()) {
                    return 1;
                }
                return f1.getName().toLowerCase().compareTo(f2.getName().toLowerCase());
            }
        });
        for (File file : fList) {
            if (!file.getName().contains(".xml")) continue;
            this.files.add(file.getName());
        }
        this.jTable1.setTableHeader(null);
        this.jTable1.setModel(new FileTableModel());
        this.jTable1.setFillsViewportHeight(true);
        this.jTable1.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
                if (table.getModel() instanceof FileTableModel) {
                    FileTableModel fileTableModel = (FileTableModel)table.getModel();
                }
                if (c instanceof JLabel) {
                    ((JLabel)c).setIcon(VectorListFileChoserJPanel.this.icon);
                }
                return this;
            }
        });
        return true;
    }

    String getChosenFilename() {
        String name = this.jTextFieldFileName.getText();
        if (name.trim().length() == 0) {
            int i = this.jTable1.getSelectedRow();
            if (i < 0) {
                return null;
            }
            name = this.files.get(i);
        }
        name = !this.filePath.endsWith(File.separator) ? (this.filePath.trim().length() != 0 ? this.filePath + File.separator + name : this.filePath + name) : this.filePath + name;
        return name;
    }

    public class FileTableModel
    extends AbstractTableModel {
        String[] columns = new String[]{"Filename"};

        @Override
        public String getColumnName(int col) {
            return this.columns[col];
        }

        @Override
        public int getRowCount() {
            return VectorListFileChoserJPanel.this.files.size();
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return VectorListFileChoserJPanel.this.files.get(row);
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

