/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.veccy.gtest;

import de.malban.vide.veccy.gtest.Point2D;
import de.malban.vide.veccy.gtest.Triangle;

class Tools2D {
    Tools2D() {
    }

    static float area2(Point2D A, Point2D B, Point2D C) {
        float pixels = (A.x - C.x) * (B.y - C.y) - (A.y - C.y) * (B.x - C.x);
        return pixels;
    }

    static boolean insideTriangle(Point2D A, Point2D B, Point2D C, Point2D P2) {
        return Tools2D.area2(A, B, P2) >= 0.0f && Tools2D.area2(B, C, P2) >= 0.0f && Tools2D.area2(C, A, P2) >= 0.0f;
    }

    static void triangulate(Point2D[] P2, Triangle[] tr) {
        int n = P2.length;
        int j = n - 1;
        int iA = 0;
        int[] next = new int[n];
        int i = 0;
        while (i < n) {
            next[j] = i;
            j = i++;
        }
        for (int k = 0; k < n - 2; ++k) {
            boolean triaFound = false;
            int count = 0;
            while (!triaFound && ++count < n) {
                Point2D A = P2[iA];
                int iB = next[iA];
                Point2D B = P2[iB];
                int iC = next[iB];
                Point2D C = P2[iC];
                if (Tools2D.area2(A, B, C) >= 0.0f) {
                    j = next[iC];
                    while (j != iA && !Tools2D.insideTriangle(A, B, C, P2[j])) {
                        j = next[j];
                    }
                    if (j == iA) {
                        tr[k] = new Triangle(A, B, C);
                        next[iA] = iC;
                        triaFound = true;
                    }
                }
                iA = next[iA];
            }
            if (count != n) continue;
            System.out.println("Not a simple polygon or vertex sequence not counter-clockwise.");
            System.exit(1);
        }
    }

    static float distance2(Point2D P2, Point2D Q) {
        float dx = P2.x - Q.x;
        float dy = P2.y - Q.y;
        return dx * dx + dy * dy;
    }
}

