/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx;

import de.malban.vide.dissy.MemoryInformation;
import java.io.Serializable;
import java.util.ArrayList;

public class Breakpoint
implements Serializable {
    public static int BP_NONE = 0;
    public static int BP_ONCE = 1;
    public static int BP_MULTI = 2;
    public static int BP_READ = 4;
    public static int BP_WRITE = 8;
    public static int BP_INFO = 16;
    public static int BP_COMPARE = 32;
    public static int BP_HEY = 64;
    public static int BP_BANK = 128;
    public static int BP_BITCOMPARE = 256;
    public static int BP_CYCLES = 512;
    public static int BP_QUIET = 1024;
    public static int BP_ALLBANK = 2048;
    public static int BP_WEIRD = 4096;
    public static int BP_INTEGRATOR = 8192;
    public static String[] types = new String[]{"once", "multi", "read", "write", "info", "compare", "hey", "bank", "bitcompare", "cycles", "quiet", "allbanks", "weird", "integrators"};
    public static int BP_TARGET_MEMORY = 0;
    public static int BP_TARGET_CPU = 1;
    public static int BP_TARGET_ANALOG = 2;
    public static int BP_TARGET_VIA = 3;
    public static int BP_TARGET_PSG = 4;
    public static int BP_TARGET_CARTRIDGE = 5;
    public static int BP_TARGET_PORT = 6;
    public static int BP_TARGET_COUNT = 7;
    public static String[] bp_target = new String[]{"Memory", "CPU", "Analog", "VIA", "PSG", "CARTRIDGE", "PORT"};
    public static String[][] bp_subtarget = new String[][]{{"none", "RAM", "ROM"}, {"none", "PC", "A", "B", "D", "X", "Y", "U", "S", "CC", "DP", "CYCLES", "SPECIAL", "STACK CHANGE"}, {"none", "RAMP"}, {"none", "ORB", "CA1", "AUX", "T2"}, {"none", "PSG 0"}, {"none", "BANKSWITCH", "PB6"}, {"none", "IN", "OUT"}};
    public static int BP_SUBTARGET_MEMORY_NONE = 0;
    public static int BP_SUBTARGET_MEMORY_RAM = 1;
    public static int BP_SUBTARGET_MEMORY_ROM = 2;
    public static int BP_SUBTARGET_CPU_NONE = 0;
    public static int BP_SUBTARGET_CPU_PC = 1;
    public static int BP_SUBTARGET_CPU_A = 2;
    public static int BP_SUBTARGET_CPU_B = 3;
    public static int BP_SUBTARGET_CPU_D = 4;
    public static int BP_SUBTARGET_CPU_X = 5;
    public static int BP_SUBTARGET_CPU_Y = 6;
    public static int BP_SUBTARGET_CPU_U = 7;
    public static int BP_SUBTARGET_CPU_S = 8;
    public static int BP_SUBTARGET_CPU_CC = 9;
    public static int BP_SUBTARGET_CPU_DP = 10;
    public static int BP_SUBTARGET_CPU_CYCLES = 11;
    public static int BP_SUBTARGET_CPU_SPECIAL = 12;
    public static int BP_SUBTARGET_CPU_STACKCHANGE = 13;
    public static int BP_SUBTARGET_ANALOG_NONE = 0;
    public static int BP_SUBTARGET_ANALOG_RAMP = 1;
    public static int BP_SUBTARGET_VIA_NONE = 0;
    public static int BP_SUBTARGET_VIA_ORB = 1;
    public static int BP_SUBTARGET_VIA_CA1 = 2;
    public static int BP_SUBTARGET_VIA_AUX = 3;
    public static int BP_SUBTARGET_VIA_T2 = 4;
    public static int BP_SUBTARGET_PSG_NONE = 0;
    public static int BP_SUBTARGET_PSG_0 = 1;
    public static int BP_SUBTARGET_CARTRIDGE_NONE = 0;
    public static int BP_SUBTARGET_CARTRIDGE_BANKSWITCH = 1;
    public static int BP_SUBTARGET_CARTRIDGE_PB6 = 2;
    public static int BP_SUBTARGET_PORT_NONE = 0;
    public static int BP_SUBTARGET_PORT_IN = 1;
    public static int BP_SUBTARGET_PORT_OUT = 2;
    private static int UID_C = 1;
    public int targetType = BP_TARGET_CPU;
    public int targetSubType = BP_SUBTARGET_CPU_PC;
    public int type = BP_ONCE;
    public int targetAddress = 0;
    public int targetBank = 0;
    public int compareValue = 0;
    public long counter = 0L;
    public String name = "";
    public int exitType = 3;
    public boolean enabled = true;
    public ArrayList<String> printInfo = null;
    public transient MemoryInformation memInfo = null;
    public final transient int uid = UID_C++;
    public transient boolean wasTriggered = false;

    public Breakpoint duplicate() {
        Breakpoint nbp = new Breakpoint();
        nbp.targetType = this.targetType;
        nbp.targetSubType = this.targetSubType;
        nbp.type = this.type;
        nbp.targetAddress = this.targetAddress;
        nbp.targetBank = this.targetBank;
        nbp.compareValue = this.compareValue;
        nbp.counter = this.counter;
        nbp.name = this.name;
        nbp.enabled = this.enabled;
        nbp.exitType = this.exitType;
        nbp.wasTriggered = this.wasTriggered;
        nbp.printInfo = this.printInfo != null ? (ArrayList)this.printInfo.clone() : null;
        nbp.memInfo = this.memInfo;
        return nbp;
    }

    public boolean addressEquals(Breakpoint bp) {
        if (this.targetType != bp.targetType) {
            return false;
        }
        if (this.targetSubType != bp.targetSubType) {
            return false;
        }
        if (this.targetAddress != bp.targetAddress) {
            return false;
        }
        if (this.targetBank != bp.targetBank) {
            return false;
        }
        return this.type == bp.type;
    }

    public boolean equals(Breakpoint bp) {
        if (this.targetType != bp.targetType) {
            return false;
        }
        if (this.targetSubType != bp.targetSubType) {
            return false;
        }
        if (this.targetAddress != bp.targetAddress) {
            return false;
        }
        if (this.targetBank != bp.targetBank) {
            return false;
        }
        if (this.compareValue != bp.compareValue) {
            return false;
        }
        return this.type == bp.type;
    }

    public String toString() {
        String ret = "Breakpoint, type=" + bp_target[this.targetType];
        ret = ret + ", subtype=" + bp_subtarget[this.targetType][this.targetSubType];
        if (this.targetAddress != 0) {
            ret = ret + ", address=" + String.format("$%04X", this.targetAddress);
            ret = ret + ", bank=" + this.targetBank;
        }
        ret = ret + ", typeflags: ";
        int t = this.type;
        for (int i = 0; i < types.length; ++i) {
            if ((t & 1) == 1) {
                ret = ret + types[i] + " ";
            }
            t >>= 1;
        }
        return ret;
    }

    public String getTargetString() {
        return bp_target[this.targetType];
    }

    public String getTargetSubtypeString() {
        return bp_subtarget[this.targetType][this.targetSubType];
    }

    public int getTargetAddress() {
        return this.targetAddress;
    }

    public int getTargetBank() {
        return this.targetBank;
    }

    public String getTypeString() {
        String ret = "";
        int t = this.type;
        for (int i = 0; i < types.length; ++i) {
            if ((t & 1) == 1) {
                ret = ret + types[i] + " ";
            }
            t >>= 1;
        }
        return ret;
    }

    public int getCompareValue() {
        return this.compareValue;
    }

    public String getExitTypeString() {
        if (this.exitType == 3) {
            return "break";
        }
        return "info";
    }

    public long getCounter() {
        return this.counter;
    }

    public String getName() {
        return this.name;
    }

    public boolean wasTriggered() {
        return this.wasTriggered;
    }

    public void setTriggered(boolean b) {
        this.wasTriggered = b;
    }
}

