/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx;

import java.io.Serializable;

public class Capacitorial
implements Serializable {
    double resistorOhm;
    double capacitorFarad;
    double currentVoltage = 0.0;
    double supplyVoltage = 0.0;
    double timeConstant;
    double offsetUnloadValue;
    double percentageDifChangePerCycle;
    private static double VECTREX_CYCLE_TIME = 6.666666666666667E-7;

    public Capacitorial(double r, double c) {
        this.resistorOhm = r;
        this.capacitorFarad = c;
        this.timeConstant = r * c;
        this.percentageDifChangePerCycle = Math.exp(-VECTREX_CYCLE_TIME / this.timeConstant);
    }

    public int getIntVoltageValue() {
        return (int)this.currentVoltage;
    }

    public double getVoltageValue() {
        return this.currentVoltage;
    }

    public double getDigitalValue() {
        return this.currentVoltage / 5.0 * 128.0;
    }

    public int getDigitalIntValue() {
        return (int)((this.currentVoltage + this.offsetUnloadValue) / 5.0 * 128.0);
    }

    public void doStep() {
        boolean charging = Math.abs(this.currentVoltage) < Math.abs(this.supplyVoltage);
        double dif = this.supplyVoltage - this.currentVoltage;
        this.currentVoltage = charging ? (this.currentVoltage += this.percentageDifChangePerCycle * dif) : (this.currentVoltage += this.percentageDifChangePerCycle * dif);
    }

    public void doDischargeStep() {
        this.currentVoltage -= 8.0E-9;
    }

    public void setDigitalVoltage(int v) {
        this.offsetUnloadValue = 0.0;
        this.supplyVoltage = v <= 127 ? (double)v / 127.0 * 5.0 : ((double)v - 256.0) / 128.0 * 5.0;
    }
}

