/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx;

import de.malban.sound.tinysound.Stream;
import de.malban.sound.tinysound.TinySound;
import de.malban.vide.VideConfig;
import de.malban.vide.vecx.E8910State;
import de.malban.vide.vecx.E8910Statics;
import de.malban.vide.vecx.devices.VectrexJoyport;
import de.malban.vide.vecx.libayemu.AY;
import de.malban.vide.vedi.sound.ibxm.IBXM;

public class E8910
extends E8910State
implements E8910Statics {
    int SAMPLE_THRESHOLD = 32;
    AY libayemu = new AY();
    VideConfig config = VideConfig.getConfig();
    transient int MAX_DIGIT_BUFFER = 60000;
    transient int[] digitByte = new int[this.MAX_DIGIT_BUFFER];
    transient int digitByteCounter = 0;
    transient VectrexJoyport[] joyport;
    transient Stream line = null;
    transient byte[] soundBytes = new byte[0];
    static int OVERSAMPLE = 4096;
    int maxpsg = -1;
    int reg14In = 255;
    int reg14Out = 255;
    boolean digit4Bit = false;
    static int SAMPLERATE = 44100;
    static int UPDATE_PER_SECOND = 40;

    public void reset() {
        this.joyport = null;
        this.envWritten = false;
    }

    public void setVectrexJoyport(VectrexJoyport[] j) {
        this.joyport = j;
        if (this.joyport == null) {
            return;
        }
        if (this.joyport[0] != null) {
            this.joyport[0].reset();
            this.joyport[0].setInputMode((this.snd_regs[7] & 0x40) == 0);
        }
        if (this.joyport[1] != null) {
            this.joyport[1].reset();
            this.joyport[1].setInputMode((this.snd_regs[7] & 0x40) == 0);
        }
    }

    private void readDataToPSGFromPortA() {
        int val = 0;
        if (this.joyport[0] != null) {
            if (this.joyport[0].isButton1(false)) {
                ++val;
            }
            if (this.joyport[0].isButton2(false)) {
                val += 2;
            }
            if (this.joyport[0].isButton3(false)) {
                val += 4;
            }
            if (this.joyport[0].isButton4(false)) {
                val += 8;
            }
        }
        if (this.joyport[1] != null) {
            if (this.joyport[1].isButton1(false)) {
                val += 16;
            }
            if (this.joyport[1].isButton2(false)) {
                val += 32;
            }
            if (this.joyport[1].isButton3(false)) {
                val += 64;
            }
            if (this.joyport[1].isButton4(false)) {
                val += 128;
            }
        }
        this.snd_regs[14] = val;
        this.reg14In = val;
    }

    private void writeDataFromPSGToPortA() {
        boolean b4;
        boolean b3;
        boolean b2;
        boolean b1;
        if (this.joyport == null) {
            return;
        }
        if (this.joyport[0] != null) {
            b1 = (this.reg14Out & 1) == 1;
            b2 = (this.reg14Out & 2) == 2;
            b3 = (this.reg14Out & 4) == 4;
            b4 = (this.reg14Out & 8) == 8;
            this.joyport[0].setButton1(b1, false);
            this.joyport[0].setButton2(b2, false);
            this.joyport[0].setButton3(b3, false);
            this.joyport[0].setButton4(b4, false);
        }
        if (this.joyport[1] != null) {
            b1 = (this.reg14Out & 0x10) == 16;
            b2 = (this.reg14Out & 0x20) == 32;
            b3 = (this.reg14Out & 0x40) == 64;
            b4 = (this.reg14Out & 0x80) == 128;
            this.joyport[1].setButton1(b1, false);
            this.joyport[1].setButton2(b2, false);
            this.joyport[1].setButton3(b3, false);
            this.joyport[1].setButton4(b4, false);
        }
    }

    public int read(int reg) {
        if (reg != 14) {
            return this.snd_regs[reg];
        }
        this.readDataToPSGFromPortA();
        if ((this.snd_regs[7] & 0x40) == 0) {
            return this.reg14In;
        }
        return this.reg14In;
    }

    public void e8910_write(int r, int v) {
        if (this.snd_regs == null) {
            return;
        }
        if (r == 14) {
            if ((this.snd_regs[7] & 0x40) == 64) {
                this.reg14Out = v;
                this.writeDataFromPSGToPortA();
            } else {
                this.reg14Out = v;
                this.writeDataFromPSGToPortA();
            }
            return;
        }
        if ((this.snd_regs[7] & 0x3F) == 63) {
            if (r == 8 || r == 9 || r == 10) {
                if (v <= 15) {
                    if (this.digit4Bit) {
                        if (this.digitByteCounter >= this.MAX_DIGIT_BUFFER) {
                            return;
                        }
                        if (this.digitByteCounter == -1) {
                            this.digitByteCounter = 0;
                        }
                        int sampleByte = v << 4;
                        this.digitByte[this.digitByteCounter++] = sampleByte -= 128;
                        return;
                    }
                    this.digit4Bit = true;
                    this.digitByteCounter = 0;
                } else {
                    this.digit4Bit = false;
                }
            } else {
                this.digit4Bit = false;
            }
        } else {
            this.digit4Bit = false;
        }
        if (r != 255 && this.digitByteCounter != 0) {
            this.digitByteCounter = 0;
        }
        if (r == 255) {
            if (this.digitByteCounter >= this.MAX_DIGIT_BUFFER) {
                return;
            }
            if (this.digitByteCounter == -1) {
                this.digitByteCounter = 0;
            }
            this.digitByte[this.digitByteCounter++] = v;
            return;
        }
        int oldReg = this.snd_regs[r];
        if (r < 15 && oldReg != v) {
            this.updateSound();
        }
        this.snd_regs[r] = v;
        switch (r) {
            case 0: 
            case 1: {
                this.snd_regs[1] = this.snd_regs[1] & 0xF;
                int old = this.PSG.PeriodA;
                this.PSG.PeriodA = (this.snd_regs[0] + 256 * this.snd_regs[1]) * this.STEP3;
                if (this.PSG.PeriodA == 0) {
                    this.PSG.PeriodA = this.STEP3;
                }
                this.PSG.CountA += this.PSG.PeriodA - old;
                if (this.PSG.CountA > 0) break;
                this.PSG.CountA = 1;
                break;
            }
            case 2: 
            case 3: {
                this.snd_regs[3] = this.snd_regs[3] & 0xF;
                int old = this.PSG.PeriodB;
                this.PSG.PeriodB = (this.snd_regs[2] + 256 * this.snd_regs[3]) * this.STEP3;
                if (this.PSG.PeriodB == 0) {
                    this.PSG.PeriodB = this.STEP3;
                }
                this.PSG.CountB += this.PSG.PeriodB - old;
                if (this.PSG.CountB > 0) break;
                this.PSG.CountB = 1;
                break;
            }
            case 4: 
            case 5: {
                this.snd_regs[5] = this.snd_regs[5] & 0xF;
                int old = this.PSG.PeriodC;
                this.PSG.PeriodC = (this.snd_regs[4] + 256 * this.snd_regs[5]) * this.STEP3;
                if (this.PSG.PeriodC == 0) {
                    this.PSG.PeriodC = this.STEP3;
                }
                this.PSG.CountC += this.PSG.PeriodC - old;
                if (this.PSG.CountC > 0) break;
                this.PSG.CountC = 1;
                break;
            }
            case 6: {
                this.snd_regs[6] = this.snd_regs[6] & 0x1F;
                int old = this.PSG.PeriodN;
                this.PSG.PeriodN = this.snd_regs[6] * this.STEP3;
                if (this.PSG.PeriodN == 0) {
                    this.PSG.PeriodN = this.STEP3;
                }
                this.PSG.CountN += this.PSG.PeriodN - old;
                if (this.PSG.CountN > 0) break;
                this.PSG.CountN = 1;
                break;
            }
            case 8: {
                this.snd_regs[8] = this.snd_regs[8] & 0x1F;
                this.PSG.EnvelopeA = this.snd_regs[8] & 0x10;
                this.PSG.VolA = this.PSG.EnvelopeA != 0 ? this.PSG.VolE : this.VolTable[this.snd_regs[8] != 0 ? this.snd_regs[8] * 2 : 0];
                break;
            }
            case 9: {
                this.snd_regs[9] = this.snd_regs[9] & 0x1F;
                this.PSG.EnvelopeB = this.snd_regs[9] & 0x10;
                this.PSG.VolB = this.PSG.EnvelopeB != 0 ? this.PSG.VolE : this.VolTable[this.snd_regs[9] != 0 ? this.snd_regs[9] * 2 : 0];
                break;
            }
            case 10: {
                this.snd_regs[10] = this.snd_regs[10] & 0x1F;
                this.PSG.EnvelopeC = this.snd_regs[10] & 0x10;
                this.PSG.VolC = this.PSG.EnvelopeC != 0 ? this.PSG.VolE : this.VolTable[this.snd_regs[10] != 0 ? this.snd_regs[10] * 2 : 0];
                break;
            }
            case 11: 
            case 12: {
                int old = this.PSG.PeriodE;
                this.PSG.PeriodE = (this.snd_regs[11] + 256 * this.snd_regs[12]) * this.STEP3;
                if (this.PSG.PeriodE == 0) {
                    this.PSG.PeriodE = this.STEP3 / 2;
                }
                if (this.PSG.PeriodE == 0) {
                    this.PSG.PeriodE = 1;
                }
                this.PSG.CountE += this.PSG.PeriodE - old;
                if (this.PSG.CountE > 0) break;
                this.PSG.CountE = 1;
                break;
            }
            case 13: {
                this.envWritten = true;
                this.snd_regs[13] = this.snd_regs[13] & 0xF;
                this.PSG.CountEnv = 31;
                this.PSG.CountE = this.PSG.PeriodE;
                this.PSG.Continue = 0;
                int n = this.PSG.Attack = (this.snd_regs[13] & 4) != 0 ? 31 : 0;
                if ((this.snd_regs[13] & 8) == 0) {
                    this.PSG.Hold = 1;
                    this.PSG.Alternate = this.PSG.Attack;
                } else {
                    this.PSG.Hold = this.snd_regs[13] & 1;
                    this.PSG.Alternate = this.snd_regs[13] & 2;
                }
                this.PSG.VolE = this.VolTable[this.PSG.CountEnv ^ this.PSG.Attack];
                if (this.PSG.EnvelopeA != 0) {
                    this.PSG.VolA = this.PSG.VolE;
                }
                if (this.PSG.EnvelopeB != 0) {
                    this.PSG.VolB = this.PSG.VolE;
                }
                if (this.PSG.EnvelopeC == 0) break;
                this.PSG.VolC = this.PSG.VolE;
                break;
            }
            case 7: {
                if ((oldReg & 0x40) == (this.snd_regs[7] & 0x40)) break;
                if (this.joyport != null) {
                    if (this.joyport[0] != null) {
                        this.joyport[0].setInputMode((this.snd_regs[7] & 0x40) == 0);
                    }
                    if (this.joyport[1] != null) {
                        this.joyport[1].setInputMode((this.snd_regs[7] & 0x40) == 0);
                    }
                }
                if ((this.snd_regs[7] & 0x40) == 0) {
                    this.readDataToPSGFromPortA();
                    break;
                }
                this.writeDataFromPSGToPortA();
                break;
            }
            case 14: {
                break;
            }
        }
    }

    private void e8910_callback_8(byte[] stream, int length) {
        int memPointer = 0;
        int lengthOrg = length;
        if (this.PSG.ready == 0) {
            for (int i = 0; i < length; ++i) {
                stream[i] = 0;
            }
            return;
        }
        if ((this.snd_regs[7] & 1) != 0) {
            if (this.PSG.CountA <= length) {
                this.PSG.CountA += length;
            }
            this.PSG.OutputA = 1;
        } else if (this.snd_regs[8] == 0 && this.PSG.CountA <= length) {
            this.PSG.CountA += length;
        }
        if ((this.snd_regs[7] & 2) != 0) {
            if (this.PSG.CountB <= length) {
                this.PSG.CountB += length;
            }
            this.PSG.OutputB = 1;
        } else if (this.snd_regs[9] == 0 && this.PSG.CountB <= length) {
            this.PSG.CountB += length;
        }
        if ((this.snd_regs[7] & 4) != 0) {
            if (this.PSG.CountC <= length) {
                this.PSG.CountC += length;
            }
            this.PSG.OutputC = 1;
        } else if (this.snd_regs[10] == 0 && this.PSG.CountC <= length) {
            this.PSG.CountC += length;
        }
        if ((this.snd_regs[7] & 0x38) == 56 && this.PSG.CountN <= length) {
            this.PSG.CountN += length;
        }
        int outn = this.PSG.OutputN | this.snd_regs[7];
        while (length > 0) {
            int nextevent;
            int left = 2;
            int volc = 0;
            int volb = 0;
            int vola = 0;
            do {
                nextevent = this.PSG.CountN < left ? this.PSG.CountN : left;
                if ((outn & 8) != 0) {
                    if (this.PSG.OutputA != 0) {
                        vola += this.PSG.CountA;
                    }
                    this.PSG.CountA -= nextevent;
                    while (this.PSG.CountA <= 0) {
                        this.PSG.CountA += this.PSG.PeriodA;
                        if (this.PSG.CountA > 0) {
                            this.PSG.OutputA ^= 1;
                            if (this.PSG.OutputA == 0) break;
                            vola += this.PSG.PeriodA;
                            break;
                        }
                        this.PSG.CountA += this.PSG.PeriodA;
                        vola += this.PSG.PeriodA;
                    }
                    if (this.PSG.OutputA != 0) {
                        vola -= this.PSG.CountA;
                    }
                } else {
                    this.PSG.CountA -= nextevent;
                    while (this.PSG.CountA <= 0) {
                        this.PSG.CountA += this.PSG.PeriodA;
                        if (this.PSG.CountA > 0) {
                            this.PSG.OutputA ^= 1;
                            break;
                        }
                        this.PSG.CountA += this.PSG.PeriodA;
                    }
                }
                if ((outn & 0x10) != 0) {
                    if (this.PSG.OutputB != 0) {
                        volb += this.PSG.CountB;
                    }
                    this.PSG.CountB -= nextevent;
                    while (this.PSG.CountB <= 0) {
                        this.PSG.CountB += this.PSG.PeriodB;
                        if (this.PSG.CountB > 0) {
                            this.PSG.OutputB ^= 1;
                            if (this.PSG.OutputB == 0) break;
                            volb += this.PSG.PeriodB;
                            break;
                        }
                        this.PSG.CountB += this.PSG.PeriodB;
                        volb += this.PSG.PeriodB;
                    }
                    if (this.PSG.OutputB != 0) {
                        volb -= this.PSG.CountB;
                    }
                } else {
                    this.PSG.CountB -= nextevent;
                    while (this.PSG.CountB <= 0) {
                        this.PSG.CountB += this.PSG.PeriodB;
                        if (this.PSG.CountB > 0) {
                            this.PSG.OutputB ^= 1;
                            break;
                        }
                        this.PSG.CountB += this.PSG.PeriodB;
                    }
                }
                if ((outn & 0x20) != 0) {
                    if (this.PSG.OutputC != 0) {
                        volc += this.PSG.CountC;
                    }
                    this.PSG.CountC -= nextevent;
                    while (this.PSG.CountC <= 0) {
                        this.PSG.CountC += this.PSG.PeriodC;
                        if (this.PSG.CountC > 0) {
                            this.PSG.OutputC ^= 1;
                            if (this.PSG.OutputC == 0) break;
                            volc += this.PSG.PeriodC;
                            break;
                        }
                        this.PSG.CountC += this.PSG.PeriodC;
                        volc += this.PSG.PeriodC;
                    }
                    if (this.PSG.OutputC != 0) {
                        volc -= this.PSG.CountC;
                    }
                } else {
                    this.PSG.CountC -= nextevent;
                    while (this.PSG.CountC <= 0) {
                        this.PSG.CountC += this.PSG.PeriodC;
                        if (this.PSG.CountC > 0) {
                            this.PSG.OutputC ^= 1;
                            break;
                        }
                        this.PSG.CountC += this.PSG.PeriodC;
                    }
                }
                this.PSG.CountN -= nextevent;
                if (this.PSG.CountN > 0) continue;
                if ((this.PSG.RNG + 1 & 2) != 0) {
                    this.PSG.OutputN ^= 0xFFFFFFFF;
                    outn = this.PSG.OutputN | this.snd_regs[7];
                }
                if ((this.PSG.RNG & 1) != 0) {
                    this.PSG.RNG ^= 0x24000;
                }
                this.PSG.RNG >>= 1;
                this.PSG.CountN += this.PSG.PeriodN;
            } while ((left -= nextevent) > 0);
            if (this.PSG.Continue == 0) {
                this.PSG.CountE -= this.STEP;
                if (this.PSG.CountE <= 0) {
                    do {
                        --this.PSG.CountEnv;
                        this.PSG.CountE += this.PSG.PeriodE;
                    } while (this.PSG.CountE <= 0);
                    if (this.PSG.CountEnv < 0) {
                        if (this.PSG.Hold != 0) {
                            if (this.PSG.Alternate != 0) {
                                this.PSG.Attack ^= 0x1F;
                            }
                            this.PSG.Continue = 1;
                            this.PSG.CountEnv = 0;
                        } else {
                            if (this.PSG.Alternate != 0 && (this.PSG.CountEnv & 0x20) != 0) {
                                this.PSG.Attack ^= 0x1F;
                            }
                            this.PSG.CountEnv &= 0x1F;
                        }
                    }
                    this.PSG.VolE = this.VolTable[this.PSG.CountEnv ^ this.PSG.Attack];
                    if (this.PSG.EnvelopeA != 0) {
                        this.PSG.VolA = this.PSG.VolE;
                    }
                    if (this.PSG.EnvelopeB != 0) {
                        this.PSG.VolB = this.PSG.VolE;
                    }
                    if (this.PSG.EnvelopeC != 0) {
                        this.PSG.VolC = this.PSG.VolE;
                    }
                }
            }
            int enableA = 0;
            int enableB = 0;
            int enableC = 0;
            if ((this.snd_regs[7] & 1) == 0 || (this.snd_regs[7] & 8) == 0) {
                enableA = 1;
            }
            if ((this.snd_regs[7] & 2) == 0 || (this.snd_regs[7] & 0x10) == 0) {
                enableB = 1;
            }
            if ((this.snd_regs[7] & 4) == 0 || (this.snd_regs[7] & 0x20) == 0) {
                enableC = 1;
            }
            int vol = (vola * enableA * this.PSG.VolA + volb * enableB * this.PSG.VolB + volc * enableC * this.PSG.VolC) / (3 * this.STEP);
            if (--length == 0) continue;
            int vol8BitSigned = vol >> 5 & 0xFF;
            if (this.config.psgSound) {
                stream[memPointer++] = (byte)vol8BitSigned;
                continue;
            }
            stream[memPointer++] = 0;
        }
        if (this.digitByteCounter > this.SAMPLE_THRESHOLD) {
            double sampleScale = (double)this.digitByteCounter / (double)lengthOrg;
            int i = 0;
            double sampleCounter = 0.0;
            double volDigital = 1.0;
            if (this.config.generation == 3) {
                volDigital = 0.2;
            }
            while (i < lengthOrg) {
                double signed8BitSampleVolumne = (double)this.digitByte[(int)sampleCounter] * volDigital;
                byte sampleValueVolumne8BitSigned = (byte)((byte)signed8BitSampleVolumne & 0xFF);
                sampleCounter += sampleScale;
                stream[i] = sampleValueVolumne8BitSigned;
                ++i;
            }
        }
        this.digitByteCounter = -1;
    }

    public void e8910_callback(byte[] stream, int length) {
        if (!this.is16Bit) {
            this.e8910_callback_8(stream, length);
        } else {
            this.e8910_callback_16(stream, length / 2);
        }
    }

    public void e8910_init_sound() {
        this.envWritten = false;
        this.libayemu.Init();
        this.PSG.RNG = 1;
        this.PSG.OutputA = 0;
        this.PSG.OutputB = 0;
        this.PSG.OutputC = 0;
        this.PSG.OutputN = 255;
        this.PSG.ready = 1;
        this.PSG.PeriodA = 1;
        this.PSG.PeriodB = 1;
        this.PSG.PeriodC = 1;
        this.PSG.PeriodE = 1;
        this.PSG.PeriodN = 1;
        this.STEP3 = this.is16Bit ? OVERSAMPLE * 44100 / 187500 : 1;
        this.VolTable = new int[32];
        double out = this.MAX_OUTPUT;
        for (int i = 31; i > 0; --i) {
            this.VolTable[i] = (int)(out + 0.5);
            out /= 1.188502227;
        }
        this.VolTable[0] = 0;
        this.MAX_OUTPUT = this.is16Bit ? Short.MAX_VALUE : 4095;
        this.e8910_done_sound();
        if (TinySound.isInitialized()) {
            this.soundBytes = new byte[this.getSoundBufferSize()];
            this.line = this.getVectrexLine();
            this.line.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSound() {
        if (this.line == null) {
            return;
        }
        Stream stream = this.line;
        synchronized (stream) {
            double v = (double)this.config.psgVolume / 255.0;
            this.line.setVolume(v);
            int soundLength = this.line.available();
            int bufLength = this.soundBytes.length;
            int n = soundLength = soundLength > bufLength ? bufLength : soundLength;
            if (soundLength > 0) {
                this.e8910_callback(this.soundBytes, soundLength);
                this.line.write(this.soundBytes, 0, soundLength);
            }
        }
    }

    public void e8910_done_sound() {
        if (this.line != null) {
            this.line.unload();
        }
        this.line = null;
    }

    public int getSoundBufferSize() {
        if (!this.is16Bit) {
            int SOUNDBUFFER_SIZE = 3528;
            return SOUNDBUFFER_SIZE;
        }
        int SOUNDBUFFER_SIZE = IBXM.IBXM_MAXBUFFER;
        int size = SAMPLERATE / UPDATE_PER_SECOND + 2;
        return size * 4;
    }

    public Stream getVectrexLine() {
        if (!this.is16Bit) {
            return TinySound.getOutStreamVectrex();
        }
        return TinySound.getOutStream();
    }

    private void e8910_callback_16(byte[] stream, int length) {
        int lengthOrg = length;
        int positionInOutputArray = 0;
        if (this.digitByteCounter < this.SAMPLE_THRESHOLD) {
            if (this.config.useLibAYEmu) {
                this.libayemu.SetRegs(this.snd_regs);
                this.libayemu.GenSound(stream, length, 0);
                return;
            }
            int maxSampleLength = length * OVERSAMPLE;
            int sampleDivider = 3 * OVERSAMPLE;
            int volaEnableMul = 1;
            int volbEnableMul = 1;
            int volcEnableMul = 1;
            if (sampleDivider == 0) {
                sampleDivider = 1;
            }
            if ((this.snd_regs[0] | this.snd_regs[1]) == 0 && (this.snd_regs[8] & 0x10) == 0 && (this.snd_regs[7] & 9) == 8) {
                volaEnableMul = 0;
            }
            if ((this.snd_regs[2] | this.snd_regs[3]) == 0 && (this.snd_regs[9] & 0x10) == 0 && (this.snd_regs[7] & 0x12) == 16) {
                volbEnableMul = 0;
            }
            if ((this.snd_regs[4] | this.snd_regs[5]) == 0 && (this.snd_regs[10] & 0x10) == 0 && (this.snd_regs[7] & 0x24) == 32) {
                volcEnableMul = 0;
            }
            int volaPSG = this.PSG.VolA * volaEnableMul;
            int volbPSG = this.PSG.VolB * volbEnableMul;
            int volcPSG = this.PSG.VolC * volcEnableMul;
            if ((this.snd_regs[7] & 1) != 0) {
                if (this.PSG.CountA <= maxSampleLength) {
                    this.PSG.CountA += maxSampleLength;
                }
                this.PSG.OutputA = 1;
            } else if (this.snd_regs[8] == 0 && this.PSG.CountA <= maxSampleLength) {
                this.PSG.CountA += maxSampleLength;
            }
            if ((this.snd_regs[7] & 2) != 0) {
                if (this.PSG.CountB <= maxSampleLength) {
                    this.PSG.CountB += maxSampleLength;
                }
                this.PSG.OutputB = 1;
            } else if (this.snd_regs[9] == 0 && this.PSG.CountB <= maxSampleLength) {
                this.PSG.CountB += maxSampleLength;
            }
            if ((this.snd_regs[7] & 4) != 0) {
                if (this.PSG.CountC <= maxSampleLength) {
                    this.PSG.CountC += maxSampleLength;
                }
                this.PSG.OutputC = 1;
            } else if (this.snd_regs[10] == 0 && this.PSG.CountC <= maxSampleLength) {
                this.PSG.CountC += maxSampleLength;
            }
            if ((this.snd_regs[7] & 0x38) == 56 && this.PSG.CountN <= maxSampleLength) {
                this.PSG.CountN += maxSampleLength;
            }
            int outn = this.PSG.OutputN | this.snd_regs[7];
            while (length > 0) {
                int nextEvent;
                int volASamples = 0;
                int volBSamples = 0;
                int volCSamples = 0;
                int left = OVERSAMPLE;
                do {
                    int n = nextEvent = this.PSG.CountN < left ? this.PSG.CountN : left;
                    if ((outn & 8) != 0) {
                        if (this.PSG.OutputA != 0) {
                            volASamples += this.PSG.CountA;
                        }
                        this.PSG.CountA -= nextEvent;
                        while (this.PSG.CountA <= 0) {
                            this.PSG.CountA += this.PSG.PeriodA;
                            if (this.PSG.CountA > 0) {
                                this.PSG.OutputA ^= 1;
                                if (this.PSG.OutputA == 0) break;
                                volASamples += this.PSG.PeriodA;
                                break;
                            }
                            this.PSG.CountA += this.PSG.PeriodA;
                            volASamples += this.PSG.PeriodA;
                        }
                        if (this.PSG.OutputA != 0) {
                            volASamples -= this.PSG.CountA;
                        }
                    } else {
                        this.PSG.CountA -= nextEvent;
                        while (this.PSG.CountA <= 0) {
                            this.PSG.CountA += this.PSG.PeriodA;
                            if (this.PSG.CountA > 0) {
                                this.PSG.OutputA ^= 1;
                                break;
                            }
                            this.PSG.CountA += this.PSG.PeriodA;
                        }
                    }
                    if ((outn & 0x10) != 0) {
                        if (this.PSG.OutputB != 0) {
                            volBSamples += this.PSG.CountB;
                        }
                        this.PSG.CountB -= nextEvent;
                        while (this.PSG.CountB <= 0) {
                            this.PSG.CountB += this.PSG.PeriodB;
                            if (this.PSG.CountB > 0) {
                                this.PSG.OutputB ^= 1;
                                if (this.PSG.OutputB == 0) break;
                                volBSamples += this.PSG.PeriodB;
                                break;
                            }
                            this.PSG.CountB += this.PSG.PeriodB;
                            volBSamples += this.PSG.PeriodB;
                        }
                        if (this.PSG.OutputB != 0) {
                            volBSamples -= this.PSG.CountB;
                        }
                    } else {
                        this.PSG.CountB -= nextEvent;
                        while (this.PSG.CountB <= 0) {
                            this.PSG.CountB += this.PSG.PeriodB;
                            if (this.PSG.CountB > 0) {
                                this.PSG.OutputB ^= 1;
                                break;
                            }
                            this.PSG.CountB += this.PSG.PeriodB;
                        }
                    }
                    if ((outn & 0x20) != 0) {
                        if (this.PSG.OutputC != 0) {
                            volCSamples += this.PSG.CountC;
                        }
                        this.PSG.CountC -= nextEvent;
                        while (this.PSG.CountC <= 0) {
                            this.PSG.CountC += this.PSG.PeriodC;
                            if (this.PSG.CountC > 0) {
                                this.PSG.OutputC ^= 1;
                                if (this.PSG.OutputC == 0) break;
                                volCSamples += this.PSG.PeriodC;
                                break;
                            }
                            this.PSG.CountC += this.PSG.PeriodC;
                            volCSamples += this.PSG.PeriodC;
                        }
                        if (this.PSG.OutputC != 0) {
                            volCSamples -= this.PSG.CountC;
                        }
                    } else {
                        this.PSG.CountC -= nextEvent;
                        while (this.PSG.CountC <= 0) {
                            this.PSG.CountC += this.PSG.PeriodC;
                            if (this.PSG.CountC > 0) {
                                this.PSG.OutputC ^= 1;
                                break;
                            }
                            this.PSG.CountC += this.PSG.PeriodC;
                        }
                    }
                    this.PSG.CountN -= nextEvent;
                    if (this.PSG.CountN > 0) continue;
                    if ((this.PSG.RNG + 1 & 2) != 0) {
                        this.PSG.OutputN ^= 0xFFFFFFFF;
                        outn = this.PSG.OutputN | this.snd_regs[7];
                    }
                    if ((this.PSG.RNG & 1) != 0) {
                        this.PSG.RNG ^= 0x24000;
                    }
                    this.PSG.RNG >>= 1;
                    this.PSG.CountN += this.PSG.PeriodN;
                } while ((left -= nextEvent) > 0);
                if (this.PSG.Continue == 0) {
                    this.PSG.CountE -= OVERSAMPLE;
                    if (this.PSG.CountE <= 0) {
                        do {
                            --this.PSG.CountEnv;
                            this.PSG.CountE += this.PSG.PeriodE;
                        } while (this.PSG.CountE <= 0);
                        if (this.PSG.CountEnv < 0) {
                            if (this.PSG.Hold != 0) {
                                if (this.PSG.Alternate != 0) {
                                    this.PSG.Attack ^= 0x1F;
                                }
                                this.PSG.Continue = 1;
                                this.PSG.CountEnv = 0;
                            } else {
                                if (this.PSG.Alternate != 0 && (this.PSG.CountEnv & 0x20) != 0) {
                                    this.PSG.Attack ^= 0x1F;
                                }
                                this.PSG.CountEnv &= 0x1F;
                            }
                        }
                        this.PSG.VolE = this.VolTable[this.PSG.CountEnv ^ this.PSG.Attack];
                        if (this.PSG.EnvelopeA != 0) {
                            this.PSG.VolA = this.PSG.VolE;
                            volaPSG = this.PSG.VolE * volaEnableMul;
                        }
                        if (this.PSG.EnvelopeB != 0) {
                            this.PSG.VolB = this.PSG.VolE;
                            volbPSG = this.PSG.VolE * volbEnableMul;
                        }
                        if (this.PSG.EnvelopeC != 0) {
                            this.PSG.VolC = this.PSG.VolE;
                            volcPSG = this.PSG.VolE * volcEnableMul;
                        }
                    }
                }
                int oneSample16Bit = (volASamples * volaPSG + volBSamples * volbPSG + volCSamples * volcPSG) / sampleDivider;
                if (this.config.psgSound) {
                    stream[positionInOutputArray++] = (byte)(oneSample16Bit & 0xFF);
                    stream[positionInOutputArray++] = (byte)(oneSample16Bit >> 8 & 0xFF);
                } else {
                    stream[positionInOutputArray++] = 0;
                    stream[positionInOutputArray++] = 0;
                }
                --length;
            }
        } else if (this.digitByteCounter > this.SAMPLE_THRESHOLD) {
            double sampleScale = (double)this.digitByteCounter / (double)lengthOrg;
            int i = 0;
            double sampleCounter = 0.0;
            double volDigital = 1.0;
            if (this.config.generation == 3) {
                volDigital = 0.2;
            }
            while (i < lengthOrg * 2) {
                double signed8BitSampleVolumne = this.digitByte[(int)sampleCounter];
                sampleCounter += sampleScale;
                int oneSample16Bit = (int)signed8BitSampleVolumne * 256;
                oneSample16Bit = (int)((double)oneSample16Bit * volDigital);
                stream[i++] = (byte)(oneSample16Bit & 0xFF);
                stream[i++] = (byte)(oneSample16Bit >> 8 & 0xFF);
            }
        }
        this.digitByteCounter = -1;
    }
}

