/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx;

import de.malban.sound.tinysound.Stream;
import de.malban.sound.tinysound.TinySound;
import de.malban.vide.vecx.VecX;
import resid.ISIDDefs;
import resid.SID;

public class VSID {
    public static final int MOS6581 = 0;
    public static final int MOS8580 = 1;
    int SID_ADDRESS = 32768;
    static final int SAMPLE_RATE = 44100;
    static int UPDATE_PER_SECOND = 40;
    int BUFFER_SIZE = 256;
    byte[] buffer = new byte[(44100 / UPDATE_PER_SECOND + 2) * 4];
    SID sid;
    int SIDFRQ = 985248;
    int VECFREQ = 1500000;
    int clocksPerSample = this.VECFREQ / 44100;
    int clocksPerSampleRest = 0;
    long nextSample = 0L;
    long lastCycles = 0L;
    private int nextRest = 0;
    private int pos = 0;
    transient Stream line = null;
    VecX vecx;
    int lastsl = 0;

    public VSID(VecX v) {
        this.vecx = v;
        this.line = TinySound.getOutStream();
        this.sid = new SID();
        this.lastCycles = this.vecx.getCycles();
        this.nextSample = this.vecx.getCycles() + 5L;
        this.sid.set_sampling_parameters(this.SIDFRQ, ISIDDefs.sampling_method.SAMPLE_RESAMPLE_INTERPOLATE, 44100.0, -1.0, 0.97);
        this.clocksPerSampleRest = (int)((long)this.VECFREQ * 1000L / 44100L);
        this.clocksPerSampleRest -= this.clocksPerSample * 1000;
        this.line.start();
    }

    public void clock(long cycles) {
        if (this.nextSample == 0L) {
            return;
        }
        if (this.nextSample <= cycles) {
            double sidfactor;
            double sidCycles;
            this.nextSample += (long)(this.clocksPerSample - 1);
            this.nextRest += this.clocksPerSampleRest;
            if (this.nextRest > 1000) {
                this.nextRest -= 1000;
                ++this.nextSample;
            }
            if ((sidCycles = (double)cycles * (sidfactor = 1.0 / ((double)this.VECFREQ / (double)this.SIDFRQ))) - (double)this.lastCycles > 5000.0) {
                this.lastCycles = (long)sidCycles - 100L;
            }
            while (this.lastCycles < (long)sidCycles) {
                this.sid.clock();
                ++this.lastCycles;
            }
            int sample = this.sid.output();
            if (this.pos < this.buffer.length) {
                this.buffer[this.pos++] = (byte)(sample & 0xFF);
                this.buffer[this.pos++] = (byte)(sample >> 8);
            }
            if (this.pos == this.buffer.length) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSamples() {
        if (this.line == null) {
            return;
        }
        Stream stream = this.line;
        synchronized (stream) {
            double v = 1.0;
            this.line.setVolume(v);
            int soundLength = this.line.available();
            int bufLength = this.pos;
            if (this.lastsl != soundLength) {
                System.out.println("" + soundLength + "/" + this.pos);
                this.lastsl = soundLength;
            }
            soundLength = soundLength > bufLength ? bufLength : soundLength;
            int n = soundLength = soundLength > this.pos ? this.pos : soundLength;
            if (soundLength > 0) {
                this.line.write(this.buffer, 0, soundLength);
            }
        }
        this.pos = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSamples() {
        if (this.line == null) {
            return;
        }
        Stream stream = this.line;
        synchronized (stream) {
            double v = 1.0;
            this.line.setVolume(v);
            int soundLength = this.line.available();
            int bufLength = this.buffer.length;
            int n = soundLength = soundLength > bufLength ? bufLength : soundLength;
            if (this.lastsl != soundLength) {
                System.out.println("" + soundLength);
                this.lastsl = soundLength;
            }
            if (soundLength > 0) {
                this.line.write(this.buffer, 0, soundLength);
            }
        }
        this.pos = 0;
    }

    public int performRead(int address, long cycles) {
        return this.sid.read(address - this.SID_ADDRESS);
    }

    public void performWrite(int address, int data2, long cycles) {
        this.sid.write(address - this.SID_ADDRESS, data2);
    }

    public void reset() {
        this.nextSample = this.vecx.getCycles() + 10L;
        this.lastCycles = this.vecx.getCycles();
        this.sid.reset();
    }

    public void stop() {
        this.nextSample = 0L;
    }

    public void setChipVersion(int version2) {
        if (version2 == 0) {
            this.sid.set_chip_model(ISIDDefs.chip_model.MOS6581);
        } else {
            this.sid.set_chip_model(ISIDDefs.chip_model.MOS8580);
        }
    }
}

