/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.dialogs.ShowWarningDialog;
import de.malban.gui.panels.LogPanel;
import de.malban.util.Utility;
import de.malban.util.UtilityFiles;
import de.malban.vide.VideConfig;
import de.malban.vide.dissy.DASMStatics;
import de.malban.vide.dissy.DissiPanel;
import de.malban.vide.dissy.MemoryInformation;
import de.malban.vide.veccy.VectorListScanner;
import de.malban.vide.vecx.Breakpoint;
import de.malban.vide.vecx.CodeScanMemory;
import de.malban.vide.vecx.CompleteState;
import de.malban.vide.vecx.DisplayerDummy;
import de.malban.vide.vecx.DisplayerInterface;
import de.malban.vide.vecx.E6809;
import de.malban.vide.vecx.E6809Access;
import de.malban.vide.vecx.E6809State;
import de.malban.vide.vecx.E8910;
import de.malban.vide.vecx.E8910State;
import de.malban.vide.vecx.Profiler;
import de.malban.vide.vecx.ValuePointer;
import de.malban.vide.vecx.VecXState;
import de.malban.vide.vecx.VecXStatics;
import de.malban.vide.vecx.cartridge.Cartridge;
import de.malban.vide.vecx.cartridge.CartridgeListener;
import de.malban.vide.vecx.cartridge.CartridgeProperties;
import de.malban.vide.vecx.cartridge.CartridgePropertiesPanel;
import de.malban.vide.vecx.cartridge.VSID;
import de.malban.vide.vecx.devices.Imager3dDevice;
import de.malban.vide.vecx.devices.VectrexJoyport;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;

public class VecX
extends VecXState
implements VecXStatics,
E6809Access {
    public static final int START_TYPE_DEBUG = 1;
    public static final int START_TYPE_RUN = 2;
    public static final int START_TYPE_INJECT = 3;
    public static final int START_TYPE_STOP = 4;
    static double[] dacDeviation = new double[256];
    transient Profiler profiler = null;
    public VideConfig config = VideConfig.getConfig();
    private LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    public ArrayList<Breakpoint>[] breakpoints = new ArrayList[Breakpoint.BP_TARGET_COUNT];
    public ArrayList<Breakpoint> activeBreakpoint = new ArrayList();
    public int breakpointExit = 1;
    boolean rampOffFraction = true;
    boolean rampOnFraction = true;
    boolean alternate = false;
    transient CodeScanMemory dissiMem = CodeScanMemory.getCodeScanMemory();
    public static int OVERFLOW_BORDER_RAYWIDTH;
    public static int OVERFLOW_SAMPLE_MAX;
    transient E8910 e8910 = null;
    transient E6809 e6809 = null;
    transient int[] rom = new int[8192];
    static transient int SS_RING_BUFFER_SIZE;
    transient int ringSSWalkStep = 0;
    transient int ringSSBufferNext = 0;
    public transient CompleteState[] goSSBackRingBuffer = new CompleteState[SS_RING_BUFFER_SIZE];
    static transient int FRAME_RING_BUFFER_SIZE;
    transient int ringFrameWalkStep = 0;
    transient int ringFrameBufferNext = 0;
    public transient CompleteState[] goFrameBackRingBuffer = new CompleteState[FRAME_RING_BUFFER_SIZE];
    static transient int WAIT_RECAL_BUFFER_SIZE;
    transient int waitRecalBufferNext = 0;
    transient boolean waitRecalActive = true;
    transient int testBank = 0;
    transient int testAddressFirst = 61858;
    transient int testAddressSecond = 61842;
    transient long lastTestTicks = 0L;
    transient int[] waitRecalBuffer = new int[WAIT_RECAL_BUFFER_SIZE];
    transient boolean directDrawActive = false;
    public transient VectrexJoyport[] joyport = new VectrexJoyport[2];
    public transient DisplayerInterface displayer = new DisplayerDummy();
    transient VectrexDisplayVectors[] vectorDisplay = new VectrexDisplayVectors[2];
    transient int displayedNext = 0;
    transient int displayedNow = 1;
    transient int[] vector_hash = new int[65521];
    transient long fcycles;
    transient long trackyCount = 0L;
    transient long trackyAbove = 0L;
    ArrayList<VecXState.TimerItem> timerHeap = new ArrayList();
    int pb6_pulseCounter = 0;
    long lastAddLine = 0L;
    double intensityDriftNow = 1.0;
    boolean toManyvectors = false;
    int nonCPUStepsDone = 0;
    ArrayList<Breakpoint> tmp = new ArrayList();
    boolean syncImpulse = false;
    long lastSyncCycles = 0L;
    long soundCycles = 0L;
    static int UID_;
    static int uid;
    volatile boolean debugging = false;
    boolean stop = false;
    long cyclesDone = 0L;
    boolean thisWaitRecal = false;
    long lastWaitRecal = 0L;
    long lastRecordCycle = 0L;
    int firq;
    public boolean recording = false;
    int recordingType = 0;
    boolean recordingIsAddress = true;
    int recordingAddress = 0;
    String recordingFilename = "";
    ArrayList<byte[]> recordData;
    static final int WR_UNKOWN = 0;
    static final int WR_FIRST_FOUND = 1;
    int wrStatus = 0;
    public transient int allTimeLow = 65536;
    ArrayList<VecXState.TimerItem> timerRemoveList = new ArrayList();
    ArrayList<VecXState.TimerItem> timerItemListClone = new ArrayList();
    long noiseCycles = 0L;
    int lcount = 0;
    boolean peerOutputEnabled = false;
    boolean wasSync = false;
    double hzStep = 6.666666666666667E-7;
    double hzStepHalf = 3.3333333333333335E-7;
    PrintWriter pw = null;
    double pureDriftXStart = 0.0;
    double pureDriftYStart = 0.0;
    double pureDriftX = 0.0;
    double pureDriftY = 0.0;
    boolean noLineChange = false;
    int startAdjustX = 0;
    int startAdjustY = 0;
    int x0Old = 0;
    int y0Old = 0;
    int x1Old = 0;
    int y1Old = 0;
    boolean retainChanged = false;
    double oldzeroRetainX = 0.0;
    double oldzeroRetainY = 0.0;
    int wayToZero = 1000;
    boolean startZero = false;
    transient int[] ramAccess = new int[1024];

    public static void initDACDeviations() {
        Random rand = new Random();
        VideConfig c = VideConfig.getConfig();
        double bit0Deviation = rand.nextDouble() * (double)(c.DACTolerance * 2) - (double)c.DACTolerance;
        double bit1Deviation = rand.nextDouble() * (double)(c.DACTolerance * 2) - (double)c.DACTolerance;
        double bit2Deviation = rand.nextDouble() * (double)(c.DACTolerance * 2) - (double)c.DACTolerance;
        double bit3Deviation = rand.nextDouble() * (double)(c.DACTolerance * 2) - (double)c.DACTolerance;
        double bit4Deviation = rand.nextDouble() * (double)(c.DACTolerance * 2) - (double)c.DACTolerance;
        double bit5Deviation = rand.nextDouble() * (double)(c.DACTolerance * 2) - (double)c.DACTolerance;
        double bit6Deviation = rand.nextDouble() * (double)(c.DACTolerance * 2) - (double)c.DACTolerance;
        double bit7Deviation = rand.nextDouble() * (double)(c.DACTolerance * 2) - (double)c.DACTolerance;
        bit0Deviation /= 256.0;
        bit1Deviation /= 128.0;
        bit2Deviation /= 64.0;
        bit3Deviation /= 32.0;
        bit4Deviation /= 16.0;
        bit5Deviation /= 8.0;
        bit6Deviation /= 4.0;
        bit7Deviation /= 2.0;
        for (int i = -128; i < 128; ++i) {
            double oneValueDeviation = 0.0;
            byte bits = (byte)(i & 0xFF);
            if ((bits & 1) == 1) {
                oneValueDeviation += bit0Deviation;
            }
            if ((bits & 2) == 2) {
                oneValueDeviation += bit1Deviation;
            }
            if ((bits & 4) == 4) {
                oneValueDeviation += bit2Deviation;
            }
            if ((bits & 8) == 8) {
                oneValueDeviation += bit3Deviation;
            }
            if ((bits & 0x10) == 16) {
                oneValueDeviation += bit4Deviation;
            }
            if ((bits & 0x20) == 32) {
                oneValueDeviation += bit5Deviation;
            }
            if ((bits & 0x40) == 64) {
                oneValueDeviation += bit6Deviation;
            }
            if ((bits & 0x80) == 128) {
                oneValueDeviation += bit7Deviation;
            }
            double d = rand.nextDouble() * (double)(c.DACTolerance * 2) - (double)c.DACTolerance;
            VecX.dacDeviation[i + 128] = oneValueDeviation = 1.0 + (oneValueDeviation / 10000.0 + d / 10000.0) / 2.0;
        }
    }

    public static void initDACDeviations3() {
        Random rand = new Random();
        VideConfig c = VideConfig.getConfig();
        double bit0Deviation = rand.nextDouble() * (double)(c.DACTolerance * 2) - (double)c.DACTolerance;
        double bit1Deviation = rand.nextDouble() * (double)(c.DACTolerance * 2) - (double)c.DACTolerance;
        double bit2Deviation = rand.nextDouble() * (double)(c.DACTolerance * 2) - (double)c.DACTolerance;
        double bit3Deviation = rand.nextDouble() * (double)(c.DACTolerance * 2) - (double)c.DACTolerance;
        double bit4Deviation = rand.nextDouble() * (double)(c.DACTolerance * 2) - (double)c.DACTolerance;
        double bit5Deviation = rand.nextDouble() * (double)(c.DACTolerance * 2) - (double)c.DACTolerance;
        double bit6Deviation = rand.nextDouble() * (double)(c.DACTolerance * 2) - (double)c.DACTolerance;
        double bit7Deviation = rand.nextDouble() * (double)(c.DACTolerance * 2) - (double)c.DACTolerance;
        bit0Deviation /= 8.0;
        bit1Deviation /= 8.0;
        bit2Deviation /= 8.0;
        bit3Deviation /= 8.0;
        bit4Deviation /= 8.0;
        bit5Deviation /= 8.0;
        bit6Deviation /= 8.0;
        bit7Deviation /= 8.0;
        for (int i = -128; i < 128; ++i) {
            double oneValueDeviation = 0.0;
            byte bits = (byte)(i & 0xFF);
            if ((bits & 1) == 1) {
                oneValueDeviation += bit0Deviation;
            }
            if ((bits & 2) == 2) {
                oneValueDeviation += bit1Deviation;
            }
            if ((bits & 4) == 4) {
                oneValueDeviation += bit2Deviation;
            }
            if ((bits & 8) == 8) {
                oneValueDeviation += bit3Deviation;
            }
            if ((bits & 0x10) == 16) {
                oneValueDeviation += bit4Deviation;
            }
            if ((bits & 0x20) == 32) {
                oneValueDeviation += bit5Deviation;
            }
            if ((bits & 0x40) == 64) {
                oneValueDeviation += bit6Deviation;
            }
            if ((bits & 0x80) == 128) {
                oneValueDeviation += bit7Deviation;
            }
            VecX.dacDeviation[i + 128] = oneValueDeviation = 1.0 + oneValueDeviation / 10000.0;
        }
    }

    public static void initDACDeviations2() {
        int i;
        VideConfig c = VideConfig.getConfig();
        Random rand = new Random();
        for (i = -128; i < 128; ++i) {
            VecX.dacDeviation[i + 128] = rand.nextDouble() * (double)(c.DACTolerance * 2) - (double)c.DACTolerance;
        }
        VecX.dacDeviation[192] = c.DACTolerance * 4 / 5;
        VecX.dacDeviation[64] = -(c.DACTolerance * 4) / 5;
        for (i = 0; i < 256; ++i) {
            VecX.dacDeviation[i] = 1.0 + dacDeviation[i] / 10000.0;
        }
    }

    public void setAllBreakpoints(ArrayList<Breakpoint>[] ab) {
        for (ArrayList<Breakpoint> blist : ab) {
            for (Breakpoint b : blist) {
                this.addBreakpoint(b);
            }
        }
    }

    ArrayList<Breakpoint>[] getAllBreakpoints() {
        return this.breakpoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void timerAddItem(int when, int value, ValuePointer destination, int t) {
        VecXState.TimerItem titem;
        if (this.timerHeap.size() == 0) {
            titem = new VecXState.TimerItem(when, value, destination, t);
        } else {
            titem = this.timerHeap.remove(0);
            titem.countDown = when;
            titem.valueToSet = value;
            titem.whereToSet = destination;
            titem.type = t;
        }
        ArrayList arrayList = this.timerItemList;
        synchronized (arrayList) {
            this.timerItemList.add(titem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void timerAddItem(int value, ValuePointer destination, int t) {
        VecXState.TimerItem titem;
        if (this.timerHeap.size() == 0) {
            titem = new VecXState.TimerItem(value, destination, t);
        } else {
            titem = this.timerHeap.remove(0);
            titem.valueToSet = value;
            titem.whereToSet = destination;
            titem.type = t;
            titem.countDown = VideConfig.getConfig().delays[t & 0xFF];
        }
        ArrayList arrayList = this.timerItemList;
        synchronized (arrayList) {
            this.timerItemList.add(titem);
        }
    }

    public VecX() {
        this.vectorDisplay[0] = new VectrexDisplayVectors();
        this.vectorDisplay[1] = new VectrexDisplayVectors();
        this.joyport[0] = new VectrexJoyport(0, this);
        this.joyport[1] = new VectrexJoyport(1, this);
        this.e6809 = new E6809();
        this.e6809.vecx = this;
        this.e8910 = new E8910();
        this.e8910.setVectrexJoyport(this.joyport);
        this.e8910.e8910_init_sound();
        for (int i = 0; i < Breakpoint.BP_TARGET_COUNT; ++i) {
            this.breakpoints[i] = new ArrayList();
        }
    }

    void deinit() {
        if (this.e8910 != null) {
            this.e8910.e8910_done_sound();
        }
        this.joyport[0].deinit();
        this.joyport[1].deinit();
        this.displayer = new DisplayerDummy();
    }

    public void setDisplayer(DisplayerInterface d) {
        this.displayer = d;
        this.displayer.setLED(0);
    }

    public void setPB6FromExternal(boolean b) {
        boolean changed;
        boolean bl = changed = (this.pb6_in & 0x40) == 64 != b;
        if (this.config.breakpointsActive && changed) {
            this.checkExternalLineBreakpoint(b);
        }
        this.pb6_in = b ? 64 : 0;
    }

    void snd_update(boolean command) {
        switch (this.via_orb & 0x18) {
            case 0: {
                break;
            }
            case 8: {
                if (!command) break;
                this.via_ora = this.e8910.read(this.snd_select);
                break;
            }
            case 16: {
                if (!command) break;
                this.e8910.e8910_write(this.snd_select, this.via_ora);
                break;
            }
            case 24: {
                if ((this.via_ora & 0xF0) != 0) break;
                this.snd_select = this.via_ora & 0xF;
            }
        }
        if ((this.via_orb & 7) == 6) {
            this.e8910.e8910_write(255, this.alg_ssh.intValue);
        }
        if (this.config.breakpointsActive) {
            this.checkPSGBreakpoint();
        }
    }

    void int_update() {
        this.via_ifr = (this.via_ifr & 0x7F & (this.via_ier & 0x7F)) != 0 ? (this.via_ifr |= 0x80) : (this.via_ifr &= 0x7F);
        if (this.cart != null) {
            this.cart.setIRQFromVectrex((this.via_ifr & 0x80) != 0);
        }
    }

    @Override
    public int e6809_readOnly8(int address) {
        int data2 = 0;
        if ((address & 0xE000) == 57344) {
            data2 = this.rom[address & 0x1FFF];
        } else if ((address & 0xE000) == 49152) {
            if ((address & 0x800) != 0) {
                data2 = this.ram[address & 0x3FF];
            } else if ((address & 0x1000) != 0) {
                switch (address & 0xF) {
                    case 0: {
                        data2 = (this.via_acr & 0x80) != 0 ? this.via_orb & 0x5F | this.alg_compare | this.via_t1pb7 : this.via_orb & 0xDF | this.alg_compare;
                        if ((this.via_ddrb & 0x40) == 0) {
                            data2 &= 0xBF;
                            data2 |= this.pb6_in;
                            break;
                        }
                        if (!this.config.isFaultyVIA) break;
                        data2 |= 0x40;
                        break;
                    }
                    case 1: 
                    case 15: {
                        if ((this.via_orb & 0x18) == 8) {
                            data2 = this.e8910.read(this.snd_select);
                            break;
                        }
                        data2 = this.via_ora;
                        break;
                    }
                    case 2: {
                        data2 = this.via_ddrb;
                        break;
                    }
                    case 3: {
                        data2 = this.via_ddra;
                        break;
                    }
                    case 4: {
                        data2 = this.via_t1c;
                        break;
                    }
                    case 5: {
                        data2 = this.via_t1c >> 8;
                        break;
                    }
                    case 6: {
                        data2 = this.via_t1ll;
                        break;
                    }
                    case 7: {
                        data2 = this.via_t1lh;
                        break;
                    }
                    case 8: {
                        data2 = this.via_t2c & 0xFF;
                        break;
                    }
                    case 9: {
                        data2 = this.via_t2c >> 8;
                        break;
                    }
                    case 10: {
                        data2 = this.via_sr;
                        break;
                    }
                    case 11: {
                        data2 = this.via_acr;
                        break;
                    }
                    case 12: {
                        data2 = this.via_pcr;
                        break;
                    }
                    case 13: {
                        data2 = this.via_ifr;
                        break;
                    }
                    case 14: {
                        data2 = this.via_ier | 0x80;
                    }
                }
            }
        } else if (this.cart != null) {
            return this.cart.readByte(address) & 0xFF;
        }
        return data2 & 0xFF;
    }

    @Override
    public int e6809_read8(int address) {
        int data2 = 0;
        if (this.config.debugingCore) {
            if (this.config.codeScanActive) {
                this.dissiMem.mem[address].addAccess(this.e6809.reg_pc, this.e6809.reg_dp, 2);
            }
            this.checkMemReadBreakpoint(address);
        }
        if ((address & 0xE000) == 57344) {
            return this.rom[address & 0x1FFF] & 0xFF;
        }
        if ((address & 0xE000) == 49152) {
            if ((address & 0x800) != 0) {
                if (this.ramAccess[address & 0x3FF] == 0 && this.e6809.clear == 0) {
                    this.log.addLog("RAM ACCESS to uninitialized location: " + String.format("$%04X", address) + " from: " + String.format("$%04X", this.e6809.reg_pc));
                }
                return this.ram[address & 0x3FF] & 0xFF;
            }
            if ((address & 0x1000) != 0) {
                switch (address & 0xF) {
                    case 0: {
                        if (this.config.DACCompareDelayEmulation) {
                            this.doCheckJoystick();
                        }
                        data2 = (this.via_acr & 0x80) != 0 ? this.via_orb & 0x5F | this.alg_compare | this.via_t1pb7 : this.via_orb & 0xDF | this.alg_compare;
                        if ((this.via_ddrb & 0x40) == 0) {
                            data2 &= 0xBF;
                            data2 |= this.pb6_in;
                        } else if (this.config.isFaultyVIA) {
                            data2 |= 0x40;
                        }
                        return data2 & 0xFF;
                    }
                    case 1: {
                        if ((this.via_pcr & 0xE) == 8) {
                            this.via_ca2 = 0;
                            this.timerAddItem(this.via_ca2, this.sig_zero, 1);
                        }
                        this.via_ifr &= 0xFD;
                        if (this.cart != null) {
                            this.cart.setIRQFromVectrex((this.via_ifr & 0x80) != 0);
                        }
                    }
                    case 15: {
                        if ((this.via_orb & 0x18) == 8) {
                            return this.e8910.read(this.snd_select);
                        }
                        return this.via_ora & 0xFF;
                    }
                    case 2: {
                        return this.via_ddrb & 0xFF;
                    }
                    case 3: {
                        return this.via_ddra;
                    }
                    case 4: {
                        data2 = this.via_t1c;
                        this.via_ifr &= 0xBF;
                        this.via_t1int = 1;
                        this.int_update();
                        return data2 & 0xFF;
                    }
                    case 5: {
                        return this.via_t1c >> 8 & 0xFF;
                    }
                    case 6: {
                        return this.via_t1ll & 0xFF;
                    }
                    case 7: {
                        return this.via_t1lh & 0xFF;
                    }
                    case 8: {
                        data2 = this.via_t2c;
                        this.via_ifr &= 0xDF;
                        this.via_t2int = 1;
                        this.int_update();
                        return data2 & 0xFF;
                    }
                    case 9: {
                        return this.via_t2c >> 8 & 0xFF;
                    }
                    case 10: {
                        this.timerAddItem(this.via_sr, null, 2061);
                        return this.via_sr & 0xFF;
                    }
                    case 11: {
                        return this.via_acr & 0xFF;
                    }
                    case 12: {
                        return this.via_pcr & 0xFF;
                    }
                    case 13: {
                        return this.via_ifr & 0xFF;
                    }
                    case 14: {
                        return (this.via_ier | 0x80) & 0xFF;
                    }
                }
            } else if (this.cart != null) {
                return this.cart.readByte(address) & 0xFF;
            }
        } else if (this.cart != null) {
            return this.cart.readByte(address) & 0xFF;
        }
        return 255;
    }

    @Override
    public void e6809_write8(int address, int data2) {
        if (this.config.debugingCore) {
            if (this.config.codeScanActive) {
                this.dissiMem.mem[address].addAccess(this.e6809.reg_pc, this.e6809.reg_dp, 4);
            }
            this.checkMemWriteBreakpoint(address, data2);
        }
        data2 &= 0xFF;
        if ((address & 0xE000) == 57344) {
            this.log.addLog("ROM write attempted! to: " + String.format("$%04X", address), LogPanel.ERROR);
        } else if ((address & 0xE000) == 49152) {
            if ((address & 0x800) != 0) {
                this.ram[address & 0x3FF] = data2;
                this.ramAccess[address & 0x3FF] = 1;
            }
            if ((address & 0x1000) != 0) {
                switch (address & 0xF) {
                    case 0: {
                        if (this.config.breakpointsActive) {
                            this.checkVIABreakpoint(0, this.via_orb, data2);
                        }
                        boolean pb6 = this.setPB6FromVectrex(data2, this.via_ddrb, true);
                        if ((data2 & 7) != (this.via_orb & 7)) {
                            this.timerAddItem(data2, this.alg_sel, 12);
                        }
                        this.via_orb = data2;
                        this.snd_update(true);
                        if ((this.via_pcr & 0xE0) == 128) {
                            this.via_cb2h = 0;
                            this.timerAddItem(this.via_cb2h, this.sig_blank, 2);
                        }
                        this.doCheckRamp(true);
                        break;
                    }
                    case 1: {
                        if ((this.via_pcr & 0xE) == 8) {
                            this.via_ca2 = 0;
                            this.timerAddItem(this.via_ca2, this.sig_zero, 1);
                        }
                        this.via_ifr &= 0xFD;
                        if (this.cart != null) {
                            this.cart.setIRQFromVectrex((this.via_ifr & 0x80) != 0);
                        }
                        this.lastORAWriteCycle = this.cyclesRunning;
                    }
                    case 15: {
                        this.alg_oldDAC = this.alg_DAC.intValue;
                        this.alg_DAC.intValue = data2;
                        this.via_ora = data2;
                        this.timerAddItem(this.alg_DAC.intValue, this.alg_xsh, 9);
                        this.doCheckMultiplexer();
                        this.snd_update(false);
                        break;
                    }
                    case 2: {
                        this.setPB6FromVectrex(this.via_orb, data2, false);
                        this.via_ddrb = data2;
                        break;
                    }
                    case 3: {
                        this.via_ddra = data2;
                        break;
                    }
                    case 4: {
                        this.via_t1ll = data2;
                        break;
                    }
                    case 5: {
                        this.timerAddItem(data2, null, 14);
                        break;
                    }
                    case 6: {
                        this.via_t1ll = data2;
                        break;
                    }
                    case 7: {
                        this.via_t1lh = data2;
                        break;
                    }
                    case 8: {
                        this.via_t2ll = data2;
                        if (!this.config.breakpointsActive) break;
                        this.checkVIABreakpoint(8, -1, data2);
                        break;
                    }
                    case 9: {
                        this.timerAddItem(data2, null, 15);
                        if (!this.config.breakpointsActive) break;
                        this.checkVIABreakpoint(9, -1, data2);
                        break;
                    }
                    case 10: {
                        this.timerAddItem(data2, this.via_shift, 1037);
                        break;
                    }
                    case 11: {
                        if ((this.via_acr & 0x1C) != (data2 & 0x1C) && (data2 & 0x1C) != 0) {
                            this.timerAddItem(0, this.sig_blank, 2);
                        }
                        if ((this.via_acr & 0xC0) != (data2 & 0xC0)) {
                            this.via_acr = data2;
                            this.doCheckRamp((this.via_acr & 0x80) != 128);
                        }
                        this.via_acr = data2;
                        break;
                    }
                    case 12: {
                        this.via_pcr = data2;
                        if ((this.via_pcr & 0xE) == 12) {
                            this.via_ca2 = 0;
                            this.timerAddItem(this.via_ca2, this.sig_zero, 1);
                        } else {
                            this.via_ca2 = 1;
                            this.timerAddItem(this.via_ca2, this.sig_zero, 1);
                        }
                        if ((this.via_acr & 0x1C) != 0) break;
                        if ((this.via_pcr & 0xE0) == 192) {
                            this.via_cb2h = 0;
                            this.via_cb2hmanual = 0;
                            this.timerAddItem(this.via_cb2h, this.sig_blank, 2);
                            break;
                        }
                        if ((this.via_pcr & 0xE0) == 224) {
                            this.via_cb2h = 1;
                            this.via_cb2hmanual = 1;
                            this.timerAddItem(this.via_cb2h, this.sig_blank, 3);
                            break;
                        }
                        this.via_cb2h = 1;
                        this.timerAddItem(this.via_cb2h, this.sig_blank, 3);
                        break;
                    }
                    case 13: {
                        this.via_ifr &= ~(data2 & 0x7F);
                        this.int_update();
                        break;
                    }
                    case 14: {
                        this.via_ier = (data2 & 0x80) != 0 ? (this.via_ier |= data2 & 0x7F) : (this.via_ier &= ~(data2 & 0x7F));
                        this.int_update();
                    }
                }
            }
            if ((address & 0x1000) == 0 && (address & 0x800) == 0) {
                this.cart.write(address, (byte)data2);
            }
            return;
        }
        this.cart.write(address, (byte)data2);
    }

    void vecx_reset() {
        this.vecx_reset(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void vecx_reset(boolean hardReset) {
        int r;
        if (this.displayer != null) {
            this.displayer.setLED(0);
        }
        if (hardReset) {
            for (r = 0; r < 1024; ++r) {
                this.ram[r] = r & 0xFF;
            }
        }
        this.e8910.reset();
        this.e8910.setVectrexJoyport(this.joyport);
        for (r = 0; r < 16; ++r) {
            this.e8910.e8910_write(r, 0);
        }
        this.snd_select = 0;
        this.lastShiftTriggered = 0L;
        this.via_stalling = false;
        this.via_ora = 0;
        this.via_orb = 0;
        this.pb6_in = 64;
        this.pb6_out = 64;
        this.via_ddra = 0;
        this.via_ddrb = 0;
        this.via_t1on = 0;
        this.via_t1int = 0;
        this.via_t1c = 0;
        this.via_t1ll = 0;
        this.via_t1lh = 0;
        this.via_t1pb7 = 128;
        this.via_t2on = 0;
        this.via_t2int = 0;
        this.via_t2c = 0;
        this.via_t2ll = 0;
        this.via_sr = 0;
        this.via_srb = 8;
        this.via_src = 0;
        this.via_srclk = 0;
        this.via_acr = 0;
        this.via_pcr = 0;
        this.via_ifr = 0;
        this.via_ier = 0;
        this.via_ca1 = 1;
        this.old_via_ca1 = 1;
        this.via_ca2 = 1;
        this.via_cb2h = 1;
        this.via_cb2s = 0;
        this.old_pb6 = false;
        this.intensityDrift = 0L;
        this.c_alg_rsh.setDigitalVoltage(128);
        this.alg_xsh.intValue = 128;
        this.alg_ysh.intValue = 128;
        this.alg_zsh.intValue = 0;
        this.alg_ssh.intValue = 0;
        this.alg_jsh = 128;
        this.alg_compare = 0;
        this.sig_zero.intValue = 1;
        this.sig_ramp.intValue = 0;
        this.sig_blank.intValue = 0;
        this.alg_curr_x = this.config.ALG_MAX_X / 2;
        this.alg_curr_y = this.config.ALG_MAX_Y / 2;
        this.lastORAWriteCycle = 0L;
        this.alg_oldDAC = 0;
        this.alg_DAC.intValue = 0;
        this.alg_vectoring = 0;
        this.alg_vector_x0 = 0;
        this.alg_vector_y0 = 0;
        this.alg_vector_x1 = 0;
        this.alg_vector_y1 = 0;
        this.alg_vector_dx = 0;
        this.alg_vector_dy = 0;
        this.alg_vector_color = 0;
        this.alg_vector_speed = 0;
        this.alg_ramping = false;
        this.alg_spline_compare_dx = Integer.MAX_VALUE;
        this.alg_spline_compare_dy = Integer.MAX_VALUE;
        this.ticksRunning = 0;
        this.vectorDisplay[0].count = 0;
        this.vectorDisplay[1].count = 0;
        this.fcycles = 50000L;
        this.cyclesRunning = 0L;
        if (hardReset && this.config.resetBreakpointsOnLoad) {
            this.clearAllBreakpoints();
        }
        ArrayList arrayList = this.timerItemList;
        synchronized (arrayList) {
            this.timerItemList.clear();
        }
        this.e6809.e6809_reset();
        this.dissiMem.reset();
        if (this.cart != null) {
            this.cart.reset();
        }
        this.resetBuffer();
    }

    public void initDissi(boolean forcedInit) {
        CSAMainFrame frame;
        DissiPanel dissi;
        if (this.config.doProfile && this.config.debugingCore && Configuration.getConfiguration().getMainFrame() instanceof CSAMainFrame && (dissi = (frame = Configuration.getConfiguration().getMainFrame()).checkDissi()) != null && (dissi.getProfiler() == null || forcedInit)) {
            String name = "main";
            if (this.cart != null) {
                name = this.cart.cartName;
            }
            this.e6809.profiler = this.profiler = Profiler.buildProfiler(this.e6809.reg_pc, name);
            dissi.setProfilingNames(this.profiler);
        }
    }

    private boolean setPB6FromVectrex(int tobe_via_orb, int tobe_via_ddrb, boolean orbInitiated) {
        boolean b = false;
        int npb6 = tobe_via_orb & tobe_via_ddrb & 0x40;
        if ((tobe_via_ddrb & 0x40) == 0) {
            npb6 |= 0x40;
        }
        b = npb6 != 0;
        this.pb6_out = npb6;
        this.cart.setPB6FromVectrex(b);
        if (this.config.breakpointsActive) {
            this.checkExternalLineBreakpoint(b);
        }
        return b;
    }

    private boolean setPB6FromVectrex_old(int tobe_via_orb, int tobe_via_ddrb, boolean orbInitiated) {
        boolean pb6;
        if (this.via_orb == tobe_via_orb && this.via_ddrb == tobe_via_ddrb) {
            return this.pb6_out != 0;
        }
        int viaOutNow = this.via_orb & 0xBF | this.pb6_out | ~this.via_ddrb & 0xFF;
        boolean bl = pb6 = this.pb6_out != 0;
        if (tobe_via_orb != viaOutNow || tobe_via_ddrb != this.via_ddrb) {
            int viaOutTobe = tobe_via_orb | ~tobe_via_ddrb & 0xFF;
            if (!orbInitiated) {
                viaOutTobe = (tobe_via_ddrb & 0x40) == 64 ? (viaOutTobe &= 0xBF) : (viaOutTobe |= 0x40);
            }
            pb6 = (viaOutTobe & 0x40) == 64;
            this.cart.setPB6FromVectrex(pb6);
            if (this.config.breakpointsActive) {
                this.checkExternalLineBreakpoint(pb6);
            }
            this.old_pb6 = pb6;
        }
        if (pb6) {
            this.pb6_out = 64;
            if (!this.cart.isDualVec() && !this.cart.isExtra8000Ram2k()) {
                if (orbInitiated && (this.via_ddrb & 0x40) == 64) {
                    this.pb6_in = this.pb6_out;
                }
                if (!orbInitiated && (tobe_via_ddrb & 0x40) == 64) {
                    this.pb6_in = this.pb6_out;
                }
                this.pb6_in = this.pb6_out;
            }
        } else {
            this.pb6_out = 0;
        }
        return pb6;
    }

    void via_sstep0() {
        boolean t2shift;
        if (this.via_t1on != 0) {
            --this.via_t1c;
            if ((this.via_t1c & 0xFFFF) == 65535) {
                if ((this.via_acr & 0x40) != 0) {
                    this.via_ifr |= 0x40;
                    this.int_update();
                    if (this.config.breakpointsActive && (this.via_acr & 0x80) != 0) {
                        if (this.via_t1pb7 == 128) {
                            this.checkVIABreakpoint(0, this.via_orb, this.via_orb - 128);
                        } else {
                            this.checkVIABreakpoint(0, this.via_orb, this.via_orb + 128);
                        }
                    }
                    this.via_t1pb7 = 128 - this.via_t1pb7;
                    this.doCheckRamp(false);
                    this.via_t1c = this.via_t1lh << 8 & 0xFF00 | this.via_t1ll & 0xFF;
                } else {
                    if (this.via_t1pb7 != 128) {
                        this.via_t1pb7 = 128;
                        if (this.config.breakpointsActive && (this.via_acr & 0x80) != 0 && this.via_t1pb7 != 128) {
                            this.checkVIABreakpoint(0, this.via_orb, this.via_orb + 128);
                        }
                        this.doCheckRamp(false);
                    } else {
                        this.via_t1pb7 = 128;
                    }
                    if (this.via_t1int != 0) {
                        this.via_ifr |= 0x40;
                        this.int_update();
                        this.via_t1int = 0;
                    }
                }
            }
        }
        if (this.via_t2on != 0 && (this.via_acr & 0x20) == 0) {
            --this.via_t2c;
            if ((this.via_t2c & 0xFFFF) == 65535 && this.via_t2int != 0) {
                this.via_ifr |= 0x20;
                this.int_update();
                this.via_t2int = 0;
                this.syncImpulse = true;
            }
        }
        --this.via_src;
        if ((this.via_src & 0xFF) == 255) {
            this.via_src = this.via_t2ll;
            if (this.via_srclk == 3) {
                t2shift = true;
                this.via_srclk = 0;
            } else {
                t2shift = false;
                this.via_srclk = (this.via_srclk + 1) % 4;
            }
        } else {
            t2shift = false;
        }
        if (this.via_srb < 8) {
            switch (this.via_acr & 0x1C) {
                case 0: {
                    break;
                }
                case 4: {
                    if (!t2shift) break;
                    this.via_sr <<= 1;
                    ++this.via_srb;
                    break;
                }
                case 8: {
                    this.via_sr <<= 1;
                    ++this.via_srb;
                    break;
                }
                case 12: {
                    break;
                }
                case 16: {
                    if (!t2shift) break;
                    this.via_cb2s = this.via_sr >> 7 & 1;
                    this.via_sr <<= 1;
                    this.via_sr |= this.via_cb2s;
                    this.timerAddItem(this.via_cb2s, this.sig_blank, this.via_cb2s == 1 ? 3 : 2);
                    break;
                }
                case 20: {
                    if (!t2shift) break;
                    this.via_cb2s = this.via_sr >> 7 & 1;
                    this.via_sr <<= 1;
                    this.via_sr |= this.via_cb2s;
                    this.timerAddItem(this.via_cb2s, this.sig_blank, this.via_cb2s == 1 ? 3 : 2);
                    ++this.via_srb;
                    break;
                }
                case 24: {
                    boolean bl = this.alternate = !this.alternate;
                    if (!this.alternate) break;
                    this.via_cb2s = this.via_sr >> 7 & 1;
                    this.via_sr <<= 1;
                    this.via_sr |= this.via_cb2s;
                    this.timerAddItem(this.via_cb2s, this.sig_blank, this.via_cb2s == 1 ? 3 : 2);
                    ++this.via_srb;
                    break;
                }
            }
            if (this.via_srb == 8) {
                this.via_ifr |= 4;
                this.int_update();
                this.lastShift = this.via_cb2s;
            }
        } else if (this.config.viaShift9BugEnabled && (this.via_acr & 0x1C) == 24) {
            if (this.via_srb == 8) {
                boolean bl = this.alternate = !this.alternate;
                if (this.alternate) {
                    this.via_srb = 9;
                }
            }
            if (this.via_srb == 9) {
                this.via_cb2s = this.lastShift;
                this.timerAddItem(this.via_cb2s, this.sig_blank, this.via_cb2s == 1 ? 3 : 2);
                ++this.via_srb;
            }
        }
    }

    void via_sstep1() {
        if ((this.via_pcr & 0xE) == 10) {
            this.via_ca2 = 1;
            this.timerAddItem(this.via_ca2, this.sig_zero, 1);
        }
        if ((this.via_pcr & 0xE0) == 160) {
            this.via_cb2h = 1;
            this.timerAddItem(this.via_cb2h, this.sig_blank, this.via_cb2h == 1 ? 3 : 2);
        }
        if (this.via_ca1 != this.old_via_ca1) {
            if (this.config.breakpointsActive) {
                this.checkVIABreakpoint(16, this.old_via_ca1, this.via_ca1);
            }
            if ((this.via_pcr & 1) == 1) {
                if (this.via_ca1 != 0) {
                    this.via_ifr |= 2;
                    this.int_update();
                }
            } else if (this.via_ca1 == 0) {
                this.via_ifr |= 2;
                this.int_update();
            }
        }
        this.old_via_ca1 = this.via_ca1;
    }

    void alg_addline(int x0, int y0, int x1, int y1, int color, int speed, int left, int right) {
        this.alg_addline(x0, y0, x1, y1, color, false, speed, left, right);
    }

    void alg_addline(int x0, int y0, int x1, int y1, int color, boolean midChange, int speed, int left, int right) {
        ++this.lcount;
        double factor = 0.8 * ((double)(this.config.brightness + 100) / 100.0);
        if (factor > 1.0) {
            factor = 1.0;
        }
        int colorA = color;
        if (color < 96) {
            colorA = (int)((double)colorA * factor);
        }
        if (color < 88) {
            colorA = (int)((double)colorA * factor);
        }
        if (color < 80) {
            colorA = (int)((double)colorA * factor);
        }
        if (color < 72) {
            colorA = (int)((double)colorA * factor);
        }
        if (color < 64) {
            colorA = (int)((double)colorA * factor);
        }
        if (color < 56) {
            colorA = (int)((double)colorA * factor);
        }
        if (color < 48) {
            colorA = (int)((double)colorA * factor);
        }
        if (color < 40) {
            colorA = (int)((double)colorA * factor);
        }
        if (color < 32) {
            colorA = (int)((double)colorA * factor);
        }
        if (color < 24) {
            colorA = (int)((double)colorA * factor);
        }
        if (color < 16) {
            colorA = (int)((double)colorA * factor);
        }
        color = colorA;
        if (!this.noLineChange) {
            this.alg_curr_x = (int)this.alg_curr_x;
            this.alg_curr_y = (int)this.alg_curr_y;
        }
        if (this.config.useRayGun) {
            return;
        }
        if (this.config.enableWobble) {
            int sinOffsetX = 0;
            int sinOffsetY = 0;
            float currentSinPos = this.cyclesRunning % (long)this.config.cycle_sin_freq;
            double currentSinPosMathX = (double)(currentSinPos / (float)this.config.cycle_sin_freq * 2.0f) * Math.PI;
            double currentSinPosMathY = (double)((currentSinPos + (float)this.config.yOffsetToX) % (float)this.config.cycle_sin_freq / (float)this.config.cycle_sin_freq * 2.0f) * Math.PI;
            sinOffsetX = (int)((double)this.config.MAX_SIN_POSITION_OFFSET * Math.sin(currentSinPosMathX));
            sinOffsetY = (int)((double)this.config.MAX_SIN_POSITION_OFFSET * Math.sin(currentSinPosMathY));
            sinOffsetX = (int)((double)this.config.MAX_SIN_POSITION_OFFSET * Math.sin(currentSinPosMathX) * Math.cos(this.config.constantC * currentSinPosMathX));
            sinOffsetY = (int)((double)this.config.MAX_SIN_POSITION_OFFSET * Math.sin(currentSinPosMathY) * Math.cos(this.config.constantC * currentSinPosMathY));
            x1 += sinOffsetX;
            y1 += sinOffsetY;
        }
        if (this.cyclesRunning - this.lastAddLine < 15L) {
            float driftXMax = 1.0f + (float)Math.abs((double)(this.cyclesRunning - this.lastAddLine) * this.config.drift_x);
            float driftYMax = 1.0f + (float)Math.abs((double)(this.cyclesRunning - this.lastAddLine) * this.config.drift_y);
            int xDif = Math.abs(x0 - x1);
            int yDif = Math.abs(y0 - y1);
            if ((float)xDif <= driftXMax && (float)yDif <= driftYMax) {
                this.lastAddLine = this.cyclesRunning;
                return;
            }
        }
        if (!this.noLineChange) {
            this.lastAddLine = this.cyclesRunning;
        }
        if (!(!this.imagerMode || left != -1 && left != 0 || right != -1 && right != 0)) {
            return;
        }
        if (this.vectorDisplay[this.displayedNext].count >= this.vectorDisplay[this.displayedNext].vectrexVectors.length) {
            if (!this.toManyvectors) {
                this.log.addLog("To many vectors - can't draw!", LogPanel.ERROR);
            }
            this.toManyvectors = true;
            return;
        }
        this.toManyvectors = false;
        VecXState.vector_t v = this.vectorDisplay[this.displayedNext].vectrexVectors[this.vectorDisplay[this.displayedNext].count];
        v.speed = speed;
        v.x0 = x0;
        v.y0 = y0;
        v.x1 = x1;
        v.y1 = y1;
        v.midChange = midChange;
        v.color = color;
        v.imagerColorLeft = left;
        v.imagerColorRight = right;
        this.intensityDriftNow = 1.0;
        v.intensityDrift = 1.0;
        if (!this.noLineChange && this.intensityDrift > 100000L) {
            double degradePercent = (1.8E8 - (double)this.intensityDrift) / 1.8E8;
            if (degradePercent < 0.0) {
                degradePercent = 0.0;
            }
            v.color = (int)((double)color * degradePercent);
            v.intensityDrift = this.intensityDriftNow = degradePercent;
        }
        if (this.config.vectorInformationCollectionActive) {
            if (v.callStack == null) {
                v.callStack = new ArrayList();
            } else {
                v.callStack.clear();
            }
            Iterator iterator = this.e6809.callStack.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                v.callStack.add(i);
            }
            v.callStack.add(this.e6809.reg_pc);
        }
        if (this.directDrawActive && this.vectorDisplay[this.displayedNow].count < 50000) {
            this.directDrawVector = this.vectorDisplay[this.displayedNow].vectrexVectors[this.vectorDisplay[this.displayedNow].count];
            ++this.vectorDisplay[this.displayedNow].count;
            this.directDrawVector.x0 = x0;
            this.directDrawVector.y0 = y0;
            this.directDrawVector.x1 = x1;
            this.directDrawVector.y1 = y1;
            this.directDrawVector.speed = speed;
            this.directDrawVector.midChange = midChange;
            this.directDrawVector.color = 127;
            this.directDrawVector.imagerColorLeft = left;
            this.directDrawVector.imagerColorRight = right;
            this.displayer.directDraw(this.directDrawVector);
        }
        ++this.vectorDisplay[this.displayedNext].count;
    }

    public double getBeamPosX() {
        return this.alg_curr_x;
    }

    public double getBeamPosY() {
        return this.alg_curr_y;
    }

    public void setCyclesRunning(long n) {
        this.cyclesRunning = n;
        if (this.cart != null) {
            this.cart.setCyclesRunning(n);
        }
    }

    public DisplayerInterface getDisplayer() {
        return this.displayer;
    }

    @Override
    public void vectrexNonCPUStepDontAdd(int cycles) {
        if (!this.config.cycleExactEmulation) {
            return;
        }
        for (int c = 0; c < cycles; ++c) {
            if (this.cart != null) {
                this.cart.cartStep(this.cyclesRunning);
            }
            this.via_sstep0();
            this.timerDoStep();
            this.analogStep();
            if (this.joyport[0] != null) {
                this.joyport[0].step();
            }
            if (this.joyport[1] != null) {
                this.joyport[1].step();
            }
            this.via_sstep1();
        }
    }

    @Override
    public void vectrexNonCPUStep(int cycles) {
        if (!this.config.cycleExactEmulation) {
            return;
        }
        for (int c = 0; c < cycles; ++c) {
            if (this.cart != null) {
                this.cart.cartStep(this.cyclesRunning);
            }
            this.via_sstep0();
            this.timerDoStep();
            this.analogStep();
            if (this.joyport[0] != null) {
                this.joyport[0].step();
            }
            if (this.joyport[1] != null) {
                this.joyport[1].step();
            }
            this.via_sstep1();
            ++this.nonCPUStepsDone;
            ++this.cyclesRunning;
            if (!this.peerOutputEnabled) continue;
            this.doPeerOutput();
        }
    }

    public synchronized void doPeerOutput() {
        double t1 = (double)this.cyclesRunning * this.hzStep;
        double t2 = (double)this.cyclesRunning * this.hzStep + this.hzStepHalf;
        StringBuffer b = new StringBuffer();
        int portA = this.e6809_readOnly8(53249);
        b.append(String.format("%02X", portA & 0xFF));
        int portB = this.e6809_readOnly8(53248);
        portB &= 7;
        if (this.sig_ramp.intValue != 0) {
            portB += 16;
        }
        if (this.sig_blank.intValue != 0) {
            portB += 32;
        }
        if (this.sig_zero.intValue != 0) {
            portB += 64;
        }
        if (this.wasSync) {
            portB += 128;
        }
        b.append(String.format("%02X", portB & 0xFF));
        this.wasSync = false;
        if (this.pw != null) {
            try {
                this.pw.print("" + b.toString() + "\n");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    synchronized void doPeerSync() {
        this.wasSync = true;
    }

    public synchronized void setPeerOutputEnabled(boolean z) {
        this.peerOutputEnabled = z;
        if (!this.peerOutputEnabled) {
            this.pw.close();
            this.pw = null;
        } else if (this.pw == null) {
            try {
                FileWriter fstream = new FileWriter(Global.mainPathPrefix + "logs" + File.separator + "peerOutput.csv", true);
                this.pw = new PrintWriter(fstream);
                this.pw.append("XXYY: X hex porta, YY hex bits szbr#10h h=S/H, 0=Sel0, 1=Sel1, #=unused , r=!RAMP, b=!BLANK, z=!ZERO, s = sync before these values\n");
            }
            catch (Throwable e) {
                e.printStackTrace();
                System.out.println("WriteFile could not be created!");
            }
        }
    }

    public long getCycles() {
        return this.cyclesRunning;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    void stopEmulation() {
        this.debugging = true;
        this.stop = true;
    }

    int vecx_emu(long cyclesOrg) {
        this.stop = false;
        long cycles = cyclesOrg;
        long cyclesStart = this.cyclesRunning;
        int reason = 1;
        this.breakpointExit = 1;
        this.activeBreakpoint.clear();
        this.debugging = cyclesOrg <= 1L;
        this.tmp.clear();
        if (this.ringSSWalkStep != -1) {
            this.ringSSBufferNext = (this.ringSSWalkStep + 1) % SS_RING_BUFFER_SIZE;
            this.ringSSWalkStep = -1;
        }
        if (this.ringFrameWalkStep != -1) {
            this.ringSSBufferNext = (this.ringFrameWalkStep + 1) % SS_RING_BUFFER_SIZE;
            this.ringFrameWalkStep = -1;
        }
        while (cycles > 0L && !this.stop) {
            this.nonCPUStepsDone = 0;
            int pc = this.e6809.reg_pc % 65536;
            if (pc == 61563 && this.e6809_readOnly8(62999) == 50) {
                this.loadOrgBios();
            }
            if (pc == 61858) {
                this.thisWaitRecal = true;
            }
            int oldAdr = this.e6809.reg_pc % 65536;
            int icycles = this.e6809.e6809_sstep(this.via_ifr & 0x80, this.firq);
            this.firq = 0;
            if (this.config.codeScanActive) {
                this.dissiMem.mem[oldAdr % 65536].addAccess(oldAdr, this.e6809.reg_dp, 1);
                int iLen = DASMStatics.getNumOpcodes((byte)this.e6809_readOnly8(oldAdr % 65536), (byte)this.e6809_readOnly8((oldAdr + 1) % 65536));
                for (int i = 0; i < iLen; ++i) {
                    this.dissiMem.mem[(oldAdr + 1 + i) % 65536].addAccess((oldAdr + 1 + i) % 65536, this.e6809.reg_dp, 8);
                }
            }
            if (this.config.doProfile && this.profiler != null) {
                this.profiler.accessed(oldAdr, icycles);
                this.profiler.checkContext(this);
            }
            for (int c = 0; c < icycles - this.nonCPUStepsDone; ++c) {
                if (this.cart != null) {
                    this.cart.cartStep(this.cyclesRunning);
                }
                this.via_sstep0();
                this.timerDoStep();
                this.analogStep();
                if (this.joyport[0] != null) {
                    this.joyport[0].step();
                }
                if (this.joyport[1] != null) {
                    this.joyport[1].step();
                }
                this.via_sstep1();
                ++this.cyclesRunning;
            }
            if (this.waitRecalActive) {
                this.checkWaitRecal();
            }
            cycles -= (long)icycles;
            this.fcycles -= (long)icycles;
            this.soundCycles -= (long)icycles;
            boolean doSync = false;
            if (this.config.autoSync) {
                if (this.imagerMode && (this.via_ier & 2) == 2) {
                    if ((this.via_ifr & 2) == 2 && (this.via_ier & 2) == 2 && !this.e6809.get_cc(16)) {
                        doSync = true;
                        this.lastSyncCycles = this.cyclesRunning;
                    }
                } else {
                    if (this.syncImpulse && this.cyclesRunning - this.lastSyncCycles < 20000L) {
                        this.lastSyncCycles = this.cyclesRunning;
                        this.syncImpulse = false;
                    }
                    if (this.syncImpulse) {
                        if (this.cyclesRunning - this.lastWaitRecal < 100000L) {
                            if (this.thisWaitRecal) {
                                this.lastSyncCycles = this.cyclesRunning;
                                doSync = true;
                            }
                        } else {
                            this.lastSyncCycles = this.cyclesRunning;
                            doSync = true;
                        }
                    } else if (this.fcycles < 0L) {
                        doSync = true;
                    }
                }
            } else if (this.fcycles < 0L) {
                doSync = true;
            }
            if (doSync) {
                this.lcount = 0;
                if (this.peerOutputEnabled) {
                    this.doPeerSync();
                }
                if (this.thisWaitRecal) {
                    this.thisWaitRecal = false;
                    this.lastWaitRecal = this.cyclesRunning;
                }
                this.syncImpulse = false;
                this.fcycles = 50000L;
                if (!this.config.useRayGun) {
                    this.displayedNext = (this.displayedNext + 1) % 2;
                    this.displayedNow = (this.displayedNow + 1) % 2;
                    this.displayer.updateDisplay();
                    this.vectorDisplay[this.displayedNext].count = 0;
                    this.vectorDisplay[this.displayedNext].resetBorders();
                } else {
                    this.displayer.switchDisplay();
                    this.displayer.updateDisplay();
                }
            }
            if (this.config.ringbufferActive) {
                this.addStateToRingbuffer();
            }
            this.checkCPUBreakpoints(icycles);
            this.checkAnalogBreakpoint();
            for (Breakpoint bp : this.tmp) {
                this.displayer.breakpointRemove(bp);
            }
            if (this.activeBreakpoint.size() != 0) {
                this.debugging = true;
                this.cyclesDone = this.cyclesRunning - cyclesStart;
                return this.breakpointExit;
            }
            if (this.soundCycles <= 0L) {
                this.soundCycles = 37500L;
                if (cyclesOrg > 1L) {
                    this.e8910.updateSound();
                    if (this.cart != null && this.cart.isSIDEnabled()) {
                        this.cart.updateSound();
                    }
                }
            }
            if (this.config.scanForVectorLists) {
                VectorListScanner.check(this.e6809, this.cart, this);
            }
            if (!this.recording) continue;
            if (this.recordingIsAddress) {
                if (this.e6809.reg_pc != this.recordingAddress) continue;
                this.addSoundRecord();
                continue;
            }
            if (this.cyclesRunning - this.lastRecordCycle < (long)this.recordingAddress) continue;
            this.addSoundRecord();
            this.lastRecordCycle = this.cyclesRunning;
        }
        this.e6809.callstackSanityCheck();
        this.cyclesDone = this.cyclesRunning - cyclesStart;
        return reason;
    }

    int vecx_emu_plain(long cyclesOrg) {
        this.stop = false;
        long cycles = cyclesOrg;
        long cyclesStart = this.cyclesRunning;
        int reason = 1;
        this.breakpointExit = 1;
        while (cycles > 0L && !this.stop) {
            this.nonCPUStepsDone = 0;
            this.thisWaitRecal = this.e6809.reg_pc % 65536 == 61858;
            int icycles = this.e6809.e6809_sstep_opt(this.via_ifr & 0x80, this.firq);
            this.firq = 0;
            for (int c = 0; c < icycles - this.nonCPUStepsDone; ++c) {
                if (this.cart != null) {
                    this.cart.cartStep(this.cyclesRunning);
                }
                this.via_sstep0();
                this.timerDoStep();
                this.analogStep();
                if (this.joyport[0] != null) {
                    this.joyport[0].step();
                }
                if (this.joyport[1] != null) {
                    this.joyport[1].step();
                }
                this.via_sstep1();
                ++this.cyclesRunning;
            }
            cycles -= (long)icycles;
            this.fcycles -= (long)icycles;
            this.soundCycles -= (long)icycles;
            boolean doSync = false;
            if (this.config.autoSync) {
                if (this.imagerMode && (this.via_ier & 2) == 2) {
                    if ((this.via_ifr & 2) == 2 && (this.via_ier & 2) == 2 && !this.e6809.get_cc(16)) {
                        doSync = true;
                        this.lastSyncCycles = this.cyclesRunning;
                    }
                } else {
                    if (this.syncImpulse && this.cyclesRunning - this.lastSyncCycles < 20000L) {
                        this.lastSyncCycles = this.cyclesRunning;
                        this.syncImpulse = false;
                    }
                    if (this.syncImpulse) {
                        if (this.cyclesRunning - this.lastWaitRecal < 100000L) {
                            if (this.thisWaitRecal) {
                                this.lastSyncCycles = this.cyclesRunning;
                                doSync = true;
                            }
                        } else {
                            this.lastSyncCycles = this.cyclesRunning;
                            doSync = true;
                        }
                    } else if (this.fcycles < 0L) {
                        doSync = true;
                    }
                }
            } else if (this.fcycles < 0L) {
                doSync = true;
            }
            if (doSync) {
                if (this.thisWaitRecal) {
                    this.thisWaitRecal = false;
                    this.lastWaitRecal = this.cyclesRunning;
                }
                this.syncImpulse = false;
                this.fcycles = 50000L;
                this.displayedNext = (this.displayedNext + 1) % 2;
                this.displayedNow = (this.displayedNow + 1) % 2;
                this.displayer.updateDisplay();
                this.vectorDisplay[this.displayedNext].count = 0;
                this.vectorDisplay[this.displayedNext].resetBorders();
            }
            if (this.soundCycles > 0L) continue;
            this.soundCycles = 37500L;
            this.e8910.updateSound();
            if (this.cart == null || !this.cart.isSIDEnabled()) continue;
            this.cart.updateSound();
        }
        this.cyclesDone = this.cyclesRunning - cyclesStart;
        return reason;
    }

    public VectrexDisplayVectors getDisplayList() {
        return this.vectorDisplay[this.displayedNow];
    }

    public void poke(int address, byte value) {
        if ((address & 0xE000) == 57344) {
            this.rom[address - 57344] = value;
        } else if ((address & 0xE000) == 49152) {
            if ((address & 0x800) != 0) {
                this.ram[address & 0x3FF] = value;
                this.checkMemWriteBreakpoint(address & 0x3FF, value);
            }
            if ((address & 0x1000) != 0) {
                this.e6809_write8(address, value);
            }
        } else {
            this.cart.write(address, value);
        }
    }

    private boolean loadBios() {
        try {
            Path path = Paths.get(Global.mainPathPrefix + this.config.usedSystemRom, new String[0]);
            byte[] biosData = Files.readAllBytes(path);
            for (int i = 0; i < biosData.length; ++i) {
                this.rom[i] = biosData[i] & 0xFF;
            }
        }
        catch (Throwable e) {
            this.log.addLog(e, LogPanel.ERROR);
            return false;
        }
        return true;
    }

    private boolean loadOrgBios() {
        try {
            Path path = Paths.get(Global.mainPathPrefix + "system" + File.separator + "system.img", new String[0]);
            byte[] biosData = Files.readAllBytes(path);
            for (int i = 0; i < biosData.length; ++i) {
                this.rom[i] = biosData[i] & 0xFF;
            }
        }
        catch (Throwable e) {
            this.log.addLog(e, LogPanel.ERROR);
            return false;
        }
        return true;
    }

    public boolean init(CartridgeProperties cartProp) {
        this.initRam();
        this.config.resetCartChanges();
        this.log.addLog("vecx: init cart: " + cartProp.mName, LogPanel.INFO);
        if (!this.loadBios()) {
            this.log.addLog("Vecx: init() BIOS of vectrex not loaded!", LogPanel.WARN);
            return false;
        }
        try {
            this.cart.setVecx(this);
            if (!this.cart.init(cartProp)) {
                this.log.addLog("Vecx: init() cartridge not loaded!", LogPanel.WARN);
                return false;
            }
            this.e6809.e6809_reset();
            this.vecx_reset();
        }
        catch (Throwable e) {
            this.log.addLog(e, LogPanel.ERROR);
            return false;
        }
        return true;
    }

    public boolean init(String filenameRom) {
        return this.init(filenameRom, true);
    }

    public boolean init(String filenameRom, boolean checkForCartridge) {
        return this.init(filenameRom, checkForCartridge, false);
    }

    public boolean init(String filenameRom, boolean checkForCartridge, boolean fromPanel) {
        return this.init(filenameRom, checkForCartridge, fromPanel, false);
    }

    public boolean init(String filenameRom, boolean checkForCartridge, boolean fromPanel, boolean doRestart) {
        this.initRam();
        this.config.resetCartChanges();
        if (this.cart == null) {
            doRestart = false;
        }
        if (doRestart && this.cart.currentCardProp != null) {
            return this.init(this.cart.currentCardProp);
        }
        if (!doRestart) {
            CartridgeProperties cartProp;
            this.cart = new Cartridge();
            this.joyport[0].deinit();
            this.joyport[1].deinit();
            this.romName = UtilityFiles.convertSeperator(filenameRom);
            if (checkForCartridge && (cartProp = CartridgePropertiesPanel.getCartridgeProp(filenameRom)) != null) {
                boolean loadit = true;
                File f = new File(filenameRom);
                if (f.exists()) {
                    Vector<String> f1 = cartProp.getFullFilename();
                    if (f1 == null) {
                        loadit = false;
                    } else if (f1.size() <= 0) {
                        loadit = false;
                    } else {
                        String f2 = UtilityFiles.convertSeperator(f1.elementAt(0));
                        loadit = filenameRom.toLowerCase().contains(f2.toLowerCase());
                    }
                }
                if (loadit) {
                    if (fromPanel) {
                        String[] orgBins = new String[]{"3dczycst", "art", "armor", "animact", "bedlam", "berzerk", "blitz", "castle", "chasm", "dktower", "headsup", "hyper", "melody", "mine3d", "mstorm2", "narrow", "polar", "pole", "ripoff", "scramble", "solar", "space", "spike", "spinball", "starhawk", "sweep", "webwars"};
                        boolean talk = true;
                        for (int i = 0; i < orgBins.length; ++i) {
                            if (!filenameRom.toLowerCase().contains(orgBins[i])) continue;
                            talk = false;
                            break;
                        }
                        if (talk) {
                            ShowWarningDialog.showWarningDialog("Cartridge found!", "For the supplied vectrex binary\n(based on the name)\na cartridge definition was found.\n\nThe cartridge was loaded!");
                        }
                    }
                    return this.init(cartProp);
                }
            }
        }
        if (!this.loadBios()) {
            this.log.addLog("Vecx: init() BIOS of vectrex not loaded!", LogPanel.WARN);
            return false;
        }
        try {
            this.cart.setVecx(this);
            this.log.addLog("vecx: init rom: " + filenameRom, LogPanel.INFO);
            this.cart.load(filenameRom);
            this.e6809.e6809_reset();
            this.vecx_reset();
        }
        catch (Throwable e) {
            this.log.addLog(e, LogPanel.ERROR);
            return false;
        }
        return true;
    }

    public boolean inject(String filenameRom, boolean checkForCartridge) {
        this.cart = new Cartridge();
        this.romName = filenameRom;
        try {
            this.cart.load(filenameRom);
        }
        catch (Throwable e) {
            this.log.addLog(e, LogPanel.ERROR);
            return false;
        }
        return true;
    }

    public boolean inject(CartridgeProperties cartProp) {
        try {
            if (!this.cart.inject(cartProp)) {
                this.log.addLog("Vecx: init() cartridge not loaded!", LogPanel.WARN);
                return false;
            }
        }
        catch (Throwable e) {
            this.log.addLog(e, LogPanel.ERROR);
            return false;
        }
        return true;
    }

    public CompleteState getState() {
        CompleteState state = new CompleteState();
        state.rom = this.rom;
        this.cart.initStateSave();
        state.sidState = null;
        if (this.cart != null && this.cart.isSIDEnabled() && this.cart.vsid != null) {
            state.sidState = this.cart.vsid.oldState;
        }
        state.cart = this.cart;
        state.putState(this);
        state.putState(this.e6809);
        state.putState(this.e8910);
        if (this.imagerMode) {
            state.putState((Imager3dDevice)this.joyport[1].getDevice());
        }
        return state;
    }

    public boolean putState(CompleteState state) {
        try {
            this.joyport[0].deinit();
            this.joyport[1].deinit();
            ArrayList<CartridgeListener> mListener = this.cart.getListener();
            this.rom = state.rom;
            this.cart = state.cart;
            if (state.cart.isSIDEnabled()) {
                this.cart.vsid = new VSID(this.cart);
            }
            this.initFromState(state);
            this.cart.setListener(mListener);
            this.cart.init();
            if (this.imagerMode) {
                state.imager.setIgnoreReset(true);
                this.joyport[1].plugIn(state.imager);
                state.imager.setIgnoreReset(false);
            }
            return true;
        }
        catch (Throwable ex) {
            this.log.addLog(ex, LogPanel.ERROR);
            return false;
        }
    }

    void initFromState(CompleteState state) {
        E6809State.deepCopy(state.e6809State, this.e6809);
        E8910State.deepCopy(state.e8910State, this.e8910);
        VecXState.deepCopy(state.eVecXState, this);
        this.cart.setBank(this.currentBank);
        this.cart.setVecx(this);
        this.cart.ds2430.cart = this.cart;
        this.cart.microchip.cart = this.cart;
        if (this.cart.isSIDEnabled()) {
            if (this.cart.vsid == null) {
                this.cart.vsid = new VSID(this.cart);
                this.cart.vsid.init();
            }
            this.cart.vsid.oldState = state.sidState;
        }
        this.cart.initFromStateSave();
    }

    private void addStateToRingbuffer() {
        try {
            if (this.goSSBackRingBuffer[this.ringSSBufferNext] == null) {
                this.goSSBackRingBuffer[this.ringSSBufferNext] = new CompleteState();
            }
            CompleteState state = this.goSSBackRingBuffer[this.ringSSBufferNext];
            this.cart.initStateSave();
            state.sidState = this.cart.getSidState();
            state.putState(this);
            state.putState(this.e6809);
            state.putState(this.e8910);
            this.ringSSBufferNext = (this.ringSSBufferNext + 1) % SS_RING_BUFFER_SIZE;
            this.ringSSWalkStep = -1;
            if (this.cyclesRunning % 30000L == 0L) {
                if (this.goFrameBackRingBuffer[this.ringFrameBufferNext] == null) {
                    this.goFrameBackRingBuffer[this.ringFrameBufferNext] = new CompleteState();
                }
                state = this.goFrameBackRingBuffer[this.ringFrameBufferNext];
                state.putState(this);
                state.putState(this.e6809);
                state.putState(this.e8910);
                this.ringFrameBufferNext = (this.ringFrameBufferNext + 1) % FRAME_RING_BUFFER_SIZE;
                this.ringFrameWalkStep = -1;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getRingbufferPos() {
        if (!this.config.ringbufferActive) {
            return 0;
        }
        int pos = 0;
        if (this.ringSSWalkStep == -1) {
            return pos;
        }
        int testStep = this.ringSSWalkStep;
        while (this.ringSSBufferNext != (testStep = testStep == -1 ? (this.ringSSBufferNext + (SS_RING_BUFFER_SIZE - 2)) % SS_RING_BUFFER_SIZE : (testStep + (SS_RING_BUFFER_SIZE - 1)) % SS_RING_BUFFER_SIZE) && this.goSSBackRingBuffer[testStep] != null) {
            ++pos;
        }
        return pos;
    }

    public boolean stepBackInSSRingbuffer(int steps) {
        boolean b = true;
        for (int i = 0; i < steps; ++i) {
            b &= this.oneStepBackInSSRingbuffer();
        }
        return b;
    }

    private boolean oneStepBackInSSRingbuffer() {
        if (!this.config.ringbufferActive) {
            return false;
        }
        this.ringSSWalkStep = this.ringSSWalkStep == -1 ? (this.ringSSBufferNext + (SS_RING_BUFFER_SIZE - 2)) % SS_RING_BUFFER_SIZE : (this.ringSSWalkStep + (SS_RING_BUFFER_SIZE - 1)) % SS_RING_BUFFER_SIZE;
        if (this.ringSSBufferNext == this.ringSSWalkStep) {
            this.ringSSWalkStep = this.ringSSWalkStep == (this.ringSSBufferNext + (SS_RING_BUFFER_SIZE - 1)) % SS_RING_BUFFER_SIZE ? -1 : (this.ringSSWalkStep + 1) % SS_RING_BUFFER_SIZE;
            return false;
        }
        if (this.goSSBackRingBuffer[this.ringSSWalkStep] == null) {
            this.ringSSWalkStep = this.ringSSWalkStep == (this.ringSSBufferNext + (SS_RING_BUFFER_SIZE - 1)) % SS_RING_BUFFER_SIZE ? -1 : (this.ringSSWalkStep + 1) % SS_RING_BUFFER_SIZE;
            return false;
        }
        CompleteState state = this.goSSBackRingBuffer[this.ringSSWalkStep];
        this.initFromState(state);
        this.displayer.directDraw(this.directDrawVector);
        return true;
    }

    public boolean stepForwardInSSRingbuffer(int steps) {
        boolean b = true;
        for (int i = 0; i < steps; ++i) {
            b &= this.oneStepForwardInSSRingbuffer();
        }
        return b;
    }

    private boolean oneStepForwardInSSRingbuffer() {
        if (!this.config.ringbufferActive) {
            return false;
        }
        if (this.ringSSWalkStep == -1) {
            return false;
        }
        this.ringSSWalkStep = (this.ringSSWalkStep + 1) % SS_RING_BUFFER_SIZE;
        if (this.goSSBackRingBuffer[this.ringSSWalkStep] == null) {
            this.ringSSWalkStep = -1;
            return false;
        }
        CompleteState state = this.goSSBackRingBuffer[this.ringSSWalkStep];
        if (this.ringSSBufferNext == this.ringSSWalkStep + 1) {
            this.ringSSWalkStep = -1;
        }
        this.initFromState(state);
        this.displayer.directDraw(this.directDrawVector);
        return true;
    }

    public boolean stepBackInFrameRingbuffer(int steps) {
        boolean b = true;
        for (int i = 0; i < steps; ++i) {
            b &= this.oneStepBackInFrameRingbuffer();
        }
        return b;
    }

    private boolean oneStepBackInFrameRingbuffer() {
        if (!this.config.ringbufferActive) {
            return false;
        }
        this.ringSSWalkStep = -1;
        this.ringSSBufferNext = 0;
        this.ringFrameWalkStep = this.ringFrameWalkStep == -1 ? (this.ringFrameBufferNext + (FRAME_RING_BUFFER_SIZE - 2)) % FRAME_RING_BUFFER_SIZE : (this.ringFrameWalkStep + (FRAME_RING_BUFFER_SIZE - 1)) % FRAME_RING_BUFFER_SIZE;
        if (this.ringFrameBufferNext == this.ringFrameWalkStep) {
            this.ringFrameWalkStep = this.ringFrameWalkStep == (this.ringFrameBufferNext + (FRAME_RING_BUFFER_SIZE - 1)) % FRAME_RING_BUFFER_SIZE ? -1 : (this.ringFrameWalkStep + 1) % FRAME_RING_BUFFER_SIZE;
            return false;
        }
        if (this.goFrameBackRingBuffer[this.ringFrameWalkStep] == null) {
            this.ringFrameWalkStep = this.ringFrameWalkStep == (this.ringFrameBufferNext + (FRAME_RING_BUFFER_SIZE - 1)) % FRAME_RING_BUFFER_SIZE ? -1 : (this.ringFrameWalkStep + 1) % FRAME_RING_BUFFER_SIZE;
            return false;
        }
        CompleteState state = this.goFrameBackRingBuffer[this.ringFrameWalkStep];
        this.initFromState(state);
        this.displayer.directDraw(this.directDrawVector);
        return true;
    }

    public boolean stepForwardInFrameRingbuffer(int steps) {
        boolean b = true;
        for (int i = 0; i < steps; ++i) {
            b &= this.oneStepForwardInFrameRingbuffer();
        }
        return b;
    }

    private boolean oneStepForwardInFrameRingbuffer() {
        if (!this.config.ringbufferActive) {
            return false;
        }
        if (this.ringFrameWalkStep == -1) {
            return false;
        }
        this.ringSSWalkStep = -1;
        this.ringSSBufferNext = 0;
        this.ringFrameWalkStep = (this.ringFrameWalkStep + 1) % FRAME_RING_BUFFER_SIZE;
        if (this.goFrameBackRingBuffer[this.ringFrameWalkStep] == null) {
            this.ringFrameWalkStep = -1;
            return false;
        }
        CompleteState state = this.goFrameBackRingBuffer[this.ringFrameWalkStep];
        if (this.ringFrameBufferNext == this.ringFrameWalkStep + 1) {
            this.ringFrameWalkStep = -1;
        }
        this.initFromState(state);
        this.displayer.directDraw(this.directDrawVector);
        return true;
    }

    int getStepoutAddress() {
        if (this.e6809.callStack.size() > 0) {
            return (Integer)this.e6809.callStack.get(this.e6809.callStack.size() - 1);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void timerDoStep() {
        ++this.ticksRunning;
        this.timerRemoveList.clear();
        this.timerItemListClone.clear();
        Object object = this.timerItemList;
        synchronized (object) {
            for (VecXState.TimerItem t : this.timerItemList) {
                this.timerItemListClone.add(t);
            }
        }
        for (VecXState.TimerItem t : this.timerItemListClone) {
            --t.countDown;
            if (t.countDown > 0) continue;
            if (t.type == 2061) {
                this.alternate = true;
                if (this.shouldStall((int)(this.cyclesRunning - this.lastShiftTriggered), true)) {
                    this.via_stalling = true;
                    this.via_ifr &= 0xFB;
                    this.via_srclk = 1;
                    this.int_update();
                    this.lastShiftTriggered = this.cyclesRunning;
                } else {
                    this.via_stalling = false;
                    this.lastShiftTriggered = this.cyclesRunning;
                    this.via_ifr &= 0xFB;
                    this.via_srb = 0;
                    this.via_srclk = 1;
                    this.int_update();
                }
            } else if (t.type == 14) {
                this.via_t1on = 1;
                this.via_t1lh = t.valueToSet & 0xFF;
                this.via_t1c = this.via_t1lh << 8 | this.via_t1ll;
                this.via_ifr &= 0xBF;
                this.via_t1int = 1;
                if (this.config.breakpointsActive && (this.via_acr & 0x80) != 0 && this.via_t1pb7 != 0) {
                    this.checkVIABreakpoint(0, this.via_orb, this.via_orb - this.via_t1pb7);
                }
                this.via_t1pb7 = 0;
                this.doCheckRamp(false);
                this.int_update();
            } else if (t.type == 15) {
                this.via_t2c = (t.valueToSet & 0xFF) << 8 | this.via_t2ll;
                this.via_t2c += 0;
                this.via_ifr &= 0xDF;
                this.via_t2on = 1;
                this.via_t2int = 1;
                this.int_update();
            } else if (t.type == 8) {
                this.noiseCycles = this.cyclesRunning;
                this.c_alg_rsh.setDigitalVoltage(t.valueToSet & 0xFF);
            } else if (t.whereToSet != null) {
                if (t.type == 1037) {
                    this.alternate = true;
                    if (this.shouldStall((int)(this.cyclesRunning - this.lastShiftTriggered), false)) {
                        this.via_stalling = true;
                        this.via_ifr &= 0xFB;
                        this.via_srclk = 1;
                        this.int_update();
                        this.timerRemoveList.add(t);
                        continue;
                    }
                    this.via_stalling = false;
                    this.lastShiftTriggered = this.cyclesRunning;
                    this.via_sr = t.valueToSet & 0xFF;
                    this.via_ifr &= 0xFB;
                    this.via_srb = 0;
                    this.via_srclk = 1;
                    this.int_update();
                } else if (t.type == 11) {
                    if ((t.whereToSet.intValue & 0xFF) != (t.valueToSet & 0xFF)) {
                        this.rampOffFraction = true;
                    }
                } else if (t.type == 4 && (t.whereToSet.intValue & 0xFF) != (t.valueToSet & 0xFF)) {
                    this.rampOnFraction = true;
                }
                t.whereToSet.intValue = t.valueToSet & 0xFF;
                if (t.type == 12) {
                    this.doCheckMultiplexer();
                }
                if (t.type != 7 && t.whereToSet.intValue >= 128) {
                    t.whereToSet.intValue -= 256;
                }
            }
            this.timerRemoveList.add(t);
        }
        object = this.timerItemList;
        synchronized (object) {
            for (VecXState.TimerItem t : this.timerRemoveList) {
                this.timerItemList.remove(t);
                this.timerHeap.add(t);
            }
        }
    }

    void doCheckMultiplexer() {
        if (!this.config.DACCompareDelayEmulation) {
            this.doCheckJoystick();
        }
        if ((this.via_orb & 1) != 0) {
            return;
        }
        switch (this.alg_sel.intValue & 6) {
            case 0: {
                this.timerAddItem(this.alg_DAC.intValue, this.alg_ysh, 5);
                break;
            }
            case 2: {
                this.timerAddItem(this.alg_DAC.intValue, null, 8);
                break;
            }
            case 4: {
                this.timerAddItem(this.alg_DAC.intValue, this.alg_zsh, 7);
                this.intensityDrift = 0L;
                break;
            }
            case 6: {
                this.timerAddItem(this.alg_DAC.intValue, this.alg_ssh, 6);
            }
        }
    }

    void doCheckJoystick() {
        switch (this.via_orb & 6) {
            case 0: {
                if (this.joyport[0] != null) {
                    this.alg_jsh = this.joyport[0].getHorizontal();
                    break;
                }
                this.alg_jsh = 127;
                break;
            }
            case 2: {
                if (this.joyport[0] != null) {
                    this.alg_jsh = this.joyport[0].getVertical();
                    break;
                }
                this.alg_jsh = 127;
                break;
            }
            case 4: {
                if (this.joyport[1] != null) {
                    this.alg_jsh = this.joyport[1].getHorizontal();
                    break;
                }
                this.alg_jsh = 127;
                break;
            }
            case 6: {
                this.alg_jsh = this.joyport[1] != null ? this.joyport[1].getVertical() : 127;
            }
        }
        int dacCompValue = (this.via_ora ^ 0x80) - 1;
        if (this.config.DACCompareDelayEmulation) {
            float delayCycles = this.cyclesRunning - this.lastORAWriteCycle;
            int newDAC = dacCompValue;
            delayCycles = (float)((double)delayCycles + 0.2);
            dacCompValue = 0;
            for (int bit = 128; delayCycles > 0.0f && bit != 0; bit >>= 1) {
                int newBit = newDAC & bit;
                int oldBit = this.alg_oldDAC & bit;
                if (newBit == bit) {
                    dacCompValue |= bit;
                    delayCycles = (float)((double)delayCycles - 0.9);
                    continue;
                }
                dacCompValue &= 255 - bit;
                delayCycles = (float)((double)delayCycles - 1.1);
            }
        }
        this.alg_compare = this.alg_jsh > dacCompValue ? 32 : 0;
    }

    int getBitsFlipped8(int v1, int v2) {
        int flipped = 0;
        int bitComp = 1;
        for (int i = 0; i < 8; ++i) {
            if ((v1 & bitComp) != (v2 & bitComp)) {
                ++flipped;
            }
            bitComp <<= 1;
        }
        return flipped;
    }

    void doCheckRamp(boolean fromOrbWrite) {
        if (!fromOrbWrite) {
            if ((this.via_acr & 0x80) != 0) {
                if (this.via_t1pb7 == 0) {
                    this.timerAddItem(this.via_t1pb7, this.sig_ramp, 4);
                } else {
                    this.timerAddItem(this.via_t1pb7, this.sig_ramp, 11);
                }
            }
        } else if ((this.via_acr & 0x80) == 0) {
            if ((this.via_orb & 0x80) == 0) {
                this.timerAddItem(this.via_orb & 0x80, this.sig_ramp, 4);
            } else {
                this.timerAddItem(this.via_orb & 0x80, this.sig_ramp, 11);
            }
        }
    }

    void analogStepColor() {
        if ((this.via_orb & 1) == 0 && (this.alg_sel.intValue & 6) == 2) {
            this.c_alg_rsh.doStep();
        }
        ++this.intensityDrift;
        int sig_dx = 0;
        int sig_dy = 0;
        if (this.lastZero != this.sig_zero.intValue) {
            if (this.sig_zero.intValue == 0) {
                this.zeroRetainX = (this.alg_curr_x - (double)(this.config.ALG_MAX_X / 2)) * this.config.zeroRetainX;
                this.zeroRetainY = (this.alg_curr_y - (double)(this.config.ALG_MAX_Y / 2)) * this.config.zeroRetainY;
            }
            this.lastZero = this.sig_zero.intValue;
        } else if (this.sig_zero.intValue == 0) {
            this.zeroRetainX *= 0.99;
            this.zeroRetainY *= 0.99;
        }
        if (this.sig_zero.intValue == 0) {
            this.noiseCycles = this.cyclesRunning;
            int absx = (int)Math.abs(this.alg_curr_x - (double)(this.config.ALG_MAX_X / 2));
            int absy = (int)Math.abs(this.alg_curr_y - (double)(this.config.ALG_MAX_Y / 2));
            sig_dx = (int)((double)(this.config.ALG_MAX_X / 2 - (int)this.alg_curr_x) / this.config.zero_divider);
            sig_dy = (int)((double)(this.config.ALG_MAX_Y / 2 - (int)this.alg_curr_y) / this.config.zero_divider);
        }
        if (this.sig_ramp.intValue == 0) {
            sig_dx += this.alg_xsh.intValue;
            sig_dy += -this.alg_ysh.intValue;
            this.fractionSaveX = this.alg_xsh.intValue;
            this.fractionSaveY = this.alg_ysh.intValue;
            if (this.rampOnFraction) {
                this.rampOnFraction = false;
                this.alg_curr_x -= (double)((int)((double)this.alg_xsh.intValue * this.config.rampOnFractionValue));
                this.alg_curr_y -= (double)(-((int)((double)this.alg_ysh.intValue * this.config.rampOnFractionValue)));
            }
        } else if (this.rampOffFraction) {
            this.rampOffFraction = false;
            this.alg_curr_x += (double)((int)((double)this.fractionSaveX * this.config.rampOffFractionValue));
            this.alg_curr_y += (double)(-((int)((double)this.fractionSaveY * this.config.rampOffFractionValue)));
            if (this.alg_vectoring == 1 && this.alg_curr_x >= 0.0 && this.alg_curr_x < (double)this.config.ALG_MAX_X && this.alg_curr_y >= 0.0 && this.alg_curr_y < (double)this.config.ALG_MAX_Y) {
                this.alg_vector_x1 = (int)this.alg_curr_x;
                this.alg_vector_y1 = (int)this.alg_curr_y;
            }
        }
        if (this.alg_vectoring == 0) {
            if (this.sig_blank.intValue == 1 && this.alg_curr_x >= 0.0 && this.alg_curr_x < (double)this.config.ALG_MAX_X && this.alg_curr_y >= 0.0 && this.alg_curr_y < (double)this.config.ALG_MAX_Y) {
                if (this.imagerMode && this.joyport[1].getDevice() instanceof Imager3dDevice) {
                    Imager3dDevice i3d = (Imager3dDevice)this.joyport[1].getDevice();
                    this.leftEyeColor = i3d.getLeftColor();
                    this.rightEyeColor = i3d.getRightColor();
                }
                this.alg_vectoring = 1;
                this.alg_vector_dx = this.alg_xsh.intValue;
                this.alg_vector_dy = -this.alg_ysh.intValue;
                int sinOffsetX = 0;
                int sinOffsetY = 0;
                if (this.config.enableWobble) {
                    float currentSinPos = this.cyclesRunning % (long)this.config.cycle_sin_freq;
                    double currentSinPosMathX = (double)(currentSinPos / (float)this.config.cycle_sin_freq * 2.0f) * Math.PI;
                    double currentSinPosMathY = (double)((currentSinPos + (float)this.config.yOffsetToX) % (float)this.config.cycle_sin_freq / (float)this.config.cycle_sin_freq * 2.0f) * Math.PI;
                    sinOffsetX = (int)((double)this.config.MAX_SIN_POSITION_OFFSET * Math.sin(currentSinPosMathX));
                    sinOffsetY = (int)((double)this.config.MAX_SIN_POSITION_OFFSET * Math.sin(currentSinPosMathY));
                    sinOffsetX = (int)((double)this.config.MAX_SIN_POSITION_OFFSET * Math.sin(currentSinPosMathX) * Math.cos(this.config.constantC * currentSinPosMathX));
                    sinOffsetY = (int)((double)this.config.MAX_SIN_POSITION_OFFSET * Math.sin(currentSinPosMathY) * Math.cos(this.config.constantC * currentSinPosMathY));
                }
                this.alg_vector_x0 = (int)this.alg_curr_x + (int)(this.config.blankOffDelay * (double)this.alg_vector_dx) + sinOffsetX;
                this.alg_vector_y0 = (int)this.alg_curr_y + (int)(this.config.blankOffDelay * (double)this.alg_vector_dy) + sinOffsetY;
                this.alg_vector_x1 = (int)this.alg_curr_x;
                this.alg_vector_y1 = (int)this.alg_curr_y;
                this.alg_vector_speed = Math.max(Math.abs(this.alg_xsh.intValue), Math.abs(this.alg_ysh.intValue));
                this.alg_leftEye = this.leftEyeColor;
                this.alg_rightEye = this.rightEyeColor;
                this.alg_vector_color = this.alg_zsh.intValue;
                boolean bl = this.alg_ramping = this.sig_ramp.intValue == 0;
                if (this.alg_ramping || this.sig_zero.intValue == 0) {
                    this.alg_spline_compare_dx = sig_dx;
                    this.alg_spline_compare_dy = sig_dy;
                } else {
                    this.alg_spline_compare_dx = Integer.MAX_VALUE;
                    this.alg_spline_compare_dy = Integer.MAX_VALUE;
                }
            }
        } else {
            boolean imagerColorChanged;
            if (this.imagerMode && this.joyport[1].getDevice() instanceof Imager3dDevice) {
                Imager3dDevice i3d = (Imager3dDevice)this.joyport[1].getDevice();
                this.leftEyeColor = i3d.getLeftColor();
                this.rightEyeColor = i3d.getRightColor();
            }
            boolean yChanged = -this.alg_ysh.intValue != this.alg_vector_dy && this.sig_ramp.intValue == 0;
            boolean xChanged = this.alg_xsh.intValue != this.alg_vector_dx && this.sig_ramp.intValue == 0;
            boolean bl = imagerColorChanged = this.imagerMode && (this.leftEyeColor != this.alg_leftEye || this.rightEyeColor != this.alg_rightEye);
            if (this.sig_blank.intValue == 0) {
                if (this.sig_blank.intValue == 0) {
                    this.alg_addline((int)((double)this.alg_vector_x0 + this.zeroRetainX), (int)((double)this.alg_vector_y0 + this.zeroRetainY), this.alg_vector_x1 + (int)(this.config.blankOnDelay * (double)this.alg_vector_dx + this.zeroRetainX), this.alg_vector_y1 + (int)(this.config.blankOnDelay * (double)this.alg_vector_dy + this.zeroRetainY), this.alg_zsh.intValue, this.alg_curved, this.alg_vector_speed, this.alg_leftEye, this.alg_rightEye);
                } else {
                    this.alg_addline((int)((double)this.alg_vector_x0 + this.zeroRetainX), (int)((double)this.alg_vector_y0 + this.zeroRetainY), (int)((double)this.alg_vector_x1 + this.zeroRetainX), (int)((double)this.alg_vector_y1 + this.zeroRetainY), this.alg_zsh.intValue, this.alg_curved, this.alg_vector_speed, this.alg_leftEye, this.alg_rightEye);
                }
                this.alg_vectoring = 0;
            } else if (imagerColorChanged || xChanged || yChanged || this.alg_zsh.intValue != this.alg_vector_color || this.sig_ramp.intValue == 0 != this.alg_ramping) {
                boolean rampStartCheck;
                boolean inLimits;
                boolean bl2 = inLimits = this.alg_curr_x >= 0.0 && this.alg_curr_x < (double)this.config.ALG_MAX_X && this.alg_curr_y >= 0.0 && this.alg_curr_y < (double)this.config.ALG_MAX_Y;
                if ((this.alg_ramping || this.sig_zero.intValue == 0) && (sig_dx != this.alg_spline_compare_dx || sig_dy != this.alg_spline_compare_dy) && inLimits && sig_dy != 0) {
                    this.alg_curved = true;
                }
                boolean bl3 = rampStartCheck = !this.alg_ramping && this.sig_ramp.intValue == 0;
                if (!rampStartCheck) {
                    this.alg_addline((int)((double)this.alg_vector_x0 + this.zeroRetainX), (int)((double)this.alg_vector_y0 + this.zeroRetainY), (int)((double)this.alg_vector_x1 + this.zeroRetainX), (int)((double)this.alg_vector_y1 + this.zeroRetainY), this.alg_zsh.intValue, this.alg_curved, this.alg_vector_speed, this.alg_leftEye, this.alg_rightEye);
                }
                if (inLimits) {
                    int sinOffsetX = 0;
                    int sinOffsetY = 0;
                    if (this.config.enableWobble) {
                        float currentSinPos = this.cyclesRunning % (long)this.config.cycle_sin_freq;
                        double currentSinPosMathX = (double)(currentSinPos / (float)this.config.cycle_sin_freq * 2.0f) * Math.PI;
                        double currentSinPosMathY = (double)((currentSinPos + (float)this.config.yOffsetToX) % (float)this.config.cycle_sin_freq / (float)this.config.cycle_sin_freq * 2.0f) * Math.PI;
                        sinOffsetX = (int)((double)this.config.MAX_SIN_POSITION_OFFSET * Math.sin(currentSinPosMathX));
                        sinOffsetY = (int)((double)this.config.MAX_SIN_POSITION_OFFSET * Math.sin(currentSinPosMathY));
                        sinOffsetX = (int)((double)this.config.MAX_SIN_POSITION_OFFSET * Math.sin(currentSinPosMathX) * Math.cos(this.config.constantC * currentSinPosMathX));
                        sinOffsetY = (int)((double)this.config.MAX_SIN_POSITION_OFFSET * Math.sin(currentSinPosMathY) * Math.cos(this.config.constantC * currentSinPosMathY));
                    }
                    this.alg_vector_x0 = (int)this.alg_curr_x + sinOffsetX;
                    this.alg_vector_y0 = (int)this.alg_curr_y + sinOffsetY;
                    this.alg_vector_x1 = (int)this.alg_curr_x;
                    this.alg_vector_y1 = (int)this.alg_curr_y;
                    if (this.sig_ramp.intValue == 0) {
                        this.alg_vector_dx = this.alg_xsh.intValue;
                        this.alg_vector_dy = -this.alg_ysh.intValue;
                    } else {
                        this.alg_vector_dx = 0;
                        this.alg_vector_dy = 0;
                        this.alg_curved = false;
                    }
                    this.alg_vector_color = this.alg_zsh.intValue;
                    this.alg_leftEye = this.leftEyeColor;
                    this.alg_rightEye = this.rightEyeColor;
                    this.alg_vector_speed = Math.max(Math.abs(this.alg_xsh.intValue), Math.abs(this.alg_ysh.intValue));
                    boolean bl4 = this.alg_ramping = this.sig_ramp.intValue == 0;
                    if (this.alg_ramping || this.sig_zero.intValue == 0) {
                        this.alg_spline_compare_dx = sig_dx;
                        this.alg_spline_compare_dy = sig_dy;
                    } else {
                        this.alg_spline_compare_dx = Integer.MAX_VALUE;
                        this.alg_spline_compare_dy = Integer.MAX_VALUE;
                    }
                } else {
                    this.alg_vectoring = 0;
                }
            } else if (sig_dx == 0 && sig_dy == 0) {
                if (this.alg_vector_speed < 128) {
                    this.alg_vector_speed = 128;
                }
                this.alg_vector_speed += 4;
            }
        }
        if (this.config.efficiencyEnabled && this.sig_zero.intValue != 0) {
            double EFFICIENCY_THRESHOLD_X = this.config.efficiencyThresholdX;
            double EFFICIENCY_THRESHOLD_Y = this.config.efficiencyThresholdY;
            double xTest = this.alg_curr_x - (double)(this.config.ALG_MAX_X / 2);
            double yTest = this.alg_curr_y - (double)(this.config.ALG_MAX_Y / 2);
            double xPercent = Math.abs(xTest / (double)(this.config.ALG_MAX_X / 2));
            double yPercent = Math.abs(yTest / (double)(this.config.ALG_MAX_Y / 2));
            double xEfficience = 1.0;
            double yEfficience = 1.0;
            if (xPercent > EFFICIENCY_THRESHOLD_X) {
                xEfficience = 1.0 - xPercent / this.config.efficiency * (xPercent - EFFICIENCY_THRESHOLD_X / EFFICIENCY_THRESHOLD_X);
                if (xEfficience < 0.01) {
                    xEfficience = 0.01;
                }
                if (xTest * (double)sig_dx < 0.0) {
                    xEfficience = 1.0 / xEfficience;
                }
            }
            if (yPercent > EFFICIENCY_THRESHOLD_Y) {
                yEfficience = 1.0 - yPercent / this.config.efficiency * (yPercent - EFFICIENCY_THRESHOLD_Y / EFFICIENCY_THRESHOLD_Y);
                if (yEfficience < 0.01) {
                    yEfficience = 0.01;
                }
                if (yTest * (double)sig_dy < 0.0) {
                    yEfficience = 1.0 / yEfficience;
                }
            }
            if (sig_dx + 128 < 256 && sig_dy + 128 < 256 && sig_dx + 128 >= 0 && sig_dy + 128 >= 0) {
                this.alg_curr_x += (double)sig_dx * dacDeviation[sig_dx + 128] * xEfficience;
                this.alg_curr_y += (double)sig_dy * dacDeviation[sig_dy + 128] * yEfficience;
            } else {
                this.alg_curr_x += (double)sig_dx * xEfficience;
                this.alg_curr_y += (double)sig_dy * yEfficience;
            }
            if (sig_dx != 0) {
                this.alg_curr_x += VideConfig.scaleEfficiency / (double)sig_dx * xPercent;
            }
            if (sig_dy != 0) {
                this.alg_curr_y += VideConfig.scaleEfficiency / (double)sig_dy * yPercent;
            }
        } else if (sig_dx + 128 < 256 && sig_dy + 128 < 256 && sig_dx + 128 >= 0 && sig_dy + 128 >= 0) {
            this.alg_curr_x += (double)sig_dx * dacDeviation[sig_dx + 128];
            this.alg_curr_y += (double)sig_dy * dacDeviation[sig_dy + 128];
        } else {
            this.alg_curr_x += (double)sig_dx;
            this.alg_curr_y += (double)sig_dy;
        }
        this.alg_curr_x -= 2.0 * this.c_alg_rsh.getDigitalValue();
        this.alg_curr_y -= -2.0 * this.c_alg_rsh.getDigitalValue();
        if (this.alg_curr_x > 100000.0) {
            this.alg_curr_x = 100000.0;
        } else if (this.alg_curr_x < -100000.0) {
            this.alg_curr_x = -100000.0;
        }
        if (this.alg_curr_y > 100000.0) {
            this.alg_curr_y = 100000.0;
        } else if (this.alg_curr_y < -100000.0) {
            this.alg_curr_y = -100000.0;
        }
        if (this.sig_zero.intValue != 0) {
            if (this.sig_ramp.intValue != 0) {
                this.alg_curr_x -= this.config.drift_x;
                this.alg_curr_y -= this.config.drift_y;
            } else {
                this.alg_curr_x -= this.config.drift_x / 5.0;
                this.alg_curr_y -= this.config.drift_y / 5.0;
            }
        }
        if (this.config.emulateIntegrationOverflow && Math.abs(sig_dx) > 100) {
            double yOverflow = ((double)sig_dx + (double)sig_dy) / this.config.overflowFactor;
            this.alg_curr_y += yOverflow;
        }
        if (this.config.noise) {
            long running = this.cyclesRunning - this.noiseCycles;
            if (running > 2000L) {
                double xnoise = (0.5 - Global.getRand().nextDouble()) * this.config.noisefactor;
                double ynoise = (0.5 - Global.getRand().nextDouble()) * this.config.noisefactor;
                this.alg_curr_x -= xnoise / 10.0;
                this.alg_curr_y -= ynoise / 10.0;
            }
            if (running > 5000L) {
                double xnoise = (0.5 - Global.getRand().nextDouble()) * this.config.noisefactor;
                double ynoise = (0.5 - Global.getRand().nextDouble()) * this.config.noisefactor;
                this.alg_curr_x -= xnoise / 8.0;
                this.alg_curr_y -= ynoise / 8.0;
            }
            if (running > 10000L) {
                double xnoise = (0.5 - Global.getRand().nextDouble()) * this.config.noisefactor;
                double ynoise = (0.5 - Global.getRand().nextDouble()) * this.config.noisefactor;
                this.alg_curr_x -= xnoise / 5.0;
                this.alg_curr_y -= ynoise / 5.0;
            }
            if (running > 15000L) {
                double xnoise = (0.5 - Global.getRand().nextDouble()) * this.config.noisefactor;
                double ynoise = (0.5 - Global.getRand().nextDouble()) * this.config.noisefactor;
                this.alg_curr_x -= xnoise / 2.0;
                this.alg_curr_y -= ynoise / 2.0;
            }
            if (running > 25000L) {
                double xnoise = (0.5 - Global.getRand().nextDouble()) * this.config.noisefactor;
                double ynoise = (0.5 - Global.getRand().nextDouble()) * this.config.noisefactor;
                this.alg_curr_x -= xnoise;
                this.alg_curr_y -= ynoise;
            }
        }
        if (this.alg_vectoring == 1 && this.alg_curr_x >= 0.0 && this.alg_curr_x < (double)this.config.ALG_MAX_X && this.alg_curr_y >= 0.0 && this.alg_curr_y < (double)this.config.ALG_MAX_Y) {
            this.alg_vector_x1 = (int)this.alg_curr_x;
            this.alg_vector_y1 = (int)this.alg_curr_y;
        }
        if (this.config.emulateBorders) {
            boolean inLimits;
            boolean bl = inLimits = this.alg_curr_x >= 0.0 && this.alg_curr_x < (double)this.config.ALG_MAX_X && this.alg_curr_y >= 0.0 && this.alg_curr_y < (double)this.config.ALG_MAX_Y;
            if (!inLimits && this.sig_blank.intValue == 1) {
                int intensity = this.alg_zsh.intValue & 0xFF;
                if (this.intensityDrift > 100000L) {
                    double degradePercent = (1.8E8 - (double)this.intensityDrift) / 1.8E8;
                    if (degradePercent < 0.0) {
                        degradePercent = 0.0;
                    }
                    intensity = (int)((double)intensity * degradePercent);
                }
                int OFFSET_START_DIVISOR = 40;
                double leftStart = -this.config.ALG_MAX_X / OFFSET_START_DIVISOR;
                double rightStart = this.config.ALG_MAX_X + this.config.ALG_MAX_X / OFFSET_START_DIVISOR;
                double topStart = -this.config.ALG_MAX_Y / OFFSET_START_DIVISOR;
                double bottomStart = this.config.ALG_MAX_Y + this.config.ALG_MAX_Y / OFFSET_START_DIVISOR;
                if (this.alg_curr_x < leftStart) {
                    int leftCoordinate = (int)(this.alg_curr_y / (double)this.config.ALG_MAX_Y * (double)OVERFLOW_SAMPLE_MAX);
                    if (leftCoordinate < 0) {
                        leftCoordinate = 0;
                    }
                    if (leftCoordinate > OVERFLOW_SAMPLE_MAX - 1) {
                        leftCoordinate = OVERFLOW_SAMPLE_MAX - 1;
                    }
                    int n = leftCoordinate;
                    this.vectorDisplay[this.displayedNext].left[n] = this.vectorDisplay[this.displayedNext].left[n] + (float)intensity;
                }
                if (this.alg_curr_x > rightStart) {
                    int rightCoordinate = (int)(this.alg_curr_y / (double)this.config.ALG_MAX_Y * (double)OVERFLOW_SAMPLE_MAX);
                    if (rightCoordinate < 0) {
                        rightCoordinate = 0;
                    }
                    if (rightCoordinate > OVERFLOW_SAMPLE_MAX - 1) {
                        rightCoordinate = OVERFLOW_SAMPLE_MAX - 1;
                    }
                    int n = rightCoordinate;
                    this.vectorDisplay[this.displayedNext].right[n] = this.vectorDisplay[this.displayedNext].right[n] + (float)intensity;
                }
                if (this.alg_curr_y < topStart) {
                    int topCoordinate = (int)(this.alg_curr_x / (double)this.config.ALG_MAX_X * (double)OVERFLOW_SAMPLE_MAX);
                    if (topCoordinate < 0) {
                        topCoordinate = 0;
                    }
                    if (topCoordinate > OVERFLOW_SAMPLE_MAX - 1) {
                        topCoordinate = OVERFLOW_SAMPLE_MAX - 1;
                    }
                    int n = topCoordinate;
                    this.vectorDisplay[this.displayedNext].top[n] = this.vectorDisplay[this.displayedNext].top[n] + (float)intensity;
                }
                if (this.alg_curr_y > bottomStart) {
                    int bottomCoordinate = (int)(this.alg_curr_x / (double)this.config.ALG_MAX_X * (double)OVERFLOW_SAMPLE_MAX);
                    if (bottomCoordinate < 0) {
                        bottomCoordinate = 0;
                    }
                    if (bottomCoordinate > OVERFLOW_SAMPLE_MAX - 1) {
                        bottomCoordinate = OVERFLOW_SAMPLE_MAX - 1;
                    }
                    int n = bottomCoordinate;
                    this.vectorDisplay[this.displayedNext].bottom[n] = this.vectorDisplay[this.displayedNext].bottom[n] + (float)intensity;
                }
            }
        }
        if (this.config.useRayGun) {
            if (this.alg_oldBlank != 0) {
                int dwell = Math.max(Math.abs(sig_dx), Math.abs(sig_dy));
                this.displayer.rayMove((int)this.alg_old_x, (int)this.alg_old_y, (int)this.alg_curr_x, (int)this.alg_curr_y, this.alg_oldzsh, dwell, this.alg_curved, this.alg_vector_speed, this.alg_leftEye, this.alg_rightEye);
            }
            this.alg_oldRamp = this.sig_ramp.intValue;
            this.alg_oldZero = this.sig_zero.intValue;
            this.alg_oldBlank = this.sig_blank.intValue;
            this.alg_oldzsh = this.alg_zsh.intValue;
            this.alg_old_x = this.alg_curr_x;
            this.alg_old_y = this.alg_curr_y;
        }
        if (this.sig_ramp.intValue != 0 || this.sig_blank.intValue == 0) {
            this.alg_curved = false;
        }
        if (Double.isNaN(this.alg_curr_x)) {
            this.alg_curr_x = this.config.ALG_MAX_X / 2;
        }
        if (Double.isNaN(this.alg_curr_y)) {
            this.alg_curr_y = this.config.ALG_MAX_Y / 2;
        }
    }

    void analogStep() {
        double currentSinPosMathY;
        double currentSinPosMathX;
        float currentSinPos;
        int sinOffsetY;
        int sinOffsetX;
        boolean rampStartCheck;
        boolean inLimits;
        boolean imagerColorChanged;
        boolean xChanged;
        boolean yChanged;
        int sinOffset;
        if (this.config.vectrexColorMode) {
            this.analogStepColor();
            return;
        }
        int inverseBrightness = 0;
        if (this.config.brightness > 75) {
            inverseBrightness = this.config.brightness - 75;
        }
        this.c_alg_rsh.doDischargeStep();
        if ((this.via_orb & 1) == 0 && (this.alg_sel.intValue & 6) == 2) {
            this.c_alg_rsh.doStep();
        }
        ++this.intensityDrift;
        int sig_dx = 0;
        int sig_dy = 0;
        if (this.lastZero != this.sig_zero.intValue) {
            if (this.sig_zero.intValue == 0) {
                this.startZero = true;
                this.wayToZero = 0;
                this.retainChanged = true;
                this.oldzeroRetainX = this.zeroRetainX;
                this.oldzeroRetainY = this.zeroRetainY;
                this.zeroRetainX = (this.alg_curr_x - (double)(this.config.ALG_MAX_X / 2)) * this.config.zeroRetainX;
                this.zeroRetainY = (this.alg_curr_y - (double)(this.config.ALG_MAX_Y / 2)) * this.config.zeroRetainY;
            }
            this.lastZero = this.sig_zero.intValue;
        } else if (this.sig_zero.intValue == 0) {
            this.zeroRetainX *= 0.99;
            this.zeroRetainY *= 0.99;
        }
        if (this.sig_zero.intValue == 0) {
            ++this.wayToZero;
            this.noiseCycles = this.cyclesRunning;
            int t = 1;
            int MAX_X = this.config.ALG_MAX_X;
            int MAX_Y = this.config.ALG_MAX_Y;
            int absx = (int)Math.abs(this.alg_curr_x - (double)(this.config.ALG_MAX_X / 2));
            int absy = (int)Math.abs(this.alg_curr_y - (double)(this.config.ALG_MAX_Y / 2));
            if (this.wayToZero == 1) {
                if (this.alg_curr_x - (double)(this.config.ALG_MAX_X / 2) < 0.0) {
                    absx = -absx;
                }
                if (this.alg_curr_x - (double)(this.config.ALG_MAX_X / 2) < 0.0) {
                    absy = -absy;
                }
                this.startAdjustX = absx;
                this.startAdjustY = absy;
            }
            int adjustX = t * (this.startAdjustX / 15) / this.wayToZero;
            int adjustY = t * (this.startAdjustY / 15) / this.wayToZero;
            sig_dx = adjustX + (int)((double)(MAX_X / 2 - (int)this.alg_curr_x) / this.config.zero_divider);
            sig_dy = adjustY + (int)((double)(MAX_Y / 2 - (int)this.alg_curr_y) / this.config.zero_divider);
        } else {
            this.startZero = false;
        }
        if (this.sig_ramp.intValue == 0) {
            sig_dx += this.alg_xsh.intValue;
            sig_dy += -this.alg_ysh.intValue;
            this.fractionSaveX = this.alg_xsh.intValue;
            this.fractionSaveY = this.alg_ysh.intValue;
            if (this.rampOnFraction) {
                this.rampOnFraction = false;
                this.alg_curr_x -= (double)((int)((double)this.alg_xsh.intValue * this.config.rampOnFractionValue));
                this.alg_curr_y -= (double)(-((int)((double)this.alg_ysh.intValue * this.config.rampOnFractionValue)));
            }
        } else if (this.rampOffFraction) {
            this.rampOffFraction = false;
            this.alg_curr_x += (double)((int)((double)this.fractionSaveX * this.config.rampOffFractionValue));
            this.alg_curr_y += (double)(-((int)((double)this.fractionSaveY * this.config.rampOffFractionValue)));
            if (this.alg_vectoring == 1 && this.alg_curr_x >= 0.0 && this.alg_curr_x < (double)this.config.ALG_MAX_X && this.alg_curr_y >= 0.0 && this.alg_curr_y < (double)this.config.ALG_MAX_Y) {
                this.alg_vector_x1 = (int)this.alg_curr_x;
                this.alg_vector_y1 = (int)this.alg_curr_y;
            }
        }
        if (this.alg_vectoring == 0) {
            if (this.sig_blank.intValue == 1 && (this.alg_zsh.intValue & 0x80) == 0 && (this.alg_zsh.intValue & 0x7F) != 0 && this.alg_curr_x >= 0.0 && this.alg_curr_x < (double)this.config.ALG_MAX_X && this.alg_curr_y >= 0.0 && this.alg_curr_y < (double)this.config.ALG_MAX_Y) {
                if (this.imagerMode && this.joyport[1].getDevice() instanceof Imager3dDevice) {
                    Imager3dDevice i3d = (Imager3dDevice)this.joyport[1].getDevice();
                    this.leftEyeColor = i3d.getLeftColor();
                    this.rightEyeColor = i3d.getRightColor();
                }
                this.alg_vectoring = 1;
                this.alg_vector_dx = this.alg_xsh.intValue;
                this.alg_vector_dy = -this.alg_ysh.intValue;
                sinOffset = 0;
                if (this.config.enableWobble) {
                    float currentSinPos2 = this.cyclesRunning % (long)this.config.cycle_sin_freq;
                    double currentSinPosMath = (double)(currentSinPos2 / (float)this.config.cycle_sin_freq * 2.0f) * Math.PI;
                    sinOffset = (int)((double)this.config.MAX_SIN_POSITION_OFFSET * Math.sin(currentSinPosMath));
                }
                this.alg_vector_x0 = (int)this.alg_curr_x + (int)(this.config.blankOffDelay * (double)this.alg_vector_dx) + sinOffset;
                this.alg_vector_y0 = (int)this.alg_curr_y + (int)(this.config.blankOffDelay * (double)this.alg_vector_dy) + sinOffset;
                this.alg_vector_x1 = (int)this.alg_curr_x;
                this.alg_vector_y1 = (int)this.alg_curr_y;
                this.alg_vector_speed = Math.max(Math.abs(this.alg_xsh.intValue), Math.abs(this.alg_ysh.intValue));
                this.alg_leftEye = this.leftEyeColor;
                this.alg_rightEye = this.rightEyeColor;
                this.alg_vector_color = this.alg_zsh.intValue;
                boolean bl = this.alg_ramping = this.sig_ramp.intValue == 0;
                if (this.alg_ramping || this.sig_zero.intValue == 0) {
                    this.alg_spline_compare_dx = sig_dx;
                    this.alg_spline_compare_dy = sig_dy;
                } else {
                    this.alg_spline_compare_dx = Integer.MAX_VALUE;
                    this.alg_spline_compare_dy = Integer.MAX_VALUE;
                }
            }
        } else {
            if (this.imagerMode && this.joyport[1].getDevice() instanceof Imager3dDevice) {
                Imager3dDevice i3d = (Imager3dDevice)this.joyport[1].getDevice();
                this.leftEyeColor = i3d.getLeftColor();
                this.rightEyeColor = i3d.getRightColor();
            }
            yChanged = -this.alg_ysh.intValue != this.alg_vector_dy && this.sig_ramp.intValue == 0;
            xChanged = this.alg_xsh.intValue != this.alg_vector_dx && this.sig_ramp.intValue == 0;
            boolean bl = imagerColorChanged = this.imagerMode && (this.leftEyeColor != this.alg_leftEye || this.rightEyeColor != this.alg_rightEye);
            if (this.sig_blank.intValue == 0 || (this.alg_zsh.intValue & 0x80) != 0 || (this.alg_zsh.intValue & 0x7F) == 0) {
                if (this.sig_blank.intValue == 0) {
                    this.alg_addline((int)((double)this.alg_vector_x0 + this.zeroRetainX), (int)((double)this.alg_vector_y0 + this.zeroRetainY), this.alg_vector_x1 + (int)(this.config.blankOnDelay * (double)this.alg_vector_dx + this.zeroRetainX), this.alg_vector_y1 + (int)(this.config.blankOnDelay * (double)this.alg_vector_dy + this.zeroRetainY), this.alg_zsh.intValue, this.alg_curved, this.alg_vector_speed, this.alg_leftEye, this.alg_rightEye);
                    this.retainChanged = false;
                } else {
                    this.alg_addline((int)((double)this.alg_vector_x0 + this.zeroRetainX), (int)((double)this.alg_vector_y0 + this.zeroRetainY), (int)((double)this.alg_vector_x1 + this.zeroRetainX), (int)((double)this.alg_vector_y1 + this.zeroRetainY), this.alg_zsh.intValue, this.alg_curved, this.alg_vector_speed, this.alg_leftEye, this.alg_rightEye);
                    this.retainChanged = false;
                }
                this.alg_vectoring = 0;
            } else if (imagerColorChanged || xChanged || yChanged || this.alg_zsh.intValue != this.alg_vector_color) {
                boolean bl2 = inLimits = this.alg_curr_x >= 0.0 && this.alg_curr_x < (double)this.config.ALG_MAX_X && this.alg_curr_y >= 0.0 && this.alg_curr_y < (double)this.config.ALG_MAX_Y;
                if ((this.alg_ramping || this.sig_zero.intValue == 0) && (sig_dx != this.alg_spline_compare_dx || sig_dy != this.alg_spline_compare_dy) && inLimits && sig_dy != 0) {
                    this.alg_curved = true;
                }
                boolean bl3 = rampStartCheck = !this.alg_ramping && this.sig_ramp.intValue == 0;
                if (!rampStartCheck) {
                    this.alg_addline((int)((double)this.alg_vector_x0 + this.zeroRetainX), (int)((double)this.alg_vector_y0 + this.zeroRetainY), (int)((double)this.alg_vector_x1 + this.zeroRetainX), (int)((double)this.alg_vector_y1 + this.zeroRetainY), this.alg_zsh.intValue, this.alg_curved, this.alg_vector_speed, this.alg_leftEye, this.alg_rightEye);
                    this.retainChanged = false;
                }
                if (inLimits) {
                    sinOffsetX = 0;
                    sinOffsetY = 0;
                    if (this.config.enableWobble) {
                        currentSinPos = this.cyclesRunning % (long)this.config.cycle_sin_freq;
                        currentSinPosMathX = (double)(currentSinPos / (float)this.config.cycle_sin_freq * 2.0f) * Math.PI;
                        currentSinPosMathY = (double)((currentSinPos + (float)this.config.yOffsetToX) % (float)this.config.cycle_sin_freq / (float)this.config.cycle_sin_freq * 2.0f) * Math.PI;
                        sinOffsetX = (int)((double)this.config.MAX_SIN_POSITION_OFFSET * Math.sin(currentSinPosMathX));
                        sinOffsetY = (int)((double)this.config.MAX_SIN_POSITION_OFFSET * Math.sin(currentSinPosMathY));
                        sinOffsetX = (int)((double)this.config.MAX_SIN_POSITION_OFFSET * Math.sin(currentSinPosMathX) * Math.cos(this.config.constantC * currentSinPosMathX));
                        sinOffsetY = (int)((double)this.config.MAX_SIN_POSITION_OFFSET * Math.sin(currentSinPosMathY) * Math.cos(this.config.constantC * currentSinPosMathY));
                    }
                    this.alg_vector_x0 = (int)this.alg_curr_x + sinOffsetX;
                    this.alg_vector_y0 = (int)this.alg_curr_y + sinOffsetY;
                    this.alg_vector_x1 = (int)this.alg_curr_x;
                    this.alg_vector_y1 = (int)this.alg_curr_y;
                    if (this.sig_ramp.intValue == 0) {
                        this.alg_vector_dx = this.alg_xsh.intValue;
                        this.alg_vector_dy = -this.alg_ysh.intValue;
                    } else {
                        this.alg_vector_dx = 0;
                        this.alg_vector_dy = 0;
                        this.alg_curved = false;
                    }
                    this.alg_vector_color = this.alg_zsh.intValue;
                    this.alg_leftEye = this.leftEyeColor;
                    this.alg_rightEye = this.rightEyeColor;
                    this.alg_vector_speed = Math.max(Math.abs(this.alg_xsh.intValue), Math.abs(this.alg_ysh.intValue));
                    boolean bl4 = this.alg_ramping = this.sig_ramp.intValue == 0;
                    if (this.alg_ramping || this.sig_zero.intValue == 0) {
                        this.alg_spline_compare_dx = sig_dx;
                        this.alg_spline_compare_dy = sig_dy;
                    } else {
                        this.alg_spline_compare_dx = Integer.MAX_VALUE;
                        this.alg_spline_compare_dy = Integer.MAX_VALUE;
                    }
                } else {
                    this.alg_vectoring = 0;
                }
            } else if (sig_dx == 0 && sig_dy == 0) {
                if (this.alg_vector_speed < 128) {
                    this.alg_vector_speed = 128;
                }
                this.alg_vector_speed += 4;
            }
        }
        if (inverseBrightness > 0) {
            if (this.ialg_vectoring == 0) {
                if ((this.sig_blank.intValue == 0 || (this.alg_zsh.intValue & 0x80) == 128 || (this.alg_zsh.intValue & 0x7F) == 0) && this.alg_curr_x >= -20000.0 && this.alg_curr_x < (double)(this.config.ALG_MAX_X + 20000) && this.alg_curr_y >= -20000.0 && this.alg_curr_y < (double)(this.config.ALG_MAX_Y + 20000)) {
                    if (this.imagerMode && this.joyport[1].getDevice() instanceof Imager3dDevice) {
                        Imager3dDevice i3d = (Imager3dDevice)this.joyport[1].getDevice();
                        this.leftEyeColor = i3d.getLeftColor();
                        this.rightEyeColor = i3d.getRightColor();
                    }
                    this.ialg_vectoring = 1;
                    this.ialg_vector_dx = this.alg_xsh.intValue;
                    this.ialg_vector_dy = -this.alg_ysh.intValue;
                    sinOffset = 0;
                    if (this.config.enableWobble) {
                        float currentSinPos3 = this.cyclesRunning % (long)this.config.cycle_sin_freq;
                        double currentSinPosMath = (double)(currentSinPos3 / (float)this.config.cycle_sin_freq * 2.0f) * Math.PI;
                        sinOffset = (int)((double)this.config.MAX_SIN_POSITION_OFFSET * Math.sin(currentSinPosMath));
                    }
                    this.ialg_vector_x0 = (int)this.alg_curr_x + (int)(this.config.blankOffDelay * (double)this.ialg_vector_dx) + sinOffset;
                    this.ialg_vector_y0 = (int)this.alg_curr_y + (int)(this.config.blankOffDelay * (double)this.ialg_vector_dy) + sinOffset;
                    this.ialg_vector_x1 = (int)this.alg_curr_x;
                    this.ialg_vector_y1 = (int)this.alg_curr_y;
                    this.ialg_vector_speed = Math.max(Math.abs(this.alg_xsh.intValue), Math.abs(this.alg_ysh.intValue));
                    this.ialg_leftEye = this.leftEyeColor;
                    this.ialg_rightEye = this.rightEyeColor;
                    this.ialg_vector_color = this.alg_zsh.intValue;
                    boolean bl = this.ialg_ramping = this.sig_ramp.intValue == 0;
                    if (this.ialg_ramping || this.sig_zero.intValue == 0) {
                        this.ialg_spline_compare_dx = sig_dx;
                        this.ialg_spline_compare_dy = sig_dy;
                    } else {
                        this.ialg_spline_compare_dx = Integer.MAX_VALUE;
                        this.ialg_spline_compare_dy = Integer.MAX_VALUE;
                    }
                }
            } else {
                if (this.imagerMode && this.joyport[1].getDevice() instanceof Imager3dDevice) {
                    Imager3dDevice i3d = (Imager3dDevice)this.joyport[1].getDevice();
                    this.leftEyeColor = i3d.getLeftColor();
                    this.rightEyeColor = i3d.getRightColor();
                }
                yChanged = -this.alg_ysh.intValue != this.ialg_vector_dy && this.sig_ramp.intValue == 0;
                xChanged = this.alg_xsh.intValue != this.ialg_vector_dx && this.sig_ramp.intValue == 0;
                boolean bl = imagerColorChanged = this.imagerMode && (this.leftEyeColor != this.alg_leftEye || this.rightEyeColor != this.alg_rightEye);
                if (this.sig_zero.intValue == 0 || this.sig_blank.intValue == 0) {
                    yChanged = true;
                    xChanged = true;
                }
                if (this.sig_blank.intValue == 1 && (this.alg_zsh.intValue & 0x80) == 0 && (this.alg_zsh.intValue & 0x7F) != 0) {
                    int tspeed;
                    if (this.sig_blank.intValue == 1) {
                        this.doDriftLine();
                        if (inverseBrightness > 0) {
                            this.noLineChange = true;
                            this.ialg_curved = true;
                            tspeed = 10;
                            if (this.retainChanged && ((int)((double)this.ialg_vector_x0 + this.zeroRetainX) != this.x1Old || (int)((double)this.ialg_vector_y0 + this.zeroRetainY) != this.y1Old)) {
                                this.alg_addline(this.x1Old, this.y1Old, (int)((double)this.ialg_vector_x0 + this.zeroRetainX), (int)((double)this.ialg_vector_y0 + this.zeroRetainY), inverseBrightness, this.ialg_curved, tspeed, this.ialg_leftEye, this.ialg_rightEye);
                            }
                            this.retainChanged = false;
                            if ((int)((double)this.ialg_vector_x0 + this.zeroRetainX) != this.x0Old || (int)((double)this.ialg_vector_y0 + this.zeroRetainY) != this.y0Old || (int)((double)this.ialg_vector_x1 + this.zeroRetainX) != this.x1Old || (int)((double)this.ialg_vector_y1 + this.zeroRetainY) != this.y1Old) {
                                this.alg_addline((int)((double)this.ialg_vector_x0 + this.zeroRetainX), (int)((double)this.ialg_vector_y0 + this.zeroRetainY), (int)((double)this.ialg_vector_x1 + this.zeroRetainX), (int)((double)this.ialg_vector_y1 + this.zeroRetainY), inverseBrightness, this.ialg_curved, tspeed, this.ialg_leftEye, this.ialg_rightEye);
                                this.x0Old = (int)((double)this.ialg_vector_x0 + this.zeroRetainX);
                                this.y0Old = (int)((double)this.ialg_vector_y0 + this.zeroRetainY);
                                this.x1Old = (int)((double)this.ialg_vector_x1 + this.zeroRetainX);
                                this.y1Old = (int)((double)this.ialg_vector_y1 + this.zeroRetainY);
                                this.noLineChange = false;
                            }
                        }
                        this.ialg_vectoring = 0;
                    } else {
                        this.doDriftLine();
                        if (inverseBrightness > 0) {
                            this.noLineChange = true;
                            this.ialg_curved = true;
                            tspeed = 10;
                            if (this.retainChanged && ((int)((double)this.ialg_vector_x0 + this.zeroRetainX) != this.x1Old || (int)((double)this.ialg_vector_y0 + this.zeroRetainY) != this.y1Old)) {
                                this.alg_addline(this.x1Old, this.y1Old, (int)((double)this.ialg_vector_x0 + this.zeroRetainX), (int)((double)this.ialg_vector_y0 + this.zeroRetainY), inverseBrightness, this.ialg_curved, tspeed, this.ialg_leftEye, this.ialg_rightEye);
                            }
                            this.retainChanged = false;
                            if ((int)((double)this.ialg_vector_x0 + this.zeroRetainX) != this.x0Old || (int)((double)this.ialg_vector_y0 + this.zeroRetainY) != this.y0Old || (int)((double)this.ialg_vector_x1 + this.zeroRetainX) != this.x1Old || (int)((double)this.ialg_vector_y1 + this.zeroRetainY) != this.y1Old) {
                                this.alg_addline((int)((double)this.ialg_vector_x0 + this.zeroRetainX), (int)((double)this.ialg_vector_y0 + this.zeroRetainY), (int)((double)this.ialg_vector_x1 + this.zeroRetainX), (int)((double)this.ialg_vector_y1 + this.zeroRetainY), inverseBrightness, this.ialg_curved, tspeed, this.ialg_leftEye, this.ialg_rightEye);
                                this.x0Old = (int)((double)this.ialg_vector_x0 + this.zeroRetainX);
                                this.y0Old = (int)((double)this.ialg_vector_y0 + this.zeroRetainY);
                                this.x1Old = (int)((double)this.ialg_vector_x1 + this.zeroRetainX);
                                this.y1Old = (int)((double)this.ialg_vector_y1 + this.zeroRetainY);
                                this.noLineChange = false;
                            }
                        }
                        boolean bl5 = inLimits = this.alg_curr_x >= -20000.0 && this.alg_curr_x < (double)(this.config.ALG_MAX_X + 20000) && this.alg_curr_y >= -20000.0 && this.alg_curr_y < (double)(this.config.ALG_MAX_Y + 20000);
                        if (inLimits) {
                            int sinOffsetX2 = 0;
                            int sinOffsetY2 = 0;
                            if (this.config.enableWobble) {
                                float currentSinPos4 = this.cyclesRunning % (long)this.config.cycle_sin_freq;
                                double currentSinPosMathX2 = (double)(currentSinPos4 / (float)this.config.cycle_sin_freq * 2.0f) * Math.PI;
                                double currentSinPosMathY2 = (double)((currentSinPos4 + (float)this.config.yOffsetToX) % (float)this.config.cycle_sin_freq / (float)this.config.cycle_sin_freq * 2.0f) * Math.PI;
                                sinOffsetX2 = (int)((double)this.config.MAX_SIN_POSITION_OFFSET * Math.sin(currentSinPosMathX2));
                                sinOffsetY2 = (int)((double)this.config.MAX_SIN_POSITION_OFFSET * Math.sin(currentSinPosMathY2));
                                sinOffsetX2 = (int)((double)this.config.MAX_SIN_POSITION_OFFSET * Math.sin(currentSinPosMathX2) * Math.cos(this.config.constantC * currentSinPosMathX2));
                                sinOffsetY2 = (int)((double)this.config.MAX_SIN_POSITION_OFFSET * Math.sin(currentSinPosMathY2) * Math.cos(this.config.constantC * currentSinPosMathY2));
                            }
                            this.ialg_vector_x0 = (int)this.alg_curr_x + sinOffsetX2;
                            this.ialg_vector_y0 = (int)this.alg_curr_y + sinOffsetY2;
                            this.ialg_vector_x1 = this.ialg_vector_x0;
                            this.ialg_vector_y1 = this.ialg_vector_y0;
                            if (this.sig_ramp.intValue == 0) {
                                this.ialg_vector_dx = this.alg_xsh.intValue;
                                this.ialg_vector_dy = -this.alg_ysh.intValue;
                            } else {
                                this.ialg_vector_dx = 0;
                                this.ialg_vector_dy = 0;
                                this.ialg_curved = false;
                            }
                            this.ialg_vector_color = this.alg_zsh.intValue;
                            this.ialg_leftEye = this.leftEyeColor;
                            this.ialg_rightEye = this.rightEyeColor;
                            this.ialg_vector_speed = Math.max(Math.abs(this.alg_xsh.intValue), Math.abs(this.alg_ysh.intValue));
                            boolean bl6 = this.ialg_ramping = this.sig_ramp.intValue == 0;
                            if (this.ialg_ramping || this.sig_zero.intValue == 0) {
                                this.ialg_spline_compare_dx = sig_dx;
                                this.ialg_spline_compare_dy = sig_dy;
                            } else {
                                this.ialg_spline_compare_dx = Integer.MAX_VALUE;
                                this.ialg_spline_compare_dy = Integer.MAX_VALUE;
                            }
                            this.ialg_vectoring = 1;
                        } else {
                            this.ialg_vectoring = 0;
                        }
                    }
                } else if (imagerColorChanged || xChanged || yChanged || this.alg_zsh.intValue != this.ialg_vector_color || this.sig_ramp.intValue == 0 != this.ialg_ramping) {
                    boolean bl7 = inLimits = this.alg_curr_x >= -20000.0 && this.alg_curr_x < (double)(this.config.ALG_MAX_X + 20000) && this.alg_curr_y >= -20000.0 && this.alg_curr_y < (double)(this.config.ALG_MAX_Y + 20000);
                    if ((this.ialg_ramping || this.sig_zero.intValue == 0) && (sig_dx != this.ialg_spline_compare_dx || sig_dy != this.ialg_spline_compare_dy) && inLimits && sig_dy != 0) {
                        this.ialg_curved = true;
                    }
                    boolean bl8 = rampStartCheck = !this.ialg_ramping && this.sig_ramp.intValue == 0;
                    if (!rampStartCheck) {
                        this.doDriftLine();
                        if (inverseBrightness > 0) {
                            this.noLineChange = true;
                            this.ialg_curved = true;
                            int tspeed = 10;
                            if (this.retainChanged && ((int)((double)this.ialg_vector_x0 + this.zeroRetainX) != this.x1Old || (int)((double)this.ialg_vector_y0 + this.zeroRetainY) != this.y1Old)) {
                                this.alg_addline(this.x1Old, this.y1Old, (int)((double)this.ialg_vector_x0 + this.zeroRetainX), (int)((double)this.ialg_vector_y0 + this.zeroRetainY), inverseBrightness, this.ialg_curved, tspeed, this.ialg_leftEye, this.ialg_rightEye);
                            }
                            this.retainChanged = false;
                            if ((int)((double)this.ialg_vector_x0 + this.zeroRetainX) != this.x0Old || (int)((double)this.ialg_vector_y0 + this.zeroRetainY) != this.y0Old || (int)((double)this.ialg_vector_x1 + this.zeroRetainX) != this.x1Old || (int)((double)this.ialg_vector_y1 + this.zeroRetainY) != this.y1Old) {
                                this.alg_addline((int)((double)this.ialg_vector_x0 + this.zeroRetainX), (int)((double)this.ialg_vector_y0 + this.zeroRetainY), (int)((double)this.ialg_vector_x1 + this.zeroRetainX), (int)((double)this.ialg_vector_y1 + this.zeroRetainY), inverseBrightness, this.ialg_curved, tspeed, this.ialg_leftEye, this.ialg_rightEye);
                                this.x0Old = (int)((double)this.ialg_vector_x0 + this.zeroRetainX);
                                this.y0Old = (int)((double)this.ialg_vector_y0 + this.zeroRetainY);
                                this.x1Old = (int)((double)this.ialg_vector_x1 + this.zeroRetainX);
                                this.y1Old = (int)((double)this.ialg_vector_y1 + this.zeroRetainY);
                                this.noLineChange = false;
                            }
                        }
                    }
                    if (inLimits) {
                        sinOffsetX = 0;
                        sinOffsetY = 0;
                        if (this.config.enableWobble) {
                            currentSinPos = this.cyclesRunning % (long)this.config.cycle_sin_freq;
                            currentSinPosMathX = (double)(currentSinPos / (float)this.config.cycle_sin_freq * 2.0f) * Math.PI;
                            currentSinPosMathY = (double)((currentSinPos + (float)this.config.yOffsetToX) % (float)this.config.cycle_sin_freq / (float)this.config.cycle_sin_freq * 2.0f) * Math.PI;
                            sinOffsetX = (int)((double)this.config.MAX_SIN_POSITION_OFFSET * Math.sin(currentSinPosMathX));
                            sinOffsetY = (int)((double)this.config.MAX_SIN_POSITION_OFFSET * Math.sin(currentSinPosMathY));
                            sinOffsetX = (int)((double)this.config.MAX_SIN_POSITION_OFFSET * Math.sin(currentSinPosMathX) * Math.cos(this.config.constantC * currentSinPosMathX));
                            sinOffsetY = (int)((double)this.config.MAX_SIN_POSITION_OFFSET * Math.sin(currentSinPosMathY) * Math.cos(this.config.constantC * currentSinPosMathY));
                        }
                        this.ialg_vector_x0 = (int)this.alg_curr_x + sinOffsetX;
                        this.ialg_vector_y0 = (int)this.alg_curr_y + sinOffsetY;
                        this.ialg_vector_x1 = (int)this.alg_curr_x;
                        this.ialg_vector_y1 = (int)this.alg_curr_y;
                        if (this.sig_ramp.intValue == 0) {
                            this.ialg_vector_dx = this.alg_xsh.intValue;
                            this.ialg_vector_dy = -this.alg_ysh.intValue;
                        } else {
                            this.ialg_vector_dx = 0;
                            this.ialg_vector_dy = 0;
                            this.ialg_curved = false;
                        }
                        this.ialg_vector_color = this.alg_zsh.intValue;
                        this.ialg_leftEye = this.leftEyeColor;
                        this.ialg_rightEye = this.rightEyeColor;
                        this.ialg_vector_speed = Math.max(Math.abs(this.alg_xsh.intValue), Math.abs(this.alg_ysh.intValue));
                        boolean bl9 = this.ialg_ramping = this.sig_ramp.intValue == 0;
                        if (this.ialg_ramping || this.sig_zero.intValue == 0) {
                            this.ialg_spline_compare_dx = sig_dx;
                            this.ialg_spline_compare_dy = sig_dy;
                        } else {
                            this.ialg_spline_compare_dx = Integer.MAX_VALUE;
                            this.ialg_spline_compare_dy = Integer.MAX_VALUE;
                        }
                    } else {
                        this.ialg_vectoring = 0;
                    }
                } else if (sig_dx == 0 && sig_dy == 0) {
                    if (this.ialg_vector_speed < 128) {
                        this.ialg_vector_speed = 128;
                    }
                    this.ialg_vector_speed += 4;
                }
            }
        }
        if (this.config.efficiencyEnabled && this.sig_zero.intValue != 0) {
            double EFFICIENCY_THRESHOLD_X = this.config.efficiencyThresholdX;
            double EFFICIENCY_THRESHOLD_Y = this.config.efficiencyThresholdY;
            double xTest = this.alg_curr_x - (double)(this.config.ALG_MAX_X / 2);
            double yTest = this.alg_curr_y - (double)(this.config.ALG_MAX_Y / 2);
            double xPercent = Math.abs(xTest / (double)(this.config.ALG_MAX_X / 2));
            double yPercent = Math.abs(yTest / (double)(this.config.ALG_MAX_Y / 2));
            double xEfficience = 1.0;
            double yEfficience = 1.0;
            if (xPercent > EFFICIENCY_THRESHOLD_X) {
                xEfficience = 1.0 - xPercent / this.config.efficiency * (xPercent - EFFICIENCY_THRESHOLD_X / EFFICIENCY_THRESHOLD_X);
                if (xEfficience < 0.01) {
                    xEfficience = 0.01;
                }
                if (xTest * (double)sig_dx < 0.0) {
                    xEfficience = 1.0 / xEfficience;
                }
            }
            if (yPercent > EFFICIENCY_THRESHOLD_Y) {
                yEfficience = 1.0 - yPercent / this.config.efficiency * (yPercent - EFFICIENCY_THRESHOLD_Y / EFFICIENCY_THRESHOLD_Y);
                if (yEfficience < 0.01) {
                    yEfficience = 0.01;
                }
                if (yTest * (double)sig_dy < 0.0) {
                    yEfficience = 1.0 / yEfficience;
                }
            }
            if (sig_dx + 128 < 256 && sig_dy + 128 < 256 && sig_dx + 128 >= 0 && sig_dy + 128 >= 0) {
                this.alg_curr_x += (double)sig_dx * dacDeviation[sig_dx + 128] * xEfficience;
                this.alg_curr_y += (double)sig_dy * dacDeviation[sig_dy + 128] * yEfficience;
            } else {
                this.alg_curr_x += (double)sig_dx * xEfficience;
                this.alg_curr_y += (double)sig_dy * yEfficience;
            }
            if (sig_dx != 0) {
                this.alg_curr_x += VideConfig.scaleEfficiency / (double)sig_dx * xPercent;
            }
            if (sig_dy != 0) {
                this.alg_curr_y += VideConfig.scaleEfficiency / (double)sig_dy * yPercent;
            }
        } else if (sig_dx + 128 < 256 && sig_dy + 128 < 256 && sig_dx + 128 >= 0 && sig_dy + 128 >= 0) {
            this.alg_curr_x += (double)sig_dx * dacDeviation[sig_dx + 128];
            this.alg_curr_y += (double)sig_dy * dacDeviation[sig_dy + 128];
        } else {
            this.alg_curr_x += (double)sig_dx;
            this.alg_curr_y += (double)sig_dy;
        }
        this.alg_curr_x -= 2.0 * this.c_alg_rsh.getDigitalValue();
        this.alg_curr_y -= -2.0 * this.c_alg_rsh.getDigitalValue();
        if (this.alg_curr_x > 100000.0) {
            this.alg_curr_x = 100000.0;
        } else if (this.alg_curr_x < -100000.0) {
            this.alg_curr_x = -100000.0;
        }
        if (this.alg_curr_y > 100000.0) {
            this.alg_curr_y = 100000.0;
        } else if (this.alg_curr_y < -100000.0) {
            this.alg_curr_y = -100000.0;
        }
        if (this.sig_zero.intValue != 0) {
            if (this.sig_ramp.intValue != 0) {
                this.alg_curr_x -= this.config.drift_x;
                this.alg_curr_y -= this.config.drift_y;
                this.pureDriftY += this.config.drift_y;
                this.pureDriftX += this.config.drift_x;
            } else {
                this.alg_curr_x -= this.config.drift_x / 5.0;
                this.alg_curr_y -= this.config.drift_y / 5.0;
                this.pureDriftY += this.config.drift_y;
                this.pureDriftX += this.config.drift_x;
            }
        }
        if (this.config.emulateIntegrationOverflow && Math.abs(sig_dx) > 100) {
            double yOverflow = ((double)sig_dx + (double)sig_dy) / this.config.overflowFactor;
            this.alg_curr_y += yOverflow;
        }
        if (this.config.noise) {
            long running = this.cyclesRunning - this.noiseCycles;
            if (running > 2000L) {
                double xnoise = (0.5 - Global.getRand().nextDouble()) * this.config.noisefactor;
                double ynoise = (0.5 - Global.getRand().nextDouble()) * this.config.noisefactor;
                this.alg_curr_x -= xnoise / 10.0;
                this.alg_curr_y -= ynoise / 10.0;
            }
            if (running > 5000L) {
                double xnoise = (0.5 - Global.getRand().nextDouble()) * this.config.noisefactor;
                double ynoise = (0.5 - Global.getRand().nextDouble()) * this.config.noisefactor;
                this.alg_curr_x -= xnoise / 8.0;
                this.alg_curr_y -= ynoise / 8.0;
            }
            if (running > 10000L) {
                double xnoise = (0.5 - Global.getRand().nextDouble()) * this.config.noisefactor;
                double ynoise = (0.5 - Global.getRand().nextDouble()) * this.config.noisefactor;
                this.alg_curr_x -= xnoise / 5.0;
                this.alg_curr_y -= ynoise / 5.0;
            }
            if (running > 15000L) {
                double xnoise = (0.5 - Global.getRand().nextDouble()) * this.config.noisefactor;
                double ynoise = (0.5 - Global.getRand().nextDouble()) * this.config.noisefactor;
                this.alg_curr_x -= xnoise / 2.0;
                this.alg_curr_y -= ynoise / 2.0;
            }
            if (running > 25000L) {
                double xnoise = (0.5 - Global.getRand().nextDouble()) * this.config.noisefactor;
                double ynoise = (0.5 - Global.getRand().nextDouble()) * this.config.noisefactor;
                this.alg_curr_x -= xnoise;
                this.alg_curr_y -= ynoise;
            }
        }
        if (this.alg_vectoring == 1 && this.alg_curr_x >= 0.0 && this.alg_curr_x < (double)this.config.ALG_MAX_X && this.alg_curr_y >= 0.0 && this.alg_curr_y < (double)this.config.ALG_MAX_Y) {
            this.alg_vector_x1 = (int)this.alg_curr_x;
            this.alg_vector_y1 = (int)this.alg_curr_y;
        }
        if (inverseBrightness > 0 && this.ialg_vectoring == 1 && this.alg_curr_x >= -20000.0 && this.alg_curr_x < (double)(this.config.ALG_MAX_X + 20000) && this.alg_curr_y >= -20000.0 && this.alg_curr_y < (double)(this.config.ALG_MAX_Y + 20000)) {
            this.ialg_vector_x1 = (int)this.alg_curr_x;
            this.ialg_vector_y1 = (int)this.alg_curr_y;
        }
        if (this.config.emulateBorders) {
            boolean inLimits2;
            boolean bl = inLimits2 = this.alg_curr_x >= 0.0 && this.alg_curr_x < (double)this.config.ALG_MAX_X && this.alg_curr_y >= 0.0 && this.alg_curr_y < (double)this.config.ALG_MAX_Y;
            if (!inLimits2 && this.sig_blank.intValue == 1 && (this.alg_zsh.intValue & 0x80) == 0 && (this.alg_zsh.intValue & 0x7F) != 0) {
                int intensity = this.alg_zsh.intValue & 0x7F;
                if (this.intensityDrift > 100000L) {
                    double degradePercent = (1.8E8 - (double)this.intensityDrift) / 1.8E8;
                    if (degradePercent < 0.0) {
                        degradePercent = 0.0;
                    }
                    intensity = (int)((double)intensity * degradePercent);
                }
                int OFFSET_START_DIVISOR = 40;
                double leftStart = -this.config.ALG_MAX_X / OFFSET_START_DIVISOR;
                double rightStart = this.config.ALG_MAX_X + this.config.ALG_MAX_X / OFFSET_START_DIVISOR;
                double topStart = -this.config.ALG_MAX_Y / OFFSET_START_DIVISOR;
                double bottomStart = this.config.ALG_MAX_Y + this.config.ALG_MAX_Y / OFFSET_START_DIVISOR;
                if (this.alg_curr_x < leftStart) {
                    int leftCoordinate = (int)(this.alg_curr_y / (double)this.config.ALG_MAX_Y * (double)OVERFLOW_SAMPLE_MAX);
                    if (leftCoordinate < 0) {
                        leftCoordinate = 0;
                    }
                    if (leftCoordinate > OVERFLOW_SAMPLE_MAX - 1) {
                        leftCoordinate = OVERFLOW_SAMPLE_MAX - 1;
                    }
                    int n = leftCoordinate;
                    this.vectorDisplay[this.displayedNext].left[n] = this.vectorDisplay[this.displayedNext].left[n] + (float)intensity;
                }
                if (this.alg_curr_x > rightStart) {
                    int rightCoordinate = (int)(this.alg_curr_y / (double)this.config.ALG_MAX_Y * (double)OVERFLOW_SAMPLE_MAX);
                    if (rightCoordinate < 0) {
                        rightCoordinate = 0;
                    }
                    if (rightCoordinate > OVERFLOW_SAMPLE_MAX - 1) {
                        rightCoordinate = OVERFLOW_SAMPLE_MAX - 1;
                    }
                    int n = rightCoordinate;
                    this.vectorDisplay[this.displayedNext].right[n] = this.vectorDisplay[this.displayedNext].right[n] + (float)intensity;
                }
                if (this.alg_curr_y < topStart) {
                    int topCoordinate = (int)(this.alg_curr_x / (double)this.config.ALG_MAX_X * (double)OVERFLOW_SAMPLE_MAX);
                    if (topCoordinate < 0) {
                        topCoordinate = 0;
                    }
                    if (topCoordinate > OVERFLOW_SAMPLE_MAX - 1) {
                        topCoordinate = OVERFLOW_SAMPLE_MAX - 1;
                    }
                    int n = topCoordinate;
                    this.vectorDisplay[this.displayedNext].top[n] = this.vectorDisplay[this.displayedNext].top[n] + (float)intensity;
                }
                if (this.alg_curr_y > bottomStart) {
                    int bottomCoordinate = (int)(this.alg_curr_x / (double)this.config.ALG_MAX_X * (double)OVERFLOW_SAMPLE_MAX);
                    if (bottomCoordinate < 0) {
                        bottomCoordinate = 0;
                    }
                    if (bottomCoordinate > OVERFLOW_SAMPLE_MAX - 1) {
                        bottomCoordinate = OVERFLOW_SAMPLE_MAX - 1;
                    }
                    int n = bottomCoordinate;
                    this.vectorDisplay[this.displayedNext].bottom[n] = this.vectorDisplay[this.displayedNext].bottom[n] + (float)intensity;
                }
            }
        }
        if (this.config.useRayGun) {
            if (this.alg_oldBlank != 0) {
                int dwell = Math.max(Math.abs(sig_dx), Math.abs(sig_dy));
                this.displayer.rayMove((int)this.alg_old_x, (int)this.alg_old_y, (int)this.alg_curr_x, (int)this.alg_curr_y, this.alg_oldzsh, dwell, this.alg_curved, this.alg_vector_speed, this.alg_leftEye, this.alg_rightEye);
            }
            this.alg_oldRamp = this.sig_ramp.intValue;
            this.alg_oldZero = this.sig_zero.intValue;
            this.alg_oldBlank = this.sig_blank.intValue;
            this.alg_oldzsh = this.alg_zsh.intValue;
            this.alg_old_x = this.alg_curr_x;
            this.alg_old_y = this.alg_curr_y;
        }
        if (inverseBrightness > 0) {
            if (this.sig_ramp.intValue == 0) {
                this.doDriftLine();
            }
            if (this.sig_zero.intValue == 0) {
                this.doDriftLine();
            }
        }
        if (this.sig_ramp.intValue != 0 || this.sig_blank.intValue == 0) {
            this.alg_curved = false;
        }
        if (Double.isNaN(this.alg_curr_x)) {
            this.alg_curr_x = this.config.ALG_MAX_X / 2;
        }
        if (Double.isNaN(this.alg_curr_y)) {
            this.alg_curr_y = this.config.ALG_MAX_Y / 2;
        }
    }

    void doDriftLine() {
        int inverseBrightness = 0;
        if (this.config.brightness > 60) {
            inverseBrightness = this.config.brightness - 60;
        }
        if ((Math.abs(this.pureDriftY) > 100.0 || Math.abs(this.pureDriftX) > 100.0) && inverseBrightness > 0) {
            this.noLineChange = true;
            this.alg_addline((int)this.pureDriftXStart, (int)this.pureDriftYStart, (int)(this.pureDriftXStart - this.pureDriftX), (int)(this.pureDriftYStart - this.pureDriftY), inverseBrightness *= 3, false, 10, 0, 0);
            this.noLineChange = false;
        }
        this.pureDriftY = 0.0;
        this.pureDriftX = 0.0;
        this.pureDriftXStart = this.alg_curr_x;
        this.pureDriftYStart = this.alg_curr_y;
    }

    public void resetAllTimeLowStack() {
        this.e6809.lowestStackValue = this.e6809.reg_s.intValue;
        this.allTimeLow = this.e6809.reg_s.intValue;
    }

    public int getAllTimeLowStack() {
        return this.allTimeLow;
    }

    void checkWaitRecal() {
        if (this.e6809.reg_pc == this.testAddressFirst && (this.cart.getCurrentBank() == this.testBank || this.testAddressFirst > 49152)) {
            this.lastTestTicks = this.ticksRunning;
            this.wrStatus = 1;
            return;
        }
        if (this.e6809.reg_pc == this.testAddressSecond && (this.cart.getCurrentBank() == this.testBank || this.testAddressFirst > 49152) && this.wrStatus == 1) {
            int cycles;
            this.waitRecalBuffer[this.waitRecalBufferNext] = cycles = (int)((long)this.ticksRunning - this.lastTestTicks);
            this.waitRecalBufferNext = (this.waitRecalBufferNext + 1) % WAIT_RECAL_BUFFER_SIZE;
            this.wrStatus = 0;
            ++this.trackyCount;
            if (cycles > 30000) {
                ++this.trackyAbove;
            }
            if (this.allTimeLow > this.e6809.lowestStackValue) {
                this.allTimeLow = this.e6809.lowestStackValue;
            }
            this.e6809.lowestStackValue = this.e6809.reg_s.intValue;
            if (this.config.doProfile && this.profiler != null && this.profiler.trackingOnly) {
                this.profiler.trackPointReached();
            }
        }
    }

    void setTrackingAddress(int start, int end2, int bank2) {
        this.testAddressFirst = start;
        this.testAddressSecond = end2;
        this.testBank = bank2;
    }

    int getCurrentWaitRecalBufferPos() {
        return this.waitRecalBufferNext;
    }

    int[] getCurrentWaitRecalBuffer() {
        return this.waitRecalBuffer;
    }

    long getLastWaitRecalTest() {
        return this.lastTestTicks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkCPUBreakpoints(int cycles) {
        if (!this.config.breakpointsActive) {
            return;
        }
        ArrayList<Breakpoint> arrayList = this.breakpoints[Breakpoint.BP_TARGET_CPU];
        synchronized (arrayList) {
            for (Breakpoint bp : this.breakpoints[Breakpoint.BP_TARGET_CPU]) {
                if (bp == null || !bp.enabled) continue;
                if (bp.targetSubType == Breakpoint.BP_SUBTARGET_CPU_PC) {
                    if ((bp.type & Breakpoint.BP_COMPARE) == Breakpoint.BP_COMPARE) {
                        if (this.e6809.reg_pc == bp.targetAddress && this.cart.getCurrentBank() == bp.targetBank) {
                            if ((bp.type & Breakpoint.BP_ONCE) == Breakpoint.BP_ONCE) {
                                this.tmp.add(bp);
                            }
                            this.activeBreakpoint.add(bp);
                            if (this.breakpointExit < bp.exitType) {
                                this.breakpointExit = bp.exitType;
                            }
                        }
                    } else if ((bp.type & Breakpoint.BP_WEIRD) == Breakpoint.BP_WEIRD) {
                        if (this.cart != null) {
                            boolean isWeird;
                            boolean bl = isWeird = this.e6809.reg_pc > this.cart.getCurrentBankLength() && this.e6809.reg_pc < 57344;
                            if (isWeird) {
                                if ((bp.type & Breakpoint.BP_ONCE) == Breakpoint.BP_ONCE) {
                                    this.tmp.add(bp);
                                }
                                this.activeBreakpoint.add(bp);
                                if (this.breakpointExit < bp.exitType) {
                                    this.breakpointExit = bp.exitType;
                                }
                            }
                        }
                    } else if ((bp.type & Breakpoint.BP_INTEGRATOR) == Breakpoint.BP_INTEGRATOR && this.cart != null && this.e6809.reg_pc == bp.targetAddress && this.cart.getCurrentBank() == bp.targetBank) {
                        int difx = Math.abs((int)this.alg_curr_x - this.config.ALG_MAX_X / 2);
                        int dify = Math.abs((int)this.alg_curr_y - this.config.ALG_MAX_Y / 2);
                        if (difx > bp.compareValue || dify > bp.compareValue) {
                            if ((bp.type & Breakpoint.BP_ONCE) == Breakpoint.BP_ONCE) {
                                this.tmp.add(bp);
                            }
                            this.activeBreakpoint.add(bp);
                            if (this.breakpointExit < bp.exitType) {
                                this.breakpointExit = bp.exitType;
                            }
                        }
                    }
                }
                if (bp.targetSubType == Breakpoint.BP_SUBTARGET_CPU_CYCLES && (bp.type & Breakpoint.BP_COMPARE) == Breakpoint.BP_COMPARE) {
                    bp.compareValue -= cycles;
                    if (bp.compareValue <= 0) {
                        if ((bp.type & Breakpoint.BP_ONCE) == Breakpoint.BP_ONCE) {
                            this.tmp.add(bp);
                        }
                        this.activeBreakpoint.add(bp);
                        if (this.breakpointExit < bp.exitType) {
                            this.breakpointExit = bp.exitType;
                        }
                    }
                }
                if (bp.targetSubType == Breakpoint.BP_SUBTARGET_CPU_S && (bp.type & Breakpoint.BP_COMPARE) == Breakpoint.BP_COMPARE && this.e6809.reg_s.intValue <= bp.targetAddress) {
                    if ((bp.type & Breakpoint.BP_ONCE) == Breakpoint.BP_ONCE) {
                        this.tmp.add(bp);
                    }
                    this.activeBreakpoint.add(bp);
                    if (this.breakpointExit < bp.exitType) {
                        this.breakpointExit = bp.exitType;
                    }
                }
                if (bp.targetSubType == Breakpoint.BP_SUBTARGET_CPU_STACKCHANGE && this.e6809.reg_pc == bp.targetAddress && this.cart.getCurrentBank() == bp.targetBank && (bp.type & Breakpoint.BP_COMPARE) == Breakpoint.BP_COMPARE && this.e6809.reg_s.intValue != bp.compareValue) {
                    if ((bp.type & Breakpoint.BP_ONCE) == Breakpoint.BP_ONCE) {
                        this.tmp.add(bp);
                    }
                    this.activeBreakpoint.add(bp);
                    if (this.breakpointExit < bp.exitType) {
                        this.breakpointExit = bp.exitType;
                    }
                }
                if (bp.targetSubType != Breakpoint.BP_SUBTARGET_CPU_SPECIAL || (bp.type & Breakpoint.BP_COMPARE) != Breakpoint.BP_COMPARE || this.e6809.reg_pc != bp.targetAddress) continue;
                if (bp.compareValue != -1) {
                    bp.targetAddress = bp.compareValue;
                    bp.counter = this.ticksRunning;
                    bp.compareValue = -1;
                    continue;
                }
                bp.compareValue = (int)((long)this.ticksRunning - bp.counter);
                this.tmp.add(bp);
                this.activeBreakpoint.add(bp);
                if (this.breakpointExit >= bp.exitType) continue;
                this.breakpointExit = bp.exitType;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkROMBreakPoint(int address, int data2) {
        if (!this.config.breakpointsActive) {
            return;
        }
        ArrayList<Breakpoint> arrayList = this.breakpoints[Breakpoint.BP_TARGET_MEMORY];
        synchronized (arrayList) {
            for (Breakpoint bp : this.breakpoints[Breakpoint.BP_TARGET_MEMORY]) {
                if (!bp.enabled || (bp.type & Breakpoint.BP_WRITE) != Breakpoint.BP_WRITE || (bp.targetSubType & Breakpoint.BP_SUBTARGET_MEMORY_ROM) != Breakpoint.BP_SUBTARGET_MEMORY_ROM) continue;
                if ((bp.type & Breakpoint.BP_ONCE) == Breakpoint.BP_ONCE) {
                    this.tmp.add(bp);
                }
                this.activeBreakpoint.add(bp);
                if (this.breakpointExit >= bp.exitType) continue;
                this.breakpointExit = bp.exitType;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkMemWriteBreakpoint(int address, int data2) {
        if (!this.config.breakpointsActive) {
            return;
        }
        ArrayList<Breakpoint> arrayList = this.breakpoints[Breakpoint.BP_TARGET_MEMORY];
        synchronized (arrayList) {
            for (Breakpoint bp : this.breakpoints[Breakpoint.BP_TARGET_MEMORY]) {
                if (!bp.enabled || (bp.type & Breakpoint.BP_WRITE) != Breakpoint.BP_WRITE || (address & 0xFFFF) != bp.targetAddress || this.cart.getCurrentBank() != bp.targetBank && bp.targetBank != -1 || (bp.type & Breakpoint.BP_COMPARE) == Breakpoint.BP_COMPARE && bp.compareValue != (data2 & 0xFF)) continue;
                if ((bp.type & Breakpoint.BP_ONCE) == Breakpoint.BP_ONCE) {
                    this.tmp.add(bp);
                }
                this.activeBreakpoint.add(bp);
                if (this.breakpointExit >= bp.exitType) continue;
                this.breakpointExit = bp.exitType;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkMemReadBreakpoint(int address) {
        if (!this.config.breakpointsActive) {
            return;
        }
        ArrayList<Breakpoint> arrayList = this.breakpoints[Breakpoint.BP_TARGET_MEMORY];
        synchronized (arrayList) {
            for (Breakpoint bp : this.breakpoints[Breakpoint.BP_TARGET_MEMORY]) {
                if (!bp.enabled || (bp.type & Breakpoint.BP_READ) != Breakpoint.BP_READ || (address & 0xFFFF) != bp.targetAddress || this.cart.getCurrentBank() != bp.targetBank && bp.targetBank != -1 || (bp.type & Breakpoint.BP_COMPARE) == Breakpoint.BP_COMPARE && bp.compareValue != this.e6809_readOnly8(address)) continue;
                if ((bp.type & Breakpoint.BP_ONCE) == Breakpoint.BP_ONCE) {
                    this.tmp.add(bp);
                }
                this.activeBreakpoint.add(bp);
                if (this.breakpointExit >= bp.exitType) continue;
                this.breakpointExit = bp.exitType;
            }
        }
    }

    boolean bitcompare(int o, int n, int bit) {
        int b = 1;
        while (bit > 0) {
            b <<= 1;
            --bit;
        }
        return (o & b) == (n & b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkVIABreakpoint(int register, int oldValue, int newValue) {
        if (!this.config.breakpointsActive) {
            return;
        }
        ArrayList<Breakpoint> arrayList = this.breakpoints[Breakpoint.BP_TARGET_VIA];
        synchronized (arrayList) {
            for (Breakpoint bp : this.breakpoints[Breakpoint.BP_TARGET_VIA]) {
                if (!bp.enabled) continue;
                if (bp.targetSubType == Breakpoint.BP_SUBTARGET_VIA_ORB && register == 0) {
                    if ((bp.type & Breakpoint.BP_BITCOMPARE) != Breakpoint.BP_BITCOMPARE || this.bitcompare(oldValue, newValue, bp.compareValue)) continue;
                    if ((bp.type & Breakpoint.BP_ONCE) == Breakpoint.BP_ONCE) {
                        this.tmp.add(bp);
                    }
                    this.activeBreakpoint.add(bp);
                    if (this.breakpointExit >= bp.exitType) continue;
                    this.breakpointExit = bp.exitType;
                    continue;
                }
                if (bp.targetSubType == Breakpoint.BP_SUBTARGET_VIA_AUX && register == 11) {
                    if (this.via_acr == 128 || this.via_acr == 152) continue;
                    if ((bp.type & Breakpoint.BP_ONCE) == Breakpoint.BP_ONCE) {
                        this.tmp.add(bp);
                    }
                    this.activeBreakpoint.add(bp);
                    if (this.breakpointExit >= bp.exitType) continue;
                    this.breakpointExit = bp.exitType;
                    continue;
                }
                if (bp.targetSubType == Breakpoint.BP_SUBTARGET_VIA_CA1 && register == 16) {
                    if ((bp.type & Breakpoint.BP_BITCOMPARE) == Breakpoint.BP_BITCOMPARE && newValue > 0 && bp.compareValue == 1) {
                        if ((bp.type & Breakpoint.BP_ONCE) == Breakpoint.BP_ONCE) {
                            this.tmp.add(bp);
                        }
                        this.activeBreakpoint.add(bp);
                        if (this.breakpointExit < bp.exitType) {
                            this.breakpointExit = bp.exitType;
                        }
                    }
                    if ((bp.type & Breakpoint.BP_BITCOMPARE) == Breakpoint.BP_BITCOMPARE && newValue == 0 && bp.compareValue == 0) {
                        if ((bp.type & Breakpoint.BP_ONCE) == Breakpoint.BP_ONCE) {
                            this.tmp.add(bp);
                        }
                        this.activeBreakpoint.add(bp);
                        if (this.breakpointExit < bp.exitType) {
                            this.breakpointExit = bp.exitType;
                        }
                    }
                    if ((bp.type & Breakpoint.BP_WRITE) != Breakpoint.BP_WRITE) continue;
                    if ((bp.type & Breakpoint.BP_ONCE) == Breakpoint.BP_ONCE) {
                        this.tmp.add(bp);
                    }
                    this.activeBreakpoint.add(bp);
                    if (this.breakpointExit >= bp.exitType) continue;
                    this.breakpointExit = bp.exitType;
                    continue;
                }
                if (bp.targetSubType != Breakpoint.BP_SUBTARGET_VIA_T2 || register != 8 && register != 9) continue;
                if ((bp.type & Breakpoint.BP_ONCE) == Breakpoint.BP_ONCE) {
                    this.tmp.add(bp);
                }
                this.activeBreakpoint.add(bp);
                if (this.breakpointExit >= bp.exitType) continue;
                this.breakpointExit = bp.exitType;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkBankswitchBreakpoint() {
        this.currentBank = this.cart.getCurrentBank();
        if (this.config.debugingCore) {
            this.dissiMem.setCurrentBank(this.currentBank);
        }
        if (!this.config.breakpointsActive) {
            return;
        }
        ArrayList<Breakpoint> arrayList = this.breakpoints[Breakpoint.BP_TARGET_CARTRIDGE];
        synchronized (arrayList) {
            for (Breakpoint bp : this.breakpoints[Breakpoint.BP_TARGET_CARTRIDGE]) {
                if (!bp.enabled || (bp.targetSubType & Breakpoint.BP_SUBTARGET_CARTRIDGE_BANKSWITCH) != Breakpoint.BP_SUBTARGET_CARTRIDGE_BANKSWITCH || (bp.type & Breakpoint.BP_BANK) != Breakpoint.BP_BANK) continue;
                if ((bp.type & Breakpoint.BP_ONCE) == Breakpoint.BP_ONCE) {
                    this.tmp.add(bp);
                }
                this.activeBreakpoint.add(bp);
                if (this.breakpointExit >= bp.exitType) continue;
                this.breakpointExit = bp.exitType;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkExternalLineBreakpoint(boolean externalLine) {
        if (!this.config.breakpointsActive) {
            return;
        }
        ArrayList<Breakpoint> arrayList = this.breakpoints[Breakpoint.BP_TARGET_CARTRIDGE];
        synchronized (arrayList) {
            for (Breakpoint bp : this.breakpoints[Breakpoint.BP_TARGET_CARTRIDGE]) {
                if (!bp.enabled || (bp.targetSubType & Breakpoint.BP_SUBTARGET_CARTRIDGE_PB6) != Breakpoint.BP_SUBTARGET_CARTRIDGE_PB6) continue;
                if ((bp.type & Breakpoint.BP_BITCOMPARE) == Breakpoint.BP_BITCOMPARE) {
                    if ((bp.compareValue != 1 || !externalLine) && (bp.compareValue != 0 || externalLine)) continue;
                    if ((bp.type & Breakpoint.BP_ONCE) == Breakpoint.BP_ONCE) {
                        this.tmp.add(bp);
                    }
                    this.activeBreakpoint.add(bp);
                    if (this.breakpointExit >= bp.exitType) continue;
                    this.breakpointExit = bp.exitType;
                    continue;
                }
                if ((bp.type & Breakpoint.BP_WRITE) != Breakpoint.BP_WRITE || this.old_pb6 == externalLine) continue;
                if ((bp.type & Breakpoint.BP_ONCE) == Breakpoint.BP_ONCE) {
                    this.tmp.add(bp);
                }
                this.activeBreakpoint.add(bp);
                if (this.breakpointExit >= bp.exitType) continue;
                this.breakpointExit = bp.exitType;
            }
        }
    }

    void checkAnalogBreakpoint() {
    }

    void checkPSGBreakpoint() {
    }

    protected boolean toggleBankBreakpoint(Breakpoint bp) {
        ArrayList<Breakpoint> bankBreakpoints = this.breakpoints[bp.targetType];
        for (Breakpoint bpAvailable : bankBreakpoints) {
            if (!bpAvailable.equals(bp)) continue;
            bankBreakpoints.remove(bpAvailable);
            return false;
        }
        bankBreakpoints.add(bp);
        return true;
    }

    protected boolean setCyclesBreakpoint(Breakpoint bp) {
        ArrayList<Breakpoint> cpuBreakpoints = this.breakpoints[bp.targetType];
        cpuBreakpoints.add(bp);
        return true;
    }

    public boolean breakpointCPUToggle(Breakpoint bp) {
        ArrayList<Breakpoint> cpuBreakpoints = this.breakpoints[bp.targetType];
        for (Breakpoint bpAvailable : cpuBreakpoints) {
            if (!bpAvailable.equals(bp)) continue;
            cpuBreakpoints.remove(bpAvailable);
            return false;
        }
        cpuBreakpoints.add(bp);
        return true;
    }

    protected boolean toggleViaBreakpoint(Breakpoint bp) {
        ArrayList<Breakpoint> viaBreakpoints = this.breakpoints[bp.targetType];
        for (Breakpoint bpAvailable : viaBreakpoints) {
            if (!bpAvailable.equals(bp)) continue;
            viaBreakpoints.remove(bpAvailable);
            return false;
        }
        viaBreakpoints.add(bp);
        return true;
    }

    protected boolean toggleROMBreakpoint(Breakpoint bp) {
        ArrayList<Breakpoint> romBreakpoints = this.breakpoints[bp.targetType];
        for (Breakpoint bpAvailable : romBreakpoints) {
            if (!bpAvailable.equals(bp)) continue;
            romBreakpoints.remove(bpAvailable);
            return false;
        }
        romBreakpoints.add(bp);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void toggleBreakpoint(Breakpoint bp) {
        boolean removed = false;
        if (bp.memInfo != null && !(removed = bp.memInfo.removeSameBreakPoint(bp))) {
            bp.memInfo.addBreakpoint(bp);
        }
        ArrayList<Breakpoint> arrayList = this.breakpoints[bp.targetType];
        synchronized (arrayList) {
            if (!removed) {
                this.breakpoints[bp.targetType].add(bp);
            } else {
                ArrayList<Breakpoint> memBreakPoints = this.breakpoints[bp.targetType];
                ArrayList<Breakpoint> toRemove = new ArrayList<Breakpoint>();
                for (Breakpoint b : memBreakPoints) {
                    if (!b.equals(bp)) continue;
                    toRemove.add(b);
                }
                for (Breakpoint b : toRemove) {
                    memBreakPoints.remove(b);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addBreakpoint(Breakpoint bp) {
        if (bp.memInfo != null) {
            bp.memInfo.addBreakpoint(bp);
        }
        ArrayList<Breakpoint> arrayList = this.breakpoints[bp.targetType];
        synchronized (arrayList) {
            this.breakpoints[bp.targetType].add(bp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBreakpoint(Breakpoint bp) {
        Breakpoint done = bp;
        ArrayList<Breakpoint> arrayList = this.breakpoints[bp.targetType];
        synchronized (arrayList) {
            boolean removed = this.breakpoints[bp.targetType].remove(bp);
            if (!removed) {
                for (int i = 0; i < this.breakpoints[bp.targetType].size(); ++i) {
                    Breakpoint realBP = this.breakpoints[bp.targetType].get(i);
                    if (!realBP.equals(bp)) continue;
                    removed = this.breakpoints[bp.targetType].remove(realBP);
                    done = realBP;
                    break;
                }
            }
        }
        if (done.memInfo != null) {
            done.memInfo.removeBreakpoint(done);
        }
    }

    public void clearAllBreakpoints() {
        ArrayList<Breakpoint> tmp = new ArrayList<Breakpoint>();
        for (ArrayList<Breakpoint> list2 : this.breakpoints) {
            for (Breakpoint bp : list2) {
                tmp.add(bp);
            }
        }
        for (Breakpoint bp : tmp) {
            if (this.displayer == null) continue;
            this.displayer.breakpointRemove(bp);
        }
    }

    public boolean shouldStall(int shiftCycleDif, boolean isRead) {
        if (isRead) {
            int generation = this.config.generation;
            if (generation == 0) {
                return false;
            }
            if (shiftCycleDif < 4) {
                return this.via_stalling;
            }
            if (generation < 3 && shiftCycleDif == 15) {
                return true;
            }
            if (generation == 3) {
                if (shiftCycleDif == 15) {
                    return true;
                }
                if (shiftCycleDif == 14) {
                    return true;
                }
            }
            return false;
        }
        int generation = this.config.generation;
        if (generation == 0) {
            return false;
        }
        if (shiftCycleDif < 4) {
            return this.via_stalling;
        }
        if (generation < 3 && shiftCycleDif == 17) {
            return true;
        }
        if (generation == 3) {
            if (shiftCycleDif == 17) {
                return true;
            }
            if (shiftCycleDif == 16) {
                return true;
            }
        }
        return false;
    }

    public void startRecord(String filename, int type, boolean isAddress, int address) {
        if (this.recording) {
            return;
        }
        this.recordingAddress = address;
        this.recordingFilename = filename;
        this.recordingType = type;
        this.recordingIsAddress = isAddress;
        this.recording = true;
        this.recordData = new ArrayList();
    }

    byte[] getLongBytes(int l) {
        byte[] ret = new byte[]{(byte)(l >> 8 >> 8 >> 8 & 0xFF), (byte)(l >> 8 >> 8 & 0xFF), (byte)(l >> 8 & 0xFF), (byte)(l & 0xFF)};
        return ret;
    }

    byte[] getWordBytes(int l) {
        byte[] ret = new byte[]{(byte)(l >> 8 & 0xFF), (byte)(l & 0xFF)};
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRecord() {
        if (!this.recording) {
            return;
        }
        long dataSaved = 0L;
        ArrayList<byte[]> arrayList = this.recordData;
        synchronized (arrayList) {
            try {
                OutputStream output = null;
                try {
                    String outAbs = Utility.makeVideAbsolute(this.recordingFilename);
                    output = new BufferedOutputStream(new FileOutputStream(outAbs));
                    if (this.recordingType == 2) {
                        for (int i = 0; i < this.recordData.size(); ++i) {
                            output.write(" db ".getBytes(StandardCharsets.UTF_8));
                            for (int r = 0; r < 16; ++r) {
                                byte toWrite = this.recordData.get(i)[r];
                                if (r == 0) {
                                    toWrite = (byte)(toWrite & 0xFF);
                                }
                                if (r == 1) {
                                    toWrite = (byte)(toWrite & 0xF);
                                }
                                if (r == 2) {
                                    toWrite = (byte)(toWrite & 0xFF);
                                }
                                if (r == 3) {
                                    toWrite = (byte)(toWrite & 0xF);
                                }
                                if (r == 4) {
                                    toWrite = (byte)(toWrite & 0xFF);
                                }
                                if (r == 5) {
                                    toWrite = (byte)(toWrite & 0xF);
                                }
                                if (r == 6) {
                                    toWrite = (byte)(toWrite & 0x1F);
                                }
                                if (r == 7) {
                                    toWrite = (byte)(toWrite & 0x3F);
                                }
                                if (r == 8) {
                                    toWrite = (byte)(toWrite & 0x1F);
                                }
                                if (r == 9) {
                                    toWrite = (byte)(toWrite & 0x1F);
                                }
                                if (r == 10) {
                                    toWrite = (byte)(toWrite & 0x1F);
                                }
                                if (r == 11) {
                                    toWrite = (byte)(toWrite & 0xFF);
                                }
                                if (r == 12) {
                                    toWrite = (byte)(toWrite & 0xFF);
                                }
                                if (r == 14) {
                                    toWrite = (byte)(toWrite & 0x1F);
                                }
                                if (r == 15) {
                                    toWrite = 0;
                                }
                                if (r == 16) {
                                    toWrite = 0;
                                }
                                if (r != 0) {
                                    output.write(", ".getBytes(StandardCharsets.UTF_8));
                                }
                                output.write(("$" + String.format("%02X", toWrite & 0xFF)).getBytes(StandardCharsets.UTF_8));
                                ++dataSaved;
                            }
                            output.write("\n".getBytes(StandardCharsets.UTF_8));
                        }
                    } else if (this.recordingType == 1) {
                        for (int i = 0; i < this.recordData.size(); ++i) {
                            for (int r = 0; r < 16; ++r) {
                                byte toWrite = this.recordData.get(i)[r];
                                if (r == 0) {
                                    toWrite = (byte)(toWrite & 0xFF);
                                }
                                if (r == 1) {
                                    toWrite = (byte)(toWrite & 0xF);
                                }
                                if (r == 2) {
                                    toWrite = (byte)(toWrite & 0xFF);
                                }
                                if (r == 3) {
                                    toWrite = (byte)(toWrite & 0xF);
                                }
                                if (r == 4) {
                                    toWrite = (byte)(toWrite & 0xFF);
                                }
                                if (r == 5) {
                                    toWrite = (byte)(toWrite & 0xF);
                                }
                                if (r == 6) {
                                    toWrite = (byte)(toWrite & 0x1F);
                                }
                                if (r == 7) {
                                    toWrite = (byte)(toWrite & 0x3F);
                                }
                                if (r == 8) {
                                    toWrite = (byte)(toWrite & 0x1F);
                                }
                                if (r == 9) {
                                    toWrite = (byte)(toWrite & 0x1F);
                                }
                                if (r == 10) {
                                    toWrite = (byte)(toWrite & 0x1F);
                                }
                                if (r == 11) {
                                    toWrite = (byte)(toWrite & 0xFF);
                                }
                                if (r == 12) {
                                    toWrite = (byte)(toWrite & 0xFF);
                                }
                                if (r == 14) {
                                    toWrite = (byte)(toWrite & 0x1F);
                                }
                                if (r == 15) {
                                    toWrite = 0;
                                }
                                if (r == 16) {
                                    toWrite = 0;
                                }
                                output.write(toWrite);
                                ++dataSaved;
                            }
                        }
                    } else if (this.recordingType == 0) {
                        output.write("YM6!".getBytes(StandardCharsets.UTF_8));
                        output.write("LeOnArD!".getBytes(StandardCharsets.UTF_8));
                        output.write(this.getLongBytes(this.recordData.size()));
                        output.write(this.getLongBytes(1));
                        output.write(this.getWordBytes(0));
                        output.write(this.getLongBytes(1500000));
                        output.write(this.getWordBytes(50));
                        output.write(this.getLongBytes(0));
                        output.write(this.getWordBytes(0));
                        dataSaved += 34L;
                        output.write("VECTREX".getBytes(StandardCharsets.UTF_8));
                        output.write(0);
                        output.write("VIDE".getBytes(StandardCharsets.UTF_8));
                        output.write(0);
                        output.write("VIDE IS GREAT!".getBytes(StandardCharsets.UTF_8));
                        output.write(0);
                        dataSaved += 28L;
                        for (int r = 0; r < 16; ++r) {
                            for (int i = 0; i < this.recordData.size(); ++i) {
                                byte toWrite = this.recordData.get(i)[r];
                                if (r == 0) {
                                    toWrite = (byte)(toWrite & 0xFF);
                                }
                                if (r == 1) {
                                    toWrite = (byte)(toWrite & 0xF);
                                }
                                if (r == 2) {
                                    toWrite = (byte)(toWrite & 0xFF);
                                }
                                if (r == 3) {
                                    toWrite = (byte)(toWrite & 0xF);
                                }
                                if (r == 4) {
                                    toWrite = (byte)(toWrite & 0xFF);
                                }
                                if (r == 5) {
                                    toWrite = (byte)(toWrite & 0xF);
                                }
                                if (r == 6) {
                                    toWrite = (byte)(toWrite & 0x1F);
                                }
                                if (r == 7) {
                                    toWrite = (byte)(toWrite & 0x3F);
                                }
                                if (r == 8) {
                                    toWrite = (byte)(toWrite & 0x1F);
                                }
                                if (r == 9) {
                                    toWrite = (byte)(toWrite & 0x1F);
                                }
                                if (r == 10) {
                                    toWrite = (byte)(toWrite & 0x1F);
                                }
                                if (r == 11) {
                                    toWrite = (byte)(toWrite & 0xFF);
                                }
                                if (r == 12) {
                                    toWrite = (byte)(toWrite & 0xFF);
                                }
                                if (r == 14) {
                                    toWrite = (byte)(toWrite & 0x1F);
                                }
                                if (r == 15) {
                                    toWrite = 0;
                                }
                                if (r == 16) {
                                    toWrite = 0;
                                }
                                output.write(toWrite);
                                ++dataSaved;
                            }
                        }
                        output.write("End!".getBytes(StandardCharsets.UTF_8));
                        dataSaved += 4L;
                    }
                }
                finally {
                    output.flush();
                    output.close();
                }
            }
            catch (Throwable ex) {
                this.log.addLog(ex, LogPanel.WARN);
            }
        }
        this.recording = false;
        this.recordData = null;
        this.log.addLog("YM file saved successfully!", LogPanel.INFO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSoundRecord() {
        if (this.recordData == null) {
            return;
        }
        ArrayList<byte[]> arrayList = this.recordData;
        synchronized (arrayList) {
            byte[] psgData = new byte[16];
            if (this.recordData == null) {
                return;
            }
            int lastReg13 = 256;
            if (this.recordData.size() > 0) {
                lastReg13 = this.recordData.get(this.recordData.size() - 1)[13];
            }
            for (int i = 0; i < 16; ++i) {
                int value = this.e8910.read(i) & 0xFF;
                if (i == 13) {
                    value = !this.e8910.envWritten ? -1 : (int)((byte)(value & 0xF));
                }
                psgData[i] = value;
            }
            this.recordData.add(psgData);
        }
        this.e8910.envWritten = false;
    }

    public void setFIRQ(boolean lineState) {
        this.firq = lineState ? 1 : 0;
    }

    public boolean setRegister(String register, int value) {
        if ((register = register.trim().toLowerCase()).equals("dp")) {
            this.e6809.reg_dp = value & 0xFF;
            return true;
        }
        if (register.equals("cc")) {
            this.e6809.reg_cc = value & 0xFF;
            return true;
        }
        if (register.equals("a")) {
            this.e6809.reg_a = value & 0xFF;
            return true;
        }
        if (register.equals("b")) {
            this.e6809.reg_b = value & 0xFF;
            return true;
        }
        if (register.equals("d")) {
            this.e6809.reg_b = value & 0xFF;
            this.e6809.reg_a = value >> 8 & 0xFF;
            return true;
        }
        if (register.equals("x")) {
            this.e6809.reg_x = value & 0xFFFF;
            return true;
        }
        if (register.equals("y")) {
            this.e6809.reg_y = value & 0xFFFF;
            return true;
        }
        if (register.equals("pc")) {
            this.e6809.reg_pc = value & 0xFFFF;
            return true;
        }
        if (register.equals("u")) {
            this.e6809.reg_u.intValue = value & 0xFFFF;
            return true;
        }
        if (register.equals("s")) {
            this.e6809.reg_s.intValue = value & 0xFFFF;
            return true;
        }
        return false;
    }

    public boolean isImager() {
        return this.imagerMode;
    }

    public void setImager(boolean im) {
        this.imagerMode = im;
    }

    public DisplayerInterface getDisplay() {
        return this.displayer;
    }

    public int getPC() {
        return this.e6809.reg_pc;
    }

    public ArrayList<Integer> getCallstack() {
        return this.e6809.callStack;
    }

    public void resetBuffer() {
        SS_RING_BUFFER_SIZE = this.config.singestepBuffer;
        this.ringSSWalkStep = 0;
        this.ringSSBufferNext = 0;
        this.goSSBackRingBuffer = new CompleteState[SS_RING_BUFFER_SIZE];
        FRAME_RING_BUFFER_SIZE = this.config.frameBuffer;
        this.ringFrameWalkStep = 0;
        this.ringFrameBufferNext = 0;
        this.goFrameBackRingBuffer = new CompleteState[FRAME_RING_BUFFER_SIZE];
    }

    public String dumpCurrentROM() {
        return this.cart.dumpCurrentROM();
    }

    public int getAddressBUS() {
        return this.e6809.getAddressBUS();
    }

    public byte getDataBUS() {
        return this.e6809.getDataBUS();
    }

    private void initRam() {
        for (int i = 0; i < 1024; ++i) {
            this.ramAccess[i] = 0;
        }
    }

    boolean checkRAMPointers() {
        return false;
    }

    @Override
    public void checkFunctionEntry() {
        int address = this.e6809.reg_pc;
        int Y = this.e6809.reg_y;
        int X = this.e6809.reg_x;
        int U = this.e6809.reg_u.intValue;
        int A = this.e6809.reg_a;
        int B = this.e6809.reg_b;
        int D = A * 256 + B;
        switch (address) {
            case 62480: {
                int mode;
                int a = X;
                int times = 0;
                if (this.dis_isKown(X) || this.dis_isCodeScanDone(X)) break;
                do {
                    if (!this.dis_isCodeScanDone(a)) {
                        this.dis_set8BitHex(a);
                        this.dis_codeScanDone(a);
                        this.dis_addLabel(a, null);
                        this.dis_addComment(a, "mode, y, x");
                    }
                    mode = this.e6809_readOnly8(a);
                    if (!this.dis_isCodeScanDone(++a)) {
                        this.dis_set8BitHex(a);
                        this.dis_codeScanDone(a);
                        this.dis_addLabel(a, null);
                        this.dis_addComment(a, null);
                    }
                    if (!this.dis_isCodeScanDone(++a)) {
                        this.dis_set8BitHex(a);
                        this.dis_codeScanDone(a);
                        this.dis_addLabel(a, null);
                        this.dis_addComment(a, null);
                    }
                    ++a;
                    ++times;
                } while (mode != 1);
                this.dis_setCount(X, times, 3);
                this.dis_addLabel(X, "List_Draw_VLp_" + String.format("0x%04X", X));
                this.dis_refresh();
                break;
            }
            case 62381: {
                int a = X;
                boolean times = false;
                if (this.dis_isKown(X) || this.dis_isCodeScanDone(X)) break;
                this.dis_set8BitHex(a);
                this.dis_codeScanDone(a);
                this.dis_addLabel(X, "List_Mov_Draw_VLc_a_" + String.format("0x%04X", X));
                this.dis_addComment(a, "count");
                this.dis_setCount(X, 1, 1);
                this.dis_refresh();
                break;
            }
            case 62389: {
                int a = X;
                boolean times = false;
                if (this.dis_isKown(X) || this.dis_isCodeScanDone(X)) break;
                if (!this.dis_isCodeScanDone(a)) {
                    this.dis_set8BitHex(a);
                    this.dis_codeScanDone(a);
                    this.dis_addLabel(X, "List_Mov_Draw_VLcs_" + String.format("0x%04X", X));
                    this.dis_addComment(a, "count, scale");
                }
                if (!this.dis_isCodeScanDone(++a)) {
                    this.dis_set8BitHex(a);
                    this.dis_codeScanDone(a);
                    this.dis_addLabel(a, null);
                    this.dis_addComment(a, null);
                }
                this.dis_setCount(X, 1, 2);
                this.dis_refresh();
                break;
            }
            case 62396: {
                int a = X;
                int times = 0;
                if (this.dis_isKown(X) || this.dis_isCodeScanDone(X)) break;
                boolean first = true;
                for (int count = this.e6809_readOnly8(51235); count >= 0; --count) {
                    if (!this.dis_isCodeScanDone(a)) {
                        this.dis_set8BitHex(a);
                        this.dis_codeScanDone(a);
                        this.dis_addLabel(a, null);
                        if (first) {
                            this.dis_addComment(a, "MOVE: rel y, rel x");
                        } else {
                            this.dis_addComment(a, "DRAW: rel y, rel x");
                        }
                    }
                    if (!this.dis_isCodeScanDone(++a)) {
                        this.dis_set8BitHex(a);
                        this.dis_codeScanDone(a);
                        this.dis_addLabel(a, null);
                        this.dis_addComment(a, null);
                    }
                    first = false;
                    ++a;
                    ++times;
                }
                this.dis_addLabel(X, "List_Mov_Draw_VL_" + String.format("0x%04X", X));
                this.dis_setCount(X, times + 1, 2);
                this.dis_refresh();
                break;
            }
            case 62414: {
                int a = X;
                boolean times = false;
                if (this.dis_isKown(X) || this.dis_isCodeScanDone(X)) break;
                int count = this.e6809_readOnly8(a);
                this.dis_set8BitHex(a);
                this.dis_codeScanDone(a);
                this.dis_addLabel(a, "List_Draw_VLc_" + String.format("0x%04X", X));
                this.dis_addComment(a, "count");
                this.dis_refresh();
                break;
            }
            case 62429: {
                int a = X;
                int times = 0;
                if (this.dis_isKown(X) || this.dis_isCodeScanDone(X)) break;
                for (int count = this.e6809_readOnly8(51235); count >= 0; --count) {
                    if (!this.dis_isCodeScanDone(a)) {
                        this.dis_set8BitHex(a);
                        this.dis_codeScanDone(a);
                        this.dis_addLabel(a, null);
                        this.dis_addComment(a, "rel y, rel x");
                    }
                    if (!this.dis_isCodeScanDone(++a)) {
                        this.dis_set8BitHex(a);
                        this.dis_codeScanDone(a);
                        this.dis_addLabel(a, null);
                        this.dis_addComment(a, null);
                    }
                    ++a;
                    ++times;
                }
                this.dis_addLabel(X, "List_Draw_VL_" + String.format("0x%04X", X));
                this.dis_setCount(X, times + 1, 2);
                this.dis_refresh();
                break;
            }
            case 62165: {
                int a = X;
                int times = 0;
                if (this.dis_isKown(X) || this.dis_isCodeScanDone(X)) break;
                for (int count = this.e6809_readOnly8(51235); count >= 0; --count) {
                    if (!this.dis_isCodeScanDone(a)) {
                        this.dis_set8BitHex(a);
                        this.dis_codeScanDone(a);
                        this.dis_addLabel(a, null);
                        this.dis_addComment(a, "rel y, rel x");
                    }
                    if (!this.dis_isCodeScanDone(++a)) {
                        this.dis_set8BitHex(a);
                        this.dis_codeScanDone(a);
                        this.dis_addLabel(a, null);
                        this.dis_addComment(a, null);
                    }
                    ++a;
                    ++times;
                }
                this.dis_addLabel(X, "List_Dot_" + String.format("0x%04X", X));
                this.dis_setCount(X, times + 1, 2);
                this.dis_refresh();
                break;
            }
            case 62077: {
                int mode;
                int a = X;
                int times = 0;
                if (this.dis_isKown(X) || this.dis_isCodeScanDone(X)) break;
                do {
                    mode = this.e6809_readOnly8(a);
                    if (!this.dis_isCodeScanDone(a)) {
                        this.dis_set8BitHex(a);
                        this.dis_codeScanDone(a);
                        this.dis_addLabel(a, null);
                        this.dis_addComment(a, "register number, music data");
                    }
                    if (!this.dis_isCodeScanDone(++a)) {
                        this.dis_set8BitHex(a);
                        this.dis_codeScanDone(a);
                        this.dis_addLabel(a, null);
                        this.dis_addComment(a, null);
                    }
                    ++a;
                    ++times;
                } while (mode != 255);
                this.dis_setCount(X, times, 2);
                this.dis_addLabel(X, "Sound_Bytes_" + String.format("0x%04X", X));
                this.dis_refresh();
                break;
            }
            case 62574: {
                int mode;
                int a = X;
                int times = 0;
                if (this.dis_isKown(X) || this.dis_isCodeScanDone(X)) break;
                do {
                    if (!this.dis_isCodeScanDone(a)) {
                        this.dis_set8BitHex(a);
                        this.dis_codeScanDone(a);
                        this.dis_addLabel(a, null);
                        this.dis_addComment(a, "mode, y, x");
                    }
                    if ((mode = this.e6809_readOnly8(a++)) != 1) {
                        if (!this.dis_isCodeScanDone(a)) {
                            this.dis_set8BitHex(a);
                            this.dis_codeScanDone(a);
                            this.dis_addLabel(a, null);
                            this.dis_addComment(a, null);
                        }
                        int y = this.e6809_readOnly8(a++);
                        if (!this.dis_isCodeScanDone(a)) {
                            this.dis_set8BitHex(a);
                            this.dis_codeScanDone(a);
                            this.dis_addLabel(a, null);
                            this.dis_addComment(a, null);
                        }
                    }
                    int x = this.e6809_readOnly8(a++);
                    ++times;
                } while (mode != 1);
                this.dis_setCount(X, times - 1, 3);
                this.dis_addLabel(X, "List_Draw_Mode_" + String.format("0x%04X", X));
                this.dis_refresh();
                break;
            }
            case 62519: {
                int a = X;
                int times = 0;
                if (this.dis_isKown(X) || this.dis_isCodeScanDone(X)) break;
                for (int count = this.e6809_readOnly8(51235); count >= 0; --count) {
                    if (!this.dis_isCodeScanDone(a)) {
                        this.dis_set8BitHex(a);
                        this.dis_codeScanDone(a);
                        this.dis_addLabel(a, null);
                        this.dis_addComment(a, "rel y, rel x");
                    }
                    if (!this.dis_isCodeScanDone(++a)) {
                        this.dis_set8BitHex(a);
                        this.dis_codeScanDone(a);
                        this.dis_addLabel(a, null);
                        this.dis_addComment(a, null);
                    }
                    ++a;
                    ++times;
                }
                this.dis_addLabel(X, "List_Draw_Pat_VL_" + String.format("0x%04X", X));
                this.dis_setCount(X, times + 1, 2);
                this.dis_refresh();
                break;
            }
            case 62330: {
                int c;
                int a = U;
                int count = 1;
                if (this.dis_isKown(U) || this.dis_isCodeScanDone(U)) break;
                this.dis_setChar(U);
                this.dis_addLabel(U, "StringData_d_" + String.format("0x%04X", U));
                this.dis_addComment(U, null);
                do {
                    c = this.e6809_readOnly8(++a);
                    this.dis_setChar(a);
                    this.dis_addLabel(a, null);
                    this.dis_addComment(a, null);
                    this.dis_codeScanDone(a);
                    ++count;
                } while (c != 128);
                this.dis_setCount(U, 1, count);
                this.dis_codeScanDone(U);
                this.dis_refresh();
                break;
            }
            case 62323: {
                int c;
                int a = U;
                int count = 1;
                if (this.dis_isKown(U) || this.dis_isCodeScanDone(U)) break;
                this.dis_set8BitHex(U);
                this.dis_addLabel(U, "StringData_hwyx_" + String.format("0x%04X", U));
                this.dis_addComment(U, "height, width, rel y, rel x");
                this.dis_set8BitHex(a);
                this.dis_set8BitHex(++a);
                this.dis_addLabel(a, null);
                this.dis_addComment(a, null);
                this.dis_set8BitHex(++a);
                this.dis_addLabel(a, null);
                this.dis_addComment(a, null);
                this.dis_set8BitHex(++a);
                this.dis_addLabel(a, null);
                this.dis_addComment(a, null);
                this.dis_setCount(U, 1, 4);
                this.dis_codeScanDone(U);
                U = a;
                do {
                    c = this.e6809_readOnly8(++a);
                    this.dis_setChar(a);
                    this.dis_addLabel(a, null);
                    this.dis_addComment(a, null);
                    this.dis_codeScanDone(a);
                    ++count;
                } while (c != 128);
                this.dis_setCount(U, 1, count);
                this.dis_codeScanDone(U);
                this.dis_refresh();
                break;
            }
            case 62328: {
                int c;
                int a = U;
                int count = 1;
                if (this.dis_isKown(U) || this.dis_isCodeScanDone(U)) break;
                this.dis_set8BitHex(U);
                this.dis_addLabel(U, "StringData_yx_" + String.format("0x%04X", U));
                this.dis_addComment(U, "rel y, rel x");
                this.dis_set8BitHex(a);
                this.dis_addLabel(a, null);
                this.dis_addComment(a, null);
                this.dis_set8BitHex(++a);
                this.dis_addLabel(a, null);
                this.dis_addComment(a, null);
                this.dis_setCount(U, 1, 4);
                this.dis_codeScanDone(U);
                U = a;
                do {
                    c = this.e6809_readOnly8(++a);
                    this.dis_setChar(a);
                    this.dis_addLabel(a, null);
                    this.dis_addComment(a, null);
                    this.dis_codeScanDone(a);
                    ++count;
                } while (c != 128);
                this.dis_setCount(U, 1, count);
                this.dis_codeScanDone(U);
                this.dis_refresh();
                break;
            }
            case 63790: {
                int a = U;
                boolean count = true;
                if (this.dis_isKown(U) || this.dis_isCodeScanDone(U)) break;
                this.dis_set8BitHex(U);
                this.dis_addLabel(U, "Explosion_Snd_" + String.format("0x%04X", U));
                this.dis_addComment(U, "Explosion Data (4 bytes)");
                this.dis_set8BitHex(a + 1);
                this.dis_addLabel(a + 1, null);
                this.dis_addComment(a + 1, null);
                this.dis_codeScanDone(a + 1);
                this.dis_set8BitHex(a + 2);
                this.dis_addLabel(a + 2, null);
                this.dis_addComment(a + 2, null);
                this.dis_codeScanDone(a + 2);
                this.dis_set8BitHex(a + 3);
                this.dis_addLabel(a + 3, null);
                this.dis_addComment(a + 3, null);
                this.dis_codeScanDone(a + 3);
                this.dis_setCount(U, 1, 4);
                this.dis_codeScanDone(U);
                this.dis_refresh();
                break;
            }
            case 63117: {
                int a = U;
                int count = 1;
                if (this.dis_isKown(U) || this.dis_isCodeScanDone(U)) break;
                this.dis_set16BitHex(a);
                this.dis_addLabel(a, "Init_Music" + String.format("0x%04X", a));
                this.dis_addComment(a, "ADSR pointer, TWANG pointer");
                this.dis_set16BitHex(a += 2);
                this.dis_addLabel(a, null);
                this.dis_addComment(a, null);
                this.dis_codeScanDone(a);
                this.dis_setCount(U, 1, 4);
                this.dis_isCodeScanDone(U);
                a += 2;
                boolean endOfSong = false;
                do {
                    int startAdr = a;
                    count = 1;
                    String comment = "";
                    this.dis_set8BitHex(a);
                    this.dis_addLabel(a, null);
                    this.dis_addComment(a, null);
                    this.dis_codeScanDone(a);
                    int b = this.e6809_readOnly8(a);
                    int freq = b & 0x3F;
                    boolean noise = (b & 0x40) == 64;
                    boolean tone = !noise;
                    boolean nextChannel = (b & 0x80) == 128;
                    boolean endNote = !nextChannel;
                    comment = comment + "1. Freq: " + freq;
                    comment = noise ? comment + ", 1. noise" : comment + ", 1. tone";
                    if (nextChannel) {
                        ++count;
                        this.dis_set8BitHex(++a);
                        this.dis_addLabel(a, null);
                        this.dis_addComment(a, null);
                        this.dis_codeScanDone(a);
                        b = this.e6809_readOnly8(a);
                        freq = b & 0x3F;
                        noise = (b & 0x40) == 64;
                        tone = !noise;
                        nextChannel = (b & 0x80) == 128;
                        endNote = !nextChannel;
                        comment = comment + " 2. Freq: " + freq;
                        comment = noise ? comment + ", 2. noise" : comment + ", 2. tone";
                    }
                    if (nextChannel) {
                        ++count;
                        this.dis_set8BitHex(++a);
                        this.dis_addLabel(a, null);
                        this.dis_addComment(a, null);
                        this.dis_codeScanDone(a);
                        b = this.e6809_readOnly8(a);
                        freq = b & 0x3F;
                        noise = (b & 0x40) == 64;
                        tone = !noise;
                        nextChannel = (b & 0x80) == 128;
                        endNote = !nextChannel;
                        comment = comment + " 3. Freq: " + freq;
                        comment = noise ? comment + ", 3. noise" : comment + ", 3. tone";
                    }
                    ++count;
                    this.dis_set8BitHex(++a);
                    this.dis_addLabel(a, null);
                    this.dis_addComment(a, null);
                    this.dis_codeScanDone(a);
                    b = this.e6809_readOnly8(a);
                    int duration = b & 0x3F;
                    comment = comment + " -> duration " + duration;
                    endOfSong = (b & 0x80) == 128;
                    this.dis_addComment(startAdr, comment);
                    this.dis_setCount(startAdr, 1, count);
                    ++a;
                } while (!endOfSong);
                this.dis_refresh();
                break;
            }
        }
    }

    void dis_refresh() {
        DissiPanel dissi = null;
        if (this.config.debugingCore && Configuration.getConfiguration().getMainFrame() instanceof CSAMainFrame) {
            CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
            dissi = frame.checkDissi();
        }
        if (dissi == null) {
            return;
        }
        dissi.refreshCodeScan();
    }

    boolean dis_isCodeScanDone(int address) {
        DissiPanel dissi = null;
        if (this.config.debugingCore && Configuration.getConfiguration().getMainFrame() instanceof CSAMainFrame) {
            CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
            dissi = frame.checkDissi();
        }
        if (dissi == null) {
            return true;
        }
        MemoryInformation memInfo = dissi.getMemInfo(address);
        if (memInfo == null) {
            return true;
        }
        return memInfo.codeScanDone;
    }

    void dis_codeScanDone(int address) {
        DissiPanel dissi = null;
        if (this.config.debugingCore && Configuration.getConfiguration().getMainFrame() instanceof CSAMainFrame) {
            CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
            dissi = frame.checkDissi();
        }
        if (dissi == null) {
            return;
        }
        MemoryInformation memInfo = dissi.getMemInfo(address);
        if (memInfo == null) {
            return;
        }
        memInfo.codeScanDone = true;
    }

    void dis_addLabel(int address, String label) {
        DissiPanel dissi = null;
        if (this.config.debugingCore && Configuration.getConfiguration().getMainFrame() instanceof CSAMainFrame) {
            CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
            dissi = frame.checkDissi();
        }
        if (dissi == null) {
            return;
        }
        MemoryInformation memInfo = dissi.getMemInfo(address);
        if (memInfo == null) {
            return;
        }
        if (memInfo.labels == null) {
            memInfo.labels = new ArrayList();
        }
        if (label != null) {
            memInfo.labels.add(label);
        }
    }

    void dis_addComment(int address, String comment) {
        DissiPanel dissi = null;
        if (this.config.debugingCore && Configuration.getConfiguration().getMainFrame() instanceof CSAMainFrame) {
            CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
            dissi = frame.checkDissi();
        }
        if (dissi == null) {
            return;
        }
        MemoryInformation memInfo = dissi.getMemInfo(address);
        if (memInfo == null) {
            return;
        }
        memInfo.comments = new ArrayList();
        if (comment != null) {
            memInfo.comments.add(comment);
        }
    }

    boolean dis_isKown(int address) {
        DissiPanel dissi = null;
        if (this.config.debugingCore && Configuration.getConfiguration().getMainFrame() instanceof CSAMainFrame) {
            CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
            dissi = frame.checkDissi();
        }
        if (dissi == null) {
            return false;
        }
        MemoryInformation memInfo = dissi.getMemInfo(address);
        if (memInfo == null) {
            return false;
        }
        return memInfo.typeWasSet;
    }

    void dis_setChar(int address) {
        DissiPanel dissi = null;
        if (this.config.debugingCore && Configuration.getConfiguration().getMainFrame() instanceof CSAMainFrame) {
            CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
            dissi = frame.checkDissi();
        }
        if (dissi == null) {
            return;
        }
        MemoryInformation memInfo = dissi.getMemInfo(address);
        if (memInfo == null) {
            return;
        }
        MemoryInformation kin = memInfo.belongsToInstruction;
        if (kin != null) {
            kin.reset();
            kin.disType = 1;
            kin.typeWasSet = true;
            kin.disTypeCollectionMax = 1;
        }
        memInfo.reset();
        dissi.resetFollowers(memInfo);
        memInfo.disType = 4;
        memInfo.typeWasSet = true;
        memInfo.disTypeCollectionMax = 1;
        memInfo.belongsToInstruction = null;
        memInfo.disassembledMnemonic = "";
        memInfo.disassembledOperand = "";
        memInfo.page = -1;
        memInfo.hexDump = "";
        memInfo.isInstructionByte = 0;
        memInfo.referingToAddress = -1;
        memInfo.referingAddressMode = -1;
        memInfo.length = 1;
        memInfo.done = false;
        memInfo.familyBytes.clear();
    }

    void dis_set8BitHex(int address) {
        DissiPanel dissi = null;
        if (this.config.debugingCore && Configuration.getConfiguration().getMainFrame() instanceof CSAMainFrame) {
            CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
            dissi = frame.checkDissi();
        }
        if (dissi == null) {
            return;
        }
        MemoryInformation memInfo = dissi.getMemInfo(address);
        if (memInfo == null) {
            return;
        }
        MemoryInformation kin = memInfo.belongsToInstruction;
        if (kin != null) {
            kin.reset();
            kin.disType = 1;
            kin.disTypeCollectionMax = 1;
            kin.typeWasSet = true;
        }
        memInfo.reset();
        dissi.resetFollowers(memInfo);
        memInfo.disType = 1;
        memInfo.typeWasSet = true;
        memInfo.disTypeCollectionMax = 1;
        memInfo.belongsToInstruction = null;
        memInfo.disassembledMnemonic = "";
        memInfo.disassembledOperand = "";
        memInfo.page = -1;
        memInfo.hexDump = "";
        memInfo.isInstructionByte = 0;
        memInfo.referingToAddress = -1;
        memInfo.referingAddressMode = -1;
        memInfo.length = 1;
        memInfo.done = false;
        memInfo.familyBytes.clear();
    }

    void dis_set16BitHex(int address) {
        DissiPanel dissi = null;
        if (this.config.debugingCore && Configuration.getConfiguration().getMainFrame() instanceof CSAMainFrame) {
            CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
            dissi = frame.checkDissi();
        }
        if (dissi == null) {
            return;
        }
        MemoryInformation memInfo = dissi.getMemInfo(address);
        if (memInfo == null) {
            return;
        }
        MemoryInformation kin = memInfo.belongsToInstruction;
        if (kin != null) {
            kin.reset();
            kin.disType = 1;
            kin.disTypeCollectionMax = 1;
            kin.typeWasSet = true;
        }
        memInfo.reset();
        dissi.resetFollowers(memInfo);
        memInfo.disType = 3;
        memInfo.typeWasSet = true;
        memInfo.disTypeCollectionMax = 1;
        memInfo.belongsToInstruction = null;
        memInfo.disassembledMnemonic = "";
        memInfo.disassembledOperand = "";
        memInfo.page = -1;
        memInfo.hexDump = "";
        memInfo.isInstructionByte = 0;
        memInfo.referingToAddress = -1;
        memInfo.referingAddressMode = -1;
        memInfo.length = 2;
        memInfo.done = false;
        memInfo.familyBytes.clear();
    }

    void dis_setCount(int address, int times, int count) {
        DissiPanel dissi = null;
        if (this.config.debugingCore && Configuration.getConfiguration().getMainFrame() instanceof CSAMainFrame) {
            CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
            dissi = frame.checkDissi();
        }
        if (dissi == null) {
            return;
        }
        for (int a = address; a < address + times * count; ++a) {
            MemoryInformation memInfo = dissi.getMemInfo(a);
            memInfo.disTypeCollectionMax = count;
        }
    }

    static {
        VecX.initDACDeviations();
        OVERFLOW_BORDER_RAYWIDTH = 6;
        OVERFLOW_SAMPLE_MAX = 16;
        SS_RING_BUFFER_SIZE = 30000;
        FRAME_RING_BUFFER_SIZE = 1000;
        WAIT_RECAL_BUFFER_SIZE = 500;
        UID_ = 1;
        uid = UID_++;
    }

    static class VectrexDisplayVectors {
        VecXState.vector_t[] vectrexVectors = new VecXState.vector_t[50000];
        float[] left = new float[OVERFLOW_SAMPLE_MAX];
        float[] right = new float[OVERFLOW_SAMPLE_MAX];
        float[] top = new float[OVERFLOW_SAMPLE_MAX];
        float[] bottom = new float[OVERFLOW_SAMPLE_MAX];
        int count = 0;

        void resetBorders() {
            for (int i = 0; i < OVERFLOW_SAMPLE_MAX; ++i) {
                this.bottom[i] = 0.0f;
                this.top[i] = 0.0f;
                this.right[i] = 0.0f;
                this.left[i] = 0.0f;
            }
        }

        VectrexDisplayVectors() {
            for (int i = 0; i < 50000; ++i) {
                this.vectrexVectors[i] = new VecXState.vector_t();
            }
        }
    }
}

