/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.graphics.GFXVector;
import de.malban.graphics.GFXVectorList;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.CloseWatcher;
import de.malban.gui.HotKey;
import de.malban.gui.ImageCache;
import de.malban.gui.Scaler;
import de.malban.gui.Stateable;
import de.malban.gui.Windowable;
import de.malban.gui.components.CSAView;
import de.malban.gui.dialogs.InternalFrameFileChoser;
import de.malban.gui.dialogs.ShowErrorDialog;
import de.malban.gui.panels.LogPanel;
import de.malban.input.ControllerEvent;
import de.malban.jogl.JOGLSupport;
import de.malban.util.Utility;
import de.malban.util.UtilityFiles;
import de.malban.util.UtilityString;
import de.malban.vide.ControllerConfig;
import de.malban.vide.VideConfig;
import de.malban.vide.dissy.DissiPanel;
import de.malban.vide.dissy.MemoryInformation;
import de.malban.vide.vecx.Breakpoint;
import de.malban.vide.vecx.CodeScanMemory;
import de.malban.vide.vecx.CompleteState;
import de.malban.vide.vecx.DisplayPanelInterface;
import de.malban.vide.vecx.DisplayerInterface;
import de.malban.vide.vecx.E6809;
import de.malban.vide.vecx.E8910State;
import de.malban.vide.vecx.Profiler;
import de.malban.vide.vecx.VecX;
import de.malban.vide.vecx.VecXState;
import de.malban.vide.vecx.VecXStatics;
import de.malban.vide.vecx.VecxSettings;
import de.malban.vide.vecx.VecxiPanel_JAVA;
import de.malban.vide.vecx.VecxiPanel_JOGL;
import de.malban.vide.vecx.cartridge.AT24C02;
import de.malban.vide.vecx.cartridge.Cartridge;
import de.malban.vide.vecx.cartridge.CartridgeProperties;
import de.malban.vide.vecx.cartridge.DS2430A;
import de.malban.vide.vecx.cartridge.DS2431;
import de.malban.vide.vecx.cartridge.DualVec;
import de.malban.vide.vecx.cartridge.Microchip11AA010;
import de.malban.vide.vecx.devices.AbstractDevice;
import de.malban.vide.vecx.devices.Imager3dDevice;
import de.malban.vide.vecx.devices.JInputJoystickDevice;
import de.malban.vide.vecx.devices.JInputSpinnerDevice;
import de.malban.vide.vecx.devices.JoyportDevice;
import de.malban.vide.vecx.devices.KeyboardJoystickDevice;
import de.malban.vide.vecx.devices.KeyboardSpinnerDevice;
import de.malban.vide.vecx.devices.LightpenDevice;
import de.malban.vide.vecx.devices.NullDevice;
import de.malban.vide.vecx.devices.VecLinkV1Device;
import de.malban.vide.vecx.devices.VecLinkV2Device;
import de.malban.vide.vecx.devices.VecSpeechDevice;
import de.malban.vide.vecx.devices.VectrexJoyport;
import de.malban.vide.vecx.panels.AnalogJPanel;
import de.malban.vide.vecx.panels.BreakpointJPanel;
import de.malban.vide.vecx.panels.CartridgePanel;
import de.malban.vide.vecx.panels.JoyportPanel;
import de.malban.vide.vecx.panels.LabelJPanel;
import de.malban.vide.vecx.panels.MemoryDumpPanel;
import de.malban.vide.vecx.panels.PSGJPanel;
import de.malban.vide.vecx.panels.ProfileJPanel;
import de.malban.vide.vecx.panels.RegisterJPanel;
import de.malban.vide.vecx.panels.VIAJPanel;
import de.malban.vide.vecx.panels.VarJPanel;
import de.malban.vide.vecx.panels.VectorInfoJPanel;
import de.malban.vide.vecx.panels.WRTrackerJPanel;
import de.malban.vide.vedi.DebugInfoC;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;

public class VecXPanel
extends JPanel
implements Windowable,
DisplayerInterface,
VecXStatics,
Stateable,
CloseWatcher {
    LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    VideConfig config = VideConfig.getConfig();
    protected CSAView mParent = null;
    protected JMenuItem mParentMenuItem = null;
    protected int mClassSetting = 0;
    VecX vecx;
    boolean cartProp = true;
    BufferedImage overlayImageOrg = null;
    boolean updateAllways = false;
    public boolean stop = false;
    public volatile boolean running = false;
    public boolean pausing = false;
    protected boolean pauseMode = false;
    public boolean debuging = false;
    public boolean stepping = false;
    public boolean mouseMode = false;
    VecXState.vector_t found = null;
    VecXState.vector_t lastfound = null;
    int exitReason = 0;
    Color crossColor = Color.ORANGE;
    boolean noCross = true;
    int mX = 0;
    int mY = 0;
    int mXPressStart = 0;
    int mYPressStart = 0;
    boolean shiftPressed = false;
    boolean mousePressed = false;
    boolean noDissiFirstLine = false;
    Thread one = null;
    boolean dissiInit = false;
    DissiPanel dissi = null;
    RegisterJPanel regi = null;
    VectorInfoJPanel vinfi = null;
    MemoryDumpPanel dumpi = null;
    VIAJPanel viai = null;
    AnalogJPanel ani = null;
    VarJPanel vari = null;
    BreakpointJPanel breaki = null;
    ProfileJPanel profi = null;
    LabelJPanel labi = null;
    WRTrackerJPanel tracki = null;
    PSGJPanel ayi = null;
    JoyportPanel joyi = null;
    CartridgePanel carti = null;
    int startTypeRun = 2;
    boolean ignoreClose = false;
    static String lastOpenedDir = Global.mainPathPrefix;
    private JButton jButtonDebug;
    private JButton jButtonFileSelect1;
    private JButton jButtonLoadState;
    private JButton jButtonPause;
    private JButton jButtonSaveState;
    private JButton jButtonStart;
    private JButton jButtonStop;
    private JCheckBox jCheckBox1;
    private JComboBox jComboBoxJoyport0;
    private JComboBox jComboBoxJoyport1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel5;
    private JLabel jLabelFPS;
    private JPanel jPanel1;
    private JTextField jTextFieldstart;
    boolean waitAMoment = false;
    boolean updatefinished = false;
    boolean ledDir = true;
    int ledStep = 0;
    public static String SID = "Emulator";
    DebugInfoC toSetCDebug = null;
    DebugInfoC usedCDebug = null;
    ArrayList<JoyportDevice> deviceList = null;
    public static int DEVICE_NULL = 0;
    public static int DEVICE_LIGHTPEN = 1;
    public static int DEVICE_VECVOICE = 2;
    public static int DEVICE_VECVOX = 3;
    public static int DEVICE_IMAGER = 4;
    public static int DEVICE_LINKV1_L = 5;
    public static int DEVICE_LINKV1_R = 6;
    public static int DEVICE_LINKV2_L = 7;
    public static int DEVICE_LINKV2_R = 8;
    public static int DEVICE_KEYBOARD_JOYSTICK0 = 9;
    public static int DEVICE_KEYBOARD_JOYSTICK1 = 10;
    public static int DEVICE_KEYBOARD_SPINNER = 11;
    public static int DEVICE_JINPUT_JOYSTICK = 12;
    public static int DEVICE_JINPUT_SPINNER = 13;
    DissiPanel.DissiSwitchData myDissi;
    boolean dissiActive = true;
    boolean ledState = false;
    DisplayPanelInterface displayPanel = null;
    boolean inResize = false;
    boolean ptoggle = false;
    boolean ftoggle = false;
    String forcedOverlay = "";
    int old_x = 0;
    int old_y = 0;

    @Override
    public boolean isLoadSettings() {
        return true;
    }

    public VecXState.vector_t getFound() {
        return this.found;
    }

    public void setFound(VecXState.vector_t v) {
        this.found = v;
    }

    public VectorInfoJPanel getVinfi() {
        return this.vinfi;
    }

    @Override
    public void preClose() {
        this.ignoreClose = true;
    }

    @Override
    public void postClose() {
        this.ignoreClose = false;
    }

    @Override
    public void closing() {
        if (this.ignoreClose) {
            return;
        }
        this.deinit();
        if (this.vecx != null) {
            this.vecx.deinit();
        }
    }

    @Override
    public void setParentWindow(CSAView jpv) {
        this.mParent = jpv;
    }

    @Override
    public boolean isIcon() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return false;
        }
        return frame.getInternalFrame(this).isIcon();
    }

    @Override
    public void setIcon(boolean b) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return;
        }
        try {
            frame.getInternalFrame(this).setIcon(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void setMenuItem(JMenuItem item) {
        this.mParentMenuItem = item;
        this.mParentMenuItem.setText(SID);
    }

    @Override
    public JMenuItem getMenuItem() {
        return this.mParentMenuItem;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    public void deinit() {
        if (this.displayPanel != null) {
            this.displayPanel.deinit();
        }
        this.jButtonStopActionPerformed(null);
        this.resetMe();
        AbstractDevice.exitSync = true;
        DualVec.exitSync = true;
    }

    public VecXPanel() {
        AbstractDevice.exitSync = false;
        DualVec.exitSync = false;
        this.initComponents();
        this.jCheckBox1.setVisible(false);
        this.vecx = new VecX();
        this.ensureDevices();
        this.initJoyportsFromFlag();
        this.vecx.setDisplayer(this);
        this.updatePorts();
        this.changeDisplay();
        new HotKey("Pause/Toggle", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VecXPanel.this.jButtonPauseActionPerformed(null);
            }
        }, this);
        new HotKey("Overlay/Toggle", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VecXPanel.this.config.overlayEnabled = !VecXPanel.this.config.overlayEnabled;
                VecXPanel.this.checkOverlay();
            }
        }, this);
        new HotKey("VecX QuickSave", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VecXPanel.this.jButtonSaveStateActionPerformed(null);
            }
        }, this);
        new HotKey("VecX QuickLoad", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VecXPanel.this.jButtonLoadStateActionPerformed(null);
            }
        }, this);
        new HotKey("RingbufferToggle", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VecXPanel.this.ringbufferToggle();
            }
        }, this);
        new HotKey("Panel/Toggle", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VecXPanel.this.toggleMainPanel();
            }
        }, this);
        new HotKey("FullScreen/Toggle", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VecXPanel.this.toggleFullscreen();
            }
        }, this);
        new HotKey("Quit vecxi", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VecXPanel.this.quitVecxi();
            }
        }, this);
    }

    void ringbufferToggle() {
        this.config.ringbufferActive = !this.config.ringbufferActive;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jComboBoxJoyport1 = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jComboBoxJoyport0 = new JComboBox();
        this.jButtonPause = new JButton();
        this.jButtonStop = new JButton();
        this.jButtonFileSelect1 = new JButton();
        this.jLabelFPS = new JLabel();
        this.jTextFieldstart = new JTextField();
        this.jButtonDebug = new JButton();
        this.jLabel5 = new JLabel();
        this.jButtonLoadState = new JButton();
        this.jButtonSaveState = new JButton();
        this.jButtonStart = new JButton();
        this.jCheckBox1 = new JCheckBox();
        this.setBackground(new Color(0, 0, 0));
        this.setName("vecxy");
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                VecXPanel.this.formMouseDragged(evt);
            }

            @Override
            public void mouseMoved(MouseEvent evt) {
                VecXPanel.this.formMouseMoved(evt);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                VecXPanel.this.formMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                VecXPanel.this.formMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                VecXPanel.this.formMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                VecXPanel.this.formMouseReleased(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                VecXPanel.this.formComponentResized(evt);
            }
        });
        this.setLayout(null);
        this.jPanel1.setPreferredSize(new Dimension(470, 90));
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/Port.png")));
        this.jLabel1.setText("1");
        this.jLabel1.setPreferredSize(new Dimension(43, 21));
        this.jComboBoxJoyport1.setModel(new DefaultComboBoxModel<String>(new String[]{" ", "Keyboard Controler", "Lightpen", "VecVox", "VecVoice", "VecLinkV1", "VecLinkV2", "3d-Imager"}));
        this.jComboBoxJoyport1.setFocusable(false);
        this.jComboBoxJoyport1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VecXPanel.this.jComboBoxJoyport1ActionPerformed(evt);
            }
        });
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/Port.png")));
        this.jLabel2.setText("0");
        this.jLabel2.setPreferredSize(new Dimension(43, 21));
        this.jComboBoxJoyport0.setModel(new DefaultComboBoxModel<String>(new String[]{" ", "Keyboard Controler", "Lightpen"}));
        this.jComboBoxJoyport0.setFocusable(false);
        this.jComboBoxJoyport0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VecXPanel.this.jComboBoxJoyport0ActionPerformed(evt);
            }
        });
        this.jButtonPause.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/control_pause.png")));
        this.jButtonPause.setToolTipText("Pauses current running emulation...");
        this.jButtonPause.setFocusable(false);
        this.jButtonPause.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonPause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VecXPanel.this.jButtonPauseActionPerformed(evt);
            }
        });
        this.jButtonStop.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/control_stop.png")));
        this.jButtonStop.setToolTipText("Stops and unloads ROM!");
        this.jButtonStop.setFocusable(false);
        this.jButtonStop.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VecXPanel.this.jButtonStopActionPerformed(evt);
            }
        });
        this.jButtonFileSelect1.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/folder_go.png")));
        this.jButtonFileSelect1.setFocusable(false);
        this.jButtonFileSelect1.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonFileSelect1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VecXPanel.this.jButtonFileSelect1ActionPerformed(evt);
            }
        });
        this.jLabelFPS.setFont(new Font("Geneva", 0, 8));
        this.jLabelFPS.setText("0");
        this.jLabelFPS.setPreferredSize(new Dimension(5, 21));
        this.jTextFieldstart.setText("FROGGER.BIN");
        this.jTextFieldstart.setFocusable(false);
        this.jTextFieldstart.setName("vecxy");
        this.jTextFieldstart.setPreferredSize(new Dimension(75, 21));
        this.jButtonDebug.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/bug_go.png")));
        this.jButtonDebug.setToolTipText("Associate dissi with this vecx instance.");
        this.jButtonDebug.setFocusable(false);
        this.jButtonDebug.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonDebug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VecXPanel.this.jButtonDebugActionPerformed(evt);
            }
        });
        this.jLabel5.setHorizontalAlignment(11);
        this.jLabel5.setText("Bin File");
        this.jLabel5.setPreferredSize(new Dimension(38, 21));
        this.jButtonLoadState.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_go.png")));
        this.jButtonLoadState.setToolTipText("load state");
        this.jButtonLoadState.setFocusable(false);
        this.jButtonLoadState.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonLoadState.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VecXPanel.this.jButtonLoadStateActionPerformed(evt);
            }
        });
        this.jButtonSaveState.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_save.png")));
        this.jButtonSaveState.setToolTipText("save state");
        this.jButtonSaveState.setFocusable(false);
        this.jButtonSaveState.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonSaveState.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VecXPanel.this.jButtonSaveStateActionPerformed(evt);
            }
        });
        this.jButtonStart.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/control_play.png")));
        this.jButtonStart.setToolTipText("<html>Starts selected ROM, no effect if running!<BR>\nSHIFT click resets and starts new!\n</html>\n");
        this.jButtonStart.setAlignmentY(0.0f);
        this.jButtonStart.setFocusable(false);
        this.jButtonStart.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VecXPanel.this.jButtonStartActionPerformed(evt);
            }
        });
        this.jCheckBox1.setText("Peer Output");
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VecXPanel.this.jCheckBox1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5, -1, -1, -2).addComponent(this.jLabel2, -1, -1, -2)).addGap(10, 10, 10).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jTextFieldstart, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonFileSelect1).addGap(2, 2, 2).addComponent(this.jLabelFPS, -2, 18, -2).addGap(0, 0, 0).addComponent(this.jButtonStart).addGap(5, 5, 5).addComponent(this.jButtonPause).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonStop).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSaveState).addGap(6, 6, 6).addComponent(this.jButtonLoadState).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDebug).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jComboBoxJoyport0, 0, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1, -2, 53, -2).addComponent(this.jComboBoxJoyport1, 0, -1, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox1, -2, 103, -2).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextFieldstart, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel5, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonLoadState, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonSaveState, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonStop, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonPause, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonStart, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonFileSelect1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelFPS, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonDebug, -1, -1, Short.MAX_VALUE)).addGap(2, 2, 2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2, -2, 21, -2).addComponent(this.jComboBoxJoyport0, -2, 21, -2)).addGap(2, 2, 2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jComboBoxJoyport1, -2, 21, -2)).addGap(0, 23, Short.MAX_VALUE)).addComponent(this.jCheckBox1, -1, -1, Short.MAX_VALUE));
        this.add(this.jPanel1);
        this.jPanel1.setBounds(0, 0, 380, 90);
        this.jPanel1.getAccessibleContext().setAccessibleDescription("");
    }

    public void resetCurrent() {
        this.jButtonStopActionPerformed(null);
        this.jButtonStartActionPerformed(null);
    }

    public void resetCurrent(boolean softreset) {
        if (this.isPausing()) {
            this.vecx.vecx_reset(!softreset);
        } else {
            this.jButtonPauseActionPerformed(null);
            this.vecx.vecx_reset(!softreset);
            this.jButtonPauseActionPerformed(null);
        }
    }

    public void startUp(String path) {
        this.startUp(path, true);
    }

    public void startUp(String path, boolean checkCartridge) {
        this.startUp(path, checkCartridge, 2);
    }

    public String getStartName() {
        return this.jTextFieldstart.getText();
    }

    public void startUp(String path, boolean checkCartridge, int runType) {
        this.startTypeRun = runType;
        this.changeDisplay();
        if (runType != 3) {
            this.jButtonStopActionPerformed(null);
        }
        this.jTextFieldstart.setText(path);
        this.cartProp = false;
        this.jButtonStartActionPerformed(null);
        this.cartProp = true;
        this.jTextFieldstart.setText("");
    }

    public void startBin(String path) {
        this.startTypeRun = 2;
        this.changeDisplay();
        this.jTextFieldstart.setText(path);
        this.cartProp = true;
        this.jButtonStartActionPerformed(null);
    }

    public boolean loadOverlay(String name) {
        try {
            this.overlayImageOrg = null;
            if (this.forcedOverlay != null && this.forcedOverlay.length() != 0) {
                this.overlayImageOrg = ImageCache.getImageCache().getImage(this.forcedOverlay);
            }
            if (this.overlayImageOrg == null) {
                Path base = Paths.get(Global.mainPathPrefix, new String[0]);
                Path fromPath = base.resolve(Paths.get(name, new String[0]));
                String pathOnly = fromPath.getParent().toString();
                if (pathOnly == null) {
                    pathOnly = Global.mainPathPrefix + File.separator;
                }
                if (!pathOnly.endsWith(File.separator)) {
                    pathOnly = pathOnly + File.separator;
                }
                String fName = fromPath.getFileName().toString();
                String fullname = fromPath.toString();
                fullname = UtilityString.replaceCI(fullname, ".rom", ".png");
                fullname = UtilityString.replaceCI(fullname, ".bin", ".png");
                fullname = UtilityString.replaceCI(fullname, ".vec", ".png");
                name = UtilityString.replaceCI(fName, ".rom", ".png");
                name = UtilityString.replaceCI(name, ".bin", ".png");
                name = UtilityString.replaceCI(name, ".vec", ".png");
                this.overlayImageOrg = ImageCache.getImageCache().getImage(Global.mainPathPrefix + "overlays" + File.separator + name);
                if (this.overlayImageOrg == null) {
                    this.overlayImageOrg = ImageCache.getImageCache().getImage(name);
                }
                if (this.overlayImageOrg == null) {
                    this.overlayImageOrg = ImageCache.getImageCache().getImage(Global.mainPathPrefix + File.separator + name);
                }
                if (this.overlayImageOrg == null) {
                    this.overlayImageOrg = ImageCache.getImageCache().getImage(Global.mainPathPrefix + File.separator + "overlays" + File.separator + name);
                }
                if (this.overlayImageOrg == null) {
                    this.overlayImageOrg = ImageCache.getImageCache().getImage(Global.mainPathPrefix + File.separator + "overlays" + File.separator + "homemade" + File.separator + name);
                }
                if (this.overlayImageOrg == null) {
                    this.overlayImageOrg = ImageCache.getImageCache().getImage(fullname);
                }
                if (this.overlayImageOrg == null) {
                    this.overlayImageOrg = ImageCache.getImageCache().getImage(pathOnly + "overlays" + File.separator + name);
                }
                if (this.overlayImageOrg == null) {
                    this.overlayImageOrg = ImageCache.getImageCache().getImage(pathOnly + name);
                }
                if (this.overlayImageOrg == null) {
                    this.overlayImageOrg = ImageCache.getImageCache().getImage(pathOnly + ".." + File.separator + "overlays" + File.separator + name);
                }
                if (this.overlayImageOrg == null) {
                    this.overlayImageOrg = ImageCache.getImageCache().getImage(pathOnly + ".." + File.separator + name);
                }
                if (this.overlayImageOrg == null) {
                    this.overlayImageOrg = ImageCache.getImageCache().getImage(pathOnly + "overlay" + File.separator + name);
                }
                if (this.overlayImageOrg == null) {
                    this.overlayImageOrg = ImageCache.getImageCache().getImage(pathOnly + name);
                }
                if (this.overlayImageOrg == null) {
                    this.overlayImageOrg = ImageCache.getImageCache().getImage(pathOnly + ".." + File.separator + "overlay" + File.separator + name);
                }
                if (this.overlayImageOrg == null) {
                    this.overlayImageOrg = ImageCache.getImageCache().getImage(pathOnly + ".." + File.separator + name);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.overlayImageOrg == null && name.toUpperCase().contains("SYSTEM")) {
            this.overlayImageOrg = ImageCache.getImageCache().getImage(Global.mainPathPrefix + "overlays" + File.separator + "mine.png");
        }
        if (this.overlayImageOrg == null) {
            return false;
        }
        this.overlayChanged();
        return true;
    }

    private void createDissi() {
        CSAMainFrame f = (CSAMainFrame)this.mParent;
        this.dissi = f.getDissi();
    }

    public void run() {
        if (this.isDebuging()) {
            this.debugAction();
        }
    }

    public void debugAction() {
        this.vecx.directDrawActive = true;
        this.updatefinished = true;
        if (this.isDebuging()) {
            this.stepping = false;
            this.stopDebug(false);
            this.vecx.config.syncCables = false;
            return;
        }
        if (!this.isRunning()) {
            this.vecx.init(this.jTextFieldstart.getText());
            this.initJoyportsFromFlag();
            if (this.config.overlayEnabled) {
                this.loadOverlay(this.vecx.romName);
            }
            this.stop = true;
            this.startDebug();
            if (this.dissi == null) {
                this.createDissi();
                if (this.dissi == null) {
                    return;
                }
            }
            this.setDissi(this.dissi);
            this.dissi.dis(this.vecx.cart);
            this.dissiInit = true;
            this.checkWindows();
            this.oneStep();
        } else {
            this.vecx.config.debugingCore = true;
            this.vecx.directDrawActive = true;
            this.startDebug();
            if (!this.dissiInit) {
                if (this.dissi == null) {
                    this.createDissi();
                    if (this.dissi == null) {
                        return;
                    }
                }
                this.setDissi(this.dissi);
                if (this.regi != null) {
                    this.regi.setDissi(this.dissi);
                }
                this.dissi.dis(this.vecx.cart);
                this.dissiInit = true;
            }
            this.checkWindows();
            this.oneStep();
        }
    }

    void quitVecxi() {
        if (this.config.doExitAfterVecxi) {
            this.jButtonStopActionPerformed(null);
            ((CSAMainFrame)this.mParent).doExit();
        }
    }

    private void formComponentResized(ComponentEvent evt) {
        this.forceResize();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VecXPanel.this.forceResize();
            }
        });
    }

    public void debugFrameUndoAction(int s) {
        this.updatefinished = true;
        if (!this.isDebuging()) {
            return;
        }
        if (this.stepping) {
            return;
        }
        this.vecx.stepBackInFrameRingbuffer(s);
        this.updateDisplay();
        this.repaint();
        int PC = 0;
        try {
            PC = this.vecx.e6809.reg_pc;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.updateAvailableWindows(true, false, true, PC);
    }

    public void debugFrameRedoAction(int s) {
        this.updatefinished = true;
        if (!this.isDebuging()) {
            return;
        }
        if (this.stepping) {
            return;
        }
        this.vecx.stepForwardInFrameRingbuffer(s);
        this.updateDisplay();
        this.repaint();
        int PC = 0;
        try {
            PC = this.vecx.e6809.reg_pc;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.updateAvailableWindows(true, false, true, PC);
    }

    public void debugUndoAction(int s) {
        if (!this.isDebuging()) {
            return;
        }
        if (this.stepping) {
            return;
        }
        this.vecx.stepBackInSSRingbuffer(s);
        this.updateDisplay();
        this.repaint();
        int PC = 0;
        try {
            PC = this.vecx.e6809.reg_pc;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.updateAvailableWindows(true, false, true, PC);
    }

    public void debugRedoAction(int s) {
        if (!this.isDebuging()) {
            return;
        }
        if (this.stepping) {
            return;
        }
        this.vecx.stepForwardInSSRingbuffer(s);
        this.updateDisplay();
        this.repaint();
        int PC = 0;
        try {
            PC = this.vecx.e6809.reg_pc;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.updateAvailableWindows(true, false, true, PC);
    }

    public void debugStepoutAction() {
        this.updatefinished = true;
        if (!this.isDebuging()) {
            return;
        }
        if (this.stepping) {
            return;
        }
        int adr = this.vecx.getStepoutAddress();
        if (adr == -1) {
            return;
        }
        Breakpoint bp = new Breakpoint();
        bp.targetAddress = adr;
        bp.targetBank = this.vecx.cart.getCurrentBank();
        bp.targetType = Breakpoint.BP_TARGET_CPU;
        bp.targetSubType = Breakpoint.BP_SUBTARGET_CPU_PC;
        bp.type = Breakpoint.BP_COMPARE | Breakpoint.BP_ONCE | Breakpoint.BP_QUIET;
        this.breakpointMemorySet(bp);
        this.vecx.directDrawActive = true;
        this.stopDebug(false);
    }

    public void debugOverstepAction() {
        this.updatefinished = true;
        if (!this.isDebuging()) {
            return;
        }
        if (this.stepping) {
            return;
        }
        this.noDissiFirstLine = true;
        if (this.dissi == null) {
            return;
        }
        int adr = this.vecx.e6809.reg_pc;
        if (!this.dissi.hasBreakpoint(adr += this.dissi.getInstructionLengthAt(adr), this.vecx.cart.getCurrentBank())) {
            Breakpoint bp = new Breakpoint();
            bp.targetAddress = adr;
            bp.targetBank = this.vecx.cart.getCurrentBank();
            bp.targetType = Breakpoint.BP_TARGET_CPU;
            bp.targetSubType = Breakpoint.BP_SUBTARGET_CPU_PC;
            bp.type = Breakpoint.BP_COMPARE | Breakpoint.BP_ONCE | Breakpoint.BP_QUIET;
            this.breakpointMemorySet(bp);
        }
        this.vecx.directDrawActive = true;
        this.stopDebug(false);
    }

    public void debugBreakpointAction() {
        this.updatefinished = true;
        if (this.stepping) {
            return;
        }
        if (this.dissi == null) {
            return;
        }
        int adr = this.dissi.getCurrentAddress();
        if (adr == -1) {
            return;
        }
        Breakpoint bp = new Breakpoint();
        bp.targetAddress = adr;
        bp.targetBank = this.dissi.getCurrentBank();
        bp.targetType = Breakpoint.BP_TARGET_CPU;
        bp.targetSubType = Breakpoint.BP_SUBTARGET_CPU_PC;
        bp.type = Breakpoint.BP_COMPARE | Breakpoint.BP_MULTI;
        this.breakpointAddressToggle(bp);
    }

    public void debugMultistepAction() {
        this.updatefinished = true;
        if (!this.isDebuging()) {
            return;
        }
        if (this.pausing) {
            this.pausing = false;
        }
        if (this.stepping) {
            this.stepping = false;
            this.startDebug();
            if (!this.dissiInit) {
                if (this.dissi == null) {
                    this.createDissi();
                    if (this.dissi == null) {
                        return;
                    }
                }
                this.setDissi(this.dissi);
                if (this.regi != null) {
                    this.regi.setDissi(this.dissi);
                }
                this.dissi.dis(this.vecx.cart);
                this.dissiInit = true;
            }
            this.oneStep();
        } else {
            this.stepping = true;
            this.start();
        }
    }

    public void debugStepAction() {
        this.updatefinished = true;
        if (this.stepping) {
            this.debugMultistepAction();
            return;
        }
        if (this.isDebuging()) {
            this.oneStep();
            return;
        }
    }

    public boolean isMouseMode() {
        return this.mouseMode;
    }

    public void setMouseMode(boolean b) {
        this.mouseMode = b;
    }

    private void formMouseMoved(MouseEvent evt) {
        if (!this.mouseMode && !this.deviceList.get(DEVICE_LIGHTPEN).isActive()) {
            return;
        }
        this.mX = evt.getX();
        this.mY = evt.getY();
        if (!this.mouseMode) {
            return;
        }
        this.crossColor = Color.ORANGE;
        this.noCross = false;
        this.repaint();
    }

    public Color getCrossColor() {
        return this.crossColor;
    }

    public boolean isCrossDisabled() {
        return this.noCross;
    }

    private void formMouseExited(MouseEvent evt) {
        this.noCross = true;
    }

    private void formMouseEntered(MouseEvent evt) {
        this.noCross = false;
    }

    private void formMousePressed(MouseEvent evt) {
        if (this.config.tryJOGL && this.displayPanel instanceof VecxiPanel_JOGL) {
            ((VecxiPanel_JOGL)this.displayPanel).getCorrectFocus();
        }
        if (!this.mouseMode && !this.deviceList.get(DEVICE_LIGHTPEN).isActive()) {
            return;
        }
        this.shiftPressed = false;
        if (evt.getButton() == 1) {
            this.mousePressed = true;
            this.mXPressStart = evt.getX();
            this.mYPressStart = evt.getY();
            if (evt != null) {
                boolean bl = this.shiftPressed = (evt.getModifiers() & 1) == 1;
            }
        }
        if (!this.mouseMode) {
            return;
        }
        this.crossColor = Color.GREEN;
        this.updateVectorInfo();
        this.repaint();
    }

    private void formMouseReleased(MouseEvent evt) {
        if (!this.mouseMode && !this.deviceList.get(DEVICE_LIGHTPEN).isActive()) {
            return;
        }
        if (evt.getButton() == 1) {
            this.mousePressed = false;
            if (evt != null) {
                boolean bl = this.shiftPressed = (evt.getModifiers() & 1) == 1;
            }
        }
        if (this.deviceList.get(DEVICE_LIGHTPEN).isActive()) {
            this.unsetLightPen();
        }
        if (!this.mouseMode) {
            return;
        }
        this.crossColor = Color.ORANGE;
        this.repaint();
    }

    public boolean isMousePressed() {
        return this.mousePressed;
    }

    public int getMouseX() {
        return this.mX;
    }

    public int getMouseY() {
        if (this.jPanel1.isVisible()) {
            return this.mY - this.jPanel1.getHeight();
        }
        return this.mY;
    }

    private void formMouseDragged(MouseEvent evt) {
        if (!this.mouseMode && !this.deviceList.get(DEVICE_LIGHTPEN).isActive()) {
            return;
        }
        this.mX = evt.getX();
        this.mY = evt.getY();
        if (!this.mouseMode) {
            return;
        }
        this.crossColor = Color.GREEN;
        this.noCross = false;
        this.repaint();
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        this.vecx.setPeerOutputEnabled(this.jCheckBox1.isSelected());
    }

    private void jButtonStartActionPerformed(ActionEvent evt) {
        this.updatefinished = true;
        this.usedCDebug = null;
        boolean doRestart = false;
        if (evt != null && (evt.getModifiers() & 1) == 1) {
            this.jButtonStopActionPerformed(evt);
            doRestart = true;
        }
        if (this.startTypeRun != 3) {
            if (this.stepping) {
                this.debugMultistepAction();
            }
            if (this.isDebuging()) {
                this.oneStep();
                return;
            }
            if (this.isPausing()) {
                this.cont();
                return;
            }
            if (this.isRunning()) {
                return;
            }
        } else {
            this.stop = true;
            while (this.running) {
            }
        }
        if (this.config.debugingCore) {
            if (this.dissi == null) {
                this.createDissi();
                if (this.dissi == null) {
                    return;
                }
            }
            this.setDissi(this.dissi);
        }
        if (this.startTypeRun != 3) {
            boolean ok = this.vecx.init(this.jTextFieldstart.getText(), this.cartProp, true, doRestart);
            if (!ok) {
                return;
            }
            if (this.dissi != null) {
                this.dissi.dis(this.vecx.cart);
                if (this.startTypeRun == 1) {
                    this.dissi.setStartbreakpoint();
                }
            }
            if (this.config.overlayEnabled) {
                this.loadOverlay(this.jTextFieldstart.getText());
            }
            this.checkWindows();
            this.initJoyportsFromFlag();
        } else {
            this.vecx.inject(this.jTextFieldstart.getText(), this.cartProp);
            if (this.dissi != null) {
                this.dissi.dis(this.vecx.cart);
            }
        }
        if (this.config.debugingCore) {
            this.dissiInit = true;
            this.dissi.processHeyDissis();
        }
        this.stop = true;
        this.setLED(0);
        this.changeDisplay();
        this.updatePorts();
        if (this.startTypeRun != 3) {
            this.start();
        } else if (!this.isDebuging() && !this.stepping) {
            this.start();
        }
    }

    private void jButtonSaveStateActionPerformed(ActionEvent evt) {
        LocalDateTime ldt = LocalDateTime.now();
        VeryCompleteState vcs = null;
        if (evt != null) {
            boolean bl = this.shiftPressed = (evt.getModifiers() & 1) == 1;
            if (this.shiftPressed) {
                vcs = new VeryCompleteState();
                vcs.breakpoints = this.vecx.breakpoints;
                vcs.SS_RING_BUFFER_SIZE = VecX.SS_RING_BUFFER_SIZE;
                vcs.ringSSWalkStep = this.vecx.ringSSWalkStep;
                vcs.ringSSBufferNext = this.vecx.ringSSBufferNext;
                vcs.goSSBackRingBuffer = this.vecx.goSSBackRingBuffer;
                vcs.FRAME_RING_BUFFER_SIZE = VecX.FRAME_RING_BUFFER_SIZE;
                vcs.ringFrameWalkStep = this.vecx.ringFrameWalkStep;
                vcs.ringFrameBufferNext = this.vecx.ringFrameBufferNext;
                vcs.goFrameBackRingBuffer = this.vecx.goFrameBackRingBuffer;
            }
        }
        if (!this.running && !this.debuging) {
            return;
        }
        if (this.stop) {
            if (this.debuging) {
                CompleteState state = this.vecx.getState();
                state.additional = vcs;
                if (this.vecx.joyport[0] != null && this.vecx.joyport[0].getDevice() != null) {
                    state.deviceID0 = this.vecx.joyport[0].getDevice().getDeviceID();
                    state.deviceName0 = this.vecx.joyport[0].getDevice().getDeviceName();
                }
                if (this.vecx.joyport[1] != null && this.vecx.joyport[1].getDevice() != null) {
                    state.deviceID1 = this.vecx.joyport[1].getDevice().getDeviceID();
                    state.deviceName1 = this.vecx.joyport[1].getDevice().getDeviceName();
                }
                CSAMainFrame.serialize(state, Global.mainPathPrefix + "serialize" + File.separator + "StateSaveTest.ser");
                CSAMainFrame.serialize(state, Global.mainPathPrefix + "serialize" + File.separator + "StateSaveTest_" + ldt.toString().replace(':', '_') + ".ser");
                state.additional = null;
            }
            return;
        }
        if (!this.isPausing()) {
            this.pause();
            while (!this.pauseMode) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(VecXPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            CompleteState state = this.vecx.getState();
            state.additional = vcs;
            if (this.vecx.joyport[0] != null && this.vecx.joyport[0].getDevice() != null) {
                state.deviceID0 = this.vecx.joyport[0].getDevice().getDeviceID();
                state.deviceName0 = this.vecx.joyport[0].getDevice().getDeviceName();
            }
            if (this.vecx.joyport[1] != null && this.vecx.joyport[1].getDevice() != null) {
                state.deviceID1 = this.vecx.joyport[1].getDevice().getDeviceID();
                state.deviceName1 = this.vecx.joyport[1].getDevice().getDeviceName();
            }
            CSAMainFrame.serialize(state, Global.mainPathPrefix + "serialize" + File.separator + "StateSaveTest.ser");
            CSAMainFrame.serialize(state, Global.mainPathPrefix + "serialize" + File.separator + "StateSaveTest_" + ldt.toString() + ".ser");
            state.additional = null;
            this.cont();
            return;
        }
        CompleteState state = this.vecx.getState();
        state.additional = vcs;
        if (this.vecx.joyport[0] != null && this.vecx.joyport[0].getDevice() != null) {
            state.deviceID0 = this.vecx.joyport[0].getDevice().getDeviceID();
            state.deviceName0 = this.vecx.joyport[0].getDevice().getDeviceName();
        }
        if (this.vecx.joyport[1] != null && this.vecx.joyport[1].getDevice() != null) {
            state.deviceID1 = this.vecx.joyport[1].getDevice().getDeviceID();
            state.deviceName1 = this.vecx.joyport[1].getDevice().getDeviceName();
        }
        CSAMainFrame.serialize(state, Global.mainPathPrefix + "serialize" + File.separator + "StateSaveTest.ser");
        CSAMainFrame.serialize(state, Global.mainPathPrefix + "serialize" + File.separator + "StateSaveTest_" + ldt.toString() + ".ser");
        state.additional = null;
    }

    private void jButtonLoadStateActionPerformed(ActionEvent evt) {
        boolean oldPause = this.isPausing();
        boolean oldDebug = this.debuging;
        this.updatefinished = true;
        this.stop();
        this.dissiInit = false;
        CompleteState state = (CompleteState)CSAMainFrame.deserialize(Global.mainPathPrefix + "serialize" + File.separator + "StateSaveTest.ser");
        if (state == null) {
            return;
        }
        if (!this.vecx.putState(state)) {
            return;
        }
        ++this.mClassSetting;
        if (state.deviceID0 != -1) {
            JoyportDevice device = this.getDevice(state.deviceID0, state.deviceName0);
            this.vecx.joyport[0].plugIn(device);
            if (device == null) {
                this.jComboBoxJoyport0.setSelectedIndex(-1);
            } else {
                this.jComboBoxJoyport0.setSelectedItem(device);
            }
        }
        if (state.deviceID1 != -1) {
            JoyportDevice device1;
            if (state.deviceID1 == DEVICE_IMAGER) {
                device1 = this.vecx.joyport[1].getDevice();
                if (device1 != null && device1 instanceof Imager3dDevice) {
                    this.replaceDeviceInList(device1);
                    this.jComboBoxJoyport1.setSelectedItem(this.vecx.joyport[1].getDevice());
                }
            } else {
                device1 = this.getDevice(state.deviceID1, state.deviceName1);
                this.vecx.joyport[1].plugIn(device1);
            }
            if (device1 == null) {
                this.jComboBoxJoyport1.setSelectedIndex(-1);
            } else {
                this.jComboBoxJoyport1.setSelectedItem(device1);
            }
        }
        --this.mClassSetting;
        if (state.additional != null && state.additional instanceof VeryCompleteState) {
            VeryCompleteState vcs = (VeryCompleteState)state.additional;
            this.vecx.breakpoints = vcs.breakpoints;
            this.setAllBreakpoints(vcs.breakpoints);
            VecX.SS_RING_BUFFER_SIZE = vcs.SS_RING_BUFFER_SIZE;
            this.vecx.ringSSWalkStep = vcs.ringSSWalkStep;
            this.vecx.ringSSBufferNext = vcs.ringSSBufferNext;
            this.vecx.goSSBackRingBuffer = vcs.goSSBackRingBuffer;
            VecX.FRAME_RING_BUFFER_SIZE = vcs.FRAME_RING_BUFFER_SIZE;
            this.vecx.ringFrameWalkStep = vcs.ringFrameWalkStep;
            this.vecx.ringFrameBufferNext = vcs.ringFrameBufferNext;
            this.vecx.goFrameBackRingBuffer = vcs.goFrameBackRingBuffer;
        }
        this.jTextFieldstart.setText(this.vecx.romName);
        this.overlayImageOrg = null;
        if (this.config.overlayEnabled) {
            this.loadOverlay(this.vecx.romName);
        }
        if (this.dissi == null) {
            this.createDissi();
            if (this.dissi == null) {
                return;
            }
        }
        this.setDissi(this.dissi);
        this.dissi.dis(this.vecx.cart);
        this.dissi.setDissiBank(this.vecx.cart.getCurrentBank());
        this.dissiInit = true;
        if (this.config.overlayEnabled) {
            this.loadOverlay(this.jTextFieldstart.getText());
        }
        this.dissi.processHeyDissis();
        this.checkWindows();
        this.changeDisplay();
        this.waitAMoment = true;
        this.start();
        if (oldPause) {
            while (!this.running) {
            }
            this.pause();
        }
        if (oldDebug) {
            while (!this.running) {
            }
            this.debugAction();
        }
        this.waitAMoment = false;
    }

    private void jButtonDebugActionPerformed(ActionEvent evt) {
        this.ensureMyDissi();
    }

    private void jButtonFileSelect1ActionPerformed(ActionEvent evt) {
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        if (!this.config.useLastKnownDir || lastOpenedDir == null || lastOpenedDir.length() == 0) {
            fc.setCurrentDirectory(new File(this.config.fileRequestHome));
        } else {
            fc.setCurrentDirectory(new File(lastOpenedDir));
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Binaries (bin, vec, img)", "bin", "vec", "img");
        fc.setFileFilter(filter);
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return;
        }
        String name = fc.getSelectedFile().getAbsolutePath();
        lastOpenedDir = new File(name).getAbsolutePath();
        this.jTextFieldstart.setText(name);
    }

    private void jButtonStopActionPerformed(ActionEvent evt) {
        this.updatefinished = true;
        this.stop();
        if (this.dissi != null) {
            this.dissi.deinit();
        }
        this.dissiInit = false;
        this.overlayImageOrg = null;
        this.overlayChanged();
    }

    private void jButtonPauseActionPerformed(ActionEvent evt) {
        this.updatefinished = true;
        if (this.isPausing()) {
            this.cont();
            return;
        }
        this.pause();
    }

    private void jComboBoxJoyport0ActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        AbstractDevice.exitSync = false;
        this.vecx.joyport[0].plugIn((JoyportDevice)this.jComboBoxJoyport0.getSelectedItem());
        this.updatePorts();
    }

    private void jComboBoxJoyport1ActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        this.vecx.joyport[1].plugIn((JoyportDevice)this.jComboBoxJoyport1.getSelectedItem());
        AbstractDevice.exitSync = false;
        this.updatePorts();
    }

    public void setUpdateAllways(boolean b) {
        this.updateAllways = b;
    }

    public void showDumpi() {
        if (this.dumpi == null) {
            this.dumpi = Configuration.getConfiguration().getMainFrame().getDumpy();
            if (this.dumpi == null) {
                return;
            }
            this.dumpi.setDissi(this.dissi);
        }
        this.dumpi.setIcon(false);
        this.dumpi.setVecxy(this);
        this.dumpi.updateValues(true);
        Configuration.getConfiguration().getMainFrame().toFront(this.dumpi);
    }

    public void showTracki() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (this.tracki == null) {
            this.tracki = frame.getWRTracker();
        }
        if (this.tracki == null) {
            return;
        }
        this.tracki.setIcon(false);
        this.tracki.setVecxy(this);
        this.tracki.updateValues(true);
        Configuration.getConfiguration().getMainFrame().toFront(this.tracki);
    }

    public void showViai() {
        if (this.viai == null) {
            this.viai = Configuration.getConfiguration().getMainFrame().getViay();
        }
        if (this.viai == null) {
            return;
        }
        this.viai.setVecxy(this);
        this.viai.updateValues(true);
        this.viai.setIcon(false);
        if (this.ani == null) {
            this.ani = Configuration.getConfiguration().getMainFrame().getAni();
        }
        if (this.ani == null) {
            return;
        }
        this.ani.setIcon(false);
        this.ani.setVecxy(this);
        this.ani.updateValues(true);
        Configuration.getConfiguration().getMainFrame().toFront(this.viai);
        Configuration.getConfiguration().getMainFrame().toFront(this.ani);
    }

    public void showVari() {
        if (this.dissi == null) {
            return;
        }
        if (this.vari == null) {
            this.vari = Configuration.getConfiguration().getMainFrame().getVari();
        }
        if (this.vari == null) {
            return;
        }
        this.vari.setVecxy(this);
        this.vari.setIcon(false);
        this.vari.setDissi(this.dissi);
        this.vari.updateValues(true);
        Configuration.getConfiguration().getMainFrame().toFront(this.vari);
    }

    public void showVari(int address) {
        this.showVari();
        if (this.dissi == null) {
            return;
        }
        if (this.vari == null) {
            return;
        }
        this.vari.setSelectedAddress(address);
    }

    public void showLabi() {
        if (this.dissi == null) {
            return;
        }
        if (this.labi == null) {
            this.labi = Configuration.getConfiguration().getMainFrame().getLabi();
        }
        if (this.labi == null) {
            return;
        }
        this.labi.setVecxy(this);
        this.labi.setIcon(false);
        this.labi.setDissi(this.dissi);
        this.labi.updateValues(true);
        Configuration.getConfiguration().getMainFrame().toFront(this.labi);
    }

    public void showPSG() {
        if (this.dissi == null) {
            return;
        }
        if (this.ayi == null) {
            this.ayi = Configuration.getConfiguration().getMainFrame().getAyi();
        }
        if (this.ayi == null) {
            return;
        }
        this.ayi.setVecxy(this);
        this.ayi.setIcon(false);
        this.ayi.setDissi(this.dissi);
        this.ayi.updateValues(true);
        Configuration.getConfiguration().getMainFrame().toFront(this.ayi);
    }

    public void showProfiling() {
        if (this.dissi == null) {
            return;
        }
        if (this.profi == null) {
            this.profi = Configuration.getConfiguration().getMainFrame().getProfi();
        }
        if (this.profi == null) {
            return;
        }
        this.profi.setIcon(false);
        this.profi.setVecxy(this);
        this.profi.setDissi(this.dissi);
        this.profi.updateValues(true);
        Configuration.getConfiguration().getMainFrame().toFront(this.profi);
    }

    public void showBreakpoints() {
        if (this.dissi == null) {
            return;
        }
        if (this.breaki == null) {
            this.breaki = Configuration.getConfiguration().getMainFrame().getBreaki();
        }
        if (this.breaki == null) {
            return;
        }
        this.breaki.setIcon(false);
        this.breaki.setVecxy(this);
        this.breaki.setDissi(this.dissi);
        this.breaki.updateValues(true);
        Configuration.getConfiguration().getMainFrame().toFront(this.breaki);
    }

    public void showJoyportDevices() {
        if (this.dissi == null) {
            return;
        }
        if (this.joyi == null) {
            this.joyi = Configuration.getConfiguration().getMainFrame().getJoyportDevice();
        }
        if (this.joyi == null) {
            return;
        }
        this.joyi.setIcon(false);
        this.joyi.setVecxy(this);
        this.joyi.setDissi(this.dissi);
        this.joyi.updateValues(true);
        Configuration.getConfiguration().getMainFrame().toFront(this.joyi);
    }

    public void showCartridges() {
        if (this.dissi == null) {
            return;
        }
        if (this.carti == null) {
            this.carti = Configuration.getConfiguration().getMainFrame().getCartridge();
        }
        if (this.carti == null) {
            return;
        }
        this.carti.setIcon(false);
        this.carti.setVecxy(this);
        this.carti.setDissi(this.dissi);
        this.carti.updateValues(true);
        Configuration.getConfiguration().getMainFrame().toFront(this.carti);
    }

    public void start() {
        if (this.one != null) {
            return;
        }
        if (!this.stop) {
            return;
        }
        this.one = new Thread("Vecxi-emulation"){

            @Override
            public void run() {
                VecXPanel.this.stop = false;
                VecXPanel.this.running = true;
                long measureTime = System.currentTimeMillis();
                long measureCycles = 0L;
                while (!VecXPanel.this.stop) {
                    long startTime2;
                    int PC;
                    long startTime = System.currentTimeMillis();
                    if (!VecXPanel.this.pausing) {
                        int cyclesToRun = 30000;
                        if (VecXPanel.this.stepping) {
                            cyclesToRun = 1;
                            VecXPanel.this.vecx.directDrawActive = true;
                        }
                        VecXPanel.this.setLightPen();
                        if (VecXPanel.this.waitAMoment) {
                            cyclesToRun = 1;
                        }
                        boolean bs = VecXPanel.this.config.breakpointsActive;
                        VecXPanel.this.config.breakpointsActive = VecXPanel.this.config.debugingCore;
                        VecXPanel.this.exitReason = VecXPanel.this.config.debugingCore ? VecXPanel.this.vecx.vecx_emu(cyclesToRun) : VecXPanel.this.vecx.vecx_emu_plain(cyclesToRun);
                        VecXPanel.this.config.breakpointsActive = bs;
                        measureCycles += VecXPanel.this.vecx.cyclesDone;
                        VecXPanel.this.vecx.directDrawActive = false;
                        if (VecXPanel.this.exitReason == 3) {
                            VecXPanel.this.vecx.config.syncCables = true;
                            VecXPanel.this.stepping = false;
                            break;
                        }
                        if (VecXPanel.this.exitReason == 2) {
                            VecXPanel.this.breakpointHandleContinue(VecXPanel.this.vecx.activeBreakpoint);
                        }
                    } else {
                        VecXPanel.this.pauseMode = true;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                VecXPanel.this.updateDisplay();
                                VecXPanel.this.repaint();
                            }
                        });
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException cyclesToRun) {
                            // empty catch block
                        }
                    }
                    if (VecXPanel.this.stepping) {
                        try {
                            int PC1 = 0;
                            try {
                                PC1 = VecXPanel.this.vecx.e6809.reg_pc;
                            }
                            catch (Throwable bs) {
                                // empty catch block
                            }
                            PC = PC1;
                            VecXPanel.this.updatefinished = false;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    VecXPanel.this.updateDisplay();
                                    VecXPanel.this.updateAvailableWindows(true, false, true, false, PC);
                                    VecXPanel.this.updatefinished = true;
                                }
                            });
                            if (VecXPanel.this.config.multiStepDelay > 0) {
                                Thread.sleep(VecXPanel.this.config.multiStepDelay);
                            }
                            while (!VecXPanel.this.updatefinished) {
                                Thread.sleep(0L, 1);
                            }
                            continue;
                        }
                        catch (InterruptedException PC1) {
                            continue;
                        }
                    }
                    int PC1 = 0;
                    try {
                        PC1 = VecXPanel.this.vecx.e6809.reg_pc;
                    }
                    catch (Throwable PC2) {
                        // empty catch block
                    }
                    PC = PC1;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            VecXPanel.this.updateAvailableWindows(true, false, false, true, PC);
                        }
                    });
                    if (VecXPanel.this.config.speedLimit) {
                        long duration = System.currentTimeMillis() - startTime;
                        double muli = (double)VecXPanel.this.config.speedLimitPercent / 100.0;
                        double waitInMilli = 1000.0;
                        double divider = 50.0;
                        int waiter = (int)(waitInMilli / (divider *= muli));
                        if (duration < (long)(waiter - 1)) {
                            try {
                                Thread.sleep((long)(waiter - 1) - duration);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    if ((startTime2 = System.currentTimeMillis()) - measureTime < 1000L) continue;
                    measureTime = startTime2;
                    double percent = (double)measureCycles / 1500000.0 * 100.0;
                    measureCycles = 0L;
                    VecXPanel.this.jLabelFPS.setText("" + (int)percent);
                }
                VecXPanel.this.one = null;
                VecXPanel.this.running = false;
                if (VecXPanel.this.exitReason == 3) {
                    int PC1 = 0;
                    try {
                        PC1 = VecXPanel.this.vecx.e6809.reg_pc;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    final int PC = PC1;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            VecXPanel.this.updateAvailableWindows(true, VecXPanel.this.noDissiFirstLine, true, PC);
                            VecXPanel.this.startDebug();
                            VecXPanel.this.noDissiFirstLine = false;
                            VecXPanel.this.breakpointHandleBreak();
                        }
                    });
                }
            }
        };
        this.vecx.initDissi(false);
        this.one.start();
    }

    public void initProfiler() {
        this.vecx.initDissi(true);
    }

    public void startDebug() {
        this.vecx.config.syncCables = true;
        this.stopThreading();
        this.debuging = true;
        if (this.regi == null) {
            this.regi = Configuration.getConfiguration().getMainFrame().getRegi();
            this.regi.setE6809(this.vecx.e6809);
            this.regi.setVecxy(this);
            if (this.dissi != null) {
                this.regi.setDissi(this.dissi);
            }
        }
        if (!this.dissiInit) {
            if (this.dissi == null) {
                this.createDissi();
                if (this.dissi == null) {
                    return;
                }
            }
            if (this.regi != null) {
                this.regi.setDissi(this.dissi);
            }
            this.dissi.dis(this.vecx.cart);
            this.dissiInit = true;
        }
        if (this.dissi != null) {
            this.vecx.initDissi(false);
            this.dissi.goAddress(this.vecx.e6809.reg_pc, true, false, true);
        }
        this.updateDisplay();
    }

    public void stopDebug(boolean noRestart) {
        if (!noRestart) {
            this.start();
        }
        this.resetDirectdraw();
        this.debuging = false;
        this.vecx.config.syncCables = false;
    }

    public void oneStep() {
        if (!this.debuging) {
            return;
        }
        this.setLightPen();
        this.vecx.directDrawActive = true;
        this.vecx.vecx_emu(1L);
        this.updateDisplay();
        this.repaint();
        int PC = 0;
        try {
            PC = this.vecx.e6809.reg_pc;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.updateAvailableWindows(true, false, true, PC);
    }

    private void stopThreading() {
        if (this.stop) {
            return;
        }
        this.stop = true;
        while (this.one != null) {
            try {
                Thread.sleep(10L);
                this.vecx.stopEmulation();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void stop() {
        if (this.isPausing()) {
            this.cont();
        }
        this.stopThreading();
        if (this.isDebuging()) {
            this.stopDebug(true);
        }
        this.stepping = false;
        this.debuging = false;
        this.pausing = false;
        this.vecx.vecx_reset();
        this.forcedOverlay = "";
        this.stopGraphics();
        this.initJoyportsFromFlag();
        this.repaint();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void cont() {
        this.pausing = false;
    }

    public void pause() {
        if (this.stop) {
            return;
        }
        this.pausing = true;
    }

    public boolean isPausing() {
        return this.pausing;
    }

    public boolean isStepping() {
        return this.stepping;
    }

    public boolean isDebuging() {
        return this.debuging;
    }

    public int getVectorCount() {
        return this.vecx.getDisplayList().count;
    }

    public boolean isImagerMode() {
        return this.vecx.imagerMode;
    }

    Color getColor(int alpha, int left, int right, Color color) {
        if (!this.vecx.imagerMode) {
            return color;
        }
        if (left == -2 || right == -2) {
            if (this.vecx.intensityDrift > 100000L) {
                return new Color((int)((double)color.getRed() * this.vecx.intensityDriftNow), (int)((double)color.getGreen() * this.vecx.intensityDriftNow), (int)((double)color.getBlue() * this.vecx.intensityDriftNow), color.getAlpha());
            }
            return color;
        }
        Imager3dDevice i3d = (Imager3dDevice)this.vecx.joyport[1].getDevice();
        if (i3d.isAnaglyphicEnabled()) {
            if (left > 0) {
                color = Color.RED;
            } else if (right > 0) {
                color = Color.BLUE;
            }
        } else if (left > 0) {
            color = i3d.getWheel().colors[left];
        } else if (right > 0) {
            color = i3d.getWheel().colors[right];
        }
        if (this.vecx.intensityDrift > 100000L) {
            return new Color((int)((double)color.getRed() * this.vecx.intensityDriftNow), (int)((double)color.getGreen() * this.vecx.intensityDriftNow), (int)((double)color.getBlue() * this.vecx.intensityDriftNow), color.getAlpha());
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    @Override
    public synchronized void rayMove(int x0, int y0, int x1, int y1, int color, int dwell, boolean curved, int alg_vector_speed, int alg_leftEye, int alg_rightEye) {
        this.displayPanel.rayMove(x0, y0, x1, y1, color, dwell, curved, alg_vector_speed, alg_leftEye, alg_rightEye);
    }

    double getBrightness() {
        double brightness = this.config.brightness;
        if ((brightness /= 10.0) >= 0.0) {
            brightness += 1.0;
        }
        if (brightness < 0.0) {
            brightness -= 1.0;
        }
        if (brightness < 0.0) {
            brightness = 1.0 / -brightness;
        }
        return brightness;
    }

    public void resetBuffer() {
        if (this.vecx != null) {
            this.vecx.resetBuffer();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    public void setLEDDir(boolean d) {
        this.ledDir = d;
    }

    public boolean isLEDDir() {
        return this.ledDir;
    }

    public void setLEDStep(int s) {
        this.ledStep = s;
    }

    public int getLEDStep() {
        return this.ledStep;
    }

    public void breakpointUpdateDissi() {
        if (this.dissi != null) {
            this.dissi.updateValues(false);
        }
    }

    public void updateVectorInfo() {
        this.lastfound = this.found;
        if (this.vinfi == null) {
            this.vinfi = Configuration.getConfiguration().getMainFrame().getVinfi();
            this.vinfi.setVecxy(this);
            if (this.dissi != null) {
                this.vinfi.setDissi(this.dissi);
            }
        }
        this.vinfi.update(this.lastfound);
    }

    @Override
    public String getID() {
        return SID;
    }

    @Override
    public String getFileID() {
        return UtilityString.replace(UtilityString.replace(UtilityString.replace(UtilityString.replaceWhiteSpaces(SID, ""), ":", ""), "(", ""), ")", "");
    }

    public int getVecXMem8(int adr) {
        return this.vecx.e6809_readOnly8(adr);
    }

    public void setDumpToAddress(int a) {
        if (this.dumpi == null) {
            this.dumpi = Configuration.getConfiguration().getMainFrame().getDumpy();
            if (this.dumpi != null) {
                this.dumpi.setDissi(this.dissi);
            }
        }
        this.dumpi.setVecxy(this);
        this.dumpi.updateValues(false);
        this.dumpi.goAddress(a);
    }

    public void unsetLightPen() {
        this.setLightPen(-100000, -100000);
    }

    public void setLightPen() {
        if (!this.deviceList.get(DEVICE_LIGHTPEN).isActive()) {
            return;
        }
        if (!this.mousePressed) {
            this.unsetLightPen();
            return;
        }
        this.displayPanel.setLightPen();
    }

    public void updateAvailableWindows(boolean jumpInDissi, boolean moveDissiToFirst, boolean forceUpdate, int PC) {
        this.updateAvailableWindows(jumpInDissi, moveDissiToFirst, forceUpdate, false, PC);
    }

    public void updateAvailableWindows(boolean jumpInDissi, boolean moveDissiToFirst, boolean forceUpdate, boolean jumpMayBeDiscarded, int PC) {
        if (!this.dissiActive) {
            return;
        }
        if (this.dissi != null) {
            if (jumpInDissi && !this.pausing) {
                this.dissi.goAddress(PC, moveDissiToFirst, false, forceUpdate, jumpMayBeDiscarded);
            }
            this.dissi.updateValues(forceUpdate);
        }
        if (this.regi != null) {
            this.regi.updateValues(forceUpdate);
        }
        if (this.dumpi != null) {
            this.dumpi.updateValues(forceUpdate);
        }
        if (this.viai != null) {
            this.viai.updateValues(forceUpdate);
        }
        if (this.ani != null) {
            this.ani.updateValues(forceUpdate);
        }
        if (this.vari != null) {
            this.vari.updateValues(forceUpdate);
        }
        if (this.breaki != null) {
            this.breaki.updateValues(forceUpdate);
        }
        if (this.labi != null) {
            this.labi.updateValues(forceUpdate);
        }
        if (this.tracki != null) {
            this.tracki.updateValues(forceUpdate);
        }
        if (this.ayi != null) {
            this.ayi.updateValues(forceUpdate);
        }
        if (this.carti != null) {
            this.carti.updateValues(forceUpdate);
        }
        if (this.joyi != null) {
            this.joyi.updateValues(forceUpdate);
        }
        if (this.vinfi != null) {
            this.vinfi.updateValues(forceUpdate);
        }
        if (this.profi != null) {
            this.profi.updateValues(forceUpdate);
        }
    }

    void checkWindows() {
        CSAMainFrame f = (CSAMainFrame)this.mParent;
        if (this.dissi == null) {
            this.dissi = f.checkDissi();
        }
        if (this.dumpi == null) {
            this.dumpi = f.checkDumpy();
        }
        if (this.regi == null) {
            this.regi = f.checkRegi();
        }
        if (this.vinfi == null) {
            this.vinfi = f.checkVinfi();
        }
        if (this.viai == null) {
            this.viai = f.checkViay();
        }
        if (this.ani == null) {
            this.ani = f.checkAni();
        }
        if (this.vari == null) {
            this.vari = f.checkVari();
        }
        if (this.breaki == null) {
            this.breaki = f.checkBreaki();
        }
        if (this.labi == null) {
            this.labi = f.checkLabi();
        }
        if (this.tracki == null) {
            this.tracki = f.checkWRTracker();
        }
        if (this.ayi == null) {
            this.ayi = f.checkAyi();
        }
        if (this.joyi == null) {
            this.joyi = f.checkJoyportDevice();
        }
        if (this.carti == null) {
            this.carti = f.checkCartridge();
        }
        if (this.profi == null) {
            this.profi = f.checkProfi();
        }
        if (this.dissi != null) {
            if (this.dumpi != null) {
                this.dumpi.setDissi(this.dissi);
            }
            if (this.regi != null) {
                this.regi.setDissi(this.dissi);
            }
            if (this.vinfi != null) {
                this.vinfi.setDissi(this.dissi);
            }
            if (this.vari != null) {
                this.vari.setDissi(this.dissi);
            }
            if (this.labi != null) {
                this.labi.setDissi(this.dissi);
            }
            if (this.ayi != null) {
                this.ayi.setDissi(this.dissi);
            }
            if (this.breaki != null) {
                this.breaki.setDissi(this.dissi);
            }
            if (this.joyi != null) {
                this.joyi.setDissi(this.dissi);
            }
            if (this.carti != null) {
                this.carti.setDissi(this.dissi);
            }
            if (this.profi != null) {
                this.profi.setDissi(this.dissi);
            }
            this.dissi.setVecxy(this);
        }
        if (this.dumpi != null) {
            this.dumpi.setVecxy(this);
        }
        if (this.regi != null) {
            this.regi.setVecxy(this);
        }
        if (this.regi != null) {
            this.regi.setE6809(this.vecx.e6809);
        }
        if (this.vinfi != null) {
            this.vinfi.setVecxy(this);
        }
        if (this.viai != null) {
            this.viai.setVecxy(this);
        }
        if (this.ani != null) {
            this.ani.setVecxy(this);
        }
        if (this.vari != null) {
            this.vari.setVecxy(this);
        }
        if (this.breaki != null) {
            this.breaki.setVecxy(this);
        }
        if (this.labi != null) {
            this.labi.setVecxy(this);
        }
        if (this.tracki != null) {
            this.tracki.setVecxy(this);
        }
        if (this.ayi != null) {
            this.ayi.setVecxy(this);
        }
        if (this.joyi != null) {
            this.joyi.setVecxy(this);
        }
        if (this.carti != null) {
            this.carti.setVecxy(this);
        }
        if (this.profi != null) {
            this.profi.setVecxy(this);
        }
    }

    public void resetCartridge() {
        this.carti = null;
    }

    public void resetDevice() {
        this.joyi = null;
    }

    public void resetAyi() {
        this.ayi = null;
    }

    public void resetProfi() {
        this.profi = null;
    }

    public void resetLabi() {
        this.labi = null;
    }

    public void resetViai() {
        this.viai = null;
    }

    public void resetVinfi() {
        this.vinfi = null;
    }

    public void resetDumpi() {
        this.dumpi = null;
    }

    public void resetRegi() {
        this.regi = null;
    }

    public void resetAni() {
        this.ani = null;
    }

    public void resetVari() {
        this.vari = null;
    }

    public void resetTracki() {
        this.tracki = null;
    }

    public void resetBreaki() {
        this.breaki = null;
    }

    public DissiPanel getDissi() {
        return this.dissi;
    }

    public void resetDissi() {
        this.dissi = null;
        this.dissiInit = false;
        if (this.dumpi != null) {
            this.dumpi.setDissi(null);
        }
        if (this.regi != null) {
            this.regi.setDissi(null);
        }
        if (this.vinfi != null) {
            this.vinfi.setDissi(null);
        }
        if (this.vari != null) {
            this.vari.setDissi(null);
        }
        if (this.labi != null) {
            this.labi.setDissi(null);
        }
        if (this.ayi != null) {
            this.ayi.setDissi(null);
        }
        if (this.breaki != null) {
            this.breaki.setDissi(null);
        }
        if (this.carti != null) {
            this.carti.setDissi(null);
        }
        if (this.joyi != null) {
            this.joyi.setDissi(null);
        }
        if (this.profi != null) {
            this.profi.setDissi(null);
        }
    }

    public void resetMe() {
        if (this.dissi != null && this.dissi.getVecXPanel() != this) {
            return;
        }
        if (this.dissi != null) {
            this.dissi.setVecxy(null);
        }
        if (this.dumpi != null) {
            this.dumpi.setVecxy(null);
        }
        if (this.regi != null) {
            this.regi.setE6809(null);
        }
        if (this.regi != null) {
            this.regi.setVecxy(null);
        }
        if (this.vinfi != null) {
            this.vinfi.setVecxy(null);
        }
        if (this.viai != null) {
            this.viai.setVecxy(null);
        }
        if (this.ani != null) {
            this.ani.setVecxy(null);
        }
        if (this.vari != null) {
            this.vari.setVecxy(null);
        }
        if (this.breaki != null) {
            this.breaki.setVecxy(null);
        }
        if (this.labi != null) {
            this.labi.setVecxy(null);
        }
        if (this.tracki != null) {
            this.tracki.setVecxy(null);
        }
        if (this.ayi != null) {
            this.ayi.setVecxy(null);
        }
        if (this.joyi != null) {
            this.joyi.setVecxy(null);
        }
        if (this.carti != null) {
            this.carti.setVecxy(null);
        }
        if (this.profi != null) {
            this.profi.setVecxy(null);
        }
    }

    public void initLabels() {
        if (this.labi != null) {
            this.labi.initLabels();
        }
    }

    public void updateDumpi() {
        if (this.dumpi != null) {
            this.dumpi.setDissi(this.dissi);
        }
    }

    public void updateLabi() {
        if (this.labi != null) {
            this.labi.setDissi(this.dissi);
        }
    }

    public void updateVari() {
        if (this.vari != null) {
            this.vari.setDissi(this.dissi);
        }
    }

    private void breakpointHandleContinue(ArrayList<Breakpoint> activeBreakpoint) {
        if (this.dissi == null) {
            return;
        }
        for (Breakpoint bp : activeBreakpoint) {
            bp.wasTriggered = true;
            if (bp.targetSubType == Breakpoint.BP_SUBTARGET_CPU_SPECIAL) {
                this.dissi.printMessage("Measure finished, target (" + String.format("$%04X", bp.targetAddress) + ")reached: " + bp.compareValue + " cycles", "editLogMessage");
                continue;
            }
            if ((bp.type & Breakpoint.BP_QUIET) == 0) {
                this.dissi.printMessage("Triggered: " + bp, "editLogMessage");
            }
            if ((bp.type & Breakpoint.BP_HEY) != Breakpoint.BP_HEY) continue;
            this.dissi.doHeyDissiBreakpoint(bp);
        }
        if (this.breaki != null) {
            this.breaki.updateValues(true);
        }
    }

    private void breakpointHandleBreak() {
        if (this.dissi == null) {
            return;
        }
        for (Breakpoint bp : this.vecx.activeBreakpoint) {
            bp.wasTriggered = true;
            if (bp.targetSubType == Breakpoint.BP_SUBTARGET_CPU_SPECIAL) {
                this.dissi.printMessage("Measure finished, target (" + String.format("$%04X", bp.targetAddress) + ")reached: " + bp.compareValue + " cycles", "editLogMessage");
                continue;
            }
            if ((bp.type & Breakpoint.BP_QUIET) == 0 && !this.dissi.isQuiet()) {
                this.dissi.printMessage("Triggered: " + bp, "editLogMessage");
            }
            this.dissi.ensureCorrectOutput();
        }
        if (this.breaki != null) {
            this.breaki.updateValues(true);
        }
    }

    public void breakpointVarToggle(Breakpoint bp) {
        if (this.dissi == null) {
            return;
        }
        this.vecx.toggleBreakpoint(bp);
        this.dissi.updateTableOnly();
        this.vari.updateValues(true);
        if (this.breaki != null) {
            this.breaki.updateValues(true);
        }
    }

    public void _breakpointVarSet(Breakpoint bp) {
        if (this.dissi == null) {
            return;
        }
        bp.memInfo = null;
        this.vecx.addBreakpoint(bp);
        this.dissi.updateTableOnly();
        this.vari.updateValues(true);
        if (this.breaki != null) {
            this.breaki.updateValues(true);
        }
    }

    public void breakpointSet(Breakpoint bp) {
        this.vecx.addBreakpoint(bp);
        if (this.breaki != null) {
            this.breaki.updateValues(true);
        }
    }

    public boolean breakpointAddressToggle(Breakpoint bp) {
        if (this.dissi == null) {
            return false;
        }
        if (this.dissi.isBankDebug()) {
            int b = 0;
            while (b < this.vecx.cart.getBankCount()) {
                Breakpoint nbp = bp.duplicate();
                nbp.targetBank = b++;
                this.breakpointAddressToggleImpl(nbp);
            }
            return true;
        }
        return this.breakpointAddressToggleImpl(bp);
    }

    public boolean breakpointAddressToggleImpl(Breakpoint bp) {
        MemoryInformation memInfo = this.dissi.getMemory().get(bp.targetAddress, bp.targetBank);
        if (memInfo == null) {
            return false;
        }
        bp.memInfo = memInfo;
        Breakpoint oldBreakpoint = memInfo.hasBreakpoint(bp);
        if (oldBreakpoint == null) {
            this.vecx.addBreakpoint(bp);
            this.dissi.updateTableOnly();
            if (this.breaki != null) {
                this.breaki.updateValues(true);
            }
            return true;
        }
        this.vecx.removeBreakpoint(oldBreakpoint);
        this.dissi.updateTableOnly();
        if (this.breaki != null) {
            this.breaki.updateValues(true);
        }
        return false;
    }

    public void breakpointMemorySet(Breakpoint bp) {
        if (this.dissi == null) {
            return;
        }
        if (this.dissi.isBankDebug()) {
            int b = 0;
            while (b < this.vecx.cart.getBankCount()) {
                Breakpoint nbp = bp.duplicate();
                nbp.targetBank = b++;
                this.breakpointAddressToggleImpl(nbp);
            }
            return;
        }
        this.breakpointAddressToggleImpl(bp);
    }

    public void breakpointMemorySetImpl(Breakpoint bp) {
        if (this.dissi == null) {
            return;
        }
        this.dissi.getMemory();
        MemoryInformation memInfo = this.dissi.getMemory().get(bp.targetAddress, bp.targetBank);
        if (memInfo == null) {
            return;
        }
        bp.memInfo = memInfo;
        this.vecx.addBreakpoint(bp);
        this.dissi.updateTableOnly();
        if (this.breaki != null) {
            this.breaki.updateValues(true);
        }
    }

    public boolean breakpointBankToggle(Breakpoint bp) {
        boolean b = this.vecx.toggleBankBreakpoint(bp);
        if (this.breaki != null) {
            this.breaki.updateValues(true);
        }
        return b;
    }

    public boolean breakpointROMToggle(Breakpoint bp) {
        boolean b = this.vecx.toggleROMBreakpoint(bp);
        if (this.breaki != null) {
            this.breaki.updateValues(true);
        }
        return b;
    }

    public boolean breakpointVIAToggle(Breakpoint bp) {
        boolean b = this.vecx.toggleViaBreakpoint(bp);
        if (this.breaki != null) {
            this.breaki.updateValues(true);
        }
        return b;
    }

    public boolean breakpointCyclesSet(Breakpoint bp) {
        boolean b = this.vecx.setCyclesBreakpoint(bp);
        if (this.breaki != null) {
            this.breaki.updateValues(true);
        }
        return b;
    }

    public boolean breakpointCPUToggle(Breakpoint bp) {
        boolean b = this.vecx.breakpointCPUToggle(bp);
        if (this.breaki != null) {
            this.breaki.updateValues(true);
        }
        return b;
    }

    @Override
    public void breakpointRemove(Breakpoint bp) {
        if (this.dissi == null) {
            return;
        }
        if (this.dissi.isBankDebug()) {
            int b = 0;
            while (b < this.vecx.cart.getBankCount()) {
                Breakpoint nbp = bp.duplicate();
                nbp.targetBank = b++;
                this.breakpointRemoveImpl(nbp);
            }
            return;
        }
        this.breakpointRemoveImpl(bp);
    }

    void breakpointRemoveImpl(Breakpoint bp) {
        this.vecx.removeBreakpoint(bp);
        this.dissi.updateTableOnly();
        if (this.breaki != null) {
            this.breaki.updateValues(true);
        }
    }

    public long getCyclesRunning() {
        return this.vecx.cyclesRunning;
    }

    public void setCyclesRunning(long n) {
        this.vecx.setCyclesRunning(n);
        if (this.regi != null) {
            this.regi.updateValues(true);
        }
    }

    public void breakpointClearAll() {
        if (this.vecx != null) {
            this.vecx.clearAllBreakpoints();
        }
        if (this.dissi != null) {
            this.dissi.updateTableOnly();
        }
        if (this.breaki != null) {
            this.breaki.updateValues(true);
        }
    }

    public CodeScanMemory getCodeScanMemory() {
        return this.vecx.dissiMem;
    }

    public Cartridge getCartridge() {
        if (this.vecx == null) {
            return null;
        }
        return this.vecx.cart;
    }

    @Override
    public Serializable getAdditionalStateinfo() {
        VecxSettings vs = new VecxSettings();
        vs.lastOpenFile = this.jTextFieldstart.getText();
        return vs;
    }

    @Override
    public void setAdditionalStateinfo(Serializable ser) {
        VecxSettings vs = (VecxSettings)ser;
        this.jTextFieldstart.setText(vs.lastOpenFile);
    }

    public int getCurrentBank() {
        if (this.vecx == null) {
            return -1;
        }
        return this.vecx.currentBank;
    }

    public int getCurrentAddress() {
        if (this.vecx == null) {
            return -1;
        }
        return this.vecx.e6809.reg_pc;
    }

    public void poke(int addres, byte value) {
        if (this.vecx == null) {
            return;
        }
        this.vecx.poke(addres, value);
    }

    public int getXIntegratorValue() {
        if (this.vecx == null) {
            return 0;
        }
        return (int)this.vecx.alg_curr_x - this.config.ALG_MAX_X / 2;
    }

    public int getYIntegratorValue() {
        if (this.vecx == null) {
            return 0;
        }
        return (int)this.vecx.alg_curr_y - this.config.ALG_MAX_Y / 2;
    }

    public E6809 get6809() {
        return this.vecx.e6809;
    }

    public VecXState getVecXState() {
        return this.vecx;
    }

    public E8910State getE8910State() {
        return this.vecx.e8910;
    }

    public int getCurrentWaitRecalBufferPos() {
        return this.vecx.getCurrentWaitRecalBufferPos();
    }

    public int[] getCurrentWaitRecalBuffer() {
        return this.vecx.getCurrentWaitRecalBuffer();
    }

    public long getLastWaitRecalTest() {
        return this.vecx.getLastWaitRecalTest();
    }

    public void setTrackingAddress(int start, int end2, int bank2) {
        this.vecx.setTrackingAddress(start, end2, bank2);
    }

    public void resetAllTimeLowStack() {
        this.vecx.resetAllTimeLowStack();
    }

    public int getAllTimeLowStack() {
        return this.vecx.getAllTimeLowStack();
    }

    public CartridgeProperties getCurrentCartProp() {
        if (this.vecx == null) {
            return null;
        }
        if (this.vecx.cart == null) {
            return null;
        }
        return this.vecx.cart.currentCardProp;
    }

    public DebugInfoC getUsedCDebugInfo() {
        return this.usedCDebug;
    }

    public void setNextStartCDebugInfo(DebugInfoC cDebug) {
        this.toSetCDebug = cDebug;
    }

    public void startCartridge(final CartridgeProperties cartProp, int runType) {
        this.startTypeRun = runType;
        if (this.startTypeRun != 3) {
            this.jButtonStopActionPerformed(null);
        }
        if (cartProp.getFullFilename().size() > 0) {
            String name = Utility.makeVideAbsolute(UtilityFiles.convertSeperator(cartProp.getFullFilename().elementAt(0)));
            this.jTextFieldstart.setText(name);
            lastOpenedDir = name;
        }
        Thread cartLoaderThread = new Thread(){

            @Override
            public void run() {
                VecXPanel.this.usedCDebug = VecXPanel.this.toSetCDebug;
                VecXPanel.this.toSetCDebug = null;
                boolean loaded = false;
                loaded = VecXPanel.this.startTypeRun != 3 ? VecXPanel.this.vecx.init(cartProp) : VecXPanel.this.vecx.inject(cartProp);
                if (!loaded) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ShowErrorDialog.showErrorDialog("Error loading binaries for: " + cartProp.getCartName() + "!");
                        }
                    });
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            VecXPanel.this.startVecxCallback();
                        }
                    });
                }
            }
        };
        cartLoaderThread.start();
    }

    void startVecxCallback() {
        if (this.dissi == null) {
            this.createDissi();
            if (this.dissi == null) {
                return;
            }
            if (this.startTypeRun == 3) {
                this.setDissi(this.dissi);
                this.dissi.dis(this.vecx.cart);
            }
        }
        if (this.startTypeRun != 3) {
            this.setDissi(this.dissi);
            this.dissi.dis(this.vecx.cart);
        } else {
            this.dissi.dis(this.vecx.cart);
        }
        if (this.startTypeRun == 1) {
            this.dissi.setStartbreakpoint();
        }
        if (this.config.pleaseforceDissiIconizeOnRun) {
            this.dissi.setIcon(this.startTypeRun == 2);
        } else if (!this.dissi.isIcon()) {
            CSAMainFrame gui = (CSAMainFrame)this.mParent;
            try {
                gui.getInternalFrame(this.dissi).toFront();
                gui.getInternalFrame(this.dissi).setSelected(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.dissiInit = true;
        if (this.config.overlayEnabled && this.vecx != null && this.vecx.cart != null && this.vecx.cart.currentCardProp != null) {
            this.loadOverlay(this.vecx.cart.currentCardProp.getOverlay());
            if (this.overlayImageOrg == null) {
                this.loadOverlay(this.vecx.cart.cartName);
            }
        }
        this.checkWindows();
        this.stop = true;
        while (this.running) {
        }
        this.dissi.processHeyDissis();
        this.changeDisplay();
        this.initJoyportsFromFlag();
        this.updatePorts();
        if (this.startTypeRun != 3) {
            this.start();
        } else if (!this.debuging && !this.stepping) {
            this.start();
        }
    }

    public void setPC(int addr) {
        this.vecx.e6809.reg_pc = addr;
    }

    public void doNMI() {
        this.vecx.e6809.doNMI();
    }

    public void setAllBreakpoints(ArrayList<Breakpoint>[] ab) {
        this.vecx.clearAllBreakpoints();
        for (ArrayList<Breakpoint> blist : ab) {
            for (Breakpoint bp : blist) {
                MemoryInformation memInfo;
                bp.memInfo = memInfo = this.dissi.getMemory().get(bp.targetAddress, bp.targetBank);
            }
        }
        this.vecx.setAllBreakpoints(ab);
    }

    public ArrayList<Breakpoint>[] getAllBreakpoints() {
        return this.vecx.getAllBreakpoints();
    }

    public void startRecord(String filename, int type, boolean isAddress, int address) {
        this.vecx.startRecord(filename, type, isAddress, address);
    }

    public void stopRecord() {
        this.vecx.stopRecord();
    }

    public void vectorScreenshot() {
        double exportScaleWidth = 255.0 / (double)this.config.ALG_MAX_X;
        double exportScaleHeight = 255.0 / (double)this.config.ALG_MAX_Y;
        VecX.VectrexDisplayVectors currentVectors = this.vecx.getDisplayList();
        GFXVectorList list2 = new GFXVectorList();
        for (int ve = 0; ve < currentVectors.count; ++ve) {
            VecXState.vector_t v = currentVectors.vectrexVectors[ve];
            GFXVector vector = new GFXVector();
            vector.pattern = 255;
            vector.intensity = v.color & 0xFF;
            double x0 = Scaler.scaleDoubleToInt(v.x0, exportScaleWidth);
            double y0 = Scaler.scaleDoubleToInt(v.y0, exportScaleHeight) * -1;
            double x1 = Scaler.scaleDoubleToInt(v.x1, exportScaleWidth);
            double y1 = Scaler.scaleDoubleToInt(v.y1, exportScaleHeight) * -1;
            vector.start.x(x0 - 128.0);
            vector.start.y(y0 + 127.0);
            vector.end.x(x1 - 128.0);
            vector.end.y(y1 + 127.0);
            list2.add(vector);
        }
        String filename = Global.mainPathPrefix + "xml" + File.separator + "vectorlist" + File.separator;
        int count = 0;
        String cartName = this.vecx.cart.cartName;
        if (cartName.trim().length() != 0) {
            if ((cartName = new File(cartName).getName()) == null) {
                cartName = "";
            }
            cartName = UtilityString.replace(cartName.toLowerCase(), ".bin", "");
            cartName = UtilityString.replace(cartName.toLowerCase(), ".vec", "");
            cartName = UtilityString.replace(cartName.toLowerCase(), ".gam", "");
        }
        String saveName = "";
        do {
            saveName = filename + cartName + "_" + count + ".xml";
            ++count;
        } while (new File(saveName).exists());
        list2.saveAsXML(saveName);
    }

    public void setLightPen(int x, int y) {
        if (this.deviceList.get(DEVICE_LIGHTPEN).isActive()) {
            ((LightpenDevice)this.deviceList.get(DEVICE_LIGHTPEN)).setCoordinates(x, y);
        }
    }

    void updatePorts() {
        ++this.mClassSetting;
        if (this.vecx.joyport[0].getDevice() == null) {
            this.vecx.joyport[0].plugIn(this.deviceList.get(DEVICE_NULL));
        }
        if (this.vecx.joyport[1].getDevice() == null) {
            this.vecx.joyport[1].plugIn(this.deviceList.get(DEVICE_NULL));
        }
        this.jComboBoxJoyport0.setSelectedItem(this.vecx.joyport[0].getDevice());
        this.jComboBoxJoyport1.setSelectedItem(this.vecx.joyport[1].getDevice());
        --this.mClassSetting;
    }

    public ArrayList<JoyportDevice> getDeviceList() {
        return this.deviceList;
    }

    private void ensureDevices() {
        if (this.deviceList != null) {
            return;
        }
        this.deviceList = new ArrayList();
        this.deviceList.add(new NullDevice());
        this.deviceList.add(new LightpenDevice());
        VecSpeechDevice speech = new VecSpeechDevice();
        speech.setVecVoice(true);
        this.deviceList.add(speech);
        speech = new VecSpeechDevice();
        speech.setVecVoice(false);
        this.deviceList.add(speech);
        this.deviceList.add(new Imager3dDevice());
        this.deviceList.add(VecLinkV1Device.getVecLinkV1(0));
        this.deviceList.add(VecLinkV1Device.getVecLinkV1(1));
        this.deviceList.add(VecLinkV2Device.getVecLinkV2(0));
        this.deviceList.add(VecLinkV2Device.getVecLinkV2(1));
        this.deviceList.add(new KeyboardJoystickDevice(this, 0));
        this.deviceList.add(new KeyboardJoystickDevice(this, 1));
        this.deviceList.add(new KeyboardSpinnerDevice(this));
        VecXPanel vecXPanel = this;
        for (ControllerConfig cConfig : vecXPanel.config.getAvailableControllerConfigs()) {
            if (cConfig.vectrexType == 1) {
                this.deviceList.add(JInputJoystickDevice.getDevice(cConfig));
            }
            if (cConfig.vectrexType != 2) continue;
            this.deviceList.add(JInputSpinnerDevice.getDevice(cConfig));
        }
        ArrayList deviceList0 = (ArrayList)this.deviceList.clone();
        deviceList0.remove(DEVICE_IMAGER);
        deviceList0.add(DEVICE_IMAGER, new NullDevice());
        this.jComboBoxJoyport0.setModel(new DefaultComboBoxModel<Object>(deviceList0.toArray()));
        this.jComboBoxJoyport1.setModel(new DefaultComboBoxModel<Object>(this.deviceList.toArray()));
    }

    private void initJoyportsFromFlag() {
        if (this.vecx == null) {
            return;
        }
        this.vecx.joyport[0].plugIn(this.deviceList.get(DEVICE_KEYBOARD_JOYSTICK0));
        this.vecx.joyport[1].plugIn(this.deviceList.get(DEVICE_KEYBOARD_JOYSTICK1));
        if (this.vecx.cart == null) {
            return;
        }
        if (this.vecx.cart.currentCardProp == null) {
            return;
        }
        int flags = this.vecx.cart.currentCardProp.getTypeFlags();
        if ((flags & Cartridge.FLAG_LIGHTPEN1) == Cartridge.FLAG_LIGHTPEN1) {
            this.vecx.joyport[0].plugIn(this.deviceList.get(DEVICE_LIGHTPEN));
        }
        if ((flags & Cartridge.FLAG_LIGHTPEN2) == Cartridge.FLAG_LIGHTPEN2) {
            this.vecx.joyport[1].plugIn(this.deviceList.get(DEVICE_LIGHTPEN));
        }
        if ((flags & Cartridge.FLAG_VEC_VOICE) == Cartridge.FLAG_VEC_VOICE) {
            this.vecx.joyport[1].plugIn(this.deviceList.get(DEVICE_VECVOICE));
        }
        if ((flags & Cartridge.FLAG_VEC_VOX) == Cartridge.FLAG_VEC_VOX) {
            this.vecx.joyport[1].plugIn(this.deviceList.get(DEVICE_VECVOX));
        }
        if ((flags & Cartridge.FLAG_IMAGER) == Cartridge.FLAG_IMAGER) {
            this.vecx.joyport[1].plugIn(this.deviceList.get(DEVICE_IMAGER));
            String wheelName = this.vecx.cart.currentCardProp.getWheelName();
            ((Imager3dDevice)this.deviceList.get(DEVICE_IMAGER)).setWheel(wheelName);
        }
        for (JoyportDevice d : this.deviceList) {
            if (this.config.devicePort0 != null && d.toString().equalsIgnoreCase(this.config.devicePort0)) {
                this.vecx.joyport[0].plugIn(d);
            }
            if (this.config.devicePort1 == null || !d.toString().equalsIgnoreCase(this.config.devicePort1)) continue;
            this.vecx.joyport[1].plugIn(d);
        }
    }

    private void replaceDeviceInList(JoyportDevice d) {
        int sel0 = this.jComboBoxJoyport0.getSelectedIndex();
        int sel1 = this.jComboBoxJoyport1.getSelectedIndex();
        int index = 0;
        for (JoyportDevice dOrg : this.deviceList) {
            if (dOrg.getDeviceID() == d.getDeviceID()) {
                this.deviceList.remove(index);
                this.deviceList.add(index, d);
                break;
            }
            ++index;
        }
        ++this.mClassSetting;
        this.jComboBoxJoyport0.setModel(new DefaultComboBoxModel<Object>(this.deviceList.toArray()));
        this.jComboBoxJoyport1.setModel(new DefaultComboBoxModel<Object>(this.deviceList.toArray()));
        this.jComboBoxJoyport0.setSelectedIndex(sel0);
        this.jComboBoxJoyport1.setSelectedIndex(sel1);
        --this.mClassSetting;
    }

    JoyportDevice getDevice(int id, String name) {
        if (id < DEVICE_JINPUT_JOYSTICK) {
            return this.deviceList.get(id);
        }
        for (JoyportDevice device : this.deviceList) {
            if (device.getDeviceID() != id || !device.getDeviceName().equals(name)) continue;
            return device;
        }
        return null;
    }

    private void initJoyportsFromEmulation() {
        if (this.vecx == null) {
            return;
        }
        if (this.vecx.joyport == null) {
            return;
        }
        JoyportDevice device1 = this.vecx.joyport[1].getDevice();
        ++this.mClassSetting;
        this.vecx.joyport[0].plugIn(this.deviceList.get(DEVICE_KEYBOARD_JOYSTICK0));
        if (!(device1 instanceof Imager3dDevice)) {
            this.vecx.joyport[1].plugIn(this.deviceList.get(DEVICE_KEYBOARD_JOYSTICK1));
        }
        if (this.vecx.cart == null) {
            --this.mClassSetting;
            return;
        }
        if (this.vecx.cart.currentCardProp == null) {
            --this.mClassSetting;
            return;
        }
        int flags = this.vecx.cart.currentCardProp.getTypeFlags();
        if ((flags & Cartridge.FLAG_LIGHTPEN1) == Cartridge.FLAG_LIGHTPEN1) {
            this.vecx.joyport[0].plugIn(this.deviceList.get(DEVICE_LIGHTPEN));
        }
        if ((flags & Cartridge.FLAG_LIGHTPEN2) == Cartridge.FLAG_LIGHTPEN2) {
            this.vecx.joyport[1].plugIn(this.deviceList.get(DEVICE_LIGHTPEN));
        }
        if ((flags & Cartridge.FLAG_VEC_VOICE) == Cartridge.FLAG_VEC_VOICE) {
            this.vecx.joyport[1].plugIn(this.deviceList.get(DEVICE_VECVOICE));
        }
        if ((flags & Cartridge.FLAG_VEC_VOX) == Cartridge.FLAG_VEC_VOX) {
            this.vecx.joyport[1].plugIn(this.deviceList.get(DEVICE_VECVOX));
        }
        if (this.vecx.joyport[0] != null) {
            this.jComboBoxJoyport0.setSelectedItem(this.vecx.joyport[0].getDevice());
        } else {
            this.jComboBoxJoyport0.setSelectedIndex(-1);
        }
        if (device1 != null && device1 instanceof Imager3dDevice) {
            this.replaceDeviceInList(device1);
            this.jComboBoxJoyport1.setSelectedItem(this.vecx.joyport[1].getDevice());
        }
        --this.mClassSetting;
    }

    public void setDissi(DissiPanel d) {
        this.dissi = d;
        this.dissi.newEnvironment(this);
        this.myDissi = this.dissi.getData();
        AbstractDevice.exitSync = false;
        DualVec.exitSync = false;
    }

    public void setDissiAcitve(boolean a) {
        this.dissiActive = a;
    }

    void removeDissi() {
        if (this.dissi == null) {
            return;
        }
        this.vecx.clearAllBreakpoints();
        if (this.breaki != null) {
            this.breaki.updateValues(true);
        }
        this.resetMe();
        this.dissi = null;
        this.regi = null;
        this.vinfi = null;
        this.dumpi = null;
        this.viai = null;
        this.ani = null;
        this.vari = null;
        this.breaki = null;
        this.labi = null;
        this.tracki = null;
        this.ayi = null;
        this.carti = null;
        this.joyi = null;
        this.profi = null;
        this.dissiInit = false;
    }

    void ensureMyDissi() {
        CSAMainFrame f = (CSAMainFrame)this.mParent;
        f.checkDissi();
        if (this.dissi != null) {
            if (this.dissi.getVecXPanel() == this) {
                return;
            }
            if (this.dissi.getVecXPanel() != null) {
                this.dissi.getVecXPanel().removeDissi();
            }
        } else if (this.config.debugingCore) {
            this.createDissi();
            if (this.dissi == null) {
                return;
            }
            if (this.running) {
                this.setDissi(this.dissi);
                this.dissi.dis(this.vecx.cart);
                this.dissi.processHeyDissis();
                this.dissiInit = true;
                this.vecx.initDissi(false);
            }
        } else {
            return;
        }
        this.dissi.changeBaseData(this.myDissi);
        this.findWindows();
        if (this.dissi != null) {
            this.dissi.setVecxy(this);
        }
        if (this.dumpi != null) {
            this.dumpi.setVecxy(this);
        }
        if (this.regi != null) {
            this.regi.setE6809(this.vecx.e6809);
        }
        if (this.regi != null) {
            this.regi.setVecxy(this);
        }
        if (this.vinfi != null) {
            this.vinfi.setVecxy(this);
        }
        if (this.viai != null) {
            this.viai.setVecxy(this);
        }
        if (this.ani != null) {
            this.ani.setVecxy(this);
        }
        if (this.vari != null) {
            this.vari.setVecxy(this);
        }
        if (this.breaki != null) {
            this.breaki.setVecxy(this);
        }
        if (this.labi != null) {
            this.labi.setVecxy(this);
        }
        if (this.tracki != null) {
            this.tracki.setVecxy(this);
        }
        if (this.ayi != null) {
            this.ayi.setVecxy(this);
        }
        if (this.carti != null) {
            this.carti.setVecxy(this);
        }
        if (this.joyi != null) {
            this.joyi.setVecxy(this);
        }
        if (this.profi != null) {
            this.profi.setVecxy(this);
        }
        if (this.dumpi != null) {
            this.dumpi.setDissi(this.dissi);
        }
        if (this.regi != null) {
            this.regi.setDissi(this.dissi);
        }
        if (this.vinfi != null) {
            this.vinfi.setDissi(this.dissi);
        }
        if (this.vari != null) {
            this.vari.setDissi(this.dissi);
        }
        if (this.labi != null) {
            this.labi.setDissi(this.dissi);
        }
        if (this.ayi != null) {
            this.ayi.setDissi(this.dissi);
        }
        if (this.breaki != null) {
            this.breaki.setDissi(this.dissi);
        }
        if (this.carti != null) {
            this.carti.setDissi(this.dissi);
        }
        if (this.joyi != null) {
            this.joyi.setDissi(this.dissi);
        }
        if (this.profi != null) {
            this.profi.setDissi(this.dissi);
        }
        int PC = 0;
        try {
            PC = this.vecx.e6809.reg_pc;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.updateAvailableWindows(false, false, true, PC);
    }

    void findWindows() {
        CSAMainFrame f = (CSAMainFrame)this.mParent;
        this.dissi = f.checkDissi();
        this.dumpi = f.checkDumpy();
        this.regi = f.checkRegi();
        this.vinfi = f.checkVinfi();
        this.viai = f.checkViay();
        this.ani = f.checkAni();
        this.vari = f.checkVari();
        this.breaki = f.checkBreaki();
        this.labi = f.checkLabi();
        this.tracki = f.checkWRTracker();
        this.ayi = f.checkAyi();
        this.carti = f.checkCartridge();
        this.joyi = f.checkJoyportDevice();
        this.profi = f.checkProfi();
    }

    public int getXReg() {
        return this.vecx.e6809.reg_x;
    }

    public int getYReg() {
        return this.vecx.e6809.reg_y;
    }

    public int getSReg() {
        return this.vecx.e6809.reg_s.intValue;
    }

    public int getUReg() {
        return this.vecx.e6809.reg_u.intValue;
    }

    public int getDReg() {
        return this.vecx.e6809.reg_a << 8 + this.vecx.e6809.reg_b;
    }

    public int getAReg() {
        return this.vecx.e6809.reg_a;
    }

    public int getBReg() {
        return this.vecx.e6809.reg_b;
    }

    public int getPCReg() {
        return this.vecx.e6809.reg_pc;
    }

    public int getDPReg() {
        return this.vecx.e6809.reg_dp;
    }

    public int getCCReg() {
        return this.vecx.e6809.reg_cc;
    }

    @Override
    public void setJoyportDevice(int port, JoyportDevice d) {
        ++this.mClassSetting;
        if (port == 0 && d == null) {
            this.jComboBoxJoyport0.setSelectedIndex(-1);
        }
        if (port == 1 && d == null) {
            this.jComboBoxJoyport1.setSelectedIndex(-1);
        }
        --this.mClassSetting;
    }

    public boolean oneSlaveEmulation(int cycles) {
        boolean stopEmulation = false;
        if (cycles == 1) {
            this.vecx.directDrawActive = true;
        }
        this.setLightPen();
        this.exitReason = this.vecx.vecx_emu(cycles);
        this.vecx.directDrawActive = false;
        if (this.exitReason == 3) {
            this.stepping = false;
            stopEmulation = true;
            return stopEmulation;
        }
        if (this.exitReason == 2) {
            this.breakpointHandleContinue(this.vecx.activeBreakpoint);
        }
        if (this.stepping) {
            try {
                int PC1 = 0;
                try {
                    PC1 = this.vecx.e6809.reg_pc;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                final int PC = PC1;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VecXPanel.this.updateDisplay();
                        VecXPanel.this.updateAvailableWindows(true, false, true, PC);
                    }
                });
                if (this.config.multiStepDelay > 0) {
                    Thread.sleep(this.config.multiStepDelay);
                }
            }
            catch (InterruptedException PC1) {}
        } else {
            int PC1 = 0;
            try {
                PC1 = this.vecx.e6809.reg_pc;
            }
            catch (Throwable PC) {
                // empty catch block
            }
            final int PC = PC1;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VecXPanel.this.updateAvailableWindows(true, false, false, PC);
                }
            });
        }
        return stopEmulation;
    }

    public AT24C02 getAtmel() {
        if (this.vecx == null) {
            return null;
        }
        if (this.vecx.cart == null) {
            return null;
        }
        if (!this.vecx.cart.isAtmel) {
            return null;
        }
        return this.vecx.cart.atmel;
    }

    public Microchip11AA010 getMicrochip() {
        if (this.vecx == null) {
            return null;
        }
        if (this.vecx.cart == null) {
            return null;
        }
        if (!this.vecx.cart.isMicrochip) {
            return null;
        }
        return this.vecx.cart.microchip;
    }

    public DS2430A getDS2430A() {
        if (this.vecx == null) {
            return null;
        }
        if (this.vecx.cart == null) {
            return null;
        }
        if (!this.vecx.cart.is2430a) {
            return null;
        }
        return this.vecx.cart.ds2430;
    }

    public DS2431 getDS2431() {
        if (this.vecx == null) {
            return null;
        }
        if (this.vecx.cart == null) {
            return null;
        }
        if (!this.vecx.cart.isDS2431) {
            return null;
        }
        return this.vecx.cart.ds2431;
    }

    public VectrexJoyport[] getJoyportDevices() {
        return this.vecx.joyport;
    }

    public boolean setRegister(String register, int value) {
        boolean ok = this.vecx.setRegister(register, value);
        int PC = 0;
        try {
            PC = this.vecx.e6809.reg_pc;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.updateAvailableWindows(true, false, true, PC);
        return ok;
    }

    public boolean isLEDState() {
        return this.ledState;
    }

    @Override
    public void setLED(int state) {
        this.ledState = state == 1;
    }

    public BufferedImage getOverlayImageOrg() {
        return this.overlayImageOrg;
    }

    void checkOverlay() {
        if (this.config.overlayEnabled) {
            try {
                if (this.overlayImageOrg == null && this.vecx.cart.currentCardProp != null) {
                    this.loadOverlay(this.vecx.cart.currentCardProp.getOverlay());
                }
                if (this.overlayImageOrg == null) {
                    this.loadOverlay(this.vecx.cart.cartName);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (this.overlayImageOrg == null && this.vecx.cart == null) {
                    this.loadOverlay(this.vecx.romName);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public String dumpCurrentROM() {
        if (this.vecx == null) {
            return null;
        }
        return this.vecx.dumpCurrentROM();
    }

    public Profiler getProfiler() {
        if (this.vecx == null) {
            return null;
        }
        if (!this.config.doProfile) {
            return null;
        }
        return this.vecx.profiler;
    }

    public boolean isJOGL() {
        return this.config.tryJOGL;
    }

    public void forceResize() {
        if (this.inResize) {
            return;
        }
        this.inResize = true;
        Rectangle bounds = this.jPanel1.getBounds();
        bounds.width = this.getWidth();
        this.jPanel1.setBounds(bounds);
        if (this.displayPanel instanceof VecxiPanel_JOGL) {
            this.changeDisplay();
        } else {
            this.displayPanel.forceResize();
        }
        this.invalidate();
        this.validate();
        this.repaint();
        this.inResize = false;
    }

    public void doRedraw() {
        this.updateDisplay();
        this.repaint();
    }

    public void stopGraphics() {
        this.displayPanel.stopGraphics();
    }

    @Override
    public void directDraw(VecXState.vector_t v) {
        this.displayPanel.directDraw(v);
    }

    public void resetDirectdraw() {
        this.displayPanel.resetDirectdraw();
    }

    @Override
    public synchronized void switchDisplay() {
        this.displayPanel.switchDisplay();
    }

    @Override
    public synchronized void updateDisplay() {
        this.displayPanel.updateDisplay();
    }

    public void overlayChanged() {
        if (this.displayPanel != null) {
            this.displayPanel.overlayChanged();
        }
    }

    public synchronized void changeDisplay() {
        this.overlayImageOrg = null;
        if (this.displayPanel != null) {
            this.displayPanel.deinit();
            this.remove((JPanel)((Object)this.displayPanel));
            this.displayPanel = null;
        }
        if (this.config.tryJOGL && JOGLSupport.isJOGLSupported()) {
            try {
                VecxiPanel_JOGL vecpanel = VecxiPanel_JOGL.getJOGLPanel(this);
                this.displayPanel = vecpanel;
                this.add((Component)((Object)vecpanel));
            }
            catch (Throwable e) {
                JOGLSupport.setJOGLSupported(false);
                this.log.addLog("JOGL init failed for Vecxi - disabling JOGL");
                VecxiPanel_JAVA vecpanel = new VecxiPanel_JAVA(this);
                this.displayPanel = vecpanel;
                this.add(vecpanel);
            }
        } else {
            VecxiPanel_JAVA vecpanel = new VecxiPanel_JAVA(this);
            this.displayPanel = vecpanel;
            this.add(vecpanel);
        }
        this.forceResize();
        this.checkOverlay();
    }

    VecX.VectrexDisplayVectors getDisplayList() {
        if (this.vecx == null) {
            return new VecX.VectrexDisplayVectors();
        }
        return this.vecx.getDisplayList();
    }

    public double getIntegratorX() {
        if (this.vecx == null) {
            return 0.0;
        }
        return this.vecx.alg_curr_x;
    }

    public double getIntegratorY() {
        if (this.vecx == null) {
            return 0.0;
        }
        return this.vecx.alg_curr_y;
    }

    public int getYOffset() {
        if (this.jPanel1.isVisible()) {
            return this.jPanel1.getHeight() + 1;
        }
        return 0;
    }

    @Override
    public void deIconified() {
        if (this.displayPanel instanceof VecxiPanel_JOGL) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VecXPanel.this.changeDisplay();
                }
            });
        }
    }

    public void toggleMainPanel() {
        if (!this.config.tryJOGL) {
            return;
        }
        CSAMainFrame mf = Configuration.getConfiguration().getMainFrame();
        if (this.ftoggle) {
            return;
        }
        if (this.ptoggle) {
            this.jPanel1.setVisible(true);
            mf.windowMe(this, 10, 10, "vecxi");
        } else {
            mf.saveState(this, mf.getInternalFrame(this));
            this.jPanel1.setVisible(false);
            mf.desktopMe(this);
        }
        this.ptoggle = !this.ptoggle;
        this.changeDisplay();
    }

    public void toggleFullscreen() {
        if (!this.config.tryJOGL) {
            return;
        }
        CSAMainFrame mf = Configuration.getConfiguration().getMainFrame();
        if (this.ftoggle) {
            this.ftoggle = !this.ftoggle;
            mf.toWindowed();
            this.toggleMainPanel();
        } else {
            if (!this.ptoggle) {
                this.toggleMainPanel();
            }
            mf.toFullscreen();
            this.ftoggle = !this.ftoggle;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VecXPanel.this.changeDisplay();
            }
        });
    }

    public void setOverlay(String overlayFile) {
        this.forcedOverlay = overlayFile;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VecXPanel.this.changeDisplay();
            }
        });
    }

    public long getTrackiCount() {
        return this.vecx.trackyCount;
    }

    public long getTrackiAbove() {
        return this.vecx.trackyAbove;
    }

    public void setMouseCoordinates(ControllerEvent event) {
        JPanel panel;
        Point p;
        if (this.displayPanel != null && (p = (panel = (JPanel)((Object)this.displayPanel)).getMousePosition()) != null) {
            float mx = p.x;
            float my = p.y;
            float percentX = mx / (float)panel.getWidth();
            float percentY = my / (float)panel.getHeight();
            float maxVectrexPos = 256.0f;
            this.old_x = (int)(maxVectrexPos * percentX);
            this.old_y = -((int)(maxVectrexPos * percentY));
            this.old_x &= 0xFF;
            this.old_y &= 0xFF;
        }
        event.x = this.old_x;
        event.y = this.old_y;
    }

    public ArrayList<Breakpoint>[] getBreakpoints() {
        return this.vecx.breakpoints;
    }

    static class VeryCompleteState
    implements Serializable {
        ArrayList<Breakpoint>[] breakpoints = new ArrayList[Breakpoint.BP_TARGET_COUNT];
        int SS_RING_BUFFER_SIZE = 30000;
        int ringSSWalkStep = 0;
        int ringSSBufferNext = 0;
        CompleteState[] goSSBackRingBuffer;
        int FRAME_RING_BUFFER_SIZE = 1000;
        int ringFrameWalkStep = 0;
        int ringFrameBufferNext = 0;
        CompleteState[] goFrameBackRingBuffer;

        VeryCompleteState() {
        }
    }
}

