/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.cartridge;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.gui.panels.LogPanel;
import de.malban.util.DownloaderPanel;
import de.malban.util.Utility;
import de.malban.util.UtilityFiles;
import de.malban.util.UtilityString;
import de.malban.vide.VideConfig;
import de.malban.vide.dissy.DissiPanel;
import de.malban.vide.vecx.DisplayerInterface;
import de.malban.vide.vecx.VecX;
import de.malban.vide.vecx.VecXPanel;
import de.malban.vide.vecx.cartridge.AT24C02;
import de.malban.vide.vecx.cartridge.CartridgeEvent;
import de.malban.vide.vecx.cartridge.CartridgeListener;
import de.malban.vide.vecx.cartridge.CartridgeProperties;
import de.malban.vide.vecx.cartridge.DS2430A;
import de.malban.vide.vecx.cartridge.DS2431;
import de.malban.vide.vecx.cartridge.DualVec;
import de.malban.vide.vecx.cartridge.Microchip11AA010;
import de.malban.vide.vecx.cartridge.VSID;
import de.malban.vide.vecx.cartridge.XMasLED;
import de.malban.vide.vecx.cartridge.resid.SID;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.zip.CRC32;

public class Cartridge
implements Serializable {
    public static int FLAG_BANKSWITCH_DONDZILA = 1;
    public static int FLAG_BANKSWITCH_VECFLASH = 2;
    public static int FLAG_EXTREME_MULTI = 4;
    public static int FLAG_RAM_ANIMACTION = 8;
    public static int FLAG_RAM_RA_SPECTRUM = 16;
    public static int FLAG_DS2430A = 32;
    public static int FLAG_VEC_VOICE = 64;
    public static int FLAG_LIGHTPEN1 = 128;
    public static int FLAG_LIGHTPEN2 = 256;
    public static int FLAG_IMAGER = 512;
    public static int FLAG_VEC_VOX = 1024;
    public static int FLAG_MICROCHIP = 2048;
    public static int FLAG_DUALVEC1 = 4096;
    public static int FLAG_DUALVEC2 = 8192;
    public static int FLAG_LOGO = 16384;
    public static int FLAG_XMAS = 32768;
    public static int FLAG_DS2431 = 65536;
    public static int FLAG_32K_ONLY = 131072;
    public static int FLAG_SID = FLAG_32K_ONLY * 2;
    public static int FLAG_48K = FLAG_SID * 2;
    public static int FLAG_V4E_16K_BS = FLAG_48K * 2;
    public static int FLAG_ATMEL_EEPROM = FLAG_V4E_16K_BS * 2;
    public static int FLAG_PIC_EEPROM = FLAG_ATMEL_EEPROM * 2;
    public static int FLAG_KEYBOARD = FLAG_PIC_EEPROM * 2;
    public static int FLAG_FLASH_SUPPORT = FLAG_KEYBOARD * 2;
    public static int FLAG_BS_PB6_IRQ = FLAG_FLASH_SUPPORT * 2;
    public static int FLAG_44_PEER_BS = FLAG_BS_PB6_IRQ * 2;
    transient LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    public boolean isMicrochip = false;
    public boolean isAtmel = false;
    public boolean isDS2431 = false;
    public boolean is2430a = false;
    public boolean isVecFeverCartridge = false;
    boolean extraRam2000_2800_2k_Enabled = false;
    boolean extraRam8000_8800_2k_Enabled = false;
    boolean extraRam6000_7fff_8k_Enabled = false;
    public boolean peer44_4_enabled = false;
    public boolean currentIRQ = true;
    public boolean currentPB6 = true;
    public boolean flashSupport = true;
    boolean isXmas = false;
    boolean isDualVec = false;
    boolean sidEnabled = false;
    boolean extremeMulti = false;
    boolean rom48KEnabled = false;
    byte spectrumByte = 0;
    boolean _32kOnly = false;
    boolean v4e_16k_bankswitch = false;
    boolean isPB6IRQBankswitch = false;
    public Microchip11AA010 microchip = new Microchip11AA010(this);
    public AT24C02 atmel = new AT24C02(this);
    public DS2430A ds2430 = new DS2430A(this);
    public DS2431 ds2431 = new DS2431(this);
    public VSID vsid = null;
    DualVec dualvec = null;
    XMasLED xMasLED = null;
    public int MAX_BANK_SIZE = 32768;
    transient VecX vecx;
    int typeFlags = 0;
    public long crc = 0L;
    int[][] cart;
    int[] bankLength;
    String[] bankFileNames;
    int loadLen = 0;
    transient ArrayList<CartridgeListener> mListener = new ArrayList();
    public CartridgeProperties currentCardProp = null;
    byte[] extraRam = null;
    int bankMax = 1;
    public String cartName = "MineStorm";
    int oldBank = -1;
    int currentBank = 0;
    boolean previousExternalLineB = true;
    boolean previousExternalLineIRQ = true;
    long oldCycles = 0L;
    int cHi;
    int parm;
    byte[] allData = null;
    int pos;
    int big = 0;
    boolean doExtremeOutput = false;
    VECFLASH vfState = VECFLASH.LOW_PULSE;
    int eraseAddress = 0;
    int eraseSequenceAddress = 0;
    int eraseSequenceData = 0;
    int idSequenceAddress = 0;
    int idSequenceData = 0;
    int writeSequenceAddress = 0;
    int writeSequenceData = 0;
    static final int BACKREFERENCESIZE = 4096;
    int window_pos;
    int lastUnzippedSize = 0;

    public void init() {
        this.log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
        if (this.ds2431 != null) {
            this.ds2431.init();
        }
        if (this.ds2430 != null) {
            this.ds2430.init();
        }
        if (this.microchip != null) {
            this.microchip.init();
        }
        if (this.atmel != null) {
            this.atmel.init();
        }
    }

    public String getTypInfoString() {
        String ret = "";
        if (this.currentCardProp == null) {
            ret = ret + "(values guessed) ";
            if (this.currentPB6) {
                ret = ret + "Dondzila Bankswitch  ";
            }
            if (this.extremeMulti) {
                ret = ret + "Extreme Multi  ";
            }
            if (this.extraRam2000_2800_2k_Enabled) {
                ret = ret + "$2000 2k extra RAM  ";
            }
            if (this.extraRam8000_8800_2k_Enabled) {
                ret = ret + "$8000 2k extra RAM + LED at $A000  ";
            }
            if (this.is2430a) {
                ret = ret + "eEprom DS2430A  ";
            }
            if (this.isMicrochip) {
                ret = ret + "eEprom MICROCHIP  ";
            }
            if (this.isDualVec) {
                ret = ret + "DualVec ";
            }
            if (this.extraRam6000_7fff_8k_Enabled) {
                ret = ret + "$6000 8k extra RAM  ";
            }
            if (this.isXmas) {
                ret = ret + "XMas LED  ";
            }
            if (this.isDS2431) {
                ret = ret + "eEprom DS2431  ";
            }
            if (this.sidEnabled) {
                ret = ret + "SID extension  ";
            }
            if (this.rom48KEnabled) {
                ret = ret + "48k ROM  ";
            }
            if (this.peer44_4_enabled) {
                ret = ret + "44k ROM (BS) +4k RAM ($b000-$bfff) ";
            }
            if (this.v4e_16k_bankswitch) {
                ret = ret + "V4E 16k BS  ";
            }
            if (this.isAtmel) {
                ret = ret + "eEprom atmel  ";
            }
            if (this.isPB6IRQBankswitch) {
                ret = ret + "Quad BS ";
            }
            return ret;
        }
        if (this.currentPB6 || (this.currentCardProp.getTypeFlags() & FLAG_BANKSWITCH_DONDZILA) != 0) {
            ret = ret + "Dondzila Bankswitch  ";
        }
        if ((this.currentCardProp.getTypeFlags() & FLAG_BANKSWITCH_VECFLASH) != 0) {
            ret = ret + "VecFlash Bankswitch  ";
        }
        if (this.extremeMulti || (this.currentCardProp.getTypeFlags() & FLAG_EXTREME_MULTI) != 0) {
            ret = ret + "Extreme Multi  ";
        }
        if (this.extraRam2000_2800_2k_Enabled || (this.currentCardProp.getTypeFlags() & FLAG_RAM_ANIMACTION) != 0) {
            ret = ret + "$2000 2k extra RAM  ";
        }
        if (this.extraRam8000_8800_2k_Enabled || (this.currentCardProp.getTypeFlags() & FLAG_RAM_RA_SPECTRUM) != 0) {
            ret = ret + "$8000 2k extra RAM + LED at $A000  ";
        }
        if (this.is2430a || (this.currentCardProp.getTypeFlags() & FLAG_DS2430A) != 0) {
            ret = ret + "eEprom DS2430A  ";
        }
        if ((this.currentCardProp.getTypeFlags() & FLAG_VEC_VOICE) != 0) {
            ret = ret + "VecVoice  ";
        }
        if ((this.currentCardProp.getTypeFlags() & FLAG_LIGHTPEN1) != 0) {
            ret = ret + "Lightpen Port 0  ";
        }
        if ((this.currentCardProp.getTypeFlags() & FLAG_LIGHTPEN2) != 0) {
            ret = ret + "Lightpen Port 1  ";
        }
        if ((this.currentCardProp.getTypeFlags() & FLAG_IMAGER) != 0) {
            ret = ret + "3d Imager  ";
        }
        if ((this.currentCardProp.getTypeFlags() & FLAG_VEC_VOX) != 0) {
            ret = ret + "VecVox  ";
        }
        if (this.isMicrochip || (this.currentCardProp.getTypeFlags() & FLAG_MICROCHIP) != 0) {
            ret = ret + "eEprom MICROCHIP  ";
        }
        if (this.isDualVec || (this.currentCardProp.getTypeFlags() & FLAG_DUALVEC1) != 0) {
            ret = ret + "DualVec1  ";
        }
        if (this.isDualVec || (this.currentCardProp.getTypeFlags() & FLAG_DUALVEC2) != 0) {
            ret = ret + "DualVec2  ";
        }
        if (this.extraRam6000_7fff_8k_Enabled || (this.currentCardProp.getTypeFlags() & FLAG_LOGO) != 0) {
            ret = ret + "$6000 8k extra RAM  ";
        }
        if (this.isXmas || (this.currentCardProp.getTypeFlags() & FLAG_XMAS) != 0) {
            ret = ret + "XMas LED  ";
        }
        if (this.isDS2431 || (this.currentCardProp.getTypeFlags() & FLAG_DS2431) != 0) {
            ret = ret + "eEprom DS2431  ";
        }
        if ((this.currentCardProp.getTypeFlags() & FLAG_32K_ONLY) != 0) {
            ret = ret + "32k forced  ";
        }
        if (this.sidEnabled || (this.currentCardProp.getTypeFlags() & FLAG_SID) != 0) {
            ret = ret + "SID extension  ";
        }
        if (this.rom48KEnabled || (this.currentCardProp.getTypeFlags() & FLAG_48K) != 0) {
            ret = ret + "48k ROM  ";
        }
        if (this.peer44_4_enabled || (this.currentCardProp.getTypeFlags() & FLAG_44_PEER_BS) != 0) {
            ret = ret + "44k ROM (BS) +4k RAM ($b000-$bfff) ";
        }
        if (this.v4e_16k_bankswitch || (this.currentCardProp.getTypeFlags() & FLAG_V4E_16K_BS) != 0) {
            ret = ret + "V4E 16k BS  ";
        }
        if (this.isAtmel || (this.currentCardProp.getTypeFlags() & FLAG_ATMEL_EEPROM) != 0) {
            ret = ret + "eEprom atmel  ";
        }
        if ((this.currentCardProp.getTypeFlags() & FLAG_PIC_EEPROM) != 0) {
            ret = ret + "eEprom PIC  ";
        }
        if ((this.currentCardProp.getTypeFlags() & FLAG_KEYBOARD) != 0) {
            ret = ret + "Keyboard  ";
        }
        if ((this.currentCardProp.getTypeFlags() & FLAG_FLASH_SUPPORT) != 0) {
            ret = ret + "Flash support  ";
        }
        if (this.isPB6IRQBankswitch || (this.currentCardProp.getTypeFlags() & FLAG_BS_PB6_IRQ) != 0) {
            ret = ret + "Quad BS ";
        }
        ret = ret.trim();
        ret = UtilityString.replace(ret, "  ", ", ");
        return ret;
    }

    public void setVecx(VecX v) {
        this.vecx = v;
    }

    String getPC() {
        if (this.vecx == null) {
            return "";
        }
        ArrayList<Integer> stack = this.vecx.getCallstack();
        String ret = "";
        for (int i = 0; i < stack.size(); ++i) {
            ret = ret + "$" + String.format("%04X", stack.get(i)) + "->";
        }
        ret = ret + "$" + String.format("%04X", this.vecx.getPC());
        return ret;
    }

    public byte getSpectrumByte() {
        return this.spectrumByte;
    }

    public boolean is48KROM() {
        return this.rom48KEnabled;
    }

    public boolean isExtra2000Ram2k() {
        return this.extraRam2000_2800_2k_Enabled;
    }

    public boolean isExtra8000Ram2k() {
        return this.extraRam8000_8800_2k_Enabled;
    }

    public boolean ispeer44_4() {
        return this.peer44_4_enabled;
    }

    public boolean isExtra6000Ram8k() {
        return this.extraRam6000_7fff_8k_Enabled;
    }

    public byte[] getExtraRam() {
        return this.extraRam;
    }

    public boolean isDualVec() {
        return this.isDualVec;
    }

    public ArrayList<CartridgeListener> getListener() {
        return this.mListener;
    }

    public void setListener(ArrayList<CartridgeListener> l) {
        this.mListener = l;
    }

    public int getBankCount() {
        return this.bankMax;
    }

    public long getCRC() {
        CRC32 localCRC32 = new CRC32();
        for (int b = 0; b < this.bankMax; ++b) {
            localCRC32.update(this.getByteData(b));
        }
        return localCRC32.getValue();
    }

    public int getBankSize(int b) {
        return this.bankLength[b % this.bankMax];
    }

    public void addCartridgeListener(CartridgeListener listener) {
        if (this.mListener == null) {
            this.mListener = new ArrayList();
        }
        this.mListener.remove(listener);
        this.mListener.add(listener);
    }

    public void removeCartridgeListener(CartridgeListener listener) {
        if (this.mListener == null) {
            return;
        }
        this.mListener.remove(listener);
    }

    public void fireCartridgeChanged(CartridgeEvent e) {
        if (this.mListener == null) {
            return;
        }
        for (int i = 0; i < this.mListener.size(); ++i) {
            this.mListener.get(i).cartridgeChanged(e);
        }
    }

    public int getCurrentBankLength() {
        if (this.cart == null) {
            return 0;
        }
        if (this.cart.length <= this.currentBank) {
            return 0;
        }
        if (this.cart[this.currentBank] == null) {
            return 0;
        }
        return this.cart[this.currentBank].length;
    }

    public int getCurrentBank() {
        return this.currentBank;
    }

    public void setBank(int newBank) {
        if (this.bankMax == 0) {
            return;
        }
        if (this.oldBank == newBank % this.bankMax) {
            return;
        }
        CartridgeEvent e = new CartridgeEvent();
        e.oldBank = this.oldBank;
        e.newBank = newBank % this.bankMax;
        this.oldBank = newBank % this.bankMax;
        this.currentBank = newBank % this.bankMax;
        if (this.vecx != null && !this.vecx.isDebugging()) {
            if (this.isMicrochip && this.microchip.usesPB6() && this.microchip.isActive()) {
                return;
            }
            if (this.is2430a && this.ds2430.usesPB6() && this.ds2430.isActive()) {
                return;
            }
            if (this.isDS2431 && this.ds2431.usesPB6() && this.ds2431.isActive()) {
                return;
            }
            if (this.isAtmel && this.atmel.usesPB6() && this.atmel.isActive()) {
                return;
            }
        }
        this.fireCartridgeChanged(e);
    }

    public int readByte(int pos) {
        if (this.cart == null) {
            return 0;
        }
        if (this.flashSupport && this.idSequenceData == 3 && this.idSequenceAddress == 3) {
            if (pos % 2 == 0) {
                this.log.addLog("FLASH ID read: $bf", LogPanel.INFO);
                return 191;
            }
            this.log.addLog("FLASH ID read: $b6", LogPanel.INFO);
            return 182;
        }
        if (this.peer44_4_enabled && pos >= 45056 && pos < 49152) {
            return this.extraRam[pos - 45056] & 0xFF;
        }
        if (this.extraRam2000_2800_2k_Enabled && pos >= 8192 && pos < 10240) {
            return this.extraRam[pos - 8192] & 0xFF;
        }
        if (this.extraRam8000_8800_2k_Enabled) {
            if (pos >= 32768 && pos < 34816) {
                return this.extraRam[pos - 32768] & 0xFF;
            }
            if (pos == 40960) {
                return this.spectrumByte & 0xFF;
            }
        }
        if (this.extraRam6000_7fff_8k_Enabled && pos >= 24576 && pos < 32768) {
            return this.extraRam[pos - 24576] & 0xFF;
        }
        if (this.sidEnabled && pos >= 32768 && pos < 32800 && this.vecx != null) {
            return this.vsid.performRead(pos, this.vecx.getCycles());
        }
        if (this.v4e_16k_bankswitch && (pos & 0xC000) == 49152) {
            int b = pos & 0xFF;
            if (b == 0) {
                this.setBank(0);
            }
            if (b == 1) {
                this.setBank(1);
            }
            if (b == 2) {
                this.setBank(2);
            }
            if (b == 3) {
                this.setBank(3);
            }
        }
        if (this.cart.length <= this.currentBank) {
            return 255;
        }
        if (this.cart[this.currentBank] == null) {
            return 255;
        }
        if (pos % this.MAX_BANK_SIZE >= this.cart[this.currentBank].length) {
            return 255;
        }
        return this.cart[this.currentBank][pos % this.MAX_BANK_SIZE];
    }

    public int readByteDirect(int adr, int bank2) {
        if (this.cart == null) {
            return 255;
        }
        if (this.cart.length <= bank2) {
            return 255;
        }
        if (this.cart[bank2] == null) {
            return 255;
        }
        if (this.peer44_4_enabled && adr >= 45056 && adr < 49152) {
            return this.extraRam[adr - 45056] & 0xFF;
        }
        if (adr % this.MAX_BANK_SIZE >= this.cart[bank2].length) {
            return 255;
        }
        return this.cart[bank2][adr % this.MAX_BANK_SIZE] & 0xFF;
    }

    public boolean isExtremeMulti() {
        return this.extremeMulti;
    }

    public void write(int address, byte data2) {
        try {
            if (this.sidEnabled && address >= 32768 && address < 32800) {
                if (this.vecx != null) {
                    this.vsid.performWrite(address, data2, this.vecx.getCycles());
                }
                return;
            }
            if (this.extremeMulti) {
                this.writeExtreme(address, data2);
                return;
            }
            if (address >= 45056 && address < 49152 && this.peer44_4_enabled) {
                this.extraRam[address - 45056] = data2;
            }
            if (address >= 8192 && address < 10240 && this.extraRam2000_2800_2k_Enabled) {
                this.extraRam[address - 8192] = data2;
            }
            boolean flashDone = false;
            if (this.flashSupport && this.writeSequenceAddress >= 3 && this.writeSequenceData >= 3 && address != 21845) {
                VecXPanel vecXPanel;
                DissiPanel dissi;
                flashDone = true;
                this.writeSequenceAddress = 0;
                this.writeSequenceData = 0;
                if (this.cart.length <= this.currentBank) {
                    return;
                }
                if (address % this.MAX_BANK_SIZE >= this.cart[this.currentBank].length) {
                    return;
                }
                byte oldData = (byte)this.cart[this.currentBank][address % this.MAX_BANK_SIZE];
                byte newData = (byte)(data2 & oldData);
                this.cart[this.currentBank][address % this.MAX_BANK_SIZE] = newData;
                this.log.addLog("FLASH write (" + this.currentBank + "," + address % this.MAX_BANK_SIZE + "->" + newData + ")", LogPanel.INFO);
                if (this.vecx != null && this.vecx.getDisplay() instanceof VecXPanel && (dissi = (vecXPanel = (VecXPanel)this.vecx.getDisplay()).getDissi()) != null) {
                    dissi.doThePoke(address, newData);
                }
            }
            if (!flashDone) {
                if (address >= 32768 && address < 34816 && this.extraRam8000_8800_2k_Enabled) {
                    this.extraRam[address - 32768] = data2;
                } else if (address == 40960 && this.extraRam8000_8800_2k_Enabled) {
                    this.spectrumByte = data2;
                } else if (address >= 24576 && address < 32768 && this.extraRam6000_7fff_8k_Enabled) {
                    this.extraRam[address - 24576] = data2;
                } else {
                    if (this.v4e_16k_bankswitch && (this.pos & 0xC000) == 49152) {
                        int b = this.pos & 0xC000;
                        if (b == 0) {
                            this.setBank(0);
                        }
                        if (b == 1) {
                            this.setBank(1);
                        }
                        if (b == 2) {
                            this.setBank(2);
                        }
                        if (b == 3) {
                            this.setBank(3);
                        }
                    }
                    if (this.cart == null) {
                        return;
                    }
                    if (this.cart.length <= this.currentBank) {
                        return;
                    }
                    if (this.vecx.config.ramAccessAllowed) {
                        if (address % this.MAX_BANK_SIZE >= this.cart[this.currentBank].length) {
                            return;
                        }
                        this.cart[this.currentBank][address % this.MAX_BANK_SIZE] = data2;
                    } else {
                        this.log.addLog("ROM write-access at: $" + String.format("%04X", address) + ", $" + String.format("%02X", data2 & 0xFF) + " from $" + String.format("%04X", this.vecx.getPC()), LogPanel.VERBOSE);
                        if (this.vecx.config.breakpointsActive) {
                            this.vecx.checkROMBreakPoint(address, data2);
                        }
                    }
                }
            }
        }
        catch (Exception xx) {
            this.log.addLog("Rom Write Expetion" + String.format("%04X", address) + ", $" + String.format("%02X", data2 & 0xFF) + " from $" + String.format("%04X", this.vecx.getPC()) + "\n" + Utility.getCurrentStackTrace(), LogPanel.ERROR);
        }
    }

    private void writeExtreme(int addr, byte data2) {
        block23: {
            if (addr == 1) {
                this.cHi = data2 << 8;
            }
            if (addr == 2) {
                int timerT2 = this.cHi + data2 & 0xFFFF;
                int timerT2Real = (data2 << 8) + (this.cHi >> 8) & 0xFFFF;
                if (this.doExtremeOutput) {
                    System.out.println("DBG: 1 " + String.format("%04X", timerT2) + "");
                    if (timerT2Real > 50000) {
                        ++this.big;
                        if (this.big > 1) {
                            // empty if block
                        }
                    } else {
                        this.big = 0;
                    }
                }
            }
            if (addr == 32766) {
                this.parm = data2;
            }
            if ((addr & 0xFF) == 255) {
                try {
                    if (data2 == 1) {
                        this.log.addLog("Cart: extreme multicard -> Unimplemented: multicart", LogPanel.WARN);
                        break block23;
                    }
                    if (data2 == 2) {
                        if (this.allData == null) {
                            try {
                                Path path = Paths.get(Global.mainPathPrefix + "vec.bin", new String[0]);
                                if (this.currentCardProp != null) {
                                    String s = "vec.bin";
                                    if (this.currentCardProp.mFullFilename.size() > 0) {
                                        String org2 = this.currentCardProp.mFullFilename.elementAt(0);
                                        int t = org2.lastIndexOf(File.separator) + 1;
                                        s = org2.substring(0, t) + s;
                                    }
                                    path = Paths.get(Global.mainPathPrefix + s, new String[0]);
                                    if (this.currentCardProp.mextremeVecFileImage != null && this.currentCardProp.mextremeVecFileImage.trim().length() != 0) {
                                        path = Paths.get(Global.mainPathPrefix + this.currentCardProp.mextremeVecFileImage, new String[0]);
                                    }
                                }
                                this.allData = Files.readAllBytes(path);
                                this.pos = 0;
                            }
                            catch (Throwable path) {
                                // empty catch block
                            }
                        }
                        if (this.allData == null) {
                            return;
                        }
                        if (this.allData.length < this.pos + 1024 + 512) {
                            this.pos = 0;
                        }
                        for (int ii = 0; ii < 1536; ++ii) {
                            this.cart[this.currentBank][16384 + ii] = this.allData[this.pos];
                            ++this.pos;
                        }
                        if (this.doExtremeOutput) {
                            System.out.println("Read 1536 bytes " + String.format("%02X", this.cart[this.currentBank][16384]) + ".");
                        }
                        break block23;
                    }
                    if (data2 == 66) {
                        this.log.addLog("Cart: extreme multicard -> doom not supported", LogPanel.WARN);
                        System.out.println("Doom Boom!\n");
                    }
                }
                catch (Exception ex) {
                    this.log.addLog(ex, LogPanel.ERROR);
                }
            }
        }
    }

    public String getBankeRomName(int bank2) {
        if (this.bankFileNames == null) {
            this.log.addLog("Cart: getBankeRomName() bankFileNames = null", LogPanel.WARN);
            return null;
        }
        if (bank2 >= this.bankFileNames.length) {
            this.log.addLog("Cart: getBankeRomName() bank > size", LogPanel.WARN);
            return null;
        }
        return this.bankFileNames[bank2];
    }

    public byte[] getByteData(int bank2) {
        if (this.bankLength == null) {
            this.log.addLog("Cart: getByteData() bankLength = null", LogPanel.WARN);
            return new byte[0];
        }
        if (bank2 >= this.bankLength.length) {
            this.log.addLog("Cart: getByteData() bank >= bankLength", LogPanel.WARN);
            return new byte[0];
        }
        byte[] ret = new byte[this.bankLength[bank2]];
        for (int i = 0; i < this.bankLength[bank2]; ++i) {
            ret[i] = (byte)(this.cart[bank2][i] & 0xFF);
        }
        return ret;
    }

    public boolean init(CartridgeProperties cartProp) {
        boolean ok;
        this.currentCardProp = cartProp;
        this.peer44_4_enabled = (cartProp.getTypeFlags() & FLAG_44_PEER_BS) != 0;
        this.extraRam2000_2800_2k_Enabled = (cartProp.getTypeFlags() & FLAG_RAM_ANIMACTION) != 0;
        this.extraRam8000_8800_2k_Enabled = (cartProp.getTypeFlags() & FLAG_RAM_RA_SPECTRUM) != 0;
        this.extraRam6000_7fff_8k_Enabled = (cartProp.getTypeFlags() & FLAG_LOGO) != 0;
        boolean bl = this.rom48KEnabled = (cartProp.getTypeFlags() & FLAG_48K) != 0;
        if (this.peer44_4_enabled) {
            this.rom48KEnabled = true;
        }
        this.MAX_BANK_SIZE = 32768;
        if (this.rom48KEnabled) {
            this.MAX_BANK_SIZE = 49152;
        }
        this.is2430a = (cartProp.getTypeFlags() & FLAG_DS2430A) != 0;
        this.isDS2431 = (cartProp.getTypeFlags() & FLAG_DS2431) != 0;
        this.isAtmel = (cartProp.getTypeFlags() & FLAG_ATMEL_EEPROM) != 0;
        this.isMicrochip = (cartProp.getTypeFlags() & FLAG_MICROCHIP) != 0;
        this.isPB6IRQBankswitch = (cartProp.getTypeFlags() & FLAG_BS_PB6_IRQ) != 0;
        this._32kOnly = (cartProp.getTypeFlags() & FLAG_32K_ONLY) != 0;
        this.isXmas = (cartProp.getTypeFlags() & FLAG_XMAS) != 0;
        this.isDualVec = (cartProp.getTypeFlags() & FLAG_DUALVEC1) != 0 || (cartProp.getTypeFlags() & FLAG_DUALVEC2) != 0;
        this.extremeMulti = (cartProp.getTypeFlags() & FLAG_EXTREME_MULTI) != 0;
        this.sidEnabled = (cartProp.getTypeFlags() & FLAG_SID) != 0;
        this.flashSupport = (cartProp.getTypeFlags() & FLAG_FLASH_SUPPORT) != 0;
        this.previousExternalLineB = false;
        this.oldCycles = 0L;
        if (cartProp == null) {
            this.log.addLog("Cart: init() cartProp = null", LogPanel.WARN);
            return false;
        }
        if (cartProp.mFullFilename == null) {
            this.log.addLog("Cart: init() mFullFilename = null", LogPanel.WARN);
            return false;
        }
        this.cartName = cartProp.mCartName;
        this.bankMax = cartProp.mFullFilename.size();
        if (this.bankMax == 0) {
            this.log.addLog("Cart: init() bankMax = 0", LogPanel.WARN);
            return false;
        }
        if (cartProp.mFullFilename.size() > 0 && !(ok = DownloaderPanel.ensureLocalFile("Cartridge", cartProp.mBinaryLink, Utility.makeVideAbsolute(UtilityFiles.convertSeperator(cartProp.mFullFilename.elementAt(0)))))) {
            this.log.addLog("Cart: Downloadable files not found...", LogPanel.WARN);
            return false;
        }
        if (this.bankMax == 1) {
            if (!this.load(Utility.makeVideAbsolute(cartProp.mFullFilename.elementAt(0)))) {
                this.log.addLog("Cart: init() single bank not loaded: " + cartProp.mFullFilename, LogPanel.WARN);
                return false;
            }
        } else {
            this.cart = new int[this.bankMax][];
            this.bankLength = new int[this.bankMax];
            this.bankFileNames = new String[this.bankMax];
            for (int bank2 = 0; bank2 < this.bankMax; ++bank2) {
                this.bankFileNames[bank2] = "";
                String romName = Utility.makeVideAbsolute(cartProp.mFullFilename.elementAt(bank2));
                this.bankFileNames[bank2] = "";
                if (cartProp.mFullFilename.elementAt(bank2).trim().length() == 0) continue;
                File f = new File(romName);
                if (!f.exists()) {
                    this.log.addLog("Cart: init() multi bank file does not exist: " + romName, LogPanel.WARN);
                    return false;
                }
                if (!this.load(romName, bank2)) {
                    this.log.addLog("Cart: init() multi bank file not loaded: " + romName, LogPanel.WARN);
                    return false;
                }
                this.bankFileNames[bank2] = romName;
            }
            if (!this.isPB6IRQBankswitch && this.getBankCount() < 3) {
                this.setBank(this.previousExternalLineB ? 1 : 0);
                this.log.addLog("cart: init " + this.toString(cartProp), LogPanel.INFO);
                return true;
            }
        }
        if (this.peer44_4_enabled) {
            this.extraRam = new byte[4096];
        }
        if (this.extraRam2000_2800_2k_Enabled) {
            this.extraRam = new byte[2048];
        }
        if (this.extraRam8000_8800_2k_Enabled) {
            this.extraRam = new byte[2048];
            this.setPB6FromCartridge(false);
        }
        if (this.extraRam6000_7fff_8k_Enabled) {
            this.extraRam = new byte[8192];
        }
        if (this.isDualVec) {
            int side = 0;
            if ((cartProp.getTypeFlags() & FLAG_DUALVEC2) != 0) {
                side = 1;
            }
            this.dualvec = DualVec.getDualVec(side, this);
        } else {
            if (this.dualvec != null) {
                this.dualvec.setCartridge(null);
            }
            this.dualvec = null;
        }
        if (this.isXmas) {
            this.xMasLED = new XMasLED();
            this.xMasLED.setCartridge(this);
        }
        this.log.addLog("cart: init " + this.toString(cartProp), LogPanel.INFO);
        if (cartProp.mConfigOverwrite) {
            VideConfig config = VideConfig.getConfig();
            config.autoSync = cartProp.mCF_AutoSync;
            config.ramAccessAllowed = cartProp.mCF_AllowROMWrite;
            config.romAndPcBreakpoints = cartProp.mCF_ROM_PC_BreakPoints;
            if (cartProp.mCF_IntegratorMaxX != 0 && cartProp.mCF_IntegratorMaxY != 0) {
                config.ALG_MAX_X = cartProp.mCF_IntegratorMaxX;
                config.ALG_MAX_Y = cartProp.mCF_IntegratorMaxY;
            }
            if (cartProp.mCF_OverlayThreshold != 0.0f) {
                config.JOGLOverlayAlphaThreshold = cartProp.mCF_OverlayThreshold;
            }
            if (cartProp.mCF_DotdwellDivisor != 0) {
                config.JOGLDotDwellDivisor = cartProp.mCF_DotdwellDivisor;
            }
        }
        return true;
    }

    public boolean inject(CartridgeProperties cartProp) {
        if (cartProp == null) {
            this.log.addLog("Cart: init() cartProp = null", LogPanel.WARN);
            return false;
        }
        if (cartProp.mFullFilename == null) {
            this.log.addLog("Cart: init() mFullFilename = null", LogPanel.WARN);
            return false;
        }
        this.cartName = cartProp.mCartName;
        this.bankMax = cartProp.mFullFilename.size();
        if (this.bankMax == 0) {
            this.log.addLog("Cart: init() bankMax = 0", LogPanel.WARN);
            return false;
        }
        if (this.bankMax == 1) {
            if (!this.load(Utility.makeVideAbsolute(cartProp.mFullFilename.elementAt(0)))) {
                this.log.addLog("Cart: init() single bank not loaded: " + cartProp.mFullFilename, LogPanel.WARN);
                return false;
            }
        } else {
            this.cart = new int[this.bankMax][];
            this.bankLength = new int[this.bankMax];
            this.bankFileNames = new String[this.bankMax];
            for (int bank2 = 0; bank2 < this.bankMax; ++bank2) {
                this.bankFileNames[bank2] = "";
                String romName = Utility.makeVideAbsolute(cartProp.mFullFilename.elementAt(bank2));
                this.bankFileNames[bank2] = "";
                if (romName.trim().length() == 0) continue;
                File f = new File(romName);
                if (!f.exists()) {
                    this.log.addLog("Cart: init() multi bank file does not exist: " + romName, LogPanel.WARN);
                    return false;
                }
                if (!this.load(romName, bank2)) {
                    this.log.addLog("Cart: init() multi bank file not loaded: " + romName, LogPanel.WARN);
                    return false;
                }
                this.bankFileNames[bank2] = romName;
            }
        }
        this.log.addLog("cart: inject " + this.toString(cartProp), LogPanel.INFO);
        return true;
    }

    private boolean load(String filenameRom, int bank2) {
        try {
            int length;
            Path path = Paths.get(Cartridge.convertSeperator(filenameRom), new String[0]);
            byte[] data2 = Files.readAllBytes(path);
            if (data2.length > this.MAX_BANK_SIZE) {
                this.log.addLog("Cart: load() multi part rom is larger than " + this.MAX_BANK_SIZE + ", additional data is ignored! - " + filenameRom, LogPanel.WARN);
            }
            this.bankLength[bank2] = (length = data2.length) > this.MAX_BANK_SIZE ? this.MAX_BANK_SIZE : length;
            this.cart[bank2] = new int[this.MAX_BANK_SIZE];
            for (int i = 0; i < this.MAX_BANK_SIZE; ++i) {
                if (i >= data2.length) {
                    if (i < 32768) {
                        this.cart[bank2][i] = 1;
                        continue;
                    }
                    this.cart[bank2][i] = 255;
                    continue;
                }
                this.cart[bank2][i] = data2[i] & 0xFF;
            }
        }
        catch (Throwable e) {
            this.log.addLog(e, LogPanel.ERROR);
            return false;
        }
        return true;
    }

    public boolean load(String filenameRom) {
        this.previousExternalLineB = false;
        this.oldCycles = 0L;
        boolean irregularBanksize = false;
        if (filenameRom.toLowerCase().endsWith(".v4e")) {
            boolean ret = this.loadV4E(filenameRom);
            return ret;
        }
        this.cartName = filenameRom;
        if (!new File(filenameRom).exists()) {
            return false;
        }
        if (new File(filenameRom).isDirectory()) {
            return false;
        }
        try {
            int i;
            Path path = Paths.get(filenameRom, new String[0]);
            byte[] data2 = Files.readAllBytes(path);
            this.loadLen = data2.length;
            if (this.loadLen == 262144) {
                this.rom48KEnabled = true;
                this.MAX_BANK_SIZE = 49152;
                this.isPB6IRQBankswitch = true;
                this.bankMax = 4;
                this.bankLength = new int[this.bankMax];
                this.bankLength[0] = 65536;
                this.bankLength[1] = 65536;
                this.bankLength[2] = 65536;
                this.bankLength[3] = 65536;
                this.cart = new int[4][];
                this.cart[0] = new int[65536];
                this.cart[1] = new int[65536];
                this.cart[2] = new int[65536];
                this.cart[3] = new int[65536];
                for (int i2 = 0; i2 < 65536; ++i2) {
                    this.cart[0][i2] = data2[0 + i2] & 0xFF;
                    this.cart[1][i2] = data2[65536 + i2] & 0xFF;
                    this.cart[2][i2] = data2[131072 + i2] & 0xFF;
                    this.cart[3][i2] = data2[196608 + i2] & 0xFF;
                }
                return true;
            }
            if (this.loadLen > this.MAX_BANK_SIZE && !this._32kOnly) {
                this.log.addLog("Cartridge size > bank size, bankswitching assumed!", LogPanel.WARN);
            }
            this.bankMax = (data2.length + (this.MAX_BANK_SIZE - 1)) / this.MAX_BANK_SIZE;
            if (this.bankMax == 3) {
                this.bankMax = 2;
                irregularBanksize = true;
            }
            if (this._32kOnly && this.loadLen > this.MAX_BANK_SIZE) {
                this.loadLen = this.MAX_BANK_SIZE;
                this.bankMax = 1;
            }
            if (this.loadLen > 32768 && this.loadLen <= 49152) {
                this.log.addLog("Assume 48k CART", LogPanel.WARN);
                this.rom48KEnabled = true;
                this.MAX_BANK_SIZE = 49152;
                this.bankMax = 2;
            }
            if (this.loadLen == 131072) {
                this.log.addLog("Assume 44+4k CART", LogPanel.WARN);
                this.peer44_4_enabled = true;
                this.rom48KEnabled = true;
                this.MAX_BANK_SIZE = 49152;
                this.extraRam = new byte[4096];
                this.bankMax = 2;
                irregularBanksize = true;
            }
            this.cart = new int[this.bankMax][];
            this.bankLength = new int[this.bankMax];
            this.bankFileNames = new String[this.bankMax];
            if (this.loadLen == 0) {
                this.log.addLog("Cartridge not loaded, loadLen = 0", LogPanel.WARN);
                return false;
            }
            int length = this.loadLen;
            int additionalFillLength = 0;
            if (irregularBanksize) {
                additionalFillLength = 16384;
            }
            for (int b = 0; b < this.bankMax; ++b) {
                this.bankFileNames[b] = filenameRom;
                this.bankLength[b] = length > this.MAX_BANK_SIZE ? this.MAX_BANK_SIZE : length;
                length -= this.bankLength[b];
                this.cart[b] = new int[this.MAX_BANK_SIZE];
                for (int i3 = 0; i3 < this.MAX_BANK_SIZE; ++i3) {
                    if (b * (this.MAX_BANK_SIZE + additionalFillLength) + i3 >= data2.length) {
                        if (i3 < 32768) {
                            this.cart[b][i3] = 1;
                            continue;
                        }
                        this.cart[b][i3] = 255;
                        continue;
                    }
                    this.cart[b][i3] = data2[b * (this.MAX_BANK_SIZE + additionalFillLength) + i3] & 0xFF;
                }
            }
            if (this.bankMax == 2 && this.bankLength[1] == 0) {
                for (i = 0; i < this.MAX_BANK_SIZE; ++i) {
                    this.cart[1][i] = this.cart[0][i];
                }
            }
            if (this.bankMax == 4) {
                if (this.bankLength[2] == 0) {
                    for (i = 0; i < this.MAX_BANK_SIZE; ++i) {
                        this.cart[2][i] = this.cart[0][i];
                    }
                }
                if (this.bankLength[3] == 0) {
                    for (i = 0; i < this.MAX_BANK_SIZE; ++i) {
                        this.cart[3][i] = this.cart[1][i];
                    }
                }
            }
            if (this.bankMax > 1 && this.getBankCount() < 3 && !this.isPB6IRQBankswitch) {
                this.setBank(this.previousExternalLineB ? 1 : 0);
            }
        }
        catch (Throwable e) {
            this.log.addLog(e, LogPanel.WARN);
            return false;
        }
        return true;
    }

    public static void deepCopy(Cartridge from, Cartridge to, boolean doRam, boolean doTimer) {
        to.atmel = from.atmel.clone();
        to.atmel.cart = to;
        to.ds2430 = from.ds2430.clone();
        to.ds2430.cart = to;
        to.ds2431 = from.ds2431.clone();
        to.ds2431.cart = to;
        to.microchip = from.microchip.clone();
        to.microchip.cart = to;
        to.isPB6IRQBankswitch = to.isPB6IRQBankswitch;
        if (from.dualvec == null) {
            to.dualvec = null;
        } else {
            to.dualvec = from.dualvec.clone();
            to.dualvec.cart = to;
        }
        to.vecx = from.vecx;
    }

    public boolean checkBankswitchPB6(boolean externalLine, long cycles) {
        if (this.v4e_16k_bankswitch) {
            return false;
        }
        if (this.previousExternalLineB != externalLine) {
            this.previousExternalLineB = externalLine;
            if (this.isPB6IRQBankswitch) {
                this.setPB6IRQBank();
                return true;
            }
            if (this.getBankCount() < 3) {
                this.setBank(this.previousExternalLineB ? 1 : 0);
                return true;
            }
            if (this.getBankCount() > 32) {
                this.setBank(this.previousExternalLineB ? 1 : 0);
                return true;
            }
            boolean switched = false;
            switch (this.vfState) {
                case RESET: {
                    if (externalLine) break;
                    this.setBank(0);
                    switched = true;
                    this.vfState = VECFLASH.LOW_CHECK;
                    break;
                }
                case LOW_CHECK: {
                    if (!externalLine) {
                        this.setBank(this.getCurrentBank() + 1);
                        switched = true;
                        this.vfState = VECFLASH.LOW_PULSE;
                        this.oldCycles = cycles;
                    }
                    return switched;
                }
                case LOW_PULSE: {
                    if (!externalLine) {
                        this.vfState = VECFLASH.LOW_PULSE;
                        break;
                    }
                    long l = cycles - this.oldCycles;
                    if (l < 80L) {
                        this.vfState = VECFLASH.LOW_CHECK;
                        return switched;
                    }
                    this.vfState = VECFLASH.RESET;
                }
            }
            return switched;
        }
        return false;
    }

    private void setPB6IRQBank() {
        int newBank = 0;
        if (this.previousExternalLineB) {
            ++newBank;
        }
        if (this.previousExternalLineIRQ) {
            newBank += 2;
        }
        this.setBank(newBank);
    }

    public boolean checkBankswitchIRQ(boolean IRQLine, long cycles) {
        if (!this.isPB6IRQBankswitch) {
            return false;
        }
        if (this.previousExternalLineIRQ != IRQLine) {
            this.previousExternalLineIRQ = IRQLine;
            this.setPB6IRQBank();
            return true;
        }
        return false;
    }

    public static String convertSeperator(String filename) {
        String ret = UtilityString.replace(filename, "/", File.separator);
        ret = UtilityString.replace(ret, "\\", File.separator);
        return ret;
    }

    public void setPB6FromVectrex(boolean pb6) {
        boolean changed;
        if (this.vecx == null) {
            return;
        }
        this.currentPB6 = pb6;
        if (this.isAtmel) {
            this.atmel.linePB6In(pb6);
        }
        if (this.is2430a) {
            this.ds2430.linePB6In(pb6);
        }
        if (this.isDS2431) {
            this.ds2431.linePB6In(pb6);
        }
        if (this.isMicrochip) {
            this.microchip.linePB6In(pb6);
        }
        if (this.vecx.config.enableBankswitch && (changed = this.checkBankswitchPB6(pb6, this.vecx.cyclesRunning))) {
            this.vecx.checkBankswitchBreakpoint();
        }
        if (this.extraRam8000_8800_2k_Enabled) {
            // empty if block
        }
        if (this.isDualVec) {
            this.dualvec.linePB6In(pb6);
        }
        if (this.isXmas) {
            this.xMasLED.linePB6In(pb6);
        }
    }

    public void setIRQFromVectrex(boolean irq) {
        boolean changed;
        if (this.vecx == null) {
            return;
        }
        boolean bl = this.currentIRQ = !irq;
        if (this.isAtmel) {
            this.atmel.lineIRQIn(!irq);
        }
        if (this.isPB6IRQBankswitch && this.vecx.config.enableBankswitch && (changed = this.checkBankswitchIRQ(!irq, this.vecx.cyclesRunning))) {
            this.vecx.checkBankswitchBreakpoint();
        }
    }

    public void setPB6FromCartridge(boolean b) {
        this.currentPB6 = b;
        if (this.vecx != null) {
            this.vecx.setPB6FromExternal(b);
        }
    }

    public void setCyclesRunning(long n) {
        if (this.isSIDEnabled()) {
            this.vsid.setCyclesRunning(n);
        }
    }

    public void updateSound() {
        if (this.sidEnabled) {
            this.vsid.updateSound();
        }
    }

    public SID.State getSidState() {
        if (!this.sidEnabled) {
            return null;
        }
        if (this.vsid == null) {
            return null;
        }
        return this.vsid.sid.read_state();
    }

    public boolean isSIDEnabled() {
        return this.sidEnabled;
    }

    public void cartStep(long cycles) {
        if (this.vecx == null) {
            return;
        }
        if (this.isAtmel) {
            this.atmel.step(cycles);
        }
        if (this.is2430a) {
            this.ds2430.step(cycles);
        }
        if (this.isDS2431) {
            this.ds2431.step(cycles);
        }
        if (this.isMicrochip) {
            this.microchip.step(cycles);
        }
        if (this.sidEnabled) {
            if (this.vsid == null) {
                this.vsid = new VSID(this);
                this.vsid.init();
            }
            this.vsid.step(cycles);
        }
        if (this.isDualVec) {
            this.dualvec.step(cycles);
        }
        if (this.flashSupport) {
            this.checkEraseSequence();
            this.checkIDSequence();
            this.checkWriteSequence();
        }
    }

    private void checkEraseSequence() {
        int addressBUS = this.vecx.getAddressBUS();
        int dataBUS = this.vecx.getDataBUS() & 0xFF;
        if (this.eraseSequenceAddress == 0 && addressBUS == 21845) {
            this.eraseSequenceAddress = 1;
        } else if (this.eraseSequenceAddress == 1 && (addressBUS == 21845 || addressBUS == 10922)) {
            if (addressBUS == 10922) {
                this.eraseSequenceAddress = 2;
            }
        } else if (this.eraseSequenceAddress == 2 && (addressBUS == 21845 || addressBUS == 10922)) {
            if (addressBUS == 10922) {
                this.eraseSequenceAddress = 3;
            }
        } else if (this.eraseSequenceAddress == 3 && (addressBUS == 21845 || addressBUS == 10922)) {
            if (addressBUS == 21845) {
                this.eraseSequenceAddress = 4;
            }
        } else if (this.eraseSequenceAddress == 4 && (addressBUS == 21845 || addressBUS == 10922)) {
            if (addressBUS == 10922) {
                this.eraseSequenceAddress = 5;
            }
        } else if (this.eraseSequenceAddress != 5 || addressBUS != 10922) {
            if (this.eraseSequenceAddress == 5 && addressBUS != 10922) {
                this.eraseAddress = addressBUS;
                this.eraseSequenceAddress = 6;
            } else {
                this.eraseSequenceAddress = this.eraseSequenceAddress == 6 && addressBUS != this.eraseAddress ? 0 : 0;
            }
        }
        if (this.eraseSequenceData == 0 && dataBUS == 170) {
            this.eraseSequenceData = 1;
        } else if (this.eraseSequenceData == 1 && (dataBUS == 170 || dataBUS == 85)) {
            if (dataBUS == 85) {
                this.eraseSequenceData = 2;
            }
        } else if (this.eraseSequenceData == 2 && (dataBUS == 85 || dataBUS == 128)) {
            if (dataBUS == 128) {
                this.eraseSequenceData = 3;
            }
        } else if (this.eraseSequenceData == 3 && (dataBUS == 170 || dataBUS == 128)) {
            if (dataBUS == 170) {
                this.eraseSequenceData = 4;
            }
        } else if (this.eraseSequenceData == 4 && (dataBUS == 170 || dataBUS == 85)) {
            if (dataBUS == 85) {
                this.eraseSequenceData = 5;
            }
        } else if (this.eraseSequenceData == 5 && (dataBUS == 48 || dataBUS == 85)) {
            if (dataBUS == 48) {
                this.eraseSequenceData = 6;
            }
        } else if (this.eraseSequenceData != 6 || dataBUS != 48) {
            this.eraseSequenceData = 0;
        }
        if (this.eraseSequenceAddress == 6 && this.eraseSequenceData == 6) {
            int start;
            this.log.addLog("Erase sequence ...", LogPanel.INFO);
            this.eraseSequenceAddress = 0;
            this.eraseSequenceData = 0;
            for (int i = start = this.eraseAddress & 0xFFFF000; i < start + 4096; ++i) {
                this.cart[this.currentBank][i % this.MAX_BANK_SIZE] = 255;
            }
        }
    }

    private void checkIDSequence() {
        int addressBUS = this.vecx.getAddressBUS();
        int dataBUS = this.vecx.getDataBUS() & 0xFF;
        if (this.idSequenceAddress == 0 && addressBUS == 21845) {
            this.idSequenceAddress = 1;
        } else if (this.idSequenceAddress == 1 && (addressBUS == 21845 || addressBUS == 10922)) {
            if (addressBUS == 10922) {
                this.idSequenceAddress = 2;
            }
        } else if (this.idSequenceAddress == 2 && (addressBUS == 21845 || addressBUS == 10922)) {
            if (addressBUS == 21845) {
                this.idSequenceAddress = 3;
            }
        } else if (!(this.idSequenceAddress == 3 && addressBUS == 21845 || this.idSequenceData == 3 && this.idSequenceAddress == 3)) {
            this.idSequenceAddress = 0;
        }
        if (this.idSequenceData == 0 && dataBUS == 170) {
            this.idSequenceData = 1;
        } else if (this.idSequenceData == 1 && (dataBUS == 170 || dataBUS == 85)) {
            if (dataBUS == 85) {
                this.idSequenceData = 2;
            }
        } else if (this.idSequenceData == 2 && (dataBUS == 85 || dataBUS == 144)) {
            if (dataBUS == 144) {
                this.idSequenceData = 3;
            }
        } else if (this.idSequenceData != 3 || dataBUS != 144) {
            if (this.idSequenceData == 3 && this.idSequenceAddress == 3) {
                this.log.addLog("Id Sequence on", LogPanel.INFO);
            } else {
                this.idSequenceData = 0;
            }
        }
        if (this.idSequenceAddress == 3 && this.idSequenceData == 3 && dataBUS == 240) {
            this.idSequenceAddress = 0;
            this.idSequenceData = 0;
            this.log.addLog("Id Sequence off", LogPanel.INFO);
        }
    }

    private void checkWriteSequence() {
        int addressBUS = this.vecx.getAddressBUS();
        int dataBUS = this.vecx.getDataBUS() & 0xFF;
        if (this.writeSequenceAddress == 0 && addressBUS == 21845) {
            this.writeSequenceAddress = 1;
        } else if (this.writeSequenceAddress == 1 && (addressBUS == 21845 || addressBUS == 10922)) {
            if (addressBUS == 10922) {
                this.writeSequenceAddress = 2;
            }
        } else if (this.writeSequenceAddress == 2 && (addressBUS == 21845 || addressBUS == 10922)) {
            if (addressBUS == 21845) {
                this.writeSequenceAddress = 3;
            }
        } else if (this.writeSequenceAddress != 3 || addressBUS != 21845) {
            if (this.writeSequenceData >= 3 && this.writeSequenceAddress == 3) {
                this.writeSequenceAddress = 4;
            } else if (this.writeSequenceData < 3 || this.writeSequenceAddress != 4) {
                this.writeSequenceAddress = 0;
            }
        }
        if (this.writeSequenceData == 0 && dataBUS == 170) {
            this.writeSequenceData = 1;
        } else if (this.writeSequenceData == 1 && (dataBUS == 170 || dataBUS == 85)) {
            if (dataBUS == 85) {
                this.writeSequenceData = 2;
            }
        } else if (this.writeSequenceData == 2 && (dataBUS == 85 || dataBUS == 160)) {
            if (dataBUS == 160) {
                this.writeSequenceData = 3;
            }
        } else if (this.writeSequenceData != 3 || dataBUS != 160) {
            if (this.writeSequenceData == 3 && this.writeSequenceAddress >= 3) {
                this.writeSequenceData = 4;
            } else if (this.writeSequenceData != 4 || this.writeSequenceAddress < 3) {
                this.writeSequenceData = 0;
            }
        }
    }

    public void reset() {
        if (this.vecx == null) {
            return;
        }
        if (this.isAtmel) {
            this.atmel.reset();
        }
        if (this.is2430a) {
            this.ds2430.reset();
        }
        if (this.isDS2431) {
            this.ds2431.reset();
        }
        if (this.isMicrochip) {
            this.microchip.reset();
        }
    }

    public DisplayerInterface getDisplay() {
        if (this.vecx == null) {
            return null;
        }
        return this.vecx.getDisplay();
    }

    String toString(CartridgeProperties prop) {
        return "\nTypes: " + this.getTypInfoString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dumpCurrentROM() {
        String filename = Global.mainPathPrefix + "tmp" + File.separator + "dump.rom";
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(filename, false);
            if (this.cart.length >= 2) {
                int i;
                for (i = 0; i < this.cart[0].length; ++i) {
                    output.write(this.cart[0][i]);
                }
                for (i = 0; i < this.cart[1].length; ++i) {
                    output.write(this.cart[1][i]);
                }
            } else {
                for (int i = 0; i < this.cart[0].length; ++i) {
                    output.write(this.cart[0][i]);
                }
            }
        }
        catch (Throwable e) {
            String string = null;
            return string;
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (Throwable e) {
                    return null;
                }
            }
        }
        return filename;
    }

    public void initFromStateSave() {
        if (this.sidEnabled) {
            this.vsid.recallState();
        }
    }

    public void initStateSave() {
        if (this.sidEnabled) {
            this.vsid.rememberState();
        }
    }

    public boolean loadV4E(String filenameRom) {
        this.cartName = filenameRom;
        if (!new File(filenameRom).exists()) {
            return false;
        }
        if (new File(filenameRom).isDirectory()) {
            return false;
        }
        try {
            Path path = Paths.get(filenameRom, new String[0]);
            byte[] data2 = Files.readAllBytes(path);
            this.loadLen = data2.length;
            boolean hasHeader = true;
            if (data2[0] != 86) {
                hasHeader = false;
            }
            if (data2[1] != 52) {
                hasHeader = false;
            }
            if (data2[2] != 69) {
                hasHeader = false;
            }
            if (data2[3] != 66) {
                hasHeader = false;
            }
            if (!hasHeader) {
                hasHeader = true;
                if (data2[0] != 86) {
                    hasHeader = false;
                }
                if (data2[1] != 52) {
                    hasHeader = false;
                }
                if (data2[2] != 69) {
                    hasHeader = false;
                }
                if (data2[3] != 67) {
                    hasHeader = false;
                }
                if (hasHeader) {
                    this.log.addLog("Crypted V4E file found - cannot decrypt - cannot load...", LogPanel.WARN);
                } else {
                    this.log.addLog("No valid header found in V4E file", LogPanel.WARN);
                }
                return false;
            }
            int v4eType = (data2[4] & 0xFF) * 256 + (data2[5] & 0xFF);
            this.log.addLog("V4E cart type: " + v4eType, LogPanel.INFO);
            int v4eBanks = (data2[6] & 0xFF) * 256 + (data2[7] & 0xFF);
            this.log.addLog("    banks    : " + v4eBanks, LogPanel.INFO);
            long crcSeed = 1446266178L;
            long[] bankedCRC = new long[v4eBanks];
            int[] bankedSize = new int[v4eBanks];
            bankedCRC[0] = (data2[8] & 0xFF) * 256 * 256 * 256 + (data2[9] & 0xFF) * 256 * 256 + (data2[10] & 0xFF) * 256 + (data2[11] & 0xFF);
            bankedSize[0] = (data2[12] & 0xFF) * 256 + (data2[13] & 0xFF);
            int index = 14;
            for (int banks = 1; banks < v4eBanks; ++banks) {
                bankedCRC[banks] = (data2[index] & 0xFF) * 256 * 256 * 256 + (data2[index + 1] & 0xFF) * 256 * 256 + (data2[index + 2] & 0xFF) * 256 + (data2[index + 3] & 0xFF);
                bankedSize[banks] = (data2[index + 4] & 0xFF) * 256 + (data2[index + 5] & 0xFF);
                index += 6;
            }
            this.cart = new int[v4eBanks][];
            this.bankLength = new int[v4eBanks];
            this.bankMax = v4eBanks;
            this.bankFileNames = new String[v4eBanks];
            if (this.loadLen == 0) {
                this.log.addLog("Cartridge not loaded, loadLen = 0", LogPanel.WARN);
                return false;
            }
            int length = this.loadLen;
            for (int b = 0; b < this.bankMax; ++b) {
                int zipedSize = bankedSize[b];
                int bankSize = 32768;
                byte[] buffer = new byte[bankSize];
                this.bankFileNames[b] = filenameRom;
                this.cart[b] = new int[bankSize];
                index = this.dunzip(buffer, data2, zipedSize, index);
                this.bankLength[b] = this.lastUnzippedSize;
                for (int i = 0; i < this.lastUnzippedSize; ++i) {
                    this.cart[b][i] = buffer[i] & 0xFF;
                }
            }
            if ((v4eType & 0xFF) == 0) {
                // empty if block
            }
            if ((v4eType & 0xFF) == 1) {
                this.vecx.config.ramAccessAllowed = true;
            }
            if ((v4eType & 0xFF) == 2) {
                this.isVecFeverCartridge = true;
                String to = Global.mainPathPrefix + "tmp" + File.separator + "";
                for (int b = 0; b < this.bankMax; ++b) {
                    if (b != 0) continue;
                    UtilityFiles.writeBinFile(to + b + ".bin", this.cart[b], false);
                }
            }
            if ((v4eType & 0xFF) == 3) {
                this.is2430a = true;
            }
            if ((v4eType & 0xFF) == 4) {
                this.isDS2431 = true;
            }
            if ((v4eType & 0xFF) == 5) {
                this.isMicrochip = true;
            }
            if ((v4eType & 0xFF) == 7 && this.bankMax <= 2) {
                v4eType = 6;
            }
            if ((v4eType & 0xFF) == 7) {
                this.MAX_BANK_SIZE = 49152;
                int[][] cart2 = new int[this.bankMax - 1][this.MAX_BANK_SIZE];
                int[] bankLength2 = new int[this.bankMax - 1];
                String[] bankFileNames2 = new String[this.bankMax - 1];
                for (int b = 1; b < this.bankMax; ++b) {
                    int i;
                    bankLength2[b - 1] = this.MAX_BANK_SIZE;
                    bankFileNames2[b - 1] = filenameRom;
                    int[] ibuffer = cart2[b - 1];
                    for (i = 0; i < 32768; ++i) {
                        ibuffer[i] = i < this.cart[0].length ? this.cart[0][i] : 1;
                    }
                    for (i = 0; i < 16384; ++i) {
                        ibuffer[i + 32768] = i < this.cart[b].length ? this.cart[b][i] : 1;
                    }
                }
                this.cart = cart2;
                this.bankLength = bankLength2;
                this.bankFileNames = bankFileNames2;
                this.rom48KEnabled = true;
                this.v4e_16k_bankswitch = true;
                this.currentBank = 0;
                --this.bankMax;
            }
            if ((v4eType & 0xFF) == 6) {
                int i;
                this.rom48KEnabled = true;
                this.MAX_BANK_SIZE = 49152;
                int[] ibuffer = new int[this.MAX_BANK_SIZE];
                for (i = 0; i < 32768; ++i) {
                    ibuffer[i] = i < this.cart[0].length ? this.cart[0][i] : 1;
                }
                if (this.bankMax > 1) {
                    for (i = 0; i < 16384; ++i) {
                        ibuffer[i + 32768] = i < this.cart[1].length ? this.cart[1][i] : 1;
                    }
                } else {
                    this.MAX_BANK_SIZE = 32768;
                }
                this.cart = new int[1][];
                this.bankMax = 1;
                this.bankLength = new int[1];
                this.bankFileNames = new String[1];
                this.cart[0] = ibuffer;
                this.bankLength[0] = this.MAX_BANK_SIZE;
                this.bankFileNames[0] = filenameRom;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.log.addLog(e, LogPanel.WARN);
            return false;
        }
        if (this.bankMax > 1) {
            this.currentBank = 1;
        }
        return true;
    }

    int dump_backref(int outsize, byte[] window, byte[] dest, int offset, int count) {
        while (count > 0) {
            int from;
            for (from = this.window_pos + offset; from < 0; from += 4096) {
            }
            dest[outsize++] = window[from];
            window[this.window_pos++] = window[from];
            this.window_pos %= 4096;
            --count;
        }
        return outsize;
    }

    int dunzip(byte[] dest, byte[] source, int zipSize, int startPosition) {
        int outsize = 0;
        this.window_pos = 0;
        int dunzipposition = 0;
        byte[] window = new byte[4096];
        this.lastUnzippedSize = 0;
        block0: while (dunzipposition < zipSize) {
            byte a;
            if (((a = source[startPosition + dunzipposition++]) & 0x80) != 0) {
                int count;
                int offset;
                byte b = source[startPosition + dunzipposition++];
                if (dunzipposition > zipSize) {
                    System.out.println("ERROR UNZIP");
                }
                if ((b & 0x80) != 0) {
                    offset = a << 7 | b & 0x7F;
                    offset &= Short.MAX_VALUE;
                    offset = -((offset ^ Short.MAX_VALUE) + 1);
                    count = source[startPosition + dunzipposition++];
                    if (dunzipposition > zipSize) {
                        System.out.println("ERROR UNZIP");
                    }
                    if ((count = 384 - count & 0xFF) == 0) {
                        count = 256;
                    }
                    outsize = this.dump_backref(outsize, window, dest, offset, count);
                    continue;
                }
                offset = -((byte)(a ^ 0xFF) + 1);
                count = 128 - b;
                outsize = this.dump_backref(outsize, window, dest, offset, count);
                continue;
            }
            for (int count = 128 - a; count > 0; --count) {
                byte c = source[startPosition + dunzipposition++];
                if (dunzipposition > zipSize) {
                    System.out.println("ERROR UNZIP");
                    continue block0;
                }
                dest[outsize++] = c;
                window[this.window_pos++] = c;
                this.window_pos %= 4096;
            }
        }
        this.lastUnzippedSize = outsize;
        return dunzipposition + startPosition;
    }

    private static enum VECFLASH {
        RESET,
        LOW_CHECK,
        LOW_PULSE;

    }
}

