/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.cartridge;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.HotKey;
import de.malban.gui.Windowable;
import de.malban.gui.components.CSAView;
import de.malban.gui.dialogs.InternalFrameFileChoser;
import de.malban.util.Utility;
import de.malban.vide.vecx.cartridge.SystemRom;
import de.malban.vide.vecx.cartridge.SystemRomPool;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;

public class SystemRomPanel
extends JPanel
implements Windowable {
    private SystemRom mSystemRom = new SystemRom();
    private SystemRomPool mSystemRomPool;
    private int mClassSetting = 0;
    private CSAView mParent = null;
    private JMenuItem mParentMenuItem = null;
    String lastImagePath = Global.mainPathPrefix + "system" + File.separator;
    private JButton jButtonDelete;
    private JButton jButtonFileSelect3;
    private JButton jButtonNew;
    private JButton jButtonSave;
    private JButton jButtonSaveAsNew;
    private JComboBox jComboBoxKlasse;
    private JComboBox jComboBoxName;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTextField jTextField1;
    private JTextField jTextFieldKlasse;
    private JTextField jTextFieldName;
    private JTextField jTextFieldPath2;
    private JTextPane jTextPane1;

    @Override
    public boolean isIcon() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return false;
        }
        return frame.getInternalFrame(this).isIcon();
    }

    @Override
    public void setIcon(boolean b) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return;
        }
        try {
            frame.getInternalFrame(this).setIcon(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void closing() {
        this.deinit();
    }

    @Override
    public void setParentWindow(CSAView jpv) {
        this.mParent = jpv;
    }

    @Override
    public void setMenuItem(JMenuItem item) {
        this.mParentMenuItem = item;
        this.mParentMenuItem.setText("Config: System BIOS");
    }

    @Override
    public JMenuItem getMenuItem() {
        return this.mParentMenuItem;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    public void deinit() {
    }

    public SystemRomPanel() {
        this.initComponents();
        this.mSystemRomPool = new SystemRomPool();
        this.resetConfigPool(true, "SystemRom");
        this.jLabel4.setVisible(false);
        this.jTextFieldKlasse.setVisible(false);
        this.jComboBoxKlasse.setVisible(false);
        if (Global.getOSName().toUpperCase().contains("MAC")) {
            HotKey.addMacDefaults(this.jTextFieldName);
            HotKey.addMacDefaults(this.jTextFieldPath2);
            HotKey.addMacDefaults(this.jTextField1);
            HotKey.addMacDefaults(this.jTextFieldKlasse);
            HotKey.addMacDefaults(this.jTextPane1);
        }
    }

    private void resetConfigPool(boolean select, String klasseToSet) {
        ++this.mClassSetting;
        Collection<String> collectionKlasse = this.mSystemRomPool.getKlassenHashMap().values();
        Iterator<String> iterKlasse = collectionKlasse.iterator();
        int i = 0;
        String klasse = "SystemRom";
        this.jComboBoxKlasse.removeAllItems();
        while (iterKlasse.hasNext()) {
            String item = iterKlasse.next();
            this.jComboBoxKlasse.addItem(item);
            if (select) {
                if (klasseToSet.length() == 0) {
                    if (i == 0) {
                        this.jComboBoxKlasse.setSelectedIndex(i);
                        this.jTextFieldKlasse.setText(item);
                        klasse = item;
                    }
                } else if (klasseToSet.equalsIgnoreCase(item)) {
                    this.jComboBoxKlasse.setSelectedIndex(i);
                    this.jTextFieldKlasse.setText(item);
                    klasse = item;
                }
            }
            ++i;
        }
        if (select && klasse.length() == 0 && this.jComboBoxKlasse.getItemCount() > 0) {
            this.jComboBoxKlasse.setSelectedIndex(0);
            this.jTextFieldKlasse.setText(this.jComboBoxKlasse.getSelectedItem().toString());
            klasse = this.jComboBoxKlasse.getSelectedItem().toString();
        }
        if (!select) {
            this.jComboBoxKlasse.setSelectedIndex(-1);
        }
        Collection<SystemRom> colC = this.mSystemRomPool.getMapForKlasse(klasse).values();
        Iterator<SystemRom> iterC = colC.iterator();
        this.jComboBoxName.removeAllItems();
        i = 0;
        while (iterC.hasNext()) {
            SystemRom item = iterC.next();
            this.jComboBoxName.addItem(item.mName);
            if (i == 0 && select) {
                this.jComboBoxName.setSelectedIndex(0);
                this.mSystemRom = this.mSystemRomPool.get(item.mName);
                this.setAllFromCurrent();
            }
            ++i;
        }
        if (!select) {
            this.jComboBoxName.setSelectedIndex(-1);
        }
        --this.mClassSetting;
    }

    private void clearAll() {
        ++this.mClassSetting;
        this.mSystemRom = new SystemRom();
        this.setAllFromCurrent();
        --this.mClassSetting;
    }

    private void setAllFromCurrent() {
        ++this.mClassSetting;
        this.jComboBoxKlasse.setSelectedItem("SystemRom");
        this.jTextFieldKlasse.setText("SystemRom");
        this.jComboBoxName.setSelectedItem(this.mSystemRom.mName);
        this.jTextFieldName.setText(this.mSystemRom.mName);
        this.jTextPane1.setText(this.mSystemRom.mComment);
        this.jTextField1.setText(this.mSystemRom.mVersion);
        this.jTextFieldPath2.setText(this.mSystemRom.mCartName);
        --this.mClassSetting;
    }

    private void readAllToCurrent() {
        this.mSystemRom.mClass = "SystemRom";
        this.mSystemRom.mName = this.jTextFieldName.getText();
        this.mSystemRom.mComment = this.jTextPane1.getText();
        this.mSystemRom.mVersion = this.jTextField1.getText();
        this.mSystemRom.mCartName = this.jTextFieldPath2.getText();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jComboBoxName = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jButtonNew = new JButton();
        this.jButtonSave = new JButton();
        this.jButtonSaveAsNew = new JButton();
        this.jButtonDelete = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel10 = new JLabel();
        this.jTextFieldPath2 = new JTextField();
        this.jButtonFileSelect3 = new JButton();
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.jLabel4 = new JLabel();
        this.jTextFieldKlasse = new JTextField();
        this.jComboBoxKlasse = new JComboBox();
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jComboBoxName.setPreferredSize(new Dimension(28, 21));
        this.jComboBoxName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SystemRomPanel.this.jComboBoxNameActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Name");
        this.jTextFieldName.setPreferredSize(new Dimension(28, 21));
        this.jButtonNew.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/new.png")));
        this.jButtonNew.setText("New");
        this.jButtonNew.setPreferredSize(new Dimension(130, 21));
        this.jButtonNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SystemRomPanel.this.jButtonNewActionPerformed(evt);
            }
        });
        this.jButtonSave.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/disk.png")));
        this.jButtonSave.setText("Save");
        this.jButtonSave.setPreferredSize(new Dimension(130, 21));
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SystemRomPanel.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jButtonSaveAsNew.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/disk_add.png")));
        this.jButtonSaveAsNew.setText("Save as new");
        this.jButtonSaveAsNew.setPreferredSize(new Dimension(130, 21));
        this.jButtonSaveAsNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SystemRomPanel.this.jButtonSaveAsNewActionPerformed(evt);
            }
        });
        this.jButtonDelete.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/cross.png")));
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setPreferredSize(new Dimension(130, 21));
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SystemRomPanel.this.jButtonDeleteActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addGap(16, 16, 16).addComponent(this.jTextFieldName, -2, 146, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jComboBoxName, -2, 146, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonSave, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonNew, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonSaveAsNew, -2, -1, -2).addComponent(this.jButtonDelete, -2, -1, -2)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(3, 3, 3).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonNew, -2, -1, -2).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonDelete, -2, -1, -2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jComboBoxName, -2, -1, -2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldName, -2, -1, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonSave, -2, -1, -2).addComponent(this.jButtonSaveAsNew, -2, -1, -2)))).addGap(4, 4, 4)));
        this.jLabel10.setText("File");
        this.jTextFieldPath2.setPreferredSize(new Dimension(6, 21));
        this.jButtonFileSelect3.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/folder_go.png")));
        this.jButtonFileSelect3.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonFileSelect3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SystemRomPanel.this.jButtonFileSelect3ActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Version");
        this.jTextField1.setPreferredSize(new Dimension(6, 21));
        this.jLabel2.setText("Comment");
        this.jScrollPane1.setViewportView(this.jTextPane1);
        this.jLabel4.setText("Class");
        this.jTextFieldKlasse.setText("SystemRom");
        this.jTextFieldKlasse.setPreferredSize(new Dimension(0, 21));
        this.jComboBoxKlasse.setModel(new DefaultComboBoxModel<String>(new String[]{"SystemRom"}));
        this.jComboBoxKlasse.setPreferredSize(new Dimension(0, 21));
        this.jComboBoxKlasse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SystemRomPanel.this.jComboBoxKlasseActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel10).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jTextFieldPath2, -2, 227, -2).addGap(12, 12, 12).addComponent(this.jButtonFileSelect3)).addComponent(this.jTextField1, -2, 67, -2).addComponent(this.jScrollPane1, -2, 259, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel4).addComponent(this.jComboBoxKlasse, 0, -1, Short.MAX_VALUE).addComponent(this.jTextFieldKlasse, -1, 135, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonFileSelect3).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.jTextFieldPath2, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextField1, -2, -1, -2)).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jScrollPane1, -2, 142, -2)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldKlasse, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxKlasse, -2, -1, -2).addGap(50, 50, 50)))));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)));
    }

    private void jButtonNewActionPerformed(ActionEvent evt) {
        ++this.mClassSetting;
        this.mSystemRom = new SystemRom();
        this.clearAll();
        this.resetConfigPool(false, "SystemRom");
        --this.mClassSetting;
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        this.readAllToCurrent();
        this.mSystemRomPool.put(this.mSystemRom);
        this.mSystemRomPool.save();
        ++this.mClassSetting;
        String klasse = this.jTextFieldKlasse.getText();
        this.resetConfigPool(true, klasse);
        this.jComboBoxName.setSelectedItem(this.mSystemRom.mName);
        --this.mClassSetting;
    }

    private void jButtonSaveAsNewActionPerformed(ActionEvent evt) {
        this.mSystemRom = new SystemRom();
        this.readAllToCurrent();
        this.mSystemRomPool.putAsNew(this.mSystemRom);
        this.mSystemRomPool.save();
        ++this.mClassSetting;
        String klasse = this.jTextFieldKlasse.getText();
        this.resetConfigPool(true, klasse);
        this.jComboBoxName.setSelectedItem(this.mSystemRom.mName);
        --this.mClassSetting;
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.readAllToCurrent();
        this.mSystemRomPool.remove(this.mSystemRom);
        this.mSystemRomPool.save();
        ++this.mClassSetting;
        String klasse = this.jTextFieldKlasse.getText();
        this.resetConfigPool(true, klasse);
        if (this.jComboBoxName.getSelectedIndex() == -1) {
            this.clearAll();
        }
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.mSystemRom = this.mSystemRomPool.get(key);
        this.setAllFromCurrent();
        --this.mClassSetting;
    }

    private void jComboBoxKlasseActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        ++this.mClassSetting;
        String selected = this.jComboBoxKlasse.getSelectedItem().toString();
        this.clearAll();
        this.resetConfigPool(true, selected);
        this.jTextFieldKlasse.setText(this.jComboBoxKlasse.getSelectedItem().toString());
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.mSystemRom = this.mSystemRomPool.get(key);
        this.setAllFromCurrent();
        --this.mClassSetting;
    }

    private void jComboBoxNameActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.mSystemRom = this.mSystemRomPool.get(key);
        this.setAllFromCurrent();
    }

    private void jButtonFileSelect3ActionPerformed(ActionEvent evt) {
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        fc.setMultiSelectionEnabled(false);
        if (this.lastImagePath.length() == 0) {
            fc.setCurrentDirectory(new File(Global.mainPathPrefix + "system" + File.separator));
        } else {
            fc.setCurrentDirectory(new File(this.lastImagePath));
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Vectrex roms", "vec", "rom", "bin", "img");
        fc.setFileFilter(filter);
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return;
        }
        File files = fc.getSelectedFile();
        if (files != null) {
            String fullPath;
            this.lastImagePath = fullPath = fc.getSelectedFile().getAbsolutePath();
            this.jTextFieldPath2.setText(Utility.makeVideRelative(fullPath));
        }
    }

    @Override
    public void deIconified() {
    }
}

