/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.cartridge;

import de.malban.Global;
import de.malban.vide.vecx.cartridge.SystemRom;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

public class SystemRomPool {
    public static final String DEFAULT_XML_NAME = new String("SystemRom.xml");
    private String mFileName = DEFAULT_XML_NAME;
    private HashMap<String, SystemRom> mSystemRom = new HashMap();
    private HashMap<String, String> mKlassenMap = new HashMap();

    public SystemRomPool(String name) {
        this.mFileName = name;
        this.init();
    }

    public SystemRomPool() {
        this.init();
    }

    public void setFilename(String n) {
        this.mFileName = n;
    }

    private boolean init() {
        try {
            return this.load();
        }
        catch (Throwable e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Load Error SystemRom...", 1);
            return false;
        }
    }

    public boolean load() {
        File f = new File(Global.mBaseDir + this.mFileName);
        if (!f.exists()) {
            return false;
        }
        this.mSystemRom = SystemRom.getHashMapFromXML(this.mFileName);
        return true;
    }

    public void save() {
        SystemRom.saveCollectionAsXML(this.mFileName, this.mSystemRom.values());
        this.buildKlassenMap();
    }

    public void remove(SystemRom st) {
        this.mSystemRom.remove(st.mName);
    }

    public void put(SystemRom st) {
        this.mSystemRom.remove(st.mName);
        this.mSystemRom.put(st.mName, st);
    }

    public void putAsNew(SystemRom st) {
        this.mSystemRom.put(st.mName, st);
    }

    public SystemRom get(String key) {
        return this.mSystemRom.get(key);
    }

    public HashMap<String, SystemRom> getHashMap() {
        return this.mSystemRom;
    }

    private void buildKlassenMap() {
        this.mKlassenMap = new HashMap();
        Set<Map.Entry<String, SystemRom>> entries = this.mSystemRom.entrySet();
        for (Map.Entry<String, SystemRom> entry : entries) {
            SystemRom value = entry.getValue();
            this.mKlassenMap.put(value.mClass, value.mClass);
        }
    }

    public HashMap<String, String> getKlassenHashMap() {
        this.buildKlassenMap();
        return this.mKlassenMap;
    }

    public HashMap<String, SystemRom> getMapForKlasse(String klasse) {
        HashMap<String, SystemRom> ret = new HashMap<String, SystemRom>();
        Set<Map.Entry<String, SystemRom>> entries = this.mSystemRom.entrySet();
        for (Map.Entry<String, SystemRom> entry : entries) {
            SystemRom value = entry.getValue();
            if (!value.mClass.equalsIgnoreCase(klasse)) continue;
            ret.put(value.mName, value);
        }
        return ret;
    }
}

