/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.cartridge.resid;

import de.malban.vide.vecx.cartridge.resid.ISIDDefs;
import de.malban.vide.vecx.cartridge.resid.PointPlotter;
import de.malban.vide.vecx.cartridge.resid.SID;

public class Filter {
    public static final boolean SPLINE_BRUTE_FORCE = false;
    protected boolean enabled;
    protected int fc = 0;
    protected int res = 0;
    protected int filt = 0;
    protected int voice3off = 0;
    protected int hp_bp_lp = 0;
    protected int vol = 0;
    protected int mixer_DC;
    protected int Vhp = 0;
    protected int Vbp = 0;
    protected int Vlp = 0;
    protected int Vnf = 0;
    int DLthreshold;
    int DLsteepness;
    int DHthreshold;
    int DHsteepness;
    int DLlp;
    int DLbp;
    int DLhp;
    int DHlp;
    int DHbp;
    int DHhp;
    protected int w0;
    protected int w0_ceil_1;
    protected int w0_ceil_dt;
    protected int _1024_div_Q;
    protected int[] f0_6581 = new int[2048];
    protected int[] f0_8580 = new int[2048];
    protected int[] f0;
    protected static int[][] f0_points_6581 = new int[][]{{0, 220}, {0, 220}, {128, 230}, {256, 250}, {384, 300}, {512, 420}, {640, 780}, {768, 1600}, {832, 2300}, {896, 3200}, {960, 4300}, {992, 5000}, {1008, 5400}, {1016, 5700}, {1023, 6000}, {1023, 6000}, {1024, 4600}, {1024, 4600}, {1032, 4800}, {1056, 5300}, {1088, 6000}, {1120, 6600}, {1152, 7200}, {1280, 9500}, {1408, 12000}, {1536, 14500}, {1664, 16000}, {1792, 17100}, {1920, 17700}, {2047, 18000}, {2047, 18000}};
    protected static int[][] f0_points_8580 = new int[][]{{0, 0}, {0, 0}, {128, 800}, {256, 1600}, {384, 2500}, {512, 3300}, {640, 4100}, {768, 4800}, {896, 5600}, {1024, 6500}, {1152, 7500}, {1280, 8400}, {1408, 9200}, {1536, 9800}, {1664, 10500}, {1792, 11000}, {1920, 11700}, {2047, 12500}, {2047, 12500}};
    protected int[][] f0_points;
    protected int f0_count;

    public void clock(int voice1, int voice2, int voice3, int ext_in) {
        voice1 >>= 7;
        voice2 >>= 7;
        voice3 = this.voice3off != 0 && (this.filt & 4) == 0 ? 0 : (voice3 >>= 7);
        ext_in >>= 7;
        if (!this.enabled) {
            this.Vnf = voice1 + voice2 + voice3 + ext_in;
            this.Vlp = 0;
            this.Vbp = 0;
            this.Vhp = 0;
            return;
        }
        this.Vnf = 0;
        int Vi = 0;
        if (SID.ANTTI_LANKILA_PATCH) {
            if ((this.filt & 1) != 0) {
                Vi += voice1;
            } else {
                this.Vnf += voice1;
            }
            if ((this.filt & 2) != 0) {
                Vi += voice2;
            } else {
                this.Vnf += voice2;
            }
            if ((this.filt & 4) != 0) {
                Vi += voice3;
            } else {
                this.Vnf += voice3;
            }
            if ((this.filt & 8) != 0) {
                Vi += ext_in;
            } else {
                this.Vnf += ext_in;
            }
        } else {
            switch (this.filt) {
                default: {
                    Vi = 0;
                    this.Vnf = voice1 + voice2 + voice3 + ext_in;
                    break;
                }
                case 1: {
                    Vi = voice1;
                    this.Vnf = voice2 + voice3 + ext_in;
                    break;
                }
                case 2: {
                    Vi = voice2;
                    this.Vnf = voice1 + voice3 + ext_in;
                    break;
                }
                case 3: {
                    Vi = voice1 + voice2;
                    this.Vnf = voice3 + ext_in;
                    break;
                }
                case 4: {
                    Vi = voice3;
                    this.Vnf = voice1 + voice2 + ext_in;
                    break;
                }
                case 5: {
                    Vi = voice1 + voice3;
                    this.Vnf = voice2 + ext_in;
                    break;
                }
                case 6: {
                    Vi = voice2 + voice3;
                    this.Vnf = voice1 + ext_in;
                    break;
                }
                case 7: {
                    Vi = voice1 + voice2 + voice3;
                    this.Vnf = ext_in;
                    break;
                }
                case 8: {
                    Vi = ext_in;
                    this.Vnf = voice1 + voice2 + voice3;
                    break;
                }
                case 9: {
                    Vi = voice1 + ext_in;
                    this.Vnf = voice2 + voice3;
                    break;
                }
                case 10: {
                    Vi = voice2 + ext_in;
                    this.Vnf = voice1 + voice3;
                    break;
                }
                case 11: {
                    Vi = voice1 + voice2 + ext_in;
                    this.Vnf = voice3;
                    break;
                }
                case 12: {
                    Vi = voice3 + ext_in;
                    this.Vnf = voice1 + voice2;
                    break;
                }
                case 13: {
                    Vi = voice1 + voice3 + ext_in;
                    this.Vnf = voice2;
                    break;
                }
                case 14: {
                    Vi = voice2 + voice3 + ext_in;
                    this.Vnf = voice1;
                    break;
                }
                case 15: {
                    Vi = voice1 + voice2 + voice3 + ext_in;
                    this.Vnf = 0;
                }
            }
        }
        if (SID.ANTTI_LANKILA_PATCH) {
            int Vi_peak_lp;
            int Vi_peak_bp = (this.Vlp * this.DHlp + this.Vbp * this.DHbp + this.Vhp * this.DHhp >> 8) + Vi;
            if (Vi_peak_bp < this.DHthreshold) {
                Vi_peak_bp = this.DHthreshold;
            }
            if ((Vi_peak_lp = (this.Vlp * this.DLlp + this.Vbp * this.DLbp + this.Vhp * this.DLhp >> 8) + Vi) < this.DLthreshold) {
                Vi_peak_lp = this.DLthreshold;
            }
            int w0_eff_bp = this.w0 + this.w0 * (Vi_peak_bp - this.DHthreshold >> 4) / this.DHsteepness;
            int w0_eff_lp = this.w0 + this.w0 * (Vi_peak_lp - this.DLthreshold >> 4) / this.DLsteepness;
            if (w0_eff_bp > this.w0_ceil_1) {
                w0_eff_bp = this.w0_ceil_1;
            }
            if (w0_eff_lp > this.w0_ceil_1) {
                w0_eff_lp = this.w0_ceil_1;
            }
            this.Vhp = (this.Vbp * this._1024_div_Q >> 10) - this.Vlp - Vi;
            this.Vlp -= w0_eff_lp * this.Vbp >> 20;
            this.Vbp -= w0_eff_bp * this.Vhp >> 20;
        } else {
            int dVbp = this.w0_ceil_1 * this.Vhp >> 20;
            int dVlp = this.w0_ceil_1 * this.Vbp >> 20;
            this.Vbp -= dVbp;
            this.Vlp -= dVlp;
            this.Vhp = (this.Vbp * this._1024_div_Q >> 10) - this.Vlp - Vi;
        }
    }

    public void clock(int delta_t, int voice1, int voice2, int voice3, int ext_in) {
        voice1 >>= 7;
        voice2 >>= 7;
        voice3 = this.voice3off != 0 && (this.filt & 4) == 0 ? 0 : (voice3 >>= 7);
        ext_in >>= 7;
        if (!this.enabled) {
            this.Vnf = voice1 + voice2 + voice3 + ext_in;
            this.Vlp = 0;
            this.Vbp = 0;
            this.Vhp = 0;
            return;
        }
        this.Vnf = 0;
        int Vi = 0;
        if (!SID.ANTTI_LANKILA_PATCH) {
            switch (this.filt) {
                default: {
                    Vi = 0;
                    this.Vnf = voice1 + voice2 + voice3 + ext_in;
                    break;
                }
                case 1: {
                    Vi = voice1;
                    this.Vnf = voice2 + voice3 + ext_in;
                    break;
                }
                case 2: {
                    Vi = voice2;
                    this.Vnf = voice1 + voice3 + ext_in;
                    break;
                }
                case 3: {
                    Vi = voice1 + voice2;
                    this.Vnf = voice3 + ext_in;
                    break;
                }
                case 4: {
                    Vi = voice3;
                    this.Vnf = voice1 + voice2 + ext_in;
                    break;
                }
                case 5: {
                    Vi = voice1 + voice3;
                    this.Vnf = voice2 + ext_in;
                    break;
                }
                case 6: {
                    Vi = voice2 + voice3;
                    this.Vnf = voice1 + ext_in;
                    break;
                }
                case 7: {
                    Vi = voice1 + voice2 + voice3;
                    this.Vnf = ext_in;
                    break;
                }
                case 8: {
                    Vi = ext_in;
                    this.Vnf = voice1 + voice2 + voice3;
                    break;
                }
                case 9: {
                    Vi = voice1 + ext_in;
                    this.Vnf = voice2 + voice3;
                    break;
                }
                case 10: {
                    Vi = voice2 + ext_in;
                    this.Vnf = voice1 + voice3;
                    break;
                }
                case 11: {
                    Vi = voice1 + voice2 + ext_in;
                    this.Vnf = voice3;
                    break;
                }
                case 12: {
                    Vi = voice3 + ext_in;
                    this.Vnf = voice1 + voice2;
                    break;
                }
                case 13: {
                    Vi = voice1 + voice3 + ext_in;
                    this.Vnf = voice2;
                    break;
                }
                case 14: {
                    Vi = voice2 + voice3 + ext_in;
                    this.Vnf = voice1;
                    break;
                }
                case 15: {
                    Vi = voice1 + voice2 + voice3 + ext_in;
                    this.Vnf = 0;
                    break;
                }
            }
        } else {
            if ((this.filt & 1) != 0) {
                Vi += voice1;
            } else {
                this.Vnf += voice1;
            }
            if ((this.filt & 2) != 0) {
                Vi += voice2;
            } else {
                this.Vnf += voice2;
            }
            if ((this.filt & 4) != 0) {
                Vi += voice3;
            } else {
                this.Vnf += voice3;
            }
            if ((this.filt & 8) != 0) {
                Vi += ext_in;
            } else {
                this.Vnf += ext_in;
            }
        }
        int delta_t_flt = 8;
        while (delta_t != 0) {
            if (delta_t < delta_t_flt) {
                delta_t_flt = delta_t;
            }
            int w0_delta_t = this.w0_ceil_dt * delta_t_flt >> 6;
            int dVbp = w0_delta_t * this.Vhp >> 14;
            int dVlp = w0_delta_t * this.Vbp >> 14;
            this.Vbp -= dVbp;
            this.Vlp -= dVlp;
            this.Vhp = (this.Vbp * this._1024_div_Q >> 10) - this.Vlp - Vi;
            delta_t -= delta_t_flt;
        }
    }

    public int output() {
        if (!this.enabled) {
            return (this.Vnf + this.mixer_DC) * this.vol;
        }
        if (!SID.ANTTI_LANKILA_PATCH) {
            int Vf;
            switch (this.hp_bp_lp) {
                default: {
                    Vf = 0;
                    break;
                }
                case 1: {
                    Vf = this.Vlp;
                    break;
                }
                case 2: {
                    Vf = this.Vbp;
                    break;
                }
                case 3: {
                    Vf = this.Vlp + this.Vbp;
                    break;
                }
                case 4: {
                    Vf = this.Vhp;
                    break;
                }
                case 5: {
                    Vf = this.Vlp + this.Vhp;
                    break;
                }
                case 6: {
                    Vf = this.Vbp + this.Vhp;
                    break;
                }
                case 7: {
                    Vf = this.Vlp + this.Vbp + this.Vhp;
                }
            }
            return (this.Vnf + Vf + this.mixer_DC) * this.vol;
        }
        int Vf = 0;
        if ((this.hp_bp_lp & 1) != 0) {
            Vf += this.Vlp;
        }
        if ((this.hp_bp_lp & 2) != 0) {
            Vf += this.Vbp;
        }
        if ((this.hp_bp_lp & 4) != 0) {
            Vf += this.Vhp;
        }
        return (this.Vnf + Vf + this.mixer_DC) * this.vol;
    }

    public Filter() {
        this.enable_filter(true);
        this.interpolate(f0_points_6581, 0, f0_points_6581.length - 1, new PointPlotter(this.f0_6581), 1.0);
        this.interpolate(f0_points_8580, 0, f0_points_8580.length - 1, new PointPlotter(this.f0_8580), 1.0);
        this.set_chip_model(ISIDDefs.chip_model.MOS6581);
        this.set_distortion_properties(999999, 999999, 0, 0, 0, 999999, 999999, 0, 0, 0);
    }

    public void enable_filter(boolean enable) {
        this.enabled = enable;
    }

    public void set_chip_model(ISIDDefs.chip_model model) {
        if (model == ISIDDefs.chip_model.MOS6581) {
            this.mixer_DC = -454;
            this.f0 = this.f0_6581;
            this.f0_points = f0_points_6581;
            this.f0_count = f0_points_6581.length;
        } else {
            this.mixer_DC = 0;
            this.f0 = this.f0_8580;
            this.f0_points = f0_points_8580;
            this.f0_count = f0_points_8580.length;
        }
        this.set_w0();
        this.set_Q();
    }

    void set_distortion_properties(int Lthreshold, int Lsteepness, int Llp, int Lbp, int Lhp, int Hthreshold, int Hsteepness, int Hlp, int Hbp, int Hhp) {
        this.DLthreshold = Lthreshold;
        if (Lsteepness < 16) {
            Lsteepness = 16;
        }
        this.DLsteepness = Lsteepness >> 4;
        this.DLlp = Llp;
        this.DLbp = Lbp;
        this.DLhp = Lhp;
        this.DHthreshold = Hthreshold;
        if (Hsteepness < 16) {
            Hsteepness = 16;
        }
        this.DHsteepness = Hsteepness >> 4;
        this.DHlp = Hlp;
        this.DHbp = Hbp;
        this.DHhp = Hhp;
    }

    public void reset() {
        this.fc = 0;
        this.res = 0;
        this.filt = 0;
        this.voice3off = 0;
        this.hp_bp_lp = 0;
        this.vol = 0;
        this.Vhp = 0;
        this.Vbp = 0;
        this.Vlp = 0;
        this.Vnf = 0;
        this.set_w0();
        this.set_Q();
    }

    public void writeFC_LO(int fc_lo) {
        this.fc = this.fc & 0x7F8 | fc_lo & 7;
        this.set_w0();
    }

    public void writeFC_HI(int fc_hi) {
        this.fc = fc_hi << 3 & 0x7F8 | this.fc & 7;
        this.set_w0();
    }

    public void writeRES_FILT(int res_filt) {
        this.res = res_filt >> 4 & 0xF;
        this.set_Q();
        this.filt = res_filt & 0xF;
    }

    public void writeMODE_VOL(int mode_vol) {
        this.voice3off = mode_vol & 0x80;
        this.hp_bp_lp = mode_vol >> 4 & 7;
        this.vol = mode_vol & 0xF;
    }

    protected void set_w0() {
        double pi = Math.PI;
        this.w0 = (int)(Math.PI * 2 * (double)this.f0[this.fc] * 1.048576);
        if (SID.ANTTI_LANKILA_PATCH) {
            this.w0_ceil_1 = 118591;
        } else {
            int w0_max_1 = 105414;
            this.w0_ceil_1 = this.w0 <= 105414 ? this.w0 : 105414;
        }
        int w0_max_dt = 26353;
        this.w0_ceil_dt = this.w0 <= 26353 ? this.w0 : 26353;
    }

    protected void set_Q() {
        this._1024_div_Q = (int)(1024.0 / (0.707 + 1.0 * (double)this.res / 15.0));
    }

    public void fc_default(SID.FCPoints fcp) {
        fcp.points = this.f0_points;
        fcp.count = this.f0_count;
    }

    public PointPlotter fc_plotter() {
        return new PointPlotter(this.f0);
    }

    protected void cubic_coefficients(double x1, double y1, double x2, double y2, double k1, double k2, Coefficients coeff) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        coeff.a = (k1 + k2 - 2.0 * dy / dx) / (dx * dx);
        coeff.b = ((k2 - k1) / dx - 3.0 * (x1 + x2) * coeff.a) / 2.0;
        coeff.c = k1 - (3.0 * x1 * coeff.a + 2.0 * coeff.b) * x1;
        coeff.d = y1 - ((x1 * coeff.a + coeff.b) * x1 + coeff.c) * x1;
    }

    protected void interpolate_brute_force(double x1, double y1, double x2, double y2, double k1, double k2, PointPlotter plotter, double res) {
        Coefficients coeff = new Coefficients();
        this.cubic_coefficients(x1, y1, x2, y2, k1, k2, coeff);
        for (double x = x1; x <= x2; x += res) {
            double y = ((coeff.a * x + coeff.b) * x + coeff.c) * x + coeff.d;
            plotter.plot(x, y);
        }
    }

    protected void interpolate_forward_difference(double x1, double y1, double x2, double y2, double k1, double k2, PointPlotter plotter, double res) {
        Coefficients coeff = new Coefficients();
        this.cubic_coefficients(x1, y1, x2, y2, k1, k2, coeff);
        double y = ((coeff.a * x1 + coeff.b) * x1 + coeff.c) * x1 + coeff.d;
        double dy = (3.0 * coeff.a * (x1 + res) + 2.0 * coeff.b) * x1 * res + ((coeff.a * res + coeff.b) * res + coeff.c) * res;
        double d2y = (6.0 * coeff.a * (x1 + res) + 2.0 * coeff.b) * res * res;
        double d3y = 6.0 * coeff.a * res * res * res;
        for (double x = x1; x <= x2; x += res) {
            plotter.plot(x, y);
            y += dy;
            dy += d2y;
            d2y += d3y;
        }
    }

    protected double x(int[][] f0_base, int p) {
        return f0_base[p][0];
    }

    protected double y(int[][] f0_base, int p) {
        return f0_base[p][1];
    }

    public void interpolate(int[][] f0_base, int p0, int pn, PointPlotter plotter, double res) {
        int p1 = p0;
        int p2 = ++p1;
        int p3 = ++p2;
        ++p3;
        while (p2 != pn) {
            if (this.x(f0_base, p1) != this.x(f0_base, p2)) {
                double k1;
                double k2;
                if (this.x(f0_base, p0) == this.x(f0_base, p1) && this.x(f0_base, p2) == this.x(f0_base, p3)) {
                    k1 = k2 = (this.y(f0_base, p2) - this.y(f0_base, p1)) / (this.x(f0_base, p2) - this.x(f0_base, p1));
                } else if (this.x(f0_base, p0) == this.x(f0_base, p1)) {
                    k2 = (this.y(f0_base, p3) - this.y(f0_base, p1)) / (this.x(f0_base, p3) - this.x(f0_base, p1));
                    k1 = (3.0 * (this.y(f0_base, p2) - this.y(f0_base, p1)) / (this.x(f0_base, p2) - this.x(f0_base, p1)) - k2) / 2.0;
                } else if (this.x(f0_base, p2) == this.x(f0_base, p3)) {
                    k1 = (this.y(f0_base, p2) - this.y(f0_base, p0)) / (this.x(f0_base, p2) - this.x(f0_base, p0));
                    k2 = (3.0 * (this.y(f0_base, p2) - this.y(f0_base, p1)) / (this.x(f0_base, p2) - this.x(f0_base, p1)) - k1) / 2.0;
                } else {
                    k1 = (this.y(f0_base, p2) - this.y(f0_base, p0)) / (this.x(f0_base, p2) - this.x(f0_base, p0));
                    k2 = (this.y(f0_base, p3) - this.y(f0_base, p1)) / (this.x(f0_base, p3) - this.x(f0_base, p1));
                }
                this.interpolate_forward_difference(this.x(f0_base, p1), this.y(f0_base, p1), this.x(f0_base, p2), this.y(f0_base, p2), k1, k2, plotter, res);
            }
            ++p0;
            ++p1;
            ++p2;
            ++p3;
        }
    }

    public class Coefficients {
        public double a;
        public double b;
        public double c;
        public double d;
    }
}

