/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.devices;

import de.malban.util.UtilityImage;
import de.malban.vide.vecx.devices.Imager3dDevice;
import de.malban.vide.vecx.devices.WheelData;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.GroupLayout;
import javax.swing.JPanel;

public class ImagerWheel
extends JPanel {
    Point center = new Point();
    int outerRadius = 0;
    int innerRadius = 0;
    public static WheelData NARROW_ESCAPE = WheelData.createNewWheel();
    WheelData currentWheel = NARROW_ESCAPE;
    double one_millimenter = 0.0;
    BufferedImage zeroAngleImage1 = null;
    BufferedImage zeroAngleImage2 = null;
    double currentAngle = 0.0;
    public static double WHEEL_WIDTH = 99.0;
    public static double CENTER_WIDTH = 39.0;
    public static double EYE_WIDTH = 24.0;
    public static double EYE_HEIGHT = 8.0;
    public static double EYE_DISTANCE = 44.0;
    public static double INDEX_WIDTH = 3.3274;
    public static double INDEX_FROM_CENTER = 16.0;

    public ImagerWheel() {
        this.initComponents();
    }

    private void initComponents() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                ImagerWheel.this.formComponentResized(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    private void formComponentResized(ComponentEvent evt) {
        int w = this.getWidth();
        int h = this.getHeight();
        this.center = new Point(w / 2, h / 2);
        this.outerRadius = w < h ? w : h;
        this.outerRadius -= 8;
        this.one_millimenter = this.outerRadius;
        this.outerRadius /= 2;
        this.one_millimenter /= WHEEL_WIDTH;
        this.innerRadius = this.scale(CENTER_WIDTH / 2.0);
        this.createCurrentWheel();
        this.repaint();
    }

    public void repaintWheel() {
        this.formComponentResized(null);
    }

    int scale(double valueInMilimeter) {
        return (int)(this.one_millimenter * valueInMilimeter);
    }

    void createCurrentWheel() {
        if (this.outerRadius == 0) {
            this.zeroAngleImage1 = null;
            return;
        }
        this.zeroAngleImage1 = UtilityImage.getNewImage(this.outerRadius * 2, this.outerRadius * 2);
        this.zeroAngleImage2 = UtilityImage.getNewImage(this.outerRadius * 2, this.outerRadius * 2);
        if (this.zeroAngleImage1 == null) {
            return;
        }
        Graphics2D g2 = this.zeroAngleImage1.createGraphics();
        g2.setBackground(new Color(0, 0, 0, 0));
        g2.clearRect(0, 0, this.outerRadius * 2, this.outerRadius * 2);
        int mod = this.currentWheel.startAngle.length;
        for (int i = 0; i < this.currentWheel.startAngle.length; ++i) {
            g2.setColor(this.currentWheel.colors[i]);
            int startAngle = (int)this.currentWheel.startAngle[i];
            int angleWidth = i + 1 >= this.currentWheel.startAngle.length ? (int)(this.currentWheel.startAngle[(i + 1) % mod] + 360.0 - this.currentWheel.startAngle[i]) : (int)(this.currentWheel.startAngle[i + 1] - this.currentWheel.startAngle[i]);
            g2.fillArc(0, 0, this.outerRadius * 2, this.outerRadius * 2, -(startAngle += 90), -angleWidth);
        }
        g2 = this.zeroAngleImage2.createGraphics();
        g2.setBackground(new Color(0, 0, 0, 0));
        g2.clearRect(0, 0, this.outerRadius * 2, this.outerRadius * 2);
        g2.setColor(new Color(0, 0, 0, 255));
        g2.rotate(Math.toRadians(this.currentWheel.indexAngle - 3.0), this.outerRadius, this.outerRadius);
        g2.fillOval(this.outerRadius - this.scale(INDEX_WIDTH / 2.0), this.outerRadius + this.scale(INDEX_FROM_CENTER), this.scale(INDEX_WIDTH), this.scale(INDEX_WIDTH));
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform old = g2.getTransform();
        g2.rotate(Math.toRadians(this.currentAngle), this.center.x, this.center.y);
        g2.drawImage((Image)this.zeroAngleImage1, this.center.x - this.outerRadius, this.center.y - this.outerRadius, null);
        g2.setTransform(old);
        g2.setStroke(new BasicStroke(2.0f));
        g2.setColor(new Color(255, 255, 255, 255));
        g2.drawOval(this.center.x - this.outerRadius, this.center.y - this.outerRadius, this.outerRadius * 2, this.outerRadius * 2);
        g2.setColor(new Color(255, 255, 255, 255));
        g2.fillOval(this.center.x - this.innerRadius, this.center.y - this.innerRadius, this.innerRadius * 2, this.innerRadius * 2);
        g2.setStroke(new BasicStroke(1.0f));
        g2.setColor(new Color(255, 255, 255, 100));
        g2.drawLine(this.center.x, this.center.y, this.center.x, this.center.y + this.outerRadius);
        g2.fillRoundRect(this.center.x - this.scale(EYE_DISTANCE / 2.0) - this.scale(EYE_WIDTH), this.center.y - this.scale(EYE_HEIGHT / 2.0), this.scale(EYE_WIDTH), this.scale(EYE_HEIGHT), this.scale(EYE_HEIGHT), this.scale(EYE_HEIGHT));
        g2.fillRoundRect(this.center.x + this.scale(EYE_DISTANCE / 2.0), this.center.y - this.scale(EYE_HEIGHT / 2.0), this.scale(EYE_WIDTH), this.scale(EYE_HEIGHT), this.scale(EYE_HEIGHT), this.scale(EYE_HEIGHT));
        g2.rotate(Math.toRadians(this.currentAngle), this.center.x, this.center.y);
        g2.drawImage((Image)this.zeroAngleImage2, this.center.x - this.outerRadius, this.center.y - this.outerRadius, null);
        g2.setTransform(old);
        g2.setColor(new Color(255, 0, 0, 200));
        g2.rotate(Math.toRadians(Imager3dDevice.photoReceiverAngleStart - 3.0), this.center.x, this.center.y);
        g2.fillOval(this.center.x - this.scale(INDEX_WIDTH / 2.0), this.center.y + this.scale(INDEX_FROM_CENTER), this.scale(INDEX_WIDTH), this.scale(INDEX_WIDTH));
        g2.setTransform(old);
    }

    public void setWheel(WheelData wheel) {
        this.currentWheel = wheel;
        this.formComponentResized(null);
        this.repaint();
    }

    public void setAngle(double a) {
        this.currentAngle = a;
        this.repaint();
    }
}

