/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.devices;

import de.malban.input.ControllerEvent;
import de.malban.input.ControllerListern;
import de.malban.input.EventController;
import de.malban.input.SystemController;
import de.malban.vide.ControllerConfig;
import de.malban.vide.VideConfig;
import de.malban.vide.vecx.VecX;
import de.malban.vide.vecx.VecXPanel;
import de.malban.vide.vecx.devices.AbstractDevice;
import de.malban.vide.vecx.devices.VectrexJoyport;
import net.java.games.input.Controller;

public class JInputSpinnerDevice
extends AbstractDevice
implements ControllerListern {
    public String usedInputID = "JInputSpinnerDevice";
    ControllerConfig cConfig = null;
    EventController eController = null;
    public static final int NONE = 0;
    public static final int RIGHT = 1;
    public static final int LEFT = 2;
    int moveDirection = 0;
    double speedFactor = 0.0;
    int currentCount = 0;
    int[] pinMoveLeft = new int[]{1, 3, 0, 2};
    int[] pinMoveRight = new int[]{2, 0, 3, 1};
    int out = 0;
    long lastCycles = 0L;
    static double FACTOR = 2.54;

    @Override
    public int getDeviceID() {
        return VecXPanel.DEVICE_JINPUT_SPINNER;
    }

    @Override
    public String getDeviceName() {
        if (this.cConfig == null) {
            return "n/a";
        }
        return this.cConfig.name;
    }

    @Override
    public String toString() {
        if (this.cConfig == null) {
            return "JInputSpinnerDevice";
        }
        return this.cConfig.toString();
    }

    @Override
    public void deinit() {
        super.deinit();
        if (this.eController != null) {
            this.eController.setActive(false);
            this.eController = null;
        }
    }

    @Override
    public void setJoyport(VectrexJoyport j) {
        if (this.eController != null) {
            this.eController.setActive(false);
            this.eController = null;
        }
        super.setJoyport(j);
        Controller controller = SystemController.getController(this.cConfig.JInputId);
        if (controller == null) {
            this.deinit();
        }
        this.eController = new EventController(controller);
        this.eController.addEventListerner(this);
        this.currentCount = VideConfig.getConfig().minimumSpinnerChangeCycles;
        this.out = 0;
        this.eController.setActive(true);
    }

    @Override
    public void step() {
        if (this.joyport == null) {
            return;
        }
        VecX vectrex = this.joyport.vecx;
        long c = vectrex.getCycles();
        int dif = (int)(c - this.lastCycles);
        this.lastCycles = c;
        this.currentCount -= dif;
        if (this.currentCount <= 0) {
            this.currentCount = (int)((double)VideConfig.getConfig().minimumSpinnerChangeCycles * this.speedFactor);
            if (this.moveDirection == 0) {
                // empty if block
            }
            if (this.moveDirection == 1) {
                this.out = this.pinMoveRight[this.out];
            }
            if (this.moveDirection == 2) {
                this.out = this.pinMoveLeft[this.out];
            }
            if (this.joyportIsInInputMode) {
                this.joyport.setButton1((this.out & 1) != 1, true);
                this.joyport.setButton2((this.out & 2) != 2, true);
            }
        }
    }

    public static JInputSpinnerDevice getDevice(ControllerConfig c) {
        JInputSpinnerDevice device = new JInputSpinnerDevice();
        device.cConfig = c;
        c.initEventMapping();
        return device;
    }

    @Override
    public void controllerEvent(ControllerEvent e) {
        String evenId = e.componentId;
        String vectrexTarget = this.cConfig.eventMapping.get(evenId);
        if (vectrexTarget == null) {
            return;
        }
        if (vectrexTarget.equals("3")) {
            this.joyport.setButton3(!e.currentButtonState, true);
        }
        if (vectrexTarget.equals("4")) {
            this.joyport.setButton4(!e.currentButtonState, true);
        }
        if (vectrexTarget.equals("horizontal")) {
            if (e.type == 4) {
                int v = e.currentAxisPercent - 50;
                int v2 = Math.abs(v);
                if (v2 > 25) {
                    this.speedFactor = 1.0;
                } else if (v2 > 12) {
                    this.speedFactor = 2.0;
                } else if (v2 > 6) {
                    this.speedFactor = 4.0;
                } else if (v2 > 3) {
                    this.speedFactor = 8.0;
                } else if (v2 > 1) {
                    this.speedFactor = 10.0;
                }
                if (v < 0) {
                    this.moveDirection = 2;
                } else if (v > 0) {
                    this.moveDirection = 1;
                } else {
                    this.moveDirection = 0;
                    this.speedFactor = 1.0;
                }
            } else if (e.type == 5) {
                float v = e.currentRelative;
                int v2 = (int)Math.abs(v);
                if (v2 > this.cConfig.compareValue >> 1) {
                    this.speedFactor = 1.0;
                } else if (v2 > this.cConfig.compareValue >> 2) {
                    this.speedFactor = 2.0;
                } else if (v2 > this.cConfig.compareValue >> 3) {
                    this.speedFactor = 4.0;
                } else if (v2 > this.cConfig.compareValue >> 4) {
                    this.speedFactor = 8.0;
                } else if (v2 > this.cConfig.compareValue >> 5) {
                    this.speedFactor = 10.0;
                }
                if (v < 0.0f) {
                    this.moveDirection = 2;
                } else if (v > 0.0f) {
                    this.moveDirection = 1;
                } else {
                    this.moveDirection = 0;
                    this.speedFactor = 1.0;
                }
            } else if (e.type == 3) {
                if (e.currentButtonState) {
                    this.speedFactor = 1.0;
                    this.moveDirection = 1;
                } else {
                    this.moveDirection = 0;
                    this.speedFactor = 1.0;
                }
            }
        }
        if (vectrexTarget.equals("vertical") && e.type == 3) {
            if (e.currentButtonState) {
                this.speedFactor = 1.0;
                this.moveDirection = 2;
            } else {
                this.moveDirection = 0;
                this.speedFactor = 1.0;
            }
        }
    }
}

