/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.panels;

import de.malban.gui.dialogs.InternalColorChooserDialog;
import de.malban.vide.vecx.devices.Imager3dDevice;
import de.malban.vide.vecx.devices.WheelData;
import de.malban.vide.vecx.panels.WheelEdit;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class OneWheelColorPanel
extends JPanel {
    int colorNo = -1;
    WheelData wheel = null;
    WheelEdit editor = null;
    private int mClassSetting = 0;
    private JButton jButtonColor;
    private JButton jButtonColor1;
    private JLabel jLabel52;
    private JLabel jLabelLeft;
    private JLabel jLabelRight;
    private JSlider jSlider4;
    private JTextField jTextField47;

    public OneWheelColorPanel(WheelData w, int c, WheelEdit e) {
        ++this.mClassSetting;
        this.wheel = w;
        this.colorNo = c;
        this.editor = e;
        this.initComponents();
        this.update();
        --this.mClassSetting;
    }

    public void update() {
        ++this.mClassSetting;
        int min = (int)this.wheel.startAngle[this.colorNo - 1];
        if (this.colorNo == 1) {
            this.wheel.startAngle[this.colorNo] = 180.0;
            min = 180;
        }
        this.jSlider4.setMinimum((int)this.wheel.startAngle[this.colorNo - 1]);
        this.jSlider4.setValue((int)this.wheel.startAngle[this.colorNo]);
        this.jTextField47.setText("" + (int)this.wheel.startAngle[this.colorNo]);
        this.jTextField47.setBackground(this.wheel.colors[this.colorNo]);
        this.jSlider4.setEnabled(this.colorNo != 1);
        double right = this.wheel.startAngle[this.colorNo] + 90.0;
        double left = this.wheel.startAngle[this.colorNo] + 90.0 + 180.0;
        OneWheelColorPanel.setCycle(right, this.jLabelRight, this.wheel);
        OneWheelColorPanel.setCycle(left, this.jLabelLeft, this.wheel);
        --this.mClassSetting;
    }

    public static void setCycle(double angle, JLabel label, WheelData wheel) {
        double angleOffset = (Imager3dDevice.indexAngleWidth + Imager3dDevice.photoReceiverAngleStart + (360.0 - wheel.indexAngle)) % 360.0;
        angle += angleOffset;
        double anglePerCycle = 360.0 / (1500000.0 / wheel.defaultFrequency);
        double cycles = (angle %= 360.0) / anglePerCycle;
        label.setText("0x" + String.format("%04X", (int)cycles));
    }

    private void initComponents() {
        this.jLabel52 = new JLabel();
        this.jTextField47 = new JTextField();
        this.jSlider4 = new JSlider();
        this.jButtonColor = new JButton();
        this.jButtonColor1 = new JButton();
        this.jLabelRight = new JLabel();
        this.jLabelLeft = new JLabel();
        this.jLabel52.setText("angle");
        this.jSlider4.setMajorTickSpacing(10);
        this.jSlider4.setMaximum(360);
        this.jSlider4.setMinimum(180);
        this.jSlider4.setMinorTickSpacing(1);
        this.jSlider4.setOrientation(1);
        this.jSlider4.setPaintTicks(true);
        this.jSlider4.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                OneWheelColorPanel.this.jSlider4StateChanged(evt);
            }
        });
        this.jButtonColor.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/color_swatch.png")));
        this.jButtonColor.setToolTipText("choose color");
        this.jButtonColor.setMargin(new Insets(0, 0, 0, -1));
        this.jButtonColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OneWheelColorPanel.this.jButtonColorActionPerformed(evt);
            }
        });
        this.jButtonColor1.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/delete.png")));
        this.jButtonColor1.setToolTipText("delete color");
        this.jButtonColor1.setMargin(new Insets(0, 0, 0, -1));
        this.jButtonColor1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OneWheelColorPanel.this.jButtonColor1ActionPerformed(evt);
            }
        });
        this.jLabelRight.setText("0x0000");
        this.jLabelRight.setToolTipText("start at cycles [relation to index whole]");
        this.jLabelLeft.setText("0x0000");
        this.jLabelLeft.setToolTipText("start at cycles [relation to index whole]");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel52).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jSlider4, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jTextField47, GroupLayout.Alignment.LEADING, -2, 45, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jButtonColor, -2, 18, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonColor1, -2, 18, -2)).addComponent(this.jLabelRight).addComponent(this.jLabelLeft)).addGap(2, 2, 2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel52).addGap(4, 4, 4).addComponent(this.jTextField47, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider4, -2, 138, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonColor, GroupLayout.Alignment.TRAILING, -2, 18, -2).addComponent(this.jButtonColor1, GroupLayout.Alignment.TRAILING, -2, 18, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabelRight).addGap(4, 4, 4).addComponent(this.jLabelLeft).addGap(2, 2, 2)));
    }

    private void jSlider4StateChanged(ChangeEvent evt) {
        if (this.wheel == null) {
            return;
        }
        if (this.mClassSetting > 1) {
            return;
        }
        this.wheel.startAngle[this.colorNo] = this.jSlider4.getValue();
        this.jTextField47.setText("" + (int)this.wheel.startAngle[this.colorNo]);
        this.editor.colorChanged(this.colorNo);
    }

    private void jButtonColorActionPerformed(ActionEvent evt) {
        Color c = InternalColorChooserDialog.showDialog("Color");
        if (c == null) {
            return;
        }
        this.wheel.colors[this.colorNo] = c;
        this.jTextField47.setBackground(this.wheel.colors[this.colorNo]);
        this.editor.colorChanged(this.colorNo);
    }

    private void jButtonColor1ActionPerformed(ActionEvent evt) {
        this.editor.removeSection(this.colorNo);
    }
}

