/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.panels;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.config.TinyLogInterface;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.Windowable;
import de.malban.gui.components.CSAView;
import de.malban.gui.dialogs.InternalFrameFileChoser;
import de.malban.gui.panels.LogPanel;
import de.malban.util.UtilityFiles;
import de.malban.vide.vecx.VecXPanel;
import de.muntjak.tinylookandfeel.Theme;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;

public class OverlSwitcherJPanel
extends JPanel
implements Windowable {
    LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    TinyLogInterface tinyLog = null;
    private int mClassSetting = 0;
    private CSAView mParent = null;
    private JMenuItem mParentMenuItem = null;
    public static final String SID = "Overlay Switcher";
    String lastPath = Global.mainPathPrefix + "overlays";
    private JButton jButtonLoad;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane3;
    private JTable jTable3;
    private PropertyChangeListener pListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            OverlSwitcherJPanel.this.updateMyUI();
        }
    };
    String[] listerColumns = new String[]{"Name", "Size"};
    ArrayList<ListerEntry> listerArray = new ArrayList();
    ListerTableModel listerModel = new ListerTableModel();

    @Override
    public boolean isIcon() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return false;
        }
        return frame.getInternalFrame(this).isIcon();
    }

    @Override
    public void setIcon(boolean b) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return;
        }
        try {
            frame.getInternalFrame(this).setIcon(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void closing() {
        this.deinit();
    }

    @Override
    public void setParentWindow(CSAView jpv) {
        this.mParent = jpv;
    }

    @Override
    public void setMenuItem(JMenuItem item) {
        this.mParentMenuItem = item;
        this.mParentMenuItem.setText(SID);
    }

    @Override
    public JMenuItem getMenuItem() {
        return this.mParentMenuItem;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    void deinit() {
        this.removeUIListerner();
    }

    public OverlSwitcherJPanel() {
        this.initComponents();
        UIManager.addPropertyChangeListener(this.pListener);
        this.updateMyUI();
        this.initLister();
    }

    private void initComponents() {
        this.jScrollPane3 = new JScrollPane();
        this.jTable3 = new JTable();
        this.jButtonLoad = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTable3.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable3.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                OverlSwitcherJPanel.this.jTable3MousePressed(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.jTable3);
        this.jButtonLoad.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_go.png")));
        this.jButtonLoad.setToolTipText("load YM");
        this.jButtonLoad.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverlSwitcherJPanel.this.jButtonLoadActionPerformed(evt);
            }
        });
        this.jLabel1.setText("load overlay");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, -1, 417, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonLoad).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButtonLoad).addComponent(this.jLabel1).addComponent(this.jLabel2, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -1, 270, Short.MAX_VALUE)));
    }

    private void jTable3MousePressed(MouseEvent evt) {
        this.tableClicked(evt);
    }

    private void jButtonLoadActionPerformed(ActionEvent evt) {
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        if (this.lastPath.length() == 0) {
            this.lastPath = Global.mainPathPrefix + "overlays";
            fc.setCurrentDirectory(new File(this.lastPath));
        } else {
            fc.setCurrentDirectory(new File(this.lastPath));
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter("png", "png");
        fc.setFileFilter(filter);
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return;
        }
        if (fc.getSelectedFile() == null) {
            return;
        }
        this.lastPath = fc.getSelectedFile().getParent();
        this.initOverlay(fc.getSelectedFile().getAbsolutePath());
        this.initLister();
    }

    public void removeUIListerner() {
        UIManager.removePropertyChangeListener(this.pListener);
    }

    void updateMyUI() {
        int fontSize = Theme.textFieldFont.getFont().getSize();
        int rowHeight = fontSize + 2;
        this.jTable3.setRowHeight(fontSize + 1);
        this.jTable3.setFont(new Font("Courier New", 1, fontSize - 1));
    }

    @Override
    public void deIconified() {
    }

    void initLister() {
        this.listerArray.clear();
        ArrayList<String> filenames = UtilityFiles.getFilesWith(this.lastPath, ".png");
        if (this.lastPath.length() > 0 && !this.lastPath.endsWith(File.separator)) {
            this.lastPath = this.lastPath + File.separator;
        }
        for (String f : filenames) {
            try {
                ListerEntry entry = new ListerEntry();
                entry.fileName = f;
                entry.completePath = this.lastPath + f;
                File ff = new File(entry.completePath);
                entry.size = ff.length();
                this.listerArray.add(entry);
            }
            catch (Throwable throwable) {}
        }
        this.jTable3.setModel(this.listerModel);
        this.jTable3.tableChanged(null);
    }

    private void tableClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            Point p = evt.getPoint();
            int row = this.jTable3.rowAtPoint(p);
            int col = this.jTable3.columnAtPoint(p);
            if (row < 0) {
                return;
            }
            if (row > this.listerArray.size() - 1) {
                return;
            }
            if (this.listerArray.get((int)row).completePath.toLowerCase().endsWith("png")) {
                String file = this.listerArray.get((int)row).completePath;
                this.initOverlay(file);
            }
        }
    }

    private void initOverlay(String file) {
        CSAMainFrame f = Configuration.getConfiguration().getMainFrame();
        VecXPanel vecxy = f.checkVecxy();
        if (vecxy == null) {
            return;
        }
        vecxy.setOverlay(file);
        this.jLabel2.setText(file);
    }

    public class ListerTableModel
    extends AbstractTableModel {
        @Override
        public String getColumnName(int col) {
            return OverlSwitcherJPanel.this.listerColumns[col];
        }

        @Override
        public int getRowCount() {
            return OverlSwitcherJPanel.this.listerArray.size();
        }

        @Override
        public int getColumnCount() {
            return OverlSwitcherJPanel.this.listerColumns.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return OverlSwitcherJPanel.this.listerArray.get((int)row).fileName;
            }
            if (col == 1) {
                return OverlSwitcherJPanel.this.listerArray.get((int)row).size;
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int col) {
            if (col == 0) {
                return String.class;
            }
            if (col == 1) {
                return Long.TYPE;
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    class ListerEntry {
        String fileName = "";
        String completePath = "";
        long size = 0L;

        ListerEntry() {
        }
    }
}

