/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.panels;

import de.malban.config.Configuration;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.Stateable;
import de.malban.gui.Windowable;
import de.malban.gui.components.CSAView;
import de.malban.util.UtilityString;
import de.malban.vide.dissy.DissiPanel;
import de.malban.vide.vecx.Profiler;
import de.malban.vide.vecx.Updatable;
import de.malban.vide.vecx.VecXPanel;
import de.muntjak.tinylookandfeel.Theme;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.event.RowSorterEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class ProfileJPanel
extends JPanel
implements Windowable,
Stateable,
Updatable {
    Profiler profiler = null;
    private CSAView mParent = null;
    private JMenuItem mParentMenuItem = null;
    private int mClassSetting = 0;
    private VecXPanel vecxPanel = null;
    private DissiPanel dissi = null;
    public static String SID = "Debug: Profiler";
    boolean nameChanged = false;
    ProfileFunctionTableModel model = new ProfileFunctionTableModel();
    TableRowSorter<TableModel> sorter;
    private PropertyChangeListener pListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ProfileJPanel.this.updateMyUI();
        }
    };
    private JButton jButtonApplyCodeScan;
    private JCheckBox jCheckBox1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTabbedPane jTabbedPane1;
    private JTable jTable1;
    private JToggleButton jToggleButton1;
    int lastLength = -1;
    boolean first = true;
    private boolean updateEnabled = false;

    @Override
    public boolean isLoadSettings() {
        return true;
    }

    @Override
    public String getID() {
        return SID;
    }

    @Override
    public String getFileID() {
        return UtilityString.replace(UtilityString.replace(UtilityString.replace(UtilityString.replaceWhiteSpaces(SID, ""), ":", ""), "(", ""), ")", "");
    }

    @Override
    public Serializable getAdditionalStateinfo() {
        return null;
    }

    @Override
    public void setAdditionalStateinfo(Serializable ser) {
    }

    public void setDissi(DissiPanel v) {
        this.dissi = v;
        if (this.dissi == null) {
            return;
        }
    }

    public void setVecxy(VecXPanel v) {
        this.vecxPanel = v;
    }

    @Override
    public boolean isIcon() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return false;
        }
        return frame.getInternalFrame(this).isIcon();
    }

    @Override
    public void setIcon(boolean b) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return;
        }
        try {
            frame.getInternalFrame(this).setIcon(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void closing() {
        if (this.vecxPanel != null) {
            this.vecxPanel.resetProfi();
        }
        this.deinit();
    }

    @Override
    public void setParentWindow(CSAView jpv) {
        this.mParent = jpv;
    }

    @Override
    public void setMenuItem(JMenuItem item) {
        this.mParentMenuItem = item;
        this.mParentMenuItem.setText(SID);
    }

    @Override
    public JMenuItem getMenuItem() {
        return this.mParentMenuItem;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    public void deinit() {
        this.removeUIListerner();
    }

    public ProfileJPanel() {
        this.initComponents();
        this.jTable1.setModel(this.model);
        UIManager.addPropertyChangeListener(this.pListener);
        this.updateMyUI();
        this.jTable1.tableChanged(null);
        this.sorter = new TableRowSorter<TableModel>(this.jTable1.getModel());
        this.jTable1.setRowSorter(this.sorter);
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>(1);
        sortKeys.add(new RowSorter.SortKey(4, SortOrder.DESCENDING));
        this.sorter.setSortKeys(sortKeys);
        this.jTable1.tableChanged(null);
        this.jTable1.sorterChanged(new RowSorterEvent(this.sorter, RowSorterEvent.Type.SORTED, null));
        this.sorter.sort();
    }

    public void removeUIListerner() {
        UIManager.removePropertyChangeListener(this.pListener);
    }

    void updateMyUI() {
        int fontSize = Theme.textFieldFont.getFont().getSize();
        int rowHeight = fontSize + 3;
        this.jTable1.setRowHeight(rowHeight);
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel1 = new JPanel();
        this.jToggleButton1 = new JToggleButton();
        this.jCheckBox1 = new JCheckBox();
        this.jButtonApplyCodeScan = new JButton();
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable1.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ProfileJPanel.this.jTable1MousePressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 395, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 375, Short.MAX_VALUE).addContainerGap())));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 243, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 221, Short.MAX_VALUE).addContainerGap())));
        this.jTabbedPane1.addTab("functional view", this.jPanel2);
        this.jToggleButton1.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/webcam.png")));
        this.jToggleButton1.setToolTipText("Toggle Update (always or only while debug)");
        this.jToggleButton1.setMargin(new Insets(0, 1, 0, -1));
        this.jToggleButton1.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/webcamSelect.png")));
        this.jToggleButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProfileJPanel.this.jToggleButton1ActionPerformed(evt);
            }
        });
        this.jCheckBox1.setText("selected tracker cycle only");
        this.jCheckBox1.setToolTipText("Only usable while tracker is actually tracking!");
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProfileJPanel.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.jButtonApplyCodeScan.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/exclamation.png")));
        this.jButtonApplyCodeScan.setToolTipText("Reset Profiler");
        this.jButtonApplyCodeScan.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonApplyCodeScan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProfileJPanel.this.jButtonApplyCodeScanActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jToggleButton1, -2, 20, -2).addGap(18, 18, 18).addComponent(this.jCheckBox1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonApplyCodeScan)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToggleButton1, -2, 20, -2).addComponent(this.jCheckBox1).addComponent(this.jButtonApplyCodeScan));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jTabbedPane1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jTabbedPane1)));
    }

    private void jToggleButton1ActionPerformed(ActionEvent evt) {
        this.updateEnabled = this.jToggleButton1.isSelected();
    }

    private void jTable1MousePressed(MouseEvent evt) {
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        if (this.profiler != null) {
            this.profiler.trackingOnly = this.jCheckBox1.isSelected();
        }
    }

    private void jButtonApplyCodeScanActionPerformed(ActionEvent evt) {
        this.vecxPanel.initProfiler();
    }

    private void update() {
        if (this.vecxPanel == null) {
            return;
        }
        this.profiler = this.vecxPanel.getProfiler();
        if (this.profiler == null) {
            return;
        }
        if (this.first) {
            this.jCheckBox1.setSelected(this.profiler.trackingOnly);
            this.first = false;
        }
        if (this.lastLength != this.profiler.routines.size()) {
            this.model.fireTableDataChanged();
        }
        this.lastLength = this.profiler.routines.size();
        try {
            this.sorter.sort();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.jTable1.repaint();
    }

    @Override
    public void updateValues(boolean forceUpdate) {
        if (this.profiler != null) {
            this.profiler.trackingOnly = this.jCheckBox1.isSelected();
        }
        if (!forceUpdate && !this.updateEnabled) {
            return;
        }
        this.update();
    }

    @Override
    public void setUpdateEnabled(boolean b) {
        this.updateEnabled = b;
    }

    @Override
    public void deIconified() {
    }

    public class ProfileFunctionTableModel
    extends AbstractTableModel {
        @Override
        public int getRowCount() {
            if (ProfileJPanel.this.profiler == null) {
                return 0;
            }
            return ProfileJPanel.this.profiler.routines.size();
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public Object getValueAt(int row, int col) {
            boolean ok = true;
            if (ProfileJPanel.this.profiler == null) {
                ok = false;
            }
            if (ok && ProfileJPanel.this.vecxPanel == null) {
                ok = false;
            }
            if (ok && ProfileJPanel.this.profiler.routines == null) {
                ok = false;
            }
            if (ok && row >= ProfileJPanel.this.profiler.routines.size()) {
                ok = false;
            }
            if (!ok) {
                if (col == 0) {
                    return "";
                }
                if (col == 1) {
                    return "";
                }
                if (col == 2) {
                    return 0;
                }
                if (col == 3) {
                    return 0;
                }
                if (col == 4) {
                    return 0.0;
                }
                return "";
            }
            Profiler.ProfilerMemoryLocation pml = ProfileJPanel.this.profiler.routines.get(row);
            if (ProfileJPanel.this.profiler.trackingOnly) {
                if (col == 0) {
                    return "$" + String.format("%04X", pml.address);
                }
                if (col == 1) {
                    return pml.name;
                }
                if (col == 2) {
                    return pml.lastTrack_accessCount_final;
                }
                if (col == 3) {
                    return pml.lastTrack_accessCyclesSum_final;
                }
                if (col == 4) {
                    double cycles = ProfileJPanel.this.profiler.track_overallCycles_final;
                    cycles = (double)pml.lastTrack_accessCyclesSum_final / cycles * 100.0;
                    return cycles;
                }
                return "";
            }
            if (col == 0) {
                return "$" + String.format("%04X", pml.address);
            }
            if (col == 1) {
                return pml.name;
            }
            if (col == 2) {
                return pml.accessCount;
            }
            if (col == 3) {
                return pml.accessCyclesSum;
            }
            if (col == 4) {
                double cycles = ProfileJPanel.this.profiler.overallCycles;
                cycles = (double)pml.accessCyclesSum / cycles * 100.0;
                return cycles;
            }
            return "";
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "address";
            }
            if (column == 1) {
                return "name";
            }
            if (column == 2) {
                return "access";
            }
            if (column == 3) {
                return "cycles";
            }
            if (column == 4) {
                return "cycles %";
            }
            return "-";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return String.class;
            }
            if (columnIndex == 1) {
                return String.class;
            }
            if (columnIndex == 2) {
                return Long.class;
            }
            if (columnIndex == 3) {
                return Long.class;
            }
            if (columnIndex == 4) {
                return Double.class;
            }
            return String.class;
        }

        public int getColWidth(int col) {
            if (col == 0) {
                return 20;
            }
            if (col == 1) {
                return 200;
            }
            if (col == 2) {
                return 20;
            }
            if (col == 3) {
                return 20;
            }
            return 20;
        }

        public Color getBackground(int col) {
            if (col == 0) {
                return new Color(200, 255, 200, 255);
            }
            return null;
        }
    }
}

