/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.panels;

import de.malban.config.Configuration;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.Stateable;
import de.malban.gui.Windowable;
import de.malban.gui.components.CSAView;
import de.malban.util.UtilityString;
import de.malban.vide.VideConfig;
import de.malban.vide.dissy.DissiPanel;
import de.malban.vide.vecx.VecXPanel;
import de.malban.vide.vecx.VecXState;
import de.muntjak.tinylookandfeel.Theme;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;

public class VectorInfoJPanel
extends JPanel
implements Windowable,
Stateable {
    public VideConfig config = VideConfig.getConfig();
    private CSAView mParent = null;
    private JMenuItem mParentMenuItem = null;
    private int mClassSetting = 0;
    private DissiPanel dissi = null;
    private VecXPanel vecxPanel = null;
    ArrayList<Integer> callStack = new ArrayList();
    int x0 = 0;
    int y0 = 0;
    int x1 = 0;
    int y1 = 0;
    int color = 0;
    int pc = 0;
    private boolean updateEnabled = false;
    private JLabel jLabel1;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel8;
    private JLabel jLabelCount;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JToggleButton jToggleButton1;
    public static String SID = "Debug: Vector info";
    private PropertyChangeListener pListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            VectorInfoJPanel.this.updateMyUI();
        }
    };

    @Override
    public boolean isLoadSettings() {
        return true;
    }

    public void setVecxy(VecXPanel v) {
        this.vecxPanel = v;
        this.jTable1.setModel(new CallStackTableModel());
    }

    @Override
    public boolean isIcon() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return false;
        }
        return frame.getInternalFrame(this).isIcon();
    }

    @Override
    public void setIcon(boolean b) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return;
        }
        try {
            frame.getInternalFrame(this).setIcon(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void closing() {
        if (this.vecxPanel != null) {
            this.vecxPanel.resetVinfi();
        }
        this.deinit();
    }

    @Override
    public void setParentWindow(CSAView jpv) {
        this.mParent = jpv;
    }

    @Override
    public void setMenuItem(JMenuItem item) {
        this.mParentMenuItem = item;
        this.mParentMenuItem.setText(SID);
    }

    @Override
    public JMenuItem getMenuItem() {
        return this.mParentMenuItem;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    public void deinit() {
        this.removeUIListerner();
    }

    public VectorInfoJPanel() {
        this.initComponents();
        UIManager.addPropertyChangeListener(this.pListener);
        this.updateMyUI();
        this.jTable1.setTableHeader(null);
    }

    public void setDissi(DissiPanel d) {
        this.dissi = d;
    }

    public void setMouseCoordinates(final int x, final int y) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String out = "";
                int x0 = x;
                if (x < 0) {
                    out = out + "-";
                    x0 *= -1;
                }
                out = out + "$" + String.format("%04X", x0 & 0xFFFF) + ",";
                VectorInfoJPanel.this.y0 = y;
                if (y < 0) {
                    out = out + "-";
                    VectorInfoJPanel.this.y0 *= -1;
                }
                out = out + "$" + String.format("%04X", VectorInfoJPanel.this.y0 & 0xFFFF);
                VectorInfoJPanel.this.jLabel16.setText(out);
                VectorInfoJPanel.this.jLabel16.setToolTipText("Mouse position in vectrex coordinates: Dec: " + x + ", " + y);
                VectorInfoJPanel.this.repaint();
            }
        });
    }

    public void updateValues(boolean forceUpdate) {
        if (!forceUpdate && !this.updateEnabled) {
            return;
        }
        this.update();
    }

    public void setUpdateEnabled(boolean b) {
        this.updateEnabled = b;
    }

    public void update() {
        this.jLabelCount.setText("" + this.vecxPanel.getVectorCount());
    }

    public void update(VecXState.vector_t v) {
        this.callStack.clear();
        this.pc = -1;
        if (v == null) {
            this.jTable1.tableChanged(null);
            this.jLabel11.setText("");
            this.jLabel12.setText("");
            this.jLabel15.setText("");
            this.jLabel14.setText("");
            this.jLabel13.setText("");
            this.jLabel14.setText("");
            this.jLabel11.setToolTipText("");
            this.jLabel12.setToolTipText("");
            this.jLabel15.setToolTipText("");
            this.jLabel14.setToolTipText("");
            this.jLabel13.setToolTipText("");
            this.jLabel14.setToolTipText("");
            return;
        }
        if (v.callStack != null) {
            for (int i = 0; i < v.callStack.size() - 1; ++i) {
                this.callStack.add(v.callStack.get(i));
            }
            this.pc = v.callStack.get(v.callStack.size() - 1);
        }
        this.x0 = v.x0 - this.config.ALG_MAX_X / 2;
        this.y0 = -(v.y0 - this.config.ALG_MAX_Y / 2);
        this.x1 = v.x1 - this.config.ALG_MAX_X / 2;
        this.y1 = -(v.y1 - this.config.ALG_MAX_Y / 2);
        this.color = v.color;
        this.jTable1.tableChanged(null);
        if (this.x0 >= 0) {
            this.jLabel11.setText("$" + String.format("%04X", this.x0 & 0xFFFF));
        } else {
            this.jLabel11.setText("-$" + String.format("%04X", this.x0 * -1 & 0xFFFF));
        }
        this.jLabel11.setToolTipText("decimal: " + (this.x0 & 0xFFFF) + "display: " + v.x0);
        if (this.y0 >= 0) {
            this.jLabel12.setText("$" + String.format("%04X", this.y0 & 0xFFFF));
        } else {
            this.jLabel12.setText("-$" + String.format("%04X", this.y0 * -1 & 0xFFFF));
        }
        this.jLabel12.setToolTipText("decimal: " + (this.y0 & 0xFFFF) + "display: " + v.y0);
        if (this.x1 >= 0) {
            this.jLabel15.setText("$" + String.format("%04X", this.x1 & 0xFFFF));
        } else {
            this.jLabel15.setText("-$" + String.format("%04X", this.x1 * -1 & 0xFFFF));
        }
        this.jLabel15.setToolTipText("decimal: " + (this.x1 & 0xFFFF) + ", width: " + ((this.x1 & 0xFFFF) - (this.x0 & 0xFFFF)) + "display: " + v.x1);
        if (this.y1 >= 0) {
            this.jLabel14.setText("$" + String.format("%04X", this.y1 & 0xFFFF));
        } else {
            this.jLabel14.setText("-$" + String.format("%04X", this.y1 * -1 & 0xFFFF));
        }
        this.jLabel14.setToolTipText("decimal: " + (this.y1 & 0xFFFF) + ", height: " + ((this.y1 & 0xFFFF) - (this.y0 & 0xFFFF)) + "display: " + v.y1);
        this.jLabel13.setText("$" + String.format("%02X", this.color & 0xFF));
        this.jLabel13.setToolTipText("decimal: " + (this.color & 0xFF));
        this.jLabel17.setText("$" + String.format("%04X", this.pc & 0xFFFF));
        this.jLabel17.setToolTipText("decimal: " + (this.pc & 0xFFFF));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jLabel17 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jLabelCount = new JLabel();
        this.jToggleButton1 = new JToggleButton();
        this.jLabel6 = new JLabel();
        this.setName("regi");
        this.jLabel1.setFont(new Font("Courier", 0, 12));
        this.jLabel1.setText("X0");
        this.jLabel2.setFont(new Font("Courier", 0, 12));
        this.jLabel2.setText("Y0");
        this.jLabel3.setFont(new Font("Courier", 0, 12));
        this.jLabel3.setText("X1");
        this.jLabel4.setFont(new Font("Courier", 0, 12));
        this.jLabel4.setText("Y1");
        this.jLabel5.setFont(new Font("Courier", 0, 12));
        this.jLabel5.setText("I");
        this.jLabel8.setFont(new Font("Courier", 0, 12));
        this.jLabel8.setText("PC");
        this.jScrollPane1.setBorder(BorderFactory.createEtchedBorder());
        this.jTable1.setFont(new Font("Courier", 0, 12));
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null}, {null}, {null}, {null}}, new String[]{"Adr"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class};
                this.canEdit = new boolean[]{false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTable1.setShowGrid(false);
        this.jTable1.setShowHorizontalLines(true);
        this.jTable1.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                VectorInfoJPanel.this.jTable1MousePressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jLabel11.setFont(new Font("Courier", 0, 12));
        this.jLabel11.setHorizontalAlignment(4);
        this.jLabel11.setText("$ff");
        this.jLabel12.setFont(new Font("Courier", 0, 12));
        this.jLabel12.setHorizontalAlignment(4);
        this.jLabel12.setText("$ff");
        this.jLabel13.setFont(new Font("Courier", 0, 12));
        this.jLabel13.setHorizontalAlignment(4);
        this.jLabel13.setText("$ffff");
        this.jLabel14.setFont(new Font("Courier", 0, 12));
        this.jLabel14.setHorizontalAlignment(4);
        this.jLabel14.setText("$ffff");
        this.jLabel15.setFont(new Font("Courier", 0, 12));
        this.jLabel15.setHorizontalAlignment(4);
        this.jLabel15.setText("$ffff");
        this.jLabel17.setFont(new Font("Courier", 0, 12));
        this.jLabel17.setHorizontalAlignment(4);
        this.jLabel17.setText("$ffff");
        this.jLabel17.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                VectorInfoJPanel.this.jLabel17MousePressed(evt);
            }
        });
        this.jLabel16.setFont(new Font("Courier", 0, 12));
        this.jLabel16.setHorizontalAlignment(4);
        this.jLabel16.setText("$ffff, $ffff");
        this.jLabel16.setToolTipText("Mouse coordinates in vectrex coordinates");
        this.jLabelCount.setFont(new Font("Geneva", 0, 8));
        this.jLabelCount.setHorizontalAlignment(11);
        this.jLabelCount.setText("0");
        this.jLabelCount.setToolTipText("<html>\ncount of vectors currently displayed <BR>\n(only non-\"ray\"-display)<BR>\n<BR>\n(a vector is here every line \"drawn\", meaning, patterned lines are counted as\nseveral vectors)<BR>\n</html>");
        this.jLabelCount.setHorizontalTextPosition(4);
        this.jToggleButton1.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/webcam.png")));
        this.jToggleButton1.setToolTipText("Toggle Update (always or only while debug)");
        this.jToggleButton1.setMargin(new Insets(0, 1, 0, -1));
        this.jToggleButton1.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/webcamSelect.png")));
        this.jToggleButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VectorInfoJPanel.this.jToggleButton1ActionPerformed(evt);
            }
        });
        this.jLabel6.setText("#");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel16, -2, 93, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jToggleButton1).addGap(10, 10, 10).addComponent(this.jLabel6, -2, 14, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelCount, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, -2, 64, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel8, -2, 18, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel17, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5, -2, 18, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel13, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4, -2, 18, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel14, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 18, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel11, -2, 51, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, -2, 18, -2).addComponent(this.jLabel3, -2, 18, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel15, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel12, -1, -1, Short.MAX_VALUE))))))).addContainerGap(21, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToggleButton1, -2, 21, -2).addComponent(this.jLabelCount, -2, 21, -2).addComponent(this.jLabel6, -2, 21, -2)).addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel11)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabel12)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jLabel14))).addComponent(this.jLabel15)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jLabel13)).addGap(22, 22, 22).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.jLabel17)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 130, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel16).addGap(33, 33, 33)));
    }

    private void jTable1MousePressed(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            JTable table = (JTable)evt.getSource();
            Point p = evt.getPoint();
            int row = table.rowAtPoint(p);
            if (this.dissi != null) {
                this.dissi.goAddress(((CallStackTableModel)table.getModel()).getAddress(row), true, true, true);
            }
        }
    }

    private void jLabel17MousePressed(MouseEvent evt) {
        if (this.pc != -1 && evt.getClickCount() == 2 && this.dissi != null) {
            this.dissi.goAddress(this.pc & 0xFFFF, true, true, true);
        }
    }

    private void jToggleButton1ActionPerformed(ActionEvent evt) {
        this.updateEnabled = this.jToggleButton1.isSelected();
    }

    @Override
    public String getID() {
        return SID;
    }

    @Override
    public String getFileID() {
        return UtilityString.replace(UtilityString.replace(UtilityString.replace(UtilityString.replaceWhiteSpaces(SID, ""), ":", ""), "(", ""), ")", "");
    }

    @Override
    public Serializable getAdditionalStateinfo() {
        return null;
    }

    @Override
    public void setAdditionalStateinfo(Serializable ser) {
    }

    public void removeUIListerner() {
        UIManager.removePropertyChangeListener(this.pListener);
    }

    void updateMyUI() {
        int fontSize = Theme.textFieldFont.getFont().getSize();
        int rowHeight = fontSize + 3;
        this.jTable1.setRowHeight(rowHeight);
    }

    @Override
    public void deIconified() {
    }

    public class CallStackTableModel
    extends AbstractTableModel {
        @Override
        public int getRowCount() {
            return VectorInfoJPanel.this.callStack.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return "$" + String.format("%04X", VectorInfoJPanel.this.callStack.get(row));
        }

        public int getAddress(int row) {
            return VectorInfoJPanel.this.callStack.get(row);
        }

        @Override
        public String getColumnName(int column) {
            return "";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }
}

