/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.panels;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.HotKey;
import de.malban.gui.Scaler;
import de.malban.gui.Stateable;
import de.malban.gui.Windowable;
import de.malban.gui.components.CSAView;
import de.malban.gui.components.ModalInternalFrame;
import de.malban.util.UtilityImage;
import de.malban.util.UtilityString;
import de.malban.vide.dissy.DASM6809;
import de.malban.vide.vecx.Updatable;
import de.malban.vide.vecx.VecXPanel;
import de.malban.vide.vecx.cartridge.Cartridge;
import de.malban.vide.vecx.panels.GetBaseline;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class WRTrackerJPanel
extends JPanel
implements Windowable,
Stateable,
Updatable {
    private CSAView mParent = null;
    private JMenuItem mParentMenuItem = null;
    private int mClassSetting = 0;
    private VecXPanel vecxPanel = null;
    public static String SID = "Debug: Tracker";
    int baseline = 30000;
    BufferedImage[] image = new BufferedImage[2];
    int imageSwitch = 0;
    int displayWidth = 0;
    int displayheight = 0;
    double scaleWidth = 0.0;
    double scaleHeight = 0.0;
    int SCALE_WR_MAX_CYCLES = 100000;
    int avgCount = 0;
    long avg = 0L;
    int max = 0;
    int min = Integer.MAX_VALUE;
    Vector<TrackiInfo> persistentInfo = new Vector();
    public long lastTest = 0L;
    private JButton jButton1;
    JButton jButtonBaseline;
    private JButton jButtonDelete;
    private JButton jButtonDelete1;
    private JButton jButtonSave;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextField jTextField3;
    private JTextField jTextField4;
    private JTextField jTextField5;
    private JTextField jTextField6;
    private JTextField jTextField7;
    private JTextField jTextFieldCurrent;
    private JToggleButton jToggleButton4;
    private boolean updateEnabled = true;
    int auto_adrLower = 0;
    int auto_adrHigher = 0;
    int auto_bank = 0;
    boolean oldFound = false;

    @Override
    public boolean isLoadSettings() {
        return true;
    }

    protected boolean loadSettings() {
        ++this.mClassSetting;
        this.jComboBox1.setModel(new DefaultComboBoxModel<TrackiInfo>(this.persistentInfo));
        --this.mClassSetting;
        try {
            this.persistentInfo = (Vector)CSAMainFrame.deserialize(Global.mainPathPrefix + "serialize" + File.separator + "TrackiInfo.ser");
            if (this.persistentInfo == null) {
                this.persistentInfo = new Vector();
                return false;
            }
        }
        catch (Throwable e) {
            return false;
        }
        ++this.mClassSetting;
        this.jComboBox1.setModel(new DefaultComboBoxModel<TrackiInfo>(this.persistentInfo));
        --this.mClassSetting;
        return true;
    }

    protected boolean saveSettings(boolean fromDelete) {
        int oldIndex = this.jComboBox1.getSelectedIndex();
        String oldText = this.jTextField5.getText();
        TrackiInfo ti = new TrackiInfo();
        if (!fromDelete) {
            ti.name = this.jTextField5.getText();
            if (ti.name.trim().length() == 0) {
                return false;
            }
            ti.start = DASM6809.toNumber(this.jTextField3.getText());
            ti.end = DASM6809.toNumber(this.jTextField4.getText());
            ti.bank = DASM6809.toNumber(this.jTextField7.getText());
            ti.baseline = this.baseline;
            for (int i = 0; i < this.persistentInfo.size(); ++i) {
                if (!this.persistentInfo.elementAt(i).equals(ti)) continue;
                this.persistentInfo.removeElementAt(i);
                break;
            }
            this.persistentInfo.addElement(ti);
        }
        try {
            CSAMainFrame.serialize(this.persistentInfo, Global.mainPathPrefix + "serialize" + File.separator + "TrackiInfo.ser");
        }
        catch (Throwable e) {
            return false;
        }
        if (!fromDelete) {
            ++this.mClassSetting;
        }
        this.jComboBox1.setModel(new DefaultComboBoxModel<TrackiInfo>(this.persistentInfo));
        if (oldIndex >= this.persistentInfo.size()) {
            --oldIndex;
        }
        this.jComboBox1.setSelectedIndex(oldIndex);
        if (!fromDelete) {
            --this.mClassSetting;
        }
        this.setFields(oldText);
        return true;
    }

    @Override
    public String getID() {
        return SID;
    }

    @Override
    public String getFileID() {
        return UtilityString.replace(UtilityString.replace(UtilityString.replace(UtilityString.replaceWhiteSpaces(SID, ""), ":", ""), "(", ""), ")", "");
    }

    @Override
    public Serializable getAdditionalStateinfo() {
        return null;
    }

    @Override
    public void setAdditionalStateinfo(Serializable ser) {
    }

    public void setVecxy(VecXPanel v) {
        this.vecxPanel = v;
        this.auto_adrLower = 0;
        this.auto_adrHigher = 0;
        this.auto_bank = 0;
        this.oldFound = false;
    }

    @Override
    public boolean isIcon() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return false;
        }
        return frame.getInternalFrame(this).isIcon();
    }

    @Override
    public void setIcon(boolean b) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return;
        }
        try {
            frame.getInternalFrame(this).setIcon(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void closing() {
        if (this.vecxPanel != null) {
            this.vecxPanel.resetTracki();
        }
        this.deinit();
    }

    @Override
    public void setParentWindow(CSAView jpv) {
        this.mParent = jpv;
    }

    @Override
    public void setMenuItem(JMenuItem item) {
        this.mParentMenuItem = item;
        this.mParentMenuItem.setText(SID);
    }

    @Override
    public JMenuItem getMenuItem() {
        return this.mParentMenuItem;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    public void deinit() {
    }

    public WRTrackerJPanel() {
        this.initComponents();
        this.loadSettings();
        if (Global.getOSName().toUpperCase().contains("MAC")) {
            HotKey.addMacDefaults(this.jTextField1);
            HotKey.addMacDefaults(this.jTextField2);
            HotKey.addMacDefaults(this.jTextField3);
            HotKey.addMacDefaults(this.jTextField4);
            HotKey.addMacDefaults(this.jTextField5);
            HotKey.addMacDefaults(this.jTextFieldCurrent);
            HotKey.addMacDefaults(this.jTextField6);
            HotKey.addMacDefaults(this.jTextField7);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        BufferedImage[] bufferedImageArray = this.image;
        synchronized (this.image) {
            if (this.image == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (this.vecxPanel == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (this.lastTest == this.vecxPanel.getLastWaitRecalTest()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.lastTest = this.vecxPanel.getLastWaitRecalTest();
            int lastDisplayed = this.imageSwitch;
            this.imageSwitch = (this.imageSwitch + 1) % 2;
            if (this.image[this.imageSwitch] == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            Graphics2D g2 = this.image[this.imageSwitch].createGraphics();
            g2.drawImage(this.image[lastDisplayed], 0, 0, this.displayWidth - 2, this.displayheight, 2, 0, this.displayWidth, this.displayheight, this);
            g2.clearRect(this.displayWidth - 2, 0, 2, this.displayheight);
            int[] wrBuffer = this.vecxPanel.getCurrentWaitRecalBuffer();
            int current = this.vecxPanel.getCurrentWaitRecalBufferPos();
            int v = 1;
            current = (current + (wrBuffer.length - 1)) % wrBuffer.length;
            int height = wrBuffer[current];
            boolean skip = false;
            if ((long)height > 5L * this.avg) {
                skip = true;
            }
            if (this.avg == 0L) {
                skip = false;
            }
            if (height <= 0) {
                skip = true;
            }
            if (height > 1000000) {
                skip = true;
            }
            String tt = "Samples: " + this.vecxPanel.getTrackiCount() + ", >" + this.baseline + ": " + this.vecxPanel.getTrackiAbove();
            this.jTextField2.setToolTipText(tt);
            this.jTextFieldCurrent.setToolTipText(tt);
            this.jTextField1.setToolTipText(tt);
            this.jTextField6.setToolTipText(tt);
            if (!skip) {
                this.jTextFieldCurrent.setText("" + height);
                this.avg += (long)height;
                ++this.avgCount;
                this.jTextField6.setText("" + this.avg / (long)this.avgCount);
                if (this.max < height) {
                    this.max = height;
                    this.jTextField2.setText("" + this.max);
                }
                if (this.min > height) {
                    this.min = height;
                    this.jTextField1.setText("" + this.min);
                }
            }
            Color c = new Color(255, 255, 0, 255);
            g2.setColor(c);
            double x0 = this.image[this.imageSwitch].getWidth() - 2 * v;
            double y0 = this.image[this.imageSwitch].getHeight();
            double x1 = x0;
            double y1 = this.SCALE_WR_MAX_CYCLES - height;
            y1 = Scaler.scaleDoubleToInt(y1, this.scaleHeight);
            g2.drawLine((int)x0, (int)y0, (int)x1, (int)y1);
            g2.dispose();
            this.repaint();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jToggleButton4 = new JToggleButton();
        this.jLabel3 = new JLabel();
        this.jTextField4 = new JTextField();
        this.jTextField3 = new JTextField();
        this.jButton1 = new JButton();
        this.jTextField7 = new JTextField();
        this.jButtonBaseline = new JButton();
        this.jButtonDelete1 = new JButton();
        this.jPanel3 = new JPanel();
        this.jButtonDelete = new JButton();
        this.jButtonSave = new JButton();
        this.jTextField5 = new JTextField();
        this.jComboBox1 = new JComboBox();
        this.jPanel4 = new JPanel();
        this.jTextFieldCurrent = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextField6 = new JTextField();
        this.jTextField1 = new JTextField();
        this.jLabel4 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jTextField2 = new JTextField();
        this.setName("regi");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                WRTrackerJPanel.this.formComponentResized(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setPreferredSize(new Dimension(345, 70));
        this.jToggleButton4.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/webcam.png")));
        this.jToggleButton4.setSelected(true);
        this.jToggleButton4.setToolTipText("Toggle Update (always or only while debug)");
        this.jToggleButton4.setMargin(new Insets(0, 1, 0, -1));
        this.jToggleButton4.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/webcamSelect.png")));
        this.jToggleButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WRTrackerJPanel.this.jToggleButton4ActionPerformed(evt);
            }
        });
        this.jLabel3.setText("addresses");
        this.jTextField4.setText("$F192");
        this.jTextField4.setToolTipText("lower address");
        this.jTextField4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WRTrackerJPanel.this.jTextField4ActionPerformed(evt);
            }
        });
        this.jTextField3.setText("$F1A2");
        this.jTextField3.setToolTipText("higher address");
        this.jButton1.setText("reset");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WRTrackerJPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jTextField7.setText("0");
        this.jTextField7.setToolTipText("bank");
        this.jTextField7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WRTrackerJPanel.this.jTextField7ActionPerformed(evt);
            }
        });
        this.jButtonBaseline.setText("b");
        this.jButtonBaseline.setToolTipText("enter baseline (default 30000)");
        this.jButtonBaseline.setMargin(new Insets(0, 0, 0, -1));
        this.jButtonBaseline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WRTrackerJPanel.this.jButtonBaselineActionPerformed(evt);
            }
        });
        this.jButtonDelete1.setText("A");
        this.jButtonDelete1.setToolTipText("<html>\nSearch for the next WR code.<BR>\nThe search only works with code exactly like:<BR>\nrepeat:<BR>\n<PRE>\n&nbsp;&nbsp;&nbsp;lda #$20\n&nbsp;&nbsp;&nbsp;bita <VIA_int_flags\n&nbsp;&nbsp;&nbsp;beq repeat\n</PRE>\n</html>");
        this.jButtonDelete1.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonDelete1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WRTrackerJPanel.this.jButtonDelete1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jToggleButton4, -2, 20, -2).addGap(3, 3, 3).addComponent(this.jButtonBaseline).addGap(2, 2, 2).addComponent(this.jLabel3, -2, 69, -2).addGap(4, 4, 4).addComponent(this.jTextField7, -2, 20, -2).addGap(2, 2, 2).addComponent(this.jTextField4, -1, 84, Short.MAX_VALUE).addGap(2, 2, 2).addComponent(this.jTextField3, -1, 86, Short.MAX_VALUE).addGap(2, 2, 2).addComponent(this.jButton1).addGap(2, 2, 2).addComponent(this.jButtonDelete1, -2, 21, -2)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToggleButton4, -2, 21, -2).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3, -2, 21, -2).addComponent(this.jButtonBaseline, -2, 21, -2)).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField4, -2, 21, -2).addComponent(this.jTextField3, -2, 21, -2).addComponent(this.jButton1, -2, 21, -2).addComponent(this.jTextField7, -2, 21, -2)).addComponent(this.jButtonDelete1, -2, 21, -2));
        this.jButtonDelete.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/delete.png")));
        this.jButtonDelete.setToolTipText("delete entry");
        this.jButtonDelete.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WRTrackerJPanel.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonSave.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_save.png")));
        this.jButtonSave.setToolTipText("save current setting");
        this.jButtonSave.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WRTrackerJPanel.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox1.setPreferredSize(new Dimension(59, 20));
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WRTrackerJPanel.this.jComboBox1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jTextField5, -1, 142, Short.MAX_VALUE).addGap(2, 2, 2).addComponent(this.jComboBox1, 0, 193, Short.MAX_VALUE).addGap(2, 2, 2).addComponent(this.jButtonSave).addGap(2, 2, 2).addComponent(this.jButtonDelete).addGap(0, 0, 0)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField5, -2, 21, -2).addComponent(this.jButtonSave, GroupLayout.Alignment.TRAILING, -2, 21, -2).addComponent(this.jButtonDelete, GroupLayout.Alignment.TRAILING, -2, 21, -2).addComponent(this.jComboBox1, GroupLayout.Alignment.TRAILING, -2, 21, -2));
        this.jTextFieldCurrent.setText("00000");
        this.jTextFieldCurrent.setToolTipText("Current cycle count");
        this.jTextFieldCurrent.setMinimumSize(new Dimension(70, 19));
        this.jTextFieldCurrent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WRTrackerJPanel.this.jTextFieldCurrentActionPerformed(evt);
            }
        });
        this.jLabel2.setText("max");
        this.jTextField6.setText("00000");
        this.jTextField6.setToolTipText("");
        this.jTextField6.setMinimumSize(new Dimension(70, 19));
        this.jTextField1.setText("00000");
        this.jTextField1.setMinimumSize(new Dimension(70, 19));
        this.jLabel4.setText("avg");
        this.jLabel1.setText("min");
        this.jTextField2.setText("00000");
        this.jTextField2.setMinimumSize(new Dimension(70, 19));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jTextFieldCurrent, -1, 75, Short.MAX_VALUE).addGap(4, 4, 4).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addGap(4, 4, 4).addComponent(this.jTextField1, -1, 75, Short.MAX_VALUE).addGap(4, 4, 4).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addGap(4, 4, 4).addComponent(this.jTextField2, -1, 75, Short.MAX_VALUE).addGap(4, 4, 4).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE).addGap(4, 4, 4).addComponent(this.jTextField6, -1, 75, Short.MAX_VALUE).addGap(0, 0, 0)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGap(0, 0, 0).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldCurrent, -2, 21, -2).addComponent(this.jLabel1, -2, 21, -2).addComponent(this.jTextField1, -2, 21, -2).addComponent(this.jLabel2, -2, 21, -2).addComponent(this.jTextField2, -2, 21, -2).addComponent(this.jLabel4, -2, 21, -2).addComponent(this.jTextField6, -2, 21, -2))));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE)).addGap(0, 0, 0)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addGap(2, 2, 2).addComponent(this.jPanel3, -2, -1, -2).addGap(2, 2, 2).addComponent(this.jPanel4, -2, -1, -2)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, 447, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, 71, -2));
    }

    private void formComponentResized(ComponentEvent evt) {
        this.resetGfx();
        this.update();
        this.repaint();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.max = 0;
        this.min = Integer.MAX_VALUE;
        this.avg = 0L;
        this.avgCount = 0;
        if (this.vecxPanel == null) {
            return;
        }
        int[] wrBuffer = this.vecxPanel.getCurrentWaitRecalBuffer();
        for (int v = 0; v < wrBuffer.length; ++v) {
            wrBuffer[v] = 0;
        }
        int start = DASM6809.toNumber(this.jTextField3.getText());
        int end2 = DASM6809.toNumber(this.jTextField4.getText());
        int bank2 = DASM6809.toNumber(this.jTextField7.getText());
        this.vecxPanel.resetAllTimeLowStack();
        this.vecxPanel.setTrackingAddress(start, end2, bank2);
    }

    private void jToggleButton4ActionPerformed(ActionEvent evt) {
        this.updateEnabled = this.jToggleButton4.isSelected();
    }

    private void jTextField4ActionPerformed(ActionEvent evt) {
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        this.saveSettings(false);
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        if (this.jComboBox1.getSelectedIndex() == -1) {
            return;
        }
        this.setFields(this.jComboBox1.getSelectedItem().toString());
        this.auto_adrLower = 0;
        this.auto_adrHigher = 0;
        this.auto_bank = 0;
        this.oldFound = false;
        this.jButton1ActionPerformed(null);
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        if (this.jComboBox1.getSelectedIndex() == -1) {
            return;
        }
        TrackiInfo info = (TrackiInfo)this.jComboBox1.getSelectedItem();
        for (int i = 0; i < this.persistentInfo.size(); ++i) {
            if (!this.persistentInfo.elementAt(i).equals(info)) continue;
            this.persistentInfo.removeElementAt(i);
            break;
        }
        this.saveSettings(true);
    }

    private void jTextFieldCurrentActionPerformed(ActionEvent evt) {
    }

    private void jTextField7ActionPerformed(ActionEvent evt) {
    }

    private void jButtonBaselineActionPerformed(ActionEvent evt) {
        Configuration C = Configuration.getConfiguration();
        if (C.getMainFrame() == null) {
            return;
        }
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        GetBaseline si = new GetBaseline(Configuration.getConfiguration().getMainFrame(), this.vecxPanel, this.baseline);
        si.modal = new ModalInternalFrame("Input Dialog", frame.getRootPane(), (Component)frame, (Container)si, si.jButton1);
        si.modal.setVisible(true);
        this.baseline = si.getBaseline();
        frame = Configuration.getConfiguration().getMainFrame();
    }

    private void jButtonDelete1ActionPerformed(ActionEvent evt) {
        this.searchAndSetWR();
    }

    private void resetGfx() {
        if (this.getWidth() == 0) {
            return;
        }
        if (this.getHeight() == 0) {
            return;
        }
        this.image[0] = UtilityImage.getNewImage(this.getWidth(), this.getHeight() - this.jPanel1.getHeight());
        if (this.image[0] == null) {
            return;
        }
        this.image[1] = UtilityImage.getNewImage(this.getWidth(), this.getHeight() - this.jPanel1.getHeight());
        if (this.image[1] == null) {
            return;
        }
        this.displayWidth = this.image[0].getWidth();
        this.displayheight = this.image[0].getHeight();
        this.scaleWidth = 1.0;
        this.scaleHeight = (double)this.displayheight / (double)this.SCALE_WR_MAX_CYCLES;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image[this.imageSwitch] != null) {
            g.drawImage(this.image[this.imageSwitch], 0, this.jPanel1.getHeight(), null);
            double y = this.SCALE_WR_MAX_CYCLES - this.baseline;
            y = Scaler.scaleDoubleToInt(y, this.scaleHeight) + this.jPanel1.getHeight();
            Color c = new Color(0, 255, 0, 255);
            g.setColor(c);
            g.drawLine(0, (int)y, this.displayWidth, (int)y);
            g.drawString("" + this.baseline, 10, (int)y - 20);
            c = new Color(255, 0, 0, 255);
            g.setColor(c);
            g.drawString("" + this.SCALE_WR_MAX_CYCLES, 10, 10 + this.jPanel1.getHeight());
        }
    }

    @Override
    public void updateValues(boolean forceUpdate) {
        if (!forceUpdate && !this.updateEnabled) {
            return;
        }
        this.update();
    }

    @Override
    public void setUpdateEnabled(boolean b) {
        this.updateEnabled = b;
    }

    @Override
    public void deIconified() {
    }

    void setFields(String oldText) {
        TrackiInfo info = (TrackiInfo)this.jComboBox1.getSelectedItem();
        if (oldText != null && oldText.length() != 0) {
            for (int i = 0; i < this.persistentInfo.size(); ++i) {
                if (!this.persistentInfo.elementAt((int)i).name.equals(oldText)) continue;
                info = this.persistentInfo.elementAt(i);
                ++this.mClassSetting;
                this.jComboBox1.setSelectedIndex(i);
                --this.mClassSetting;
                break;
            }
        }
        this.jTextField5.setText(info.name);
        this.jTextField3.setText("$" + String.format("%04X", info.start & 0xFFFF));
        this.jTextField4.setText("$" + String.format("%04X", info.end & 0xFFFF));
        this.jTextField7.setText("" + info.bank);
        this.baseline = info.baseline;
    }

    void searchAndSetWR() {
        int lowerStart;
        boolean found = false;
        if (this.auto_adrLower == 61842) {
            this.auto_adrLower = 0;
            this.auto_adrHigher = 1;
            this.auto_bank = 0;
        }
        int bStart = this.auto_bank;
        int lowerRealStart = lowerStart = this.auto_adrHigher;
        if (this.vecxPanel == null) {
            return;
        }
        Cartridge cart = this.vecxPanel.getCartridge();
        if (cart == null) {
            return;
        }
        for (int b = this.auto_bank; b < cart.getBankCount(); ++b) {
            int bSize = cart.getBankSize(b);
            for (int a = lowerStart + 1; a < bSize; ++a) {
                int aByte1 = cart.readByteDirect(a + 0, b);
                int aByte2 = cart.readByteDirect(a + 1, b);
                int aByte3 = cart.readByteDirect(a + 2, b);
                int aByte4 = cart.readByteDirect(a + 3, b);
                if (aByte1 != 149 || aByte2 != 13 || aByte3 != 39 || aByte4 != 252) continue;
                int MAXBACK = 20;
                for (int aa = a - MAXBACK; aa != a; ++aa) {
                    if (aa < 0) continue;
                    int aaByte1 = cart.readByteDirect(aa + 0, b);
                    int aaByte2 = cart.readByteDirect(aa + 1, b);
                    if (aaByte1 != 134 || aaByte2 != 32) continue;
                    found = true;
                    this.auto_adrLower = aa;
                    this.auto_adrHigher = a + 4;
                    this.auto_bank = b;
                    break;
                }
                if (found) break;
            }
            lowerStart = -1;
            if (found) break;
        }
        if (!found) {
            this.auto_adrHigher = 61858;
            this.auto_adrLower = 61842;
            this.auto_bank = 0;
        }
        if (found) {
            this.oldFound = true;
        }
        this.jTextField3.setText("$" + String.format("%04X", this.auto_adrHigher & 0xFFFF));
        this.jTextField4.setText("$" + String.format("%04X", this.auto_adrLower & 0xFFFF));
        this.jTextField7.setText("" + this.auto_bank);
        this.jButton1ActionPerformed(null);
    }

    public static class TrackiInfo
    implements Serializable {
        int baseline = 30000;
        int start;
        int end;
        int bank;
        String name;

        public String toString() {
            return this.name;
        }

        public boolean equals(TrackiInfo other) {
            return this.name.equals(other.name);
        }
    }
}

