/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vecx.parts;

public class Capacitorial {
    private double resistorOhm;
    private double capacitorFarad;
    private double currentVoltage = 0.0;
    private double supplyVoltage = 0.0;
    private double timeConstant;
    private double percentageDifChangePerCycle;
    private static double VECTREX_CYCLE_TIME = 6.666666666666667E-7;

    public Capacitorial(double r, double c) {
        this.resistorOhm = r;
        this.capacitorFarad = c;
        this.timeConstant = r * c;
        this.percentageDifChangePerCycle = Math.exp(-VECTREX_CYCLE_TIME / this.timeConstant);
    }

    public void doStep() {
        boolean charging = Math.abs(this.currentVoltage) < Math.abs(this.supplyVoltage);
        double dif = this.supplyVoltage - this.currentVoltage;
        this.currentVoltage = charging ? (this.currentVoltage += this.percentageDifChangePerCycle * dif) : (this.currentVoltage -= this.percentageDifChangePerCycle * dif);
    }

    public void setDigitalVoltage(int v) {
        this.supplyVoltage = v >= 0 ? (double)v / 127.0 * 5.0 : (double)v / 128.0 * 5.0;
    }
}

