/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortEvent;
import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.config.TinyLogInterface;
import de.malban.gui.dialogs.InternalFrameFileChoser;
import de.malban.gui.dialogs.QuickHelpTopFrame;
import de.malban.gui.panels.LogPanel;
import de.malban.util.KeyboardListener;
import de.malban.util.UtilityFiles;
import de.malban.util.UtilityString;
import de.malban.util.syntax.Syntax.TokenStyles;
import de.malban.vide.PiTrex.PiTrexEvent;
import de.malban.vide.PiTrex.PiTrexListenerInterface;
import de.malban.vide.PiTrex.PiTrexSingleton;
import de.malban.vide.VideConfig;
import de.malban.vide.dissy.DASM6809;
import de.malban.vide.dissy.DissiPanel;
import de.malban.vide.vedi.EditorEvent;
import de.malban.vide.vedi.VEdiFoundationPanel;
import de.malban.vide.vedi.VediSettings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.StyleConstants;

public class PiTrexTerminal
extends VEdiFoundationPanel
implements TinyLogInterface {
    VideConfig config = VideConfig.getConfig();
    LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    Path currentStartPath = Paths.get(Global.mainPathPrefix, new String[0]);
    private String lastPath = "";
    public static int scanCount = 0;
    boolean init = false;
    PiTrexSingleton pi = null;
    boolean loadSettings = true;
    public static String SID = "PiTrexTerminal";
    final int TAB_EQU = 30;
    final int TAB_EQU_VALUE = 40;
    final int TAB_MNEMONIC = 20;
    final int TAB_OP = 30;
    final int TAB_COMMENT = 58;
    boolean fileView = true;
    private JButton jButton8;
    private JButton jButtonDumpRom;
    private JButton jButtonReset;
    private JEditorPane jEditorLog;
    private JLabel jLabel10;
    private JMenuItem jMenuItemAction;
    private JMenuItem jMenuItemDelete;
    private JMenuItem jMenuItemDuplicate;
    private JMenuItem jMenuItemFileProperties;
    private JMenuItem jMenuItemModi;
    private JMenuItem jMenuItemNewFile;
    private JMenuItem jMenuItemRaster;
    private JMenuItem jMenuItemRename;
    private JMenuItem jMenuItemVector;
    private JMenuItem jMenuItemYM;
    private JMenu jMenuNewFileMenu;
    private JPanel jPanel1;
    private JPopupMenu jPopupMenu1;
    private JPopupMenu jPopupMenuTree;
    private JScrollPane jScrollPane2;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JTabbedPane jTabbedPane;
    Point pos = new Point(0, 0);
    private PropertyChangeListener pListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PiTrexTerminal.this.updateMyUI();
        }
    };
    StringBuilder fromCard = new StringBuilder();
    PiTrexListenerInterface listener = new PiTrexListenerInterface(){

        @Override
        public synchronized void piTrexEvent(PiTrexEvent e) {
            if (e.type == 1) {
                PiTrexTerminal piTrexTerminal = PiTrexTerminal.this;
                if (piTrexTerminal.pi.getPiTrex().isReady()) {
                    PiTrexTerminal.this.jLabel10.setText("connected");
                    PiTrexTerminal.this.jLabel10.setForeground(PiTrexTerminal.this.config.valueNotChanged);
                } else {
                    PiTrexTerminal.this.jLabel10.setText("not connected");
                    PiTrexTerminal.this.jLabel10.setForeground(PiTrexTerminal.this.config.valueChanged);
                }
                return;
            }
            SerialPortEvent event = e.se;
            SerialPort comPort = event.getSerialPort();
            int available = comPort.bytesAvailable();
            if (available < 0) {
                return;
            }
            byte[] newData = new byte[available];
            int numRead = comPort.readBytes(newData, (long)newData.length);
            for (byte d : newData) {
                PiTrexTerminal.this.fromCard.append((char)d);
            }
            if (PiTrexTerminal.this.jEditorLog.getDocument().getLength() > 400000) {
                PiTrexTerminal.this.jEditorLog.setText("");
            }
            try {
                PiTrexTerminal.this.jEditorLog.getDocument().insertString(PiTrexTerminal.this.jEditorLog.getDocument().getLength(), PiTrexTerminal.this.fromCard.toString() + "", TokenStyles.getStyle("editLogMessage"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            PiTrexTerminal.this.fromCard = new StringBuilder();
            PiTrexTerminal.this.jEditorLog.setCaretPosition(PiTrexTerminal.this.jEditorLog.getDocument().getLength());
        }
    };
    byte typed = 0;

    @Override
    public boolean isLoadSettings() {
        return this.loadSettings;
    }

    public PiTrexTerminal() {
        this(true);
    }

    public PiTrexTerminal(boolean ls) {
        this.initComponents();
        this.jMenuItemVector.setVisible(false);
        this.loadSettings = ls;
        this.jEditorLog.setContentType("text/html");
        this.init();
        PiTrexTerminal piTrexTerminal = this;
        if (piTrexTerminal.pi.getPiTrex().isReady()) {
            this.jLabel10.setText("connected");
            this.jLabel10.setForeground(this.config.valueNotChanged);
        } else {
            this.jLabel10.setText("not connected");
            this.jLabel10.setForeground(this.config.valueChanged);
        }
        UIManager.addPropertyChangeListener(this.pListener);
        this.updateMyUI();
    }

    @Override
    public void deinit() {
        this.pi.removeListener(this.listener);
        this.jLabel10.setText("not connected");
        this.jLabel10.setForeground(this.config.valueChanged);
        this.saveSettings();
        this.init = false;
        this.removeUIListerner();
    }

    @Override
    public String getSettingsName() {
        return "PiTrexTerminal.ser";
    }

    @Override
    protected boolean saveSettings() {
        return super.saveSettings();
    }

    @Override
    public String getID() {
        return SID;
    }

    @Override
    public String getFileID() {
        return UtilityString.replace(UtilityString.replace(UtilityString.replace(UtilityString.replaceWhiteSpaces(SID, ""), ":", ""), "(", ""), ")", "");
    }

    @Override
    public void init() {
        this.pi = PiTrexSingleton.getPiTrex();
        this.pi.addListener(this.listener);
        Object lastLoadedFile = null;
        if (this.loadSettings()) {
            this.setFontSize(this.settings.fontSize);
            if (this.isLoadSettings()) {
                // empty if block
            }
        } else {
            this.settings = new VediSettings();
        }
        this.init = true;
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.jMenuNewFileMenu = new JMenu();
        this.jMenuItemNewFile = new JMenuItem();
        this.jPopupMenuTree = new JPopupMenu();
        this.jMenuItemFileProperties = new JMenuItem();
        this.jMenuItemAction = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jMenuItemModi = new JMenuItem();
        this.jMenuItemYM = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.jMenuItemRaster = new JMenuItem();
        this.jMenuItemVector = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.jMenuItemDelete = new JMenuItem();
        this.jMenuItemRename = new JMenuItem();
        this.jMenuItemDuplicate = new JMenuItem();
        this.jPanel1 = new JPanel();
        this.jButton8 = new JButton();
        this.jButtonDumpRom = new JButton();
        this.jTabbedPane = new JTabbedPane();
        this.jScrollPane2 = new JScrollPane();
        this.jEditorLog = new JEditorPane();
        this.jLabel10 = new JLabel();
        this.jButtonReset = new JButton();
        this.jPopupMenu1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                PiTrexTerminal.this.jPopupMenu1MouseExited(evt);
            }
        });
        this.jMenuNewFileMenu.setText("new file");
        this.jMenuItemNewFile.setText("new empty file");
        this.jMenuItemNewFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PiTrexTerminal.this.jMenuItemNewFileActionPerformed(evt);
            }
        });
        this.jMenuNewFileMenu.add(this.jMenuItemNewFile);
        this.jPopupMenu1.add(this.jMenuNewFileMenu);
        this.jPopupMenuTree.setEnabled(false);
        this.jMenuItemFileProperties.setText("Properties");
        this.jMenuItemFileProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PiTrexTerminal.this.jMenuItemFilePropertiesActionPerformed(evt);
            }
        });
        this.jPopupMenuTree.add(this.jMenuItemFileProperties);
        this.jMenuItemAction.setText("execute action");
        this.jMenuItemAction.setToolTipText("execute the configured action (if any)");
        this.jMenuItemAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PiTrexTerminal.this.jMenuItemActionActionPerformed(evt);
            }
        });
        this.jPopupMenuTree.add(this.jMenuItemAction);
        this.jPopupMenuTree.add(this.jSeparator1);
        this.jMenuItemModi.setText("build vectrex mod");
        this.jMenuItemModi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PiTrexTerminal.this.jMenuItemModiActionPerformed(evt);
            }
        });
        this.jPopupMenuTree.add(this.jMenuItemModi);
        this.jMenuItemYM.setText("build vectrex YM");
        this.jMenuItemYM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PiTrexTerminal.this.jMenuItemYMActionPerformed(evt);
            }
        });
        this.jPopupMenuTree.add(this.jMenuItemYM);
        this.jPopupMenuTree.add(this.jSeparator3);
        this.jMenuItemRaster.setText("convert image to vectrex raster");
        this.jMenuItemRaster.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PiTrexTerminal.this.jMenuItemRasterActionPerformed(evt);
            }
        });
        this.jPopupMenuTree.add(this.jMenuItemRaster);
        this.jMenuItemVector.setText("convert image to vector");
        this.jMenuItemVector.setToolTipText("");
        this.jMenuItemVector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PiTrexTerminal.this.jMenuItemVectorActionPerformed(evt);
            }
        });
        this.jPopupMenuTree.add(this.jMenuItemVector);
        this.jPopupMenuTree.add(this.jSeparator2);
        this.jMenuItemDelete.setText("Delete");
        this.jMenuItemDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PiTrexTerminal.this.jMenuItemDeleteActionPerformed(evt);
            }
        });
        this.jPopupMenuTree.add(this.jMenuItemDelete);
        this.jMenuItemRename.setText("Rename");
        this.jMenuItemRename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PiTrexTerminal.this.jMenuItemRenameActionPerformed(evt);
            }
        });
        this.jPopupMenuTree.add(this.jMenuItemRename);
        this.jMenuItemDuplicate.setText("Duplicate");
        this.jMenuItemDuplicate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PiTrexTerminal.this.jMenuItemDuplicateActionPerformed(evt);
            }
        });
        this.jPopupMenuTree.add(this.jMenuItemDuplicate);
        this.setName("regi");
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setPreferredSize(new Dimension(946, 645));
        this.jButton8.setText("connect");
        this.jButton8.setToolTipText("<html>\nConnect to Vectrex 32 using the given parameters<BR>\nSHIFT -> disconnect.\n</html>\n");
        this.jButton8.setPreferredSize(new Dimension(71, 21));
        this.jButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PiTrexTerminal.this.jButton8ActionPerformed(evt);
            }
        });
        this.jButtonDumpRom.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_go.png")));
        this.jButtonDumpRom.setToolTipText("Dump a ROM to PiTrex (must be in Vectrex-Exact)");
        this.jButtonDumpRom.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonDumpRom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PiTrexTerminal.this.jButtonDumpRomActionPerformed(evt);
            }
        });
        this.jTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                PiTrexTerminal.this.jTabbedPaneStateChanged(evt);
            }
        });
        this.jEditorLog.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PiTrexTerminal.this.jEditorLogMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                PiTrexTerminal.this.jEditorLogMousePressed(evt);
            }
        });
        this.jEditorLog.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                PiTrexTerminal.this.jEditorLogKeyTyped(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jEditorLog);
        this.jTabbedPane.addTab("Terminal", this.jScrollPane2);
        this.jLabel10.setForeground(new Color(255, 0, 0));
        this.jLabel10.setText("not connected");
        this.jLabel10.setPreferredSize(new Dimension(69, 21));
        this.jButtonReset.setText("reset PiTrex");
        this.jButtonReset.setToolTipText("<html>\nConnect to Vectrex 32 using the given parameters<BR>\nSHIFT -> disconnect.\n</html>\n");
        this.jButtonReset.setPreferredSize(new Dimension(71, 21));
        this.jButtonReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PiTrexTerminal.this.jButtonResetActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonDumpRom).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 455, Short.MAX_VALUE).addComponent(this.jButtonReset, -2, 110, -2).addGap(29, 29, 29).addComponent(this.jButton8, -2, 81, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel10, -2, 133, -2)).addComponent(this.jTabbedPane, -2, 0, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonDumpRom).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10, -2, 21, -2).addComponent(this.jButton8, -2, -1, -2).addComponent(this.jButtonReset, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPane, -1, 383, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, 837, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jPanel1, -1, 414, Short.MAX_VALUE).addGap(2, 2, 2)));
    }

    private void jButtonDumpRomActionPerformed(ActionEvent evt) {
        if (!this.pi.isReady()) {
            return;
        }
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        if (!this.config.useLastKnownDir || this.lastPath == null || this.lastPath.length() == 0) {
            fc.setCurrentDirectory(new File(this.config.fileRequestHome));
        } else {
            fc.setCurrentDirectory(new File(this.lastPath));
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Rom (bin, rom, vec)", "bin", "rom", "vec");
        fc.setFileFilter(filter);
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return;
        }
        String name = fc.getSelectedFile().getAbsolutePath();
        this.lastPath = new File(name).getAbsolutePath();
        this.pi.fileToPiTrex(name);
    }

    int spaceTo(StringBuilder s, int posNow, int upTo) {
        s.append(" ");
        while (true) {
            int n = ++posNow;
            ++posNow;
            if (n >= upTo) break;
            s.append(" ");
        }
        return posNow;
    }

    String prettyQuoteLine(String line) {
        int endQuote;
        String quoteChar = "\"";
        int startQuote = line.indexOf("\"");
        if (line.indexOf("'") > startQuote) {
            quoteChar = "'";
            startQuote = line.indexOf("'");
        }
        if ((endQuote = line.lastIndexOf(quoteChar)) <= startQuote) {
            return line;
        }
        String preQuote = line.substring(0, startQuote);
        String quote = line.substring(startQuote, endQuote + 1);
        String postQuote = line.substring(endQuote + 1);
        StringBuilder b = new StringBuilder();
        String[] words = preQuote.split(" ");
        int w = 0;
        int c = 0;
        if (!UtilityString.isWordBoundry(line.charAt(0))) {
            b.append(words[w]).append(" ");
            c += words[w].length() + 1;
            ++w;
        }
        c = this.spaceTo(b, c, 20);
        if (w >= words.length) {
            b.append(quote);
            c += quote.length();
            c = this.spaceTo(b, c, 30);
            b.append(postQuote);
            return b.toString();
        }
        while (words[w].length() == 0) {
            ++w;
        }
        b.append(words[w]).append(" ");
        c += words[w].length() + 1;
        ++w;
        c = this.spaceTo(b, c, 30);
        while (w < words.length) {
            if (words[w].length() != 0) {
                b.append(words[w]).append(" ");
                c += words[w].length() + 1;
            }
            ++w;
        }
        b.append(quote);
        c += quote.length();
        b.append(postQuote);
        return b.toString();
    }

    int getFirstnonQuoteComment(String line) {
        int endQuote;
        String quoteChar = "\"";
        int startQuote = line.indexOf("\"");
        if (line.indexOf("'") > startQuote) {
            quoteChar = "'";
            startQuote = line.indexOf("'");
        }
        if ((endQuote = line.lastIndexOf(quoteChar)) <= startQuote) {
            return -1;
        }
        String preQuote = line.substring(0, startQuote);
        String quote = line.substring(startQuote, endQuote + 1);
        String postQuote = line.substring(endQuote + 1);
        int ind = postQuote.indexOf(";");
        if (ind == -1) {
            return -1;
        }
        return ind + preQuote.length() + quote.length();
    }

    private void jMenuItemNewFileActionPerformed(ActionEvent evt) {
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        if (this.lastPath.length() == 0) {
            this.lastPath = "";
        }
        if (!this.config.useLastKnownDir || this.lastPath == null || this.lastPath.length() == 0) {
            fc.setCurrentDirectory(new File(this.config.fileRequestHome));
        } else {
            fc.setCurrentDirectory(new File(this.lastPath));
        }
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return;
        }
        this.lastPath = fc.getSelectedFile().getAbsolutePath();
        File newFile = new File(this.lastPath);
        if (newFile.exists()) {
            int answer = JOptionPane.showOptionDialog(Configuration.getConfiguration().getMainFrame(), "The file already exists, do you really want\nto create a new file?\n\nAll previous data will be lost!", "File exists", 2, 2, null, null, null);
            if (answer == 0) {
                System.out.println("YES");
            } else {
                System.out.println("NO");
                return;
            }
        }
        UtilityFiles.createTextFile(this.lastPath, "");
    }

    public void addTempEditFile(String filePath) {
    }

    private void jPopupMenu1MouseExited(MouseEvent evt) {
        this.jPopupMenu1.setVisible(false);
    }

    private void jMenuItemFilePropertiesActionPerformed(ActionEvent evt) {
    }

    private void jMenuItemModiActionPerformed(ActionEvent evt) {
    }

    private void jTabbedPaneStateChanged(ChangeEvent evt) {
    }

    private void jMenuItemRenameActionPerformed(ActionEvent evt) {
    }

    private void jMenuItemDeleteActionPerformed(ActionEvent evt) {
    }

    private void jMenuItemDuplicateActionPerformed(ActionEvent evt) {
    }

    private void jMenuItemActionActionPerformed(ActionEvent evt) {
    }

    private void jMenuItemRasterActionPerformed(ActionEvent evt) {
    }

    private void jMenuItemYMActionPerformed(ActionEvent evt) {
    }

    private void jMenuItemVectorActionPerformed(ActionEvent evt) {
    }

    private void jEditorLogKeyTyped(KeyEvent evt) {
        this.handleTerminalKey(evt.getKeyChar());
    }

    private void jEditorLogMousePressed(MouseEvent evt) {
    }

    private void jEditorLogMouseClicked(MouseEvent evt) {
        this.pos = this.getCursorPos();
    }

    private void jButton8ActionPerformed(ActionEvent evt) {
        if (KeyboardListener.is_ShiftDown()) {
            this.pi.disconnect();
        } else {
            this.pi.rescanConnect();
        }
    }

    private void jButtonResetActionPerformed(ActionEvent evt) {
        if (!this.pi.resetPi()) {
            this.printError("Reset failed, see log for more information.");
        }
    }

    public boolean doCalculator(String command) {
        try {
            Double d = DissiPanel.eval(command);
            int i = d.intValue();
            if (i < 256 && i > -128) {
                this.printMessage("Result: " + i + ", $" + String.format("%02X", i & 0xFF) + ", " + DASM6809.printbinary(i));
            } else {
                this.printMessage("Result: " + i + ", $" + String.format("%X", i) + ", " + DASM6809.printbinary16(i));
            }
        }
        catch (Throwable x) {
            return false;
        }
        return true;
    }

    public String getLine(JEditorPane comp, int pos) {
        try {
            String[] s = comp.getDocument().getText(0, comp.getDocument().getLength()).split("\n");
            return s[pos];
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    int getLineOfPos(JEditorPane comp, int pos) {
        int ret = -1;
        try {
            String[] lines = comp.getDocument().getText(0, comp.getDocument().getLength()).split("\n");
            int c = -1;
            for (int count = 0; count <= pos; count += lines[++c].length() + 1) {
            }
            if (c < lines.length) {
                ret = c;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    public void editorChanged(EditorEvent ev) {
        this.tabChanged(false);
    }

    boolean isPrintable(byte c) {
        String test = "abcdefghijklmnopqrstuvwxyz1234567890\u00f6\u00e4\u00fc\u00df!\"\u00a7$%&/()=?#'@\u20ac^\u00b0`*+,.-;:_|<>";
        String t = "" + (char)c;
        return test.contains(t.toLowerCase());
    }

    public Point getCursorPos() {
        String[] splitter;
        Point p = new Point(1, 1);
        try {
            splitter = this.jEditorLog.getDocument().getText(0, this.jEditorLog.getDocument().getLength()).split("\n");
        }
        catch (Throwable e) {
            return p;
        }
        int pos = this.jEditorLog.getCaretPosition();
        int count = 0;
        for (String split : splitter) {
            if (count + split.length() >= pos) {
                p.x = pos - count + 1;
                break;
            }
            count += split.length();
            ++count;
            ++p.y;
        }
        return p;
    }

    void setFontSize(int fs) {
        ArrayList<TokenStyles.MyStyle> cloneStyleList = TokenStyles.styleList;
        TokenStyles.reset();
        this.settings.fontSize = fs;
        for (TokenStyles.MyStyle style : cloneStyleList) {
            TokenStyles.addStyle(style.name, StyleConstants.getBackground(style), StyleConstants.getForeground(style), StyleConstants.isBold(style), StyleConstants.isItalic(style), this.settings.fontSize, StyleConstants.getFontFamily(style));
        }
    }

    public void removeUIListerner() {
        UIManager.removePropertyChangeListener(this.pListener);
    }

    void updateMyUI() {
        SwingUtilities.updateComponentTreeUI(this.jPopupMenu1);
        SwingUtilities.updateComponentTreeUI(this.jPopupMenuTree);
    }

    @Override
    public void deIconified() {
    }

    @Override
    public void printMessageSU(final String s) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PiTrexTerminal.this.printMessage(s);
            }
        });
    }

    @Override
    public void printWarningSU(final String s) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PiTrexTerminal.this.printWarning(s);
            }
        });
    }

    @Override
    public void printErrorSU(final String s) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PiTrexTerminal.this.printError(s);
            }
        });
    }

    public static boolean displayHelp(String h) {
        h = h.toLowerCase();
        String path = Global.mainPathPrefix + "help" + File.separator;
        String full = path + h + ".html";
        File f = new File(full);
        if (!f.exists()) {
            full = path + h + ".htm";
        }
        if ((f = new File(full)).exists()) {
            QuickHelpTopFrame.showHelpHtmlFile(full);
            return true;
        }
        full = path + h + ".png";
        f = new File(full);
        if (f.exists()) {
            QuickHelpTopFrame.showHelpPNGFile(full);
            return true;
        }
        return false;
    }

    @Override
    public void printMessage(String s) {
        try {
            this.jEditorLog.getDocument().insertString(this.jEditorLog.getDocument().getLength(), s + "\n", TokenStyles.getStyle("editLogMessage"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.jEditorLog.setCaretPosition(this.jEditorLog.getDocument().getLength());
    }

    @Override
    public void printWarning(String s) {
        try {
            this.jEditorLog.getDocument().insertString(this.jEditorLog.getDocument().getLength(), s + "\n", TokenStyles.getStyle("editLogWarning"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.jEditorLog.setCaretPosition(this.jEditorLog.getDocument().getLength());
    }

    @Override
    public void printError(String s) {
        try {
            this.jEditorLog.getDocument().insertString(this.jEditorLog.getDocument().getLength(), s + "\n", TokenStyles.getStyle("editLogError"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.jEditorLog.setCaretPosition(this.jEditorLog.getDocument().getLength());
    }

    @Override
    public void printASMList(String s, int type) {
    }

    @Override
    public void printASMMessage(String s, int type) {
    }

    @Override
    protected boolean closeRequested(String tabName) {
        return true;
    }

    @Override
    public void doQuickHelp(String word, String integer) {
        if (!PiTrexTerminal.displayHelp(word)) {
            this.doCalculator(integer);
        }
    }

    @Override
    public void tabChanged(boolean b) {
    }

    @Override
    public void changeFileName(String s, String f2) {
    }

    @Override
    public void processIncludeLine(String s) {
    }

    @Override
    public void processWord(String s) {
    }

    @Override
    public void requestSearchFocus() {
    }

    @Override
    protected void deselectInTree(String name) {
    }

    @Override
    public void run() {
    }

    @Override
    public void debug() {
    }

    void handleTerminalKey(char t) {
        if (!this.pi.isReady()) {
            return;
        }
        if (t >= ' ' && t <= '~' || t == '\n') {
            this.typed = (byte)t;
            if (this.pi.getActiveSerialPort() != null) {
                byte[] buffer = new byte[]{this.typed};
                this.pi.getActiveSerialPort().writeBytes(buffer, 1L);
                if (this.typed == 3) {
                    buffer[0] = 10;
                    this.pi.getActiveSerialPort().writeBytes(buffer, 1L);
                }
            }
        }
        this.pos = this.getCursorPos();
    }
}

