/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi;

import com.fazecast.jSerialComm.SerialPort;
import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.config.TinyLogInterface;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.HotKey;
import de.malban.gui.TimingTriggerer;
import de.malban.gui.TriggerCallback;
import de.malban.gui.dialogs.InternalFrameFileChoser;
import de.malban.gui.dialogs.QuickHelpTopFrame;
import de.malban.gui.panels.LogPanel;
import de.malban.util.Utility;
import de.malban.util.UtilityFiles;
import de.malban.util.UtilityString;
import de.malban.util.syntax.Syntax.TokenStyles;
import de.malban.util.syntax.entities.ASM6809FileMaster;
import de.malban.util.syntax.entities.C6809FileMaster;
import de.malban.util.syntax.entities.EntityDefinition;
import de.malban.util.syntax.entities.SyntaxDebugJPanel;
import de.malban.vide.PiTrex.PiTrexSingleton;
import de.malban.vide.VideConfig;
import de.malban.vide.assy.Asmj;
import de.malban.vide.assy.Comment;
import de.malban.vide.dissy.DASM6809;
import de.malban.vide.dissy.DissiPanel;
import de.malban.vide.script.ExecutionDescriptor;
import de.malban.vide.script.ScriptDataPanel;
import de.malban.vide.vecx.VecXPanel;
import de.malban.vide.vecx.cartridge.Cartridge;
import de.malban.vide.vecx.cartridge.CartridgeProperties;
import de.malban.vide.vedi.Bookmark;
import de.malban.vide.vedi.CloseButton;
import de.malban.vide.vedi.CustomOutputStream;
import de.malban.vide.vedi.DebugComment;
import de.malban.vide.vedi.DebugCommentList;
import de.malban.vide.vedi.DebugInfoC;
import de.malban.vide.vedi.EditorEvent;
import de.malban.vide.vedi.EditorFileSettings;
import de.malban.vide.vedi.EditorListener;
import de.malban.vide.vedi.EditorPanel;
import de.malban.vide.vedi.VEdiFoundationPanel;
import de.malban.vide.vedi.VediSettings;
import de.malban.vide.vedi.panels.BinaryPanel;
import de.malban.vide.vedi.panels.GetIDValuePanel;
import de.malban.vide.vedi.panels.ImagePanel;
import de.malban.vide.vedi.panels.LabelVisibilityConfigPanel;
import de.malban.vide.vedi.peeper.FilePeeper;
import de.malban.vide.vedi.project.FileProperties;
import de.malban.vide.vedi.project.FilePropertiesPanel;
import de.malban.vide.vedi.project.FilePropertiesPool;
import de.malban.vide.vedi.project.ProjectProperties;
import de.malban.vide.vedi.project.ProjectPropertiesPanel;
import de.malban.vide.vedi.project.ProjectPropertiesPool;
import de.malban.vide.vedi.raster.RasterPanel;
import de.malban.vide.vedi.raster.VectorJPanel;
import de.malban.vide.vedi.sound.AKSBin;
import de.malban.vide.vedi.sound.ModJPanel;
import de.malban.vide.vedi.sound.SampleJPanel;
import de.malban.vide.vedi.sound.VecSpeechPanel;
import de.malban.vide.vedi.sound.YMJPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.StyleConstants;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class VediPanel
extends VEdiFoundationPanel
implements TinyLogInterface,
EditorListener {
    public static String SID = "Source Editor";
    VideConfig config = VideConfig.getConfig();
    LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    String oneTimeTab = null;
    boolean tabChangeNotAllowed = false;
    public static int scanCount = 0;
    boolean init = false;
    boolean inProject = false;
    ProjectProperties currentProject = null;
    DefaultListModel projectsListModel;
    DefaultListModel filesListModel;
    boolean loadSettings = true;
    BookmarkTableModel bookmarkModel = new BookmarkTableModel();
    int currentBookmark = -1;
    ArrayList<InventoryEntry> inventory = new ArrayList();
    InventoryTableModel inventoryModel = new InventoryTableModel();
    TableRowSorter<TableModel> sorter;
    WatchesTableModel watchesModel = new WatchesTableModel();
    BreakpointTableModel breakpointModel = new BreakpointTableModel();
    String possibleProject = null;
    TreeEntry selectedTreeEntry = null;
    TreePath selectedTreePath = null;
    DefaultMutableTreeNode root = null;
    static ArrayList<VediPanel> listVedi = new ArrayList();
    Path currentStartPath = Paths.get(".", new String[0]);
    int startTypeRun = 2;
    private DefaultTreeCellEditor editor;
    private TreeEntry currentSelectedTreeLeaf = null;
    private String lastPath = "";
    Thread one = null;
    public boolean asmStarted = false;
    public boolean stop = false;
    public boolean running = false;
    public boolean pausing = false;
    boolean fileView = false;
    int popupRow = -1;
    private JButton jButtonAdressBack;
    private JButton jButtonAdressForward;
    JButton jButtonAssemble;
    private JButton jButtonAssembleOne;
    private JButton jButtonAssembleOne1;
    private JButton jButtonAssembleOne2;
    private JButton jButtonAssembleOne3;
    private JButton jButtonAssembleOne4;
    private JButton jButtonAssembleOne5;
    private JButton jButtonClearMessages;
    private JButton jButtonCopy;
    private JButton jButtonCut;
    JButton jButtonDebug;
    private JButton jButtonDebugSyntax;
    private JButton jButtonFontMinus;
    private JButton jButtonFontPlus;
    private JButton jButtonIgnoreCase;
    private JButton jButtonInjectBin;
    private JButton jButtonLabelConfig;
    private JButton jButtonLoad;
    private JButton jButtonNew;
    private JButton jButtonNew1;
    private JButton jButtonNew7;
    private JButton jButtonPaste;
    private JButton jButtonPrettyPrint;
    private JButton jButtonRedo;
    private JButton jButtonRefresh;
    private JButton jButtonReplaceAll;
    private JButton jButtonReplaceInSelection;
    private JButton jButtonReplaceNext;
    private JButton jButtonSave;
    private JButton jButtonSaveAll;
    private JButton jButtonSearchNext;
    private JButton jButtonSearchPrevious;
    private JButton jButtonUndo;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBoxIgnoreCase;
    private JCheckBox jCheckBoxPiTrex;
    private JCheckBox jCheckBoxVecFever;
    private JEditorPane jEditorASMMessages;
    private JEditorPane jEditorLog;
    private JEditorPane jEditorPaneASMListing;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel9;
    private JList jListFiles;
    private JList jListProjects;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem1AddNewFile;
    private JMenuItem jMenuItemAKS;
    private JMenuItem jMenuItemASFX;
    private JMenuItem jMenuItemAction;
    private JMenuItem jMenuItemAddToProject;
    private JMenuItem jMenuItemCFile;
    private JMenuItem jMenuItemClose;
    private JMenuItem jMenuItemDelete;
    private JMenuItem jMenuItemDuplicate;
    private JMenuItem jMenuItemFileProperties;
    private JMenuItem jMenuItemModi;
    private JMenuItem jMenuItemNewFile;
    private JMenuItem jMenuItemNewProject;
    private JMenuItem jMenuItemProjectProperties;
    private JMenuItem jMenuItemRaster;
    private JMenuItem jMenuItemRefresh;
    private JMenuItem jMenuItemRemoveBM;
    private JMenuItem jMenuItemRemoveBP;
    private JMenuItem jMenuItemRemoveWatch;
    private JMenuItem jMenuItemRename;
    private JMenuItem jMenuItemSample;
    private JMenuItem jMenuItemSetMain;
    private JMenuItem jMenuItemVecSpeech;
    private JMenuItem jMenuItemVector;
    private JMenuItem jMenuItemVectrexFile;
    private JMenuItem jMenuItemYM;
    private JMenu jMenuNewFileMenu;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JPopupMenu jPopupMenu1;
    private JPopupMenu jPopupMenuBM;
    private JPopupMenu jPopupMenuBP;
    private JPopupMenu jPopupMenuProjectProperties;
    private JPopupMenu jPopupMenuTree;
    private JPopupMenu jPopupMenuWatch;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane10;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JScrollPane jScrollPane7;
    private JScrollPane jScrollPane8;
    private JScrollPane jScrollPane9;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JSplitPane jSplitPane3;
    private JSplitPane jSplitPane4;
    private JTabbedPane jTabbedPane;
    private JTabbedPane jTabbedPane1;
    private JTabbedPane jTabbedPane2;
    private JTabbedPane jTabbedPane3;
    private JTable jTableBookmarks;
    private JTable jTableBreakpoints;
    private JTable jTableInventory;
    private JTable jTableWatches;
    private JTextField jTextFieldCommand;
    private JTextField jTextFieldReplace;
    private JTextField jTextFieldSearch;
    private JTree jTree1;
    public static final int DIR = 0;
    public static final int FILE = 1;
    public boolean projectLoaded = true;
    private static HashMap<String, String> biosMap = null;
    private static HashMap<String, Integer> biosFileMap = null;
    private PropertyChangeListener pListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            VediPanel.this.updateMyUI();
        }
    };
    boolean invUpdating = false;
    ArrayList<HistoryEntry> history = new ArrayList();
    int historyPosition = 0;
    private Object syncObject = new Object();
    private TimingTriggerer timer = null;
    private TriggerCallback timerWorker = null;
    static boolean isMac = Global.getOSName().toUpperCase().contains("MAC");
    static boolean isWin = Global.getOSName().toUpperCase().contains("WIN");
    static boolean isLinux = Global.getOSName().toUpperCase().contains("LIN");
    boolean peepAtASM = true;
    final int CNT_UNKOWN = 0;
    final int CNT_CODE = 1;
    final int CNT_DATA_WORD = 2;
    final int CNT_DATA_BYTE = 3;
    final int CNT_DATA_CHAR = 4;

    public void updateTables() {
        int i;
        this.jTableBreakpoints.tableChanged(null);
        this.jTableBookmarks.tableChanged(null);
        this.jTableWatches.tableChanged(null);
        this.jTableBreakpoints.repaint();
        this.jTableBookmarks.repaint();
        this.jTableWatches.repaint();
        this.jTableBookmarks.setAutoResizeMode(3);
        for (i = 0; i < this.bookmarkModel.getColumnCount(); ++i) {
            this.jTableBookmarks.getColumnModel().getColumn(i).setPreferredWidth(this.bookmarkModel.getColWidth(i));
            this.jTableBookmarks.getColumnModel().getColumn(i).setWidth(this.bookmarkModel.getColWidth(i));
        }
        this.jTableBookmarks.setAutoResizeMode(2);
        this.jTableBreakpoints.setAutoResizeMode(3);
        for (i = 0; i < this.breakpointModel.getColumnCount(); ++i) {
            this.jTableBreakpoints.getColumnModel().getColumn(i).setPreferredWidth(this.breakpointModel.getColWidth(i));
            this.jTableBreakpoints.getColumnModel().getColumn(i).setWidth(this.breakpointModel.getColWidth(i));
        }
        this.jTableBreakpoints.setAutoResizeMode(2);
        this.jTableWatches.setAutoResizeMode(3);
        for (i = 0; i < this.watchesModel.getColumnCount(); ++i) {
            this.jTableWatches.getColumnModel().getColumn(i).setPreferredWidth(this.watchesModel.getColWidth(i));
            this.jTableWatches.getColumnModel().getColumn(i).setWidth(this.watchesModel.getColWidth(i));
        }
        this.jTableWatches.setAutoResizeMode(2);
    }

    @Override
    public boolean isLoadSettings() {
        return this.loadSettings;
    }

    DebugCommentList getDebugComments(EditorPanel edi) {
        if (edi == null) {
            return null;
        }
        String key = UtilityFiles.convertSeperator(Utility.makeVideAbsolute(edi.getFilename())).toLowerCase();
        DebugCommentList list2 = this.settings.allDebugComments.get(key);
        if (list2 == null) {
            list2 = new DebugCommentList();
            this.settings.allDebugComments.put(key, list2);
        }
        list2.filename = UtilityFiles.convertSeperator(Utility.makeVideAbsolute(edi.getFilename()));
        return list2;
    }

    private DebugCommentList getDebugComments(String fname) {
        String key = UtilityFiles.convertSeperator(Utility.makeVideAbsolute(fname)).toLowerCase();
        DebugCommentList list2 = this.settings.allDebugComments.get(key);
        return list2;
    }

    @Override
    public String getID() {
        return SID;
    }

    @Override
    public String getFileID() {
        return UtilityString.replace(UtilityString.replace(UtilityString.replace(UtilityString.replaceWhiteSpaces(SID, ""), ":", ""), "(", ""), ")", "");
    }

    public static synchronized void setInScan(boolean b) {
        if (b) {
            if (++scanCount == 1) {
                VediPanel.notifyVedi(true);
            }
        } else if (--scanCount == 0) {
            VediPanel.notifyVedi(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addVedi(VediPanel vedi) {
        ArrayList<VediPanel> arrayList = listVedi;
        synchronized (arrayList) {
            listVedi.add(vedi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeVedi(VediPanel vedi) {
        ArrayList<VediPanel> arrayList = listVedi;
        synchronized (arrayList) {
            listVedi.remove(vedi);
        }
    }

    private static void notifyVedi(final boolean working) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList<VediPanel> arrayList = listVedi;
                synchronized (arrayList) {
                    for (VediPanel vp : listVedi) {
                        if (working) {
                            vp.jLabel6.setText(" *");
                            continue;
                        }
                        vp.jLabel6.setText("  ");
                    }
                }
            }
        });
    }

    public VediPanel() {
        this(true);
    }

    public VediPanel(boolean ls) {
        this.initComponents();
        this.jMenuItem1.setVisible(false);
        this.jSeparator4.setVisible(false);
        this.jMenuItemVector.setVisible(false);
        this.loadSettings = ls;
        this.jEditorLog.setEditable(false);
        this.jEditorLog.setContentType("text/html");
        this.jEditorASMMessages.setEditable(false);
        this.jEditorASMMessages.setContentType("text/html");
        this.jEditorPaneASMListing.setEditable(false);
        this.jEditorPaneASMListing.setContentType("text/html");
        this.jSplitPane1.getInputMap(1).put(KeyStroke.getKeyStroke(117, 0), "none");
        this.jSplitPane2.getInputMap(1).put(KeyStroke.getKeyStroke(117, 0), "none");
        this.jSplitPane3.getInputMap(1).put(KeyStroke.getKeyStroke(117, 0), "none");
        this.jSplitPane4.getInputMap(1).put(KeyStroke.getKeyStroke(117, 0), "none");
        this.jTabbedPane.getInputMap(1).put(KeyStroke.getKeyStroke(38, 128), "none");
        this.jTabbedPane.getInputMap(1).put(KeyStroke.getKeyStroke(40, 128), "none");
        this.jTabbedPane1.getInputMap(1).put(KeyStroke.getKeyStroke(38, 128), "none");
        this.jTabbedPane1.getInputMap(1).put(KeyStroke.getKeyStroke(40, 128), "none");
        this.jTabbedPane2.getInputMap(1).put(KeyStroke.getKeyStroke(38, 128), "none");
        this.jTabbedPane2.getInputMap(1).put(KeyStroke.getKeyStroke(40, 128), "none");
        this.jTabbedPane3.getInputMap(1).put(KeyStroke.getKeyStroke(38, 128), "none");
        this.jTabbedPane3.getInputMap(1).put(KeyStroke.getKeyStroke(40, 128), "none");
        this.jTableInventory.setModel(this.inventoryModel);
        this.sorter = new TableRowSorter<TableModel>(this.jTableInventory.getModel());
        this.jTableInventory.setRowSorter(this.sorter);
        this.sorter.addRowSorterListener(new RowSorterListener(){

            @Override
            public void sorterChanged(RowSorterEvent e) {
            }
        });
        this.sorter.setSortsOnUpdates(true);
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>(2);
        sortKeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
        sortKeys.add(new RowSorter.SortKey(1, SortOrder.ASCENDING));
        this.sorter.setSortKeys(sortKeys);
        this.init();
        UIManager.addPropertyChangeListener(this.pListener);
        this.updateMyUI();
        this.initScheduler();
        this.jButtonAssembleOne1.setVisible(false);
    }

    public void setTreeVisible(boolean v) {
        if (!v) {
            this.jTabbedPane2.setVisible(v);
            this.jSplitPane2.setDividerLocation(0);
            this.jSplitPane2.setDividerSize(0);
        }
    }

    @Override
    public void deinit() {
        this.deinitScheduler();
        this.settings.pos3 = this.jSplitPane3.getDividerLocation();
        this.settings.pos2 = this.jSplitPane2.getDividerLocation();
        this.settings.pos1 = this.jSplitPane1.getDividerLocation();
        this.settings.inventoryPos = this.jSplitPane4.getDividerLocation();
        for (Component c : this.jTabbedPane1.getComponents()) {
            if (!(c instanceof EditorPanel)) continue;
            EditorPanel ep = (EditorPanel)c;
            ep.deinit();
        }
        this.saveSettings();
        this.init = false;
        VediPanel.removeVedi(this);
        this.removeUIListerner();
        this.deinitSyntax();
    }

    @Override
    public void init() {
        int i;
        this.initSyntax();
        String lastLoadedFile = null;
        if (this.loadSettings()) {
            this.setFontSize(this.settings.fontSize);
            if (this.isLoadSettings()) {
                this.jSplitPane3.setDividerLocation(this.settings.pos3);
                this.jSplitPane2.setDividerLocation(this.settings.pos2);
                this.jSplitPane1.setDividerLocation(this.settings.pos1);
                this.jSplitPane4.setDividerLocation(this.settings.inventoryPos);
                if (this.settings.currentProject != null && this.settings.currentProject.mName.trim().length() != 0) {
                    this.loadProject(this.settings.currentProject.mClass, this.settings.currentProject.mName, this.settings.currentProject.mFullPath);
                }
                ArrayList<EditorFileSettings> toRemove = new ArrayList<EditorFileSettings>();
                for (EditorFileSettings fn : this.settings.currentOpenFiles) {
                    EditorPanel edi = this.addEditor(Utility.makeVideAbsolute(fn.filename), false, false);
                    if (edi == null) {
                        toRemove.add(fn);
                        continue;
                    }
                    lastLoadedFile = fn.filename;
                    edi.setPosition(fn.position);
                    this.oneTimeTab = null;
                }
                for (EditorFileSettings fn : toRemove) {
                    this.settings.currentOpenFiles.remove(fn);
                }
                this.jCheckBoxVecFever.setSelected(this.settings.v4eEnabled);
                this.jCheckBoxPiTrex.setSelected(this.settings.piTrexEnabled);
            }
        } else {
            this.settings = new VediSettings();
        }
        this.updateList();
        this.init = true;
        VediPanel.addVedi(this);
        if (!this.inProject) {
            if (lastLoadedFile != null) {
                this.fillTree(Paths.get(lastLoadedFile, new String[0]).getParent());
            } else {
                this.fillTree();
            }
        }
        this.jTree1.setInvokesStopCellEditing(true);
        this.editor = new MyTreeCellEditor(this.jTree1, (DefaultTreeCellRenderer)this.jTree1.getCellRenderer());
        this.jTree1.setCellEditor(this.editor);
        this.jTree1.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                VediPanel.this.currentSelectedTreeLeaf = null;
                TreePath path = e.getNewLeadSelectionPath();
                if (path != null) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    VediPanel.this.currentSelectedTreeLeaf = (TreeEntry)node.getUserObject();
                }
            }
        });
        new HotKey("Search next", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.jButtonSearchNextActionPerformed(null);
            }
        }, this);
        new HotKey("Search previous", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.jButtonSearchPreviousActionPerformed(null);
            }
        }, this);
        if (isMac) {
            HotKey.addMacDefaults(this.jTextFieldSearch);
            HotKey.addMacDefaults(this.jTextFieldReplace);
            HotKey.addMacDefaults(this.jTextFieldCommand);
            HotKey.addMacDefaults(this.jEditorLog);
            HotKey.addMacDefaults(this.jEditorASMMessages);
            HotKey.addMacDefaults(this.jEditorPaneASMListing);
        }
        new HotKey("Run", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.run();
            }
        }, this);
        new HotKey("Debug", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.debug();
            }
        }, this);
        new HotKey("SaveWin", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.jButtonSaveActionPerformed(null);
            }
        }, this);
        new HotKey("SaveMac", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.jButtonSaveActionPerformed(null);
            }
        }, this);
        new HotKey("GoBookmark1Mac", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.goBookmark(1);
            }
        }, this);
        new HotKey("GoBookmark1Win", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.goBookmark(1);
            }
        }, this);
        new HotKey("SetBookmark1Mac", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.setBookmark(1);
            }
        }, this);
        new HotKey("SetBookmark1Win", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.setBookmark(1);
            }
        }, this);
        new HotKey("GoBookmark2Mac", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.goBookmark(2);
            }
        }, this);
        new HotKey("GoBookmark2Win", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.goBookmark(2);
            }
        }, this);
        new HotKey("SetBookmark2Mac", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.setBookmark(2);
            }
        }, this);
        new HotKey("SetBookmark2Win", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.setBookmark(2);
            }
        }, this);
        new HotKey("GoBookmark3Mac", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.goBookmark(3);
            }
        }, this);
        new HotKey("GoBookmark3Win", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.goBookmark(3);
            }
        }, this);
        new HotKey("SetBookmark3Mac", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.setBookmark(3);
            }
        }, this);
        new HotKey("SetBookmark3Win", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.setBookmark(3);
            }
        }, this);
        new HotKey("GoBookmark4Mac", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.goBookmark(4);
            }
        }, this);
        new HotKey("GoBookmark4Win", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.goBookmark(4);
            }
        }, this);
        new HotKey("SetBookmark4Mac", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.setBookmark(4);
            }
        }, this);
        new HotKey("SetBookmark4Win", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.setBookmark(4);
            }
        }, this);
        new HotKey("GoBookmark5Mac", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.goBookmark(5);
            }
        }, this);
        new HotKey("GoBookmark5Win", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.goBookmark(5);
            }
        }, this);
        new HotKey("SetBookmark5Mac", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.setBookmark(5);
            }
        }, this);
        new HotKey("SetBookmark5Win", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.setBookmark(5);
            }
        }, this);
        new HotKey("GoBookmark6Mac", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.goBookmark(6);
            }
        }, this);
        new HotKey("GoBookmark6Win", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.goBookmark(6);
            }
        }, this);
        new HotKey("SetBookmark6Mac", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.setBookmark(6);
            }
        }, this);
        new HotKey("SetBookmark6Win", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.setBookmark(6);
            }
        }, this);
        new HotKey("GoBookmark7Mac", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.goBookmark(7);
            }
        }, this);
        new HotKey("GoBookmark7Win", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.goBookmark(7);
            }
        }, this);
        new HotKey("SetBookmark7Mac", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.setBookmark(7);
            }
        }, this);
        new HotKey("SetBookmark7Win", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.setBookmark(7);
            }
        }, this);
        new HotKey("GoBookmark8Mac", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.goBookmark(8);
            }
        }, this);
        new HotKey("GoBookmark8Win", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.goBookmark(8);
            }
        }, this);
        new HotKey("SetBookmark8Mac", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.setBookmark(8);
            }
        }, this);
        new HotKey("SetBookmark8Win", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.setBookmark(8);
            }
        }, this);
        new HotKey("GoBookmark9Mac", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.goBookmark(9);
            }
        }, this);
        new HotKey("GoBookmark9Win", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.goBookmark(9);
            }
        }, this);
        new HotKey("SetBookmark9Mac", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.setBookmark(9);
            }
        }, this);
        new HotKey("SetBookmark9Win", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.setBookmark(9);
            }
        }, this);
        new HotKey("GoBookmark0Mac", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.goBookmark(0);
            }
        }, this);
        new HotKey("GoBookmark0Win", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.goBookmark(0);
            }
        }, this);
        new HotKey("SetBookmark0Mac", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.setBookmark(0);
            }
        }, this);
        new HotKey("SetBookmark0Win", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.setBookmark(0);
            }
        }, this);
        new HotKey("NextBookmark", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.nextBookmark();
            }
        }, this);
        new HotKey("PreviousBookmark", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VediPanel.this.previousBookmark();
            }
        }, this);
        this.jTableBookmarks.setModel(this.bookmarkModel);
        this.jTableBookmarks.setAutoResizeMode(3);
        for (i = 0; i < this.bookmarkModel.getColumnCount(); ++i) {
            this.jTableBookmarks.getColumnModel().getColumn(i).setPreferredWidth(this.bookmarkModel.getColWidth(i));
            this.jTableBookmarks.getColumnModel().getColumn(i).setWidth(this.bookmarkModel.getColWidth(i));
        }
        this.jTableBookmarks.setAutoResizeMode(2);
        this.jTableBreakpoints.setModel(this.breakpointModel);
        this.jTableBreakpoints.setAutoResizeMode(3);
        for (i = 0; i < this.breakpointModel.getColumnCount(); ++i) {
            this.jTableBreakpoints.getColumnModel().getColumn(i).setPreferredWidth(this.breakpointModel.getColWidth(i));
            this.jTableBreakpoints.getColumnModel().getColumn(i).setWidth(this.breakpointModel.getColWidth(i));
        }
        this.jTableBreakpoints.setAutoResizeMode(2);
        this.jTableWatches.setModel(this.watchesModel);
        this.jTableWatches.setAutoResizeMode(3);
        for (i = 0; i < this.watchesModel.getColumnCount(); ++i) {
            this.jTableWatches.getColumnModel().getColumn(i).setPreferredWidth(this.watchesModel.getColWidth(i));
            this.jTableWatches.getColumnModel().getColumn(i).setWidth(this.watchesModel.getColWidth(i));
        }
        this.jTableWatches.setAutoResizeMode(2);
        this.initInventory();
    }

    void setBookmark(int b) {
        Bookmark bm = new Bookmark();
        bm.number = b;
        bm.lineNumber = this.getSelectedEditor().getCursorPos().y;
        bm.name = this.getSelectedEditor().getFilename();
        bm.fullFilename = this.getSelectedEditor().getFilename();
        if (this.currentProject != null) {
            bm.project = this.currentProject.getDirectoryName();
        }
        Set<Map.Entry<Integer, Bookmark>> entries = this.settings.bookmarks.entrySet();
        for (Map.Entry<Integer, Bookmark> entry : entries) {
            Bookmark bm2 = entry.getValue();
            if (bm2.lineNumber != bm.lineNumber || !bm2.fullFilename.equals(bm.fullFilename)) continue;
            this.removeBookmark(bm2.number);
            return;
        }
        this.settings.bookmarks.put(b, bm);
        this.printMessage("Bookmark set: " + bm.toString());
        this.updateTables();
        this.getSelectedEditor().correctLine(bm.lineNumber - 1);
    }

    void removeBookmark(int b) {
        if (this.settings.bookmarks.get(b) == null) {
            return;
        }
        int line = this.settings.bookmarks.get((Object)Integer.valueOf((int)b)).lineNumber - 1;
        this.settings.bookmarks.remove(b);
        this.getSelectedEditor().correctLine(line);
        this.printMessage("Bookmark removed: 1");
        this.updateTables();
    }

    void goBookmark(int b) {
        Bookmark bm = this.settings.bookmarks.get(b);
        this.currentBookmark = b;
        if (bm == null) {
            return;
        }
        this.addHistory();
        this.printMessage("Bookmark go: " + bm.toString());
        this.addEditor(bm.fullFilename, true);
        this.tabExistsSwitch(bm.fullFilename);
        if (this.getSelectedEditor() == null) {
            return;
        }
        this.getSelectedEditor().jump(bm.lineNumber);
        this.updateTables();
    }

    void nextBookmark() {
        int nb = this.currentBookmark + 1;
        do {
            Bookmark bm;
            if ((bm = this.settings.bookmarks.get(nb)) != null) {
                this.goBookmark(nb);
                return;
            }
            if (++nb > 9) {
                nb = 0;
            }
            if (nb != this.currentBookmark) continue;
            return;
        } while (nb != 0 || this.currentBookmark != -1);
    }

    void previousBookmark() {
        Bookmark bm;
        int nb = this.currentBookmark;
        if (nb < 0) {
            nb = 10;
        }
        do {
            if (--nb < 0 && this.currentBookmark == -1) {
                return;
            }
            if (nb < 0) {
                nb = 9;
            }
            if (nb != this.currentBookmark) continue;
            return;
        } while ((bm = this.settings.bookmarks.get(nb)) == null);
        this.goBookmark(nb);
    }

    void goBreakpoint(DebugComment dbc) {
        if (dbc == null) {
            return;
        }
        this.addHistory();
        this.addEditor(dbc.file, true);
        this.tabExistsSwitch(dbc.file);
        this.getSelectedEditor().jump(dbc.beforLineNo + 1);
        this.updateTables();
    }

    public void updateList() {
        this.projectsListModel = new DefaultListModel();
        this.filesListModel = new DefaultListModel();
        for (VediSettings.P p : this.settings.recentProject) {
            this.projectsListModel.addElement(p);
        }
        this.jListProjects.setModel(this.projectsListModel);
        for (EditorFileSettings s : this.settings.recentOpenFiles) {
            Path p = Paths.get(s.filename, new String[0]);
            this.filesListModel.addElement(p.getFileName().toString());
        }
        this.jListFiles.setModel(this.filesListModel);
    }

    void verifySettings() {
        boolean redo;
        block0: do {
            redo = false;
            for (EditorFileSettings set : this.settings.currentOpenFiles) {
                String settingsRel = Utility.makeVideRelative(set.filename);
                String settingsAbs = Utility.makeVideAbsolute(set.filename);
                if (this.getEditor(settingsRel, false) != null || this.getEditor(settingsAbs, false) != null || this.getEditor(set.filename, false) != null) continue;
                this.settings.removeOpen(set.filename);
                redo = true;
                continue block0;
            }
        } while (redo);
    }

    EditorPanel addEditor(String fullPathname, boolean addToSettings) {
        return this.addEditor(fullPathname, addToSettings, true);
    }

    EditorPanel addEditor(String fullPathname, boolean addToSettings, boolean verifySettings) {
        EditorPanel edi;
        String name = "edi";
        Path path = Paths.get(fullPathname, new String[0]);
        name = path.getFileName().toString();
        Object oldSettings = null;
        int pos = 0;
        String settingsRel = Utility.makeVideRelative(fullPathname);
        String settingsAbs = Utility.makeVideAbsolute(fullPathname);
        if (verifySettings) {
            this.verifySettings();
        }
        if (addToSettings) {
            if (this.settings.openContains(settingsAbs)) {
                return null;
            }
            if (this.settings.openContains(settingsRel)) {
                return null;
            }
        } else {
            edi = this.getEditor(settingsAbs, false);
            if (edi != null) {
                edi.reload(true);
                return edi;
            }
        }
        edi = new EditorPanel(Utility.makeVideAbsolute(fullPathname), this, this.UID);
        edi.setMinimumSize(new Dimension(5, 5));
        edi.setAddToSettings(addToSettings);
        if (edi.isInitError()) {
            return null;
        }
        int count = 0;
        String nname = name;
        while (this.jTabbedPane1.indexOfTab(nname) != -1) {
            if (++count == 0) continue;
            nname = name + "-" + count;
        }
        name = nname;
        this.jTabbedPane1.addTab(name, null, edi, settingsRel);
        this.oneTimeTab = name;
        this.addCloseButton(this.jTabbedPane1, name);
        this.jTabbedPane1.setSelectedComponent(edi);
        edi.setTinyLog(this);
        edi.addEditorListener(this);
        this.jLabel5.setText("");
        if (addToSettings) {
            this.settings.addOpen(Utility.makeVideAbsolute(fullPathname), pos);
        }
        edi.setParent(this);
        if (pos != 0) {
            edi.setPosition(pos);
        }
        return edi;
    }

    public int checkTabExists(String fileName) {
        String pathName = Paths.get(fileName, new String[0]).getFileName().toString();
        int count = this.jTabbedPane1.getTabCount();
        int found = -1;
        for (int i = 0; i < count; ++i) {
            if (!pathName.equals(this.jTabbedPane1.getTitleAt(i))) continue;
            return i;
        }
        return -1;
    }

    ImagePanel addImageDisplay(String fullPathname, boolean addToSettings) {
        String name = "imi";
        Path path = Paths.get(fullPathname, new String[0]);
        name = path.getFileName().toString();
        if (addToSettings && this.settings.currentOpenFiles.contains(fullPathname)) {
            return null;
        }
        if (this.nameExistAsTab(name)) {
            return null;
        }
        ImagePanel edi = new ImagePanel(fullPathname, this);
        if (edi.isInitError()) {
            return null;
        }
        this.oneTimeTab = name;
        this.jTabbedPane1.addTab(name, null, edi, fullPathname);
        this.addCloseButton(this.jTabbedPane1, name);
        this.jTabbedPane1.setSelectedComponent(edi);
        this.jLabel5.setText("");
        if (addToSettings) {
            this.settings.addOpen(fullPathname, 0);
        }
        edi.setParent(this);
        return edi;
    }

    public BinaryPanel addBinaryDisplay(String fullPathname, boolean addToSettings) {
        String name = "imi";
        Path path = Paths.get(fullPathname, new String[0]);
        name = path.getFileName().toString();
        if (addToSettings && this.settings.currentOpenFiles.contains(fullPathname)) {
            return null;
        }
        if (this.nameExistAsTab(name)) {
            return null;
        }
        BinaryPanel edi = new BinaryPanel(fullPathname, this);
        if (edi.isInitError()) {
            return null;
        }
        this.jTabbedPane1.addTab(name, null, edi, fullPathname);
        this.oneTimeTab = name;
        this.addCloseButton(this.jTabbedPane1, name);
        this.jTabbedPane1.setSelectedComponent(edi);
        this.jLabel5.setText("");
        if (addToSettings) {
            this.settings.addOpen(fullPathname, 0);
        }
        edi.setParent(this);
        return edi;
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.jMenuNewFileMenu = new JMenu();
        this.jMenuItemVectrexFile = new JMenuItem();
        this.jMenuItemNewFile = new JMenuItem();
        this.jMenuItemCFile = new JMenuItem();
        this.jMenuItemNewProject = new JMenuItem();
        this.jPopupMenuTree = new JPopupMenu();
        this.jMenuItemFileProperties = new JMenuItem();
        this.jMenuItemSetMain = new JMenuItem();
        this.jMenuItemAction = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jMenuItemModi = new JMenuItem();
        this.jMenuItemYM = new JMenuItem();
        this.jMenuItemAKS = new JMenuItem();
        this.jMenuItemASFX = new JMenuItem();
        this.jMenuItemSample = new JMenuItem();
        this.jMenuItemVecSpeech = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.jMenuItemRaster = new JMenuItem();
        this.jMenuItemVector = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.jMenuItemDelete = new JMenuItem();
        this.jMenuItemRename = new JMenuItem();
        this.jMenuItemDuplicate = new JMenuItem();
        this.jMenuItem1AddNewFile = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.jMenuItem1 = new JMenuItem();
        this.jPopupMenuProjectProperties = new JPopupMenu();
        this.jMenuItemProjectProperties = new JMenuItem();
        this.jMenuItemRefresh = new JMenuItem();
        this.jMenuItemClose = new JMenuItem();
        this.jMenuItemAddToProject = new JMenuItem();
        this.jPopupMenuBP = new JPopupMenu();
        this.jMenuItemRemoveBP = new JMenuItem();
        this.jPopupMenuWatch = new JPopupMenu();
        this.jMenuItemRemoveWatch = new JMenuItem();
        this.jPopupMenuBM = new JPopupMenu();
        this.jMenuItemRemoveBM = new JMenuItem();
        this.jPanel1 = new JPanel();
        this.jButtonCut = new JButton();
        this.jButtonPaste = new JButton();
        this.jButtonSave = new JButton();
        this.jButtonRedo = new JButton();
        this.jButtonUndo = new JButton();
        this.jButtonCopy = new JButton();
        this.jButtonSaveAll = new JButton();
        this.jButtonLoad = new JButton();
        this.jButtonAssemble = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jSplitPane2 = new JSplitPane();
        this.jTabbedPane1 = new JTabbedPane(){

            @Override
            public void setSelectedIndex(int index) {
                if (this.getSelectedIndex() == index) {
                    return;
                }
                if (VediPanel.this.tabChangeNotAllowed) {
                    return;
                }
                super.setSelectedIndex(index);
            }
        };
        this.jSplitPane4 = new JSplitPane();
        this.jTabbedPane2 = new JTabbedPane();
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.jPanel4 = new JPanel();
        this.jScrollPane5 = new JScrollPane();
        this.jListFiles = new JList();
        this.jButtonNew1 = new JButton();
        this.jPanel5 = new JPanel();
        this.jScrollPane6 = new JScrollPane();
        this.jListProjects = new JList();
        this.jButtonNew7 = new JButton();
        this.jPanel7 = new JPanel();
        this.jScrollPane9 = new JScrollPane();
        this.jTableInventory = new JTable();
        this.jButtonAdressBack = new JButton();
        this.jButtonAdressForward = new JButton();
        this.jButtonLabelConfig = new JButton();
        this.jSplitPane3 = new JSplitPane();
        this.jTabbedPane = new JTabbedPane();
        this.jScrollPane2 = new JScrollPane();
        this.jEditorLog = new JEditorPane();
        this.jScrollPane3 = new JScrollPane();
        this.jEditorASMMessages = new JEditorPane();
        this.jScrollPane4 = new JScrollPane();
        this.jEditorPaneASMListing = new JEditorPane();
        this.jTabbedPane3 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jScrollPane7 = new JScrollPane();
        this.jTableBookmarks = new JTable();
        this.jPanel6 = new JPanel();
        this.jScrollPane8 = new JScrollPane();
        this.jTableBreakpoints = new JTable();
        this.jPanel8 = new JPanel();
        this.jScrollPane10 = new JScrollPane();
        this.jTableWatches = new JTable();
        this.jPanel9 = new JPanel();
        this.jPanel10 = new JPanel();
        this.jButtonAssembleOne1 = new JButton();
        this.jButtonAssembleOne2 = new JButton();
        this.jButtonAssembleOne3 = new JButton();
        this.jButtonAssembleOne4 = new JButton();
        this.jCheckBox1 = new JCheckBox();
        this.jButtonAssembleOne5 = new JButton();
        this.jButtonNew = new JButton();
        this.jButtonPrettyPrint = new JButton();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextFieldSearch = new JTextField();
        this.jButtonSearchNext = new JButton();
        this.jButtonSearchPrevious = new JButton();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jButtonReplaceInSelection = new JButton();
        this.jButtonReplaceAll = new JButton();
        this.jButtonReplaceNext = new JButton();
        this.jButtonIgnoreCase = new JButton();
        this.jCheckBoxIgnoreCase = new JCheckBox();
        this.jTextFieldReplace = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jButtonClearMessages = new JButton();
        this.jButtonFontPlus = new JButton();
        this.jButtonFontMinus = new JButton();
        this.jButtonRefresh = new JButton();
        this.jButtonDebug = new JButton();
        this.jButtonInjectBin = new JButton();
        this.jTextFieldCommand = new JTextField();
        this.jLabel7 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jCheckBoxVecFever = new JCheckBox();
        this.jButtonDebugSyntax = new JButton();
        this.jButtonAssembleOne = new JButton();
        this.jCheckBoxPiTrex = new JCheckBox();
        this.jLabel10 = new JLabel();
        this.jPopupMenu1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                VediPanel.this.jPopupMenu1MouseExited(evt);
            }
        });
        this.jMenuNewFileMenu.setText("new file");
        this.jMenuItemVectrexFile.setText("new vectrex file");
        this.jMenuItemVectrexFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jMenuItemVectrexFileActionPerformed(evt);
            }
        });
        this.jMenuNewFileMenu.add(this.jMenuItemVectrexFile);
        this.jMenuItemNewFile.setText("new empty file");
        this.jMenuItemNewFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jMenuItemNewFileActionPerformed(evt);
            }
        });
        this.jMenuNewFileMenu.add(this.jMenuItemNewFile);
        this.jMenuItemCFile.setText("new C file");
        this.jMenuItemCFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jMenuItemCFileActionPerformed(evt);
            }
        });
        this.jMenuNewFileMenu.add(this.jMenuItemCFile);
        this.jPopupMenu1.add(this.jMenuNewFileMenu);
        this.jMenuItemNewProject.setText("new Project");
        this.jMenuItemNewProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jMenuItemNewProjectActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemNewProject);
        this.jMenuItemFileProperties.setText("Properties");
        this.jMenuItemFileProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jMenuItemFilePropertiesActionPerformed(evt);
            }
        });
        this.jPopupMenuTree.add(this.jMenuItemFileProperties);
        this.jMenuItemSetMain.setText("set as main");
        this.jMenuItemSetMain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jMenuItemSetMainActionPerformed(evt);
            }
        });
        this.jPopupMenuTree.add(this.jMenuItemSetMain);
        this.jMenuItemAction.setText("execute action");
        this.jMenuItemAction.setToolTipText("execute the configured action (if any)");
        this.jMenuItemAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jMenuItemActionActionPerformed(evt);
            }
        });
        this.jPopupMenuTree.add(this.jMenuItemAction);
        this.jPopupMenuTree.add(this.jSeparator1);
        this.jMenuItemModi.setText("build vectrex mod");
        this.jMenuItemModi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jMenuItemModiActionPerformed(evt);
            }
        });
        this.jPopupMenuTree.add(this.jMenuItemModi);
        this.jMenuItemYM.setText("build vectrex YM");
        this.jMenuItemYM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jMenuItemYMActionPerformed(evt);
            }
        });
        this.jPopupMenuTree.add(this.jMenuItemYM);
        this.jMenuItemAKS.setText("Arkos Tracker \"bin\"");
        this.jMenuItemAKS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jMenuItemAKSActionPerformed(evt);
            }
        });
        this.jPopupMenuTree.add(this.jMenuItemAKS);
        this.jMenuItemASFX.setText("build vectrex ayfx");
        this.jMenuItemASFX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jMenuItemASFXActionPerformed(evt);
            }
        });
        this.jPopupMenuTree.add(this.jMenuItemASFX);
        this.jMenuItemSample.setText("build vectrex sample");
        this.jMenuItemSample.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jMenuItemSampleActionPerformed(evt);
            }
        });
        this.jPopupMenuTree.add(this.jMenuItemSample);
        this.jMenuItemVecSpeech.setText("VecVoice/VecVox+");
        this.jMenuItemVecSpeech.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jMenuItemVecSpeechActionPerformed(evt);
            }
        });
        this.jPopupMenuTree.add(this.jMenuItemVecSpeech);
        this.jPopupMenuTree.add(this.jSeparator3);
        this.jMenuItemRaster.setText("convert image to vectrex raster");
        this.jMenuItemRaster.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jMenuItemRasterActionPerformed(evt);
            }
        });
        this.jPopupMenuTree.add(this.jMenuItemRaster);
        this.jMenuItemVector.setText("convert image to vector");
        this.jMenuItemVector.setToolTipText("");
        this.jMenuItemVector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jMenuItemVectorActionPerformed(evt);
            }
        });
        this.jPopupMenuTree.add(this.jMenuItemVector);
        this.jPopupMenuTree.add(this.jSeparator2);
        this.jMenuItemDelete.setText("Delete");
        this.jMenuItemDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jMenuItemDeleteActionPerformed(evt);
            }
        });
        this.jPopupMenuTree.add(this.jMenuItemDelete);
        this.jMenuItemRename.setText("Rename");
        this.jMenuItemRename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jMenuItemRenameActionPerformed(evt);
            }
        });
        this.jPopupMenuTree.add(this.jMenuItemRename);
        this.jMenuItemDuplicate.setText("Duplicate");
        this.jMenuItemDuplicate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jMenuItemDuplicateActionPerformed(evt);
            }
        });
        this.jPopupMenuTree.add(this.jMenuItemDuplicate);
        this.jMenuItem1AddNewFile.setText("new empty file");
        this.jMenuItem1AddNewFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jMenuItem1AddNewFileActionPerformed(evt);
            }
        });
        this.jPopupMenuTree.add(this.jMenuItem1AddNewFile);
        this.jPopupMenuTree.add(this.jSeparator4);
        this.jMenuItem1.setText("Invoke C-Compiler");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jPopupMenuTree.add(this.jMenuItem1);
        this.jMenuItemProjectProperties.setText("Project properties");
        this.jMenuItemProjectProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jMenuItemProjectPropertiesActionPerformed(evt);
            }
        });
        this.jPopupMenuProjectProperties.add(this.jMenuItemProjectProperties);
        this.jMenuItemRefresh.setLabel("Refresh");
        this.jMenuItemRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jMenuItemRefreshActionPerformed(evt);
            }
        });
        this.jPopupMenuProjectProperties.add(this.jMenuItemRefresh);
        this.jMenuItemClose.setText("close project");
        this.jMenuItemClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jMenuItemCloseActionPerformed(evt);
            }
        });
        this.jPopupMenuProjectProperties.add(this.jMenuItemClose);
        this.jMenuItemAddToProject.setText("add file");
        this.jMenuItemAddToProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jMenuItemAddToProjectActionPerformed(evt);
            }
        });
        this.jPopupMenuProjectProperties.add(this.jMenuItemAddToProject);
        this.jMenuItemRemoveBP.setText("remove breakpoint");
        this.jMenuItemRemoveBP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jMenuItemRemoveBPActionPerformed(evt);
            }
        });
        this.jPopupMenuBP.add(this.jMenuItemRemoveBP);
        this.jMenuItemRemoveWatch.setText("remove watch");
        this.jMenuItemRemoveWatch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jMenuItemRemoveWatchActionPerformed(evt);
            }
        });
        this.jPopupMenuWatch.add(this.jMenuItemRemoveWatch);
        this.jMenuItemRemoveBM.setText("remove bookmark");
        this.jMenuItemRemoveBM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jMenuItemRemoveBMActionPerformed(evt);
            }
        });
        this.jPopupMenuBM.add(this.jMenuItemRemoveBM);
        this.setName("regi");
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jButtonCut.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/cut.png")));
        this.jButtonCut.setToolTipText("Cut");
        this.jButtonCut.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonCut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jButtonCutActionPerformed(evt);
            }
        });
        this.jButtonPaste.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/paste_plain.png")));
        this.jButtonPaste.setToolTipText("Paste");
        this.jButtonPaste.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jButtonPasteActionPerformed(evt);
            }
        });
        this.jButtonSave.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_save.png")));
        this.jButtonSave.setToolTipText("Save File (with shift - > save as)");
        this.jButtonSave.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jButtonRedo.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/arrow_redo.png")));
        this.jButtonRedo.setToolTipText("Redo");
        this.jButtonRedo.setEnabled(false);
        this.jButtonRedo.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonRedo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jButtonRedoActionPerformed(evt);
            }
        });
        this.jButtonUndo.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/arrow_undo.png")));
        this.jButtonUndo.setToolTipText("Undo");
        this.jButtonUndo.setEnabled(false);
        this.jButtonUndo.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jButtonUndoActionPerformed(evt);
            }
        });
        this.jButtonCopy.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_copy.png")));
        this.jButtonCopy.setToolTipText("Copy");
        this.jButtonCopy.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jButtonCopyActionPerformed(evt);
            }
        });
        this.jButtonSaveAll.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/disk_multiple.png")));
        this.jButtonSaveAll.setToolTipText("Save all");
        this.jButtonSaveAll.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonSaveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jButtonSaveAllActionPerformed(evt);
            }
        });
        this.jButtonLoad.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_go.png")));
        this.jButtonLoad.setToolTipText("<html>\nOpen file <BR>\n+Shift -> reload current file <BR>\n+Meta/CTRL/ALT -> load file or project and start compilation <BR>\n\n</html>");
        this.jButtonLoad.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jButtonLoadActionPerformed(evt);
            }
        });
        this.jButtonAssemble.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/control_play_blue.png")));
        this.jButtonAssemble.setToolTipText("Assemble current file, if project is loaded, build project and run it (if so defined in config).");
        this.jButtonAssemble.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonAssemble.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jButtonAssembleActionPerformed(evt);
            }
        });
        this.jSplitPane1.setDividerLocation(500);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(1.0);
        this.jSplitPane2.setDividerLocation(200);
        this.jTabbedPane1.setTabLayoutPolicy(1);
        this.jTabbedPane1.setPreferredSize(null);
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                VediPanel.this.jTabbedPane1StateChanged(evt);
            }
        });
        this.jSplitPane2.setRightComponent(this.jTabbedPane1);
        this.jSplitPane4.setDividerLocation(300);
        this.jSplitPane4.setOrientation(0);
        this.jTabbedPane2.setTabLayoutPolicy(1);
        this.jScrollPane1.setPreferredSize(new Dimension(80, 200));
        this.jTree1.setDragEnabled(true);
        this.jTree1.setEditable(true);
        this.jTree1.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                VediPanel.this.jTree1MousePressed(evt);
            }
        });
        this.jTree1.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                VediPanel.this.jTree1ValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTree1);
        this.jTabbedPane2.addTab("Project", this.jScrollPane1);
        this.jPanel4.setPreferredSize(new Dimension(100, 100));
        this.jListFiles.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jListFiles.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                VediPanel.this.jListFilesMousePressed(evt);
            }
        });
        this.jScrollPane5.setViewportView(this.jListFiles);
        this.jButtonNew1.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/delete.png")));
        this.jButtonNew1.setToolTipText("delete entries");
        this.jButtonNew1.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonNew1.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                VediPanel.this.jButtonNew1MousePressed(evt);
            }
        });
        this.jButtonNew1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jButtonNew1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane5, -1, 195, Short.MAX_VALUE).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jButtonNew1).addGap(0, 0, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addComponent(this.jButtonNew1).addGap(2, 2, 2).addComponent(this.jScrollPane5, -1, 131, Short.MAX_VALUE)));
        this.jTabbedPane2.addTab("last files", this.jPanel4);
        this.jPanel5.setPreferredSize(new Dimension(100, 100));
        this.jListProjects.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jListProjects.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                VediPanel.this.jListProjectsMousePressed(evt);
            }
        });
        this.jScrollPane6.setViewportView(this.jListProjects);
        this.jButtonNew7.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/delete.png")));
        this.jButtonNew7.setToolTipText("delete entries");
        this.jButtonNew7.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonNew7.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                VediPanel.this.jButtonNew7MousePressed(evt);
            }
        });
        this.jButtonNew7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jButtonNew7ActionPerformed(evt);
            }
        });
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane6, -1, 195, Short.MAX_VALUE).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jButtonNew7).addGap(0, 0, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup().addComponent(this.jButtonNew7).addGap(2, 2, 2).addComponent(this.jScrollPane6, -1, 131, Short.MAX_VALUE)));
        this.jTabbedPane2.addTab("last projects", this.jPanel5);
        this.jSplitPane4.setLeftComponent(this.jTabbedPane2);
        this.jPanel7.setBorder(BorderFactory.createTitledBorder("Navigation"));
        this.jTableInventory.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTableInventory.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                VediPanel.this.jTableInventoryMousePressed(evt);
            }
        });
        this.jScrollPane9.setViewportView(this.jTableInventory);
        this.jButtonAdressBack.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/resultset_previous.png")));
        this.jButtonAdressBack.setToolTipText("<html>\ngo to last visited adress\n<BR>\nAll visited adresses are on a stack.<BR>\nThe current displayed address is NOT on the stack.<BR>\nIf the current address is change by the user, and than goes<BR>\nback and forth, the \"new\" last address is visted, not the \"old\"<BR>\nlast address!<BR>\n\n</html>\n");
        this.jButtonAdressBack.setEnabled(false);
        this.jButtonAdressBack.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonAdressBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jButtonAdressBackActionPerformed(evt);
            }
        });
        this.jButtonAdressForward.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/resultset_next.png")));
        this.jButtonAdressForward.setToolTipText("<html>\ngo to next visited adress\n<BR>\nAll visited adresses are on a stack.<BR>\nThe current displayed address is NOT on the stack.<BR>\nIf the current address is change by the user, and than goes<BR>\nback and forth, the \"new\" last address is visted, not the \"old\"<BR>\nlast address!<BR>\n\n</html>\n");
        this.jButtonAdressForward.setEnabled(false);
        this.jButtonAdressForward.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonAdressForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jButtonAdressForwardActionPerformed(evt);
            }
        });
        this.jButtonLabelConfig.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/cog_edit.png")));
        this.jButtonLabelConfig.setToolTipText("configure kind of listed labels");
        this.jButtonLabelConfig.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonLabelConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jButtonLabelConfigActionPerformed(evt);
            }
        });
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane9, -2, 0, Short.MAX_VALUE).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jButtonAdressBack).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAdressForward).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 124, Short.MAX_VALUE).addComponent(this.jButtonLabelConfig)));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel7Layout.createSequentialGroup().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonAdressForward, GroupLayout.Alignment.TRAILING).addComponent(this.jButtonAdressBack, GroupLayout.Alignment.TRAILING).addComponent(this.jButtonLabelConfig, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane9, -1, 64, Short.MAX_VALUE)));
        this.jSplitPane4.setRightComponent(this.jPanel7);
        this.jSplitPane2.setLeftComponent(this.jSplitPane4);
        this.jSplitPane1.setTopComponent(this.jSplitPane2);
        this.jSplitPane3.setDividerLocation(600);
        this.jTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                VediPanel.this.jTabbedPaneStateChanged(evt);
            }
        });
        this.jTabbedPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                VediPanel.this.jTabbedPaneMousePressed(evt);
            }
        });
        this.jEditorLog.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                VediPanel.this.jEditorLogMousePressed(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jEditorLog);
        this.jTabbedPane.addTab("Editor messages", this.jScrollPane2);
        this.jEditorASMMessages.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                VediPanel.this.jEditorASMMessagesMousePressed(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.jEditorASMMessages);
        this.jTabbedPane.addTab("ASM messages", this.jScrollPane3);
        this.jScrollPane4.setViewportView(this.jEditorPaneASMListing);
        this.jTabbedPane.addTab("ASM listing/symbols", this.jScrollPane4);
        this.jSplitPane3.setLeftComponent(this.jTabbedPane);
        this.jTableBookmarks.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTableBookmarks.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                VediPanel.this.jTableBookmarksMousePressed(evt);
            }
        });
        this.jScrollPane7.setViewportView(this.jTableBookmarks);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane7, -1, 434, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane7, -1, 178, Short.MAX_VALUE));
        this.jTabbedPane3.addTab("Bookmarks", this.jPanel2);
        this.jTableBreakpoints.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTableBreakpoints.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                VediPanel.this.jTableBreakpointsMousePressed(evt);
            }
        });
        this.jScrollPane8.setViewportView(this.jTableBreakpoints);
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane8, -1, 434, Short.MAX_VALUE));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane8, -1, 178, Short.MAX_VALUE));
        this.jTabbedPane3.addTab("Breakpoints", this.jPanel6);
        this.jTableWatches.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTableWatches.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                VediPanel.this.jTableWatchesMousePressed(evt);
            }
        });
        this.jScrollPane10.setViewportView(this.jTableWatches);
        GroupLayout jPanel8Layout = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane10, -1, 434, Short.MAX_VALUE));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane10, -1, 178, Short.MAX_VALUE));
        this.jTabbedPane3.addTab("Watches", this.jPanel8);
        this.jPanel10.setBorder(BorderFactory.createTitledBorder("assi only"));
        this.jButtonAssembleOne1.setText("to assi");
        this.jButtonAssembleOne1.setToolTipText("");
        this.jButtonAssembleOne1.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonAssembleOne1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jButtonAssembleOne1ActionPerformed(evt);
            }
        });
        this.jButtonAssembleOne2.setText("to as6809");
        this.jButtonAssembleOne2.setToolTipText("");
        this.jButtonAssembleOne2.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonAssembleOne2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jButtonAssembleOne2ActionPerformed(evt);
            }
        });
        this.jButtonAssembleOne3.setText("preProcess only");
        this.jButtonAssembleOne3.setToolTipText("");
        this.jButtonAssembleOne3.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonAssembleOne3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jButtonAssembleOne3ActionPerformed(evt);
            }
        });
        this.jButtonAssembleOne4.setText("start as6809");
        this.jButtonAssembleOne4.setToolTipText("");
        this.jButtonAssembleOne4.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonAssembleOne4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jButtonAssembleOne4ActionPerformed(evt);
            }
        });
        this.jCheckBox1.setSelected(true);
        this.jCheckBox1.setText("scheduler");
        this.jCheckBox1.setToolTipText("update timer to check files for var changes");
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.jButtonAssembleOne5.setText("both");
        this.jButtonAssembleOne5.setToolTipText("");
        this.jButtonAssembleOne5.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonAssembleOne5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jButtonAssembleOne5ActionPerformed(evt);
            }
        });
        GroupLayout jPanel10Layout = new GroupLayout(this.jPanel10);
        this.jPanel10.setLayout(jPanel10Layout);
        jPanel10Layout.setHorizontalGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel10Layout.createSequentialGroup().addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel10Layout.createSequentialGroup().addComponent(this.jButtonAssembleOne4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE)).addGroup(jPanel10Layout.createSequentialGroup().addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonAssembleOne1, -1, 92, Short.MAX_VALUE).addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonAssembleOne2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonAssembleOne3, GroupLayout.Alignment.LEADING, -1, 92, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonAssembleOne5, -2, 92, -2).addGap(22, 22, 22))).addComponent(this.jCheckBox1).addGap(119, 119, 119)));
        jPanel10Layout.setVerticalGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel10Layout.createSequentialGroup().addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonAssembleOne1, -2, 20, -2).addComponent(this.jCheckBox1)).addGap(14, 14, 14).addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonAssembleOne3, -2, 20, -2).addComponent(this.jButtonAssembleOne5)).addGap(14, 14, 14).addComponent(this.jButtonAssembleOne2, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonAssembleOne4, -2, 20, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel9Layout = new GroupLayout(this.jPanel9);
        this.jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addComponent(this.jPanel10, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel9Layout.setVerticalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel10, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTabbedPane3.addTab("Assi->C", this.jPanel9);
        this.jSplitPane3.setRightComponent(this.jTabbedPane3);
        this.jSplitPane1.setBottomComponent(this.jSplitPane3);
        this.jButtonNew.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/new.png")));
        this.jButtonNew.setToolTipText("new Project");
        this.jButtonNew.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonNew.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                VediPanel.this.jButtonNewMousePressed(evt);
            }
        });
        this.jButtonNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jButtonNewActionPerformed(evt);
            }
        });
        this.jButtonPrettyPrint.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/text_columns.png")));
        this.jButtonPrettyPrint.setToolTipText("Pretty print (as9 only)");
        this.jButtonPrettyPrint.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonPrettyPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jButtonPrettyPrintActionPerformed(evt);
            }
        });
        this.jPanel3.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel1.setText("search:");
        this.jLabel1.setPreferredSize(new Dimension(36, 21));
        this.jTextFieldSearch.setPreferredSize(new Dimension(6, 21));
        this.jTextFieldSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jTextFieldSearchActionPerformed(evt);
            }
        });
        this.jTextFieldSearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                VediPanel.this.jTextFieldSearchKeyPressed(evt);
            }
        });
        this.jButtonSearchNext.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/resultset_next.png")));
        this.jButtonSearchNext.setToolTipText("search forward");
        this.jButtonSearchNext.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonSearchNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jButtonSearchNextActionPerformed(evt);
            }
        });
        this.jButtonSearchPrevious.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/resultset_previous.png")));
        this.jButtonSearchPrevious.setToolTipText("search backwards");
        this.jButtonSearchPrevious.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonSearchPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jButtonSearchPreviousActionPerformed(evt);
            }
        });
        this.jLabel2.setText("replace:");
        this.jLabel2.setToolTipText("");
        this.jLabel2.setPreferredSize(new Dimension(39, 21));
        this.jLabel3.setHorizontalAlignment(11);
        this.jLabel3.setText("xyz chars");
        this.jLabel3.setPreferredSize(new Dimension(46, 21));
        this.jLabel4.setText("row/col: xxxx/yyyy");
        this.jLabel4.setPreferredSize(new Dimension(94, 21));
        this.jButtonReplaceInSelection.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/control_fastforward_blue.png")));
        this.jButtonReplaceInSelection.setToolTipText("replace in selection");
        this.jButtonReplaceInSelection.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonReplaceInSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jButtonReplaceInSelectionActionPerformed(evt);
            }
        });
        this.jButtonReplaceAll.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/control_fastforward.png")));
        this.jButtonReplaceAll.setToolTipText("replace all (complete document)");
        this.jButtonReplaceAll.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonReplaceAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jButtonReplaceAllActionPerformed(evt);
            }
        });
        this.jButtonReplaceNext.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/control_play.png")));
        this.jButtonReplaceNext.setToolTipText("replace next");
        this.jButtonReplaceNext.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonReplaceNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jButtonReplaceNextActionPerformed(evt);
            }
        });
        this.jButtonIgnoreCase.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/text_uppercase.png")));
        this.jButtonIgnoreCase.setToolTipText("ignore case (if selected)");
        this.jButtonIgnoreCase.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonIgnoreCase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jButtonIgnoreCaseActionPerformed(evt);
            }
        });
        this.jCheckBoxIgnoreCase.setSelected(true);
        this.jCheckBoxIgnoreCase.setToolTipText("ignore case (if selected)");
        this.jTextFieldReplace.setPreferredSize(new Dimension(6, 21));
        this.jTextFieldReplace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jTextFieldReplaceActionPerformed(evt);
            }
        });
        this.jLabel5.setForeground(new Color(255, 0, 0));
        this.jLabel5.setToolTipText("");
        this.jLabel5.setPreferredSize(new Dimension(100, 21));
        this.jLabel6.setFont(new Font("Courier New", 0, 12));
        this.jLabel6.setForeground(new Color(0, 153, 51));
        this.jLabel6.setHorizontalAlignment(11);
        this.jLabel6.setText("*");
        this.jLabel6.setMaximumSize(new Dimension(16, 21));
        this.jLabel6.setMinimumSize(new Dimension(16, 21));
        this.jLabel6.setPreferredSize(new Dimension(16, 21));
        this.jButtonClearMessages.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/weather_sun.png")));
        this.jButtonClearMessages.setToolTipText("clear messages");
        this.jButtonClearMessages.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonClearMessages.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jButtonClearMessagesActionPerformed(evt);
            }
        });
        this.jButtonFontPlus.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/font_add.png")));
        this.jButtonFontPlus.setToolTipText("update size of all fonts");
        this.jButtonFontPlus.setMargin(new Insets(0, 0, 0, 0));
        this.jButtonFontPlus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jButtonFontPlusActionPerformed(evt);
            }
        });
        this.jButtonFontMinus.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/font_delete.png")));
        this.jButtonFontMinus.setToolTipText("update size of all fonts");
        this.jButtonFontMinus.setMargin(new Insets(0, 0, 0, 0));
        this.jButtonFontMinus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jButtonFontMinusActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.jButtonClearMessages).addGap(5, 5, 5).addComponent(this.jCheckBoxIgnoreCase).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonIgnoreCase).addGap(1, 1, 1).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addGap(2, 2, 2).addComponent(this.jTextFieldSearch, -2, 105, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSearchPrevious).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSearchNext).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.jTextFieldReplace, -2, 105, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonReplaceNext).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonReplaceAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonReplaceInSelection).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonFontPlus).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFontMinus).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5, -2, 114, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel4, -2, 184, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3, -2, 144, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel6, -2, 16, -2)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(0, 0, 0).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -2, -1, -2).addComponent(this.jCheckBoxIgnoreCase).addComponent(this.jButtonIgnoreCase).addComponent(this.jButtonReplaceNext).addComponent(this.jButtonReplaceAll).addComponent(this.jButtonReplaceInSelection).addComponent(this.jLabel4, -2, -1, -2).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3, -2, -1, -2).addComponent(this.jLabel6, -2, -1, -2)).addComponent(this.jLabel2, -2, -1, -2).addComponent(this.jButtonFontMinus).addComponent(this.jButtonFontPlus).addComponent(this.jButtonClearMessages).addComponent(this.jButtonSearchPrevious).addComponent(this.jButtonSearchNext).addComponent(this.jLabel5, -2, -1, -2).addComponent(this.jTextFieldSearch, -2, -1, -2).addComponent(this.jTextFieldReplace, -2, -1, -2)).addGap(0, 0, 0)));
        this.jButtonRefresh.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/arrow_refresh.png")));
        this.jButtonRefresh.setToolTipText("refresh tree");
        this.jButtonRefresh.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jButtonRefreshActionPerformed(evt);
            }
        });
        this.jButtonDebug.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/bug_go.png")));
        this.jButtonDebug.setToolTipText("<html>\nAssemble current file, if project is loaded, build project and start debugging it (if so defined in config).\n<BR>\nUsing C, this oes as of now nothing different than \"build\".\n</html>\n");
        this.jButtonDebug.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonDebug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jButtonDebugActionPerformed(evt);
            }
        });
        this.jButtonInjectBin.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/server_go.png")));
        this.jButtonInjectBin.setToolTipText("Assemble and \"inject\" built binary to currently running vecx");
        this.jButtonInjectBin.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonInjectBin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jButtonInjectBinActionPerformed(evt);
            }
        });
        this.jTextFieldCommand.setPreferredSize(new Dimension(6, 21));
        this.jTextFieldCommand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jTextFieldCommandActionPerformed(evt);
            }
        });
        this.jLabel7.setText("ask:");
        this.jLabel9.setHorizontalAlignment(11);
        this.jLabel9.setText("V4E");
        this.jCheckBoxVecFever.setToolTipText("ignore case (if selected)");
        this.jCheckBoxVecFever.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jCheckBoxVecFeverActionPerformed(evt);
            }
        });
        this.jButtonDebugSyntax.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/zoom_out.png")));
        this.jButtonDebugSyntax.setToolTipText("debug");
        this.jButtonDebugSyntax.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonDebugSyntax.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jButtonDebugSyntaxActionPerformed(evt);
            }
        });
        this.jButtonAssembleOne.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/control_end_blue.png")));
        this.jButtonAssembleOne.setToolTipText("Assemble/compile current file - nothing is started!");
        this.jButtonAssembleOne.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonAssembleOne.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jButtonAssembleOneActionPerformed(evt);
            }
        });
        this.jCheckBoxPiTrex.setToolTipText("ignore case (if selected)");
        this.jCheckBoxPiTrex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VediPanel.this.jCheckBoxPiTrexActionPerformed(evt);
            }
        });
        this.jLabel10.setHorizontalAlignment(11);
        this.jLabel10.setText("PiTrex");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonNew).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonRefresh).addGap(30, 30, 30).addComponent(this.jButtonLoad).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSaveAll).addGap(18, 18, 18).addComponent(this.jButtonCopy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonPaste).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCut).addGap(18, 18, 18).addComponent(this.jButtonUndo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonRedo).addGap(18, 18, 18).addComponent(this.jButtonPrettyPrint).addGap(18, 18, 18).addComponent(this.jButtonAssembleOne).addGap(4, 4, 4).addComponent(this.jButtonAssemble).addGap(4, 4, 4).addComponent(this.jButtonDebug).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonInjectBin).addGap(2, 2, 2).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextFieldCommand, -2, 139, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel9, -2, 40, -2).addGap(1, 1, 1).addComponent(this.jCheckBoxVecFever).addGap(18, 18, 18).addComponent(this.jLabel10, -2, 71, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxPiTrex).addGap(166, 166, 166).addComponent(this.jButtonDebugSyntax).addContainerGap(-1, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jSplitPane1)).addGap(1, 1, 1)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jCheckBoxVecFever, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonPaste, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonSave, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonCopy, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonSaveAll, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonLoad, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonCut, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonRedo, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonUndo, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonAssemble, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonNew, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonPrettyPrint, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonRefresh, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonDebug, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonInjectBin, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldCommand, -2, -1, -2).addComponent(this.jLabel7).addComponent(this.jLabel9)).addComponent(this.jButtonDebugSyntax, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonAssembleOne, -1, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxPiTrex, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel10, -1, -1, Short.MAX_VALUE)).addComponent(this.jSplitPane1, -1, 637, Short.MAX_VALUE).addGap(1, 1, 1).addComponent(this.jPanel3, -2, -1, -2)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
    }

    private void jButtonCutActionPerformed(ActionEvent evt) {
    }

    private void jButtonPasteActionPerformed(ActionEvent evt) {
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        EditorPanel edi = this.getSelectedEditor();
        if (edi == null) {
            return;
        }
        boolean shift = false;
        if (evt != null) {
            shift = (evt.getModifiers() & 1) == 1;
        }
        edi.save(shift);
        this.printMessage("\"" + this.getSelectedEditor().getFilename() + "\" saved.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonRedoActionPerformed(ActionEvent evt) {
        EditorPanel edi = this.getSelectedEditor();
        if (edi == null) {
            return;
        }
        EditorPanel editorPanel = this.getSelectedEditor();
        synchronized (editorPanel) {
            this.getSelectedEditor().redo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonUndoActionPerformed(ActionEvent evt) {
        EditorPanel edi = this.getSelectedEditor();
        if (edi == null) {
            return;
        }
        EditorPanel editorPanel = this.getSelectedEditor();
        synchronized (editorPanel) {
            this.getSelectedEditor().undo();
        }
    }

    private void jButtonCopyActionPerformed(ActionEvent evt) {
    }

    private void jButtonSaveAllActionPerformed(ActionEvent evt) {
        this.saveAll();
    }

    private void jButtonLoadActionPerformed(ActionEvent evt) {
        if (evt != null && (evt.getModifiers() & 1) == 1) {
            if (this.getSelectedEditor() != null) {
                this.getSelectedEditor().reload(true);
            }
            return;
        }
        boolean runit = false;
        if (evt != null && (evt.getModifiers() & 2) == 2) {
            runit = true;
        }
        if (evt != null && (evt.getModifiers() & 4) == 4) {
            runit = true;
        }
        if (evt != null && (evt.getModifiers() & 8) == 8) {
            runit = true;
        }
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        if (!this.config.useLastKnownDir || this.lastPath == null || this.lastPath.length() == 0) {
            fc.setCurrentDirectory(new File(this.config.fileRequestHome));
        } else {
            fc.setCurrentDirectory(new File(this.lastPath));
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Edit (asm, s, c, i, h, txt)", "asm", "s", "c", "i", "h", "txt", "xml");
        fc.setFileFilter(filter);
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return;
        }
        if (fc == null) {
            return;
        }
        if (fc.getSelectedFile() == null) {
            return;
        }
        this.lastPath = fc.getSelectedFile().getAbsolutePath();
        try {
            this.lastPath = fc.getSelectedFile().getCanonicalPath();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.inProject) {
            this.jMenuItemCloseActionPerformed(null);
        }
        if (this.isProject(Utility.makeVideRelative(this.lastPath))) {
            if (runit) {
                this.jButtonAssembleActionPerformed(null);
            }
            return;
        }
        this.addEditor(this.lastPath, true);
        this.oneTimeTab = null;
        Path p = Paths.get(this.lastPath, new String[0]);
        this.fillTree(p.getParent());
        if (runit) {
            this.jButtonAssembleActionPerformed(null);
        }
    }

    public void startASM(final String filenameASM) {
        if (this.asmStarted) {
            return;
        }
        this.asmStarted = true;
        this.jButtonDebug.setEnabled(false);
        this.jButtonAssemble.setEnabled(false);
        if (this.one != null) {
            return;
        }
        this.one = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(10L);
                    try {
                        boolean is48K = false;
                        boolean is44K = false;
                        if (VediPanel.this.currentProject != null) {
                            is48K = (VediPanel.this.currentProject.getExtras() & Cartridge.FLAG_48K) != 0;
                            is44K = (VediPanel.this.currentProject.getExtras() & Cartridge.FLAG_44_PEER_BS) != 0;
                        }
                        Asmj asm = new Asmj(filenameASM, VediPanel.this.asmErrorOut, null, null, VediPanel.this.asmMessagesOut, "", VediPanel.this.settings.allDebugComments, is48K);
                        if (Asmj.version.length() != 0 && VediPanel.this.currentProject != null) {
                            VediPanel.this.currentProject.setVersion(Asmj.version);
                            VediPanel.this.printMessage("Project version set to: " + Asmj.version + " (found in: " + filenameASM + ")");
                        }
                        VediPanel.this.printASMList(asm.getListing(), 2);
                        String info = asm.getInfo();
                        final boolean asmOk = info.indexOf("0 errors detected.") >= 0;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                VediPanel.this.asmResult(asmOk, filenameASM);
                            }
                        });
                    }
                    catch (Throwable e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                VediPanel.this.printASMMessage("Exception while assembling: " + e.getMessage(), 1);
                                VediPanel.this.printASMMessage(Utility.getStackTrace(e), 1);
                                VediPanel.this.asmResult(false, filenameASM);
                            }
                        });
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                VediPanel.this.one = null;
                VediPanel.this.jButtonAssemble.setEnabled(true);
                VediPanel.this.jButtonDebug.setEnabled(true);
                VediPanel.this.asmStarted = false;
            }
        };
        this.one.setName("Run ASMJ with: " + filenameASM);
        this.one.start();
    }

    protected void asmResult(boolean asmOk, String filename) {
        if (asmOk) {
            String fname = this.getSelectedEditor().getFilename();
            if (fname.toLowerCase().endsWith(".c")) {
                Path p = Paths.get(fname, new String[0]);
                String pathOnly = p.getParent().toString();
                if (pathOnly.length() > 0) {
                    pathOnly = pathOnly + File.separator;
                }
                fname = VediPanel.baseOnly(filename);
            }
            if (fname.toLowerCase().endsWith(".asm")) {
                fname = fname.substring(0, fname.length() - 4);
            } else {
                int li = fname.lastIndexOf(".");
                if (li >= 0) {
                    fname = fname.substring(0, li);
                }
            }
            fname = fname + ".bin";
            boolean started = false;
            if (this.config.invokeEmulatorAfterAssembly && this.startTypeRun != 4) {
                VecXPanel vec = ((CSAMainFrame)this.mParent).getVecxy();
                if (vec != null) {
                    ((CSAMainFrame)this.mParent).getInternalFrame(vec).toFront();
                }
                boolean ask = false;
                if (this.startTypeRun == 3) {
                    String myName = fname;
                    String oldName = vec.getStartName();
                    if (!oldName.equals(myName)) {
                        ask = true;
                    }
                }
                this.checkVec4EverFile(fname);
                started = true;
                boolean doit = true;
                if (ask) {
                    int answer = JOptionPane.showOptionDialog(Configuration.getConfiguration().getMainFrame(), "The bin files appear to be not compatible, inject anyway?", "Different bin file", 2, 2, null, null, null);
                    doit = answer == 0;
                }
                if (doit) {
                    vec.startUp(fname, true, this.startTypeRun);
                    this.printMessage("Assembly successful, starting emulation...");
                }
            }
            if (!started) {
                this.checkVec4EverFile(fname);
                this.printMessage("Assembly successful...");
            }
        } else {
            this.printError("Assembly not successful, see ASM output...");
            this.jTabbedPane.setSelectedIndex(1);
        }
        this.refreshTree();
    }

    private void jButtonAssembleActionPerformed(ActionEvent evt) {
        this.jEditorPaneASMListing.setText("");
        this.jEditorASMMessages.setText("");
        this.jEditorLog.setText("");
        this.run();
    }

    @Override
    public void debug() {
        this.startTypeRun = 1;
        this.runInternal();
    }

    @Override
    public void run() {
        this.startTypeRun = 2;
        this.runInternal();
    }

    public void runInternal() {
        String fname;
        VecXPanel vec = ((CSAMainFrame)this.mParent).getVecxy();
        if (vec != null) {
            vec.breakpointClearAll();
        }
        if (this.inProject) {
            this.doBuildProject();
            return;
        }
        this.clearASMOutput();
        EditorPanel edit = this.getSelectedEditor();
        if (edit == null) {
            return;
        }
        if (!this.config.onlyManualSaveInEditor && edit.hasChanged()) {
            this.printMessage("\"" + this.getSelectedEditor().getFilename() + "\" saved.");
            edit.save(false);
        }
        if ((fname = this.getSelectedEditor().getFilename()) == null) {
            return;
        }
        if (fname.toLowerCase().endsWith(".c")) {
            FilePeeper.peepsFound = 0;
            this.doCCompilerSingleFile(fname);
        } else {
            this.startASM(fname);
        }
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
        this.tabChanged(true);
        this.initInventory();
    }

    private void jButtonSearchNextActionPerformed(ActionEvent evt) {
        EditorPanel edi = this.getSelectedEditor();
        if (edi == null) {
            return;
        }
        this.jLabel5.setText("");
        boolean found = this.getSelectedEditor().goNext(this.jTextFieldSearch.getText(), this.jCheckBoxIgnoreCase.isSelected());
        if (!found) {
            this.jLabel5.setText("not found!");
        }
    }

    private void jButtonSearchPreviousActionPerformed(ActionEvent evt) {
        this.jLabel5.setText("");
        EditorPanel edi = this.getSelectedEditor();
        if (edi == null) {
            return;
        }
        boolean found = this.getSelectedEditor().goPrevious(this.jTextFieldSearch.getText(), this.jCheckBoxIgnoreCase.isSelected());
        if (!found) {
            this.jLabel5.setText("not found!");
        }
    }

    private void jButtonIgnoreCaseActionPerformed(ActionEvent evt) {
        this.jCheckBoxIgnoreCase.setSelected(!this.jCheckBoxIgnoreCase.isSelected());
    }

    private void jButtonReplaceNextActionPerformed(ActionEvent evt) {
        this.jLabel5.setText("");
        EditorPanel edi = this.getSelectedEditor();
        if (edi == null) {
            return;
        }
        boolean found = this.getSelectedEditor().replaceNext(this.jTextFieldSearch.getText(), this.jTextFieldReplace.getText(), this.jCheckBoxIgnoreCase.isSelected(), true, false);
        if (!found) {
            this.jLabel5.setText("not found!");
        }
    }

    private void jButtonReplaceAllActionPerformed(ActionEvent evt) {
        this.jLabel5.setText("");
        EditorPanel edi = this.getSelectedEditor();
        if (edi == null) {
            return;
        }
        int found = this.getSelectedEditor().replaceAll(this.jTextFieldSearch.getText(), this.jTextFieldReplace.getText(), this.jCheckBoxIgnoreCase.isSelected());
        if (found == 0) {
            this.jLabel5.setText("not found!");
        } else {
            this.jLabel5.setText("" + found + " replaced");
        }
    }

    private void jButtonReplaceInSelectionActionPerformed(ActionEvent evt) {
        this.jLabel5.setText("");
        EditorPanel edi = this.getSelectedEditor();
        if (edi == null) {
            return;
        }
        int found = this.getSelectedEditor().replaceInSelection(this.jTextFieldSearch.getText(), this.jTextFieldReplace.getText(), this.jCheckBoxIgnoreCase.isSelected());
        if (found == 0) {
            this.jLabel5.setText("not found!");
        } else {
            this.jLabel5.setText("" + found + " replaced");
        }
    }

    private void jTextFieldReplaceActionPerformed(ActionEvent evt) {
        this.jButtonReplaceNextActionPerformed(null);
    }

    private void jTextFieldSearchKeyPressed(KeyEvent evt) {
        this.jLabel5.setText("");
    }

    private void jButtonNewActionPerformed(ActionEvent evt) {
        if (evt != null && (evt.getModifiers() & 1) == 1) {
            if (this.possibleProject == null) {
                return;
            }
            if (this.possibleProject.endsWith(File.separator)) {
                return;
            }
            this.inProject = false;
            this.closeAllEditors();
            this.settings.currentProject = null;
            this.currentProject = null;
            ProjectProperties project = new ProjectProperties();
            String nameFull = "";
            String nameOnly = "";
            String path = "";
            String projectName = "";
            String work = Utility.makeVideRelative(this.possibleProject);
            int tmp = work.lastIndexOf(File.separator);
            nameFull = tmp < 0 ? work : work.substring(tmp + 1);
            tmp = nameFull.lastIndexOf(".");
            nameOnly = nameFull.substring(0, tmp);
            work = work.substring(0, work.length() - nameFull.length());
            if (work.endsWith(File.separator)) {
                work = work.substring(0, work.length() - 1);
            }
            if (work.contains(File.separator)) {
                tmp = work.lastIndexOf(File.separator);
                projectName = work.substring(tmp + 1);
                work = work.substring(0, work.length() - projectName.length());
            } else {
                projectName = work;
            }
            if (work.endsWith(File.separator)) {
                work = work.substring(0, work.length() - 1);
            }
            path = work;
            project.setCClass("Project");
            project.setName(nameOnly);
            project.setOldPath(path);
            project.projectPrefix = path + File.separator + projectName;
            project.setProjectName(projectName);
            project.setMainFile(nameFull);
            Vector<String> bankMainFiles = new Vector<String>();
            bankMainFiles.add(nameFull);
            project.setBankMainFiles(bankMainFiles);
            Vector<String> bankDefines = new Vector<String>();
            bankDefines.add("");
            project.setBankDefines(bankDefines);
            project.setVersion("1.0");
            project.setBankswitching("none");
            project.setNumberOfBanks(1);
            project.setExtras(0);
            this.doNewProject(project, false);
            this.fileView = false;
            this.fillTree(Paths.get(Utility.makeVideAbsolute(this.currentProject.projectPrefix), new String[0]));
        }
    }

    private void jEditorASMMessagesMousePressed(MouseEvent evt) {
        Point pt;
        int pos;
        int line;
        if (evt.getClickCount() == 2 && (line = this.getLineOfPos(this.jEditorASMMessages, pos = this.jEditorASMMessages.viewToModel(pt = new Point(evt.getX(), evt.getY())))) != -1) {
            String lineString = this.getLine(this.jEditorASMMessages, line);
            if (lineString.indexOf("jEditorASMMessages") > 0) {
                return;
            }
            if (lineString.contains("******")) {
                lineString = this.getLine(this.jEditorASMMessages, line + 1);
            }
            if (lineString.contains("++++++")) {
                lineString = this.getLine(this.jEditorASMMessages, line + 1);
            }
            if (lineString.contains("######")) {
                lineString = this.getLine(this.jEditorASMMessages, line + 1);
            }
            if (lineString.length() == 0) {
                return;
            }
            this.processErrorLine(lineString);
        }
    }

    private void jTextFieldSearchActionPerformed(ActionEvent evt) {
        this.jButtonSearchNextActionPerformed(null);
    }

    static int spaceTo(StringBuilder s, int posNow, int upTo) {
        s.append(" ");
        while (true) {
            int n = ++posNow;
            ++posNow;
            if (n >= upTo) break;
            s.append(" ");
        }
        return posNow;
    }

    static String prettyQuoteLine(String line) {
        int endQuote;
        String quoteChar = "\"";
        int startQuote = line.indexOf("\"");
        if (line.indexOf("'") > startQuote) {
            quoteChar = "'";
            startQuote = line.indexOf("'");
        }
        if ((endQuote = line.lastIndexOf(quoteChar)) <= startQuote) {
            return line;
        }
        String preQuote = line.substring(0, startQuote);
        String quote = line.substring(startQuote, endQuote + 1);
        String postQuote = line.substring(endQuote + 1);
        StringBuilder b = new StringBuilder();
        String[] words = preQuote.split(" ");
        int w = 0;
        int c = 0;
        if (!UtilityString.isWordBoundry(line.charAt(0))) {
            b.append(words[w]).append(" ");
            c += words[w].length() + 1;
            ++w;
        }
        c = VediPanel.spaceTo(b, c, VideConfig.getConfig().TAB_MNEMONIC);
        if (w >= words.length) {
            b.append(quote);
            c += quote.length();
            c = VediPanel.spaceTo(b, c, VideConfig.getConfig().TAB_OP);
            b.append(postQuote);
            return b.toString();
        }
        while (words[w].length() == 0) {
            ++w;
        }
        b.append(words[w]).append(" ");
        c += words[w].length() + 1;
        ++w;
        c = VediPanel.spaceTo(b, c, VideConfig.getConfig().TAB_OP);
        while (w < words.length) {
            if (words[w].length() != 0) {
                b.append(words[w]).append(" ");
                c += words[w].length() + 1;
            }
            ++w;
        }
        b.append(quote);
        c += quote.length();
        b.append(postQuote);
        return b.toString();
    }

    static int getFirstnonQuoteComment(String line) {
        int endQuote;
        String quoteChar = "\"";
        int startQuote = line.indexOf("\"");
        if (line.indexOf("'") > startQuote) {
            quoteChar = "'";
            startQuote = line.indexOf("'");
        }
        if ((endQuote = line.lastIndexOf(quoteChar)) <= startQuote) {
            return -1;
        }
        String preQuote = line.substring(0, startQuote);
        String quote = line.substring(startQuote, endQuote + 1);
        String postQuote = line.substring(endQuote + 1);
        int ind = postQuote.indexOf(";");
        if (ind == -1) {
            return -1;
        }
        return ind + preQuote.length() + quote.length();
    }

    static String getTABString() {
        String tab = "";
        for (int i = 0; i < VideConfig.getConfig().tab_width; ++i) {
            tab = tab + " ";
        }
        return tab;
    }

    String getTabForLineBracket(int count) {
        String ret = "";
        for (int i = 0; i < count; ++i) {
            ret = ret + VediPanel.getTABString();
        }
        return ret;
    }

    String prettyPrintC(String orgText) {
        String[] lines;
        StringBuilder b = new StringBuilder();
        orgText = UtilityString.replace(orgText, "\r\n", "\n");
        orgText = UtilityString.replace(orgText, "\t", VediPanel.getTABString());
        int openBrackets = 0;
        for (String line : lines = orgText.split("\n")) {
            int bracketHelp = 0;
            if (line.trim().startsWith("}")) {
                bracketHelp = -1;
            }
            b.append(this.getTabForLineBracket(openBrackets + bracketHelp));
            b.append(line.trim());
            openBrackets += UtilityString.countChars(line, "{");
            openBrackets -= UtilityString.countChars(line, "}");
            b.append("\n");
        }
        return b.toString();
    }

    public static String prettyPrint(String orgText) {
        int w;
        int c;
        boolean inComment;
        boolean DELELTE_EMPTY_LINES = true;
        StringBuilder b = new StringBuilder();
        orgText = UtilityString.replace(orgText, "\r\n", "\n");
        orgText = UtilityString.replace(orgText, "\t", VediPanel.getTABString());
        String[] lines = orgText.split("\n");
        boolean lastLineEmpty = false;
        for (String line : lines) {
            boolean doSeperator = false;
            inComment = false;
            c = 0;
            w = 0;
            if (line.contains("\"") || line.contains("'")) {
                int commentPos = line.indexOf(";");
                int q1 = line.indexOf("\"");
                int q2 = line.indexOf("'");
                if (q1 == -1) {
                    q1 = Integer.MAX_VALUE;
                }
                if (q2 == -1) {
                    q2 = Integer.MAX_VALUE;
                }
                if (commentPos == -1) {
                    commentPos = Integer.MAX_VALUE;
                }
                if (commentPos >= q1 || commentPos >= q2) {
                    b.append(VediPanel.prettyQuoteLine(line)).append("\n");
                    continue;
                }
            }
            if (DELELTE_EMPTY_LINES) {
                if (line.trim().length() == 0) {
                    if (lastLineEmpty) {
                        lastLineEmpty = true;
                        continue;
                    }
                    b.append(line).append("\n");
                    lastLineEmpty = true;
                    continue;
                }
                if (line.charAt(0) == ';') {
                    b.append(line).append("\n");
                    lastLineEmpty = false;
                    continue;
                }
                if (line.charAt(0) == '*') {
                    b.append(line).append("\n");
                    lastLineEmpty = false;
                    continue;
                }
            } else {
                if (line.trim().length() == 0) {
                    if (!lastLineEmpty) {
                        b.append(line).append("\n");
                    }
                    lastLineEmpty = true;
                    continue;
                }
                if (line.trim().charAt(0) == ';') {
                    b.append(line).append("\n");
                    lastLineEmpty = false;
                    continue;
                }
                if (line.trim().charAt(0) == '*') {
                    b.append(line).append("\n");
                    lastLineEmpty = false;
                    continue;
                }
            }
            line = UtilityString.replace(line, "\t", VediPanel.getTABString());
            String[] words = line.split(" ");
            if (!UtilityString.isWordBoundry(line.charAt(0))) {
                b.append(words[w]).append(" ");
                c += words[w].length() + 1;
                ++w;
            }
            if (w >= words.length) {
                b.append("\n");
                lastLineEmpty = false;
                continue;
            }
            while (words[w].length() == 0) {
                ++w;
            }
            boolean shortTab = false;
            if (words[w].toLowerCase().equals("if")) {
                shortTab = true;
            }
            if (words[w].toLowerCase().equals("else")) {
                shortTab = true;
            }
            if (words[w].toLowerCase().equals("elseif")) {
                shortTab = true;
            }
            if (words[w].toLowerCase().equals("endif")) {
                shortTab = true;
            }
            if (words[w].toLowerCase().equals("ifdef")) {
                shortTab = true;
            }
            c = shortTab ? VediPanel.spaceTo(b, c, VideConfig.getConfig().SHORT_TAB_OP) : VediPanel.spaceTo(b, c, VideConfig.getConfig().TAB_MNEMONIC);
            b.append(words[w]).append(" ");
            boolean structPossible = false;
            if (words[w].toLowerCase().equals("rts")) {
                doSeperator = true;
            }
            if (words[w].toLowerCase().equals("jmp")) {
                doSeperator = true;
            }
            if (words[w].toLowerCase().equals("bra")) {
                doSeperator = true;
            }
            if (words[w].toLowerCase().equals("lbra")) {
                doSeperator = true;
            }
            if (words[w].toLowerCase().equals("end")) {
                structPossible = true;
            }
            c += words[w].length() + 1;
            ++w;
            if (structPossible) {
                structPossible = line.toLowerCase().contains("struct");
            }
            if (!structPossible && !line.toString().trim().startsWith(";")) {
                c = shortTab ? VediPanel.spaceTo(b, c, VideConfig.getConfig().SHORT_TAB_OP) : VediPanel.spaceTo(b, c, VideConfig.getConfig().TAB_OP);
            }
            while (w < words.length) {
                if (words[w].length() != 0) {
                    b.append(words[w]).append(" ");
                    c += words[w].length() + 1;
                }
                ++w;
            }
            b.append("\n");
            if (doSeperator) {
                b.append("\n");
            }
            lastLineEmpty = false;
        }
        String text = b.toString();
        b = new StringBuilder();
        lines = text.split("\n");
        lastLineEmpty = false;
        for (String line : lines) {
            inComment = false;
            c = 0;
            w = 0;
            int commentPos = -1;
            if (line.contains("\"") || line.contains("'")) {
                commentPos = line.indexOf(";");
                int q1 = line.indexOf("\"");
                int q2 = line.indexOf("'");
                if (q1 == -1) {
                    q1 = Integer.MAX_VALUE;
                }
                if (q2 == -1) {
                    q2 = Integer.MAX_VALUE;
                }
                if (commentPos == -1) {
                    commentPos = Integer.MAX_VALUE;
                }
                if (commentPos >= q1 || commentPos >= q2) {
                    commentPos = VediPanel.getFirstnonQuoteComment(line);
                }
            } else {
                commentPos = line.indexOf(";");
            }
            if (commentPos <= 0) {
                b.append(line).append("\n");
                lastLineEmpty = line.trim().length() == 0;
                continue;
            }
            if (!DELELTE_EMPTY_LINES) {
                if (line.trim().length() == 0) {
                    if (!lastLineEmpty) {
                        b.append(line).append("\n");
                    }
                    lastLineEmpty = true;
                    continue;
                }
                lastLineEmpty = false;
                if (line.trim().charAt(0) == ';') {
                    b.append(line).append("\n");
                    continue;
                }
                if (line.trim().charAt(0) == '*') {
                    b.append(line).append("\n");
                    continue;
                }
            }
            String preComment = UtilityString.trimEnd(line.substring(0, commentPos));
            String comment = line.substring(commentPos);
            b.append(preComment);
            c = preComment.length();
            c = VediPanel.spaceTo(b, c, VideConfig.getConfig().TAB_COMMENT);
            b.append(comment).append("\n");
        }
        return b.toString();
    }

    private void jButtonPrettyPrintActionPerformed(ActionEvent evt) {
        if (evt != null && (evt.getModifiers() & 1) == 1) {
            if (this.inProject && this.currentProject.getIsPeerCProject()) {
                this.peerClean(this.currentProject.projectPrefix, 0);
                this.peerClean(this.currentProject.projectPrefix, 1);
                this.refreshTree();
            }
            this.cInfo.resetDefinitions();
            this.asmInfo.resetDefinitions();
            this.initInventory();
            this.reDisplayAll();
            return;
        }
        if (this.getSelectedEditor() == null) {
            return;
        }
        String text = this.getSelectedEditor().getText();
        if (this.getSelectedEditor().assume6809Asm) {
            text = VediPanel.prettyPrint(text);
        } else if (this.getSelectedEditor().assume6809C) {
            text = this.prettyPrintC(text);
        }
        this.getSelectedEditor().stopColoring();
        this.getSelectedEditor().setText(text);
        this.getSelectedEditor().startColoring(this.settings.fontSize);
        this.initInventory();
    }

    private void jMenuItemNewFileActionPerformed(ActionEvent evt) {
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        if (!this.config.useLastKnownDir || this.lastPath == null || this.lastPath.length() == 0) {
            fc.setCurrentDirectory(new File(this.config.fileRequestHome));
        } else {
            fc.setCurrentDirectory(new File(this.lastPath));
        }
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return;
        }
        this.lastPath = fc.getSelectedFile().getAbsolutePath();
        File newFile = new File(this.lastPath);
        if (newFile.exists()) {
            int answer = JOptionPane.showOptionDialog(Configuration.getConfiguration().getMainFrame(), "The file already exists, do you really want\nto create a new file?\n\nAll previous data will be lost!", "File exists", 2, 2, null, null, null);
            if (answer == 0) {
                System.out.println("YES");
            } else {
                System.out.println("NO");
                return;
            }
        }
        UtilityFiles.createTextFile(this.lastPath, "");
        this.addEditor(this.lastPath, true);
        this.oneTimeTab = null;
        this.refreshTree();
    }

    public void addTempEditFile(String filePath) {
        this.addEditor(filePath, false);
        this.oneTimeTab = null;
        this.refreshTree();
    }

    private void jMenuItemNewProjectActionPerformed(ActionEvent evt) {
        this.doNewProject();
    }

    private void jPopupMenu1MouseExited(MouseEvent evt) {
        this.jPopupMenu1.setVisible(false);
    }

    private void jButtonNewMousePressed(MouseEvent evt) {
        if (evt == null) {
            return;
        }
        if (evt != null && (evt.getModifiersEx() & 0x40) == 64) {
            return;
        }
        this.jMenuItemCFile.setVisible(false);
        if (this.currentProject != null && this.currentProject.getIsPeerCProject()) {
            this.jMenuItemCFile.setVisible(true);
        }
        this.jPopupMenu1.show(this.jButtonNew, evt.getX() - 20, evt.getY() - 20);
    }

    private void jMenuItemVectrexFileActionPerformed(ActionEvent evt) {
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        if (!this.config.useLastKnownDir || this.lastPath == null || this.lastPath.length() == 0) {
            fc.setCurrentDirectory(new File(this.config.fileRequestHome));
        } else {
            fc.setCurrentDirectory(new File(this.lastPath));
        }
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return;
        }
        this.lastPath = fc.getSelectedFile().getAbsolutePath();
        File newFile = new File(this.lastPath);
        if (newFile.exists()) {
            int answer = JOptionPane.showOptionDialog(Configuration.getConfiguration().getMainFrame(), "The file already exists, do you really want\nto create a new file?\n\nAll previous data will be lost!", "File exists", 2, 2, null, null, null);
            if (answer == 0) {
                System.out.println("YES");
            } else {
                System.out.println("NO");
                return;
            }
        }
        Path template = Paths.get(Global.mainPathPrefix, "template", "vectrexMain.template");
        UtilityFiles.copyOneFile(template.toString(), this.lastPath);
        Path include2 = Paths.get(Global.mainPathPrefix, "template", "VECTREX.I");
        Path p = Paths.get(this.lastPath, new String[0]);
        File includeFile = new File(p.getParent().toString() + File.separator + "VECTREX.I");
        UtilityFiles.copyOneFile(include2.toString(), includeFile.toString());
        this.addEditor(this.lastPath, true);
        this.oneTimeTab = null;
    }

    @Override
    protected void deselectInTree(String tabName) {
        if (this.jTree1 == null) {
            return;
        }
        if (this.jTree1.getSelectionPath() == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.jTree1.getSelectionPath().getLastPathComponent();
        if (node == null) {
            return;
        }
        TreeEntry entry = (TreeEntry)node.getUserObject();
        if (entry == null) {
            return;
        }
        if (tabName.equals(entry.name)) {
            ++this.mClassSetting;
            this.jTree1.clearSelection();
            --this.mClassSetting;
        }
    }

    private void jTree1ValueChanged(TreeSelectionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        if (!(((DefaultMutableTreeNode)evt.getPath().getLastPathComponent()).getUserObject() instanceof TreeEntry)) {
            return;
        }
        this.closeOneTimeTab();
        this.possibleProject = null;
        TreeEntry entry = (TreeEntry)((DefaultMutableTreeNode)evt.getPath().getLastPathComponent()).getUserObject();
        if (entry.type == 0) {
            return;
        }
        if (this.tabExistsSwitch(entry)) {
            if (entry.name.toLowerCase().endsWith(".asm") || entry.name.toLowerCase().endsWith(".s") || entry.name.toLowerCase().endsWith(".as9") || entry.name.toLowerCase().endsWith(".a69")) {
                this.possibleProject = entry.pathAndName.toString();
            }
            return;
        }
        if (entry.name.toLowerCase().endsWith(".asm") || entry.name.toLowerCase().endsWith(".s") || entry.name.toLowerCase().endsWith(".as9") || entry.name.toLowerCase().endsWith(".a69") || entry.name.toLowerCase().endsWith(".template") || entry.name.toLowerCase().endsWith(".i") || entry.name.toLowerCase().endsWith(".h") || entry.name.toLowerCase().endsWith(".c") || entry.name.toLowerCase().endsWith(".ec") || entry.name.toLowerCase().endsWith(".inc")) {
            this.addEditor(entry.pathAndName.toString(), true);
            this.oneTimeTab = null;
            this.possibleProject = entry.pathAndName.toString();
        } else if (entry.name.toLowerCase().endsWith(".md") || entry.name.toLowerCase().endsWith(".diz") || entry.name.toLowerCase().endsWith(".doc") || entry.name.toLowerCase().endsWith(".cc") || entry.name.toLowerCase().endsWith(".js") || entry.name.toLowerCase().endsWith(".cpp") || entry.name.toLowerCase().endsWith(".java") || entry.name.toLowerCase().endsWith(".xml") || entry.name.toLowerCase().endsWith(".html") || entry.name.toLowerCase().endsWith(".bat") || entry.name.toLowerCase().endsWith(".man") || entry.name.toLowerCase().endsWith(".lst") || entry.name.toLowerCase().endsWith(".map") || entry.name.toLowerCase().endsWith(".s19") || entry.name.toLowerCase().endsWith(".rel") || entry.name.toLowerCase().endsWith(".hlr") || entry.name.toLowerCase().endsWith(".rst") || entry.name.toLowerCase().endsWith(".cnt")) {
            this.addEditor(entry.pathAndName.toString(), true);
        } else if (entry.name.toLowerCase().endsWith(".txt")) {
            this.addEditor(entry.pathAndName.toString(), true);
            this.oneTimeTab = null;
        } else if (entry.name.toLowerCase().endsWith(".png") || entry.name.toLowerCase().endsWith(".jpg") || entry.name.toLowerCase().endsWith(".gif") || entry.name.toLowerCase().endsWith(".bmp")) {
            this.addImageDisplay(entry.pathAndName.toString(), false);
        } else {
            this.addBinaryDisplay(entry.pathAndName.toString(), false);
        }
        this.initInventory();
    }

    private void jTree1MousePressed(MouseEvent evt) {
        this.selectedTreeEntry = null;
        this.selectedTreePath = null;
        if (SwingUtilities.isRightMouseButton(evt)) {
            if (this.root == null) {
                return;
            }
            int rowReal = this.jTree1.getRowForLocation(evt.getX(), evt.getY());
            int row = this.jTree1.getClosestRowForLocation(evt.getX(), evt.getY());
            this.selectedTreePath = this.jTree1.getPathForLocation(evt.getX(), evt.getY());
            this.jTree1.setSelectionRow(row);
            if (this.jTree1.getSelectionPath() == null) {
                return;
            }
            if ((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getLastPathComponent() == this.root) {
                if (rowReal != row) {
                    this.jPopupMenuTree.show(evt.getComponent(), evt.getX(), evt.getY());
                    this.selectedTreeEntry = null;
                    return;
                }
                this.jPopupMenuProjectProperties.show(evt.getComponent(), evt.getX(), evt.getY());
                return;
            }
            if (this.jTree1.getSelectionPath().getLastPathComponent() == null) {
                return;
            }
            if (((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getLastPathComponent()).getUserObject() == null) {
                return;
            }
            TreeEntry te = (TreeEntry)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getLastPathComponent()).getUserObject();
            if (te.type == 0) {
                if (this.currentProject != null && this.currentProject.getIsPeerCProject() && te.name.equals("lib")) {
                    this.showAddLibPopup(evt);
                }
                return;
            }
            this.selectedTreeEntry = te;
            this.jMenuItemModi.setEnabled(te.name.toLowerCase().endsWith(".mod"));
            this.jMenuItemYM.setEnabled(te.name.toLowerCase().endsWith(".ym"));
            this.jMenuItemASFX.setEnabled(te.name.toLowerCase().endsWith(".afx"));
            this.jMenuItemAKS.setEnabled(te.name.toLowerCase().endsWith(".bin"));
            this.jMenuItemRaster.setEnabled(te.name.toLowerCase().endsWith(".jpg") || te.name.toLowerCase().endsWith(".gif") || te.name.toLowerCase().endsWith(".png") || te.name.toLowerCase().endsWith(".bmp"));
            this.jMenuItemVector.setEnabled(te.name.toLowerCase().endsWith(".jpg") || te.name.toLowerCase().endsWith(".gif") || te.name.toLowerCase().endsWith(".png") || te.name.toLowerCase().endsWith(".bmp"));
            this.jPopupMenuTree.show(evt.getComponent(), evt.getX(), evt.getY());
        }
        if (evt.getClickCount() == 2 && this.jTree1.getSelectionPath() != null && this.jTree1.getSelectionPath().getLastPathComponent() != null) {
            TreeEntry te = (TreeEntry)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getLastPathComponent()).getUserObject();
            if (te.type == 0) {
                return;
            }
            if (te.name.toLowerCase().endsWith(".bin")) {
                VecXPanel vec = ((CSAMainFrame)this.mParent).getVecxy();
                ((CSAMainFrame)this.mParent).getInternalFrame(vec).toFront();
                String fname = te.pathAndName.toString();
                vec.startUp(fname, true, 2);
                this.printMessage("Starting emulation...");
            } else {
                String fname = te.pathAndName.toString();
                CSAMainFrame.invokeSystemFile(new File(fname));
            }
        }
    }

    void addLibItem(ActionEvent evt) {
        String sourceInc = Global.mainPathPrefix + "C" + File.separator + "PeerC" + File.separator + "vide" + File.separator + "include";
        String source = Global.mainPathPrefix + "C" + File.separator + "PeerC" + File.separator + "vide" + File.separator + "lib";
        String dest = this.currentProject.projectPrefix;
        String destInc = this.currentProject.projectPrefix;
        dest = dest + File.separator + "lib" + File.separator;
        destInc = destInc + File.separator + "include";
        JMenuItem item = (JMenuItem)evt.getSource();
        String baseName = item.getText();
        UtilityFiles.copyOneFile(source + File.separator + baseName + ".rel", dest + File.separator + baseName + ".rel");
        UtilityFiles.copyOneFile(source + File.separator + baseName + ".lst", dest + File.separator + baseName + ".lst");
        UtilityFiles.copyOneFile(sourceInc + File.separator + baseName + ".h", destInc + File.separator + baseName + ".h");
        this.refreshTree();
    }

    void showAddLibPopup(MouseEvent evt) {
        File[] fList;
        JPopupMenu jPopupMenu = new JPopupMenu();
        String source = Global.mainPathPrefix + "C" + File.separator + "PeerC" + File.separator + "vide" + File.separator + "lib";
        File directory = new File(source);
        for (File file : fList = directory.listFiles()) {
            String fileNameOnly = file.getName();
            if (!fileNameOnly.endsWith(".rel")) continue;
            String nameonly = VediPanel.baseOnly(fileNameOnly);
            JMenuItem item = new JMenuItem(nameonly);
            item.setText(nameonly);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    VediPanel.this.addLibItem(evt);
                }
            });
            jPopupMenu.add(item);
        }
        jPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
    }

    private void jMenuItemFilePropertiesActionPerformed(ActionEvent evt) {
        this.doFileProperties(this.selectedTreeEntry);
    }

    private void jMenuItemProjectPropertiesActionPerformed(ActionEvent evt) {
        this.doProjectProperties();
        if (this.currentProject.getIsPeerCProject()) {
            String flags = this.currentProject.getCFLAGS();
            boolean hasFramePointer = true;
            if (flags.contains("-fomit-frame-pointer")) {
                hasFramePointer = false;
            }
            this.resetCScan(hasFramePointer);
        }
    }

    private void jMenuItemModiActionPerformed(ActionEvent evt) {
        this.doMod2Vectrex();
    }

    private void jTabbedPaneStateChanged(ChangeEvent evt) {
        Rectangle r = this.jPanel3.getBounds();
        r.height = 27;
        this.jPanel3.setBounds(r);
    }

    private void jMenuItemRenameActionPerformed(ActionEvent evt) {
        if (this.selectedTreePath == null) {
            return;
        }
        this.jTree1.startEditingAtPath(this.selectedTreePath);
    }

    private void jMenuItemDeleteActionPerformed(ActionEvent evt) {
        FilePropertiesPool pool;
        FileProperties fileProperties;
        File ttest = new File(this.selectedTreeEntry.pathAndName.toString());
        if (ttest.isDirectory()) {
            return;
        }
        UtilityFiles.deleteFile(this.selectedTreeEntry.pathAndName.toString());
        String type = "";
        String pathFull = "";
        String pathOnly = "";
        String filenameOnly = "";
        String filenameBaseOnly = "";
        Path p = Paths.get(this.selectedTreeEntry.pathAndName.toString(), new String[0]);
        pathFull = p.toString();
        pathOnly = p.getParent().toString();
        filenameOnly = p.getFileName().toString();
        if (filenameOnly.contains(".")) {
            filenameBaseOnly = filenameOnly.substring(0, filenameOnly.indexOf("."));
            type = filenameOnly.substring(filenameOnly.indexOf(".") + 1);
        } else {
            filenameBaseOnly = filenameOnly;
        }
        File test = new File(pathOnly + File.separator + filenameBaseOnly + "FileProperty.xml");
        if (test.exists() && (fileProperties = (pool = new FilePropertiesPool((pathOnly = Utility.makeVideRelative(pathOnly)) + File.separator, test.getName())).get(filenameOnly)) != null && fileProperties.getFilename().endsWith(filenameOnly)) {
            UtilityFiles.deleteFile(Global.mainPathPrefix + pathOnly + File.separator + filenameBaseOnly + "FileProperty.xml");
        }
        this.refreshTree();
    }

    private void jMenuItemRefreshActionPerformed(ActionEvent evt) {
        this.refreshTree();
    }

    private void jMenuItemDuplicateActionPerformed(ActionEvent evt) {
        if (this.selectedTreeEntry == null) {
            return;
        }
        UtilityFiles.copyOneFile(this.selectedTreeEntry.pathAndName.toString(), this.selectedTreeEntry.pathAndName.toString() + ".copy");
        this.refreshTree();
    }

    private void jMenuItemAddToProjectActionPerformed(ActionEvent evt) {
        if (!this.inProject) {
            return;
        }
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        fc.setMultiSelectionEnabled(true);
        if (!this.config.useLastKnownDir || this.lastPath == null || this.lastPath.length() == 0) {
            fc.setCurrentDirectory(new File(this.config.fileRequestHome));
        } else {
            fc.setCurrentDirectory(new File(this.lastPath));
        }
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return;
        }
        File[] files = fc.getSelectedFiles();
        if (files == null) {
            File f = fc.getSelectedFile();
            if (f != null) {
                String fullPath;
                this.lastPath = fullPath = f.getAbsolutePath();
                this.addFileToProject(f);
            }
        } else if (files.length > 0) {
            String fullPath;
            this.lastPath = fullPath = files[0].getAbsolutePath();
            for (File f : files) {
                this.addFileToProject(f);
            }
        }
        this.fillTree(Paths.get(Utility.makeVideAbsolute(this.currentProject.projectPrefix), new String[0]));
    }

    private void jMenuItemCloseActionPerformed(ActionEvent evt) {
        this.inProject = false;
        this.fillTree();
        this.closeAllEditors();
        this.asmInfo.clearDefinitions();
        this.cInfo.clearDefinitions();
        this.settings.currentProject = null;
        this.currentProject = null;
    }

    public void closeProject() {
        this.inProject = false;
        this.fillTree();
        this.closeAllEditors();
        this.asmInfo.clearDefinitions();
        this.cInfo.clearDefinitions();
        this.settings.currentProject = null;
        this.currentProject = null;
    }

    private void jListProjectsMousePressed(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            VediSettings.P p;
            int index = this.jListProjects.locationToIndex(evt.getPoint());
            if (index == -1) {
                return;
            }
            this.settings.currentProject = p = (VediSettings.P)this.projectsListModel.elementAt(index);
            if (this.settings.currentProject != null && this.settings.currentProject.mName.trim().length() != 0) {
                this.closeAllEditors();
                this.asmInfo.clearDefinitions();
                this.cInfo.clearDefinitions();
                String path = this.settings.currentProject.mFullPath;
                this.loadProject(this.settings.currentProject.mClass, this.settings.currentProject.mName, path);
            }
            this.jTabbedPane2.setSelectedIndex(0);
        }
    }

    private void jListFilesMousePressed(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            int index = this.jListFiles.locationToIndex(evt.getPoint());
            if (index == -1) {
                return;
            }
            EditorFileSettings fn = this.settings.recentOpenFiles.get(index);
            EditorPanel edi = this.addEditor(Utility.makeVideAbsolute(fn.filename), true);
            if (edi != null) {
                edi.setPosition(fn.position);
            }
            this.oneTimeTab = null;
            if (edi == null) {
                this.settings.currentOpenFiles.remove(fn);
            }
            if (!this.inProject) {
                if (edi != null) {
                    this.fillTree(Paths.get(Utility.makeVideAbsolute(fn.filename), new String[0]).getParent());
                } else {
                    this.fillTree();
                }
            }
            this.jTabbedPane2.setSelectedIndex(0);
        }
    }

    private void jMenuItemSetMainActionPerformed(ActionEvent evt) {
        if (!this.inProject) {
            return;
        }
        String filename = this.selectedTreeEntry.name.toString();
        this.currentProject.setMainFile(filename);
        this.currentProject.getBankMainFiles().remove(0);
        this.currentProject.getBankMainFiles().add(0, filename);
        this.saveProject();
    }

    private void jMenuItemActionActionPerformed(ActionEvent evt) {
        File test;
        String fileNameOnly;
        if (this.selectedTreeEntry == null) {
            return;
        }
        String filename = this.selectedTreeEntry.pathAndName.toString();
        File file = new File(filename);
        String path = file.getParent();
        String fileNameBare = fileNameOnly = file.getName();
        int li = fileNameOnly.lastIndexOf(".");
        if (li >= 0) {
            fileNameBare = fileNameOnly.substring(0, li);
        }
        if (path.length() != 0) {
            path = path + File.separator;
        }
        if ((test = new File(path + fileNameBare + "FileProperty.xml")).exists()) {
            ExecutionDescriptor ed;
            String scriptName;
            FilePropertiesPool pool;
            FileProperties fileProperties;
            String pathOnly = test.getParent().toString();
            if ((pathOnly = Utility.makeVideRelative(pathOnly)).length() != 0) {
                pathOnly = pathOnly + File.separator;
            }
            if ((fileProperties = (pool = new FilePropertiesPool(pathOnly, test.getName())).get(fileNameOnly)) == null) {
                return;
            }
            String scriptClass = fileProperties.getActionScriptClass();
            if (!ScriptDataPanel.executeScript(scriptClass, scriptName = fileProperties.getActionScriptName(), this, ed = new ExecutionDescriptor(ExecutionDescriptor.ED_TYPE_FILE_ACTION, this.currentProject.getProjectName(), fileNameOnly, "VediPanel", Utility.makeVideAbsolute(pathOnly)))) {
                this.printWarning("Script for " + fileNameOnly + " returned with error!");
            }
        }
        this.scanTreeDirectory(this.selectedTreeEntry);
    }

    private void jButtonClearMessagesActionPerformed(ActionEvent evt) {
        if (evt != null && (evt.getModifiers() & 1) == 1) {
            final String to = Global.mainPathPrefix + "tmp" + File.separator + "BIOS.ASM";
            File biosFile = new File(to);
            if (!biosFile.exists()) {
                String from = Global.mainPathPrefix + "codelib" + File.separator + "Originals" + File.separator + "BIOS - Bruce Tomlin" + File.separator + "BIOS.ASM";
                UtilityFiles.copyOneFile(from, to);
            }
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VediPanel.this.jumpToEdit(to, 0);
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.jEditorPaneASMListing.setText("");
        this.jEditorASMMessages.setText("");
        this.jEditorLog.setText("");
    }

    private void jMenuItemRasterActionPerformed(ActionEvent evt) {
        this.doRasterImage();
    }

    private void jMenuItemSampleActionPerformed(ActionEvent evt) {
        this.doSample();
        this.refreshTree();
    }

    private void jMenuItemYMActionPerformed(ActionEvent evt) {
        String type = "";
        String pathFull = "";
        String pathOnly = "";
        String filenameOnly = "";
        String filenameBaseOnly = "";
        Path p = Paths.get(this.selectedTreeEntry.pathAndName.toString(), new String[0]);
        pathFull = p.toString();
        pathOnly = p.getParent().toString();
        filenameOnly = p.getFileName().toString();
        YMJPanel.showYMPanelNoModal(pathFull, this);
    }

    private void jMenuItemASFXActionPerformed(ActionEvent evt) {
        this.doAYFX();
    }

    private void jButtonRefreshActionPerformed(ActionEvent evt) {
        this.fileView = evt != null && (evt.getModifiers() & 1) == 1;
        this.refreshTree();
    }

    private void jMenuItemVectorActionPerformed(ActionEvent evt) {
        this.doVector();
    }

    private void jButtonNew1MousePressed(MouseEvent evt) {
    }

    private void jButtonNew1ActionPerformed(ActionEvent evt) {
        this.settings.recentOpenFiles = new ArrayList();
        this.updateList();
    }

    private void jButtonNew7MousePressed(MouseEvent evt) {
    }

    private void jButtonNew7ActionPerformed(ActionEvent evt) {
        this.settings.recentProject = new ArrayList();
        this.updateList();
    }

    private void jButtonDebugActionPerformed(ActionEvent evt) {
        this.debug();
    }

    private void jMenuItemVecSpeechActionPerformed(ActionEvent evt) {
        String path = "";
        if (this.inProject && this.currentProject != null) {
            path = Utility.makeVideAbsolute(this.currentProject.projectPrefix) + File.separator;
        }
        VecSpeechPanel.showVecSpeechPanelNoModal(this, path);
    }

    private void jButtonInjectBinActionPerformed(ActionEvent evt) {
        VecXPanel vec = ((CSAMainFrame)this.mParent).getVecxy();
        if (vec == null) {
            return;
        }
        if (!vec.isRunning() && !vec.isDebuging()) {
            this.printError("Vecxi not running!");
            return;
        }
        this.startTypeRun = 3;
        this.runInternal();
    }

    private void jCheckBoxVecFeverActionPerformed(ActionEvent evt) {
        this.settings.v4eEnabled = this.jCheckBoxVecFever.isSelected();
    }

    private void jButtonFontPlusActionPerformed(ActionEvent evt) {
        this.increaseFontSize();
    }

    private void jButtonFontMinusActionPerformed(ActionEvent evt) {
        this.decreaseFontSize();
    }

    private void jTableBookmarksMousePressed(MouseEvent evt) {
        JTable table = (JTable)evt.getSource();
        Point p = evt.getPoint();
        int row = table.rowAtPoint(p);
        int col = table.columnAtPoint(p);
        if (evt.getClickCount() == 2) {
            this.goBookmark(row);
        }
        if (evt.getButton() == 3) {
            this.popupRow = row;
            this.jPopupMenuBM.show(this.jTableBookmarks, evt.getX() - 20, evt.getY() - 20);
        }
    }

    private void jTableBreakpointsMousePressed(MouseEvent evt) {
        JTable table = (JTable)evt.getSource();
        Point p = evt.getPoint();
        int row = table.rowAtPoint(p);
        int col = table.columnAtPoint(p);
        if (evt.getButton() == 3) {
            this.popupRow = row;
            this.jPopupMenuBP.show(this.jTableBreakpoints, evt.getX() - 20, evt.getY() - 20);
        }
        if (evt.getClickCount() == 2) {
            this.goBreakpoint(this.breakpointModel.getDebugComment(row));
        }
    }

    private void jMenuItemRemoveBPActionPerformed(ActionEvent evt) {
        if (this.popupRow < 0) {
            return;
        }
        DebugComment dbc = this.breakpointModel.getDebugComment(this.popupRow);
        DebugCommentList list2 = this.getDebugComments(dbc.file);
        if (list2 == null) {
            return;
        }
        int line = dbc.beforLineNo;
        list2.removeComment(dbc);
        this.updateTables();
        EditorPanel edi = this.getEditor(dbc.file, false);
        if (edi == null) {
            return;
        }
        edi.correctLine(line);
    }

    private void jButtonDebugSyntaxActionPerformed(ActionEvent evt) {
        SyntaxDebugJPanel.showSyntaxDebugPanelNoModal(this.UID);
    }

    private void jTableInventoryMousePressed(MouseEvent evt) {
        JTable table = (JTable)evt.getSource();
        Point p = evt.getPoint();
        int row = table.rowAtPoint(p);
        int col = table.columnAtPoint(p);
        row = this.sorter.convertRowIndexToModel(row);
        if (evt.getClickCount() == 2) {
            this.goFunction(row);
        }
    }

    private void jButtonAdressBackActionPerformed(ActionEvent evt) {
        this.historyBack();
    }

    private void jButtonAdressForwardActionPerformed(ActionEvent evt) {
        this.historyForward();
    }

    private void jButtonLabelConfigActionPerformed(ActionEvent evt) {
        LabelVisibilityConfigPanel.showEnterValueDialog(this.settings);
        this.initInventory();
    }

    private void jTableWatchesMousePressed(MouseEvent evt) {
        JTable table = (JTable)evt.getSource();
        Point p = evt.getPoint();
        int row = table.rowAtPoint(p);
        int col = table.columnAtPoint(p);
        if (evt.getButton() == 3) {
            this.popupRow = row;
            this.jPopupMenuWatch.show(this.jTableWatches, evt.getX() - 20, evt.getY() - 20);
        }
    }

    private void jMenuItemRemoveWatchActionPerformed(ActionEvent evt) {
        if (this.popupRow < 0) {
            return;
        }
        DebugComment dbc = this.watchesModel.getDebugComment(this.popupRow);
        DebugCommentList list2 = this.getDebugComments(dbc.file);
        if (list2 == null) {
            return;
        }
        list2.removeComment(dbc);
        this.updateTables();
    }

    private void jMenuItem1AddNewFileActionPerformed(ActionEvent evt) {
        if (this.selectedTreeEntry == null) {
            return;
        }
        String dir = Global.mainPathPrefix;
        if (this.selectedTreeEntry.pathAndName.getParent() != null) {
            dir = this.selectedTreeEntry.pathAndName.getParent() + File.separator;
        }
        UtilityFiles.createTextFile(dir + "newFile.asm", "");
        this.refreshTree();
    }

    private void jMenuItemAKSActionPerformed(ActionEvent evt) {
        this.doAKS();
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        if (this.selectedTreeEntry == null) {
            return;
        }
        this.doCCompilerSingleFile(this.selectedTreeEntry.pathAndName.toString());
        this.refreshTree();
    }

    private void jTabbedPaneMousePressed(MouseEvent evt) {
    }

    private void jEditorLogMousePressed(MouseEvent evt) {
        Point pt;
        int pos;
        int line;
        if (evt.getClickCount() == 2 && (line = this.getLineOfPos(this.jEditorLog, pos = this.jEditorLog.viewToModel(pt = new Point(evt.getX(), evt.getY())))) != -1) {
            String lineString = this.getLine(this.jEditorLog, line);
            if (!lineString.contains(": error")) {
                return;
            }
            if (lineString.indexOf(": error") < 2) {
                return;
            }
            String filename = "";
            String linenumber = "";
            filename = lineString.substring(0, lineString.indexOf(": error"));
            File f = new File(filename = filename.substring(0, filename.lastIndexOf(":")));
            if (!f.exists() && filename.lastIndexOf(":") > 0) {
                filename = filename.substring(0, filename.lastIndexOf(":"));
            }
            linenumber = UtilityString.replace(lineString, filename + ":", "");
            linenumber = linenumber.substring(0, linenumber.indexOf(":"));
            int lineNoI = DASM6809.toNumber(linenumber);
            this.processErrorLine(filename, lineNoI);
        }
    }

    private void jButtonAssembleOneActionPerformed(ActionEvent evt) {
        this.startTypeRun = 4;
        this.runInternal();
    }

    private void jButtonAssembleOne1ActionPerformed(ActionEvent evt) {
        this.toAssi();
        this.refreshTree();
    }

    private void jButtonAssembleOne2ActionPerformed(ActionEvent evt) {
        this.jButtonClearMessagesActionPerformed(null);
        this.toAs6809();
        this.refreshTree();
    }

    private void jButtonAssembleOne3ActionPerformed(ActionEvent evt) {
        this.jButtonClearMessagesActionPerformed(null);
        this.preprocessOnly();
        this.refreshTree();
    }

    private void jButtonAssembleOne4ActionPerformed(ActionEvent evt) {
        this.jButtonClearMessagesActionPerformed(null);
        this.doAS6809();
        this.refreshTree();
    }

    private void jMenuItemCFileActionPerformed(ActionEvent evt) {
        if (this.currentProject == null) {
            return;
        }
        if (!this.currentProject.getIsPeerCProject()) {
            return;
        }
        String baseProjectPath = this.currentProject.projectPrefix + File.separator + "source" + File.separator;
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        fc.setCurrentDirectory(new File(Utility.makeVideAbsolute(baseProjectPath)));
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return;
        }
        this.lastPath = fc.getSelectedFile().getAbsolutePath();
        File newFile = new File(this.lastPath);
        if (newFile.exists()) {
            int answer = JOptionPane.showOptionDialog(Configuration.getConfiguration().getMainFrame(), "The file already exists, do you really want\nto create a new file?\n\nAll previous data will be lost!", "File exists", 2, 2, null, null, null);
            if (answer == 0) {
                System.out.println("YES");
            } else {
                System.out.println("NO");
                return;
            }
        }
        Path template = Paths.get(Global.mainPathPrefix, "template", "template.c");
        UtilityFiles.copyOneFile(template.toString(), this.lastPath);
        this.addEditor(this.lastPath, true);
        this.oneTimeTab = null;
        this.refreshTree();
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        if (this.jCheckBox1.isSelected()) {
            this.initScheduler();
            this.log.addLog("scheduling was switched on manually", LogPanel.INFO);
        } else {
            this.deinitScheduler();
            this.log.addLog("scheduling was switched off manually", LogPanel.INFO);
        }
    }

    private void jTextFieldCommandActionPerformed(ActionEvent evt) {
        String command = this.jTextFieldCommand.getText();
        this.jTextFieldCommand.setText("");
        this.doQuickHelp(command, command);
    }

    private void jButtonAssembleOne5ActionPerformed(ActionEvent evt) {
        String[] lines;
        this.jButtonClearMessagesActionPerformed(null);
        if (this.getSelectedEditor() == null) {
            return;
        }
        String fn = this.getSelectedEditor().getFilename();
        if (!(fn.toLowerCase().endsWith("s") || fn.toLowerCase().endsWith("i") || fn.toLowerCase().endsWith("asm"))) {
            return;
        }
        if (!this.config.onlyManualSaveInEditor && this.getSelectedEditor().hasChanged()) {
            this.getSelectedEditor().save(false);
        }
        CustomOutputStream preprocessOut = new CustomOutputStream();
        PrintStream asmPreprocess = new PrintStream(preprocessOut);
        CustomOutputStream _errOut = new CustomOutputStream();
        PrintStream _asmErrOut = new PrintStream(_errOut);
        String o = new Asmj(fn, _asmErrOut, asmPreprocess).getAllOut();
        fn = VediPanel.changeTypeTo(fn, "asx.s");
        File f = new File(fn);
        String nameOnly = f.getName();
        Vector<String> sLines = new Vector<String>();
        for (String zeile : lines = o.split("\n")) {
            if (zeile == null || zeile.trim().length() == 0) continue;
            sLines.addElement(zeile);
        }
        CompileResult result = VediPanel.toAs6809(sLines, nameOnly);
        UtilityString.writeToTextFile(result.codeData, new File(fn));
        EditorPanel edi = this.addEditor(fn, true);
        this.refreshTree();
    }

    private void jMenuItemRemoveBMActionPerformed(ActionEvent evt) {
        if (this.popupRow < 0) {
            return;
        }
        this.removeBookmark(this.popupRow);
    }

    private void jCheckBoxPiTrexActionPerformed(ActionEvent evt) {
        this.settings.piTrexEnabled = this.jCheckBoxPiTrex.isSelected();
    }

    @Override
    public void doQuickHelp(String word, String integer) {
        if (!VediPanel.displayHelp(word)) {
            this.doCalculator(integer);
        }
    }

    public boolean doCalculator(String command) {
        try {
            Double d = DissiPanel.eval(command);
            int i = d.intValue();
            if (i < 256 && i > -128) {
                this.printMessage("Result: " + i + "(" + (i > 127 ? i - 256 : i) + "), $" + String.format("%02X", i & 0xFF) + ", " + DASM6809.printbinary(i));
            } else {
                this.printMessage("Result: " + i + "(" + (i > 127 ? i - 65536 : i) + "), $" + String.format("%X", i) + ", " + DASM6809.printbinary16(i));
            }
        }
        catch (Throwable x) {
            return false;
        }
        return true;
    }

    public String getLine(JEditorPane comp, int pos) {
        try {
            return comp.getDocument().getText(0, comp.getDocument().getLength()).split("\n")[pos];
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    int getLineOfPos(JEditorPane comp, int pos) {
        int ret = -1;
        try {
            String[] lines = comp.getDocument().getText(0, comp.getDocument().getLength()).split("\n");
            int c = -1;
            for (int count = 0; count <= pos; count += lines[++c].length() + 1) {
            }
            if (c < lines.length) {
                ret = c;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    EditorPanel getSelectedEditor() {
        if (this.jTabbedPane1.getSelectedComponent() instanceof EditorPanel) {
            return (EditorPanel)this.jTabbedPane1.getSelectedComponent();
        }
        return null;
    }

    @Override
    public void editorChanged(EditorEvent ev) {
        this.tabChanged(false);
    }

    @Override
    public void printMessage(String s) {
        if (s.trim().length() == 0) {
            return;
        }
        try {
            if (s.endsWith("\n")) {
                this.jEditorLog.getDocument().insertString(this.jEditorLog.getDocument().getLength(), s, TokenStyles.getStyle("editLogMessage"));
            } else {
                this.jEditorLog.getDocument().insertString(this.jEditorLog.getDocument().getLength(), s + "\n", TokenStyles.getStyle("editLogMessage"));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.jEditorLog.setCaretPosition(this.jEditorLog.getDocument().getLength());
    }

    public void printNoLNMessage(String s) {
        if (s.trim().length() == 0) {
            return;
        }
        try {
            this.jEditorLog.getDocument().insertString(this.jEditorLog.getDocument().getLength(), s, TokenStyles.getStyle("editLogMessage"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.jEditorLog.setCaretPosition(this.jEditorLog.getDocument().getLength());
    }

    @Override
    public void printWarning(String s) {
        if (s.trim().length() == 0) {
            return;
        }
        try {
            if (s.endsWith("\n")) {
                this.jEditorLog.getDocument().insertString(this.jEditorLog.getDocument().getLength(), s, TokenStyles.getStyle("editLogWarning"));
            } else {
                this.jEditorLog.getDocument().insertString(this.jEditorLog.getDocument().getLength(), s + "\n", TokenStyles.getStyle("editLogWarning"));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.jEditorLog.setCaretPosition(this.jEditorLog.getDocument().getLength());
    }

    public void printNoLNWarning(String s) {
        if (s.trim().length() == 0) {
            return;
        }
        try {
            this.jEditorLog.getDocument().insertString(this.jEditorLog.getDocument().getLength(), s, TokenStyles.getStyle("editLogWarning"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.jEditorLog.setCaretPosition(this.jEditorLog.getDocument().getLength());
    }

    @Override
    public void printError(String s) {
        if (s.trim().length() == 0) {
            return;
        }
        try {
            if (s.endsWith("\n")) {
                this.jEditorLog.getDocument().insertString(this.jEditorLog.getDocument().getLength(), s, TokenStyles.getStyle("editLogError"));
            } else {
                this.jEditorLog.getDocument().insertString(this.jEditorLog.getDocument().getLength(), s + "\n", TokenStyles.getStyle("editLogError"));
            }
        }
        catch (Throwable e) {
            System.out.println(e);
            e.printStackTrace();
        }
        this.jEditorLog.setCaretPosition(this.jEditorLog.getDocument().getLength());
    }

    public void printNoLNError(String s) {
        if (s.trim().length() == 0) {
            return;
        }
        try {
            this.jEditorLog.getDocument().insertString(this.jEditorLog.getDocument().getLength(), s, TokenStyles.getStyle("editLogError"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.jEditorLog.setCaretPosition(this.jEditorLog.getDocument().getLength());
    }

    @Override
    public void printMessageSU(final String s) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VediPanel.this.printMessage(s);
            }
        });
    }

    @Override
    public void printWarningSU(final String s) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VediPanel.this.printWarning(s);
            }
        });
    }

    @Override
    public void printErrorSU(final String s) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VediPanel.this.printError(s);
            }
        });
    }

    @Override
    public void printASMList(String s, int type) {
        try {
            if (type == 2) {
                if (s.startsWith("******")) {
                    this.jEditorPaneASMListing.getDocument().insertString(this.jEditorPaneASMListing.getDocument().getLength(), s, TokenStyles.getStyle("editLogError"));
                } else if (s.startsWith("++++++")) {
                    this.jEditorPaneASMListing.getDocument().insertString(this.jEditorPaneASMListing.getDocument().getLength(), s, TokenStyles.getStyle("editLogWarning"));
                } else if (s.startsWith("######")) {
                    this.jEditorPaneASMListing.getDocument().insertString(this.jEditorPaneASMListing.getDocument().getLength(), s, TokenStyles.getStyle("editLogComment"));
                } else {
                    this.jEditorPaneASMListing.getDocument().insertString(this.jEditorPaneASMListing.getDocument().getLength(), s, TokenStyles.getStyle("editLogMessage"));
                }
            } else if (type == 3) {
                this.jEditorPaneASMListing.getDocument().insertString(this.jEditorPaneASMListing.getDocument().getLength(), s, TokenStyles.getStyle("editLogWarning"));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.jEditorPaneASMListing.setCaretPosition(this.jEditorPaneASMListing.getDocument().getLength());
    }

    @Override
    public void printASMMessage(String s, int type) {
        try {
            if (type == 0) {
                this.jEditorASMMessages.getDocument().insertString(this.jEditorASMMessages.getDocument().getLength(), s, TokenStyles.getStyle("editLogMessage"));
            } else if (type == 1) {
                this.jEditorASMMessages.getDocument().insertString(this.jEditorASMMessages.getDocument().getLength(), s, TokenStyles.getStyle("editLogError"));
            } else if (type == 2) {
                this.jEditorASMMessages.getDocument().insertString(this.jEditorASMMessages.getDocument().getLength(), s, TokenStyles.getStyle("editLogWarning"));
            } else if (type == 3) {
                this.jEditorASMMessages.getDocument().insertString(this.jEditorASMMessages.getDocument().getLength(), s, TokenStyles.getStyle("editLogComment"));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.jEditorASMMessages.setCaretPosition(this.jEditorASMMessages.getDocument().getLength());
    }

    @Override
    public void tabChanged(boolean really) {
        if (this.getSelectedEditor() == null) {
            this.jButtonRedo.setEnabled(false);
            this.jButtonUndo.setEnabled(false);
            this.jLabel3.setText("0 chars");
            this.jLabel4.setText("row/col: 0/0");
            this.jLabel5.setText("");
            return;
        }
        this.jButtonRedo.setEnabled(this.getSelectedEditor().canRedo());
        this.jButtonUndo.setEnabled(this.getSelectedEditor().canUndo());
        this.jLabel3.setText("" + this.getSelectedEditor().getCharCount() + " chars");
        Point p = this.getSelectedEditor().getCursorPos();
        this.jLabel4.setText("row/col: " + p.y + "/" + p.x);
        if (really) {
            this.jLabel5.setText("");
        }
        if (really) {
            this.getSelectedEditor().reColor();
        }
    }

    @Override
    protected boolean closeRequested(String tabName) {
        JPanel edit;
        int count = this.jTabbedPane1.getTabCount();
        int found = -1;
        for (int i = 0; i < count; ++i) {
            if (!tabName.equals(this.jTabbedPane1.getTitleAt(i))) continue;
            found = i;
            break;
        }
        if (found == -1) {
            return false;
        }
        Component com = this.jTabbedPane1.getComponentAt(found);
        if (this.jTabbedPane1.getComponentAt(found) instanceof EditorPanel) {
            edit = (EditorPanel)this.jTabbedPane1.getComponentAt(found);
            this.settings.removeOpen(((EditorPanel)edit).getFilename());
            if (((EditorPanel)edit).isAddToSettings()) {
                this.settings.removeRecent(((EditorPanel)edit).getFilename());
                this.settings.addRecent(((EditorPanel)edit).getFilename(), ((EditorPanel)edit).getPosition());
                this.updateList();
            }
            ((EditorPanel)edit).deinit();
        }
        if (this.jTabbedPane1.getComponentAt(found) instanceof BinaryPanel) {
            edit = (BinaryPanel)this.jTabbedPane1.getComponentAt(found);
            ((BinaryPanel)edit).deinit();
        }
        return true;
    }

    private void processErrorLine(String lineString) {
        try {
            int redux;
            int lineNumberStart = lineString.lastIndexOf("(") + 1;
            int lineNumberEnd = lineString.lastIndexOf("):");
            for (redux = 0; redux < lineNumberEnd && !lineString.substring(lineNumberEnd - redux, lineNumberEnd).startsWith("("); ++redux) {
            }
            lineNumberStart = lineNumberEnd - redux + 1;
            String lineNumberString = lineString.substring(lineNumberStart, lineNumberEnd);
            int lineNumber = Integer.parseInt(lineNumberString);
            lineString = UtilityString.replace(lineString, "MACRO-EXPAND from ", "").trim();
            String filename = lineString.substring(0, lineString.lastIndexOf("(" + lineNumberString));
            this.jumpToEdit(filename, lineNumber);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void processErrorLine(String file, int lineno) {
        try {
            this.jumpToEdit(file, lineno);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void processIncludeLine(String lineString) {
        String fn = this.getSelectedEditor().getFilename().toLowerCase();
        if (fn.endsWith(".c") || fn.endsWith(".h") || fn.endsWith(".i")) {
            File f;
            String flags;
            String nameToLoad;
            if (lineString.contains("//")) {
                lineString = lineString.substring(0, lineString.indexOf("//"));
            }
            lineString = UtilityString.replace(lineString.trim(), "#", "");
            lineString = UtilityString.replace(lineString.trim(), "\t", "");
            lineString = UtilityString.replace(lineString.trim(), "include", "");
            lineString = UtilityString.replace(lineString.trim(), "INCLUDE", "");
            lineString = UtilityString.replace(lineString.trim(), "<", "");
            lineString = UtilityString.replace(lineString.trim(), ">", "");
            lineString = UtilityString.replace(lineString.trim(), "\"", "").trim();
            String line = nameToLoad = VediPanel.convertSeperator(lineString);
            String[] parts = line.split("\"");
            String name = "";
            if (parts.length <= 1) {
                parts = line.split("'");
            }
            if (parts.length <= 1) {
                parts = line.split(" ");
            }
            if (parts.length <= 0) {
                return;
            }
            String filename = parts[0].trim();
            if (filename.length() == 0 && parts.length > 1) {
                filename = parts[1].trim();
            }
            if (filename.length() == 0) {
                return;
            }
            String path = this.getSelectedEditor().getPath();
            if (path != null) {
                nameToLoad = path + File.separator;
            }
            nameToLoad = VediPanel.convertSeperator(nameToLoad);
            parts = File.separator.equals("\\") ? filename.split("\\\\") : filename.split(File.separator);
            if (parts.length > 1) {
                String firstPart = "";
                for (int i = 0; i < parts.length - 1; ++i) {
                    firstPart = firstPart + parts[i] + File.separator;
                }
                if (nameToLoad.endsWith(firstPart)) {
                    filename = parts[parts.length - 1];
                }
            }
            nameToLoad = nameToLoad + filename;
            boolean hasFramePointer = true;
            if (this.currentProject != null && this.currentProject.getIsPeerCProject() && (flags = this.currentProject.getCFLAGS()).contains("-fomit-frame-pointer")) {
                hasFramePointer = false;
            }
            if (!(f = new File(nameToLoad)).exists()) {
                nameToLoad = Global.mainPathPrefix + "C" + File.separator + "include" + File.separator + filename;
                if (this.inProject && this.currentProject.getIsPeerCProject()) {
                    nameToLoad = Global.mainPathPrefix + "C" + File.separator + "PeerC" + File.separator + "vectrex" + File.separator + "include" + File.separator + filename;
                }
                if (!(f = new File(nameToLoad)).exists()) {
                    if (this.inProject && this.currentProject.getIsPeerCProject()) {
                        path = Global.mainPathPrefix + this.currentProject.projectPrefix;
                        nameToLoad = path + File.separator + "include" + File.separator + filename;
                    }
                    if (!(f = new File(nameToLoad)).exists()) {
                        return;
                    }
                }
            }
            this.jumpToEdit(nameToLoad, 0);
            return;
        }
        lineString = VediPanel.convertSeperator(lineString);
        try {
            int start = lineString.toLowerCase().indexOf("include");
            if (start < 0) {
                return;
            }
            String line = lineString.substring(start + 7).trim();
            String[] parts = line.split("\"");
            String name = "";
            if (parts.length <= 1) {
                parts = line.split("'");
            }
            if (parts.length <= 1) {
                parts = line.split(" ");
            }
            if (parts.length <= 1) {
                return;
            }
            String filename = parts[0].trim();
            if (filename.length() == 0) {
                filename = parts[1].trim();
            }
            if (filename.length() == 0) {
                return;
            }
            String path = this.getSelectedEditor().getPath();
            String nameToLoad = "";
            if (path != null) {
                nameToLoad = path + File.separator;
            }
            nameToLoad = VediPanel.convertSeperator(nameToLoad);
            parts = File.separator.equals("\\") ? filename.split("\\\\") : filename.split(File.separator);
            if (parts.length > 1) {
                String firstPart = "";
                for (int i = 0; i < parts.length - 1; ++i) {
                    firstPart = firstPart + parts[i] + File.separator;
                }
                if (nameToLoad.endsWith(firstPart)) {
                    filename = parts[parts.length - 1];
                }
            }
            nameToLoad = nameToLoad + filename;
            this.jumpToEdit(nameToLoad, 0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    EditorPanel getEditor(String filename, boolean create) {
        String name = "edi";
        Path path = Paths.get(filename, new String[0]);
        name = path.getFileName().toString();
        filename = UtilityFiles.convertSeperator(Utility.makeVideAbsolute(filename));
        int found = -1;
        for (int i = 0; i < this.jTabbedPane1.getTabCount(); ++i) {
            EditorPanel ed;
            String t;
            this.jTabbedPane1.setSelectedComponent(this.jTabbedPane1.getComponentAt(i));
            if (!(this.jTabbedPane1.getComponentAt(i) instanceof EditorPanel) || !(t = (ed = (EditorPanel)this.jTabbedPane1.getComponentAt(i)).getFilename()).equals(filename)) continue;
            return ed;
        }
        if (!create) {
            return null;
        }
        EditorPanel edi = this.addEditor(filename, true);
        this.oneTimeTab = null;
        return edi;
    }

    private void jumpToEdit(String filename, int lineNumber) {
        this.jumpToEdit(filename, lineNumber, true);
    }

    private void jumpToEdit(String filename, int lineNumber, boolean addToHistory) {
        EditorPanel edi;
        if (addToHistory) {
            this.addHistory();
        }
        if ((edi = this.getEditor(filename, true)) == null) {
            this.printError("Could not access editor for: \"" + filename + "\"");
            return;
        }
        edi.goLine(lineNumber);
    }

    void clearASMOutput() {
        this.jEditorASMMessages.setText("");
        this.jEditorPaneASMListing.setText("");
    }

    @Override
    public void requestSearchFocus() {
        this.jTextFieldSearch.requestFocusInWindow();
        this.jTextFieldSearch.setSelectionStart(0);
        this.jTextFieldSearch.setSelectionEnd(this.jTextFieldSearch.getText().length());
    }

    void scanTreeDirectory(TreeEntry selectedTreeEntry) {
        if (selectedTreeEntry == null) {
            return;
        }
        DefaultMutableTreeNode parent = selectedTreeEntry.parentNode;
        if (parent == null) {
            return;
        }
        TreeEntry entry = (TreeEntry)parent.getUserObject();
        if (entry.type == 1) {
            return;
        }
        Path basePath = entry.pathAndName;
        File directory = basePath.toFile();
        File[] fList = directory.listFiles();
        ArrayList<Integer> indexe = new ArrayList<Integer>();
        ArrayList<DefaultMutableTreeNode> added = new ArrayList<DefaultMutableTreeNode>();
        int i = 0;
        for (File file : fList) {
            if (file.getName().contains("FileProperty.xml") || file.getName().contains("ProjectProperty.xml")) continue;
            Path name = Paths.get(basePath.toString(), file.getName());
            if (!this.hasDirectChild(parent, name)) {
                DefaultMutableTreeNode child;
                TreeEntry newEntry = new TreeEntry(name);
                newEntry.myNode = child = new DefaultMutableTreeNode(newEntry);
                newEntry.parentNode = parent;
                parent.add(child);
                this.addChildren(child);
                added.add(child);
                indexe.add(i);
            }
            ++i;
        }
        this.jTree1.updateUI();
    }

    boolean hasDirectChild(DefaultMutableTreeNode parent, Path name) {
        if (name == null) {
            return false;
        }
        Enumeration<TreeNode> en = parent.children();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
            TreeEntry entry = (TreeEntry)node.getUserObject();
            if (entry == null || !name.equals(entry.pathAndName)) continue;
            return true;
        }
        return false;
    }

    public void refreshTree() {
        this.fillTree(this.currentStartPath, true);
    }

    void fillTree() {
        if (!this.projectLoaded) {
            this.jTree1.setModel(new DefaultTreeModel(null));
            this.root = null;
            return;
        }
        Path startpath = Paths.get(Global.mainPathPrefix, "codelib");
        this.fillTree(startpath);
    }

    void fillTree(Path startpath) {
        this.fillTree(startpath, false);
    }

    void fillTree(Path startpath, boolean refresh) {
        if (this.fileView) {
            this.fillTreeFiles();
            return;
        }
        if (!this.inProject) {
            this.jTree1.setModel(new DefaultTreeModel(null));
            return;
        }
        this.tabChangeNotAllowed = true;
        this.currentStartPath = startpath;
        TreeEntry rootEntry = new TreeEntry(startpath);
        rootEntry.myNode = this.root = new DefaultMutableTreeNode(rootEntry);
        rootEntry.parentNode = null;
        this.addChildren(this.root);
        if (!refresh) {
            this.jTree1.setModel(new DefaultTreeModel(this.root));
        } else {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.jTree1.getRowCount(); ++i) {
                TreePath tp = this.jTree1.getPathForRow(i);
                if (!this.jTree1.isExpanded(i)) continue;
                sb.append(tp.toString());
                sb.append(",");
            }
            this.jTree1.setModel(new DefaultTreeModel(this.root));
            String state = sb.toString();
            for (int i = 0; i < this.jTree1.getRowCount(); ++i) {
                TreePath tp = this.jTree1.getPathForRow(i);
                if (!state.contains(tp.toString())) continue;
                this.jTree1.expandRow(i);
            }
        }
        if (!refresh && this.currentProject != null && this.currentProject.getIsPeerCProject()) {
            DefaultMutableTreeNode node = null;
            Enumeration<TreeNode> enumeration = this.root.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                node = (DefaultMutableTreeNode)enumeration.nextElement();
                if (!"source".equals(node.getUserObject().toString())) continue;
                Object[] nodes = ((DefaultTreeModel)this.jTree1.getModel()).getPathToRoot(node);
                TreePath tpath = new TreePath(nodes);
                this.jTree1.scrollPathToVisible(tpath);
                this.jTree1.getSelectionModel().setSelectionPath(tpath);
                this.jTree1.expandPath(tpath);
                break;
            }
        }
        this.tabChangeNotAllowed = false;
    }

    void fillTreeFiles() {
        this.tabChangeNotAllowed = true;
        Path startpath = Paths.get(Global.mainPathPrefix, "");
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(new TreeEntry(startpath));
        this.addChildrenFile(root);
        this.jTree1.setModel(new DefaultTreeModel(root));
        this.tabChangeNotAllowed = false;
    }

    boolean addChildrenFile(DefaultMutableTreeNode node) {
        TreeEntry entry = (TreeEntry)node.getUserObject();
        if (entry.type == 1) {
            return false;
        }
        Path basePath = entry.pathAndName;
        File directory = basePath.toFile();
        File[] fList = directory.listFiles();
        Arrays.sort(fList, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                if (f1 == null) {
                    return 1;
                }
                if (f2 == null) {
                    return -1;
                }
                if (f1.isDirectory() && !f2.isDirectory()) {
                    return -1;
                }
                if (f2.isDirectory() && !f1.isDirectory()) {
                    return 1;
                }
                return f1.getName().toLowerCase().compareTo(f2.getName().toLowerCase());
            }
        });
        for (File file : fList) {
            TreeEntry newEntry = new TreeEntry(Paths.get(basePath.toString(), file.getName()));
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(newEntry);
            node.add(child);
            this.addChildrenFile(child);
        }
        return true;
    }

    boolean addChildren(DefaultMutableTreeNode node) {
        TreeEntry entry = (TreeEntry)node.getUserObject();
        if (entry.type == 1) {
            return false;
        }
        Path basePath = entry.pathAndName;
        File directory = basePath.toFile();
        File[] fList = directory.listFiles();
        Arrays.sort(fList, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                if (f1 == null) {
                    return 1;
                }
                if (f2 == null) {
                    return -1;
                }
                if (f1.isDirectory() && !f2.isDirectory()) {
                    return -1;
                }
                if (f2.isDirectory() && !f1.isDirectory()) {
                    return 1;
                }
                return f1.getName().toLowerCase().compareTo(f2.getName().toLowerCase());
            }
        });
        for (File file : fList) {
            DefaultMutableTreeNode child;
            if (file.getName().contains("FileProperty.xml") || file.getName().contains("ProjectProperty.xml")) continue;
            TreeEntry newEntry = new TreeEntry(Paths.get(basePath.toString(), file.getName()));
            newEntry.myNode = child = new DefaultMutableTreeNode(newEntry);
            newEntry.parentNode = node;
            node.add(child);
            this.addChildren(child);
        }
        return true;
    }

    TreeEntry getTreeEntry(DefaultMutableTreeNode node, String name) {
        TreeEntry entry = (TreeEntry)node.getUserObject();
        if (entry.pathAndName.toString().equals(name)) {
            return entry;
        }
        Enumeration<TreeNode> en = node.children();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode nextNode = (DefaultMutableTreeNode)en.nextElement();
            entry = this.getTreeEntry(nextNode, name);
            if (entry == null) continue;
            return entry;
        }
        return null;
    }

    @Override
    public void changeFileName(String oldFileName, String newFileName) {
        try {
            String newName = Paths.get(newFileName, new String[0]).getFileName().toString();
            String oldName = Paths.get(oldFileName, new String[0]).getFileName().toString();
            int count = this.jTabbedPane1.getTabCount();
            int found = -1;
            for (int i = 0; i < count; ++i) {
                if (!oldName.equals(this.jTabbedPane1.getTitleAt(i))) continue;
                found = i;
                break;
            }
            this.refreshTree();
            if (found != -1) {
                this.jTabbedPane1.setTitleAt(found, newName);
                JPanel tabPanel = (JPanel)this.jTabbedPane1.getTabComponentAt(found);
                for (int t = 0; t < tabPanel.getComponentCount(); ++t) {
                    if (tabPanel.getComponent(t) instanceof JLabel) {
                        JLabel lblTitle = (JLabel)tabPanel.getComponent(t);
                        lblTitle.setText(newName + "  ");
                    }
                    if (!(tabPanel.getComponent(t) instanceof CloseButton)) continue;
                    CloseButton btnClose = (CloseButton)tabPanel.getComponent(t);
                    btnClose.renameTo(newName);
                }
                Component com = this.jTabbedPane1.getComponentAt(found);
                EditorPanel edit = (EditorPanel)this.jTabbedPane1.getComponentAt(found);
                this.settings.removeOpen(oldFileName);
                this.settings.addOpen(newFileName, edit.getPosition());
                this.updateList();
                edit.replaceFilename(newFileName);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    void changeFileName(TreeEntry leaf, String newFilename) {
        if (leaf == null) {
            return;
        }
        if (newFilename == null) {
            return;
        }
        if (newFilename.trim().length() == 0) {
            return;
        }
        String fullName = leaf.pathAndName.toString();
        Path base = Paths.get(Global.mainPathPrefix, new String[0]);
        Path fromPath = base.resolve(Paths.get(leaf.pathAndName.toString(), new String[0]));
        File ff = fromPath.toFile();
        if (ff.isDirectory()) {
            this.log.addLog("Renaming of directories not allowed!", LogPanel.INFO);
            return;
        }
        if (UtilityFiles.rename(leaf.pathAndName.toString(), newFilename)) {
            File test;
            String oldName = leaf.name;
            leaf.name = newFilename;
            int count = this.jTabbedPane1.getTabCount();
            int found = -1;
            for (int i = 0; i < count; ++i) {
                if (!oldName.equals(this.jTabbedPane1.getTitleAt(i))) continue;
                found = i;
                break;
            }
            String oldFileName = leaf.pathAndName.toString();
            String newFileName = UtilityString.replace(leaf.pathAndName.toString(), oldName, newFilename);
            leaf.pathAndName = Paths.get(newFileName, new String[0]);
            this.asmInfo.replaceFileName(oldFileName, newFileName);
            this.cInfo.replaceFileName(oldFileName, newFileName);
            if (found != -1) {
                this.jTabbedPane1.setTitleAt(found, newFilename);
                JPanel tabPanel = (JPanel)this.jTabbedPane1.getTabComponentAt(found);
                for (int t = 0; t < tabPanel.getComponentCount(); ++t) {
                    if (tabPanel.getComponent(t) instanceof JLabel) {
                        JLabel lblTitle = (JLabel)tabPanel.getComponent(t);
                        lblTitle.setText(newFilename + "  ");
                    }
                    if (!(tabPanel.getComponent(t) instanceof CloseButton)) continue;
                    CloseButton btnClose = (CloseButton)tabPanel.getComponent(t);
                    btnClose.renameTo(newFilename);
                }
                Component com = this.jTabbedPane1.getComponentAt(found);
                if (this.jTabbedPane1.getComponentAt(found) instanceof EditorPanel) {
                    EditorPanel edit = (EditorPanel)this.jTabbedPane1.getComponentAt(found);
                    this.settings.removeOpen(oldFileName);
                    this.settings.addOpen(newFileName, edit.getPosition());
                    edit.replaceFilename(newFileName);
                }
            }
            String type = "";
            String pathFull = "";
            String pathOnly = "";
            String filenameOnly = "";
            String filenameBaseOnly = "";
            Path p = Paths.get(fullName, new String[0]);
            if (p == null) {
                return;
            }
            pathFull = p.toString();
            pathOnly = p.getParent() == null ? "" : p.getParent().toString();
            filenameOnly = p.getFileName().toString();
            if (filenameOnly.contains(".")) {
                filenameBaseOnly = filenameOnly.substring(0, filenameOnly.indexOf("."));
                type = filenameOnly.substring(filenameOnly.indexOf(".") + 1);
            } else {
                filenameBaseOnly = filenameOnly;
            }
            String start = "";
            if (pathOnly.length() != 0) {
                start = pathOnly + File.separator;
            }
            if ((test = new File(start + filenameBaseOnly + "FileProperty.xml")).exists()) {
                FilePropertiesPool pool;
                FileProperties fileProperties;
                String rel = Utility.makeVideRelative(start);
                if (rel.length() > 0) {
                    rel = rel + File.separator;
                }
                if ((fileProperties = (pool = new FilePropertiesPool(rel, filenameBaseOnly + "FileProperty.xml")).get(filenameOnly)) != null) {
                    pool.remove(fileProperties);
                    String ntype = "";
                    String npathFull = "";
                    String npathOnly = "";
                    String nfilenameOnly = "";
                    String nfilenameBaseOnly = "";
                    Path np = Paths.get(leaf.pathAndName.toString(), new String[0]);
                    npathFull = np.toString();
                    if (np.getParent() != null) {
                        npathOnly = np.getParent().toString();
                    }
                    if ((nfilenameOnly = np.getFileName().toString()).contains(".")) {
                        nfilenameBaseOnly = nfilenameOnly.substring(0, nfilenameOnly.indexOf("."));
                        ntype = nfilenameOnly.substring(nfilenameOnly.indexOf(".") + 1);
                    } else {
                        nfilenameBaseOnly = nfilenameOnly;
                    }
                    fileProperties.mName = nfilenameOnly;
                    fileProperties.setFilename(Utility.makeVideRelative(npathFull));
                    fileProperties.setTyp(ntype);
                    pool.put(fileProperties);
                    pool.save();
                    String start2 = "";
                    if (pathOnly.length() != 0) {
                        start2 = pathOnly + File.separator;
                    }
                    UtilityFiles.rename(start2 + filenameBaseOnly + "FileProperty.xml", nfilenameBaseOnly + "FileProperty.xml");
                }
            }
        }
    }

    private void loadProject(String mClass, String mName, String mPath) {
        ProjectPropertiesPool pool;
        ProjectProperties project;
        String xmlFilename = UtilityFiles.convertSeperator(mName);
        String ppath = UtilityFiles.convertSeperator(mPath);
        if (ppath.endsWith(File.separator)) {
            ppath = ppath.substring(0, ppath.length() - 1);
        }
        if ((project = (pool = new ProjectPropertiesPool(ppath, mName + "ProjectProperty.xml")).get(mName)) == null) {
            this.log.addLog("Project file not found: " + mName, LogPanel.WARN);
            return;
        }
        project.projectPrefix = ppath;
        this.inProject = true;
        this.currentProject = project;
        this.fillTree(Paths.get(Utility.makeVideAbsolute(project.projectPrefix), new String[0]));
        this.settings.addProject(this.currentProject.getName(), this.currentProject.getCClass(), project.projectPrefix);
        this.settings.setCurrentProject(this.currentProject.getName(), this.currentProject.getCClass(), project.projectPrefix);
        String path = project.projectPrefix + File.separator;
        for (int b = 0; b < this.currentProject.getNumberOfBanks(); ++b) {
            File test;
            String filenameASM = this.currentProject.getBankMainFiles().elementAt(b);
            if (filenameASM.length() == 0 || !(test = new File(filenameASM = Global.mainPathPrefix + path + filenameASM)).exists()) continue;
            this.asmInfo.handleFile(filenameASM, null);
        }
        if (this.currentProject.getIsPeerCProject()) {
            String flags = this.currentProject.getCFLAGS();
            boolean hasFramePointer = true;
            if (flags.contains("-fomit-frame-pointer")) {
                hasFramePointer = false;
            }
            this.resetCScan(hasFramePointer);
        }
        this.updateList();
    }

    private void doNewProject() {
        this.doNewProject(ProjectPropertiesPanel.showNewProjectProperties(), true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doNewProject(ProjectProperties project, boolean askForDirDouble) {
        Path include2;
        File asmFile;
        File xmlFile;
        File file;
        boolean b;
        if (project == null) {
            return;
        }
        String p1 = project.getOldPath();
        String p2 = project.getProjectName();
        Path p = Paths.get(Global.mainPathPrefix + p1, p2);
        project.projectPrefix = p1 + File.separator + p2;
        if (project.projectPrefix.startsWith(File.separator)) {
            project.projectPrefix = project.projectPrefix.substring(1);
        }
        if (p.toFile().exists() && askForDirDouble) {
            int answer = JOptionPane.showOptionDialog(Configuration.getConfiguration().getMainFrame(), "A directory \"" + project.getProjectName() + "\"already exists, do you really want\nto use an existing diretcory for a new project?", "Directory exists", 2, 2, null, null, null);
            if (answer != 0) {
                System.out.println("NO");
                return;
            }
            System.out.println("YES");
        } else if (askForDirDouble && !(b = (file = p.toAbsolutePath().toFile()).mkdir())) {
            JOptionPane.showMessageDialog(Configuration.getConfiguration().getMainFrame(), "Failed to create directory!\n" + p.toAbsolutePath(), "Directory creation failed", 0);
            return;
        }
        if ((xmlFile = new File(Global.mainPathPrefix + project.projectPrefix + File.separator + project.getProjectName() + "ProjectProperty.xml")).exists()) {
            JOptionPane.showMessageDialog(Configuration.getConfiguration().getMainFrame(), "Projectfile already exists! \nNew project cancled!", "Projectfile already exists", 0);
            return;
        }
        String poolName = project.getProjectName() + "ProjectProperty.xml";
        ProjectPropertiesPool pool = new ProjectPropertiesPool(Utility.makeVideRelative(p.toString()) + File.separator, poolName);
        pool.put(project);
        pool.save();
        boolean shouldSave = false;
        if (project.getIsPeerCProject()) {
            this.doCreatePeerCProject(project);
            return;
        }
        if (project.getcreateGameLoopCode()) {
            if (project.getBankswitching().equals("none") || !project.getcreateBankswitchCode()) {
                asmFile = new File(Utility.makeVideAbsolute(p.toString() + File.separator + project.getMainFile()));
                if (asmFile.exists()) {
                    int answer = JOptionPane.showOptionDialog(Configuration.getConfiguration().getMainFrame(), "The file:\"" + project.getMainFile() + "\" already exists, do you really want\nto create a new file?\n\nAll previous data will be lost!", "File exists", 2, 2, null, null, null);
                    if (answer != 0) {
                        System.out.println("NO");
                        return;
                    }
                    System.out.println("YES");
                }
                Path template = Paths.get(Global.mainPathPrefix, "template", "vectrexMain.template");
                UtilityFiles.copyOneFile(template.toString(), asmFile.toString());
                Path include3 = Paths.get(Global.mainPathPrefix, "template", "VECTREX.I");
                File includeFile = new File(p.toString() + File.separator + "VECTREX.I");
                UtilityFiles.copyOneFile(include3.toString(), includeFile.toString());
                this.addEditor(asmFile.toString(), true);
                this.oneTimeTab = null;
            } else if (project.getBankswitching().contains("2 bank standard")) {
                String name0 = project.getBankMainFiles().elementAt(0);
                String name1 = project.getBankMainFiles().elementAt(1);
                if (name0 == null || name0.length() == 0) {
                    name0 = "mainBank0.asm";
                    project.getBankMainFiles().setElementAt(name0, 0);
                }
                if (name1 == null || name1.length() == 0) {
                    name1 = "mainBank1.asm";
                    project.getBankMainFiles().setElementAt(name1, 1);
                }
                Path template = Paths.get(Global.mainPathPrefix, "template", "bank0Main.template");
                UtilityFiles.copyOneFile(template.toString(), p.toString() + File.separator + name0.toString());
                template = Paths.get(Global.mainPathPrefix, "template", "bank1Main.template");
                UtilityFiles.copyOneFile(template.toString(), p.toString() + File.separator + name1.toString());
                Path include4 = Paths.get(Global.mainPathPrefix, "template", "VECTREX.I");
                UtilityFiles.copyOneFile(include4.toString(), p.toString() + File.separator + "VECTREX.I");
            } else if (project.getBankswitching().contains("VecFlash")) {
                for (int i = 0; i < project.getNumberOfBanks(); ++i) {
                    String name = project.getBankMainFiles().elementAt(i);
                    if (name == null || name.length() == 0) {
                        name = "mainBank" + i + ".asm";
                        project.getBankMainFiles().setElementAt(name, i);
                    }
                    Path template = Paths.get(Global.mainPathPrefix, "template", "vecflashBankXMain.template");
                    String bankMain = UtilityString.readTextFileToOneString(new File(template.toString()));
                    bankMain = UtilityString.replace(bankMain, "3+1", "" + project.getNumberOfBanks() + "+1");
                    bankMain = UtilityString.replace(bankMain, "BANK 0", "BANK " + i);
                    bankMain = UtilityString.replace(bankMain, "Bank 0", "Bank " + i);
                    UtilityFiles.createTextFile(p.toString() + File.separator + name.toString(), bankMain);
                }
                include2 = Paths.get(Global.mainPathPrefix, "template", "VECTREX.I");
                UtilityFiles.copyOneFile(include2.toString(), p.toString() + File.separator + "VECTREX.I");
                Path flashi = Paths.get(Global.mainPathPrefix, "template", "vecflash_bs.i");
                UtilityFiles.copyOneFile(flashi.toString(), p.toString() + File.separator + "vecflash_bs.i");
            } else if (project.getBankswitching().contains("4 bank PB6/IRQ")) {
                project.getBankMainFiles().setElementAt("mainBank0.asm", 0);
                project.getBankMainFiles().setElementAt("mainBank1.asm", 1);
                project.getBankMainFiles().setElementAt("mainBank2.asm", 2);
                project.getBankMainFiles().setElementAt("mainBank3.asm", 3);
                UtilityFiles.copyOneFile(Paths.get(Global.mainPathPrefix, "template", "mainBank0.asm").toString(), p.toString() + File.separator + "mainBank0.asm");
                UtilityFiles.copyOneFile(Paths.get(Global.mainPathPrefix, "template", "mainBank1.asm").toString(), p.toString() + File.separator + "mainBank1.asm");
                UtilityFiles.copyOneFile(Paths.get(Global.mainPathPrefix, "template", "mainBank2.asm").toString(), p.toString() + File.separator + "mainBank2.asm");
                UtilityFiles.copyOneFile(Paths.get(Global.mainPathPrefix, "template", "mainBank3.asm").toString(), p.toString() + File.separator + "mainBank3.asm");
                UtilityFiles.copyOneFile(Paths.get(Global.mainPathPrefix, "template", "waitMacros.i").toString(), p.toString() + File.separator + "waitMacros.i");
                UtilityFiles.copyOneFile(Paths.get(Global.mainPathPrefix, "template", "macro.i").toString(), p.toString() + File.separator + "macro.i");
                UtilityFiles.copyOneFile(Paths.get(Global.mainPathPrefix, "template", "inAllBanks.i").toString(), p.toString() + File.separator + "inAllBanks.i");
                UtilityFiles.copyOneFile(Paths.get(Global.mainPathPrefix, "template", "commonGround.i").toString(), p.toString() + File.separator + "commonGround.i");
                UtilityFiles.copyOneFile(Paths.get(Global.mainPathPrefix, "template", "VECTREX.I").toString(), p.toString() + File.separator + "VECTREX.I");
            }
            shouldSave = true;
        }
        if ((project.getExtras() & Cartridge.FLAG_DS2430A) == Cartridge.FLAG_DS2430A) {
            include2 = Paths.get(Global.mainPathPrefix, "template", "VECTREX.I");
            UtilityFiles.copyOneFile(include2.toString(), p.toString() + File.separator + "VECTREX.I");
            include2 = Paths.get(Global.mainPathPrefix, "template", "ds2430LowLevel.i");
            UtilityFiles.copyOneFile(include2.toString(), p.toString() + File.separator + "ds2430LowLevel.i");
            include2 = Paths.get(Global.mainPathPrefix, "template", "ds2430HighLevel.i");
            UtilityFiles.copyOneFile(include2.toString(), p.toString() + File.separator + "ds2430HighLevel.i");
            include2 = Paths.get(Global.mainPathPrefix, "template", "ds2430ExampleMain.template");
            UtilityFiles.copyOneFile(include2.toString(), p.toString() + File.separator + "ds2430ExampleMain.asm");
            project.getBankMainFiles().setElementAt("ds2430ExampleMain.asm", 0);
        }
        if ((project.getExtras() & Cartridge.FLAG_DS2431) == Cartridge.FLAG_DS2431) {
            include2 = Paths.get(Global.mainPathPrefix, "template", "VECTREX.I");
            UtilityFiles.copyOneFile(include2.toString(), p.toString() + File.separator + "VECTREX.I");
            include2 = Paths.get(Global.mainPathPrefix, "template", "ds2431LowLevel.i");
            UtilityFiles.copyOneFile(include2.toString(), p.toString() + File.separator + "ds2431LowLevel.i");
            include2 = Paths.get(Global.mainPathPrefix, "template", "ds2431HighLevel.i");
            UtilityFiles.copyOneFile(include2.toString(), p.toString() + File.separator + "ds2431HighLevel.i");
            include2 = Paths.get(Global.mainPathPrefix, "template", "ds2431ExampleMain.template");
            UtilityFiles.copyOneFile(include2.toString(), p.toString() + File.separator + "ds2431ExampleMain.asm");
            project.getBankMainFiles().setElementAt("ds2431ExampleMain.asm", 0);
        }
        this.inProject = true;
        this.fillTree(Paths.get(Global.mainPathPrefix + project.projectPrefix, new String[0]));
        this.currentProject = project;
        if (shouldSave) {
            this.saveProject();
        }
        this.settings.addProject(this.currentProject.getName(), this.currentProject.getCClass(), project.projectPrefix);
        this.settings.setCurrentProject(this.currentProject.getName(), this.currentProject.getCClass(), project.projectPrefix);
        this.updateList();
        asmFile = new File(Global.mainPathPrefix + this.currentProject.projectPrefix + File.separator + project.getMainFile());
        this.asmInfo.resetToProject(asmFile);
    }

    @Override
    public void processWord(String word) {
        EntityDefinition entity = null;
        if (this.currentProject != null) {
            if (!this.currentProject.getIsPeerCProject() && this.checkBIOSFile(word)) {
                return;
            }
            if (this.currentProject.getIsPeerCProject() && entity == null) {
                entity = this.cInfo.knownGlobalFunctions.get(word);
            }
        }
        if (entity == null) {
            entity = this.asmInfo.knownGlobalVariables.get(word);
        }
        if (entity == null) {
            entity = this.asmInfo.knownGlobalMacros.get(word);
        }
        if (entity == null) {
            this.printWarning("no definition found for: \"" + word + "\"");
            return;
        }
        StringBuilder message = new StringBuilder();
        message.append("\"").append(word).append("\":");
        if (entity.getType() == EntityDefinition.TYP_LABEL) {
            message.append(" label");
        } else {
            message.append(" macro");
        }
        message.append("\n");
        if (entity.getCFile() != null) {
            message.append("defined at: ").append(entity.getCFile().toString()).append("(").append(entity.getLineNumber()).append(")");
        } else {
            message.append("defined at: ").append(entity.getFile().toString()).append("(").append(entity.getLineNumber()).append(")");
        }
        this.printMessage(message.toString());
        try {
            final String filename = entity.getCFile() != null ? UtilityFiles.convertSeperator(entity.getCFile().toString()) : UtilityFiles.convertSeperator(entity.getFile().toString());
            if (filename.length() == 0) {
                return;
            }
            final int line = entity.getLineNumber();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VediPanel.this.jumpToEdit(filename, line);
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void addFileToProject(File f) {
        Path p = Paths.get(f.getAbsolutePath(), new String[0]);
        String filename = p.getFileName().toString();
        UtilityFiles.copyOneFile(f.getAbsolutePath(), Global.mainPathPrefix + this.currentProject.projectPrefix + File.separator + filename);
    }

    public void reDisplayAll() {
        for (int i = 0; i < this.jTabbedPane1.getTabCount(); ++i) {
            if (!(this.jTabbedPane1.getComponentAt(i) instanceof EditorPanel)) continue;
            EditorPanel ep = (EditorPanel)this.jTabbedPane1.getComponentAt(i);
            ep.reColorDirect();
        }
    }

    private void closeAllEditors() {
        while (this.jTabbedPane1.getTabCount() > 0) {
            String tabName = this.jTabbedPane1.getTitleAt(0);
            boolean ok = this.closeRequested(tabName);
            if (!ok) continue;
            JPanel tabPanel = (JPanel)this.jTabbedPane1.getTabComponentAt(0);
            if (tabPanel != null) {
                for (int t = 0; t < tabPanel.getComponentCount(); ++t) {
                    if (!(tabPanel.getComponent(t) instanceof CloseButton)) continue;
                    CloseButton btnClose = (CloseButton)tabPanel.getComponent(t);
                    btnClose.clearCloseListerner();
                }
            }
            this.jTabbedPane1.removeTabAt(0);
        }
    }

    private boolean nameExistAsTab(String n) {
        for (int i = 0; i < this.jTabbedPane1.getTabCount(); ++i) {
            String tabTitle = this.jTabbedPane1.getTitleAt(i);
            if (!n.equals(tabTitle)) continue;
            return true;
        }
        return false;
    }

    private boolean saveProject() {
        if (!this.inProject) {
            return false;
        }
        if (this.currentProject == null) {
            return false;
        }
        ProjectPropertiesPool pool = new ProjectPropertiesPool(this.currentProject.projectPrefix + File.separator, this.currentProject.getProjectName() + "ProjectProperty.xml");
        pool.put(this.currentProject);
        pool.save();
        return true;
    }

    private void doProjectProperties() {
        ProjectProperties project = ProjectPropertiesPanel.showEditProjectProperties(this.currentProject);
        if (project == null) {
            return;
        }
        this.currentProject = project;
        this.saveProject();
    }

    private void doFileProperties(TreeEntry te) {
        if (this.selectedTreeEntry == null) {
            return;
        }
        if (this.selectedTreeEntry.pathAndName == null) {
            return;
        }
        FilePropertiesPanel.showEditFileProperties(this.selectedTreeEntry.pathAndName.toString(), this);
    }

    void doBuildProject() {
        if (this.currentProject == null) {
            this.printWarning("There is no Project to build!");
            return;
        }
        if (!this.config.onlyManualSaveInEditor) {
            this.saveAll();
        }
        if (this.currentProject.getIsCProject()) {
            FilePeeper.peepsFound = 0;
            if (this.startTypeRun == 4) {
                String fname = this.getSelectedEditor().getFilename();
                if (fname == null) {
                    return;
                }
                if (fname.toLowerCase().endsWith(".c")) {
                    this.doCCompilerSingleFile(fname);
                }
                return;
            }
            this.doBuildCProject();
            return;
        }
        if (this.currentProject.getIsPeerCProject()) {
            FilePeeper.peepsFound = 0;
            this.doBuildPeerCProject();
            return;
        }
        if (this.startTypeRun == 4) {
            String fname = this.getSelectedEditor().getFilename();
            if (fname == null) {
                return;
            }
            this.startASM(fname);
            return;
        }
        String preClass = this.currentProject.getProjectPreScriptClass();
        String preName = this.currentProject.getProjectPreScriptName();
        String p = this.currentProject.projectPrefix + File.separator;
        String pathAbs = Utility.makeVideAbsolute(p);
        ExecutionDescriptor ed = new ExecutionDescriptor(ExecutionDescriptor.ED_TYPE_PROJECT_PRE, this.currentProject.getProjectName(), "", "VediPanel", pathAbs);
        boolean ok = ScriptDataPanel.executeScript(preClass, preName, this, ed);
        if (!ok) {
            return;
        }
        this.clearASMOutput();
        this.startBuildProject();
    }

    public static String convertSeperator(String filename) {
        String ret = UtilityString.replace(filename, "/", File.separator);
        ret = UtilityString.replace(ret, "\\", File.separator);
        return ret;
    }

    boolean skipInternalProcessing(String videRelFilename) {
        String absFilename;
        File test;
        String fileNameOnly;
        File file = new File(videRelFilename);
        String fileNameBare = fileNameOnly = file.getName();
        int li = videRelFilename.lastIndexOf(".");
        if (li >= 0) {
            videRelFilename = videRelFilename.substring(0, li);
        }
        if ((test = new File((absFilename = Utility.makeVideAbsolute(videRelFilename)) + "FileProperty.xml")).exists()) {
            FilePropertiesPool pool;
            FileProperties fileProperties;
            String relOnly;
            String pathOnly = test.getParent().toString();
            if (pathOnly.length() != 0) {
                pathOnly = pathOnly + File.separator;
            }
            if ((relOnly = Utility.makeVideRelative(pathOnly)).length() != 0) {
                relOnly = relOnly + File.separator;
            }
            if ((fileProperties = (pool = new FilePropertiesPool(relOnly, test.getName())).get(fileNameOnly)) == null) {
                return false;
            }
            return fileProperties.getNoInternalProcessing();
        }
        return false;
    }

    String executeFileScripts(String type, String videRelPath) {
        File[] fList;
        String absPath = Utility.makeVideAbsolute(videRelPath);
        File directory = new File(absPath);
        for (File file : fList = directory.listFiles()) {
            ExecutionDescriptor ed;
            String scriptName;
            String scriptClass;
            FilePropertiesPool pool;
            FileProperties fileProperties;
            String relPathOnly;
            File test;
            String fileNameOnly;
            String fileNameBare = fileNameOnly = file.getName();
            int li = fileNameOnly.lastIndexOf(".");
            if (li >= 0) {
                fileNameBare = fileNameOnly.substring(0, li);
            }
            if (absPath.length() != 0) {
                absPath = absPath + File.separator;
            }
            if (!(test = new File(absPath + fileNameBare + "FileProperty.xml")).exists()) continue;
            String pathOnly = test.getParent().toString();
            if (pathOnly.length() != 0) {
                pathOnly = pathOnly + File.separator;
            }
            if ((relPathOnly = Utility.makeVideRelative(pathOnly)).length() != 0) {
                relPathOnly = relPathOnly + File.separator;
            }
            if ((fileProperties = (pool = new FilePropertiesPool(relPathOnly, test.getName())).get(fileNameOnly)) == null) continue;
            if (type.equals("Pre")) {
                scriptClass = fileProperties.getPreScriptClass();
                scriptName = fileProperties.getPreScriptName();
                ed = new ExecutionDescriptor(ExecutionDescriptor.ED_TYPE_FILE_PRE, this.currentProject.getProjectName(), fileNameOnly, "VediPanel", pathOnly);
            } else {
                scriptClass = fileProperties.getPostScriptClass();
                scriptName = fileProperties.getPostScriptName();
                ed = new ExecutionDescriptor(ExecutionDescriptor.ED_TYPE_FILE_POST, this.currentProject.getProjectName(), fileNameOnly, "VediPanel", pathOnly);
            }
            if (scriptClass.length() == 0 || scriptName.length() == 0 || ScriptDataPanel.executeScript(scriptClass, scriptName, this, ed)) continue;
            return file.getName();
        }
        return null;
    }

    public void startBuildProject() {
        if (this.asmStarted) {
            return;
        }
        this.asmStarted = true;
        this.jButtonAssemble.setEnabled(false);
        this.jButtonDebug.setEnabled(false);
        if (this.one != null) {
            return;
        }
        this.one = new Thread(){

            @Override
            public void run() {
                boolean asmOk = true;
                boolean is48K = (VediPanel.this.currentProject.getExtras() & Cartridge.FLAG_48K) != 0;
                boolean is44K = (VediPanel.this.currentProject.getExtras() & Cartridge.FLAG_44_PEER_BS) != 0;
                try {
                    String videRelPath = VediPanel.this.currentProject.projectPrefix;
                    String pathAbs = Utility.makeVideAbsolute(videRelPath);
                    Asmj.resetReplacements(pathAbs);
                    final String failure = VediPanel.this.executeFileScripts("Pre", videRelPath);
                    if (failure != null && !asmOk) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                VediPanel.this.printError("Error execute pre build script for: " + failure);
                                VediPanel.this.buildProjectResult(false);
                            }
                        });
                        VediPanel.this.one = null;
                        VediPanel.this.jButtonAssemble.setEnabled(true);
                        VediPanel.this.jButtonDebug.setEnabled(true);
                        VediPanel.this.asmStarted = false;
                        return;
                    }
                    boolean compiled = false;
                    for (int b = 0; b < VediPanel.this.currentProject.getNumberOfBanks(); ++b) {
                        String absFileName;
                        File test;
                        String filenameASM = VediPanel.this.currentProject.getBankMainFiles().elementAt(b);
                        File f = new File(filenameASM);
                        if ((filenameASM = f.getName()).length() == 0 || !(test = new File(absFileName = Utility.makeVideAbsolute(filenameASM = videRelPath + File.separator + filenameASM))).exists()) continue;
                        if (VediPanel.this.skipInternalProcessing(filenameASM)) {
                            String filename = VediPanel.this.currentProject.getBankMainFiles().elementAt(b);
                            filename = videRelPath + File.separator + filename;
                            int li = filename.lastIndexOf(".");
                            if (li >= 0) {
                                filename = filename.substring(0, li);
                            }
                            String orgVideRel = filename + ".bin";
                            String bankedVideRel = filename + "_" + b + ".bin";
                            String orgAbs = Utility.makeVideAbsolute(orgVideRel);
                            String bankedAbs = Utility.makeVideAbsolute(bankedVideRel);
                            File orgName = new File(orgAbs);
                            if (!orgName.exists()) continue;
                            UtilityFiles.move(orgAbs, bankedAbs);
                            continue;
                        }
                        String define = VediPanel.this.currentProject.getBankDefines().elementAt(b);
                        VediPanel.this.printMessage("Assembling: " + absFileName);
                        Asmj asm = new Asmj(absFileName, VediPanel.this.asmErrorOut, null, null, VediPanel.this.asmMessagesOut, define, VediPanel.this.settings.allDebugComments, is48K);
                        if (Asmj.version.length() != 0 && VediPanel.this.currentProject != null) {
                            VediPanel.this.currentProject.setVersion(Asmj.version);
                            VediPanel.this.printMessage("Project version set to: " + Asmj.version + " (found in: " + filenameASM + ")");
                        }
                        VediPanel.this.printASMList(asm.getListing(), 2);
                        String info = asm.getInfo();
                        boolean bl = asmOk = info.indexOf("0 errors detected.") >= 0;
                        if (!asmOk) break;
                        compiled = true;
                        String filename = VediPanel.this.currentProject.getBankMainFiles().elementAt(b);
                        File ff = new File(filename);
                        filename = ff.getName();
                        filename = videRelPath + File.separator + filename;
                        int li = filename.lastIndexOf(".");
                        if (li >= 0) {
                            filename = filename.substring(0, li);
                        }
                        String org2 = filename + ".bin";
                        String banked = filename + "_" + b + ".bin";
                        String orgAbs = Utility.makeVideAbsolute(org2);
                        String bankedAbs = Utility.makeVideAbsolute(banked);
                        UtilityFiles.move(orgAbs, bankedAbs);
                        Asmj.binFileRename(orgAbs, bankedAbs);
                        org2 = filename + ".cnt";
                        banked = filename + "_" + b + ".cnt";
                        orgAbs = Utility.makeVideAbsolute(org2);
                        bankedAbs = Utility.makeVideAbsolute(banked);
                        Vector<String> what = new Vector<String>();
                        Vector<String> with = new Vector<String>();
                        what.add("BANK 0");
                        with.add("BANK " + b);
                        UtilityString.replaceToNewFile(new File(orgAbs), new File(bankedAbs), what, with);
                        UtilityFiles.deleteFile(orgAbs);
                    }
                    if (!compiled) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                VediPanel.this.printError("Nothing compiled, main not set? ");
                                VediPanel.this.buildProjectResult(false);
                            }
                        });
                        VediPanel.this.one = null;
                        VediPanel.this.jButtonAssemble.setEnabled(true);
                        VediPanel.this.jButtonDebug.setEnabled(true);
                        VediPanel.this.asmStarted = false;
                        return;
                    }
                    final String failure2 = VediPanel.this.executeFileScripts("Post", videRelPath);
                    if (failure2 != null && !asmOk) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                VediPanel.this.printError("Error execute post build script for: " + failure2);
                                VediPanel.this.buildProjectResult(false);
                            }
                        });
                        VediPanel.this.one = null;
                        VediPanel.this.jButtonAssemble.setEnabled(true);
                        VediPanel.this.jButtonDebug.setEnabled(true);
                        VediPanel.this.asmStarted = false;
                        return;
                    }
                }
                catch (Throwable e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            VediPanel.this.printASMMessage("Exception while building: " + e.getMessage(), 1);
                            VediPanel.this.printASMMessage(Utility.getStackTrace(e), 1);
                            VediPanel.this.buildProjectResult(false);
                        }
                    });
                    VediPanel.this.one = null;
                    VediPanel.this.jButtonAssemble.setEnabled(true);
                    VediPanel.this.jButtonDebug.setEnabled(true);
                    VediPanel.this.asmStarted = false;
                    return;
                }
                if (!asmOk) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            VediPanel.this.buildProjectResult(false);
                        }
                    });
                    VediPanel.this.one = null;
                    VediPanel.this.jButtonAssemble.setEnabled(true);
                    VediPanel.this.jButtonDebug.setEnabled(true);
                    VediPanel.this.asmStarted = false;
                    return;
                }
                final boolean asmOk2 = asmOk;
                Asmj.doReplacements();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VediPanel.this.buildProjectResult(asmOk2);
                    }
                });
                VediPanel.this.one = null;
                VediPanel.this.jButtonAssemble.setEnabled(true);
                VediPanel.this.jButtonDebug.setEnabled(true);
                VediPanel.this.asmStarted = false;
            }
        };
        this.one.setName("Build: " + this.currentProject.getProjectName());
        this.one.start();
    }

    protected void buildProjectResult(boolean buildOk) {
        this.refreshTree();
        if (buildOk) {
            CartridgeProperties cartProp = this.buildCart(this.currentProject, true);
            this.checkVec4EverProject(cartProp);
            String postClass = this.currentProject.getProjectPostScriptClass();
            String postName = this.currentProject.getProjectPostScriptName();
            String pp = this.currentProject.projectPrefix;
            ExecutionDescriptor ed = new ExecutionDescriptor(ExecutionDescriptor.ED_TYPE_PROJECT_POST, this.currentProject.getProjectName(), "", "VediPanel", pp);
            boolean ok = ScriptDataPanel.executeScript(postClass, postName, this, ed);
            if (this.config.invokeEmulatorAfterAssembly) {
                VecXPanel vec = ((CSAMainFrame)this.mParent).getVecxy();
                if (((CSAMainFrame)this.mParent).getInternalFrame(vec) != null) {
                    ((CSAMainFrame)this.mParent).getInternalFrame(vec).toFront();
                }
                boolean ask = false;
                if (this.startTypeRun == 3) {
                    CartridgeProperties oldProp = vec.getCurrentCartProp();
                    if (oldProp == null) {
                        ask = true;
                    } else {
                        String myName = this.currentProject.getProjectName();
                        String oldName = oldProp.getCartName();
                        if (!oldName.equals(myName)) {
                            ask = true;
                        }
                    }
                }
                boolean doit = true;
                if (ask) {
                    int answer = JOptionPane.showOptionDialog(Configuration.getConfiguration().getMainFrame(), "The bin files appear to be not compatible, inject anyway?", "File not compatible", 2, 2, null, null, null);
                    doit = answer == 0;
                }
                if (doit) {
                    vec.startCartridge(cartProp, this.startTypeRun);
                    this.printMessage("Assembly successful, starting emulation...");
                }
            } else {
                this.printMessage("Assembly successful...");
            }
            if (this.config.invokeVecMultiAfterAssembly) {
                this.loadVecMulti(cartProp);
            }
        } else {
            this.printError("Assembly not successful, see ASM output...");
            this.jTabbedPane.setSelectedIndex(1);
        }
        this.refreshTree();
    }

    private void writeByte(OutputStream output, byte value) throws InterruptedException, IOException {
        output.write(value);
    }

    private void loadVecMulti(CartridgeProperties cartProp) {
        final String fileName = Utility.makeVideAbsolute(UtilityFiles.convertSeperator(cartProp.getFullFilename().elementAt(0)));
        Thread thread = new Thread(){

            @Override
            public void run() {
                int BAUD_RATE = 115200;
                int DATA_BITS = 8;
                int PROGRESS_FREQ = 4096;
                if (VediPanel.this.config.vecMultiPortDescriptor == null) {
                    VediPanel.this.printError("Failed to find any connected serial ports");
                    return;
                }
                SerialPort port = SerialPort.getCommPort((String)VediPanel.this.config.vecMultiPortDescriptor);
                VediPanel.this.printMessage("Writing to serial port " + VediPanel.this.config.vecMultiPortDescriptor + "...");
                port.setComPortParameters(115200, 8, 1, 0);
                port.openPort();
                try {
                    try (OutputStream output = port.getOutputStream();){
                        byte[] bytes;
                        VediPanel.this.writeByte(output, (byte)115);
                        try (RandomAccessFile file = new RandomAccessFile(fileName, "r");){
                            bytes = new byte[(int)file.length()];
                            file.readFully(bytes);
                        }
                        for (int i = 0; i < bytes.length; ++i) {
                            VediPanel.this.writeByte(output, (byte)64);
                            VediPanel.this.writeByte(output, bytes[i]);
                            int progress = i * 100 / bytes.length;
                            if (i % 4096 != 0) continue;
                            VediPanel.this.printMessage(progress + "% loaded...");
                        }
                        VediPanel.this.writeByte(output, (byte)121);
                    }
                    catch (InterruptedException e) {
                        VediPanel.this.printError(e.toString());
                    }
                    port.closePort();
                    VediPanel.this.printMessage("VecMulti loading successful. Reset your Vectrex!");
                }
                catch (IOException e) {
                    VediPanel.this.printError(e.toString());
                }
            }
        };
        thread.setName("VecMulti load: " + this.currentProject.getProjectName());
        thread.start();
    }

    boolean isProject(String filename) {
        ProjectProperties project;
        if (!filename.toLowerCase().endsWith("projectproperty.xml")) {
            this.log.addLog(filename + " is not a project file", LogPanel.INFO);
            return false;
        }
        String file = UtilityString.readTextFileToOneString(new File(Utility.makeVideAbsolute(filename)));
        if (!file.contains("<AllProjectProperties>")) {
            this.log.addLog(Utility.makeVideAbsolute(filename) + " contains no project definition", LogPanel.INFO);
            return false;
        }
        this.closeAllEditors();
        String name = Paths.get(filename, new String[0]).getFileName().toString();
        name = name.substring(0, name.length() - "ProjectProperty.xml".length());
        ProjectPropertiesPool pool = new ProjectPropertiesPool(Paths.get(Utility.makeVideAbsolute(filename), new String[0]).getParent().toString() + File.separator, Paths.get(Utility.makeVideAbsolute(filename), new String[0]).getFileName().toString());
        this.currentProject = project = pool.get(name);
        this.inProject = true;
        File projectFile = new File(Utility.makeVideAbsolute(filename));
        if (this.currentProject == null) {
            return false;
        }
        this.currentProject.projectPrefix = Utility.makeVideRelative(projectFile.getAbsolutePath());
        this.currentProject.projectPrefix = UtilityString.replace(this.currentProject.projectPrefix, projectFile.getName(), "");
        if (this.currentProject.projectPrefix.endsWith(File.separator)) {
            this.currentProject.projectPrefix = this.currentProject.projectPrefix.substring(0, this.currentProject.projectPrefix.length() - 1);
        }
        this.fillTree(Paths.get(Utility.makeVideAbsolute(this.currentProject.projectPrefix), new String[0]));
        this.settings.addProject(this.currentProject.getName(), this.currentProject.getCClass(), this.currentProject.projectPrefix);
        this.settings.setCurrentProject(this.currentProject.getName(), this.currentProject.getCClass(), this.currentProject.projectPrefix);
        this.updateList();
        Path p = Paths.get(Utility.makeVideAbsolute(this.currentProject.projectPrefix), new String[0]);
        File asmFile = new File(p.toString() + File.separator + project.getMainFile());
        this.asmInfo.resetToProject(asmFile);
        this.cInfo.resetToProject(asmFile);
        return true;
    }

    CartridgeProperties buildCart(ProjectProperties project, boolean banked) {
        String filenameVideRel;
        int b;
        CartridgeProperties cart = new CartridgeProperties();
        String videRelpath = this.currentProject.projectPrefix;
        if (banked) {
            for (b = 0; b < project.getNumberOfBanks(); ++b) {
                String filenameAbs;
                File test;
                int li;
                filenameVideRel = project.getBankMainFiles().elementAt(b);
                if (project.getIsPeerCProject()) {
                    filenameVideRel = "bin" + File.separator + filenameVideRel;
                    filenameVideRel = videRelpath + File.separator + filenameVideRel;
                } else if (!filenameVideRel.contains(File.separator)) {
                    filenameVideRel = videRelpath + File.separator + filenameVideRel;
                }
                if (filenameVideRel.endsWith(".") && (li = filenameVideRel.lastIndexOf(".")) >= 0) {
                    filenameVideRel = filenameVideRel.substring(0, li);
                }
                if (filenameVideRel.toLowerCase().endsWith(".asm") && (li = filenameVideRel.lastIndexOf(".")) >= 0) {
                    filenameVideRel = filenameVideRel.substring(0, li);
                }
                if (filenameVideRel.toLowerCase().endsWith(".s") && (li = filenameVideRel.lastIndexOf(".")) >= 0) {
                    filenameVideRel = filenameVideRel.substring(0, li);
                }
                String tmp = filenameVideRel;
                String tmp2 = filenameVideRel;
                filenameVideRel = tmp + "_" + b + ".bin";
                String filenameVideRelCNT = tmp2 + "_" + b + ".cnt";
                String s = this.getVersionString();
                if (new File(filenameVideRel).exists() && s.length() > 0) {
                    tmp = tmp + "_" + s + "_" + b + ".bin";
                    UtilityFiles.move(filenameVideRel, tmp);
                    filenameVideRel = tmp;
                }
                if (new File(filenameVideRelCNT).exists() && s.length() > 0) {
                    tmp2 = tmp2 + "_" + s + "_" + b + ".cnt";
                    UtilityFiles.move(filenameVideRelCNT, tmp2);
                }
                if (!(test = new File(filenameAbs = Utility.makeVideAbsolute(filenameVideRel))).exists()) {
                    cart.getFullFilename().add("");
                    continue;
                }
                cart.getFullFilename().add(filenameVideRel);
            }
        } else {
            b = 0;
            filenameVideRel = project.getBankMainFiles().elementAt(b);
            filenameVideRel = project.getIsPeerCProject() ? videRelpath + File.separator + "bin" + File.separator + project.getProjectName() : videRelpath + File.separator + project.getProjectName();
            String tmp = filenameVideRel;
            String tmp2 = filenameVideRel;
            filenameVideRel = tmp + ".bin";
            String filenameVideRelCNT = tmp2 + ".cnt";
            String s = this.getVersionString();
            if (new File(filenameVideRel).exists() && s.length() > 0) {
                tmp = tmp + "_" + s + ".bin";
                UtilityFiles.move(filenameVideRel, tmp);
                filenameVideRel = tmp;
            }
            if (new File(filenameVideRelCNT).exists() && s.length() > 0) {
                tmp2 = tmp2 + "_" + s + ".cnt";
                UtilityFiles.move(filenameVideRelCNT, tmp2);
            }
            cart.getFullFilename().add(filenameVideRel);
        }
        cart.setCartName(project.getProjectName());
        cart.setAuthor(project.getAuthor());
        String bs = project.getBankswitching();
        int typeFlags = project.getExtras();
        if (!bs.equals("none")) {
            if (bs.contains("standard")) {
                typeFlags += Cartridge.FLAG_BANKSWITCH_DONDZILA;
            } else if (bs.contains("VecFlash")) {
                typeFlags += Cartridge.FLAG_BANKSWITCH_VECFLASH;
            }
        }
        if ((typeFlags & Cartridge.FLAG_IMAGER) == Cartridge.FLAG_IMAGER) {
            cart.setWheelName(project.getWheelName());
        }
        cart.setTypeFlags(typeFlags);
        return cart;
    }

    void saveAll() {
        for (int i = 0; i < this.jTabbedPane1.getTabCount(); ++i) {
            EditorPanel ep;
            if (!(this.jTabbedPane1.getComponentAt(i) instanceof EditorPanel) || !(ep = (EditorPanel)this.jTabbedPane1.getComponentAt(i)).hasChanged()) continue;
            ep.save(false);
        }
    }

    void closeOneTimeTab() {
        if (this.oneTimeTab == null) {
            return;
        }
        int index = -1;
        for (int i = 0; i < this.jTabbedPane1.getTabCount(); ++i) {
            String tabName = this.jTabbedPane1.getTitleAt(i);
            if (!tabName.equals(this.oneTimeTab)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return;
        }
        boolean ok = this.closeRequested(this.oneTimeTab);
        if (ok) {
            JPanel tabPanel = (JPanel)this.jTabbedPane1.getTabComponentAt(index);
            if (tabPanel != null) {
                for (int t = 0; t < tabPanel.getComponentCount(); ++t) {
                    if (!(tabPanel.getComponent(t) instanceof CloseButton)) continue;
                    CloseButton btnClose = (CloseButton)tabPanel.getComponent(t);
                    btnClose.clearCloseListerner();
                }
            }
            this.jTabbedPane1.removeTabAt(index);
        }
    }

    boolean tabExistsSwitch(TreeEntry entry) {
        String fname = entry.pathAndName.toString();
        return this.tabExistsSwitch(fname);
    }

    boolean tabExistsSwitch(String fname) {
        int count = this.jTabbedPane1.getTabCount();
        String fn1 = UtilityFiles.convertSeperator(Utility.makeVideAbsolute(fname)).toLowerCase();
        for (int i = 0; i < count; ++i) {
            EditorPanel edi;
            String fn2;
            Component com = this.jTabbedPane1.getComponentAt(i);
            if (!(com instanceof EditorPanel) || !fn1.equals(fn2 = UtilityFiles.convertSeperator(Utility.makeVideAbsolute((edi = (EditorPanel)com).getFilename())).toLowerCase())) continue;
            this.jTabbedPane1.setSelectedIndex(i);
            return true;
        }
        return false;
    }

    boolean _old_tabExistsSwitch(String tabname) {
        int count = this.jTabbedPane1.getTabCount();
        int found = -1;
        for (int i = 0; i < count; ++i) {
            if (!tabname.equals(this.jTabbedPane1.getTitleAt(i))) continue;
            found = i;
            break;
        }
        if (found == -1) {
            return false;
        }
        this.jTabbedPane1.setSelectedIndex(found);
        return true;
    }

    void doRasterImage() {
        String type = "";
        String pathFull = "";
        String pathOnly = "";
        String filenameOnly = "";
        String filenameBaseOnly = "";
        Path p = Paths.get(this.selectedTreeEntry.pathAndName.toString(), new String[0]);
        pathFull = p.toString();
        pathOnly = p.getParent().toString();
        filenameOnly = p.getFileName().toString();
        boolean pic = false;
        if (filenameOnly.toLowerCase().endsWith(".gif")) {
            pic = true;
        }
        if (filenameOnly.toLowerCase().endsWith(".jpg")) {
            pic = true;
        }
        if (filenameOnly.toLowerCase().endsWith(".png")) {
            pic = true;
        }
        if (filenameOnly.toLowerCase().endsWith(".bmp")) {
            pic = true;
        }
        if (!pic) {
            this.printError("Selected entry does not have a known image extension!");
            return;
        }
        boolean done = RasterPanel.showRasterPanel(pathFull);
        if (!done) {
            return;
        }
        this.refreshTree();
    }

    void doSample() {
        String type = "";
        String pathFull = "";
        String pathOnly = "";
        String filenameOnly = "";
        String filenameBaseOnly = "";
        Path p = null;
        if (this.selectedTreeEntry != null) {
            p = Paths.get(this.selectedTreeEntry.pathAndName.toString(), new String[0]);
        } else if (this.inProject && this.currentProject != null) {
            p = Paths.get(Utility.makeVideAbsolute(this.currentProject.projectPrefix), new String[0]);
        }
        if (p == null) {
            return;
        }
        pathFull = p.toString();
        pathOnly = p.toFile().isDirectory() ? pathFull : p.getParent().toString();
        filenameOnly = p.getFileName().toString();
        boolean wav = false;
        if (filenameOnly.toLowerCase().endsWith(".wav")) {
            wav = true;
        }
        if (filenameOnly.toLowerCase().endsWith(".pcm")) {
            wav = true;
        }
        boolean done = false;
        done = !wav ? SampleJPanel.showSamplePanel(pathOnly, false) : SampleJPanel.showSamplePanel(pathFull, true);
        if (!done) {
            return;
        }
        this.refreshTree();
    }

    private void doMod2Vectrex() {
        String type = "";
        String pathFull = "";
        String pathOnly = "";
        String filenameOnly = "";
        String filenameBaseOnly = "";
        Path p = Paths.get(this.selectedTreeEntry.pathAndName.toString(), new String[0]);
        pathFull = p.toString();
        pathOnly = p.getParent().toString();
        filenameOnly = p.getFileName().toString();
        ModJPanel.showModPanelNoModal(pathFull, this);
    }

    public void returnFromVecVoxPanel(int type) {
        if (type == 0) {
            return;
        }
        if (this.currentProject == null || !this.projectLoaded) {
            this.printWarning("Voice files were built, but no project is active.");
            this.printWarning("Voice emulation in vecxi will not be active if run without a project!");
        } else {
            int extras = this.currentProject.getExtras();
            if (type == 1) {
                extras |= Cartridge.FLAG_VEC_VOX;
            }
            if (type == 2) {
                extras |= Cartridge.FLAG_VEC_VOICE;
            }
            this.currentProject.setExtras(extras);
        }
        this.refreshTree();
        this.scanTreeDirectory(this.selectedTreeEntry);
    }

    public void returnFromModPanel(boolean d) {
        boolean done = d;
        if (!done) {
            return;
        }
        this.refreshTree();
        this.scanTreeDirectory(this.selectedTreeEntry);
    }

    public void returnFromYMPanel(boolean d) {
        boolean done = d;
        if (!done) {
            return;
        }
        this.refreshTree();
        this.scanTreeDirectory(this.selectedTreeEntry);
    }

    void doAKS() {
        String type = "";
        String pathFull = "";
        String pathOnly = "";
        String filenameOnly = "";
        String filenameBaseOnly = "";
        Path p = Paths.get(this.selectedTreeEntry.pathAndName.toString(), new String[0]);
        pathFull = p.toString();
        pathOnly = p.getParent().toString();
        if (pathOnly.length() > 0) {
            pathOnly = pathOnly + File.separator;
        }
        filenameOnly = p.getFileName().toString();
        boolean pic = false;
        if (filenameOnly.toLowerCase().endsWith(".bin")) {
            pic = true;
        }
        if (!pic) {
            this.printError("Selected entry does not have a \"bin\" extension!");
            return;
        }
        filenameBaseOnly = filenameOnly.substring(0, filenameOnly.length() - 4);
        AKSBin aksbin = new AKSBin();
        String id = GetIDValuePanel.showEnterValueDialog();
        String text = aksbin.buildData(pathFull, this, id);
        if (text.length() == 0) {
            return;
        }
        String targetFile = pathOnly + File.separator + filenameBaseOnly + "AKS.asm";
        UtilityFiles.createTextFile(targetFile, text);
        boolean isPC = false;
        if (this.currentProject != null) {
            isPC = this.currentProject.getIsPeerCProject();
        }
        if (!isPC) {
            String nameOnly = Paths.get(targetFile, new String[0]).getFileName().toString();
            String barenameOnly = nameOnly.substring(0, nameOnly.length() - 4);
            Path include2 = Paths.get(Global.mainPathPrefix, "template", "VECTREX.I");
            UtilityFiles.copyOneFile(include2.toString(), pathOnly + "VECTREX.I");
            Path digital = Paths.get(Global.mainPathPrefix, "template", "arkosPlayer.i");
            UtilityFiles.copyOneFile(digital.toString(), pathOnly + "arkosPlayer.i");
            Path template = Paths.get(Global.mainPathPrefix, "template", "arkosPlayerMain.template");
            String exampleMain = UtilityString.readTextFileToOneString(new File(template.toString()));
            exampleMain = UtilityString.replace(exampleMain, "#AKS_DATA#", filenameBaseOnly + "AKS.asm");
            UtilityFiles.createTextFile(pathOnly + filenameBaseOnly + "Main.asm", exampleMain);
        } else {
            String pathSource = this.getProjectBase() + File.separator + "source";
            VediPanel.convertToCASM(targetFile, true);
            UtilityFiles.move(VediPanel.changeTypeTo(targetFile, "s"), pathSource + File.separator + filenameBaseOnly + ".s");
            String outName = pathSource + File.separator + filenameBaseOnly + ".h";
            String body = "extern const void* SongAddress" + id + ";\n";
            UtilityFiles.createTextFile(outName, body);
        }
        this.refreshTree();
    }

    void doAYFX() {
        String type = "";
        String pathFull = "";
        String pathOnly = "";
        String filenameOnly = "";
        String filenameBaseOnly = "";
        Path p = Paths.get(this.selectedTreeEntry.pathAndName.toString(), new String[0]);
        pathFull = p.toString();
        pathOnly = p.getParent().toString();
        if (pathOnly.length() > 0) {
            pathOnly = pathOnly + File.separator;
        }
        boolean isPC = false;
        if (this.currentProject != null) {
            isPC = this.currentProject.getIsPeerCProject();
        }
        filenameOnly = p.getFileName().toString();
        boolean pic = false;
        if (filenameOnly.toLowerCase().endsWith(".afx")) {
            pic = true;
        }
        if (!pic) {
            this.printError("Selected entry does not have a known afx extension!");
            return;
        }
        filenameBaseOnly = filenameOnly.substring(0, filenameOnly.length() - 4);
        if (isPC) {
            boolean twice = this.currentProject.getBankswitching().contains("2 bank standard");
            String bankAdd = "";
            String targetFile = pathOnly + filenameBaseOnly + ".c";
            if (!this.saveAYFXC(pathFull, targetFile)) {
                this.printError("Could not generate c file from: " + pathFull);
                return;
            }
            String nameOnly = Paths.get(targetFile, new String[0]).getFileName().toString();
            String barenameOnly = nameOnly.substring(0, nameOnly.length() - 2);
            targetFile = UtilityString.replace(targetFile, ".c", ".h");
            String body = "extern const unsigned int " + barenameOnly + "_data[];\n";
            UtilityFiles.createTextFile(targetFile, body);
        } else {
            String targetFile = pathOnly + filenameBaseOnly + ".asm";
            if (!this.saveAYFX(pathFull, targetFile)) {
                this.printError("Could not generate asm file from: " + pathFull);
                return;
            }
            String nameOnly = Paths.get(targetFile, new String[0]).getFileName().toString();
            String barenameOnly = nameOnly.substring(0, nameOnly.length() - 4);
            Path include2 = Paths.get(Global.mainPathPrefix, "template", "VECTREX.I");
            UtilityFiles.copyOneFile(include2.toString(), pathOnly + "VECTREX.I");
            Path digital = Paths.get(Global.mainPathPrefix, "template", "ayfxPlayer.i");
            UtilityFiles.copyOneFile(digital.toString(), pathOnly + "ayfxPlayer.i");
            Path template = Paths.get(Global.mainPathPrefix, "template", "ayfxPlayMain.template");
            String exampleMain = UtilityString.readTextFileToOneString(new File(template.toString()));
            exampleMain = UtilityString.replace(exampleMain, "#AYFX_DATA_ADDRESS#", barenameOnly + "_data");
            exampleMain = UtilityString.replace(exampleMain, "#AYFX_DATA#", filenameBaseOnly + ".asm");
            exampleMain = UtilityString.replace(exampleMain, "#AYFX_NAME#", UtilityString.onlyUpperASCII(filenameBaseOnly.toUpperCase()));
            UtilityFiles.createTextFile(pathOnly + filenameBaseOnly + "Main.asm", exampleMain);
        }
        this.refreshTree();
    }

    public String getProjectBase() {
        if (this.currentProject == null) {
            return "";
        }
        return this.currentProject.projectPrefix;
    }

    boolean saveAYFX(String inFilename, String outFilename) {
        Path path = Paths.get(inFilename, new String[0]);
        String nameOnly = path.getFileName().toString();
        String barenameOnly = nameOnly.substring(0, nameOnly.length() - 4);
        try {
            byte[] data2 = Files.readAllBytes(path);
            StringBuilder buf = new StringBuilder();
            int count = 0;
            buf.append("; AYFX - Data of file: \"" + inFilename + "\"\n");
            buf.append("" + barenameOnly + "_data:\n");
            for (int i = 0; i < data2.length; ++i) {
                if (count == 0) {
                    buf.append(" DB ");
                } else {
                    buf.append(", ");
                }
                buf.append(String.format("$%02X", data2[i]));
                if (++count != 10) continue;
                count = 0;
                buf.append("\n");
            }
            UtilityFiles.createTextFile(outFilename, buf.toString());
        }
        catch (Throwable e) {
            this.log.addLog(e, LogPanel.WARN);
            return false;
        }
        return true;
    }

    boolean saveAYFXC(String inFilename, String outFilename) {
        Path path = Paths.get(inFilename, new String[0]);
        String nameOnly = path.getFileName().toString();
        String barenameOnly = nameOnly.substring(0, nameOnly.length() - 4);
        try {
            byte[] data2 = Files.readAllBytes(path);
            StringBuilder buf = new StringBuilder();
            int count = 0;
            buf.append("// AYFX - Data of file: \"" + inFilename + "\"\n");
            buf.append("const unsigned int " + barenameOnly + "_data").append("[]=\n{\n");
            for (int i = 0; i < data2.length; ++i) {
                if (count == 0) {
                    buf.append("\t");
                } else {
                    buf.append("");
                }
                buf.append(String.format("0x%02X, ", data2[i]));
                if (++count != 10) continue;
                count = 0;
                buf.append("\n");
            }
            buf.append("\n};\n");
            UtilityFiles.createTextFile(outFilename, buf.toString());
        }
        catch (Throwable e) {
            this.log.addLog(e, LogPanel.WARN);
            return false;
        }
        return true;
    }

    void doVector() {
        String type = "";
        String pathFull = "";
        String pathOnly = "";
        String filenameOnly = "";
        String filenameBaseOnly = "";
        Path p = Paths.get(this.selectedTreeEntry.pathAndName.toString(), new String[0]);
        pathFull = p.toString();
        pathOnly = p.getParent().toString();
        filenameOnly = p.getFileName().toString();
        boolean pic = false;
        if (filenameOnly.toLowerCase().endsWith(".gif")) {
            pic = true;
        }
        if (filenameOnly.toLowerCase().endsWith(".jpg")) {
            pic = true;
        }
        if (filenameOnly.toLowerCase().endsWith(".png")) {
            pic = true;
        }
        if (filenameOnly.toLowerCase().endsWith(".bmp")) {
            pic = true;
        }
        if (!pic) {
            this.printError("Selected entry does not have a known image extension!");
            return;
        }
        VectorJPanel.showModPanelNoModal(pathFull, this);
    }

    public static boolean checkBIOS(String word) {
        String target;
        if (biosMap == null) {
            biosMap = new HashMap();
            biosMap.put("Abs_a_b", "F584");
            biosMap.put("Abs_b", "F58B");
            biosMap.put("Add_Score_a", "F85E");
            biosMap.put("Add_Score_d", "F87C");
            biosMap.put("Bitmask_a", "F57E");
            biosMap.put("Check0Ref", "F34F");
            biosMap.put("Clear_C8_RAM", "F542");
            biosMap.put("Clear_Score", "F84F");
            biosMap.put("Clear_Sound", "F272");
            biosMap.put("Clear_x_256", "F545");
            biosMap.put("Clear_x_b", "F53F");
            biosMap.put("Clear_x_b_80", "F550");
            biosMap.put("Clear_x_b_a", "F552");
            biosMap.put("Clear_x_d", "F548");
            biosMap.put("Cold_Start", "F000");
            biosMap.put("Compare_Score", "F8C7");
            biosMap.put("Dec_3_Counters", "F55A");
            biosMap.put("Dec_6_Counters", "F55E");
            biosMap.put("Dec_Counters", "F563");
            biosMap.put("Delay_0", "F579");
            biosMap.put("Delay_1", "F575");
            biosMap.put("Delay_2", "F571");
            biosMap.put("Delay_3", "F56D");
            biosMap.put("Delay_b", "F57A");
            biosMap.put("Delay_RTS", "F57D");
            biosMap.put("Display_Option", "F835");
            biosMap.put("Do_Sound", "F289");
            biosMap.put("Do_Sound_x", "F28C");
            biosMap.put("Dot_d", "F2C3");
            biosMap.put("Dot_here", "F2C5");
            biosMap.put("Dot_ix_b", "F2BE");
            biosMap.put("Dot_ix", "F2C1");
            biosMap.put("Dot_List", "F2D5");
            biosMap.put("Dot_List_Reset", "F2DE");
            biosMap.put("DP_to_C8", "F1AF");
            biosMap.put("DP_to_D0", "F1AA");
            biosMap.put("Draw_Grid_VL", "FF9F");
            biosMap.put("Draw_Line_d", "F3DF");
            biosMap.put("Draw_Pat_VL", "F437");
            biosMap.put("Draw_Pat_VL_a", "F434");
            biosMap.put("Draw_Pat_VL_d", "F439");
            biosMap.put("Draw_VL", "F3DD");
            biosMap.put("Draw_VL_a", "F3DA");
            biosMap.put("Draw_VL_ab", "F3D8");
            biosMap.put("Draw_VL_b", "F3D2");
            biosMap.put("Draw_VL_mode", "F46E");
            biosMap.put("Draw_VLc", "F3CE");
            biosMap.put("Draw_VLcs", "F3D6");
            biosMap.put("Draw_VLp", "F410");
            biosMap.put("Draw_VLp_7F", "F408");
            biosMap.put("Draw_VLp_b", "F40E");
            biosMap.put("Draw_VLp_FF", "F404");
            biosMap.put("Draw_VLp_scale", "F40C");
            biosMap.put("Explosion_Snd", "F92E");
            biosMap.put("Get_Rise_Idx", "F5D9");
            biosMap.put("Get_Run_Idx", "F5DB");
            biosMap.put("Init_Music", "F68D");
            biosMap.put("Init_Music_Buf", "F533");
            biosMap.put("Init_Music_chk", "F687");
            biosMap.put("Init_Music_dft", "F692");
            biosMap.put("Init_OS", "F18B");
            biosMap.put("Init_OS_RAM", "F164");
            biosMap.put("Init_VIA", "F14C");
            biosMap.put("Intensity_1F", "F29D");
            biosMap.put("Intensity_3F", "F2A1");
            biosMap.put("Intensity_5F", "F2A5");
            biosMap.put("Intensity_7F", "F2A9");
            biosMap.put("Intensity_a", "F2AB");
            biosMap.put("Joy_Analog", "F1F5");
            biosMap.put("Joy_Digital", "F1F8");
            biosMap.put("Mov_Draw_VL", "F3BC");
            biosMap.put("Mov_Draw_VL_ab", "F3B7");
            biosMap.put("Mov_Draw_VL_a", "F3B9");
            biosMap.put("Mov_Draw_VL_d", "F3BE");
            biosMap.put("Mov_Draw_VLc_a", "F3AD");
            biosMap.put("Mov_Draw_VLc_b", "F3B1");
            biosMap.put("Mov_Draw_VLcs", "F3B5");
            biosMap.put("Move_Mem_a", "F683");
            biosMap.put("Move_Mem_a_1", "F67F");
            biosMap.put("Moveto_d", "F312");
            biosMap.put("Moveto_d_7F", "F2FC");
            biosMap.put("Moveto_ix", "F310");
            biosMap.put("Moveto_ix_7F", "F30C");
            biosMap.put("Moveto_ix_b", "F30E");
            biosMap.put("Moveto_ix_FF", "F308");
            biosMap.put("Moveto_x_7F", "F2F2");
            biosMap.put("New_High_Score", "F8D8");
            biosMap.put("Obj_Hit", "F8FF");
            biosMap.put("Obj_Will_Hit", "F8F3");
            biosMap.put("Obj_Will_Hit_u", "F8E5");
            biosMap.put("Print_Str_d", "F37A");
            biosMap.put("Print_List", "F38A");
            biosMap.put("Print_List_chk", "F38C");
            biosMap.put("Print_List_hw", "F385");
            biosMap.put("Print_Ships_x", "F391");
            biosMap.put("Print_Ships", "F393");
            biosMap.put("Print_Str", "F495");
            biosMap.put("Print_Str_hwyx", "F373");
            biosMap.put("Print_Str_yx", "F378");
            biosMap.put("Random", "F517");
            biosMap.put("Random_3", "F511");
            biosMap.put("Read_Btns_Mask", "F1B4");
            biosMap.put("Read_Btns", "F1BA");
            biosMap.put("Recalibrate", "F2E6");
            biosMap.put("Reset_Pen", "F35B");
            biosMap.put("Reset0Int", "F36B");
            biosMap.put("Reset0Ref", "F354");
            biosMap.put("Reset0Ref_D0", "F34A");
            biosMap.put("Rise_Run_Angle", "F593");
            biosMap.put("Rise_Run_Idx", "F5EF");
            biosMap.put("Rise_Run_Len", "F603");
            biosMap.put("Rise_Run_X", "F5FF");
            biosMap.put("Rise_Run_Y", "F601");
            biosMap.put("Rot_VL", "F616");
            biosMap.put("Rot_VL_ab", "F610");
            biosMap.put("Rot_VL_M_dft", "F62B");
            biosMap.put("Rot_VL_Mode", "F61F");
            biosMap.put("Select_Game", "F7A9");
            biosMap.put("Set_Refresh", "F1A2");
            biosMap.put("Sound_Byte", "F256");
            biosMap.put("Sound_Byte_x", "F259");
            biosMap.put("Sound_Byte_raw", "F25B");
            biosMap.put("Sound_Bytes", "F27D");
            biosMap.put("Sound_Bytes_x", "F284");
            biosMap.put("Strip_Zeros", "F8B7");
            biosMap.put("Wait_Recal", "F192");
            biosMap.put("Warm_Start", "F06C");
            biosMap.put("Xform_Rise", "F663");
            biosMap.put("Xform_Rise_a", "F661");
            biosMap.put("Xform_Run", "F65D");
            biosMap.put("Xform_Run_a", "F65B");
        }
        if ((target = biosMap.get(word)) != null) {
            return false;
        }
        return false;
    }

    public boolean checkBIOSFile(String word) {
        Integer target;
        if (biosFileMap == null) {
            biosFileMap = new HashMap();
            biosFileMap.put("Abs_a_b", 2038);
            biosFileMap.put("Abs_b", 2038);
            biosFileMap.put("Add_Score_a", 2765);
            biosFileMap.put("Add_Score_d", 2765);
            biosFileMap.put("Bitmask_a", 2021);
            biosFileMap.put("Check0Ref", 985);
            biosFileMap.put("Clear_C8_RAM", 1889);
            biosFileMap.put("Clear_Score", 2744);
            biosFileMap.put("Clear_Sound", 594);
            biosFileMap.put("Clear_x_256", 1901);
            biosFileMap.put("Clear_x_b", 1873);
            biosFileMap.put("Clear_x_b_80", 1920);
            biosFileMap.put("Clear_x_b_a", 1920);
            biosFileMap.put("Clear_x_d", 1901);
            biosFileMap.put("Cold_Start", 29);
            biosFileMap.put("Compare_Score", 2851);
            biosFileMap.put("Dec_3_Counters", 1945);
            biosFileMap.put("Dec_6_Counters", 1945);
            biosFileMap.put("Dec_Counters", 1965);
            biosFileMap.put("Delay_0", 1986);
            biosFileMap.put("Delay_1", 1986);
            biosFileMap.put("Delay_2", 1986);
            biosFileMap.put("Delay_3", 1986);
            biosFileMap.put("Delay_b", 1986);
            biosFileMap.put("Delay_RTS", 1986);
            biosFileMap.put("Display_Option", 2711);
            biosFileMap.put("Do_Sound", 644);
            biosFileMap.put("Do_Sound_x", 644);
            biosFileMap.put("Dot_d", 732);
            biosFileMap.put("Dot_here", 748);
            biosFileMap.put("Dot_ix_b", 711);
            biosFileMap.put("Dot_ix", 711);
            biosFileMap.put("Dot_List", 767);
            biosFileMap.put("Dot_List_Reset", 794);
            biosFileMap.put("DP_to_C8", 365);
            biosFileMap.put("DP_to_D0", 351);
            biosFileMap.put("Draw_Grid_VL", 3307);
            biosFileMap.put("Draw_Line_d", 1461);
            biosFileMap.put("Draw_Pat_VL", 1623);
            biosFileMap.put("Draw_Pat_VL_a", 1623);
            biosFileMap.put("Draw_Pat_VL_d", 1623);
            biosFileMap.put("Draw_VL", 1441);
            biosFileMap.put("Draw_VL_a", 1421);
            biosFileMap.put("Draw_VL_ab", 1404);
            biosFileMap.put("Draw_VL_b", 1360);
            biosFileMap.put("Draw_VL_mode", 1688);
            biosFileMap.put("Draw_VLc", 1339);
            biosFileMap.put("Draw_VLcs", 1380);
            biosFileMap.put("Draw_VLp", 1581);
            biosFileMap.put("Draw_VLp_7F", 1497);
            biosFileMap.put("Draw_VLp_b", 1555);
            biosFileMap.put("Draw_VLp_FF", 1497);
            biosFileMap.put("Draw_VLp_scale", 1528);
            biosFileMap.put("Explosion_Snd", 2995);
            biosFileMap.put("Get_Rise_Idx", 2127);
            biosFileMap.put("Get_Run_Idx", 2127);
            biosFileMap.put("Init_Music", 2411);
            biosFileMap.put("Init_Music_Buf", 1857);
            biosFileMap.put("Init_Music_chk", 2411);
            biosFileMap.put("Init_Music_dft", 2411);
            biosFileMap.put("Init_OS", 292);
            biosFileMap.put("Init_OS_RAM", 262);
            biosFileMap.put("Init_VIA", 239);
            biosFileMap.put("Intensity_1F", 671);
            biosFileMap.put("Intensity_3F", 671);
            biosFileMap.put("Intensity_5F", 671);
            biosFileMap.put("Intensity_7F", 671);
            biosFileMap.put("Intensity_a", 671);
            biosFileMap.put("Joy_Analog", 466);
            biosFileMap.put("Joy_Digital", 466);
            biosFileMap.put("Mov_Draw_VL", 1304);
            biosFileMap.put("Mov_Draw_VL_b", 1236);
            biosFileMap.put("Mov_Draw_VL_ab", 1281);
            biosFileMap.put("Mov_Draw_VL_a", 1281);
            biosFileMap.put("Mov_Draw_VL_d", 1304);
            biosFileMap.put("Mov_Draw_VLc_a", 1214);
            biosFileMap.put("Mov_Draw_VLcs", 1260);
            biosFileMap.put("Move_Mem_a", 2385);
            biosFileMap.put("Move_Mem_a_1", 2385);
            biosFileMap.put("Moveto_d", 926);
            biosFileMap.put("Moveto_d_7F", 865);
            biosFileMap.put("Moveto_ix", 909);
            biosFileMap.put("Moveto_ix_7F", 885);
            biosFileMap.put("Moveto_ix_b", 885);
            biosFileMap.put("Moveto_ix_FF", 885);
            biosFileMap.put("Moveto_x_7F", 840);
            biosFileMap.put("New_High_Score", 2882);
            biosFileMap.put("Obj_Hit", 2945);
            biosFileMap.put("Obj_Will_Hit", 2905);
            biosFileMap.put("Obj_Will_Hit_u", 2905);
            biosFileMap.put("Print_Str_d", 1094);
            biosFileMap.put("Print_List", 1145);
            biosFileMap.put("Print_List_chk", 1145);
            biosFileMap.put("Print_List_hw", 1121);
            biosFileMap.put("Print_Ships_x", 1177);
            biosFileMap.put("Print_Ships", 1177);
            biosFileMap.put("Print_Str", 1739);
            biosFileMap.put("Print_Str_hwyx", 1054);
            biosFileMap.put("Print_Str_yx", 1075);
            biosFileMap.put("Random", 1822);
            biosFileMap.put("Random_3", 1822);
            biosFileMap.put("Read_Btns_Mask", 380);
            biosFileMap.put("Read_Btns", 380);
            biosFileMap.put("Recalibrate", 824);
            biosFileMap.put("Reset_Pen", 1018);
            biosFileMap.put("Reset0Int", 1037);
            biosFileMap.put("Reset0Ref", 1001);
            biosFileMap.put("Reset0Ref_D0", 971);
            biosFileMap.put("Rise_Run_Angle", 2067);
            biosFileMap.put("Rise_Run_Idx", 2173);
            biosFileMap.put("Rise_Run_Len", 2197);
            biosFileMap.put("Rise_Run_X", 2197);
            biosFileMap.put("Rise_Run_Y", 2197);
            biosFileMap.put("Rot_VL", 2235);
            biosFileMap.put("Rot_VL_ab", 2235);
            biosFileMap.put("Rot_VL_M_dft", 2269);
            biosFileMap.put("Rot_VL_Mode", 2269);
            biosFileMap.put("Select_Game", 2600);
            biosFileMap.put("Set_Refresh", 331);
            biosFileMap.put("Sound_Byte", 558);
            biosFileMap.put("Sound_Byte_x", 558);
            biosFileMap.put("Sound_Byte_raw", 558);
            biosFileMap.put("Sound_Bytes", 612);
            biosFileMap.put("Sound_Bytes_x", 612);
            biosFileMap.put("Strip_Zeros", 2830);
            biosFileMap.put("Wait_Recal", 309);
            biosFileMap.put("Warm_Start", 99);
            biosFileMap.put("Xform_Rise", 2349);
            biosFileMap.put("Xform_Rise_a", 2349);
            biosFileMap.put("Xform_Run", 2328);
            biosFileMap.put("Xform_Run_a", 2328);
        }
        if ((target = biosFileMap.get(word)) != null) {
            final String to = Global.mainPathPrefix + "tmp" + File.separator + "BIOS.ASM";
            File biosFile = new File(to);
            if (!biosFile.exists()) {
                String from = Global.mainPathPrefix + "codelib" + File.separator + "Originals" + File.separator + "BIOS - Bruce Tomlin" + File.separator + "BIOS.ASM";
                UtilityFiles.copyOneFile(from, to);
            }
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VediPanel.this.jumpToEdit(to, target);
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public static boolean displayHelp(String h) {
        if (h == null) {
            return false;
        }
        h = h.toLowerCase();
        String path = Global.mainPathPrefix + "help" + File.separator;
        String full = path + h + ".html";
        File f = new File(full);
        if (!f.exists()) {
            full = path + h + ".htm";
        }
        if ((f = new File(full)).exists()) {
            QuickHelpTopFrame.showHelpHtmlFile(full);
            return true;
        }
        full = path + h + ".png";
        f = new File(full);
        if (f.exists()) {
            QuickHelpTopFrame.showHelpPNGFile(full);
            return true;
        }
        return false;
    }

    public static boolean openInVedi(String path) {
        VediPanel vp = Configuration.getConfiguration().getMainFrame().getVedi(true);
        vp.closeProject();
        vp.addEditor(path, false);
        return true;
    }

    public boolean checkVec4EverVolume(boolean verbose) {
        if (!this.settings.v4eEnabled) {
            return false;
        }
        try {
            Path path = Paths.get(this.config.v4eVolumeName, new String[0]);
            File directory = path.toFile();
            File[] fList = directory.listFiles();
            if (fList != null) {
                for (File file : fList) {
                    String readmetxt;
                    if (!file.getName().contains("README.TXT") || !(readmetxt = UtilityString.readTextFileToOneString(file)).contains("Sontowski")) continue;
                    this.printMessage("V4E: RAM DISK volume found.");
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.printError("V4E: RAM DISK volume not found.");
        return false;
    }

    void ejectVec4Ever() {
        boolean available = this.checkVec4EverVolume(false);
        if (!available) {
            this.printError("V4E: VecFever not found!");
            return;
        }
        boolean ok = UtilityFiles.ejectVolume(this.config.v4eVolumeName);
        if (!ok) {
            this.printError("V4E: RAM DISK not ejected");
        } else {
            this.printMessage("V4E: RAM DISK ejected");
        }
    }

    void checkVec4EverProject(CartridgeProperties cart) {
        try {
            if (cart.getFullFilename().size() == 2) {
                boolean is48K = (this.currentProject.getExtras() & Cartridge.FLAG_48K) != 0;
                boolean is44K = (this.currentProject.getExtras() & Cartridge.FLAG_44_PEER_BS) != 0;
                int memSize = 32768;
                if (is48K) {
                    memSize += 32768;
                }
                String newFilename = Utility.makeVideAbsolute(cart.getFullFilename().elementAt(0).substring(0, cart.getFullFilename().elementAt(0).length() - 1 - 4));
                String n1 = Utility.makeVideAbsolute(cart.getFullFilename().elementAt(0));
                String n2 = Utility.makeVideAbsolute(cart.getFullFilename().elementAt(1));
                UtilityFiles.padFile(n1, (byte)-1, memSize);
                UtilityFiles.padFile(n2, (byte)-1, memSize);
                n1 = n1 + ".fil";
                n2 = n2 + ".fil";
                UtilityFiles.concatFiles(n1, n2);
                this.checkVec4EverFile(n1 + ".con");
                if (is48K && !is44K) {
                    UtilityFiles.concatFiles(n1 + ".con", n1 + ".con");
                }
            } else if (cart.getFullFilename().size() == 4) {
                boolean is48K = (this.currentProject.getExtras() & Cartridge.FLAG_48K) != 0;
                boolean is44K = (this.currentProject.getExtras() & Cartridge.FLAG_44_PEER_BS) != 0;
                int memSize = 32768;
                if (is48K) {
                    memSize += 32768;
                }
                String newFilename = Utility.makeVideAbsolute(cart.getFullFilename().elementAt(0).substring(0, cart.getFullFilename().elementAt(0).length() - 1 - 4));
                String n1 = Utility.makeVideAbsolute(cart.getFullFilename().elementAt(0));
                String n2 = Utility.makeVideAbsolute(cart.getFullFilename().elementAt(1));
                String n3 = Utility.makeVideAbsolute(cart.getFullFilename().elementAt(2));
                String n4 = Utility.makeVideAbsolute(cart.getFullFilename().elementAt(3));
                UtilityFiles.padFile(n1, (byte)-1, memSize);
                UtilityFiles.padFile(n2, (byte)-1, memSize);
                UtilityFiles.padFile(n3, (byte)-1, memSize);
                UtilityFiles.padFile(n4, (byte)-1, memSize);
                n1 = n1 + ".fil";
                n2 = n2 + ".fil";
                n3 = n3 + ".fil";
                n4 = n4 + ".fil";
                UtilityFiles.concatFiles(n1, n2);
                UtilityFiles.concatFiles(n3, n4);
                UtilityFiles.concatFiles(n1 + ".con", n3 + ".con");
                UtilityFiles.rename(n1 + ".con.con", newFilename + "256k.bin");
                UtilityFiles.deleteFile(n1);
                UtilityFiles.deleteFile(n2);
                UtilityFiles.deleteFile(n3);
                UtilityFiles.deleteFile(n4);
                UtilityFiles.deleteFile(n1 + ".con");
                UtilityFiles.deleteFile(n3 + ".con");
                if (this.settings.piTrexEnabled && PiTrexSingleton.getPiTrex().isReady()) {
                    PiTrexSingleton.getPiTrex().fileToPiTrex(newFilename + "256k.bin");
                    this.printMessage("PiTrex: bin file copied.");
                    return;
                }
            } else {
                String filename = Utility.makeVideAbsolute(cart.getFullFilename().elementAt(0));
                this.checkVec4EverFile(filename);
            }
        }
        catch (Throwable e) {
            this.printError("V4E: could not access project file.");
        }
    }

    public void checkVec4EverFile(String filenameAbs) {
        if (this.settings.piTrexEnabled && PiTrexSingleton.getPiTrex().isReady()) {
            PiTrexSingleton.getPiTrex().fileToPiTrex(filenameAbs);
            this.printMessage("PiTrex: bin file copied.");
            return;
        }
        if (!this.checkVec4EverVolume(false)) {
            return;
        }
        boolean ok = UtilityFiles.copyOneFile(filenameAbs, this.config.v4eVolumeName + File.separator + "cart.bin");
        if (!ok) {
            this.printError("V4E: error copying file to RAMDISK: " + UtilityFiles.error);
        } else {
            this.printMessage("V4E: bin file copied to RAM DISK");
            if (this.config.autoEjectV4EonCompile) {
                this.ejectVec4Ever();
            }
        }
    }

    public int getFontSize() {
        return this.settings.fontSize;
    }

    void setFontSize(int fs) {
        ArrayList cloneStyleList = (ArrayList)TokenStyles.styleList.clone();
        this.settings.fontSize = fs;
        for (TokenStyles.MyStyle style : cloneStyleList) {
            if (style.name.contains("editLog")) continue;
            TokenStyles.addStyle(style.name, StyleConstants.getBackground(style), StyleConstants.getForeground(style), StyleConstants.isBold(style), StyleConstants.isItalic(style), this.settings.fontSize, StyleConstants.getFontFamily(style));
        }
        this.resetAllEditors();
    }

    void increaseFontSize() {
        ArrayList cloneStyleList = (ArrayList)TokenStyles.styleList.clone();
        ++this.settings.fontSize;
        for (TokenStyles.MyStyle style : cloneStyleList) {
            if (style.name.contains("editLog")) continue;
            TokenStyles.addStyle(style.name, StyleConstants.getBackground(style), StyleConstants.getForeground(style), StyleConstants.isBold(style), StyleConstants.isItalic(style), this.settings.fontSize, StyleConstants.getFontFamily(style));
        }
        this.resetAllEditors();
    }

    void decreaseFontSize() {
        ArrayList cloneStyleList = (ArrayList)TokenStyles.styleList.clone();
        --this.settings.fontSize;
        for (TokenStyles.MyStyle style : cloneStyleList) {
            if (style.name.contains("editLog")) continue;
            TokenStyles.addStyle(style.name, StyleConstants.getBackground(style), StyleConstants.getForeground(style), StyleConstants.isBold(style), StyleConstants.isItalic(style), this.settings.fontSize, StyleConstants.getFontFamily(style));
        }
        this.resetAllEditors();
    }

    void resetAllEditors() {
        for (Component c : this.jTabbedPane1.getComponents()) {
            if (!(c instanceof EditorPanel)) continue;
            EditorPanel ep = (EditorPanel)c;
            ep.stopColoring();
            ep.startColoring(this.settings.fontSize);
        }
    }

    public void removeUIListerner() {
        UIManager.removePropertyChangeListener(this.pListener);
    }

    void updateMyUI() {
        this.jEditorPaneASMListing.setText("");
        this.jEditorASMMessages.setText("");
        this.jEditorLog.setText("");
        SwingUtilities.updateComponentTreeUI(this.jPopupMenu1);
        SwingUtilities.updateComponentTreeUI(this.jPopupMenuTree);
        SwingUtilities.updateComponentTreeUI(this.jPopupMenuProjectProperties);
        for (Component c : this.jTabbedPane1.getComponents()) {
            if (!(c instanceof EditorPanel)) continue;
            EditorPanel ep = (EditorPanel)c;
            ep.updateMyUI();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initInventory() {
        if (this.invUpdating) {
            return;
        }
        this.invUpdating = true;
        this.inventory.clear();
        EditorPanel edi = this.getSelectedEditor();
        if (edi != null) {
            Object entity;
            Set entries;
            HashMap clonnie;
            String filename = edi.getFilename();
            if (filename.contains(Global.mainPathPrefix)) {
                filename = UtilityString.replace(filename, Global.mainPathPrefix, "");
            }
            if (edi.assume6809C) {
                HashMap<String, EntityDefinition> hashMap = this.cInfo.knownGlobalFunctions;
                synchronized (hashMap) {
                    clonnie = (HashMap)this.cInfo.knownGlobalFunctions.clone();
                    entries = clonnie.entrySet();
                }
                for (Map.Entry entry : entries) {
                    entity = (EntityDefinition)entry.getValue();
                    if (((EntityDefinition)entity).getCFile() != null && !((EntityDefinition)entity).getCFile().toString().toLowerCase().equals(filename.toLowerCase())) continue;
                    boolean add = false;
                    add = add || this.settings.showEQULabel && ((EntityDefinition)entity).getSubType() == EntityDefinition.SUBTYPE_EQU_LABEL;
                    add = add || this.settings.showEqualLabel && ((EntityDefinition)entity).getSubType() == EntityDefinition.SUBTYPE_DEFINED_LABEL;
                    add = add || this.settings.showSetLabel && ((EntityDefinition)entity).getSubType() == EntityDefinition.SUBTYPE_SET_LABEL;
                    add = add || this.settings.showStructLabel && ((EntityDefinition)entity).getSubType() == EntityDefinition.SUBTYPE_STRUCT_LABEL;
                    add = add || this.settings.showInStructLabel && ((EntityDefinition)entity).getSubType() == EntityDefinition.SUBTYPE_INSTRUCT_LABEL;
                    add = add || this.settings.showLineLabel && ((EntityDefinition)entity).getSubType() == EntityDefinition.SUBTYPE_LINE_LABEL;
                    add = add || this.settings.showDataLabel && ((EntityDefinition)entity).getSubType() == EntityDefinition.SUBTYPE_DATA_LABEL;
                    add = add || this.settings.showMacroLabel && ((EntityDefinition)entity).getSubType() == EntityDefinition.SUBTYPE_INNER_MACRO_LABEL;
                    add = add || this.settings.showFunctionLabel && ((EntityDefinition)entity).getSubType() == EntityDefinition.SUBTYPE_FUNCTION_LABEL;
                    add = add || this.settings.showUserLabel && ((EntityDefinition)entity).getSubType() == EntityDefinition.SUBTYPE_VERIFIED_FUNCTION_LABEL;
                    if (!(add = add || this.settings.showMacroDefinition && ((EntityDefinition)entity).getSubType() == EntityDefinition.SUBTYPE_MACRO_DEFINITION_LABEL)) continue;
                    this.inventory.add(new InventoryEntry(((EntityDefinition)entity).getName(), ((EntityDefinition)entity).getLineNumber(), ((EntityDefinition)entity).getSubType()));
                }
            } else if (edi.assume6809Asm) {
                Iterator it = this.asmInfo.knownGlobalVariables;
                synchronized (it) {
                    clonnie = (HashMap)this.asmInfo.knownGlobalVariables.clone();
                    entries = clonnie.entrySet();
                }
                for (Map.Entry entry : entries) {
                    entity = (EntityDefinition)entry.getValue();
                    if (((EntityDefinition)entity).getCFile() == null ? !((EntityDefinition)entity).getFile().toString().toLowerCase().equals(filename.toLowerCase()) : !((EntityDefinition)entity).getCFile().toString().toLowerCase().equals(filename.toLowerCase())) continue;
                    boolean add = false;
                    add = add || this.settings.showEQULabel && ((EntityDefinition)entity).getSubType() == EntityDefinition.SUBTYPE_EQU_LABEL;
                    add = add || this.settings.showEqualLabel && ((EntityDefinition)entity).getSubType() == EntityDefinition.SUBTYPE_DEFINED_LABEL;
                    add = add || this.settings.showSetLabel && ((EntityDefinition)entity).getSubType() == EntityDefinition.SUBTYPE_SET_LABEL;
                    add = add || this.settings.showStructLabel && ((EntityDefinition)entity).getSubType() == EntityDefinition.SUBTYPE_STRUCT_LABEL;
                    add = add || this.settings.showInStructLabel && ((EntityDefinition)entity).getSubType() == EntityDefinition.SUBTYPE_INSTRUCT_LABEL;
                    add = add || this.settings.showLineLabel && ((EntityDefinition)entity).getSubType() == EntityDefinition.SUBTYPE_LINE_LABEL;
                    add = add || this.settings.showDataLabel && ((EntityDefinition)entity).getSubType() == EntityDefinition.SUBTYPE_DATA_LABEL;
                    add = add || this.settings.showMacroLabel && ((EntityDefinition)entity).getSubType() == EntityDefinition.SUBTYPE_INNER_MACRO_LABEL;
                    add = add || this.settings.showFunctionLabel && ((EntityDefinition)entity).getSubType() == EntityDefinition.SUBTYPE_FUNCTION_LABEL;
                    if (!(add = add || this.settings.showUserLabel && ((EntityDefinition)entity).getSubType() == EntityDefinition.SUBTYPE_VERIFIED_FUNCTION_LABEL)) continue;
                    this.inventory.add(new InventoryEntry(((EntityDefinition)entity).getName(), ((EntityDefinition)entity).getLineNumber(), ((EntityDefinition)entity).getSubType()));
                }
                HashMap<String, String> savety = new HashMap<String, String>();
                if (this.settings.showMacroDefinition) {
                    entity = this.asmInfo.knownGlobalMacros;
                    synchronized (entity) {
                        HashMap clonnie2 = (HashMap)this.asmInfo.knownGlobalMacros.clone();
                        entries = clonnie2.entrySet();
                    }
                    for (Map.Entry entry : entries) {
                        EntityDefinition entity2 = (EntityDefinition)entry.getValue();
                        if (entity2.getCFile() != null ? !entity2.getCFile().toString().toLowerCase().equals(filename.toLowerCase()) : !entity2.getFile().toString().toLowerCase().equals(filename.toLowerCase())) continue;
                        boolean add = false;
                        if (entity2.getSubType() != EntityDefinition.SUBTYPE_MACRO_DEFINITION_LABEL || savety.get(entity2.getName()) != null) continue;
                        savety.put(entity2.getName(), entity2.getName());
                        this.inventory.add(new InventoryEntry(entity2.getName(), entity2.getLineNumber(), entity2.getSubType()));
                    }
                }
            }
        }
        this.invUpdating = false;
        List<RowSorter.SortKey> list2 = this.sorter.getSortKeys();
        this.jTableInventory.tableChanged(null);
        this.sorter.setSortKeys(list2);
        this.sorter.sort();
        this.jTableInventory.setAutoResizeMode(3);
        for (int i = 0; i < this.inventoryModel.getColumnCount(); ++i) {
            this.jTableInventory.getColumnModel().getColumn(i).setPreferredWidth(this.inventoryModel.getColWidth(i));
            this.jTableInventory.getColumnModel().getColumn(i).setWidth(this.inventoryModel.getColWidth(i));
        }
        this.jTableInventory.setAutoResizeMode(2);
    }

    void goFunction(int row) {
        if (row < 0) {
            return;
        }
        if (row >= this.inventory.size()) {
            return;
        }
        InventoryEntry inv = this.inventory.get(row);
        EditorPanel edi = this.getSelectedEditor();
        if (edi == null) {
            return;
        }
        this.addHistory();
        edi.goLine(inv.line);
        this.updateTables();
    }

    private void addHistory() {
        EditorPanel edi = this.getSelectedEditor();
        if (edi == null) {
            return;
        }
        while (this.historyPosition < this.history.size()) {
            this.history.remove(this.history.size() - 1);
        }
        this.history.add(new HistoryEntry(edi.getFilename(), edi.getCurrentLineNumber() + 1));
        this.historyPosition = this.history.size();
        this.jButtonAdressBack.setEnabled(this.historyPosition > 0);
        this.jButtonAdressForward.setEnabled(this.historyPosition < this.history.size());
    }

    private void historyBack() {
        if (this.historyPosition > 0) {
            if (this.historyPosition == this.history.size()) {
                this.addHistory();
                --this.historyPosition;
            }
            --this.historyPosition;
            HistoryEntry h = this.history.get(this.historyPosition);
            this.jumpToEdit(h.file, h.line, false);
        }
        this.jButtonAdressBack.setEnabled(this.historyPosition > 0);
        this.jButtonAdressForward.setEnabled(this.historyPosition < this.history.size());
    }

    private void historyForward() {
        if (this.historyPosition < this.history.size() - 1) {
            ++this.historyPosition;
            HistoryEntry h = this.history.get(this.historyPosition);
            this.jumpToEdit(h.file, h.line, false);
        }
        if (this.historyPosition == this.history.size() - 1) {
            this.history.remove(this.history.size() - 1);
        }
        this.jButtonAdressBack.setEnabled(this.historyPosition > 0);
        this.jButtonAdressForward.setEnabled(this.historyPosition < this.history.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deinitScheduler() {
        Object object = this.syncObject;
        synchronized (object) {
            if (this.timer != null) {
                this.timer.removeTrigger(this.timerWorker);
                this.timerWorker = null;
                this.timer = null;
            }
        }
    }

    private void initScheduler() {
        if (this.timer == null) {
            this.timer = TimingTriggerer.getPrivatTimer();
            this.timer.setResolution(this.config.deepSyntaxCheckTiming);
            this.timerWorker = new TriggerCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void doIt(int state, Object o) {
                    VediPanel.this.updateDefinitions();
                    Object object = VediPanel.this.syncObject;
                    synchronized (object) {
                        if (VediPanel.this.timer != null && VediPanel.this.timerWorker != null) {
                            VediPanel.this.timer.addTrigger(VediPanel.this.timerWorker, VediPanel.this.config.deepSyntaxCheckTiming, 0, null);
                        }
                    }
                }
            };
            this.timer.addTrigger(this.timerWorker, this.config.deepSyntaxCheckTiming, 0, null);
        }
    }

    boolean doIHaveSomeFocus() {
        if (this.getFrame() == null) {
            return false;
        }
        Component c = this.getFrame().getFocusOwner();
        if (c == null) {
            return false;
        }
        while (c != null) {
            if (c == this) {
                return true;
            }
            c = c.getParent();
        }
        return false;
    }

    boolean doesItHaveSomeFocus(Component editor) {
        Component c = this.getFrame().getFocusOwner();
        if (c == null) {
            return false;
        }
        while (c != null) {
            if (c == editor) {
                return true;
            }
            c = c.getParent();
        }
        return false;
    }

    private void updateDefinitions() {
        if (!this.doIHaveSomeFocus()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (VediPanel.this.config.deepSyntaxCheck) {
                    EditorPanel lastEdi = null;
                    for (int i = 0; i < VediPanel.this.jTabbedPane1.getTabCount(); ++i) {
                        try {
                            EditorPanel edi;
                            if (!(VediPanel.this.jTabbedPane1.getComponentAt(i) instanceof EditorPanel)) continue;
                            lastEdi = edi = (EditorPanel)VediPanel.this.jTabbedPane1.getComponentAt(i);
                            if (edi.assume6809Asm && edi.hasChanged1) {
                                if (VediPanel.this.config.deepSyntaxCheckThresholdActive && edi.getText().length() > VediPanel.this.config.deepSyntaxCheckThreshold) continue;
                                VediPanel.this.asmInfo.resetDefinitions(Utility.makeVideAbsolute(edi.getFilename()), edi.getText(), false);
                                edi.hasChanged1 = false;
                            }
                            if (!edi.assume6809C || !edi.hasChanged1 || VediPanel.this.config.deepSyntaxCheckThresholdActive && edi.getText().length() > VediPanel.this.config.deepSyntaxCheckThreshold) continue;
                            VediPanel.this.cInfo.resetDefinitions(Utility.makeVideAbsolute(edi.getFilename()), edi.getText(), false);
                            edi.hasChanged1 = false;
                            continue;
                        }
                        catch (Throwable e) {
                            VediPanel.this.log.addLog("UpdateDefinitions:\n" + Utility.getStackTrace(e), LogPanel.INFO);
                            if (lastEdi != null) {
                                VediPanel.this.log.addLog("Editorname:\n" + lastEdi.getFilename(), LogPanel.INFO);
                            }
                            e.printStackTrace();
                        }
                    }
                    if (VediPanel.this.getSelectedEditor() != null && VediPanel.this.getSelectedEditor().hasChanged2) {
                        if (!(VediPanel.this.config.deepSyntaxCheckThresholdActive && VediPanel.this.getSelectedEditor().getText().length() > VediPanel.this.config.deepSyntaxCheckThreshold || !VediPanel.this.doesItHaveSomeFocus(VediPanel.this.getSelectedEditor()) || VediPanel.this.getSelectedEditor().hasSelection())) {
                            try {
                                VediPanel.this.getSelectedEditor().setViewportEnabled(false);
                                VediPanel.this.getSelectedEditor().saveSelection();
                                VediPanel.this.getSelectedEditor().stopColoring();
                                VediPanel.this.getSelectedEditor().startColoring(VediPanel.this.settings.fontSize);
                                VediPanel.this.getSelectedEditor().restoreSelection();
                                VediPanel.this.getSelectedEditor().setViewportEnabled(true);
                            }
                            catch (Throwable e) {
                                VediPanel.this.log.addLog("UpdateDefinitions 2:\n" + Utility.getStackTrace(e), LogPanel.INFO);
                                if (lastEdi != null) {
                                    VediPanel.this.log.addLog("Editorname:\n" + VediPanel.this.getSelectedEditor().getFilename(), LogPanel.INFO);
                                }
                                e.printStackTrace();
                            }
                        }
                        VediPanel.this.getSelectedEditor().hasChanged2 = false;
                    }
                }
                VediPanel.this.initInventory();
            }
        });
    }

    @Override
    public void deIconified() {
    }

    public void doCCompilerSingleFile(String file) {
        String compiler = Global.mainPathPrefix + "C" + File.separator + "Mac" + File.separator + "gcc6809" + File.separator + "bin" + File.separator + "cc1";
        String CFLAGS1a = "-dumpbase";
        String CFLAGS1b = VediPanel.baseOnly(file);
        String CFLAGS2a = "-O3";
        String CFLAGS2b = "-O3";
        String CFLAGS3 = "-mint8";
        String CFLAGS4 = "-msoft-reg-count=0";
        String CFLAGS5a = "-auxbase";
        String CFLAGS5b = VediPanel.baseOnly(file);
        String CFLAGS6 = "-I" + Global.mainPathPrefix + "C" + File.separator + "include";
        String CFLAGS7 = "-quiet";
        String CFLAGS8 = "-fno-strict-overflow";
        String CFLAGS9 = "-fno-tree-vrp";
        String CFLAGS10 = "-fno-gcse";
        String program = file;
        String output1 = "-o";
        String output2 = VediPanel.changeTypeTo(file, "s");
        String[] cmd = new String[15];
        int cl = 0;
        cmd[cl++] = compiler;
        cmd[cl++] = CFLAGS1a;
        cmd[cl++] = CFLAGS1b;
        cmd[cl++] = CFLAGS2a;
        cmd[cl++] = CFLAGS2b;
        cmd[cl++] = CFLAGS3;
        cmd[cl++] = CFLAGS4;
        cmd[cl++] = CFLAGS5a;
        cmd[cl++] = CFLAGS5b;
        cmd[cl++] = CFLAGS6;
        cmd[cl++] = CFLAGS7;
        cmd[cl++] = CFLAGS8;
        cmd[cl++] = CFLAGS9;
        cmd[cl++] = CFLAGS10;
        cmd[cl++] = program;
        cmd[cl++] = output1;
        cmd[cl++] = output2;
        CompileResult compiled = this.doCCompiler(cmd);
        if (this.peepAtASM) {
            if (this.currentProject != null) {
                if (this.currentProject.getIsCPeephole()) {
                    FilePeeper.peepCorrectASM(output2);
                }
            } else {
                FilePeeper.peepCorrectASM(output2);
            }
        }
    }

    public CompileResult doCCompiler(String[] flags) {
        if (isMac) {
            return this.doCCompilerMac(flags);
        }
        if (isWin) {
            return this.doCCompilerWin(flags);
        }
        return null;
    }

    public CompileResult doCCompilerWin(String[] flags) {
        flags[0] = Global.mainPathPrefix + "C" + File.separator + "Win32" + File.separator + "bin" + File.separator + "gcc6809.exe";
        String file = flags[flags.length - 3];
        String outputFile = flags[flags.length - 1];
        try {
            this.log.addLog("Trying to compile: " + file, LogPanel.INFO);
            boolean ok = UtilityFiles.executeOSCommand(flags);
            String tt = UtilityFiles.lastError;
            boolean bl = ok = ok && !UtilityFiles.lastError.contains("error:");
            if (ok) {
                this.printWarning(UtilityFiles.lastError);
                this.printMessage(UtilityFiles.lastMessage);
                this.printMessage("\nCompile success");
                CompileResult cr = this.doAssiConform(file, outputFile);
                return cr;
            }
        }
        catch (Throwable e) {
            this.log.addLog(Utility.getStackTrace(e), LogPanel.INFO);
        }
        this.log.addLog("Compile failed: " + file, LogPanel.WARN);
        this.printError(UtilityFiles.lastError);
        this.printError(UtilityFiles.lastMessage);
        this.printError("\nCompile failed");
        return null;
    }

    public CompileResult doCCompilerMac(String[] flags) {
        flags[0] = Global.mainPathPrefix + "C" + File.separator + "Mac" + File.separator + "bin" + File.separator + "cc1";
        String file = flags[flags.length - 3];
        String outputFile = flags[flags.length - 1];
        this.printMessage("\nCompiling: " + file);
        try {
            this.log.addLog("Trying to compile: " + file, LogPanel.INFO);
            boolean ok = UtilityFiles.executeOSCommand(flags);
            String tt = UtilityFiles.lastError;
            boolean bl = ok = ok && !UtilityFiles.lastError.contains("error:");
            if (ok) {
                this.printWarning(UtilityFiles.lastError.trim());
                this.printMessage(UtilityFiles.lastMessage.trim());
                this.printMessage("\nCompile success");
                CompileResult cr = this.doAssiConform(file, outputFile);
                return cr;
            }
        }
        catch (Throwable e) {
            this.log.addLog(Utility.getStackTrace(e), LogPanel.INFO);
        }
        this.log.addLog("Compile failed: " + file, LogPanel.WARN);
        this.printError(UtilityFiles.lastError);
        this.printError(UtilityFiles.lastMessage);
        this.printError("\nCompile failed");
        return null;
    }

    public static String baseOnly(String file) {
        if (file.lastIndexOf(".") == -1) {
            return file;
        }
        String fileWithoutEnding = file.substring(0, file.lastIndexOf("."));
        return fileWithoutEnding;
    }

    public static String changeTypeTo(String file, String type) {
        return VediPanel.baseOnly(file) + "." + type;
    }

    static String nameOnly(String file) {
        if (!(file = VediPanel.convertSeperator(file)).contains(File.separator)) {
            return file;
        }
        if (file.endsWith(File.separator)) {
            return "";
        }
        return file.substring(file.lastIndexOf(File.separator) + 1);
    }

    boolean buildFinalAssiResult(ArrayList<CompileResult> compiles, boolean isProject) {
        String n = this.buildFinalAssiResultString(compiles, isProject);
        if (n == null) {
            return false;
        }
        String assiFile = VediPanel.changeTypeTo(compiles.get((int)0).inputFile, "asm");
        if (this.currentProject != null) {
            assiFile = Utility.makeVideAbsolute(this.currentProject.projectPrefix + File.separator + this.currentProject.getProjectName() + ".asm");
        }
        UtilityFiles.createTextFile(assiFile, n);
        if (!isProject) {
            this.startTypeRun = 2;
            this.asmStarted = false;
            this.startASM(assiFile);
        }
        return true;
    }

    String buildFinalAssiResultString(ArrayList<CompileResult> compiles, boolean isProject) {
        Set entries;
        if (compiles.size() == 0) {
            return null;
        }
        HashMap<String, String> libCCalls = new HashMap<String, String>();
        Path include2 = Paths.get(Global.mainPathPrefix, "template", "VECTREX.I");
        UtilityFiles.copyOneFile(include2.toString(), compiles.get((int)0).pathOnly + "VECTREX.I");
        StringBuilder assiSource = new StringBuilder();
        assiSource.append(" include \"VECTREX.I\"").append("\n");
        boolean initializedDataFound = false;
        for (CompileResult compile : compiles) {
            if (compile.initializedDataFound) {
                initializedDataFound = true;
            }
            entries = compile.libCCalls.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                String key = entry.getKey();
                String lib = entry.getValue();
                libCCalls.put(key, lib);
            }
        }
        assiSource.append("; Vectrex RAM section").append("\n");
        assiSource.append(" bss").append("\n");
        assiSource.append(" org 0xc880").append("\n");
        if (initializedDataFound) {
            assiSource.append("RAM_to_initialize_start:").append("\n");
        }
        for (CompileResult compile : compiles) {
            assiSource.append(compile.bssInitData);
        }
        if (initializedDataFound) {
            assiSource.append("RAM_to_initialize_end:").append("\n");
        }
        assiSource.append("RAM_uninitialized:").append("\n");
        for (CompileResult compile : compiles) {
            assiSource.append(compile.bssData);
        }
        StringBuilder crt0 = new StringBuilder();
        crt0.append(this.getLibSource("crt0.s"));
        String crt0S = crt0.toString();
        if (this.currentProject != null) {
            crt0S = UtilityString.replace(crt0S, "VIDE-C", this.currentProject.getProjectName().toUpperCase());
        }
        assiSource.append(crt0S);
        if (initializedDataFound) {
            assiSource.append(" jsr initializeData_bss").append("\n");
        }
        assiSource.append(" jmp _main").append("\n");
        for (CompileResult compile : compiles) {
            assiSource.append(compile.codeData);
        }
        entries = libCCalls.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String lib = entry.getValue();
            assiSource.append(this.getLibSource(lib));
        }
        if (initializedDataFound) {
            assiSource.append(this.getLibSource("initbss.s"));
            assiSource.append("data_to_initialize_bss:").append("\n");
            for (CompileResult compile : compiles) {
                assiSource.append(compile.dataData);
            }
        }
        String string = VediPanel.prettyPrint(assiSource.toString());
        return string;
    }

    String getLibSource(String lib) {
        String fullPath = Global.mainPathPrefix + "C" + File.separator + "lib" + File.separator + lib;
        return UtilityString.readTextFileToOneString(new File(fullPath));
    }

    static int getDBLen(String input) {
        if (!input.contains("db")) {
            return 0;
        }
        if (!input.contains("\"")) {
            return 1;
        }
        String[] split = input.split("\"");
        split = VediPanel.removeEmpty(split);
        return 1;
    }

    public static String[] removeEmpty(String[] split) {
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < split.length; ++i) {
            if (split[i] == null || split[i].length() == 0) continue;
            l.add(split[i]);
        }
        return l.toArray(new String[0]);
    }

    static String doVarMapping(HashMap<String, String> map, String line, String append) {
        return line;
    }

    static String checkRAMLocations(String sLine) {
        if (sLine.startsWith(";")) {
            return sLine;
        }
        String wl = UtilityString.replace(sLine, "#", "");
        wl = UtilityString.replace(wl, "<", "");
        wl = UtilityString.replace(wl, "<<", "");
        wl = UtilityString.replace(wl, ">", "");
        String[] parts = wl.trim().split(" ");
        parts = VediPanel.removeEmpty(parts);
        for (int i = 0; i < parts.length; ++i) {
            int v = 0;
            try {
                v = DASM6809.toNumber(parts[i]);
                if (v >= 51200 && v < 52224 || v >= 53248 && v <= 53263) {
                    String label = DASM6809.getBIOSLabel(v);
                    if (label == null) continue;
                    return UtilityString.replace(sLine, parts[i], label);
                }
                if (v <= 256 || v >= 65408) continue;
                return UtilityString.replace(sLine, parts[i], "0x" + String.format("%04X", v & 0xFFFF));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sLine;
    }

    void doBuildCProject() {
        String preClass = this.currentProject.getProjectPreScriptClass();
        String preName = this.currentProject.getProjectPreScriptName();
        String p = this.currentProject.projectPrefix + File.separator;
        ExecutionDescriptor ed = new ExecutionDescriptor(ExecutionDescriptor.ED_TYPE_PROJECT_PRE, this.currentProject.getProjectName(), "", "VediPanel", p);
        boolean ok = ScriptDataPanel.executeScript(preClass, preName, this, ed);
        if (!ok) {
            return;
        }
        this.clearASMOutput();
        this.startBuildCProject();
    }

    String[] buildCFLAGS() {
        if (this.currentProject == null) {
            return new String[0];
        }
        String[] splits = this.currentProject.getCFLAGS().split(" ");
        splits = VediPanel.removeEmpty(splits);
        for (int i = 0; i < splits.length; ++i) {
            if (!splits[i].startsWith("-I")) continue;
            String dir = splits[i].substring(2);
            dir = "-I" + Global.mainPathPrefix + dir;
            splits[i] = UtilityFiles.convertSeperator(dir);
        }
        String[] cflags = new String[splits.length + 4];
        for (int i = 0; i < splits.length; ++i) {
            cflags[i + 1] = splits[i];
        }
        cflags[cflags.length - 2] = "-o";
        return cflags;
    }

    public void startBuildCProject() {
        if (this.asmStarted) {
            return;
        }
        this.asmStarted = true;
        this.jButtonAssemble.setEnabled(false);
        this.jButtonDebug.setEnabled(false);
        if (this.one != null) {
            return;
        }
        final String[] CFLAGS = this.buildCFLAGS();
        this.log.addLog("GCC: " + CFLAGS);
        this.one = new Thread(){

            @Override
            public void run() {
                ArrayList<CompileResult> crs = new ArrayList<CompileResult>();
                boolean asmOk = true;
                try {
                    File[] fList;
                    String path = VediPanel.this.currentProject.projectPrefix;
                    final String failure = VediPanel.this.executeFileScripts("Pre", path);
                    if (failure != null && !asmOk) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                VediPanel.this.printError("Error execute pre build script for: " + failure);
                                VediPanel.this.buildCProjectResult(false, true);
                            }
                        });
                        VediPanel.this.one = null;
                        VediPanel.this.jButtonAssemble.setEnabled(true);
                        VediPanel.this.jButtonDebug.setEnabled(true);
                        VediPanel.this.asmStarted = false;
                        return;
                    }
                    File directory = new File(path);
                    for (File file : fList = directory.listFiles()) {
                        File test;
                        String fileNameOnly = file.getName();
                        if (!fileNameOnly.toLowerCase().endsWith(".c")) continue;
                        String fileNameBare = fileNameOnly;
                        int li = fileNameOnly.lastIndexOf(".");
                        if (li >= 0) {
                            fileNameBare = fileNameOnly.substring(0, li);
                        }
                        if (path.length() != 0) {
                            path = path + File.separator;
                        }
                        if ((test = new File(path + fileNameBare + "FileProperty.xml")).exists()) {
                            FilePropertiesPool pool;
                            FileProperties fileProperties;
                            String relPathOnly;
                            String pathOnly = test.getParent().toString();
                            if (pathOnly.length() != 0) {
                                pathOnly = pathOnly + File.separator;
                            }
                            if ((relPathOnly = Utility.makeVideRelative(pathOnly)).length() != 0) {
                                relPathOnly = relPathOnly + File.separator;
                            }
                            if ((fileProperties = (pool = new FilePropertiesPool(relPathOnly, test.getName())).get(fileNameOnly)) != null && fileProperties.getNoInternalProcessing()) continue;
                        }
                        CFLAGS[CFLAGS.length - 3] = file.getAbsolutePath();
                        CFLAGS[CFLAGS.length - 1] = VediPanel.changeTypeTo(file.getAbsolutePath(), "s");
                        CompileResult compiled = VediPanel.this.doCCompiler(CFLAGS);
                        if (compiled != null) {
                            crs.add(compiled);
                            continue;
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                VediPanel.this.printError("Error compiling: " + CFLAGS[CFLAGS.length - 3]);
                                VediPanel.this.buildCProjectResult(false, true);
                            }
                        });
                        VediPanel.this.one = null;
                        VediPanel.this.jButtonAssemble.setEnabled(true);
                        VediPanel.this.jButtonDebug.setEnabled(true);
                        VediPanel.this.asmStarted = false;
                        return;
                    }
                    final String failure2 = VediPanel.this.executeFileScripts("Post", path);
                    if (failure2 != null && !asmOk) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                VediPanel.this.printError("Error execute post build script for: " + failure2);
                                VediPanel.this.buildCProjectResult(false, true);
                            }
                        });
                        VediPanel.this.one = null;
                        VediPanel.this.jButtonAssemble.setEnabled(true);
                        VediPanel.this.jButtonDebug.setEnabled(true);
                        VediPanel.this.asmStarted = false;
                        return;
                    }
                }
                catch (Throwable e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            VediPanel.this.printASMMessage("Exception while building: " + e.getMessage(), 1);
                            VediPanel.this.printASMMessage(Utility.getStackTrace(e), 1);
                            VediPanel.this.buildCProjectResult(false, true);
                        }
                    });
                    VediPanel.this.one = null;
                    VediPanel.this.jButtonAssemble.setEnabled(true);
                    VediPanel.this.jButtonDebug.setEnabled(true);
                    VediPanel.this.asmStarted = false;
                    return;
                }
                String postClass = VediPanel.this.currentProject.getProjectPostScriptClass();
                String postName = VediPanel.this.currentProject.getProjectPostScriptName();
                String pp = VediPanel.this.currentProject.projectPrefix;
                ExecutionDescriptor ed = new ExecutionDescriptor(ExecutionDescriptor.ED_TYPE_PROJECT_POST, VediPanel.this.currentProject.getProjectName(), "", "VediPanel", pp);
                boolean ok = ScriptDataPanel.executeScript(postClass, postName, VediPanel.this, ed);
                boolean asmOk2 = asmOk;
                if (!ok) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            VediPanel.this.buildCProjectResult(false, true);
                        }
                    });
                    VediPanel.this.one = null;
                    VediPanel.this.jButtonAssemble.setEnabled(true);
                    VediPanel.this.jButtonDebug.setEnabled(true);
                    VediPanel.this.asmStarted = false;
                } else {
                    asmOk = VediPanel.this.buildFinalAssiResult(crs, true);
                    if (asmOk) {
                        String assiFile = Utility.makeVideAbsolute(VediPanel.this.currentProject.projectPrefix + File.separator + VediPanel.this.currentProject.getProjectName() + ".asm");
                        VediPanel.this.printMessage("Assembling: " + assiFile);
                        Asmj asm = new Asmj(assiFile, VediPanel.this.asmErrorOut, null, null, VediPanel.this.asmMessagesOut, "", VediPanel.this.settings.allDebugComments);
                        VediPanel.this.printASMList(asm.getListing(), 2);
                        String info = asm.getInfo();
                        boolean bl = asmOk = info.indexOf("0 errors detected.") >= 0;
                    }
                    if (asmOk) {
                        // empty if block
                    }
                    final boolean asmOk3 = asmOk;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            VediPanel.this.buildCProjectResult(asmOk3, false);
                        }
                    });
                    VediPanel.this.one = null;
                    VediPanel.this.asmStarted = false;
                    VediPanel.this.jButtonAssemble.setEnabled(true);
                    VediPanel.this.jButtonDebug.setEnabled(true);
                }
            }
        };
        this.one.setName("C-Build: " + this.currentProject.getProjectName());
        this.one.start();
    }

    protected void buildCProjectResult(boolean buildOk, boolean errorPreAssembler) {
        this.refreshTree();
        if (buildOk) {
            VecXPanel vec = ((CSAMainFrame)this.mParent).getVecxy();
            ((CSAMainFrame)this.mParent).getInternalFrame(vec).toFront();
            CartridgeProperties cartProp = this.buildCart(this.currentProject, false);
            if (this.config.invokeEmulatorAfterAssembly) {
                this.checkVec4EverProject(cartProp);
                boolean ask = false;
                if (this.startTypeRun == 3) {
                    CartridgeProperties oldProp = vec.getCurrentCartProp();
                    if (oldProp == null) {
                        ask = true;
                    } else {
                        String myName = this.currentProject.getProjectName();
                        String oldName = oldProp.getCartName();
                        if (!oldName.equals(myName)) {
                            ask = true;
                        }
                    }
                }
                boolean doit = true;
                if (ask) {
                    int answer = JOptionPane.showOptionDialog(Configuration.getConfiguration().getMainFrame(), "The bin files appear to be not compatible, inject anyway?", "File not compatible", 2, 2, null, null, null);
                    doit = answer == 0;
                }
                if (doit) {
                    vec.startCartridge(cartProp, this.startTypeRun);
                    this.printMessage("Assembly successful, starting emulation...");
                }
            } else {
                this.printMessage("Assembly successful...");
            }
            if (this.config.invokeVecMultiAfterAssembly) {
                this.loadVecMulti(cartProp);
            }
        } else {
            this.printError("Assembly not successful, see ASM output...");
            if (errorPreAssembler) {
                this.jTabbedPane.setSelectedIndex(0);
            } else {
                this.jTabbedPane.setSelectedIndex(1);
            }
        }
        this.refreshTree();
    }

    CompileResult doAssiConform(String cFile, String gccSFile) {
        CompileResult result = new CompileResult();
        result.inputFile = cFile;
        result.intermediateFile = gccSFile;
        Path p = Paths.get(cFile, new String[0]);
        result.pathOnly = p.getParent().toString();
        if (result.pathOnly.length() > 0) {
            result.pathOnly = result.pathOnly + File.separator;
        }
        result.nameOnly = VediPanel.baseOnly(UtilityString.replace(cFile, result.pathOnly, ""));
        Vector<String> orgLines = UtilityString.readTextFileToString(new File(cFile));
        Vector<String> sLines = UtilityString.readTextFileToString(new File(gccSFile));
        return VediPanel.doAssiConform(orgLines, sLines, result);
    }

    static CompileResult doAssiConform(Vector<String> orgLines, Vector<String> sLines, CompileResult r) {
        String sLine;
        int i;
        CompileResult result = r;
        if (result == null) {
            result = new CompileResult();
        }
        String cFile = "something, that does not occur in C Source";
        if (r != null) {
            cFile = r.inputFile;
        }
        StringBuilder codeSource = new StringBuilder();
        StringBuilder dataSource = new StringBuilder();
        StringBuilder bssSource = new StringBuilder();
        StringBuilder bssInitSource = new StringBuilder();
        boolean in_Code = false;
        boolean in_Data = false;
        boolean in_BSS = false;
        for (i = 0; i < sLines.size(); ++i) {
            sLine = sLines.elementAt(i);
            if (!sLine.contains(".area .data")) continue;
            result.initializedDataFound = true;
            break;
        }
        for (i = 0; i < sLines.size(); ++i) {
            String orgJSR;
            int biosAddress;
            String name;
            int pos;
            sLine = sLines.elementAt(i);
            String[] splits = sLine.split(" ");
            boolean doLine = true;
            if (sLine.contains(".area .text")) {
                in_Code = true;
                in_Data = false;
                in_BSS = false;
                doLine = false;
            }
            if (sLine.contains(".area .data")) {
                in_Code = false;
                in_Data = true;
                in_BSS = false;
                doLine = false;
            }
            if (sLine.contains(".area .bss")) {
                in_Code = false;
                in_Data = false;
                in_BSS = true;
                doLine = false;
            }
            if ((sLine = UtilityString.replace(sLine, "\t", "        ")).contains(cFile)) {
                int line = UtilityString.Int0(splits[2]);
                if (in_Code) {
                    codeSource.append("; ").append(orgLines.elementAt(line - 1)).append("\n");
                }
                if (in_Data) {
                    dataSource.append("; ").append(orgLines.elementAt(line - 1)).append("\n");
                }
                if (in_BSS) {
                    bssSource.append("; ").append(orgLines.elementAt(line - 1)).append("\n");
                }
            }
            if ((pos = sLine.indexOf("jsr 0xF")) > 0 && (name = DASM6809.getBIOSFunction(biosAddress = DASM6809.toNumber((orgJSR = sLine.substring(pos, pos + 10)).substring(4)))) != null) {
                sLine = UtilityString.replace(sLine, orgJSR, "jsr " + name);
            }
            sLine = UtilityString.replace(sLine, ".byte", "db");
            sLine = UtilityString.replace(sLine, ".word", "dw");
            if ((sLine = UtilityString.replace(sLine, ".blkb", "ds")).contains(".ascii")) {
                sLine = UtilityString.replace(sLine, "\\0\"", "\", $80");
            }
            if ((sLine = UtilityString.replace(sLine, ".ascii", "db")).contains(".globl")) {
                doLine = false;
            }
            if (sLine.contains(";----- asm")) {
                doLine = false;
            }
            if (sLine.contains(";--- end asm")) {
                doLine = false;
            }
            if (sLine.contains(".module")) {
                doLine = false;
            }
            if (sLine.contains(";;; ")) {
                doLine = false;
            }
            if (!doLine) continue;
            if (in_Data) {
                if (sLine.contains("db")) {
                    bssInitSource.append(" ds " + VediPanel.getDBLen(sLine) + "\n");
                } else if (sLine.contains("dw")) {
                    bssInitSource.append(" ds 2\n");
                }
                if (sLine.contains("_") && sLine.contains(":")) {
                    bssInitSource.append(VediPanel.doVarMapping(result.varMapping, sLine, result.nameOnly)).append("\n");
                    doLine = false;
                }
                if (doLine) {
                    dataSource.append(VediPanel.doVarMapping(result.varMapping, sLine, result.nameOnly)).append("\n");
                }
            }
            if (in_BSS) {
                bssSource.append(VediPanel.doVarMapping(result.varMapping, sLine, result.nameOnly)).append("\n");
            }
            if (!in_Code) continue;
            if (sLine.contains("_ashlhi3")) {
                result.libCCalls.put("_ashlhi3", "ashlhi3.s");
            }
            if (sLine.contains("_ashrhi3")) {
                result.libCCalls.put("_ashrhi3", "ashrhi3.s");
            }
            if (sLine.contains("_lshrhi3")) {
                result.libCCalls.put("_lshrhi3", "lshrhi3.s");
            }
            if (sLine.contains("_ashlsi3_one")) {
                result.libCCalls.put("_ashlsi3_one", "ashlsi3_one.s");
            }
            if (sLine.contains("_ashrsi3_one")) {
                result.libCCalls.put("_ashrsi3_one", "ashrsi3_one.s");
            }
            if (sLine.contains("_lshrsi3_one")) {
                result.libCCalls.put("_lshrsi3_one", "lshrsi3_one.s");
            }
            if (sLine.contains("_mulhi3")) {
                result.libCCalls.put("_mulhi3", "mulhi3.s");
            }
            if (sLine.contains("_divhi3")) {
                result.libCCalls.put("divAndMod", "divAndMod.s");
            }
            if (sLine.contains("_udivhi3")) {
                result.libCCalls.put("divAndMod", "divAndMod.s");
            }
            if (sLine.contains("_modhi3")) {
                result.libCCalls.put("divAndMod", "divAndMod.s");
            }
            if (sLine.contains("_umodhi3")) {
                result.libCCalls.put("divAndMod", "divAndMod.s");
            }
            sLine = VediPanel.checkRAMLocations(sLine);
            codeSource.append(VediPanel.doVarMapping(result.varMapping, sLine, result.nameOnly)).append("\n");
        }
        result.bssInitData = bssInitSource.toString();
        result.bssData = bssSource.toString();
        result.codeData = codeSource.toString();
        result.dataData = dataSource.toString();
        return result;
    }

    void doCreatePeerCProject(ProjectProperties project) {
        String projectDirPath = Utility.makeVideAbsolute(project.projectPrefix + File.separator);
        if (!project.getBankswitching().contains("2 bank standard")) {
            UtilityFiles.copyDirectoryAllFiles(Global.mainPathPrefix + "template" + File.separator + "PeerC", projectDirPath);
            UtilityFiles.rename(projectDirPath + "overlay" + File.separator + "c_project.png", project.getProjectName() + ".png");
            UtilityFiles.rename(projectDirPath + "overlay" + File.separator + "c_project.pptx", project.getProjectName() + ".pptx");
            UtilityFiles.rename(projectDirPath + "manual" + File.separator + "c_project.pdf", project.getProjectName() + ".pdf");
            UtilityFiles.rename(projectDirPath + "manual" + File.separator + "c_project.pptx", project.getProjectName() + ".pptx");
        } else {
            UtilityFiles.copyDirectoryAllFiles(Global.mainPathPrefix + "template" + File.separator + "PeerC.2banks", projectDirPath);
            UtilityFiles.rename(projectDirPath + "overlay" + File.separator + "c_project.png", project.getProjectName() + ".png");
            UtilityFiles.rename(projectDirPath + "overlay" + File.separator + "c_project.pptx", project.getProjectName() + ".pptx");
            UtilityFiles.rename(projectDirPath + "manual" + File.separator + "c_project.pdf", project.getProjectName() + ".pdf");
            UtilityFiles.rename(projectDirPath + "manual" + File.separator + "c_project.pptx", project.getProjectName() + ".pptx");
            project.getBankMainFiles().clear();
            project.getBankMainFiles().addElement(project.getProjectName());
            project.getBankMainFiles().addElement(project.getProjectName());
        }
        this.inProject = true;
        this.currentProject = project;
        this.fillTree(Paths.get(Utility.makeVideAbsolute(this.currentProject.projectPrefix), new String[0]));
        this.saveProject();
        this.settings.addProject(this.currentProject.getName(), this.currentProject.getCClass(), this.currentProject.projectPrefix);
        this.settings.setCurrentProject(this.currentProject.getName(), this.currentProject.getCClass(), this.currentProject.projectPrefix);
        this.updateList();
    }

    void doBuildPeerCProject() {
        if (this.startTypeRun == 4) {
            String fname = this.getSelectedEditor().getFilename();
            if (fname == null) {
                return;
            }
            if (fname.toLowerCase().endsWith(".c")) {
                this.doSinglePeerCFile(fname);
            }
            return;
        }
        String preClass = this.currentProject.getProjectPreScriptClass();
        String preName = this.currentProject.getProjectPreScriptName();
        boolean twice = this.currentProject.getBankswitching().contains("2 bank standard");
        if (!twice) {
            String p = this.currentProject.projectPrefix + File.separator + "source" + File.separator;
            ExecutionDescriptor ed = new ExecutionDescriptor(ExecutionDescriptor.ED_TYPE_PROJECT_PRE, this.currentProject.getProjectName(), "", "VediPanel", p);
            boolean ok = ScriptDataPanel.executeScript(preClass, preName, this, ed);
            if (!ok) {
                return;
            }
        } else {
            String p = this.currentProject.projectPrefix + File.separator + "source" + File.separator + "bank0" + File.separator;
            ExecutionDescriptor ed = new ExecutionDescriptor(ExecutionDescriptor.ED_TYPE_PROJECT_PRE, this.currentProject.getProjectName(), "", "VediPanel", p);
            boolean ok = ScriptDataPanel.executeScript(preClass, preName, this, ed);
            if (!ok) {
                return;
            }
            p = this.currentProject.projectPrefix + File.separator + "source" + File.separator + "bank1" + File.separator;
            ed = new ExecutionDescriptor(ExecutionDescriptor.ED_TYPE_PROJECT_PRE, this.currentProject.getProjectName(), "", "VediPanel", p);
            ok = ScriptDataPanel.executeScript(preClass, preName, this, ed);
            if (!ok) {
                return;
            }
        }
        this.clearASMOutput();
        this.startBuildPeerCProject();
    }

    public void startBuildPeerCProject() {
        if (this.asmStarted) {
            return;
        }
        this.asmStarted = true;
        this.jButtonAssemble.setEnabled(false);
        this.jButtonDebug.setEnabled(false);
        if (this.one != null) {
            return;
        }
        this.one = new Thread(){

            @Override
            public void run() {
                ArrayList crs = new ArrayList();
                boolean asmOk = true;
                boolean twice = VediPanel.this.currentProject.getBankswitching().contains("2 bank standard");
                for (int banks = 0; banks < 2; ++banks) {
                    try {
                        File[] fList;
                        String libPath;
                        String path;
                        String baseProjectPath = Utility.makeVideAbsolute(VediPanel.this.currentProject.projectPrefix);
                        VediPanel.this.peerClean(baseProjectPath, banks);
                        if (!twice) {
                            path = baseProjectPath + File.separator + "source";
                            libPath = baseProjectPath + File.separator + "build" + File.separator + "lib" + File.separator;
                        } else {
                            path = baseProjectPath + File.separator + "source" + File.separator + "bank" + banks;
                            libPath = baseProjectPath + File.separator + "build" + File.separator + "lib." + banks + File.separator;
                        }
                        File directory = new File(path);
                        for (File file : fList = directory.listFiles()) {
                            String fileNameOnly = file.getName();
                            if (!fileNameOnly.toLowerCase().endsWith(".s")) continue;
                            UtilityFiles.copyOneFile(file.getAbsolutePath(), libPath + fileNameOnly);
                        }
                        final String failure = VediPanel.this.executeFileScripts("Pre", path);
                        if (failure != null && !asmOk) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    VediPanel.this.printError("Error execute pre build script for: " + failure);
                                    VediPanel.this.buildPeerCProjectResult(false, true);
                                }
                            });
                            VediPanel.this.one = null;
                            VediPanel.this.jButtonAssemble.setEnabled(true);
                            VediPanel.this.jButtonDebug.setEnabled(true);
                            VediPanel.this.asmStarted = false;
                            return;
                        }
                        directory = new File(path);
                        fList = directory.listFiles();
                        VediPanel.this.scanForVersion(fList);
                        ArrayList<String> outNames = VediPanel.this.peerPreprocess(fList, baseProjectPath, banks);
                        if (outNames == null) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    VediPanel.this.buildPeerCProjectResult(false, true);
                                }
                            });
                            VediPanel.this.one = null;
                            VediPanel.this.jButtonAssemble.setEnabled(true);
                            VediPanel.this.jButtonDebug.setEnabled(true);
                            VediPanel.this.asmStarted = false;
                            return;
                        }
                        if (!VediPanel.this.peerCompile(fList, baseProjectPath, false, banks)) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    VediPanel.this.buildPeerCProjectResult(false, true);
                                }
                            });
                            VediPanel.this.one = null;
                            VediPanel.this.jButtonAssemble.setEnabled(true);
                            VediPanel.this.jButtonDebug.setEnabled(true);
                            VediPanel.this.asmStarted = false;
                            return;
                        }
                        if (VediPanel.this.currentProject.getIsCDebugging()) {
                            VediPanel.this.deleteAllCompileTargets(fList, baseProjectPath);
                            File[] fList2 = VediPanel.this.enrichCFiles(fList);
                            if (!VediPanel.this.peerCompile(fList2, baseProjectPath, true, banks)) {
                                VediPanel.this.deleteEnrichedCFiles(fList2);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        VediPanel.this.buildPeerCProjectResult(false, true);
                                    }
                                });
                                VediPanel.this.one = null;
                                VediPanel.this.jButtonAssemble.setEnabled(true);
                                VediPanel.this.jButtonDebug.setEnabled(true);
                                VediPanel.this.asmStarted = false;
                                return;
                            }
                            VediPanel.this.deleteEnrichedCFiles(fList2);
                        }
                        if (!VediPanel.this.peerAssemble(fList = (directory = new File(path = !twice ? baseProjectPath + File.separator + "build" + File.separator + "lib" : baseProjectPath + File.separator + "build" + File.separator + "lib." + banks)).listFiles(), baseProjectPath, banks)) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    VediPanel.this.buildPeerCProjectResult(false, true);
                                }
                            });
                            VediPanel.this.one = null;
                            VediPanel.this.jButtonAssemble.setEnabled(true);
                            VediPanel.this.jButtonDebug.setEnabled(true);
                            VediPanel.this.asmStarted = false;
                            return;
                        }
                        if (!VediPanel.this.peerLink(baseProjectPath, banks)) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    VediPanel.this.buildPeerCProjectResult(false, true);
                                }
                            });
                            VediPanel.this.one = null;
                            VediPanel.this.jButtonAssemble.setEnabled(true);
                            VediPanel.this.jButtonDebug.setEnabled(true);
                            VediPanel.this.asmStarted = false;
                            return;
                        }
                        if (!VediPanel.this.peerBuild(baseProjectPath, banks)) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    VediPanel.this.buildPeerCProjectResult(false, true);
                                }
                            });
                            VediPanel.this.one = null;
                            VediPanel.this.jButtonAssemble.setEnabled(true);
                            VediPanel.this.jButtonDebug.setEnabled(true);
                            VediPanel.this.asmStarted = false;
                            return;
                        }
                    }
                    catch (Throwable e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                VediPanel.this.printError("Exception while building: " + e.getMessage());
                                VediPanel.this.printError(Utility.getStackTrace(e));
                                VediPanel.this.buildPeerCProjectResult(false, true);
                            }
                        });
                        VediPanel.this.one = null;
                        VediPanel.this.jButtonAssemble.setEnabled(true);
                        VediPanel.this.jButtonDebug.setEnabled(true);
                        VediPanel.this.asmStarted = false;
                        return;
                    }
                    if (!twice) break;
                }
                String postClass = VediPanel.this.currentProject.getProjectPostScriptClass();
                String postName = VediPanel.this.currentProject.getProjectPostScriptName();
                String pp = VediPanel.this.currentProject.projectPrefix;
                ExecutionDescriptor ed = new ExecutionDescriptor(ExecutionDescriptor.ED_TYPE_PROJECT_POST, VediPanel.this.currentProject.getProjectName(), "", "VediPanel", pp);
                boolean ok = ScriptDataPanel.executeScript(postClass, postName, VediPanel.this, ed);
                boolean asmOk2 = asmOk;
                if (!ok) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            VediPanel.this.buildPeerCProjectResult(false, true);
                        }
                    });
                    VediPanel.this.one = null;
                    VediPanel.this.jButtonAssemble.setEnabled(true);
                    VediPanel.this.jButtonDebug.setEnabled(true);
                    VediPanel.this.asmStarted = false;
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            VediPanel.this.buildPeerCProjectResult(true, false);
                        }
                    });
                    VediPanel.this.one = null;
                    VediPanel.this.asmStarted = false;
                    VediPanel.this.jButtonAssemble.setEnabled(true);
                    VediPanel.this.jButtonDebug.setEnabled(true);
                }
            }
        };
        this.one.setName("C-Build: " + this.currentProject.getProjectName());
        this.one.start();
    }

    protected void buildPeerCProjectResult(boolean buildOk, boolean errorPreAssembler) {
        this.refreshTree();
        if (buildOk) {
            if (!this.buildPeerCCNT()) {
                return;
            }
            boolean twice = this.currentProject.getBankswitching().contains("2 bank standard");
            boolean is48K = (this.currentProject.getExtras() & Cartridge.FLAG_48K) != 0;
            boolean is44K = (this.currentProject.getExtras() & Cartridge.FLAG_44_PEER_BS) != 0;
            CartridgeProperties cartProp = this.buildCart(this.currentProject, twice);
            this.checkVec4EverProject(cartProp);
            if (this.config.invokeEmulatorAfterAssembly) {
                VecXPanel vec = ((CSAMainFrame)this.mParent).getVecxy();
                ((CSAMainFrame)this.mParent).getInternalFrame(vec).toFront();
                boolean ask = false;
                if (this.startTypeRun == 3) {
                    CartridgeProperties oldProp = vec.getCurrentCartProp();
                    if (oldProp == null) {
                        ask = true;
                    } else {
                        String myName = this.currentProject.getProjectName();
                        String oldName = oldProp.getCartName();
                        if (!oldName.equals(myName)) {
                            ask = true;
                        }
                    }
                }
                boolean doit = true;
                if (ask) {
                    int answer = JOptionPane.showOptionDialog(Configuration.getConfiguration().getMainFrame(), "The bin files appear to be not compatible, inject anyway?", "File not compatible", 2, 2, null, null, null);
                    doit = answer == 0;
                }
                if (doit) {
                    DebugInfoC cDebug = null;
                    vec.setNextStartCDebugInfo(cDebug);
                    vec.startCartridge(cartProp, this.startTypeRun);
                    this.printMessage("Compile successful, starting emulation...");
                }
            } else {
                this.printMessage("Compile successful...");
            }
            if (this.config.invokeVecMultiAfterAssembly) {
                this.loadVecMulti(cartProp);
            }
        }
        this.refreshTree();
    }

    String getVersionString() {
        if (this.currentProject == null) {
            return "NV";
        }
        String version2 = this.currentProject.getVersion();
        if (version2 != null && version2.trim().length() > 0) {
            if ((version2 = UtilityString.cleanStringSpaceDotOk(version2.toUpperCase().trim())).trim().length() == 0) {
                return "NV";
            }
            return version2;
        }
        return "NV";
    }

    String[] buildPeerCFLAGS(String additional, String additionalFileFlags) {
        int i;
        if (this.currentProject == null) {
            return new String[0];
        }
        String flags = this.currentProject.getCFLAGS();
        String version2 = this.getVersionString();
        if (version2 != null && version2.trim().length() > 0) {
            if (isWin) {
                flags = flags + " -DP_VERSION_80=\\\"" + version2 + "\\x80\\\" ";
                flags = flags + " -DP_VERSION_0=\\\"" + version2 + "\\\" ";
            } else {
                flags = flags + " -DP_VERSION_80=\"" + version2 + "\\x80\" ";
                flags = flags + " -DP_VERSION_0=\"" + version2 + "\" ";
            }
        }
        boolean hasFramePointer = true;
        if (flags.contains("-fomit-frame-pointer")) {
            hasFramePointer = false;
        }
        if (flags.contains("-fno-omit-frame-pointer")) {
            hasFramePointer = true;
        }
        String[] splitsFile = additionalFileFlags.split(" ");
        splitsFile = VediPanel.removeEmpty(splitsFile);
        String[] splits = flags.split(" ");
        splits = VediPanel.removeEmpty(splits);
        String[] splits2 = additional.split(" ");
        splits2 = VediPanel.removeEmpty(splits2);
        for (int i2 = 0; i2 < splits.length; ++i2) {
            if (!splits[i2].startsWith("-I")) continue;
            String dir = splits[i2].substring(2);
            dir = "-I" + Global.mainPathPrefix + dir;
            splits[i2] = UtilityFiles.convertSeperator(dir);
        }
        File directory = new File(Utility.makeVideAbsolute(this.currentProject.projectPrefix + File.separator + "include"));
        String additionalInclude = "";
        int additionalFlags = 5;
        ++additionalFlags;
        if (directory.exists()) {
            additionalInclude = "-I" + directory.getAbsolutePath();
            ++additionalFlags;
        }
        String[] cflags = new String[splits.length + splits2.length + additionalFlags + splitsFile.length];
        int flagBase = 1;
        for (i = 0; i < splits.length; ++i) {
            cflags[flagBase++] = splits[i];
        }
        for (i = 0; i < splits2.length; ++i) {
            cflags[flagBase++] = splits2[i];
        }
        for (i = 0; i < splitsFile.length; ++i) {
            cflags[flagBase++] = splitsFile[i];
        }
        if (additionalInclude.length() != 0) {
            cflags[cflags.length - 4] = additionalInclude;
            cflags[cflags.length - 5] = !hasFramePointer ? "-DOMMIT_FRAMEPOINTER=1" : "-DFRAME_POINTER=1";
            cflags[cflags.length - 6] = this.currentProject.getIsCRumInlined() ? "-D__INLINE_RUM=1" : "-D__RUM_FUNCTION=1";
        } else {
            cflags[cflags.length - 4] = !hasFramePointer ? "-DOMMIT_FRAMEPOINTER=1" : "-DFRAME_POINTER=1";
            cflags[cflags.length - 5] = this.currentProject.getIsCRumInlined() ? "-D__INLINE_RUM=1" : "-D__RUM_FUNCTION=1";
        }
        cflags[cflags.length - 2] = "-o";
        return cflags;
    }

    ArrayList<String> peerPreprocess(File[] fList, String baseProjectPath, int banks) {
        ArrayList<String> outNames = new ArrayList<String>();
        boolean twice = this.currentProject.getBankswitching().contains("2 bank standard");
        String path = Utility.makeVideAbsolute(baseProjectPath + File.separator + "source");
        if (twice) {
            path = path + File.separator + "bank" + banks;
        }
        final String[] CFLAGS = this.buildPeerCFLAGS("-E", "");
        for (File file : fList) {
            File test;
            String fileNameOnly = file.getName();
            if (file.isDirectory()) {
                File directory = new File(file.getAbsoluteFile().toString());
                File[] fList2 = directory.listFiles();
                ArrayList<String> outNames2 = this.peerPreprocess(fList2, baseProjectPath, banks);
                if (null == outNames2) {
                    return null;
                }
                for (String on : outNames2) {
                    outNames.add(on);
                }
                continue;
            }
            if (!fileNameOnly.toLowerCase().endsWith(".c")) continue;
            String fileNameBare = fileNameOnly = UtilityString.replace(fileNameOnly, ".enr.", ".");
            int li = fileNameOnly.lastIndexOf(".");
            if (li >= 0) {
                fileNameBare = fileNameOnly.substring(0, li);
            }
            if (path.length() != 0) {
                path = path + File.separator;
            }
            if ((test = new File(path + fileNameBare + "FileProperty.xml")).exists()) {
                FilePropertiesPool pool;
                FileProperties fileProperties;
                String relPathOnly;
                String pathOnly = test.getParent().toString();
                if (pathOnly.length() != 0) {
                    pathOnly = pathOnly + File.separator;
                }
                if ((relPathOnly = Utility.makeVideRelative(pathOnly)).length() != 0) {
                    relPathOnly = relPathOnly + File.separator;
                }
                if ((fileProperties = (pool = new FilePropertiesPool(relPathOnly, test.getName())).get(fileNameOnly)) != null && fileProperties.getNoInternalProcessing()) continue;
            }
            CFLAGS[CFLAGS.length - 3] = file.getAbsolutePath();
            CFLAGS[CFLAGS.length - 1] = !twice ? baseProjectPath + File.separator + "build" + File.separator + "lib" + File.separator + fileNameBare + ".i" : baseProjectPath + File.separator + "build" + File.separator + "lib." + banks + File.separator + fileNameBare + ".i";
            outNames.add(CFLAGS[CFLAGS.length - 1]);
            if (this.doPeerCCompiler(CFLAGS, "Preprocessing", false)) continue;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VediPanel.this.printError("Error preprocessing: " + CFLAGS[CFLAGS.length - 3]);
                    VediPanel.this.buildPeerCProjectResult(false, true);
                }
            });
            this.one = null;
            this.jButtonAssemble.setEnabled(true);
            this.jButtonDebug.setEnabled(true);
            this.asmStarted = false;
            return null;
        }
        return outNames;
    }

    boolean peerCompile(File[] fList, String baseProjectPath, boolean quiet, int banks) {
        boolean twice = this.currentProject.getBankswitching().contains("2 bank standard");
        String path = baseProjectPath + File.separator + "source";
        if (twice) {
            path = path + File.separator + "bank" + banks;
        }
        for (File file : fList) {
            String fileNameOnly = file.getName();
            if (file.isDirectory()) {
                File directory = new File(file.getAbsoluteFile().toString());
                File[] fList2 = directory.listFiles();
                if (this.peerCompile(fList2, baseProjectPath, quiet, banks)) continue;
                return false;
            }
            if (!fileNameOnly.toLowerCase().endsWith(".c")) continue;
            String fileNameBare = fileNameOnly = UtilityString.replace(fileNameOnly, ".enr.", ".");
            int li = fileNameOnly.lastIndexOf(".");
            if (li >= 0) {
                fileNameBare = fileNameOnly.substring(0, li);
            }
            if (path.length() != 0) {
                path = path + File.separator;
            }
            File test = new File(path + fileNameBare + "FileProperty.xml");
            String fileCFLAGS = "";
            if (test.exists()) {
                FilePropertiesPool pool;
                FileProperties fileProperties;
                String relPathOnly;
                String pathOnly = test.getParent().toString();
                if (pathOnly.length() != 0) {
                    pathOnly = pathOnly + File.separator;
                }
                if ((relPathOnly = Utility.makeVideRelative(pathOnly)).length() != 0) {
                    relPathOnly = relPathOnly + File.separator;
                }
                if ((fileProperties = (pool = new FilePropertiesPool(relPathOnly, test.getName())).get(fileNameOnly)) != null) {
                    if (fileProperties.getNoInternalProcessing()) continue;
                    fileCFLAGS = fileProperties.getFlags().trim();
                }
            }
            final String[] CFLAGS = this.buildPeerCFLAGS("", fileCFLAGS);
            CFLAGS[CFLAGS.length - 3] = file.getAbsolutePath();
            CFLAGS[CFLAGS.length - 1] = !twice ? baseProjectPath + File.separator + "build" + File.separator + "lib" + File.separator + fileNameBare + ".s" : baseProjectPath + File.separator + "build" + File.separator + "lib." + banks + File.separator + fileNameBare + ".s";
            if (!this.doPeerCCompiler(CFLAGS, "Compiling", quiet)) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VediPanel.this.printError("Error compiling: " + CFLAGS[CFLAGS.length - 3]);
                        VediPanel.this.buildPeerCProjectResult(false, true);
                    }
                });
                this.one = null;
                this.jButtonAssemble.setEnabled(true);
                this.jButtonDebug.setEnabled(true);
                this.asmStarted = false;
                return false;
            }
            if (!this.peepAtASM || !this.currentProject.getIsCPeephole()) continue;
            FilePeeper.peepCorrectASM(CFLAGS[CFLAGS.length - 1]);
        }
        return true;
    }

    void deleteAllCompileTargets(File[] fList, String baseProjectPath) {
        for (File file : fList) {
            String fileNameOnly = file.getName();
            if (file.isDirectory()) {
                File directory = new File(file.getAbsoluteFile().toString());
                File[] fList2 = directory.listFiles();
                this.deleteAllCompileTargets(fList2, baseProjectPath);
            }
            if (!fileNameOnly.toLowerCase().endsWith(".c")) continue;
            String fileNameBare = fileNameOnly;
            int li = fileNameOnly.lastIndexOf(".");
            if (li >= 0) {
                fileNameBare = fileNameOnly.substring(0, li);
            }
            String targetName = baseProjectPath + File.separator + "build" + File.separator + "lib" + File.separator + fileNameBare + ".s";
            UtilityFiles.deleteFile(targetName);
        }
    }

    public boolean doPeerCCompiler(String[] flags, String stageMessage, boolean quiet) {
        String[] envs = null;
        if (isMac) {
            flags[0] = Global.mainPathPrefix + "C" + File.separator + "Mac" + File.separator + "bin" + File.separator + "cc1";
        }
        if (isWin) {
            flags[0] = Global.getOSBit() == 64 ? Global.mainPathPrefix + "C" + File.separator + "Win32" + File.separator + "bin" + File.separator + "gcc6809.exe" : Global.mainPathPrefix + "C" + File.separator + "Win32" + File.separator + "bin" + File.separator + "gcc6809.exe";
        }
        if (isLinux) {
            flags[0] = Global.getOSBit() == 64 ? Global.mainPathPrefix + "C" + File.separator + "Linux64" + File.separator + "bin" + File.separator + "cc1" : Global.mainPathPrefix + "C" + File.separator + "Linux32" + File.separator + "bin" + File.separator + "cc1";
        }
        String flagsOut = "";
        for (int i = 0; i < flags.length; ++i) {
            flagsOut = flagsOut + flags[i] + " ";
        }
        this.log.addLog("GCC: " + flagsOut);
        String file = flags[flags.length - 3];
        String outputFile = flags[flags.length - 1];
        if (!quiet) {
            this.printNoLNMessage(stageMessage + ": " + this.truncateFilename(file));
        }
        try {
            this.log.addLog(stageMessage + ": " + file, LogPanel.INFO);
            for (int i = 0; i < flags.length; ++i) {
                this.log.addLog("SingleFlag Out: \"" + flags[i] + "\"", LogPanel.INFO);
            }
            boolean ok = UtilityFiles.executeOSCommand(flags, envs);
            boolean bl = ok = ok && !UtilityFiles.lastError.contains("error:");
            if (ok) {
                if (!quiet) {
                    this.printMessage(" ... success");
                    this.printWarning(this.truncateFilename(UtilityFiles.lastError.trim()));
                    this.printMessage(this.truncateFilename(UtilityFiles.lastMessage.trim()));
                }
                return true;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.log.addLog(stageMessage + " failed: " + file, LogPanel.WARN);
        this.printError(stageMessage + " failed");
        this.printError(UtilityFiles.lastError.trim());
        this.printError(UtilityFiles.lastMessage.trim());
        return false;
    }

    String[] buildPeerASMFLAGS(String additional) {
        int i;
        String[] splits = "-x -p -l -o -y -g".split(" ");
        splits = VediPanel.removeEmpty(splits);
        String[] splits2 = additional.split(" ");
        splits2 = VediPanel.removeEmpty(splits2);
        String[] asmflags = new String[splits.length + splits2.length + 3];
        int flagBase = 1;
        for (i = 0; i < splits.length; ++i) {
            asmflags[flagBase++] = splits[i];
        }
        for (i = 0; i < splits2.length; ++i) {
            asmflags[flagBase++] = splits2[i];
        }
        return asmflags;
    }

    boolean peerAssemble(File[] fList, String baseProjectPath, int banks) {
        boolean twice = this.currentProject.getBankswitching().contains("2 bank standard");
        String path = baseProjectPath + File.separator + "source";
        if (twice) {
            path = path + File.separator + "bank" + banks;
        }
        final String[] ASMFLAGS = this.buildPeerASMFLAGS("");
        for (File file : fList) {
            String fileNameOnly = file.getName();
            if (!fileNameOnly.toLowerCase().endsWith(".s")) continue;
            ASMFLAGS[ASMFLAGS.length - 2] = VediPanel.changeTypeTo(file.getAbsolutePath(), "rel");
            ASMFLAGS[ASMFLAGS.length - 1] = file.getAbsolutePath();
            if (this.doPeerAssemble(ASMFLAGS, "Assemble")) continue;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VediPanel.this.printError("Error assembling: " + ASMFLAGS[ASMFLAGS.length - 3]);
                    VediPanel.this.buildPeerCProjectResult(false, true);
                }
            });
            this.one = null;
            this.jButtonAssemble.setEnabled(true);
            this.jButtonDebug.setEnabled(true);
            this.asmStarted = false;
            return false;
        }
        return true;
    }

    public boolean doPeerAssemble(String[] flags, String stageMessage) {
        if (isMac) {
            flags[0] = Global.mainPathPrefix + "C" + File.separator + "Mac" + File.separator + "bin" + File.separator + "as6809";
        }
        if (isWin) {
            flags[0] = Global.mainPathPrefix + "C" + File.separator + "Win32" + File.separator + "bin" + File.separator + "as6809.exe";
        }
        if (isLinux) {
            flags[0] = Global.getOSBit() == 64 ? Global.mainPathPrefix + "C" + File.separator + "Linux64" + File.separator + "bin" + File.separator + "as6809" : Global.mainPathPrefix + "C" + File.separator + "Linux32" + File.separator + "bin" + File.separator + "as6809";
        }
        String file = flags[flags.length - 1];
        String outputFile = flags[flags.length - 2];
        String flagsOut = "";
        for (int i = 0; i < flags.length; ++i) {
            flagsOut = flagsOut + flags[i] + " ";
        }
        this.log.addLog("ASM: " + flagsOut);
        this.printNoLNMessage(stageMessage + ": " + this.truncateFilename(file));
        try {
            this.log.addLog(stageMessage + ": " + file, LogPanel.INFO);
            boolean ok = UtilityFiles.executeOSCommand(flags);
            String tt = UtilityFiles.lastError;
            boolean bl = ok = ok && !UtilityFiles.lastError.toLowerCase().contains("error");
            if (ok) {
                this.printMessage(" ... success");
                this.printWarning(this.truncateFilename(UtilityFiles.lastError.trim()));
                this.printMessage(this.truncateFilename(UtilityFiles.lastMessage.trim()));
                return true;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.log.addLog(stageMessage + " failed: " + file, LogPanel.WARN);
        this.printError(" ... failed");
        this.printError(UtilityFiles.lastError.trim());
        this.printError(UtilityFiles.lastMessage.trim());
        return false;
    }

    String[] buildPeerLINKFLAGS(String additional1, String[] additional3) {
        String fileNameOnly;
        if (this.currentProject == null) {
            return new String[0];
        }
        int extras = this.currentProject.getExtras();
        boolean is48K = (extras & Cartridge.FLAG_48K) != 0;
        boolean is44K = (extras & Cartridge.FLAG_44_PEER_BS) != 0;
        String path = Global.mainPathPrefix + "C" + File.separator + "PeerC" + File.separator + "vectrex" + File.separator + "lib";
        File directory = new File(path);
        File[] fList = directory.listFiles();
        ArrayList<String> additional2 = new ArrayList<String>();
        for (File file : fList) {
            fileNameOnly = file.getName();
            if (!fileNameOnly.toLowerCase().contains("crt0.rel")) continue;
            additional2.add(file.getAbsolutePath());
            break;
        }
        for (File file : fList) {
            fileNameOnly = file.getName();
            if (fileNameOnly.contains("crt0") || !fileNameOnly.toLowerCase().endsWith(".rel") || this.currentProject.getIsCRumInlined() && fileNameOnly.contains("vec_rum_fct_pjc.rel")) continue;
            additional2.add(file.getAbsolutePath());
        }
        String libPath = Global.mainPathPrefix + "C" + File.separator + "PeerC" + File.separator + "vectrex" + File.separator + "lib" + File.separator;
        ArrayList<String> allOptions = new ArrayList<String>();
        allOptions.add("-n");
        allOptions.add("-m");
        allOptions.add("-u");
        allOptions.add("-w");
        allOptions.add("-s");
        allOptions.add("-k");
        allOptions.add(libPath);
        allOptions.add("-l");
        allOptions.add("rum.lib");
        allOptions.add("-l");
        allOptions.add("libgcc.lib");
        allOptions.add("-l");
        allOptions.add("gcc.lib");
        allOptions.add("-l");
        allOptions.add("assert.lib");
        allOptions.add(additional1);
        for (String additional21 : additional2) {
            allOptions.add(additional21);
        }
        for (String additional31 : additional3) {
            allOptions.add(additional31);
        }
        String[] asmflags = new String[allOptions.size() + 1];
        int flagBase = 1;
        for (int i = 0; i < allOptions.size(); ++i) {
            asmflags[flagBase++] = (String)allOptions.get(i);
        }
        return asmflags;
    }

    boolean peerLink(String baseProjectPath, int banks) {
        String[] LINKFLAGS;
        String fileNameOnly;
        boolean twice = this.currentProject.getBankswitching().contains("2 bank standard");
        String path = baseProjectPath + File.separator + "build";
        path = baseProjectPath + File.separator + "build" + File.separator + "lib";
        if (twice) {
            path = path + "." + banks;
        }
        File directory = new File(path);
        File[] fList = directory.listFiles();
        ArrayList<String> files = new ArrayList<String>();
        for (File file : fList) {
            fileNameOnly = file.getName();
            if (!fileNameOnly.toLowerCase().endsWith(".rel")) continue;
            files.add(file.getAbsolutePath());
        }
        directory = new File(baseProjectPath + File.separator + "lib");
        if (directory.exists()) {
            for (File file : fList = directory.listFiles()) {
                fileNameOnly = file.getName();
                if (!fileNameOnly.toLowerCase().endsWith(".rel")) continue;
                files.add(file.getAbsolutePath());
            }
        }
        if ((directory = new File(Global.mainPathPrefix + "C" + File.separator + "PeerC" + File.separator + "vectrex" + File.separator + "lib" + File.separator + "static" + File.separator)).exists()) {
            for (File file : fList = directory.listFiles()) {
                fileNameOnly = file.getName();
                if (!fileNameOnly.toLowerCase().endsWith(".rel")) continue;
                files.add(file.getAbsolutePath());
            }
        }
        if (!this.doPeerLink(LINKFLAGS = !twice ? this.buildPeerLINKFLAGS(baseProjectPath + File.separator + "build" + File.separator + this.currentProject.getProjectName() + ".s19", files.toArray(new String[0])) : this.buildPeerLINKFLAGS(baseProjectPath + File.separator + "build" + File.separator + this.currentProject.getProjectName() + "_" + banks + ".s19", files.toArray(new String[0])), "Link")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VediPanel.this.printError("Error linking... ");
                    VediPanel.this.buildPeerCProjectResult(false, true);
                }
            });
            this.one = null;
            this.jButtonAssemble.setEnabled(true);
            this.jButtonDebug.setEnabled(true);
            this.asmStarted = false;
            return false;
        }
        return true;
    }

    public boolean doPeerLink(String[] flags, String stageMessage) {
        if (isMac) {
            flags[0] = Global.mainPathPrefix + "C" + File.separator + "Mac" + File.separator + "bin" + File.separator + "aslink";
        }
        if (isWin) {
            flags[0] = Global.mainPathPrefix + "C" + File.separator + "Win32" + File.separator + "bin" + File.separator + "aslink.exe";
        }
        if (isLinux) {
            flags[0] = Global.getOSBit() == 64 ? Global.mainPathPrefix + "C" + File.separator + "Linux64" + File.separator + "bin" + File.separator + "aslink" : Global.mainPathPrefix + "C" + File.separator + "Linux32" + File.separator + "bin" + File.separator + "aslink";
        }
        String outputFile = flags[flags.length - 2];
        String flagsOut = "";
        for (int i = 0; i < flags.length; ++i) {
            flagsOut = flagsOut + flags[i] + " ";
        }
        this.log.addLog("LINK: " + flagsOut);
        String to = "";
        String libs = "";
        String rels = "";
        for (int i = 0; i < flags.length; ++i) {
            if (flags[i].trim().endsWith(".a")) {
                if (libs.length() > 0) {
                    libs = libs + " ";
                }
                libs = libs + flags[i];
            }
            if (flags[i].trim().endsWith(".s19")) {
                if (to.length() > 0) {
                    to = to + " ";
                }
                to = to + flags[i];
            }
            if (!flags[i].trim().endsWith(".rel")) continue;
            if (rels.length() > 0) {
                rels = rels + " ";
            }
            rels = rels + flags[i];
        }
        String msg = libs + " " + rels + " to " + to;
        msg = this.truncateFilename(msg);
        this.printNoLNMessage(stageMessage + ": " + msg);
        try {
            this.log.addLog(stageMessage + " ...", LogPanel.INFO);
            boolean ok = UtilityFiles.executeOSCommand(flags);
            boolean explain = false;
            String errorMessage = UtilityFiles.lastError;
            if (errorMessage.contains("?ASlink-Warning-Undefined Global")) {
                ok = false;
            }
            if (errorMessage.contains("?ASlink-Warning-PageN relocation error")) {
                explain = true;
            }
            errorMessage = UtilityString.replace(errorMessage, "?ASlink-Warning-PageN relocation error", "?ASlink-Warning-PageN relocation WARNING!");
            ok = ok && !errorMessage.toLowerCase().contains("error");
            boolean bl = ok = ok && !UtilityFiles.lastMessage.toLowerCase().contains("error");
            if (ok) {
                this.printMessage(" ... success");
                this.printWarning(this.truncateFilename(UtilityFiles.lastError.trim()));
                this.printMessage(this.truncateFilename(UtilityFiles.lastMessage.trim()));
                if (explain) {
                    this.printMessage("The above warning happens if direct access is used to another page than the current.\nThis is frequently the case, when accessing VIA.");
                }
                return true;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.log.addLog(stageMessage + " failed ", LogPanel.WARN);
        this.printError(" ... failed");
        this.printError(UtilityFiles.lastError);
        this.printError(UtilityFiles.lastMessage);
        return false;
    }

    String[] buildPeerSREC(String options) {
        if (this.currentProject == null) {
            return new String[0];
        }
        String[] splits = options.split(" ");
        splits = VediPanel.removeEmpty(splits);
        String[] asmflags = new String[splits.length + 3];
        int flagBase = 1;
        for (int i = 0; i < splits.length; ++i) {
            asmflags[flagBase++] = splits[i];
        }
        return asmflags;
    }

    boolean peerBuild(String baseProjectPath, int banks) {
        boolean twice = this.currentProject.getBankswitching().contains("2 bank standard");
        String msg = "";
        String path = baseProjectPath + File.separator + "build";
        String romBase = "_rom";
        String ramBase = "_ram";
        String binBase = ".bin";
        if (twice) {
            romBase = "_" + banks + "_rom";
            ramBase = "_" + banks + "_ram";
            binBase = "_" + banks + ".bin";
        }
        String fromS19 = baseProjectPath + File.separator + "build" + File.separator + this.currentProject.getProjectName() + romBase + ".s19";
        String toBin = baseProjectPath + File.separator + "build" + File.separator + this.currentProject.getProjectName() + romBase + ".bin";
        msg = msg + "build" + File.separator + this.currentProject.getProjectName() + romBase + ".s19";
        msg = msg + "->";
        msg = msg + "build" + File.separator + this.currentProject.getProjectName() + romBase + ".bin";
        String[] SRECFLAGS = this.buildPeerSREC("-q");
        SRECFLAGS[SRECFLAGS.length - 2] = fromS19;
        SRECFLAGS[SRECFLAGS.length - 1] = toBin;
        boolean ok = true;
        ok = ok && this.doPeerBuild(SRECFLAGS, "SREC2BIN: " + msg);
        String fromS19ram = baseProjectPath + File.separator + "build" + File.separator + this.currentProject.getProjectName() + ramBase + ".s19";
        String toBinram = baseProjectPath + File.separator + "build" + File.separator + this.currentProject.getProjectName() + ramBase + ".bin";
        boolean ramExists = new File(fromS19ram).exists();
        if (ramExists) {
            msg = "build" + File.separator + this.currentProject.getProjectName() + ramBase + ".s19";
            msg = msg + "->";
            msg = msg + "build" + File.separator + this.currentProject.getProjectName() + ramBase + ".bin";
            SRECFLAGS = this.buildPeerSREC("-q -o -0xc880");
            SRECFLAGS[SRECFLAGS.length - 2] = fromS19ram;
            SRECFLAGS[SRECFLAGS.length - 1] = toBinram;
            ok = ok && this.doPeerBuild(SRECFLAGS, "SREC2BIN: " + msg);
            this.printMessage("Concatinate: build" + File.separator + this.currentProject.getProjectName() + romBase + ".bin + build" + File.separator + this.currentProject.getProjectName() + ramBase + ".bin to bin" + File.separator + this.currentProject.getProjectName() + binBase);
            ok = ok && UtilityFiles.concatFiles(toBin, toBinram, baseProjectPath + File.separator + "bin" + File.separator + this.currentProject.getProjectName() + binBase);
        } else {
            this.printMessage("copy: build" + File.separator + this.currentProject.getProjectName() + "_rom.bin to bin" + File.separator + this.currentProject.getProjectName() + binBase);
            boolean bl = ok = ok && UtilityFiles.copyOneFile(toBin, baseProjectPath + File.separator + "bin" + File.separator + this.currentProject.getProjectName() + binBase);
        }
        if (!ok) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VediPanel.this.printError("Error linking... ");
                    VediPanel.this.buildPeerCProjectResult(false, true);
                }
            });
            this.one = null;
            this.jButtonAssemble.setEnabled(true);
            this.jButtonDebug.setEnabled(true);
            this.asmStarted = false;
            return false;
        }
        return true;
    }

    public boolean doPeerBuild(String[] flags, String stageMessage) {
        if (isMac) {
            flags[0] = Global.mainPathPrefix + "C" + File.separator + "Mac" + File.separator + "bin" + File.separator + "srec2bin";
        }
        if (isWin) {
            flags[0] = Global.mainPathPrefix + "C" + File.separator + "Win32" + File.separator + "bin" + File.separator + "srec2bin.exe";
        }
        if (isLinux) {
            flags[0] = Global.getOSBit() == 64 ? Global.mainPathPrefix + "C" + File.separator + "Linux64" + File.separator + "bin" + File.separator + "srec2bin" : Global.mainPathPrefix + "C" + File.separator + "Linux32" + File.separator + "bin" + File.separator + "srec2bin";
        }
        String flagsOut = "";
        for (int i = 0; i < flags.length; ++i) {
            flagsOut = flagsOut + flags[i] + " ";
        }
        this.log.addLog("SREC: " + flagsOut);
        this.printNoLNMessage(stageMessage);
        try {
            this.log.addLog(stageMessage + " ", LogPanel.INFO);
            boolean ok = UtilityFiles.executeOSCommand(flags);
            ok = ok && !UtilityFiles.lastError.toLowerCase().contains("error");
            boolean bl = ok = ok && !UtilityFiles.lastMessage.toLowerCase().contains("error");
            if (ok) {
                this.printMessage(" ... success");
                this.printWarning(this.truncateFilename(UtilityFiles.lastError.trim()));
                this.printMessage(this.truncateFilename(UtilityFiles.lastMessage.trim()));
                return true;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.log.addLog(stageMessage + " failed ", LogPanel.WARN);
        this.printError(" ... failed");
        this.printError(UtilityFiles.lastError);
        this.printError(UtilityFiles.lastMessage);
        return false;
    }

    void peerClean(String baseProjectPath, int banks) {
        boolean twice = this.currentProject.getBankswitching().contains("2 bank standard");
        if (twice && banks == 0) {
            UtilityFiles.cleanDirectory(baseProjectPath + File.separator + "bin");
            UtilityFiles.cleanDirectory(baseProjectPath + File.separator + "build");
        }
        if (!twice) {
            File f = new File(baseProjectPath + File.separator + "build" + File.separator + "lib");
            f.mkdir();
        } else {
            File f = new File(baseProjectPath + File.separator + "build" + File.separator + "lib." + banks);
            f.mkdir();
        }
        this.printMessage("Cleaned...");
        this.log.addLog("Clean was run...");
    }

    void doSinglePeerCFile(final String fname) {
        if (this.asmStarted) {
            return;
        }
        this.asmStarted = true;
        this.jButtonAssemble.setEnabled(false);
        this.jButtonDebug.setEnabled(false);
        if (this.one != null) {
            return;
        }
        this.one = new Thread(){

            @Override
            public void run() {
                boolean asmOk = true;
                try {
                    String baseProjectPath = VediPanel.this.currentProject.projectPrefix;
                    VediPanel.this.peerClean(baseProjectPath, -1);
                    String path = Utility.makeVideAbsolute(baseProjectPath + File.separator + "source");
                    File[] fList = new File[]{new File(fname)};
                    ArrayList<String> res = VediPanel.this.peerPreprocess(fList, baseProjectPath, -1);
                    if (res == null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                VediPanel.this.buildPeerCProjectResult(false, true);
                            }
                        });
                        VediPanel.this.one = null;
                        VediPanel.this.jButtonAssemble.setEnabled(true);
                        VediPanel.this.jButtonDebug.setEnabled(true);
                        VediPanel.this.asmStarted = false;
                        VediPanel.this.refreshTree();
                        return;
                    }
                    if (!VediPanel.this.peerCompile(fList, baseProjectPath, false, -1)) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                VediPanel.this.buildPeerCProjectResult(false, true);
                            }
                        });
                        VediPanel.this.one = null;
                        VediPanel.this.jButtonAssemble.setEnabled(true);
                        VediPanel.this.jButtonDebug.setEnabled(true);
                        VediPanel.this.asmStarted = false;
                        VediPanel.this.refreshTree();
                        return;
                    }
                    path = baseProjectPath + File.separator + "build" + File.separator + "lib";
                    File directory = new File(path);
                    String sName = path + File.separator + VediPanel.changeTypeTo(VediPanel.nameOnly(fname), "s");
                    fList[0] = new File(sName);
                    if (!VediPanel.this.peerAssemble(fList, baseProjectPath, -1)) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                VediPanel.this.buildPeerCProjectResult(false, true);
                            }
                        });
                        VediPanel.this.one = null;
                        VediPanel.this.jButtonAssemble.setEnabled(true);
                        VediPanel.this.jButtonDebug.setEnabled(true);
                        VediPanel.this.asmStarted = false;
                        VediPanel.this.refreshTree();
                        return;
                    }
                }
                catch (Throwable e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            VediPanel.this.printError("Exception while building: " + e.getMessage());
                            VediPanel.this.printError(Utility.getStackTrace(e));
                            VediPanel.this.buildPeerCProjectResult(false, true);
                        }
                    });
                    VediPanel.this.one = null;
                    VediPanel.this.jButtonAssemble.setEnabled(true);
                    VediPanel.this.jButtonDebug.setEnabled(true);
                    VediPanel.this.asmStarted = false;
                    VediPanel.this.refreshTree();
                    return;
                }
                VediPanel.this.printMessage("Compile successful...");
                VediPanel.this.one = null;
                VediPanel.this.asmStarted = false;
                VediPanel.this.jButtonAssemble.setEnabled(true);
                VediPanel.this.jButtonDebug.setEnabled(true);
                VediPanel.this.refreshTree();
            }
        };
        this.one.setName("C-Build: " + this.currentProject.getProjectName());
        this.one.start();
    }

    boolean buildPeerCCNT() {
        boolean twice = this.currentProject.getBankswitching().contains("2 bank standard");
        for (int banks = 0; banks < 2; ++banks) {
            Object c;
            String fileNameOnly;
            ASMap asmap;
            String cntFilename;
            CartridgeProperties cart = new CartridgeProperties();
            StringBuilder buf = new StringBuilder();
            String baseProjectPath = Utility.makeVideAbsolute(this.currentProject.projectPrefix);
            String pathBuildLib = baseProjectPath + File.separator + "build" + File.separator + "lib";
            String pathSource = baseProjectPath + File.separator + "source";
            String pathBuild = baseProjectPath + File.separator + "build";
            String pathUsrLib = baseProjectPath + File.separator + "lib";
            if (!twice) {
                cntFilename = Utility.makeVideAbsolute(this.currentProject.projectPrefix + File.separator + "bin" + File.separator + this.currentProject.getProjectName() + ".cnt");
                asmap = this.parseMap(pathBuild + File.separator + this.currentProject.getProjectName() + ".map");
            } else {
                cntFilename = Utility.makeVideAbsolute(this.currentProject.projectPrefix + File.separator + "bin" + File.separator + this.currentProject.getProjectName() + "_" + banks + ".cnt");
                buf.append("BANK " + banks + "\n");
                pathBuildLib = baseProjectPath + File.separator + "build" + File.separator + "lib." + banks;
                asmap = this.parseMap(pathBuild + File.separator + this.currentProject.getProjectName() + "_" + banks + ".map");
            }
            File directory = new File(Utility.makeVideAbsolute(this.currentProject.projectPrefix));
            File[] fList = directory.listFiles();
            if (this.currentProject.getIsCDebugging()) {
                buf.append("HIGHEST_USED_RAM " + String.format("$%04X", asmap.highestUsedRAM & 0xFFFF) + "\n");
            }
            buf.append("COMMENT " + String.format("$%04X", asmap.highestUsedRAM & 0xFFFF) + " not used RAM onword...\n");
            if (this.currentProject.getIsCDebugging()) {
                FilePeeper.peepsFound /= 2;
            }
            this.printMessage("Header size: " + asmap.headerLength + ", Rom size: " + asmap.romLength + ", iRam size: " + asmap.initializedRAMUsage + ", uRam size: " + asmap.unInitializedRAMUsage + ", PF: " + FilePeeper.peepsFound);
            int extras = this.currentProject.getExtras();
            boolean is48K = (extras & Cartridge.FLAG_48K) != 0;
            boolean is44K = (extras & Cartridge.FLAG_44_PEER_BS) != 0;
            int maxSize = 32768;
            if (is48K) {
                maxSize += 16384;
            }
            if (asmap.romLength > maxSize) {
                this.printError("Resulting ROM exceeds maximum size!");
                return false;
            }
            String pathCLib = Global.mainPathPrefix + "C" + File.separator + "PeerC" + File.separator + "vectrex" + File.separator + "lib";
            directory = new File(pathCLib);
            fList = directory.listFiles();
            ArrayList<String> files = new ArrayList<String>();
            for (File file : fList) {
                fileNameOnly = file.getName();
                if (!fileNameOnly.toLowerCase().endsWith(".rst")) continue;
                files.add(file.getAbsolutePath());
            }
            directory = new File(pathUsrLib);
            if (directory.exists()) {
                for (File file : fList = directory.listFiles()) {
                    fileNameOnly = file.getName();
                    if (!fileNameOnly.toLowerCase().endsWith(".rst")) continue;
                    files.add(file.getAbsolutePath());
                }
            }
            directory = new File(pathBuildLib);
            for (File file : fList = directory.listFiles()) {
                fileNameOnly = file.getName();
                if (!fileNameOnly.toLowerCase().endsWith(".rst")) continue;
                files.add(file.getAbsolutePath());
            }
            RSTInfo rst = this.parseRSTs(files);
            for (MemInfo info : rst.m) {
                if (info.label.length() == 0) continue;
                String label = info.label;
                if ((info.address & 0xFFFF) <= 255 && label.contains("_dp_")) {
                    label = this.removeDP_LABELs(label);
                }
                buf.append("LABEL ").append(String.format("$%04X", info.address & 0xFFFF)).append(" ").append(label).append("\n");
            }
            for (MemInfo info : rst.m) {
                if (info.comment.length() == 0) continue;
                c = info.comment;
                c = UtilityString.replace((String)c, "rum:", "");
                c = UtilityString.replace((String)c, "rum", "");
                c = UtilityString.replace((String)c, "cold reset:", "");
                c = UtilityString.replace((String)c, "cold reset", "");
                c = UtilityString.replace((String)c, "cmpqi:(R):", "");
                c = UtilityString.replace((String)c, "cmpqi:(R)", "");
                if (((String)(c = UtilityString.replace((String)c, "cmpqi", ""))).trim().length() == 0 || (info.address & 0xFFFF) <= 255 && info.label.contains("_dp_")) continue;
                buf.append("COMMENT " + String.format("$%04X", info.address & 0xFFFF) + " " + (String)c + "\n");
            }
            for (MemInfo info : rst.m) {
                if (info.lineComment.length() == 0) continue;
                c = info.lineComment;
                buf.append("COMMENT_LINE " + String.format("$%04X", info.address & 0xFFFF) + " " + (String)c + "\n");
            }
            for (MemInfo info : rst.m) {
                if (info.cInfo == null) continue;
                c = info.cInfo;
                if (((CInfoBlock)c).hasBreakpoint) {
                    buf.append("C_INFO_BLOCK " + String.format("$%04X", info.address & 0xFFFF) + " \"" + ((CInfoBlock)c).file + " \"FN_END " + ((CInfoBlock)c).lineNo + " \"" + ((CInfoBlock)c).lineString + " \" BKPOINT=1\n");
                    continue;
                }
                buf.append("C_INFO_BLOCK " + String.format("$%04X", info.address & 0xFFFF) + " \"" + ((CInfoBlock)c).file + " \"FN_END " + ((CInfoBlock)c).lineNo + " \"" + ((CInfoBlock)c).lineString + " \" BKPOINT=0\n");
            }
            int a = 0;
            while (a < 32768) {
                a = this.addConsecutiveType(a, rst, buf);
            }
            try {
                PrintWriter out = new PrintWriter(cntFilename);
                out.println(buf.toString());
                out.close();
            }
            catch (Throwable e) {
                System.out.println("Error saving CNT file...");
                return false;
            }
            if (!twice) break;
        }
        return true;
    }

    String removeDP_LABELs(String in) {
        String out = "";
        String[] parts = in.split(":");
        for (String l : parts = VediPanel.removeEmpty(parts)) {
            if (l.contains("_dp_")) continue;
            if (out.length() > 0) {
                out = out + ":";
            }
            out = out + l.trim();
        }
        return out;
    }

    int addConsecutiveType(int start, RSTInfo rst, StringBuilder buf) {
        int end2;
        if (start > Short.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        int length = rst.m[start].typeLength;
        int type = rst.m[start].type;
        for (end2 = start + rst.m[start].typeLength; end2 < 32768 && rst.m[end2].type == type; end2 += rst.m[end2].typeLength) {
            length += rst.m[end2].typeLength;
        }
        if (end2 > 32768) {
            end2 = 32768;
        }
        switch (type) {
            case 3: {
                buf.append("RANGE " + String.format("$%04X", start & 0xFFFF) + "-" + String.format("$%04X", start + length & 0xFFFF) + " DB_DATA 8\n");
                break;
            }
            case 4: {
                buf.append("RANGE " + String.format("$%04X", start & 0xFFFF) + "-" + String.format("$%04X", start + length & 0xFFFF) + " CHAR_DATA 20\n");
                break;
            }
            case 2: {
                buf.append("RANGE " + String.format("$%04X", start & 0xFFFF) + "-" + String.format("$%04X", start + length & 0xFFFF) + " DW_DATA 4\n");
                break;
            }
            case 1: {
                buf.append("RANGE " + String.format("$%04X", start & 0xFFFF) + "-" + String.format("$%04X", start + length & 0xFFFF) + " CODE\n");
            }
        }
        return end2;
    }

    ASMap parseMap(String mapFile) {
        String line;
        int i;
        File f = new File(mapFile);
        if (f == null) {
            return null;
        }
        ASMap m = new ASMap();
        Vector<String> lines = UtilityString.readTextFileToStringNoTab(f);
        int areaCount = 0;
        for (i = 0; i < lines.size(); ++i) {
            int localHi;
            String[] split;
            line = lines.elementAt(i);
            if (line.startsWith(".data")) {
                split = line.split(" ");
                split = VediPanel.removeEmpty(split);
                m.initializedRAMUsage = DASM6809.toNumber("$" + split[2]);
                localHi = DASM6809.toNumber("$" + split[1]) + DASM6809.toNumber("$" + split[2]);
                if (m.highestUsedRAM < localHi) {
                    m.highestUsedRAM = localHi;
                }
            }
            if (line.startsWith(".bss")) {
                split = line.split(" ");
                split = VediPanel.removeEmpty(split);
                m.unInitializedRAMUsage = DASM6809.toNumber("$" + split[2]);
                localHi = DASM6809.toNumber("$" + split[1]) + DASM6809.toNumber("$" + split[2]);
                if (m.highestUsedRAM < localHi) {
                    m.highestUsedRAM = localHi;
                }
            }
            if (line.startsWith(".cartridge")) {
                split = line.split(" ");
                split = VediPanel.removeEmpty(split);
                m.headerLength = DASM6809.toNumber("$" + split[2]);
            }
            if (!line.startsWith(".text")) continue;
            split = line.split(" ");
            split = VediPanel.removeEmpty(split);
            m.romLength = DASM6809.toNumber("$" + split[2]);
        }
        for (i = 0; i < lines.size() && !(line = lines.elementAt(i)).contains("Files Linked"); ++i) {
            if (!line.contains("Area") || ++areaCount == 1) continue;
            line = lines.elementAt(i += 2);
            Area a = new Area(line);
            m.area.add(a);
            while (!line.contains("Global")) {
                line = lines.elementAt(i++);
            }
            i += 2;
            while (line.trim().length() != 0) {
                GlobalSymbols gs = new GlobalSymbols(line, a);
                a.symbols.add(gs);
                line = lines.elementAt(i++);
            }
        }
        return m;
    }

    Vector<String> ensureFileLoaded(HashMap<String, Vector> cFiles, String filename) {
        File f = new File(filename);
        if (!f.exists()) {
            return null;
        }
        if (cFiles.get(filename) != null) {
            return cFiles.get(filename);
        }
        Vector<String> v = UtilityString.readTextFileToStringNoTab(f);
        cFiles.put(filename, v);
        return v;
    }

    RSTInfo parseRSTs(ArrayList<String> files) {
        HashMap<String, Vector> cFiles = new HashMap<String, Vector>();
        RSTInfo rst = new RSTInfo();
        for (String f : files) {
            if (f.contains("vec_rom") || f.contains("vec_ram")) continue;
            ArrayList<Object> commentList = new ArrayList();
            String debugCommentFilename = "";
            debugCommentFilename = f.contains("enr.rst") ? UtilityString.replace(f, "enr.rst", "c") : UtilityString.replace(f, ".rst", ".c");
            DebugCommentList currentComments = this.getDebugComments(debugCommentFilename = UtilityString.replace(debugCommentFilename, "build" + File.separator + "lib", "source"));
            if (currentComments != null) {
                commentList = currentComments.getList();
                for (DebugComment debugComment : commentList) {
                    debugComment.breakpointCommitted = false;
                }
            }
            int areaCount = 0;
            Vector<String> vector = UtilityString.readTextFileToStringNoTab(new File(f));
            for (int i = 0; i < vector.size(); ++i) {
                String address;
                String line = vector.elementAt(i);
                if ((line = UtilityString.replaceWhiteSpaces(line, " ")).contains(".area")) {
                    ++areaCount;
                }
                if (areaCount < 1) continue;
                if (line.contains("(Motorola 6809)")) break;
                if (line.length() < 30 || !UtilityString.isHexNumber(address = line.substring(3, 7))) continue;
                int iaddress = DASM6809.toNumber("$" + address);
                if (!line.contains("[") || !line.contains("]") || !line.contains(";")) continue;
                String comment = line.substring(line.indexOf(";"));
                rst.setComment(iaddress, comment);
            }
            areaCount = 0;
            int lastAddress = 0;
            String nextComment = "";
            CInfoBlock cInfo = null;
            for (int i = 0; i < vector.size(); ++i) {
                String ln;
                String line = vector.elementAt(i);
                if ((line = UtilityString.replaceWhiteSpaces(line, " ")).contains(".area")) {
                    ++areaCount;
                }
                if (areaCount < 1) continue;
                if (line.contains("(Motorola 6809)")) break;
                if (line.contains("; #ENR#[") && i + 4 < vector.size()) {
                    String string = vector.elementAt(i - 1);
                    String line2 = line;
                    String line4 = "";
                    int t = 1;
                    boolean adressFound = false;
                    while (!adressFound && vector.size() >= i + t + 1) {
                        String address;
                        if (!UtilityString.isHexNumber(address = (line4 = vector.elementAt(i + t++)).substring(3, 7))) continue;
                        adressFound = true;
                    }
                    if (line2.contains("#ENR#")) {
                        if (cInfo == null) {
                            cInfo = new CInfoBlock();
                        }
                        if (!cInfo.hasBreakpoint) {
                            cInfo.file = string.indexOf("\"") == -1 ? "" : string.substring(string.indexOf("\"") + 1, string.lastIndexOf("\""));
                            cInfo.file = UtilityString.replace(cInfo.file, ".enr.c", ".c").trim();
                            String lineNo = line2.substring(line2.indexOf("[") + 1, line2.indexOf("]"));
                            cInfo.lineNo = UtilityString.Int0(lineNo);
                            cInfo.lineString = cInfo.lineString.length() == 0 ? line2.substring(line2.indexOf("]") + 1) : cInfo.lineString + ", " + line2.substring(line2.indexOf("]") + 1);
                            String address = line4.substring(3, 7);
                            if (UtilityString.isHexNumber(address)) {
                                cInfo.address = DASM6809.toNumber("$" + address);
                            }
                            for (DebugComment debugComment : commentList) {
                                if (debugComment.beforLineNo != cInfo.lineNo) continue;
                                cInfo.hasBreakpoint = true;
                                debugComment.breakpointCommitted = true;
                            }
                        }
                        ++i;
                        continue;
                    }
                }
                if (line.length() < 30) continue;
                String string = line.substring(3, 7);
                if (UtilityString.isHexNumber(string)) {
                    lastAddress = DASM6809.toNumber("$" + string);
                    if (cInfo != null) {
                        rst.setCInfo(lastAddress, cInfo);
                    }
                    if (nextComment.length() != 0) {
                        rst.setLineComment(lastAddress, nextComment);
                    }
                    cInfo = null;
                    nextComment = "";
                    continue;
                }
                if (line.contains(".stabs") || !line.contains(Global.mainPathPrefix) || !UtilityString.isDecNumber(ln = line.substring(33, 38).trim())) continue;
                int lineNumber = UtilityString.Int0(ln);
                String filename = line.substring(line.indexOf("\"") + 1, line.lastIndexOf("\""));
                Vector<String> v = this.ensureFileLoaded(cFiles, filename);
                if (v == null) continue;
                nextComment = v.elementAt(lineNumber - 1);
            }
            areaCount = 0;
            int lastCertainAddress = 0;
            for (int i = 0; i < vector.size(); ++i) {
                String address;
                String string2 = vector.elementAt(i);
                string2 = UtilityString.replaceWhiteSpaces(string2, " ");
                if (string2.contains(".area")) {
                    ++areaCount;
                }
                if (areaCount < 1) continue;
                if (string2.contains("(Motorola 6809)")) break;
                if (string2.length() < 30 || !UtilityString.isHexNumber(address = string2.substring(3, 7))) continue;
                int iaddress = DASM6809.toNumber("$" + address);
                boolean isCertainAddress = false;
                if (string2.contains("[") && string2.contains("]")) {
                    isCertainAddress = true;
                    lastCertainAddress = iaddress;
                }
                if (string2.contains(".byte")) {
                    rst.setType(iaddress, 3, 1);
                    continue;
                }
                if (string2.contains(".word")) {
                    rst.setType(iaddress, 2, 2);
                    continue;
                }
                if (string2.contains(".ascii")) {
                    int asciiLen = this.getAsciiLen(i, vector);
                    rst.setType(iaddress, 4, asciiLen);
                    continue;
                }
                if (string2.contains("[") && string2.contains("]")) {
                    int x = this.getCodeBytes(string2, 12);
                    rst.setType(iaddress, 1, x);
                    continue;
                }
                String label = string2.substring(32);
                if (!label.contains(":")) continue;
                if ((label = label.substring(0, label.indexOf(":")).trim()).trim().split(" ").length > 1) {
                    label = "";
                }
                if (label.length() == 0) continue;
                if (!isCertainAddress && iaddress < lastCertainAddress) {
                    iaddress += lastCertainAddress;
                }
                rst.setLabel(iaddress, label);
            }
            for (DebugComment debugComment : commentList) {
                if (debugComment.breakpointCommitted) continue;
                this.printWarning("Breakpoint " + debugCommentFilename + ": " + debugComment.beforLineNo + " could not be committed!");
            }
        }
        return rst;
    }

    int getCodeBytes(String line, int max) {
        int end2;
        int x = 0;
        for (end2 = 8 + max; line.length() < end2; --end2) {
        }
        line = line.substring(8, end2).trim();
        String[] split = line.split(" ");
        split = VediPanel.removeEmpty(split);
        for (int i = 0; i < split.length && UtilityString.isHexNumber(split[i]); ++i) {
            ++x;
        }
        return x;
    }

    int getAsciiLen(int i, Vector<String> lines) {
        String line = lines.elementAt(i++);
        int count = this.getCodeBytes(line, 18);
        line = lines.elementAt(i++);
        while (line.startsWith("       ")) {
            count += this.getCodeBytes(line, 18);
            line = lines.elementAt(i++);
        }
        return count;
    }

    String truncateFilename(String file) {
        String path;
        String baseProjectPath = path = Global.mainPathPrefix;
        if (this.currentProject != null) {
            baseProjectPath = Utility.makeVideAbsolute(this.currentProject.projectPrefix + File.separator);
        }
        String path2 = Global.mainPathPrefix + "C" + File.separator + "PeerC" + File.separator + "vectrex" + File.separator + "lib" + File.separator;
        String ret = UtilityString.replace(file, baseProjectPath, "");
        ret = UtilityString.replace(ret, path2, "");
        return ret;
    }

    void toAssi() {
        if (this.getSelectedEditor() == null) {
            return;
        }
        String fn = this.getSelectedEditor().getFilename();
        if (!fn.toLowerCase().endsWith("s")) {
            return;
        }
        if (!this.config.onlyManualSaveInEditor && this.getSelectedEditor().hasChanged()) {
            this.getSelectedEditor().save(false);
        }
        Vector<String> sLines = UtilityString.readTextFileToString(new File(fn));
        CompileResult result = VediPanel.doAssiConform(null, sLines, null);
        ArrayList<CompileResult> compiles = new ArrayList<CompileResult>();
        compiles.add(result);
        String t = this.buildFinalAssiResultString(compiles, false);
        if (t == null) {
            return;
        }
        this.getSelectedEditor().stopColoring();
        this.getSelectedEditor().setText(t);
        this.getSelectedEditor().startColoring(this.settings.fontSize);
        this.initInventory();
    }

    static String getMnemonic(String line) {
        if (!line.startsWith(" ")) {
            if (!line.contains(" ")) {
                return "";
            }
            line = line.substring(line.indexOf(" "));
        }
        String[] split = line.split(" ");
        for (int i = 0; i < split.length; ++i) {
            if (split[i].length() == 0) continue;
            return split[i];
        }
        return "";
    }

    static String getOperand(String line, String knownMnemonic) {
        String rest = line.substring(line.indexOf(knownMnemonic) + knownMnemonic.length()).trim();
        if (rest.length() == 0) {
            return "";
        }
        rest = UtilityString.replaceWhiteSpaces(rest, " ");
        rest = UtilityString.replace(rest, " ", "");
        return rest;
    }

    void preprocessOnly() {
        if (this.getSelectedEditor() == null) {
            return;
        }
        String fn = this.getSelectedEditor().getFilename();
        if (!(fn.toLowerCase().endsWith("s") || fn.toLowerCase().endsWith("i") || fn.toLowerCase().endsWith("asm"))) {
            return;
        }
        if (!this.config.onlyManualSaveInEditor && this.getSelectedEditor().hasChanged()) {
            this.getSelectedEditor().save(false);
        }
        CustomOutputStream preprocessOut = new CustomOutputStream();
        PrintStream asmPreprocess = new PrintStream(preprocessOut);
        CustomOutputStream _errOut = new CustomOutputStream();
        PrintStream _asmErrOut = new PrintStream(_errOut);
        String o = new Asmj(fn, _asmErrOut, asmPreprocess).getAllOut();
        fn = VediPanel.changeTypeTo(fn, "pre.s");
        UtilityString.writeToTextFile(o, new File(fn));
        EditorPanel edi = this.addEditor(fn, true);
    }

    void toAs6809() {
        if (this.getSelectedEditor() == null) {
            return;
        }
        String fn = this.getSelectedEditor().getFilename();
        if (!(fn.toLowerCase().endsWith("s") || fn.toLowerCase().endsWith("i") || fn.toLowerCase().endsWith("asm"))) {
            return;
        }
        if (!this.config.onlyManualSaveInEditor && this.getSelectedEditor().hasChanged()) {
            this.getSelectedEditor().save(false);
        }
        File f = new File(fn);
        String nameOnly = f.getName();
        Vector<String> sLines = UtilityString.readTextFileToString(new File(fn));
        CompileResult result = VediPanel.toAs6809(sLines, nameOnly);
        fn = VediPanel.changeTypeTo(fn, "asx.s");
        UtilityString.writeToTextFile(result.codeData, new File(fn));
        EditorPanel edi = this.addEditor(fn, true);
    }

    static boolean containsWord(String line, String word) {
        char endChar;
        char startChar;
        if (!line.contains(word)) {
            return false;
        }
        boolean contains = true;
        int start = line.indexOf(word);
        int end2 = line.indexOf(word) + word.length();
        if (start > 0 && !UtilityString.isWordBoundry(startChar = line.charAt(start - 1))) {
            contains = false;
        }
        if (end2 < line.length() && !UtilityString.isWordBoundry(endChar = line.charAt(end2))) {
            contains = false;
        }
        return contains;
    }

    static String removeAS6809QuotePairs(String sLine) {
        if (!sLine.contains("'")) {
            return sLine;
        }
        String[] split = sLine.split("'");
        if ((split = VediPanel.removeEmpty(split)).length < 2) {
            return sLine;
        }
        String result = "";
        int pos1 = 0;
        int pos2 = 0;
        String work = sLine;
        pos1 = work.indexOf("'");
        result = work.substring(0, pos1 + 1);
        pos2 = (work = work.substring(pos1 + 1)).indexOf("'");
        if (pos2 != 1) {
            result = result + work.substring(0, pos2 + 1);
            work = work.substring(pos2 + 1);
        } else {
            result = result + work.substring(0, 1);
            work = work.substring(2);
        }
        result = result + VediPanel.removeAS6809QuotePairs(work);
        return result;
    }

    static CompileResult toAs6809(Vector<String> sLines, String module) {
        CompileResult result = new CompileResult();
        module = UtilityString.replaceWhiteSpaces(module.toLowerCase(), " ");
        if ((module = UtilityString.replaceWhiteSpaces(module, "")).length() == 0) {
            module = "tmp";
        }
        if (Character.isDigit(module.charAt(0))) {
            module = "_" + module;
        }
        StringBuilder codeSource = new StringBuilder();
        StringBuilder dataSource = new StringBuilder();
        StringBuilder bssSource = new StringBuilder();
        StringBuilder bssInitSource = new StringBuilder();
        boolean in_Code = false;
        boolean in_Data = false;
        boolean in_BSS = false;
        ArrayList<String> globalNames = new ArrayList<String>();
        ArrayList<String> globalVars = new ArrayList<String>();
        codeSource.append("; NOTE!!!\n; IF USED IN 'C' YOU MIGHT NEED TO SAVE SOME REGS WHEN CALLING\n");
        codeSource.append("; YOUR FUNCTIONS, LIKE REG 'U' and 'Y'!\n");
        codeSource.append("; ALSO CHECK YOUR DP SETTINGS, BELOW DP = D0 is assumed!\n");
        codeSource.append(" .module " + module + "\n");
        codeSource.append(" .area .text\n");
        boolean inStruct = false;
        String structName = "";
        String structComment = "";
        int structCount = 0;
        for (int i = 0; i < sLines.size(); ++i) {
            String mnemonic;
            String innerBracketString;
            int ii;
            String comment;
            String line;
            boolean doLine = true;
            String sLine = sLines.elementAt(i);
            String orgLine = sLines.elementAt(i);
            if (orgLine.trim().startsWith("SONG_DATA ")) continue;
            orgLine = UtilityString.replace(orgLine, "$", "0x");
            if ((sLine = UtilityString.replaceWhiteSpaces(sLine.toLowerCase(), " ")).trim().startsWith(";")) {
                codeSource.append(orgLine + "\n");
                continue;
            }
            if (sLine.trim().startsWith("*")) {
                codeSource.append(";" + orgLine.substring(1) + "\n");
                continue;
            }
            sLine = Comment.removeEndOfLineComment(sLine);
            sLine = VediPanel.removeAS6809QuotePairs(sLine);
            orgLine = VediPanel.removeAS6809QuotePairs(orgLine);
            String wLine = UtilityString.replaceWhiteSpaces(sLine, " ");
            if ((wLine.toLowerCase().contains(" db ") || wLine.toLowerCase().contains(" fcb ") || wLine.toLowerCase().contains(" fcc ")) && wLine.contains("\"") && wLine.contains(",")) {
                int cPos = orgLine.lastIndexOf("\"");
                String newLine1 = orgLine.substring(0, cPos + 1);
                newLine1 = UtilityString.replace(newLine1, " DB ", " .ascii ");
                newLine1 = UtilityString.replace(newLine1, " FCB ", " .ascii ");
                newLine1 = UtilityString.replace(newLine1, " FCC ", " .ascii ");
                newLine1 = UtilityString.replace(newLine1, " db ", ". ascii ");
                newLine1 = UtilityString.replace(newLine1, " fcb ", " .ascii ");
                newLine1 = UtilityString.replace(newLine1, " fcc ", " .ascii ");
                String newLine2 = orgLine.substring(cPos + 1).trim();
                newLine2 = newLine2.substring(1).trim();
                newLine2 = " .byte " + newLine2;
                codeSource.append(newLine1 + "\n");
                codeSource.append(newLine2 + "\n");
                continue;
            }
            if (sLine.contains("%")) {
                int pos = sLine.indexOf("%");
                if (sLine.length() - pos >= 8) {
                    boolean isBinary = true;
                    for (int ib = pos + 1; ib < pos + 1 + 8; ++ib) {
                        char c = sLine.charAt(ib);
                        if (c == '0' || c == '1') continue;
                        isBinary = false;
                        break;
                    }
                    if (isBinary) {
                        orgLine = UtilityString.replace(orgLine, "%", "0b");
                        sLine = UtilityString.replace(sLine, "%", "0b");
                    }
                }
            }
            if (sLine.contains(" end struct")) {
                codeSource.append(structName + " = " + structCount + " " + structComment + "\n");
                inStruct = false;
                structName = "";
                structComment = "";
                structCount = 0;
                continue;
            }
            if (inStruct) {
                String line2 = Comment.removeEndOfLineComment(orgLine);
                String someComment = UtilityString.replace(orgLine, line2, "");
                String someName = "";
                if (!(line2 = UtilityString.replaceWhiteSpaces(line2, " ")).toLowerCase().contains(" ds") || !line2.toLowerCase().contains(",")) continue;
                int dsIndex = line2.toLowerCase().indexOf(" ds");
                int commaIndex = line2.toLowerCase().indexOf(",");
                someName = line2.substring(dsIndex + " ds".length(), commaIndex).trim();
                codeSource.append(someName + " = " + structCount + " " + someComment + "\n");
                line2 = line2.substring(commaIndex + 1).trim();
                String[] split = line2.split(" ");
                for (String s : split = VediPanel.removeEmpty(split)) {
                    structCount += DASM6809.toNumber(s);
                }
                continue;
            }
            if (sLine.contains(" struct")) {
                String line3 = Comment.removeEndOfLineComment(orgLine);
                structComment = UtilityString.replace(orgLine, line3, "");
                int pos = sLine.indexOf(" struct");
                if (sLine.length() > pos + " struct".length()) {
                    pos = sLine.indexOf(" struct ");
                }
                if (pos >= 0) {
                    inStruct = true;
                    structCount = 0;
                    String lineCopy = line3.toLowerCase();
                    pos = lineCopy.indexOf(" struct");
                    structName = line3.substring(pos + " struct".length()).trim();
                    continue;
                }
            }
            boolean isFunction = true;
            isFunction &= sLine.trim().length() != 0;
            isFunction &= !sLine.startsWith(" ");
            isFunction &= !sLine.contains("=");
            isFunction &= !VediPanel.containsWord(sLine, "equ");
            isFunction &= !VediPanel.containsWord(sLine, "set");
            isFunction &= !VediPanel.containsWord(sLine, "macro");
            isFunction &= !VediPanel.containsWord(sLine, "struct");
            isFunction &= !VediPanel.containsWord(sLine, "db");
            isFunction &= !VediPanel.containsWord(sLine, "dw");
            isFunction &= !VediPanel.containsWord(sLine, "ds");
            isFunction &= !sLine.contains("\"");
            String t1 = UtilityString.replaceWhiteSpaces(orgLine, " ");
            t1 = Comment.removeEndOfLineComment(t1);
            t1 = UtilityString.replaceWhiteSpaces(t1, " ");
            t1 = UtilityString.replace(t1, ":", " ");
            t1 = UtilityString.replace(t1.trim(), "  ", " ");
            String[] split = t1.split(" ");
            if ((split = VediPanel.removeEmpty(split)).length == 1) {
                if (i + 1 < sLines.size()) {
                    String nextLine = sLines.elementAt(i + 1).toLowerCase();
                    t1 = UtilityString.replaceWhiteSpaces(nextLine, " ");
                    t1 = Comment.removeEndOfLineComment(t1);
                    t1 = UtilityString.replaceWhiteSpaces(t1, " ");
                    t1 = UtilityString.replace(t1, ":", " ");
                    isFunction &= !VediPanel.containsWord(t1 = UtilityString.replace(t1.trim(), "  ", " "), "equ");
                    isFunction &= !VediPanel.containsWord(t1, "set");
                    isFunction &= !VediPanel.containsWord(t1, "macro");
                    isFunction &= !VediPanel.containsWord(t1, "struct");
                    isFunction &= !VediPanel.containsWord(t1, "db");
                    isFunction &= !VediPanel.containsWord(t1, "dw");
                    isFunction &= !VediPanel.containsWord(t1, "ds");
                    isFunction &= !t1.contains("\"");
                } else {
                    isFunction = false;
                }
            }
            if (isFunction) {
                String sLine2 = UtilityString.replaceWhiteSpaces(orgLine, " ");
                String name = (sLine2 = Comment.removeEndOfLineComment(sLine2)).split(" ")[0];
                if (name.endsWith(":")) {
                    name = name.substring(0, name.length() - 1);
                }
                if (name.trim().length() != 0) {
                    codeSource.append(" .globl " + name + "\n");
                    globalNames.add(name);
                }
                orgLine = UtilityString.replace(orgLine, name + ":", name);
                orgLine = UtilityString.replace(orgLine, name, name + ":");
            }
            boolean isVar = true & !isFunction;
            isVar &= sLine.trim().length() != 0;
            isVar &= !sLine.startsWith(" ");
            isVar &= !sLine.contains("=");
            isVar &= !VediPanel.containsWord(sLine, "equ");
            isVar &= !VediPanel.containsWord(sLine, "set");
            isVar &= !VediPanel.containsWord(sLine, "macro");
            isVar &= !VediPanel.containsWord(sLine, "struct");
            if (isVar &= !sLine.contains("\"")) {
                String sLine2 = UtilityString.replaceWhiteSpaces(orgLine, " ");
                String name = (sLine2 = Comment.removeEndOfLineComment(sLine2)).split(" ")[0];
                if (name.endsWith(":")) {
                    name = name.substring(0, name.length() - 1);
                }
                if (name.trim().length() != 0) {
                    codeSource.append(" .globl " + name + "\n");
                    globalVars.add(name);
                }
                orgLine = UtilityString.replace(orgLine, name + ":", name);
                orgLine = UtilityString.replace(orgLine, name, name + ":");
            }
            String loHiTest = UtilityString.replaceWhiteSpaces(orgLine, " ");
            loHiTest = Comment.removeEndOfLineComment(loHiTest);
            if ((loHiTest = UtilityString.replace(loHiTest, " ", "")).toLowerCase().contains("lo(")) {
                int pos;
                line = Comment.removeEndOfLineComment(orgLine);
                comment = UtilityString.replace(orgLine, line, "");
                line = UtilityString.replaceCI(line, "lo (", "lo_(");
                line = UtilityString.replaceCI(line, "lo(", "lo_(");
                String r = "";
                while ((pos = line.indexOf("lo_")) != -1) {
                    r = r + line.substring(0, pos);
                    line = line.substring(pos + 4);
                    int in = 1;
                    ii = 0;
                    for (ii = 0; ii < line.length(); ++ii) {
                        char t = line.charAt(ii);
                        if (t == '(') {
                            ++in;
                        }
                        if (t == ')') {
                            --in;
                        }
                        if (in == 0) break;
                    }
                    innerBracketString = line.substring(0, ii);
                    line = line.substring(ii + 1);
                    r = r + "((" + innerBracketString + ")&0xff)";
                }
                orgLine = r + line + comment;
            }
            if (loHiTest.toLowerCase().contains("hi(")) {
                int pos;
                line = Comment.removeEndOfLineComment(orgLine);
                comment = UtilityString.replace(orgLine, line, "");
                line = UtilityString.replaceCI(line, "hi (", "hi_(");
                line = UtilityString.replaceCI(line, "hi(", "hi_(");
                String r = "";
                while ((pos = line.indexOf("hi_")) != -1) {
                    r = r + line.substring(0, pos);
                    line = line.substring(pos + 4);
                    int in = 1;
                    ii = 0;
                    for (ii = 0; ii < line.length(); ++ii) {
                        char t = line.charAt(ii);
                        if (t == '(') {
                            ++in;
                        }
                        if (t == ')') {
                            --in;
                        }
                        if (in == 0) break;
                    }
                    innerBracketString = line.substring(0, ii);
                    line = line.substring(ii + 1);
                    r = r + "(((" + innerBracketString + ")>>8)&0xff)";
                }
                orgLine = r + line + comment;
            }
            if ((mnemonic = VediPanel.getMnemonic(sLine)).trim().length() == 0) {
                codeSource.append(orgLine + "\n");
                continue;
            }
            if (mnemonic.equals("code")) {
                codeSource.append(UtilityString.replaceCI(orgLine, "code", ".area .text", true) + "\n");
                codeSource.append("; NOTE!!!\n; THIS MIGHT BE INCORRECT FOR YOUR NEEDS!\n; MOST OF THE TIME FOR MALBAN THIS IS GOOD!\n");
                codeSource.append(" .setdp   0xd000,_DATA\n");
                continue;
            }
            if (mnemonic.equals("bss")) {
                codeSource.append(UtilityString.replaceCI(orgLine, "bss", ".area .bss", true) + "\n");
                continue;
            }
            if (mnemonic.equals("direct")) {
                codeSource.append("; Warning - direct line found!\n");
                codeSource.append(";" + orgLine + "\n");
                continue;
            }
            if (mnemonic.equals("org")) {
                codeSource.append("; Warning - org line found, my be countering relocatable code!\n");
                codeSource.append(";" + orgLine + "\n");
                continue;
            }
            if (mnemonic.equals("equ")) {
                codeSource.append(UtilityString.replaceCI(orgLine, "equ", "=", true) + "\n");
                continue;
            }
            if (mnemonic.equals("set")) {
                codeSource.append(UtilityString.replaceCI(orgLine, "set", "=", true) + "\n");
                continue;
            }
            if (mnemonic.equals("ds") || mnemonic.equals("rmb")) {
                orgLine = UtilityString.replaceCI(orgLine, "ds", ".blkb", true);
                orgLine = UtilityString.replaceCI(orgLine, "rmb", ".blkb", true);
                codeSource.append(orgLine + "\n");
                continue;
            }
            if (mnemonic.equals("dw") || mnemonic.equals("fdb")) {
                orgLine = UtilityString.replaceCI(orgLine, "dw", ".word", true);
                orgLine = UtilityString.replaceCI(orgLine, "fdb", ".word", true);
                codeSource.append(orgLine + "\n");
                continue;
            }
            if (mnemonic.equals("db") || mnemonic.equals("fcb") || mnemonic.equals("fcc")) {
                orgLine = UtilityString.replaceCI(orgLine, "db", ".byte", true);
                orgLine = UtilityString.replaceCI(orgLine, "fcb", ".byte", true);
                if ((orgLine = UtilityString.replaceCI(orgLine, "fcc", ".byte", true)).contains("\"")) {
                    orgLine = UtilityString.replaceCI(orgLine, ".byte", ".ascii", true);
                    if (sLine.endsWith(", 0x80")) {
                        orgLine = UtilityString.replaceCI(orgLine, ", 0x80", "");
                        codeSource.append(orgLine + "\n");
                        codeSource.append(" .byte 0x80\n");
                        continue;
                    }
                    if (sLine.endsWith(",0x80")) {
                        orgLine = UtilityString.replaceCI(orgLine, ",0x80", "");
                        codeSource.append(orgLine + "\n");
                        codeSource.append(" .byte 0x80\n");
                        continue;
                    }
                }
                codeSource.append(orgLine + "\n");
                continue;
            }
            String op = VediPanel.getOperand(sLine, mnemonic);
            if (mnemonic.equals("nop")) {
                String line4 = Comment.removeEndOfLineComment(orgLine);
                String someComment = UtilityString.replace(orgLine, line4, "");
                op = UtilityString.replace(op, "(", "").toLowerCase();
                op = UtilityString.replace(op, "nop", "");
                op = UtilityString.replace(op, ")", "").trim();
                int nopCount = UtilityString.IntX(op, 1);
                for (int ni = 0; ni < nopCount; ++ni) {
                    if (ni == 0) {
                        codeSource.append(" nop " + someComment + "\n");
                        continue;
                    }
                    codeSource.append(" nop \n");
                }
                continue;
            }
            if (op.startsWith("<<")) {
                orgLine = UtilityString.replace(orgLine, "<<", "");
            }
            if (op.startsWith("[<<")) {
                orgLine = UtilityString.replace(orgLine, "[<<", "[");
            }
            if (op.startsWith("<")) {
                orgLine = UtilityString.replace(orgLine, "<", "*");
            }
            if (op.startsWith("[<")) {
                orgLine = UtilityString.replace(orgLine, "[<", "[*");
            }
            if (op.startsWith(">")) {
                orgLine = UtilityString.replace(orgLine, ">", "");
            }
            if (op.startsWith("[>")) {
                orgLine = UtilityString.replace(orgLine, "[>", "[");
            }
            if (op.contains(",sp")) {
                orgLine = UtilityString.replace(orgLine, ",sp", ",s");
            }
            if (op.contains(",SP")) {
                orgLine = UtilityString.replace(orgLine, ",SP", ",s");
            }
            if (op.contains(", sp")) {
                orgLine = UtilityString.replace(orgLine, ", sp", ",s");
            }
            if (op.contains(", SP")) {
                orgLine = UtilityString.replace(orgLine, ", SP", ",s");
            }
            codeSource.append(orgLine + "\n");
        }
        String org2 = codeSource.toString();
        for (String varName : globalVars) {
            String in = org2;
            String out = "";
            int sPos = in.indexOf(varName);
            while (sPos >= 0) {
                char preChar = ' ';
                char postChar = ' ';
                String pre = in.substring(0, sPos);
                String post = in.substring(sPos + varName.length(), in.length());
                if (pre.length() > 0) {
                    preChar = pre.charAt(pre.length() - 1);
                }
                if (post.length() > 0) {
                    postChar = post.charAt(0);
                }
                out = VediPanel.isVarSeperator(preChar) && VediPanel.isVarSeperator(postChar) ? out + pre + "_" + varName : out + pre + varName;
                in = post;
                sPos = in.indexOf(varName);
            }
            org2 = out + in;
        }
        result.bssInitData = bssInitSource.toString();
        result.bssData = bssSource.toString();
        result.codeData = org2;
        result.dataData = dataSource.toString();
        return result;
    }

    static boolean isVarSeperator(char a) {
        boolean noSeperator = false;
        if (Character.isAlphabetic(a)) {
            noSeperator = true;
        }
        if (Character.isDigit(a)) {
            noSeperator = true;
        }
        if (a == '_') {
            noSeperator = true;
        }
        return !noSeperator;
    }

    void doAS6809() {
        if (this.getSelectedEditor() == null) {
            return;
        }
        String fn = this.getSelectedEditor().getFilename();
        if (!(fn.toLowerCase().endsWith("s") || fn.toLowerCase().endsWith("i") || fn.toLowerCase().endsWith("asm"))) {
            return;
        }
        if (!this.config.onlyManualSaveInEditor && this.getSelectedEditor().hasChanged()) {
            this.getSelectedEditor().save(false);
        }
        String[] ASMFLAGS = this.buildPeerASMFLAGS("");
        File file = new File(fn);
        ASMFLAGS[ASMFLAGS.length - 2] = VediPanel.changeTypeTo(file.getAbsolutePath(), "rel");
        ASMFLAGS[ASMFLAGS.length - 1] = file.getAbsolutePath();
        if (this.doPeerAssemble(ASMFLAGS, "Assemble")) {
            EditorPanel editorPanel = this.addEditor(ASMFLAGS[ASMFLAGS.length - 2], false);
        }
    }

    public static void convertToCASM(String orgName, boolean deleteOrg) {
        CustomOutputStream preprocessOut = new CustomOutputStream();
        PrintStream asmPreprocess = new PrintStream(preprocessOut);
        CustomOutputStream _errOut = new CustomOutputStream();
        PrintStream _asmErrOut = new PrintStream(_errOut);
        String o = new Asmj(orgName, _asmErrOut, asmPreprocess).getAllOut();
        String newNamePre = VediPanel.changeTypeTo(orgName, "pre.s");
        UtilityString.writeToTextFile(o, new File(newNamePre));
        Vector<String> sLines = UtilityString.readTextFileToString(new File(newNamePre));
        String module = VediPanel.baseOnly(new File(orgName).getName());
        CompileResult result = VediPanel.toAs6809(sLines, module);
        UtilityFiles.deleteFile(newNamePre);
        String newName_s = VediPanel.changeTypeTo(orgName, "s");
        UtilityString.writeToTextFile(result.codeData, new File(newName_s));
        if (deleteOrg) {
            UtilityFiles.deleteFile(orgName);
        }
    }

    File[] enrichCFiles(ArrayList<String> fList) {
        ArrayList<File> outputFiles = new ArrayList<File>();
        for (String file : fList) {
            String outName = VediPanel.changeTypeTo(file, "enr.c");
            this.enrichtOneFile(file, outName);
            outputFiles.add(new File(outName));
        }
        return outputFiles.toArray(new File[0]);
    }

    File[] enrichCFiles(File[] fList) {
        File[] flist2 = this.getAllCFiles(fList);
        ArrayList<File> outputFiles = new ArrayList<File>();
        for (File file : flist2) {
            String fileName = file.getAbsolutePath();
            if (!fileName.toLowerCase().endsWith(".c")) continue;
            String outName = VediPanel.changeTypeTo(fileName, "enr.c");
            this.enrichtOneFile(fileName, outName);
            outputFiles.add(new File(outName));
        }
        return outputFiles.toArray(new File[0]);
    }

    File[] getAllCFiles(File[] fList) {
        ArrayList<File> outputFiles = new ArrayList<File>();
        for (File file : fList) {
            if (file.isDirectory()) {
                File[] outputFiles3;
                File[] fList2 = file.listFiles();
                for (File f3 : outputFiles3 = this.getAllCFiles(fList2)) {
                    outputFiles.add(f3);
                }
                continue;
            }
            outputFiles.add(file);
        }
        return outputFiles.toArray(new File[0]);
    }

    String removeQuots(String line) {
        if (line.contains("\"")) {
            String l1 = line.substring(0, line.indexOf("\""));
            String l2 = "";
            if ((line = UtilityString.replace(line, l1 + "\"", "")).contains("\"")) {
                l2 = line.substring(line.indexOf("\"") + 1);
            }
            if ((line = l1 + l2).contains("\"")) {
                return this.removeQuots(line);
            }
        }
        return line;
    }

    String removeComments(String line) {
        if ((line = this.removeQuots(line)).contains("//")) {
            line = line.substring(0, line.indexOf("//"));
        }
        if (line.contains("/*")) {
            if (line.contains("*/")) {
                String l1 = line.substring(0, line.indexOf("/*"));
                String l2 = "";
                if (!line.trim().endsWith("*/") && line.lastIndexOf("*/") + 2 < line.length()) {
                    l2 = line.substring(line.lastIndexOf("*/") + 2);
                }
                line = l1 + l2;
            } else {
                line = line.substring(0, line.indexOf("/*"));
            }
        }
        return line.trim();
    }

    void enrichtOneFile(String in, String out) {
        Vector<String> sLines = UtilityString.readTextFileToString(new File(in));
        ArrayList<String> outLines = new ArrayList<String>();
        int countCurly = 0;
        int countRound = 0;
        int countSquare = 0;
        boolean inLargeLine = false;
        boolean inComment = false;
        boolean inStart = false;
        boolean inStruct = false;
        boolean inStartRoundSeen = false;
        boolean inVar = false;
        boolean inFunc = false;
        boolean openOneLiner = false;
        boolean openDo = false;
        int doCurlyCount = 0;
        boolean doEnrich = true;
        for (int i = 0; i < sLines.size(); ++i) {
            String line;
            String nextLine;
            int commentStartPos;
            boolean addCloseCurly = false;
            String preLine = "";
            boolean preLineAllowed = true;
            boolean overwriteAllowed = false;
            int curlyStart = countCurly;
            boolean openIfStart = openOneLiner;
            String orgLine = sLines.elementAt(i);
            if (orgLine.contains("EnrichmentOff")) {
                doEnrich = false;
            }
            if (orgLine.contains("EnrichmentOn")) {
                doEnrich = true;
            }
            if ((commentStartPos = orgLine.indexOf("/*")) >= 0 && orgLine.indexOf("//*") != -1) {
                commentStartPos = -1;
            }
            int commentEndPos = orgLine.lastIndexOf("*/");
            if (commentStartPos >= 0) {
                inComment = true;
            }
            if (inComment && commentEndPos > commentStartPos) {
                inComment = false;
            }
            if (inComment) {
                preLineAllowed = false;
            }
            if (commentStartPos >= 0 && commentEndPos >= 0) {
                String l = orgLine.substring(0, commentStartPos);
                if ((l = l + orgLine.substring(commentEndPos)).trim().length() == 0) {
                    preLineAllowed = false;
                }
            }
            String countReadyLine = orgLine.trim().toLowerCase();
            if (inComment) {
                countReadyLine = countReadyLine.contains("*/") ? countReadyLine.substring(countReadyLine.indexOf("*/") + 2) : "";
            }
            countReadyLine = this.removeComments(countReadyLine).trim();
            if (!inComment && orgLine.trim().toLowerCase().startsWith("#define")) {
                outLines.add(orgLine);
                while (i + 1 < sLines.size() && orgLine.endsWith("\\")) {
                    orgLine = sLines.elementAt(++i);
                    outLines.add(orgLine);
                }
                continue;
            }
            if (!(!countReadyLine.contains("=") || countReadyLine.contains("!=") || countReadyLine.contains("==") || countReadyLine.contains("<=") || countReadyLine.contains(">=") || countReadyLine.contains("=<") || countReadyLine.contains("=>") || countReadyLine.contains("*") || countReadyLine.contains("+=") || countReadyLine.contains("/=") || countReadyLine.contains("-=") || countReadyLine.contains("^=") || countReadyLine.contains("|=") || countReadyLine.contains("&=") || countReadyLine.contains("~="))) {
                openOneLiner = true;
            }
            if (countReadyLine.toLowerCase().trim().startsWith("while")) {
                openOneLiner = true;
            }
            if (countReadyLine.toLowerCase().trim().startsWith("for")) {
                openOneLiner = true;
            }
            if (countReadyLine.toLowerCase().trim().startsWith("if")) {
                openOneLiner = true;
            }
            if (countReadyLine.toLowerCase().trim().startsWith("else")) {
                openOneLiner = true;
                preLineAllowed = false;
            }
            if (orgLine.trim().contains("{")) {
                openOneLiner = false;
            }
            if (orgLine.trim().contains(";")) {
                String strange = UtilityString.replaceWhiteSpaces(orgLine, "");
                if (strange.toLowerCase().trim().startsWith("}while")) {
                    openOneLiner = false;
                } else if (orgLine.toLowerCase().trim().startsWith("while")) {
                    openOneLiner = false;
                } else if (orgLine.toLowerCase().trim().startsWith("for")) {
                    if (orgLine.toLowerCase().trim().endsWith(";")) {
                        openOneLiner = false;
                    }
                } else {
                    if (openOneLiner) {
                        // empty if block
                    }
                    openOneLiner = false;
                }
            }
            if (orgLine.toLowerCase().contains("else") && orgLine.toLowerCase().contains("if")) {
                preLineAllowed = false;
                overwriteAllowed = false;
            }
            boolean isAloneDo = false;
            if (orgLine.trim().startsWith("do")) {
                int doPos = orgLine.indexOf("do") + 2;
                isAloneDo = true;
                if (doPos < orgLine.length()) {
                    char next = orgLine.charAt(doPos);
                    isAloneDo = UtilityString.isWordBoundry(next);
                }
                if (isAloneDo) {
                    openDo = true;
                    doCurlyCount = countCurly;
                }
            }
            if (countReadyLine.trim().contains("while") && countReadyLine.trim().contains(";")) {
                preLineAllowed = false;
            }
            if (orgLine.trim().startsWith("#define")) {
                preLineAllowed = false;
            }
            if (orgLine.trim().startsWith("{")) {
                preLineAllowed = false;
            }
            if (orgLine.trim().startsWith("}")) {
                preLineAllowed = false;
            }
            if (orgLine.trim().startsWith("//")) {
                preLineAllowed = false;
            }
            if (orgLine.trim().length() == 0) {
                preLineAllowed = false;
            }
            if (countCurly == 0) {
                preLineAllowed = false;
            }
            if (countRound != 0) {
                preLineAllowed = false;
            }
            if (countSquare != 0) {
                preLineAllowed = false;
            }
            if (openDo && doCurlyCount == countCurly && !isAloneDo) {
                preLineAllowed = false;
            }
            if (inLargeLine) {
                preLineAllowed = false;
            }
            if (openIfStart) {
                preLineAllowed = false;
            }
            if (orgLine.trim().contains("while") && openDo) {
                if (doCurlyCount == countCurly) {
                    openDo = false;
                }
                if (orgLine.trim().startsWith("}")) {
                    if (doCurlyCount == countCurly - 1) {
                        openDo = false;
                    }
                    preLineAllowed = true;
                } else {
                    String lastLine = (String)outLines.get(outLines.size() - 1);
                    if (lastLine.trim().startsWith("}")) {
                        String prepreLine = "asm(\"; #ENR#[" + i + "]" + this.escape(countReadyLine) + "\");";
                        outLines.add(outLines.size() - 1, prepreLine);
                        preLineAllowed = false;
                    }
                }
            }
            if (!countReadyLine.endsWith(";") && !countReadyLine.endsWith(";") && sLines.size() > i + 1 && (nextLine = sLines.elementAt(i + 1)).trim().startsWith("}")) {
                preLineAllowed = false;
            }
            countCurly += UtilityString.countChars(countReadyLine, "{");
            if ((countCurly -= UtilityString.countChars(countReadyLine, "}")) == 0 && countReadyLine.contains("struct ") && !countReadyLine.contains(",") && !countReadyLine.contains("*")) {
                inStruct = true;
            }
            if (countCurly == 0 && curlyStart != 0 && inStruct) {
                inStruct = false;
            }
            int countRoundStart = UtilityString.countChars(countReadyLine, "(");
            countRound += UtilityString.countChars(countReadyLine, "(");
            countRound -= UtilityString.countChars(countReadyLine, ")");
            countSquare += UtilityString.countChars(countReadyLine, "[");
            countSquare -= UtilityString.countChars(countReadyLine, "]");
            if (countCurly == 0 && curlyStart != 0) {
                inStart = false;
                inStartRoundSeen = false;
                inFunc = false;
            }
            if (!inFunc && curlyStart == 0) {
                if (orgLine.trim().toLowerCase().contains("void ")) {
                    inStart = true;
                }
                if (orgLine.trim().toLowerCase().contains("signed ")) {
                    inStart = true;
                }
                if (orgLine.trim().toLowerCase().contains("unsigned ")) {
                    inStart = true;
                }
                if (orgLine.trim().toLowerCase().contains("char ")) {
                    inStart = true;
                }
                if (orgLine.trim().toLowerCase().contains("int ")) {
                    inStart = true;
                }
                if (orgLine.trim().toLowerCase().contains("short ")) {
                    inStart = true;
                }
                if (orgLine.trim().toLowerCase().contains("long ")) {
                    inStart = true;
                }
                if (orgLine.trim().toLowerCase().contains("volatile ")) {
                    inStart = true;
                }
                if (orgLine.trim().toLowerCase().contains("const ")) {
                    inStart = true;
                }
                if (orgLine.trim().toLowerCase().contains("static ")) {
                    inStart = true;
                }
                if (orgLine.trim().toLowerCase().contains("inline ")) {
                    inStart = true;
                }
                if (orgLine.trim().toLowerCase().contains("struct ")) {
                    inStart = true;
                }
                if (orgLine.trim().toLowerCase().contains("(") && orgLine.trim().toLowerCase().contains(")") && !orgLine.trim().toLowerCase().contains(";") && !orgLine.trim().toLowerCase().contains("=")) {
                    inStart = true;
                }
            }
            if (countRoundStart > 0 && inStart) {
                inStartRoundSeen = true;
            }
            if (inStart) {
                if (curlyStart == 0 && countCurly != 0) {
                    int curlyPos = orgLine.indexOf("{");
                    int roundPos = orgLine.indexOf(")");
                    int equalPos = orgLine.indexOf("=");
                    if (curlyPos > roundPos && inStartRoundSeen) {
                        inFunc = true;
                    }
                    if (roundPos == -1) {
                        roundPos = Integer.MAX_VALUE;
                    }
                    if (equalPos > roundPos) {
                        inFunc = false;
                        inStart = false;
                        inStartRoundSeen = false;
                    }
                    if (orgLine.contains("#define")) {
                        inFunc = false;
                        inStart = false;
                        inStartRoundSeen = false;
                    }
                    if (orgLine.contains("\\")) {
                        inFunc = false;
                    }
                    if (orgLine.trim().startsWith("//") || orgLine.trim().startsWith("/*")) {
                        inFunc = false;
                    }
                    inStart = false;
                } else if (curlyStart == 0 && countCurly == 0) {
                    int equalPos;
                    int roundPos = orgLine.indexOf(")");
                    if (roundPos >= 0 && inStartRoundSeen) {
                        inFunc = true;
                    }
                    if ((equalPos = orgLine.indexOf("=")) > roundPos) {
                        inFunc = false;
                        inStartRoundSeen = false;
                        inStart = false;
                    }
                    if (orgLine.contains("#define")) {
                        inFunc = false;
                        inStartRoundSeen = false;
                        inStart = false;
                    }
                    if (orgLine.contains("\\")) {
                        inFunc = false;
                    }
                    if (orgLine.trim().startsWith("//") || orgLine.trim().startsWith("/*")) {
                        inFunc = false;
                    }
                }
            }
            if (inStart && inFunc) {
                inStartRoundSeen = false;
                inStart = false;
            }
            if (orgLine.trim().startsWith("asm")) {
                preLineAllowed = false;
            }
            if (orgLine.contains("#define")) {
                preLineAllowed = false;
            }
            if (orgLine.trim().startsWith("*/")) {
                preLineAllowed = false;
            }
            if (orgLine.trim().endsWith("\\")) {
                preLineAllowed = false;
            }
            if ((line = this.removeComments(orgLine).trim()).endsWith(",")) {
                preLineAllowed = false;
            }
            if (!inFunc) {
                preLineAllowed = false;
            }
            if (inStruct) {
                preLineAllowed = false;
            }
            preLine = "{asm(\"; #ENR#[" + i + "]" + this.escape(countReadyLine) + "\");}";
            preLine = UtilityString.replace(preLine, "*/", "* /");
            inLargeLine = orgLine.endsWith("\\");
            if ((preLine.length() > 0 && preLineAllowed || overwriteAllowed) && doEnrich) {
                outLines.add(preLine);
            }
            if (addCloseCurly) {
                outLines.add(orgLine);
                outLines.add("}");
            } else {
                outLines.add(orgLine);
            }
            if (!countReadyLine.contains(";")) continue;
            inStruct = false;
        }
        StringBuilder outString = new StringBuilder();
        for (String s : outLines) {
            outString.append(s).append("\n");
        }
        UtilityString.writeToTextFile(outString.toString(), new File(out));
    }

    void deleteEnrichedCFiles(File[] fList) {
        for (File f : fList) {
            if (!f.exists() || !f.getAbsolutePath().endsWith("enr.c")) continue;
            if (this.currentProject.getIsCKeepEnriched()) {
                String copyForTest = VediPanel.changeTypeTo(f.getAbsolutePath(), "ec");
                UtilityFiles.move(f.getAbsolutePath(), copyForTest);
                continue;
            }
            UtilityFiles.deleteFile(f.getAbsolutePath());
        }
    }

    String escape(String e) {
        return UtilityString.replace(e, "\"", "\\\"");
    }

    @Override
    public Point getEditorPos() {
        Point p = new Point();
        p.x = this.settings.pos2 + 10;
        p.y = this.jSplitPane1.getY() + 4 + 20;
        return p;
    }

    public void resetCScan(boolean hasFramePointer) {
        if (this.cInfo.hasFramePointer == hasFramePointer) {
            return;
        }
        this.cInfo.hasFramePointer = hasFramePointer;
        this.cInfo.resetDefinitions();
        this.updateDefinitions();
    }

    public static C6809FileMaster getCInfo(Component o) {
        VEdiFoundationPanel vedi = VediPanel.getVedi(o);
        if (vedi == null) {
            return null;
        }
        return vedi.cInfo;
    }

    public static ASM6809FileMaster getAsmInfo(Component o) {
        VEdiFoundationPanel vedi = VediPanel.getVedi(o);
        if (vedi == null) {
            return null;
        }
        return vedi.asmInfo;
    }

    void scanForVersion(File[] fList) {
        for (File file : fList) {
            String fileNameOnly = file.getName();
            if (file.isDirectory()) {
                File directory = new File(file.getAbsoluteFile().toString());
                File[] fList2 = directory.listFiles();
                this.scanForVersion(fList2);
                continue;
            }
            if (!fileNameOnly.toLowerCase().endsWith(".c") && !fileNameOnly.toLowerCase().endsWith(".h")) continue;
            String fname = file.getAbsolutePath();
            Vector<String> lines = UtilityString.readTextFileToString(file, true);
            for (int i = 0; i < lines.size(); ++i) {
                String line = lines.elementAt(i);
                if (!line.toLowerCase().contains("#define") || !line.toLowerCase().contains(" version ")) continue;
                this.extractVersion(line.toUpperCase(), file);
            }
        }
    }

    void extractVersion(String line, File file) {
        if (this.currentProject == null) {
            return;
        }
        line = UtilityString.replace(line, "#DEFINE", "");
        line = UtilityString.replace(line, "VERSION", "");
        line = UtilityString.replace(line, "  ", " ");
        line = line.trim();
        String[] split = line.split(" ");
        if ((split = VediPanel.removeEmpty(split)).length == 0) {
            return;
        }
        String v = split[0];
        v = UtilityString.replace(v, "\"", "");
        if ((v = UtilityString.replace(v, " ", "")).length() == 0) {
            return;
        }
        this.currentProject.setVersion(v);
        this.printMessage("Project version set to: " + v + " (found in: " + file.getAbsolutePath() + ")");
    }

    class RSTInfo {
        MemInfo[] m = new MemInfo[65536];
        ArrayList<StackFrame> stackFrames = new ArrayList();

        void setLabel(int a, String l) {
            if (l.startsWith("LBE")) {
                return;
            }
            if (l.startsWith("LBB")) {
                return;
            }
            if (l.startsWith("Lscope")) {
                return;
            }
            if (l.startsWith("LFBB")) {
                return;
            }
            if (l.startsWith("Ltext")) {
                return;
            }
            this.m[a].label = this.m[a].label.length() != 0 ? (this.m[a].label.startsWith("_") ? this.m[a].label + ":" + l : l + ":" + this.m[a].label) : l;
        }

        void setType(int a, int t, int l) {
            this.m[a].type = t;
            this.m[a].typeLength = l;
            while (a + l > 65536) {
                --l;
            }
            String comment = this.m[a].comment;
            for (int i = 1; i < l; ++i) {
                this.m[a + i].type = t;
                this.m[a + i].typeLength = l - i;
                if (this.m[a + 1].comment.length() == 0) continue;
                if (comment.length() != 0) {
                    comment = comment + ":";
                }
                comment = comment + this.m[a + i].comment;
            }
            this.setComment(a, comment);
        }

        void setLineComment(int a, String c) {
            this.m[a].lineComment = c;
        }

        void setComment(int a, String c) {
            String test = c.trim();
            test = UtilityString.replace(test, ",", "").trim();
            test = UtilityString.replace(test, ":", "").trim();
            test = UtilityString.replace(test, ";", "").trim();
            test = UtilityString.replace(test, "*", "").trim();
            test = UtilityString.replace(test, "i", "").trim();
            test = UtilityString.replace(test, "0", "").trim();
            test = UtilityString.replace(test, "1", "").trim();
            test = UtilityString.replace(test, "2", "").trim();
            test = UtilityString.replace(test, "3", "").trim();
            test = UtilityString.replace(test, "4", "").trim();
            test = UtilityString.replace(test, "5", "").trim();
            test = UtilityString.replace(test, "6", "").trim();
            test = UtilityString.replace(test, "7", "").trim();
            test = UtilityString.replace(test, "8", "").trim();
            test = UtilityString.replace(test, "9", "").trim();
            test = UtilityString.replace(test, "D", "").trim();
            test = UtilityString.replace(test, "i", "").trim();
            test = UtilityString.replace(test, "t", "").trim();
            test = UtilityString.replace(test, ".", "").trim();
            test = UtilityString.replaceCI(test, "tmp", "").trim();
            if ((test = UtilityString.replace(test, "::", ":").trim()).startsWith(":")) {
                test = test.substring(1);
            }
            if (test.endsWith(":")) {
                test = test.substring(0, test.length() - 1);
            }
            if (test.startsWith(",")) {
                test = test.substring(1);
            }
            if (test.startsWith(";")) {
                test = test.substring(1);
            }
            if (test.endsWith(",")) {
                test = test.substring(0, test.length() - 1);
            }
            if ((test = test.trim()).trim().length() == 0) {
                return;
            }
            this.m[a].comment = c.trim();
            this.m[a].comment = UtilityString.replace(this.m[a].comment, "::", ":").trim();
            if (this.m[a].comment.endsWith(";")) {
                this.m[a].comment = this.m[a].comment.substring(0, this.m[a].comment.length() - 1).trim();
            }
            if (this.m[a].comment.endsWith(":")) {
                this.m[a].comment = this.m[a].comment.substring(0, this.m[a].comment.length() - 1).trim();
            }
            if (this.m[a].comment.endsWith(",")) {
                this.m[a].comment = this.m[a].comment.substring(0, this.m[a].comment.length() - 1).trim();
            }
            if (this.m[a].comment.startsWith(";")) {
                this.m[a].comment = this.m[a].comment.substring(1).trim();
            }
            if (this.m[a].comment.startsWith(":")) {
                this.m[a].comment = this.m[a].comment.substring(1).trim();
            }
            if (this.m[a].comment.startsWith(",")) {
                this.m[a].comment = this.m[a].comment.substring(1).trim();
            }
            this.m[a].comment = this.m[a].comment.trim();
        }

        void setCInfo(int a, CInfoBlock c) {
            if (this.m[a].cInfo != null) {
                this.m[a].cInfo.lineString = this.m[a].cInfo.lineString + c.lineString;
                this.m[a].cInfo.hasBreakpoint = this.m[a].cInfo.hasBreakpoint || c.hasBreakpoint;
            } else {
                this.m[a].cInfo = c;
            }
        }

        RSTInfo() {
            for (int i = 0; i < 65536; ++i) {
                this.m[i] = new MemInfo(i);
            }
        }
    }

    class StackFrame {
        int start = 0;
        int end = 0;
        int size = 0;
        String frameReg = "u";
        ArrayList<ValueName> defs = new ArrayList();

        StackFrame() {
        }
    }

    class ValueName {
        int size = 0;
        int value = 0;
        String name = "";

        ValueName() {
        }
    }

    class MemInfo {
        String label = "";
        int address = 0;
        int type = 0;
        int typeLength = 1;
        String comment = "";
        String lineComment = "";
        CInfoBlock cInfo = null;
        boolean hasBreakpoint = false;

        MemInfo(int i) {
            this.address = i;
        }
    }

    class CInfoBlock {
        boolean hasBreakpoint = false;
        int lineNo = 0;
        String file = "";
        String lineString = "";
        int address = 0;

        CInfoBlock() {
        }
    }

    class ASMap {
        public ArrayList<Area> area = new ArrayList();
        int initializedRAMUsage = 0;
        int unInitializedRAMUsage = 0;
        int headerLength = 0;
        int romLength = 0;
        int highestUsedRAM = 0;

        ASMap() {
        }
    }

    class GlobalSymbols {
        public int relativeAddress = 0;
        public int absolutAddress = 0;
        public String fullname = "";

        public GlobalSymbols(String line, Area a) {
            line = UtilityString.replaceWhiteSpaces(line, " ");
            line = UtilityString.replace(line, "  ", " ").trim();
            String[] split = line.split(" ");
            split = VediPanel.removeEmpty(split);
            this.absolutAddress = DASM6809.toNumber("$" + split[0]);
            this.relativeAddress = this.absolutAddress - a.baseAddress;
            this.fullname = split[1];
        }
    }

    class Area {
        public int baseAddress = 0;
        public int length = 0;
        public String fullname = "";
        ArrayList<GlobalSymbols> symbols = new ArrayList();
        public boolean isROM = true;

        public Area(String line) {
            line = UtilityString.replaceWhiteSpaces(line, " ");
            line = UtilityString.replace(line, "  ", " ").trim();
            String[] split = line.split(" ");
            split = VediPanel.removeEmpty(split);
            this.fullname = split[0];
            this.baseAddress = DASM6809.toNumber("$" + split[1]);
            this.length = DASM6809.toNumber("$" + split[2]);
            this.isROM = this.baseAddress < 51200;
        }
    }

    static class CompileResult {
        String inputFile;
        String intermediateFile;
        String codeData;
        String dataData;
        String bssData;
        String bssInitData;
        boolean initializedDataFound = false;
        String pathOnly;
        String nameOnly;
        ArrayList<String> usedIncludeFiles = new ArrayList();
        HashMap<String, String> varMapping = new HashMap();
        HashMap<String, String> libCCalls = new HashMap();

        CompileResult() {
        }
    }

    class HistoryEntry {
        public int line;
        public String file;

        public HistoryEntry(String f, int l) {
            this.line = l;
            this.file = f;
        }
    }

    class TreeEntry {
        int type;
        String name;
        Path pathAndName;
        DefaultMutableTreeNode myNode;
        DefaultMutableTreeNode parentNode;

        public TreeEntry(Path p) {
            this.pathAndName = p;
            this.type = p.toFile().isDirectory() ? 0 : 1;
            this.name = this.pathAndName.getFileName().toString();
        }

        public String toString() {
            return this.name;
        }
    }

    private class MyTreeCellEditor
    extends DefaultTreeCellEditor {
        public MyTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer) {
            super(tree, renderer);
        }

        @Override
        public Object getCellEditorValue() {
            String value = (String)super.getCellEditorValue();
            if (VediPanel.this.currentSelectedTreeLeaf == null) {
                return null;
            }
            VediPanel.this.changeFileName(VediPanel.this.currentSelectedTreeLeaf, value);
            return VediPanel.this.currentSelectedTreeLeaf;
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (this.lastPath != null && this.lastPath.getLastPathComponent() != null) {
                return super.isCellEditable(e) && ((TreeNode)this.lastPath.getLastPathComponent()).isLeaf();
            }
            return false;
        }
    }

    public class BreakpointTableModel
    extends AbstractTableModel {
        @Override
        public int getRowCount() {
            Set<Map.Entry<String, DebugCommentList>> entries = VediPanel.this.settings.allDebugComments.entrySet();
            Iterator<Map.Entry<String, DebugCommentList>> it = entries.iterator();
            int count = 0;
            while (it.hasNext()) {
                Map.Entry<String, DebugCommentList> entry = it.next();
                DebugCommentList dbclist = entry.getValue();
                String filename = entry.getKey();
                ArrayList<DebugComment> list2 = dbclist.getList();
                for (DebugComment dbc : list2) {
                    if (dbc.type != 1) continue;
                    ++count;
                }
            }
            return count;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        public DebugComment getDebugComment(int row) {
            Set<Map.Entry<String, DebugCommentList>> entries = VediPanel.this.settings.allDebugComments.entrySet();
            Iterator<Map.Entry<String, DebugCommentList>> it = entries.iterator();
            int count = 0;
            while (it.hasNext()) {
                Map.Entry<String, DebugCommentList> entry = it.next();
                DebugCommentList dbclist = entry.getValue();
                String filename = entry.getKey();
                ArrayList<DebugComment> list2 = dbclist.getList();
                for (DebugComment dbc : list2) {
                    if (dbc.type != 1) continue;
                    if (count == row) {
                        return dbc;
                    }
                    ++count;
                }
            }
            return null;
        }

        @Override
        public Object getValueAt(int row, int col) {
            DebugComment dbc = this.getDebugComment(row);
            if (dbc == null) {
                return "";
            }
            if (col == 0) {
                return dbc.file;
            }
            if (col == 1) {
                return dbc.beforLineNo + 1;
            }
            return "";
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "file";
            }
            if (column == 1) {
                return "line";
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public int getColWidth(int col) {
            if (col == 0) {
                return 200;
            }
            return 10;
        }

        public Color getBackground(int col) {
            if (col == 0) {
                return new Color(200, 255, 200, 255);
            }
            return null;
        }
    }

    public class WatchesTableModel
    extends AbstractTableModel {
        @Override
        public int getRowCount() {
            Set<Map.Entry<String, DebugCommentList>> entries = VediPanel.this.settings.allDebugComments.entrySet();
            Iterator<Map.Entry<String, DebugCommentList>> it = entries.iterator();
            int count = 0;
            while (it.hasNext()) {
                Map.Entry<String, DebugCommentList> entry = it.next();
                DebugCommentList dbclist = entry.getValue();
                String filename = entry.getKey();
                ArrayList<DebugComment> list2 = dbclist.getList();
                for (DebugComment dbc : list2) {
                    if (dbc.type != 2) continue;
                    ++count;
                }
            }
            return count;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        public DebugComment getDebugComment(int row) {
            Set<Map.Entry<String, DebugCommentList>> entries = VediPanel.this.settings.allDebugComments.entrySet();
            Iterator<Map.Entry<String, DebugCommentList>> it = entries.iterator();
            int count = 0;
            while (it.hasNext()) {
                Map.Entry<String, DebugCommentList> entry = it.next();
                DebugCommentList dbclist = entry.getValue();
                String filename = entry.getKey();
                ArrayList<DebugComment> list2 = dbclist.getList();
                for (DebugComment dbc : list2) {
                    if (dbc.type != 2) continue;
                    if (count == row) {
                        return dbc;
                    }
                    ++count;
                }
            }
            return null;
        }

        @Override
        public Object getValueAt(int row, int col) {
            DebugComment dbc = this.getDebugComment(row);
            if (dbc == null) {
                return "";
            }
            if (col == 0) {
                return dbc.varname;
            }
            if (col == 1) {
                return dbc.getSubtypeString();
            }
            return "";
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "name";
            }
            if (column == 1) {
                return "type";
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public int getColWidth(int col) {
            if (col == 0) {
                return 100;
            }
            return 100;
        }

        public Color getBackground(int col) {
            if (col == 0) {
                return new Color(200, 255, 200, 255);
            }
            return null;
        }
    }

    public class BookmarkTableModel
    extends AbstractTableModel {
        @Override
        public int getRowCount() {
            return 10;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return row;
            }
            Bookmark b = VediPanel.this.settings.bookmarks.get(row);
            if (b == null) {
                return "";
            }
            if (col == 1) {
                return b.name;
            }
            if (col == 2) {
                return b.lineNumber;
            }
            return "";
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "no";
            }
            if (column == 1) {
                return "file";
            }
            return "line";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public int getColWidth(int col) {
            if (col == 0) {
                return 10;
            }
            if (col == 1) {
                return 200;
            }
            return 10;
        }

        public Color getBackground(int col) {
            if (col == 0) {
                return new Color(200, 255, 200, 255);
            }
            return null;
        }
    }

    public class InventoryTableModel
    extends AbstractTableModel {
        @Override
        public int getRowCount() {
            return VediPanel.this.inventory.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row >= VediPanel.this.inventory.size()) {
                return "";
            }
            if (col == 0) {
                return VediPanel.this.inventory.get((int)row).line;
            }
            if (col == 1) {
                return VediPanel.this.inventory.get((int)row).name;
            }
            if (col == 2) {
                return EntityDefinition.SUBTYPE_NAMES[VediPanel.this.inventory.get((int)row).type];
            }
            return "";
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "line";
            }
            if (column == 1) {
                return "name";
            }
            if (column == 2) {
                return "type";
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int col) {
            if (col == 0) {
                return Integer.class;
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public int getColWidth(int col) {
            if (col == 0) {
                return 50;
            }
            if (col == 1) {
                return 180;
            }
            if (col == 2) {
                return 80;
            }
            return 10;
        }

        public Color getBackground(int col) {
            if (col == 0) {
                return new Color(200, 255, 200, 255);
            }
            return null;
        }
    }

    class InventoryEntry {
        public String name = "";
        public int line = 0;
        public int type = 0;

        public InventoryEntry(String n, int l, int t) {
            this.name = n;
            this.line = l;
            this.type = t;
        }
    }
}

