/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi.panels;

import de.malban.config.Configuration;
import de.malban.config.TinyLogInterface;
import de.malban.gui.panels.LogPanel;
import de.malban.vide.VideConfig;
import de.malban.vide.vedi.VEdiFoundationPanel;
import de.muntjak.tinylookandfeel.Theme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.GroupLayout;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class BinaryPanel
extends JPanel {
    VideConfig config = VideConfig.getConfig();
    LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    private JMenuItem mParentMenuItem = null;
    private int mClassSetting = 0;
    TinyLogInterface tinyLog = null;
    private String filename = "";
    boolean initError = false;
    byte[] data;
    VEdiFoundationPanel parent;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private boolean updateEnabled = false;
    private PropertyChangeListener pListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            BinaryPanel.this.updateMyUI();
        }
    };

    public void setParent(VEdiFoundationPanel p) {
        this.parent = p;
    }

    private void update() {
        this.jTable1.repaint();
    }

    public void correctTable() {
        this.jTable1.tableChanged(null);
        MemoryDumpTableModel model = (MemoryDumpTableModel)this.jTable1.getModel();
        for (int i = 0; i < model.getColumnCount(); ++i) {
            this.jTable1.getColumnModel().getColumn(i).setPreferredWidth(model.getColWidth(i));
        }
    }

    public void deinit() {
        this.removeUIListerner();
    }

    public BinaryPanel() {
        this.initComponents();
        this.setup();
        UIManager.addPropertyChangeListener(this.pListener);
        this.updateMyUI();
    }

    public boolean isInitError() {
        return this.initError;
    }

    public BinaryPanel(String fn, TinyLogInterface tl) {
        this.initComponents();
        this.filename = fn;
        try {
            this.setup();
        }
        catch (Throwable e) {
            this.initError = true;
        }
        if (this.initError) {
            this.deinit();
        }
    }

    public void setup() {
        Path path = Paths.get(this.filename, new String[0]);
        try {
            this.data = Files.readAllBytes(path);
        }
        catch (Throwable e) {
            this.log.addLog(e, LogPanel.WARN);
        }
        if (this.data == null) {
            this.data = new byte[0];
            return;
        }
        MemoryDumpTableModel model = new MemoryDumpTableModel();
        this.jTable1.setModel(model);
        this.jTable1.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
                if (table.getModel() instanceof MemoryDumpTableModel) {
                    MemoryDumpTableModel model = (MemoryDumpTableModel)table.getModel();
                    if (isSelected) {
                        this.setBackground(table.getSelectionBackground());
                        this.setForeground(table.getSelectionForeground());
                    } else {
                        Color back = model.getBackground(col);
                        if (back != null) {
                            this.setBackground(back);
                        } else {
                            this.setBackground(table.getBackground());
                        }
                        this.setForeground(table.getForeground());
                    }
                }
                return this;
            }
        });
        this.correctTable();
    }

    JTable buildTable() {
        JTable table = new JTable();
        return table;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = this.buildTable();
        this.jTable1.setFont(new Font("Courier", 0, 12));
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable1.setShowHorizontalLines(false);
        this.jTable1.setShowVerticalLines(false);
        this.jScrollPane1.setViewportView(this.jTable1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 742, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 522, Short.MAX_VALUE));
    }

    public void goAddress(int address) {
        int row = address / 16;
        if (row == -1) {
            return;
        }
        this.jTable1.setRowSelectionInterval(row, row);
        BinaryPanel.scrollToVisible(this.jTable1, row, 0);
    }

    public static void scrollToVisible(JTable table, int rowIndex, int vColIndex) {
        JViewport vp = (JViewport)table.getParent();
        int bottomIndex = table.getModel().getRowCount() - 1;
        table.setRowSelectionInterval(bottomIndex, bottomIndex);
        table.changeSelection(bottomIndex, 0, false, false);
        Rectangle r = table.getCellRect(bottomIndex - 1, 0, true);
        int vph = vp.getExtentSize().height;
        r.y += vph;
        table.scrollRectToVisible(r);
        int currentSelectedRow = table.getSelectedRow();
        try {
            table.changeSelection(rowIndex, 0, false, false);
            if (rowIndex > currentSelectedRow) {
                r = table.getCellRect(rowIndex - 1, 0, true);
                vph = vp.getExtentSize().height;
                r.y += vph;
                table.scrollRectToVisible(r);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    String asciiDump(int row) {
        String dump = "";
        for (int i = 0; i < 16; ++i) {
            int v = this.data[row * 16 + i] & 0xFF;
            dump = v < 32 ? dump + "." : (v < 127 ? dump + (char)v : dump + "~");
        }
        return dump;
    }

    public void updateValues(boolean forceUpdate) {
        if (!forceUpdate && !this.updateEnabled) {
            return;
        }
        this.update();
    }

    public void setUpdateEnabled(boolean b) {
        this.updateEnabled = b;
    }

    public void removeUIListerner() {
        UIManager.removePropertyChangeListener(this.pListener);
    }

    void updateMyUI() {
        int fontSize = Theme.textFieldFont.getFont().getSize();
        int rowHeight = fontSize + 2;
        this.jTable1.setRowHeight(rowHeight);
    }

    public class MemoryDumpTableModel
    extends AbstractTableModel {
        @Override
        public int getRowCount() {
            return BinaryPanel.this.data.length / 16;
        }

        @Override
        public int getColumnCount() {
            return 18;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return "$" + String.format("%04X", this.getAddress(row, col) + 1);
            }
            if (col == 17) {
                return BinaryPanel.this.asciiDump(row);
            }
            return "$" + String.format("%02X", BinaryPanel.this.data[this.getAddress(row, col)]);
        }

        public int getAddress(int row, int col) {
            return row * 16 + (col - 1);
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "Address";
            }
            if (column == 17) {
                return "Chars";
            }
            return "$" + String.format("%02X", (column & 0xFF) - 1);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public int getColWidth(int col) {
            if (col == 0) {
                return 40;
            }
            if (col == 17) {
                return 120;
            }
            return 20;
        }

        public Color getBackground(int col) {
            if (col == 0) {
                return BinaryPanel.this.config.tableAddress;
            }
            return null;
        }
    }
}

