/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi.peeper;

import de.malban.util.XMLSupport;
import de.malban.vide.vedi.peeper.ASMLine;
import de.malban.vide.vedi.peeper.OnePeepRule;
import de.malban.vide.vedi.peeper.PeepRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class CombinedPeepRule {
    public static final int COMBINE_UNKOWN = -1;
    public static final int COMBINE_AND = 0;
    public static final int COMBINE_OR = 1;
    ArrayList<OnePeepRule> rules = new ArrayList();
    int combiner = -1;
    int line = 0;

    CombinedPeepRule doClone() {
        CombinedPeepRule ret = new CombinedPeepRule();
        ret.combiner = this.combiner;
        ret.line = this.line;
        for (OnePeepRule rule : this.rules) {
            ret.rules.add(rule.doClone());
        }
        ret.reorderList();
        return ret;
    }

    CombinedPeepRule() {
    }

    public CombinedPeepRule(OnePeepRule r1, int o) {
        this.rules.add(r1);
        this.line = o;
        this.combiner = 0;
    }

    public CombinedPeepRule(OnePeepRule r1, int c, int o) {
        this.rules.add(r1);
        this.line = o;
        this.combiner = c;
    }

    public CombinedPeepRule(OnePeepRule r1, OnePeepRule r2, int c, int o) {
        this.rules.add(r1);
        this.rules.add(r2);
        this.line = o;
        this.combiner = c;
    }

    public CombinedPeepRule(OnePeepRule r1, OnePeepRule r2, OnePeepRule r3, int c, int o) {
        this.rules.add(r1);
        this.rules.add(r2);
        this.rules.add(r3);
        this.line = o;
        this.combiner = c;
    }

    public CombinedPeepRule(OnePeepRule r1, OnePeepRule r2, OnePeepRule r3, OnePeepRule r4, int c, int o) {
        this.rules.add(r1);
        this.rules.add(r2);
        this.rules.add(r3);
        this.rules.add(r4);
        this.line = o;
        this.combiner = c;
    }

    public CombinedPeepRule(OnePeepRule r1, OnePeepRule r2, OnePeepRule r3, OnePeepRule r4, OnePeepRule r5, int c, int o) {
        this.rules.add(r1);
        this.rules.add(r2);
        this.rules.add(r3);
        this.rules.add(r4);
        this.rules.add(r5);
        this.line = o;
        this.combiner = c;
    }

    public CombinedPeepRule(ArrayList<OnePeepRule> r, int c, int o) {
        this.rules = r;
        this.line = o;
        this.combiner = c;
    }

    public boolean isNotRelevant(ASMLine line) {
        return line.mnenomic.length() == 0 && line.label.length() == 0;
    }

    boolean isTrue(ASMLine line, PeepRule parent) {
        if (this.combiner == 0) {
            for (OnePeepRule r : this.rules) {
                if (r.isTrue(line, parent)) continue;
                return false;
            }
            return true;
        }
        if (this.combiner == 1) {
            for (OnePeepRule r : this.rules) {
                if (!r.isTrue(line, parent)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static CombinedPeepRule readRuleFromXML(StringBuilder xml, XMLSupport xmlSupport) {
        if (xml == null) {
            return null;
        }
        if (xml.length() == 0) {
            return null;
        }
        CombinedPeepRule rule = new CombinedPeepRule();
        if (rule.fromXML(xml, xmlSupport)) {
            return rule;
        }
        return null;
    }

    public boolean toXML(StringBuilder s, String tag) {
        s.append("<").append(tag).append(">\n");
        boolean ok = true;
        ok &= XMLSupport.addElement(s, "combiner", this.combiner);
        ok &= XMLSupport.addElement(s, "line", this.line);
        for (OnePeepRule rule : this.rules) {
            ok &= rule.toXML(s, "OneRule");
        }
        s.append("</").append(tag).append(">\n");
        return ok;
    }

    public boolean fromXML(StringBuilder xml, XMLSupport xmlSupport) {
        int errorCode = 0;
        this.rules = new ArrayList();
        this.combiner = xmlSupport.getIntElement("combiner", xml);
        errorCode |= xmlSupport.errorCode;
        this.line = xmlSupport.getIntElement("line", xml);
        errorCode |= xmlSupport.errorCode;
        OnePeepRule rule = null;
        do {
            xmlSupport.errorCode = 0;
            xmlSupport.beQuiet(true);
            rule = OnePeepRule.readRuleFromXML(xmlSupport.getXMLElement("OneRule", xml), xmlSupport);
            xmlSupport.beQuiet(false);
            if (rule != null) {
                errorCode |= xmlSupport.errorCode;
                this.rules.add(rule);
                continue;
            }
            xmlSupport.errorCode = 0;
        } while (rule != null);
        if (errorCode != 0) {
            this.rules = new ArrayList();
            return false;
        }
        this.reorderList();
        return true;
    }

    void reorderList() {
        Collections.sort(this.rules, new Comparator<OnePeepRule>(){

            @Override
            public int compare(OnePeepRule rule1, OnePeepRule rule2) {
                return rule1.order - rule2.order;
            }
        });
    }
}

