/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi.peeper;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.Windowable;
import de.malban.gui.components.CSAView;
import de.malban.gui.components.ModalInternalFrame;
import de.malban.vide.vedi.peeper.CombinedPeepRule;
import de.malban.vide.vedi.peeper.FilePeeper;
import de.malban.vide.vedi.peeper.OneResult;
import de.malban.vide.vedi.peeper.PeepEditJPanel;
import de.malban.vide.vedi.peeper.PeepRule;
import de.muntjak.tinylookandfeel.Theme;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;

public class PeepJPanel
extends JPanel
implements Windowable {
    private int mClassSetting = 0;
    PeepTableModel model = new PeepTableModel();
    private CSAView mParent = null;
    private JMenuItem mParentMenuItem = null;
    private PropertyChangeListener pListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PeepJPanel.this.updateMyUI();
        }
    };
    ModalInternalFrame modelDialog;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButtonOk;
    private JButton jButtonSave1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private PeepEditJPanel peepEditJPanel1;
    PeepRule currentPeeper = null;

    @Override
    public void closing() {
        this.deinit();
    }

    @Override
    public void setParentWindow(CSAView jpv) {
        this.mParent = jpv;
    }

    @Override
    public boolean isIcon() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return false;
        }
        return frame.getInternalFrame(this).isIcon();
    }

    @Override
    public void setIcon(boolean b) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return;
        }
        try {
            frame.getInternalFrame(this).setIcon(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void setMenuItem(JMenuItem item) {
        this.mParentMenuItem = item;
        this.mParentMenuItem.setText("C: Peephole config");
    }

    @Override
    public JMenuItem getMenuItem() {
        return this.mParentMenuItem;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    public void deinit() {
        this.removeUIListerner();
    }

    public void removeUIListerner() {
        UIManager.removePropertyChangeListener(this.pListener);
    }

    void updateMyUI() {
        int fontSize = Theme.textFieldFont.getFont().getSize();
        int rowHeight = fontSize + 2;
        this.jTable1.setRowHeight(rowHeight);
    }

    @Override
    public void deIconified() {
    }

    public PeepJPanel() {
        this.initComponents();
        FilePeeper fp = new FilePeeper();
        this.jTable1.setModel(this.model);
        UIManager.addPropertyChangeListener(this.pListener);
        this.updateMyUI();
        ListSelectionModel peeperSelectionModel = this.jTable1.getSelectionModel();
        peeperSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PeepJPanel.this.peeperSelectionChanged();
            }
        });
        this.peepEditJPanel1.setParent(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PeepJPanel.this.clearFields();
            }
        });
    }

    void refreshTable() {
        ++this.mClassSetting;
        FilePeeper.reorder();
        this.jTable1.tableChanged(null);
        --this.mClassSetting;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jButtonOk = new JButton();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.peepEditJPanel1 = new PeepEditJPanel();
        this.jButtonSave1 = new JButton();
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable1.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.jTable1);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 137, -2).addGap(0, 45, Short.MAX_VALUE)));
        this.jButtonOk.setText("Ok");
        this.jButtonOk.setName("ok");
        this.jButton1.setText("delete");
        this.jButton1.setToolTipText("delete selcted table entry");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeepJPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("add");
        this.jButton2.setToolTipText("add one rule");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeepJPanel.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButtonSave1.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_save.png")));
        this.jButtonSave1.setToolTipText("save peepHole list");
        this.jButtonSave1.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonSave1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeepJPanel.this.jButtonSave1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButton2, -2, 104, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -2, 102, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonSave1, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonOk)).addComponent(this.peepEditJPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.peepEditJPanel1, -1, 495, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonSave1, -2, 23, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOk).addComponent(this.jButton1).addComponent(this.jButton2))).addGap(0, 0, 0)));
    }

    private void jButtonSave1ActionPerformed(ActionEvent evt) {
        FilePeeper.saveAsXML();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        int selected = this.jTable1.getSelectedRow();
        if (selected != -1) {
            FilePeeper.peepers.remove(selected);
        }
        this.clearFields();
        this.refreshTable();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        PeepRule newRule = new PeepRule(FilePeeper.peepers.size(), "", "", 0, new ArrayList<CombinedPeepRule>(), new ArrayList<OneResult>());
        FilePeeper.peepers.add(newRule);
        this.currentPeeper = newRule;
        this.setFields();
        this.refreshTable();
    }

    public static boolean showEditPeepProperties() {
        ModalInternalFrame modal;
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        PeepJPanel panel = new PeepJPanel();
        ArrayList<JButton> eb = new ArrayList<JButton>();
        eb.add(panel.jButtonOk);
        panel.modelDialog = modal = new ModalInternalFrame("C: Peephole config", frame.getRootPane(), frame, panel, null, null, eb);
        modal.setVisible(true);
        String result = modal.getNamedExit();
        if (result.equals("ok")) {
            panel.saveChanges();
            return true;
        }
        return true;
    }

    void saveChanges() {
        String filename = Global.mainPathPrefix + "xml" + File.separator + "VidePeepholes.xml";
        FilePeeper.saveAsXML(filename);
    }

    void peeperSelectionChanged() {
        if (this.mClassSetting > 0) {
            return;
        }
        int selected = this.jTable1.getSelectedRow();
        if (selected == -1) {
            this.clearFields();
            return;
        }
        this.currentPeeper = FilePeeper.peepers.get(selected);
        this.setFields();
    }

    void clearFields() {
        this.currentPeeper = null;
        this.setFields();
    }

    void setFields() {
        this.peepEditJPanel1.setPeepRule(this.currentPeeper);
    }

    class PeepTableModel
    extends AbstractTableModel {
        private PeepTableModel() {
        }

        @Override
        public int getRowCount() {
            if (FilePeeper.peepers == null) {
                return 0;
            }
            return FilePeeper.peepers.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return FilePeeper.peepers.get((int)row).order;
            }
            if (col == 1) {
                return "" + FilePeeper.peepers.get((int)row).name;
            }
            if (col == 2) {
                return "" + FilePeeper.peepers.get((int)row).longName;
            }
            if (col == 3) {
                return FilePeeper.peepers.get((int)row).active;
            }
            return "";
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "#";
            }
            if (column == 1) {
                return "short";
            }
            if (column == 2) {
                return "long";
            }
            if (column == 3) {
                return "active";
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Integer.class;
            }
            if (columnIndex == 3) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 3;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 3) {
                FilePeeper.peepers.get((int)rowIndex).active = (Boolean)aValue;
            }
        }
    }
}

