/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi.project;

import de.malban.util.Utility;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;

public class FileChooserCellEditor
extends DefaultCellEditor
implements TableCellEditor {
    private static final int CLICK_COUNT_TO_START = 2;
    private JButton button;
    private JFileChooser fileChooser;
    private String file = "";

    public FileChooserCellEditor(String home) {
        super(new JTextField());
        this.setClickCountToStart(2);
        this.button = new JButton();
        this.button.setBackground(Color.white);
        this.button.setFont(this.button.getFont().deriveFont(0));
        this.button.setBorder(null);
        this.fileChooser = new JFileChooser();
        this.fileChooser.setCurrentDirectory(new File(home));
    }

    @Override
    public Object getCellEditorValue() {
        return this.file;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.file = "";
        if (value != null) {
            this.file = value.toString();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (FileChooserCellEditor.this.file.trim().length() > 0) {
                    FileChooserCellEditor.this.fileChooser.setSelectedFile(new File(FileChooserCellEditor.this.file));
                }
                if (FileChooserCellEditor.this.fileChooser.showOpenDialog(FileChooserCellEditor.this.button) == 0) {
                    FileChooserCellEditor.this.file = FileChooserCellEditor.this.fileChooser.getSelectedFile().getAbsolutePath();
                    FileChooserCellEditor.this.file = Utility.makeVideRelative(FileChooserCellEditor.this.file);
                }
                FileChooserCellEditor.this.fireEditingStopped();
            }
        });
        this.button.setText(this.file);
        return this.button;
    }
}

