/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi.project;

import de.malban.Global;
import de.malban.util.Utility;
import de.malban.vide.vedi.project.FileProperties;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

public class FilePropertiesPool {
    public static final String DEFAULT_XML_NAME = new String("FileProperties.xml");
    private String mFileName = DEFAULT_XML_NAME;
    private String pathName = null;
    private HashMap<String, FileProperties> mFileProperties = new HashMap();
    private HashMap<String, String> mKlassenMap = new HashMap();

    public FilePropertiesPool(String p, String name) {
        this.pathName = p;
        this.mFileName = name;
        this.init();
    }

    public FilePropertiesPool() {
        this.init();
    }

    public void setFilename(String n) {
        this.mFileName = n;
    }

    private boolean init() {
        try {
            return this.load();
        }
        catch (Throwable e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Load Error FileProperties...", 1);
            return false;
        }
    }

    public boolean load() {
        File f = this.pathName == null ? new File(Utility.makeVideAbsolute("xml" + File.separator + this.mFileName)) : new File(Utility.makeVideAbsolute(this.pathName) + File.separator + this.mFileName);
        if (!f.exists()) {
            return false;
        }
        if (this.pathName == null) {
            if (!new File(this.mFileName).exists()) {
                return false;
            }
            this.mFileProperties = FileProperties.getHashMapFromXML(this.mFileName);
        } else {
            this.mFileProperties = FileProperties.getHashMapFromXML(this.mFileName, Utility.makeVideAbsolute(this.pathName));
        }
        return true;
    }

    public void save() {
        if (this.pathName == null) {
            FileProperties.saveCollectionAsXML(this.mFileName, this.mFileProperties.values());
        } else if (Utility.isFilenameRelative(this.pathName)) {
            FileProperties.saveCollectionAsXML(Global.mainPathPrefix + this.pathName, this.mFileName, this.mFileProperties.values());
        } else {
            FileProperties.saveCollectionAsXML(this.pathName, this.mFileName, this.mFileProperties.values());
        }
        this.buildKlassenMap();
    }

    public void remove(FileProperties st) {
        this.mFileProperties.remove(st.mName);
    }

    public void put(FileProperties st) {
        this.mFileProperties.remove(st.mName);
        this.mFileProperties.put(st.mName, st);
    }

    public void putAsNew(FileProperties st) {
        this.mFileProperties.put(st.mName, st);
    }

    public FileProperties get(String key) {
        return this.mFileProperties.get(key);
    }

    public HashMap<String, FileProperties> getHashMap() {
        return this.mFileProperties;
    }

    private void buildKlassenMap() {
        this.mKlassenMap = new HashMap();
        Set<Map.Entry<String, FileProperties>> entries = this.mFileProperties.entrySet();
        for (Map.Entry<String, FileProperties> entry : entries) {
            FileProperties value = entry.getValue();
            this.mKlassenMap.put(value.mClass, value.mClass);
        }
    }

    public HashMap<String, String> getKlassenHashMap() {
        this.buildKlassenMap();
        return this.mKlassenMap;
    }

    public HashMap<String, FileProperties> getMapForKlasse(String klasse) {
        HashMap<String, FileProperties> ret = new HashMap<String, FileProperties>();
        Set<Map.Entry<String, FileProperties>> entries = this.mFileProperties.entrySet();
        for (Map.Entry<String, FileProperties> entry : entries) {
            FileProperties value = entry.getValue();
            if (!value.mClass.equalsIgnoreCase(klasse)) continue;
            ret.put(value.mName, value);
        }
        return ret;
    }
}

