/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi.project;

import de.malban.Global;
import de.malban.util.UtilityString;
import de.malban.vide.vedi.project.ProjectPropertiesXMLHandler;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class ProjectProperties {
    public String projectPrefix = "";
    protected String mClass = "";
    public String mName = "";
    protected String mProjectName = "";
    protected String mDirectoryName = "";
    protected String mOldPath = "";
    protected String mMainFile = "";
    protected String mDescription = "";
    protected String mVersion = "";
    protected String mAuthor = "";
    protected String mBankswitching = "";
    protected boolean mcreateBankswitchCode = false;
    protected boolean mcreateGameLoopCode = false;
    protected int mNumberOfBanks = 0;
    protected Vector<String> mBankMainFiles = new Vector();
    protected int mExtras = 0;
    protected int mFileVersion = 0;
    protected String mProjectPreScriptClass = "";
    protected String mProjectPreScriptName = "";
    protected String mProjectPostScriptClass = "";
    protected String mProjectPostScriptName = "";
    protected Vector<String> mBankDefines = new Vector();
    protected String mWheelName = "";
    protected boolean mIsCProject = false;
    protected boolean mIsPeerCProject = false;
    protected String mCFLAGS = "-O3 -g -fverbose-asm -mint8 -fno-strict-overflow -msoft-reg-count=0 -quiet -IC/include";
    protected boolean mCDebugging = true;
    protected boolean mCPeephole = true;
    protected boolean mCKeepEnriched = false;
    protected boolean mCRumInlined = false;
    private static ProjectPropertiesXMLHandler XMLHANDLER = new ProjectPropertiesXMLHandler();

    public String getName() {
        return this.mName;
    }

    public void setName(String n) {
        this.mName = n;
    }

    public String getCClass() {
        return this.mClass;
    }

    public void setCClass(String c) {
        this.mClass = c;
    }

    public String getProjectName() {
        return this.mProjectName;
    }

    public void setProjectName(String ProjectName) {
        this.mProjectName = ProjectName;
    }

    public String getDirectoryName() {
        return this.mDirectoryName;
    }

    public void setDirectoryName(String DirectoryName) {
        this.mDirectoryName = DirectoryName;
    }

    public String getOldPath() {
        return this.mOldPath;
    }

    public void setOldPath(String Path2) {
        this.mOldPath = Path2;
    }

    public String getMainFile() {
        return this.mMainFile;
    }

    public void setMainFile(String MainFile) {
        this.mMainFile = MainFile;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String Description) {
        this.mDescription = Description;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public void setVersion(String Version2) {
        this.mVersion = Version2;
    }

    public String getAuthor() {
        return this.mAuthor;
    }

    public void setAuthor(String Author) {
        this.mAuthor = Author;
    }

    public String getBankswitching() {
        return this.mBankswitching;
    }

    public void setBankswitching(String Bankswitching) {
        this.mBankswitching = Bankswitching;
    }

    public boolean getcreateBankswitchCode() {
        return this.mcreateBankswitchCode;
    }

    public void setcreateBankswitchCode(boolean createBankswitchCode) {
        this.mcreateBankswitchCode = createBankswitchCode;
    }

    public boolean getcreateGameLoopCode() {
        return this.mcreateGameLoopCode;
    }

    public void setcreateGameLoopCode(boolean createGameLoopCode) {
        this.mcreateGameLoopCode = createGameLoopCode;
    }

    public int getNumberOfBanks() {
        return this.mNumberOfBanks;
    }

    public void setNumberOfBanks(int NumberOfBanks) {
        this.mNumberOfBanks = NumberOfBanks;
    }

    public int getFileVersion() {
        return this.mFileVersion;
    }

    public void setFileVersion(int fv) {
        this.mFileVersion = fv;
    }

    public Vector<String> getBankMainFiles() {
        return this.mBankMainFiles;
    }

    public void setBankMainFiles(Vector<String> BankMainFiles) {
        this.mBankMainFiles = BankMainFiles;
    }

    public int getExtras() {
        return this.mExtras;
    }

    public void setExtras(int Extras) {
        this.mExtras = Extras;
    }

    public String getProjectPreScriptClass() {
        return this.mProjectPreScriptClass;
    }

    public void setProjectPreScriptClass(String ProjectPreScriptClass) {
        this.mProjectPreScriptClass = ProjectPreScriptClass;
    }

    public String getProjectPreScriptName() {
        return this.mProjectPreScriptName;
    }

    public void setProjectPreScriptName(String ProjectPreScriptName) {
        this.mProjectPreScriptName = ProjectPreScriptName;
    }

    public String getProjectPostScriptClass() {
        return this.mProjectPostScriptClass;
    }

    public void setProjectPostScriptClass(String ProjectPostScriptClass) {
        this.mProjectPostScriptClass = ProjectPostScriptClass;
    }

    public String getProjectPostScriptName() {
        return this.mProjectPostScriptName;
    }

    public void setProjectPostScriptName(String ProjectPostScriptName) {
        this.mProjectPostScriptName = ProjectPostScriptName;
    }

    public Vector<String> getBankDefines() {
        return this.mBankDefines;
    }

    public void setBankDefines(Vector<String> BankDefines) {
        this.mBankDefines = BankDefines;
    }

    public String getWheelName() {
        return this.mWheelName;
    }

    public void setWheelName(String WheelName) {
        this.mWheelName = WheelName;
    }

    public boolean getIsPeerCProject() {
        return this.mIsPeerCProject;
    }

    public void setIsPeerCProject(boolean IsCProject) {
        this.mIsPeerCProject = IsCProject;
    }

    public boolean getIsCProject() {
        return this.mIsCProject;
    }

    public void setIsCProject(boolean IsCProject) {
        this.mIsCProject = IsCProject;
    }

    public boolean getIsCRumInlined() {
        return false;
    }

    public void setIsCRumInlined(boolean CRumInlined) {
        this.mCRumInlined = CRumInlined;
    }

    public boolean getIsCDebugging() {
        return this.mCDebugging;
    }

    public void setIsCDebugging(boolean b) {
        this.mCDebugging = b;
    }

    public boolean getIsCPeephole() {
        return this.mCPeephole;
    }

    public void setIsCPeephole(boolean b) {
        this.mCPeephole = b;
    }

    public boolean getIsCKeepEnriched() {
        return this.mCKeepEnriched;
    }

    public void setIsCKeepEnriched(boolean b) {
        this.mCKeepEnriched = b;
    }

    public String getCFLAGS() {
        return this.mCFLAGS;
    }

    public void setCFLAGS(String CFLAGS) {
        this.mCFLAGS = CFLAGS;
    }

    private String exportXML() {
        int i;
        this.mFileVersion = 2;
        StringBuffer s = new StringBuffer();
        s.append("\t<ProjectProperties>\n");
        s.append("\t\t<Class>" + UtilityString.toXML(this.mClass) + "</Class>\n");
        s.append("\t\t<Name>" + UtilityString.toXML(this.mName) + "</Name>\n");
        s.append("\t\t<FileVersion>" + this.mFileVersion + "</FileVersion>\n");
        s.append("\t\t<ProjectName>" + UtilityString.toXML(this.mProjectName) + "</ProjectName>\n");
        s.append("\t\t<DirectoryName>" + UtilityString.toXML(this.mDirectoryName) + "</DirectoryName>\n");
        s.append("\t\t<Path>" + UtilityString.toXML(this.mOldPath) + "</Path>\n");
        s.append("\t\t<MainFile>" + UtilityString.toXML(this.mMainFile) + "</MainFile>\n");
        s.append("\t\t<Description>" + UtilityString.toXML(this.mDescription) + "</Description>\n");
        s.append("\t\t<Version>" + UtilityString.toXML(this.mVersion) + "</Version>\n");
        s.append("\t\t<Author>" + UtilityString.toXML(this.mAuthor) + "</Author>\n");
        s.append("\t\t<Bankswitching>" + UtilityString.toXML(this.mBankswitching) + "</Bankswitching>\n");
        s.append("\t\t<createBankswitchCode>" + this.mcreateBankswitchCode + "</createBankswitchCode>\n");
        s.append("\t\t<createGameLoopCode>" + this.mcreateGameLoopCode + "</createGameLoopCode>\n");
        s.append("\t\t<NumberOfBanks>" + this.mNumberOfBanks + "</NumberOfBanks>\n");
        s.append("\t\t<BankMainFiless>\n");
        for (i = 0; i < this.mBankMainFiles.size(); ++i) {
            s.append("\t\t\t<BankMainFiles>" + UtilityString.toXML(this.mBankMainFiles.elementAt(i)) + "</BankMainFiles>\n");
        }
        s.append("\t\t</BankMainFiless>\n");
        s.append("\t\t<Extras>" + this.mExtras + "</Extras>\n");
        s.append("\t\t<ProjectPreScriptClass>" + UtilityString.toXML(this.mProjectPreScriptClass) + "</ProjectPreScriptClass>\n");
        s.append("\t\t<ProjectPreScriptName>" + UtilityString.toXML(this.mProjectPreScriptName) + "</ProjectPreScriptName>\n");
        s.append("\t\t<ProjectPostScriptClass>" + UtilityString.toXML(this.mProjectPostScriptClass) + "</ProjectPostScriptClass>\n");
        s.append("\t\t<ProjectPostScriptName>" + UtilityString.toXML(this.mProjectPostScriptName) + "</ProjectPostScriptName>\n");
        s.append("\t\t<BankDefiness>\n");
        for (i = 0; i < this.mBankDefines.size(); ++i) {
            s.append("\t\t\t<BankDefines>" + UtilityString.toXML(this.mBankDefines.elementAt(i)) + "</BankDefines>\n");
        }
        s.append("\t\t</BankDefiness>\n");
        s.append("\t\t<WheelName>" + UtilityString.toXML(this.mWheelName) + "</WheelName>\n");
        s.append("\t\t<IsCDebugging>" + this.mCDebugging + "</IsCDebugging>\n");
        s.append("\t\t<IsCPeephole>" + this.mCPeephole + "</IsCPeephole>\n");
        s.append("\t\t<IsCKeepEnriched>" + this.mCKeepEnriched + "</IsCKeepEnriched>\n");
        s.append("\t\t<IsCProject>" + this.mIsCProject + "</IsCProject>\n");
        s.append("\t\t<IsPeerCProject>" + this.mIsPeerCProject + "</IsPeerCProject>\n");
        s.append("\t\t<CFLAGS>" + UtilityString.toXML(this.mCFLAGS) + "</CFLAGS>\n");
        s.append("\t\t<IsCRumInlined>" + this.mCRumInlined + "</IsCRumInlined>\n");
        s.append("\t</ProjectProperties>\n");
        return s.toString();
    }

    public String toString() {
        return this.mName;
    }

    public static ProjectPropertiesXMLHandler getXMLParseHandler() {
        return XMLHANDLER;
    }

    public static boolean saveCollectionAsXML(String filename, Collection<ProjectProperties> col) {
        return ProjectProperties.saveCollectionAsXML(Global.mainPathPrefix, filename, col);
    }

    public static boolean saveCollectionAsXML(String pathName, String filename, Collection<ProjectProperties> col) {
        if (!pathName.endsWith(File.separator)) {
            pathName = pathName + File.separator;
        }
        try {
            PrintWriter pw = new PrintWriter(pathName + filename, "UTF-8");
            pw.print("<?xml version=\"1.0\"?>\n");
            pw.print("<AllProjectProperties>\n");
            for (ProjectProperties item : col) {
                pw.print(item.exportXML());
            }
            pw.print("</AllProjectProperties>\n");
            pw.close();
        }
        catch (IOException e) {
            System.err.println(e.toString() + " saveCollectionAsXML(): " + pathName + filename);
            return false;
        }
        return true;
    }

    public static HashMap<String, ProjectProperties> getHashMapFromXML(String filename) {
        return ProjectProperties.getHashMapFromXML(filename, Global.mainPathPrefix);
    }

    public static HashMap<String, ProjectProperties> getHashMapFromXML(String filename, String path) {
        if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        HashMap<String, ProjectProperties> filters = new HashMap<String, ProjectProperties>();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            ProjectPropertiesXMLHandler h = ProjectProperties.getXMLParseHandler();
            saxParser.parse(path + filename, (DefaultHandler)h);
            filters = h.getLastHashMap();
        }
        catch (Throwable e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.toString(), "ProjectProperties Load Error...", 1);
        }
        return filters;
    }
}

