/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi.project;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.HotKey;
import de.malban.gui.Windowable;
import de.malban.gui.components.CSAView;
import de.malban.gui.components.ModalInternalFrame;
import de.malban.gui.dialogs.InternalFrameFileChoser;
import de.malban.util.Utility;
import de.malban.util.UtilityFiles;
import de.malban.util.UtilityString;
import de.malban.vide.VideConfig;
import de.malban.vide.script.ExecutionDescriptor;
import de.malban.vide.script.ExportData;
import de.malban.vide.script.ExportDataPool;
import de.malban.vide.script.ScriptDataPanel;
import de.malban.vide.vecx.cartridge.Cartridge;
import de.malban.vide.vedi.VediPanel;
import de.malban.vide.vedi.project.FileChooserCellEditor;
import de.malban.vide.vedi.project.ProjectProperties;
import de.malban.vide.vedi.project.ProjectPropertiesPool;
import de.muntjak.tinylookandfeel.Theme;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;

public class ProjectPropertiesPanel
extends JPanel
implements Windowable {
    private ExportDataPool mExportDataPool;
    BankMainTableModel model = new BankMainTableModel();
    private ProjectProperties mProjectProperties = new ProjectProperties();
    private ProjectPropertiesPool mProjectPropertiesPool;
    private int mClassSetting = 0;
    private CSAView mParent = null;
    private JMenuItem mParentMenuItem = null;
    boolean wasMainSetManually = false;
    private JButton jButtonCancel;
    private JButton jButtonCreate;
    private JButton jButtonDelete;
    private JButton jButtonFileSelect1;
    private JButton jButtonNew;
    private JButton jButtonPost;
    private JButton jButtonPre;
    private JButton jButtonSave;
    private JButton jButtonSaveAsNew;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox10;
    private JCheckBox jCheckBox11;
    private JCheckBox jCheckBox16;
    private JCheckBox jCheckBox2;
    private JCheckBox jCheckBox3;
    private JCheckBox jCheckBox4;
    private JCheckBox jCheckBox5;
    private JCheckBox jCheckBox6;
    private JCheckBox jCheckBox7;
    private JCheckBox jCheckBox8;
    private JCheckBox jCheckBox9;
    private JCheckBox jCheckBoxCDebugging;
    private JCheckBox jCheckBoxCKeepEnriched;
    private JCheckBox jCheckBoxCPeepholing;
    private JCheckBox jCheckBoxCProject;
    private JCheckBox jCheckBoxCProject1;
    private JCheckBox jCheckBoxCRumInlined;
    private JCheckBox jCheckBoxCreateGameLoop;
    private JCheckBox jCheckBoxCreateSupportCode;
    private JCheckBox jCheckBoxFlashSupport;
    private JComboBox jComboBoxBankswitch;
    private JComboBox jComboBoxBankswitchNumber;
    private JComboBox jComboBoxImager;
    private JComboBox jComboBoxKlasse;
    private JComboBox jComboBoxName;
    private JComboBox jComboBoxPostClass;
    private JComboBox jComboBoxPostName;
    private JComboBox jComboBoxPreClass;
    private JComboBox jComboBoxPreName;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTabbedPane jTabbedPane1;
    private JTable jTable1;
    private JTextArea jTextAreaDescription;
    private JTextField jTextFieldAuthor;
    private JTextField jTextFieldCFLAGS;
    private JTextField jTextFieldKlasse;
    private JTextField jTextFieldMainFile;
    private JTextField jTextFieldName;
    private JTextField jTextFieldPath;
    private JTextField jTextFieldProjectName;
    private JTextField jTextFieldVersion;
    ModalInternalFrame modelDialog;
    private PropertyChangeListener pListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ProjectPropertiesPanel.this.updateMyUI();
        }
    };

    @Override
    public void closing() {
        this.deinit();
    }

    @Override
    public void setParentWindow(CSAView jpv) {
        this.mParent = jpv;
    }

    @Override
    public boolean isIcon() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return false;
        }
        return frame.getInternalFrame(this).isIcon();
    }

    @Override
    public void setIcon(boolean b) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return;
        }
        try {
            frame.getInternalFrame(this).setIcon(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void setMenuItem(JMenuItem item) {
        this.mParentMenuItem = item;
        this.mParentMenuItem.setText("Editor: Project properties");
    }

    @Override
    public JMenuItem getMenuItem() {
        return this.mParentMenuItem;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    public void deinit() {
        this.removeUIListerner();
    }

    public ProjectPropertiesPanel() {
        ++this.mClassSetting;
        this.initComponents();
        if (Global.getOSName().toUpperCase().contains("MAC")) {
            HotKey.addMacDefaults(this.jTextFieldProjectName);
            HotKey.addMacDefaults(this.jTextFieldPath);
            HotKey.addMacDefaults(this.jTextFieldMainFile);
            HotKey.addMacDefaults(this.jTextFieldVersion);
            HotKey.addMacDefaults(this.jTextFieldAuthor);
            HotKey.addMacDefaults(this.jTextAreaDescription);
            HotKey.addMacDefaults(this.jTextFieldCFLAGS);
        }
        this.initScripts();
        this.initImager();
        this.jComboBoxImager.setSelectedIndex(-1);
        this.mProjectPropertiesPool = new ProjectPropertiesPool();
        this.resetConfigPool(false, "");
        this.jPanel1.setVisible(false);
        this.jTable1.setModel(this.model);
        String ppath = this.mProjectProperties.mOldPath.toString();
        if (ppath.length() != 0) {
            ppath = ppath + File.separator;
        }
        this.jTable1.getColumnModel().getColumn(1).setCellEditor(new FileChooserCellEditor(ppath + this.mProjectProperties.mProjectName));
        this.jTable1.getColumnModel().getColumn(0).setPreferredWidth(5);
        this.jTable1.getColumnModel().getColumn(0).setWidth(5);
        this.jTable1.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.jTable1.getColumnModel().getColumn(1).setWidth(200);
        this.jTable1.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.jTable1.getColumnModel().getColumn(1).setWidth(100);
        this.jCheckBoxCRumInlined.setVisible(false);
        --this.mClassSetting;
        UIManager.addPropertyChangeListener(this.pListener);
        this.updateMyUI();
    }

    public ProjectPropertiesPanel(ProjectProperties currentProject) {
        ++this.mClassSetting;
        this.initComponents();
        this.initScripts();
        this.initImager();
        this.jComboBoxImager.setSelectedIndex(-1);
        this.jButtonCreate.setText("ok");
        this.jButtonCreate.setName("ok");
        this.mProjectProperties = currentProject;
        this.setAllFromCurrent();
        this.jPanel1.setVisible(false);
        this.jTextFieldProjectName.setEnabled(false);
        this.jTextFieldPath.setEnabled(false);
        this.jButtonFileSelect1.setEnabled(false);
        this.jTable1.setModel(this.model);
        String ppath = this.mProjectProperties.mOldPath.toString();
        if (ppath.length() != 0) {
            ppath = ppath + File.separator;
        }
        this.jTable1.getColumnModel().getColumn(1).setCellEditor(new FileChooserCellEditor(ppath + this.mProjectProperties.mProjectName));
        this.jTable1.getColumnModel().getColumn(0).setPreferredWidth(5);
        this.jTable1.getColumnModel().getColumn(0).setWidth(5);
        this.jTable1.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.jTable1.getColumnModel().getColumn(1).setWidth(200);
        this.jCheckBoxCRumInlined.setVisible(false);
        --this.mClassSetting;
        UIManager.addPropertyChangeListener(this.pListener);
        this.updateMyUI();
    }

    void adjustMains() {
        if (this.mClassSetting > 0) {
            return;
        }
        if (this.mProjectProperties.mBankMainFiles == null) {
            this.mProjectProperties.mBankMainFiles = new Vector();
        }
        if (this.mProjectProperties.mBankDefines == null) {
            this.mProjectProperties.mBankDefines = new Vector();
        }
        int number = 0;
        if (this.jComboBoxBankswitch.getSelectedIndex() != 0) {
            if (this.jComboBoxBankswitch.getSelectedIndex() == 1) {
                number = 2;
            } else if (this.jComboBoxBankswitch.getSelectedIndex() == 2) {
                number = 4;
            } else if (this.jComboBoxBankswitch.getSelectedIndex() == 3) {
                number = this.jComboBoxBankswitchNumber.getSelectedIndex() + 1;
            }
        }
        if (this.mProjectProperties.mBankMainFiles.size() > number) {
            while (this.mProjectProperties.mBankMainFiles.size() > number) {
                this.mProjectProperties.mBankMainFiles.removeElementAt(this.mProjectProperties.mBankMainFiles.size() - 1);
            }
        } else {
            while (this.mProjectProperties.mBankMainFiles.size() < number) {
                this.mProjectProperties.mBankMainFiles.addElement("");
            }
        }
        if (this.mProjectProperties.mBankDefines.size() > number) {
            while (this.mProjectProperties.mBankDefines.size() > number) {
                this.mProjectProperties.mBankDefines.removeElementAt(this.mProjectProperties.mBankDefines.size() - 1);
            }
        } else {
            while (this.mProjectProperties.mBankDefines.size() < number) {
                this.mProjectProperties.mBankDefines.addElement("");
            }
        }
        this.jTable1.tableChanged(null);
        String ppath = this.mProjectProperties.mOldPath.toString();
        if (ppath.length() != 0) {
            ppath = ppath + File.separator;
        }
        this.jTable1.getColumnModel().getColumn(1).setCellEditor(new FileChooserCellEditor(ppath + this.mProjectProperties.mProjectName));
        this.jTable1.getColumnModel().getColumn(0).setPreferredWidth(5);
        this.jTable1.getColumnModel().getColumn(0).setWidth(5);
        this.jTable1.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.jTable1.getColumnModel().getColumn(1).setWidth(200);
    }

    private void resetConfigPool(boolean select, String klasseToSet) {
        ++this.mClassSetting;
        Collection<String> collectionKlasse = this.mProjectPropertiesPool.getKlassenHashMap().values();
        Iterator<String> iterKlasse = collectionKlasse.iterator();
        int i = 0;
        String klasse = "";
        this.jComboBoxKlasse.removeAllItems();
        while (iterKlasse.hasNext()) {
            String item = iterKlasse.next();
            this.jComboBoxKlasse.addItem(item);
            if (select) {
                if (klasseToSet.length() == 0) {
                    if (i == 0) {
                        this.jComboBoxKlasse.setSelectedIndex(i);
                        this.jTextFieldKlasse.setText(item);
                        klasse = item;
                    }
                } else if (klasseToSet.equalsIgnoreCase(item)) {
                    this.jComboBoxKlasse.setSelectedIndex(i);
                    this.jTextFieldKlasse.setText(item);
                    klasse = item;
                }
            }
            ++i;
        }
        if (select && klasse.length() == 0 && this.jComboBoxKlasse.getItemCount() > 0) {
            this.jComboBoxKlasse.setSelectedIndex(0);
            this.jTextFieldKlasse.setText(this.jComboBoxKlasse.getSelectedItem().toString());
            klasse = this.jComboBoxKlasse.getSelectedItem().toString();
        }
        if (!select) {
            this.jComboBoxKlasse.setSelectedIndex(-1);
        }
        Collection<ProjectProperties> colC = this.mProjectPropertiesPool.getMapForKlasse(klasse).values();
        Iterator<ProjectProperties> iterC = colC.iterator();
        this.jComboBoxName.removeAllItems();
        i = 0;
        while (iterC.hasNext()) {
            ProjectProperties item = iterC.next();
            this.jComboBoxName.addItem(item.mName);
            if (i == 0 && select) {
                this.jComboBoxName.setSelectedIndex(0);
                this.mProjectProperties = this.mProjectPropertiesPool.get(item.mName);
                this.setAllFromCurrent();
            }
            ++i;
        }
        if (!select) {
            this.jComboBoxName.setSelectedIndex(-1);
        }
        --this.mClassSetting;
    }

    private void clearAll() {
        ++this.mClassSetting;
        this.mProjectProperties = new ProjectProperties();
        this.setAllFromCurrent();
        --this.mClassSetting;
    }

    private void setAllFromCurrent() {
        ++this.mClassSetting;
        this.jComboBoxKlasse.setSelectedItem(this.mProjectProperties.mClass);
        this.jTextFieldKlasse.setText(this.mProjectProperties.mClass);
        this.jComboBoxName.setSelectedItem(this.mProjectProperties.mName);
        this.jTextFieldName.setText(this.mProjectProperties.mName);
        this.jCheckBoxCProject.setSelected(this.mProjectProperties.mIsCProject);
        this.jTextFieldCFLAGS.setText(this.mProjectProperties.mCFLAGS);
        this.jTextFieldAuthor.setText(this.mProjectProperties.mAuthor);
        this.jTextAreaDescription.setText(this.mProjectProperties.mDescription);
        this.jTextFieldPath.setText(this.mProjectProperties.mOldPath);
        this.jTextFieldProjectName.setText(this.mProjectProperties.mProjectName);
        if (!this.jCheckBoxCProject1.isSelected()) {
            this.jTextFieldMainFile.setText(this.mProjectProperties.mMainFile);
        }
        this.jTextFieldVersion.setText(this.mProjectProperties.mVersion);
        this.jCheckBoxCreateSupportCode.setSelected(this.mProjectProperties.mcreateBankswitchCode);
        this.jCheckBoxCreateGameLoop.setSelected(this.mProjectProperties.mcreateGameLoopCode);
        if (this.mProjectProperties.mBankswitching != null && this.mProjectProperties.mBankswitching.trim().length() != 0) {
            this.jComboBoxBankswitch.setSelectedItem(this.mProjectProperties.mBankswitching);
        } else {
            this.jComboBoxBankswitch.setSelectedIndex(-1);
        }
        if (this.mProjectProperties.mNumberOfBanks != 0) {
            this.jComboBoxBankswitchNumber.setSelectedItem("" + this.mProjectProperties.mNumberOfBanks);
        } else {
            this.jComboBoxBankswitchNumber.setSelectedIndex(-1);
        }
        this.jCheckBox1.setSelected((this.mProjectProperties.mExtras & Cartridge.FLAG_VEC_VOICE) == Cartridge.FLAG_VEC_VOICE);
        this.jCheckBox2.setSelected((this.mProjectProperties.mExtras & Cartridge.FLAG_DS2430A) == Cartridge.FLAG_DS2430A);
        this.jCheckBox16.setSelected((this.mProjectProperties.mExtras & Cartridge.FLAG_MICROCHIP) == Cartridge.FLAG_MICROCHIP);
        this.jCheckBox3.setSelected((this.mProjectProperties.mExtras & Cartridge.FLAG_LIGHTPEN1) == Cartridge.FLAG_LIGHTPEN1);
        this.jCheckBox4.setSelected((this.mProjectProperties.mExtras & Cartridge.FLAG_LIGHTPEN2) == Cartridge.FLAG_LIGHTPEN2);
        this.jCheckBox5.setSelected((this.mProjectProperties.mExtras & Cartridge.FLAG_IMAGER) == Cartridge.FLAG_IMAGER);
        this.jCheckBox6.setSelected((this.mProjectProperties.mExtras & Cartridge.FLAG_EXTREME_MULTI) == Cartridge.FLAG_EXTREME_MULTI);
        this.jCheckBox7.setSelected((this.mProjectProperties.mExtras & Cartridge.FLAG_VEC_VOX) == Cartridge.FLAG_VEC_VOX);
        this.jCheckBox8.setSelected((this.mProjectProperties.mExtras & Cartridge.FLAG_DS2431) == Cartridge.FLAG_DS2431);
        this.jCheckBox9.setSelected((this.mProjectProperties.mExtras & Cartridge.FLAG_SID) == Cartridge.FLAG_SID);
        this.jCheckBox10.setSelected((this.mProjectProperties.mExtras & Cartridge.FLAG_48K) == Cartridge.FLAG_48K);
        this.jCheckBoxFlashSupport.setSelected((this.mProjectProperties.mExtras & Cartridge.FLAG_FLASH_SUPPORT) == Cartridge.FLAG_FLASH_SUPPORT);
        this.jCheckBox11.setSelected((this.mProjectProperties.mExtras & Cartridge.FLAG_44_PEER_BS) == Cartridge.FLAG_44_PEER_BS);
        this.jCheckBoxCProject1.setSelected(this.mProjectProperties.mIsPeerCProject);
        this.jComboBoxImager.setEnabled(this.jCheckBox5.isSelected());
        if (this.jCheckBox5.isSelected()) {
            this.jComboBoxImager.setSelectedIndex(-1);
            if (this.mProjectProperties.mWheelName != null) {
                for (int i = 0; i < this.jComboBoxImager.getItemCount(); ++i) {
                    if (!this.jComboBoxImager.getItemAt(i).toString().equals(this.mProjectProperties.mWheelName)) continue;
                    this.jComboBoxImager.setSelectedIndex(i);
                    break;
                }
            }
        }
        this.jCheckBoxCPeepholing.setEnabled(this.jCheckBoxCProject1.isSelected());
        this.jCheckBoxCDebugging.setEnabled(this.jCheckBoxCProject1.isSelected());
        this.jCheckBoxCKeepEnriched.setEnabled(this.jCheckBoxCProject1.isSelected());
        this.jCheckBoxCRumInlined.setEnabled(false);
        this.jCheckBoxCRumInlined.setVisible(false);
        this.jCheckBoxCDebugging.setSelected(this.mProjectProperties.mCDebugging);
        this.jCheckBoxCPeepholing.setSelected(this.mProjectProperties.mCPeephole);
        this.jCheckBoxCKeepEnriched.setSelected(this.mProjectProperties.mCKeepEnriched);
        this.jCheckBoxCRumInlined.setSelected(false);
        this.enableASM(!this.mProjectProperties.mIsPeerCProject);
        this.initScripts();
        --this.mClassSetting;
    }

    private void readAllToCurrent() {
        this.mProjectProperties.mCDebugging = this.jCheckBoxCDebugging.isSelected();
        this.mProjectProperties.mCPeephole = this.jCheckBoxCPeepholing.isSelected();
        this.mProjectProperties.mCKeepEnriched = this.jCheckBoxCKeepEnriched.isSelected();
        this.mProjectProperties.mCRumInlined = this.jCheckBoxCRumInlined.isSelected();
        this.mProjectProperties.mClass = "Project";
        this.mProjectProperties.mName = this.jTextFieldProjectName.getText();
        this.mProjectProperties.mIsCProject = this.jCheckBoxCProject.isSelected();
        this.mProjectProperties.mIsPeerCProject = this.jCheckBoxCProject1.isSelected();
        this.mProjectProperties.mCFLAGS = this.jTextFieldCFLAGS.getText();
        this.mProjectProperties.mAuthor = this.jTextFieldAuthor.getText();
        this.mProjectProperties.mDescription = this.jTextAreaDescription.getText();
        this.mProjectProperties.mDirectoryName = "";
        this.mProjectProperties.mOldPath = Utility.makeVideRelative(this.jTextFieldPath.getText());
        this.mProjectProperties.mProjectName = this.jTextFieldProjectName.getText();
        this.mProjectProperties.mMainFile = this.jTextFieldMainFile.getText();
        this.mProjectProperties.mVersion = this.jTextFieldVersion.getText();
        this.mProjectProperties.mBankswitching = this.jComboBoxBankswitch.getSelectedItem() != null ? this.jComboBoxBankswitch.getSelectedItem().toString() : "none";
        this.mProjectProperties.mNumberOfBanks = this.jComboBoxBankswitchNumber.getSelectedItem() != null ? Integer.parseInt(this.jComboBoxBankswitchNumber.getSelectedItem().toString()) : 1;
        this.mProjectProperties.mcreateBankswitchCode = this.jCheckBoxCreateSupportCode.isSelected();
        this.mProjectProperties.mcreateGameLoopCode = this.jCheckBoxCreateGameLoop.isSelected();
        this.mProjectProperties.mProjectPreScriptClass = "";
        if (this.jComboBoxPreClass.getSelectedIndex() != -1) {
            this.mProjectProperties.mProjectPreScriptClass = this.jComboBoxPreClass.getSelectedItem().toString();
        }
        this.mProjectProperties.mProjectPreScriptName = "";
        if (this.jComboBoxPreName.getSelectedIndex() != -1) {
            this.mProjectProperties.mProjectPreScriptName = this.jComboBoxPreName.getSelectedItem().toString();
        }
        this.mProjectProperties.mProjectPostScriptClass = "";
        if (this.jComboBoxPostClass.getSelectedIndex() != -1) {
            this.mProjectProperties.mProjectPostScriptClass = this.jComboBoxPostClass.getSelectedItem().toString();
        }
        this.mProjectProperties.mProjectPostScriptName = "";
        if (this.jComboBoxPostName.getSelectedIndex() != -1) {
            this.mProjectProperties.mProjectPostScriptName = this.jComboBoxPostName.getSelectedItem().toString();
        }
        if (this.mProjectProperties.mBankswitching.equals("none")) {
            this.mProjectProperties.mBankMainFiles.clear();
            this.mProjectProperties.mBankMainFiles.addElement(this.mProjectProperties.mMainFile);
            this.mProjectProperties.mBankDefines.clear();
            this.mProjectProperties.mBankDefines.addElement("");
        }
        this.mProjectProperties.mWheelName = "";
        if (this.jCheckBox5.isSelected() && this.jComboBoxImager.getSelectedIndex() >= 0) {
            this.mProjectProperties.mWheelName = this.jComboBoxImager.getSelectedItem().toString();
        }
        int extra = 0;
        if (this.jCheckBox1.isSelected()) {
            extra += Cartridge.FLAG_VEC_VOICE;
        }
        if (this.jCheckBox2.isSelected()) {
            extra += Cartridge.FLAG_DS2430A;
        }
        if (this.jCheckBox16.isSelected()) {
            extra += Cartridge.FLAG_MICROCHIP;
        }
        if (this.jCheckBox3.isSelected()) {
            extra += Cartridge.FLAG_LIGHTPEN1;
        }
        if (this.jCheckBox4.isSelected()) {
            extra += Cartridge.FLAG_LIGHTPEN2;
        }
        if (this.jCheckBox5.isSelected()) {
            extra += Cartridge.FLAG_IMAGER;
        }
        if (this.jCheckBox6.isSelected()) {
            extra += Cartridge.FLAG_EXTREME_MULTI;
        }
        if (this.jCheckBox7.isSelected()) {
            extra += Cartridge.FLAG_VEC_VOX;
        }
        if (this.jCheckBox8.isSelected()) {
            extra += Cartridge.FLAG_DS2431;
        }
        if (this.jCheckBox9.isSelected()) {
            extra += Cartridge.FLAG_SID;
        }
        if (this.jCheckBox10.isSelected()) {
            extra += Cartridge.FLAG_48K;
        }
        if (this.jCheckBoxFlashSupport.isSelected()) {
            extra += Cartridge.FLAG_FLASH_SUPPORT;
        }
        if (this.jCheckBox11.isSelected()) {
            extra += Cartridge.FLAG_44_PEER_BS;
        }
        if (this.jComboBoxBankswitch.getSelectedIndex() == 2) {
            extra += Cartridge.FLAG_BS_PB6_IRQ;
        }
        this.mProjectProperties.mExtras = extra;
    }

    private ProjectProperties getProject() {
        return this.mProjectProperties;
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel6 = new JPanel();
        this.jTextFieldPath = new JTextField();
        this.jTextFieldVersion = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaDescription = new JTextArea();
        this.jLabel2 = new JLabel();
        this.jTextFieldAuthor = new JTextField();
        this.jButtonFileSelect1 = new JButton();
        this.jLabel7 = new JLabel();
        this.jTextFieldProjectName = new JTextField();
        this.jTextFieldMainFile = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jComboBoxBankswitch = new JComboBox();
        this.jCheckBoxCreateSupportCode = new JCheckBox();
        this.jComboBoxBankswitchNumber = new JComboBox();
        this.jPanel1 = new JPanel();
        this.jComboBoxKlasse = new JComboBox();
        this.jComboBoxName = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jTextFieldKlasse = new JTextField();
        this.jButtonNew = new JButton();
        this.jButtonSave = new JButton();
        this.jButtonSaveAsNew = new JButton();
        this.jButtonDelete = new JButton();
        this.jPanel5 = new JPanel();
        this.jCheckBox1 = new JCheckBox();
        this.jCheckBox2 = new JCheckBox();
        this.jCheckBox3 = new JCheckBox();
        this.jCheckBox4 = new JCheckBox();
        this.jCheckBox5 = new JCheckBox();
        this.jCheckBox6 = new JCheckBox();
        this.jCheckBox7 = new JCheckBox();
        this.jCheckBox16 = new JCheckBox();
        this.jComboBoxImager = new JComboBox();
        this.jCheckBox8 = new JCheckBox();
        this.jCheckBox9 = new JCheckBox();
        this.jCheckBox10 = new JCheckBox();
        this.jCheckBoxCDebugging = new JCheckBox();
        this.jCheckBoxCPeepholing = new JCheckBox();
        this.jCheckBoxCKeepEnriched = new JCheckBox();
        this.jCheckBoxCRumInlined = new JCheckBox();
        this.jCheckBoxFlashSupport = new JCheckBox();
        this.jCheckBox11 = new JCheckBox();
        this.jButtonPre = new JButton();
        this.jLabel6 = new JLabel();
        this.jComboBoxPostName = new JComboBox();
        this.jLabel10 = new JLabel();
        this.jComboBoxPostClass = new JComboBox();
        this.jButtonPost = new JButton();
        this.jComboBoxPreClass = new JComboBox();
        this.jComboBoxPreName = new JComboBox();
        this.jScrollPane2 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jButtonCreate = new JButton();
        this.jButtonCancel = new JButton();
        this.jCheckBoxCreateGameLoop = new JCheckBox();
        this.jCheckBoxCProject = new JCheckBox();
        this.jTextFieldCFLAGS = new JTextField();
        this.jLabel11 = new JLabel();
        this.jCheckBoxCProject1 = new JCheckBox();
        this.setPreferredSize(new Dimension(900, 500));
        this.jTextFieldPath.setPreferredSize(new Dimension(6, 21));
        this.jTextFieldVersion.setText("1.0");
        this.jTextFieldVersion.setPreferredSize(new Dimension(22, 21));
        this.jTextAreaDescription.setColumns(20);
        this.jTextAreaDescription.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextAreaDescription);
        this.jLabel2.setText("Version");
        this.jTextFieldAuthor.setPreferredSize(new Dimension(6, 21));
        this.jButtonFileSelect1.setText("...");
        this.jButtonFileSelect1.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonFileSelect1.setPreferredSize(new Dimension(17, 21));
        this.jButtonFileSelect1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesPanel.this.jButtonFileSelect1ActionPerformed(evt);
            }
        });
        this.jLabel7.setText("Path");
        this.jTextFieldProjectName.setPreferredSize(new Dimension(6, 21));
        this.jTextFieldProjectName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ProjectPropertiesPanel.this.jTextFieldProjectNameFocusLost(evt);
            }
        });
        this.jTextFieldProjectName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesPanel.this.jTextFieldProjectNameActionPerformed(evt);
            }
        });
        this.jTextFieldProjectName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ProjectPropertiesPanel.this.jTextFieldProjectNameKeyReleased(evt);
            }
        });
        this.jTextFieldMainFile.setPreferredSize(new Dimension(6, 21));
        this.jLabel5.setText("Name");
        this.jLabel8.setText("Main file");
        this.jLabel9.setText("Author");
        this.jLabel1.setText("Description");
        this.jComboBoxBankswitch.setModel(new DefaultComboBoxModel<String>(new String[]{"none", "2 bank standard", "4 bank PB6/IRQ", "VecFlash (up to 32 banks)"}));
        this.jComboBoxBankswitch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesPanel.this.jComboBoxBankswitchActionPerformed(evt);
            }
        });
        this.jCheckBoxCreateSupportCode.setText("create bankswitch code");
        this.jComboBoxBankswitchNumber.setModel(new DefaultComboBoxModel<String>(new String[]{"1"}));
        this.jComboBoxBankswitchNumber.setEnabled(false);
        this.jComboBoxBankswitchNumber.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesPanel.this.jComboBoxBankswitchNumberActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jComboBoxKlasse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesPanel.this.jComboBoxKlasseActionPerformed(evt);
            }
        });
        this.jComboBoxName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesPanel.this.jComboBoxNameActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Name");
        this.jLabel4.setText("Class");
        this.jButtonNew.setText("New");
        this.jButtonNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesPanel.this.jButtonNewActionPerformed(evt);
            }
        });
        this.jButtonSave.setText("Save");
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesPanel.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jButtonSaveAsNew.setText("Save as new");
        this.jButtonSaveAsNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesPanel.this.jButtonSaveAsNewActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesPanel.this.jButtonDeleteActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel3)).addGap(16, 16, 16).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldName, GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldKlasse, GroupLayout.Alignment.LEADING)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxKlasse, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBoxName, 0, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonSave).addComponent(this.jButtonNew)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonSaveAsNew).addComponent(this.jButtonDelete)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonSave).addComponent(this.jButtonSaveAsNew))).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxKlasse, -2, -1, -2).addComponent(this.jButtonNew)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxName, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jTextFieldKlasse, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldName, -2, -1, -2)))))));
        this.jCheckBox1.setText("VecVoice");
        this.jCheckBox2.setText("DS2430A");
        this.jCheckBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesPanel.this.jCheckBox2ActionPerformed(evt);
            }
        });
        this.jCheckBox3.setText("Lightpen 1");
        this.jCheckBox3.setToolTipText("Lightpen Port 1");
        this.jCheckBox3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesPanel.this.jCheckBox3ActionPerformed(evt);
            }
        });
        this.jCheckBox4.setText("Lightpen 2");
        this.jCheckBox4.setToolTipText("Lightpen Port 2");
        this.jCheckBox4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesPanel.this.jCheckBox4ActionPerformed(evt);
            }
        });
        this.jCheckBox5.setText("3d Imager");
        this.jCheckBox5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesPanel.this.jCheckBox5ActionPerformed(evt);
            }
        });
        this.jCheckBox6.setText("extreme multi");
        this.jCheckBox6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesPanel.this.jCheckBox6ActionPerformed(evt);
            }
        });
        this.jCheckBox7.setText("VecVox");
        this.jCheckBox16.setText("11AA010");
        this.jCheckBox16.setToolTipText("Microchip 11AA010");
        this.jCheckBox16.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesPanel.this.jCheckBox16ActionPerformed(evt);
            }
        });
        this.jComboBoxImager.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesPanel.this.jComboBoxImagerActionPerformed(evt);
            }
        });
        this.jCheckBox8.setText("DS2431");
        this.jCheckBox8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesPanel.this.jCheckBox8ActionPerformed(evt);
            }
        });
        this.jCheckBox9.setText("SID");
        this.jCheckBox9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesPanel.this.jCheckBox9ActionPerformed(evt);
            }
        });
        this.jCheckBox10.setText("48k ROM");
        this.jCheckBox10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesPanel.this.jCheckBox10ActionPerformed(evt);
            }
        });
        this.jCheckBoxCDebugging.setText("C debugging");
        this.jCheckBoxCDebugging.setEnabled(false);
        this.jCheckBoxCDebugging.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesPanel.this.jCheckBoxCDebuggingActionPerformed(evt);
            }
        });
        this.jCheckBoxCPeepholing.setText("C peepholing");
        this.jCheckBoxCPeepholing.setEnabled(false);
        this.jCheckBoxCPeepholing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesPanel.this.jCheckBoxCPeepholingActionPerformed(evt);
            }
        });
        this.jCheckBoxCKeepEnriched.setText("C keep enriched");
        this.jCheckBoxCKeepEnriched.setEnabled(false);
        this.jCheckBoxCKeepEnriched.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesPanel.this.jCheckBoxCKeepEnrichedActionPerformed(evt);
            }
        });
        this.jCheckBoxCRumInlined.setText("C Rum inlined");
        this.jCheckBoxCRumInlined.setToolTipText("<html>\nRum functions inlined -> not supported! <BR>\nRum functions as \"functions\"...\n</html>");
        this.jCheckBoxCRumInlined.setEnabled(false);
        this.jCheckBoxCRumInlined.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesPanel.this.jCheckBoxCRumInlinedActionPerformed(evt);
            }
        });
        this.jCheckBoxFlashSupport.setText("Flash support");
        this.jCheckBoxFlashSupport.setToolTipText("SST39SF020A - and only \"barely\"");
        this.jCheckBoxFlashSupport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesPanel.this.jCheckBoxFlashSupportActionPerformed(evt);
            }
        });
        this.jCheckBox11.setText("44k+4 BS");
        this.jCheckBox11.setToolTipText("Special Peer Mode, 48k usage, PB6 bankswitched, 4 kB shared RAM");
        this.jCheckBox11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesPanel.this.jCheckBox11ActionPerformed(evt);
            }
        });
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox6).addComponent(this.jCheckBox5)).addGap(30, 30, 30).addComponent(this.jComboBoxImager, -2, 109, -2)).addComponent(this.jCheckBoxCRumInlined).addComponent(this.jCheckBoxCDebugging).addComponent(this.jCheckBox8).addComponent(this.jCheckBox4).addComponent(this.jCheckBox3).addComponent(this.jCheckBoxCKeepEnriched).addComponent(this.jCheckBoxCPeepholing).addGroup(jPanel5Layout.createSequentialGroup().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox2).addComponent(this.jCheckBox1).addComponent(this.jCheckBox7).addComponent(this.jCheckBox16)).addGap(18, 18, 18).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox11, -2, 93, -2).addComponent(this.jCheckBox10, -2, 93, -2).addComponent(this.jCheckBox9).addComponent(this.jCheckBoxFlashSupport, -2, 134, -2)))).addContainerGap(18, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox1).addComponent(this.jCheckBox9)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox7).addComponent(this.jCheckBox10)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox2).addComponent(this.jCheckBoxFlashSupport)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox16).addComponent(this.jCheckBox11)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox4).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox6)).addGroup(jPanel5Layout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.jComboBoxImager, -1, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxCDebugging).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxCPeepholing).addGap(0, 0, 0).addComponent(this.jCheckBoxCKeepEnriched, -2, 19, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxCRumInlined).addContainerGap(49, Short.MAX_VALUE)));
        this.jButtonPre.setText("script");
        this.jButtonPre.setPreferredSize(new Dimension(90, 21));
        this.jButtonPre.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesPanel.this.jButtonPreActionPerformed(evt);
            }
        });
        this.jLabel6.setText("Pre build commands");
        this.jComboBoxPostName.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel10.setText("Post build commands");
        this.jComboBoxPostClass.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxPostClass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesPanel.this.jComboBoxPostClassActionPerformed(evt);
            }
        });
        this.jButtonPost.setText("script");
        this.jButtonPost.setPreferredSize(new Dimension(90, 21));
        this.jButtonPost.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesPanel.this.jButtonPostActionPerformed(evt);
            }
        });
        this.jComboBoxPreClass.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxPreClass.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ProjectPropertiesPanel.this.jComboBoxPreClassItemStateChanged(evt);
            }
        });
        this.jComboBoxPreName.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null}, {null}, {null}, {null}}, new String[]{"Main for Bank"}){
            Class[] types;
            {
                this.types = new Class[]{String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.jTable1.setAutoResizeMode(3);
        this.jScrollPane2.setViewportView(this.jTable1);
        this.jButtonCreate.setText("create");
        this.jButtonCreate.setName("create");
        this.jButtonCreate.setPreferredSize(new Dimension(63, 21));
        this.jButtonCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesPanel.this.jButtonCreateActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("cancel");
        this.jButtonCancel.setName("cancel");
        this.jButtonCancel.setPreferredSize(new Dimension(63, 21));
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesPanel.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jCheckBoxCreateGameLoop.setText("create game loop");
        this.jCheckBoxCProject.setText("C - Project");
        this.jCheckBoxCProject.setEnabled(false);
        this.jCheckBoxCProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesPanel.this.jCheckBoxCProjectActionPerformed(evt);
            }
        });
        this.jTextFieldCFLAGS.setText("-O3 -mint8 -msoft-reg-count=0 -quiet -IC/include");
        this.jTextFieldCFLAGS.setPreferredSize(new Dimension(6, 21));
        this.jLabel11.setText("CFLAGS");
        this.jCheckBoxCProject1.setText("PeerC - Project");
        this.jCheckBoxCProject1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesPanel.this.jCheckBoxCProject1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup().addGap(6, 6, 6).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addGroup(jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel7).addComponent(this.jLabel8).addComponent(this.jLabel9).addComponent(this.jLabel1)).addGap(61, 61, 61).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextFieldCFLAGS, -2, 340, -2)).addComponent(this.jTextFieldMainFile, -2, 169, -2).addComponent(this.jTextFieldAuthor, -2, 169, -2).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jCheckBoxCProject).addGap(43, 43, 43).addComponent(this.jCheckBoxCProject1)).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jTextFieldPath, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFileSelect1, -2, -1, -2)).addGroup(GroupLayout.Alignment.LEADING, jPanel6Layout.createSequentialGroup().addComponent(this.jTextFieldProjectName, -2, 169, -2).addGap(51, 51, 51).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextFieldVersion, -2, 58, -2))).addComponent(this.jScrollPane1, -2, 401, -2).addComponent(this.jScrollPane2, -2, 400, -2))).addGroup(jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.jLabel10)).addGap(6, 6, 6).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jComboBoxPostName, -2, 120, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxPostClass, -2, 116, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonPost, -2, -1, -2)).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jComboBoxPreName, -2, 120, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxPreClass, -2, 116, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonPre, -2, -1, -2)).addGroup(jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxCreateSupportCode).addComponent(this.jCheckBoxCreateGameLoop)).addGap(100, 100, 100).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxBankswitchNumber, -2, 40, -2).addComponent(this.jComboBoxBankswitch, -2, 138, -2)))))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel5, -2, -1, -2).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jButtonCancel, -2, 77, -2).addGap(87, 87, 87).addComponent(this.jButtonCreate, -2, 74, -2))))).addGap(0, 109, Short.MAX_VALUE)));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addGap(6, 6, 6).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldVersion, -2, -1, -2).addComponent(this.jTextFieldProjectName, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldPath, -2, -1, -2).addComponent(this.jButtonFileSelect1, -2, -1, -2).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldMainFile, -2, -1, -2).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldAuthor, -2, -1, -2).addComponent(this.jLabel9)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jScrollPane1, -2, 85, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxCProject1).addComponent(this.jCheckBoxCProject)).addGap(9, 9, 9).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldCFLAGS, -2, -1, -2).addComponent(this.jLabel11)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxPreName, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.jComboBoxPreClass, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.jLabel6, GroupLayout.Alignment.TRAILING).addComponent(this.jButtonPre, GroupLayout.Alignment.TRAILING, -2, -1, -2)).addGap(6, 6, 6).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxPostClass, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.jButtonPost, GroupLayout.Alignment.TRAILING, -2, -1, -2).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jComboBoxPostName, -2, -1, -2).addComponent(this.jLabel10))).addGap(6, 6, 6).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jComboBoxBankswitch, -2, -1, -2).addComponent(this.jCheckBoxCreateSupportCode)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jCheckBoxCreateGameLoop).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 106, Short.MAX_VALUE)).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jComboBoxBankswitchNumber, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)))).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jPanel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel, -2, -1, -2).addComponent(this.jButtonCreate, -2, -1, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -2, 8, -2).addGap(13, 13, 13)));
        this.jTabbedPane1.addTab("Project settings", this.jPanel6);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, -1, 554, Short.MAX_VALUE));
    }

    private void jButtonNewActionPerformed(ActionEvent evt) {
        ++this.mClassSetting;
        this.mProjectProperties = new ProjectProperties();
        this.clearAll();
        this.resetConfigPool(false, "");
        --this.mClassSetting;
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        this.readAllToCurrent();
        this.mProjectPropertiesPool.put(this.mProjectProperties);
        this.mProjectPropertiesPool.save();
        ++this.mClassSetting;
        String klasse = this.jTextFieldKlasse.getText();
        this.resetConfigPool(true, klasse);
        this.jComboBoxName.setSelectedItem(this.mProjectProperties.mName);
        --this.mClassSetting;
    }

    private void jButtonSaveAsNewActionPerformed(ActionEvent evt) {
        this.mProjectProperties = new ProjectProperties();
        this.readAllToCurrent();
        this.mProjectPropertiesPool.putAsNew(this.mProjectProperties);
        this.mProjectPropertiesPool.save();
        ++this.mClassSetting;
        String klasse = this.jTextFieldKlasse.getText();
        this.resetConfigPool(true, klasse);
        this.jComboBoxName.setSelectedItem(this.mProjectProperties.mName);
        --this.mClassSetting;
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.readAllToCurrent();
        this.mProjectPropertiesPool.remove(this.mProjectProperties);
        this.mProjectPropertiesPool.save();
        ++this.mClassSetting;
        String klasse = this.jTextFieldKlasse.getText();
        this.resetConfigPool(true, klasse);
        if (this.jComboBoxName.getSelectedIndex() == -1) {
            this.clearAll();
        }
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.mProjectProperties = this.mProjectPropertiesPool.get(key);
        this.setAllFromCurrent();
        --this.mClassSetting;
    }

    private void jComboBoxKlasseActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        ++this.mClassSetting;
        String selected = this.jComboBoxKlasse.getSelectedItem().toString();
        this.clearAll();
        this.resetConfigPool(true, selected);
        this.jTextFieldKlasse.setText(this.jComboBoxKlasse.getSelectedItem().toString());
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.mProjectProperties = this.mProjectPropertiesPool.get(key);
        this.setAllFromCurrent();
        --this.mClassSetting;
    }

    private void jComboBoxNameActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.mProjectProperties = this.mProjectPropertiesPool.get(key);
        this.setAllFromCurrent();
    }

    private void jButtonFileSelect1ActionPerformed(ActionEvent evt) {
        VideConfig config = VideConfig.getConfig();
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        fc.setDialogTitle("Select project parent directory");
        fc.setCurrentDirectory(new File(config.fileRequestHome));
        fc.setFileSelectionMode(1);
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return;
        }
        String lastPath = fc.getSelectedFile().getAbsolutePath();
        Path p = Paths.get(lastPath, new String[0]);
        this.jTextFieldPath.setText(p.toString());
    }

    private void jButtonCreateActionPerformed(ActionEvent evt) {
        this.deinit();
    }

    private void jTextFieldProjectNameActionPerformed(ActionEvent evt) {
        if (!this.wasMainSetManually && !this.jCheckBoxCProject1.isSelected()) {
            this.jTextFieldMainFile.setText(this.jTextFieldProjectName.getText() + ".asm");
        }
    }

    private void jTextFieldProjectNameKeyReleased(KeyEvent evt) {
        if (!this.wasMainSetManually && !this.jCheckBoxCProject1.isSelected()) {
            this.jTextFieldMainFile.setText(this.jTextFieldProjectName.getText() + ".asm");
        }
    }

    private void jTextFieldProjectNameFocusLost(FocusEvent evt) {
        if (!this.wasMainSetManually && !this.jCheckBoxCProject1.isSelected()) {
            this.jTextFieldMainFile.setText(this.jTextFieldProjectName.getText() + ".asm");
        }
    }

    private void jComboBoxBankswitchNumberActionPerformed(ActionEvent evt) {
        this.adjustMains();
    }

    private void jComboBoxBankswitchActionPerformed(ActionEvent evt) {
        int i;
        String[] s;
        if (this.jComboBoxBankswitch.getSelectedIndex() == 0) {
            this.jComboBoxBankswitchNumber.setModel(new DefaultComboBoxModel<String>(new String[]{"1"}));
            this.jComboBoxBankswitchNumber.setEnabled(false);
        }
        if (this.jComboBoxBankswitch.getSelectedIndex() == 1) {
            this.jComboBoxBankswitchNumber.setModel(new DefaultComboBoxModel<String>(new String[]{"2"}));
            this.jComboBoxBankswitchNumber.setEnabled(false);
        }
        if (this.jComboBoxBankswitch.getSelectedIndex() == 2) {
            s = new String[4];
            for (i = 0; i <= 3; ++i) {
                s[i] = "" + (i + 1);
            }
            this.jComboBoxBankswitchNumber.setModel(new DefaultComboBoxModel<String>(new String[]{"4"}));
            this.jComboBoxBankswitchNumber.setEnabled(false);
        }
        if (this.jComboBoxBankswitch.getSelectedIndex() == 3) {
            s = new String[32];
            for (i = 0; i <= 31; ++i) {
                s[i] = "" + (i + 1);
            }
            this.jComboBoxBankswitchNumber.setModel(new DefaultComboBoxModel<String>(s));
            this.jComboBoxBankswitchNumber.setEnabled(true);
        }
        this.adjustMains();
    }

    private void jCheckBox3ActionPerformed(ActionEvent evt) {
    }

    private void jCheckBox4ActionPerformed(ActionEvent evt) {
    }

    private void jCheckBox5ActionPerformed(ActionEvent evt) {
        this.jComboBoxImager.setEnabled(this.jCheckBox5.isSelected());
    }

    private void jCheckBox6ActionPerformed(ActionEvent evt) {
    }

    private void jButtonPreActionPerformed(ActionEvent evt) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        ScriptDataPanel sdp = new ScriptDataPanel();
        ModalInternalFrame modal = null;
        String pp = VediPanel.convertSeperator(this.mProjectProperties.getOldPath());
        if (pp.length() > 0) {
            pp = pp + File.separator;
        }
        pp = pp + this.mProjectProperties.getProjectName();
        ExecutionDescriptor ed = new ExecutionDescriptor(ExecutionDescriptor.ED_TYPE_PROJECT_PRE, this.mProjectProperties.mProjectName, "", "ProjectPropertiesPanel", Utility.makeVideAbsolute(pp));
        sdp.setSelected(this.mProjectProperties.mProjectPreScriptClass, this.mProjectProperties.mProjectPreScriptName, ed);
        modal = new ModalInternalFrame("Scripter", frame.getRootPane(), (Component)frame, (Container)sdp, "done");
        modal.setVisible(true);
        this.mProjectProperties.mProjectPreScriptClass = sdp.getSelectedClass();
        this.mProjectProperties.mProjectPreScriptName = sdp.getSelectedName();
        this.initScripts();
    }

    private void jButtonPostActionPerformed(ActionEvent evt) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        ScriptDataPanel sdp = new ScriptDataPanel();
        ModalInternalFrame modal = null;
        String pp = VediPanel.convertSeperator(this.mProjectProperties.projectPrefix);
        if (pp.length() > 0) {
            pp = pp + File.separator;
        }
        ExecutionDescriptor ed = new ExecutionDescriptor(ExecutionDescriptor.ED_TYPE_PROJECT_POST, this.mProjectProperties.mProjectName, "", "ProjectPropertiesPanel", pp);
        sdp.setSelected(this.mProjectProperties.mProjectPostScriptClass, this.mProjectProperties.mProjectPostScriptName, ed);
        modal = new ModalInternalFrame("Scripter", frame.getRootPane(), (Component)frame, (Container)sdp, "done");
        modal.setVisible(true);
        this.mProjectProperties.mProjectPostScriptClass = sdp.getSelectedClass();
        this.mProjectProperties.mProjectPostScriptName = sdp.getSelectedName();
        this.initScripts();
    }

    private void jComboBoxPreClassItemStateChanged(ItemEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        this.mProjectProperties.mProjectPreScriptClass = this.jComboBoxPreClass.getSelectedIndex() != -1 ? this.jComboBoxPreClass.getSelectedItem().toString() : "";
        this.initScripts();
    }

    private void jComboBoxPostClassActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        this.mProjectProperties.mProjectPostScriptClass = this.jComboBoxPostClass.getSelectedIndex() != -1 ? this.jComboBoxPostClass.getSelectedItem().toString() : "";
        this.initScripts();
    }

    private void jCheckBox2ActionPerformed(ActionEvent evt) {
    }

    private void jCheckBox16ActionPerformed(ActionEvent evt) {
    }

    private void jCheckBox8ActionPerformed(ActionEvent evt) {
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.deinit();
    }

    private void jCheckBox9ActionPerformed(ActionEvent evt) {
    }

    private void jComboBoxImagerActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
    }

    private void jCheckBoxCProjectActionPerformed(ActionEvent evt) {
        ++this.mClassSetting;
        this.jCheckBoxCProject1.setSelected(!this.jCheckBoxCProject.isSelected());
        --this.mClassSetting;
    }

    private void jCheckBoxCProject1ActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        ++this.mClassSetting;
        if (this.jCheckBoxCProject1.isSelected()) {
            this.jTextFieldMainFile.setText("");
            this.jCheckBoxCProject.setSelected(false);
        }
        this.jCheckBoxCPeepholing.setEnabled(this.jCheckBoxCProject1.isSelected());
        this.jCheckBoxCDebugging.setEnabled(this.jCheckBoxCProject1.isSelected());
        this.jCheckBoxCKeepEnriched.setEnabled(this.jCheckBoxCProject1.isSelected());
        this.jCheckBoxCRumInlined.setEnabled(false);
        --this.mClassSetting;
        this.jTextFieldCFLAGS.setText("-quiet -fno-tree-vrp -fno-ipa-reference -ftree-ter -fno-gcse -fverbose-asm -W -Wall -Wextra -Wconversion -Werror -fno-strict-overflow -fomit-frame-pointer -fno-toplevel-reorder -mint8 -msoft-reg-count=0 -std=gnu99 -fno-time-report -IC/PeerC/vectrex/include");
        this.enableASM(!this.jCheckBoxCProject1.isSelected());
    }

    private void jCheckBoxCDebuggingActionPerformed(ActionEvent evt) {
    }

    private void jCheckBox10ActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxCPeepholingActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxCKeepEnrichedActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxCRumInlinedActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxFlashSupportActionPerformed(ActionEvent evt) {
    }

    private void jCheckBox11ActionPerformed(ActionEvent evt) {
    }

    public static ProjectProperties showNewProjectProperties() {
        ModalInternalFrame modal;
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        ProjectPropertiesPanel panel = new ProjectPropertiesPanel();
        ArrayList<JButton> eb = new ArrayList<JButton>();
        eb.add(panel.jButtonCreate);
        eb.add(panel.jButtonCancel);
        panel.modelDialog = modal = new ModalInternalFrame("New project", frame.getRootPane(), frame, panel, null, null, eb);
        modal.setVisible(true);
        String result = modal.getNamedExit();
        panel.deinit();
        if (result.equals("create")) {
            panel.readAllToCurrent();
            return panel.getProject();
        }
        return null;
    }

    public static ProjectProperties showEditProjectProperties(ProjectProperties currentProject) {
        ModalInternalFrame modal;
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        ProjectPropertiesPanel panel = new ProjectPropertiesPanel(currentProject);
        ArrayList<JButton> eb = new ArrayList<JButton>();
        eb.add(panel.jButtonCreate);
        eb.add(panel.jButtonCancel);
        panel.modelDialog = modal = new ModalInternalFrame(currentProject.mProjectName, frame.getRootPane(), frame, panel, null, null, eb);
        modal.setResizable(true);
        Rectangle b = modal.getBounds();
        b.width = 1024;
        b.height = 650;
        modal.setBounds(b);
        modal.setVisible(true);
        String result = modal.getNamedExit();
        panel.deinit();
        if (result.equals("ok")) {
            panel.readAllToCurrent();
            return panel.getProject();
        }
        return null;
    }

    void initScripts() {
        String name;
        int j;
        Vector<String> nnames;
        Iterator<ExportData> iterC;
        Collection<ExportData> colC;
        this.mExportDataPool = new ExportDataPool();
        String preClass = this.mProjectProperties.mProjectPreScriptClass;
        String preName = this.mProjectProperties.mProjectPreScriptName;
        ++this.mClassSetting;
        Collection<String> collectionKlasse = this.mExportDataPool.getKlassenHashMap().values();
        Iterator<String> iterKlasse = collectionKlasse.iterator();
        int i = 0;
        String klasse = "";
        this.jComboBoxPreName.removeAllItems();
        this.jComboBoxPreClass.removeAllItems();
        this.jComboBoxPostName.removeAllItems();
        this.jComboBoxPostClass.removeAllItems();
        while (iterKlasse.hasNext()) {
            String item = iterKlasse.next();
            this.jComboBoxPreClass.addItem(item);
            this.jComboBoxPostClass.addItem(item);
            ++i;
        }
        if (this.mProjectProperties.mProjectPreScriptClass != null && this.mProjectProperties.mProjectPreScriptClass.length() != 0) {
            this.jComboBoxPreClass.setSelectedItem(this.mProjectProperties.mProjectPreScriptClass);
            colC = this.mExportDataPool.getMapForKlasse(this.mProjectProperties.mProjectPreScriptClass).values();
            iterC = colC.iterator();
            nnames = new Vector<String>();
            while (iterC.hasNext()) {
                nnames.addElement(iterC.next().mName);
            }
            Collections.sort(nnames, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    return s1.compareTo(s2);
                }
            });
            this.jComboBoxPreName.addItem("");
            for (j = 0; j < nnames.size(); ++j) {
                name = (String)nnames.elementAt(j);
                this.jComboBoxPreName.addItem(name);
            }
            if (this.mProjectProperties.mProjectPreScriptName != null && this.mProjectProperties.mProjectPreScriptName.length() != 0) {
                this.jComboBoxPreName.setSelectedItem(this.mProjectProperties.mProjectPreScriptName);
            }
        } else {
            this.jComboBoxPreClass.setSelectedIndex(-1);
            this.jComboBoxPreName.setSelectedIndex(-1);
        }
        if (this.mProjectProperties.mProjectPostScriptClass != null && this.mProjectProperties.mProjectPostScriptClass.length() != 0) {
            this.jComboBoxPostClass.setSelectedItem(this.mProjectProperties.mProjectPostScriptClass);
            colC = this.mExportDataPool.getMapForKlasse(this.mProjectProperties.mProjectPostScriptClass).values();
            iterC = colC.iterator();
            nnames = new Vector();
            while (iterC.hasNext()) {
                nnames.addElement(iterC.next().mName);
            }
            Collections.sort(nnames, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    return s1.compareTo(s2);
                }
            });
            this.jComboBoxPostName.addItem("");
            for (j = 0; j < nnames.size(); ++j) {
                name = (String)nnames.elementAt(j);
                this.jComboBoxPostName.addItem(name);
            }
            if (this.mProjectProperties.mProjectPostScriptName != null && this.mProjectProperties.mProjectPostScriptName.length() != 0) {
                this.jComboBoxPostName.setSelectedItem(this.mProjectProperties.mProjectPostScriptName);
            }
        } else {
            this.jComboBoxPostClass.setSelectedIndex(-1);
            this.jComboBoxPostName.setSelectedIndex(-1);
        }
        --this.mClassSetting;
    }

    void initImager() {
        String path = Global.mainPathPrefix + "xml" + File.separator + "wheels";
        ArrayList<String> files = UtilityFiles.getXMLFileList(path);
        this.jComboBoxImager.removeAllItems();
        for (String name : files) {
            this.jComboBoxImager.addItem(UtilityString.replace(name.toLowerCase(), ".xml", ""));
        }
    }

    public void removeUIListerner() {
        UIManager.removePropertyChangeListener(this.pListener);
    }

    void updateMyUI() {
        int fontSize = Theme.textFieldFont.getFont().getSize();
        int rowHeight = fontSize + 2;
        this.jTable1.setRowHeight(rowHeight);
    }

    @Override
    public void deIconified() {
    }

    void enableASM(boolean b) {
        this.jCheckBox1.setEnabled(b);
        this.jCheckBox2.setEnabled(b);
        this.jCheckBox16.setEnabled(b);
        this.jCheckBox3.setEnabled(b);
        this.jCheckBox4.setEnabled(b);
        this.jCheckBox5.setEnabled(b);
        this.jCheckBox6.setEnabled(b);
        this.jCheckBox7.setEnabled(b);
        this.jCheckBox8.setEnabled(b);
        this.jCheckBox9.setEnabled(b);
        this.jComboBoxImager.setEnabled(b);
        this.jCheckBoxCreateSupportCode.setEnabled(b);
        this.jCheckBoxCreateGameLoop.setEnabled(b);
        this.jTable1.setEnabled(b);
        this.jCheckBoxCDebugging.setEnabled(!b);
        this.jCheckBoxCRumInlined.setEnabled(false);
        if (this.mProjectProperties.mIsPeerCProject && this.mProjectProperties.mNumberOfBanks > 1) {
            this.jTable1.setEnabled(true);
        }
    }

    class BankMainTableModel
    extends AbstractTableModel {
        private BankMainTableModel() {
        }

        @Override
        public int getRowCount() {
            if (ProjectPropertiesPanel.this.mProjectProperties == null) {
                return 0;
            }
            if (((ProjectPropertiesPanel)ProjectPropertiesPanel.this).mProjectProperties.mBankMainFiles == null) {
                return 0;
            }
            return ((ProjectPropertiesPanel)ProjectPropertiesPanel.this).mProjectProperties.mBankMainFiles.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return "" + row;
            }
            if (ProjectPropertiesPanel.this.mProjectProperties == null) {
                return "";
            }
            if (((ProjectPropertiesPanel)ProjectPropertiesPanel.this).mProjectProperties.mBankMainFiles == null) {
                return "";
            }
            if (col == 1) {
                String name = ((ProjectPropertiesPanel)ProjectPropertiesPanel.this).mProjectProperties.mBankMainFiles.elementAt(row);
                Path p = Paths.get(name, new String[0]);
                return p.getFileName();
            }
            if (col == 2 && row < ((ProjectPropertiesPanel)ProjectPropertiesPanel.this).mProjectProperties.mBankDefines.size()) {
                String name = ((ProjectPropertiesPanel)ProjectPropertiesPanel.this).mProjectProperties.mBankDefines.elementAt(row);
                return name;
            }
            return "-";
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "#";
            }
            if (column == 1) {
                return "main file for bank";
            }
            if (column == 2) {
                return "define(s)";
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 1) {
                return true;
            }
            return columnIndex == 2;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (ProjectPropertiesPanel.this.mProjectProperties == null) {
                return;
            }
            if (columnIndex == 1) {
                if (((ProjectPropertiesPanel)ProjectPropertiesPanel.this).mProjectProperties.mBankMainFiles == null) {
                    return;
                }
                if (((ProjectPropertiesPanel)ProjectPropertiesPanel.this).mProjectProperties.mBankMainFiles.size() <= rowIndex) {
                    return;
                }
                String path = aValue.toString();
                String malRel = Utility.makeVideRelative(path);
                String repl = ((ProjectPropertiesPanel)ProjectPropertiesPanel.this).mProjectProperties.projectPrefix + File.separator;
                path = UtilityString.replace(path, repl, "");
                ((ProjectPropertiesPanel)ProjectPropertiesPanel.this).mProjectProperties.mBankMainFiles.setElementAt(path.toString(), rowIndex);
            }
            if (columnIndex == 2) {
                if (((ProjectPropertiesPanel)ProjectPropertiesPanel.this).mProjectProperties.mBankDefines == null) {
                    return;
                }
                if (((ProjectPropertiesPanel)ProjectPropertiesPanel.this).mProjectProperties.mBankDefines.size() <= rowIndex) {
                    return;
                }
                ((ProjectPropertiesPanel)ProjectPropertiesPanel.this).mProjectProperties.mBankDefines.setElementAt(aValue.toString(), rowIndex);
            }
        }
    }
}

