/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi.project;

import de.malban.util.Utility;
import de.malban.vide.vedi.project.ProjectProperties;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

public class ProjectPropertiesPool {
    public static final String DEFAULT_XML_NAME = new String("ProjectProperties.xml");
    private String mFileName = DEFAULT_XML_NAME;
    private String pathName = null;
    private HashMap<String, ProjectProperties> mProjectProperties = new HashMap();
    private HashMap<String, String> mKlassenMap = new HashMap();

    public ProjectPropertiesPool(String p, String name) {
        this.pathName = p;
        this.mFileName = name;
        this.init();
    }

    public ProjectPropertiesPool() {
        this.init();
    }

    public void setFilename(String n) {
        this.mFileName = n;
    }

    private boolean init() {
        try {
            return this.load();
        }
        catch (Throwable e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Load Error ProjectProperties...", 1);
            return false;
        }
    }

    public boolean load() {
        File f = this.pathName == null ? new File(Utility.makeVideAbsolute(this.mFileName)) : new File(Utility.makeVideAbsolute(this.pathName) + File.separator + this.mFileName);
        if (!f.exists()) {
            return false;
        }
        this.mProjectProperties = this.pathName == null ? ProjectProperties.getHashMapFromXML(this.mFileName) : ProjectProperties.getHashMapFromXML(this.mFileName, Utility.makeVideAbsolute(this.pathName));
        return true;
    }

    public void save() {
        if (this.pathName == null) {
            ProjectProperties.saveCollectionAsXML(this.mFileName, this.mProjectProperties.values());
        } else if (Utility.isFilenameRelative(this.pathName)) {
            ProjectProperties.saveCollectionAsXML(Utility.makeVideAbsolute(this.pathName), this.mFileName, this.mProjectProperties.values());
        } else {
            ProjectProperties.saveCollectionAsXML(this.pathName, this.mFileName, this.mProjectProperties.values());
        }
        this.buildKlassenMap();
    }

    public void remove(ProjectProperties st) {
        this.mProjectProperties.remove(st.mName);
    }

    public void put(ProjectProperties st) {
        this.mProjectProperties.remove(st.mName);
        this.mProjectProperties.put(st.mName, st);
    }

    public void putAsNew(ProjectProperties st) {
        this.mProjectProperties.put(st.mName, st);
    }

    public ProjectProperties get(String key) {
        return this.mProjectProperties.get(key);
    }

    public HashMap<String, ProjectProperties> getHashMap() {
        return this.mProjectProperties;
    }

    private void buildKlassenMap() {
        this.mKlassenMap = new HashMap();
        Set<Map.Entry<String, ProjectProperties>> entries = this.mProjectProperties.entrySet();
        for (Map.Entry<String, ProjectProperties> entry : entries) {
            ProjectProperties value = entry.getValue();
            this.mKlassenMap.put(value.mClass, value.mClass);
        }
    }

    public HashMap<String, String> getKlassenHashMap() {
        this.buildKlassenMap();
        return this.mKlassenMap;
    }

    public HashMap<String, ProjectProperties> getMapForKlasse(String klasse) {
        HashMap<String, ProjectProperties> ret = new HashMap<String, ProjectProperties>();
        Set<Map.Entry<String, ProjectProperties>> entries = this.mProjectProperties.entrySet();
        for (Map.Entry<String, ProjectProperties> entry : entries) {
            ProjectProperties value = entry.getValue();
            if (!value.mClass.equalsIgnoreCase(klasse)) continue;
            ret.put(value.mName, value);
        }
        return ret;
    }
}

