/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi.raster;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.graphics.GFXVector;
import de.malban.graphics.SingleImagePanel;
import de.malban.graphics.SingleVectorPanel;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.ImageCache;
import de.malban.gui.Windowable;
import de.malban.gui.components.CSAView;
import de.malban.gui.components.ModalInternalFrame;
import de.malban.gui.dialogs.InternalFrameFileChoser;
import de.malban.util.UtilityFiles;
import de.malban.util.UtilityString;
import de.malban.vide.vedi.VediPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class RasterPanel
extends JPanel
implements Windowable {
    boolean modal = true;
    String orgName = "Default";
    private int mClassSetting = 0;
    private CSAView mParent = null;
    private JMenuItem mParentMenuItem = null;
    String lastImagePath = Global.mainPathPrefix;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButton7;
    private JButton jButton8;
    private JButton jButtonCancel;
    private JButton jButtonCreate;
    private JButton jButtonLoad;
    private JButton jButtonLoad1;
    private JCheckBox jCheckBoxAssume9Bit;
    private JCheckBox jCheckBoxBiDirectionalData;
    private JCheckBox jCheckBoxFix;
    private JCheckBox jCheckBoxGenerateData;
    private JCheckBox jCheckBoxGenerateExampleCode;
    private JCheckBox jCheckBoxIncludeBrightness;
    private JCheckBox jCheckBoxInvert;
    private JCheckBox jCheckBoxXMirror;
    private JCheckBox jCheckBoxYMirror;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JRadioButton jRadioButton3;
    private JRadioButton jRadioButtonAlphaAsGrayscale;
    private JRadioButton jRadioButtonHorizontalVectors;
    private JRadioButton jRadioButtonVertical;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSlider jSliderGridSize;
    private JSlider jSliderSourceScale;
    private JSlider jSliderThreshold;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextFieldHeight;
    private JTextField jTextFieldMultiplyBits;
    private JTextField jTextFieldStartX;
    private JTextField jTextFieldStartY;
    private JTextField jTextFieldVectorHeight;
    private JTextField jTextFieldVectorWitdh;
    private JTextField jTextFieldWidth;
    private SingleImagePanel singleImagePanel1;
    private SingleVectorPanel singleVectorPanel1;
    ModalInternalFrame modelDialog;
    ArrayList<Integer>[] shiftRegRows = new ArrayList[0];
    ArrayList<GFXVector>[] vectorRows = new ArrayList[0];
    ArrayList<Integer>[] shiftRegCols = new ArrayList[0];
    ArrayList<GFXVector>[] vectorCols = new ArrayList[0];

    public void setModal(boolean b) {
        this.modal = b;
        this.jPanel1.setVisible(!this.modal);
        this.jButtonCancel.setVisible(this.modal);
    }

    @Override
    public boolean isIcon() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return false;
        }
        return frame.getInternalFrame(this).isIcon();
    }

    @Override
    public void setIcon(boolean b) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return;
        }
        try {
            frame.getInternalFrame(this).setIcon(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void closing() {
        this.deinit();
    }

    @Override
    public void setParentWindow(CSAView jpv) {
        this.mParent = jpv;
    }

    @Override
    public void setMenuItem(JMenuItem item) {
        this.mParentMenuItem = item;
        this.mParentMenuItem.setText("Image Raster converter");
    }

    @Override
    public JMenuItem getMenuItem() {
        return this.mParentMenuItem;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    public void deinit() {
    }

    public RasterPanel() {
        ++this.mClassSetting;
        this.initComponents();
        --this.mClassSetting;
    }

    public void setImage(String filename) {
        this.orgName = filename;
        this.singleImagePanel1.setImage(this.orgName);
        if (this.singleImagePanel1.getSourceWidth() > 320 || this.singleImagePanel1.getSourceHeight() > 320) {
            this.singleImagePanel1.scaleToFit();
        }
        this.jTextFieldWidth.setText("" + this.singleImagePanel1.getSourceWidth());
        this.jTextFieldHeight.setText("" + this.singleImagePanel1.getSourceHeight());
        if (this.jRadioButtonHorizontalVectors.isSelected()) {
            this.jTextFieldVectorWitdh.setText("" + this.singleImagePanel1.getSourceWidth());
            this.jTextFieldVectorHeight.setText("" + this.singleImagePanel1.getSourceHeight());
        }
        this.jSliderSourceScaleStateChanged(null);
        this.buildVectors();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel3 = new JPanel();
        this.jRadioButtonHorizontalVectors = new JRadioButton();
        this.jRadioButtonVertical = new JRadioButton();
        this.jRadioButton3 = new JRadioButton();
        this.jRadioButtonAlphaAsGrayscale = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.jTextFieldWidth = new JTextField();
        this.jTextFieldHeight = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextFieldVectorWitdh = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTextFieldVectorHeight = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.singleImagePanel1 = new SingleImagePanel();
        this.jSliderThreshold = new JSlider();
        this.jLabel5 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.singleVectorPanel1 = new SingleVectorPanel();
        this.jSliderSourceScale = new JSlider();
        this.jCheckBoxGenerateData = new JCheckBox();
        this.jCheckBoxGenerateExampleCode = new JCheckBox();
        this.jCheckBoxIncludeBrightness = new JCheckBox();
        this.jCheckBoxAssume9Bit = new JCheckBox();
        this.jCheckBoxBiDirectionalData = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.jTextFieldStartX = new JTextField();
        this.jLabel7 = new JLabel();
        this.jTextFieldStartY = new JTextField();
        this.jCheckBoxInvert = new JCheckBox();
        this.jCheckBoxFix = new JCheckBox();
        this.jCheckBoxXMirror = new JCheckBox();
        this.jCheckBoxYMirror = new JCheckBox();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jButton4 = new JButton();
        this.jButton5 = new JButton();
        this.jButton6 = new JButton();
        this.jButton7 = new JButton();
        this.jButton8 = new JButton();
        this.jButtonCreate = new JButton();
        this.jButtonCancel = new JButton();
        this.jSliderGridSize = new JSlider();
        this.jLabel9 = new JLabel();
        this.jTextFieldMultiplyBits = new JTextField();
        this.jLabel10 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel8 = new JLabel();
        this.jButtonLoad = new JButton();
        this.jButtonLoad1 = new JButton();
        this.setPreferredSize(new Dimension(700, 600));
        this.buttonGroup1.add(this.jRadioButtonHorizontalVectors);
        this.jRadioButtonHorizontalVectors.setSelected(true);
        this.jRadioButtonHorizontalVectors.setText("horizontal vectors");
        this.jRadioButtonHorizontalVectors.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPanel.this.jRadioButtonHorizontalVectorsActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonVertical);
        this.jRadioButtonVertical.setText("vertical vectors");
        this.jRadioButtonVertical.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPanel.this.jRadioButtonVerticalActionPerformed(evt);
            }
        });
        this.buttonGroup2.add(this.jRadioButton3);
        this.jRadioButton3.setSelected(true);
        this.jRadioButton3.setText("colors as grayscale");
        this.jRadioButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPanel.this.jRadioButton3ActionPerformed(evt);
            }
        });
        this.buttonGroup2.add(this.jRadioButtonAlphaAsGrayscale);
        this.jRadioButtonAlphaAsGrayscale.setText("alpha as grayscale");
        this.jRadioButtonAlphaAsGrayscale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPanel.this.jRadioButtonAlphaAsGrayscaleActionPerformed(evt);
            }
        });
        this.jLabel1.setText("size");
        this.jTextFieldWidth.setEditable(false);
        this.jTextFieldHeight.setEditable(false);
        this.jLabel2.setText("x");
        this.jLabel3.setText("vector \"size\"");
        this.jTextFieldVectorWitdh.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                RasterPanel.this.jTextFieldVectorWitdhFocusLost(evt);
            }
        });
        this.jTextFieldVectorWitdh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPanel.this.jTextFieldVectorWitdhActionPerformed(evt);
            }
        });
        this.jLabel4.setText("x");
        this.jTextFieldVectorHeight.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                RasterPanel.this.jTextFieldVectorHeightFocusLost(evt);
            }
        });
        this.jTextFieldVectorHeight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPanel.this.jTextFieldVectorHeightActionPerformed(evt);
            }
        });
        this.jScrollPane1.setMaximumSize(new Dimension(320, 320));
        this.jScrollPane1.setMinimumSize(new Dimension(320, 320));
        this.singleImagePanel1.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                RasterPanel.this.singleImagePanel1MouseDragged(evt);
            }

            @Override
            public void mouseMoved(MouseEvent evt) {
                RasterPanel.this.singleImagePanel1MouseMoved(evt);
            }
        });
        this.singleImagePanel1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                RasterPanel.this.singleImagePanel1MouseReleased(evt);
            }
        });
        GroupLayout singleImagePanel1Layout = new GroupLayout(this.singleImagePanel1);
        this.singleImagePanel1.setLayout(singleImagePanel1Layout);
        singleImagePanel1Layout.setHorizontalGroup(singleImagePanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 318, Short.MAX_VALUE));
        singleImagePanel1Layout.setVerticalGroup(singleImagePanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 318, Short.MAX_VALUE));
        this.jScrollPane1.setViewportView(this.singleImagePanel1);
        this.jSliderThreshold.setMajorTickSpacing(50);
        this.jSliderThreshold.setMaximum(255);
        this.jSliderThreshold.setMinorTickSpacing(5);
        this.jSliderThreshold.setPaintLabels(true);
        this.jSliderThreshold.setPaintTicks(true);
        this.jSliderThreshold.setValue(60);
        this.jSliderThreshold.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RasterPanel.this.jSliderThresholdStateChanged(evt);
            }
        });
        this.jLabel5.setText("threshold");
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        this.jScrollPane2.setVerticalScrollBarPolicy(21);
        this.jScrollPane2.setPreferredSize(new Dimension(320, 320));
        this.singleVectorPanel1.setPreferredSize(new Dimension(318, 318));
        GroupLayout singleVectorPanel1Layout = new GroupLayout(this.singleVectorPanel1);
        this.singleVectorPanel1.setLayout(singleVectorPanel1Layout);
        singleVectorPanel1Layout.setHorizontalGroup(singleVectorPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 318, Short.MAX_VALUE));
        singleVectorPanel1Layout.setVerticalGroup(singleVectorPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 318, Short.MAX_VALUE));
        this.jScrollPane2.setViewportView(this.singleVectorPanel1);
        this.jSliderSourceScale.setMajorTickSpacing(1);
        this.jSliderSourceScale.setMaximum(25);
        this.jSliderSourceScale.setMinimum(1);
        this.jSliderSourceScale.setMinorTickSpacing(1);
        this.jSliderSourceScale.setOrientation(1);
        this.jSliderSourceScale.setPaintTicks(true);
        this.jSliderSourceScale.setSnapToTicks(true);
        this.jSliderSourceScale.setValue(20);
        this.jSliderSourceScale.setPreferredSize(new Dimension(39, 292));
        this.jSliderSourceScale.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RasterPanel.this.jSliderSourceScaleStateChanged(evt);
            }
        });
        this.jCheckBoxGenerateData.setSelected(true);
        this.jCheckBoxGenerateData.setText("generate data file");
        this.jCheckBoxGenerateExampleCode.setSelected(true);
        this.jCheckBoxGenerateExampleCode.setText("example code file");
        this.jCheckBoxIncludeBrightness.setText("include brightness data");
        this.jCheckBoxIncludeBrightness.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPanel.this.jCheckBoxIncludeBrightnessActionPerformed(evt);
            }
        });
        this.jCheckBoxAssume9Bit.setSelected(true);
        this.jCheckBoxAssume9Bit.setText("assume 9 bit shift");
        this.jCheckBoxAssume9Bit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPanel.this.jCheckBoxAssume9BitActionPerformed(evt);
            }
        });
        this.jCheckBoxBiDirectionalData.setSelected(true);
        this.jCheckBoxBiDirectionalData.setText("generate bi directional data");
        this.jCheckBoxBiDirectionalData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPanel.this.jCheckBoxBiDirectionalDataActionPerformed(evt);
            }
        });
        this.jLabel6.setText("start");
        this.jTextFieldStartX.setEditable(false);
        this.jTextFieldStartX.setText("0");
        this.jLabel7.setText(",");
        this.jTextFieldStartY.setEditable(false);
        this.jTextFieldStartY.setText("0");
        this.jCheckBoxInvert.setText("invert");
        this.jCheckBoxInvert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPanel.this.jCheckBoxInvertActionPerformed(evt);
            }
        });
        this.jCheckBoxFix.setText("fix");
        this.jCheckBoxFix.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPanel.this.jCheckBoxFixActionPerformed(evt);
            }
        });
        this.jCheckBoxXMirror.setText("xMirror");
        this.jCheckBoxXMirror.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPanel.this.jCheckBoxXMirrorActionPerformed(evt);
            }
        });
        this.jCheckBoxYMirror.setText("yMirror");
        this.jCheckBoxYMirror.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPanel.this.jCheckBoxYMirrorActionPerformed(evt);
            }
        });
        this.jButton1.setText(">");
        this.jButton1.setMargin(new Insets(1, 1, 1, 1));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("<");
        this.jButton2.setMargin(new Insets(1, 1, 1, 1));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPanel.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton3.setText(">");
        this.jButton3.setMargin(new Insets(1, 1, 1, 1));
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPanel.this.jButton3ActionPerformed(evt);
            }
        });
        this.jButton4.setText("<");
        this.jButton4.setMargin(new Insets(1, 1, 1, 1));
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPanel.this.jButton4ActionPerformed(evt);
            }
        });
        this.jButton5.setText(">");
        this.jButton5.setMargin(new Insets(1, 1, 1, 1));
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPanel.this.jButton5ActionPerformed(evt);
            }
        });
        this.jButton6.setText("<");
        this.jButton6.setMargin(new Insets(1, 1, 1, 1));
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPanel.this.jButton6ActionPerformed(evt);
            }
        });
        this.jButton7.setText(">");
        this.jButton7.setMargin(new Insets(1, 1, 1, 1));
        this.jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPanel.this.jButton7ActionPerformed(evt);
            }
        });
        this.jButton8.setText("<");
        this.jButton8.setMargin(new Insets(1, 1, 1, 1));
        this.jButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPanel.this.jButton8ActionPerformed(evt);
            }
        });
        this.jButtonCreate.setText("create");
        this.jButtonCreate.setName("create");
        this.jButtonCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPanel.this.jButtonCreateActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("cancel");
        this.jButtonCancel.setName("cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPanel.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jSliderGridSize.setMajorTickSpacing(5);
        this.jSliderGridSize.setMaximum(20);
        this.jSliderGridSize.setMinorTickSpacing(1);
        this.jSliderGridSize.setPaintTicks(true);
        this.jSliderGridSize.setValue(10);
        this.jSliderGridSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RasterPanel.this.jSliderGridSizeStateChanged(evt);
            }
        });
        this.jLabel9.setText("grid");
        this.jTextFieldMultiplyBits.setText("1");
        this.jTextFieldMultiplyBits.setToolTipText("not with brightnessdata included");
        this.jLabel10.setText("multiply bits");
        this.jLabel10.setToolTipText("only with vertical switch");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jCheckBoxGenerateData).addGap(18, 18, 18).addComponent(this.jCheckBoxBiDirectionalData)).addComponent(this.jCheckBoxGenerateExampleCode)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonCancel).addGap(86, 86, 86).addComponent(this.jButtonCreate)).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel5).addComponent(this.jScrollPane1, -2, 320, -2).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel6).addGap(3, 3, 3).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jTextFieldStartX, -2, 44, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jButton4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3)).addComponent(this.jTextFieldStartY, -2, 44, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jTextFieldWidth, -2, 44, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jButton6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton5))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jButton8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton7)).addComponent(this.jTextFieldHeight, -2, 44, -2)))).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 320, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSliderSourceScale, -1, -1, -2)).addGroup(jPanel3Layout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonHorizontalVectors).addComponent(this.jRadioButtonVertical).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jTextFieldMultiplyBits, -2, 29, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel10))).addGap(39, 39, 39).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jCheckBoxYMirror, -1, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxXMirror)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonAlphaAsGrayscale).addComponent(this.jRadioButton3))).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxIncludeBrightness).addComponent(this.jCheckBoxAssume9Bit)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel9)).addGroup(GroupLayout.Alignment.LEADING, jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldVectorWitdh, -2, 44, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldVectorHeight, -2, 44, -2)).addComponent(this.jCheckBoxInvert)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxFix))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSliderGridSize, -2, 93, -2)))))).addComponent(this.jSliderThreshold, -2, 220, -2)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jScrollPane2, -2, 320, -2).addComponent(this.jSliderSourceScale, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, -2, 320, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jTextFieldStartX, -2, -1, -2).addComponent(this.jTextFieldStartY, -2, -1, -2).addComponent(this.jLabel7)).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldVectorWitdh, -2, -1, -2).addComponent(this.jTextFieldVectorHeight, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.jLabel1).addComponent(this.jTextFieldWidth, -2, -1, -2).addComponent(this.jTextFieldHeight, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jCheckBoxFix))).addGap(1, 1, 1).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(54, 54, 54).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSliderThreshold, -2, -1, -2).addGap(0, 0, 0).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxGenerateData).addComponent(this.jCheckBoxBiDirectionalData)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxGenerateExampleCode).addComponent(this.jTextFieldMultiplyBits, -2, -1, -2).addComponent(this.jLabel10))).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxIncludeBrightness).addComponent(this.jButton2).addComponent(this.jButton1).addComponent(this.jButton4).addComponent(this.jButton3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxAssume9Bit)).addGroup(jPanel3Layout.createSequentialGroup().addGap(3, 3, 3).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton8).addComponent(this.jButton7)).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton6).addComponent(this.jButton5))))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxInvert).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonHorizontalVectors).addComponent(this.jRadioButton3).addComponent(this.jCheckBoxXMirror))).addGroup(jPanel3Layout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.jLabel9)).addGroup(jPanel3Layout.createSequentialGroup().addGap(8, 8, 8).addComponent(this.jSliderGridSize, -2, -1, -2))).addGap(6, 6, 6).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonVertical).addComponent(this.jRadioButtonAlphaAsGrayscale).addComponent(this.jCheckBoxYMirror)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 43, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonCreate)))).addGap(0, 0, 0)));
        this.jTabbedPane1.addTab("image settings", this.jPanel3);
        this.jLabel8.setText("load image file");
        this.jButtonLoad.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_go.png")));
        this.jButtonLoad.setToolTipText("load YM");
        this.jButtonLoad.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPanel.this.jButtonLoadActionPerformed(evt);
            }
        });
        this.jButtonLoad1.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/paste_plain.png")));
        this.jButtonLoad1.setToolTipText("Paste from clipboard");
        this.jButtonLoad1.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonLoad1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterPanel.this.jButtonLoad1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonLoad).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonLoad1).addGap(0, 0, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButtonLoad).addComponent(this.jLabel8).addComponent(this.jButtonLoad1)).addGap(2, 2, 2)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jTabbedPane1, GroupLayout.Alignment.TRAILING, -1, 708, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jTabbedPane1).addGap(0, 0, 0)));
    }

    private void jButtonCreateActionPerformed(ActionEvent evt) {
        this.createASMFile();
        this.buildVectors();
    }

    private void jSliderSourceScaleStateChanged(ChangeEvent evt) {
        int value = this.jSliderSourceScale.getValue();
        int max = this.jSliderSourceScale.getMaximum();
        double scale = value - (max - 1) / 2;
        if (value < max / 2 + 1) {
            int invScale = max / 2 + 2 - value;
            scale = 1.0 / (double)invScale;
        }
        this.singleVectorPanel1.setScale(scale);
    }

    private void jSliderThresholdStateChanged(ChangeEvent evt) {
        this.buildVectors();
    }

    private void jRadioButton3ActionPerformed(ActionEvent evt) {
        this.buildVectors();
    }

    private void jRadioButtonAlphaAsGrayscaleActionPerformed(ActionEvent evt) {
        this.buildVectors();
    }

    private void jRadioButtonHorizontalVectorsActionPerformed(ActionEvent evt) {
        this.jCheckBoxBiDirectionalData.setEnabled(true);
        this.jCheckBoxIncludeBrightness.setEnabled(true);
        this.buildVectors();
    }

    private void jRadioButtonVerticalActionPerformed(ActionEvent evt) {
        this.jCheckBoxBiDirectionalData.setEnabled(false);
        this.jCheckBoxIncludeBrightness.setEnabled(false);
        this.buildVectors();
    }

    private void jTextFieldVectorWitdhFocusLost(FocusEvent evt) {
        this.buildVectors();
    }

    private void jTextFieldVectorHeightFocusLost(FocusEvent evt) {
        this.buildVectors();
    }

    private void jCheckBoxIncludeBrightnessActionPerformed(ActionEvent evt) {
        this.buildVectors();
        this.jButtonCreate.setEnabled(!this.jCheckBoxIncludeBrightness.isSelected());
    }

    private void jCheckBoxAssume9BitActionPerformed(ActionEvent evt) {
        this.buildVectors();
    }

    private void jCheckBoxBiDirectionalDataActionPerformed(ActionEvent evt) {
    }

    private void singleImagePanel1MouseDragged(MouseEvent evt) {
        int tmp;
        BufferedImage orgImage = this.singleImagePanel1.getImage();
        if (orgImage == null) {
            return;
        }
        int x = (int)((double)evt.getX() / 1.0);
        int y = (int)((double)evt.getY() / 1.0);
        int sX = this.singleImagePanel1.getPressedStartX();
        int sY = this.singleImagePanel1.getPressedStartY();
        if (x < 0) {
            x = 0;
        }
        if (sX < 0) {
            sX = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (sY < 0) {
            sY = 0;
        }
        if (x > orgImage.getWidth()) {
            x = orgImage.getWidth();
        }
        if (sX > orgImage.getWidth()) {
            sX = orgImage.getWidth();
        }
        if (y > orgImage.getHeight()) {
            y = orgImage.getHeight();
        }
        if (sY > orgImage.getHeight()) {
            sY = orgImage.getHeight();
        }
        if (x < sX) {
            tmp = sX;
            sX = x;
            x = tmp;
        }
        if (y < sY) {
            tmp = sY;
            sY = y;
            y = tmp;
        }
        int w = x - sX;
        int h = y - sY;
        if (this.singleImagePanel1.isLocked()) {
            Dimension wh = this.singleImagePanel1.getSelectionLock();
            w = wh.width;
            h = wh.height;
        }
        this.jTextFieldStartX.setText("" + sX);
        this.jTextFieldStartY.setText("" + sY);
        this.jTextFieldWidth.setText("" + w);
        this.jTextFieldHeight.setText("" + h);
        if (!this.jCheckBoxFix.isSelected()) {
            this.jTextFieldVectorWitdh.setText("" + w);
            this.jTextFieldVectorHeight.setText("" + h);
        }
        this.buildVectors();
    }

    private void singleImagePanel1MouseMoved(MouseEvent evt) {
    }

    private void singleImagePanel1MouseReleased(MouseEvent evt) {
    }

    private void jButtonLoadActionPerformed(ActionEvent evt) {
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        fc.setMultiSelectionEnabled(true);
        if (this.lastImagePath.length() != 0) {
            fc.setCurrentDirectory(new File(this.lastImagePath));
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Images", "jpg", "jpeg", "png", "bmp", "gif");
        fc.setFileFilter(filter);
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return;
        }
        File[] files = fc.getSelectedFiles();
        String fullPath = files == null || files.length == 1 ? fc.getSelectedFile().getAbsolutePath() : files[0].getAbsolutePath();
        this.lastImagePath = fullPath;
        this.setImage(fullPath);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxInvertActionPerformed(ActionEvent evt) {
        this.buildVectors();
    }

    private void jTextFieldVectorWitdhActionPerformed(ActionEvent evt) {
        this.buildVectors();
    }

    private void jTextFieldVectorHeightActionPerformed(ActionEvent evt) {
        this.buildVectors();
    }

    private void jCheckBoxXMirrorActionPerformed(ActionEvent evt) {
        this.buildVectors();
    }

    private void jCheckBoxYMirrorActionPerformed(ActionEvent evt) {
        this.buildVectors();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        int startX = UtilityString.IntX(this.jTextFieldStartX.getText(), 0);
        if (startX == 0) {
            return;
        }
        this.jTextFieldStartX.setText("" + --startX);
        this.buildVectors();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        BufferedImage orgImage = this.singleImagePanel1.getImage();
        if (orgImage == null) {
            return;
        }
        int startX = UtilityString.IntX(this.jTextFieldStartX.getText(), 0);
        if (startX >= orgImage.getWidth()) {
            return;
        }
        this.jTextFieldStartX.setText("" + ++startX);
        this.buildVectors();
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        int startY = UtilityString.IntX(this.jTextFieldStartY.getText(), 0);
        if (startY == 0) {
            return;
        }
        this.jTextFieldStartY.setText("" + --startY);
        this.buildVectors();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        BufferedImage orgImage = this.singleImagePanel1.getImage();
        if (orgImage == null) {
            return;
        }
        int startY = UtilityString.IntX(this.jTextFieldStartY.getText(), 0);
        if (startY >= orgImage.getHeight()) {
            return;
        }
        this.jTextFieldStartY.setText("" + ++startY);
        this.buildVectors();
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        int width = UtilityString.IntX(this.jTextFieldWidth.getText(), 0);
        if (width == 0) {
            return;
        }
        this.jTextFieldWidth.setText("" + --width);
        if (!this.jCheckBoxFix.isSelected()) {
            this.jTextFieldVectorWitdh.setText("" + width);
        }
        this.buildVectors();
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        int startX;
        BufferedImage orgImage = this.singleImagePanel1.getImage();
        if (orgImage == null) {
            return;
        }
        int width = UtilityString.IntX(this.jTextFieldWidth.getText(), 0);
        if (width + (startX = UtilityString.IntX(this.jTextFieldStartX.getText(), 0)) >= orgImage.getWidth()) {
            return;
        }
        this.jTextFieldWidth.setText("" + ++width);
        if (!this.jCheckBoxFix.isSelected()) {
            this.jTextFieldVectorWitdh.setText("" + width);
        }
        this.buildVectors();
    }

    private void jButton8ActionPerformed(ActionEvent evt) {
        int height = UtilityString.IntX(this.jTextFieldHeight.getText(), 0);
        if (height == 0) {
            return;
        }
        this.jTextFieldHeight.setText("" + --height);
        if (!this.jCheckBoxFix.isSelected()) {
            this.jTextFieldVectorHeight.setText("" + height);
        }
        this.buildVectors();
    }

    private void jButton7ActionPerformed(ActionEvent evt) {
        int startY;
        BufferedImage orgImage = this.singleImagePanel1.getImage();
        if (orgImage == null) {
            return;
        }
        int height = UtilityString.IntX(this.jTextFieldHeight.getText(), 0);
        if (height + (startY = UtilityString.IntX(this.jTextFieldStartY.getText(), 0)) >= orgImage.getHeight()) {
            return;
        }
        this.jTextFieldHeight.setText("" + ++height);
        if (!this.jCheckBoxFix.isSelected()) {
            this.jTextFieldVectorHeight.setText("" + height);
        }
        this.buildVectors();
    }

    private void jSliderGridSizeStateChanged(ChangeEvent evt) {
        int gridSize = this.jSliderGridSize.getValue();
        this.singleVectorPanel1.setGrid(gridSize != 0, gridSize);
        this.buildVectors();
    }

    private void jButtonLoad1ActionPerformed(ActionEvent evt) {
        this.singleImagePanel1.setImageFromClipboard();
        if (this.singleImagePanel1.getSourceWidth() > 320 || this.singleImagePanel1.getSourceHeight() > 320) {
            this.singleImagePanel1.scaleToFit();
        }
        this.jTextFieldWidth.setText("" + this.singleImagePanel1.getSourceWidth());
        this.jTextFieldHeight.setText("" + this.singleImagePanel1.getSourceHeight());
        if (this.jRadioButtonHorizontalVectors.isSelected()) {
            this.jTextFieldVectorWitdh.setText("" + this.singleImagePanel1.getSourceWidth());
            this.jTextFieldVectorHeight.setText("" + this.singleImagePanel1.getSourceHeight());
        }
        this.jSliderSourceScaleStateChanged(null);
        this.buildVectors();
    }

    int getI(JTextField t) {
        return this.getI(t.getText());
    }

    int getI(String t) {
        return this.getI(t, 0);
    }

    int getI(String t, int _default) {
        int i = _default;
        try {
            i = Integer.parseInt(t);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return i;
    }

    private void jCheckBoxFixActionPerformed(ActionEvent evt) {
        this.singleImagePanel1.setSelectionLock(this.jCheckBoxFix.isSelected(), this.getI(this.jTextFieldWidth), this.getI(this.jTextFieldHeight));
    }

    public static boolean showRasterPanel(String fileName) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        RasterPanel panel = new RasterPanel();
        panel.setImage(fileName);
        ArrayList<JButton> eb = new ArrayList<JButton>();
        eb.add(panel.jButtonCreate);
        eb.add(panel.jButtonCancel);
        ModalInternalFrame modal = new ModalInternalFrame("Raster image", frame.getRootPane(), frame, panel, null, null, eb);
        modal.setResizable(true);
        panel.modelDialog = modal;
        modal.setVisible(true);
        String result = modal.getNamedExit();
        return result.equals("create");
    }

    public static void showModPanelNoModal() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        RasterPanel panel = new RasterPanel();
        panel.setModal(false);
        Configuration.getConfiguration().getMainFrame().addAsWindow(panel, 1080, 800, "Image Raster converter");
    }

    void buildVectors() {
        if (this.jRadioButtonHorizontalVectors.isSelected()) {
            this.buildHorizontal();
        } else {
            this.buildVertical();
        }
        this.displayVectors();
    }

    boolean buildHorizontal() {
        BufferedImage orgImage = this.singleImagePanel1.getImage();
        int targetWidth = UtilityString.IntX(this.jTextFieldVectorWitdh.getText(), orgImage.getWidth());
        int targetHeight = UtilityString.IntX(this.jTextFieldVectorHeight.getText(), orgImage.getHeight());
        int startX = UtilityString.IntX(this.jTextFieldStartX.getText(), 0);
        int startY = UtilityString.IntX(this.jTextFieldStartY.getText(), 0);
        int width = UtilityString.IntX(this.jTextFieldWidth.getText(), orgImage.getWidth() - startX);
        int height = UtilityString.IntX(this.jTextFieldHeight.getText(), orgImage.getHeight() - startY);
        if (this.jCheckBoxAssume9Bit.isSelected()) {
            if (!this.jCheckBoxFix.isSelected()) {
                this.jTextFieldVectorWitdh.setText("" + (width + width / 8));
                targetWidth = UtilityString.IntX(this.jTextFieldVectorWitdh.getText(), orgImage.getWidth());
            } else {
                int shift9 = targetWidth / 8;
                targetWidth -= shift9;
            }
        } else if (!this.jCheckBoxFix.isSelected()) {
            this.jTextFieldVectorWitdh.setText("" + width);
            targetWidth = UtilityString.IntX(this.jTextFieldVectorWitdh.getText(), orgImage.getWidth());
        }
        orgImage = this.singleImagePanel1.getSelection((int)startX, (int)startY, (int)width, (int)height).image;
        int threshold = this.jSliderThreshold.getValue();
        BufferedImage scaledImage = ImageCache.getImageCache().getDerivatScale(orgImage, targetWidth, targetHeight);
        if (scaledImage == null) {
            return false;
        }
        this.shiftRegRows = new ArrayList[targetHeight];
        this.vectorRows = new ArrayList[targetHeight];
        int rowWidth = 0;
        if (!this.jCheckBoxIncludeBrightness.isSelected()) {
            for (int y = 0; y < targetHeight; ++y) {
                rowWidth = 0;
                ArrayList<Integer> shiftRegRow = new ArrayList<Integer>();
                int shiftReg = 0;
                int bitCount = 0;
                for (int x = 0; x < targetWidth; ++x) {
                    int usedX = x;
                    int usedY = y;
                    if (this.jCheckBoxXMirror.isSelected()) {
                        usedX = targetWidth - 1 - x;
                    }
                    if (this.jCheckBoxYMirror.isSelected()) {
                        usedY = targetHeight - 1 - y;
                    }
                    int rgba = scaledImage.getRGB(usedX, usedY);
                    boolean bit = this.getBitFromColor(rgba);
                    int mulValue = UtilityString.IntX(this.jTextFieldMultiplyBits.getText(), 1);
                    for (int ttt = 0; ttt < mulValue; ++ttt) {
                        if (bit) {
                            ++shiftReg;
                        }
                        if (++bitCount == 8) {
                            shiftRegRow.add(shiftReg);
                            ++rowWidth;
                            shiftReg = 0;
                            bitCount = 0;
                        }
                        shiftReg <<= 1;
                    }
                }
                while (bitCount < 8) {
                    if (++bitCount == 8) {
                        shiftRegRow.add(shiftReg);
                        ++rowWidth;
                    }
                    shiftReg <<= 1;
                }
                this.shiftRegRows[y] = shiftRegRow;
            }
        } else {
            for (int y = 0; y < targetHeight; ++y) {
                rowWidth = 0;
                ArrayList<GFXVector> vectorRow = new ArrayList<GFXVector>();
                this.vectorRows[y] = vectorRow;
                int oldGrayscale = -1;
                boolean oldShown = false;
                int xStart = 0;
                int yStart = y;
                for (int x = 0; x < targetWidth; ++x) {
                    int rgba = scaledImage.getRGB(x, y);
                    Color c = new Color(rgba);
                    boolean shown = false;
                    int grayscale = 0;
                    if (this.jRadioButtonAlphaAsGrayscale.isSelected()) {
                        int A = rgba >> 24 & 0xFF;
                        if (A > threshold) {
                            grayscale = A;
                            shown = true;
                        }
                    } else {
                        int B;
                        int G;
                        int R = c.getRed();
                        int brightness = (R + (G = c.getGreen()) + (B = c.getBlue())) / 3;
                        if (brightness > threshold) {
                            grayscale = brightness;
                            shown = true;
                        }
                    }
                    boolean forced = false;
                    if (x - xStart > 126) {
                        forced = true;
                    }
                    if (forced || (oldShown != shown || oldGrayscale != grayscale) && oldGrayscale != -1) {
                        GFXVector v = new GFXVector();
                        v.start.x(xStart - targetWidth / 2);
                        v.start.y(-yStart + targetHeight / 2);
                        v.end.x(x - 1 - targetWidth / 2);
                        v.end.y(-yStart + targetHeight / 2);
                        v.pattern = 255;
                        v.setIntensity(oldGrayscale);
                        xStart = x - 1;
                        vectorRow.add(v);
                    }
                    oldShown = shown;
                    oldGrayscale = grayscale;
                }
                GFXVector v = new GFXVector();
                v.start.x(xStart - targetWidth / 2);
                v.start.y(-yStart + targetHeight / 2);
                v.end.x(targetWidth - 1 - targetWidth / 2);
                v.end.y(-yStart + targetHeight / 2);
                v.pattern = 255;
                v.setIntensity(oldGrayscale);
                vectorRow.add(v);
            }
        }
        return true;
    }

    void buildVertical() {
        BufferedImage orgImage = this.singleImagePanel1.getImage();
        int targetWidth = UtilityString.IntX(this.jTextFieldVectorWitdh.getText(), orgImage.getWidth());
        int targetHeight = UtilityString.IntX(this.jTextFieldVectorHeight.getText(), orgImage.getHeight());
        int startX = UtilityString.IntX(this.jTextFieldStartX.getText(), 0);
        int startY = UtilityString.IntX(this.jTextFieldStartY.getText(), 0);
        int width = UtilityString.IntX(this.jTextFieldWidth.getText(), orgImage.getWidth() - startX);
        int height = UtilityString.IntX(this.jTextFieldHeight.getText(), orgImage.getHeight() - startY);
        orgImage = this.singleImagePanel1.getSelection((int)startX, (int)startY, (int)width, (int)height).image;
        BufferedImage scaledImage = ImageCache.getImageCache().getDerivatScale(orgImage, targetWidth, targetHeight);
        this.shiftRegCols = new ArrayList[targetWidth];
        this.vectorCols = new ArrayList[targetWidth];
        int colHeight = 0;
        if (!this.jCheckBoxIncludeBrightness.isSelected()) {
            for (int x = 0; x < targetWidth; ++x) {
                colHeight = 0;
                ArrayList<Integer> shiftRegCol = new ArrayList<Integer>();
                int shiftReg = 0;
                int bitCount = 0;
                for (int y = 0; y < targetHeight; ++y) {
                    int usedX = x;
                    int usedY = y;
                    if (this.jCheckBoxXMirror.isSelected()) {
                        usedX = targetWidth - 1 - x;
                    }
                    if (this.jCheckBoxYMirror.isSelected()) {
                        usedY = targetHeight - 1 - y;
                    }
                    int rgba = scaledImage.getRGB(usedX, usedY);
                    boolean bit = this.getBitFromColor(rgba);
                    int mulValue = UtilityString.IntX(this.jTextFieldMultiplyBits.getText(), 1);
                    for (int ttt = 0; ttt < mulValue; ++ttt) {
                        if (bit) {
                            ++shiftReg;
                        }
                        if (++bitCount == 8) {
                            shiftRegCol.add(shiftReg);
                            ++colHeight;
                            shiftReg = 0;
                            bitCount = 0;
                            if (this.jCheckBoxAssume9Bit.isSelected()) {
                                ++y;
                            }
                        }
                        shiftReg <<= 1;
                    }
                }
                while (bitCount < 8) {
                    if (++bitCount == 8) {
                        shiftRegCol.add(shiftReg);
                        ++colHeight;
                    }
                    shiftReg <<= 1;
                }
                this.shiftRegCols[x] = shiftRegCol;
            }
        }
    }

    boolean getBitFromColor(int rgba) {
        int threshold = this.jSliderThreshold.getValue();
        boolean bit = false;
        Color c = new Color(rgba);
        if (this.jRadioButtonAlphaAsGrayscale.isSelected()) {
            int A = rgba >> 24 & 0xFF;
            if (A > threshold) {
                bit = true;
            }
        } else {
            int B;
            int G;
            int R = c.getRed();
            int brightness = (R + (G = c.getGreen()) + (B = c.getBlue())) / 3;
            if (brightness > threshold) {
                bit = true;
            }
        }
        if (this.jCheckBoxInvert.isSelected()) {
            bit = !bit;
        }
        return bit;
    }

    void displayVectors() {
        this.singleVectorPanel1.setSharedRepaint(false);
        this.singleVectorPanel1.setDrawVectorEnds(false);
        BufferedImage orgImage = this.singleImagePanel1.getImage();
        int targetWidth = UtilityString.IntX(this.jTextFieldVectorWitdh.getText(), orgImage.getWidth());
        int targetHeight = UtilityString.IntX(this.jTextFieldVectorHeight.getText(), orgImage.getHeight());
        this.singleVectorPanel1.clearVectors();
        if (this.jRadioButtonHorizontalVectors.isSelected()) {
            if (!this.jCheckBoxIncludeBrightness.isSelected()) {
                int vy = 0 + targetHeight / 2;
                for (int y = 0; y < targetHeight; ++y) {
                    int vx = 0 - targetWidth / 2;
                    ArrayList<Integer> shiftRegRow = this.shiftRegRows[y];
                    for (int x = 0; x < shiftRegRow.size(); ++x) {
                        int brightness = 255;
                        int shiftreg = shiftRegRow.get(x);
                        for (int b = 0; b < 8; ++b) {
                            boolean bit = (shiftreg & 0x80) != 0;
                            shiftreg <<= 1;
                            int pattern = bit ? 255 : 0;
                            GFXVector v = new GFXVector();
                            v.start.x(vx);
                            v.start.y(vy);
                            v.end.x(vx + 1);
                            v.end.y(vy);
                            v.pattern = pattern;
                            v.setIntensity(brightness);
                            this.singleVectorPanel1.addForegroundVector(v);
                            ++vx;
                            if (!this.jCheckBoxAssume9Bit.isSelected() || b != 7) continue;
                            v = new GFXVector();
                            v.start.x(vx);
                            v.start.y(vy);
                            v.end.x(vx + 1);
                            v.end.y(vy);
                            v.pattern = pattern;
                            v.setIntensity(brightness);
                            this.singleVectorPanel1.addForegroundVector(v);
                            ++vx;
                        }
                    }
                    --vy;
                }
            } else {
                for (int y = 0; y < targetHeight; ++y) {
                    ArrayList<GFXVector> vectorRow = this.vectorRows[y];
                    for (GFXVector v : vectorRow) {
                        this.singleVectorPanel1.addForegroundVector(v);
                    }
                }
            }
        } else if (!this.jCheckBoxIncludeBrightness.isSelected()) {
            int vx = 0 - targetWidth / 2;
            for (int x = 0; x < targetWidth; ++x) {
                ArrayList<Integer> shiftRegCol = this.shiftRegCols[x];
                int vy = 0 + targetHeight / 2;
                for (int y = 0; y < shiftRegCol.size(); ++y) {
                    int brightness = 255;
                    int shiftreg = shiftRegCol.get(y);
                    for (int b = 0; b < 8; ++b) {
                        boolean bit = (shiftreg & 0x80) != 0;
                        shiftreg <<= 1;
                        int pattern = bit ? 255 : 0;
                        GFXVector v = new GFXVector();
                        v.start.x(vx);
                        v.start.y(vy);
                        v.end.x(vx);
                        v.end.y(vy + 1);
                        v.pattern = pattern;
                        v.setIntensity(brightness);
                        this.singleVectorPanel1.addForegroundVector(v);
                        ++vy;
                        if (!this.jCheckBoxAssume9Bit.isSelected() || b != 7) continue;
                        v = new GFXVector();
                        v.start.x(vx);
                        v.start.y(vy);
                        v.end.x(vx);
                        v.end.y(vy + 1);
                        v.pattern = pattern;
                        v.setIntensity(brightness);
                        this.singleVectorPanel1.addForegroundVector(v);
                        ++vy;
                    }
                }
                ++vx;
            }
        }
        this.singleVectorPanel1.setSharedRepaint(true);
    }

    void createASMFile() {
        String exampleMain;
        Path include2;
        Path template;
        int shiftreg;
        String basebaseName;
        String baseName;
        int li;
        if (this.orgName == null) {
            return;
        }
        if (this.orgName.length() == 0) {
            return;
        }
        if (!this.modal) {
            InternalFrameFileChoser fc = new InternalFrameFileChoser();
            fc.setDialogTitle("Select save directory");
            fc.setCurrentDirectory(new File(Global.mainPathPrefix));
            fc.setFileSelectionMode(1);
            int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
            if (r != 0) {
                return;
            }
            String lastPath = fc.getSelectedFile().getAbsolutePath();
            Path p = Paths.get(lastPath, new String[0]);
            String newName = p.toString();
            if (!newName.endsWith(File.separator)) {
                newName = newName + File.separator;
            }
            File f = new File(this.orgName);
            String nameOnly = f.getName();
            this.orgName = newName = newName + nameOnly;
        }
        if ((li = (baseName = this.orgName).lastIndexOf(".")) >= 0) {
            baseName = baseName.substring(0, li);
        }
        if ((basebaseName = baseName).contains(File.separator)) {
            basebaseName = basebaseName.substring(basebaseName.lastIndexOf(File.separator) + 1);
        }
        StringBuffer out = new StringBuffer();
        BufferedImage orgImage = this.singleImagePanel1.getImage();
        int targetHeight = UtilityString.IntX(this.jTextFieldVectorHeight.getText(), orgImage.getHeight());
        int targetWidth = UtilityString.IntX(this.jTextFieldVectorWitdh.getText(), orgImage.getWidth());
        if (targetHeight == 0) {
            return;
        }
        if (this.jRadioButtonHorizontalVectors.isSelected()) {
            this.singleVectorPanel1.clearVectors();
            if (this.jCheckBoxIncludeBrightness.isSelected()) {
                out.append("; format:\n");
                out.append("; brightness, deltx, brightness, deltx...brightness, deltx,  -Value [negative brightness]\n");
                out.append("; ....\n");
                out.append("; brightness, deltx, brightness, deltx...brightness, deltx,  -Value [negative brightness]\n");
                out.append("; -Value [negative brightness]\n");
                out.append("; every second row is a 'backward' row\n");
                out.append("; backward rows have the direction reversed!\n");
                out.append("VScale equ 1\n");
                String vScaleString = "*VScale";
                out.append(basebaseName + "_data:\n");
                for (int y = 0; y < targetHeight; ++y) {
                    int xvalue;
                    ArrayList<GFXVector> vectorRow = this.vectorRows[y];
                    out.append(" db ");
                    boolean start = true;
                    if (y % 2 == 0) {
                        for (GFXVector v : vectorRow) {
                            if (!start) {
                                out.append(", ");
                            }
                            out.append(String.format("$%02X", v.getIntensity() / 2));
                            xvalue = (int)(v.end.x() - v.start.x()) & 0xFF;
                            if (xvalue > 127) {
                                out.append(", -" + String.format("$%02X", -(xvalue -= 256)) + vScaleString);
                            } else {
                                out.append(",  " + String.format("$%02X", xvalue) + vScaleString);
                            }
                            start = false;
                        }
                        out.append(", $ff ; one row of forward data\n");
                        continue;
                    }
                    for (int i = vectorRow.size() - 1; i >= 0; --i) {
                        GFXVector v;
                        v = vectorRow.get(i);
                        if (!start) {
                            out.append(", ");
                        }
                        out.append(String.format("$%02X", v.getIntensity() / 2));
                        xvalue = (int)(v.start.x() - v.end.x()) & 0xFF;
                        if (xvalue > 127) {
                            out.append(", -" + String.format("$%02X", -(xvalue -= 256)) + vScaleString);
                        } else {
                            out.append(",  " + String.format("$%02X", xvalue) + vScaleString);
                        }
                        start = false;
                    }
                    out.append(", $ff ; one row of backward data\n");
                }
                out.append(" db $ff ; end of data \n");
            } else {
                out.append("; format:\n");
                out.append("; height, width\n");
                out.append("; shiftreg, ...,  shiftreg\n");
                out.append("; ....\n");
                out.append("; shiftreg, ...,  shiftreg\n");
                out.append("; \n");
                if (this.jCheckBoxBiDirectionalData.isSelected()) {
                    out.append("; every second row is a 'backward' row\n");
                    out.append("; backward rows have the direction AND the bits reversed!\n");
                }
                out.append(basebaseName + "_data:\n");
                out.append(" db " + String.format("$%02X", targetHeight) + ", " + String.format("$%02X ", this.shiftRegRows[0].size()) + "\n");
                for (int y = 0; y < targetHeight; ++y) {
                    int x;
                    ArrayList<Integer> shiftRegRow;
                    if (this.jCheckBoxBiDirectionalData.isSelected()) {
                        if (y % 2 == 0) {
                            out.append(" db ");
                            shiftRegRow = this.shiftRegRows[y];
                            for (x = 0; x < shiftRegRow.size(); ++x) {
                                shiftreg = shiftRegRow.get(x);
                                if (x != 0) {
                                    out.append(", ");
                                }
                                out.append("%" + String.format("%8s", Integer.toBinaryString(shiftreg)).replace(" ", "0"));
                            }
                            out.append("; forward\n");
                            continue;
                        }
                        out.append(" db ");
                        shiftRegRow = this.shiftRegRows[y];
                        for (x = shiftRegRow.size() - 1; x >= 0; --x) {
                            shiftreg = shiftRegRow.get(x);
                            shiftreg = this.bitReverse8(shiftreg);
                            if (x != shiftRegRow.size() - 1) {
                                out.append(", ");
                            }
                            out.append("%" + String.format("%8s", Integer.toBinaryString(shiftreg)).replace(" ", "0"));
                        }
                        out.append("; backward\n");
                        continue;
                    }
                    out.append(" db ");
                    shiftRegRow = this.shiftRegRows[y];
                    for (x = 0; x < shiftRegRow.size(); ++x) {
                        shiftreg = shiftRegRow.get(x);
                        if (x != 0) {
                            out.append(", ");
                        }
                        out.append("%" + String.format("%8s", Integer.toBinaryString(shiftreg)).replace(" ", "0"));
                    }
                    out.append("; forward\n");
                }
            }
        } else {
            this.singleVectorPanel1.clearVectors();
            out.append("; format:\n");
            out.append("; height, width\n");
            out.append("; shiftreg, ...,  shiftreg\n");
            out.append("; ....\n");
            out.append("; shiftreg, ...,  shiftreg\n");
            out.append("; \n");
            out.append(basebaseName + "_data:\n");
            out.append(" db " + String.format("$%02X", targetWidth) + ", " + String.format("$%02X ", this.shiftRegCols[0].size()) + "\n");
            for (int x = 0; x < targetWidth; ++x) {
                out.append(" db ");
                ArrayList<Integer> shiftRegCol = this.shiftRegCols[x];
                for (int y = 0; y < shiftRegCol.size(); ++y) {
                    shiftreg = shiftRegCol.get(y);
                    if (y != 0) {
                        out.append(", ");
                    }
                    out.append("%" + String.format("%8s", Integer.toBinaryString(shiftreg)).replace(" ", "0"));
                }
                out.append("; forward\n");
            }
        }
        String asm = out.toString();
        String fileNameData = baseName + ".asm";
        String dataLabel = basebaseName + "_data";
        String pathName = Paths.get(fileNameData, new String[0]).getParent().toString();
        if (this.jCheckBoxGenerateData.isEnabled()) {
            UtilityFiles.createTextFile(fileNameData, asm);
        }
        if (this.jRadioButtonHorizontalVectors.isSelected()) {
            if (this.jCheckBoxGenerateExampleCode.isEnabled()) {
                if (!this.jCheckBoxBiDirectionalData.isSelected()) {
                    template = Paths.get(Global.mainPathPrefix, "template", "rasterDrawUni.template");
                    UtilityFiles.copyOneFile(template.toString(), pathName + File.separator + "rasterDraw.asm");
                    include2 = Paths.get(Global.mainPathPrefix, "template", "VECTREX.I");
                    UtilityFiles.copyOneFile(include2.toString(), pathName + File.separator + "VECTREX.I");
                    template = Paths.get(Global.mainPathPrefix, "template", "rasterExampleMainUni.template");
                } else {
                    template = Paths.get(Global.mainPathPrefix, "template", "rasterDraw.template");
                    UtilityFiles.copyOneFile(template.toString(), pathName + File.separator + "rasterDraw.asm");
                    include2 = Paths.get(Global.mainPathPrefix, "template", "VECTREX.I");
                    UtilityFiles.copyOneFile(include2.toString(), pathName + File.separator + "VECTREX.I");
                    template = Paths.get(Global.mainPathPrefix, "template", "rasterExampleMain.template");
                }
                exampleMain = UtilityString.readTextFileToOneString(new File(template.toString()));
                exampleMain = UtilityString.replace(exampleMain, "#DATAFILE#", basebaseName + ".asm");
                exampleMain = UtilityString.replace(exampleMain, "#RASTERDATA#", dataLabel);
                exampleMain = UtilityString.replace(exampleMain, "#WIDTH#", "$40");
                exampleMain = UtilityString.replace(exampleMain, "#HEIGHT#", "10");
                exampleMain = UtilityString.replace(exampleMain, "#XPOS#", "-$40");
                exampleMain = UtilityString.replace(exampleMain, "#YPOS#", "10");
                UtilityFiles.createTextFile(pathName + File.separator + basebaseName + "Main.asm", exampleMain);
            }
        } else if (this.jCheckBoxGenerateExampleCode.isEnabled()) {
            template = Paths.get(Global.mainPathPrefix, "template", "rasterDrawVertical.template");
            UtilityFiles.copyOneFile(template.toString(), pathName + File.separator + "rasterDrawVertical.asm");
            include2 = Paths.get(Global.mainPathPrefix, "template", "VECTREX.I");
            UtilityFiles.copyOneFile(include2.toString(), pathName + File.separator + "VECTREX.I");
            template = Paths.get(Global.mainPathPrefix, "template", "rasterExampleVerticalMain.template");
            exampleMain = UtilityString.readTextFileToOneString(new File(template.toString()));
            exampleMain = UtilityString.replace(exampleMain, "#DATAFILE#", basebaseName + ".asm");
            exampleMain = UtilityString.replace(exampleMain, "#RASTERDATA#", dataLabel);
            exampleMain = UtilityString.replace(exampleMain, "#WIDTH#", "$40");
            exampleMain = UtilityString.replace(exampleMain, "#HEIGHT#", "120");
            exampleMain = UtilityString.replace(exampleMain, "#XPOS#", "-$70");
            exampleMain = UtilityString.replace(exampleMain, "#YPOS#", "10");
            UtilityFiles.createTextFile(pathName + File.separator + basebaseName + "Main.asm", exampleMain);
        }
        if (!this.modal) {
            VediPanel.openInVedi(pathName + File.separator + basebaseName + "Main.asm");
        }
    }

    int bitReverse8(int shiftreg) {
        int ret = 0;
        for (int b = 0; b < 8; ++b) {
            ret >>= 1;
            if ((shiftreg & 0x80) != 0) {
                ret |= 0x80;
            }
            shiftreg <<= 1;
        }
        return ret;
    }

    @Override
    public void deIconified() {
    }
}

