/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi.raster;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.config.TinyLogInterface;
import de.malban.graphics.GFXVector;
import de.malban.graphics.GFXVectorList;
import de.malban.graphics.SingleImagePanel;
import de.malban.graphics.SingleVectorPanel;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.ImageCache;
import de.malban.gui.Windowable;
import de.malban.gui.components.CSAView;
import de.malban.gui.dialogs.InternalFrameFileChoser;
import de.malban.gui.image.DespeckleFilter;
import de.malban.gui.image.SmartBlurFilter;
import de.malban.gui.image.ThresholdFilter;
import de.malban.gui.panels.LogPanel;
import de.malban.util.UtilityFiles;
import de.malban.util.UtilityImage;
import de.malban.util.UtilityString;
import de.malban.vide.veccy.VeccyPanel;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class VectorJPanel
extends JPanel
implements Windowable {
    LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    StringBuilder outGobblerString = null;
    String pathOnly = "";
    TinyLogInterface tinyLog = null;
    private int mClassSetting = 0;
    private CSAView mParent = null;
    private JMenuItem mParentMenuItem = null;
    Thread two = null;
    String orgName = "";
    BufferedImage baseImage;
    String lastImagePath = Global.mainPathPrefix;
    double xFactor = 1.0;
    double yFactor = 1.0;
    private ButtonGroup buttonGroup1;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButtonEnlarge;
    private JButton jButtonLoad;
    private JButton jButtonLoad1;
    private JButton jButtonShrink;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBoxGenerateData;
    private JCheckBox jCheckBoxGenerateExampleCode;
    private JComboBox<String> jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel3;
    private JRadioButton jRadioButtonAutotrace;
    private JRadioButton jRadioButtonPotrace;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JSlider jSlider1;
    private JSlider jSlider2;
    private JSlider jSliderBlurRadius;
    private JSlider jSliderBlurThreshold;
    private JSlider jSliderCombineAngle;
    private JSlider jSliderCombinePixelLen;
    private JSlider jSliderCombineUpscale;
    private JSlider jSliderDespeckle;
    private JSlider jSliderSourceScale;
    private JSlider jSliderThreshold;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextField jTextField3;
    private JTextField jTextField4;
    private JTextField jTextFieldHeight;
    private JTextField jTextFieldScaleFactor;
    private JTextField jTextFieldStartX;
    private JTextField jTextFieldStartY;
    private JTextField jTextFieldWidth;
    private SingleImagePanel singleImagePanel1;
    private SingleImagePanel singleImagePanel2;
    private SingleVectorPanel singleVectorPanel1;
    VeccyPanel veccy = null;
    static long uid = 0L;
    boolean building = false;
    static boolean isMac = Global.getOSName().toUpperCase().contains("MAC");
    static boolean isWin = Global.getOSName().toUpperCase().contains("WIN");
    static boolean isLinux = Global.getOSName().toUpperCase().contains("LIN");

    @Override
    public void closing() {
    }

    @Override
    public boolean isIcon() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return false;
        }
        return frame.getInternalFrame(this).isIcon();
    }

    @Override
    public void setIcon(boolean b) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return;
        }
        try {
            frame.getInternalFrame(this).setIcon(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void setParentWindow(CSAView jpv) {
        this.mParent = jpv;
    }

    @Override
    public void setMenuItem(JMenuItem item) {
        this.mParentMenuItem = item;
        this.mParentMenuItem.setText("Vector: Image to Vector");
    }

    @Override
    public JMenuItem getMenuItem() {
        return this.mParentMenuItem;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    public VectorJPanel() {
        this.initComponents();
    }

    public VectorJPanel(String filename, TinyLogInterface tl) {
        this.tinyLog = tl;
        this.initComponents();
        this.setImage(filename);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jButtonLoad = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextFieldWidth = new JTextField();
        this.jTextFieldHeight = new JTextField();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.singleImagePanel1 = new SingleImagePanel();
        this.jSliderThreshold = new JSlider();
        this.jLabel5 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.singleVectorPanel1 = new SingleVectorPanel();
        this.jSliderSourceScale = new JSlider();
        this.jCheckBoxGenerateData = new JCheckBox();
        this.jCheckBoxGenerateExampleCode = new JCheckBox();
        this.jSliderCombinePixelLen = new JSlider();
        this.jSliderCombineAngle = new JSlider();
        this.jLabel9 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jButton1 = new JButton();
        this.jTextField2 = new JTextField();
        this.jLabel10 = new JLabel();
        this.jTextField3 = new JTextField();
        this.jCheckBox1 = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.singleImagePanel2 = new SingleImagePanel();
        this.jSliderDespeckle = new JSlider();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jSliderBlurRadius = new JSlider();
        this.jLabel15 = new JLabel();
        this.jSliderBlurThreshold = new JSlider();
        this.jButton2 = new JButton();
        this.jLabel16 = new JLabel();
        this.jTextFieldStartX = new JTextField();
        this.jLabel17 = new JLabel();
        this.jTextFieldStartY = new JTextField();
        this.jSlider1 = new JSlider();
        this.jLabel18 = new JLabel();
        this.jSlider2 = new JSlider();
        this.jLabel19 = new JLabel();
        this.jSliderCombineUpscale = new JSlider();
        this.jLabel14 = new JLabel();
        this.jButtonShrink = new JButton();
        this.jButtonEnlarge = new JButton();
        this.jTextFieldScaleFactor = new JTextField();
        this.jLabel6 = new JLabel();
        this.jRadioButtonPotrace = new JRadioButton();
        this.jRadioButtonAutotrace = new JRadioButton();
        this.jComboBox1 = new JComboBox();
        this.jTextField4 = new JTextField();
        this.jLabel20 = new JLabel();
        this.jButtonLoad1 = new JButton();
        this.setPreferredSize(new Dimension(960, 537));
        this.jButtonLoad.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_go.png")));
        this.jButtonLoad.setToolTipText("load from disk");
        this.jButtonLoad.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VectorJPanel.this.jButtonLoadActionPerformed(evt);
            }
        });
        this.jLabel1.setText("size");
        this.jTextFieldWidth.setEditable(false);
        this.jTextFieldHeight.setEditable(false);
        this.jLabel2.setText("x");
        this.singleImagePanel1.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                VectorJPanel.this.singleImagePanel1MouseDragged(evt);
            }
        });
        GroupLayout singleImagePanel1Layout = new GroupLayout(this.singleImagePanel1);
        this.singleImagePanel1.setLayout(singleImagePanel1Layout);
        singleImagePanel1Layout.setHorizontalGroup(singleImagePanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 318, Short.MAX_VALUE));
        singleImagePanel1Layout.setVerticalGroup(singleImagePanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 318, Short.MAX_VALUE));
        this.jScrollPane1.setViewportView(this.singleImagePanel1);
        this.jSliderThreshold.setMajorTickSpacing(50);
        this.jSliderThreshold.setMaximum(255);
        this.jSliderThreshold.setMinorTickSpacing(5);
        this.jSliderThreshold.setPaintLabels(true);
        this.jSliderThreshold.setPaintTicks(true);
        this.jSliderThreshold.setValue(60);
        this.jSliderThreshold.setPreferredSize(new Dimension(322, 45));
        this.jSliderThreshold.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                VectorJPanel.this.jSliderThresholdStateChanged(evt);
            }
        });
        this.jLabel5.setText("threshold");
        GroupLayout singleVectorPanel1Layout = new GroupLayout(this.singleVectorPanel1);
        this.singleVectorPanel1.setLayout(singleVectorPanel1Layout);
        singleVectorPanel1Layout.setHorizontalGroup(singleVectorPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 318, Short.MAX_VALUE));
        singleVectorPanel1Layout.setVerticalGroup(singleVectorPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 318, Short.MAX_VALUE));
        this.jScrollPane2.setViewportView(this.singleVectorPanel1);
        this.jSliderSourceScale.setMajorTickSpacing(1);
        this.jSliderSourceScale.setMaximum(25);
        this.jSliderSourceScale.setMinimum(1);
        this.jSliderSourceScale.setMinorTickSpacing(1);
        this.jSliderSourceScale.setOrientation(1);
        this.jSliderSourceScale.setPaintTicks(true);
        this.jSliderSourceScale.setSnapToTicks(true);
        this.jSliderSourceScale.setValue(20);
        this.jSliderSourceScale.setPreferredSize(new Dimension(39, 292));
        this.jSliderSourceScale.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                VectorJPanel.this.jSliderSourceScaleStateChanged(evt);
            }
        });
        this.jCheckBoxGenerateData.setText("generate data file");
        this.jCheckBoxGenerateData.setEnabled(false);
        this.jCheckBoxGenerateExampleCode.setText("example code file");
        this.jCheckBoxGenerateExampleCode.setEnabled(false);
        this.jSliderCombinePixelLen.setMajorTickSpacing(10);
        this.jSliderCombinePixelLen.setMinorTickSpacing(1);
        this.jSliderCombinePixelLen.setPaintLabels(true);
        this.jSliderCombinePixelLen.setPaintTicks(true);
        this.jSliderCombinePixelLen.setValue(2);
        this.jSliderCombinePixelLen.setPreferredSize(new Dimension(322, 45));
        this.jSliderCombinePixelLen.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                VectorJPanel.this.jSliderCombinePixelLenStateChanged(evt);
            }
        });
        this.jSliderCombineAngle.setMajorTickSpacing(5);
        this.jSliderCombineAngle.setMaximum(45);
        this.jSliderCombineAngle.setMinorTickSpacing(1);
        this.jSliderCombineAngle.setPaintLabels(true);
        this.jSliderCombineAngle.setPaintTicks(true);
        this.jSliderCombineAngle.setValue(10);
        this.jSliderCombineAngle.setPreferredSize(new Dimension(322, 45));
        this.jSliderCombineAngle.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                VectorJPanel.this.jSliderCombineAngleStateChanged(evt);
            }
        });
        this.jLabel9.setText("polygon count");
        this.jButton1.setText("auto limit to:");
        this.jButton1.setEnabled(false);
        this.jTextField2.setEnabled(false);
        this.jLabel10.setText("vector count");
        this.jCheckBox1.setText("no end points");
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VectorJPanel.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.jLabel3.setText("minimal vector length");
        this.jLabel4.setText("minimal vector angle");
        this.jLabel7.setText("original");
        this.jLabel8.setText("black and white");
        this.jLabel11.setText("vectorized");
        GroupLayout singleImagePanel2Layout = new GroupLayout(this.singleImagePanel2);
        this.singleImagePanel2.setLayout(singleImagePanel2Layout);
        singleImagePanel2Layout.setHorizontalGroup(singleImagePanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 320, Short.MAX_VALUE));
        singleImagePanel2Layout.setVerticalGroup(singleImagePanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 318, Short.MAX_VALUE));
        this.jScrollPane3.setViewportView(this.singleImagePanel2);
        this.jSliderDespeckle.setMajorTickSpacing(5);
        this.jSliderDespeckle.setMaximum(25);
        this.jSliderDespeckle.setMinorTickSpacing(1);
        this.jSliderDespeckle.setPaintLabels(true);
        this.jSliderDespeckle.setPaintTicks(true);
        this.jSliderDespeckle.setValue(0);
        this.jSliderDespeckle.setPreferredSize(new Dimension(322, 45));
        this.jSliderDespeckle.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                VectorJPanel.this.jSliderDespeckleStateChanged(evt);
            }
        });
        this.jLabel12.setText("despeckle");
        this.jLabel13.setText("smart blur radius");
        this.jSliderBlurRadius.setMajorTickSpacing(20);
        this.jSliderBlurRadius.setMinorTickSpacing(10);
        this.jSliderBlurRadius.setPaintLabels(true);
        this.jSliderBlurRadius.setPaintTicks(true);
        this.jSliderBlurRadius.setValue(0);
        this.jSliderBlurRadius.setPreferredSize(new Dimension(322, 45));
        this.jSliderBlurRadius.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                VectorJPanel.this.jSliderBlurRadiusStateChanged(evt);
            }
        });
        this.jLabel15.setText("threshold");
        this.jSliderBlurThreshold.setMajorTickSpacing(20);
        this.jSliderBlurThreshold.setMinorTickSpacing(10);
        this.jSliderBlurThreshold.setPaintLabels(true);
        this.jSliderBlurThreshold.setPaintTicks(true);
        this.jSliderBlurThreshold.setValue(0);
        this.jSliderBlurThreshold.setPreferredSize(new Dimension(322, 45));
        this.jSliderBlurThreshold.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                VectorJPanel.this.jSliderBlurThresholdStateChanged(evt);
            }
        });
        this.jButton2.setText("to vecci");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VectorJPanel.this.jButton2ActionPerformed(evt);
            }
        });
        this.jLabel16.setText("start");
        this.jTextFieldStartX.setEditable(false);
        this.jTextFieldStartX.setText("0");
        this.jLabel17.setText(",");
        this.jTextFieldStartY.setEditable(false);
        this.jTextFieldStartY.setText("0");
        this.jSlider1.setOrientation(1);
        this.jSlider1.setValue(100);
        this.jSlider1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                VectorJPanel.this.jSlider1StateChanged(evt);
            }
        });
        this.jLabel18.setText("x factor");
        this.jSlider2.setOrientation(1);
        this.jSlider2.setValue(100);
        this.jSlider2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                VectorJPanel.this.jSlider2StateChanged(evt);
            }
        });
        this.jLabel19.setText("y factor");
        this.jSliderCombineUpscale.setMajorTickSpacing(10);
        this.jSliderCombineUpscale.setMinimum(1);
        this.jSliderCombineUpscale.setMinorTickSpacing(1);
        this.jSliderCombineUpscale.setPaintTicks(true);
        this.jSliderCombineUpscale.setValue(10);
        this.jSliderCombineUpscale.setPreferredSize(new Dimension(322, 45));
        this.jSliderCombineUpscale.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                VectorJPanel.this.jSliderCombineUpscaleStateChanged(evt);
            }
        });
        this.jLabel14.setText("upscaling");
        this.jButtonShrink.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/delete.png")));
        this.jButtonShrink.setToolTipText("shrink vectorlist");
        this.jButtonShrink.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonShrink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VectorJPanel.this.jButtonShrinkActionPerformed(evt);
            }
        });
        this.jButtonEnlarge.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/add.png")));
        this.jButtonEnlarge.setToolTipText("expand vectorlist");
        this.jButtonEnlarge.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonEnlarge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VectorJPanel.this.jButtonEnlargeActionPerformed(evt);
            }
        });
        this.jTextFieldScaleFactor.setText("1.5");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSliderDespeckle, -1, -1, -2).addComponent(this.jSliderBlurRadius, -1, -1, -2).addComponent(this.jSliderBlurThreshold, -1, -1, -2).addComponent(this.jLabel5).addComponent(this.jLabel12).addComponent(this.jLabel13).addComponent(this.jLabel15))).addGroup(jPanel3Layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jScrollPane1, -2, 320, -2)).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jSliderThreshold, -2, -1, -2))).addGap(6, 6, 6).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jSliderCombinePixelLen, -1, -1, -2).addComponent(this.jLabel4).addComponent(this.jSliderCombineAngle, -1, -1, -2).addComponent(this.jScrollPane3, -2, 322, -2))).addGroup(jPanel3Layout.createSequentialGroup().addGap(330, 330, 330).addComponent(this.jLabel8)).addGroup(jPanel3Layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jLabel7)).addGroup(jPanel3Layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabel16).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldStartX, -2, 44, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel17).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldStartY, -2, 44, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addComponent(this.jTextFieldWidth, -2, 44, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addComponent(this.jButtonShrink).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonEnlarge).addGap(13, 13, 13))).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldScaleFactor, GroupLayout.Alignment.LEADING, -2, 44, -2).addComponent(this.jTextFieldHeight, -2, 44, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -2, 320, -2).addComponent(this.jCheckBox1).addComponent(this.jCheckBoxGenerateData).addComponent(this.jCheckBoxGenerateExampleCode).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9).addComponent(this.jLabel10).addComponent(this.jButton1)).addGap(13, 13, 13).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField2, -2, 69, -2).addComponent(this.jTextField3, -2, 49, -2).addComponent(this.jTextField1, -2, 49, -2)))).addGap(6, 6, 6)).addGroup(GroupLayout.Alignment.LEADING, jPanel3Layout.createSequentialGroup().addComponent(this.jLabel14).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE))).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSliderSourceScale, -1, -1, -2).addComponent(this.jSlider2, -2, 25, -2).addComponent(this.jLabel19).addComponent(this.jLabel18).addComponent(this.jSlider1, -2, 25, -2))).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jSliderCombineUpscale, -2, 229, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton2).addGap(1, 1, 1)))).addGroup(jPanel3Layout.createSequentialGroup().addGap(666, 666, 666).addComponent(this.jLabel11))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(373, 373, 373).addComponent(this.jSlider1, -2, 73, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel18).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider2, -2, 73, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel19).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton2).addGap(11, 11, 11)).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jLabel8).addComponent(this.jLabel11)).addGap(5, 5, 5).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSliderSourceScale, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, -2, 320, -2).addComponent(this.jScrollPane3, -2, 320, -2)).addComponent(this.jScrollPane2, -2, 320, -2)).addGap(5, 5, 5).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldHeight, -2, -1, -2).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldWidth, -2, -1, -2).addComponent(this.jLabel2)).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldStartY, -2, -1, -2).addComponent(this.jLabel1)).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldStartX, -2, -1, -2).addComponent(this.jLabel17).addComponent(this.jLabel16)).addComponent(this.jCheckBox1)).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(6, 6, 6).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel3)).addGap(13, 13, 13).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel10).addComponent(this.jTextField3, -2, -1, -2)).addGap(44, 44, 44).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jTextField2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxGenerateData).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxGenerateExampleCode).addGap(18, 18, 18).addComponent(this.jLabel14)).addGroup(jPanel3Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButtonShrink).addComponent(this.jButtonEnlarge).addComponent(this.jTextFieldScaleFactor, -2, -1, -2)).addGap(2, 2, 2).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSliderCombinePixelLen, -2, -1, -2).addComponent(this.jSliderThreshold, -2, -1, -2)).addGap(6, 6, 6).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel12)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSliderCombineAngle, -2, -1, -2).addComponent(this.jSliderDespeckle, -2, -1, -2)).addGap(6, 6, 6).addComponent(this.jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSliderBlurRadius, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel15).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSliderBlurThreshold, -2, -1, -2)).addComponent(this.jSliderCombineUpscale, -2, -1, -2))).addGroup(jPanel3Layout.createSequentialGroup().addGap(373, 373, 373).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.jTextField1, -2, -1, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("image settings", this.jPanel3);
        this.jLabel6.setText("load image file");
        this.buttonGroup1.add(this.jRadioButtonPotrace);
        this.jRadioButtonPotrace.setSelected(true);
        this.jRadioButtonPotrace.setText("potrace");
        this.jRadioButtonPotrace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VectorJPanel.this.jRadioButtonPotraceActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonAutotrace);
        this.jRadioButtonAutotrace.setText("autotrace");
        this.jRadioButtonAutotrace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VectorJPanel.this.jRadioButtonAutotraceActionPerformed(evt);
            }
        });
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"black", "white"}));
        this.jComboBox1.setToolTipText("only autotrace");
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VectorJPanel.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jTextField4.setText("0.2");
        this.jTextField4.setToolTipText("<html>\nonly autotrace\n<BR>\ninto how many single vectors curves are \"splitted\", the higher (0.5, 1, 2,3,4...) the blockier\n</html>");
        this.jTextField4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VectorJPanel.this.jTextField4ActionPerformed(evt);
            }
        });
        this.jLabel20.setText("error-Threshold");
        this.jButtonLoad1.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/paste_plain.png")));
        this.jButtonLoad1.setToolTipText("Paste from clipboard");
        this.jButtonLoad1.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonLoad1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VectorJPanel.this.jButtonLoad1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1).addGroup(layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonLoad).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonLoad1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonPotrace).addGap(35, 35, 35).addComponent(this.jRadioButtonAutotrace).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jComboBox1, -2, 107, -2).addGap(77, 77, 77).addComponent(this.jLabel20).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextField4, -2, 65, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonLoad).addComponent(this.jLabel6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonPotrace, -2, 21, -2).addComponent(this.jRadioButtonAutotrace, -2, 21, -2)).addComponent(this.jComboBox1, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField4, -2, -1, -2).addComponent(this.jLabel20)).addComponent(this.jButtonLoad1)).addComponent(this.jTabbedPane1)));
    }

    private void jButtonLoadActionPerformed(ActionEvent evt) {
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        fc.setMultiSelectionEnabled(true);
        if (this.lastImagePath.length() != 0) {
            fc.setCurrentDirectory(new File(this.lastImagePath));
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Images", "jpg", "jpeg", "png", "bmp", "gif");
        fc.setFileFilter(filter);
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return;
        }
        File[] files = fc.getSelectedFiles();
        String fullPath = files == null || files.length == 1 ? fc.getSelectedFile().getAbsolutePath() : files[0].getAbsolutePath();
        this.lastImagePath = fullPath;
        this.setImage(fullPath);
    }

    private void jSliderThresholdStateChanged(ChangeEvent evt) {
        this.buildVectors();
    }

    private void jSliderSourceScaleStateChanged(ChangeEvent evt) {
        int value = this.jSliderSourceScale.getValue();
        int max = this.jSliderSourceScale.getMaximum();
        double scale = value - (max - 1) / 2;
        if (value < max / 2 + 1) {
            int invScale = max / 2 + 2 - value;
            scale = 1.0 / (double)invScale;
        }
        this.singleVectorPanel1.setScale(scale);
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        this.singleVectorPanel1.setDrawVectorEnds(!this.jCheckBox1.isSelected());
    }

    private void jSliderCombinePixelLenStateChanged(ChangeEvent evt) {
        this.buildVectors();
    }

    private void jSliderCombineAngleStateChanged(ChangeEvent evt) {
        this.buildVectors();
    }

    private void jSliderDespeckleStateChanged(ChangeEvent evt) {
        this.buildVectors();
    }

    private void jSliderBlurRadiusStateChanged(ChangeEvent evt) {
        this.buildVectors();
    }

    private void jSliderBlurThresholdStateChanged(ChangeEvent evt) {
        this.buildVectors();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        if (this.veccy != null) {
            this.veccy.setCurrentVectorList(this.singleVectorPanel1.getForegroundVectorList().clone());
            return;
        }
        CSAMainFrame mainFrame = Configuration.getConfiguration().getMainFrame();
        this.veccy = mainFrame.getVeccy();
        this.veccy.setVPanel(this);
        this.setVeccy(this.veccy);
        this.veccy.setCurrentVectorList(this.singleVectorPanel1.getForegroundVectorList().clone());
    }

    private void singleImagePanel1MouseDragged(MouseEvent evt) {
        int tmp;
        if (this.baseImage == null) {
            return;
        }
        int x = (int)((double)evt.getX() / 1.0);
        int y = (int)((double)evt.getY() / 1.0);
        int sX = this.singleImagePanel1.getPressedStartX();
        int sY = this.singleImagePanel1.getPressedStartY();
        if (x < 0) {
            x = 0;
        }
        if (sX < 0) {
            sX = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (sY < 0) {
            sY = 0;
        }
        if (x > this.baseImage.getWidth()) {
            x = this.baseImage.getWidth();
        }
        if (sX > this.baseImage.getWidth()) {
            sX = this.baseImage.getWidth();
        }
        if (y > this.baseImage.getHeight()) {
            y = this.baseImage.getHeight();
        }
        if (sY > this.baseImage.getHeight()) {
            sY = this.baseImage.getHeight();
        }
        if (x < sX) {
            tmp = sX;
            sX = x;
            x = tmp;
        }
        if (y < sY) {
            tmp = sY;
            sY = y;
            y = tmp;
        }
        int w = x - sX;
        int h = y - sY;
        this.jTextFieldStartX.setText("" + sX);
        this.jTextFieldStartY.setText("" + sY);
        this.jTextFieldWidth.setText("" + w);
        this.jTextFieldHeight.setText("" + h);
        this.buildVectors();
    }

    private void jSlider1StateChanged(ChangeEvent evt) {
        this.xFactor = (double)this.jSlider1.getValue() / 100.0;
        this.buildVectors();
    }

    private void jSlider2StateChanged(ChangeEvent evt) {
        this.yFactor = (double)this.jSlider2.getValue() / 100.0;
        this.buildVectors();
    }

    private void jSliderCombineUpscaleStateChanged(ChangeEvent evt) {
        this.buildVectors();
    }

    private void jRadioButtonPotraceActionPerformed(ActionEvent evt) {
        this.buildVectors();
    }

    private void jRadioButtonAutotraceActionPerformed(ActionEvent evt) {
        this.buildVectors();
    }

    private void jTextField4ActionPerformed(ActionEvent evt) {
        this.buildVectors();
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        this.buildVectors();
    }

    private void jButtonLoad1ActionPerformed(ActionEvent evt) {
        this.singleImagePanel1.setImageFromClipboard();
        this.baseImage = this.singleImagePanel1.getImage();
        if (this.singleImagePanel1.getSourceWidth() > 320 || this.singleImagePanel1.getSourceHeight() > 320) {
            this.singleImagePanel1.scaleToFit();
        }
        this.jTextFieldWidth.setText("" + this.singleImagePanel1.getSourceWidth());
        this.jTextFieldHeight.setText("" + this.singleImagePanel1.getSourceHeight());
        this.jSliderSourceScaleStateChanged(null);
        this.buildVectors();
    }

    private void jButtonShrinkActionPerformed(ActionEvent evt) {
        double scale = 1.0 / (double)UtilityString.FloatX(this.jTextFieldScaleFactor.getText(), 2.0f);
        this.singleImagePanel1.setScale(scale);
        this.singleImagePanel1.bakeScale();
        this.baseImage = this.singleImagePanel1.getImage();
        if (this.singleImagePanel1.getSourceWidth() > 320 || this.singleImagePanel1.getSourceHeight() > 320) {
            this.singleImagePanel1.scaleToFit();
        }
        this.jTextFieldWidth.setText("" + this.singleImagePanel1.getSourceWidth());
        this.jTextFieldHeight.setText("" + this.singleImagePanel1.getSourceHeight());
        this.jSliderSourceScaleStateChanged(null);
        this.buildVectors();
    }

    private void jButtonEnlargeActionPerformed(ActionEvent evt) {
        double scale = UtilityString.FloatX(this.jTextFieldScaleFactor.getText(), 2.0f);
        this.singleImagePanel1.setScale(scale);
        this.singleImagePanel1.bakeScale();
        this.baseImage = this.singleImagePanel1.getImage();
        if (this.singleImagePanel1.getSourceWidth() > 320 || this.singleImagePanel1.getSourceHeight() > 320) {
            this.singleImagePanel1.scaleToFit();
        }
        this.jTextFieldWidth.setText("" + this.singleImagePanel1.getSourceWidth());
        this.jTextFieldHeight.setText("" + this.singleImagePanel1.getSourceHeight());
        this.jSliderSourceScaleStateChanged(null);
        this.buildVectors();
    }

    public void setVeccy(VeccyPanel vp) {
        this.veccy = vp;
    }

    public static void showModPanelNoModal(VeccyPanel v) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        VectorJPanel panel = new VectorJPanel();
        if (v != null) {
            v.setVPanel(panel);
            panel.veccy = v;
        }
        Configuration.getConfiguration().getMainFrame().addAsWindow(panel, 1080, 800, "Vector: Image to Vector");
    }

    public static void showModPanelNoModal(String fileName, TinyLogInterface tl) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        VectorJPanel panel = new VectorJPanel(fileName, tl);
        Configuration.getConfiguration().getMainFrame().addAsWindow(panel, 1080, 800, "Vector: Image to Vector");
    }

    public void setImage(String filename) {
        this.orgName = filename;
        this.singleImagePanel1.setImage(this.orgName);
        this.baseImage = this.singleImagePanel1.getImage();
        if (this.singleImagePanel1.getSourceWidth() > 320 || this.singleImagePanel1.getSourceHeight() > 320) {
            this.singleImagePanel1.scaleToFit();
        }
        this.jTextFieldWidth.setText("" + this.singleImagePanel1.getSourceWidth());
        this.jTextFieldHeight.setText("" + this.singleImagePanel1.getSourceHeight());
        this.jSliderSourceScaleStateChanged(null);
        this.buildVectors();
    }

    public boolean buildVectors() {
        if (this.baseImage == null) {
            return false;
        }
        if (this.building) {
            return false;
        }
        this.building = true;
        int startX = UtilityString.IntX(this.jTextFieldStartX.getText(), 0);
        int startY = UtilityString.IntX(this.jTextFieldStartY.getText(), 0);
        int width = UtilityString.IntX(this.jTextFieldWidth.getText(), this.baseImage.getWidth() - startX);
        int height = UtilityString.IntX(this.jTextFieldHeight.getText(), this.baseImage.getHeight() - startY);
        double upscale = (double)this.jSliderCombineUpscale.getValue() / 10.0;
        if (width == 0) {
            this.building = false;
            return false;
        }
        if (height == 0) {
            this.building = false;
            return false;
        }
        BufferedImage orgImage = this.baseImage;
        String filenameTMP = Global.mainPathPrefix + "tmp" + File.separator + "tmpImage" + uid++ + ".bmp";
        try {
            Features features;
            boolean result;
            BufferedImage filteredImage = UtilityImage.toNonAlpha(orgImage);
            DespeckleFilter despeckleFilter = new DespeckleFilter();
            for (int d = 0; d < this.jSliderDespeckle.getValue(); ++d) {
                filteredImage = despeckleFilter.filter(filteredImage, null);
            }
            if (this.jSliderBlurRadius.getValue() > 0 && this.jSliderBlurThreshold.getValue() > 0) {
                SmartBlurFilter blurFilter = new SmartBlurFilter();
                blurFilter.setRadius(this.jSliderBlurRadius.getValue());
                blurFilter.setThreshold(this.jSliderBlurThreshold.getValue());
                filteredImage = blurFilter.filter(filteredImage, null);
            }
            this.singleImagePanel1.setBaseImage(filteredImage);
            this.singleImagePanel1.setNoMouseRection(false);
            ThresholdFilter bwFilter = new ThresholdFilter(this.jSliderThreshold.getValue());
            filteredImage = bwFilter.filter(filteredImage, null);
            filteredImage = filteredImage.getSubimage(startX, startY, width, height);
            this.singleImagePanel2.setBaseImage(filteredImage);
            if (upscale != 1.0) {
                filteredImage = ImageCache.getImageCache().getDerivatScale(filteredImage, (int)((double)width * upscale), (int)((double)height * upscale));
            }
            if (!(result = ImageIO.write((RenderedImage)(filteredImage = UtilityImage.toNonAlpha(filteredImage)), "BMP", new File(filenameTMP)))) {
                this.building = false;
                return false;
            }
            ArrayList<Object> vList = new ArrayList();
            String outFilename = filenameTMP.substring(0, filenameTMP.length() - 4) + ".vec";
            result = this.jRadioButtonPotrace.isSelected() ? this.executePoTrace(filenameTMP, outFilename) : this.executeAutotrace(filenameTMP);
            if (!result) {
                this.building = false;
                return false;
            }
            if (this.jRadioButtonPotrace.isSelected()) {
                features = this.readJSONData(outFilename, filteredImage.getWidth(), filteredImage.getHeight());
            } else {
                while (!this.outGobblerString.toString().contains("</svg>")) {
                    Thread.sleep(10L);
                }
                features = this.readSVGData(this.outGobblerString.toString(), filteredImage.getWidth(), filteredImage.getHeight());
            }
            features = this.cullBorders(features);
            int combinePixelLen = this.jSliderCombinePixelLen.getValue();
            double combineAngle = (double)(180 - this.jSliderCombineAngle.getValue()) * (Math.PI / 180);
            features = this.optimizeMesh(features, combinePixelLen, combineAngle);
            features = this.cullEmpty(features);
            int scale = 4;
            vList = this.generateGFXVectorList(features);
            this.jTextField1.setText("" + vList.size());
            GFXVectorList vectorList = this.concat(vList);
            this.jTextField3.setText("" + vectorList.list.size());
            this.singleVectorPanel1.clearForegroundVectorList();
            this.centerVectorList(vectorList);
            this.singleVectorPanel1.addForegroundVectorList(vectorList.list);
        }
        catch (Throwable e) {
            this.log.addLog(e, LogPanel.WARN);
            this.building = false;
            return false;
        }
        this.building = false;
        UtilityFiles.cleanDirectory(Global.mainPathPrefix + "tmp");
        return true;
    }

    void centerVectorList(GFXVectorList vl) {
        double minX = 2.147483647E9;
        double maxX = -2.147483647E9;
        double minY = 2.147483647E9;
        double maxY = -2.147483647E9;
        double minZ = 2.147483647E9;
        double maxZ = -2.147483647E9;
        for (int i = 0; i < vl.size(); ++i) {
            GFXVector v = vl.get(i);
            if (minX > v.start.x()) {
                minX = v.start.x();
            }
            if (minX > v.end.x()) {
                minX = v.end.x();
            }
            if (maxX < v.start.x()) {
                maxX = v.start.x();
            }
            if (maxX < v.end.x()) {
                maxX = v.end.x();
            }
            if (minY > v.start.y()) {
                minY = v.start.y();
            }
            if (minY > v.end.y()) {
                minY = v.end.y();
            }
            if (maxY < v.start.y()) {
                maxY = v.start.y();
            }
            if (maxY < v.end.y()) {
                maxY = v.end.y();
            }
            if (minZ > v.start.z()) {
                minZ = v.start.z();
            }
            if (minZ > v.end.z()) {
                minZ = v.end.z();
            }
            if (maxZ < v.start.z()) {
                maxZ = v.start.z();
            }
            if (!(maxZ < v.end.z())) continue;
            maxZ = v.end.z();
        }
        double difX = maxX - minX;
        double difY = maxY - minY;
        double difZ = maxZ - minZ;
        int translocationX = (int)(maxX - difX / 2.0);
        int translocationY = (int)(maxY - difY / 2.0);
        int translocationZ = (int)(maxZ - difZ / 2.0);
        HashMap<String, Boolean> done = new HashMap<String, Boolean>();
        for (int i = 0; i < vl.size(); ++i) {
            GFXVector v = vl.get(i);
            if (done.get("" + v.start.uid) == null) {
                v.start.x(v.start.x() - (double)translocationX);
                v.start.y(v.start.y() - (double)translocationY);
                v.start.z(v.start.z() - (double)translocationZ);
                done.put("" + v.start.uid, true);
            }
            if (done.get("" + v.end.uid) != null) continue;
            v.end.x(v.end.x() - (double)translocationX);
            v.end.y(v.end.y() - (double)translocationY);
            v.end.z(v.end.z() - (double)translocationZ);
            done.put("" + v.end.uid, true);
        }
    }

    ArrayList<GFXVectorList> generateGFXVectorList_(Features in) {
        ArrayList<GFXVectorList> vList = new ArrayList<GFXVectorList>();
        for (Feature feature : in.feature) {
            for (Poly poly : feature.poly) {
                GFXVectorList vectorList = new GFXVectorList();
                boolean first = true;
                for (VPoint coord : poly.coords) {
                    GFXVector gFXVector = new GFXVector();
                }
                vList.add(vectorList);
            }
        }
        return vList;
    }

    Features readJSONData(String filename, int imageWidth, int imageHeight) {
        Features features = new Features();
        try {
            FileReader reader = new FileReader(filename);
            JSONObject jobj = (JSONObject)new JSONParser().parse(reader);
            JSONArray featuresArray = (JSONArray)jobj.get("features");
            int featureCount = 0;
            for (Object f : featuresArray) {
                JSONObject geometry = (JSONObject)((JSONObject)f).get("geometry");
                JSONArray polygonArray = (JSONArray)geometry.get("coordinates");
                int polygonCount = 0;
                Feature feature = new Feature();
                for (Object p : polygonArray) {
                    JSONArray polyArray = (JSONArray)p;
                    Poly poly = new Poly();
                    int coordsCount = 0;
                    for (Object c : polyArray) {
                        JSONArray coords = (JSONArray)c;
                        double val0 = (Double)coords.get(0);
                        double val1 = (Double)coords.get(1);
                        val0 *= 255.0;
                        val1 *= 255.0;
                        VPoint point = new VPoint((int)(val0 /= (double)imageWidth), (int)(val1 /= (double)imageHeight));
                        ++coordsCount;
                        poly.coords.add(point);
                    }
                    ++polygonCount;
                    feature.poly.add(poly);
                }
                ++featureCount;
                features.feature.add(feature);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
        return features;
    }

    Features cullBorders(Features in) {
        Features retFeatures = new Features();
        for (Feature feature : in.feature) {
            Feature retFeature = new Feature();
            for (Poly poly : feature.poly) {
                Poly retPoly = new Poly();
                for (VPoint coord : poly.coords) {
                    if (coord.x <= 1 || coord.x >= 254 || coord.y <= 1 || coord.y >= 254) continue;
                    retPoly.coords.add(new VPoint(coord.x, coord.y));
                }
                retFeature.poly.add(retPoly);
            }
            retFeatures.feature.add(retFeature);
        }
        return retFeatures;
    }

    Features optimizeMesh(Features in, int combinePixelLen, double combineAngle) {
        Features retFeatures = new Features();
        int skippy = 0;
        for (Feature feature : in.feature) {
            Feature retFeature = new Feature();
            for (Poly poly : feature.poly) {
                Poly retPoly = new Poly();
                int coordsCount = 0;
                int px = -9999;
                int py = -9999;
                for (VPoint coord : poly.coords) {
                    boolean skip = false;
                    int x = coord.x;
                    int dx = x - px;
                    int y = coord.y;
                    int dy = y - py;
                    if (dx * dx + dy * dy <= combinePixelLen * combinePixelLen) {
                        skip = true;
                    }
                    double a = 1.5707963267948966;
                    if (coordsCount + 1 < poly.coords.size()) {
                        a = this.calcAngle(px, py, x, y, poly.coords.get((int)(coordsCount + 1)).x, poly.coords.get((int)(coordsCount + 1)).y);
                    }
                    if (a < 0.0) {
                        a = -a;
                    }
                    if (a > Math.PI) {
                        a = Math.PI * 2 - a;
                    }
                    if (!(a < combineAngle)) {
                        skip = true;
                    }
                    if (!skip) {
                        retPoly.coords.add(new VPoint(x, y));
                        px = x;
                        py = y;
                    } else {
                        ++skippy;
                    }
                    ++coordsCount;
                }
                retFeature.poly.add(retPoly);
            }
            retFeatures.feature.add(retFeature);
        }
        return retFeatures;
    }

    Features cullEmpty(Features in) {
        Features retFeatures = new Features();
        for (Feature feature : in.feature) {
            Feature retFeature = new Feature();
            for (Poly poly : feature.poly) {
                if (poly.coords.size() <= 0) continue;
                retFeature.poly.add(poly);
            }
            if (feature.poly.size() <= 0) continue;
            retFeatures.feature.add(retFeature);
        }
        return retFeatures;
    }

    Features scaleRel(Features in, int sc) {
        int scaleMode = 1;
        if (!this.jRadioButtonPotrace.isSelected()) {
            scaleMode = -1;
        }
        int px = 128 * sc;
        int py = 128 * sc;
        Features retFeatures = new Features();
        for (Feature feature : in.feature) {
            Feature retFeature = new Feature();
            for (Poly poly : feature.poly) {
                Poly retPoly = new Poly();
                int coordsCount = 0;
                boolean first = true;
                for (VPoint coord : poly.coords) {
                    int divy;
                    double div;
                    int x = coord.x * sc;
                    int y = coord.y * sc;
                    double dx = x - px;
                    double dy = y - py;
                    int divx = (int)Math.abs(dx / 127.0) + 1;
                    double d = div = divx > (divy = (int)Math.abs(dy / 127.0) + 1) ? (double)divx : (double)divy;
                    if (first) {
                        if (dx != 0.0 || dy != 0.0) {
                            VPoint retPoint = new VPoint((int)(dx / div), (int)(dy / div) * scaleMode);
                            retPoint.flagSign = "c";
                            retPoint.flag = (int)div;
                            px = (int)((double)px + (double)((int)(dx / div)) * div);
                            py = (int)((double)py + (double)((int)(dy / div)) * div);
                            retPoly.coords.add(retPoint);
                        }
                    } else {
                        int i = 0;
                        while ((double)i < div) {
                            VPoint retPoint = new VPoint((int)(dx / div), (int)(dy / div) * scaleMode);
                            px += (int)(dx / div);
                            py += (int)(dy / div);
                            retPoint.flagSign = "c";
                            retPoly.coords.add(retPoint);
                            ++i;
                        }
                    }
                    first = false;
                }
                ++coordsCount;
                retFeature.poly.add(retPoly);
            }
            retFeatures.feature.add(retFeature);
        }
        return retFeatures;
    }

    double calcAngle(int x1, int y1, int x2, int y2, int x3, int y3) {
        double dv1x = x2 - x1;
        double dv1y = y2 - y1;
        double dv2x = x2 - x3;
        double dv2y = y2 - y3;
        double n1 = Math.sqrt(dv1x * dv1x + dv1y * dv1y);
        double n2 = Math.sqrt(dv2x * dv2x + dv2y * dv2y);
        double np = n1 * n2;
        double dp = dv1x * dv2x + dv1y * dv2y;
        if (Math.abs(np) < 1.0E-4) {
            return 1.5707963267948966;
        }
        return Math.acos(dp / np);
    }

    public boolean executePoTrace(String filename, String outFilename) {
        if (isMac) {
            return this.executePoTraceMac(filename, outFilename);
        }
        if (isWin) {
            return this.executePoTraceWin(filename, outFilename);
        }
        if (isLinux) {
            return this.executePoTraceLin(filename, outFilename);
        }
        return false;
    }

    public boolean executePoTraceMac(String filename, String outFilename) {
        int bits = Global.getOSBit();
        String osDir = "mac" + bits;
        String filepath = Global.mainPathPrefix + "externalTools" + File.separator + "potrace" + File.separator + osDir + File.separator + "potrace";
        String[] cmd = new String[]{filepath, "-a0", "-O1", "-bgeojson", "-o" + outFilename, filename};
        this.log.addLog("Starting Mac potrace...", LogPanel.INFO);
        return this.executeOSCommand(cmd);
    }

    public boolean executePoTraceWin(String filename, String outFilename) {
        int bits = Global.getOSBit();
        String osDir = "win" + bits;
        String filepath = Global.mainPathPrefix + "externalTools" + File.separator + "potrace" + File.separator + osDir + File.separator + "potrace.exe";
        String[] cmd = new String[]{filepath, "-a0", "-O1", "-bgeojson", "-o" + outFilename, filename};
        this.log.addLog("Starting Win potrace...", LogPanel.INFO);
        return this.executeOSCommand(cmd);
    }

    public boolean executePoTraceLin(String filename, String outFilename) {
        int bits = Global.getOSBit();
        String osDir = "linux" + bits;
        String filepath = Global.mainPathPrefix + "externalTools" + File.separator + "potrace" + File.separator + osDir + File.separator + "potrace";
        String[] cmd = new String[]{filepath, "-a0", "-O1", "-bgeojson", "-o" + outFilename, filename};
        this.log.addLog("Starting Linux potrace...", LogPanel.INFO);
        return this.executeOSCommand(cmd);
    }

    boolean executeOSCommand(String[] cmd) {
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            StreamGobbler errorGobbler = new StreamGobbler(p.getErrorStream(), "ERROR");
            StreamGobbler outputGobbler = new StreamGobbler(p.getInputStream(), "OUTPUT");
            errorGobbler.start();
            outputGobbler.start();
            p.waitFor();
        }
        catch (Throwable e) {
            this.log.addLog(e, LogPanel.WARN);
            return false;
        }
        return true;
    }

    ArrayList<GFXVectorList> generateGFXVectorList(Features in) {
        int scaleMode = 1;
        if (!this.jRadioButtonPotrace.isSelected()) {
            scaleMode = -1;
        }
        ArrayList<GFXVectorList> vListList = new ArrayList<GFXVectorList>();
        for (Feature feature : in.feature) {
            for (Poly poly : feature.poly) {
                GFXVectorList vList = new GFXVectorList();
                GFXVector lastVector = null;
                for (VPoint coord : poly.coords) {
                    GFXVector thisVector = new GFXVector();
                    int x = coord.x - 128;
                    int y = coord.y - 128;
                    x = (int)((double)x * this.xFactor);
                    y = (int)((double)y * this.yFactor) * scaleMode;
                    if (lastVector == null) {
                        thisVector.end.x(x);
                        thisVector.end.y(y);
                    } else {
                        thisVector.start = lastVector.end;
                        thisVector.end.x(x);
                        thisVector.end.y(y);
                        vList.list.add(thisVector);
                    }
                    lastVector = thisVector;
                }
                if (vList.list.size() <= 0) continue;
                vListList.add(vList);
            }
        }
        return vListList;
    }

    GFXVectorList concat(ArrayList<GFXVectorList> vList) {
        GFXVectorList ret = new GFXVectorList();
        for (GFXVectorList vl : vList) {
            for (GFXVector vl2 : vl.list) {
                ret.list.add(vl2);
            }
        }
        return ret;
    }

    @Override
    public void deIconified() {
    }

    public boolean executeAutotrace(String filename) {
        boolean b = false;
        if (isMac) {
            b = this.executeAutotraceMac(filename);
        }
        if (isWin) {
            b = this.executeAutotraceWin(filename);
        }
        if (isLinux) {
            b = this.executeAutotraceLin(filename);
        }
        return b;
    }

    public boolean executeAutotraceMac(String filename) {
        int bits = Global.getOSBit();
        String osDir = "mac" + bits;
        String filepath = Global.mainPathPrefix + "externalTools" + File.separator + "autotrace" + File.separator + osDir + File.separator + "MacOS" + File.separator + "autotrace";
        String[] cmd = new String[]{filepath, this.jComboBox1.getSelectedIndex() == 0 ? "-background-color=000000" : "-background-color=ffffff", "-error-threshold=" + this.jTextField4.getText(), "-centerline", "-line-reversion-threshold=1000", "-line-threshold=1000", "-output-format=svg", filename};
        this.log.addLog("Starting Mac autotrace...", LogPanel.INFO);
        return this.executeOSCommand(cmd);
    }

    public boolean executeAutotraceWin(String filename) {
        int bits = Global.getOSBit();
        String osDir = "win" + bits;
        String filepath = Global.mainPathPrefix + "externalTools" + File.separator + "autotrace" + File.separator + osDir + File.separator + "autotrace.exe";
        String[] cmd = new String[]{filepath, this.jComboBox1.getSelectedIndex() == 0 ? "-background-color=000000" : "-background-color=ffffff", "-error-threshold=" + this.jTextField4.getText(), "-centerline", "-line-reversion-threshold=1000", "-line-threshold=1000", "-output-format=svg", filename};
        this.log.addLog("Starting Win autotrace...", LogPanel.INFO);
        return this.executeOSCommand(cmd);
    }

    public boolean executeAutotraceLin(String filename) {
        int bits = Global.getOSBit();
        String osDir = "linux" + bits;
        String filepath = Global.mainPathPrefix + "externalTools" + File.separator + "autotrace" + File.separator + osDir + File.separator + "autotrace";
        String[] cmd = new String[]{filepath, this.jComboBox1.getSelectedIndex() == 0 ? "-background-color=000000" : "-background-color=ffffff", "-error-threshold=" + this.jTextField4.getText(), "-centerline", "-line-reversion-threshold=1000", "-line-threshold=1000", "-output-format=svg", filename};
        this.log.addLog("Starting Linux autotrace...", LogPanel.INFO);
        return this.executeOSCommand(cmd);
    }

    Features readSVGData(String data2, int imageWidth, int imageHeight) {
        Features features = new Features();
        Feature feature = new Feature();
        features.feature.add(feature);
        int globalX = 0;
        int globalY = 0;
        int oldMoveX = 0;
        int oldMoveY = 0;
        try {
            SVGStream svg = new SVGStream(data2);
            String mode = "";
            String nextMode = "";
            while (svg.toNextPath()) {
                Poly poly = null;
                while (!mode.equals("x")) {
                    VPoint point;
                    double val1;
                    double val0;
                    nextMode = svg.nextMode();
                    int x = svg.nextIntNumber();
                    int y = svg.nextIntNumber();
                    if (nextMode.equals("L") || nextMode.equals("M")) {
                        globalX = x;
                        globalY = y;
                    }
                    if (nextMode.equals("l") || nextMode.equals("m")) {
                        globalX += x;
                        globalY += y;
                    }
                    nextMode = nextMode.toLowerCase();
                    if (mode.equals("l") && !nextMode.equals("l")) {
                        feature.poly.add(poly);
                        poly = null;
                    } else if (!mode.equals("l") && nextMode.equals("l")) {
                        poly = new Poly();
                        if (mode.equals("m")) {
                            val0 = oldMoveX;
                            val1 = oldMoveY;
                            val0 *= 255.0;
                            val1 *= 255.0;
                            point = new VPoint((int)(val0 /= (double)imageWidth), (int)(val1 /= (double)imageHeight));
                            poly.coords.add(point);
                        }
                        val0 = globalX;
                        val1 = globalY;
                        val0 *= 255.0;
                        val1 *= 255.0;
                        point = new VPoint((int)(val0 /= (double)imageWidth), (int)(val1 /= (double)imageHeight));
                        poly.coords.add(point);
                    } else if (nextMode.equals("l")) {
                        val0 = globalX;
                        val1 = globalY;
                        val0 *= 255.0;
                        val1 *= 255.0;
                        point = new VPoint((int)(val0 /= (double)imageWidth), (int)(val1 /= (double)imageHeight));
                        poly.coords.add(point);
                    }
                    if (!(mode = nextMode).equals("m")) continue;
                    oldMoveX = globalX;
                    oldMoveY = globalY;
                }
                if (poly == null) continue;
                feature.poly.add(poly);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
        return features;
    }

    class SVGStream {
        String err = "";
        String s;
        String work;
        int pos;
        String mode = "";

        SVGStream(String ss) {
            this.s = ss;
            this.work = ss;
            this.pos = 0;
        }

        void error(String s) {
            this.err = this.err + "(" + this.pos + "): " + s + "\n";
        }

        boolean toNextPath() {
            int p = this.work.indexOf("d=\"");
            if (p < 0) {
                return false;
            }
            this.work = this.work.substring(p + 3);
            this.pos = this.pos + p + 3;
            return true;
        }

        void skipSpaces() {
            char m;
            int p = 0;
            do {
                m = this.work.substring(p, p + 1).charAt(0);
                ++p;
                ++this.pos;
            } while (m == ' ');
            --this.pos;
            if (--p > 0) {
                this.work = this.work.substring(p);
            }
        }

        String nextMode() {
            this.skipSpaces();
            char m = this.peekChar();
            if (m != 'L' && m != 'l' && m != 'M' && m != 'm') {
                this.mode = "x";
                return this.mode;
            }
            this.mode = "" + this.getChar();
            return this.mode;
        }

        char peekChar() {
            if (this.work.length() == 0) {
                this.error("stream end");
                return '\u0000';
            }
            return this.work.substring(0, 1).charAt(0);
        }

        char getChar() {
            if (this.work.length() == 0) {
                this.error("stream end");
                return '\u0000';
            }
            char m = this.work.substring(0, 1).charAt(0);
            ++this.pos;
            this.work = this.work.substring(1);
            return m;
        }

        int nextIntNumber() {
            int ret = 0;
            this.skipSpaces();
            char m = this.peekChar();
            while (m >= '0' && m <= '9') {
                m = this.getChar();
                ret *= 10;
                ret += m - 48;
                m = this.peekChar();
            }
            if (m == '.') {
                m = this.getChar();
                m = this.peekChar();
                while (m >= '0' && m <= '9') {
                    m = this.getChar();
                    m = this.peekChar();
                }
            }
            return ret;
        }
    }

    class StreamGobbler
    extends Thread {
        InputStream is;
        String type;

        StreamGobbler(InputStream is, String type) {
            this.is = is;
            this.type = type;
            if (type.equals("OUTPUT")) {
                VectorJPanel.this.outGobblerString = new StringBuilder();
            }
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (this.type.equals("ERROR")) {
                        if (VectorJPanel.this.tinyLog != null) {
                            VectorJPanel.this.tinyLog.printError(line);
                        }
                        VectorJPanel.this.log.addLog(line, LogPanel.WARN);
                        continue;
                    }
                    if (VectorJPanel.this.tinyLog != null) {
                        VectorJPanel.this.tinyLog.printMessage(line);
                    }
                    VectorJPanel.this.log.addLog(line, LogPanel.INFO);
                    VectorJPanel.this.outGobblerString.append(line + "\n");
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    class Features {
        ArrayList<Feature> feature = new ArrayList();

        Features() {
        }
    }

    class Feature {
        ArrayList<Poly> poly = new ArrayList();

        Feature() {
        }
    }

    class Poly {
        ArrayList<VPoint> coords = new ArrayList();

        Poly() {
        }
    }

    class VPoint {
        int x;
        int y;
        int flag;
        String flagSign;

        public VPoint(int _x, int _y) {
            this.x = _x;
            this.y = _y;
        }
    }
}

