/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi.sound;

import de.malban.config.Configuration;
import de.malban.config.TinyLogInterface;
import de.malban.gui.panels.LogPanel;
import de.malban.util.UtilityString;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class AKSBin {
    int trackNo = 0;
    HashMap<Integer, Track> trackMap = new HashMap();
    String[] notes = new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"};
    public static final int CM_BYTE = 1;
    public static final int CM_WORD_1 = 2;
    public static final int CM_WORD_2 = 3;
    public static final int CM_POINTER_1 = 4;
    public static final int CM_POINTER_2 = 5;

    public String buildData(String pathFull, TinyLogInterface logi, String labelID) {
        StringBuilder ret = new StringBuilder();
        LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
        int offset = 0;
        try {
            Path path = Paths.get(pathFull, new String[0]);
            byte[] dataB = Files.readAllBytes(path);
            int[] data2 = new int[dataB.length];
            int c = 0;
            for (byte b : dataB) {
                data2[c] = dataB[c] & 0xFF;
                ++c;
            }
            if (data2[0] != 65 || data2[1] != 84 || data2[2] != 49 || data2[3] != 48) {
                logi.printError("No Arkos Tracker signature found - aborting.");
                return "";
            }
            AKSMemory aks = new AKSMemory(data2, labelID);
            aks.get((int)0).ommit = true;
            aks.get((int)1).ommit = true;
            aks.get((int)2).ommit = true;
            aks.get((int)3).ommit = true;
            aks.get((int)4).ommit = true;
            aks.get((int)5).ommit = true;
            aks.get((int)6).ommit = true;
            aks.get((int)7).ommit = true;
            aks.get((int)8).ommit = true;
            aks.addPreComment(9, "This file was build using VIDE - Vectrex Integrated Development Environment");
            aks.addPreComment(9, "Original bin file was: " + pathFull);
            aks.addPreComment(9, "");
            aks.addComment(9, "default speed");
            int sizeOfInstrumentTable = data2[10] + data2[11] * 256;
            aks.setTypeWord(10);
            aks.addComment(10, "size of instrument table (without this word pointer)");
            boolean instrumentCount = false;
            int address = 12;
            int instrumentTableAddress = 12;
            offset = 0;
            offset = data2[13] * 256;
            aks.setOffset(offset);
            aks.addPreComment(9, "offset for AKS file assumed: $" + UtilityString.convertToHexWord(offset) + " guessed by accessing byte data[13] * 256)");
            aks.addPreComment(9, "not used by vectrex player and therefor omitted:");
            aks.addPreComment(9, " DB \"AT10\" ; Signature of Arkos Tracker files");
            aks.addPreComment(9, " DB $" + UtilityString.convertToHex(data2, 4, 5, "") + " ; sample channel");
            aks.addPreComment(9, " DB $" + UtilityString.convertToHex(data2, 5, 8, ", ") + " ; YM custom frequence - little endian");
            aks.addPreComment(9, " DB $" + UtilityString.convertToHex(data2, 8, 9, "") + " ; Replay frequency (0=13hz,1=25hz,2=50hz,3=100hz,4=150hz,5=300hz)");
            aks.addLabel(9, "SongAddress");
            Linker linker = new Linker(data2, address += sizeOfInstrumentTable, aks);
            ArrayList<SpecialTrack> stracks = new ArrayList<SpecialTrack>();
            ArrayList<Instrument> instruments = new ArrayList<Instrument>();
            int lfd = 0;
            Set<Map.Entry<Integer, Integer>> entries = aks.specialtrackPointer.entrySet();
            for (Map.Entry<Integer, Integer> entry : entries) {
                Integer trackAddress = entry.getValue();
                stracks.add(new SpecialTrack(data2, trackAddress, lfd++, aks));
            }
            instruments.add(new Instrument(data2, instrumentTableAddress, 0, aks));
            entries = aks.instrumentCounter.entrySet();
            for (Map.Entry<Integer, Integer> entry : entries) {
                Integer instrumentNo = entry.getValue();
                if (instrumentNo == 0) continue;
                instruments.add(new Instrument(data2, instrumentTableAddress, instrumentNo, aks));
            }
            ret.append(aks);
        }
        catch (Throwable e) {
            logi.printError("Something went wrong with AKS - please look in the log.");
            log.addLog(e, LogPanel.WARN);
        }
        return ret.toString();
    }

    class Linker {
        int firstHeight;
        int transposition1;
        int transposition2;
        int transposition3;
        int specialTrack;
        String specialTrackString;
        int[] data;
        int linkerStart;
        int height = 0;
        ArrayList<Pattern> patterns = new ArrayList();

        Linker(int[] d, int ls, AKSMemory aks) {
            Pattern p;
            this.data = d;
            this.linkerStart = ls;
            this.height = this.firstHeight = d[this.linkerStart];
            this.transposition1 = d[this.linkerStart + 1];
            this.transposition2 = d[this.linkerStart + 2];
            this.transposition3 = d[this.linkerStart + 3];
            this.specialTrack = this.data[this.linkerStart + 4] + this.data[this.linkerStart + 5] * 256 - aks.offset;
            this.specialTrackString = "$" + String.format("%04X", this.specialTrack);
            aks.addLabel(this.linkerStart, "linker");
            aks.addSpecialtrackPointer(this.specialTrack);
            aks.addPreComment(this.linkerStart, "start of linker definition");
            aks.addComment(this.linkerStart, "first height");
            aks.addComment(this.linkerStart + 1, "transposition1");
            aks.addComment(this.linkerStart + 2, "transposition2");
            aks.addComment(this.linkerStart + 3, "transposition3");
            aks.addComment(this.linkerStart + 4, "specialTrack");
            aks.setTypePointer(this.linkerStart + 4);
            int address = this.linkerStart + 6;
            int patternCount = 0;
            do {
                p = new Pattern(this.data, address, patternCount++, aks, this.height);
                this.height = p.height;
                this.patterns.add(p);
                address += p.size();
            } while (!p.songOver);
        }
    }

    class Pattern {
        int[] data;
        int patternStart;
        int size;
        public boolean songOver = false;
        int lfd;
        int height = 0;

        Pattern(int[] d, int ps, int l, AKSMemory aks, int defaultHeight) {
            this.height = defaultHeight;
            this.lfd = l;
            this.data = d;
            int address = this.patternStart = ps;
            int state = this.data[address++];
            aks.addComment(address - 1, "pattern " + this.lfd + " state");
            aks.addLabel(address - 1, "pattern" + this.lfd + "Definition");
            int t1 = -1;
            int t2 = -1;
            int t3 = -1;
            if ((state & 1) == 1) {
                this.songOver = true;
                int songRestart = this.data[address] + this.data[address + 1] * 256;
                aks.addComment(address, "song restart address");
                aks.setTypePointer(address);
                address += 2;
            } else {
                if ((state & 2) == 2) {
                    aks.addComment(address++, "transposition 1");
                }
                if ((state & 4) == 4) {
                    aks.addComment(address++, "transposition 2");
                }
                if ((state & 8) == 8) {
                    aks.addComment(address++, "transposition 3");
                }
                t1 = this.data[address] + this.data[address + 1] * 256 - aks.offset;
                aks.addComment(address, "pattern " + this.lfd + ", track 1");
                aks.setTypePointer(address);
                t2 = this.data[address += 2] + this.data[address + 1] * 256 - aks.offset;
                aks.addComment(address, "pattern " + this.lfd + ", track 2");
                aks.setTypePointer(address);
                t3 = this.data[address += 2] + this.data[address + 1] * 256 - aks.offset;
                aks.addComment(address, "pattern " + this.lfd + ", track 3");
                aks.setTypePointer(address);
                address += 2;
                if ((state & 0x10) == 16) {
                    this.height = d[address];
                    aks.addComment(address++, "new height");
                }
                if ((state & 0x20) == 32) {
                    int st = this.data[address] + this.data[address + 1] * 256 - aks.offset;
                    aks.addComment(address, "New Special Track");
                    aks.setTypePointer(address);
                    address += 2;
                    aks.addSpecialtrackPointer(st);
                }
            }
            if (t1 != -1) {
                Track t_1 = AKSBin.this.trackMap.get(t1);
                if (t_1 != null) {
                    t_1.update(this.height);
                } else {
                    t_1 = new Track(this.data, t1, AKSBin.this.trackNo++, aks, this.height);
                    AKSBin.this.trackMap.put(t1, t_1);
                }
            }
            if (t2 != -1) {
                Track t_2 = AKSBin.this.trackMap.get(t2);
                if (t_2 != null) {
                    t_2.update(this.height);
                    AKSBin.this.trackMap.put(t2, t_2);
                } else {
                    t_2 = new Track(this.data, t2, AKSBin.this.trackNo++, aks, this.height);
                }
            }
            if (t3 != -1) {
                Track t_3 = AKSBin.this.trackMap.get(t3);
                if (t_3 != null) {
                    t_3.update(this.height);
                } else {
                    t_3 = new Track(this.data, t3, AKSBin.this.trackNo++, aks, this.height);
                    AKSBin.this.trackMap.put(t3, t_3);
                }
            }
            this.size = address - this.patternStart;
        }

        public int size() {
            return this.size;
        }
    }

    class SpecialTrack {
        int[] data;
        int trackStart;
        int size;
        int lfd;

        SpecialTrack(int[] d, int ts, int l, AKSMemory aks) {
            this.lfd = l;
            this.data = d;
            int address = this.trackStart = ts;
            aks.addLabel(address, "specialtrackDef" + this.lfd);
            int count = 0;
            while (count < 128) {
                int st0;
                if (((st0 = d[address++]) & 1) == 0) {
                    int w = st0 >>> 1;
                    if (w == 0) {
                        w = 128;
                    }
                    aks.addComment(address - 1, "wait " + w);
                    count += w;
                    continue;
                }
                aks.addComment(address - 1, "data");
                if ((st0 & 0xFC) == 0) {
                    int st1 = d[address++];
                    aks.addComment(address - 1, "escaped data");
                    continue;
                }
                if ((st0 & 2) == 2) {
                    aks.addComment(address - 1, "digidrum (ignored by vectrex player)");
                    continue;
                }
                if ((st0 & 2) != 0) continue;
                aks.addComment(address - 1, "speed " + (st0 >>>= 2));
            }
        }
    }

    class Track {
        int[] data;
        int trackStart;
        int size;
        int lfd;
        int height = 0;
        AKSMemory aks;

        void update(int maxHeight) {
            if (this.height >= maxHeight) {
                return;
            }
            this.height = maxHeight;
            int address = this.trackStart;
            this.aks.setLabel(this.trackStart, "trackDef" + this.lfd);
            boolean patternEnd = false;
            for (int currentHeight = 0; !patternEnd && currentHeight < maxHeight; ++currentHeight) {
                int n;
                int t0;
                boolean parameters = true;
                if (((t0 = this.data[address++]) & 1) == 1) {
                    parameters = false;
                    if ((t0 & 0xFE) == 0) {
                        this.aks.setComment(address - 1, "full optimization, escape necessary");
                        n = this.data[address];
                        int o = n / 12;
                        this.aks.setComment(address++, "escaped note definition " + AKSBin.this.notes[n %= 12] + "" + o);
                    } else {
                        int note = t0 & 0xFF;
                        note >>>= 1;
                        int o = --note / 12;
                        this.aks.setComment(address - 1, "full optimization, no escape: " + AKSBin.this.notes[note %= 12] + "" + o);
                    }
                } else {
                    t0 &= 0xFF;
                    if (((t0 >>>= 1) & 0x7F) == 0) {
                        parameters = false;
                        patternEnd = true;
                        this.aks.setComment(address - 1, "track end signature found");
                        break;
                    }
                    this.aks.setComment(address - 1, "normal track data");
                    if ((t0 -= 32) < 0) {
                        int w = t0 + 32;
                        currentHeight += --w;
                        parameters = false;
                        this.aks.addComment(address - 1, " wait " + w);
                    } else if (t0 == 0) {
                        patternEnd = true;
                        this.aks.setComment(address - 1, "note escape found");
                        n = this.data[address];
                        int o = n / 12;
                        this.aks.setComment(address++, "escaped note definition " + AKSBin.this.notes[n %= 12] + "" + o);
                    } else if (t0 <= 94) {
                        int p = this.data[address];
                        if ((p & 4) == 4) {
                            int n2 = --t0;
                            int o = n2 / 12;
                            this.aks.addComment(address - 1, " note: " + AKSBin.this.notes[n2 %= 12] + "" + o);
                        }
                    } else {
                        this.aks.addComment(address - 1, " w/o note");
                    }
                }
                if (!parameters) continue;
                int v = this.data[address];
                String comment = "";
                if ((v & 1) == 1) {
                    v >>>= 1;
                    comment = "vol = $" + String.format("%01X", 15 - (v &= 0xF)) + " (inverted)";
                } else {
                    comment = "vol off";
                }
                comment = comment + ((v & 0x80) == 128 ? ", pitch" : ", no pitch");
                comment = comment + ((v & 0x40) == 64 ? ", note" : ", no note");
                comment = comment + ((v & 0x20) == 32 ? ", instrument" : ", no instrument");
                this.aks.setComment(address, comment);
                int t1 = this.data[address++];
                if ((t1 & 0x80) == 128) {
                    this.aks.setComment(address, "pitch");
                    this.aks.setTypeWord(address);
                    address += 2;
                }
                if ((t1 & 0x20) != 32) continue;
                this.aks.setComment(address, "instrument");
                this.aks.addInstrument(this.data[address]);
                ++address;
            }
        }

        Track(int[] d, int ts, int l, AKSMemory a, int maxHeight) {
            this.aks = a;
            this.lfd = l;
            this.data = d;
            this.trackStart = ts;
            this.update(maxHeight);
        }
    }

    class Instrument {
        int[] data;
        int firstInstrumentAddress;
        int intrumentNumber;

        Instrument(int[] d, int fi, int no, AKSMemory aks) {
            this.data = d;
            this.firstInstrumentAddress = fi;
            this.intrumentNumber = no;
            int addressOfPointer = this.firstInstrumentAddress + 2 * this.intrumentNumber;
            aks.addComment(addressOfPointer, "pointer to instrument " + this.intrumentNumber);
            aks.setTypePointer(addressOfPointer);
            int address = d[addressOfPointer] + d[addressOfPointer + 1] * 256 - aks.offset;
            aks.addLabel(address, "instrument" + this.intrumentNumber);
            aks.addComment(address++, "speed");
            aks.addComment(address++, "retrig");
            while (true) {
                int secondByte;
                int firstByte;
                boolean manualFrequency = false;
                if (((firstByte = d[address++]) & 1) == 0) {
                    int firstAddress = address - 1;
                    aks.addComment(firstAddress, "dataColumn_0 (non hard)");
                    if ((firstByte & 2) == 2) {
                        int s2Noise;
                        int secondByte2 = d[address++];
                        int secondAddress = address - 1;
                        aks.addComment(secondAddress, "dataColumn_1");
                        if ((secondByte2 & 0x40) == 64) {
                            aks.setTypeWord(address);
                            aks.addComment(address, "manual frequency");
                            address += 2;
                            manualFrequency = true;
                        }
                        if ((s2Noise = secondByte2 & 0x1F) > 0) {
                            aks.addComment(secondAddress, "noise=$" + String.format("%02X", s2Noise & 0x1F));
                        }
                    }
                    if (!manualFrequency && (firstByte & 0x80) == 128) {
                        aks.setTypeWord(address);
                        aks.addComment(address, "pitch");
                        address += 2;
                    }
                    if (!manualFrequency && (firstByte & 0x40) == 64) {
                        aks.addComment(address, "arpegio");
                        ++address;
                    }
                    firstByte >>>= 2;
                    aks.addComment(firstAddress, "vol=$" + String.format("%01X", (firstByte &= 0xF) & 0xF));
                    continue;
                }
                aks.addComment(address - 1, "dataColumn_0 (hard)");
                if ((firstByte & 0xC) == 12) {
                    int instrumentTableAddress = 12;
                    int instrument0Address = d[instrumentTableAddress] + d[instrumentTableAddress + 1] * 256 - aks.offset;
                    int instrument0Loop = instrument0Address + 2;
                    aks.setTypePointer(address);
                    aks.addComment(address, "loop");
                    int loopAddress = d[address] + d[address + 1] * 256 - aks.offset;
                    if (loopAddress != instrument0Loop || this.intrumentNumber == 0) {
                        aks.addLabel(loopAddress, "instrument" + this.intrumentNumber + "loop");
                    }
                    address += 2;
                    break;
                }
                if ((firstByte & 0xC) == 4) {
                    aks.addComment(address, "software dependend 2. byte");
                    secondByte = d[address++];
                    if ((firstByte & 0x10) == 16) {
                        aks.setTypeWord(address);
                        aks.addComment(address, "manual frequency");
                        address += 2;
                        manualFrequency = true;
                    }
                    if (!manualFrequency && (firstByte & 0x40) == 64) {
                        aks.setTypeWord(address);
                        aks.addComment(address, "pitch");
                        address += 2;
                    }
                    if (!manualFrequency && (firstByte & 0x20) == 32) {
                        aks.addComment(address, "arpegio");
                        ++address;
                    }
                    if ((firstByte & 0x80) == 128) {
                        aks.setTypeWord(address);
                        aks.addComment(address, "hardware pitch");
                        address += 2;
                    }
                    if ((secondByte & 0x80) == 128) {
                        aks.addComment(address, "noise");
                        ++address;
                    }
                }
                if ((firstByte & 0xC) == 0) {
                    aks.addComment(address, "hardware dependend 2. byte");
                    secondByte = d[address++];
                    if ((firstByte & 0x10) == 16) {
                        aks.setTypeWord(address);
                        aks.addComment(address, "manual frequency");
                        address += 2;
                        manualFrequency = true;
                    }
                    if (!manualFrequency && (firstByte & 0x40) == 64) {
                        aks.setTypeWord(address);
                        aks.addComment(address, "pitch");
                        address += 2;
                    }
                    if (!manualFrequency && (firstByte & 0x20) == 32) {
                        aks.addComment(address, "arpegio");
                        ++address;
                    }
                    if ((firstByte & 0x80) == 128) {
                        aks.setTypeWord(address);
                        aks.addComment(address, "software pitch");
                        address += 2;
                    }
                    if ((secondByte & 0x80) == 128) {
                        aks.addComment(address, "noise");
                        ++address;
                    }
                }
                if ((firstByte & 0xC) != 8) continue;
                boolean hasSound = (firstByte & 0x80) == 128;
                boolean hasPitch = (firstByte & 0x40) == 64;
                boolean hasArpegio = (firstByte & 0x20) == 32;
                boolean hasManualFrequency = (firstByte & 0x10) == 16;
                aks.addComment(address, "Independent dependend 2. byte");
                int secondByte3 = d[address++];
                boolean hasNoise = (secondByte3 & 0x80) == 128;
                boolean hasHardwarePitch = (secondByte3 & 0x40) == 64;
                boolean hasHardwareArpegio = (secondByte3 & 0x20) == 32;
                boolean hasHardwareManualFrequency = (secondByte3 & 0x10) == 16;
                boolean hardwareManualFrequency = false;
                if (hasSound) {
                    if (hasManualFrequency) {
                        aks.setTypeWord(address);
                        aks.addComment(address, "manual frequency");
                        address += 2;
                        manualFrequency = true;
                    } else {
                        if (hasPitch) {
                            aks.setTypeWord(address);
                            aks.addComment(address, "independend pitch");
                            address += 2;
                        }
                        if (hasArpegio) {
                            aks.addComment(address, "independend arpegio");
                            ++address;
                        }
                    }
                }
                if (hasHardwareManualFrequency) {
                    aks.setTypeWord(address);
                    aks.addComment(address, "hardware manual frequency");
                    address += 2;
                    hardwareManualFrequency = true;
                } else {
                    if (hasHardwarePitch) {
                        aks.setTypeWord(address);
                        aks.addComment(address, "inepenended hardware pitch");
                        address += 2;
                    }
                    if (hasHardwareArpegio) {
                        aks.addComment(address, "independend hardware arpegio");
                        ++address;
                    }
                }
                if (!hasNoise) continue;
                aks.addComment(address, "independend noise");
                ++address;
            }
        }
    }

    class AKSMemory {
        ArrayList<CommentedMemory> m = new ArrayList();
        HashMap<Integer, Integer> trackPointer = new HashMap();
        HashMap<Integer, Integer> specialtrackPointer = new HashMap();
        HashMap<Integer, Integer> instrumentCounter = new HashMap();
        String labelId = "";
        int offset;

        public void addInstrument(int a) {
            this.instrumentCounter.put(a, a);
        }

        public void addTrackPointer(int a) {
            this.trackPointer.put(a, a);
        }

        public void addSpecialtrackPointer(int a) {
            this.specialtrackPointer.put(a, a);
        }

        public void setOffset(int o) {
            this.offset = o;
            for (CommentedMemory cm : this.m) {
                cm.setOffset(o);
            }
        }

        AKSMemory(int[] data2, String id) {
            this.labelId = id;
            int i = 0;
            while (i < data2.length) {
                CommentedMemory cm = new CommentedMemory();
                cm.byteValue = data2[i];
                cm.address = i++;
                cm.parent = this;
                this.m.add(cm);
            }
        }

        void addPreComment(int a, String c) {
            this.m.get(a).addPreComment(c);
        }

        void addComment(int a, String c) {
            this.m.get(a).addComment(c);
        }

        void setComment(int a, String c) {
            this.m.get(a).setComment(c);
        }

        void addLabel(int a, String l) {
            this.m.get(a).addLabel(l);
        }

        void setLabel(int a, String l) {
            this.m.get(a).setLabel(l);
        }

        CommentedMemory get(int a) {
            return this.m.get(a);
        }

        void setTypeWord(int a) {
            int v;
            this.m.get((int)a).type = 2;
            this.m.get((int)(a + 1)).type = 3;
            this.m.get((int)a).wordValue = v = this.m.get((int)a).byteValue + this.m.get((int)(a + 1)).byteValue * 256;
        }

        void setTypePointer(int a) {
            int v;
            this.m.get((int)a).type = 4;
            this.m.get((int)(a + 1)).type = 5;
            this.m.get((int)a).wordValue = v = this.m.get((int)a).byteValue + this.m.get((int)(a + 1)).byteValue * 256;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            int byteCount = 0;
            int lastType = -1;
            for (CommentedMemory cm : this.m) {
                String v = cm.toString();
                if (v.length() == 0) continue;
                String addi = "";
                int type = cm.type;
                if (cm.addressLabel.length() != 0) {
                    lastType = -1;
                }
                boolean hasAdditions = cm.hasAdditions();
                if (type == 1) {
                    if (lastType == type && !hasAdditions) {
                        if (byteCount > 10) {
                            addi = addi + "\n db " + v;
                            byteCount = 0;
                        } else {
                            addi = addi + ", " + v;
                        }
                        ++byteCount;
                    } else {
                        addi = addi + "\n" + cm.getPreString();
                        addi = addi + " db " + cm.getValueString();
                        addi = addi + cm.getPostString();
                        byteCount = 0;
                        ++byteCount;
                    }
                }
                if (type == 2) {
                    if (lastType == type && !hasAdditions) {
                        if (byteCount > 5) {
                            addi = addi + "\n dw " + v;
                            byteCount = 0;
                        } else {
                            addi = addi + ", " + v;
                        }
                        ++byteCount;
                    } else {
                        addi = addi + "\n" + cm.getPreString();
                        addi = addi + " dw " + cm.getValueString();
                        addi = addi + cm.getPostString();
                        byteCount = 0;
                        ++byteCount;
                    }
                }
                if (type == 4) {
                    if (lastType == type && !hasAdditions) {
                        if (byteCount > 5) {
                            addi = addi + "\n dw " + cm.getValueString();
                            byteCount = 0;
                        } else {
                            addi = addi + ", " + v;
                        }
                        ++byteCount;
                    } else {
                        addi = addi + "\n" + cm.getPreString();
                        addi = addi + " dw " + cm.getValueString();
                        addi = addi + cm.getPostString(cm.wordValue);
                        byteCount = 0;
                        ++byteCount;
                    }
                }
                b.append(addi);
                if (cm.getPostString().length() == 0) {
                    lastType = type;
                    continue;
                }
                lastType = -1;
            }
            return b.toString();
        }
    }

    class CommentedMemory {
        int address = -1;
        boolean isCommentLine = false;
        boolean additionalComment = false;
        int type = 1;
        String addressLabel = "";
        String aditionalComment = "";
        String preCommentLine = "";
        int byteValue;
        boolean ommit = false;
        int wordValue = -1;
        AKSMemory parent;
        int offset = 0;

        CommentedMemory() {
        }

        public void setOffset(int o) {
            this.offset = o;
        }

        void addLabel(String l) {
            this.addressLabel = this.addressLabel + l + this.parent.labelId;
        }

        void setLabel(String l) {
            if (this.addressLabel.length() != 0) {
                return;
            }
            this.addressLabel = l + this.parent.labelId;
        }

        void addComment(String c) {
            if (this.aditionalComment.contains(c)) {
                return;
            }
            if (this.aditionalComment.length() != 0) {
                this.aditionalComment = this.aditionalComment + ", ";
            }
            this.aditionalComment = this.aditionalComment + c;
        }

        void setComment(String c) {
            if (this.aditionalComment.length() != 0) {
                return;
            }
            this.aditionalComment = c;
        }

        void addPreComment(String c) {
            this.preCommentLine = this.preCommentLine + "; " + c + "\n";
        }

        public String getPreString() {
            if (this.type == 3) {
                return "";
            }
            if (this.type == 5) {
                return "";
            }
            if (this.ommit) {
                return "";
            }
            String ret = this.preCommentLine + this.addressLabel;
            if (this.addressLabel.length() != 0) {
                ret = ret + ":\n";
            }
            return ret;
        }

        public String getValueString() {
            if (this.type == 3) {
                return "";
            }
            if (this.type == 5) {
                return "";
            }
            if (this.ommit) {
                return "";
            }
            String ret = "";
            if (this.type == 1) {
                ret = ret + "$" + String.format("%02X", this.byteValue & 0xFF);
            }
            if (this.type == 4) {
                String otherLabel = this.parent.m.get((int)(this.wordValue - this.offset)).addressLabel;
                ret = otherLabel.length() != 0 ? ret + otherLabel : ret + "$" + String.format("%04X", this.wordValue - this.offset & 0xFFFF);
            }
            if (this.type == 2) {
                ret = ret + "$" + String.format("%04X", this.wordValue & 0xFFFF);
            }
            return ret;
        }

        public String getPostString() {
            if (this.type == 3) {
                return "";
            }
            if (this.type == 5) {
                return "";
            }
            if (this.ommit) {
                return "";
            }
            if (this.aditionalComment.length() == 0) {
                return "";
            }
            return " ; $" + String.format("%04X", this.address & 0xFFFF) + ": " + this.aditionalComment;
        }

        public String getPostString(int pointer) {
            if (this.type == 3) {
                return "";
            }
            if (this.type == 5) {
                return "";
            }
            if (this.ommit) {
                return "";
            }
            if (this.aditionalComment.length() == 0) {
                return "";
            }
            return " ; $" + String.format("%04X", this.address & 0xFFFF) + ": [$" + String.format("%04X", this.wordValue & 0xFFFF) + "] " + this.aditionalComment;
        }

        public boolean hasAdditions() {
            if (this.addressLabel.length() != 0) {
                return true;
            }
            if (this.aditionalComment.length() != 0) {
                return true;
            }
            return this.preCommentLine.length() != 0;
        }

        public String toString() {
            return this.getPreString() + this.getValueString() + this.getPostString();
        }
    }
}

