/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi.sound;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.config.TinyLogInterface;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.Windowable;
import de.malban.gui.components.CSAView;
import de.malban.gui.panels.LogPanel;
import de.malban.util.UtilityFiles;
import de.malban.util.UtilityString;
import de.malban.vide.assy.Asmj;
import de.malban.vide.dissy.DASM6809;
import de.malban.vide.vecx.VecXPanel;
import de.malban.vide.vedi.VediPanel;
import de.malban.vide.vedi.sound.Explosion;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ExplosionEditor
extends JPanel
implements Windowable {
    LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    Explosion currentExplosion = new Explosion();
    private int mClassSetting = 0;
    private CSAView mParent = null;
    private JMenuItem mParentMenuItem = null;
    JInternalFrame modelDialog;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JToggleButton jButtonAssemble;
    private JButton jButtonEditInVedi;
    private JButton jButtonNewYM;
    private JButton jButtonSave;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JCheckBox jCheckBox3;
    private JCheckBox jCheckBox4;
    private JCheckBox jCheckBox5;
    private JCheckBox jCheckBox6;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel22;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JRadioButton jRadioButton3;
    private JRadioButton jRadioButton4;
    private JRadioButton jRadioButton5;
    private JRadioButton jRadioButton6;
    private JSlider jSlider1;
    private JTextField jTextField1;
    private JTextField jTextField1a;
    private JTextField jTextField2;
    private JTextField jTextField3;
    Thread one = null;
    public boolean asmStarted = false;
    public boolean stop = false;
    public boolean running = false;
    public boolean pausing = false;

    @Override
    public void closing() {
    }

    @Override
    public boolean isIcon() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return false;
        }
        return frame.getInternalFrame(this).isIcon();
    }

    @Override
    public void setIcon(boolean b) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return;
        }
        try {
            frame.getInternalFrame(this).setIcon(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void setParentWindow(CSAView jpv) {
        this.mParent = jpv;
    }

    @Override
    public void setMenuItem(JMenuItem item) {
        this.mParentMenuItem = item;
        this.mParentMenuItem.setText("Sound: Explosion Editor");
    }

    @Override
    public JMenuItem getMenuItem() {
        return this.mParentMenuItem;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    public ExplosionEditor(TinyLogInterface tl) {
        this.initComponents();
        this.initComboBox(-1);
        this.currentExplosion.setBytes(this.jTextField1.getText());
        this.initCurrentExplosion();
    }

    void initCurrentExplosion() {
        this.jTextField1.setText(this.currentExplosion.getBytesString());
        this.setFromTextfield();
        this.jTextField1a.setText(this.currentExplosion.name);
    }

    void initComboBox(int sel) {
        ArrayList<String> list2 = Explosion.getExplosionList();
        ++this.mClassSetting;
        this.jComboBox1.removeAllItems();
        for (String name : list2) {
            this.jComboBox1.addItem(UtilityString.replace(name.toLowerCase(), ".xml", ""));
        }
        this.jComboBox1.setSelectedIndex(sel);
        --this.mClassSetting;
    }

    void initComboBox(String nameSel) {
        ArrayList<String> list2 = Explosion.getExplosionList();
        ++this.mClassSetting;
        this.jComboBox1.removeAllItems();
        int selIndex = -1;
        int index = 0;
        for (String name : list2) {
            String comboName = UtilityString.replace(name.toLowerCase(), ".xml", "");
            this.jComboBox1.addItem(comboName);
            if (comboName.equals(nameSel.toLowerCase())) {
                selIndex = index;
            }
            ++index;
        }
        this.jComboBox1.setSelectedIndex(selIndex);
        --this.mClassSetting;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jTextField1a = new JTextField();
        this.jButtonSave = new JButton();
        this.jButtonNewYM = new JButton();
        this.jLabel7 = new JLabel();
        this.jLabel22 = new JLabel();
        this.jButtonAssemble = new JToggleButton();
        this.jButtonEditInVedi = new JButton();
        this.jCheckBox1 = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.jCheckBox2 = new JCheckBox();
        this.jCheckBox3 = new JCheckBox();
        this.jCheckBox4 = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.jCheckBox5 = new JCheckBox();
        this.jCheckBox6 = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.jRadioButton1 = new JRadioButton();
        this.jLabel8 = new JLabel();
        this.jRadioButton2 = new JRadioButton();
        this.jRadioButton3 = new JRadioButton();
        this.jLabel9 = new JLabel();
        this.jRadioButton4 = new JRadioButton();
        this.jRadioButton5 = new JRadioButton();
        this.jRadioButton6 = new JRadioButton();
        this.jLabel10 = new JLabel();
        this.jSlider1 = new JSlider();
        this.jTextField1 = new JTextField();
        this.jTextField2 = new JTextField();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jTextField3 = new JTextField();
        this.jLabel1.setText("name");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExplosionEditor.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jTextField1a.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ExplosionEditor.this.jTextField1aFocusLost(evt);
            }
        });
        this.jTextField1a.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExplosionEditor.this.jTextField1aActionPerformed(evt);
            }
        });
        this.jButtonSave.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_save.png")));
        this.jButtonSave.setToolTipText("Save explosion");
        this.jButtonSave.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExplosionEditor.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jButtonNewYM.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/new.png")));
        this.jButtonNewYM.setToolTipText("new YM window");
        this.jButtonNewYM.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonNewYM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExplosionEditor.this.jButtonNewYMActionPerformed(evt);
            }
        });
        this.jLabel7.setText("Channels (byte 1)");
        this.jLabel22.setText("Explosion data");
        this.jButtonAssemble.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/control_play_blue.png")));
        this.jButtonAssemble.setToolTipText("Animates through all images, animation is looped. Given delay is taken.");
        this.jButtonAssemble.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonAssemble.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExplosionEditor.this.jButtonAssembleActionPerformed(evt);
            }
        });
        this.jButtonEditInVedi.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_edit.png")));
        this.jButtonEditInVedi.setToolTipText("edit output in vedi");
        this.jButtonEditInVedi.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonEditInVedi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExplosionEditor.this.jButtonEditInVediActionPerformed(evt);
            }
        });
        this.jCheckBox1.setText("Noise");
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExplosionEditor.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Channel 1");
        this.jCheckBox2.setText("Tone");
        this.jCheckBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExplosionEditor.this.jCheckBox2ActionPerformed(evt);
            }
        });
        this.jCheckBox3.setText("Tone");
        this.jCheckBox3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExplosionEditor.this.jCheckBox3ActionPerformed(evt);
            }
        });
        this.jCheckBox4.setText("Noise");
        this.jCheckBox4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExplosionEditor.this.jCheckBox4ActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Channel 2");
        this.jCheckBox5.setText("Tone");
        this.jCheckBox5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExplosionEditor.this.jCheckBox5ActionPerformed(evt);
            }
        });
        this.jCheckBox6.setText("Noise");
        this.jCheckBox6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExplosionEditor.this.jCheckBox6ActionPerformed(evt);
            }
        });
        this.jLabel6.setText("Channel 3");
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setText("Sweep up");
        this.jRadioButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExplosionEditor.this.jRadioButton1ActionPerformed(evt);
            }
        });
        this.jLabel8.setText("Frequency (byte 2)");
        this.buttonGroup1.add(this.jRadioButton2);
        this.jRadioButton2.setText("Sweep down");
        this.jRadioButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExplosionEditor.this.jRadioButton2ActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButton3);
        this.jRadioButton3.setText("stay");
        this.jRadioButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExplosionEditor.this.jRadioButton3ActionPerformed(evt);
            }
        });
        this.jLabel9.setText("Volume (byte 3)");
        this.buttonGroup2.add(this.jRadioButton4);
        this.jRadioButton4.setText("Sweep down");
        this.jRadioButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExplosionEditor.this.jRadioButton4ActionPerformed(evt);
            }
        });
        this.buttonGroup2.add(this.jRadioButton5);
        this.jRadioButton5.setText("stay");
        this.jRadioButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExplosionEditor.this.jRadioButton5ActionPerformed(evt);
            }
        });
        this.buttonGroup2.add(this.jRadioButton6);
        this.jRadioButton6.setText("Sweep up");
        this.jRadioButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExplosionEditor.this.jRadioButton6ActionPerformed(evt);
            }
        });
        this.jLabel10.setText("Duration (byte 4)");
        this.jSlider1.setMajorTickSpacing(16);
        this.jSlider1.setMaximum(128);
        this.jSlider1.setMinimum(1);
        this.jSlider1.setMinorTickSpacing(1);
        this.jSlider1.setPaintTicks(true);
        this.jSlider1.setToolTipText("1 longest duration, 128 shortest duration");
        this.jSlider1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ExplosionEditor.this.jSlider1StateChanged(evt);
            }
        });
        this.jTextField1.setText("$19, $3f, 00, $02");
        this.jTextField1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ExplosionEditor.this.jTextField1FocusLost(evt);
            }
        });
        this.jTextField1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExplosionEditor.this.jTextField1ActionPerformed(evt);
            }
        });
        this.jTextField2.setText("$1f");
        this.jTextField2.setToolTipText("5 bit value of \"stay\" is selected");
        this.jTextField2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExplosionEditor.this.jTextField2ActionPerformed(evt);
            }
        });
        this.jTextField2.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                ExplosionEditor.this.jTextField2KeyTyped(evt);
            }
        });
        this.jLabel4.setText("stay - frequency");
        this.jLabel5.setText("stay - volume");
        this.jTextField3.setText("$0f");
        this.jTextField3.setToolTipText("<html>\n4 bit value of \"stay\" is selected.<BR>\nBit 5 <b> must not </b> be set, since this would changle the amplitude mode bit of psg<BR> \n- and no sound at all would be heard!\n</html>\n");
        this.jTextField3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExplosionEditor.this.jTextField3ActionPerformed(evt);
            }
        });
        this.jTextField3.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                ExplosionEditor.this.jTextField3KeyTyped(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextField1).addComponent(this.jTextField1a).addComponent(this.jComboBox1, 0, 151, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jButtonSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonNewYM)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(157, 157, 157).addComponent(this.jButtonAssemble).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonEditInVedi)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel10).addComponent(this.jLabel8).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addGap(34, 34, 34).addComponent(this.jCheckBox4).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox3)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addGap(34, 34, 34).addComponent(this.jCheckBox1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox2)).addComponent(this.jLabel22).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9).addGroup(layout.createSequentialGroup().addGap(85, 85, 85).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSlider1, -2, 242, -2).addGroup(layout.createSequentialGroup().addComponent(this.jRadioButton4).addGap(18, 18, 18).addComponent(this.jRadioButton5).addGap(18, 18, 18).addComponent(this.jRadioButton6))))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel6).addGap(34, 34, 34).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jRadioButton2).addGap(18, 18, 18).addComponent(this.jRadioButton3).addGap(18, 18, 18).addComponent(this.jRadioButton1)).addGroup(layout.createSequentialGroup().addComponent(this.jCheckBox6).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox5)))))).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField2, -2, 43, -2).addComponent(this.jLabel4).addComponent(this.jTextField3, -2, 43, -2).addComponent(this.jLabel5)))).addContainerGap(125, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel7).addGap(13, 13, 13).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox1).addComponent(this.jLabel2).addComponent(this.jCheckBox2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox4).addComponent(this.jLabel3).addComponent(this.jCheckBox3)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox6).addComponent(this.jLabel6).addComponent(this.jCheckBox5)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.jLabel4)).addGap(1, 1, 1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButton2).addComponent(this.jRadioButton3).addComponent(this.jRadioButton1).addComponent(this.jTextField2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel9).addGap(1, 1, 1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButton4).addComponent(this.jRadioButton5).addComponent(this.jRadioButton6))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5).addGap(1, 1, 1).addComponent(this.jTextField3, -2, -1, -2))).addGap(8, 8, 8).addComponent(this.jLabel10).addGap(5, 5, 5).addComponent(this.jSlider1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jComboBox1).addComponent(this.jButtonSave).addComponent(this.jButtonNewYM).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField1a, -2, 21, -2).addGap(12, 12, 12).addComponent(this.jLabel22).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButtonEditInVedi).addComponent(this.jButtonAssemble)).addComponent(this.jTextField1, -2, -1, -2)).addContainerGap(73, Short.MAX_VALUE)));
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        this.readAll();
        if (this.currentExplosion.name.length() == 0) {
            this.log.addLog("Explosion not saved, no name given!", LogPanel.WARN);
            return;
        }
        String path = Global.mainPathPrefix + "xml" + File.separator + "explosions" + File.separator + this.currentExplosion.name + ".xml";
        this.currentExplosion.saveAsXML(path);
        this.initComboBox(this.currentExplosion.name);
    }

    private void jButtonNewYMActionPerformed(ActionEvent evt) {
        this.currentExplosion = new Explosion();
        this.initCurrentExplosion();
    }

    private void jTextField1aActionPerformed(ActionEvent evt) {
        this.currentExplosion.name = this.jTextField1a.getText();
    }

    private void jTextField1aFocusLost(FocusEvent evt) {
        this.currentExplosion.name = this.jTextField1a.getText();
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        if (this.jComboBox1.getSelectedIndex() == -1) {
            return;
        }
        String name = this.jComboBox1.getSelectedItem().toString();
        this.currentExplosion = Explosion.getExplosion(name);
        this.initCurrentExplosion();
    }

    private void jButtonAssembleActionPerformed(ActionEvent evt) {
        String filename = Global.mainPathPrefix + "tmp" + File.separator + "expltmp.asm";
        UtilityFiles.createTextFile(filename, this.getProg());
        this.startASM(filename);
    }

    private void jButtonEditInVediActionPerformed(ActionEvent evt) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        VediPanel p = new VediPanel(false);
        p.setTreeVisible(false);
        frame.addAsWindow(p, 1024, 768, VediPanel.SID);
        String filename = Global.mainPathPrefix + "tmp" + File.separator + "expltmp.asm";
        UtilityFiles.createTextFile(filename, this.getProg());
        p.addTempEditFile(filename);
    }

    private void jRadioButton1ActionPerformed(ActionEvent evt) {
        this.setToTextfield();
    }

    private void jRadioButton2ActionPerformed(ActionEvent evt) {
        this.setToTextfield();
    }

    private void jRadioButton3ActionPerformed(ActionEvent evt) {
        this.setToTextfield();
    }

    private void jRadioButton4ActionPerformed(ActionEvent evt) {
        this.setToTextfield();
    }

    private void jRadioButton5ActionPerformed(ActionEvent evt) {
        this.setToTextfield();
    }

    private void jRadioButton6ActionPerformed(ActionEvent evt) {
        this.setToTextfield();
    }

    private void jTextField1ActionPerformed(ActionEvent evt) {
        this.setFromTextfield();
    }

    private void jSlider1StateChanged(ChangeEvent evt) {
        this.setToTextfield();
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        this.setToTextfield();
    }

    private void jCheckBox4ActionPerformed(ActionEvent evt) {
        this.setToTextfield();
    }

    private void jCheckBox6ActionPerformed(ActionEvent evt) {
        this.setToTextfield();
    }

    private void jCheckBox2ActionPerformed(ActionEvent evt) {
        this.setToTextfield();
    }

    private void jCheckBox3ActionPerformed(ActionEvent evt) {
        this.setToTextfield();
    }

    private void jCheckBox5ActionPerformed(ActionEvent evt) {
        this.setToTextfield();
    }

    private void jTextField2ActionPerformed(ActionEvent evt) {
        this.setToTextfield();
    }

    private void jTextField3ActionPerformed(ActionEvent evt) {
        this.setToTextfield();
    }

    private void jTextField2KeyTyped(KeyEvent evt) {
        this.setToTextfield();
    }

    private void jTextField3KeyTyped(KeyEvent evt) {
        this.setToTextfield();
    }

    private void jTextField1FocusLost(FocusEvent evt) {
        this.setFromTextfield();
    }

    public static boolean showExplosionPanel(TinyLogInterface tl) {
        return false;
    }

    public static void showExplosionPanelNoModal(TinyLogInterface tl) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        ExplosionEditor panel = new ExplosionEditor(tl);
        Configuration.getConfiguration().getMainFrame().addAsWindow(panel, 600, 450, "Sound: Explosion Editor");
    }

    void readAll() {
        this.currentExplosion.name = this.jTextField1a.getText();
        this.currentExplosion.setBytes(this.jTextField1.getText());
    }

    @Override
    public void deIconified() {
    }

    public void startASM(final String filenameASM) {
        if (this.asmStarted) {
            return;
        }
        this.asmStarted = true;
        this.jButtonAssemble.setEnabled(false);
        if (this.one != null) {
            return;
        }
        this.one = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(10L);
                    try {
                        Asmj asm = new Asmj(filenameASM, null, null, null, null, "", null);
                        String info = asm.getInfo();
                        final boolean asmOk = info.indexOf("0 errors detected.") >= 0;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ExplosionEditor.this.asmResult(asmOk);
                            }
                        });
                    }
                    catch (Throwable e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ExplosionEditor.this.log.addLog(e, LogPanel.WARN);
                                ExplosionEditor.this.asmResult(false);
                            }
                        });
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ExplosionEditor.this.one = null;
                ExplosionEditor.this.jButtonAssemble.setEnabled(true);
                ExplosionEditor.this.asmStarted = false;
            }
        };
        this.one.setName("Run ASMJ with: " + filenameASM);
        this.one.start();
    }

    protected void asmResult(boolean asmOk) {
        if (asmOk) {
            VecXPanel vec = ((CSAMainFrame)this.mParent).getVecxy();
            ((CSAMainFrame)this.mParent).getInternalFrame(vec).toFront();
            String fname = Global.mainPathPrefix + "tmp" + File.separator + "expltmp.bin";
            vec.startUp(fname);
            this.log.addLog("Explosion-Assembly successful...", LogPanel.INFO);
        } else {
            this.log.addLog("Explosion-Assembly not successful, see ASM output...", LogPanel.WARN);
        }
        this.jButtonAssemble.setEnabled(true);
    }

    void setFromTextfield() {
        if (this.mClassSetting > 0) {
            return;
        }
        ++this.mClassSetting;
        this.currentExplosion.setBytes(this.jTextField1.getText());
        int b3 = this.currentExplosion.bytes[2];
        this.currentExplosion.bytes[2] = (byte)(b3 &= 0xEF);
        this.jTextField1.setText(this.currentExplosion.getBytesString());
        byte b = this.currentExplosion.bytes[0];
        this.jCheckBox2.setSelected((b & 1) == 1);
        this.jCheckBox3.setSelected((b & 2) == 2);
        this.jCheckBox5.setSelected((b & 4) == 4);
        this.jCheckBox1.setSelected((b & 8) == 8);
        this.jCheckBox4.setSelected((b & 0x10) == 16);
        this.jCheckBox6.setSelected((b & 0x20) == 32);
        b = this.currentExplosion.bytes[1];
        this.jTextField2.setText("");
        if (b == 0) {
            this.jRadioButton1.setSelected(true);
        } else if ((b & 0x80) == 128) {
            this.jRadioButton3.setSelected(true);
            this.jTextField2.setText("$" + String.format("%02X", b & 0xF));
        } else {
            this.jRadioButton2.setSelected(true);
        }
        b = this.currentExplosion.bytes[2];
        this.jTextField3.setText("");
        if (b == 0) {
            this.jRadioButton4.setSelected(true);
        } else if ((b & 0x80) == 128) {
            this.jRadioButton5.setSelected(true);
            this.jTextField3.setText("$" + String.format("%02X", b & 0xF));
        } else {
            this.jRadioButton6.setSelected(true);
        }
        b = this.currentExplosion.bytes[3];
        this.jSlider1.setValue(b);
        --this.mClassSetting;
    }

    void setToTextfield() {
        if (this.mClassSetting > 0) {
            return;
        }
        ++this.mClassSetting;
        int b = 0;
        if (this.jCheckBox2.isSelected()) {
            ++b;
        }
        if (this.jCheckBox3.isSelected()) {
            b += 2;
        }
        if (this.jCheckBox5.isSelected()) {
            b += 4;
        }
        if (this.jCheckBox1.isSelected()) {
            b += 8;
        }
        if (this.jCheckBox4.isSelected()) {
            b += 16;
        }
        if (this.jCheckBox6.isSelected()) {
            b += 32;
        }
        this.currentExplosion.bytes[0] = (byte)b;
        b = 0;
        int b2 = DASM6809.toNumber(this.jTextField2.getText()) & 0x1F;
        if (this.jRadioButton1.isSelected()) {
            b = 0;
        } else if (this.jRadioButton3.isSelected()) {
            b = 128;
            b += b2;
        } else if (this.jRadioButton2.isSelected()) {
            b = 1;
        }
        this.currentExplosion.bytes[1] = (byte)b;
        b = 0;
        b2 = DASM6809.toNumber(this.jTextField3.getText()) & 0xF;
        this.jTextField3.setText("$" + String.format("%02X", b2 & 0xF));
        if (this.jRadioButton4.isSelected()) {
            b = 0;
        } else if (this.jRadioButton5.isSelected()) {
            b = 128;
            b += b2;
        } else if (this.jRadioButton6.isSelected()) {
            b = 1;
        }
        this.currentExplosion.bytes[2] = (byte)b;
        b = this.jSlider1.getValue();
        this.currentExplosion.bytes[3] = (byte)b;
        this.jTextField1.setText(this.currentExplosion.getBytesString());
        --this.mClassSetting;
    }

    String getProg() {
        String explosionString = this.jTextField1.getText();
        Path template = Paths.get(Global.mainPathPrefix, "template", "explosionPlayer.i");
        String main = UtilityString.readTextFileToOneString(new File(template.toString()));
        main = main + "\nexplosionData:\n";
        main = main + " db " + explosionString + "\n";
        return main;
    }
}

