/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi.sound;

import de.malban.config.Configuration;
import de.malban.gui.panels.LogPanel;
import de.malban.vide.vedi.sound.ModJPanel;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;

public class Mod2Vectrex {
    LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    public static byte DEFAULT_SPEED;
    public static byte SPEED;
    public static byte BASS_DRUM_VALUE;
    public static byte HIHAT_DRUM_VALUE;
    public static byte SNARE_DRUM_VALUE;
    public static String PROGNAME;
    public static String VERSION;
    public static String _DATE;
    public static String AUTHOR;
    public static byte VERBOSITY;
    public static String HEXPRE;
    public static int[] PERIOD;
    public static int[] PSG_PERIOD;
    public static HashMap<Integer, Integer> freq2Index;
    public static String[] NAME;
    public static String[] VEC_NOTES;
    public static byte OFFNOTE_VALUE;
    public static String OFFNOTE;
    public static String[] EFFECT_INFO;
    pattern_type[] pattern = new pattern_type[128];
    sample_type[] sample = new sample_type[32];
    byte songlength;
    String songName;
    String trackerID;
    String inModName;
    String outTxtName;
    String outVecFile;
    byte[] pattern_position = new byte[128];
    byte pattern_number;
    byte loop_position;
    public int[] vectrexModMapping = new int[3];
    StringBuffer stdOut;
    String adsr1 = "";
    String adsr2 = "";
    String adsr3 = "";
    String twang1 = "";
    String twang2 = "";
    String twang3 = "";
    ArrayList<ModJPanel.InstrumentHandle> instrumentHandles;

    public Mod2Vectrex() {
        this.vectrexModMapping[0] = 0;
        this.vectrexModMapping[1] = 1;
        this.vectrexModMapping[2] = 2;
    }

    String hex(byte input) {
        return String.format("%02X", input);
    }

    String hexShort(byte input) {
        return String.format("%01X", input & 0xF);
    }

    void show_message() {
        this.stdOut.append(PROGNAME + " v" + VERSION + " - " + _DATE + " by " + AUTHOR + "\n");
        this.stdOut.append("\n");
    }

    byte findNote(int period_in) {
        byte ret = OFFNOTE_VALUE;
        for (int a = 0; a <= 83; ++a) {
            if (period_in != PERIOD[a]) continue;
            ret = (byte)(a - 7);
        }
        return ret;
    }

    void findPatternNumber() {
        this.pattern_number = 0;
        for (int a = 0; a <= this.songlength; ++a) {
            if (this.pattern_position[a] <= this.pattern_number) continue;
            this.pattern_number = this.pattern_position[a];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean readMod(String fileName) {
        int d;
        char swapChar;
        int c;
        FileInputStream fin = null;
        byte[] data2 = new byte[4];
        this.songName = "";
        this.stdOut.append("Reading file \"" + fileName + "\"\n");
        File file = new File(fileName);
        byte[] a = new byte[(int)file.length()];
        int pos = 0;
        if (VERBOSITY > 0) {
            this.stdOut.append("Reading songName...\n");
        }
        try {
            fin = new FileInputStream(file);
            fin.read(a);
        }
        catch (Throwable ex) {
            this.log.addLog(ex, LogPanel.WARN);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                fin.close();
            }
            catch (Throwable ex) {
                this.log.addLog(ex, LogPanel.WARN);
                return false;
            }
        }
        for (c = 1; c <= 20; ++c) {
            swapChar = '\u0000';
            if (pos < a.length) {
                swapChar = (char)a[pos++];
            }
            if (swapChar == '\u0000') continue;
            this.songName = this.songName + swapChar;
        }
        if (VERBOSITY > 0) {
            this.stdOut.append("Reading Samples...\n");
        }
        for (c = 1; c <= 31; ++c) {
            this.sample[c].name = "";
            for (d = 1; d <= 22; ++d) {
                swapChar = '\u0000';
                if (pos < a.length) {
                    swapChar = (char)a[pos++];
                }
                if (swapChar == '\u0000') continue;
                this.sample[c].name = this.sample[c].name + swapChar;
            }
            data2[0] = a[pos++];
            data2[1] = a[pos++];
            this.sample[c].length = ((data2[0] & 0xFF) * 256 + (data2[1] & 0xFF)) * 2;
            this.sample[c].finetune = a[pos++];
            this.sample[c].finetune = (byte)(this.sample[c].finetune | 0xF);
            this.sample[c].volume = a[pos++];
            data2[0] = a[pos++];
            data2[1] = a[pos++];
            this.sample[c].repeat_pos = ((data2[0] & 0xFF) * 256 + (data2[1] & 0xFF)) * 2;
            data2[0] = a[pos++];
            data2[1] = a[pos++];
            this.sample[c].repeat_length = ((data2[0] & 0xFF) * 256 + (data2[1] & 0xFF)) * 2;
        }
        if (VERBOSITY > 0) {
            this.stdOut.append("Reading songLength...\n");
        }
        if (pos < a.length) {
            this.songlength = a[pos++];
        }
        if (pos < a.length) {
            data2[0] = a[pos++];
        }
        if (VERBOSITY > 0) {
            this.stdOut.append("Reading Pattern Position Table...\n");
        }
        for (c = 0; c <= 127; ++c) {
            if (pos >= a.length) continue;
            this.pattern_position[c] = a[pos++];
        }
        this.findPatternNumber();
        if (VERBOSITY > 0) {
            this.stdOut.append("Reading Tracker-ID string...\n");
        }
        this.trackerID = "";
        for (d = 1; d <= 4; ++d) {
            swapChar = '\u0000';
            if (pos < a.length) {
                swapChar = (char)a[pos++];
            }
            if (swapChar == '\u0000') continue;
            this.trackerID = this.trackerID + swapChar;
        }
        this.loop_position = 0;
        if (VERBOSITY > 0) {
            this.stdOut.append("Reading Patterns...\n");
        }
        for (int f = 0; f <= this.pattern_number; ++f) {
            if (VERBOSITY > 1) {
                this.stdOut.append(" Pattern " + String.format("%02d", f) + ": ");
            }
            for (c = 0; c <= 63; ++c) {
                if (VERBOSITY > 1) {
                    this.stdOut.append(".");
                }
                for (d = 0; d <= 3; ++d) {
                    for (int e = 0; e <= 3; ++e) {
                        if (pos >= a.length) continue;
                        data2[e] = a[pos++];
                    }
                    this.pattern[f].voice[d].tone[c].instrument = (byte)(data2[0] & 0xFF & 0xF0 | (data2[2] & 0xFF) >>> 4);
                    this.pattern[f].voice[d].tone[c].period = (data2[0] & 0xFF & 0xF) << 8 | data2[1] & 0xFF;
                    this.pattern[f].voice[d].tone[c].note = this.findNote(this.pattern[f].voice[d].tone[c].period);
                    this.pattern[f].voice[d].tone[c].effect1 = (byte)(data2[2] & 0xFF & 0xF);
                    this.pattern[f].voice[d].tone[c].effect2 = (byte)((data2[3] & 0xFF) >>> 4);
                    this.pattern[f].voice[d].tone[c].effect3 = (byte)(data2[3] & 0xFF & 0xF);
                    if (this.pattern[f].voice[d].tone[c].effect1 != 11) continue;
                    if (this.loop_position != 0) {
                        this.stdOut.append("! >> Caution: More than one loop found in modfile, so I am taking the last one.\n");
                    }
                    this.loop_position = data2[3];
                }
            }
            if (VERBOSITY <= 1) continue;
            this.stdOut.append("\n");
        }
        if (VERBOSITY > 1) {
            this.stdOut.append("done.\n");
        }
        if (VERBOSITY > 1) {
            this.stdOut.append("\n");
        }
        return true;
    }

    void findUsedPatterns() {
        for (int e = 0; e <= this.pattern_number; ++e) {
            this.pattern[e].used = false;
            for (int c = 0; c <= this.songlength - 1; ++c) {
                if (e != this.pattern_position[c]) continue;
                this.pattern[e].used = true;
            }
        }
    }

    boolean writeModInfo(String fileName) {
        try {
            int e;
            int c;
            PrintWriter writer = new PrintWriter(fileName, "UTF-8");
            this.stdOut.append("Writing file \"" + fileName + "\"\n");
            if (VERBOSITY > 0) {
                this.stdOut.append(" Writing header...\n");
            }
            writer.println(PROGNAME + " v" + VERSION + " - " + _DATE + " by " + AUTHOR);
            writer.println("");
            if (VERBOSITY > 0) {
                this.stdOut.append(" Writing SongName...\n");
            }
            writer.println("SongName: \"" + this.songName + "\"");
            writer.println("");
            if (VERBOSITY > 0) {
                this.stdOut.append(" Writing TrackerID...\n");
            }
            writer.println("TrackerID: \"" + this.trackerID + "\"");
            writer.println("");
            writer.println("");
            if (VERBOSITY > 0) {
                this.stdOut.append(" Writing Sample Information...\n");
            }
            writer.println("Samples:");
            writer.println("");
            for (c = 1; c < 31; ++c) {
                if (this.sample[c].length <= 0 && this.sample[c].name.length() == 0) continue;
                writer.write("Sample " + this.hex((byte)c) + ": ");
                writer.println("\"" + this.sample[c].name + "\"");
                writer.write("Length: " + this.sample[c].length + " bytes - ");
                writer.write("Finetune: $" + this.hex(this.sample[c].finetune) + " - ");
                writer.println("Volume: $" + this.hex(this.sample[c].volume));
                writer.write("Repeat position: " + this.sample[c].repeat_pos + " bytes - ");
                writer.println("Repeat length: " + this.sample[c].repeat_length + " bytes");
                writer.println("");
            }
            writer.println("");
            writer.println("");
            if (VERBOSITY > 0) {
                this.stdOut.append(" Writing SongLength...\n");
            }
            writer.println("Songlength: $" + this.hex(this.songlength) + " pattern positions");
            writer.println("Finally, song jumps to pattern position: $" + this.hex(this.loop_position));
            writer.println("");
            if (VERBOSITY > 0) {
                this.stdOut.append(" Writing Pattern Position Table...\n");
            }
            writer.println("Pattern Position Table:");
            for (c = 0; c <= this.songlength - 1; ++c) {
                writer.println(this.hex((byte)c) + " " + this.hex(this.pattern_position[c]));
            }
            writer.println("");
            writer.println("");
            if (VERBOSITY > 0) {
                this.stdOut.append(" Writing Patterns...\n");
            }
            for (e = 0; e <= this.pattern_number; ++e) {
                if (!this.pattern[e].used) continue;
                writer.println("Pattern " + this.hex((byte)e));
                writer.println("");
                if (VERBOSITY > 1) {
                    this.stdOut.append("  Pattern " + this.hex((byte)e) + ": ");
                }
                for (c = 0; c <= 63; ++c) {
                    writer.write(this.hex((byte)c) + ": ");
                    for (int d = 0; d <= 3; ++d) {
                        String swap_note = this.pattern[e].voice[d].tone[c].note != OFFNOTE_VALUE ? NAME[this.pattern[e].voice[d].tone[c].note] : OFFNOTE;
                        writer.write(swap_note + " ");
                        if (this.pattern[e].voice[d].tone[c].instrument > 0) {
                            writer.write(this.hex(this.pattern[e].voice[d].tone[c].instrument) + " ");
                        } else {
                            writer.write("   ");
                        }
                        writer.write(this.hexShort(this.pattern[e].voice[d].tone[c].effect1));
                        writer.write(this.hexShort(this.pattern[e].voice[d].tone[c].effect2));
                        writer.write(this.hexShort(this.pattern[e].voice[d].tone[c].effect3));
                        writer.write("   ");
                    }
                    writer.println("");
                    if (VERBOSITY <= 1) continue;
                    this.stdOut.append(".");
                }
                if (VERBOSITY > 1) {
                    this.stdOut.append("\n");
                }
                writer.println("");
                writer.println("");
            }
            if (VERBOSITY > 0) {
                this.stdOut.append(" Writing Protracker Effect Information...\n");
            }
            for (e = 0; e <= 35; ++e) {
                writer.println(EFFECT_INFO[e]);
            }
            writer.println("");
            writer.println("");
            if (VERBOSITY > 0) {
                this.stdOut.append("done.\n");
            }
            if (VERBOSITY > 0) {
                this.stdOut.append("\n");
            }
            writer.close();
        }
        catch (Exception x) {
            this.log.addLog(x, LogPanel.WARN);
            return false;
        }
        return true;
    }

    void writePatternDirect(PrintWriter writer) {
        int c;
        this.stdOut.append("Writing section \"Patterns\"\n");
        writer.println(";--- music data [created with " + PROGNAME + " v" + VERSION + " - " + _DATE + " by " + AUTHOR + "] ---");
        writer.println();
        writer.println("adsr: ");
        writer.println("  fcb " + this.adsr1 + "      ; channel 2");
        writer.println("  fcb " + this.adsr2 + "      ; channel 1");
        writer.println("  fcb " + this.adsr3 + "      ; channel 0");
        writer.println();
        writer.println("twang: ");
        writer.println("  fcb " + this.twang1 + "      ; channel 2");
        writer.println("  fcb " + this.twang2 + "      ; channel 1");
        writer.println("  fcb " + this.twang3 + "      ; channel 0");
        writer.println();
        writer.println("");
        writer.println("SPEED = " + DEFAULT_SPEED);
        if (VERBOSITY > 0) {
            this.stdOut.append(" Writing Pattern Position Table...\n");
        }
        writer.println("SIL\tequ\t$3f");
        writer.println();
        writer.println("songLength\tequ\t$" + this.hex(this.songlength));
        writer.println("loopPosition\tequ\t$" + this.hex(this.loop_position));
        writer.println();
        writer.println(";   Pattern ");
        writer.println("script:");
        for (c = 0; c <= this.songlength - 1; ++c) {
            writer.println("  fdb pattern" + this.hex(this.pattern_position[c]));
        }
        writer.println();
        if (VERBOSITY > 0) {
            this.stdOut.append(" Writing Patterns...\n");
        }
        for (int e = 0; e <= this.pattern_number; ++e) {
            if (!this.pattern[e].used) continue;
            writer.println("pattern" + this.hex((byte)e) + ":");
            writer.println("  fdb adsr");
            writer.println("  fdb twang");
            writer.println();
            for (c = 0; c <= 63; ++c) {
                writer.print("  fcb ");
                if (this.pattern[e].voice[this.vectrexModMapping[0]].tone[c].note == OFFNOTE_VALUE && this.pattern[e].voice[this.vectrexModMapping[1]].tone[c].note == OFFNOTE_VALUE && this.pattern[e].voice[this.vectrexModMapping[2]].tone[c].note == OFFNOTE_VALUE) {
                    writer.print("SIL,");
                }
                for (int d = 0; d <= 2; ++d) {
                    byte data2 = this.pattern[e].voice[this.vectrexModMapping[d]].tone[c].effect1;
                    if (data2 == 15 && this.pattern[e].voice[this.vectrexModMapping[d]].tone[c].effect2 < 2) {
                        if (VERBOSITY > 0) {
                            this.stdOut.append("Setting speed to " + this.hex((byte)(this.pattern[e].voice[this.vectrexModMapping[d]].tone[c].effect2 * 16 + this.pattern[e].voice[this.vectrexModMapping[d]].tone[c].effect3)) + "\n");
                        }
                        SPEED = (byte)(this.pattern[e].voice[this.vectrexModMapping[d]].tone[c].effect2 * 16 + this.pattern[e].voice[this.vectrexModMapping[d]].tone[c].effect3);
                    }
                    if ((data2 = this.pattern[e].voice[this.vectrexModMapping[d]].tone[c].note) < 24) {
                        this.stdOut.append("*** Attention: Pattern $" + this.hex((byte)e) + " Voice $" + this.hex((byte)this.vectrexModMapping[d]) + " Position $" + this.hex((byte)c) + " is too low! ***\n");
                    } else {
                        data2 = (byte)(data2 - 24);
                    }
                    byte instNo = this.pattern[e].voice[this.vectrexModMapping[d]].tone[c].instrument;
                    ModJPanel.VectrexInstrument instr = this.getInstrument(instNo);
                    if (instr != null) {
                        if (instr.isSilent) {
                            data2 = ModJPanel.VectrexInstrument.SILENCE.vectrexByte;
                        } else if (instr.isNoise) {
                            data2 = (byte)(instr.vectrexByte | 0x40);
                        }
                    }
                    if (d < 2 && this.pattern[e].voice[this.vectrexModMapping[d + 1]].tone[c].note != OFFNOTE_VALUE) {
                        data2 = (byte)(data2 | 0x80);
                    }
                    if (d == 0 && this.pattern[e].voice[this.vectrexModMapping[d + 2]].tone[c].note != OFFNOTE_VALUE) {
                        data2 = (byte)(data2 | 0x80);
                    }
                    if (this.pattern[e].voice[this.vectrexModMapping[d]].tone[c].note != OFFNOTE_VALUE) {
                        writer.print("$" + this.hex(data2) + ", ");
                        continue;
                    }
                    writer.print("     ");
                }
                if (SPEED == DEFAULT_SPEED) {
                    writer.println("SPEED ; $" + this.hex((byte)c));
                    continue;
                }
                writer.println("$" + this.hex(SPEED) + " ; $" + this.hex((byte)c));
            }
            writer.println(" fcb $00, $80 ; end-marker");
            writer.println();
            if (VERBOSITY <= 1) continue;
            this.stdOut.append("\n");
        }
        if (VERBOSITY > 0) {
            this.stdOut.append("done.\n");
        }
        if (VERBOSITY > 0) {
            this.stdOut.append("\n");
        }
    }

    ModJPanel.VectrexInstrument getInstrument(int no) {
        for (ModJPanel.InstrumentHandle vh : this.instrumentHandles) {
            if (vh.no != no) continue;
            return vh.vectrex;
        }
        return null;
    }

    void writePatternIndirect(PrintWriter writer) {
        int c;
        this.stdOut.append("Writing section \"Patterns\"\n");
        writer.println(";--- music data [created with " + PROGNAME + " v" + VERSION + " - " + _DATE + " by " + AUTHOR + "] ---");
        writer.println();
        writer.println("adsr: ");
        writer.println("  fcb " + this.adsr1 + "      ; channel 2");
        writer.println("  fcb " + this.adsr2 + "      ; channel 1");
        writer.println("  fcb " + this.adsr3 + "      ; channel 0");
        writer.println();
        writer.println("twang: ");
        writer.println("  fcb " + this.twang1 + "      ; channel 2");
        writer.println("  fcb " + this.twang2 + "      ; channel 1");
        writer.println("  fcb " + this.twang3 + "      ; channel 0");
        writer.println();
        writer.println("");
        writer.println("SPEED = " + DEFAULT_SPEED);
        if (VERBOSITY > 0) {
            this.stdOut.append(" Writing Pattern Position Table...\n");
        }
        writer.println("; Player identifier values");
        writer.println("SIL            EQU     $3f   ;  Silence");
        writer.println("NOISE          EQU     $40   ;  Sound is a 'noise'");
        writer.println("CONT           EQU     $80   ;  continue to next note (max 2 continues per line)");
        writer.println("; ");
        writer.println("; Instrument mapping");
        for (ModJPanel.InstrumentHandle instrumentHandle : this.instrumentHandles) {
            if (instrumentHandle.vectrex.isNote) {
                writer.println("; " + this.getInstrumentLabelForced(instrumentHandle.no, 0).trim() + "                        ;  Note     : " + instrumentHandle.name + " -> " + instrumentHandle.vectrex.name);
                continue;
            }
            String l = this.getInstrumentLabel(instrumentHandle.no, 0).trim();
            writer.print(l + "            EQU     $" + this.hex(instrumentHandle.vectrex.vectrexByte));
            if (instrumentHandle.vectrex.isNoise) {
                writer.println("   ;  Noise    : " + instrumentHandle.name + " -> " + instrumentHandle.vectrex.name);
                continue;
            }
            if (instrumentHandle.vectrex.isSilent) {
                writer.println("   ;  Silence  : " + instrumentHandle.name + " -> " + instrumentHandle.vectrex.name);
                continue;
            }
            if (instrumentHandle.vectrex.isNote) {
                writer.println("   ;  Note     : " + instrumentHandle.name + " -> " + instrumentHandle.vectrex.name);
                continue;
            }
            writer.println("   ;  Unkown");
        }
        int counter = 0;
        writer.println("; ");
        writer.println("; Note mapping");
        for (String note : VEC_NOTES) {
            writer.println(note + "            EQU     $" + this.hex((byte)counter++));
        }
        writer.println("; ");
        writer.println("; Song values");
        writer.println("songLength     EQU     $" + this.hex(this.songlength));
        writer.println("loopPosition   EQU     $" + this.hex(this.loop_position));
        writer.println();
        writer.println(";   Pattern ");
        writer.println("script:");
        for (c = 0; c <= this.songlength - 1; ++c) {
            writer.println("  fdb pattern" + this.hex(this.pattern_position[c]));
        }
        writer.println();
        if (VERBOSITY > 0) {
            this.stdOut.append(" Writing Patterns...\n");
        }
        for (int e = 0; e <= this.pattern_number; ++e) {
            if (!this.pattern[e].used) continue;
            writer.println("pattern" + this.hex((byte)e) + ":");
            writer.println("  fdb adsr");
            writer.println("  fdb twang");
            writer.println();
            boolean bl = false;
            for (c = 0; c <= 63; ++c) {
                int n = 0;
                writer.print("  fcb ");
                n += 6;
                if (this.pattern[e].voice[this.vectrexModMapping[0]].tone[c].note == OFFNOTE_VALUE && this.pattern[e].voice[this.vectrexModMapping[1]].tone[c].note == OFFNOTE_VALUE && this.pattern[e].voice[this.vectrexModMapping[2]].tone[c].note == OFFNOTE_VALUE) {
                    writer.print("SIL,");
                    n += 4;
                }
                for (int d = 0; d <= 2; ++d) {
                    byte data2 = this.pattern[e].voice[this.vectrexModMapping[d]].tone[c].effect1;
                    if (data2 == 15 && this.pattern[e].voice[this.vectrexModMapping[d]].tone[c].effect2 < 2) {
                        if (VERBOSITY > 0) {
                            this.stdOut.append("Setting speed to " + this.hex((byte)(this.pattern[e].voice[this.vectrexModMapping[d]].tone[c].effect2 * 16 + this.pattern[e].voice[this.vectrexModMapping[d]].tone[c].effect3)) + "\n");
                        }
                        SPEED = (byte)(this.pattern[e].voice[this.vectrexModMapping[d]].tone[c].effect2 * 16 + this.pattern[e].voice[this.vectrexModMapping[d]].tone[c].effect3);
                    }
                    if ((data2 = this.pattern[e].voice[this.vectrexModMapping[d]].tone[c].note) < 24) {
                        this.stdOut.append("*** Attention: Pattern $" + this.hex((byte)e) + " Voice $" + this.hex((byte)this.vectrexModMapping[d]) + " Position $" + this.hex((byte)c) + " is too low! ***\n");
                    } else {
                        data2 = (byte)(data2 - 24);
                    }
                    byte instNo = this.pattern[e].voice[this.vectrexModMapping[d]].tone[c].instrument;
                    ModJPanel.VectrexInstrument instr = this.getInstrument(instNo);
                    if (instr != null) {
                        if (instr.isSilent) {
                            data2 = ModJPanel.VectrexInstrument.SILENCE.vectrexByte;
                        } else if (instr.isNoise) {
                            data2 = (byte)(instr.vectrexByte | 0x40);
                        }
                    }
                    if (d < 2 && this.pattern[e].voice[this.vectrexModMapping[d + 1]].tone[c].note != OFFNOTE_VALUE) {
                        data2 = (byte)(data2 | 0x80);
                    }
                    if (d == 0 && this.pattern[e].voice[this.vectrexModMapping[d + 2]].tone[c].note != OFFNOTE_VALUE) {
                        data2 = (byte)(data2 | 0x80);
                    }
                    if (this.pattern[e].voice[this.vectrexModMapping[d]].tone[c].note != OFFNOTE_VALUE) {
                        writer.print(this.getInstrumentLabel(instNo, data2) + ", ");
                        n += 14;
                        continue;
                    }
                    writer.print("                ");
                    n += 14;
                }
                int SPEED_POS = 60;
                for (int p = n; p < SPEED_POS; ++p) {
                    writer.print(" ");
                }
                if (SPEED == DEFAULT_SPEED) {
                    writer.println("SPEED ; $" + this.hex((byte)c));
                    continue;
                }
                writer.println("$" + this.hex(SPEED) + " ; $" + this.hex((byte)c));
            }
            writer.println(" fcb $00, $80 ; end-marker");
            writer.println();
            if (VERBOSITY <= 1) continue;
            this.stdOut.append("\n");
        }
        if (VERBOSITY > 0) {
            this.stdOut.append("done.\n");
        }
        if (VERBOSITY > 0) {
            this.stdOut.append("\n");
        }
    }

    String getInstrumentLabel(int no, int data2) {
        String o = "";
        int newData = data2;
        ModJPanel.VectrexInstrument inst = this.getInstrument(no);
        if (inst == null) {
            this.log.addLog("Mod contains unkown instrument data! (instr: " + no + ") -> DEFAULT to TONE!", LogPanel.WARN);
            newData = data2 & 0xBF;
            newData = data2 & 0x7F;
            o = o + VEC_NOTES[newData & 0x3F];
        } else if (inst.isNote) {
            newData = data2 & 0xBF;
            newData = data2 & 0x7F;
            o = o + VEC_NOTES[newData & 0x3F];
        } else {
            o = o + "_";
            if (no < 10) {
                o = o + 0;
            }
            o = o + "" + no;
        }
        o = (newData & 0x40) == 64 ? o + "+NOISE" : o + "      ";
        o = (data2 & 0x80) == 128 ? o + "+CONT" : o + "     ";
        return o;
    }

    String getInstrumentLabelForced(int no, int data2) {
        String o = "";
        int newData = data2;
        o = o + "_";
        if (no < 10) {
            o = o + 0;
        }
        o = o + "" + no;
        o = (newData & 0x40) == 64 ? o + "+NOISE" : o + "      ";
        o = (data2 & 0x80) == 128 ? o + "+CONT" : o + "     ";
        return o;
    }

    boolean writeIndirectOutput(String fileName) {
        String header_string = "$1100";
        try {
            PrintWriter writer = new PrintWriter(fileName, "UTF-8");
            this.stdOut.append("Writing file \"" + fileName + "\" beginning from " + header_string + "\n");
            this.stdOut.append("\n");
            this.writePatternIndirect(writer);
            writer.close();
        }
        catch (Exception x) {
            this.log.addLog(x, LogPanel.WARN);
            return false;
        }
        this.stdOut.append("The three channels of the mod file have been converted to 3 channels of vectres\n");
        this.stdOut.append("following mapping was used:\n");
        this.stdOut.append("  mod channel " + this.vectrexModMapping[0] + " was mapped to channel 0 vectrex\n");
        this.stdOut.append("  mod channel " + this.vectrexModMapping[1] + " was mapped to channel 1 vectrex\n");
        this.stdOut.append("  mod channel " + this.vectrexModMapping[2] + " was mapped to channel 2 vectrex\n");
        this.stdOut.append("Every voice in a pattern has the length of $40 bytes.\n");
        this.stdOut.append("Every pattern is 3x$40 bytes = $c0 bytes long.\n");
        this.stdOut.append("\n");
        this.stdOut.append("Speed is set to $" + this.hex(SPEED) + ".\n");
        this.stdOut.append("\n");
        this.stdOut.append("Following instrument mapping was used:\n");
        for (ModJPanel.InstrumentHandle vh : this.instrumentHandles) {
            this.stdOut.append("(Mod)Instrument " + vh.no + " (" + vh.name + ") is mapped to vectrex: " + vh.vectrex.name + " (" + this.hex(vh.vectrex.vectrexByte) + ")\n");
        }
        this.stdOut.append("\n");
        this.stdOut.append("\n");
        this.stdOut.append("Lowest note should be G-2.\n");
        this.stdOut.append("\n");
        return true;
    }

    boolean writeDirectOutput(String fileName) {
        String header_string = "$1100";
        try {
            PrintWriter writer = new PrintWriter(fileName, "UTF-8");
            this.stdOut.append("Writing file \"" + fileName + "\" beginning from " + header_string + "\n");
            this.stdOut.append("\n");
            this.writePatternDirect(writer);
            writer.close();
        }
        catch (Exception x) {
            this.log.addLog(x, LogPanel.WARN);
            return false;
        }
        this.stdOut.append("The three channels of the mod file have been converted to 3 channels of vectres\n");
        this.stdOut.append("following mapping was used:\n");
        this.stdOut.append("  mod channel " + this.vectrexModMapping[0] + " was mapped to channel 0 vectrex\n");
        this.stdOut.append("  mod channel " + this.vectrexModMapping[1] + " was mapped to channel 1 vectrex\n");
        this.stdOut.append("  mod channel " + this.vectrexModMapping[2] + " was mapped to channel 2 vectrex\n");
        this.stdOut.append("Every voice in a pattern has the length of $40 bytes.\n");
        this.stdOut.append("Every pattern is 3x$40 bytes = $c0 bytes long.\n");
        this.stdOut.append("\n");
        this.stdOut.append("Speed is set to $" + this.hex(SPEED) + ".\n");
        this.stdOut.append("\n");
        this.stdOut.append("Following instrument mapping was used:\n");
        for (ModJPanel.InstrumentHandle vh : this.instrumentHandles) {
            this.stdOut.append("(Mod)Instrument " + vh.no + " (" + vh.name + ") is mapped to vectrex: " + vh.vectrex.name + " (" + this.hex(vh.vectrex.vectrexByte) + ")\n");
        }
        this.stdOut.append("\n");
        this.stdOut.append("\n");
        this.stdOut.append("Lowest note should be G-2.\n");
        this.stdOut.append("\n");
        return true;
    }

    public String doIt(String filename, String outname, ArrayList<ModJPanel.InstrumentHandle> vh, String a1, String a2, String a3, String t1, String t2, String t3, boolean indirectOutput) {
        int i;
        SPEED = DEFAULT_SPEED;
        this.adsr1 = a3;
        this.adsr2 = a2;
        this.adsr3 = a1;
        this.twang1 = t3;
        this.twang2 = t2;
        this.twang3 = t1;
        this.instrumentHandles = vh;
        this.stdOut = new StringBuffer();
        for (i = 0; i < 128; ++i) {
            this.pattern[i] = new pattern_type();
        }
        for (i = 0; i < 32; ++i) {
            this.sample[i] = new sample_type();
        }
        this.show_message();
        this.inModName = filename;
        int li = outname.lastIndexOf(".");
        if (li < 0) {
            return "File not recognized.";
        }
        this.outTxtName = outname.substring(0, li) + ".txt";
        this.outVecFile = outname.substring(0, li) + ".asm";
        boolean ok = this.readMod(this.inModName);
        if (!ok) {
            return this.stdOut.toString();
        }
        this.findUsedPatterns();
        ok = this.writeModInfo(this.outTxtName);
        if (!ok) {
            return this.stdOut.toString();
        }
        ok = indirectOutput ? this.writeIndirectOutput(this.outVecFile) : this.writeDirectOutput(this.outVecFile);
        return this.stdOut.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readQuiet(String filename) {
        int d;
        char swapChar;
        int c;
        int i;
        for (i = 0; i < 128; ++i) {
            this.pattern[i] = new pattern_type();
        }
        for (i = 0; i < 32; ++i) {
            this.sample[i] = new sample_type();
        }
        FileInputStream fin = null;
        byte[] data2 = new byte[4];
        this.songName = "";
        File file = new File(filename);
        byte[] a = new byte[(int)file.length()];
        int pos = 0;
        try {
            fin = new FileInputStream(file);
            fin.read(a);
        }
        catch (Throwable ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                fin.close();
            }
            catch (Throwable ex) {
                return false;
            }
        }
        for (c = 1; c <= 20; ++c) {
            swapChar = '\u0000';
            if (pos < a.length) {
                swapChar = (char)a[pos++];
            }
            if (swapChar == '\u0000') continue;
            this.songName = this.songName + swapChar;
        }
        for (c = 1; c <= 31; ++c) {
            this.sample[c].name = "";
            for (d = 1; d <= 22; ++d) {
                swapChar = '\u0000';
                if (pos < a.length) {
                    swapChar = (char)a[pos++];
                }
                if (swapChar == '\u0000') continue;
                this.sample[c].name = this.sample[c].name + swapChar;
            }
            data2[0] = a[pos++];
            data2[1] = a[pos++];
            this.sample[c].length = ((data2[0] & 0xFF) * 256 + (data2[1] & 0xFF)) * 2;
            this.sample[c].finetune = a[pos++];
            this.sample[c].finetune = (byte)(this.sample[c].finetune | 0xF);
            this.sample[c].volume = a[pos++];
            data2[0] = a[pos++];
            data2[1] = a[pos++];
            this.sample[c].repeat_pos = ((data2[0] & 0xFF) * 256 + (data2[1] & 0xFF)) * 2;
            data2[0] = a[pos++];
            data2[1] = a[pos++];
            this.sample[c].repeat_length = ((data2[0] & 0xFF) * 256 + (data2[1] & 0xFF)) * 2;
        }
        if (pos < a.length) {
            this.songlength = a[pos++];
        }
        if (pos < a.length) {
            data2[0] = a[pos++];
        }
        for (c = 0; c <= 127; ++c) {
            if (pos >= a.length) continue;
            this.pattern_position[c] = a[pos++];
        }
        this.findPatternNumber();
        this.trackerID = "";
        for (d = 1; d <= 4; ++d) {
            swapChar = '\u0000';
            if (pos < a.length) {
                swapChar = (char)a[pos++];
            }
            if (swapChar == '\u0000') continue;
            this.trackerID = this.trackerID + swapChar;
        }
        this.loop_position = 0;
        for (int f = 0; f <= this.pattern_number; ++f) {
            for (c = 0; c <= 63; ++c) {
                for (d = 0; d <= 3; ++d) {
                    for (int e = 0; e <= 3; ++e) {
                        if (pos >= a.length) continue;
                        data2[e] = a[pos++];
                    }
                    this.pattern[f].voice[d].tone[c].instrument = (byte)(data2[0] & 0xFF & 0xF0 | (data2[2] & 0xFF) >>> 4);
                    this.pattern[f].voice[d].tone[c].period = (data2[0] & 0xFF & 0xF) << 8 | data2[1] & 0xFF;
                    this.pattern[f].voice[d].tone[c].note = this.findNote(this.pattern[f].voice[d].tone[c].period);
                    this.pattern[f].voice[d].tone[c].effect1 = (byte)(data2[2] & 0xFF & 0xF);
                    this.pattern[f].voice[d].tone[c].effect2 = (byte)((data2[3] & 0xFF) >>> 4);
                    this.pattern[f].voice[d].tone[c].effect3 = (byte)(data2[3] & 0xFF & 0xF);
                    if (this.pattern[f].voice[d].tone[c].effect1 != 11) continue;
                    this.loop_position = data2[3];
                }
            }
        }
        return true;
    }

    public boolean collectInfo(String filename, ArrayList<ModJPanel.InstrumentHandle> vh) {
        boolean read = this.readQuiet(filename);
        if (!read) {
            return false;
        }
        this.findUsedPatterns();
        for (int e = 0; e <= this.pattern_number; ++e) {
            if (!this.pattern[e].used) continue;
            for (int c = 0; c <= 63; ++c) {
                for (int d = 0; d <= 3; ++d) {
                    if (this.pattern[e].voice[d].tone[c].note == OFFNOTE_VALUE || this.pattern[e].voice[d].tone[c].instrument <= 0) continue;
                    this.incInstrumentUsed(vh, this.pattern[e].voice[d].tone[c].instrument, d);
                }
            }
        }
        return true;
    }

    void incInstrumentUsed(ArrayList<ModJPanel.InstrumentHandle> vh, int instrumentNo, int voice) {
        for (ModJPanel.InstrumentHandle h : vh) {
            if (h.no != instrumentNo) continue;
            int n = voice;
            h.usage[n] = h.usage[n] + 1;
            return;
        }
    }

    static {
        SPEED = DEFAULT_SPEED = (byte)2;
        BASS_DRUM_VALUE = (byte)63;
        HIHAT_DRUM_VALUE = 1;
        SNARE_DRUM_VALUE = (byte)47;
        PROGNAME = "VIDE: Mod2Vectrex";
        VERSION = "1.08";
        _DATE = "02.01.2011";
        AUTHOR = "Wolf, additions by Nitro/NCE, PAS to Java by Malban";
        VERBOSITY = 1;
        HEXPRE = "0123456789ABCDEF";
        PERIOD = new int[]{3424, 3232, 3048, 2880, 2712, 2560, 2416, 2280, 2152, 2032, 1920, 1812, 1712, 1616, 1524, 1440, 1356, 1280, 1208, 1140, 1076, 1016, 960, 906, 856, 808, 762, 720, 678, 640, 604, 570, 538, 508, 480, 453, 428, 404, 381, 360, 339, 320, 302, 285, 269, 254, 240, 226, 214, 202, 190, 180, 170, 160, 151, 143, 135, 127, 120, 113, 107, 101, 95, 90, 85, 80, 75, 71, 67, 63, 60, 56, 53, 50, 47, 45, 42, 40, 37, 35, 33, 31, 30, 28};
        PSG_PERIOD = new int[]{3421, 3228, 3047, 2876, 2715, 2562, 2419, 2283, 2155, 2546, 1920, 1812, 1710, 1614, 1524, 1438, 1357, 1281, 1209, 1141, 1077, 1017, 960, 906, 855, 807, 762, 719, 679, 641, 605, 571, 539, 508, 480, 453, 428, 404, 381, 360, 339, 320, 302, 285, 269, 254, 240, 226, 214, 202, 190, 180, 170, 160, 151, 143, 135, 127, 120, 113, 107, 101, 95, 90, 85, 80, 76, 71, 67, 64, 60, 57, 53, 50, 48, 45, 42, 40, 38, 36, 34, 32, 30, 28, 27, 25, 24, 22, 21, 20, 19, 18, 17, 24, 15, 14};
        freq2Index = new HashMap();
        for (int i = 0; i < 84; ++i) {
            freq2Index.put(PSG_PERIOD[i], i);
        }
        NAME = new String[]{"C-1", "C#1", "D-1", "D#1", "E-1", "F-1", "F#1", "G-1", "G#1", "A-1", "A#1", "H-1", "C-2", "C#2", "D-2", "D#2", "E-2", "F-2", "F#2", "G-2", "G#2", "A-2", "A#2", "H-2", "C-3", "C#3", "D-3", "D#3", "E-3", "F-3", "F#3", "G-3", "G#3", "A-3", "A#3", "H-3", "C-4", "C#4", "D-4", "D#4", "E-4", "F-4", "F#4", "G-4", "G#4", "A-4", "A#4", "H-4", "C-5", "C#5", "D-5", "D#5", "E-5", "F-5", "F#5", "G-5", "G#5", "A-5", "A#5", "H-5", "C-6", "C#6", "D-6", "D#6", "E-6", "F-6", "F#6", "G-6", "G#6", "A-6", "A#6", "H-6", "C-7", "C#7", "D-7", "D#7", "E-7", "F-7", "F#7", "G-7", "G#7", "A-7", "A#7", "H-7"};
        VEC_NOTES = new String[]{"G2_", "GS2", "A2_", "AS2", "B2_", "C3_", "CS3", "D3_", "DS3", "E3_", "F3_", "FS3", "G3_", "GS3", "A3_", "AS3", "B3_", "C4_", "CS4", "D4_", "DS4", "E4_", "F4_", "FS4", "G4_", "GS4", "A4_", "AS4", "B4_", "C5_", "CS5", "D5_", "DS5", "E5_", "F5_", "FS5", "G5_", "GS5", "A5_", "AS5", "B5_", "C6_", "CS6", "D6_", "DS6", "E6_", "F6_", "FS6", "G6_", "GS6", "A6_", "AS6", "B6_", "C7_", "CS7", "D7_", "DS7", "E7_", "F7_", "FS7", "G7_", "GS7", "A7_", "AS7"};
        OFFNOTE_VALUE = (byte)84;
        OFFNOTE = "---";
        EFFECT_INFO = new String[]{"Protracker V2.3A/3.01 Effect Commands", "----------------------------------------------------------------------------", "0 - Normal play or Arpeggio             0xy : x-first halfnote add, y-second", "1 - Slide Up                            1xx : upspeed", "2 - Slide Down                          2xx : downspeed", "3 - Tone Portamento                     3xx : up/down speed", "4 - Vibrato                             4xy : x-speed,   y-depth", "5 - Tone Portamento + Volume Slide      5xy : x-upspeed, y-downspeed", "6 - Vibrato + Volume Slide              6xy : x-upspeed, y-downspeed", "7 - Tremolo                             7xy : x-speed,   y-depth", "8 - NOT USED", "9 - Set SampleOffset                    9xx : offset (23 -> 2300)", "A - VolumeSlide                         Axy : x-upspeed, y-downspeed", "B - Position Jump                       Bxx : songposition", "C - Set Volume                          Cxx : volume, 00-40", "D - Pattern Break                       Dxx : break position in next pattern", "E - E-Commands                          Exy : see below...", "F - Set Speed                           Fxx : speed (00-1F) / tempo (20-FF)", "----------------------------------------------------------------------------", "E0- Set Filter                          E0x : 0-filter on, 1-filter off", "E1- FineSlide Up                        E1x : value", "E2- FineSlide Down                      E2x : value", "E3- Glissando Control                   E3x : 0-off, 1-on (use with tonep.)", "E4- Set Vibrato Waveform                E4x : 0-sine, 1-ramp down, 2-square", "E5- Set Loop                            E5x : set loop point", "E6- Jump to Loop                        E6x : jump to loop, play x times", "E7- Set Tremolo Waveform                E7x : 0-sine, 1-ramp down. 2-square", "E8- NOT USED", "E9- Retrig Note                         E9x : retrig from note + x vblanks", "EA- Fine VolumeSlide Up                 EAx : add x to volume", "EB- Fine VolumeSlide Down               EBx : subtract x from volume", "EC- NoteCut                             ECx : cut from note + x vblanks", "ED- NoteDelay                           EDx : delay note x vblanks", "EE- PatternDelay                        EEx : delay pattern x notes", "EF- Invert Loop                         EFx : speed", "----------------------------------------------------------------------------"};
    }

    class sample_type {
        String name;
        int length;
        byte finetune;
        byte volume;
        int repeat_pos;
        int repeat_length;

        sample_type() {
        }
    }

    class pattern_type {
        voice_type[] voice = new voice_type[4];
        boolean used;

        public pattern_type() {
            for (int i = 0; i < 4; ++i) {
                this.voice[i] = new voice_type();
            }
        }
    }

    class voice_type {
        tone_type[] tone = new tone_type[64];

        public voice_type() {
            for (int i = 0; i < 64; ++i) {
                this.tone[i] = new tone_type();
            }
        }
    }

    class tone_type {
        byte instrument;
        int period;
        byte note;
        byte effect1;
        byte effect2;
        byte effect3;

        tone_type() {
        }
    }
}

