/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi.sound;

import de.malban.config.Configuration;
import de.malban.gui.panels.LogPanel;

public class NavalTranslationSpeakJet {
    LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    public static final String Anything = "";
    public static final String Nothing = " ";
    public static final String Pause = " ";
    public static final String Silent = "";
    static String[][] punct_rules = new String[][]{{"", " ", "", "6 "}, {"", "-", "", ""}, {".", "'S", "", "167 "}, {"#:.E", "'S", "", "167 "}, {"#", "'S", "", "167 "}, {"", "'", "", ""}, {"", ",", "", "15 "}, {"", ".", "", "15 "}, {"", "?", "", "14 "}, {"", "!", "", "14 "}, {"", null, "", ""}};
    static String[][] A_rules = new String[][]{{"", "A", " ", "133 "}, {" ", "ARE", " ", "136 148 "}, {" ", "AR", "O", "133 148 "}, {"", "AR", "#", "131 148 "}, {"^", "AS", "#", "130 187 "}, {"", "A", "WA", "133 "}, {"", "AW", "", "133 "}, {" :", "ANY", "", "131 142 128 "}, {"", "A", "^+#", "130 "}, {"#:", "ALLY", "", "133 145 128 "}, {" ", "AL", "#", "133 145 "}, {"", "AGAIN", "", "133 179 131 142 "}, {"#:", "AG", "E", "129 165 "}, {"", "A", "^+:#", "132 "}, {" :", "A", "^+ ", "130 "}, {"", "A", "^%", "130 "}, {" ", "ARR", "", "133 148 "}, {"", "ARR", "", "132 148 "}, {" :", "AR", " ", "136 148 "}, {"", "AR", " ", "151 "}, {"", "AR", "", "136 148 "}, {"", "AIR", "", "131 148 "}, {"", "AI", "", "130 "}, {"", "AY", "", "130 "}, {"", "AU", "", "133 "}, {"#:", "AL", " ", "133 145 "}, {"#:", "ALS", " ", "133 145 167 "}, {"", "ALK", "", "133 195 "}, {"", "AL", "^", "133 145 "}, {" :", "ABLE", "", "130 171 133 145 "}, {"", "ABLE", "", "133 171 133 145 "}, {"", "ANG", "+", "130 142 165 "}, {"", "A", "", "132 "}, {"", null, "", ""}};
    static String[][] B_rules = new String[][]{{" ", "BE", "^#", "171 129 "}, {"", "BEING", "", "171 128 129 144 "}, {" ", "BOTH", " ", "171 142 190 "}, {" ", "BUS", "#", "171 129 167 "}, {"", "BUIL", "", "171 129 145 "}, {"", "B", "", "171 "}, {"", null, "", ""}};
    static String[][] C_rules = new String[][]{{" ", "CH", "^", "195 "}, {"^E", "CH", "", "195 "}, {"", "CH", "", "182 "}, {" S", "CI", "#", "187 157 "}, {"", "CI", "A", "189 "}, {"", "CI", "O", "189 "}, {"", "CI", "EN", "189 "}, {"", "C", "+", "187 "}, {"", "CK", "", "195 "}, {"", "COM", "%", "195 134 140 "}, {"", "C", "", "195 "}, {"", null, "", ""}};
    static String[][] D_rules = new String[][]{{"#:", "DED", " ", "174 129 174 "}, {".E", "D", " ", "174 "}, {"#:^E", "D", " ", "191 "}, {" ", "DE", "^#", "174 129 "}, {" ", "DO", " ", "174 139 "}, {" ", "DOES", "", "174 134 167 "}, {" ", "DOING", "", "174 139 129 144 "}, {" ", "DOW", "", "174 163 "}, {"", "DU", "A", "165 139 "}, {"", "D", "", "174 "}, {"", null, "", ""}};
    static String[][] E_rules = new String[][]{{"#:", "E", " ", ""}, {"':^", "E", " ", ""}, {" :", "E", " ", "128 "}, {"#", "ED", " ", "174 "}, {"#:", "E", "D ", ""}, {"", "EV", "ER", "131 166 "}, {"", "E", "^%", "128 "}, {"", "ERI", "#", "128 148 128 "}, {"", "ERI", "", "131 148 129 "}, {"#:", "ER", "#", "151 "}, {"", "ER", "#", "131 148 "}, {"", "ER", "", "151 "}, {" ", "EVEN", "", "128 166 131 142 "}, {"#:", "E", "W", ""}, {"T", "EW", "", "139 "}, {"S", "EW", "", "139 "}, {"R", "EW", "", "139 "}, {"D", "EW", "", "139 "}, {"L", "EW", "", "139 "}, {"Z", "EW", "", "139 "}, {"N", "EW", "", "139 "}, {"J", "EW", "", "139 "}, {"TH", "EW", "", "139 "}, {"CH", "EW", "", "139 "}, {"SH", "EW", "", "139 "}, {"", "EW", "", "158 139 "}, {"", "E", "O", "128 "}, {"#:S", "ES", " ", "129 167 "}, {"#:C", "ES", " ", "129 167 "}, {"#:G", "ES", " ", "129 167 "}, {"#:Z", "ES", " ", "129 167 "}, {"#:X", "ES", " ", "129 167 "}, {"#:J", "ES", " ", "129 167 "}, {"#:CH", "ES", " ", "129 167 "}, {"#:SH", "ES", " ", "129 167 "}, {"#:", "E", "S ", ""}, {"#:", "ELY", " ", "145 128 "}, {"#:", "EMENT", "", "140 131 142 191 "}, {"", "EFUL", "", "186 138 145 "}, {"", "EE", "", "128 "}, {"", "EARN", "", "151 142 "}, {" ", "EAR", "^", "151 "}, {"", "EAD", "", "131 174 "}, {"#:", "EA", " ", "128 133 "}, {"", "EA", "SU", "131 "}, {"", "EA", "", "128 "}, {"", "EIGH", "", "130 "}, {"", "EI", "", "128 "}, {" ", "EYE", "", "157 "}, {"", "EY", "", "128 "}, {"", "EU", "", "158 139 "}, {"", "E", "", "131 "}, {"", null, "", ""}};
    static String[][] F_rules = new String[][]{{"", "FUL", "", "186 138 145 "}, {"", "F", "", "186 "}, {"", null, "", ""}};
    static String[][] G_rules = new String[][]{{"", "GIV", "", "179 129 166 "}, {" ", "G", "I^", "179 "}, {"", "GE", "T", "179 131 "}, {"SU", "GGES", "", "179 165 131 187 "}, {"", "GG", "", "179 "}, {" B#", "G", "", "179 "}, {"", "G", "+", "165 "}, {"", "GREAT", "", "179 148 130 191 "}, {"#", "GH", "", ""}, {"", "G", "", "179 "}, {"", null, "", ""}};
    static String[][] H_rules = new String[][]{{" ", "HAV", "", "184 132 166 "}, {" ", "HERE", "", "184 128 148 "}, {" ", "HOUR", "", "163 151 "}, {"", "HOW", "", "184 163 "}, {"", "HUM", "", "184 160 140 "}, {"", "H", "#", "184 "}, {"", "H", "", ""}, {"", null, "", ""}};
    static String[][] I_rules = new String[][]{{" ", "IN", "", "129 142 "}, {" ", "I", " ", "157 "}, {"", "IN", "D", "157 142 "}, {"", "IER", "", "128 151 "}, {"#:R", "IED", "", "128 174 "}, {"", "IED", " ", "157 174 "}, {"", "IEN", "", "128 131 142 "}, {"", "IE", "T", "157 131 "}, {" :", "I", "%", "157 "}, {"", "I", "%", "128 "}, {"", "IE", "", "128 "}, {"", "I", "^+:#", "129 "}, {"", "IR", "#", "157 148 "}, {"", "IZ", "%", "157 167 "}, {"", "IS", "%", "157 167 "}, {"", "I", "D%", "157 "}, {"+^", "I", "^+", "129 "}, {"", "I", "T%", "157 "}, {"#:^", "I", "^+", "129 "}, {"", "I", "^+", "157 "}, {"", "IR", "", "151 "}, {"", "IGH", "", "157 "}, {"", "ILD", "", "157 145 174 "}, {"", "IGN", " ", "157 142 "}, {"", "IGN", "^", "157 142 "}, {"", "IGN", "%", "157 142 "}, {"", "IQUE", "", "128 195 "}, {"", "I", "", "129 "}, {"", null, "", ""}};
    static String[][] J_rules = new String[][]{{"", "J", "", "165 "}, {"", null, "", ""}};
    static String[][] K_rules = new String[][]{{" ", "K", "N", ""}, {"", "K", "", "195 "}, {"", null, "", ""}};
    static String[][] L_rules = new String[][]{{"", "LO", "C#", "145 142 "}, {"L", "L", "", ""}, {"#:^", "L", "%", "133 145 "}, {"", "LEAD", "", "145 128 174 "}, {"", "L", "", "145 "}, {"", null, "", ""}};
    static String[][] M_rules = new String[][]{{"", "MOV", "", "140 139 166 "}, {"", "MO", "^", "140 137 "}, {"", "M", "", "140 "}, {"", null, "", ""}};
    static String[][] N_rules = new String[][]{{"E", "NG", "+", "142 165 "}, {"", "NG", "R", "144 179 "}, {"", "NG", "#", "144 179 "}, {"", "NGL", "%", "144 179 133 145 "}, {"", "NG", "", "144 "}, {"", "NK", "", "144 195 "}, {" ", "NOW", " ", "142 163 "}, {"", "N", "", "142 "}, {"", null, "", ""}};
    static String[][] O_rules = new String[][]{{"", "OF", " ", "133 166 "}, {"", "OROUGH", "", "151 142 "}, {"#:", "OR", " ", "151 "}, {"#:", "ORS", " ", "151 167 "}, {"", "OR", "", "133 148 "}, {" ", "ONE", "", "147 134 142 "}, {"", "OW", "", "142 "}, {" ", "OVER", "", "142 166 151 "}, {"", "OV", "", "134 166 "}, {"", "O", "^%", "142 "}, {"", "O", "^EN", "142 "}, {"", "O", "^I#", "142 "}, {"", "OL", "D", "142 145 "}, {"", "OUGHT", "", "133 191 "}, {"", "OUGH", "", "134 186 "}, {" ", "OU", "", "163 "}, {"H", "OU", "S#", "163 "}, {"", "OUS", "", "133 187 "}, {"", "OUR", "", "133 148 "}, {"", "OULD", "", "138 174 "}, {"^", "OU", "^L", "134 "}, {"", "OUP", "", "139 199 "}, {"", "OU", "", "163 "}, {"", "OY", "", "156 "}, {"", "OING", "", "142 129 144 "}, {"", "OI", "", "156 "}, {"", "OOR", "", "133 148 "}, {"", "OOK", "", "138 195 "}, {"", "OOD", "", "138 174 "}, {"", "OO", "", "139 "}, {"", "O", "E", "142 "}, {"", "O", " ", "142 "}, {"", "OA", "", "142 "}, {" ", "ONLY", "", "142 142 145 128 "}, {" ", "ONCE", "", "147 134 142 187 "}, {"", "ON'T", "", "142 142 191 "}, {"C", "O", "N", "136 "}, {"", "O", "NG", "133 "}, {" :^", "O", "N", "134 "}, {"I", "ON", "", "133 142 "}, {"#:", "ON", " ", "133 142 "}, {"#^", "ON", "", "133 142 "}, {"", "O", "ST ", "142 "}, {"", "OF", "^", "133 186 "}, {"", "OTHER", "", "134 169 151 "}, {"", "OSS", " ", "133 187 "}, {"#:^", "OM", "", "134 140 "}, {"", "O", "", "136 "}, {"", null, "", ""}};
    static String[][] P_rules = new String[][]{{"", "PH", "", "186 "}, {"", "PEOP", "", "199 128 199 "}, {"", "POW", "", "199 163 "}, {"", "PUT", " ", "199 138 191 "}, {"", "P", "", "199 "}, {"", null, "", ""}};
    static String[][] Q_rules = new String[][]{{"", "QUAR", "", "195 147 133 148 "}, {"", "QU", "", "195 147 "}, {"", "Q", "", "195 "}, {"", null, "", ""}};
    static String[][] R_rules = new String[][]{{" ", "RE", "^#", "148 128 "}, {"", "R", "", "148 "}, {"", null, "", ""}};
    static String[][] S_rules = new String[][]{{"", "SH", "", "189 "}, {"#", "SION", "", "168 133 142 "}, {"", "SOME", "", "187 134 140 "}, {"#", "SUR", "#", "168 151 "}, {"", "SUR", "#", "189 151 "}, {"#", "SU", "#", "168 139 "}, {"#", "SSU", "#", "189 139 "}, {"#", "SED", " ", "167 174 "}, {"#", "S", "#", "167 "}, {"", "SAID", "", "187 131 174 "}, {"^", "SION", "", "189 133 142 "}, {"", "S", "S", ""}, {".", "S", " ", "167 "}, {"#:.E", "S", " ", "167 "}, {"#:^##", "S", " ", "167 "}, {"#:^#", "S", " ", "187 "}, {"U", "S", " ", "187 "}, {" :#", "S", " ", "167 "}, {" ", "SCH", "", "187 195 "}, {"", "S", "C+", ""}, {"#", "SM", "", "167 140 "}, {"#", "SN", "'", "167 133 142 "}, {"", "S", "", "187 "}, {"", null, "", ""}};
    static String[][] T_rules = new String[][]{{" ", "THE", " ", "169 133 "}, {"", "TO", " ", "191 139 "}, {"", "THAT", " ", "169 132 191 "}, {" ", "THIS", " ", "169 129 187 "}, {" ", "THEY", "", "169 130 "}, {" ", "THERE", "", "169 131 148 "}, {"", "THER", "", "169 151 "}, {"", "THEIR", "", "169 131 148 "}, {" ", "THAN", " ", "169 132 142 "}, {" ", "THEM", " ", "169 131 140 "}, {"", "THESE", " ", "169 128 167 "}, {" ", "THEN", "", "169 131 142 "}, {"", "THROUGH", "", "190 148 139 "}, {"", "THOSE", "", "169 142 167 "}, {"", "THOUGH", " ", "169 142 "}, {" ", "THUS", "", "169 134 187 "}, {"", "TH", "", "190 "}, {"#:", "TED", " ", "191 129 174 "}, {"S", "TI", "#N", "182 "}, {"", "TI", "O", "189 "}, {"", "TI", "A", "189 "}, {"", "TIEN", "", "189 133 142 "}, {"", "TUR", "#", "182 151 "}, {"", "TU", "A", "182 139 "}, {" ", "TWO", "", "191 139 "}, {"", "T", "", "191 "}, {"", null, "", ""}};
    static String[][] U_rules = new String[][]{{" ", "UN", "I", "158 139 142 "}, {" ", "UN", "", "134 142 "}, {" ", "UPON", "", "133 199 133 142 "}, {"T", "UR", "#", "138 148 "}, {"S", "UR", "#", "138 148 "}, {"R", "UR", "#", "138 148 "}, {"D", "UR", "#", "138 148 "}, {"L", "UR", "#", "138 148 "}, {"Z", "UR", "#", "138 148 "}, {"N", "UR", "#", "138 148 "}, {"J", "UR", "#", "138 148 "}, {"TH", "UR", "#", "138 148 "}, {"CH", "UR", "#", "138 148 "}, {"SH", "UR", "#", "138 148 "}, {"", "UR", "#", "158 138 148 "}, {"", "UR", "", "151 "}, {"", "U", "^ ", "134 "}, {"", "U", "^^", "134 "}, {"", "UY", "", "157 "}, {" G", "U", "#", ""}, {"G", "U", "%", ""}, {"G", "U", "#", "147 "}, {"#N", "U", "", "158 139 "}, {"T", "U", "", "139 "}, {"S", "U", "", "139 "}, {"R", "U", "", "139 "}, {"D", "U", "", "139 "}, {"L", "U", "", "139 "}, {"Z", "U", "", "139 "}, {"N", "U", "", "139 "}, {"J", "U", "", "139 "}, {"TH", "U", "", "139 "}, {"CH", "U", "", "139 "}, {"SH", "U", "", "139 "}, {"", "U", "", "158 139 "}, {"", null, "", ""}};
    static String[][] V_rules = new String[][]{{"", "VIEW", "", "166 158 139 "}, {"", "V", "", "166 "}, {"", null, "", ""}};
    static String[][] W_rules = new String[][]{{" ", "WERE", "", "147 151 "}, {"", "WA", "S", "147 136 "}, {"", "WA", "T", "147 136 "}, {"", "WHERE", "", "185 131 148 "}, {"", "WHAT", "", "185 136 191 "}, {"", "WHOL", "", "184 142 145 "}, {"", "WHO", "", "184 139 "}, {"", "WH", "", "185 "}, {"", "WAR", "", "147 133 148 "}, {"", "WOR", "^", "147 151 "}, {"", "WR", "", "148 "}, {"", "W", "", "147 "}, {"", null, "", ""}};
    static String[][] X_rules = new String[][]{{"", "X", "", "195 187 "}, {"", null, "", ""}};
    static String[][] Y_rules = new String[][]{{"", "YOUNG", "", "158 134 144 "}, {" ", "YOU", "", "160  "}, {" ", "YES", "", "158 131 187 "}, {" ", "Y", "", "158 "}, {"#:^", "Y", " ", "128 "}, {"#:^", "Y", "I", "128 "}, {" :", "Y", " ", "157 "}, {" :", "Y", "#", "157 "}, {" :", "Y", "^+:#", "129 "}, {" :", "Y", "^#", "157 "}, {"", "Y", "", "129 "}, {"", null, "", ""}};
    static String[][] Z_rules = new String[][]{{"", "Z", "", "167 "}, {"", null, "", ""}};
    static String[][][] Rules = new String[][][]{punct_rules, A_rules, B_rules, C_rules, D_rules, E_rules, F_rules, G_rules, H_rules, I_rules, J_rules, K_rules, L_rules, M_rules, N_rules, O_rules, P_rules, Q_rules, R_rules, S_rules, T_rules, U_rules, V_rules, W_rules, X_rules, Y_rules, Z_rules};
    static String output = "";

    private static boolean isvowel(char chr) {
        return chr == 'A' || chr == 'E' || chr == 'I' || chr == 'O' || chr == 'U';
    }

    private static boolean isconsonant(char chr) {
        return !NavalTranslationSpeakJet.isvowel(chr);
    }

    private static boolean isLetter(char chr) {
        return Character.isAlphabetic(chr);
    }

    private static void outstring(String out) {
        output = output + out;
    }

    public static String xlate_word(String word) {
        int type;
        output = "";
        word = word.toUpperCase().trim();
        int index = 0;
        while ((index = NavalTranslationSpeakJet.find_rule(word, index, Rules[type = NavalTranslationSpeakJet.isLetter(word.charAt(index)) ? word.charAt(index) - 65 + 1 : 0])) < word.length()) {
        }
        return output;
    }

    private static int find_rule(String word, int index, String[][] rules) {
        String[] rule;
        int ruleIndex = 0;
        int remainder = 0;
        while (true) {
            int matchIndex;
            String match;
            if ((match = (rule = rules[ruleIndex++])[1]) == null) {
                Configuration.getConfiguration().getDebugEntity().addLog("NavalTranslation: Can't find rule for: " + word + " index: " + index, LogPanel.INFO);
                return index + 1;
            }
            remainder = index;
            for (matchIndex = 0; matchIndex < match.length() && remainder < word.length() && match.charAt(matchIndex) == word.charAt(remainder); ++remainder, ++matchIndex) {
            }
            if (matchIndex < match.length()) continue;
            String left = rule[0];
            String right = rule[2];
            if (NavalTranslationSpeakJet.leftmatch(left, word, index - 1) && NavalTranslationSpeakJet.rightmatch(right, word, remainder)) break;
        }
        String output = rule[3];
        NavalTranslationSpeakJet.outstring(output);
        return remainder;
    }

    private static boolean leftmatch(String pattern, String context, int contextIndex) {
        int count;
        int patIndex = 0;
        if (pattern.length() == 0) {
            return true;
        }
        if (contextIndex < 0) {
            return pattern.equals(" ");
        }
        patIndex = count - 1;
        for (count = pattern.length(); count > 0; --count) {
            char pat = pattern.charAt(patIndex);
            char text = context.charAt(contextIndex);
            if (Character.isAlphabetic(pat) || pat == '\'' || pat == ' ') {
                if (pat != text) {
                    return false;
                }
                if (--contextIndex < 0) {
                    return count - 1 <= 0;
                }
            } else {
                switch (pat) {
                    case '#': {
                        if (!NavalTranslationSpeakJet.isvowel(text)) {
                            return false;
                        }
                        if (--contextIndex < 0) {
                            return count - 1 <= 0;
                        }
                        text = context.charAt(contextIndex);
                        while (NavalTranslationSpeakJet.isvowel(text)) {
                            if (--contextIndex < 0) {
                                return count - 1 <= 0;
                            }
                            text = context.charAt(contextIndex);
                        }
                        break;
                    }
                    case ':': {
                        while (NavalTranslationSpeakJet.isconsonant(text)) {
                            if (--contextIndex < 0) {
                                return count - 1 <= 0;
                            }
                            text = context.charAt(contextIndex);
                        }
                        break;
                    }
                    case '^': {
                        if (!NavalTranslationSpeakJet.isconsonant(text)) {
                            return false;
                        }
                        if (--contextIndex < 0) {
                            return count - 1 <= 0;
                        }
                        text = context.charAt(contextIndex);
                        break;
                    }
                    case '.': {
                        if (text != 'B' && text != 'D' && text != 'V' && text != 'G' && text != 'J' && text != 'L' && text != 'M' && text != 'N' && text != 'R' && text != 'W' && text != 'Z') {
                            return false;
                        }
                        if (--contextIndex < 0) {
                            return count - 1 <= 0;
                        }
                        text = context.charAt(contextIndex);
                        break;
                    }
                    case '+': {
                        if (text != 'E' && text != 'I' && text != 'Y') {
                            return false;
                        }
                        if (--contextIndex < 0) {
                            return count - 1 <= 0;
                        }
                        text = context.charAt(contextIndex);
                        break;
                    }
                    default: {
                        Configuration.getConfiguration().getDebugEntity().addLog("Bad char in left rule: '" + pat + "'", LogPanel.INFO);
                        return false;
                    }
                }
            }
            --patIndex;
        }
        return true;
    }

    private static boolean rightmatch(String pattern, String context, int contextIndex) {
        int patIndex = 0;
        if (pattern.length() == 0) {
            return true;
        }
        if (contextIndex >= context.length()) {
            return false;
        }
        char text = context.charAt(contextIndex);
        block8: for (patIndex = 0; patIndex < pattern.length(); ++patIndex) {
            char pat = pattern.charAt(patIndex);
            if (Character.isAlphabetic(pat) || pat == '\'' || pat == ' ') {
                if (pat != text) {
                    return false;
                }
                if (++contextIndex >= context.length()) {
                    return patIndex + 1 >= pattern.length();
                }
                text = context.charAt(contextIndex);
                continue;
            }
            switch (pat) {
                case '#': {
                    if (!NavalTranslationSpeakJet.isvowel(text)) {
                        return false;
                    }
                    if (++contextIndex >= context.length()) {
                        return patIndex + 1 >= pattern.length();
                    }
                    text = context.charAt(contextIndex);
                    while (NavalTranslationSpeakJet.isvowel(text)) {
                        if (++contextIndex >= context.length()) {
                            return patIndex + 1 >= pattern.length();
                        }
                        text = context.charAt(contextIndex);
                    }
                    continue block8;
                }
                case ':': {
                    while (NavalTranslationSpeakJet.isconsonant(text)) {
                        if (++contextIndex >= context.length()) {
                            return patIndex + 1 >= pattern.length();
                        }
                        text = context.charAt(contextIndex);
                    }
                    continue block8;
                }
                case '^': {
                    if (!NavalTranslationSpeakJet.isconsonant(text)) {
                        return false;
                    }
                    if (++contextIndex >= context.length()) {
                        return patIndex + 1 >= pattern.length();
                    }
                    text = context.charAt(contextIndex);
                    continue block8;
                }
                case '.': {
                    if (text != 'B' && text != 'D' && text != 'V' && text != 'G' && text != 'J' && text != 'L' && text != 'M' && text != 'N' && text != 'R' && text != 'W' && text != 'Z') {
                        return false;
                    }
                    if (++contextIndex >= context.length()) {
                        return patIndex + 1 >= pattern.length();
                    }
                    text = context.charAt(contextIndex);
                    continue block8;
                }
                case '+': {
                    if (text != 'E' && text != 'I' && text != 'Y') {
                        return false;
                    }
                    if (++contextIndex >= context.length()) {
                        return patIndex + 1 >= pattern.length();
                    }
                    text = context.charAt(contextIndex);
                    continue block8;
                }
                case '%': {
                    if (text == 'E') {
                        if (++contextIndex >= context.length()) {
                            return false;
                        }
                        text = context.charAt(contextIndex);
                        if (text == 'L') {
                            if (++contextIndex >= context.length()) {
                                return false;
                            }
                            text = context.charAt(contextIndex);
                            if (text == 'Y') {
                                if (++contextIndex >= context.length()) {
                                    return patIndex + 1 >= pattern.length();
                                }
                                text = context.charAt(contextIndex);
                                continue block8;
                            }
                            text = context.charAt(--contextIndex);
                            continue block8;
                        }
                        if (text != 'R' && text != 'S' && text != 'D') continue block8;
                        if (++contextIndex >= context.length()) {
                            return patIndex + 1 >= pattern.length();
                        }
                        text = context.charAt(contextIndex);
                        continue block8;
                    }
                    if (text == 'I') {
                        if (++contextIndex >= context.length()) {
                            return false;
                        }
                        text = context.charAt(contextIndex);
                        if (text == 'N') {
                            if (++contextIndex >= context.length()) {
                                return false;
                            }
                            text = context.charAt(contextIndex);
                            if (text == 'G') {
                                if (++contextIndex >= context.length()) {
                                    return patIndex + 1 >= pattern.length();
                                }
                                text = context.charAt(contextIndex);
                                continue block8;
                            }
                        }
                        return false;
                    }
                    return false;
                }
                default: {
                    Configuration.getConfiguration().getDebugEntity().addLog("Bad char in right rule: '" + pat + "'", LogPanel.INFO);
                    return false;
                }
            }
        }
        return true;
    }

    public class Rule {
        String left;
        String match;
        String right;
        String out;
    }
}

