/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi.sound;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.event.EditMouseEvent;
import de.malban.graphics.MouseMovedListener;
import de.malban.graphics.MousePressedListener;
import de.malban.graphics.SingleImagePanel;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.HotKey;
import de.malban.gui.Windowable;
import de.malban.gui.components.CSAView;
import de.malban.gui.components.ModalInternalFrame;
import de.malban.gui.dialogs.InternalFrameFileChoser;
import de.malban.gui.dialogs.QuickHelpModal;
import de.malban.gui.dialogs.ShowErrorDialog;
import de.malban.gui.panels.LogPanel;
import de.malban.sound.tinysound.Sound;
import de.malban.sound.tinysound.TinySound;
import de.malban.sound.tinysound.internal.ByteList;
import de.malban.sound.tinysound.internal.MemSound;
import de.malban.sound.tinysound.internal.PositionListener;
import de.malban.util.Utility;
import de.malban.util.UtilityFiles;
import de.malban.util.UtilityImage;
import de.malban.util.UtilityString;
import de.malban.vide.dissy.DASM6809;
import de.malban.vide.vedi.VediPanel;
import de.malban.vide.vedi.sound.GetFilenamePanel;
import de.malban.vide.vedi.sound.GetRawFilenamePanel;
import de.malban.vide.vedi.sound.GetWavFilenamePanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;

public class SampleJPanel
extends JPanel
implements PositionListener,
MousePressedListener,
MouseMovedListener,
Windowable {
    public static final String TMP_FILENAME = Global.mainPathPrefix + "tmp" + File.separator + "sampleRecording.wav";
    LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    String currentSampleFile = "";
    MemSound sound = null;
    TargetDataLine targetDataLine = null;
    boolean targetLineOk = false;
    Recorder recorder = null;
    ArrayList<MyMixer> targetMixers = new ArrayList();
    int rangeStartPos = -1;
    int rangeEndPos = -1;
    boolean rangeWasSet = false;
    BufferedImage org = null;
    BufferedImage image = null;
    BufferedImage pos = null;
    int positionDeltaMin = 0;
    int lastPostion = 0;
    int lastDrawnPosition = 0;
    boolean standalone = false;
    private int mClassSetting = 0;
    private CSAView mParent = null;
    private JMenuItem mParentMenuItem = null;
    String pathOnly = "";
    String lastPath = "";
    private JButton jButton1;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButton7;
    private JButton jButtonCancel;
    private JButton jButtonCreate;
    private JButton jButtonCut;
    private JButton jButtonPlaySample;
    private JButton jButtonPlayVectrex;
    private JButton jButtonRecord;
    private JButton jButtonSaveOrgSample;
    private JButton jButtonStop2;
    private JButton jButtonStop3;
    private JCheckBox jCheckBox4BitTranslate;
    private JCheckBox jCheckBoxReverse;
    private JCheckBox jCheckBoxZeroUnsigned;
    private JComboBox jComboBox3;
    private JComboBox jComboBox4;
    private JComboBox jComboBoxAudioDevices;
    private JComboBox jComboBoxAudioDevices1;
    private JComboBox jComboBoxBit;
    private JComboBox jComboBoxChannels;
    private JComboBox jComboBoxEncoding;
    private JComboBox jComboBoxEncodingType;
    private JComboBox jComboBoxEndian;
    private JComboBox jComboBoxNormalize;
    private JComboBox jComboBoxSampleBits;
    private JComboBox jComboBoxSampleRate;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JSlider jSlider1;
    private JTextField jTextField5;
    private JTextField jTextField6;
    private JTextField jTextFieldFrameRate;
    private JTextField jTextFieldFrameSize;
    private JTextField jTextFieldSampleRate;
    private JTextField jTextFieldSizeInternal;
    private JTextField jTextFieldVectrexSize;
    private SingleImagePanel singleImagePanel1;
    ModalInternalFrame modelDialog;
    static int[] psgVolumeTranslation = new int[]{0, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15};

    @Override
    public boolean isIcon() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return false;
        }
        return frame.getInternalFrame(this).isIcon();
    }

    @Override
    public void setIcon(boolean b) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return;
        }
        try {
            frame.getInternalFrame(this).setIcon(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void closing() {
        this.deinit();
    }

    @Override
    public void setParentWindow(CSAView jpv) {
        this.mParent = jpv;
    }

    @Override
    public void setMenuItem(JMenuItem item) {
        this.mParentMenuItem = item;
        this.mParentMenuItem.setText("Sound: Sample Editor");
    }

    @Override
    public JMenuItem getMenuItem() {
        return this.mParentMenuItem;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    public SampleJPanel(String filename) {
        File file;
        this.initComponents();
        this.fillDeviceList();
        this.checkTargetLine();
        if (Global.getOSName().toUpperCase().contains("MAC")) {
            HotKey.addMacDefaults(this.jTextFieldSampleRate);
        }
        if (filename == null) {
            filename = "";
        }
        if ((file = new File(filename)).isDirectory()) {
            this.pathOnly = file.toString();
        } else {
            this.pathOnly = file.getParent();
            this.currentSampleFile = filename;
        }
        if (this.pathOnly == null) {
            this.pathOnly = Global.mainPathPrefix;
        }
        if (this.pathOnly.length() == 0) {
            this.pathOnly = Global.mainPathPrefix;
        }
        if (this.currentSampleFile.length() == 0) {
            this.currentSampleFile = TMP_FILENAME;
        }
        if (this.currentSampleFile.length() != 0) {
            this.setSample(this.currentSampleFile);
        }
        this.paintSamples();
        this.singleImagePanel1.addClickListener(this);
        this.singleImagePanel1.addMouseMovedListener(this);
        this.singleImagePanel1.setCrossDrawn(false);
        this.singleImagePanel1.setSelectionDrawn(false);
    }

    void deinit() {
    }

    @Override
    public void pressed(EditMouseEvent evt) {
        if (this.sound == null) {
            return;
        }
        this.rangeStartPos = evt.evt.getX();
        this.rangeEndPos = -1;
        this.setRanges();
    }

    @Override
    public void moved(EditMouseEvent evt) {
        if (this.sound == null) {
            return;
        }
        if (evt.dragging) {
            this.rangeEndPos = evt.evt.getX();
            this.setRanges();
        }
    }

    private void initComponents() {
        this.singleImagePanel1 = new SingleImagePanel();
        this.jButton1 = new JButton();
        this.jButtonCreate = new JButton();
        this.jButtonSaveOrgSample = new JButton();
        this.jSlider1 = new JSlider();
        this.jButtonCancel = new JButton();
        this.jPanel3 = new JPanel();
        this.jButtonRecord = new JButton();
        this.jButtonPlaySample = new JButton();
        this.jButtonStop2 = new JButton();
        this.jButtonCut = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jTextFieldFrameSize = new JTextField();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jTextFieldFrameRate = new JTextField();
        this.jLabel14 = new JLabel();
        this.jComboBoxEncoding = new JComboBox();
        this.jComboBoxBit = new JComboBox();
        this.jComboBoxChannels = new JComboBox();
        this.jComboBoxEndian = new JComboBox();
        this.jComboBoxSampleRate = new JComboBox();
        this.jLabel16 = new JLabel();
        this.jComboBoxAudioDevices = new JComboBox();
        this.jLabel17 = new JLabel();
        this.jButtonStop3 = new JButton();
        this.jTextFieldSizeInternal = new JTextField();
        this.jLabel20 = new JLabel();
        this.jComboBoxNormalize = new JComboBox();
        this.jPanel4 = new JPanel();
        this.jButtonPlayVectrex = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextFieldSampleRate = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jTextField5 = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jTextField6 = new JTextField();
        this.jLabel7 = new JLabel();
        this.jComboBoxEncodingType = new JComboBox();
        this.jComboBoxSampleBits = new JComboBox();
        this.jComboBox3 = new JComboBox();
        this.jComboBox4 = new JComboBox();
        this.jCheckBox4BitTranslate = new JCheckBox();
        this.jCheckBoxZeroUnsigned = new JCheckBox();
        this.jLabel18 = new JLabel();
        this.jComboBoxAudioDevices1 = new JComboBox();
        this.jButton5 = new JButton();
        this.jButton7 = new JButton();
        this.jLabel19 = new JLabel();
        this.jTextFieldVectrexSize = new JTextField();
        this.jCheckBoxReverse = new JCheckBox();
        this.jButton6 = new JButton();
        this.singleImagePanel1.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                SampleJPanel.this.singleImagePanel1ComponentResized(evt);
            }
        });
        GroupLayout singleImagePanel1Layout = new GroupLayout(this.singleImagePanel1);
        this.singleImagePanel1.setLayout(singleImagePanel1Layout);
        singleImagePanel1Layout.setHorizontalGroup(singleImagePanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        singleImagePanel1Layout.setVerticalGroup(singleImagePanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 207, Short.MAX_VALUE));
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_go.png")));
        this.jButton1.setText("load a sample");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SampleJPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButtonCreate.setText("create source");
        this.jButtonCreate.setName("create");
        this.jButtonCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SampleJPanel.this.jButtonCreateActionPerformed(evt);
            }
        });
        this.jButtonSaveOrgSample.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_save.png")));
        this.jButtonSaveOrgSample.setText("save sample as");
        this.jButtonSaveOrgSample.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SampleJPanel.this.jButtonSaveOrgSampleActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SampleJPanel.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Source"));
        this.jButtonRecord.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/control_record_blue.png")));
        this.jButtonRecord.setToolTipText("Record a sample (microphone)");
        this.jButtonRecord.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonRecord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SampleJPanel.this.jButtonRecordActionPerformed(evt);
            }
        });
        this.jButtonPlaySample.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/control_play_blue.png")));
        this.jButtonPlaySample.setToolTipText("Play current sample!");
        this.jButtonPlaySample.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonPlaySample.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SampleJPanel.this.jButtonPlaySampleActionPerformed(evt);
            }
        });
        this.jButtonStop2.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/control_stop_blue.png")));
        this.jButtonStop2.setToolTipText("Stop recording/playing sample!");
        this.jButtonStop2.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonStop2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SampleJPanel.this.jButtonStop2ActionPerformed(evt);
            }
        });
        this.jButtonCut.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/cut.png")));
        this.jButtonCut.setToolTipText("Cut current seelction!");
        this.jButtonCut.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonCut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SampleJPanel.this.jButtonCutActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Input Format"));
        this.jLabel8.setText("encoding");
        this.jLabel9.setText("sample rate");
        this.jLabel10.setText("bit ");
        this.jLabel11.setText("channels");
        this.jTextFieldFrameSize.setEditable(false);
        this.jTextFieldFrameSize.setText("1");
        this.jLabel12.setText("frame size");
        this.jLabel13.setText("frame rate");
        this.jTextFieldFrameRate.setEditable(false);
        this.jTextFieldFrameRate.setText("22050");
        this.jLabel14.setText("endian");
        this.jComboBoxEncoding.setModel(new DefaultComboBoxModel<String>(new String[]{"PCM_SIGNED", "PCM_UNSIGNED"}));
        this.jComboBoxEncoding.setSelectedIndex(1);
        this.jComboBoxEncoding.setEnabled(false);
        this.jComboBoxEncoding.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SampleJPanel.this.jComboBoxEncodingActionPerformed(evt);
            }
        });
        this.jComboBoxBit.setModel(new DefaultComboBoxModel<String>(new String[]{"8 bit", "16 bit", "24 bit", "32 bit"}));
        this.jComboBoxBit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SampleJPanel.this.jComboBoxBitActionPerformed(evt);
            }
        });
        this.jComboBoxChannels.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2"}));
        this.jComboBoxChannels.setEnabled(false);
        this.jComboBoxChannels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SampleJPanel.this.jComboBoxChannelsActionPerformed(evt);
            }
        });
        this.jComboBoxEndian.setModel(new DefaultComboBoxModel<String>(new String[]{"little endian", "big endian"}));
        this.jComboBoxEndian.setEnabled(false);
        this.jComboBoxEndian.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SampleJPanel.this.jComboBoxEndianActionPerformed(evt);
            }
        });
        this.jComboBoxSampleRate.setModel(new DefaultComboBoxModel<String>(new String[]{"8 kHz", "22.05 kHz", "44.10 kHz", "48 kHz"}));
        this.jComboBoxSampleRate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SampleJPanel.this.jComboBoxSampleRateActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8).addComponent(this.jLabel9).addComponent(this.jLabel10).addComponent(this.jLabel11).addComponent(this.jLabel12).addComponent(this.jLabel13).addComponent(this.jLabel14)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxEncoding, 0, 144, Short.MAX_VALUE).addComponent(this.jComboBoxSampleRate, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBoxBit, -2, -1, -2).addComponent(this.jComboBoxChannels, -2, 46, -2).addComponent(this.jTextFieldFrameSize, -2, 46, -2).addComponent(this.jTextFieldFrameRate).addComponent(this.jComboBoxEndian, -2, -1, -2))));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8).addComponent(this.jComboBoxEncoding, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9).addComponent(this.jComboBoxSampleRate, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel10).addComponent(this.jComboBoxBit, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel11).addComponent(this.jComboBoxChannels, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel12).addComponent(this.jTextFieldFrameSize, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.jTextFieldFrameRate, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel14).addComponent(this.jComboBoxEndian, -2, -1, -2))));
        this.jLabel16.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/help.png")));
        this.jComboBoxAudioDevices.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxAudioDevices.setToolTipText("Select input device");
        this.jComboBoxAudioDevices.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SampleJPanel.this.jComboBoxAudioDevicesActionPerformed(evt);
            }
        });
        this.jLabel17.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/microphone.png")));
        this.jButtonStop3.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/control_equalizer_blue.png")));
        this.jButtonStop3.setToolTipText("normalize samples");
        this.jButtonStop3.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonStop3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SampleJPanel.this.jButtonStop3ActionPerformed(evt);
            }
        });
        this.jTextFieldSizeInternal.setEditable(false);
        this.jTextFieldSizeInternal.setToolTipText("size in byte of internal data representation (16bit, 2channel, 44100Hz)");
        this.jLabel20.setText("size");
        this.jComboBoxNormalize.setModel(new DefaultComboBoxModel<String>(new String[]{"peak", "1bit", "2bit", "3bit", "4bit"}));
        this.jComboBoxNormalize.setToolTipText("<html>\nNormalize<BR>\nThis is a \"simple\" normalize without eleborated range compression.<BR>\nThe options are:<BR>\n<UL>\n<LI>peak: <BR>use highest found value, give it max bits, and scale all others</LI>\n<LI>xbit: <BR>set highest x bits to 0 and than give highest found value max bits and scale all others</LI>\n</UL>\n</html>");
        this.jComboBoxNormalize.setPreferredSize(new Dimension(31, 19));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel17).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxAudioDevices, 0, -1, Short.MAX_VALUE)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel16).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel20).addGap(37, 37, 37).addComponent(this.jTextFieldSizeInternal, -2, 94, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jButtonRecord).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonPlaySample).addGap(28, 28, 28).addComponent(this.jButtonStop2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCut).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonStop3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jComboBoxNormalize, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonRecord).addComponent(this.jButtonPlaySample).addComponent(this.jButtonStop2).addComponent(this.jButtonCut).addComponent(this.jButtonStop3).addComponent(this.jComboBoxNormalize, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel16).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel20).addComponent(this.jTextFieldSizeInternal, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 7, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel17, GroupLayout.Alignment.TRAILING, -2, 21, -2).addComponent(this.jComboBoxAudioDevices, GroupLayout.Alignment.TRAILING, -2, -1, -2))));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Target"));
        this.jButtonPlayVectrex.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/control_play_blue.png")));
        this.jButtonPlayVectrex.setToolTipText("Play current sample!");
        this.jButtonPlayVectrex.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonPlayVectrex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SampleJPanel.this.jButtonPlayVectrexActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Output Format"));
        this.jLabel1.setText("encoding");
        this.jTextFieldSampleRate.setText("8000");
        this.jTextFieldSampleRate.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SampleJPanel.this.jTextFieldSampleRateFocusLost(evt);
            }
        });
        this.jTextFieldSampleRate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SampleJPanel.this.jTextFieldSampleRateActionPerformed(evt);
            }
        });
        this.jTextFieldSampleRate.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                SampleJPanel.this.jTextFieldSampleRateKeyTyped(evt);
            }
        });
        this.jLabel2.setText("sample rate");
        this.jLabel3.setText("bit ");
        this.jLabel4.setText("channels");
        this.jTextField5.setEditable(false);
        this.jTextField5.setText("1");
        this.jTextField5.setToolTipText("");
        this.jLabel5.setText("frame size");
        this.jLabel6.setText("frame rate");
        this.jTextField6.setEditable(false);
        this.jTextField6.setText("8000");
        this.jLabel7.setText("endian");
        this.jComboBoxEncodingType.setModel(new DefaultComboBoxModel<String>(new String[]{"PCM_SIGNED", "PCM_UNSIGNED"}));
        this.jComboBoxEncodingType.setToolTipText("Save signed for direct output. Save unsigned for PSG output!");
        this.jComboBoxEncodingType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SampleJPanel.this.jComboBoxEncodingTypeActionPerformed(evt);
            }
        });
        this.jComboBoxSampleBits.setModel(new DefaultComboBoxModel<String>(new String[]{"8 bit", "4 bit"}));
        this.jComboBoxSampleBits.setToolTipText("Use 8bit for direct output. 4bit can be used for PSG output.");
        this.jComboBoxSampleBits.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SampleJPanel.this.jComboBoxSampleBitsActionPerformed(evt);
            }
        });
        this.jComboBox3.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2"}));
        this.jComboBox3.setEnabled(false);
        this.jComboBox4.setModel(new DefaultComboBoxModel<String>(new String[]{"1 byte"}));
        this.jComboBox4.setEnabled(false);
        this.jCheckBox4BitTranslate.setText("4b transl.");
        this.jCheckBox4BitTranslate.setToolTipText("\"Translates\" 4bit PCM data to PSG volumes (exponential steps)");
        this.jCheckBox4BitTranslate.setEnabled(false);
        this.jCheckBoxZeroUnsigned.setText("0f");
        this.jCheckBoxZeroUnsigned.setToolTipText("zero unsigned floored");
        this.jCheckBoxZeroUnsigned.setEnabled(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jLabel5).addComponent(this.jLabel6).addComponent(this.jLabel7)).addGap(12, 12, 12).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxEncodingType, 0, -1, Short.MAX_VALUE).addComponent(this.jTextFieldSampleRate).addComponent(this.jTextField6).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField5, -2, 46, -2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jComboBox4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxZeroUnsigned, -2, 46, -2)).addComponent(this.jComboBox3, -2, 46, -2)).addContainerGap()).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jComboBoxSampleBits, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jCheckBox4BitTranslate, -2, 82, -2)))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jComboBoxEncodingType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldSampleRate, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jComboBoxSampleBits, -2, -1, -2).addComponent(this.jCheckBox4BitTranslate)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jComboBox3, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jTextField5, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jTextField6, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addComponent(this.jComboBox4, -2, -1, -2).addComponent(this.jCheckBoxZeroUnsigned)).addGap(0, 0, 0)));
        this.jLabel18.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/sound_none.png")));
        this.jComboBoxAudioDevices1.setModel(new DefaultComboBoxModel<String>(new String[]{"Vectrex"}));
        this.jComboBoxAudioDevices1.setToolTipText("Select input device");
        this.jComboBoxAudioDevices1.setEnabled(false);
        this.jButton5.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_save.png")));
        this.jButton5.setText("save (wav)");
        this.jButton5.setMargin(new Insets(2, 2, 2, 2));
        this.jButton5.setPreferredSize(new Dimension(100, 20));
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SampleJPanel.this.jButton5ActionPerformed(evt);
            }
        });
        this.jButton7.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_save.png")));
        this.jButton7.setLabel("save (raw)");
        this.jButton7.setMargin(new Insets(2, 2, 2, 2));
        this.jButton7.setPreferredSize(new Dimension(100, 20));
        this.jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SampleJPanel.this.jButton7ActionPerformed(evt);
            }
        });
        this.jLabel19.setText("size");
        this.jTextFieldVectrexSize.setEditable(false);
        this.jCheckBoxReverse.setSelected(true);
        this.jCheckBoxReverse.setText("reverse");
        this.jCheckBoxReverse.setToolTipText("Save generated asm data in reverse order");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jButtonPlayVectrex).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton5, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton7, -1, -1, Short.MAX_VALUE)).addGroup(jPanel4Layout.createSequentialGroup().addGap(12, 12, 12).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel19).addComponent(this.jLabel18)).addGap(53, 53, 53).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jTextFieldVectrexSize, -2, 78, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxReverse, -1, -1, Short.MAX_VALUE)).addComponent(this.jComboBoxAudioDevices1, 0, -1, Short.MAX_VALUE)))).addGap(0, 0, 0)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonPlayVectrex).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton5, -2, -1, -2).addComponent(this.jButton7, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel19).addComponent(this.jTextFieldVectrexSize, -2, -1, -2).addComponent(this.jCheckBoxReverse)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel18, GroupLayout.Alignment.TRAILING, -2, 21, -2).addComponent(this.jComboBoxAudioDevices1, GroupLayout.Alignment.TRAILING, -2, -1, -2))));
        this.jButton6.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/information.png")));
        this.jButton6.setText("info");
        this.jButton6.setPreferredSize(new Dimension(72, 20));
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SampleJPanel.this.jButton6ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.singleImagePanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSaveOrgSample).addGap(102, 102, 102).addComponent(this.jButtonCancel).addGap(47, 47, 47).addComponent(this.jButtonCreate)).addGroup(layout.createSequentialGroup().addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel4, -2, -1, -2))).addGap(0, 82, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jButton6, -2, 104, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSlider1, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.singleImagePanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSlider1, -2, -1, -2).addComponent(this.jButton6, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCreate).addComponent(this.jButtonCancel).addComponent(this.jButtonSaveOrgSample).addComponent(this.jButton1)).addGap(18, 18, 18)));
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        Configuration.getConfiguration().getMainFrame().removePanel(this);
    }

    private void jButtonRecordActionPerformed(ActionEvent evt) {
        if (this.targetDataLine != null) {
            return;
        }
        if (!this.targetLineOk) {
            return;
        }
        if (this.sound != null) {
            this.sound.unload();
            this.sound = null;
        }
        this.image = null;
        this.targetDataLine = this.getTargetDataLine((MyMixer)this.jComboBoxAudioDevices.getSelectedItem(), this.getSelectedAudioFormat(), -1);
        AudioFileFormat.Type targetType = SampleJPanel.findTargetType("wav");
        File file = new File(TMP_FILENAME);
        this.recorder = new BufferingRecorder(this.targetDataLine, targetType, file);
        this.recorder.start();
        this.jButtonRecord.setEnabled(false);
    }

    private void jButtonPlaySampleActionPerformed(ActionEvent evt) {
        if (this.sound != null) {
            if (this.image != null) {
                this.pos = UtilityImage.copyImage(this.image);
            }
            this.lastPostion = 0;
            this.lastDrawnPosition = 0;
            if (this.rangeEndPos != -1 && this.rangeStartPos != -1) {
                int rStart = this.rangeStartPos;
                int rEnd = this.rangeEndPos;
                if (this.rangeEndPos < this.rangeStartPos) {
                    rEnd = this.rangeStartPos;
                    rStart = this.rangeEndPos;
                }
                if (rStart < 0) {
                    rStart = 0;
                }
                this.sound.playRange(this.getSamplePos(rStart), this.getSamplePos(rEnd));
            } else {
                this.sound.play();
            }
        }
    }

    int getSamplePos(int winPos) {
        int windowWidth;
        double pos;
        int oneChannelFrameSize;
        if (this.sound == null) {
            return -1;
        }
        byte[] data2 = this.sound.getLeftData();
        double sampleWidth = (double)data2.length / (double)(oneChannelFrameSize = 2);
        int samplePos = (int)(sampleWidth * (pos = (double)winPos / (double)(windowWidth = this.singleImagePanel1.getWidth())));
        if (samplePos < 0) {
            samplePos = 0;
        }
        if (samplePos >= data2.length / oneChannelFrameSize) {
            samplePos = data2.length / oneChannelFrameSize - 1;
        }
        return samplePos;
    }

    private void jButtonStop2ActionPerformed(ActionEvent evt) {
        if (this.recorder != null) {
            this.recorder.stopRecording();
            this.checkTargetLine();
            this.recorder = null;
            this.setSample(TMP_FILENAME);
        }
        if (this.sound != null) {
            this.sound.stop();
        }
    }

    private void jButtonCutActionPerformed(ActionEvent evt) {
        if (this.sound != null && this.rangeEndPos != -1 && this.rangeStartPos != -1) {
            int rStart = this.rangeStartPos;
            int rEnd = this.rangeEndPos;
            if (this.rangeEndPos < this.rangeStartPos) {
                rEnd = this.rangeStartPos;
                rStart = this.rangeEndPos;
            }
            if (rStart < 0) {
                rStart = 0;
            }
            this.sound.cutRange(this.getSamplePos(rStart), this.getSamplePos(rEnd));
            this.rangeStartPos = -1;
            this.rangeEndPos = -1;
            this.paintSamples();
        }
    }

    private void jButtonPlayVectrexActionPerformed(ActionEvent evt) {
        this.playVectrex();
    }

    private void jComboBoxSampleRateActionPerformed(ActionEvent evt) {
        if (this.jComboBoxSampleRate.getSelectedIndex() == 0) {
            this.jTextFieldFrameRate.setText("8000");
        }
        if (this.jComboBoxSampleRate.getSelectedIndex() == 1) {
            this.jTextFieldFrameRate.setText("22050");
        }
        if (this.jComboBoxSampleRate.getSelectedIndex() == 2) {
            this.jTextFieldFrameRate.setText("44100");
        }
        if (this.jComboBoxSampleRate.getSelectedIndex() == 3) {
            this.jTextFieldFrameRate.setText("48000");
        }
        this.checkTargetLine();
    }

    private void jComboBoxBitActionPerformed(ActionEvent evt) {
        if (this.jComboBoxBit.getSelectedIndex() == 0) {
            this.jComboBoxEncoding.setSelectedIndex(1);
        } else {
            this.jComboBoxEncoding.setSelectedIndex(0);
        }
        this.calcFrameSize();
        this.checkTargetLine();
    }

    private void jComboBoxChannelsActionPerformed(ActionEvent evt) {
        this.calcFrameSize();
        this.checkTargetLine();
    }

    private void jComboBoxEncodingActionPerformed(ActionEvent evt) {
        this.checkTargetLine();
    }

    private void jComboBoxEndianActionPerformed(ActionEvent evt) {
        this.checkTargetLine();
    }

    private void jComboBoxAudioDevicesActionPerformed(ActionEvent evt) {
    }

    private void singleImagePanel1ComponentResized(ComponentEvent evt) {
        this.image = null;
        this.pos = null;
        this.org = null;
        this.rangeStartPos = -1;
        this.rangeEndPos = -1;
        this.paintSamples();
    }

    private void jButtonCreateActionPerformed(ActionEvent evt) {
        this.createSource();
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        this.saveVectrex();
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        QuickHelpModal.showHelpHtmlFile(Global.mainPathPrefix + "help" + File.separator + "sample.html");
    }

    private void jButtonStop3ActionPerformed(ActionEvent evt) {
        if (this.sound != null) {
            this.normalize();
        }
    }

    private void jButton7ActionPerformed(ActionEvent evt) {
        this.saveVectrexRaw();
    }

    private void jTextFieldSampleRateActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        this.jTextField6.setText(this.jTextFieldSampleRate.getText());
        if (this.convertToVectrex(false) != null) {
            if (this.jComboBoxSampleBits.getSelectedIndex() == 0) {
                this.jTextFieldVectrexSize.setText("" + this.convertToVectrex(false).length);
            } else {
                this.jTextFieldVectrexSize.setText("" + this.convertToVectrex(false).length / 2);
            }
        }
    }

    private void jTextFieldSampleRateFocusLost(FocusEvent evt) {
        this.jTextField6.setText(this.jTextFieldSampleRate.getText());
        if (this.convertToVectrex(false) != null) {
            if (this.jComboBoxSampleBits.getSelectedIndex() == 0) {
                this.jTextFieldVectrexSize.setText("" + this.convertToVectrex(false).length);
            } else {
                this.jTextFieldVectrexSize.setText("" + this.convertToVectrex(false).length / 2);
            }
        }
    }

    private void jTextFieldSampleRateKeyTyped(KeyEvent evt) {
        this.jTextField6.setText(this.jTextFieldSampleRate.getText());
        if (this.convertToVectrex(false) != null) {
            if (this.jComboBoxSampleBits.getSelectedIndex() == 0) {
                this.jTextFieldVectrexSize.setText("" + this.convertToVectrex(false).length);
            } else {
                this.jTextFieldVectrexSize.setText("" + this.convertToVectrex(false).length / 2);
            }
        }
    }

    private void jButtonSaveOrgSampleActionPerformed(ActionEvent evt) {
        String name = GetWavFilenamePanel.showEnterValueDialog();
        name = name + ".wav";
        if (this.pathOnly == null) {
            this.pathOnly = Global.mainPathPrefix;
        }
        if (this.pathOnly.length() == 0) {
            this.pathOnly = Global.mainPathPrefix;
        }
        name = this.pathOnly + File.separator + name;
        try {
            byte[] orgData16Bit2Channel = this.sound.getData();
            AudioFormat tinyformat = TinySound.FORMAT;
            AudioInputStream audioStream = new AudioInputStream(new ByteArrayInputStream(orgData16Bit2Channel), tinyformat, orgData16Bit2Channel.length / 4);
            AudioFileFormat.Type targetType = SampleJPanel.findTargetType("wav");
            AudioSystem.write(audioStream, targetType, new File(name));
        }
        catch (Throwable e) {
            this.log.addLog(e, LogPanel.WARN);
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        if (this.lastPath.length() == 0) {
            if (this.pathOnly == null) {
                this.lastPath = Global.mainPathPrefix;
                fc.setCurrentDirectory(new File(this.lastPath));
            } else {
                fc.setCurrentDirectory(new File(this.pathOnly));
            }
        } else {
            fc.setCurrentDirectory(new File(this.lastPath));
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter("wav", "wav");
        fc.setFileFilter(filter);
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return;
        }
        this.lastPath = fc.getSelectedFile().getAbsolutePath();
        String relPath = Utility.makeVideRelative(this.lastPath);
        this.setSample(relPath);
    }

    private void jComboBoxSampleBitsActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        this.jTextField6.setText(this.jTextFieldSampleRate.getText());
        if (this.convertToVectrex(false) != null) {
            if (this.jComboBoxSampleBits.getSelectedIndex() == 0) {
                this.jTextFieldVectrexSize.setText("" + this.convertToVectrex(false).length);
            } else {
                this.jTextFieldVectrexSize.setText("" + this.convertToVectrex(false).length / 2);
            }
        }
    }

    private void jComboBoxEncodingTypeActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
    }

    void calcFrameSize() {
        int size = this.jComboBoxBit.getSelectedIndex() + 1;
        this.jTextFieldFrameSize.setText("" + (size *= this.jComboBoxChannels.getSelectedIndex() + 1));
        this.checkTargetLine();
    }

    public static boolean showSamplePanel(String fileName, boolean fileExists) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        SampleJPanel panel = new SampleJPanel(fileName);
        ArrayList<JButton> eb = new ArrayList<JButton>();
        eb.add(panel.jButtonCreate);
        eb.add(panel.jButtonCancel);
        ModalInternalFrame modal = new ModalInternalFrame("Sample", frame.getRootPane(), frame, panel, null, null, eb);
        modal.setResizable(true);
        panel.modelDialog = modal;
        modal.setVisible(true);
        String result = modal.getNamedExit();
        return result.equals("create");
    }

    public static boolean showSamplePanelNoModal() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        SampleJPanel panel = new SampleJPanel(null);
        panel.standalone = true;
        Configuration.getConfiguration().getMainFrame().addAsWindow(panel, 800, 800, "Sound: Sample Editor");
        return true;
    }

    private void checkTargetLine() {
        if (this.targetMixers.isEmpty()) {
            this.jLabel16.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/help.png")));
            return;
        }
        this.targetDataLine = null;
        this.targetDataLine = this.getTargetDataLine((MyMixer)this.jComboBoxAudioDevices.getSelectedItem(), this.getSelectedAudioFormat(), -1);
        if (this.targetDataLine == null) {
            this.targetLineOk = false;
            this.jLabel16.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/cancel.png")));
        } else {
            this.targetLineOk = true;
            this.jLabel16.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/accept.png")));
        }
        this.targetDataLine = null;
        if (this.recorder != null) {
            this.jButtonRecord.setEnabled(this.targetLineOk);
        }
    }

    private AudioFormat getSelectedAudioFormat() {
        AudioFormat.Encoding encoding = this.jComboBoxEncoding.getSelectedIndex() == 0 ? AudioFormat.Encoding.PCM_SIGNED : AudioFormat.Encoding.PCM_UNSIGNED;
        int nBitsPerSample = DASM6809.toNumber(this.jComboBoxBit.getSelectedItem().toString().split(" ")[0]);
        boolean bBigEndian = this.jComboBoxEndian.getSelectedIndex() == 1;
        int nChannels = this.jComboBoxChannels.getSelectedIndex() + 1;
        int nFrameSize = nBitsPerSample / 8 * nChannels;
        int fRate = DASM6809.toNumber(this.jTextFieldFrameRate.getText());
        int fsize = DASM6809.toNumber(this.jTextFieldFrameSize.getText());
        AudioFormat audioFormat = new AudioFormat(encoding, fRate, nBitsPerSample, nChannels, nFrameSize, fRate, bBigEndian);
        int nInternalBufferSize = -1;
        return audioFormat;
    }

    public boolean setSample(String fullPathFilename) {
        this.currentSampleFile = fullPathFilename;
        File file = new File(this.currentSampleFile);
        if (!file.exists()) {
            return false;
        }
        this.sound = (MemSound)TinySound.loadSound(new File(this.currentSampleFile), false);
        if (this.sound != null) {
            this.setAudioFormat(fullPathFilename);
        } else {
            this.log.addLog("Sample could not be loaded: " + fullPathFilename, LogPanel.WARN);
        }
        this.paintSamples();
        return false;
    }

    void paintSamples() {
        int windowWidth = this.singleImagePanel1.getWidth();
        int windowHeight = this.singleImagePanel1.getHeight();
        if (windowWidth == 0 || windowHeight == 0) {
            return;
        }
        if (this.image == null) {
            this.pos = null;
            this.org = null;
            this.image = UtilityImage.getNewImage(windowWidth, windowHeight);
        }
        Graphics2D g = this.image.createGraphics();
        g.clearRect(0, 0, windowWidth, windowHeight);
        if (this.sound == null) {
            g.dispose();
            this.singleImagePanel1.setImage(this.image);
            return;
        }
        byte[] data2 = this.sound.getLeftData();
        int oneChannelFrameSize = 2;
        this.jTextFieldSizeInternal.setText("" + this.sound.getLeftData().length * 2);
        this.jTextFieldVectrexSize.setText("" + this.convertToVectrex(false).length);
        double maxSampleWidth = 32768.0;
        int height0 = windowHeight / 2;
        double heightScale = (double)height0 / maxSampleWidth;
        int gfxSampleWidth = data2.length / oneChannelFrameSize / windowWidth;
        if (gfxSampleWidth < 1) {
            gfxSampleWidth = 1;
        }
        this.positionDeltaMin = gfxSampleWidth;
        int gfxSample = 0;
        int gfxSampleCount = 0;
        int x = 0;
        int max = -1000000000;
        int min = 1000000000;
        int lastSample = 0;
        int ignoreDiv = 0;
        for (int i = 0; i < data2.length; i += oneChannelFrameSize) {
            int soundSample = this.sound.get16BitDataAt(i, 0);
            boolean ignore = false;
            if (lastSample != 0) {
                if (lastSample * soundSample < 0) {
                    ++ignoreDiv;
                    ignore = true;
                } else {
                    lastSample = soundSample;
                }
            } else {
                lastSample = soundSample;
            }
            if (!ignore) {
                gfxSample += soundSample;
            }
            if ((gfxSampleCount = (gfxSampleCount + 1) % gfxSampleWidth) != 0) continue;
            double gfxSampleScaled = (double)(gfxSample /= gfxSampleWidth - ignoreDiv) * heightScale;
            gfxSample = 0;
            int y = height0 - (int)gfxSampleScaled;
            g.drawLine(x, height0, x, y);
            ++x;
            lastSample = 0;
            ignoreDiv = 0;
        }
        if (this.pos == null) {
            this.pos = UtilityImage.copyImage(this.image);
        } else {
            Graphics2D g2 = this.pos.createGraphics();
            g2.drawImage(this.image, null, null);
            g2.dispose();
        }
        if (this.org == null) {
            this.org = UtilityImage.copyImage(this.image);
        } else {
            Graphics2D g2 = this.org.createGraphics();
            g2.drawImage(this.image, null, null);
            g2.dispose();
        }
        g.dispose();
        this.setRanges();
        this.singleImagePanel1.setImage(this.image);
        this.sound.addPositionListener(this);
    }

    void setRanges() {
        int rStart = this.rangeStartPos;
        int rEnd = this.rangeEndPos;
        if (this.rangeEndPos == -1 || this.rangeStartPos == -1) {
            if (this.rangeWasSet) {
                this.rangeWasSet = false;
                Graphics2D g = this.image.createGraphics();
                g.drawImage(this.org, null, null);
                this.singleImagePanel1.setImage(this.image);
                g.dispose();
            }
            return;
        }
        if (this.rangeEndPos < this.rangeStartPos) {
            rEnd = this.rangeStartPos;
            rStart = this.rangeEndPos;
        }
        Graphics2D g = this.image.createGraphics();
        g.drawImage(this.org, null, null);
        g.setColor(new Color(255, 255, 0, 100));
        g.fillRect(rStart, 0, rEnd - rStart, this.image.getHeight());
        this.rangeWasSet = true;
        this.singleImagePanel1.setImage(this.image);
        g.dispose();
    }

    @Override
    public void positionChanged(final int position) {
        if (this.image == null) {
            return;
        }
        if (this.sound == null) {
            return;
        }
        if (Math.abs(position - this.lastPostion) > this.positionDeltaMin) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Graphics2D g = SampleJPanel.this.pos.createGraphics();
                    int oneChannelFrameSize = 2;
                    int gfxSampleWidth = SampleJPanel.this.sound.getLeftData().length / oneChannelFrameSize / SampleJPanel.this.image.getWidth();
                    if (SampleJPanel.this.lastDrawnPosition != 0) {
                        g.drawImage(SampleJPanel.this.image, SampleJPanel.this.lastDrawnPosition, 0, SampleJPanel.this.lastDrawnPosition + 1, SampleJPanel.this.image.getHeight(), SampleJPanel.this.lastDrawnPosition, 0, SampleJPanel.this.lastDrawnPosition + 1, SampleJPanel.this.image.getHeight(), null);
                    }
                    double pos1 = (double)position / (double)SampleJPanel.this.sound.getLeftData().length;
                    double pos2 = (double)SampleJPanel.this.image.getWidth() * pos1;
                    g.setColor(Color.red);
                    g.drawLine((int)pos2, 0, (int)pos2, SampleJPanel.this.image.getHeight());
                    SampleJPanel.this.singleImagePanel1.setImage(SampleJPanel.this.pos);
                    SampleJPanel.this.lastDrawnPosition = (int)pos2;
                }
            });
            this.lastPostion = position;
        }
    }

    void fillDeviceList() {
        this.jComboBoxAudioDevices.removeAllItems();
        Mixer.Info[] aInfos = AudioSystem.getMixerInfo();
        for (int i = 0; i < aInfos.length; ++i) {
            Line.Info lineInfo;
            Mixer mixer = AudioSystem.getMixer(aInfos[i]);
            if (!mixer.isLineSupported(lineInfo = new Line.Info(TargetDataLine.class))) continue;
            MyMixer mm = new MyMixer(aInfos[i], mixer);
            this.targetMixers.add(mm);
            this.jComboBoxAudioDevices.addItem(mm);
        }
    }

    public TargetDataLine getTargetDataLine(MyMixer mixer, AudioFormat audioFormat, int nBufferSize) {
        TargetDataLine targetDataLine = null;
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, audioFormat, nBufferSize);
        try {
            targetDataLine = (TargetDataLine)mixer.mixer.getLine(info);
            targetDataLine.open(audioFormat, nBufferSize);
        }
        catch (LineUnavailableException e) {
            this.log.addLog(e, LogPanel.INFO);
            targetDataLine = null;
        }
        catch (Exception e) {
            this.log.addLog(e, LogPanel.INFO);
            targetDataLine = null;
        }
        if (targetDataLine != null) {
            targetDataLine.close();
        }
        return targetDataLine;
    }

    public static AudioFileFormat.Type findTargetType(String strExtension) {
        AudioFileFormat.Type[] aTypes = AudioSystem.getAudioFileTypes();
        for (int i = 0; i < aTypes.length; ++i) {
            if (!aTypes[i].getExtension().equals(strExtension)) continue;
            return aTypes[i];
        }
        return null;
    }

    public static void listSupportedTargetTypes() {
        String strMessage = "Supported target types:";
        AudioFileFormat.Type[] aTypes = AudioSystem.getAudioFileTypes();
        for (int i = 0; i < aTypes.length; ++i) {
            strMessage = strMessage + " " + aTypes[i].getExtension();
        }
        System.out.println(strMessage);
    }

    void createSource() {
        int index8;
        byte[] vectrexSampleData = this.convertToVectrex(true);
        int size = vectrexSampleData.length;
        int div = 1;
        if (this.jComboBoxSampleBits.getSelectedIndex() == 1) {
            div = 2;
        }
        if (this.jCheckBoxZeroUnsigned.isSelected()) {
            for (int index82 = 0; index82 < size; ++index82) {
                int data8 = 0;
                data8 = vectrexSampleData[index82];
                byte test = (byte)((data8 += 128) & 0xFF);
                if (test < 0) {
                    int t2 = test * -1;
                    test = (byte)t2;
                    data8 = test;
                }
                vectrexSampleData[index82] = (byte)data8;
            }
        }
        if (size / div > 49052) {
            ShowErrorDialog.showErrorDialog("Size of samples exceeds memory limit of vectrex, creating source of that is stupid!<BR>I, <B>'VIDE'</B> refuses to do so!");
            return;
        }
        String name = "";
        if (this.standalone) {
            InternalFrameFileChoser fc = new InternalFrameFileChoser();
            fc.setDialogTitle("Select save directory/name");
            fc.setCurrentDirectory(new File(Global.mainPathPrefix));
            int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
            if (r != 0) {
                return;
            }
            this.pathOnly = fc.getSelectedFile() != null ? fc.getSelectedFile().getParent() : fc.getCurrentDirectory().getPath();
            if (this.pathOnly == null) {
                this.pathOnly = Global.mainPathPrefix;
            }
            if (this.pathOnly.length() == 0) {
                this.pathOnly = Global.mainPathPrefix;
            }
            if (!this.pathOnly.endsWith(File.separator)) {
                this.pathOnly = this.pathOnly + File.separator;
            }
            name = fc.getSelectedFile() == null ? "SampleSource" : fc.getSelectedFile().getName();
        } else {
            name = GetFilenamePanel.showEnterValueDialog();
        }
        String nameOnly = name;
        name = name + ".asm";
        if (!this.pathOnly.endsWith(File.separator)) {
            this.pathOnly = this.pathOnly + File.separator;
        }
        StringBuilder b = new StringBuilder();
        b.append("; following is sample data saved by Vide\n");
        if (this.jComboBoxEncodingType.getSelectedIndex() == 0) {
            for (int index83 = 0; index83 < size; ++index83) {
                int data8 = 0;
                data8 = vectrexSampleData[index83];
                vectrexSampleData[index83] = (byte)(data8 -= 128);
            }
            b.append("; the data is in raw format: 8 bit, signed, 1 channel, samplerate: " + this.jTextFieldSampleRate.getText() + "\n");
        } else if (this.jComboBoxSampleBits.getSelectedIndex() == 0) {
            b.append("; the data is in raw format: 8 bit, unsigned, 1 channel, samplerate: " + this.jTextFieldSampleRate.getText() + "\n");
        } else {
            b.append("; the data is in raw format: 4 bit (two nibbles), unsigned, 1 channel, samplerate: " + this.jTextFieldSampleRate.getText() + "\n");
        }
        b.append("; since a frame is only one byte, endianess is meaningless\n");
        b.append("; one word with 'length', followed by length sample bytes\n");
        b.append("\n");
        if (this.jCheckBoxReverse.isSelected()) {
            b.append("; The sample data below is stored in REVERSE order!");
        }
        b.append("\n");
        b.append(nameOnly.toUpperCase() + "_SAMPLERATE equ " + this.jTextFieldSampleRate.getText() + "\n");
        b.append("\n");
        b.append(nameOnly + "_length:\n dw " + size / div + "\n\n");
        b.append(nameOnly + "_data: \n");
        b.append(nameOnly + "_data_start: ");
        int LINEMAX = 10;
        int lineCount = 0;
        int count = 0;
        if (this.jComboBoxSampleBits.getSelectedIndex() == 0) {
            for (index8 = 0; index8 < size; ++index8) {
                if (lineCount == 0) {
                    b.append("\n db ");
                } else {
                    b.append(", ");
                }
                byte data2 = vectrexSampleData[index8];
                if (this.jCheckBoxReverse.isSelected()) {
                    data2 = vectrexSampleData[size - 1 - index8];
                }
                b.append(" $" + String.format("%02X", data2 & 0xFF));
                lineCount = (lineCount + 1) % LINEMAX;
                ++count;
            }
        } else {
            for (index8 = 0; index8 < size; index8 += 2) {
                if (lineCount == 0) {
                    b.append("\n db ");
                } else {
                    b.append(", ");
                }
                byte data1 = vectrexSampleData[index8];
                byte data2 = 0;
                if (index8 + 1 < size) {
                    data2 = vectrexSampleData[index8 + 1];
                }
                if (this.jCheckBoxReverse.isSelected()) {
                    data1 = vectrexSampleData[size - 1 - index8];
                    data2 = 0;
                    if (index8 + 1 < size) {
                        data2 = vectrexSampleData[size - 1 - (index8 + 1)];
                    }
                }
                int data3 = (data1 & 0xF0) + (data2 >> 4 & 0xF);
                if (this.jCheckBox4BitTranslate.isSelected()) {
                    data3 = psgVolumeTranslation[data1 & 0xFF] * 16 + psgVolumeTranslation[data2 & 0xFF];
                }
                b.append(" $" + String.format("%02X", data3 & 0xFF));
                lineCount = (lineCount + 1) % LINEMAX;
                ++count;
            }
        }
        b.append("\n" + nameOnly + "_data_end: ");
        String pathNow = this.pathOnly;
        if (!pathNow.endsWith(File.separator)) {
            this.pathOnly = this.pathOnly + File.separator;
        }
        UtilityFiles.createTextFile(pathNow + name, b.toString());
        if (this.jComboBoxSampleBits.getSelectedIndex() == 0) {
            Path include2 = Paths.get(Global.mainPathPrefix, "template", "VECTREX.I");
            UtilityFiles.copyOneFile(include2.toString(), pathNow + "VECTREX.I");
            Path digital = Paths.get(Global.mainPathPrefix, "template", "digitalPlayer.i");
            UtilityFiles.copyOneFile(digital.toString(), pathNow + "digitalPlayer.i");
            Path template = Paths.get(Global.mainPathPrefix, "template", "digitalPlayMain.template");
            String exampleMain = UtilityString.readTextFileToOneString(new File(template.toString()));
            int sampleRate = UtilityString.IntX(this.jTextFieldSampleRate.getText(), 8000);
            exampleMain = UtilityString.replace(exampleMain, "#SAMPLE_RATE#", "" + nameOnly.toUpperCase() + "_SAMPLERATE");
            exampleMain = UtilityString.replace(exampleMain, "#SAMPLE_START#", "" + nameOnly + "_data_start");
            exampleMain = UtilityString.replace(exampleMain, "#SAMPLE_LENGTH#", "" + nameOnly + "_length");
            exampleMain = UtilityString.replace(exampleMain, "#SAMPLE_FILE#", "" + nameOnly + ".asm");
            UtilityFiles.createTextFile(pathNow + nameOnly + "Main.asm", exampleMain);
            if (this.standalone) {
                VediPanel.openInVedi(pathNow + nameOnly + "Main.asm");
            }
        } else {
            Path include3 = Paths.get(Global.mainPathPrefix, "template", "VECTREX.I");
            UtilityFiles.copyOneFile(include3.toString(), pathNow + "VECTREX.I");
            Path digital = Paths.get(Global.mainPathPrefix, "template", "digitalPlayerPSG.i");
            UtilityFiles.copyOneFile(digital.toString(), pathNow + "digitalPlayerPSG.i");
            Path template = Paths.get(Global.mainPathPrefix, "template", "digitalPlayMainPSG.template");
            String exampleMain = UtilityString.readTextFileToOneString(new File(template.toString()));
            int sampleRate = UtilityString.IntX(this.jTextFieldSampleRate.getText(), 8000);
            exampleMain = UtilityString.replace(exampleMain, "#SAMPLE_RATE#", "" + nameOnly.toUpperCase() + "_SAMPLERATE");
            exampleMain = UtilityString.replace(exampleMain, "#SAMPLE_START#", "" + nameOnly + "_data_start");
            exampleMain = UtilityString.replace(exampleMain, "#SAMPLE_LENGTH#", "" + nameOnly + "_length");
            exampleMain = UtilityString.replace(exampleMain, "#SAMPLE_FILE#", "" + nameOnly + ".asm");
            UtilityFiles.createTextFile(pathNow + nameOnly + "Main.asm", exampleMain);
            if (this.standalone) {
                VediPanel.openInVedi(pathNow + nameOnly + "Main.asm");
            }
        }
    }

    void playVectrex() {
        byte[] vectrexSampleData = this.convertToVectrex(false);
        if (vectrexSampleData == null) {
            return;
        }
        AudioInputStream audioStream = new AudioInputStream(new ByteArrayInputStream(vectrexSampleData), this.getVectrexAudioFormat(), vectrexSampleData.length);
        Sound s = TinySound.loadSound(audioStream, false);
        s.play();
    }

    AudioFormat getVectrexAudioFormat() {
        int sampleRate = UtilityString.IntX(this.jTextFieldSampleRate.getText(), 8000);
        return new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, sampleRate, 8, 1, 1, sampleRate, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveVectrexRaw() {
        String name = GetRawFilenamePanel.showEnterValueDialog();
        name = name + ".raw";
        if (!this.pathOnly.endsWith(File.separator)) {
            this.pathOnly = this.pathOnly + File.separator;
        }
        name = this.pathOnly + name;
        byte[] vectrexSampleData = this.convertToVectrex(false);
        if (vectrexSampleData == null) {
            return;
        }
        int size = vectrexSampleData.length;
        for (int index8 = 0; index8 < size; ++index8) {
            int data8 = 0;
            data8 = vectrexSampleData[index8];
            vectrexSampleData[index8] = (byte)(data8 -= 128);
        }
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(name);
            stream.write(vectrexSampleData);
        }
        catch (Throwable e) {
            this.log.addLog(e, LogPanel.WARN);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Throwable data8) {}
        }
    }

    void saveVectrex() {
        String name = GetWavFilenamePanel.showEnterValueDialog();
        name = name + ".wav";
        if (!this.pathOnly.endsWith(File.separator)) {
            this.pathOnly = this.pathOnly + File.separator;
        }
        name = this.pathOnly + name;
        byte[] vectrexSampleData = this.convertToVectrex(false);
        if (vectrexSampleData == null) {
            return;
        }
        int sampleRate = UtilityString.IntX(this.jTextFieldSampleRate.getText(), 8000);
        AudioInputStream audioStream = new AudioInputStream(new ByteArrayInputStream(vectrexSampleData), this.getVectrexAudioFormat(), vectrexSampleData.length);
        AudioFileFormat.Type targetType = SampleJPanel.findTargetType("wav");
        try {
            AudioSystem.write(audioStream, targetType, new File(name));
        }
        catch (Throwable e) {
            this.log.addLog(e, LogPanel.WARN);
        }
    }

    public void setVectrexValues(int sampleRate, int bits, int encodingtype) {
        ++this.mClassSetting;
        this.jTextFieldSampleRate.setText("" + sampleRate);
        if (bits == 8) {
            this.jComboBoxSampleBits.setSelectedIndex(0);
        } else {
            this.jComboBoxSampleBits.setSelectedIndex(1);
        }
        if (encodingtype > 0) {
            this.jComboBoxEncodingType.setSelectedIndex(1);
        } else {
            this.jComboBoxEncodingType.setSelectedIndex(0);
        }
        --this.mClassSetting;
    }

    public byte[] convertToVectrex(boolean fakeSamplerate) {
        if (this.sound == null) {
            return null;
        }
        int sampleRate = UtilityString.IntX(this.jTextFieldSampleRate.getText(), 8000);
        if (this.jComboBoxSampleBits.getSelectedIndex() != 0 && fakeSamplerate) {
            sampleRate = (int)((double)sampleRate * 0.8);
        }
        byte[] orgData16 = this.sound.getLeftData();
        AudioFormat outDataFormat = this.getVectrexAudioFormat();
        AudioFormat tinyformat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 1, 2, 44100.0f, false);
        try {
            AudioInputStream lowResAIS = SampleJPanel.convertSampleRate(sampleRate, new AudioInputStream(new ByteArrayInputStream(orgData16), tinyformat, orgData16.length / 2));
            orgData16 = this.getData(lowResAIS);
            byte[] orgData8 = this.convert16BitSignedTo8BitUnsigned(orgData16, false);
            lowResAIS = new AudioInputStream(new ByteArrayInputStream(orgData8), this.getVectrexAudioFormat(), orgData8.length);
            int bufSize = (int)outDataFormat.getSampleRate() * outDataFormat.getChannels() * outDataFormat.getFrameSize();
            byte[] buf = new byte[bufSize];
            ByteList list2 = new ByteList(bufSize);
            int numRead = 0;
            while ((numRead = lowResAIS.read(buf)) > -1) {
                for (int i = 0; i < numRead; ++i) {
                    list2.add(buf[i]);
                }
            }
            return list2.asArray();
        }
        catch (Throwable e) {
            this.log.addLog(e, LogPanel.WARN);
            return null;
        }
    }

    byte[] getData(AudioInputStream audioStream) {
        try {
            int bufSize = (int)audioStream.getFormat().getSampleRate() * audioStream.getFormat().getChannels() * audioStream.getFormat().getFrameSize();
            byte[] buf = new byte[bufSize];
            ByteList list2 = new ByteList(bufSize);
            int numRead = 0;
            while ((numRead = audioStream.read(buf)) > -1) {
                for (int i = 0; i < numRead; ++i) {
                    list2.add(buf[i]);
                }
            }
            return list2.asArray();
        }
        catch (Throwable e) {
            this.log.addLog(e, LogPanel.WARN);
            return null;
        }
    }

    private static AudioInputStream convertSampleRate(float fSampleRate, AudioInputStream sourceStream) {
        AudioFormat sourceFormat = sourceStream.getFormat();
        AudioFormat targetFormat = new AudioFormat(sourceFormat.getEncoding(), fSampleRate, sourceFormat.getSampleSizeInBits(), sourceFormat.getChannels(), sourceFormat.getFrameSize(), fSampleRate, sourceFormat.isBigEndian());
        return AudioSystem.getAudioInputStream(targetFormat, sourceStream);
    }

    private static AudioInputStream convertSampleSizeAndEndianess(int nSampleSizeInBits, boolean bBigEndian, AudioInputStream sourceStream) {
        AudioFormat sourceFormat = sourceStream.getFormat();
        AudioFormat targetFormat = new AudioFormat(sourceFormat.getEncoding(), sourceFormat.getSampleRate(), nSampleSizeInBits, sourceFormat.getChannels(), SampleJPanel.calculateFrameSize(sourceFormat.getChannels(), nSampleSizeInBits), sourceFormat.getFrameRate(), bBigEndian);
        return AudioSystem.getAudioInputStream(targetFormat, sourceStream);
    }

    private static int calculateFrameSize(int nChannels, int nSampleSizeInBits) {
        return (nSampleSizeInBits + 7) / 8 * nChannels;
    }

    private static AudioInputStream convertEncoding(AudioFormat.Encoding targetEncoding, AudioInputStream sourceStream) {
        return AudioSystem.getAudioInputStream(targetEncoding, sourceStream);
    }

    byte[] convert16BitSignedTo8BitUnsigned(byte[] orgData16, boolean bigEndian) {
        int size = orgData16.length / 2;
        if (size * 2 != orgData16.length) {
            --size;
        }
        byte[] data8All = new byte[size];
        for (int index8 = 0; index8 < size; ++index8) {
            int index16 = index8 * 2;
            int data8 = 0;
            int data16 = bigEndian ? orgData16[index16] << 8 | orgData16[index16 + 1] & 0xFF : orgData16[index16 + 1] << 8 | orgData16[index16] & 0xFF;
            data8 = data16 / 256;
            if ((data8 += 128) > 255) {
                System.out.println("Data Conversion error: " + data16 + " -> " + data8);
            }
            data8All[index8] = (byte)data8;
        }
        return data8All;
    }

    void setAudioFormat(String filename) {
        AudioFormat format = this.getAudioFormat(filename);
        if (format.getChannels() == 1) {
            this.jComboBoxChannels.setSelectedIndex(0);
        } else if (format.getChannels() == 2) {
            this.jComboBoxChannels.setSelectedIndex(1);
        } else {
            this.jComboBoxChannels.addItem("" + format.getChannels());
            this.jComboBoxChannels.setSelectedItem("" + format.getChannels());
        }
        if (format.getEncoding() == AudioFormat.Encoding.PCM_SIGNED) {
            this.jComboBoxEncoding.setSelectedIndex(0);
        } else if (format.getEncoding() == AudioFormat.Encoding.PCM_UNSIGNED) {
            this.jComboBoxEncoding.setSelectedIndex(1);
        } else {
            this.jComboBoxEncoding.addItem("" + format.getEncoding().toString());
            this.jComboBoxEncoding.setSelectedItem("" + format.getEncoding().toString());
        }
        if ((double)format.getSampleRate() == 8000.0) {
            this.jComboBoxSampleRate.setSelectedIndex(0);
        } else if ((double)format.getSampleRate() == 22050.0) {
            this.jComboBoxSampleRate.setSelectedIndex(1);
        } else if ((double)format.getSampleRate() == 44100.0) {
            this.jComboBoxSampleRate.setSelectedIndex(2);
        } else if ((double)format.getSampleRate() == 48000.0) {
            this.jComboBoxSampleRate.setSelectedIndex(3);
        } else {
            this.jComboBoxSampleRate.addItem("" + format.getSampleRate() + " Hz");
            this.jComboBoxSampleRate.setSelectedItem("" + format.getSampleRate() + " Hz");
        }
        if ((double)format.getSampleRate() == 8000.0) {
            this.jTextFieldFrameRate.setText("8000");
        } else if ((double)format.getSampleRate() == 22050.0) {
            this.jTextFieldFrameRate.setText("22050");
        } else if ((double)format.getSampleRate() == 44100.0) {
            this.jTextFieldFrameRate.setText("44100");
        } else if ((double)format.getSampleRate() == 48000.0) {
            this.jTextFieldFrameRate.setText("48000");
        } else {
            this.jTextFieldFrameRate.setText("" + format.getSampleRate());
        }
        if (format.getSampleSizeInBits() == 8) {
            this.jComboBoxBit.setSelectedIndex(0);
        } else if (format.getSampleSizeInBits() == 16) {
            this.jComboBoxBit.setSelectedIndex(1);
        } else if (format.getSampleSizeInBits() == 24) {
            this.jComboBoxBit.setSelectedIndex(2);
        } else if (format.getSampleSizeInBits() == 32) {
            this.jComboBoxBit.setSelectedIndex(3);
        } else {
            this.jComboBoxBit.addItem("" + format.getSampleSizeInBits() + " bit");
            this.jComboBoxBit.setSelectedItem("" + format.getSampleSizeInBits() + " bit");
        }
        if (format.isBigEndian()) {
            this.jComboBoxEndian.setSelectedIndex(1);
        } else {
            this.jComboBoxEndian.setSelectedIndex(0);
        }
        int framesize = format.getSampleSizeInBits() / 8 * format.getChannels();
        this.jTextFieldFrameSize.setText("" + framesize);
    }

    AudioFormat getAudioFormat(String filename) {
        try {
            File file = new File(filename);
            AudioFileFormat aff = AudioSystem.getAudioFileFormat(file);
            return aff.getFormat();
        }
        catch (Throwable e) {
            this.log.addLog(e, LogPanel.WARN);
            return null;
        }
    }

    void normalize() {
        byte[] orgData16 = this.sound.getLeftData();
        double max = 0.0;
        int size = orgData16.length / 2;
        int andBits = 65535;
        if (this.jComboBoxNormalize.getSelectedIndex() != 0) {
            if (this.jComboBoxNormalize.getSelectedIndex() == 1) {
                andBits = 16383;
            } else if (this.jComboBoxNormalize.getSelectedIndex() == 2) {
                andBits = 8191;
            } else if (this.jComboBoxNormalize.getSelectedIndex() == 3) {
                andBits = 4095;
            } else if (this.jComboBoxNormalize.getSelectedIndex() == 4) {
                andBits = 2047;
            }
        }
        for (int index = 0; index < size; ++index) {
            int index16 = index * 2;
            int data16 = orgData16[index16 + 1] << 8 | orgData16[index16] & 0xFF;
            if (!(max < (double)(Math.abs(data16) & andBits))) continue;
            max = Math.abs(data16) & andBits;
        }
        double scale = 32767.0 / max;
        for (int index = 0; index < size; ++index) {
            int index16 = index * 2;
            int data16 = orgData16[index16 + 1] << 8 | orgData16[index16] & 0xFF;
            boolean neg = data16 < 0;
            int newData = Math.abs(data16);
            if (newData > andBits) {
                newData = andBits;
            }
            newData = (int)((double)(newData & andBits) * scale);
            orgData16[index16] = (byte)((newData *= neg ? -1 : 1) & 0xFF);
            orgData16[index16 + 1] = (byte)(newData >> 8 & 0xFF);
        }
        this.sound.setLeftData(orgData16);
        this.sound.setRightData(orgData16);
        this.paintSamples();
    }

    @Override
    public void deIconified() {
    }

    public static class BufferingRecorder
    extends AbstractRecorder {
        public BufferingRecorder(TargetDataLine line, AudioFileFormat.Type targetType, File file) {
            super(line, targetType, file);
        }

        @Override
        public void run() {
            ByteArrayOutputStream byteArrayOutputStream;
            ByteArrayOutputStream outputStream = byteArrayOutputStream = new ByteArrayOutputStream();
            AudioFormat format = this.m_line.getFormat();
            int size = 1024;
            size = (int)format.getFrameRate() * format.getFrameSize();
            byte[] abBuffer = new byte[size];
            int nFrameSize = format.getFrameSize();
            int nBufferFrames = abBuffer.length / nFrameSize;
            this.m_bRecording = true;
            this.frames = 0L;
            while (this.m_bRecording) {
                int nBytesRead;
                int available = this.m_line.available();
                if (available <= 0) continue;
                if (available > abBuffer.length) {
                    available = abBuffer.length;
                }
                int nBytesToWrite = nBytesRead = this.m_line.read(abBuffer, 0, available);
                this.frames += (long)(nBytesRead / nFrameSize);
                try {
                    ((OutputStream)outputStream).write(abBuffer, 0, nBytesToWrite);
                }
                catch (IOException e) {
                    this.log.addLog(e, LogPanel.WARN);
                }
            }
            this.log.addLog("" + this.frames + " frames were sampled.", LogPanel.INFO);
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException e) {
                this.log.addLog(e, LogPanel.WARN);
            }
            byte[] abData = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(abData);
            AudioInputStream audioInputStream = new AudioInputStream(byteArrayInputStream, format, abData.length / format.getFrameSize());
            try {
                AudioSystem.write(audioInputStream, this.m_targetType, this.m_file);
            }
            catch (IOException e) {
                this.log.addLog(e, LogPanel.WARN);
            }
        }
    }

    public static class DirectRecorder
    extends AbstractRecorder {
        private AudioInputStream m_audioInputStream;

        public DirectRecorder(TargetDataLine line, AudioFileFormat.Type targetType, File file) {
            super(line, targetType, file);
            this.m_audioInputStream = new AudioInputStream(line);
        }

        @Override
        public void run() {
            try {
                AudioSystem.write(this.m_audioInputStream, this.m_targetType, this.m_file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static class AbstractRecorder
    extends Thread
    implements Recorder {
        LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
        protected TargetDataLine m_line;
        protected AudioFileFormat.Type m_targetType;
        protected File m_file;
        protected boolean m_bRecording;
        long frames = 0L;

        public AbstractRecorder(TargetDataLine line, AudioFileFormat.Type targetType, File file) {
            this.m_line = line;
            this.m_targetType = targetType;
            this.m_file = file;
        }

        @Override
        public void start() {
            if (!this.m_line.isOpen()) {
                try {
                    this.m_line.open();
                }
                catch (Throwable e) {
                    this.log.addLog(e, LogPanel.WARN);
                    return;
                }
            }
            this.m_line.start();
            super.start();
        }

        @Override
        public void stopRecording() {
            this.m_line.stop();
            this.m_line.drain();
            this.m_line.close();
            this.m_bRecording = false;
        }

        @Override
        public long getFrames() {
            return this.frames;
        }
    }

    public static interface Recorder {
        public void start();

        public void stopRecording();

        public long getFrames();
    }

    class MyMixer {
        Mixer.Info info;
        Mixer mixer;

        public MyMixer(Mixer.Info i, Mixer m) {
            this.info = i;
            this.mixer = m;
        }

        public String toString() {
            return this.info.getName();
        }
    }
}

