/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi.sound.ibxm;

import de.malban.vide.vedi.sound.ibxm.IBXM;
import de.malban.vide.vedi.sound.ibxm.Instrument;
import de.malban.vide.vedi.sound.ibxm.Module;
import de.malban.vide.vedi.sound.ibxm.WavInputStream;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Line;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;

public class IBXMPlayer
extends JFrame {
    private static final int SAMPLE_RATE = 48000;
    private JLabel songLabel;
    private JLabel timeLabel;
    private JSlider seekSlider;
    private JButton playButton;
    private JList instrumentList;
    private Timer updateTimer;
    private JFileChooser loadFileChooser;
    private JFileChooser saveFileChooser;
    private JCheckBox fadeOutCheckBox;
    private JTextField fadeOutTextField;
    private Module module;
    private IBXM ibxm;
    private volatile boolean playing;
    private int interpolation;
    private int sliderPos;
    private int samplePos;
    private int duration;
    private Thread playThread;

    public IBXMPlayer() {
        super("IBXM a61 (c)2011 mumart@gmail.com");
        URL icon = IBXMPlayer.class.getResource("ibxm.png");
        this.setIconImage(Toolkit.getDefaultToolkit().createImage(icon));
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BorderLayout(5, 5));
        this.songLabel = new JLabel("No song loaded.", 0);
        controlPanel.add((Component)this.songLabel, "North");
        this.timeLabel = new JLabel("0:00");
        controlPanel.add((Component)this.timeLabel, "West");
        this.playButton = new JButton("Play");
        this.playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (IBXMPlayer.this.playing) {
                    IBXMPlayer.this.stop();
                } else {
                    IBXMPlayer.this.play();
                }
            }
        });
        controlPanel.add((Component)this.playButton, "East");
        this.seekSlider = new JSlider(0, 0, 0, 0);
        controlPanel.add((Component)this.seekSlider, "Center");
        this.instrumentList = new JList();
        this.instrumentList.setFont(new Font("Monospaced", 1, 12));
        this.instrumentList.setOpaque(false);
        JScrollPane instrumentPane = new JScrollPane(this.instrumentList);
        instrumentPane.setBorder(BorderFactory.createTitledBorder("Instruments"));
        DropTarget dropTarget = new DropTarget(this, new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent dropTargetDropEvent) {
                try {
                    dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                    Transferable transferable = dropTargetDropEvent.getTransferable();
                    DataFlavor dataFlavor = DataFlavor.javaFileListFlavor;
                    List fileList = (List)transferable.getTransferData(dataFlavor);
                    File file = (File)fileList.get(0);
                    try {
                        IBXMPlayer.this.loadModule(file);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(IBXMPlayer.this, e.getMessage(), "Error", 0);
                    }
                    dropTargetDropEvent.dropComplete(true);
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            }
        });
        this.updateTimer = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!IBXMPlayer.this.seekSlider.getValueIsAdjusting()) {
                    if (IBXMPlayer.this.seekSlider.getValue() != IBXMPlayer.this.sliderPos) {
                        IBXMPlayer.this.seek(IBXMPlayer.this.seekSlider.getValue());
                    }
                    IBXMPlayer.this.sliderPos = IBXMPlayer.this.samplePos;
                    if (IBXMPlayer.this.sliderPos > IBXMPlayer.this.duration) {
                        IBXMPlayer.this.sliderPos = IBXMPlayer.this.duration;
                    }
                    IBXMPlayer.this.seekSlider.setValue(IBXMPlayer.this.sliderPos);
                }
                int secs = IBXMPlayer.this.sliderPos / 48000;
                int mins = secs / 60;
                IBXMPlayer.this.timeLabel.setText(mins + ((secs %= 60) < 10 ? ":0" : ":") + secs);
            }
        });
        this.loadFileChooser = new JFileChooser();
        this.loadFileChooser.setFileFilter(new FileNameExtensionFilter("Module files", "mod", "ft", "s3m", "xm"));
        this.saveFileChooser = new JFileChooser();
        this.saveFileChooser.setFileFilter(new FileNameExtensionFilter("Wave files", "wav"));
        JPanel saveAccessory = new JPanel();
        this.fadeOutTextField = new JTextField("0", 4);
        this.fadeOutTextField.setEnabled(false);
        this.fadeOutTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            }
        });
        this.fadeOutTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                try {
                    Integer.parseInt(IBXMPlayer.this.fadeOutTextField.getText());
                }
                catch (Exception exception) {
                    IBXMPlayer.this.fadeOutTextField.setText(String.valueOf(IBXMPlayer.this.duration / 48000));
                }
            }
        });
        this.fadeOutCheckBox = new JCheckBox("Fade out after");
        this.fadeOutCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IBXMPlayer.this.fadeOutTextField.setText(String.valueOf(IBXMPlayer.this.duration / 48000));
                IBXMPlayer.this.fadeOutTextField.setEnabled(IBXMPlayer.this.fadeOutCheckBox.isSelected());
            }
        });
        saveAccessory.add(this.fadeOutCheckBox);
        saveAccessory.add(this.fadeOutTextField);
        saveAccessory.add(new JLabel("seconds."));
        this.saveFileChooser.setAccessory(saveAccessory);
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenuItem loadMenuItem = new JMenuItem("Load module.");
        loadMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int result = IBXMPlayer.this.loadFileChooser.showOpenDialog(IBXMPlayer.this);
                if (result == 0) {
                    try {
                        IBXMPlayer.this.loadModule(IBXMPlayer.this.loadFileChooser.getSelectedFile());
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(IBXMPlayer.this, e.getMessage(), "Error", 0);
                    }
                }
            }
        });
        fileMenu.add(loadMenuItem);
        JMenuItem saveWavMenuItem = new JMenuItem("Save module as wave file.");
        saveWavMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (IBXMPlayer.this.module != null) {
                    IBXMPlayer.this.fadeOutCheckBox.setSelected(false);
                    IBXMPlayer.this.fadeOutTextField.setText(String.valueOf(IBXMPlayer.this.duration / 48000));
                    IBXMPlayer.this.saveFileChooser.setSelectedFile(new File(((IBXMPlayer)IBXMPlayer.this).module.songName.trim() + ".wav"));
                    int result = IBXMPlayer.this.saveFileChooser.showSaveDialog(IBXMPlayer.this);
                    if (result == 0) {
                        try {
                            boolean fade = IBXMPlayer.this.fadeOutCheckBox.isSelected();
                            int time = IBXMPlayer.this.duration;
                            if (fade) {
                                try {
                                    time = (Integer.parseInt(IBXMPlayer.this.fadeOutTextField.getText()) + 8) * 48000;
                                }
                                catch (Exception e) {
                                    fade = false;
                                }
                            }
                            IBXMPlayer.this.saveWav(IBXMPlayer.this.saveFileChooser.getSelectedFile(), time, fade);
                            JOptionPane.showMessageDialog(IBXMPlayer.this, "Module saved successfully.", "Success", 1);
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(IBXMPlayer.this, e.getMessage(), "Error", 0);
                        }
                    }
                }
            }
        });
        fileMenu.add(saveWavMenuItem);
        fileMenu.addSeparator();
        JMenuItem exitMenuItem = new JMenuItem("Exit");
        exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IBXMPlayer.this.stop();
                IBXMPlayer.this.dispose();
            }
        });
        fileMenu.add(exitMenuItem);
        menuBar.add(fileMenu);
        JMenu optionsMenu = new JMenu("Options");
        ButtonGroup interpolationGroup = new ButtonGroup();
        JRadioButtonMenuItem noneMenuItem = new JRadioButtonMenuItem("No interpolation");
        noneMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IBXMPlayer.this.setInterpolation(0);
            }
        });
        interpolationGroup.add(noneMenuItem);
        optionsMenu.add(noneMenuItem);
        JRadioButtonMenuItem lineMenuItem = new JRadioButtonMenuItem("Linear interpolation");
        lineMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IBXMPlayer.this.setInterpolation(1);
            }
        });
        interpolationGroup.add(lineMenuItem);
        interpolationGroup.setSelected(lineMenuItem.getModel(), true);
        this.setInterpolation(1);
        optionsMenu.add(lineMenuItem);
        JRadioButtonMenuItem sincMenuItem = new JRadioButtonMenuItem("Sinc interpolation");
        sincMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IBXMPlayer.this.setInterpolation(2);
            }
        });
        interpolationGroup.add(sincMenuItem);
        optionsMenu.add(sincMenuItem);
        menuBar.add(optionsMenu);
        this.setJMenuBar(menuBar);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPanel.setLayout(new BorderLayout(10, 10));
        mainPanel.add((Component)controlPanel, "North");
        mainPanel.add((Component)instrumentPane, "Center");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(mainPanel);
        this.pack();
    }

    private synchronized void loadModule(File modFile) throws IOException {
        int len;
        byte[] moduleData = new byte[(int)modFile.length()];
        FileInputStream inputStream = new FileInputStream(modFile);
        for (int offset = 0; offset < moduleData.length; offset += len) {
            len = inputStream.read(moduleData, offset, moduleData.length - offset);
            if (len >= 0) continue;
            throw new IOException("Unexpected end of file.");
        }
        inputStream.close();
        this.module = new Module(moduleData);
        this.ibxm = new IBXM(this.module, 48000);
        this.ibxm.setInterpolation(this.interpolation);
        this.duration = this.ibxm.calculateSongDuration();
        this.sliderPos = 0;
        this.samplePos = 0;
        this.seekSlider.setMinimum(0);
        this.seekSlider.setMaximum(this.duration);
        this.seekSlider.setValue(0);
        this.songLabel.setText(this.module.songName.trim());
        Vector<String> vector = new Vector<String>();
        Instrument[] instruments = this.module.instruments;
        int len2 = instruments.length;
        for (int idx = 0; idx < len2; ++idx) {
            String name = instruments[idx].name;
            if (name.trim().length() <= 0) continue;
            vector.add(String.format("%03d: %s", idx, name));
        }
        this.instrumentList.setListData(vector);
    }

    private synchronized void play() {
        if (this.ibxm != null) {
            this.playing = true;
            this.playThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int[] mixBuf = new int[IBXMPlayer.this.ibxm.getMixBufferLength()];
                    byte[] outBuf = new byte[mixBuf.length * 4];
                    AudioFormat audioFormat = null;
                    Line audioLine = null;
                    try {
                        audioFormat = new AudioFormat(48000.0f, 16, 2, true, true);
                        audioLine = AudioSystem.getSourceDataLine(audioFormat);
                        audioLine.open();
                        audioLine.start();
                        while (IBXMPlayer.this.playing) {
                            int count = IBXMPlayer.this.getAudio(mixBuf);
                            int outIdx = 0;
                            int mixEnd = count * 2;
                            for (int mixIdx = 0; mixIdx < mixEnd; ++mixIdx) {
                                int ampl = mixBuf[mixIdx];
                                if (ampl > Short.MAX_VALUE) {
                                    ampl = Short.MAX_VALUE;
                                }
                                if (ampl < Short.MIN_VALUE) {
                                    ampl = Short.MIN_VALUE;
                                }
                                outBuf[outIdx++] = (byte)(ampl >> 8);
                                outBuf[outIdx++] = (byte)ampl;
                            }
                            audioLine.write(outBuf, 0, outIdx);
                        }
                        audioLine.drain();
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(IBXMPlayer.this, e.getMessage(), "Error", 0);
                    }
                    finally {
                        if (audioLine != null && audioLine.isOpen()) {
                            audioLine.close();
                        }
                    }
                }
            });
            this.playThread.start();
            this.updateTimer.start();
            this.playButton.setText("Stop");
        }
    }

    private synchronized void stop() {
        this.playing = false;
        try {
            if (this.playThread != null) {
                this.playThread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.updateTimer.stop();
        this.playButton.setText("Play");
    }

    private synchronized void seek(int pos) {
        this.samplePos = this.ibxm.seek(pos);
    }

    private synchronized void setInterpolation(int interpolation) {
        this.interpolation = interpolation;
        if (this.ibxm != null) {
            this.ibxm.setInterpolation(interpolation);
        }
    }

    private synchronized int getAudio(int[] mixBuf) {
        int count = this.ibxm.getAudio(mixBuf);
        this.samplePos += count;
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void saveWav(File wavFile, int time, boolean fade) throws IOException {
        this.stop();
        this.seek(0);
        WavInputStream wavInputStream = new WavInputStream(this.ibxm, time, fade);
        FileOutputStream fileOutputStream = null;
        try {
            int count;
            fileOutputStream = new FileOutputStream(wavFile);
            byte[] buf = new byte[this.ibxm.getMixBufferLength() * 4];
            for (int remain = wavInputStream.getBytesRemaining(); remain > 0; remain -= count) {
                count = remain > buf.length ? buf.length : remain;
                count = wavInputStream.read(buf, 0, count);
                fileOutputStream.write(buf, 0, count);
            }
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            this.seek(0);
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception e) {
                    System.out.println(e);
                }
                IBXMPlayer ibxmPlayer = new IBXMPlayer();
                ibxmPlayer.setDefaultCloseOperation(3);
                ibxmPlayer.setLocationByPlatform(true);
                ibxmPlayer.setVisible(true);
            }
        });
    }
}

