/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi.sound.ibxm;

import de.malban.config.Configuration;
import de.malban.gui.panels.LogPanel;
import de.malban.sound.tinysound.Stream;
import de.malban.sound.tinysound.TinySound;
import de.malban.vide.vedi.sound.ibxm.IBXM;
import de.malban.vide.vedi.sound.ibxm.Instrument;
import de.malban.vide.vedi.sound.ibxm.Module;
import de.malban.vide.vedi.sound.ibxm.Sample;
import de.malban.vide.vedi.sound.ibxm.WavInputStream;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Line;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.Timer;

public class IBXMPlayerJPanel
extends JPanel {
    LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    private static final int SAMPLE_RATE = 44100;
    private Module module;
    private IBXM ibxm;
    private volatile boolean playing;
    private int interpolation;
    private int sliderPos;
    private int samplePos;
    private int duration;
    private Thread playThread;
    private Timer updateTimer;
    private ButtonGroup buttonGroup1;
    private JList instrumentList;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JRadioButton jRadioButton3;
    private JScrollPane jScrollPane1;
    private JButton playButton;
    private JSlider seekSlider;
    private JLabel songLabel;
    private JLabel timeLabel;
    Vector<String> instr;

    public IBXMPlayerJPanel() {
        this.initComponents();
        this.jPanel1.setVisible(false);
        this.updateTimer = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!IBXMPlayerJPanel.this.seekSlider.getValueIsAdjusting()) {
                    if (IBXMPlayerJPanel.this.seekSlider.getValue() != IBXMPlayerJPanel.this.sliderPos) {
                        IBXMPlayerJPanel.this.seek(IBXMPlayerJPanel.this.seekSlider.getValue());
                    }
                    IBXMPlayerJPanel.this.sliderPos = IBXMPlayerJPanel.this.samplePos;
                    if (IBXMPlayerJPanel.this.sliderPos > IBXMPlayerJPanel.this.duration) {
                        IBXMPlayerJPanel.this.sliderPos = IBXMPlayerJPanel.this.duration;
                    }
                    IBXMPlayerJPanel.this.seekSlider.setValue(IBXMPlayerJPanel.this.sliderPos);
                }
                int secs = IBXMPlayerJPanel.this.sliderPos / 44100;
                int mins = secs / 60;
                IBXMPlayerJPanel.this.timeLabel.setText(mins + ((secs %= 60) < 10 ? ":0" : ":") + secs);
            }
        });
    }

    public boolean setModfile(String filename) {
        try {
            this.loadModule(new File(filename));
        }
        catch (Throwable e) {
            this.log.addLog("Modfile: \"" + filename + "\" not loaded");
            return false;
        }
        return true;
    }

    public void setVoicePlay(boolean[] voicePlay) {
        boolean wasPlaying = this.playing;
        if (this.playing) {
            this.stop();
        }
        if (this.ibxm == null) {
            return;
        }
        this.ibxm.setVoicePlay(voicePlay);
        if (wasPlaying) {
            this.play();
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.instrumentList = new JList();
        this.seekSlider = new JSlider();
        this.playButton = new JButton();
        this.songLabel = new JLabel();
        this.timeLabel = new JLabel();
        this.jPanel2 = new JPanel();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jRadioButton3 = new JRadioButton();
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Instruments"));
        this.instrumentList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.instrumentList);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 201, Short.MAX_VALUE));
        this.playButton.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/control_play_blue.png")));
        this.playButton.setToolTipText("Play current sample!");
        this.playButton.setMargin(new Insets(0, 1, 0, -1));
        this.playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBXMPlayerJPanel.this.playButtonActionPerformed(evt);
            }
        });
        this.songLabel.setText("No song loaded");
        this.timeLabel.setText("00:00");
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("interpolation"));
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setText("none");
        this.jRadioButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBXMPlayerJPanel.this.jRadioButton1ActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButton2);
        this.jRadioButton2.setSelected(true);
        this.jRadioButton2.setText("linear");
        this.jRadioButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBXMPlayerJPanel.this.jRadioButton2ActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButton3);
        this.jRadioButton3.setText("sinc");
        this.jRadioButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBXMPlayerJPanel.this.jRadioButton3ActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButton1).addComponent(this.jRadioButton2).addComponent(this.jRadioButton3)).addContainerGap(33, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jRadioButton1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButton2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButton3).addGap(0, 9, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.timeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.seekSlider, -1, 216, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.playButton)).addGroup(layout.createSequentialGroup().addComponent(this.songLabel).addGap(0, 0, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel2, -2, -1, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(30, 30, 30).addComponent(this.songLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.seekSlider, -1, -1, -2).addComponent(this.playButton, -1, -1, Short.MAX_VALUE).addComponent(this.timeLabel, -1, -1, Short.MAX_VALUE))).addComponent(this.jPanel2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)));
    }

    private void playButtonActionPerformed(ActionEvent evt) {
        if (this.playing) {
            this.stop();
        } else {
            this.play();
        }
    }

    private void jRadioButton1ActionPerformed(ActionEvent evt) {
        this.setInterpolation(0);
    }

    private void jRadioButton2ActionPerformed(ActionEvent evt) {
        this.setInterpolation(1);
    }

    private void jRadioButton3ActionPerformed(ActionEvent evt) {
        this.setInterpolation(2);
    }

    private synchronized void loadModule(File modFile) throws IOException {
        int len;
        byte[] moduleData = new byte[(int)modFile.length()];
        FileInputStream inputStream = new FileInputStream(modFile);
        for (int offset = 0; offset < moduleData.length; offset += len) {
            len = inputStream.read(moduleData, offset, moduleData.length - offset);
            if (len >= 0) continue;
            throw new IOException("Unexpected end of file.");
        }
        inputStream.close();
        this.module = new Module(moduleData);
        this.ibxm = new IBXM(this.module, 44100);
        this.ibxm.setInterpolation(this.interpolation);
        this.duration = this.ibxm.calculateSongDuration();
        this.sliderPos = 0;
        this.samplePos = 0;
        this.seekSlider.setMinimum(0);
        this.seekSlider.setMaximum(this.duration);
        this.seekSlider.setValue(0);
        this.songLabel.setText(this.module.songName.trim());
        Vector<String> vector = new Vector<String>();
        Instrument[] instruments = this.module.instruments;
        int len2 = instruments.length;
        for (int idx = 0; idx < len2; ++idx) {
            String name = instruments[idx].name;
            if (name.trim().length() <= 0) continue;
            vector.add(String.format("%03d: %s", idx, name));
        }
        this.instrumentList.setListData(vector);
        this.instr = vector;
    }

    public Vector<String> getInstruments() {
        return this.instr;
    }

    public Sample getInstrumentSample(int instrumentNo) {
        if (this.ibxm.module.instruments.length < instrumentNo) {
            return null;
        }
        if (this.ibxm.module.instruments[instrumentNo].samples.length <= 0) {
            return null;
        }
        return this.ibxm.module.instruments[instrumentNo].samples[0];
    }

    private synchronized void playOrg() {
        if (this.ibxm != null) {
            this.playing = true;
            this.playThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int[] mixBuf = new int[IBXMPlayerJPanel.this.ibxm.getMixBufferLength()];
                    byte[] outBuf = new byte[mixBuf.length * 4];
                    AudioFormat audioFormat = null;
                    Line audioLine = null;
                    try {
                        audioFormat = new AudioFormat(44100.0f, 16, 2, true, true);
                        audioLine = AudioSystem.getSourceDataLine(audioFormat);
                        audioLine.open();
                        audioLine.start();
                        while (IBXMPlayerJPanel.this.playing) {
                            int count = IBXMPlayerJPanel.this.getAudio(mixBuf);
                            int outIdx = 0;
                            int mixEnd = count * 2;
                            for (int mixIdx = 0; mixIdx < mixEnd; ++mixIdx) {
                                int ampl = mixBuf[mixIdx];
                                if (ampl > Short.MAX_VALUE) {
                                    ampl = Short.MAX_VALUE;
                                }
                                if (ampl < Short.MIN_VALUE) {
                                    ampl = Short.MIN_VALUE;
                                }
                                outBuf[outIdx++] = (byte)(ampl >> 8);
                                outBuf[outIdx++] = (byte)ampl;
                            }
                            audioLine.write(outBuf, 0, outIdx);
                        }
                        audioLine.drain();
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(Configuration.getConfiguration().getMainFrame(), e.getMessage(), "Error", 0);
                    }
                    finally {
                        if (audioLine != null && audioLine.isOpen()) {
                            audioLine.close();
                        }
                    }
                }
            });
            this.playThread.start();
            this.updateTimer.start();
            this.playButton.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/control_stop_blue.png")));
        }
    }

    private synchronized void play() {
        if (this.ibxm != null) {
            this.playing = true;
            this.playThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    block7: {
                        int[] mixBuf = new int[IBXMPlayerJPanel.this.ibxm.getMixBufferLength()];
                        byte[] outBuf = new byte[mixBuf.length * 4];
                        Stream audioLine = null;
                        try {
                            audioLine = TinySound.getOutStreamMod();
                            audioLine.start();
                            while (IBXMPlayerJPanel.this.playing) {
                                int count = IBXMPlayerJPanel.this.getAudio(mixBuf);
                                int outIdx = 0;
                                int mixEnd = count * 2;
                                for (int mixIdx = 0; mixIdx < mixEnd; ++mixIdx) {
                                    int ampl = mixBuf[mixIdx];
                                    if (ampl > Short.MAX_VALUE) {
                                        ampl = Short.MAX_VALUE;
                                    }
                                    if (ampl < Short.MIN_VALUE) {
                                        ampl = Short.MIN_VALUE;
                                    }
                                    outBuf[outIdx++] = (byte)(ampl >> 8);
                                    outBuf[outIdx++] = (byte)ampl;
                                }
                                while (audioLine.available() < outIdx) {
                                    Thread.sleep(5L);
                                }
                                audioLine.write(outBuf, 0, outIdx);
                            }
                            audioLine.stop();
                            audioLine.unload();
                            audioLine = null;
                        }
                        catch (Exception e) {
                            IBXMPlayerJPanel.this.log.addLog(e, LogPanel.WARN);
                            if (audioLine == null) break block7;
                            audioLine.stop();
                            audioLine.unload();
                        }
                    }
                }
            }, "IBXM Modplayer");
            this.playThread.start();
            this.updateTimer.start();
            this.playButton.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/control_stop_blue.png")));
        }
    }

    public synchronized void stop() {
        this.playing = false;
        try {
            if (this.playThread != null) {
                this.playThread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.updateTimer.stop();
        this.playButton.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/control_play_blue.png")));
    }

    private synchronized void seek(int pos) {
        this.samplePos = this.ibxm.seek(pos);
    }

    private synchronized void setInterpolation(int interpolation) {
        this.interpolation = interpolation;
        if (this.ibxm != null) {
            this.ibxm.setInterpolation(interpolation);
        }
    }

    private synchronized int getAudio(int[] mixBuf) {
        int count = this.ibxm.getAudio(mixBuf);
        this.samplePos += count;
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void saveWav(File wavFile, int time, boolean fade) throws IOException {
        this.stop();
        this.seek(0);
        WavInputStream wavInputStream = new WavInputStream(this.ibxm, time, fade);
        FileOutputStream fileOutputStream = null;
        try {
            int count;
            fileOutputStream = new FileOutputStream(wavFile);
            byte[] buf = new byte[this.ibxm.getMixBufferLength() * 4];
            for (int remain = wavInputStream.getBytesRemaining(); remain > 0; remain -= count) {
                count = remain > buf.length ? buf.length : remain;
                count = wavInputStream.read(buf, 0, count);
                fileOutputStream.write(buf, 0, count);
            }
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            this.seek(0);
        }
    }
}

